# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTrunkedNetworkResult',
    'AwaitableGetTrunkedNetworkResult',
    'get_trunked_network',
    'get_trunked_network_output',
]

@pulumi.output_type
class GetTrunkedNetworkResult:
    def __init__(__self__, cluster_id=None, detailed_status=None, detailed_status_message=None, extended_location=None, hybrid_aks_clusters_associated_ids=None, hybrid_aks_plugin_type=None, id=None, interface_name=None, isolation_domain_ids=None, location=None, name=None, provisioning_state=None, system_data=None, tags=None, type=None, virtual_machines_associated_ids=None, vlans=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if detailed_status and not isinstance(detailed_status, str):
            raise TypeError("Expected argument 'detailed_status' to be a str")
        pulumi.set(__self__, "detailed_status", detailed_status)
        if detailed_status_message and not isinstance(detailed_status_message, str):
            raise TypeError("Expected argument 'detailed_status_message' to be a str")
        pulumi.set(__self__, "detailed_status_message", detailed_status_message)
        if extended_location and not isinstance(extended_location, dict):
            raise TypeError("Expected argument 'extended_location' to be a dict")
        pulumi.set(__self__, "extended_location", extended_location)
        if hybrid_aks_clusters_associated_ids and not isinstance(hybrid_aks_clusters_associated_ids, list):
            raise TypeError("Expected argument 'hybrid_aks_clusters_associated_ids' to be a list")
        pulumi.set(__self__, "hybrid_aks_clusters_associated_ids", hybrid_aks_clusters_associated_ids)
        if hybrid_aks_plugin_type and not isinstance(hybrid_aks_plugin_type, str):
            raise TypeError("Expected argument 'hybrid_aks_plugin_type' to be a str")
        pulumi.set(__self__, "hybrid_aks_plugin_type", hybrid_aks_plugin_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interface_name and not isinstance(interface_name, str):
            raise TypeError("Expected argument 'interface_name' to be a str")
        pulumi.set(__self__, "interface_name", interface_name)
        if isolation_domain_ids and not isinstance(isolation_domain_ids, list):
            raise TypeError("Expected argument 'isolation_domain_ids' to be a list")
        pulumi.set(__self__, "isolation_domain_ids", isolation_domain_ids)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if virtual_machines_associated_ids and not isinstance(virtual_machines_associated_ids, list):
            raise TypeError("Expected argument 'virtual_machines_associated_ids' to be a list")
        pulumi.set(__self__, "virtual_machines_associated_ids", virtual_machines_associated_ids)
        if vlans and not isinstance(vlans, list):
            raise TypeError("Expected argument 'vlans' to be a list")
        pulumi.set(__self__, "vlans", vlans)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The resource ID of the Network Cloud cluster this trunked network is associated with.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="detailedStatus")
    def detailed_status(self) -> str:
        """
        The more detailed status of the trunked network.
        """
        return pulumi.get(self, "detailed_status")

    @property
    @pulumi.getter(name="detailedStatusMessage")
    def detailed_status_message(self) -> str:
        """
        The descriptive message about the current detailed status.
        """
        return pulumi.get(self, "detailed_status_message")

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> 'outputs.ExtendedLocationResponse':
        """
        The extended location of the cluster associated with the resource.
        """
        return pulumi.get(self, "extended_location")

    @property
    @pulumi.getter(name="hybridAksClustersAssociatedIds")
    def hybrid_aks_clusters_associated_ids(self) -> Sequence[str]:
        """
        The list of Hybrid AKS cluster resource IDs that are associated with this trunked network.
        """
        return pulumi.get(self, "hybrid_aks_clusters_associated_ids")

    @property
    @pulumi.getter(name="hybridAksPluginType")
    def hybrid_aks_plugin_type(self) -> Optional[str]:
        """
        The network plugin type for Hybrid AKS.
        """
        return pulumi.get(self, "hybrid_aks_plugin_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[str]:
        """
        The default interface name for this trunked network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter(name="isolationDomainIds")
    def isolation_domain_ids(self) -> Sequence[str]:
        """
        The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
        """
        return pulumi.get(self, "isolation_domain_ids")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the trunked network.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualMachinesAssociatedIds")
    def virtual_machines_associated_ids(self) -> Sequence[str]:
        """
        The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are currently using this trunked network.
        """
        return pulumi.get(self, "virtual_machines_associated_ids")

    @property
    @pulumi.getter
    def vlans(self) -> Sequence[float]:
        """
        The list of vlans that are selected from the isolation domains for trunking.
        """
        return pulumi.get(self, "vlans")


class AwaitableGetTrunkedNetworkResult(GetTrunkedNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrunkedNetworkResult(
            cluster_id=self.cluster_id,
            detailed_status=self.detailed_status,
            detailed_status_message=self.detailed_status_message,
            extended_location=self.extended_location,
            hybrid_aks_clusters_associated_ids=self.hybrid_aks_clusters_associated_ids,
            hybrid_aks_plugin_type=self.hybrid_aks_plugin_type,
            id=self.id,
            interface_name=self.interface_name,
            isolation_domain_ids=self.isolation_domain_ids,
            location=self.location,
            name=self.name,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type,
            virtual_machines_associated_ids=self.virtual_machines_associated_ids,
            vlans=self.vlans)


def get_trunked_network(resource_group_name: Optional[str] = None,
                        trunked_network_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrunkedNetworkResult:
    """
    API Version: 2022-12-12-preview.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str trunked_network_name: The name of the trunked network.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['trunkedNetworkName'] = trunked_network_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:networkcloud:getTrunkedNetwork', __args__, opts=opts, typ=GetTrunkedNetworkResult).value

    return AwaitableGetTrunkedNetworkResult(
        cluster_id=__ret__.cluster_id,
        detailed_status=__ret__.detailed_status,
        detailed_status_message=__ret__.detailed_status_message,
        extended_location=__ret__.extended_location,
        hybrid_aks_clusters_associated_ids=__ret__.hybrid_aks_clusters_associated_ids,
        hybrid_aks_plugin_type=__ret__.hybrid_aks_plugin_type,
        id=__ret__.id,
        interface_name=__ret__.interface_name,
        isolation_domain_ids=__ret__.isolation_domain_ids,
        location=__ret__.location,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type,
        virtual_machines_associated_ids=__ret__.virtual_machines_associated_ids,
        vlans=__ret__.vlans)


@_utilities.lift_output_func(get_trunked_network)
def get_trunked_network_output(resource_group_name: Optional[pulumi.Input[str]] = None,
                               trunked_network_name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTrunkedNetworkResult]:
    """
    API Version: 2022-12-12-preview.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str trunked_network_name: The name of the trunked network.
    """
    ...
