# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AacAudioResponse',
    'AbsoluteClipTimeResponse',
    'AudioAnalyzerPresetResponse',
    'AudioOverlayResponse',
    'AudioResponse',
    'AudioTrackDescriptorResponse',
    'BuiltInStandardEncoderPresetResponse',
    'CmafFormatResponse',
    'CopyAudioResponse',
    'CopyVideoResponse',
    'DDAudioResponse',
    'DeinterlaceResponse',
    'FaceDetectorPresetResponse',
    'FiltersResponse',
    'FromAllInputFileResponse',
    'FromEachInputFileResponse',
    'H264LayerResponse',
    'H264VideoResponse',
    'H265LayerResponse',
    'H265VideoResponse',
    'ImageFormatResponse',
    'ImageResponse',
    'InputFileResponse',
    'JobErrorDetailResponse',
    'JobErrorResponse',
    'JobInputAssetResponse',
    'JobInputClipResponse',
    'JobInputHttpResponse',
    'JobInputSequenceResponse',
    'JobInputsResponse',
    'JobOutputAssetResponse',
    'JpgFormatResponse',
    'JpgImageResponse',
    'JpgLayerResponse',
    'Mp4FormatResponse',
    'MultiBitrateFormatResponse',
    'OutputFileResponse',
    'PngFormatResponse',
    'PngImageResponse',
    'PngLayerResponse',
    'PresetConfigurationsResponse',
    'RectangleResponse',
    'SelectAudioTrackByAttributeResponse',
    'SelectAudioTrackByIdResponse',
    'SelectVideoTrackByAttributeResponse',
    'SelectVideoTrackByIdResponse',
    'StandardEncoderPresetResponse',
    'SystemDataResponse',
    'TransformOutputResponse',
    'TransportStreamFormatResponse',
    'UtcClipTimeResponse',
    'VideoAnalyzerPresetResponse',
    'VideoOverlayResponse',
    'VideoResponse',
    'VideoTrackDescriptorResponse',
]

@pulumi.output_type
class AacAudioResponse(dict):
    """
    Describes Advanced Audio Codec (AAC) audio encoding settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "samplingRate":
            suggest = "sampling_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AacAudioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AacAudioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AacAudioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 bitrate: Optional[int] = None,
                 channels: Optional[int] = None,
                 label: Optional[str] = None,
                 profile: Optional[str] = None,
                 sampling_rate: Optional[int] = None):
        """
        Describes Advanced Audio Codec (AAC) audio encoding settings.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AacAudio'.
        :param int bitrate: The bitrate, in bits per second, of the output encoded audio.
        :param int channels: The number of channels in the audio.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param str profile: The encoding profile to be used when encoding audio with AAC.
        :param int sampling_rate: The sampling rate to use for encoding in hertz.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AacAudio')
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AacAudio'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[int]:
        """
        The bitrate, in bits per second, of the output encoded audio.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter
    def channels(self) -> Optional[int]:
        """
        The number of channels in the audio.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def profile(self) -> Optional[str]:
        """
        The encoding profile to be used when encoding audio with AAC.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[int]:
        """
        The sampling rate to use for encoding in hertz.
        """
        return pulumi.get(self, "sampling_rate")


@pulumi.output_type
class AbsoluteClipTimeResponse(dict):
    """
    Specifies the clip time as an absolute time position in the media file.  The absolute time can point to a different position depending on whether the media file starts from a timestamp of zero or not.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AbsoluteClipTimeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AbsoluteClipTimeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AbsoluteClipTimeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 time: str):
        """
        Specifies the clip time as an absolute time position in the media file.  The absolute time can point to a different position depending on whether the media file starts from a timestamp of zero or not.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AbsoluteClipTime'.
        :param str time: The time position on the timeline of the input media. It is usually specified as an ISO8601 period. e.g PT30S for 30 seconds.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AbsoluteClipTime')
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AbsoluteClipTime'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        The time position on the timeline of the input media. It is usually specified as an ISO8601 period. e.g PT30S for 30 seconds.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class AudioAnalyzerPresetResponse(dict):
    """
    The Audio Analyzer preset applies a pre-defined set of AI-based analysis operations, including speech transcription. Currently, the preset supports processing of content with a single audio track.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "audioLanguage":
            suggest = "audio_language"
        elif key == "experimentalOptions":
            suggest = "experimental_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AudioAnalyzerPresetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AudioAnalyzerPresetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AudioAnalyzerPresetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 audio_language: Optional[str] = None,
                 experimental_options: Optional[Mapping[str, str]] = None,
                 mode: Optional[str] = None):
        """
        The Audio Analyzer preset applies a pre-defined set of AI-based analysis operations, including speech transcription. Currently, the preset supports processing of content with a single audio track.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
        :param str audio_language: The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        :param Mapping[str, str] experimental_options: Dictionary containing key value pairs for parameters not exposed in the preset itself
        :param str mode: Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioAnalyzerPreset')
        if audio_language is not None:
            pulumi.set(__self__, "audio_language", audio_language)
        if experimental_options is not None:
            pulumi.set(__self__, "experimental_options", experimental_options)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="audioLanguage")
    def audio_language(self) -> Optional[str]:
        """
        The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        """
        return pulumi.get(self, "audio_language")

    @property
    @pulumi.getter(name="experimentalOptions")
    def experimental_options(self) -> Optional[Mapping[str, str]]:
        """
        Dictionary containing key value pairs for parameters not exposed in the preset itself
        """
        return pulumi.get(self, "experimental_options")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class AudioOverlayResponse(dict):
    """
    Describes the properties of an audio overlay.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputLabel":
            suggest = "input_label"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "audioGainLevel":
            suggest = "audio_gain_level"
        elif key == "fadeInDuration":
            suggest = "fade_in_duration"
        elif key == "fadeOutDuration":
            suggest = "fade_out_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AudioOverlayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AudioOverlayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AudioOverlayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_label: str,
                 odata_type: str,
                 audio_gain_level: Optional[float] = None,
                 end: Optional[str] = None,
                 fade_in_duration: Optional[str] = None,
                 fade_out_duration: Optional[str] = None,
                 start: Optional[str] = None):
        """
        Describes the properties of an audio overlay.
        :param str input_label: The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioOverlay'.
        :param float audio_gain_level: The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        :param str end: The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        :param str fade_in_duration: The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        :param str fade_out_duration: The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        :param str start: The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        pulumi.set(__self__, "input_label", input_label)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioOverlay')
        if audio_gain_level is not None:
            pulumi.set(__self__, "audio_gain_level", audio_gain_level)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if fade_in_duration is not None:
            pulumi.set(__self__, "fade_in_duration", fade_in_duration)
        if fade_out_duration is not None:
            pulumi.set(__self__, "fade_out_duration", fade_out_duration)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="inputLabel")
    def input_label(self) -> str:
        """
        The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        """
        return pulumi.get(self, "input_label")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioOverlay'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="audioGainLevel")
    def audio_gain_level(self) -> Optional[float]:
        """
        The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        """
        return pulumi.get(self, "audio_gain_level")

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter(name="fadeInDuration")
    def fade_in_duration(self) -> Optional[str]:
        """
        The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        """
        return pulumi.get(self, "fade_in_duration")

    @property
    @pulumi.getter(name="fadeOutDuration")
    def fade_out_duration(self) -> Optional[str]:
        """
        The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        """
        return pulumi.get(self, "fade_out_duration")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class AudioResponse(dict):
    """
    Defines the common properties for all audio codecs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "samplingRate":
            suggest = "sampling_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AudioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AudioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AudioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 bitrate: Optional[int] = None,
                 channels: Optional[int] = None,
                 label: Optional[str] = None,
                 sampling_rate: Optional[int] = None):
        """
        Defines the common properties for all audio codecs.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Audio'.
        :param int bitrate: The bitrate, in bits per second, of the output encoded audio.
        :param int channels: The number of channels in the audio.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param int sampling_rate: The sampling rate to use for encoding in hertz.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Audio')
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Audio'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[int]:
        """
        The bitrate, in bits per second, of the output encoded audio.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter
    def channels(self) -> Optional[int]:
        """
        The number of channels in the audio.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[int]:
        """
        The sampling rate to use for encoding in hertz.
        """
        return pulumi.get(self, "sampling_rate")


@pulumi.output_type
class AudioTrackDescriptorResponse(dict):
    """
    A TrackSelection to select audio tracks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "channelMapping":
            suggest = "channel_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AudioTrackDescriptorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AudioTrackDescriptorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AudioTrackDescriptorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 channel_mapping: Optional[str] = None):
        """
        A TrackSelection to select audio tracks.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioTrackDescriptor'.
        :param str channel_mapping: Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioTrackDescriptor')
        if channel_mapping is not None:
            pulumi.set(__self__, "channel_mapping", channel_mapping)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioTrackDescriptor'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="channelMapping")
    def channel_mapping(self) -> Optional[str]:
        """
        Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        return pulumi.get(self, "channel_mapping")


@pulumi.output_type
class BuiltInStandardEncoderPresetResponse(dict):
    """
    Describes a built-in preset for encoding the input video with the Standard Encoder.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "presetName":
            suggest = "preset_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuiltInStandardEncoderPresetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuiltInStandardEncoderPresetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuiltInStandardEncoderPresetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 preset_name: str,
                 configurations: Optional['outputs.PresetConfigurationsResponse'] = None):
        """
        Describes a built-in preset for encoding the input video with the Standard Encoder.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
        :param str preset_name: The built-in preset to be used for encoding videos.
        :param 'PresetConfigurationsResponse' configurations: Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.BuiltInStandardEncoderPreset')
        pulumi.set(__self__, "preset_name", preset_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> str:
        """
        The built-in preset to be used for encoding videos.
        """
        return pulumi.get(self, "preset_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional['outputs.PresetConfigurationsResponse']:
        """
        Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class CmafFormatResponse(dict):
    """
    A CMAF based output format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filenamePattern":
            suggest = "filename_pattern"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "outputFiles":
            suggest = "output_files"
        elif key == "streamingFormat":
            suggest = "streaming_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CmafFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CmafFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CmafFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filename_pattern: str,
                 odata_type: str,
                 output_files: Optional[Sequence['outputs.OutputFileResponse']] = None,
                 streaming_format: Optional[str] = None):
        """
        A CMAF based output format.
        :param str filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.CmafFormat'.
        :param Sequence['OutputFileResponse'] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.CmafFormat')
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)
        if streaming_format is not None:
            pulumi.set(__self__, "streaming_format", streaming_format)

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> str:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.CmafFormat'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[Sequence['outputs.OutputFileResponse']]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")

    @property
    @pulumi.getter(name="streamingFormat")
    def streaming_format(self) -> Optional[str]:
        return pulumi.get(self, "streaming_format")


@pulumi.output_type
class CopyAudioResponse(dict):
    """
    A codec flag, which tells the encoder to copy the input audio bitstream.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CopyAudioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CopyAudioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CopyAudioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 label: Optional[str] = None):
        """
        A codec flag, which tells the encoder to copy the input audio bitstream.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.CopyAudio'.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.CopyAudio')
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.CopyAudio'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class CopyVideoResponse(dict):
    """
    A codec flag, which tells the encoder to copy the input video bitstream without re-encoding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CopyVideoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CopyVideoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CopyVideoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 label: Optional[str] = None):
        """
        A codec flag, which tells the encoder to copy the input video bitstream without re-encoding.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.CopyVideo'.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.CopyVideo')
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.CopyVideo'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class DDAudioResponse(dict):
    """
    Describes Dolby Digital Audio Codec (AC3) audio encoding settings. The current implementation for Dolby Digital Audio support are: Audio channel numbers at 1((mono), 2(stereo), 6(5.1side); Audio sampling frequency rates at: 32K/44.1K/48K Hz; Audio bitrate values as AC3 specification supports: 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000 bps.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "samplingRate":
            suggest = "sampling_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DDAudioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DDAudioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DDAudioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 bitrate: Optional[int] = None,
                 channels: Optional[int] = None,
                 label: Optional[str] = None,
                 sampling_rate: Optional[int] = None):
        """
        Describes Dolby Digital Audio Codec (AC3) audio encoding settings. The current implementation for Dolby Digital Audio support are: Audio channel numbers at 1((mono), 2(stereo), 6(5.1side); Audio sampling frequency rates at: 32K/44.1K/48K Hz; Audio bitrate values as AC3 specification supports: 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000 bps.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.DDAudio'.
        :param int bitrate: The bitrate, in bits per second, of the output encoded audio.
        :param int channels: The number of channels in the audio.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param int sampling_rate: The sampling rate to use for encoding in hertz.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.DDAudio')
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.DDAudio'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[int]:
        """
        The bitrate, in bits per second, of the output encoded audio.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter
    def channels(self) -> Optional[int]:
        """
        The number of channels in the audio.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[int]:
        """
        The sampling rate to use for encoding in hertz.
        """
        return pulumi.get(self, "sampling_rate")


@pulumi.output_type
class DeinterlaceResponse(dict):
    """
    Describes the de-interlacing settings.
    """
    def __init__(__self__, *,
                 mode: Optional[str] = None,
                 parity: Optional[str] = None):
        """
        Describes the de-interlacing settings.
        :param str mode: The deinterlacing mode. Defaults to AutoPixelAdaptive.
        :param str parity: The field parity for de-interlacing, defaults to Auto.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if parity is not None:
            pulumi.set(__self__, "parity", parity)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The deinterlacing mode. Defaults to AutoPixelAdaptive.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def parity(self) -> Optional[str]:
        """
        The field parity for de-interlacing, defaults to Auto.
        """
        return pulumi.get(self, "parity")


@pulumi.output_type
class FaceDetectorPresetResponse(dict):
    """
    Describes all the settings to be used when analyzing a video in order to detect (and optionally redact) all the faces present.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "blurType":
            suggest = "blur_type"
        elif key == "experimentalOptions":
            suggest = "experimental_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FaceDetectorPresetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FaceDetectorPresetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FaceDetectorPresetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 blur_type: Optional[str] = None,
                 experimental_options: Optional[Mapping[str, str]] = None,
                 mode: Optional[str] = None,
                 resolution: Optional[str] = None):
        """
        Describes all the settings to be used when analyzing a video in order to detect (and optionally redact) all the faces present.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.FaceDetectorPreset'.
        :param str blur_type: Blur type
        :param Mapping[str, str] experimental_options: Dictionary containing key value pairs for parameters not exposed in the preset itself
        :param str mode: This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
        :param str resolution: Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.FaceDetectorPreset')
        if blur_type is not None:
            pulumi.set(__self__, "blur_type", blur_type)
        if experimental_options is not None:
            pulumi.set(__self__, "experimental_options", experimental_options)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.FaceDetectorPreset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="blurType")
    def blur_type(self) -> Optional[str]:
        """
        Blur type
        """
        return pulumi.get(self, "blur_type")

    @property
    @pulumi.getter(name="experimentalOptions")
    def experimental_options(self) -> Optional[Mapping[str, str]]:
        """
        Dictionary containing key value pairs for parameters not exposed in the preset itself
        """
        return pulumi.get(self, "experimental_options")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def resolution(self) -> Optional[str]:
        """
        Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
        """
        return pulumi.get(self, "resolution")


@pulumi.output_type
class FiltersResponse(dict):
    """
    Describes all the filtering operations, such as de-interlacing, rotation etc. that are to be applied to the input media before encoding.
    """
    def __init__(__self__, *,
                 crop: Optional['outputs.RectangleResponse'] = None,
                 deinterlace: Optional['outputs.DeinterlaceResponse'] = None,
                 overlays: Optional[Sequence[Any]] = None,
                 rotation: Optional[str] = None):
        """
        Describes all the filtering operations, such as de-interlacing, rotation etc. that are to be applied to the input media before encoding.
        :param 'RectangleResponse' crop: The parameters for the rectangular window with which to crop the input video.
        :param 'DeinterlaceResponse' deinterlace: The de-interlacing settings.
        :param Sequence[Union['AudioOverlayResponse', 'VideoOverlayResponse']] overlays: The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
        :param str rotation: The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
        """
        if crop is not None:
            pulumi.set(__self__, "crop", crop)
        if deinterlace is not None:
            pulumi.set(__self__, "deinterlace", deinterlace)
        if overlays is not None:
            pulumi.set(__self__, "overlays", overlays)
        if rotation is not None:
            pulumi.set(__self__, "rotation", rotation)

    @property
    @pulumi.getter
    def crop(self) -> Optional['outputs.RectangleResponse']:
        """
        The parameters for the rectangular window with which to crop the input video.
        """
        return pulumi.get(self, "crop")

    @property
    @pulumi.getter
    def deinterlace(self) -> Optional['outputs.DeinterlaceResponse']:
        """
        The de-interlacing settings.
        """
        return pulumi.get(self, "deinterlace")

    @property
    @pulumi.getter
    def overlays(self) -> Optional[Sequence[Any]]:
        """
        The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
        """
        return pulumi.get(self, "overlays")

    @property
    @pulumi.getter
    def rotation(self) -> Optional[str]:
        """
        The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
        """
        return pulumi.get(self, "rotation")


@pulumi.output_type
class FromAllInputFileResponse(dict):
    """
    An InputDefinition that looks across all of the files provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to allow selection of a single track across a set of input files.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "includedTracks":
            suggest = "included_tracks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FromAllInputFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FromAllInputFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FromAllInputFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 included_tracks: Optional[Sequence[Any]] = None):
        """
        An InputDefinition that looks across all of the files provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to allow selection of a single track across a set of input files.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.FromAllInputFile'.
        :param Sequence[Union['AudioTrackDescriptorResponse', 'SelectAudioTrackByAttributeResponse', 'SelectAudioTrackByIdResponse', 'SelectVideoTrackByAttributeResponse', 'SelectVideoTrackByIdResponse', 'VideoTrackDescriptorResponse']] included_tracks: The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.FromAllInputFile')
        if included_tracks is not None:
            pulumi.set(__self__, "included_tracks", included_tracks)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.FromAllInputFile'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="includedTracks")
    def included_tracks(self) -> Optional[Sequence[Any]]:
        """
        The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        return pulumi.get(self, "included_tracks")


@pulumi.output_type
class FromEachInputFileResponse(dict):
    """
    An InputDefinition that looks at each input file provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to select tracks from each file given.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "includedTracks":
            suggest = "included_tracks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FromEachInputFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FromEachInputFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FromEachInputFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 included_tracks: Optional[Sequence[Any]] = None):
        """
        An InputDefinition that looks at each input file provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to select tracks from each file given.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.FromEachInputFile'.
        :param Sequence[Union['AudioTrackDescriptorResponse', 'SelectAudioTrackByAttributeResponse', 'SelectAudioTrackByIdResponse', 'SelectVideoTrackByAttributeResponse', 'SelectVideoTrackByIdResponse', 'VideoTrackDescriptorResponse']] included_tracks: The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.FromEachInputFile')
        if included_tracks is not None:
            pulumi.set(__self__, "included_tracks", included_tracks)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.FromEachInputFile'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="includedTracks")
    def included_tracks(self) -> Optional[Sequence[Any]]:
        """
        The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        return pulumi.get(self, "included_tracks")


@pulumi.output_type
class H264LayerResponse(dict):
    """
    Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.264 video codec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adaptiveBFrame":
            suggest = "adaptive_b_frame"
        elif key == "bFrames":
            suggest = "b_frames"
        elif key == "bufferWindow":
            suggest = "buffer_window"
        elif key == "entropyMode":
            suggest = "entropy_mode"
        elif key == "frameRate":
            suggest = "frame_rate"
        elif key == "maxBitrate":
            suggest = "max_bitrate"
        elif key == "referenceFrames":
            suggest = "reference_frames"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in H264LayerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        H264LayerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        H264LayerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bitrate: int,
                 adaptive_b_frame: Optional[bool] = None,
                 b_frames: Optional[int] = None,
                 buffer_window: Optional[str] = None,
                 crf: Optional[float] = None,
                 entropy_mode: Optional[str] = None,
                 frame_rate: Optional[str] = None,
                 height: Optional[str] = None,
                 label: Optional[str] = None,
                 level: Optional[str] = None,
                 max_bitrate: Optional[int] = None,
                 profile: Optional[str] = None,
                 reference_frames: Optional[int] = None,
                 slices: Optional[int] = None,
                 width: Optional[str] = None):
        """
        Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.264 video codec.
        :param int bitrate: The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
        :param bool adaptive_b_frame: Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        :param int b_frames: The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        :param str buffer_window: The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        :param float crf: The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 23.
        :param str entropy_mode: The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
        :param str frame_rate: The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        :param str height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param str label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param str level: We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        :param int max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        :param str profile: We currently support Baseline, Main, High, High422, High444. Default is Auto.
        :param int reference_frames: The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        :param int slices: The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        :param str width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        pulumi.set(__self__, "bitrate", bitrate)
        if adaptive_b_frame is not None:
            pulumi.set(__self__, "adaptive_b_frame", adaptive_b_frame)
        if b_frames is not None:
            pulumi.set(__self__, "b_frames", b_frames)
        if buffer_window is not None:
            pulumi.set(__self__, "buffer_window", buffer_window)
        if crf is not None:
            pulumi.set(__self__, "crf", crf)
        if entropy_mode is not None:
            pulumi.set(__self__, "entropy_mode", entropy_mode)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if reference_frames is not None:
            pulumi.set(__self__, "reference_frames", reference_frames)
        if slices is not None:
            pulumi.set(__self__, "slices", slices)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def bitrate(self) -> int:
        """
        The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter(name="adaptiveBFrame")
    def adaptive_b_frame(self) -> Optional[bool]:
        """
        Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        """
        return pulumi.get(self, "adaptive_b_frame")

    @property
    @pulumi.getter(name="bFrames")
    def b_frames(self) -> Optional[int]:
        """
        The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        """
        return pulumi.get(self, "b_frames")

    @property
    @pulumi.getter(name="bufferWindow")
    def buffer_window(self) -> Optional[str]:
        """
        The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        """
        return pulumi.get(self, "buffer_window")

    @property
    @pulumi.getter
    def crf(self) -> Optional[float]:
        """
        The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 23.
        """
        return pulumi.get(self, "crf")

    @property
    @pulumi.getter(name="entropyMode")
    def entropy_mode(self) -> Optional[str]:
        """
        The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
        """
        return pulumi.get(self, "entropy_mode")

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[str]:
        """
        The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        """
        return pulumi.get(self, "frame_rate")

    @property
    @pulumi.getter
    def height(self) -> Optional[str]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[int]:
        """
        The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        """
        return pulumi.get(self, "max_bitrate")

    @property
    @pulumi.getter
    def profile(self) -> Optional[str]:
        """
        We currently support Baseline, Main, High, High422, High444. Default is Auto.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="referenceFrames")
    def reference_frames(self) -> Optional[int]:
        """
        The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        """
        return pulumi.get(self, "reference_frames")

    @property
    @pulumi.getter
    def slices(self) -> Optional[int]:
        """
        The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        """
        return pulumi.get(self, "slices")

    @property
    @pulumi.getter
    def width(self) -> Optional[str]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class H264VideoResponse(dict):
    """
    Describes all the properties for encoding a video with the H.264 codec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "rateControlMode":
            suggest = "rate_control_mode"
        elif key == "sceneChangeDetection":
            suggest = "scene_change_detection"
        elif key == "stretchMode":
            suggest = "stretch_mode"
        elif key == "syncMode":
            suggest = "sync_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in H264VideoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        H264VideoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        H264VideoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 complexity: Optional[str] = None,
                 key_frame_interval: Optional[str] = None,
                 label: Optional[str] = None,
                 layers: Optional[Sequence['outputs.H264LayerResponse']] = None,
                 rate_control_mode: Optional[str] = None,
                 scene_change_detection: Optional[bool] = None,
                 stretch_mode: Optional[str] = None,
                 sync_mode: Optional[str] = None):
        """
        Describes all the properties for encoding a video with the H.264 codec.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.H264Video'.
        :param str complexity: Tells the encoder how to choose its encoding settings. The default value is Balanced.
        :param str key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param Sequence['H264LayerResponse'] layers: The collection of output H.264 layers to be produced by the encoder.
        :param str rate_control_mode: The video rate control mode
        :param bool scene_change_detection: Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        :param str stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param str sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.H264Video')
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if rate_control_mode is not None:
            pulumi.set(__self__, "rate_control_mode", rate_control_mode)
        if scene_change_detection is not None:
            pulumi.set(__self__, "scene_change_detection", scene_change_detection)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.H264Video'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def complexity(self) -> Optional[str]:
        """
        Tells the encoder how to choose its encoding settings. The default value is Balanced.
        """
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def layers(self) -> Optional[Sequence['outputs.H264LayerResponse']]:
        """
        The collection of output H.264 layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="rateControlMode")
    def rate_control_mode(self) -> Optional[str]:
        """
        The video rate control mode
        """
        return pulumi.get(self, "rate_control_mode")

    @property
    @pulumi.getter(name="sceneChangeDetection")
    def scene_change_detection(self) -> Optional[bool]:
        """
        Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        """
        return pulumi.get(self, "scene_change_detection")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[str]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")


@pulumi.output_type
class H265LayerResponse(dict):
    """
    Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.265 video codec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adaptiveBFrame":
            suggest = "adaptive_b_frame"
        elif key == "bFrames":
            suggest = "b_frames"
        elif key == "bufferWindow":
            suggest = "buffer_window"
        elif key == "frameRate":
            suggest = "frame_rate"
        elif key == "maxBitrate":
            suggest = "max_bitrate"
        elif key == "referenceFrames":
            suggest = "reference_frames"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in H265LayerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        H265LayerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        H265LayerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bitrate: int,
                 adaptive_b_frame: Optional[bool] = None,
                 b_frames: Optional[int] = None,
                 buffer_window: Optional[str] = None,
                 crf: Optional[float] = None,
                 frame_rate: Optional[str] = None,
                 height: Optional[str] = None,
                 label: Optional[str] = None,
                 level: Optional[str] = None,
                 max_bitrate: Optional[int] = None,
                 profile: Optional[str] = None,
                 reference_frames: Optional[int] = None,
                 slices: Optional[int] = None,
                 width: Optional[str] = None):
        """
        Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.265 video codec.
        :param int bitrate: The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
        :param bool adaptive_b_frame: Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        :param int b_frames: The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        :param str buffer_window: The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        :param float crf: The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 28.
        :param str frame_rate: The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        :param str height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param str label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param str level: We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        :param int max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        :param str profile: We currently support Main. Default is Auto.
        :param int reference_frames: The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        :param int slices: The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        :param str width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        pulumi.set(__self__, "bitrate", bitrate)
        if adaptive_b_frame is not None:
            pulumi.set(__self__, "adaptive_b_frame", adaptive_b_frame)
        if b_frames is not None:
            pulumi.set(__self__, "b_frames", b_frames)
        if buffer_window is not None:
            pulumi.set(__self__, "buffer_window", buffer_window)
        if crf is not None:
            pulumi.set(__self__, "crf", crf)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if reference_frames is not None:
            pulumi.set(__self__, "reference_frames", reference_frames)
        if slices is not None:
            pulumi.set(__self__, "slices", slices)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def bitrate(self) -> int:
        """
        The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter(name="adaptiveBFrame")
    def adaptive_b_frame(self) -> Optional[bool]:
        """
        Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        """
        return pulumi.get(self, "adaptive_b_frame")

    @property
    @pulumi.getter(name="bFrames")
    def b_frames(self) -> Optional[int]:
        """
        The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        """
        return pulumi.get(self, "b_frames")

    @property
    @pulumi.getter(name="bufferWindow")
    def buffer_window(self) -> Optional[str]:
        """
        The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        """
        return pulumi.get(self, "buffer_window")

    @property
    @pulumi.getter
    def crf(self) -> Optional[float]:
        """
        The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 28.
        """
        return pulumi.get(self, "crf")

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[str]:
        """
        The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        """
        return pulumi.get(self, "frame_rate")

    @property
    @pulumi.getter
    def height(self) -> Optional[str]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[int]:
        """
        The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        """
        return pulumi.get(self, "max_bitrate")

    @property
    @pulumi.getter
    def profile(self) -> Optional[str]:
        """
        We currently support Main. Default is Auto.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="referenceFrames")
    def reference_frames(self) -> Optional[int]:
        """
        The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        """
        return pulumi.get(self, "reference_frames")

    @property
    @pulumi.getter
    def slices(self) -> Optional[int]:
        """
        The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        """
        return pulumi.get(self, "slices")

    @property
    @pulumi.getter
    def width(self) -> Optional[str]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class H265VideoResponse(dict):
    """
    Describes all the properties for encoding a video with the H.265 codec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "sceneChangeDetection":
            suggest = "scene_change_detection"
        elif key == "stretchMode":
            suggest = "stretch_mode"
        elif key == "syncMode":
            suggest = "sync_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in H265VideoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        H265VideoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        H265VideoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 complexity: Optional[str] = None,
                 key_frame_interval: Optional[str] = None,
                 label: Optional[str] = None,
                 layers: Optional[Sequence['outputs.H265LayerResponse']] = None,
                 scene_change_detection: Optional[bool] = None,
                 stretch_mode: Optional[str] = None,
                 sync_mode: Optional[str] = None):
        """
        Describes all the properties for encoding a video with the H.265 codec.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.H265Video'.
        :param str complexity: Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
        :param str key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param Sequence['H265LayerResponse'] layers: The collection of output H.265 layers to be produced by the encoder.
        :param bool scene_change_detection: Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        :param str stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param str sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.H265Video')
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if scene_change_detection is not None:
            pulumi.set(__self__, "scene_change_detection", scene_change_detection)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.H265Video'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def complexity(self) -> Optional[str]:
        """
        Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
        """
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def layers(self) -> Optional[Sequence['outputs.H265LayerResponse']]:
        """
        The collection of output H.265 layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="sceneChangeDetection")
    def scene_change_detection(self) -> Optional[bool]:
        """
        Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        """
        return pulumi.get(self, "scene_change_detection")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[str]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")


@pulumi.output_type
class ImageFormatResponse(dict):
    """
    Describes the properties for an output image file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filenamePattern":
            suggest = "filename_pattern"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filename_pattern: str,
                 odata_type: str):
        """
        Describes the properties for an output image file.
        :param str filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ImageFormat'.
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ImageFormat')

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> str:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ImageFormat'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ImageResponse(dict):
    """
    Describes the basic properties for generating thumbnails from the input video
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "stretchMode":
            suggest = "stretch_mode"
        elif key == "syncMode":
            suggest = "sync_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 start: str,
                 key_frame_interval: Optional[str] = None,
                 label: Optional[str] = None,
                 range: Optional[str] = None,
                 step: Optional[str] = None,
                 stretch_mode: Optional[str] = None,
                 sync_mode: Optional[str] = None):
        """
        Describes the basic properties for generating thumbnails from the input video
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Image'.
        :param str start: The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        :param str key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param str range: The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        :param str step: The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :param str stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param str sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Image')
        pulumi.set(__self__, "start", start)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Image'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def start(self) -> str:
        """
        The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def range(self) -> Optional[str]:
        """
        The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter
    def step(self) -> Optional[str]:
        """
        The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        """
        return pulumi.get(self, "step")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[str]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")


@pulumi.output_type
class InputFileResponse(dict):
    """
    An InputDefinition for a single file.  TrackSelections are scoped to the file specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "includedTracks":
            suggest = "included_tracks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InputFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InputFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InputFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 filename: Optional[str] = None,
                 included_tracks: Optional[Sequence[Any]] = None):
        """
        An InputDefinition for a single file.  TrackSelections are scoped to the file specified.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.InputFile'.
        :param str filename: Name of the file that this input definition applies to.
        :param Sequence[Union['AudioTrackDescriptorResponse', 'SelectAudioTrackByAttributeResponse', 'SelectAudioTrackByIdResponse', 'SelectVideoTrackByAttributeResponse', 'SelectVideoTrackByIdResponse', 'VideoTrackDescriptorResponse']] included_tracks: The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.InputFile')
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if included_tracks is not None:
            pulumi.set(__self__, "included_tracks", included_tracks)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.InputFile'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def filename(self) -> Optional[str]:
        """
        Name of the file that this input definition applies to.
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter(name="includedTracks")
    def included_tracks(self) -> Optional[Sequence[Any]]:
        """
        The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        return pulumi.get(self, "included_tracks")


@pulumi.output_type
class JobErrorDetailResponse(dict):
    """
    Details of JobOutput errors.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str):
        """
        Details of JobOutput errors.
        :param str code: Code describing the error detail.
        :param str message: A human-readable representation of the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Code describing the error detail.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable representation of the error.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class JobErrorResponse(dict):
    """
    Details of JobOutput errors.
    """
    def __init__(__self__, *,
                 category: str,
                 code: str,
                 details: Sequence['outputs.JobErrorDetailResponse'],
                 message: str,
                 retry: str):
        """
        Details of JobOutput errors.
        :param str category: Helps with categorization of errors.
        :param str code: Error code describing the error.
        :param Sequence['JobErrorDetailResponse'] details: An array of details about specific errors that led to this reported error.
        :param str message: A human-readable language-dependent representation of the error.
        :param str retry: Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via Azure Portal.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "retry", retry)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Helps with categorization of errors.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code describing the error.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.JobErrorDetailResponse']:
        """
        An array of details about specific errors that led to this reported error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable language-dependent representation of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def retry(self) -> str:
        """
        Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via Azure Portal.
        """
        return pulumi.get(self, "retry")


@pulumi.output_type
class JobInputAssetResponse(dict):
    """
    Represents an Asset for input into a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetName":
            suggest = "asset_name"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "inputDefinitions":
            suggest = "input_definitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobInputAssetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobInputAssetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobInputAssetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_name: str,
                 odata_type: str,
                 end: Optional[Any] = None,
                 files: Optional[Sequence[str]] = None,
                 input_definitions: Optional[Sequence[Any]] = None,
                 label: Optional[str] = None,
                 start: Optional[Any] = None):
        """
        Represents an Asset for input into a Job.
        :param str asset_name: The name of the input Asset.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputAsset'.
        :param Union['AbsoluteClipTimeResponse', 'UtcClipTimeResponse'] end: Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        :param Sequence[str] files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        :param Sequence[Union['FromAllInputFileResponse', 'FromEachInputFileResponse', 'InputFileResponse']] input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        :param str label: A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        :param Union['AbsoluteClipTimeResponse', 'UtcClipTimeResponse'] start: Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        pulumi.set(__self__, "asset_name", asset_name)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputAsset')
        if end is not None:
            pulumi.set(__self__, "end", end)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if input_definitions is not None:
            pulumi.set(__self__, "input_definitions", input_definitions)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> str:
        """
        The name of the input Asset.
        """
        return pulumi.get(self, "asset_name")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputAsset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def end(self) -> Optional[Any]:
        """
        Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def files(self) -> Optional[Sequence[str]]:
        """
        List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter(name="inputDefinitions")
    def input_definitions(self) -> Optional[Sequence[Any]]:
        """
        Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        """
        return pulumi.get(self, "input_definitions")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def start(self) -> Optional[Any]:
        """
        Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class JobInputClipResponse(dict):
    """
    Represents input files for a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "inputDefinitions":
            suggest = "input_definitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobInputClipResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobInputClipResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobInputClipResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 end: Optional[Any] = None,
                 files: Optional[Sequence[str]] = None,
                 input_definitions: Optional[Sequence[Any]] = None,
                 label: Optional[str] = None,
                 start: Optional[Any] = None):
        """
        Represents input files for a Job.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputClip'.
        :param Union['AbsoluteClipTimeResponse', 'UtcClipTimeResponse'] end: Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        :param Sequence[str] files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        :param Sequence[Union['FromAllInputFileResponse', 'FromEachInputFileResponse', 'InputFileResponse']] input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        :param str label: A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        :param Union['AbsoluteClipTimeResponse', 'UtcClipTimeResponse'] start: Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputClip')
        if end is not None:
            pulumi.set(__self__, "end", end)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if input_definitions is not None:
            pulumi.set(__self__, "input_definitions", input_definitions)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputClip'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def end(self) -> Optional[Any]:
        """
        Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def files(self) -> Optional[Sequence[str]]:
        """
        List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter(name="inputDefinitions")
    def input_definitions(self) -> Optional[Sequence[Any]]:
        """
        Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        """
        return pulumi.get(self, "input_definitions")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def start(self) -> Optional[Any]:
        """
        Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class JobInputHttpResponse(dict):
    """
    Represents HTTPS job input.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "baseUri":
            suggest = "base_uri"
        elif key == "inputDefinitions":
            suggest = "input_definitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobInputHttpResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobInputHttpResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobInputHttpResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 base_uri: Optional[str] = None,
                 end: Optional[Any] = None,
                 files: Optional[Sequence[str]] = None,
                 input_definitions: Optional[Sequence[Any]] = None,
                 label: Optional[str] = None,
                 start: Optional[Any] = None):
        """
        Represents HTTPS job input.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputHttp'.
        :param str base_uri: Base URI for HTTPS job input. It will be concatenated with provided file names. If no base uri is given, then the provided file list is assumed to be fully qualified uris. Maximum length of 4000 characters. The query strings will not be returned in service responses to prevent sensitive data exposure.
        :param Union['AbsoluteClipTimeResponse', 'UtcClipTimeResponse'] end: Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        :param Sequence[str] files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        :param Sequence[Union['FromAllInputFileResponse', 'FromEachInputFileResponse', 'InputFileResponse']] input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        :param str label: A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        :param Union['AbsoluteClipTimeResponse', 'UtcClipTimeResponse'] start: Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputHttp')
        if base_uri is not None:
            pulumi.set(__self__, "base_uri", base_uri)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if input_definitions is not None:
            pulumi.set(__self__, "input_definitions", input_definitions)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputHttp'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="baseUri")
    def base_uri(self) -> Optional[str]:
        """
        Base URI for HTTPS job input. It will be concatenated with provided file names. If no base uri is given, then the provided file list is assumed to be fully qualified uris. Maximum length of 4000 characters. The query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "base_uri")

    @property
    @pulumi.getter
    def end(self) -> Optional[Any]:
        """
        Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def files(self) -> Optional[Sequence[str]]:
        """
        List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter(name="inputDefinitions")
    def input_definitions(self) -> Optional[Sequence[Any]]:
        """
        Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        """
        return pulumi.get(self, "input_definitions")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def start(self) -> Optional[Any]:
        """
        Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class JobInputSequenceResponse(dict):
    """
    A Sequence contains an ordered list of Clips where each clip is a JobInput.  The Sequence will be treated as a single input.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobInputSequenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobInputSequenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobInputSequenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 inputs: Optional[Sequence['outputs.JobInputClipResponse']] = None):
        """
        A Sequence contains an ordered list of Clips where each clip is a JobInput.  The Sequence will be treated as a single input.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputSequence'.
        :param Sequence['JobInputClipResponse'] inputs: JobInputs that make up the timeline.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputSequence')
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputSequence'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence['outputs.JobInputClipResponse']]:
        """
        JobInputs that make up the timeline.
        """
        return pulumi.get(self, "inputs")


@pulumi.output_type
class JobInputsResponse(dict):
    """
    Describes a list of inputs to a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobInputsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobInputsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobInputsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 inputs: Optional[Sequence[Any]] = None):
        """
        Describes a list of inputs to a Job.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputs'.
        :param Sequence[Union['JobInputAssetResponse', 'JobInputClipResponse', 'JobInputHttpResponse', 'JobInputSequenceResponse', 'JobInputsResponse']] inputs: List of inputs to a Job.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputs')
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputs'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence[Any]]:
        """
        List of inputs to a Job.
        """
        return pulumi.get(self, "inputs")


@pulumi.output_type
class JobOutputAssetResponse(dict):
    """
    Represents an Asset used as a JobOutput.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetName":
            suggest = "asset_name"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "presetOverride":
            suggest = "preset_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobOutputAssetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobOutputAssetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobOutputAssetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_name: str,
                 end_time: str,
                 error: 'outputs.JobErrorResponse',
                 odata_type: str,
                 progress: int,
                 start_time: str,
                 state: str,
                 label: Optional[str] = None,
                 preset_override: Optional[Any] = None):
        """
        Represents an Asset used as a JobOutput.
        :param str asset_name: The name of the output Asset.
        :param str end_time: The UTC date and time at which this Job Output finished processing.
        :param 'JobErrorResponse' error: If the JobOutput is in the Error state, it contains the details of the error.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobOutputAsset'.
        :param int progress: If the JobOutput is in a Processing state, this contains the Job completion percentage. The value is an estimate and not intended to be used to predict Job completion times. To determine if the JobOutput is complete, use the State property.
        :param str start_time: The UTC date and time at which this Job Output began processing.
        :param str state: Describes the state of the JobOutput.
        :param str label: A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more than one TransformOutput, whereby your Job has more than one JobOutput. In such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you retrieve the Job, either through events or on a GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the Job. Note that this index is the same as the relative index of the corresponding TransformOutput within its Transform.
        :param Union['AudioAnalyzerPresetResponse', 'BuiltInStandardEncoderPresetResponse', 'FaceDetectorPresetResponse', 'StandardEncoderPresetResponse', 'VideoAnalyzerPresetResponse'] preset_override: A preset used to override the preset in the corresponding transform output.
        """
        pulumi.set(__self__, "asset_name", asset_name)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobOutputAsset')
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "state", state)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if preset_override is not None:
            pulumi.set(__self__, "preset_override", preset_override)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> str:
        """
        The name of the output Asset.
        """
        return pulumi.get(self, "asset_name")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The UTC date and time at which this Job Output finished processing.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.JobErrorResponse':
        """
        If the JobOutput is in the Error state, it contains the details of the error.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobOutputAsset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def progress(self) -> int:
        """
        If the JobOutput is in a Processing state, this contains the Job completion percentage. The value is an estimate and not intended to be used to predict Job completion times. To determine if the JobOutput is complete, use the State property.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The UTC date and time at which this Job Output began processing.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describes the state of the JobOutput.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more than one TransformOutput, whereby your Job has more than one JobOutput. In such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you retrieve the Job, either through events or on a GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the Job. Note that this index is the same as the relative index of the corresponding TransformOutput within its Transform.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="presetOverride")
    def preset_override(self) -> Optional[Any]:
        """
        A preset used to override the preset in the corresponding transform output.
        """
        return pulumi.get(self, "preset_override")


@pulumi.output_type
class JpgFormatResponse(dict):
    """
    Describes the settings for producing JPEG thumbnails.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filenamePattern":
            suggest = "filename_pattern"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JpgFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JpgFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JpgFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filename_pattern: str,
                 odata_type: str):
        """
        Describes the settings for producing JPEG thumbnails.
        :param str filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JpgFormat'.
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JpgFormat')

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> str:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JpgFormat'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class JpgImageResponse(dict):
    """
    Describes the properties for producing a series of JPEG images from the input video.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "spriteColumn":
            suggest = "sprite_column"
        elif key == "stretchMode":
            suggest = "stretch_mode"
        elif key == "syncMode":
            suggest = "sync_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JpgImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JpgImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JpgImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 start: str,
                 key_frame_interval: Optional[str] = None,
                 label: Optional[str] = None,
                 layers: Optional[Sequence['outputs.JpgLayerResponse']] = None,
                 range: Optional[str] = None,
                 sprite_column: Optional[int] = None,
                 step: Optional[str] = None,
                 stretch_mode: Optional[str] = None,
                 sync_mode: Optional[str] = None):
        """
        Describes the properties for producing a series of JPEG images from the input video.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JpgImage'.
        :param str start: The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        :param str key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param Sequence['JpgLayerResponse'] layers: A collection of output JPEG image layers to be produced by the encoder.
        :param str range: The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        :param int sprite_column: Sets the number of columns used in thumbnail sprite image.  The number of rows are automatically calculated and a VTT file is generated with the coordinate mappings for each thumbnail in the sprite. Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will not go beyond JPEG maximum pixel resolution limit 65535x65535.
        :param str step: The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :param str stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param str sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JpgImage')
        pulumi.set(__self__, "start", start)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if sprite_column is not None:
            pulumi.set(__self__, "sprite_column", sprite_column)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JpgImage'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def start(self) -> str:
        """
        The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def layers(self) -> Optional[Sequence['outputs.JpgLayerResponse']]:
        """
        A collection of output JPEG image layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter
    def range(self) -> Optional[str]:
        """
        The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter(name="spriteColumn")
    def sprite_column(self) -> Optional[int]:
        """
        Sets the number of columns used in thumbnail sprite image.  The number of rows are automatically calculated and a VTT file is generated with the coordinate mappings for each thumbnail in the sprite. Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will not go beyond JPEG maximum pixel resolution limit 65535x65535.
        """
        return pulumi.get(self, "sprite_column")

    @property
    @pulumi.getter
    def step(self) -> Optional[str]:
        """
        The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        """
        return pulumi.get(self, "step")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[str]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")


@pulumi.output_type
class JpgLayerResponse(dict):
    """
    Describes the settings to produce a JPEG image from the input video.
    """
    def __init__(__self__, *,
                 height: Optional[str] = None,
                 label: Optional[str] = None,
                 quality: Optional[int] = None,
                 width: Optional[str] = None):
        """
        Describes the settings to produce a JPEG image from the input video.
        :param str height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param str label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param int quality: The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
        :param str width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[str]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def quality(self) -> Optional[int]:
        """
        The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
        """
        return pulumi.get(self, "quality")

    @property
    @pulumi.getter
    def width(self) -> Optional[str]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class Mp4FormatResponse(dict):
    """
    Describes the properties for an output ISO MP4 file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filenamePattern":
            suggest = "filename_pattern"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "outputFiles":
            suggest = "output_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mp4FormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mp4FormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mp4FormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filename_pattern: str,
                 odata_type: str,
                 output_files: Optional[Sequence['outputs.OutputFileResponse']] = None):
        """
        Describes the properties for an output ISO MP4 file.
        :param str filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Mp4Format'.
        :param Sequence['OutputFileResponse'] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Mp4Format')
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> str:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Mp4Format'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[Sequence['outputs.OutputFileResponse']]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")


@pulumi.output_type
class MultiBitrateFormatResponse(dict):
    """
    Describes the properties for producing a collection of GOP aligned multi-bitrate files. The default behavior is to produce one output file for each video layer which is muxed together with all the audios. The exact output files produced can be controlled by specifying the outputFiles collection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filenamePattern":
            suggest = "filename_pattern"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "outputFiles":
            suggest = "output_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiBitrateFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiBitrateFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiBitrateFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filename_pattern: str,
                 odata_type: str,
                 output_files: Optional[Sequence['outputs.OutputFileResponse']] = None):
        """
        Describes the properties for producing a collection of GOP aligned multi-bitrate files. The default behavior is to produce one output file for each video layer which is muxed together with all the audios. The exact output files produced can be controlled by specifying the outputFiles collection.
        :param str filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.MultiBitrateFormat'.
        :param Sequence['OutputFileResponse'] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.MultiBitrateFormat')
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> str:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.MultiBitrateFormat'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[Sequence['outputs.OutputFileResponse']]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")


@pulumi.output_type
class OutputFileResponse(dict):
    """
    Represents an output file produced.
    """
    def __init__(__self__, *,
                 labels: Sequence[str]):
        """
        Represents an output file produced.
        :param Sequence[str] labels: The list of labels that describe how the encoder should multiplex video and audio into an output file. For example, if the encoder is producing two video layers with labels v1 and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented by v1 and the audio track represented by a1.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Sequence[str]:
        """
        The list of labels that describe how the encoder should multiplex video and audio into an output file. For example, if the encoder is producing two video layers with labels v1 and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented by v1 and the audio track represented by a1.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class PngFormatResponse(dict):
    """
    Describes the settings for producing PNG thumbnails.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filenamePattern":
            suggest = "filename_pattern"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PngFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PngFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PngFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filename_pattern: str,
                 odata_type: str):
        """
        Describes the settings for producing PNG thumbnails.
        :param str filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.PngFormat'.
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.PngFormat')

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> str:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.PngFormat'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class PngImageResponse(dict):
    """
    Describes the properties for producing a series of PNG images from the input video.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "stretchMode":
            suggest = "stretch_mode"
        elif key == "syncMode":
            suggest = "sync_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PngImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PngImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PngImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 start: str,
                 key_frame_interval: Optional[str] = None,
                 label: Optional[str] = None,
                 layers: Optional[Sequence['outputs.PngLayerResponse']] = None,
                 range: Optional[str] = None,
                 step: Optional[str] = None,
                 stretch_mode: Optional[str] = None,
                 sync_mode: Optional[str] = None):
        """
        Describes the properties for producing a series of PNG images from the input video.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.PngImage'.
        :param str start: The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        :param str key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param Sequence['PngLayerResponse'] layers: A collection of output PNG image layers to be produced by the encoder.
        :param str range: The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        :param str step: The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :param str stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param str sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.PngImage')
        pulumi.set(__self__, "start", start)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.PngImage'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def start(self) -> str:
        """
        The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def layers(self) -> Optional[Sequence['outputs.PngLayerResponse']]:
        """
        A collection of output PNG image layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter
    def range(self) -> Optional[str]:
        """
        The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter
    def step(self) -> Optional[str]:
        """
        The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        """
        return pulumi.get(self, "step")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[str]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")


@pulumi.output_type
class PngLayerResponse(dict):
    """
    Describes the settings to produce a PNG image from the input video.
    """
    def __init__(__self__, *,
                 height: Optional[str] = None,
                 label: Optional[str] = None,
                 width: Optional[str] = None):
        """
        Describes the settings to produce a PNG image from the input video.
        :param str height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param str label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param str width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[str]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def width(self) -> Optional[str]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class PresetConfigurationsResponse(dict):
    """
    An object of optional configuration settings for encoder.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interleaveOutput":
            suggest = "interleave_output"
        elif key == "keyFrameIntervalInSeconds":
            suggest = "key_frame_interval_in_seconds"
        elif key == "maxBitrateBps":
            suggest = "max_bitrate_bps"
        elif key == "maxHeight":
            suggest = "max_height"
        elif key == "maxLayers":
            suggest = "max_layers"
        elif key == "minBitrateBps":
            suggest = "min_bitrate_bps"
        elif key == "minHeight":
            suggest = "min_height"
        elif key == "outputFormat":
            suggest = "output_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PresetConfigurationsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PresetConfigurationsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PresetConfigurationsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 complexity: Optional[str] = None,
                 interleave_output: Optional[str] = None,
                 key_frame_interval_in_seconds: Optional[float] = None,
                 max_bitrate_bps: Optional[int] = None,
                 max_height: Optional[int] = None,
                 max_layers: Optional[int] = None,
                 min_bitrate_bps: Optional[int] = None,
                 min_height: Optional[int] = None,
                 output_format: Optional[Any] = None):
        """
        An object of optional configuration settings for encoder.
        :param str complexity: Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
        :param str interleave_output: Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
        :param float key_frame_interval_in_seconds: The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
        :param int max_bitrate_bps: The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for contents with high complexity.
        :param int max_height: The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the input is 4K.
        :param int max_layers: The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced to control the overall cost of the encoding job.
        :param int min_bitrate_bps: The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users with low network bandwidth.
        :param int min_height: The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions like 180P.
        :param Union['CmafFormatResponse', 'ImageFormatResponse', 'JpgFormatResponse', 'Mp4FormatResponse', 'MultiBitrateFormatResponse', 'PngFormatResponse', 'TransportStreamFormatResponse'] output_format: Sets the output format type. Only Mp4Format and CmafFormat are supported in current implementation. Example: set OutputFormat as CmafFormat to produce audio/video stream variant and manifest files for streaming.
        """
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if interleave_output is not None:
            pulumi.set(__self__, "interleave_output", interleave_output)
        if key_frame_interval_in_seconds is not None:
            pulumi.set(__self__, "key_frame_interval_in_seconds", key_frame_interval_in_seconds)
        if max_bitrate_bps is not None:
            pulumi.set(__self__, "max_bitrate_bps", max_bitrate_bps)
        if max_height is not None:
            pulumi.set(__self__, "max_height", max_height)
        if max_layers is not None:
            pulumi.set(__self__, "max_layers", max_layers)
        if min_bitrate_bps is not None:
            pulumi.set(__self__, "min_bitrate_bps", min_bitrate_bps)
        if min_height is not None:
            pulumi.set(__self__, "min_height", min_height)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)

    @property
    @pulumi.getter
    def complexity(self) -> Optional[str]:
        """
        Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
        """
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="interleaveOutput")
    def interleave_output(self) -> Optional[str]:
        """
        Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
        """
        return pulumi.get(self, "interleave_output")

    @property
    @pulumi.getter(name="keyFrameIntervalInSeconds")
    def key_frame_interval_in_seconds(self) -> Optional[float]:
        """
        The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
        """
        return pulumi.get(self, "key_frame_interval_in_seconds")

    @property
    @pulumi.getter(name="maxBitrateBps")
    def max_bitrate_bps(self) -> Optional[int]:
        """
        The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for contents with high complexity.
        """
        return pulumi.get(self, "max_bitrate_bps")

    @property
    @pulumi.getter(name="maxHeight")
    def max_height(self) -> Optional[int]:
        """
        The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the input is 4K.
        """
        return pulumi.get(self, "max_height")

    @property
    @pulumi.getter(name="maxLayers")
    def max_layers(self) -> Optional[int]:
        """
        The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced to control the overall cost of the encoding job.
        """
        return pulumi.get(self, "max_layers")

    @property
    @pulumi.getter(name="minBitrateBps")
    def min_bitrate_bps(self) -> Optional[int]:
        """
        The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users with low network bandwidth.
        """
        return pulumi.get(self, "min_bitrate_bps")

    @property
    @pulumi.getter(name="minHeight")
    def min_height(self) -> Optional[int]:
        """
        The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions like 180P.
        """
        return pulumi.get(self, "min_height")

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[Any]:
        """
        Sets the output format type. Only Mp4Format and CmafFormat are supported in current implementation. Example: set OutputFormat as CmafFormat to produce audio/video stream variant and manifest files for streaming.
        """
        return pulumi.get(self, "output_format")


@pulumi.output_type
class RectangleResponse(dict):
    """
    Describes the properties of a rectangular window applied to the input media before processing it.
    """
    def __init__(__self__, *,
                 height: Optional[str] = None,
                 left: Optional[str] = None,
                 top: Optional[str] = None,
                 width: Optional[str] = None):
        """
        Describes the properties of a rectangular window applied to the input media before processing it.
        :param str height: The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param str left: The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param str top: The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param str width: The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if left is not None:
            pulumi.set(__self__, "left", left)
        if top is not None:
            pulumi.set(__self__, "top", top)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[str]:
        """
        The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def left(self) -> Optional[str]:
        """
        The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "left")

    @property
    @pulumi.getter
    def top(self) -> Optional[str]:
        """
        The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "top")

    @property
    @pulumi.getter
    def width(self) -> Optional[str]:
        """
        The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class SelectAudioTrackByAttributeResponse(dict):
    """
    Select audio tracks from the input by specifying an attribute and an attribute filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "channelMapping":
            suggest = "channel_mapping"
        elif key == "filterValue":
            suggest = "filter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SelectAudioTrackByAttributeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SelectAudioTrackByAttributeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SelectAudioTrackByAttributeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute: str,
                 filter: str,
                 odata_type: str,
                 channel_mapping: Optional[str] = None,
                 filter_value: Optional[str] = None):
        """
        Select audio tracks from the input by specifying an attribute and an attribute filter.
        :param str attribute: The TrackAttribute to filter the tracks by.
        :param str filter: The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectAudioTrackByAttribute'.
        :param str channel_mapping: Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        :param str filter_value: The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectAudioTrackByAttribute')
        if channel_mapping is not None:
            pulumi.set(__self__, "channel_mapping", channel_mapping)
        if filter_value is not None:
            pulumi.set(__self__, "filter_value", filter_value)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The TrackAttribute to filter the tracks by.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectAudioTrackByAttribute'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="channelMapping")
    def channel_mapping(self) -> Optional[str]:
        """
        Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        return pulumi.get(self, "channel_mapping")

    @property
    @pulumi.getter(name="filterValue")
    def filter_value(self) -> Optional[str]:
        """
        The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property.
        """
        return pulumi.get(self, "filter_value")


@pulumi.output_type
class SelectAudioTrackByIdResponse(dict):
    """
    Select audio tracks from the input by specifying a track identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "trackId":
            suggest = "track_id"
        elif key == "channelMapping":
            suggest = "channel_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SelectAudioTrackByIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SelectAudioTrackByIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SelectAudioTrackByIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 track_id: float,
                 channel_mapping: Optional[str] = None):
        """
        Select audio tracks from the input by specifying a track identifier.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectAudioTrackById'.
        :param float track_id: Track identifier to select
        :param str channel_mapping: Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectAudioTrackById')
        pulumi.set(__self__, "track_id", track_id)
        if channel_mapping is not None:
            pulumi.set(__self__, "channel_mapping", channel_mapping)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectAudioTrackById'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="trackId")
    def track_id(self) -> float:
        """
        Track identifier to select
        """
        return pulumi.get(self, "track_id")

    @property
    @pulumi.getter(name="channelMapping")
    def channel_mapping(self) -> Optional[str]:
        """
        Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        return pulumi.get(self, "channel_mapping")


@pulumi.output_type
class SelectVideoTrackByAttributeResponse(dict):
    """
    Select video tracks from the input by specifying an attribute and an attribute filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "filterValue":
            suggest = "filter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SelectVideoTrackByAttributeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SelectVideoTrackByAttributeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SelectVideoTrackByAttributeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute: str,
                 filter: str,
                 odata_type: str,
                 filter_value: Optional[str] = None):
        """
        Select video tracks from the input by specifying an attribute and an attribute filter.
        :param str attribute: The TrackAttribute to filter the tracks by.
        :param str filter: The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectVideoTrackByAttribute'.
        :param str filter_value: The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g: '1500000').  The TrackAttribute.Language is not supported for video tracks.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectVideoTrackByAttribute')
        if filter_value is not None:
            pulumi.set(__self__, "filter_value", filter_value)

    @property
    @pulumi.getter
    def attribute(self) -> str:
        """
        The TrackAttribute to filter the tracks by.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectVideoTrackByAttribute'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="filterValue")
    def filter_value(self) -> Optional[str]:
        """
        The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g: '1500000').  The TrackAttribute.Language is not supported for video tracks.
        """
        return pulumi.get(self, "filter_value")


@pulumi.output_type
class SelectVideoTrackByIdResponse(dict):
    """
    Select video tracks from the input by specifying a track identifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "trackId":
            suggest = "track_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SelectVideoTrackByIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SelectVideoTrackByIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SelectVideoTrackByIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 track_id: float):
        """
        Select video tracks from the input by specifying a track identifier.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectVideoTrackById'.
        :param float track_id: Track identifier to select
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectVideoTrackById')
        pulumi.set(__self__, "track_id", track_id)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectVideoTrackById'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="trackId")
    def track_id(self) -> float:
        """
        Track identifier to select
        """
        return pulumi.get(self, "track_id")


@pulumi.output_type
class StandardEncoderPresetResponse(dict):
    """
    Describes all the settings to be used when encoding the input video with the Standard Encoder.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardEncoderPresetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardEncoderPresetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardEncoderPresetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 codecs: Sequence[Any],
                 formats: Sequence[Any],
                 odata_type: str,
                 filters: Optional['outputs.FiltersResponse'] = None):
        """
        Describes all the settings to be used when encoding the input video with the Standard Encoder.
        :param Sequence[Union['AacAudioResponse', 'AudioResponse', 'CopyAudioResponse', 'CopyVideoResponse', 'DDAudioResponse', 'H264VideoResponse', 'H265VideoResponse', 'ImageResponse', 'JpgImageResponse', 'PngImageResponse', 'VideoResponse']] codecs: The list of codecs to be used when encoding the input video.
        :param Sequence[Union['CmafFormatResponse', 'ImageFormatResponse', 'JpgFormatResponse', 'Mp4FormatResponse', 'MultiBitrateFormatResponse', 'PngFormatResponse', 'TransportStreamFormatResponse']] formats: The list of outputs to be produced by the encoder.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.StandardEncoderPreset'.
        :param 'FiltersResponse' filters: One or more filtering operations that are applied to the input media before encoding.
        """
        pulumi.set(__self__, "codecs", codecs)
        pulumi.set(__self__, "formats", formats)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.StandardEncoderPreset')
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def codecs(self) -> Sequence[Any]:
        """
        The list of codecs to be used when encoding the input video.
        """
        return pulumi.get(self, "codecs")

    @property
    @pulumi.getter
    def formats(self) -> Sequence[Any]:
        """
        The list of outputs to be produced by the encoder.
        """
        return pulumi.get(self, "formats")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.StandardEncoderPreset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def filters(self) -> Optional['outputs.FiltersResponse']:
        """
        One or more filtering operations that are applied to the input media before encoding.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TransformOutputResponse(dict):
    """
    Describes the properties of a TransformOutput, which are the rules to be applied while generating the desired output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onError":
            suggest = "on_error"
        elif key == "relativePriority":
            suggest = "relative_priority"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preset: Any,
                 on_error: Optional[str] = None,
                 relative_priority: Optional[str] = None):
        """
        Describes the properties of a TransformOutput, which are the rules to be applied while generating the desired output.
        :param Union['AudioAnalyzerPresetResponse', 'BuiltInStandardEncoderPresetResponse', 'FaceDetectorPresetResponse', 'StandardEncoderPresetResponse', 'VideoAnalyzerPresetResponse'] preset: Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
        :param str on_error: A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
        :param str relative_priority: Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
        """
        pulumi.set(__self__, "preset", preset)
        if on_error is not None:
            pulumi.set(__self__, "on_error", on_error)
        if relative_priority is not None:
            pulumi.set(__self__, "relative_priority", relative_priority)

    @property
    @pulumi.getter
    def preset(self) -> Any:
        """
        Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
        """
        return pulumi.get(self, "preset")

    @property
    @pulumi.getter(name="onError")
    def on_error(self) -> Optional[str]:
        """
        A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
        """
        return pulumi.get(self, "on_error")

    @property
    @pulumi.getter(name="relativePriority")
    def relative_priority(self) -> Optional[str]:
        """
        Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
        """
        return pulumi.get(self, "relative_priority")


@pulumi.output_type
class TransportStreamFormatResponse(dict):
    """
    Describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC 13818-1) output video file(s).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filenamePattern":
            suggest = "filename_pattern"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "outputFiles":
            suggest = "output_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransportStreamFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransportStreamFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransportStreamFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filename_pattern: str,
                 odata_type: str,
                 output_files: Optional[Sequence['outputs.OutputFileResponse']] = None):
        """
        Describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC 13818-1) output video file(s).
        :param str filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.TransportStreamFormat'.
        :param Sequence['OutputFileResponse'] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.TransportStreamFormat')
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> str:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.TransportStreamFormat'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[Sequence['outputs.OutputFileResponse']]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")


@pulumi.output_type
class UtcClipTimeResponse(dict):
    """
    Specifies the clip time as a Utc time position in the media file.  The Utc time can point to a different position depending on whether the media file starts from a timestamp of zero or not.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UtcClipTimeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UtcClipTimeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UtcClipTimeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 time: str):
        """
        Specifies the clip time as a Utc time position in the media file.  The Utc time can point to a different position depending on whether the media file starts from a timestamp of zero or not.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.UtcClipTime'.
        :param str time: The time position on the timeline of the input media based on Utc time.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.UtcClipTime')
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.UtcClipTime'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        The time position on the timeline of the input media based on Utc time.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class VideoAnalyzerPresetResponse(dict):
    """
    A video analyzer preset that extracts insights (rich metadata) from both audio and video, and outputs a JSON format file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "audioLanguage":
            suggest = "audio_language"
        elif key == "experimentalOptions":
            suggest = "experimental_options"
        elif key == "insightsToExtract":
            suggest = "insights_to_extract"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoAnalyzerPresetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoAnalyzerPresetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoAnalyzerPresetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 audio_language: Optional[str] = None,
                 experimental_options: Optional[Mapping[str, str]] = None,
                 insights_to_extract: Optional[str] = None,
                 mode: Optional[str] = None):
        """
        A video analyzer preset that extracts insights (rich metadata) from both audio and video, and outputs a JSON format file.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoAnalyzerPreset'.
        :param str audio_language: The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        :param Mapping[str, str] experimental_options: Dictionary containing key value pairs for parameters not exposed in the preset itself
        :param str insights_to_extract: Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly', and 'AllInsights'. The default is AllInsights. If you set this to AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only, then only video insights are generated. It is recommended that you not use AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your inputs to be audio only. Your Jobs in such conditions would error out.
        :param str mode: Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoAnalyzerPreset')
        if audio_language is not None:
            pulumi.set(__self__, "audio_language", audio_language)
        if experimental_options is not None:
            pulumi.set(__self__, "experimental_options", experimental_options)
        if insights_to_extract is not None:
            pulumi.set(__self__, "insights_to_extract", insights_to_extract)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoAnalyzerPreset'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="audioLanguage")
    def audio_language(self) -> Optional[str]:
        """
        The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        """
        return pulumi.get(self, "audio_language")

    @property
    @pulumi.getter(name="experimentalOptions")
    def experimental_options(self) -> Optional[Mapping[str, str]]:
        """
        Dictionary containing key value pairs for parameters not exposed in the preset itself
        """
        return pulumi.get(self, "experimental_options")

    @property
    @pulumi.getter(name="insightsToExtract")
    def insights_to_extract(self) -> Optional[str]:
        """
        Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly', and 'AllInsights'. The default is AllInsights. If you set this to AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only, then only video insights are generated. It is recommended that you not use AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your inputs to be audio only. Your Jobs in such conditions would error out.
        """
        return pulumi.get(self, "insights_to_extract")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class VideoOverlayResponse(dict):
    """
    Describes the properties of a video overlay.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputLabel":
            suggest = "input_label"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "audioGainLevel":
            suggest = "audio_gain_level"
        elif key == "cropRectangle":
            suggest = "crop_rectangle"
        elif key == "fadeInDuration":
            suggest = "fade_in_duration"
        elif key == "fadeOutDuration":
            suggest = "fade_out_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoOverlayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoOverlayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoOverlayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_label: str,
                 odata_type: str,
                 audio_gain_level: Optional[float] = None,
                 crop_rectangle: Optional['outputs.RectangleResponse'] = None,
                 end: Optional[str] = None,
                 fade_in_duration: Optional[str] = None,
                 fade_out_duration: Optional[str] = None,
                 opacity: Optional[float] = None,
                 position: Optional['outputs.RectangleResponse'] = None,
                 start: Optional[str] = None):
        """
        Describes the properties of a video overlay.
        :param str input_label: The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoOverlay'.
        :param float audio_gain_level: The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        :param 'RectangleResponse' crop_rectangle: An optional rectangular window used to crop the overlay image or video.
        :param str end: The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        :param str fade_in_duration: The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        :param str fade_out_duration: The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        :param float opacity: The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
        :param 'RectangleResponse' position: The location in the input video where the overlay is applied.
        :param str start: The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        pulumi.set(__self__, "input_label", input_label)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoOverlay')
        if audio_gain_level is not None:
            pulumi.set(__self__, "audio_gain_level", audio_gain_level)
        if crop_rectangle is not None:
            pulumi.set(__self__, "crop_rectangle", crop_rectangle)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if fade_in_duration is not None:
            pulumi.set(__self__, "fade_in_duration", fade_in_duration)
        if fade_out_duration is not None:
            pulumi.set(__self__, "fade_out_duration", fade_out_duration)
        if opacity is not None:
            pulumi.set(__self__, "opacity", opacity)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="inputLabel")
    def input_label(self) -> str:
        """
        The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        """
        return pulumi.get(self, "input_label")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoOverlay'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="audioGainLevel")
    def audio_gain_level(self) -> Optional[float]:
        """
        The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        """
        return pulumi.get(self, "audio_gain_level")

    @property
    @pulumi.getter(name="cropRectangle")
    def crop_rectangle(self) -> Optional['outputs.RectangleResponse']:
        """
        An optional rectangular window used to crop the overlay image or video.
        """
        return pulumi.get(self, "crop_rectangle")

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter(name="fadeInDuration")
    def fade_in_duration(self) -> Optional[str]:
        """
        The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        """
        return pulumi.get(self, "fade_in_duration")

    @property
    @pulumi.getter(name="fadeOutDuration")
    def fade_out_duration(self) -> Optional[str]:
        """
        The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        """
        return pulumi.get(self, "fade_out_duration")

    @property
    @pulumi.getter
    def opacity(self) -> Optional[float]:
        """
        The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
        """
        return pulumi.get(self, "opacity")

    @property
    @pulumi.getter
    def position(self) -> Optional['outputs.RectangleResponse']:
        """
        The location in the input video where the overlay is applied.
        """
        return pulumi.get(self, "position")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class VideoResponse(dict):
    """
    Describes the basic properties for encoding the input video.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "stretchMode":
            suggest = "stretch_mode"
        elif key == "syncMode":
            suggest = "sync_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 key_frame_interval: Optional[str] = None,
                 label: Optional[str] = None,
                 stretch_mode: Optional[str] = None,
                 sync_mode: Optional[str] = None):
        """
        Describes the basic properties for encoding the input video.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Video'.
        :param str key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param str label: An optional label for the codec. The label can be used to control muxing behavior.
        :param str stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param str sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Video')
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Video'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[str]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")


@pulumi.output_type
class VideoTrackDescriptorResponse(dict):
    """
    A TrackSelection to select video tracks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoTrackDescriptorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoTrackDescriptorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoTrackDescriptorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        A TrackSelection to select video tracks.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoTrackDescriptor'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoTrackDescriptor')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoTrackDescriptor'.
        """
        return pulumi.get(self, "odata_type")


