# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetActionResult',
    'AwaitableGetActionResult',
    'get_action',
    'get_action_output',
]

@pulumi.output_type
class GetActionResult:
    """
    Action for alert rule.
    """
    def __init__(__self__, etag=None, id=None, logic_app_resource_id=None, name=None, system_data=None, type=None, workflow_id=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if logic_app_resource_id and not isinstance(logic_app_resource_id, str):
            raise TypeError("Expected argument 'logic_app_resource_id' to be a str")
        pulumi.set(__self__, "logic_app_resource_id", logic_app_resource_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if workflow_id and not isinstance(workflow_id, str):
            raise TypeError("Expected argument 'workflow_id' to be a str")
        pulumi.set(__self__, "workflow_id", workflow_id)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Etag of the action.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logicAppResourceId")
    def logic_app_resource_id(self) -> str:
        """
        Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
        """
        return pulumi.get(self, "logic_app_resource_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> Optional[str]:
        """
        The name of the logic app's workflow.
        """
        return pulumi.get(self, "workflow_id")


class AwaitableGetActionResult(GetActionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActionResult(
            etag=self.etag,
            id=self.id,
            logic_app_resource_id=self.logic_app_resource_id,
            name=self.name,
            system_data=self.system_data,
            type=self.type,
            workflow_id=self.workflow_id)


def get_action(action_id: Optional[str] = None,
               resource_group_name: Optional[str] = None,
               rule_id: Optional[str] = None,
               workspace_name: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActionResult:
    """
    Action for alert rule.


    :param str action_id: Action ID
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str rule_id: Alert rule ID
    :param str workspace_name: The name of the workspace.
    """
    __args__ = dict()
    __args__['actionId'] = action_id
    __args__['resourceGroupName'] = resource_group_name
    __args__['ruleId'] = rule_id
    __args__['workspaceName'] = workspace_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:securityinsights/v20230201:getAction', __args__, opts=opts, typ=GetActionResult).value

    return AwaitableGetActionResult(
        etag=__ret__.etag,
        id=__ret__.id,
        logic_app_resource_id=__ret__.logic_app_resource_id,
        name=__ret__.name,
        system_data=__ret__.system_data,
        type=__ret__.type,
        workflow_id=__ret__.workflow_id)


@_utilities.lift_output_func(get_action)
def get_action_output(action_id: Optional[pulumi.Input[str]] = None,
                      resource_group_name: Optional[pulumi.Input[str]] = None,
                      rule_id: Optional[pulumi.Input[str]] = None,
                      workspace_name: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetActionResult]:
    """
    Action for alert rule.


    :param str action_id: Action ID
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str rule_id: Alert rule ID
    :param str workspace_name: The name of the workspace.
    """
    ...
