# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdministrativeCredentialsResponse',
    'BareMetalMachineConfigurationDataResponse',
    'BgpPeerResponse',
    'ClusterAvailableUpgradeVersionResponse',
    'ClusterAvailableVersionResponse',
    'ClusterCapacityResponse',
    'CniBgpConfigurationResponse',
    'CommunityAdvertisementResponse',
    'EgressEndpointResponse',
    'EndpointDependencyResponse',
    'ExtendedLocationResponse',
    'HardwareInventoryNetworkInterfaceResponse',
    'HardwareInventoryResponse',
    'HardwareValidationStatusResponse',
    'ImageRepositoryCredentialsResponse',
    'KeySetUserResponse',
    'KeySetUserStatusResponse',
    'LldpNeighborResponse',
    'ManagedResourceGroupConfigurationResponse',
    'NetworkAttachmentResponse',
    'NicResponse',
    'NodeConfigurationResponse',
    'NodeResponse',
    'OsDiskResponse',
    'RackDefinitionResponse',
    'ServicePrincipalInformationResponse',
    'SshPublicKeyResponse',
    'StorageApplianceConfigurationDataResponse',
    'StorageProfileResponse',
    'SystemDataResponse',
    'ValidationThresholdResponse',
    'VirtualMachinePlacementHintResponse',
]

@pulumi.output_type
class AdministrativeCredentialsResponse(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The password of the administrator of the device used during initialization.
        :param str username: The username of the administrator of the device used during initialization.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password of the administrator of the device used during initialization.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username of the administrator of the device used during initialization.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class BareMetalMachineConfigurationDataResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bmcConnectionString":
            suggest = "bmc_connection_string"
        elif key == "bmcCredentials":
            suggest = "bmc_credentials"
        elif key == "bmcMacAddress":
            suggest = "bmc_mac_address"
        elif key == "bootMacAddress":
            suggest = "boot_mac_address"
        elif key == "rackSlot":
            suggest = "rack_slot"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "machineDetails":
            suggest = "machine_details"
        elif key == "machineName":
            suggest = "machine_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BareMetalMachineConfigurationDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BareMetalMachineConfigurationDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BareMetalMachineConfigurationDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bmc_connection_string: str,
                 bmc_credentials: 'outputs.AdministrativeCredentialsResponse',
                 bmc_mac_address: str,
                 boot_mac_address: str,
                 rack_slot: float,
                 serial_number: str,
                 machine_details: Optional[str] = None,
                 machine_name: Optional[str] = None):
        """
        :param str bmc_connection_string: The connection string for the baseboard management controller including IP address and protocol.
        :param str bmc_mac_address: The MAC address of the BMC for this machine.
        :param str boot_mac_address: The MAC address associated with the PXE NIC card.
        :param float rack_slot: The slot the physical machine is in the rack based on the BOM configuration.
        :param str serial_number: The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag.
        :param str machine_details: The free-form additional information about the machine, e.g. an asset tag.
        :param str machine_name: The user-provided name for the bare metal machine created from this specification.
               If not provided, the machine name will be generated programmatically.
        """
        pulumi.set(__self__, "bmc_connection_string", bmc_connection_string)
        pulumi.set(__self__, "bmc_credentials", bmc_credentials)
        pulumi.set(__self__, "bmc_mac_address", bmc_mac_address)
        pulumi.set(__self__, "boot_mac_address", boot_mac_address)
        pulumi.set(__self__, "rack_slot", rack_slot)
        pulumi.set(__self__, "serial_number", serial_number)
        if machine_details is not None:
            pulumi.set(__self__, "machine_details", machine_details)
        if machine_name is not None:
            pulumi.set(__self__, "machine_name", machine_name)

    @property
    @pulumi.getter(name="bmcConnectionString")
    def bmc_connection_string(self) -> str:
        """
        The connection string for the baseboard management controller including IP address and protocol.
        """
        return pulumi.get(self, "bmc_connection_string")

    @property
    @pulumi.getter(name="bmcCredentials")
    def bmc_credentials(self) -> 'outputs.AdministrativeCredentialsResponse':
        return pulumi.get(self, "bmc_credentials")

    @property
    @pulumi.getter(name="bmcMacAddress")
    def bmc_mac_address(self) -> str:
        """
        The MAC address of the BMC for this machine.
        """
        return pulumi.get(self, "bmc_mac_address")

    @property
    @pulumi.getter(name="bootMacAddress")
    def boot_mac_address(self) -> str:
        """
        The MAC address associated with the PXE NIC card.
        """
        return pulumi.get(self, "boot_mac_address")

    @property
    @pulumi.getter(name="rackSlot")
    def rack_slot(self) -> float:
        """
        The slot the physical machine is in the rack based on the BOM configuration.
        """
        return pulumi.get(self, "rack_slot")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="machineDetails")
    def machine_details(self) -> Optional[str]:
        """
        The free-form additional information about the machine, e.g. an asset tag.
        """
        return pulumi.get(self, "machine_details")

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> Optional[str]:
        """
        The user-provided name for the bare metal machine created from this specification.
        If not provided, the machine name will be generated programmatically.
        """
        return pulumi.get(self, "machine_name")


@pulumi.output_type
class BgpPeerResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "asNumber":
            suggest = "as_number"
        elif key == "peerIp":
            suggest = "peer_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BgpPeerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BgpPeerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BgpPeerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 as_number: float,
                 peer_ip: str):
        """
        :param float as_number: The ASN (Autonomous System Number) of the BGP peer.
        :param str peer_ip: The IPv4 or IPv6 address to peer with the associated CNI Network. The IP version type will drive a peering with the same version type from the Default CNI Network. For example, IPv4 to IPv4 or IPv6 to IPv6.
        """
        pulumi.set(__self__, "as_number", as_number)
        pulumi.set(__self__, "peer_ip", peer_ip)

    @property
    @pulumi.getter(name="asNumber")
    def as_number(self) -> float:
        """
        The ASN (Autonomous System Number) of the BGP peer.
        """
        return pulumi.get(self, "as_number")

    @property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> str:
        """
        The IPv4 or IPv6 address to peer with the associated CNI Network. The IP version type will drive a peering with the same version type from the Default CNI Network. For example, IPv4 to IPv4 or IPv6 to IPv6.
        """
        return pulumi.get(self, "peer_ip")


@pulumi.output_type
class ClusterAvailableUpgradeVersionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "controlImpact":
            suggest = "control_impact"
        elif key == "expectedDuration":
            suggest = "expected_duration"
        elif key == "impactDescription":
            suggest = "impact_description"
        elif key == "supportExpiryDate":
            suggest = "support_expiry_date"
        elif key == "targetClusterVersion":
            suggest = "target_cluster_version"
        elif key == "workloadImpact":
            suggest = "workload_impact"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAvailableUpgradeVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAvailableUpgradeVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAvailableUpgradeVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 control_impact: str,
                 expected_duration: str,
                 impact_description: str,
                 support_expiry_date: str,
                 target_cluster_version: str,
                 workload_impact: str):
        """
        :param str control_impact: The indicator of whether the control plane will be impacted during the upgrade.
        :param str expected_duration: The expected duration needed for this upgrade.
        :param str impact_description: The impact description including the specific details and release notes.
        :param str support_expiry_date: The last date the version of the platform is supported.
        :param str target_cluster_version: The target version this cluster will be upgraded to.
        :param str workload_impact: The indicator of whether the workload will be impacted during the upgrade.
        """
        pulumi.set(__self__, "control_impact", control_impact)
        pulumi.set(__self__, "expected_duration", expected_duration)
        pulumi.set(__self__, "impact_description", impact_description)
        pulumi.set(__self__, "support_expiry_date", support_expiry_date)
        pulumi.set(__self__, "target_cluster_version", target_cluster_version)
        pulumi.set(__self__, "workload_impact", workload_impact)

    @property
    @pulumi.getter(name="controlImpact")
    def control_impact(self) -> str:
        """
        The indicator of whether the control plane will be impacted during the upgrade.
        """
        return pulumi.get(self, "control_impact")

    @property
    @pulumi.getter(name="expectedDuration")
    def expected_duration(self) -> str:
        """
        The expected duration needed for this upgrade.
        """
        return pulumi.get(self, "expected_duration")

    @property
    @pulumi.getter(name="impactDescription")
    def impact_description(self) -> str:
        """
        The impact description including the specific details and release notes.
        """
        return pulumi.get(self, "impact_description")

    @property
    @pulumi.getter(name="supportExpiryDate")
    def support_expiry_date(self) -> str:
        """
        The last date the version of the platform is supported.
        """
        return pulumi.get(self, "support_expiry_date")

    @property
    @pulumi.getter(name="targetClusterVersion")
    def target_cluster_version(self) -> str:
        """
        The target version this cluster will be upgraded to.
        """
        return pulumi.get(self, "target_cluster_version")

    @property
    @pulumi.getter(name="workloadImpact")
    def workload_impact(self) -> str:
        """
        The indicator of whether the workload will be impacted during the upgrade.
        """
        return pulumi.get(self, "workload_impact")


@pulumi.output_type
class ClusterAvailableVersionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supportExpiryDate":
            suggest = "support_expiry_date"
        elif key == "targetClusterVersion":
            suggest = "target_cluster_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAvailableVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAvailableVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAvailableVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 support_expiry_date: str,
                 target_cluster_version: str):
        """
        :param str support_expiry_date: The last date the version of the platform is supported.
        :param str target_cluster_version: The version of the cluster to be deployed.
        """
        pulumi.set(__self__, "support_expiry_date", support_expiry_date)
        pulumi.set(__self__, "target_cluster_version", target_cluster_version)

    @property
    @pulumi.getter(name="supportExpiryDate")
    def support_expiry_date(self) -> str:
        """
        The last date the version of the platform is supported.
        """
        return pulumi.get(self, "support_expiry_date")

    @property
    @pulumi.getter(name="targetClusterVersion")
    def target_cluster_version(self) -> str:
        """
        The version of the cluster to be deployed.
        """
        return pulumi.get(self, "target_cluster_version")


@pulumi.output_type
class ClusterCapacityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableApplianceStorageGB":
            suggest = "available_appliance_storage_gb"
        elif key == "availableCoreCount":
            suggest = "available_core_count"
        elif key == "availableHostStorageGB":
            suggest = "available_host_storage_gb"
        elif key == "availableMemoryGB":
            suggest = "available_memory_gb"
        elif key == "totalApplianceStorageGB":
            suggest = "total_appliance_storage_gb"
        elif key == "totalCoreCount":
            suggest = "total_core_count"
        elif key == "totalHostStorageGB":
            suggest = "total_host_storage_gb"
        elif key == "totalMemoryGB":
            suggest = "total_memory_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCapacityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCapacityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCapacityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_appliance_storage_gb: Optional[float] = None,
                 available_core_count: Optional[float] = None,
                 available_host_storage_gb: Optional[float] = None,
                 available_memory_gb: Optional[float] = None,
                 total_appliance_storage_gb: Optional[float] = None,
                 total_core_count: Optional[float] = None,
                 total_host_storage_gb: Optional[float] = None,
                 total_memory_gb: Optional[float] = None):
        """
        :param float available_appliance_storage_gb: The remaining appliance-based storage in GB available for workload use.
        :param float available_core_count: The remaining number of cores that are available in this cluster for workload use.
        :param float available_host_storage_gb: The remaining machine or host-based storage in GB available for workload use.
        :param float available_memory_gb: The remaining memory in GB that are available in this cluster for workload use.
        :param float total_appliance_storage_gb: The total appliance-based storage in GB supported by this cluster for workload use.
        :param float total_core_count: The total number of cores that are supported by this cluster for workload use.
        :param float total_host_storage_gb: The total machine or host-based storage in GB supported by this cluster for workload use.
        :param float total_memory_gb: The total memory supported by this cluster for workload use.
        """
        if available_appliance_storage_gb is not None:
            pulumi.set(__self__, "available_appliance_storage_gb", available_appliance_storage_gb)
        if available_core_count is not None:
            pulumi.set(__self__, "available_core_count", available_core_count)
        if available_host_storage_gb is not None:
            pulumi.set(__self__, "available_host_storage_gb", available_host_storage_gb)
        if available_memory_gb is not None:
            pulumi.set(__self__, "available_memory_gb", available_memory_gb)
        if total_appliance_storage_gb is not None:
            pulumi.set(__self__, "total_appliance_storage_gb", total_appliance_storage_gb)
        if total_core_count is not None:
            pulumi.set(__self__, "total_core_count", total_core_count)
        if total_host_storage_gb is not None:
            pulumi.set(__self__, "total_host_storage_gb", total_host_storage_gb)
        if total_memory_gb is not None:
            pulumi.set(__self__, "total_memory_gb", total_memory_gb)

    @property
    @pulumi.getter(name="availableApplianceStorageGB")
    def available_appliance_storage_gb(self) -> Optional[float]:
        """
        The remaining appliance-based storage in GB available for workload use.
        """
        return pulumi.get(self, "available_appliance_storage_gb")

    @property
    @pulumi.getter(name="availableCoreCount")
    def available_core_count(self) -> Optional[float]:
        """
        The remaining number of cores that are available in this cluster for workload use.
        """
        return pulumi.get(self, "available_core_count")

    @property
    @pulumi.getter(name="availableHostStorageGB")
    def available_host_storage_gb(self) -> Optional[float]:
        """
        The remaining machine or host-based storage in GB available for workload use.
        """
        return pulumi.get(self, "available_host_storage_gb")

    @property
    @pulumi.getter(name="availableMemoryGB")
    def available_memory_gb(self) -> Optional[float]:
        """
        The remaining memory in GB that are available in this cluster for workload use.
        """
        return pulumi.get(self, "available_memory_gb")

    @property
    @pulumi.getter(name="totalApplianceStorageGB")
    def total_appliance_storage_gb(self) -> Optional[float]:
        """
        The total appliance-based storage in GB supported by this cluster for workload use.
        """
        return pulumi.get(self, "total_appliance_storage_gb")

    @property
    @pulumi.getter(name="totalCoreCount")
    def total_core_count(self) -> Optional[float]:
        """
        The total number of cores that are supported by this cluster for workload use.
        """
        return pulumi.get(self, "total_core_count")

    @property
    @pulumi.getter(name="totalHostStorageGB")
    def total_host_storage_gb(self) -> Optional[float]:
        """
        The total machine or host-based storage in GB supported by this cluster for workload use.
        """
        return pulumi.get(self, "total_host_storage_gb")

    @property
    @pulumi.getter(name="totalMemoryGB")
    def total_memory_gb(self) -> Optional[float]:
        """
        The total memory supported by this cluster for workload use.
        """
        return pulumi.get(self, "total_memory_gb")


@pulumi.output_type
class CniBgpConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bgpPeers":
            suggest = "bgp_peers"
        elif key == "communityAdvertisements":
            suggest = "community_advertisements"
        elif key == "serviceExternalPrefixes":
            suggest = "service_external_prefixes"
        elif key == "serviceLoadBalancerPrefixes":
            suggest = "service_load_balancer_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CniBgpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CniBgpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CniBgpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bgp_peers: Optional[Sequence['outputs.BgpPeerResponse']] = None,
                 community_advertisements: Optional[Sequence['outputs.CommunityAdvertisementResponse']] = None,
                 service_external_prefixes: Optional[Sequence[str]] = None,
                 service_load_balancer_prefixes: Optional[Sequence[str]] = None):
        """
        :param Sequence['BgpPeerResponse'] bgp_peers: The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
        :param Sequence['CommunityAdvertisementResponse'] community_advertisements: The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
               communities that should be associated with that prefix when it is announced.
        :param Sequence[str] service_external_prefixes: The subnet blocks in CIDR format for Kubernetes service external IPs to be advertised over BGP.
        :param Sequence[str] service_load_balancer_prefixes: The subnet blocks in CIDR format for Kubernetes load balancers. Load balancer IPs will only be advertised if they
               are within one of these blocks.
        """
        if bgp_peers is not None:
            pulumi.set(__self__, "bgp_peers", bgp_peers)
        if community_advertisements is not None:
            pulumi.set(__self__, "community_advertisements", community_advertisements)
        if service_external_prefixes is not None:
            pulumi.set(__self__, "service_external_prefixes", service_external_prefixes)
        if service_load_balancer_prefixes is not None:
            pulumi.set(__self__, "service_load_balancer_prefixes", service_load_balancer_prefixes)

    @property
    @pulumi.getter(name="bgpPeers")
    def bgp_peers(self) -> Optional[Sequence['outputs.BgpPeerResponse']]:
        """
        The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
        """
        return pulumi.get(self, "bgp_peers")

    @property
    @pulumi.getter(name="communityAdvertisements")
    def community_advertisements(self) -> Optional[Sequence['outputs.CommunityAdvertisementResponse']]:
        """
        The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
        communities that should be associated with that prefix when it is announced.
        """
        return pulumi.get(self, "community_advertisements")

    @property
    @pulumi.getter(name="serviceExternalPrefixes")
    def service_external_prefixes(self) -> Optional[Sequence[str]]:
        """
        The subnet blocks in CIDR format for Kubernetes service external IPs to be advertised over BGP.
        """
        return pulumi.get(self, "service_external_prefixes")

    @property
    @pulumi.getter(name="serviceLoadBalancerPrefixes")
    def service_load_balancer_prefixes(self) -> Optional[Sequence[str]]:
        """
        The subnet blocks in CIDR format for Kubernetes load balancers. Load balancer IPs will only be advertised if they
        are within one of these blocks.
        """
        return pulumi.get(self, "service_load_balancer_prefixes")


@pulumi.output_type
class CommunityAdvertisementResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetPrefix":
            suggest = "subnet_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommunityAdvertisementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommunityAdvertisementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommunityAdvertisementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 communities: Sequence[str],
                 subnet_prefix: str):
        """
        :param Sequence[str] communities: The list of community strings to announce with this prefix.
        :param str subnet_prefix: The subnet in CIDR format for which properties should be advertised.
        """
        pulumi.set(__self__, "communities", communities)
        pulumi.set(__self__, "subnet_prefix", subnet_prefix)

    @property
    @pulumi.getter
    def communities(self) -> Sequence[str]:
        """
        The list of community strings to announce with this prefix.
        """
        return pulumi.get(self, "communities")

    @property
    @pulumi.getter(name="subnetPrefix")
    def subnet_prefix(self) -> str:
        """
        The subnet in CIDR format for which properties should be advertised.
        """
        return pulumi.get(self, "subnet_prefix")


@pulumi.output_type
class EgressEndpointResponse(dict):
    def __init__(__self__, *,
                 category: str,
                 endpoints: Sequence['outputs.EndpointDependencyResponse']):
        """
        :param str category: The descriptive category name of endpoints accessible by the AKS agent node. For example, azure-resource-management, API server, etc. The platform egress endpoints provided by default will use the category 'default'.
        :param Sequence['EndpointDependencyResponse'] endpoints: The list of endpoint dependencies.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "endpoints", endpoints)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The descriptive category name of endpoints accessible by the AKS agent node. For example, azure-resource-management, API server, etc. The platform egress endpoints provided by default will use the category 'default'.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.EndpointDependencyResponse']:
        """
        The list of endpoint dependencies.
        """
        return pulumi.get(self, "endpoints")


@pulumi.output_type
class EndpointDependencyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointDependencyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointDependencyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointDependencyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: str,
                 port: Optional[float] = None):
        """
        :param str domain_name: The domain name of the dependency.
        :param float port: The port of this endpoint.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The domain name of the dependency.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The port of this endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        :param str name: The resource ID of the extended location on which the resource will be created.
        :param str type: The extended location type, for example, CustomLocation.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource ID of the extended location on which the resource will be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The extended location type, for example, CustomLocation.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HardwareInventoryNetworkInterfaceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkStatus":
            suggest = "link_status"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "networkInterfaceId":
            suggest = "network_interface_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HardwareInventoryNetworkInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HardwareInventoryNetworkInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HardwareInventoryNetworkInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 link_status: str,
                 mac_address: str,
                 name: str,
                 network_interface_id: str):
        """
        :param str link_status: The current status of the link.
        :param str mac_address: The MAC address associated with this interface.
        :param str name: The name of the interface.
        :param str network_interface_id: The resource ID of the network interface for the port on the switch that this machine's interface is connected to.
        """
        pulumi.set(__self__, "link_status", link_status)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_interface_id", network_interface_id)

    @property
    @pulumi.getter(name="linkStatus")
    def link_status(self) -> str:
        """
        The current status of the link.
        """
        return pulumi.get(self, "link_status")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        """
        The MAC address associated with this interface.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the interface.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> str:
        """
        The resource ID of the network interface for the port on the switch that this machine's interface is connected to.
        """
        return pulumi.get(self, "network_interface_id")


@pulumi.output_type
class HardwareInventoryResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalHostInformation":
            suggest = "additional_host_information"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HardwareInventoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HardwareInventoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HardwareInventoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_host_information: str,
                 interfaces: Sequence['outputs.HardwareInventoryNetworkInterfaceResponse'],
                 nics: Sequence['outputs.NicResponse']):
        """
        :param str additional_host_information: Freeform data extracted from the environment about this machine. This information varies depending on the specific hardware and configuration.
        :param Sequence['HardwareInventoryNetworkInterfaceResponse'] interfaces: The list of network interfaces and associated details for the bare metal machine.
        :param Sequence['NicResponse'] nics: Field Deprecated. Will be removed in an upcoming version. The list of network interface cards and associated details for the bare metal machine.
        """
        pulumi.set(__self__, "additional_host_information", additional_host_information)
        pulumi.set(__self__, "interfaces", interfaces)
        pulumi.set(__self__, "nics", nics)

    @property
    @pulumi.getter(name="additionalHostInformation")
    def additional_host_information(self) -> str:
        """
        Freeform data extracted from the environment about this machine. This information varies depending on the specific hardware and configuration.
        """
        return pulumi.get(self, "additional_host_information")

    @property
    @pulumi.getter
    def interfaces(self) -> Sequence['outputs.HardwareInventoryNetworkInterfaceResponse']:
        """
        The list of network interfaces and associated details for the bare metal machine.
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter
    def nics(self) -> Sequence['outputs.NicResponse']:
        """
        Field Deprecated. Will be removed in an upcoming version. The list of network interface cards and associated details for the bare metal machine.
        """
        return pulumi.get(self, "nics")


@pulumi.output_type
class HardwareValidationStatusResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastValidationTime":
            suggest = "last_validation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HardwareValidationStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HardwareValidationStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HardwareValidationStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_validation_time: str,
                 result: str):
        """
        :param str last_validation_time: The timestamp of the hardware validation execution.
        :param str result: The outcome of the hardware validation.
        """
        pulumi.set(__self__, "last_validation_time", last_validation_time)
        pulumi.set(__self__, "result", result)

    @property
    @pulumi.getter(name="lastValidationTime")
    def last_validation_time(self) -> str:
        """
        The timestamp of the hardware validation execution.
        """
        return pulumi.get(self, "last_validation_time")

    @property
    @pulumi.getter
    def result(self) -> str:
        """
        The outcome of the hardware validation.
        """
        return pulumi.get(self, "result")


@pulumi.output_type
class ImageRepositoryCredentialsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryUrl":
            suggest = "registry_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageRepositoryCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageRepositoryCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageRepositoryCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 registry_url: str,
                 username: str):
        """
        :param str password: The password or token used to access an image in the target repository.
        :param str registry_url: The URL of the authentication server used to validate the repository credentials.
        :param str username: The username used to access an image in the target repository.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "registry_url", registry_url)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password or token used to access an image in the target repository.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="registryUrl")
    def registry_url(self) -> str:
        """
        The URL of the authentication server used to validate the repository credentials.
        """
        return pulumi.get(self, "registry_url")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username used to access an image in the target repository.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class KeySetUserResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureUserName":
            suggest = "azure_user_name"
        elif key == "sshPublicKey":
            suggest = "ssh_public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeySetUserResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeySetUserResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeySetUserResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_user_name: str,
                 ssh_public_key: 'outputs.SshPublicKeyResponse',
                 description: Optional[str] = None):
        """
        :param str azure_user_name: The Azure Active Directory user name (email name).
        :param str description: The free-form description for this user.
        """
        pulumi.set(__self__, "azure_user_name", azure_user_name)
        pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="azureUserName")
    def azure_user_name(self) -> str:
        """
        The Azure Active Directory user name (email name).
        """
        return pulumi.get(self, "azure_user_name")

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> 'outputs.SshPublicKeyResponse':
        return pulumi.get(self, "ssh_public_key")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The free-form description for this user.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class KeySetUserStatusResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureUserName":
            suggest = "azure_user_name"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeySetUserStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeySetUserStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeySetUserStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_user_name: str,
                 status: str,
                 status_message: str):
        """
        :param str azure_user_name: The Azure Active Directory user name (email name).
        :param str status: The indicator of whether the user is currently deployed for access.
        :param str status_message: The additional information describing the current status of this user, if any available.
        """
        pulumi.set(__self__, "azure_user_name", azure_user_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="azureUserName")
    def azure_user_name(self) -> str:
        """
        The Azure Active Directory user name (email name).
        """
        return pulumi.get(self, "azure_user_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The indicator of whether the user is currently deployed for access.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        The additional information describing the current status of this user, if any available.
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class LldpNeighborResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portDescription":
            suggest = "port_description"
        elif key == "portName":
            suggest = "port_name"
        elif key == "systemDescription":
            suggest = "system_description"
        elif key == "systemName":
            suggest = "system_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LldpNeighborResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LldpNeighborResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LldpNeighborResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port_description: str,
                 port_name: str,
                 system_description: str,
                 system_name: str):
        """
        :param str port_description: The descriptive information about the port on the connected device.
        :param str port_name: The system-assigned name of the port on the connected device.
        :param str system_description: The descriptive information about the connected device.
        :param str system_name: The system-assigned name of the connected device.
        """
        pulumi.set(__self__, "port_description", port_description)
        pulumi.set(__self__, "port_name", port_name)
        pulumi.set(__self__, "system_description", system_description)
        pulumi.set(__self__, "system_name", system_name)

    @property
    @pulumi.getter(name="portDescription")
    def port_description(self) -> str:
        """
        The descriptive information about the port on the connected device.
        """
        return pulumi.get(self, "port_description")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> str:
        """
        The system-assigned name of the port on the connected device.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="systemDescription")
    def system_description(self) -> str:
        """
        The descriptive information about the connected device.
        """
        return pulumi.get(self, "system_description")

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> str:
        """
        The system-assigned name of the connected device.
        """
        return pulumi.get(self, "system_name")


@pulumi.output_type
class ManagedResourceGroupConfigurationResponse(dict):
    def __init__(__self__, *,
                 location: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str location: The location of the managed resource group. If not specified, the location of the parent resource is chosen.
        :param str name: The name for the managed resource group. If not specified, the unique name is automatically generated.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location of the managed resource group. If not specified, the location of the parent resource is chosen.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name for the managed resource group. If not specified, the unique name is automatically generated.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NetworkAttachmentResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attachedNetworkId":
            suggest = "attached_network_id"
        elif key == "ipAllocationMethod":
            suggest = "ip_allocation_method"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "defaultGateway":
            suggest = "default_gateway"
        elif key == "ipv4Address":
            suggest = "ipv4_address"
        elif key == "ipv6Address":
            suggest = "ipv6_address"
        elif key == "networkAttachmentName":
            suggest = "network_attachment_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAttachmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAttachmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAttachmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attached_network_id: str,
                 ip_allocation_method: str,
                 mac_address: str,
                 default_gateway: Optional[str] = None,
                 ipv4_address: Optional[str] = None,
                 ipv6_address: Optional[str] = None,
                 network_attachment_name: Optional[str] = None):
        """
        :param str attached_network_id: The resource ID of the associated network attached to the virtual machine.
               It can be one of cloudServicesNetwork, l3Network, l2Network or trunkedNetwork resources.
        :param str ip_allocation_method: The IP allocation mechanism for the virtual machine.
               Dynamic and Static are only valid for l3Network which may also specify Disabled.
               Otherwise, Disabled is the only permitted value.
        :param str mac_address: The MAC address of the interface for the virtual machine that corresponds to this network attachment.
        :param str default_gateway: The indicator of whether this is the default gateway.
               Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
        :param str ipv4_address: The IPv4 address of the virtual machine.
               
               This field is used only if the attached network has IPAllocationType of IPV4 or DualStack.
               
               If IPAllocationMethod is:
               Static - this field must contain a user specified IPv4 address from within the subnet specified in the attached network.
               Dynamic - this field is read-only, but will be populated with an address from within the subnet specified in the attached network.
               Disabled - this field will be empty.
        :param str ipv6_address: The IPv6 address of the virtual machine.
               
               This field is used only if the attached network has IPAllocationType of IPV6 or DualStack.
               
               If IPAllocationMethod is:
               Static - this field must contain an IPv6 address range from within the range specified in the attached network.
               Dynamic - this field is read-only, but will be populated with an range from within the subnet specified in the attached network.
               Disabled - this field will be empty.
        :param str network_attachment_name: The associated network's interface name.
               If specified, the network attachment name has a maximum length of 15 characters and must be unique to this virtual machine.
               If the user doesn’t specify this value, the default interface name of the network resource will be used.
               For a CloudServicesNetwork resource, this name will be ignored.
        """
        pulumi.set(__self__, "attached_network_id", attached_network_id)
        pulumi.set(__self__, "ip_allocation_method", ip_allocation_method)
        pulumi.set(__self__, "mac_address", mac_address)
        if default_gateway is not None:
            pulumi.set(__self__, "default_gateway", default_gateway)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if network_attachment_name is not None:
            pulumi.set(__self__, "network_attachment_name", network_attachment_name)

    @property
    @pulumi.getter(name="attachedNetworkId")
    def attached_network_id(self) -> str:
        """
        The resource ID of the associated network attached to the virtual machine.
        It can be one of cloudServicesNetwork, l3Network, l2Network or trunkedNetwork resources.
        """
        return pulumi.get(self, "attached_network_id")

    @property
    @pulumi.getter(name="ipAllocationMethod")
    def ip_allocation_method(self) -> str:
        """
        The IP allocation mechanism for the virtual machine.
        Dynamic and Static are only valid for l3Network which may also specify Disabled.
        Otherwise, Disabled is the only permitted value.
        """
        return pulumi.get(self, "ip_allocation_method")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        """
        The MAC address of the interface for the virtual machine that corresponds to this network attachment.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> Optional[str]:
        """
        The indicator of whether this is the default gateway.
        Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
        """
        return pulumi.get(self, "default_gateway")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[str]:
        """
        The IPv4 address of the virtual machine.

        This field is used only if the attached network has IPAllocationType of IPV4 or DualStack.

        If IPAllocationMethod is:
        Static - this field must contain a user specified IPv4 address from within the subnet specified in the attached network.
        Dynamic - this field is read-only, but will be populated with an address from within the subnet specified in the attached network.
        Disabled - this field will be empty.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[str]:
        """
        The IPv6 address of the virtual machine.

        This field is used only if the attached network has IPAllocationType of IPV6 or DualStack.

        If IPAllocationMethod is:
        Static - this field must contain an IPv6 address range from within the range specified in the attached network.
        Dynamic - this field is read-only, but will be populated with an range from within the subnet specified in the attached network.
        Disabled - this field will be empty.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="networkAttachmentName")
    def network_attachment_name(self) -> Optional[str]:
        """
        The associated network's interface name.
        If specified, the network attachment name has a maximum length of 15 characters and must be unique to this virtual machine.
        If the user doesn’t specify this value, the default interface name of the network resource will be used.
        For a CloudServicesNetwork resource, this name will be ignored.
        """
        return pulumi.get(self, "network_attachment_name")


@pulumi.output_type
class NicResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "macAddress":
            suggest = "mac_address"
        elif key == "lldpNeighbor":
            suggest = "lldp_neighbor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NicResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NicResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NicResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mac_address: str,
                 name: str,
                 lldp_neighbor: Optional['outputs.LldpNeighborResponse'] = None):
        """
        :param str mac_address: The MAC address associated with this NIC.
        :param str name: The name of the NIC/interface.
        """
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "name", name)
        if lldp_neighbor is not None:
            pulumi.set(__self__, "lldp_neighbor", lldp_neighbor)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        """
        The MAC address associated with this NIC.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the NIC/interface.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="lldpNeighbor")
    def lldp_neighbor(self) -> Optional['outputs.LldpNeighborResponse']:
        return pulumi.get(self, "lldp_neighbor")


@pulumi.output_type
class NodeConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentPoolId":
            suggest = "agent_pool_id"
        elif key == "agentPoolName":
            suggest = "agent_pool_name"
        elif key == "cpuCores":
            suggest = "cpu_cores"
        elif key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "memorySizeGB":
            suggest = "memory_size_gb"
        elif key == "nodePoolName":
            suggest = "node_pool_name"
        elif key == "vmCount":
            suggest = "vm_count"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_pool_id: str,
                 agent_pool_name: str,
                 cpu_cores: float,
                 disk_size_gb: float,
                 memory_size_gb: float,
                 node_pool_name: str,
                 nodes: Sequence['outputs.NodeResponse'],
                 vm_count: float,
                 vm_size: str):
        """
        :param str agent_pool_id: The resource ID of the agent pool that contains the nodes in this configuration.
        :param str agent_pool_name: The name of the agent pool that contains the nodes in this configuration.
        :param float cpu_cores: The number of CPU cores in the virtual machine.
        :param float disk_size_gb: The root disk size of the virtual machine in GB.
        :param float memory_size_gb: The memory size of the virtual machine in GB.
        :param str node_pool_name: Field deprecated, use agentPoolName instead. This field will be removed in a future version but will reflect the name of the agent pool that contains the nodes in this configuration.
        :param Sequence['NodeResponse'] nodes: The list of nodes that utilize this configuration.
        :param float vm_count: The number of virtual machines that use this configuration.
        :param str vm_size: The name of the VM size supplied during the creation of the cluster.
        """
        pulumi.set(__self__, "agent_pool_id", agent_pool_id)
        pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        pulumi.set(__self__, "cpu_cores", cpu_cores)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "memory_size_gb", memory_size_gb)
        pulumi.set(__self__, "node_pool_name", node_pool_name)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "vm_count", vm_count)
        pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="agentPoolId")
    def agent_pool_id(self) -> str:
        """
        The resource ID of the agent pool that contains the nodes in this configuration.
        """
        return pulumi.get(self, "agent_pool_id")

    @property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> str:
        """
        The name of the agent pool that contains the nodes in this configuration.
        """
        return pulumi.get(self, "agent_pool_name")

    @property
    @pulumi.getter(name="cpuCores")
    def cpu_cores(self) -> float:
        """
        The number of CPU cores in the virtual machine.
        """
        return pulumi.get(self, "cpu_cores")

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> float:
        """
        The root disk size of the virtual machine in GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="memorySizeGB")
    def memory_size_gb(self) -> float:
        """
        The memory size of the virtual machine in GB.
        """
        return pulumi.get(self, "memory_size_gb")

    @property
    @pulumi.getter(name="nodePoolName")
    def node_pool_name(self) -> str:
        """
        Field deprecated, use agentPoolName instead. This field will be removed in a future version but will reflect the name of the agent pool that contains the nodes in this configuration.
        """
        return pulumi.get(self, "node_pool_name")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.NodeResponse']:
        """
        The list of nodes that utilize this configuration.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="vmCount")
    def vm_count(self) -> float:
        """
        The number of virtual machines that use this configuration.
        """
        return pulumi.get(self, "vm_count")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> str:
        """
        The name of the VM size supplied during the creation of the cluster.
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class NodeResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bareMetalMachineId":
            suggest = "bare_metal_machine_id"
        elif key == "imageId":
            suggest = "image_id"
        elif key == "networkAttachments":
            suggest = "network_attachments"
        elif key == "nodeName":
            suggest = "node_name"
        elif key == "powerState":
            suggest = "power_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bare_metal_machine_id: str,
                 image_id: str,
                 network_attachments: Sequence['outputs.NetworkAttachmentResponse'],
                 node_name: str,
                 power_state: str):
        """
        :param str bare_metal_machine_id: The resource ID of the bare metal machine that hosts this node.
        :param str image_id: The machine image last used to deploy this node.
        :param Sequence['NetworkAttachmentResponse'] network_attachments: The list of network attachments to the virtual machine.
        :param str node_name: The name of this node, as realized in the Hybrid AKS cluster.
        :param str power_state: The power state (On | Off) of the node.
        """
        pulumi.set(__self__, "bare_metal_machine_id", bare_metal_machine_id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "network_attachments", network_attachments)
        pulumi.set(__self__, "node_name", node_name)
        pulumi.set(__self__, "power_state", power_state)

    @property
    @pulumi.getter(name="bareMetalMachineId")
    def bare_metal_machine_id(self) -> str:
        """
        The resource ID of the bare metal machine that hosts this node.
        """
        return pulumi.get(self, "bare_metal_machine_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The machine image last used to deploy this node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="networkAttachments")
    def network_attachments(self) -> Sequence['outputs.NetworkAttachmentResponse']:
        """
        The list of network attachments to the virtual machine.
        """
        return pulumi.get(self, "network_attachments")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> str:
        """
        The name of this node, as realized in the Hybrid AKS cluster.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> str:
        """
        The power state (On | Off) of the node.
        """
        return pulumi.get(self, "power_state")


@pulumi.output_type
class OsDiskResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGB":
            suggest = "disk_size_gb"
        elif key == "createOption":
            suggest = "create_option"
        elif key == "deleteOption":
            suggest = "delete_option"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: float,
                 create_option: Optional[str] = None,
                 delete_option: Optional[str] = None):
        """
        :param float disk_size_gb: The size of the disk in gigabytes. Required if the createOption is Ephemeral.
        :param str create_option: The strategy for creating the OS disk.
        :param str delete_option: The strategy for deleting the OS disk.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if create_option is None:
            create_option = 'Ephemeral'
        if create_option is not None:
            pulumi.set(__self__, "create_option", create_option)
        if delete_option is None:
            delete_option = 'Delete'
        if delete_option is not None:
            pulumi.set(__self__, "delete_option", delete_option)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> float:
        """
        The size of the disk in gigabytes. Required if the createOption is Ephemeral.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> Optional[str]:
        """
        The strategy for creating the OS disk.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter(name="deleteOption")
    def delete_option(self) -> Optional[str]:
        """
        The strategy for deleting the OS disk.
        """
        return pulumi.get(self, "delete_option")


@pulumi.output_type
class RackDefinitionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkRackId":
            suggest = "network_rack_id"
        elif key == "rackSerialNumber":
            suggest = "rack_serial_number"
        elif key == "rackSkuId":
            suggest = "rack_sku_id"
        elif key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "bareMetalMachineConfigurationData":
            suggest = "bare_metal_machine_configuration_data"
        elif key == "rackLocation":
            suggest = "rack_location"
        elif key == "storageApplianceConfigurationData":
            suggest = "storage_appliance_configuration_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RackDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RackDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RackDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_rack_id: str,
                 rack_serial_number: str,
                 rack_sku_id: str,
                 availability_zone: Optional[str] = None,
                 bare_metal_machine_configuration_data: Optional[Sequence['outputs.BareMetalMachineConfigurationDataResponse']] = None,
                 rack_location: Optional[str] = None,
                 storage_appliance_configuration_data: Optional[Sequence['outputs.StorageApplianceConfigurationDataResponse']] = None):
        """
        :param str network_rack_id: The resource ID of the network rack that matches this rack definition.
        :param str rack_serial_number: The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
        :param str rack_sku_id: The resource ID of the sku for the rack being added.
        :param str availability_zone: The zone name used for this rack when created.
        :param Sequence['BareMetalMachineConfigurationDataResponse'] bare_metal_machine_configuration_data: The unordered list of bare metal machine configuration.
        :param str rack_location: The free-form description of the rack's location.
        :param Sequence['StorageApplianceConfigurationDataResponse'] storage_appliance_configuration_data: The list of storage appliance configuration data for this rack.
        """
        pulumi.set(__self__, "network_rack_id", network_rack_id)
        pulumi.set(__self__, "rack_serial_number", rack_serial_number)
        pulumi.set(__self__, "rack_sku_id", rack_sku_id)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if bare_metal_machine_configuration_data is not None:
            pulumi.set(__self__, "bare_metal_machine_configuration_data", bare_metal_machine_configuration_data)
        if rack_location is not None:
            pulumi.set(__self__, "rack_location", rack_location)
        if storage_appliance_configuration_data is not None:
            pulumi.set(__self__, "storage_appliance_configuration_data", storage_appliance_configuration_data)

    @property
    @pulumi.getter(name="networkRackId")
    def network_rack_id(self) -> str:
        """
        The resource ID of the network rack that matches this rack definition.
        """
        return pulumi.get(self, "network_rack_id")

    @property
    @pulumi.getter(name="rackSerialNumber")
    def rack_serial_number(self) -> str:
        """
        The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
        """
        return pulumi.get(self, "rack_serial_number")

    @property
    @pulumi.getter(name="rackSkuId")
    def rack_sku_id(self) -> str:
        """
        The resource ID of the sku for the rack being added.
        """
        return pulumi.get(self, "rack_sku_id")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        The zone name used for this rack when created.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="bareMetalMachineConfigurationData")
    def bare_metal_machine_configuration_data(self) -> Optional[Sequence['outputs.BareMetalMachineConfigurationDataResponse']]:
        """
        The unordered list of bare metal machine configuration.
        """
        return pulumi.get(self, "bare_metal_machine_configuration_data")

    @property
    @pulumi.getter(name="rackLocation")
    def rack_location(self) -> Optional[str]:
        """
        The free-form description of the rack's location.
        """
        return pulumi.get(self, "rack_location")

    @property
    @pulumi.getter(name="storageApplianceConfigurationData")
    def storage_appliance_configuration_data(self) -> Optional[Sequence['outputs.StorageApplianceConfigurationDataResponse']]:
        """
        The list of storage appliance configuration data for this rack.
        """
        return pulumi.get(self, "storage_appliance_configuration_data")


@pulumi.output_type
class ServicePrincipalInformationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePrincipalInformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePrincipalInformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePrincipalInformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: str,
                 password: str,
                 principal_id: str,
                 tenant_id: str):
        """
        :param str application_id: The application ID, also known as client ID, of the service principal.
        :param str password: The password of the service principal.
        :param str principal_id: The principal ID, also known as the object ID, of the service principal.
        :param str tenant_id: The tenant ID, also known as the directory ID, of the tenant in which the service principal is created.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> str:
        """
        The application ID, also known as client ID, of the service principal.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password of the service principal.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID, also known as the object ID, of the service principal.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID, also known as the directory ID, of the tenant in which the service principal is created.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class SshPublicKeyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshPublicKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_data: str):
        """
        :param str key_data: The public ssh key of the user.
        """
        pulumi.set(__self__, "key_data", key_data)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> str:
        """
        The public ssh key of the user.
        """
        return pulumi.get(self, "key_data")


@pulumi.output_type
class StorageApplianceConfigurationDataResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminCredentials":
            suggest = "admin_credentials"
        elif key == "rackSlot":
            suggest = "rack_slot"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "storageApplianceName":
            suggest = "storage_appliance_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageApplianceConfigurationDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageApplianceConfigurationDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageApplianceConfigurationDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_credentials: 'outputs.AdministrativeCredentialsResponse',
                 rack_slot: float,
                 serial_number: str,
                 storage_appliance_name: Optional[str] = None):
        """
        :param float rack_slot: The slot that storage appliance is in the rack based on the BOM configuration.
        :param str serial_number: The serial number of the appliance.
        :param str storage_appliance_name: The user-provided name for the storage appliance that will be created from this specification.
        """
        pulumi.set(__self__, "admin_credentials", admin_credentials)
        pulumi.set(__self__, "rack_slot", rack_slot)
        pulumi.set(__self__, "serial_number", serial_number)
        if storage_appliance_name is not None:
            pulumi.set(__self__, "storage_appliance_name", storage_appliance_name)

    @property
    @pulumi.getter(name="adminCredentials")
    def admin_credentials(self) -> 'outputs.AdministrativeCredentialsResponse':
        return pulumi.get(self, "admin_credentials")

    @property
    @pulumi.getter(name="rackSlot")
    def rack_slot(self) -> float:
        """
        The slot that storage appliance is in the rack based on the BOM configuration.
        """
        return pulumi.get(self, "rack_slot")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        The serial number of the appliance.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="storageApplianceName")
    def storage_appliance_name(self) -> Optional[str]:
        """
        The user-provided name for the storage appliance that will be created from this specification.
        """
        return pulumi.get(self, "storage_appliance_name")


@pulumi.output_type
class StorageProfileResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osDisk":
            suggest = "os_disk"
        elif key == "volumeAttachments":
            suggest = "volume_attachments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_disk: 'outputs.OsDiskResponse',
                 volume_attachments: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] volume_attachments: The resource IDs of volumes that are requested to be attached to the virtual machine.
        """
        pulumi.set(__self__, "os_disk", os_disk)
        if volume_attachments is not None:
            pulumi.set(__self__, "volume_attachments", volume_attachments)

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> 'outputs.OsDiskResponse':
        return pulumi.get(self, "os_disk")

    @property
    @pulumi.getter(name="volumeAttachments")
    def volume_attachments(self) -> Optional[Sequence[str]]:
        """
        The resource IDs of volumes that are requested to be attached to the virtual machine.
        """
        return pulumi.get(self, "volume_attachments")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class ValidationThresholdResponse(dict):
    def __init__(__self__, *,
                 grouping: str,
                 type: str,
                 value: float):
        """
        :param str grouping: Selection of how the type evaluation is applied to the cluster calculation.
        :param str type: Selection of how the threshold should be evaluated.
        :param float value: The numeric threshold value.
        """
        pulumi.set(__self__, "grouping", grouping)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def grouping(self) -> str:
        """
        Selection of how the type evaluation is applied to the cluster calculation.
        """
        return pulumi.get(self, "grouping")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Selection of how the threshold should be evaluated.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The numeric threshold value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class VirtualMachinePlacementHintResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hintType":
            suggest = "hint_type"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "schedulingExecution":
            suggest = "scheduling_execution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachinePlacementHintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachinePlacementHintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachinePlacementHintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hint_type: str,
                 resource_id: str,
                 scheduling_execution: str,
                 scope: str):
        """
        :param str hint_type: The specification of whether this hint supports affinity or anti-affinity with the referenced resources.
        :param str resource_id: The resource ID of the target object that the placement hints will be checked against, e.g., the bare metal node to host the virtual machine.
        :param str scheduling_execution: The indicator of whether the hint is a hard or soft requirement during scheduling.
        :param str scope: The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in the case of node affinity.
        """
        pulumi.set(__self__, "hint_type", hint_type)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "scheduling_execution", scheduling_execution)
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="hintType")
    def hint_type(self) -> str:
        """
        The specification of whether this hint supports affinity or anti-affinity with the referenced resources.
        """
        return pulumi.get(self, "hint_type")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The resource ID of the target object that the placement hints will be checked against, e.g., the bare metal node to host the virtual machine.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="schedulingExecution")
    def scheduling_execution(self) -> str:
        """
        The indicator of whether the hint is a hard or soft requirement during scheduling.
        """
        return pulumi.get(self, "scheduling_execution")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in the case of node affinity.
        """
        return pulumi.get(self, "scope")


