# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetTenantActionGroupResult',
    'AwaitableGetTenantActionGroupResult',
    'get_tenant_action_group',
    'get_tenant_action_group_output',
]

@pulumi.output_type
class GetTenantActionGroupResult:
    """
    A tenant action group resource.
    """
    def __init__(__self__, azure_app_push_receivers=None, email_receivers=None, enabled=None, group_short_name=None, id=None, location=None, name=None, sms_receivers=None, tags=None, type=None, voice_receivers=None, webhook_receivers=None):
        if azure_app_push_receivers and not isinstance(azure_app_push_receivers, list):
            raise TypeError("Expected argument 'azure_app_push_receivers' to be a list")
        pulumi.set(__self__, "azure_app_push_receivers", azure_app_push_receivers)
        if email_receivers and not isinstance(email_receivers, list):
            raise TypeError("Expected argument 'email_receivers' to be a list")
        pulumi.set(__self__, "email_receivers", email_receivers)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if group_short_name and not isinstance(group_short_name, str):
            raise TypeError("Expected argument 'group_short_name' to be a str")
        pulumi.set(__self__, "group_short_name", group_short_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sms_receivers and not isinstance(sms_receivers, list):
            raise TypeError("Expected argument 'sms_receivers' to be a list")
        pulumi.set(__self__, "sms_receivers", sms_receivers)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if voice_receivers and not isinstance(voice_receivers, list):
            raise TypeError("Expected argument 'voice_receivers' to be a list")
        pulumi.set(__self__, "voice_receivers", voice_receivers)
        if webhook_receivers and not isinstance(webhook_receivers, list):
            raise TypeError("Expected argument 'webhook_receivers' to be a list")
        pulumi.set(__self__, "webhook_receivers", webhook_receivers)

    @property
    @pulumi.getter(name="azureAppPushReceivers")
    def azure_app_push_receivers(self) -> Optional[Sequence['outputs.AzureAppPushReceiverResponse']]:
        """
        The list of AzureAppPush receivers that are part of this tenant action group.
        """
        return pulumi.get(self, "azure_app_push_receivers")

    @property
    @pulumi.getter(name="emailReceivers")
    def email_receivers(self) -> Optional[Sequence['outputs.EmailReceiverResponse']]:
        """
        The list of email receivers that are part of this tenant action group.
        """
        return pulumi.get(self, "email_receivers")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether this tenant action group is enabled. If a tenant action group is not enabled, then none of its receivers will receive communications.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="groupShortName")
    def group_short_name(self) -> str:
        """
        The short name of the action group. This will be used in SMS messages.
        """
        return pulumi.get(self, "group_short_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Azure resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Azure resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="smsReceivers")
    def sms_receivers(self) -> Optional[Sequence['outputs.SmsReceiverResponse']]:
        """
        The list of SMS receivers that are part of this tenant action group.
        """
        return pulumi.get(self, "sms_receivers")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Azure resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="voiceReceivers")
    def voice_receivers(self) -> Optional[Sequence['outputs.VoiceReceiverResponse']]:
        """
        The list of voice receivers that are part of this tenant action group.
        """
        return pulumi.get(self, "voice_receivers")

    @property
    @pulumi.getter(name="webhookReceivers")
    def webhook_receivers(self) -> Optional[Sequence['outputs.WebhookReceiverResponse']]:
        """
        The list of webhook receivers that are part of this tenant action group.
        """
        return pulumi.get(self, "webhook_receivers")


class AwaitableGetTenantActionGroupResult(GetTenantActionGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTenantActionGroupResult(
            azure_app_push_receivers=self.azure_app_push_receivers,
            email_receivers=self.email_receivers,
            enabled=self.enabled,
            group_short_name=self.group_short_name,
            id=self.id,
            location=self.location,
            name=self.name,
            sms_receivers=self.sms_receivers,
            tags=self.tags,
            type=self.type,
            voice_receivers=self.voice_receivers,
            webhook_receivers=self.webhook_receivers)


def get_tenant_action_group(management_group_id: Optional[str] = None,
                            tenant_action_group_name: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTenantActionGroupResult:
    """
    A tenant action group resource.


    :param str management_group_id: The management group id.
    :param str tenant_action_group_name: The name of the action group.
    """
    __args__ = dict()
    __args__['managementGroupId'] = management_group_id
    __args__['tenantActionGroupName'] = tenant_action_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:insights/v20230301preview:getTenantActionGroup', __args__, opts=opts, typ=GetTenantActionGroupResult).value

    return AwaitableGetTenantActionGroupResult(
        azure_app_push_receivers=__ret__.azure_app_push_receivers,
        email_receivers=__ret__.email_receivers,
        enabled=__ret__.enabled,
        group_short_name=__ret__.group_short_name,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        sms_receivers=__ret__.sms_receivers,
        tags=__ret__.tags,
        type=__ret__.type,
        voice_receivers=__ret__.voice_receivers,
        webhook_receivers=__ret__.webhook_receivers)


@_utilities.lift_output_func(get_tenant_action_group)
def get_tenant_action_group_output(management_group_id: Optional[pulumi.Input[str]] = None,
                                   tenant_action_group_name: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTenantActionGroupResult]:
    """
    A tenant action group resource.


    :param str management_group_id: The management group id.
    :param str tenant_action_group_name: The name of the action group.
    """
    ...
