# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AuthenticationDetailsValue',
    'ConnectedClusterAADProfileArgs',
    'ConnectedClusterIdentityArgs',
]

@pulumi.input_type
class AuthenticationDetailsValue:
    def __init__(__self__, *,
                 token: Optional[str] = None):
        """
        Authentication token value.
        :param str token: Authentication token.
        """
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        Authentication token.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[str]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class ConnectedClusterAADProfileArgs:
    def __init__(__self__, *,
                 client_app_id: pulumi.Input[str],
                 server_app_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str]):
        """
        AAD profile of the connected cluster
        :param pulumi.Input[str] client_app_id: The client app id configured on target K8 cluster 
        :param pulumi.Input[str] server_app_id: The server app id to access AD server
        :param pulumi.Input[str] tenant_id: The aad tenant id which is configured on target K8s cluster
        """
        pulumi.set(__self__, "client_app_id", client_app_id)
        pulumi.set(__self__, "server_app_id", server_app_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientAppId")
    def client_app_id(self) -> pulumi.Input[str]:
        """
        The client app id configured on target K8 cluster 
        """
        return pulumi.get(self, "client_app_id")

    @client_app_id.setter
    def client_app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_app_id", value)

    @property
    @pulumi.getter(name="serverAppId")
    def server_app_id(self) -> pulumi.Input[str]:
        """
        The server app id to access AD server
        """
        return pulumi.get(self, "server_app_id")

    @server_app_id.setter
    def server_app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_app_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The aad tenant id which is configured on target K8s cluster
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class ConnectedClusterIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['ResourceIdentityType']):
        """
        Identity for the connected cluster.
        :param pulumi.Input['ResourceIdentityType'] type: The type of identity used for the connected cluster. The type 'SystemAssigned, includes a system created identity. The type 'None' means no identity is assigned to the connected cluster.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ResourceIdentityType']:
        """
        The type of identity used for the connected cluster. The type 'SystemAssigned, includes a system created identity. The type 'None' means no identity is assigned to the connected cluster.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ResourceIdentityType']):
        pulumi.set(self, "type", value)


