# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetAnalyticsConnectorResult',
    'AwaitableGetAnalyticsConnectorResult',
    'get_analytics_connector',
    'get_analytics_connector_output',
]

@pulumi.output_type
class GetAnalyticsConnectorResult:
    """
    Analytics Connector definition.
    """
    def __init__(__self__, data_destination_configuration=None, data_mapping_configuration=None, data_source_configuration=None, etag=None, id=None, identity=None, location=None, name=None, provisioning_state=None, system_data=None, tags=None, type=None):
        if data_destination_configuration and not isinstance(data_destination_configuration, dict):
            raise TypeError("Expected argument 'data_destination_configuration' to be a dict")
        pulumi.set(__self__, "data_destination_configuration", data_destination_configuration)
        if data_mapping_configuration and not isinstance(data_mapping_configuration, dict):
            raise TypeError("Expected argument 'data_mapping_configuration' to be a dict")
        pulumi.set(__self__, "data_mapping_configuration", data_mapping_configuration)
        if data_source_configuration and not isinstance(data_source_configuration, dict):
            raise TypeError("Expected argument 'data_source_configuration' to be a dict")
        pulumi.set(__self__, "data_source_configuration", data_source_configuration)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity and not isinstance(identity, dict):
            raise TypeError("Expected argument 'identity' to be a dict")
        pulumi.set(__self__, "identity", identity)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="dataDestinationConfiguration")
    def data_destination_configuration(self) -> 'outputs.AnalyticsConnectorDataLakeDataDestinationResponse':
        """
        Data destination configuration for Analytics Connector.
        """
        return pulumi.get(self, "data_destination_configuration")

    @property
    @pulumi.getter(name="dataMappingConfiguration")
    def data_mapping_configuration(self) -> 'outputs.AnalyticsConnectorFhirToParquetMappingResponse':
        """
        Data mapping configuration for Analytics Connector.
        """
        return pulumi.get(self, "data_mapping_configuration")

    @property
    @pulumi.getter(name="dataSourceConfiguration")
    def data_source_configuration(self) -> 'outputs.AnalyticsConnectorFhirServiceDataSourceResponse':
        """
        Data source for Analytics Connector.
        """
        return pulumi.get(self, "data_source_configuration")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        An etag associated with the resource, used for optimistic concurrency when editing it.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.ServiceManagedIdentityResponseIdentity']:
        """
        Setting indicating whether the service has a managed identity associated with it.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetAnalyticsConnectorResult(GetAnalyticsConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAnalyticsConnectorResult(
            data_destination_configuration=self.data_destination_configuration,
            data_mapping_configuration=self.data_mapping_configuration,
            data_source_configuration=self.data_source_configuration,
            etag=self.etag,
            id=self.id,
            identity=self.identity,
            location=self.location,
            name=self.name,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_analytics_connector(analytics_connector_name: Optional[str] = None,
                            resource_group_name: Optional[str] = None,
                            workspace_name: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAnalyticsConnectorResult:
    """
    Analytics Connector definition.


    :param str analytics_connector_name: The name of Analytics Connector resource.
    :param str resource_group_name: The name of the resource group that contains the service instance.
    :param str workspace_name: The name of workspace resource.
    """
    __args__ = dict()
    __args__['analyticsConnectorName'] = analytics_connector_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['workspaceName'] = workspace_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:healthcareapis/v20221001preview:getAnalyticsConnector', __args__, opts=opts, typ=GetAnalyticsConnectorResult).value

    return AwaitableGetAnalyticsConnectorResult(
        data_destination_configuration=__ret__.data_destination_configuration,
        data_mapping_configuration=__ret__.data_mapping_configuration,
        data_source_configuration=__ret__.data_source_configuration,
        etag=__ret__.etag,
        id=__ret__.id,
        identity=__ret__.identity,
        location=__ret__.location,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_analytics_connector)
def get_analytics_connector_output(analytics_connector_name: Optional[pulumi.Input[str]] = None,
                                   resource_group_name: Optional[pulumi.Input[str]] = None,
                                   workspace_name: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAnalyticsConnectorResult]:
    """
    Analytics Connector definition.


    :param str analytics_connector_name: The name of Analytics Connector resource.
    :param str resource_group_name: The name of the resource group that contains the service instance.
    :param str workspace_name: The name of workspace resource.
    """
    ...
