# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActionRulePropertiesResponse',
    'ConditionResponse',
    'ConditionsResponse',
    'ScopeResponse',
    'SuppressionConfigResponse',
    'SuppressionScheduleResponse',
]

@pulumi.output_type
class ActionRulePropertiesResponse(dict):
    """
    Action rule properties defining scope, conditions, suppression logic for action rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "suppressionConfig":
            suggest = "suppression_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionRulePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionRulePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionRulePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: str,
                 created_by: str,
                 last_modified_at: str,
                 last_modified_by: str,
                 resource_group: str,
                 conditions: Optional['outputs.ConditionsResponse'] = None,
                 description: Optional[str] = None,
                 scope: Optional['outputs.ScopeResponse'] = None,
                 status: Optional[str] = None,
                 suppression_config: Optional['outputs.SuppressionConfigResponse'] = None):
        """
        Action rule properties defining scope, conditions, suppression logic for action rule
        :param str created_at: Creation time of action rule. Date-Time in ISO-8601 format.
        :param str created_by: Created by user name.
        :param str last_modified_at: Last updated time of action rule. Date-Time in ISO-8601 format.
        :param str last_modified_by: Last modified by user name.
        :param str resource_group: Resource group where action rule is stored
        :param 'ConditionsResponse' conditions: Conditions in alert instance to be matched for a given action rule. Default value is all. Multiple values could be provided with comma separation.
        :param str description: Description of action rule
        :param 'ScopeResponse' scope: Target scope for a given action rule. By default scope will be the subscription. User can also provide list of resource groups or list of resources from the scope subscription as well.
        :param str status: Indicates if the given action rule is enabled or disabled
        :param 'SuppressionConfigResponse' suppression_config: Suppression logic for a given action rule
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "last_modified_at", last_modified_at)
        pulumi.set(__self__, "last_modified_by", last_modified_by)
        pulumi.set(__self__, "resource_group", resource_group)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if suppression_config is not None:
            pulumi.set(__self__, "suppression_config", suppression_config)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation time of action rule. Date-Time in ISO-8601 format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        Created by user name.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> str:
        """
        Last updated time of action rule. Date-Time in ISO-8601 format.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> str:
        """
        Last modified by user name.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        Resource group where action rule is stored
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter
    def conditions(self) -> Optional['outputs.ConditionsResponse']:
        """
        Conditions in alert instance to be matched for a given action rule. Default value is all. Multiple values could be provided with comma separation.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of action rule
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def scope(self) -> Optional['outputs.ScopeResponse']:
        """
        Target scope for a given action rule. By default scope will be the subscription. User can also provide list of resource groups or list of resources from the scope subscription as well.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates if the given action rule is enabled or disabled
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="suppressionConfig")
    def suppression_config(self) -> Optional['outputs.SuppressionConfigResponse']:
        """
        Suppression logic for a given action rule
        """
        return pulumi.get(self, "suppression_config")


@pulumi.output_type
class ConditionResponse(dict):
    """
    condition to trigger an action rule
    """
    def __init__(__self__, *,
                 operator: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        condition to trigger an action rule
        :param str operator: operator for a given condition
        :param Sequence[str] values: list of values to match for a given condition.
        """
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        operator for a given condition
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        list of values to match for a given condition.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ConditionsResponse(dict):
    """
    Conditions in alert instance to be matched for a given action rule. Default value is all. Multiple values could be provided with comma separation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertRuleId":
            suggest = "alert_rule_id"
        elif key == "applicationInsightsSearchResults":
            suggest = "application_insights_search_results"
        elif key == "logAnalyticsSearchResults":
            suggest = "log_analytics_search_results"
        elif key == "monitorCondition":
            suggest = "monitor_condition"
        elif key == "monitorService":
            suggest = "monitor_service"
        elif key == "signalType":
            suggest = "signal_type"
        elif key == "targetResource":
            suggest = "target_resource"
        elif key == "targetResourceGroup":
            suggest = "target_resource_group"
        elif key == "targetResourceType":
            suggest = "target_resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConditionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConditionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConditionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_rule_id: Optional['outputs.ConditionResponse'] = None,
                 application_insights_search_results: Optional['outputs.ConditionResponse'] = None,
                 description: Optional['outputs.ConditionResponse'] = None,
                 log_analytics_search_results: Optional['outputs.ConditionResponse'] = None,
                 monitor_condition: Optional['outputs.ConditionResponse'] = None,
                 monitor_service: Optional['outputs.ConditionResponse'] = None,
                 severity: Optional['outputs.ConditionResponse'] = None,
                 signal_type: Optional['outputs.ConditionResponse'] = None,
                 target_resource: Optional['outputs.ConditionResponse'] = None,
                 target_resource_group: Optional['outputs.ConditionResponse'] = None,
                 target_resource_type: Optional['outputs.ConditionResponse'] = None):
        """
        Conditions in alert instance to be matched for a given action rule. Default value is all. Multiple values could be provided with comma separation.
        :param 'ConditionResponse' alert_rule_id: condition to trigger an action rule
        :param 'ConditionResponse' application_insights_search_results: condition to trigger an action rule
        :param 'ConditionResponse' description: condition to trigger an action rule
        :param 'ConditionResponse' log_analytics_search_results: condition to trigger an action rule
        :param 'ConditionResponse' monitor_condition: condition to trigger an action rule
        :param 'ConditionResponse' monitor_service: condition to trigger an action rule
        :param 'ConditionResponse' severity: condition to trigger an action rule
        :param 'ConditionResponse' signal_type: condition to trigger an action rule
        :param 'ConditionResponse' target_resource: condition to trigger an action rule
        :param 'ConditionResponse' target_resource_group: condition to trigger an action rule
        :param 'ConditionResponse' target_resource_type: condition to trigger an action rule
        """
        if alert_rule_id is not None:
            pulumi.set(__self__, "alert_rule_id", alert_rule_id)
        if application_insights_search_results is not None:
            pulumi.set(__self__, "application_insights_search_results", application_insights_search_results)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if log_analytics_search_results is not None:
            pulumi.set(__self__, "log_analytics_search_results", log_analytics_search_results)
        if monitor_condition is not None:
            pulumi.set(__self__, "monitor_condition", monitor_condition)
        if monitor_service is not None:
            pulumi.set(__self__, "monitor_service", monitor_service)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if signal_type is not None:
            pulumi.set(__self__, "signal_type", signal_type)
        if target_resource is not None:
            pulumi.set(__self__, "target_resource", target_resource)
        if target_resource_group is not None:
            pulumi.set(__self__, "target_resource_group", target_resource_group)
        if target_resource_type is not None:
            pulumi.set(__self__, "target_resource_type", target_resource_type)

    @property
    @pulumi.getter(name="alertRuleId")
    def alert_rule_id(self) -> Optional['outputs.ConditionResponse']:
        """
        condition to trigger an action rule
        """
        return pulumi.get(self, "alert_rule_id")

    @property
    @pulumi.getter(name="applicationInsightsSearchResults")
    def application_insights_search_results(self) -> Optional['outputs.ConditionResponse']:
        """
        condition to trigger an action rule
        """
        return pulumi.get(self, "application_insights_search_results")

    @property
    @pulumi.getter
    def description(self) -> Optional['outputs.ConditionResponse']:
        """
        condition to trigger an action rule
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="logAnalyticsSearchResults")
    def log_analytics_search_results(self) -> Optional['outputs.ConditionResponse']:
        """
        condition to trigger an action rule
        """
        return pulumi.get(self, "log_analytics_search_results")

    @property
    @pulumi.getter(name="monitorCondition")
    def monitor_condition(self) -> Optional['outputs.ConditionResponse']:
        """
        condition to trigger an action rule
        """
        return pulumi.get(self, "monitor_condition")

    @property
    @pulumi.getter(name="monitorService")
    def monitor_service(self) -> Optional['outputs.ConditionResponse']:
        """
        condition to trigger an action rule
        """
        return pulumi.get(self, "monitor_service")

    @property
    @pulumi.getter
    def severity(self) -> Optional['outputs.ConditionResponse']:
        """
        condition to trigger an action rule
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="signalType")
    def signal_type(self) -> Optional['outputs.ConditionResponse']:
        """
        condition to trigger an action rule
        """
        return pulumi.get(self, "signal_type")

    @property
    @pulumi.getter(name="targetResource")
    def target_resource(self) -> Optional['outputs.ConditionResponse']:
        """
        condition to trigger an action rule
        """
        return pulumi.get(self, "target_resource")

    @property
    @pulumi.getter(name="targetResourceGroup")
    def target_resource_group(self) -> Optional['outputs.ConditionResponse']:
        """
        condition to trigger an action rule
        """
        return pulumi.get(self, "target_resource_group")

    @property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> Optional['outputs.ConditionResponse']:
        """
        condition to trigger an action rule
        """
        return pulumi.get(self, "target_resource_type")


@pulumi.output_type
class ScopeResponse(dict):
    """
    Target scope for a given action rule. By default scope will be the subscription. User can also provide list of resource groups or list of resources from the scope subscription as well.
    """
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        Target scope for a given action rule. By default scope will be the subscription. User can also provide list of resource groups or list of resources from the scope subscription as well.
        :param str type: type of target scope
        :param Sequence[str] values: list of ARM IDs of the given scope type which will be the target of the given action rule.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        type of target scope
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        list of ARM IDs of the given scope type which will be the target of the given action rule.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SuppressionConfigResponse(dict):
    """
    Suppression logic for a given action rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recurrenceType":
            suggest = "recurrence_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SuppressionConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SuppressionConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SuppressionConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recurrence_type: str,
                 schedule: Optional['outputs.SuppressionScheduleResponse'] = None):
        """
        Suppression logic for a given action rule
        :param str recurrence_type: Specifies when the suppression should be applied
        :param 'SuppressionScheduleResponse' schedule: Schedule for a given suppression configuration.
        """
        pulumi.set(__self__, "recurrence_type", recurrence_type)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> str:
        """
        Specifies when the suppression should be applied
        """
        return pulumi.get(self, "recurrence_type")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.SuppressionScheduleResponse']:
        """
        Schedule for a given suppression configuration.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class SuppressionScheduleResponse(dict):
    """
    Schedule for a given suppression configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "recurrenceValues":
            suggest = "recurrence_values"
        elif key == "startDate":
            suggest = "start_date"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SuppressionScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SuppressionScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SuppressionScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: Optional[str] = None,
                 end_time: Optional[str] = None,
                 recurrence_values: Optional[Sequence[int]] = None,
                 start_date: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        Schedule for a given suppression configuration.
        :param str end_date: End date for suppression
        :param str end_time: End date for suppression
        :param Sequence[int] recurrence_values: Specifies the values for recurrence pattern
        :param str start_date: Start date for suppression
        :param str start_time: Start time for suppression
        """
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if recurrence_values is not None:
            pulumi.set(__self__, "recurrence_values", recurrence_values)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[str]:
        """
        End date for suppression
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        End date for suppression
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="recurrenceValues")
    def recurrence_values(self) -> Optional[Sequence[int]]:
        """
        Specifies the values for recurrence pattern
        """
        return pulumi.get(self, "recurrence_values")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[str]:
        """
        Start date for suppression
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Start time for suppression
        """
        return pulumi.get(self, "start_time")


