# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApplianceArtifactResponse',
    'ApplianceProviderAuthorizationResponse',
    'IdentityResponse',
    'PlanResponse',
    'SkuResponse',
]

@pulumi.output_type
class ApplianceArtifactResponse(dict):
    """
    Appliance artifact.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        Appliance artifact.
        :param str name: The appliance artifact name.
        :param str type: The appliance artifact type.
        :param str uri: The appliance artifact blob uri.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The appliance artifact name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The appliance artifact type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        The appliance artifact blob uri.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class ApplianceProviderAuthorizationResponse(dict):
    """
    The appliance provider authorization.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "roleDefinitionId":
            suggest = "role_definition_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplianceProviderAuthorizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplianceProviderAuthorizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplianceProviderAuthorizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 role_definition_id: str):
        """
        The appliance provider authorization.
        :param str principal_id: The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the appliance resources.
        :param str role_definition_id: The provider's role definition identifier. This role will define all the permissions that the provider must have on the appliance's container resource group. This role definition cannot have permission to delete the resource group.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "role_definition_id", role_definition_id)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the appliance resources.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> str:
        """
        The provider's role definition identifier. This role will define all the permissions that the provider must have on the appliance's container resource group. This role definition cannot have permission to delete the resource group.
        """
        return pulumi.get(self, "role_definition_id")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PlanResponse(dict):
    """
    Plan for the appliance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promotionCode":
            suggest = "promotion_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlanResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlanResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlanResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 product: str,
                 publisher: str,
                 version: str,
                 promotion_code: Optional[str] = None):
        """
        Plan for the appliance.
        :param str name: The plan name.
        :param str product: The product code.
        :param str publisher: The publisher ID.
        :param str version: The plan's version.
        :param str promotion_code: The promotion code.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "version", version)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The plan name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def product(self) -> str:
        """
        The product code.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def publisher(self) -> str:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The plan's version.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[str]:
        """
        The promotion code.
        """
        return pulumi.get(self, "promotion_code")


@pulumi.output_type
class SkuResponse(dict):
    """
    SKU for the resource.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 model: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        SKU for the resource.
        :param str name: The SKU name.
        :param int capacity: The SKU capacity.
        :param str family: The SKU family.
        :param str model: The SKU model.
        :param str size: The SKU size.
        :param str tier: The SKU tier.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The SKU name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The SKU capacity.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        The SKU family.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def model(self) -> Optional[str]:
        """
        The SKU model.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The SKU size.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The SKU tier.
        """
        return pulumi.get(self, "tier")


