# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AdministrativeCredentialsArgs',
    'BareMetalMachineConfigurationDataArgs',
    'BgpPeerArgs',
    'ClusterCapacityArgs',
    'CniBgpConfigurationArgs',
    'CommunityAdvertisementArgs',
    'EgressEndpointArgs',
    'EndpointDependencyArgs',
    'ExtendedLocationArgs',
    'ImageRepositoryCredentialsArgs',
    'KeySetUserArgs',
    'ManagedResourceGroupConfigurationArgs',
    'NetworkAttachmentArgs',
    'OsDiskArgs',
    'RackDefinitionArgs',
    'ServicePrincipalInformationArgs',
    'SshPublicKeyArgs',
    'StorageApplianceConfigurationDataArgs',
    'StorageProfileArgs',
    'ValidationThresholdArgs',
    'VirtualMachinePlacementHintArgs',
]

@pulumi.input_type
class AdministrativeCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: The password of the administrator of the device used during initialization.
        :param pulumi.Input[str] username: The username of the administrator of the device used during initialization.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password of the administrator of the device used during initialization.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username of the administrator of the device used during initialization.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class BareMetalMachineConfigurationDataArgs:
    def __init__(__self__, *,
                 bmc_credentials: pulumi.Input['AdministrativeCredentialsArgs'],
                 bmc_mac_address: pulumi.Input[str],
                 boot_mac_address: pulumi.Input[str],
                 rack_slot: pulumi.Input[float],
                 serial_number: pulumi.Input[str],
                 machine_details: Optional[pulumi.Input[str]] = None,
                 machine_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bmc_mac_address: The MAC address of the BMC for this machine.
        :param pulumi.Input[str] boot_mac_address: The MAC address associated with the PXE NIC card.
        :param pulumi.Input[float] rack_slot: The slot the physical machine is in the rack based on the BOM configuration.
        :param pulumi.Input[str] serial_number: The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag.
        :param pulumi.Input[str] machine_details: The free-form additional information about the machine, e.g. an asset tag.
        :param pulumi.Input[str] machine_name: The user-provided name for the bare metal machine created from this specification.
               If not provided, the machine name will be generated programmatically.
        """
        pulumi.set(__self__, "bmc_credentials", bmc_credentials)
        pulumi.set(__self__, "bmc_mac_address", bmc_mac_address)
        pulumi.set(__self__, "boot_mac_address", boot_mac_address)
        pulumi.set(__self__, "rack_slot", rack_slot)
        pulumi.set(__self__, "serial_number", serial_number)
        if machine_details is not None:
            pulumi.set(__self__, "machine_details", machine_details)
        if machine_name is not None:
            pulumi.set(__self__, "machine_name", machine_name)

    @property
    @pulumi.getter(name="bmcCredentials")
    def bmc_credentials(self) -> pulumi.Input['AdministrativeCredentialsArgs']:
        return pulumi.get(self, "bmc_credentials")

    @bmc_credentials.setter
    def bmc_credentials(self, value: pulumi.Input['AdministrativeCredentialsArgs']):
        pulumi.set(self, "bmc_credentials", value)

    @property
    @pulumi.getter(name="bmcMacAddress")
    def bmc_mac_address(self) -> pulumi.Input[str]:
        """
        The MAC address of the BMC for this machine.
        """
        return pulumi.get(self, "bmc_mac_address")

    @bmc_mac_address.setter
    def bmc_mac_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "bmc_mac_address", value)

    @property
    @pulumi.getter(name="bootMacAddress")
    def boot_mac_address(self) -> pulumi.Input[str]:
        """
        The MAC address associated with the PXE NIC card.
        """
        return pulumi.get(self, "boot_mac_address")

    @boot_mac_address.setter
    def boot_mac_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "boot_mac_address", value)

    @property
    @pulumi.getter(name="rackSlot")
    def rack_slot(self) -> pulumi.Input[float]:
        """
        The slot the physical machine is in the rack based on the BOM configuration.
        """
        return pulumi.get(self, "rack_slot")

    @rack_slot.setter
    def rack_slot(self, value: pulumi.Input[float]):
        pulumi.set(self, "rack_slot", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Input[str]:
        """
        The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "serial_number", value)

    @property
    @pulumi.getter(name="machineDetails")
    def machine_details(self) -> Optional[pulumi.Input[str]]:
        """
        The free-form additional information about the machine, e.g. an asset tag.
        """
        return pulumi.get(self, "machine_details")

    @machine_details.setter
    def machine_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_details", value)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-provided name for the bare metal machine created from this specification.
        If not provided, the machine name will be generated programmatically.
        """
        return pulumi.get(self, "machine_name")

    @machine_name.setter
    def machine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_name", value)


@pulumi.input_type
class BgpPeerArgs:
    def __init__(__self__, *,
                 as_number: pulumi.Input[float],
                 peer_ip: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[float] as_number: The ASN (Autonomous System Number) of the BGP peer.
        :param pulumi.Input[str] peer_ip: The IPv4 or IPv6 address to peer with the associated CNI Network. The IP version type will drive a peering with the same version type from the Default CNI Network. For example, IPv4 to IPv4 or IPv6 to IPv6.
        :param pulumi.Input[str] password: The password for this peering neighbor. It defaults to no password if not specified.
        """
        pulumi.set(__self__, "as_number", as_number)
        pulumi.set(__self__, "peer_ip", peer_ip)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="asNumber")
    def as_number(self) -> pulumi.Input[float]:
        """
        The ASN (Autonomous System Number) of the BGP peer.
        """
        return pulumi.get(self, "as_number")

    @as_number.setter
    def as_number(self, value: pulumi.Input[float]):
        pulumi.set(self, "as_number", value)

    @property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> pulumi.Input[str]:
        """
        The IPv4 or IPv6 address to peer with the associated CNI Network. The IP version type will drive a peering with the same version type from the Default CNI Network. For example, IPv4 to IPv4 or IPv6 to IPv6.
        """
        return pulumi.get(self, "peer_ip")

    @peer_ip.setter
    def peer_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_ip", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for this peering neighbor. It defaults to no password if not specified.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class ClusterCapacityArgs:
    def __init__(__self__, *,
                 available_appliance_storage_gb: Optional[pulumi.Input[float]] = None,
                 available_core_count: Optional[pulumi.Input[float]] = None,
                 available_host_storage_gb: Optional[pulumi.Input[float]] = None,
                 available_memory_gb: Optional[pulumi.Input[float]] = None,
                 total_appliance_storage_gb: Optional[pulumi.Input[float]] = None,
                 total_core_count: Optional[pulumi.Input[float]] = None,
                 total_host_storage_gb: Optional[pulumi.Input[float]] = None,
                 total_memory_gb: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] available_appliance_storage_gb: The remaining appliance-based storage in GB available for workload use.
        :param pulumi.Input[float] available_core_count: The remaining number of cores that are available in this cluster for workload use.
        :param pulumi.Input[float] available_host_storage_gb: The remaining machine or host-based storage in GB available for workload use.
        :param pulumi.Input[float] available_memory_gb: The remaining memory in GB that are available in this cluster for workload use.
        :param pulumi.Input[float] total_appliance_storage_gb: The total appliance-based storage in GB supported by this cluster for workload use.
        :param pulumi.Input[float] total_core_count: The total number of cores that are supported by this cluster for workload use.
        :param pulumi.Input[float] total_host_storage_gb: The total machine or host-based storage in GB supported by this cluster for workload use.
        :param pulumi.Input[float] total_memory_gb: The total memory supported by this cluster for workload use.
        """
        if available_appliance_storage_gb is not None:
            pulumi.set(__self__, "available_appliance_storage_gb", available_appliance_storage_gb)
        if available_core_count is not None:
            pulumi.set(__self__, "available_core_count", available_core_count)
        if available_host_storage_gb is not None:
            pulumi.set(__self__, "available_host_storage_gb", available_host_storage_gb)
        if available_memory_gb is not None:
            pulumi.set(__self__, "available_memory_gb", available_memory_gb)
        if total_appliance_storage_gb is not None:
            pulumi.set(__self__, "total_appliance_storage_gb", total_appliance_storage_gb)
        if total_core_count is not None:
            pulumi.set(__self__, "total_core_count", total_core_count)
        if total_host_storage_gb is not None:
            pulumi.set(__self__, "total_host_storage_gb", total_host_storage_gb)
        if total_memory_gb is not None:
            pulumi.set(__self__, "total_memory_gb", total_memory_gb)

    @property
    @pulumi.getter(name="availableApplianceStorageGB")
    def available_appliance_storage_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The remaining appliance-based storage in GB available for workload use.
        """
        return pulumi.get(self, "available_appliance_storage_gb")

    @available_appliance_storage_gb.setter
    def available_appliance_storage_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "available_appliance_storage_gb", value)

    @property
    @pulumi.getter(name="availableCoreCount")
    def available_core_count(self) -> Optional[pulumi.Input[float]]:
        """
        The remaining number of cores that are available in this cluster for workload use.
        """
        return pulumi.get(self, "available_core_count")

    @available_core_count.setter
    def available_core_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "available_core_count", value)

    @property
    @pulumi.getter(name="availableHostStorageGB")
    def available_host_storage_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The remaining machine or host-based storage in GB available for workload use.
        """
        return pulumi.get(self, "available_host_storage_gb")

    @available_host_storage_gb.setter
    def available_host_storage_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "available_host_storage_gb", value)

    @property
    @pulumi.getter(name="availableMemoryGB")
    def available_memory_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The remaining memory in GB that are available in this cluster for workload use.
        """
        return pulumi.get(self, "available_memory_gb")

    @available_memory_gb.setter
    def available_memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "available_memory_gb", value)

    @property
    @pulumi.getter(name="totalApplianceStorageGB")
    def total_appliance_storage_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The total appliance-based storage in GB supported by this cluster for workload use.
        """
        return pulumi.get(self, "total_appliance_storage_gb")

    @total_appliance_storage_gb.setter
    def total_appliance_storage_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "total_appliance_storage_gb", value)

    @property
    @pulumi.getter(name="totalCoreCount")
    def total_core_count(self) -> Optional[pulumi.Input[float]]:
        """
        The total number of cores that are supported by this cluster for workload use.
        """
        return pulumi.get(self, "total_core_count")

    @total_core_count.setter
    def total_core_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "total_core_count", value)

    @property
    @pulumi.getter(name="totalHostStorageGB")
    def total_host_storage_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The total machine or host-based storage in GB supported by this cluster for workload use.
        """
        return pulumi.get(self, "total_host_storage_gb")

    @total_host_storage_gb.setter
    def total_host_storage_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "total_host_storage_gb", value)

    @property
    @pulumi.getter(name="totalMemoryGB")
    def total_memory_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The total memory supported by this cluster for workload use.
        """
        return pulumi.get(self, "total_memory_gb")

    @total_memory_gb.setter
    def total_memory_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "total_memory_gb", value)


@pulumi.input_type
class CniBgpConfigurationArgs:
    def __init__(__self__, *,
                 bgp_peers: Optional[pulumi.Input[Sequence[pulumi.Input['BgpPeerArgs']]]] = None,
                 community_advertisements: Optional[pulumi.Input[Sequence[pulumi.Input['CommunityAdvertisementArgs']]]] = None,
                 node_mesh_password: Optional[pulumi.Input[str]] = None,
                 service_external_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_load_balancer_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['BgpPeerArgs']]] bgp_peers: The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
        :param pulumi.Input[Sequence[pulumi.Input['CommunityAdvertisementArgs']]] community_advertisements: The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
               communities that should be associated with that prefix when it is announced.
        :param pulumi.Input[str] node_mesh_password: The password of the Calico node mesh. It defaults to a randomly-generated string when not provided.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_external_prefixes: The subnet blocks in CIDR format for Kubernetes service external IPs to be advertised over BGP.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_load_balancer_prefixes: The subnet blocks in CIDR format for Kubernetes load balancers. Load balancer IPs will only be advertised if they
               are within one of these blocks.
        """
        if bgp_peers is not None:
            pulumi.set(__self__, "bgp_peers", bgp_peers)
        if community_advertisements is not None:
            pulumi.set(__self__, "community_advertisements", community_advertisements)
        if node_mesh_password is not None:
            pulumi.set(__self__, "node_mesh_password", node_mesh_password)
        if service_external_prefixes is not None:
            pulumi.set(__self__, "service_external_prefixes", service_external_prefixes)
        if service_load_balancer_prefixes is not None:
            pulumi.set(__self__, "service_load_balancer_prefixes", service_load_balancer_prefixes)

    @property
    @pulumi.getter(name="bgpPeers")
    def bgp_peers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BgpPeerArgs']]]]:
        """
        The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
        """
        return pulumi.get(self, "bgp_peers")

    @bgp_peers.setter
    def bgp_peers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BgpPeerArgs']]]]):
        pulumi.set(self, "bgp_peers", value)

    @property
    @pulumi.getter(name="communityAdvertisements")
    def community_advertisements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CommunityAdvertisementArgs']]]]:
        """
        The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
        communities that should be associated with that prefix when it is announced.
        """
        return pulumi.get(self, "community_advertisements")

    @community_advertisements.setter
    def community_advertisements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CommunityAdvertisementArgs']]]]):
        pulumi.set(self, "community_advertisements", value)

    @property
    @pulumi.getter(name="nodeMeshPassword")
    def node_mesh_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the Calico node mesh. It defaults to a randomly-generated string when not provided.
        """
        return pulumi.get(self, "node_mesh_password")

    @node_mesh_password.setter
    def node_mesh_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_mesh_password", value)

    @property
    @pulumi.getter(name="serviceExternalPrefixes")
    def service_external_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The subnet blocks in CIDR format for Kubernetes service external IPs to be advertised over BGP.
        """
        return pulumi.get(self, "service_external_prefixes")

    @service_external_prefixes.setter
    def service_external_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_external_prefixes", value)

    @property
    @pulumi.getter(name="serviceLoadBalancerPrefixes")
    def service_load_balancer_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The subnet blocks in CIDR format for Kubernetes load balancers. Load balancer IPs will only be advertised if they
        are within one of these blocks.
        """
        return pulumi.get(self, "service_load_balancer_prefixes")

    @service_load_balancer_prefixes.setter
    def service_load_balancer_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_load_balancer_prefixes", value)


@pulumi.input_type
class CommunityAdvertisementArgs:
    def __init__(__self__, *,
                 communities: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_prefix: pulumi.Input[str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] communities: The list of community strings to announce with this prefix.
        :param pulumi.Input[str] subnet_prefix: The subnet in CIDR format for which properties should be advertised.
        """
        pulumi.set(__self__, "communities", communities)
        pulumi.set(__self__, "subnet_prefix", subnet_prefix)

    @property
    @pulumi.getter
    def communities(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of community strings to announce with this prefix.
        """
        return pulumi.get(self, "communities")

    @communities.setter
    def communities(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "communities", value)

    @property
    @pulumi.getter(name="subnetPrefix")
    def subnet_prefix(self) -> pulumi.Input[str]:
        """
        The subnet in CIDR format for which properties should be advertised.
        """
        return pulumi.get(self, "subnet_prefix")

    @subnet_prefix.setter
    def subnet_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_prefix", value)


@pulumi.input_type
class EgressEndpointArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[str],
                 endpoints: pulumi.Input[Sequence[pulumi.Input['EndpointDependencyArgs']]]):
        """
        :param pulumi.Input[str] category: The descriptive category name of endpoints accessible by the AKS agent node. For example, azure-resource-management, API server, etc. The platform egress endpoints provided by default will use the category 'default'.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointDependencyArgs']]] endpoints: The list of endpoint dependencies.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "endpoints", endpoints)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Input[str]:
        """
        The descriptive category name of endpoints accessible by the AKS agent node. For example, azure-resource-management, API server, etc. The platform egress endpoints provided by default will use the category 'default'.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[str]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Input[Sequence[pulumi.Input['EndpointDependencyArgs']]]:
        """
        The list of endpoint dependencies.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: pulumi.Input[Sequence[pulumi.Input['EndpointDependencyArgs']]]):
        pulumi.set(self, "endpoints", value)


@pulumi.input_type
class EndpointDependencyArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 port: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] domain_name: The domain name of the dependency.
        :param pulumi.Input[float] port: The port of this endpoint.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The domain name of the dependency.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[float]]:
        """
        The port of this endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ExtendedLocationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The resource ID of the extended location on which the resource will be created.
        :param pulumi.Input[str] type: The extended location type, for example, CustomLocation.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The resource ID of the extended location on which the resource will be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The extended location type, for example, CustomLocation.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ImageRepositoryCredentialsArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 registry_url: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: The password or token used to access an image in the target repository.
        :param pulumi.Input[str] registry_url: The URL of the authentication server used to validate the repository credentials.
        :param pulumi.Input[str] username: The username used to access an image in the target repository.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "registry_url", registry_url)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password or token used to access an image in the target repository.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="registryUrl")
    def registry_url(self) -> pulumi.Input[str]:
        """
        The URL of the authentication server used to validate the repository credentials.
        """
        return pulumi.get(self, "registry_url")

    @registry_url.setter
    def registry_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry_url", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username used to access an image in the target repository.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class KeySetUserArgs:
    def __init__(__self__, *,
                 azure_user_name: pulumi.Input[str],
                 ssh_public_key: pulumi.Input['SshPublicKeyArgs'],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] azure_user_name: The Azure Active Directory user name (email name).
        :param pulumi.Input[str] description: The free-form description for this user.
        """
        pulumi.set(__self__, "azure_user_name", azure_user_name)
        pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="azureUserName")
    def azure_user_name(self) -> pulumi.Input[str]:
        """
        The Azure Active Directory user name (email name).
        """
        return pulumi.get(self, "azure_user_name")

    @azure_user_name.setter
    def azure_user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "azure_user_name", value)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> pulumi.Input['SshPublicKeyArgs']:
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: pulumi.Input['SshPublicKeyArgs']):
        pulumi.set(self, "ssh_public_key", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The free-form description for this user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ManagedResourceGroupConfigurationArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] location: The location of the managed resource group. If not specified, the location of the parent resource is chosen.
        :param pulumi.Input[str] name: The name for the managed resource group. If not specified, the unique name is automatically generated.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the managed resource group. If not specified, the location of the parent resource is chosen.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the managed resource group. If not specified, the unique name is automatically generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class NetworkAttachmentArgs:
    def __init__(__self__, *,
                 attached_network_id: pulumi.Input[str],
                 ip_allocation_method: pulumi.Input[Union[str, 'VirtualMachineIPAllocationMethod']],
                 default_gateway: Optional[pulumi.Input[Union[str, 'DefaultGateway']]] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 network_attachment_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] attached_network_id: The resource ID of the associated network attached to the virtual machine.
               It can be one of cloudServicesNetwork, l3Network, l2Network or trunkedNetwork resources.
        :param pulumi.Input[Union[str, 'VirtualMachineIPAllocationMethod']] ip_allocation_method: The IP allocation mechanism for the virtual machine.
               Dynamic and Static are only valid for l3Network which may also specify Disabled.
               Otherwise, Disabled is the only permitted value.
        :param pulumi.Input[Union[str, 'DefaultGateway']] default_gateway: The indicator of whether this is the default gateway.
               Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
        :param pulumi.Input[str] ipv4_address: The IPv4 address of the virtual machine.
               
               This field is used only if the attached network has IPAllocationType of IPV4 or DualStack.
               
               If IPAllocationMethod is:
               Static - this field must contain a user specified IPv4 address from within the subnet specified in the attached network.
               Dynamic - this field is read-only, but will be populated with an address from within the subnet specified in the attached network.
               Disabled - this field will be empty.
        :param pulumi.Input[str] ipv6_address: The IPv6 address of the virtual machine.
               
               This field is used only if the attached network has IPAllocationType of IPV6 or DualStack.
               
               If IPAllocationMethod is:
               Static - this field must contain an IPv6 address range from within the range specified in the attached network.
               Dynamic - this field is read-only, but will be populated with an range from within the subnet specified in the attached network.
               Disabled - this field will be empty.
        :param pulumi.Input[str] network_attachment_name: The associated network's interface name.
               If specified, the network attachment name has a maximum length of 15 characters and must be unique to this virtual machine.
               If the user doesn’t specify this value, the default interface name of the network resource will be used.
               For a CloudServicesNetwork resource, this name will be ignored.
        """
        pulumi.set(__self__, "attached_network_id", attached_network_id)
        pulumi.set(__self__, "ip_allocation_method", ip_allocation_method)
        if default_gateway is not None:
            pulumi.set(__self__, "default_gateway", default_gateway)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if network_attachment_name is not None:
            pulumi.set(__self__, "network_attachment_name", network_attachment_name)

    @property
    @pulumi.getter(name="attachedNetworkId")
    def attached_network_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the associated network attached to the virtual machine.
        It can be one of cloudServicesNetwork, l3Network, l2Network or trunkedNetwork resources.
        """
        return pulumi.get(self, "attached_network_id")

    @attached_network_id.setter
    def attached_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "attached_network_id", value)

    @property
    @pulumi.getter(name="ipAllocationMethod")
    def ip_allocation_method(self) -> pulumi.Input[Union[str, 'VirtualMachineIPAllocationMethod']]:
        """
        The IP allocation mechanism for the virtual machine.
        Dynamic and Static are only valid for l3Network which may also specify Disabled.
        Otherwise, Disabled is the only permitted value.
        """
        return pulumi.get(self, "ip_allocation_method")

    @ip_allocation_method.setter
    def ip_allocation_method(self, value: pulumi.Input[Union[str, 'VirtualMachineIPAllocationMethod']]):
        pulumi.set(self, "ip_allocation_method", value)

    @property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> Optional[pulumi.Input[Union[str, 'DefaultGateway']]]:
        """
        The indicator of whether this is the default gateway.
        Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
        """
        return pulumi.get(self, "default_gateway")

    @default_gateway.setter
    def default_gateway(self, value: Optional[pulumi.Input[Union[str, 'DefaultGateway']]]):
        pulumi.set(self, "default_gateway", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address of the virtual machine.

        This field is used only if the attached network has IPAllocationType of IPV4 or DualStack.

        If IPAllocationMethod is:
        Static - this field must contain a user specified IPv4 address from within the subnet specified in the attached network.
        Dynamic - this field is read-only, but will be populated with an address from within the subnet specified in the attached network.
        Disabled - this field will be empty.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 address of the virtual machine.

        This field is used only if the attached network has IPAllocationType of IPV6 or DualStack.

        If IPAllocationMethod is:
        Static - this field must contain an IPv6 address range from within the range specified in the attached network.
        Dynamic - this field is read-only, but will be populated with an range from within the subnet specified in the attached network.
        Disabled - this field will be empty.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter(name="networkAttachmentName")
    def network_attachment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The associated network's interface name.
        If specified, the network attachment name has a maximum length of 15 characters and must be unique to this virtual machine.
        If the user doesn’t specify this value, the default interface name of the network resource will be used.
        For a CloudServicesNetwork resource, this name will be ignored.
        """
        return pulumi.get(self, "network_attachment_name")

    @network_attachment_name.setter
    def network_attachment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_attachment_name", value)


@pulumi.input_type
class OsDiskArgs:
    def __init__(__self__, *,
                 disk_size_gb: pulumi.Input[float],
                 create_option: Optional[pulumi.Input[Union[str, 'OsDiskCreateOption']]] = None,
                 delete_option: Optional[pulumi.Input[Union[str, 'OsDiskDeleteOption']]] = None):
        """
        :param pulumi.Input[float] disk_size_gb: The size of the disk in gigabytes. Required if the createOption is Ephemeral.
        :param pulumi.Input[Union[str, 'OsDiskCreateOption']] create_option: The strategy for creating the OS disk.
        :param pulumi.Input[Union[str, 'OsDiskDeleteOption']] delete_option: The strategy for deleting the OS disk.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if create_option is None:
            create_option = 'Ephemeral'
        if create_option is not None:
            pulumi.set(__self__, "create_option", create_option)
        if delete_option is None:
            delete_option = 'Delete'
        if delete_option is not None:
            pulumi.set(__self__, "delete_option", delete_option)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> pulumi.Input[float]:
        """
        The size of the disk in gigabytes. Required if the createOption is Ephemeral.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: pulumi.Input[float]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> Optional[pulumi.Input[Union[str, 'OsDiskCreateOption']]]:
        """
        The strategy for creating the OS disk.
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: Optional[pulumi.Input[Union[str, 'OsDiskCreateOption']]]):
        pulumi.set(self, "create_option", value)

    @property
    @pulumi.getter(name="deleteOption")
    def delete_option(self) -> Optional[pulumi.Input[Union[str, 'OsDiskDeleteOption']]]:
        """
        The strategy for deleting the OS disk.
        """
        return pulumi.get(self, "delete_option")

    @delete_option.setter
    def delete_option(self, value: Optional[pulumi.Input[Union[str, 'OsDiskDeleteOption']]]):
        pulumi.set(self, "delete_option", value)


@pulumi.input_type
class RackDefinitionArgs:
    def __init__(__self__, *,
                 network_rack_id: pulumi.Input[str],
                 rack_serial_number: pulumi.Input[str],
                 rack_sku_id: pulumi.Input[str],
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 bare_metal_machine_configuration_data: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalMachineConfigurationDataArgs']]]] = None,
                 rack_location: Optional[pulumi.Input[str]] = None,
                 storage_appliance_configuration_data: Optional[pulumi.Input[Sequence[pulumi.Input['StorageApplianceConfigurationDataArgs']]]] = None):
        """
        :param pulumi.Input[str] network_rack_id: The resource ID of the network rack that matches this rack definition.
        :param pulumi.Input[str] rack_serial_number: The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
        :param pulumi.Input[str] rack_sku_id: The resource ID of the sku for the rack being added.
        :param pulumi.Input[str] availability_zone: The zone name used for this rack when created.
        :param pulumi.Input[Sequence[pulumi.Input['BareMetalMachineConfigurationDataArgs']]] bare_metal_machine_configuration_data: The unordered list of bare metal machine configuration.
        :param pulumi.Input[str] rack_location: The free-form description of the rack's location.
        :param pulumi.Input[Sequence[pulumi.Input['StorageApplianceConfigurationDataArgs']]] storage_appliance_configuration_data: The list of storage appliance configuration data for this rack.
        """
        pulumi.set(__self__, "network_rack_id", network_rack_id)
        pulumi.set(__self__, "rack_serial_number", rack_serial_number)
        pulumi.set(__self__, "rack_sku_id", rack_sku_id)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if bare_metal_machine_configuration_data is not None:
            pulumi.set(__self__, "bare_metal_machine_configuration_data", bare_metal_machine_configuration_data)
        if rack_location is not None:
            pulumi.set(__self__, "rack_location", rack_location)
        if storage_appliance_configuration_data is not None:
            pulumi.set(__self__, "storage_appliance_configuration_data", storage_appliance_configuration_data)

    @property
    @pulumi.getter(name="networkRackId")
    def network_rack_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the network rack that matches this rack definition.
        """
        return pulumi.get(self, "network_rack_id")

    @network_rack_id.setter
    def network_rack_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_rack_id", value)

    @property
    @pulumi.getter(name="rackSerialNumber")
    def rack_serial_number(self) -> pulumi.Input[str]:
        """
        The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
        """
        return pulumi.get(self, "rack_serial_number")

    @rack_serial_number.setter
    def rack_serial_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "rack_serial_number", value)

    @property
    @pulumi.getter(name="rackSkuId")
    def rack_sku_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the sku for the rack being added.
        """
        return pulumi.get(self, "rack_sku_id")

    @rack_sku_id.setter
    def rack_sku_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rack_sku_id", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone name used for this rack when created.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="bareMetalMachineConfigurationData")
    def bare_metal_machine_configuration_data(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalMachineConfigurationDataArgs']]]]:
        """
        The unordered list of bare metal machine configuration.
        """
        return pulumi.get(self, "bare_metal_machine_configuration_data")

    @bare_metal_machine_configuration_data.setter
    def bare_metal_machine_configuration_data(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BareMetalMachineConfigurationDataArgs']]]]):
        pulumi.set(self, "bare_metal_machine_configuration_data", value)

    @property
    @pulumi.getter(name="rackLocation")
    def rack_location(self) -> Optional[pulumi.Input[str]]:
        """
        The free-form description of the rack's location.
        """
        return pulumi.get(self, "rack_location")

    @rack_location.setter
    def rack_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rack_location", value)

    @property
    @pulumi.getter(name="storageApplianceConfigurationData")
    def storage_appliance_configuration_data(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageApplianceConfigurationDataArgs']]]]:
        """
        The list of storage appliance configuration data for this rack.
        """
        return pulumi.get(self, "storage_appliance_configuration_data")

    @storage_appliance_configuration_data.setter
    def storage_appliance_configuration_data(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageApplianceConfigurationDataArgs']]]]):
        pulumi.set(self, "storage_appliance_configuration_data", value)


@pulumi.input_type
class ServicePrincipalInformationArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[str],
                 password: pulumi.Input[str],
                 principal_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] application_id: The application ID, also known as client ID, of the service principal.
        :param pulumi.Input[str] password: The password of the service principal.
        :param pulumi.Input[str] principal_id: The principal ID, also known as the object ID, of the service principal.
        :param pulumi.Input[str] tenant_id: The tenant ID, also known as the directory ID, of the tenant in which the service principal is created.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[str]:
        """
        The application ID, also known as client ID, of the service principal.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password of the service principal.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[str]:
        """
        The principal ID, also known as the object ID, of the service principal.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        The tenant ID, also known as the directory ID, of the tenant in which the service principal is created.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class SshPublicKeyArgs:
    def __init__(__self__, *,
                 key_data: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key_data: The public ssh key of the user.
        """
        pulumi.set(__self__, "key_data", key_data)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> pulumi.Input[str]:
        """
        The public ssh key of the user.
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_data", value)


@pulumi.input_type
class StorageApplianceConfigurationDataArgs:
    def __init__(__self__, *,
                 admin_credentials: pulumi.Input['AdministrativeCredentialsArgs'],
                 rack_slot: pulumi.Input[float],
                 serial_number: pulumi.Input[str],
                 storage_appliance_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[float] rack_slot: The slot that storage appliance is in the rack based on the BOM configuration.
        :param pulumi.Input[str] serial_number: The serial number of the appliance.
        :param pulumi.Input[str] storage_appliance_name: The user-provided name for the storage appliance that will be created from this specification.
        """
        pulumi.set(__self__, "admin_credentials", admin_credentials)
        pulumi.set(__self__, "rack_slot", rack_slot)
        pulumi.set(__self__, "serial_number", serial_number)
        if storage_appliance_name is not None:
            pulumi.set(__self__, "storage_appliance_name", storage_appliance_name)

    @property
    @pulumi.getter(name="adminCredentials")
    def admin_credentials(self) -> pulumi.Input['AdministrativeCredentialsArgs']:
        return pulumi.get(self, "admin_credentials")

    @admin_credentials.setter
    def admin_credentials(self, value: pulumi.Input['AdministrativeCredentialsArgs']):
        pulumi.set(self, "admin_credentials", value)

    @property
    @pulumi.getter(name="rackSlot")
    def rack_slot(self) -> pulumi.Input[float]:
        """
        The slot that storage appliance is in the rack based on the BOM configuration.
        """
        return pulumi.get(self, "rack_slot")

    @rack_slot.setter
    def rack_slot(self, value: pulumi.Input[float]):
        pulumi.set(self, "rack_slot", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Input[str]:
        """
        The serial number of the appliance.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "serial_number", value)

    @property
    @pulumi.getter(name="storageApplianceName")
    def storage_appliance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-provided name for the storage appliance that will be created from this specification.
        """
        return pulumi.get(self, "storage_appliance_name")

    @storage_appliance_name.setter
    def storage_appliance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_appliance_name", value)


@pulumi.input_type
class StorageProfileArgs:
    def __init__(__self__, *,
                 os_disk: pulumi.Input['OsDiskArgs'],
                 volume_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] volume_attachments: The resource IDs of volumes that are requested to be attached to the virtual machine.
        """
        pulumi.set(__self__, "os_disk", os_disk)
        if volume_attachments is not None:
            pulumi.set(__self__, "volume_attachments", volume_attachments)

    @property
    @pulumi.getter(name="osDisk")
    def os_disk(self) -> pulumi.Input['OsDiskArgs']:
        return pulumi.get(self, "os_disk")

    @os_disk.setter
    def os_disk(self, value: pulumi.Input['OsDiskArgs']):
        pulumi.set(self, "os_disk", value)

    @property
    @pulumi.getter(name="volumeAttachments")
    def volume_attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The resource IDs of volumes that are requested to be attached to the virtual machine.
        """
        return pulumi.get(self, "volume_attachments")

    @volume_attachments.setter
    def volume_attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "volume_attachments", value)


@pulumi.input_type
class ValidationThresholdArgs:
    def __init__(__self__, *,
                 grouping: pulumi.Input[Union[str, 'ValidationThresholdGrouping']],
                 type: pulumi.Input[Union[str, 'ValidationThresholdType']],
                 value: pulumi.Input[float]):
        """
        :param pulumi.Input[Union[str, 'ValidationThresholdGrouping']] grouping: Selection of how the type evaluation is applied to the cluster calculation.
        :param pulumi.Input[Union[str, 'ValidationThresholdType']] type: Selection of how the threshold should be evaluated.
        :param pulumi.Input[float] value: The numeric threshold value.
        """
        pulumi.set(__self__, "grouping", grouping)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def grouping(self) -> pulumi.Input[Union[str, 'ValidationThresholdGrouping']]:
        """
        Selection of how the type evaluation is applied to the cluster calculation.
        """
        return pulumi.get(self, "grouping")

    @grouping.setter
    def grouping(self, value: pulumi.Input[Union[str, 'ValidationThresholdGrouping']]):
        pulumi.set(self, "grouping", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ValidationThresholdType']]:
        """
        Selection of how the threshold should be evaluated.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ValidationThresholdType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[float]:
        """
        The numeric threshold value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[float]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class VirtualMachinePlacementHintArgs:
    def __init__(__self__, *,
                 hint_type: pulumi.Input[Union[str, 'VirtualMachinePlacementHintType']],
                 resource_id: pulumi.Input[str],
                 scheduling_execution: pulumi.Input[Union[str, 'VirtualMachineSchedulingExecution']],
                 scope: pulumi.Input[Union[str, 'VirtualMachinePlacementHintPodAffinityScope']]):
        """
        :param pulumi.Input[Union[str, 'VirtualMachinePlacementHintType']] hint_type: The specification of whether this hint supports affinity or anti-affinity with the referenced resources.
        :param pulumi.Input[str] resource_id: The resource ID of the target object that the placement hints will be checked against, e.g., the bare metal node to host the virtual machine.
        :param pulumi.Input[Union[str, 'VirtualMachineSchedulingExecution']] scheduling_execution: The indicator of whether the hint is a hard or soft requirement during scheduling.
        :param pulumi.Input[Union[str, 'VirtualMachinePlacementHintPodAffinityScope']] scope: The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in the case of node affinity.
        """
        pulumi.set(__self__, "hint_type", hint_type)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "scheduling_execution", scheduling_execution)
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="hintType")
    def hint_type(self) -> pulumi.Input[Union[str, 'VirtualMachinePlacementHintType']]:
        """
        The specification of whether this hint supports affinity or anti-affinity with the referenced resources.
        """
        return pulumi.get(self, "hint_type")

    @hint_type.setter
    def hint_type(self, value: pulumi.Input[Union[str, 'VirtualMachinePlacementHintType']]):
        pulumi.set(self, "hint_type", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the target object that the placement hints will be checked against, e.g., the bare metal node to host the virtual machine.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="schedulingExecution")
    def scheduling_execution(self) -> pulumi.Input[Union[str, 'VirtualMachineSchedulingExecution']]:
        """
        The indicator of whether the hint is a hard or soft requirement during scheduling.
        """
        return pulumi.get(self, "scheduling_execution")

    @scheduling_execution.setter
    def scheduling_execution(self, value: pulumi.Input[Union[str, 'VirtualMachineSchedulingExecution']]):
        pulumi.set(self, "scheduling_execution", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[Union[str, 'VirtualMachinePlacementHintPodAffinityScope']]:
        """
        The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in the case of node affinity.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[Union[str, 'VirtualMachinePlacementHintPodAffinityScope']]):
        pulumi.set(self, "scope", value)


