# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AadAuthenticationParametersResponse',
    'AddressSpaceResponse',
    'ApplicationGatewayAuthenticationCertificateResponse',
    'ApplicationGatewayAutoscaleConfigurationResponse',
    'ApplicationGatewayBackendAddressPoolResponse',
    'ApplicationGatewayBackendAddressResponse',
    'ApplicationGatewayBackendHealthHttpSettingsResponse',
    'ApplicationGatewayBackendHealthServerResponse',
    'ApplicationGatewayBackendHttpSettingsResponse',
    'ApplicationGatewayConnectionDrainingResponse',
    'ApplicationGatewayCustomErrorResponse',
    'ApplicationGatewayFirewallDisabledRuleGroupResponse',
    'ApplicationGatewayFirewallExclusionResponse',
    'ApplicationGatewayFrontendIPConfigurationResponse',
    'ApplicationGatewayFrontendPortResponse',
    'ApplicationGatewayHeaderConfigurationResponse',
    'ApplicationGatewayHttpListenerResponse',
    'ApplicationGatewayIPConfigurationResponse',
    'ApplicationGatewayPathRuleResponse',
    'ApplicationGatewayPrivateEndpointConnectionResponse',
    'ApplicationGatewayPrivateLinkConfigurationResponse',
    'ApplicationGatewayPrivateLinkIpConfigurationResponse',
    'ApplicationGatewayProbeHealthResponseMatchResponse',
    'ApplicationGatewayProbeResponse',
    'ApplicationGatewayRedirectConfigurationResponse',
    'ApplicationGatewayRequestRoutingRuleResponse',
    'ApplicationGatewayResponse',
    'ApplicationGatewayRewriteRuleActionSetResponse',
    'ApplicationGatewayRewriteRuleConditionResponse',
    'ApplicationGatewayRewriteRuleResponse',
    'ApplicationGatewayRewriteRuleSetResponse',
    'ApplicationGatewaySkuResponse',
    'ApplicationGatewaySslCertificateResponse',
    'ApplicationGatewaySslPolicyResponse',
    'ApplicationGatewayTrustedRootCertificateResponse',
    'ApplicationGatewayUrlConfigurationResponse',
    'ApplicationGatewayUrlPathMapResponse',
    'ApplicationGatewayWebApplicationFirewallConfigurationResponse',
    'ApplicationRuleResponse',
    'ApplicationSecurityGroupResponse',
    'AzureFirewallApplicationRuleCollectionResponse',
    'AzureFirewallApplicationRuleProtocolResponse',
    'AzureFirewallApplicationRuleResponse',
    'AzureFirewallIPConfigurationResponse',
    'AzureFirewallIpGroupsResponse',
    'AzureFirewallNatRCActionResponse',
    'AzureFirewallNatRuleCollectionResponse',
    'AzureFirewallNatRuleResponse',
    'AzureFirewallNetworkRuleCollectionResponse',
    'AzureFirewallNetworkRuleResponse',
    'AzureFirewallPublicIPAddressResponse',
    'AzureFirewallRCActionResponse',
    'AzureFirewallSkuResponse',
    'BackendAddressPoolResponse',
    'BackendPoolResponse',
    'BackendPoolsSettingsResponse',
    'BackendResponse',
    'BastionActiveSessionResponse',
    'BastionHostIPConfigurationResponse',
    'BastionShareableLinkResponse',
    'BgpPeerStatusResponse',
    'BgpSettingsResponse',
    'BreakOutCategoryPoliciesResponse',
    'CacheConfigurationResponse',
    'ConnectionMonitorDestinationResponse',
    'ConnectionMonitorEndpointFilterItemResponse',
    'ConnectionMonitorEndpointFilterResponse',
    'ConnectionMonitorEndpointResponse',
    'ConnectionMonitorHttpConfigurationResponse',
    'ConnectionMonitorIcmpConfigurationResponse',
    'ConnectionMonitorOutputResponse',
    'ConnectionMonitorSourceResponse',
    'ConnectionMonitorSuccessThresholdResponse',
    'ConnectionMonitorTcpConfigurationResponse',
    'ConnectionMonitorTestConfigurationResponse',
    'ConnectionMonitorTestGroupResponse',
    'ConnectionMonitorWorkspaceSettingsResponse',
    'ContainerNetworkInterfaceConfigurationResponse',
    'ContainerNetworkInterfaceIpConfigurationResponse',
    'ContainerNetworkInterfaceResponse',
    'ContainerResponse',
    'CustomDnsConfigPropertiesFormatResponse',
    'CustomHttpsConfigurationResponse',
    'DdosSettingsResponse',
    'DelegationResponse',
    'DevicePropertiesResponse',
    'DhcpOptionsResponse',
    'DnsSettingsResponse',
    'ExpressRouteCircuitAuthorizationResponse',
    'ExpressRouteCircuitConnectionResponse',
    'ExpressRouteCircuitPeeringConfigResponse',
    'ExpressRouteCircuitPeeringIdResponse',
    'ExpressRouteCircuitPeeringResponse',
    'ExpressRouteCircuitServiceProviderPropertiesResponse',
    'ExpressRouteCircuitSkuResponse',
    'ExpressRouteCircuitStatsResponse',
    'ExpressRouteConnectionIdResponse',
    'ExpressRouteConnectionResponse',
    'ExpressRouteGatewayPropertiesResponseAutoScaleConfiguration',
    'ExpressRouteGatewayPropertiesResponseBounds',
    'ExpressRouteLinkMacSecConfigResponse',
    'ExpressRouteLinkResponse',
    'FirewallPolicyFilterRuleCollectionActionResponse',
    'FirewallPolicyFilterRuleCollectionResponse',
    'FirewallPolicyNatRuleCollectionActionResponse',
    'FirewallPolicyNatRuleCollectionResponse',
    'FirewallPolicyRuleApplicationProtocolResponse',
    'FirewallPolicyThreatIntelWhitelistResponse',
    'FlowLogFormatParametersResponse',
    'FlowLogResponse',
    'ForwardingConfigurationResponse',
    'FrontendEndpointResponse',
    'FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink',
    'FrontendIPConfigurationResponse',
    'GatewayRouteResponse',
    'HTTPHeaderResponse',
    'HeaderActionResponse',
    'HealthProbeSettingsModelResponse',
    'HubIPAddressesResponse',
    'HubPublicIPAddressesResponse',
    'HubRouteResponse',
    'IPConfigurationBgpPeeringAddressResponse',
    'IPConfigurationProfileResponse',
    'IPConfigurationResponse',
    'InboundNatPoolResponse',
    'InboundNatRuleResponse',
    'IpTagResponse',
    'IpsecPolicyResponse',
    'Ipv6CircuitConnectionConfigResponse',
    'Ipv6ExpressRouteCircuitPeeringConfigResponse',
    'KeyVaultCertificateSourceParametersResponseVault',
    'LoadBalancerBackendAddressResponse',
    'LoadBalancerSkuResponse',
    'LoadBalancingRuleResponse',
    'LoadBalancingSettingsModelResponse',
    'LocalNetworkGatewayResponse',
    'ManagedRuleGroupOverrideResponse',
    'ManagedRuleOverrideResponse',
    'ManagedRuleSetResponse',
    'ManagedRulesDefinitionResponse',
    'ManagedServiceIdentityResponse',
    'ManagedServiceIdentityResponseUserAssignedIdentities',
    'MatchConditionResponse',
    'MatchVariableResponse',
    'NatGatewaySkuResponse',
    'NatRuleResponse',
    'NetworkInterfaceDnsSettingsResponse',
    'NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse',
    'NetworkInterfaceIPConfigurationResponse',
    'NetworkInterfaceResponse',
    'NetworkInterfaceTapConfigurationResponse',
    'NetworkRuleResponse',
    'NetworkSecurityGroupResponse',
    'Office365PolicyPropertiesResponse',
    'OutboundRuleResponse',
    'OwaspCrsExclusionEntryResponse',
    'P2SConnectionConfigurationResponse',
    'P2SVpnGatewayResponse',
    'PacketCaptureFilterResponse',
    'PacketCaptureStorageLocationResponse',
    'PeerExpressRouteCircuitConnectionResponse',
    'PolicySettingsResponse',
    'PrivateDnsZoneConfigResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'PrivateLinkServiceIpConfigurationResponse',
    'PrivateLinkServicePropertiesResponseAutoApproval',
    'PrivateLinkServicePropertiesResponseVisibility',
    'ProbeResponse',
    'PropagatedRouteTableResponse',
    'ProtocolCustomSettingsFormatResponse',
    'PublicIPAddressDnsSettingsResponse',
    'PublicIPAddressResponse',
    'PublicIPAddressSkuResponse',
    'PublicIPPrefixSkuResponse',
    'RadiusServerResponse',
    'RecordSetResponse',
    'RedirectConfigurationResponse',
    'ReferencedPublicIpAddressResponse',
    'ResourceNavigationLinkResponse',
    'RetentionPolicyParametersResponse',
    'RouteFilterRuleResponse',
    'RouteResponse',
    'RouteTableResponse',
    'RoutingConfigurationResponse',
    'RoutingRuleResponse',
    'RoutingRuleUpdateParametersResponseWebApplicationFirewallPolicyLink',
    'RulesEngineActionResponse',
    'RulesEngineMatchConditionResponse',
    'RulesEngineResponse',
    'RulesEngineRuleResponse',
    'SecurityRuleResponse',
    'ServiceAssociationLinkResponse',
    'ServiceEndpointPolicyDefinitionResponse',
    'ServiceEndpointPolicyResponse',
    'ServiceEndpointPropertiesFormatResponse',
    'StaticRouteResponse',
    'SubResourceResponse',
    'SubnetResponse',
    'TrafficAnalyticsConfigurationPropertiesResponse',
    'TrafficAnalyticsPropertiesResponse',
    'TrafficSelectorPolicyResponse',
    'TunnelConnectionHealthResponse',
    'VMResponse',
    'VirtualApplianceNicPropertiesResponse',
    'VirtualApplianceSkuPropertiesResponse',
    'VirtualHubIdResponse',
    'VirtualHubRouteResponse',
    'VirtualHubRouteTableResponse',
    'VirtualHubRouteTableV2Response',
    'VirtualHubRouteV2Response',
    'VirtualNetworkBgpCommunitiesResponse',
    'VirtualNetworkGatewayIPConfigurationResponse',
    'VirtualNetworkGatewayResponse',
    'VirtualNetworkGatewaySkuResponse',
    'VirtualNetworkPeeringResponse',
    'VirtualNetworkTapResponse',
    'VnetRouteResponse',
    'VpnClientConfigurationResponse',
    'VpnClientConnectionHealthDetailResponse',
    'VpnClientConnectionHealthResponse',
    'VpnClientRevokedCertificateResponse',
    'VpnClientRootCertificateResponse',
    'VpnConnectionResponse',
    'VpnLinkBgpSettingsResponse',
    'VpnLinkProviderPropertiesResponse',
    'VpnServerConfigRadiusClientRootCertificateResponse',
    'VpnServerConfigRadiusServerRootCertificateResponse',
    'VpnServerConfigVpnClientRevokedCertificateResponse',
    'VpnServerConfigVpnClientRootCertificateResponse',
    'VpnSiteLinkConnectionResponse',
    'VpnSiteLinkResponse',
    'WebApplicationFirewallCustomRuleResponse',
]

@pulumi.output_type
class AadAuthenticationParametersResponse(dict):
    """
    AAD Vpn authentication type related parameters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadAudience":
            suggest = "aad_audience"
        elif key == "aadIssuer":
            suggest = "aad_issuer"
        elif key == "aadTenant":
            suggest = "aad_tenant"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AadAuthenticationParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AadAuthenticationParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AadAuthenticationParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_audience: Optional[str] = None,
                 aad_issuer: Optional[str] = None,
                 aad_tenant: Optional[str] = None):
        """
        AAD Vpn authentication type related parameters.
        :param str aad_audience: AAD Vpn authentication parameter AAD audience.
        :param str aad_issuer: AAD Vpn authentication parameter AAD issuer.
        :param str aad_tenant: AAD Vpn authentication parameter AAD tenant.
        """
        if aad_audience is not None:
            pulumi.set(__self__, "aad_audience", aad_audience)
        if aad_issuer is not None:
            pulumi.set(__self__, "aad_issuer", aad_issuer)
        if aad_tenant is not None:
            pulumi.set(__self__, "aad_tenant", aad_tenant)

    @property
    @pulumi.getter(name="aadAudience")
    def aad_audience(self) -> Optional[str]:
        """
        AAD Vpn authentication parameter AAD audience.
        """
        return pulumi.get(self, "aad_audience")

    @property
    @pulumi.getter(name="aadIssuer")
    def aad_issuer(self) -> Optional[str]:
        """
        AAD Vpn authentication parameter AAD issuer.
        """
        return pulumi.get(self, "aad_issuer")

    @property
    @pulumi.getter(name="aadTenant")
    def aad_tenant(self) -> Optional[str]:
        """
        AAD Vpn authentication parameter AAD tenant.
        """
        return pulumi.get(self, "aad_tenant")


@pulumi.output_type
class AddressSpaceResponse(dict):
    """
    AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefixes":
            suggest = "address_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddressSpaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddressSpaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddressSpaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefixes: Optional[Sequence[str]] = None):
        """
        AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
        :param Sequence[str] address_prefixes: A list of address blocks reserved for this virtual network in CIDR notation.
        """
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        A list of address blocks reserved for this virtual network in CIDR notation.
        """
        return pulumi.get(self, "address_prefixes")


@pulumi.output_type
class ApplicationGatewayAuthenticationCertificateResponse(dict):
    """
    Authentication certificates of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayAuthenticationCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayAuthenticationCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayAuthenticationCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 data: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Authentication certificates of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the authentication certificate resource.
        :param str type: Type of the resource.
        :param str data: Certificate public data.
        :param str id: Resource ID.
        :param str name: Name of the authentication certificate that is unique within an Application Gateway.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the authentication certificate resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        Certificate public data.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the authentication certificate that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ApplicationGatewayAutoscaleConfigurationResponse(dict):
    """
    Application Gateway autoscale configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minCapacity":
            suggest = "min_capacity"
        elif key == "maxCapacity":
            suggest = "max_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayAutoscaleConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayAutoscaleConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayAutoscaleConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_capacity: int,
                 max_capacity: Optional[int] = None):
        """
        Application Gateway autoscale configuration.
        :param int min_capacity: Lower bound on number of Application Gateway capacity.
        :param int max_capacity: Upper bound on number of Application Gateway capacity.
        """
        pulumi.set(__self__, "min_capacity", min_capacity)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> int:
        """
        Lower bound on number of Application Gateway capacity.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[int]:
        """
        Upper bound on number of Application Gateway capacity.
        """
        return pulumi.get(self, "max_capacity")


@pulumi.output_type
class ApplicationGatewayBackendAddressPoolResponse(dict):
    """
    Backend Address Pool of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendIPConfigurations":
            suggest = "backend_ip_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "backendAddresses":
            suggest = "backend_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendAddressPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendAddressPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendAddressPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_ip_configurations: Sequence['outputs.NetworkInterfaceIPConfigurationResponse'],
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 backend_addresses: Optional[Sequence['outputs.ApplicationGatewayBackendAddressResponse']] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Backend Address Pool of an application gateway.
        :param Sequence['NetworkInterfaceIPConfigurationResponse'] backend_ip_configurations: Collection of references to IPs defined in network interfaces.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the backend address pool resource.
        :param str type: Type of the resource.
        :param Sequence['ApplicationGatewayBackendAddressResponse'] backend_addresses: Backend addresses.
        :param str id: Resource ID.
        :param str name: Name of the backend address pool that is unique within an Application Gateway.
        """
        pulumi.set(__self__, "backend_ip_configurations", backend_ip_configurations)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if backend_addresses is not None:
            pulumi.set(__self__, "backend_addresses", backend_addresses)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="backendIPConfigurations")
    def backend_ip_configurations(self) -> Sequence['outputs.NetworkInterfaceIPConfigurationResponse']:
        """
        Collection of references to IPs defined in network interfaces.
        """
        return pulumi.get(self, "backend_ip_configurations")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the backend address pool resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="backendAddresses")
    def backend_addresses(self) -> Optional[Sequence['outputs.ApplicationGatewayBackendAddressResponse']]:
        """
        Backend addresses.
        """
        return pulumi.get(self, "backend_addresses")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the backend address pool that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ApplicationGatewayBackendAddressResponse(dict):
    """
    Backend address of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 ip_address: Optional[str] = None):
        """
        Backend address of an application gateway.
        :param str fqdn: Fully qualified domain name (FQDN).
        :param str ip_address: IP address.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Fully qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        IP address.
        """
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class ApplicationGatewayBackendHealthHttpSettingsResponse(dict):
    """
    Application gateway BackendHealthHttp settings.
    """
    def __init__(__self__, *,
                 backend_http_settings: Optional['outputs.ApplicationGatewayBackendHttpSettingsResponse'] = None,
                 servers: Optional[Sequence['outputs.ApplicationGatewayBackendHealthServerResponse']] = None):
        """
        Application gateway BackendHealthHttp settings.
        :param 'ApplicationGatewayBackendHttpSettingsResponse' backend_http_settings: Reference to an ApplicationGatewayBackendHttpSettings resource.
        :param Sequence['ApplicationGatewayBackendHealthServerResponse'] servers: List of ApplicationGatewayBackendHealthServer resources.
        """
        if backend_http_settings is not None:
            pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)

    @property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> Optional['outputs.ApplicationGatewayBackendHttpSettingsResponse']:
        """
        Reference to an ApplicationGatewayBackendHttpSettings resource.
        """
        return pulumi.get(self, "backend_http_settings")

    @property
    @pulumi.getter
    def servers(self) -> Optional[Sequence['outputs.ApplicationGatewayBackendHealthServerResponse']]:
        """
        List of ApplicationGatewayBackendHealthServer resources.
        """
        return pulumi.get(self, "servers")


@pulumi.output_type
class ApplicationGatewayBackendHealthServerResponse(dict):
    """
    Application gateway backendhealth http settings.
    """
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 health: Optional[str] = None,
                 health_probe_log: Optional[str] = None,
                 ip_configuration: Optional['outputs.NetworkInterfaceIPConfigurationResponse'] = None):
        """
        Application gateway backendhealth http settings.
        :param str address: IP address or FQDN of backend server.
        :param str health: Health of backend server.
        :param str health_probe_log: Health Probe Log.
        :param 'NetworkInterfaceIPConfigurationResponse' ip_configuration: Reference to IP configuration of backend server.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if health_probe_log is not None:
            pulumi.set(__self__, "health_probe_log", health_probe_log)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        IP address or FQDN of backend server.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def health(self) -> Optional[str]:
        """
        Health of backend server.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="healthProbeLog")
    def health_probe_log(self) -> Optional[str]:
        """
        Health Probe Log.
        """
        return pulumi.get(self, "health_probe_log")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional['outputs.NetworkInterfaceIPConfigurationResponse']:
        """
        Reference to IP configuration of backend server.
        """
        return pulumi.get(self, "ip_configuration")


@pulumi.output_type
class ApplicationGatewayBackendHttpSettingsResponse(dict):
    """
    Backend address pool settings of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "affinityCookieName":
            suggest = "affinity_cookie_name"
        elif key == "authenticationCertificates":
            suggest = "authentication_certificates"
        elif key == "connectionDraining":
            suggest = "connection_draining"
        elif key == "cookieBasedAffinity":
            suggest = "cookie_based_affinity"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "pickHostNameFromBackendAddress":
            suggest = "pick_host_name_from_backend_address"
        elif key == "probeEnabled":
            suggest = "probe_enabled"
        elif key == "requestTimeout":
            suggest = "request_timeout"
        elif key == "trustedRootCertificates":
            suggest = "trusted_root_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendHttpSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendHttpSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendHttpSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 affinity_cookie_name: Optional[str] = None,
                 authentication_certificates: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 connection_draining: Optional['outputs.ApplicationGatewayConnectionDrainingResponse'] = None,
                 cookie_based_affinity: Optional[str] = None,
                 host_name: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None,
                 pick_host_name_from_backend_address: Optional[bool] = None,
                 port: Optional[int] = None,
                 probe: Optional['outputs.SubResourceResponse'] = None,
                 probe_enabled: Optional[bool] = None,
                 protocol: Optional[str] = None,
                 request_timeout: Optional[int] = None,
                 trusted_root_certificates: Optional[Sequence['outputs.SubResourceResponse']] = None):
        """
        Backend address pool settings of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the backend HTTP settings resource.
        :param str type: Type of the resource.
        :param str affinity_cookie_name: Cookie name to use for the affinity cookie.
        :param Sequence['SubResourceResponse'] authentication_certificates: Array of references to application gateway authentication certificates.
        :param 'ApplicationGatewayConnectionDrainingResponse' connection_draining: Connection draining of the backend http settings resource.
        :param str cookie_based_affinity: Cookie based affinity.
        :param str host_name: Host header to be sent to the backend servers.
        :param str id: Resource ID.
        :param str name: Name of the backend http settings that is unique within an Application Gateway.
        :param str path: Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
        :param bool pick_host_name_from_backend_address: Whether to pick host header should be picked from the host name of the backend server. Default value is false.
        :param int port: The destination port on the backend.
        :param 'SubResourceResponse' probe: Probe resource of an application gateway.
        :param bool probe_enabled: Whether the probe is enabled. Default value is false.
        :param str protocol: The protocol used to communicate with the backend.
        :param int request_timeout: Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
        :param Sequence['SubResourceResponse'] trusted_root_certificates: Array of references to application gateway trusted root certificates.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if affinity_cookie_name is not None:
            pulumi.set(__self__, "affinity_cookie_name", affinity_cookie_name)
        if authentication_certificates is not None:
            pulumi.set(__self__, "authentication_certificates", authentication_certificates)
        if connection_draining is not None:
            pulumi.set(__self__, "connection_draining", connection_draining)
        if cookie_based_affinity is not None:
            pulumi.set(__self__, "cookie_based_affinity", cookie_based_affinity)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if pick_host_name_from_backend_address is not None:
            pulumi.set(__self__, "pick_host_name_from_backend_address", pick_host_name_from_backend_address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if probe is not None:
            pulumi.set(__self__, "probe", probe)
        if probe_enabled is not None:
            pulumi.set(__self__, "probe_enabled", probe_enabled)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if trusted_root_certificates is not None:
            pulumi.set(__self__, "trusted_root_certificates", trusted_root_certificates)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the backend HTTP settings resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="affinityCookieName")
    def affinity_cookie_name(self) -> Optional[str]:
        """
        Cookie name to use for the affinity cookie.
        """
        return pulumi.get(self, "affinity_cookie_name")

    @property
    @pulumi.getter(name="authenticationCertificates")
    def authentication_certificates(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Array of references to application gateway authentication certificates.
        """
        return pulumi.get(self, "authentication_certificates")

    @property
    @pulumi.getter(name="connectionDraining")
    def connection_draining(self) -> Optional['outputs.ApplicationGatewayConnectionDrainingResponse']:
        """
        Connection draining of the backend http settings resource.
        """
        return pulumi.get(self, "connection_draining")

    @property
    @pulumi.getter(name="cookieBasedAffinity")
    def cookie_based_affinity(self) -> Optional[str]:
        """
        Cookie based affinity.
        """
        return pulumi.get(self, "cookie_based_affinity")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        Host header to be sent to the backend servers.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the backend http settings that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pickHostNameFromBackendAddress")
    def pick_host_name_from_backend_address(self) -> Optional[bool]:
        """
        Whether to pick host header should be picked from the host name of the backend server. Default value is false.
        """
        return pulumi.get(self, "pick_host_name_from_backend_address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The destination port on the backend.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def probe(self) -> Optional['outputs.SubResourceResponse']:
        """
        Probe resource of an application gateway.
        """
        return pulumi.get(self, "probe")

    @property
    @pulumi.getter(name="probeEnabled")
    def probe_enabled(self) -> Optional[bool]:
        """
        Whether the probe is enabled. Default value is false.
        """
        return pulumi.get(self, "probe_enabled")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol used to communicate with the backend.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[int]:
        """
        Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "request_timeout")

    @property
    @pulumi.getter(name="trustedRootCertificates")
    def trusted_root_certificates(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Array of references to application gateway trusted root certificates.
        """
        return pulumi.get(self, "trusted_root_certificates")


@pulumi.output_type
class ApplicationGatewayConnectionDrainingResponse(dict):
    """
    Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drainTimeoutInSec":
            suggest = "drain_timeout_in_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayConnectionDrainingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayConnectionDrainingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayConnectionDrainingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 drain_timeout_in_sec: int,
                 enabled: bool):
        """
        Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.
        :param int drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
        :param bool enabled: Whether connection draining is enabled or not.
        """
        pulumi.set(__self__, "drain_timeout_in_sec", drain_timeout_in_sec)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="drainTimeoutInSec")
    def drain_timeout_in_sec(self) -> int:
        """
        The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
        """
        return pulumi.get(self, "drain_timeout_in_sec")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether connection draining is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ApplicationGatewayCustomErrorResponse(dict):
    """
    Customer error of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customErrorPageUrl":
            suggest = "custom_error_page_url"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayCustomErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayCustomErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayCustomErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_error_page_url: Optional[str] = None,
                 status_code: Optional[str] = None):
        """
        Customer error of an application gateway.
        :param str custom_error_page_url: Error page URL of the application gateway customer error.
        :param str status_code: Status code of the application gateway customer error.
        """
        if custom_error_page_url is not None:
            pulumi.set(__self__, "custom_error_page_url", custom_error_page_url)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="customErrorPageUrl")
    def custom_error_page_url(self) -> Optional[str]:
        """
        Error page URL of the application gateway customer error.
        """
        return pulumi.get(self, "custom_error_page_url")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[str]:
        """
        Status code of the application gateway customer error.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ApplicationGatewayFirewallDisabledRuleGroupResponse(dict):
    """
    Allows to disable rules within a rule group or an entire rule group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleGroupName":
            suggest = "rule_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFirewallDisabledRuleGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFirewallDisabledRuleGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFirewallDisabledRuleGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_group_name: str,
                 rules: Optional[Sequence[int]] = None):
        """
        Allows to disable rules within a rule group or an entire rule group.
        :param str rule_group_name: The name of the rule group that will be disabled.
        :param Sequence[int] rules: The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> str:
        """
        The name of the rule group that will be disabled.
        """
        return pulumi.get(self, "rule_group_name")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence[int]]:
        """
        The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ApplicationGatewayFirewallExclusionResponse(dict):
    """
    Allow to exclude some variable satisfy the condition for the WAF check.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchVariable":
            suggest = "match_variable"
        elif key == "selectorMatchOperator":
            suggest = "selector_match_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFirewallExclusionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFirewallExclusionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFirewallExclusionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_variable: str,
                 selector: str,
                 selector_match_operator: str):
        """
        Allow to exclude some variable satisfy the condition for the WAF check.
        :param str match_variable: The variable to be excluded.
        :param str selector: When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
        :param str selector_match_operator: When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "selector_match_operator", selector_match_operator)

    @property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> str:
        """
        The variable to be excluded.
        """
        return pulumi.get(self, "match_variable")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="selectorMatchOperator")
    def selector_match_operator(self) -> str:
        """
        When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector_match_operator")


@pulumi.output_type
class ApplicationGatewayFrontendIPConfigurationResponse(dict):
    """
    Frontend IP configuration of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "privateLinkConfiguration":
            suggest = "private_link_configuration"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFrontendIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFrontendIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFrontendIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 private_link_configuration: Optional['outputs.SubResourceResponse'] = None,
                 public_ip_address: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        Frontend IP configuration of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the frontend IP configuration resource.
        :param str type: Type of the resource.
        :param str id: Resource ID.
        :param str name: Name of the frontend IP configuration that is unique within an Application Gateway.
        :param str private_ip_address: PrivateIPAddress of the network interface IP Configuration.
        :param str private_ip_allocation_method: The private IP address allocation method.
        :param 'SubResourceResponse' private_link_configuration: Reference to the application gateway private link configuration.
        :param 'SubResourceResponse' public_ip_address: Reference to the PublicIP resource.
        :param 'SubResourceResponse' subnet: Reference to the subnet resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if private_link_configuration is not None:
            pulumi.set(__self__, "private_link_configuration", private_link_configuration)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the frontend IP configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the frontend IP configuration that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        PrivateIPAddress of the network interface IP Configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="privateLinkConfiguration")
    def private_link_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to the application gateway private link configuration.
        """
        return pulumi.get(self, "private_link_configuration")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to the PublicIP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to the subnet resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ApplicationGatewayFrontendPortResponse(dict):
    """
    Frontend port of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFrontendPortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFrontendPortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFrontendPortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None):
        """
        Frontend port of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the frontend port resource.
        :param str type: Type of the resource.
        :param str id: Resource ID.
        :param str name: Name of the frontend port that is unique within an Application Gateway.
        :param int port: Frontend port.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the frontend port resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the frontend port that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Frontend port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ApplicationGatewayHeaderConfigurationResponse(dict):
    """
    Header configuration of the Actions set in Application Gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayHeaderConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayHeaderConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayHeaderConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: Optional[str] = None,
                 header_value: Optional[str] = None):
        """
        Header configuration of the Actions set in Application Gateway.
        :param str header_name: Header name of the header configuration.
        :param str header_value: Header value of the header configuration.
        """
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[str]:
        """
        Header name of the header configuration.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[str]:
        """
        Header value of the header configuration.
        """
        return pulumi.get(self, "header_value")


@pulumi.output_type
class ApplicationGatewayHttpListenerResponse(dict):
    """
    Http listener of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "customErrorConfigurations":
            suggest = "custom_error_configurations"
        elif key == "firewallPolicy":
            suggest = "firewall_policy"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "hostNames":
            suggest = "host_names"
        elif key == "requireServerNameIndication":
            suggest = "require_server_name_indication"
        elif key == "sslCertificate":
            suggest = "ssl_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayHttpListenerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayHttpListenerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayHttpListenerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 custom_error_configurations: Optional[Sequence['outputs.ApplicationGatewayCustomErrorResponse']] = None,
                 firewall_policy: Optional['outputs.SubResourceResponse'] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 frontend_port: Optional['outputs.SubResourceResponse'] = None,
                 host_name: Optional[str] = None,
                 host_names: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 protocol: Optional[str] = None,
                 require_server_name_indication: Optional[bool] = None,
                 ssl_certificate: Optional['outputs.SubResourceResponse'] = None):
        """
        Http listener of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the HTTP listener resource.
        :param str type: Type of the resource.
        :param Sequence['ApplicationGatewayCustomErrorResponse'] custom_error_configurations: Custom error configurations of the HTTP listener.
        :param 'SubResourceResponse' firewall_policy: Reference to the FirewallPolicy resource.
        :param 'SubResourceResponse' frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
        :param 'SubResourceResponse' frontend_port: Frontend port resource of an application gateway.
        :param str host_name: Host name of HTTP listener.
        :param Sequence[str] host_names: List of Host names for HTTP Listener that allows special wildcard characters as well.
        :param str id: Resource ID.
        :param str name: Name of the HTTP listener that is unique within an Application Gateway.
        :param str protocol: Protocol of the HTTP listener.
        :param bool require_server_name_indication: Applicable only if protocol is https. Enables SNI for multi-hosting.
        :param 'SubResourceResponse' ssl_certificate: SSL certificate resource of an application gateway.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if custom_error_configurations is not None:
            pulumi.set(__self__, "custom_error_configurations", custom_error_configurations)
        if firewall_policy is not None:
            pulumi.set(__self__, "firewall_policy", firewall_policy)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if host_names is not None:
            pulumi.set(__self__, "host_names", host_names)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if require_server_name_indication is not None:
            pulumi.set(__self__, "require_server_name_indication", require_server_name_indication)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the HTTP listener resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="customErrorConfigurations")
    def custom_error_configurations(self) -> Optional[Sequence['outputs.ApplicationGatewayCustomErrorResponse']]:
        """
        Custom error configurations of the HTTP listener.
        """
        return pulumi.get(self, "custom_error_configurations")

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to the FirewallPolicy resource.
        """
        return pulumi.get(self, "firewall_policy")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Frontend IP configuration resource of an application gateway.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional['outputs.SubResourceResponse']:
        """
        Frontend port resource of an application gateway.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        Host name of HTTP listener.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="hostNames")
    def host_names(self) -> Optional[Sequence[str]]:
        """
        List of Host names for HTTP Listener that allows special wildcard characters as well.
        """
        return pulumi.get(self, "host_names")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the HTTP listener that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol of the HTTP listener.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="requireServerNameIndication")
    def require_server_name_indication(self) -> Optional[bool]:
        """
        Applicable only if protocol is https. Enables SNI for multi-hosting.
        """
        return pulumi.get(self, "require_server_name_indication")

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional['outputs.SubResourceResponse']:
        """
        SSL certificate resource of an application gateway.
        """
        return pulumi.get(self, "ssl_certificate")


@pulumi.output_type
class ApplicationGatewayIPConfigurationResponse(dict):
    """
    IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the application gateway IP configuration resource.
        :param str type: Type of the resource.
        :param str id: Resource ID.
        :param str name: Name of the IP configuration that is unique within an Application Gateway.
        :param 'SubResourceResponse' subnet: Reference to the subnet resource. A subnet from where application gateway gets its private address.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the application gateway IP configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the IP configuration that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to the subnet resource. A subnet from where application gateway gets its private address.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ApplicationGatewayPathRuleResponse(dict):
    """
    Path rule of URL path map of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "backendHttpSettings":
            suggest = "backend_http_settings"
        elif key == "firewallPolicy":
            suggest = "firewall_policy"
        elif key == "redirectConfiguration":
            suggest = "redirect_configuration"
        elif key == "rewriteRuleSet":
            suggest = "rewrite_rule_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayPathRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayPathRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayPathRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 backend_http_settings: Optional['outputs.SubResourceResponse'] = None,
                 firewall_policy: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 paths: Optional[Sequence[str]] = None,
                 redirect_configuration: Optional['outputs.SubResourceResponse'] = None,
                 rewrite_rule_set: Optional['outputs.SubResourceResponse'] = None):
        """
        Path rule of URL path map of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the path rule resource.
        :param str type: Type of the resource.
        :param 'SubResourceResponse' backend_address_pool: Backend address pool resource of URL path map path rule.
        :param 'SubResourceResponse' backend_http_settings: Backend http settings resource of URL path map path rule.
        :param 'SubResourceResponse' firewall_policy: Reference to the FirewallPolicy resource.
        :param str id: Resource ID.
        :param str name: Name of the path rule that is unique within an Application Gateway.
        :param Sequence[str] paths: Path rules of URL path map.
        :param 'SubResourceResponse' redirect_configuration: Redirect configuration resource of URL path map path rule.
        :param 'SubResourceResponse' rewrite_rule_set: Rewrite rule set resource of URL path map path rule.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_http_settings is not None:
            pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        if firewall_policy is not None:
            pulumi.set(__self__, "firewall_policy", firewall_policy)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if redirect_configuration is not None:
            pulumi.set(__self__, "redirect_configuration", redirect_configuration)
        if rewrite_rule_set is not None:
            pulumi.set(__self__, "rewrite_rule_set", rewrite_rule_set)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the path rule resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        Backend address pool resource of URL path map path rule.
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Backend http settings resource of URL path map path rule.
        """
        return pulumi.get(self, "backend_http_settings")

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to the FirewallPolicy resource.
        """
        return pulumi.get(self, "firewall_policy")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the path rule that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        Path rules of URL path map.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="redirectConfiguration")
    def redirect_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Redirect configuration resource of URL path map path rule.
        """
        return pulumi.get(self, "redirect_configuration")

    @property
    @pulumi.getter(name="rewriteRuleSet")
    def rewrite_rule_set(self) -> Optional['outputs.SubResourceResponse']:
        """
        Rewrite rule set resource of URL path map path rule.
        """
        return pulumi.get(self, "rewrite_rule_set")


@pulumi.output_type
class ApplicationGatewayPrivateEndpointConnectionResponse(dict):
    """
    Private Endpoint connection on an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkIdentifier":
            suggest = "link_identifier"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayPrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayPrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayPrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 link_identifier: str,
                 private_endpoint: 'outputs.PrivateEndpointResponse',
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None):
        """
        Private Endpoint connection on an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str link_identifier: The consumer link id.
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        :param str provisioning_state: The provisioning state of the application gateway private endpoint connection resource.
        :param str type: Type of the resource.
        :param str id: Resource ID.
        :param str name: Name of the private endpoint connection on an application gateway.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "link_identifier", link_identifier)
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="linkIdentifier")
    def link_identifier(self) -> str:
        """
        The consumer link id.
        """
        return pulumi.get(self, "link_identifier")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> 'outputs.PrivateEndpointResponse':
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the application gateway private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the private endpoint connection on an application gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class ApplicationGatewayPrivateLinkConfigurationResponse(dict):
    """
    Private Link Configuration on an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayPrivateLinkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayPrivateLinkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayPrivateLinkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 ip_configurations: Optional[Sequence['outputs.ApplicationGatewayPrivateLinkIpConfigurationResponse']] = None,
                 name: Optional[str] = None):
        """
        Private Link Configuration on an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the application gateway private link configuration.
        :param str type: Type of the resource.
        :param str id: Resource ID.
        :param Sequence['ApplicationGatewayPrivateLinkIpConfigurationResponse'] ip_configurations: An array of application gateway private link ip configurations.
        :param str name: Name of the private link configuration that is unique within an Application Gateway.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the application gateway private link configuration.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.ApplicationGatewayPrivateLinkIpConfigurationResponse']]:
        """
        An array of application gateway private link ip configurations.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the private link configuration that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ApplicationGatewayPrivateLinkIpConfigurationResponse(dict):
    """
    The application gateway private link ip configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayPrivateLinkIpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayPrivateLinkIpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayPrivateLinkIpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 primary: Optional[bool] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        The application gateway private link ip configuration.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the application gateway private link IP configuration.
        :param str type: The resource type.
        :param str id: Resource ID.
        :param str name: The name of application gateway private link ip configuration.
        :param bool primary: Whether the ip configuration is primary or not.
        :param str private_ip_address: The private IP address of the IP configuration.
        :param str private_ip_allocation_method: The private IP address allocation method.
        :param 'SubResourceResponse' subnet: Reference to the subnet resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the application gateway private link IP configuration.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of application gateway private link ip configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Whether the ip configuration is primary or not.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to the subnet resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class ApplicationGatewayProbeHealthResponseMatchResponse(dict):
    """
    Application gateway probe health response match.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCodes":
            suggest = "status_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayProbeHealthResponseMatchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayProbeHealthResponseMatchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayProbeHealthResponseMatchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body: Optional[str] = None,
                 status_codes: Optional[Sequence[str]] = None):
        """
        Application gateway probe health response match.
        :param str body: Body that must be contained in the health response. Default value is empty.
        :param Sequence[str] status_codes: Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)

    @property
    @pulumi.getter
    def body(self) -> Optional[str]:
        """
        Body that must be contained in the health response. Default value is empty.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[Sequence[str]]:
        """
        Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
        """
        return pulumi.get(self, "status_codes")


@pulumi.output_type
class ApplicationGatewayProbeResponse(dict):
    """
    Probe of the application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "minServers":
            suggest = "min_servers"
        elif key == "pickHostNameFromBackendHttpSettings":
            suggest = "pick_host_name_from_backend_http_settings"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayProbeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayProbeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayProbeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 host: Optional[str] = None,
                 id: Optional[str] = None,
                 interval: Optional[int] = None,
                 match: Optional['outputs.ApplicationGatewayProbeHealthResponseMatchResponse'] = None,
                 min_servers: Optional[int] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None,
                 pick_host_name_from_backend_http_settings: Optional[bool] = None,
                 port: Optional[int] = None,
                 protocol: Optional[str] = None,
                 timeout: Optional[int] = None,
                 unhealthy_threshold: Optional[int] = None):
        """
        Probe of the application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the probe resource.
        :param str type: Type of the resource.
        :param str host: Host name to send the probe to.
        :param str id: Resource ID.
        :param int interval: The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        :param 'ApplicationGatewayProbeHealthResponseMatchResponse' match: Criterion for classifying a healthy probe response.
        :param int min_servers: Minimum number of servers that are always marked healthy. Default value is 0.
        :param str name: Name of the probe that is unique within an Application Gateway.
        :param str path: Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
        :param bool pick_host_name_from_backend_http_settings: Whether the host header should be picked from the backend http settings. Default value is false.
        :param int port: Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only.
        :param str protocol: The protocol used for the probe.
        :param int timeout: The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        :param int unhealthy_threshold: The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if min_servers is not None:
            pulumi.set(__self__, "min_servers", min_servers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if pick_host_name_from_backend_http_settings is not None:
            pulumi.set(__self__, "pick_host_name_from_backend_http_settings", pick_host_name_from_backend_http_settings)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the probe resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Host name to send the probe to.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def match(self) -> Optional['outputs.ApplicationGatewayProbeHealthResponseMatchResponse']:
        """
        Criterion for classifying a healthy probe response.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter(name="minServers")
    def min_servers(self) -> Optional[int]:
        """
        Minimum number of servers that are always marked healthy. Default value is 0.
        """
        return pulumi.get(self, "min_servers")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the probe that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pickHostNameFromBackendHttpSettings")
    def pick_host_name_from_backend_http_settings(self) -> Optional[bool]:
        """
        Whether the host header should be picked from the backend http settings. Default value is false.
        """
        return pulumi.get(self, "pick_host_name_from_backend_http_settings")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Custom port which will be used for probing the backend servers. The valid value ranges from 1 to 65535. In case not set, port from http settings will be used. This property is valid for Standard_v2 and WAF_v2 only.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol used for the probe.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[int]:
        """
        The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class ApplicationGatewayRedirectConfigurationResponse(dict):
    """
    Redirect configuration of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includePath":
            suggest = "include_path"
        elif key == "includeQueryString":
            suggest = "include_query_string"
        elif key == "pathRules":
            suggest = "path_rules"
        elif key == "redirectType":
            suggest = "redirect_type"
        elif key == "requestRoutingRules":
            suggest = "request_routing_rules"
        elif key == "targetListener":
            suggest = "target_listener"
        elif key == "targetUrl":
            suggest = "target_url"
        elif key == "urlPathMaps":
            suggest = "url_path_maps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayRedirectConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayRedirectConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayRedirectConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 type: str,
                 id: Optional[str] = None,
                 include_path: Optional[bool] = None,
                 include_query_string: Optional[bool] = None,
                 name: Optional[str] = None,
                 path_rules: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 redirect_type: Optional[str] = None,
                 request_routing_rules: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 target_listener: Optional['outputs.SubResourceResponse'] = None,
                 target_url: Optional[str] = None,
                 url_path_maps: Optional[Sequence['outputs.SubResourceResponse']] = None):
        """
        Redirect configuration of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str type: Type of the resource.
        :param str id: Resource ID.
        :param bool include_path: Include path in the redirected url.
        :param bool include_query_string: Include query string in the redirected url.
        :param str name: Name of the redirect configuration that is unique within an Application Gateway.
        :param Sequence['SubResourceResponse'] path_rules: Path rules specifying redirect configuration.
        :param str redirect_type: HTTP redirection type.
        :param Sequence['SubResourceResponse'] request_routing_rules: Request routing specifying redirect configuration.
        :param 'SubResourceResponse' target_listener: Reference to a listener to redirect the request to.
        :param str target_url: Url to redirect the request to.
        :param Sequence['SubResourceResponse'] url_path_maps: Url path maps specifying default redirect configuration.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if include_path is not None:
            pulumi.set(__self__, "include_path", include_path)
        if include_query_string is not None:
            pulumi.set(__self__, "include_query_string", include_query_string)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_rules is not None:
            pulumi.set(__self__, "path_rules", path_rules)
        if redirect_type is not None:
            pulumi.set(__self__, "redirect_type", redirect_type)
        if request_routing_rules is not None:
            pulumi.set(__self__, "request_routing_rules", request_routing_rules)
        if target_listener is not None:
            pulumi.set(__self__, "target_listener", target_listener)
        if target_url is not None:
            pulumi.set(__self__, "target_url", target_url)
        if url_path_maps is not None:
            pulumi.set(__self__, "url_path_maps", url_path_maps)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includePath")
    def include_path(self) -> Optional[bool]:
        """
        Include path in the redirected url.
        """
        return pulumi.get(self, "include_path")

    @property
    @pulumi.getter(name="includeQueryString")
    def include_query_string(self) -> Optional[bool]:
        """
        Include query string in the redirected url.
        """
        return pulumi.get(self, "include_query_string")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the redirect configuration that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pathRules")
    def path_rules(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Path rules specifying redirect configuration.
        """
        return pulumi.get(self, "path_rules")

    @property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> Optional[str]:
        """
        HTTP redirection type.
        """
        return pulumi.get(self, "redirect_type")

    @property
    @pulumi.getter(name="requestRoutingRules")
    def request_routing_rules(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Request routing specifying redirect configuration.
        """
        return pulumi.get(self, "request_routing_rules")

    @property
    @pulumi.getter(name="targetListener")
    def target_listener(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to a listener to redirect the request to.
        """
        return pulumi.get(self, "target_listener")

    @property
    @pulumi.getter(name="targetUrl")
    def target_url(self) -> Optional[str]:
        """
        Url to redirect the request to.
        """
        return pulumi.get(self, "target_url")

    @property
    @pulumi.getter(name="urlPathMaps")
    def url_path_maps(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Url path maps specifying default redirect configuration.
        """
        return pulumi.get(self, "url_path_maps")


@pulumi.output_type
class ApplicationGatewayRequestRoutingRuleResponse(dict):
    """
    Request routing rule of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "backendHttpSettings":
            suggest = "backend_http_settings"
        elif key == "httpListener":
            suggest = "http_listener"
        elif key == "redirectConfiguration":
            suggest = "redirect_configuration"
        elif key == "rewriteRuleSet":
            suggest = "rewrite_rule_set"
        elif key == "ruleType":
            suggest = "rule_type"
        elif key == "urlPathMap":
            suggest = "url_path_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayRequestRoutingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayRequestRoutingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayRequestRoutingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 backend_http_settings: Optional['outputs.SubResourceResponse'] = None,
                 http_listener: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 redirect_configuration: Optional['outputs.SubResourceResponse'] = None,
                 rewrite_rule_set: Optional['outputs.SubResourceResponse'] = None,
                 rule_type: Optional[str] = None,
                 url_path_map: Optional['outputs.SubResourceResponse'] = None):
        """
        Request routing rule of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the request routing rule resource.
        :param str type: Type of the resource.
        :param 'SubResourceResponse' backend_address_pool: Backend address pool resource of the application gateway.
        :param 'SubResourceResponse' backend_http_settings: Backend http settings resource of the application gateway.
        :param 'SubResourceResponse' http_listener: Http listener resource of the application gateway.
        :param str id: Resource ID.
        :param str name: Name of the request routing rule that is unique within an Application Gateway.
        :param int priority: Priority of the request routing rule.
        :param 'SubResourceResponse' redirect_configuration: Redirect configuration resource of the application gateway.
        :param 'SubResourceResponse' rewrite_rule_set: Rewrite Rule Set resource in Basic rule of the application gateway.
        :param str rule_type: Rule type.
        :param 'SubResourceResponse' url_path_map: URL path map resource of the application gateway.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_http_settings is not None:
            pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        if http_listener is not None:
            pulumi.set(__self__, "http_listener", http_listener)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if redirect_configuration is not None:
            pulumi.set(__self__, "redirect_configuration", redirect_configuration)
        if rewrite_rule_set is not None:
            pulumi.set(__self__, "rewrite_rule_set", rewrite_rule_set)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)
        if url_path_map is not None:
            pulumi.set(__self__, "url_path_map", url_path_map)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the request routing rule resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        Backend address pool resource of the application gateway.
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Backend http settings resource of the application gateway.
        """
        return pulumi.get(self, "backend_http_settings")

    @property
    @pulumi.getter(name="httpListener")
    def http_listener(self) -> Optional['outputs.SubResourceResponse']:
        """
        Http listener resource of the application gateway.
        """
        return pulumi.get(self, "http_listener")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the request routing rule that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of the request routing rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="redirectConfiguration")
    def redirect_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Redirect configuration resource of the application gateway.
        """
        return pulumi.get(self, "redirect_configuration")

    @property
    @pulumi.getter(name="rewriteRuleSet")
    def rewrite_rule_set(self) -> Optional['outputs.SubResourceResponse']:
        """
        Rewrite Rule Set resource in Basic rule of the application gateway.
        """
        return pulumi.get(self, "rewrite_rule_set")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[str]:
        """
        Rule type.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="urlPathMap")
    def url_path_map(self) -> Optional['outputs.SubResourceResponse']:
        """
        URL path map resource of the application gateway.
        """
        return pulumi.get(self, "url_path_map")


@pulumi.output_type
class ApplicationGatewayResponse(dict):
    """
    Application gateway resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationalState":
            suggest = "operational_state"
        elif key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "authenticationCertificates":
            suggest = "authentication_certificates"
        elif key == "autoscaleConfiguration":
            suggest = "autoscale_configuration"
        elif key == "backendAddressPools":
            suggest = "backend_address_pools"
        elif key == "backendHttpSettingsCollection":
            suggest = "backend_http_settings_collection"
        elif key == "customErrorConfigurations":
            suggest = "custom_error_configurations"
        elif key == "enableFips":
            suggest = "enable_fips"
        elif key == "enableHttp2":
            suggest = "enable_http2"
        elif key == "firewallPolicy":
            suggest = "firewall_policy"
        elif key == "forceFirewallPolicyAssociation":
            suggest = "force_firewall_policy_association"
        elif key == "frontendIPConfigurations":
            suggest = "frontend_ip_configurations"
        elif key == "frontendPorts":
            suggest = "frontend_ports"
        elif key == "gatewayIPConfigurations":
            suggest = "gateway_ip_configurations"
        elif key == "httpListeners":
            suggest = "http_listeners"
        elif key == "privateLinkConfigurations":
            suggest = "private_link_configurations"
        elif key == "redirectConfigurations":
            suggest = "redirect_configurations"
        elif key == "requestRoutingRules":
            suggest = "request_routing_rules"
        elif key == "rewriteRuleSets":
            suggest = "rewrite_rule_sets"
        elif key == "sslCertificates":
            suggest = "ssl_certificates"
        elif key == "sslPolicy":
            suggest = "ssl_policy"
        elif key == "trustedRootCertificates":
            suggest = "trusted_root_certificates"
        elif key == "urlPathMaps":
            suggest = "url_path_maps"
        elif key == "webApplicationFirewallConfiguration":
            suggest = "web_application_firewall_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 name: str,
                 operational_state: str,
                 private_endpoint_connections: Sequence['outputs.ApplicationGatewayPrivateEndpointConnectionResponse'],
                 provisioning_state: str,
                 resource_guid: str,
                 type: str,
                 authentication_certificates: Optional[Sequence['outputs.ApplicationGatewayAuthenticationCertificateResponse']] = None,
                 autoscale_configuration: Optional['outputs.ApplicationGatewayAutoscaleConfigurationResponse'] = None,
                 backend_address_pools: Optional[Sequence['outputs.ApplicationGatewayBackendAddressPoolResponse']] = None,
                 backend_http_settings_collection: Optional[Sequence['outputs.ApplicationGatewayBackendHttpSettingsResponse']] = None,
                 custom_error_configurations: Optional[Sequence['outputs.ApplicationGatewayCustomErrorResponse']] = None,
                 enable_fips: Optional[bool] = None,
                 enable_http2: Optional[bool] = None,
                 firewall_policy: Optional['outputs.SubResourceResponse'] = None,
                 force_firewall_policy_association: Optional[bool] = None,
                 frontend_ip_configurations: Optional[Sequence['outputs.ApplicationGatewayFrontendIPConfigurationResponse']] = None,
                 frontend_ports: Optional[Sequence['outputs.ApplicationGatewayFrontendPortResponse']] = None,
                 gateway_ip_configurations: Optional[Sequence['outputs.ApplicationGatewayIPConfigurationResponse']] = None,
                 http_listeners: Optional[Sequence['outputs.ApplicationGatewayHttpListenerResponse']] = None,
                 id: Optional[str] = None,
                 identity: Optional['outputs.ManagedServiceIdentityResponse'] = None,
                 location: Optional[str] = None,
                 private_link_configurations: Optional[Sequence['outputs.ApplicationGatewayPrivateLinkConfigurationResponse']] = None,
                 probes: Optional[Sequence['outputs.ApplicationGatewayProbeResponse']] = None,
                 redirect_configurations: Optional[Sequence['outputs.ApplicationGatewayRedirectConfigurationResponse']] = None,
                 request_routing_rules: Optional[Sequence['outputs.ApplicationGatewayRequestRoutingRuleResponse']] = None,
                 rewrite_rule_sets: Optional[Sequence['outputs.ApplicationGatewayRewriteRuleSetResponse']] = None,
                 sku: Optional['outputs.ApplicationGatewaySkuResponse'] = None,
                 ssl_certificates: Optional[Sequence['outputs.ApplicationGatewaySslCertificateResponse']] = None,
                 ssl_policy: Optional['outputs.ApplicationGatewaySslPolicyResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 trusted_root_certificates: Optional[Sequence['outputs.ApplicationGatewayTrustedRootCertificateResponse']] = None,
                 url_path_maps: Optional[Sequence['outputs.ApplicationGatewayUrlPathMapResponse']] = None,
                 web_application_firewall_configuration: Optional['outputs.ApplicationGatewayWebApplicationFirewallConfigurationResponse'] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        Application gateway resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str name: Resource name.
        :param str operational_state: Operational state of the application gateway resource.
        :param Sequence['ApplicationGatewayPrivateEndpointConnectionResponse'] private_endpoint_connections: Private Endpoint connections on application gateway.
        :param str provisioning_state: The provisioning state of the application gateway resource.
        :param str resource_guid: The resource GUID property of the application gateway resource.
        :param str type: Resource type.
        :param Sequence['ApplicationGatewayAuthenticationCertificateResponse'] authentication_certificates: Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        :param 'ApplicationGatewayAutoscaleConfigurationResponse' autoscale_configuration: Autoscale Configuration.
        :param Sequence['ApplicationGatewayBackendAddressPoolResponse'] backend_address_pools: Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        :param Sequence['ApplicationGatewayBackendHttpSettingsResponse'] backend_http_settings_collection: Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        :param Sequence['ApplicationGatewayCustomErrorResponse'] custom_error_configurations: Custom error configurations of the application gateway resource.
        :param bool enable_fips: Whether FIPS is enabled on the application gateway resource.
        :param bool enable_http2: Whether HTTP2 is enabled on the application gateway resource.
        :param 'SubResourceResponse' firewall_policy: Reference to the FirewallPolicy resource.
        :param bool force_firewall_policy_association: If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config.
        :param Sequence['ApplicationGatewayFrontendIPConfigurationResponse'] frontend_ip_configurations: Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        :param Sequence['ApplicationGatewayFrontendPortResponse'] frontend_ports: Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        :param Sequence['ApplicationGatewayIPConfigurationResponse'] gateway_ip_configurations: Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        :param Sequence['ApplicationGatewayHttpListenerResponse'] http_listeners: Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        :param str id: Resource ID.
        :param 'ManagedServiceIdentityResponse' identity: The identity of the application gateway, if configured.
        :param str location: Resource location.
        :param Sequence['ApplicationGatewayPrivateLinkConfigurationResponse'] private_link_configurations: PrivateLink configurations on application gateway.
        :param Sequence['ApplicationGatewayProbeResponse'] probes: Probes of the application gateway resource.
        :param Sequence['ApplicationGatewayRedirectConfigurationResponse'] redirect_configurations: Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        :param Sequence['ApplicationGatewayRequestRoutingRuleResponse'] request_routing_rules: Request routing rules of the application gateway resource.
        :param Sequence['ApplicationGatewayRewriteRuleSetResponse'] rewrite_rule_sets: Rewrite rules for the application gateway resource.
        :param 'ApplicationGatewaySkuResponse' sku: SKU of the application gateway resource.
        :param Sequence['ApplicationGatewaySslCertificateResponse'] ssl_certificates: SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        :param 'ApplicationGatewaySslPolicyResponse' ssl_policy: SSL policy of the application gateway resource.
        :param Mapping[str, str] tags: Resource tags.
        :param Sequence['ApplicationGatewayTrustedRootCertificateResponse'] trusted_root_certificates: Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        :param Sequence['ApplicationGatewayUrlPathMapResponse'] url_path_maps: URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        :param 'ApplicationGatewayWebApplicationFirewallConfigurationResponse' web_application_firewall_configuration: Web application firewall configuration.
        :param Sequence[str] zones: A list of availability zones denoting where the resource needs to come from.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operational_state", operational_state)
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "type", type)
        if authentication_certificates is not None:
            pulumi.set(__self__, "authentication_certificates", authentication_certificates)
        if autoscale_configuration is not None:
            pulumi.set(__self__, "autoscale_configuration", autoscale_configuration)
        if backend_address_pools is not None:
            pulumi.set(__self__, "backend_address_pools", backend_address_pools)
        if backend_http_settings_collection is not None:
            pulumi.set(__self__, "backend_http_settings_collection", backend_http_settings_collection)
        if custom_error_configurations is not None:
            pulumi.set(__self__, "custom_error_configurations", custom_error_configurations)
        if enable_fips is not None:
            pulumi.set(__self__, "enable_fips", enable_fips)
        if enable_http2 is not None:
            pulumi.set(__self__, "enable_http2", enable_http2)
        if firewall_policy is not None:
            pulumi.set(__self__, "firewall_policy", firewall_policy)
        if force_firewall_policy_association is not None:
            pulumi.set(__self__, "force_firewall_policy_association", force_firewall_policy_association)
        if frontend_ip_configurations is not None:
            pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        if frontend_ports is not None:
            pulumi.set(__self__, "frontend_ports", frontend_ports)
        if gateway_ip_configurations is not None:
            pulumi.set(__self__, "gateway_ip_configurations", gateway_ip_configurations)
        if http_listeners is not None:
            pulumi.set(__self__, "http_listeners", http_listeners)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if private_link_configurations is not None:
            pulumi.set(__self__, "private_link_configurations", private_link_configurations)
        if probes is not None:
            pulumi.set(__self__, "probes", probes)
        if redirect_configurations is not None:
            pulumi.set(__self__, "redirect_configurations", redirect_configurations)
        if request_routing_rules is not None:
            pulumi.set(__self__, "request_routing_rules", request_routing_rules)
        if rewrite_rule_sets is not None:
            pulumi.set(__self__, "rewrite_rule_sets", rewrite_rule_sets)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if ssl_certificates is not None:
            pulumi.set(__self__, "ssl_certificates", ssl_certificates)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trusted_root_certificates is not None:
            pulumi.set(__self__, "trusted_root_certificates", trusted_root_certificates)
        if url_path_maps is not None:
            pulumi.set(__self__, "url_path_maps", url_path_maps)
        if web_application_firewall_configuration is not None:
            pulumi.set(__self__, "web_application_firewall_configuration", web_application_firewall_configuration)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationalState")
    def operational_state(self) -> str:
        """
        Operational state of the application gateway resource.
        """
        return pulumi.get(self, "operational_state")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.ApplicationGatewayPrivateEndpointConnectionResponse']:
        """
        Private Endpoint connections on application gateway.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the application gateway resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resource GUID property of the application gateway resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="authenticationCertificates")
    def authentication_certificates(self) -> Optional[Sequence['outputs.ApplicationGatewayAuthenticationCertificateResponse']]:
        """
        Authentication certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        """
        return pulumi.get(self, "authentication_certificates")

    @property
    @pulumi.getter(name="autoscaleConfiguration")
    def autoscale_configuration(self) -> Optional['outputs.ApplicationGatewayAutoscaleConfigurationResponse']:
        """
        Autoscale Configuration.
        """
        return pulumi.get(self, "autoscale_configuration")

    @property
    @pulumi.getter(name="backendAddressPools")
    def backend_address_pools(self) -> Optional[Sequence['outputs.ApplicationGatewayBackendAddressPoolResponse']]:
        """
        Backend address pool of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        """
        return pulumi.get(self, "backend_address_pools")

    @property
    @pulumi.getter(name="backendHttpSettingsCollection")
    def backend_http_settings_collection(self) -> Optional[Sequence['outputs.ApplicationGatewayBackendHttpSettingsResponse']]:
        """
        Backend http settings of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        """
        return pulumi.get(self, "backend_http_settings_collection")

    @property
    @pulumi.getter(name="customErrorConfigurations")
    def custom_error_configurations(self) -> Optional[Sequence['outputs.ApplicationGatewayCustomErrorResponse']]:
        """
        Custom error configurations of the application gateway resource.
        """
        return pulumi.get(self, "custom_error_configurations")

    @property
    @pulumi.getter(name="enableFips")
    def enable_fips(self) -> Optional[bool]:
        """
        Whether FIPS is enabled on the application gateway resource.
        """
        return pulumi.get(self, "enable_fips")

    @property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> Optional[bool]:
        """
        Whether HTTP2 is enabled on the application gateway resource.
        """
        return pulumi.get(self, "enable_http2")

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to the FirewallPolicy resource.
        """
        return pulumi.get(self, "firewall_policy")

    @property
    @pulumi.getter(name="forceFirewallPolicyAssociation")
    def force_firewall_policy_association(self) -> Optional[bool]:
        """
        If true, associates a firewall policy with an application gateway regardless whether the policy differs from the WAF Config.
        """
        return pulumi.get(self, "force_firewall_policy_association")

    @property
    @pulumi.getter(name="frontendIPConfigurations")
    def frontend_ip_configurations(self) -> Optional[Sequence['outputs.ApplicationGatewayFrontendIPConfigurationResponse']]:
        """
        Frontend IP addresses of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @property
    @pulumi.getter(name="frontendPorts")
    def frontend_ports(self) -> Optional[Sequence['outputs.ApplicationGatewayFrontendPortResponse']]:
        """
        Frontend ports of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        """
        return pulumi.get(self, "frontend_ports")

    @property
    @pulumi.getter(name="gatewayIPConfigurations")
    def gateway_ip_configurations(self) -> Optional[Sequence['outputs.ApplicationGatewayIPConfigurationResponse']]:
        """
        Subnets of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        """
        return pulumi.get(self, "gateway_ip_configurations")

    @property
    @pulumi.getter(name="httpListeners")
    def http_listeners(self) -> Optional[Sequence['outputs.ApplicationGatewayHttpListenerResponse']]:
        """
        Http listeners of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        """
        return pulumi.get(self, "http_listeners")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.ManagedServiceIdentityResponse']:
        """
        The identity of the application gateway, if configured.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="privateLinkConfigurations")
    def private_link_configurations(self) -> Optional[Sequence['outputs.ApplicationGatewayPrivateLinkConfigurationResponse']]:
        """
        PrivateLink configurations on application gateway.
        """
        return pulumi.get(self, "private_link_configurations")

    @property
    @pulumi.getter
    def probes(self) -> Optional[Sequence['outputs.ApplicationGatewayProbeResponse']]:
        """
        Probes of the application gateway resource.
        """
        return pulumi.get(self, "probes")

    @property
    @pulumi.getter(name="redirectConfigurations")
    def redirect_configurations(self) -> Optional[Sequence['outputs.ApplicationGatewayRedirectConfigurationResponse']]:
        """
        Redirect configurations of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        """
        return pulumi.get(self, "redirect_configurations")

    @property
    @pulumi.getter(name="requestRoutingRules")
    def request_routing_rules(self) -> Optional[Sequence['outputs.ApplicationGatewayRequestRoutingRuleResponse']]:
        """
        Request routing rules of the application gateway resource.
        """
        return pulumi.get(self, "request_routing_rules")

    @property
    @pulumi.getter(name="rewriteRuleSets")
    def rewrite_rule_sets(self) -> Optional[Sequence['outputs.ApplicationGatewayRewriteRuleSetResponse']]:
        """
        Rewrite rules for the application gateway resource.
        """
        return pulumi.get(self, "rewrite_rule_sets")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.ApplicationGatewaySkuResponse']:
        """
        SKU of the application gateway resource.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="sslCertificates")
    def ssl_certificates(self) -> Optional[Sequence['outputs.ApplicationGatewaySslCertificateResponse']]:
        """
        SSL certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        """
        return pulumi.get(self, "ssl_certificates")

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional['outputs.ApplicationGatewaySslPolicyResponse']:
        """
        SSL policy of the application gateway resource.
        """
        return pulumi.get(self, "ssl_policy")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trustedRootCertificates")
    def trusted_root_certificates(self) -> Optional[Sequence['outputs.ApplicationGatewayTrustedRootCertificateResponse']]:
        """
        Trusted Root certificates of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        """
        return pulumi.get(self, "trusted_root_certificates")

    @property
    @pulumi.getter(name="urlPathMaps")
    def url_path_maps(self) -> Optional[Sequence['outputs.ApplicationGatewayUrlPathMapResponse']]:
        """
        URL path map of the application gateway resource. For default limits, see [Application Gateway limits](https://docs.microsoft.com/azure/azure-subscription-service-limits#application-gateway-limits).
        """
        return pulumi.get(self, "url_path_maps")

    @property
    @pulumi.getter(name="webApplicationFirewallConfiguration")
    def web_application_firewall_configuration(self) -> Optional['outputs.ApplicationGatewayWebApplicationFirewallConfigurationResponse']:
        """
        Web application firewall configuration.
        """
        return pulumi.get(self, "web_application_firewall_configuration")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        A list of availability zones denoting where the resource needs to come from.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class ApplicationGatewayRewriteRuleActionSetResponse(dict):
    """
    Set of actions in the Rewrite Rule in Application Gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestHeaderConfigurations":
            suggest = "request_header_configurations"
        elif key == "responseHeaderConfigurations":
            suggest = "response_header_configurations"
        elif key == "urlConfiguration":
            suggest = "url_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayRewriteRuleActionSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayRewriteRuleActionSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayRewriteRuleActionSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_header_configurations: Optional[Sequence['outputs.ApplicationGatewayHeaderConfigurationResponse']] = None,
                 response_header_configurations: Optional[Sequence['outputs.ApplicationGatewayHeaderConfigurationResponse']] = None,
                 url_configuration: Optional['outputs.ApplicationGatewayUrlConfigurationResponse'] = None):
        """
        Set of actions in the Rewrite Rule in Application Gateway.
        :param Sequence['ApplicationGatewayHeaderConfigurationResponse'] request_header_configurations: Request Header Actions in the Action Set.
        :param Sequence['ApplicationGatewayHeaderConfigurationResponse'] response_header_configurations: Response Header Actions in the Action Set.
        :param 'ApplicationGatewayUrlConfigurationResponse' url_configuration: Url Configuration Action in the Action Set.
        """
        if request_header_configurations is not None:
            pulumi.set(__self__, "request_header_configurations", request_header_configurations)
        if response_header_configurations is not None:
            pulumi.set(__self__, "response_header_configurations", response_header_configurations)
        if url_configuration is not None:
            pulumi.set(__self__, "url_configuration", url_configuration)

    @property
    @pulumi.getter(name="requestHeaderConfigurations")
    def request_header_configurations(self) -> Optional[Sequence['outputs.ApplicationGatewayHeaderConfigurationResponse']]:
        """
        Request Header Actions in the Action Set.
        """
        return pulumi.get(self, "request_header_configurations")

    @property
    @pulumi.getter(name="responseHeaderConfigurations")
    def response_header_configurations(self) -> Optional[Sequence['outputs.ApplicationGatewayHeaderConfigurationResponse']]:
        """
        Response Header Actions in the Action Set.
        """
        return pulumi.get(self, "response_header_configurations")

    @property
    @pulumi.getter(name="urlConfiguration")
    def url_configuration(self) -> Optional['outputs.ApplicationGatewayUrlConfigurationResponse']:
        """
        Url Configuration Action in the Action Set.
        """
        return pulumi.get(self, "url_configuration")


@pulumi.output_type
class ApplicationGatewayRewriteRuleConditionResponse(dict):
    """
    Set of conditions in the Rewrite Rule in Application Gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreCase":
            suggest = "ignore_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayRewriteRuleConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayRewriteRuleConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayRewriteRuleConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ignore_case: Optional[bool] = None,
                 negate: Optional[bool] = None,
                 pattern: Optional[str] = None,
                 variable: Optional[str] = None):
        """
        Set of conditions in the Rewrite Rule in Application Gateway.
        :param bool ignore_case: Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
        :param bool negate: Setting this value as truth will force to check the negation of the condition given by the user.
        :param str pattern: The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
        :param str variable: The condition parameter of the RewriteRuleCondition.
        """
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if variable is not None:
            pulumi.set(__self__, "variable", variable)

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[bool]:
        """
        Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter
    def negate(self) -> Optional[bool]:
        """
        Setting this value as truth will force to check the negation of the condition given by the user.
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        """
        The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def variable(self) -> Optional[str]:
        """
        The condition parameter of the RewriteRuleCondition.
        """
        return pulumi.get(self, "variable")


@pulumi.output_type
class ApplicationGatewayRewriteRuleResponse(dict):
    """
    Rewrite rule of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionSet":
            suggest = "action_set"
        elif key == "ruleSequence":
            suggest = "rule_sequence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayRewriteRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayRewriteRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayRewriteRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_set: Optional['outputs.ApplicationGatewayRewriteRuleActionSetResponse'] = None,
                 conditions: Optional[Sequence['outputs.ApplicationGatewayRewriteRuleConditionResponse']] = None,
                 name: Optional[str] = None,
                 rule_sequence: Optional[int] = None):
        """
        Rewrite rule of an application gateway.
        :param 'ApplicationGatewayRewriteRuleActionSetResponse' action_set: Set of actions to be done as part of the rewrite Rule.
        :param Sequence['ApplicationGatewayRewriteRuleConditionResponse'] conditions: Conditions based on which the action set execution will be evaluated.
        :param str name: Name of the rewrite rule that is unique within an Application Gateway.
        :param int rule_sequence: Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
        """
        if action_set is not None:
            pulumi.set(__self__, "action_set", action_set)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_sequence is not None:
            pulumi.set(__self__, "rule_sequence", rule_sequence)

    @property
    @pulumi.getter(name="actionSet")
    def action_set(self) -> Optional['outputs.ApplicationGatewayRewriteRuleActionSetResponse']:
        """
        Set of actions to be done as part of the rewrite Rule.
        """
        return pulumi.get(self, "action_set")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.ApplicationGatewayRewriteRuleConditionResponse']]:
        """
        Conditions based on which the action set execution will be evaluated.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the rewrite rule that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ruleSequence")
    def rule_sequence(self) -> Optional[int]:
        """
        Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
        """
        return pulumi.get(self, "rule_sequence")


@pulumi.output_type
class ApplicationGatewayRewriteRuleSetResponse(dict):
    """
    Rewrite rule set of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "rewriteRules":
            suggest = "rewrite_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayRewriteRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayRewriteRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayRewriteRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 rewrite_rules: Optional[Sequence['outputs.ApplicationGatewayRewriteRuleResponse']] = None):
        """
        Rewrite rule set of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the rewrite rule set resource.
        :param str id: Resource ID.
        :param str name: Name of the rewrite rule set that is unique within an Application Gateway.
        :param Sequence['ApplicationGatewayRewriteRuleResponse'] rewrite_rules: Rewrite rules in the rewrite rule set.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rewrite_rules is not None:
            pulumi.set(__self__, "rewrite_rules", rewrite_rules)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the rewrite rule set resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the rewrite rule set that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rewriteRules")
    def rewrite_rules(self) -> Optional[Sequence['outputs.ApplicationGatewayRewriteRuleResponse']]:
        """
        Rewrite rules in the rewrite rule set.
        """
        return pulumi.get(self, "rewrite_rules")


@pulumi.output_type
class ApplicationGatewaySkuResponse(dict):
    """
    SKU of an application gateway.
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        SKU of an application gateway.
        :param int capacity: Capacity (instance count) of an application gateway.
        :param str name: Name of an application gateway SKU.
        :param str tier: Tier of an application gateway.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Capacity (instance count) of an application gateway.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of an application gateway SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Tier of an application gateway.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class ApplicationGatewaySslCertificateResponse(dict):
    """
    SSL certificates of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicCertData":
            suggest = "public_cert_data"
        elif key == "keyVaultSecretId":
            suggest = "key_vault_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewaySslCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewaySslCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewaySslCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 public_cert_data: str,
                 type: str,
                 data: Optional[str] = None,
                 id: Optional[str] = None,
                 key_vault_secret_id: Optional[str] = None,
                 name: Optional[str] = None,
                 password: Optional[str] = None):
        """
        SSL certificates of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the SSL certificate resource.
        :param str public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
        :param str type: Type of the resource.
        :param str data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
        :param str id: Resource ID.
        :param str key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
        :param str name: Name of the SSL certificate that is unique within an Application Gateway.
        :param str password: Password for the pfx file specified in data. Only applicable in PUT request.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "public_cert_data", public_cert_data)
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the SSL certificate resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> str:
        """
        Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
        """
        return pulumi.get(self, "public_cert_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        Base-64 encoded pfx certificate. Only applicable in PUT Request.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[str]:
        """
        Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the SSL certificate that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for the pfx file specified in data. Only applicable in PUT request.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class ApplicationGatewaySslPolicyResponse(dict):
    """
    Application Gateway Ssl policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cipherSuites":
            suggest = "cipher_suites"
        elif key == "disabledSslProtocols":
            suggest = "disabled_ssl_protocols"
        elif key == "minProtocolVersion":
            suggest = "min_protocol_version"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "policyType":
            suggest = "policy_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewaySslPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewaySslPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewaySslPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cipher_suites: Optional[Sequence[str]] = None,
                 disabled_ssl_protocols: Optional[Sequence[str]] = None,
                 min_protocol_version: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 policy_type: Optional[str] = None):
        """
        Application Gateway Ssl policy.
        :param Sequence[str] cipher_suites: Ssl cipher suites to be enabled in the specified order to application gateway.
        :param Sequence[str] disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
        :param str min_protocol_version: Minimum version of Ssl protocol to be supported on application gateway.
        :param str policy_name: Name of Ssl predefined policy.
        :param str policy_type: Type of Ssl Policy.
        """
        if cipher_suites is not None:
            pulumi.set(__self__, "cipher_suites", cipher_suites)
        if disabled_ssl_protocols is not None:
            pulumi.set(__self__, "disabled_ssl_protocols", disabled_ssl_protocols)
        if min_protocol_version is not None:
            pulumi.set(__self__, "min_protocol_version", min_protocol_version)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)

    @property
    @pulumi.getter(name="cipherSuites")
    def cipher_suites(self) -> Optional[Sequence[str]]:
        """
        Ssl cipher suites to be enabled in the specified order to application gateway.
        """
        return pulumi.get(self, "cipher_suites")

    @property
    @pulumi.getter(name="disabledSslProtocols")
    def disabled_ssl_protocols(self) -> Optional[Sequence[str]]:
        """
        Ssl protocols to be disabled on application gateway.
        """
        return pulumi.get(self, "disabled_ssl_protocols")

    @property
    @pulumi.getter(name="minProtocolVersion")
    def min_protocol_version(self) -> Optional[str]:
        """
        Minimum version of Ssl protocol to be supported on application gateway.
        """
        return pulumi.get(self, "min_protocol_version")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of Ssl predefined policy.
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[str]:
        """
        Type of Ssl Policy.
        """
        return pulumi.get(self, "policy_type")


@pulumi.output_type
class ApplicationGatewayTrustedRootCertificateResponse(dict):
    """
    Trusted Root certificates of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "keyVaultSecretId":
            suggest = "key_vault_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayTrustedRootCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayTrustedRootCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayTrustedRootCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 data: Optional[str] = None,
                 id: Optional[str] = None,
                 key_vault_secret_id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Trusted Root certificates of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the trusted root certificate resource.
        :param str type: Type of the resource.
        :param str data: Certificate public data.
        :param str id: Resource ID.
        :param str key_vault_secret_id: Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
        :param str name: Name of the trusted root certificate that is unique within an Application Gateway.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the trusted root certificate resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        Certificate public data.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[str]:
        """
        Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the trusted root certificate that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ApplicationGatewayUrlConfigurationResponse(dict):
    """
    Url configuration of the Actions set in Application Gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modifiedPath":
            suggest = "modified_path"
        elif key == "modifiedQueryString":
            suggest = "modified_query_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayUrlConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayUrlConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayUrlConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 modified_path: Optional[str] = None,
                 modified_query_string: Optional[str] = None,
                 reroute: Optional[bool] = None):
        """
        Url configuration of the Actions set in Application Gateway.
        :param str modified_path: Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.
        :param str modified_query_string: Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.
        :param bool reroute: If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path. Default value is false.
        """
        if modified_path is not None:
            pulumi.set(__self__, "modified_path", modified_path)
        if modified_query_string is not None:
            pulumi.set(__self__, "modified_query_string", modified_query_string)
        if reroute is not None:
            pulumi.set(__self__, "reroute", reroute)

    @property
    @pulumi.getter(name="modifiedPath")
    def modified_path(self) -> Optional[str]:
        """
        Url path which user has provided for url rewrite. Null means no path will be updated. Default value is null.
        """
        return pulumi.get(self, "modified_path")

    @property
    @pulumi.getter(name="modifiedQueryString")
    def modified_query_string(self) -> Optional[str]:
        """
        Query string which user has provided for url rewrite. Null means no query string will be updated. Default value is null.
        """
        return pulumi.get(self, "modified_query_string")

    @property
    @pulumi.getter
    def reroute(self) -> Optional[bool]:
        """
        If set as true, it will re-evaluate the url path map provided in path based request routing rules using modified path. Default value is false.
        """
        return pulumi.get(self, "reroute")


@pulumi.output_type
class ApplicationGatewayUrlPathMapResponse(dict):
    """
    UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "defaultBackendAddressPool":
            suggest = "default_backend_address_pool"
        elif key == "defaultBackendHttpSettings":
            suggest = "default_backend_http_settings"
        elif key == "defaultRedirectConfiguration":
            suggest = "default_redirect_configuration"
        elif key == "defaultRewriteRuleSet":
            suggest = "default_rewrite_rule_set"
        elif key == "pathRules":
            suggest = "path_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayUrlPathMapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayUrlPathMapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayUrlPathMapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 default_backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 default_backend_http_settings: Optional['outputs.SubResourceResponse'] = None,
                 default_redirect_configuration: Optional['outputs.SubResourceResponse'] = None,
                 default_rewrite_rule_set: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 path_rules: Optional[Sequence['outputs.ApplicationGatewayPathRuleResponse']] = None):
        """
        UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the URL path map resource.
        :param str type: Type of the resource.
        :param 'SubResourceResponse' default_backend_address_pool: Default backend address pool resource of URL path map.
        :param 'SubResourceResponse' default_backend_http_settings: Default backend http settings resource of URL path map.
        :param 'SubResourceResponse' default_redirect_configuration: Default redirect configuration resource of URL path map.
        :param 'SubResourceResponse' default_rewrite_rule_set: Default Rewrite rule set resource of URL path map.
        :param str id: Resource ID.
        :param str name: Name of the URL path map that is unique within an Application Gateway.
        :param Sequence['ApplicationGatewayPathRuleResponse'] path_rules: Path rule of URL path map resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if default_backend_address_pool is not None:
            pulumi.set(__self__, "default_backend_address_pool", default_backend_address_pool)
        if default_backend_http_settings is not None:
            pulumi.set(__self__, "default_backend_http_settings", default_backend_http_settings)
        if default_redirect_configuration is not None:
            pulumi.set(__self__, "default_redirect_configuration", default_redirect_configuration)
        if default_rewrite_rule_set is not None:
            pulumi.set(__self__, "default_rewrite_rule_set", default_rewrite_rule_set)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_rules is not None:
            pulumi.set(__self__, "path_rules", path_rules)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the URL path map resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultBackendAddressPool")
    def default_backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        Default backend address pool resource of URL path map.
        """
        return pulumi.get(self, "default_backend_address_pool")

    @property
    @pulumi.getter(name="defaultBackendHttpSettings")
    def default_backend_http_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Default backend http settings resource of URL path map.
        """
        return pulumi.get(self, "default_backend_http_settings")

    @property
    @pulumi.getter(name="defaultRedirectConfiguration")
    def default_redirect_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Default redirect configuration resource of URL path map.
        """
        return pulumi.get(self, "default_redirect_configuration")

    @property
    @pulumi.getter(name="defaultRewriteRuleSet")
    def default_rewrite_rule_set(self) -> Optional['outputs.SubResourceResponse']:
        """
        Default Rewrite rule set resource of URL path map.
        """
        return pulumi.get(self, "default_rewrite_rule_set")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the URL path map that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pathRules")
    def path_rules(self) -> Optional[Sequence['outputs.ApplicationGatewayPathRuleResponse']]:
        """
        Path rule of URL path map resource.
        """
        return pulumi.get(self, "path_rules")


@pulumi.output_type
class ApplicationGatewayWebApplicationFirewallConfigurationResponse(dict):
    """
    Application gateway web application firewall configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firewallMode":
            suggest = "firewall_mode"
        elif key == "ruleSetType":
            suggest = "rule_set_type"
        elif key == "ruleSetVersion":
            suggest = "rule_set_version"
        elif key == "disabledRuleGroups":
            suggest = "disabled_rule_groups"
        elif key == "fileUploadLimitInMb":
            suggest = "file_upload_limit_in_mb"
        elif key == "maxRequestBodySize":
            suggest = "max_request_body_size"
        elif key == "maxRequestBodySizeInKb":
            suggest = "max_request_body_size_in_kb"
        elif key == "requestBodyCheck":
            suggest = "request_body_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayWebApplicationFirewallConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayWebApplicationFirewallConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayWebApplicationFirewallConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 firewall_mode: str,
                 rule_set_type: str,
                 rule_set_version: str,
                 disabled_rule_groups: Optional[Sequence['outputs.ApplicationGatewayFirewallDisabledRuleGroupResponse']] = None,
                 exclusions: Optional[Sequence['outputs.ApplicationGatewayFirewallExclusionResponse']] = None,
                 file_upload_limit_in_mb: Optional[int] = None,
                 max_request_body_size: Optional[int] = None,
                 max_request_body_size_in_kb: Optional[int] = None,
                 request_body_check: Optional[bool] = None):
        """
        Application gateway web application firewall configuration.
        :param bool enabled: Whether the web application firewall is enabled or not.
        :param str firewall_mode: Web application firewall mode.
        :param str rule_set_type: The type of the web application firewall rule set. Possible values are: 'OWASP'.
        :param str rule_set_version: The version of the rule set type.
        :param Sequence['ApplicationGatewayFirewallDisabledRuleGroupResponse'] disabled_rule_groups: The disabled rule groups.
        :param Sequence['ApplicationGatewayFirewallExclusionResponse'] exclusions: The exclusion list.
        :param int file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
        :param int max_request_body_size: Maximum request body size for WAF.
        :param int max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
        :param bool request_body_check: Whether allow WAF to check request Body.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "firewall_mode", firewall_mode)
        pulumi.set(__self__, "rule_set_type", rule_set_type)
        pulumi.set(__self__, "rule_set_version", rule_set_version)
        if disabled_rule_groups is not None:
            pulumi.set(__self__, "disabled_rule_groups", disabled_rule_groups)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if file_upload_limit_in_mb is not None:
            pulumi.set(__self__, "file_upload_limit_in_mb", file_upload_limit_in_mb)
        if max_request_body_size is not None:
            pulumi.set(__self__, "max_request_body_size", max_request_body_size)
        if max_request_body_size_in_kb is not None:
            pulumi.set(__self__, "max_request_body_size_in_kb", max_request_body_size_in_kb)
        if request_body_check is not None:
            pulumi.set(__self__, "request_body_check", request_body_check)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the web application firewall is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="firewallMode")
    def firewall_mode(self) -> str:
        """
        Web application firewall mode.
        """
        return pulumi.get(self, "firewall_mode")

    @property
    @pulumi.getter(name="ruleSetType")
    def rule_set_type(self) -> str:
        """
        The type of the web application firewall rule set. Possible values are: 'OWASP'.
        """
        return pulumi.get(self, "rule_set_type")

    @property
    @pulumi.getter(name="ruleSetVersion")
    def rule_set_version(self) -> str:
        """
        The version of the rule set type.
        """
        return pulumi.get(self, "rule_set_version")

    @property
    @pulumi.getter(name="disabledRuleGroups")
    def disabled_rule_groups(self) -> Optional[Sequence['outputs.ApplicationGatewayFirewallDisabledRuleGroupResponse']]:
        """
        The disabled rule groups.
        """
        return pulumi.get(self, "disabled_rule_groups")

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence['outputs.ApplicationGatewayFirewallExclusionResponse']]:
        """
        The exclusion list.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter(name="fileUploadLimitInMb")
    def file_upload_limit_in_mb(self) -> Optional[int]:
        """
        Maximum file upload size in Mb for WAF.
        """
        return pulumi.get(self, "file_upload_limit_in_mb")

    @property
    @pulumi.getter(name="maxRequestBodySize")
    def max_request_body_size(self) -> Optional[int]:
        """
        Maximum request body size for WAF.
        """
        return pulumi.get(self, "max_request_body_size")

    @property
    @pulumi.getter(name="maxRequestBodySizeInKb")
    def max_request_body_size_in_kb(self) -> Optional[int]:
        """
        Maximum request body size in Kb for WAF.
        """
        return pulumi.get(self, "max_request_body_size_in_kb")

    @property
    @pulumi.getter(name="requestBodyCheck")
    def request_body_check(self) -> Optional[bool]:
        """
        Whether allow WAF to check request Body.
        """
        return pulumi.get(self, "request_body_check")


@pulumi.output_type
class ApplicationRuleResponse(dict):
    """
    Rule of type application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"
        elif key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "fqdnTags":
            suggest = "fqdn_tags"
        elif key == "sourceAddresses":
            suggest = "source_addresses"
        elif key == "sourceIpGroups":
            suggest = "source_ip_groups"
        elif key == "targetFqdns":
            suggest = "target_fqdns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: str,
                 description: Optional[str] = None,
                 destination_addresses: Optional[Sequence[str]] = None,
                 fqdn_tags: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 protocols: Optional[Sequence['outputs.FirewallPolicyRuleApplicationProtocolResponse']] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 source_ip_groups: Optional[Sequence[str]] = None,
                 target_fqdns: Optional[Sequence[str]] = None):
        """
        Rule of type application.
        :param str rule_type: Rule Type.
               Expected value is 'ApplicationRule'.
        :param str description: Description of the rule.
        :param Sequence[str] destination_addresses: List of destination IP addresses or Service Tags.
        :param Sequence[str] fqdn_tags: List of FQDN Tags for this rule.
        :param str name: Name of the rule.
        :param Sequence['FirewallPolicyRuleApplicationProtocolResponse'] protocols: Array of Application Protocols.
        :param Sequence[str] source_addresses: List of source IP addresses for this rule.
        :param Sequence[str] source_ip_groups: List of source IpGroups for this rule.
        :param Sequence[str] target_fqdns: List of FQDNs for this rule.
        """
        pulumi.set(__self__, "rule_type", 'ApplicationRule')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if fqdn_tags is not None:
            pulumi.set(__self__, "fqdn_tags", fqdn_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)
        if target_fqdns is not None:
            pulumi.set(__self__, "target_fqdns", target_fqdns)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        Rule Type.
        Expected value is 'ApplicationRule'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        List of destination IP addresses or Service Tags.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="fqdnTags")
    def fqdn_tags(self) -> Optional[Sequence[str]]:
        """
        List of FQDN Tags for this rule.
        """
        return pulumi.get(self, "fqdn_tags")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence['outputs.FirewallPolicyRuleApplicationProtocolResponse']]:
        """
        Array of Application Protocols.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[Sequence[str]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")

    @property
    @pulumi.getter(name="targetFqdns")
    def target_fqdns(self) -> Optional[Sequence[str]]:
        """
        List of FQDNs for this rule.
        """
        return pulumi.get(self, "target_fqdns")


@pulumi.output_type
class ApplicationSecurityGroupResponse(dict):
    """
    An application security group in a resource group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationSecurityGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationSecurityGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationSecurityGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 name: str,
                 provisioning_state: str,
                 resource_guid: str,
                 type: str,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        An application security group in a resource group.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the application security group resource.
        :param str resource_guid: The resource GUID property of the application security group resource. It uniquely identifies a resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
        :param str type: Resource type.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the application security group resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resource GUID property of the application security group resource. It uniquely identifies a resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class AzureFirewallApplicationRuleCollectionResponse(dict):
    """
    Application rule collection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallApplicationRuleCollectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallApplicationRuleCollectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallApplicationRuleCollectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 action: Optional['outputs.AzureFirewallRCActionResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 rules: Optional[Sequence['outputs.AzureFirewallApplicationRuleResponse']] = None):
        """
        Application rule collection resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the application rule collection resource.
        :param 'AzureFirewallRCActionResponse' action: The action type of a rule collection.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        :param int priority: Priority of the application rule collection resource.
        :param Sequence['AzureFirewallApplicationRuleResponse'] rules: Collection of rules used by a application rule collection.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the application rule collection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.AzureFirewallRCActionResponse']:
        """
        The action type of a rule collection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of the application rule collection resource.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.AzureFirewallApplicationRuleResponse']]:
        """
        Collection of rules used by a application rule collection.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class AzureFirewallApplicationRuleProtocolResponse(dict):
    """
    Properties of the application rule protocol.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolType":
            suggest = "protocol_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallApplicationRuleProtocolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallApplicationRuleProtocolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallApplicationRuleProtocolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: Optional[int] = None,
                 protocol_type: Optional[str] = None):
        """
        Properties of the application rule protocol.
        :param int port: Port number for the protocol, cannot be greater than 64000. This field is optional.
        :param str protocol_type: Protocol type.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number for the protocol, cannot be greater than 64000. This field is optional.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[str]:
        """
        Protocol type.
        """
        return pulumi.get(self, "protocol_type")


@pulumi.output_type
class AzureFirewallApplicationRuleResponse(dict):
    """
    Properties of an application rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fqdnTags":
            suggest = "fqdn_tags"
        elif key == "sourceAddresses":
            suggest = "source_addresses"
        elif key == "sourceIpGroups":
            suggest = "source_ip_groups"
        elif key == "targetFqdns":
            suggest = "target_fqdns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallApplicationRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallApplicationRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallApplicationRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 fqdn_tags: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 protocols: Optional[Sequence['outputs.AzureFirewallApplicationRuleProtocolResponse']] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 source_ip_groups: Optional[Sequence[str]] = None,
                 target_fqdns: Optional[Sequence[str]] = None):
        """
        Properties of an application rule.
        :param str description: Description of the rule.
        :param Sequence[str] fqdn_tags: List of FQDN Tags for this rule.
        :param str name: Name of the application rule.
        :param Sequence['AzureFirewallApplicationRuleProtocolResponse'] protocols: Array of ApplicationRuleProtocols.
        :param Sequence[str] source_addresses: List of source IP addresses for this rule.
        :param Sequence[str] source_ip_groups: List of source IpGroups for this rule.
        :param Sequence[str] target_fqdns: List of FQDNs for this rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fqdn_tags is not None:
            pulumi.set(__self__, "fqdn_tags", fqdn_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)
        if target_fqdns is not None:
            pulumi.set(__self__, "target_fqdns", target_fqdns)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fqdnTags")
    def fqdn_tags(self) -> Optional[Sequence[str]]:
        """
        List of FQDN Tags for this rule.
        """
        return pulumi.get(self, "fqdn_tags")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the application rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence['outputs.AzureFirewallApplicationRuleProtocolResponse']]:
        """
        Array of ApplicationRuleProtocols.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[Sequence[str]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")

    @property
    @pulumi.getter(name="targetFqdns")
    def target_fqdns(self) -> Optional[Sequence[str]]:
        """
        List of FQDNs for this rule.
        """
        return pulumi.get(self, "target_fqdns")


@pulumi.output_type
class AzureFirewallIPConfigurationResponse(dict):
    """
    IP configuration of an Azure Firewall.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 private_ip_address: str,
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 public_ip_address: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        IP configuration of an Azure Firewall.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str private_ip_address: The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes.
        :param str provisioning_state: The provisioning state of the Azure firewall IP configuration resource.
        :param str type: Type of the resource.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'SubResourceResponse' public_ip_address: Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
        :param 'SubResourceResponse' subnet: Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> str:
        """
        The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the Azure firewall IP configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to the PublicIP resource. This field is a mandatory input if subnet is not null.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to the subnet resource. This resource must be named 'AzureFirewallSubnet' or 'AzureFirewallManagementSubnet'.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class AzureFirewallIpGroupsResponse(dict):
    """
    IpGroups associated with azure firewall.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "changeNumber":
            suggest = "change_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallIpGroupsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallIpGroupsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallIpGroupsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 change_number: str,
                 id: str):
        """
        IpGroups associated with azure firewall.
        :param str change_number: The iteration number.
        :param str id: Resource ID.
        """
        pulumi.set(__self__, "change_number", change_number)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="changeNumber")
    def change_number(self) -> str:
        """
        The iteration number.
        """
        return pulumi.get(self, "change_number")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class AzureFirewallNatRCActionResponse(dict):
    """
    AzureFirewall NAT Rule Collection Action.
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        AzureFirewall NAT Rule Collection Action.
        :param str type: The type of action.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AzureFirewallNatRuleCollectionResponse(dict):
    """
    NAT rule collection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallNatRuleCollectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallNatRuleCollectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallNatRuleCollectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 action: Optional['outputs.AzureFirewallNatRCActionResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 rules: Optional[Sequence['outputs.AzureFirewallNatRuleResponse']] = None):
        """
        NAT rule collection resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the NAT rule collection resource.
        :param 'AzureFirewallNatRCActionResponse' action: The action type of a NAT rule collection.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        :param int priority: Priority of the NAT rule collection resource.
        :param Sequence['AzureFirewallNatRuleResponse'] rules: Collection of rules used by a NAT rule collection.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the NAT rule collection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.AzureFirewallNatRCActionResponse']:
        """
        The action type of a NAT rule collection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of the NAT rule collection resource.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.AzureFirewallNatRuleResponse']]:
        """
        Collection of rules used by a NAT rule collection.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class AzureFirewallNatRuleResponse(dict):
    """
    Properties of a NAT rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "destinationPorts":
            suggest = "destination_ports"
        elif key == "sourceAddresses":
            suggest = "source_addresses"
        elif key == "sourceIpGroups":
            suggest = "source_ip_groups"
        elif key == "translatedAddress":
            suggest = "translated_address"
        elif key == "translatedFqdn":
            suggest = "translated_fqdn"
        elif key == "translatedPort":
            suggest = "translated_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallNatRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallNatRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallNatRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 destination_addresses: Optional[Sequence[str]] = None,
                 destination_ports: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 protocols: Optional[Sequence[str]] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 source_ip_groups: Optional[Sequence[str]] = None,
                 translated_address: Optional[str] = None,
                 translated_fqdn: Optional[str] = None,
                 translated_port: Optional[str] = None):
        """
        Properties of a NAT rule.
        :param str description: Description of the rule.
        :param Sequence[str] destination_addresses: List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
        :param Sequence[str] destination_ports: List of destination ports.
        :param str name: Name of the NAT rule.
        :param Sequence[str] protocols: Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
        :param Sequence[str] source_addresses: List of source IP addresses for this rule.
        :param Sequence[str] source_ip_groups: List of source IpGroups for this rule.
        :param str translated_address: The translated address for this NAT rule.
        :param str translated_fqdn: The translated FQDN for this NAT rule.
        :param str translated_port: The translated port for this NAT rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)
        if translated_address is not None:
            pulumi.set(__self__, "translated_address", translated_address)
        if translated_fqdn is not None:
            pulumi.set(__self__, "translated_fqdn", translated_fqdn)
        if translated_port is not None:
            pulumi.set(__self__, "translated_port", translated_port)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        List of destination IP addresses for this rule. Supports IP ranges, prefixes, and service tags.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[Sequence[str]]:
        """
        List of destination ports.
        """
        return pulumi.get(self, "destination_ports")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the NAT rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[str]]:
        """
        Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[Sequence[str]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")

    @property
    @pulumi.getter(name="translatedAddress")
    def translated_address(self) -> Optional[str]:
        """
        The translated address for this NAT rule.
        """
        return pulumi.get(self, "translated_address")

    @property
    @pulumi.getter(name="translatedFqdn")
    def translated_fqdn(self) -> Optional[str]:
        """
        The translated FQDN for this NAT rule.
        """
        return pulumi.get(self, "translated_fqdn")

    @property
    @pulumi.getter(name="translatedPort")
    def translated_port(self) -> Optional[str]:
        """
        The translated port for this NAT rule.
        """
        return pulumi.get(self, "translated_port")


@pulumi.output_type
class AzureFirewallNetworkRuleCollectionResponse(dict):
    """
    Network rule collection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallNetworkRuleCollectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallNetworkRuleCollectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallNetworkRuleCollectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 action: Optional['outputs.AzureFirewallRCActionResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 rules: Optional[Sequence['outputs.AzureFirewallNetworkRuleResponse']] = None):
        """
        Network rule collection resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the network rule collection resource.
        :param 'AzureFirewallRCActionResponse' action: The action type of a rule collection.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        :param int priority: Priority of the network rule collection resource.
        :param Sequence['AzureFirewallNetworkRuleResponse'] rules: Collection of rules used by a network rule collection.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the network rule collection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.AzureFirewallRCActionResponse']:
        """
        The action type of a rule collection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of the network rule collection resource.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.AzureFirewallNetworkRuleResponse']]:
        """
        Collection of rules used by a network rule collection.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class AzureFirewallNetworkRuleResponse(dict):
    """
    Properties of the network rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "destinationFqdns":
            suggest = "destination_fqdns"
        elif key == "destinationIpGroups":
            suggest = "destination_ip_groups"
        elif key == "destinationPorts":
            suggest = "destination_ports"
        elif key == "sourceAddresses":
            suggest = "source_addresses"
        elif key == "sourceIpGroups":
            suggest = "source_ip_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallNetworkRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallNetworkRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallNetworkRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 destination_addresses: Optional[Sequence[str]] = None,
                 destination_fqdns: Optional[Sequence[str]] = None,
                 destination_ip_groups: Optional[Sequence[str]] = None,
                 destination_ports: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 protocols: Optional[Sequence[str]] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 source_ip_groups: Optional[Sequence[str]] = None):
        """
        Properties of the network rule.
        :param str description: Description of the rule.
        :param Sequence[str] destination_addresses: List of destination IP addresses.
        :param Sequence[str] destination_fqdns: List of destination FQDNs.
        :param Sequence[str] destination_ip_groups: List of destination IpGroups for this rule.
        :param Sequence[str] destination_ports: List of destination ports.
        :param str name: Name of the network rule.
        :param Sequence[str] protocols: Array of AzureFirewallNetworkRuleProtocols.
        :param Sequence[str] source_addresses: List of source IP addresses for this rule.
        :param Sequence[str] source_ip_groups: List of source IpGroups for this rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_fqdns is not None:
            pulumi.set(__self__, "destination_fqdns", destination_fqdns)
        if destination_ip_groups is not None:
            pulumi.set(__self__, "destination_ip_groups", destination_ip_groups)
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        List of destination IP addresses.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="destinationFqdns")
    def destination_fqdns(self) -> Optional[Sequence[str]]:
        """
        List of destination FQDNs.
        """
        return pulumi.get(self, "destination_fqdns")

    @property
    @pulumi.getter(name="destinationIpGroups")
    def destination_ip_groups(self) -> Optional[Sequence[str]]:
        """
        List of destination IpGroups for this rule.
        """
        return pulumi.get(self, "destination_ip_groups")

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[Sequence[str]]:
        """
        List of destination ports.
        """
        return pulumi.get(self, "destination_ports")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the network rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[str]]:
        """
        Array of AzureFirewallNetworkRuleProtocols.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[Sequence[str]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")


@pulumi.output_type
class AzureFirewallPublicIPAddressResponse(dict):
    """
    Public IP Address associated with azure firewall.
    """
    def __init__(__self__, *,
                 address: Optional[str] = None):
        """
        Public IP Address associated with azure firewall.
        :param str address: Public IP Address value.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Public IP Address value.
        """
        return pulumi.get(self, "address")


@pulumi.output_type
class AzureFirewallRCActionResponse(dict):
    """
    Properties of the AzureFirewallRCAction.
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        Properties of the AzureFirewallRCAction.
        :param str type: The type of action.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AzureFirewallSkuResponse(dict):
    """
    SKU of an Azure Firewall.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        SKU of an Azure Firewall.
        :param str name: Name of an Azure Firewall SKU.
        :param str tier: Tier of an Azure Firewall.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of an Azure Firewall SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Tier of an Azure Firewall.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class BackendAddressPoolResponse(dict):
    """
    Pool of backend IP addresses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendIPConfigurations":
            suggest = "backend_ip_configurations"
        elif key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "outboundRule":
            suggest = "outbound_rule"
        elif key == "outboundRules":
            suggest = "outbound_rules"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "loadBalancerBackendAddresses":
            suggest = "load_balancer_backend_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendAddressPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendAddressPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendAddressPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_ip_configurations: Sequence['outputs.NetworkInterfaceIPConfigurationResponse'],
                 etag: str,
                 load_balancing_rules: Sequence['outputs.SubResourceResponse'],
                 outbound_rule: 'outputs.SubResourceResponse',
                 outbound_rules: Sequence['outputs.SubResourceResponse'],
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 load_balancer_backend_addresses: Optional[Sequence['outputs.LoadBalancerBackendAddressResponse']] = None,
                 name: Optional[str] = None):
        """
        Pool of backend IP addresses.
        :param Sequence['NetworkInterfaceIPConfigurationResponse'] backend_ip_configurations: An array of references to IP addresses defined in network interfaces.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param Sequence['SubResourceResponse'] load_balancing_rules: An array of references to load balancing rules that use this backend address pool.
        :param 'SubResourceResponse' outbound_rule: A reference to an outbound rule that uses this backend address pool.
        :param Sequence['SubResourceResponse'] outbound_rules: An array of references to outbound rules that use this backend address pool.
        :param str provisioning_state: The provisioning state of the backend address pool resource.
        :param str type: Type of the resource.
        :param str id: Resource ID.
        :param Sequence['LoadBalancerBackendAddressResponse'] load_balancer_backend_addresses: An array of backend addresses.
        :param str name: The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
        """
        pulumi.set(__self__, "backend_ip_configurations", backend_ip_configurations)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        pulumi.set(__self__, "outbound_rule", outbound_rule)
        pulumi.set(__self__, "outbound_rules", outbound_rules)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancer_backend_addresses is not None:
            pulumi.set(__self__, "load_balancer_backend_addresses", load_balancer_backend_addresses)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="backendIPConfigurations")
    def backend_ip_configurations(self) -> Sequence['outputs.NetworkInterfaceIPConfigurationResponse']:
        """
        An array of references to IP addresses defined in network interfaces.
        """
        return pulumi.get(self, "backend_ip_configurations")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        An array of references to load balancing rules that use this backend address pool.
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter(name="outboundRule")
    def outbound_rule(self) -> 'outputs.SubResourceResponse':
        """
        A reference to an outbound rule that uses this backend address pool.
        """
        return pulumi.get(self, "outbound_rule")

    @property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        An array of references to outbound rules that use this backend address pool.
        """
        return pulumi.get(self, "outbound_rules")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the backend address pool resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerBackendAddresses")
    def load_balancer_backend_addresses(self) -> Optional[Sequence['outputs.LoadBalancerBackendAddressResponse']]:
        """
        An array of backend addresses.
        """
        return pulumi.get(self, "load_balancer_backend_addresses")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class BackendPoolResponse(dict):
    """
    A backend pool is a collection of backends that can be routed to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceState":
            suggest = "resource_state"
        elif key == "healthProbeSettings":
            suggest = "health_probe_settings"
        elif key == "loadBalancingSettings":
            suggest = "load_balancing_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_state: str,
                 type: str,
                 backends: Optional[Sequence['outputs.BackendResponse']] = None,
                 health_probe_settings: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 load_balancing_settings: Optional['outputs.SubResourceResponse'] = None,
                 name: Optional[str] = None):
        """
        A backend pool is a collection of backends that can be routed to.
        :param str resource_state: Resource status.
        :param str type: Resource type.
        :param Sequence['BackendResponse'] backends: The set of backends for this pool
        :param 'SubResourceResponse' health_probe_settings: L7 health probe settings for a backend pool
        :param str id: Resource ID.
        :param 'SubResourceResponse' load_balancing_settings: Load balancing settings for a backend pool
        :param str name: Resource name.
        """
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "type", type)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if health_probe_settings is not None:
            pulumi.set(__self__, "health_probe_settings", health_probe_settings)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancing_settings is not None:
            pulumi.set(__self__, "load_balancing_settings", load_balancing_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Resource status.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def backends(self) -> Optional[Sequence['outputs.BackendResponse']]:
        """
        The set of backends for this pool
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter(name="healthProbeSettings")
    def health_probe_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        L7 health probe settings for a backend pool
        """
        return pulumi.get(self, "health_probe_settings")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancingSettings")
    def load_balancing_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Load balancing settings for a backend pool
        """
        return pulumi.get(self, "load_balancing_settings")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class BackendPoolsSettingsResponse(dict):
    """
    Settings that apply to all backend pools.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enforceCertificateNameCheck":
            suggest = "enforce_certificate_name_check"
        elif key == "sendRecvTimeoutSeconds":
            suggest = "send_recv_timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendPoolsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendPoolsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendPoolsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enforce_certificate_name_check: Optional[str] = None,
                 send_recv_timeout_seconds: Optional[int] = None):
        """
        Settings that apply to all backend pools.
        :param str enforce_certificate_name_check: Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
        :param int send_recv_timeout_seconds: Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
        """
        if enforce_certificate_name_check is None:
            enforce_certificate_name_check = 'Enabled'
        if enforce_certificate_name_check is not None:
            pulumi.set(__self__, "enforce_certificate_name_check", enforce_certificate_name_check)
        if send_recv_timeout_seconds is not None:
            pulumi.set(__self__, "send_recv_timeout_seconds", send_recv_timeout_seconds)

    @property
    @pulumi.getter(name="enforceCertificateNameCheck")
    def enforce_certificate_name_check(self) -> Optional[str]:
        """
        Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
        """
        return pulumi.get(self, "enforce_certificate_name_check")

    @property
    @pulumi.getter(name="sendRecvTimeoutSeconds")
    def send_recv_timeout_seconds(self) -> Optional[int]:
        """
        Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
        """
        return pulumi.get(self, "send_recv_timeout_seconds")


@pulumi.output_type
class BackendResponse(dict):
    """
    Backend address of a frontDoor load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpointStatus":
            suggest = "private_endpoint_status"
        elif key == "backendHostHeader":
            suggest = "backend_host_header"
        elif key == "enabledState":
            suggest = "enabled_state"
        elif key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"
        elif key == "privateLinkAlias":
            suggest = "private_link_alias"
        elif key == "privateLinkApprovalMessage":
            suggest = "private_link_approval_message"
        elif key == "privateLinkLocation":
            suggest = "private_link_location"
        elif key == "privateLinkResourceId":
            suggest = "private_link_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint_status: str,
                 address: Optional[str] = None,
                 backend_host_header: Optional[str] = None,
                 enabled_state: Optional[str] = None,
                 http_port: Optional[int] = None,
                 https_port: Optional[int] = None,
                 priority: Optional[int] = None,
                 private_link_alias: Optional[str] = None,
                 private_link_approval_message: Optional[str] = None,
                 private_link_location: Optional[str] = None,
                 private_link_resource_id: Optional[str] = None,
                 weight: Optional[int] = None):
        """
        Backend address of a frontDoor load balancer.
        :param str private_endpoint_status: The Approval status for the connection to the Private Link
        :param str address: Location of the backend (IP address or FQDN)
        :param str backend_host_header: The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
        :param str enabled_state: Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
        :param int http_port: The HTTP TCP port number. Must be between 1 and 65535.
        :param int https_port: The HTTPS TCP port number. Must be between 1 and 65535.
        :param int priority: Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
        :param str private_link_alias: The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        :param str private_link_approval_message: A custom message to be included in the approval request to connect to the Private Link
        :param str private_link_location: The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
        :param str private_link_resource_id: The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        :param int weight: Weight of this endpoint for load balancing purposes.
        """
        pulumi.set(__self__, "private_endpoint_status", private_endpoint_status)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if backend_host_header is not None:
            pulumi.set(__self__, "backend_host_header", backend_host_header)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if private_link_alias is not None:
            pulumi.set(__self__, "private_link_alias", private_link_alias)
        if private_link_approval_message is not None:
            pulumi.set(__self__, "private_link_approval_message", private_link_approval_message)
        if private_link_location is not None:
            pulumi.set(__self__, "private_link_location", private_link_location)
        if private_link_resource_id is not None:
            pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="privateEndpointStatus")
    def private_endpoint_status(self) -> str:
        """
        The Approval status for the connection to the Private Link
        """
        return pulumi.get(self, "private_endpoint_status")

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Location of the backend (IP address or FQDN)
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="backendHostHeader")
    def backend_host_header(self) -> Optional[str]:
        """
        The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
        """
        return pulumi.get(self, "backend_host_header")

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[str]:
        """
        Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "enabled_state")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[int]:
        """
        The HTTP TCP port number. Must be between 1 and 65535.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[int]:
        """
        The HTTPS TCP port number. Must be between 1 and 65535.
        """
        return pulumi.get(self, "https_port")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="privateLinkAlias")
    def private_link_alias(self) -> Optional[str]:
        """
        The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        """
        return pulumi.get(self, "private_link_alias")

    @property
    @pulumi.getter(name="privateLinkApprovalMessage")
    def private_link_approval_message(self) -> Optional[str]:
        """
        A custom message to be included in the approval request to connect to the Private Link
        """
        return pulumi.get(self, "private_link_approval_message")

    @property
    @pulumi.getter(name="privateLinkLocation")
    def private_link_location(self) -> Optional[str]:
        """
        The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
        """
        return pulumi.get(self, "private_link_location")

    @property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> Optional[str]:
        """
        The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        """
        return pulumi.get(self, "private_link_resource_id")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        Weight of this endpoint for load balancing purposes.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class BastionActiveSessionResponse(dict):
    """
    The session detail for a target.
    """
    def __init__(__self__, *,
                 protocol: str,
                 resource_type: str,
                 session_duration_in_mins: float,
                 session_id: str,
                 start_time: Any,
                 target_host_name: str,
                 target_ip_address: str,
                 target_resource_group: str,
                 target_resource_id: str,
                 target_subscription_id: str,
                 user_name: str):
        """
        The session detail for a target.
        :param str protocol: The protocol used to connect to the target.
        :param str resource_type: The type of the resource.
        :param float session_duration_in_mins: Duration in mins the session has been active.
        :param str session_id: A unique id for the session.
        :param Any start_time: The time when the session started.
        :param str target_host_name: The host name of the target.
        :param str target_ip_address: The IP Address of the target.
        :param str target_resource_group: The resource group of the target.
        :param str target_resource_id: The resource id of the target.
        :param str target_subscription_id: The subscription id for the target virtual machine.
        :param str user_name: The user name who is active on this session.
        """
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "session_duration_in_mins", session_duration_in_mins)
        pulumi.set(__self__, "session_id", session_id)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "target_host_name", target_host_name)
        pulumi.set(__self__, "target_ip_address", target_ip_address)
        pulumi.set(__self__, "target_resource_group", target_resource_group)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        pulumi.set(__self__, "target_subscription_id", target_subscription_id)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used to connect to the target.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="sessionDurationInMins")
    def session_duration_in_mins(self) -> float:
        """
        Duration in mins the session has been active.
        """
        return pulumi.get(self, "session_duration_in_mins")

    @property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> str:
        """
        A unique id for the session.
        """
        return pulumi.get(self, "session_id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Any:
        """
        The time when the session started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="targetHostName")
    def target_host_name(self) -> str:
        """
        The host name of the target.
        """
        return pulumi.get(self, "target_host_name")

    @property
    @pulumi.getter(name="targetIpAddress")
    def target_ip_address(self) -> str:
        """
        The IP Address of the target.
        """
        return pulumi.get(self, "target_ip_address")

    @property
    @pulumi.getter(name="targetResourceGroup")
    def target_resource_group(self) -> str:
        """
        The resource group of the target.
        """
        return pulumi.get(self, "target_resource_group")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> str:
        """
        The resource id of the target.
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter(name="targetSubscriptionId")
    def target_subscription_id(self) -> str:
        """
        The subscription id for the target virtual machine.
        """
        return pulumi.get(self, "target_subscription_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        The user name who is active on this session.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class BastionHostIPConfigurationResponse(dict):
    """
    IP configuration of an Bastion Host.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BastionHostIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BastionHostIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BastionHostIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 public_ip_address: 'outputs.SubResourceResponse',
                 subnet: 'outputs.SubResourceResponse',
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None):
        """
        IP configuration of an Bastion Host.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the bastion host IP configuration resource.
        :param 'SubResourceResponse' public_ip_address: Reference of the PublicIP resource.
        :param 'SubResourceResponse' subnet: Reference of the subnet resource.
        :param str type: Ip configuration type.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_ip_allocation_method: Private IP allocation method.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the bastion host IP configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> 'outputs.SubResourceResponse':
        """
        Reference of the PublicIP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> 'outputs.SubResourceResponse':
        """
        Reference of the subnet resource.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Ip configuration type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        Private IP allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")


@pulumi.output_type
class BastionShareableLinkResponse(dict):
    """
    Bastion Shareable Link.
    """
    def __init__(__self__, *,
                 bsl: str,
                 created_at: str,
                 message: str,
                 vm: 'outputs.VMResponse'):
        """
        Bastion Shareable Link.
        :param str bsl: The unique Bastion Shareable Link to the virtual machine.
        :param str created_at: The time when the link was created.
        :param str message: Optional field indicating the warning or error message related to the vm in case of partial failure.
        :param 'VMResponse' vm: Reference of the virtual machine resource.
        """
        pulumi.set(__self__, "bsl", bsl)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "vm", vm)

    @property
    @pulumi.getter
    def bsl(self) -> str:
        """
        The unique Bastion Shareable Link to the virtual machine.
        """
        return pulumi.get(self, "bsl")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The time when the link was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Optional field indicating the warning or error message related to the vm in case of partial failure.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def vm(self) -> 'outputs.VMResponse':
        """
        Reference of the virtual machine resource.
        """
        return pulumi.get(self, "vm")


@pulumi.output_type
class BgpPeerStatusResponse(dict):
    """
    BGP peer status details.
    """
    def __init__(__self__, *,
                 asn: float,
                 connected_duration: str,
                 local_address: str,
                 messages_received: float,
                 messages_sent: float,
                 neighbor: str,
                 routes_received: float,
                 state: str):
        """
        BGP peer status details.
        :param float asn: The autonomous system number of the remote BGP peer.
        :param str connected_duration: For how long the peering has been up.
        :param str local_address: The virtual network gateway's local address.
        :param float messages_received: The number of BGP messages received.
        :param float messages_sent: The number of BGP messages sent.
        :param str neighbor: The remote BGP peer.
        :param float routes_received: The number of routes learned from this peer.
        :param str state: The BGP peer state.
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "connected_duration", connected_duration)
        pulumi.set(__self__, "local_address", local_address)
        pulumi.set(__self__, "messages_received", messages_received)
        pulumi.set(__self__, "messages_sent", messages_sent)
        pulumi.set(__self__, "neighbor", neighbor)
        pulumi.set(__self__, "routes_received", routes_received)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def asn(self) -> float:
        """
        The autonomous system number of the remote BGP peer.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="connectedDuration")
    def connected_duration(self) -> str:
        """
        For how long the peering has been up.
        """
        return pulumi.get(self, "connected_duration")

    @property
    @pulumi.getter(name="localAddress")
    def local_address(self) -> str:
        """
        The virtual network gateway's local address.
        """
        return pulumi.get(self, "local_address")

    @property
    @pulumi.getter(name="messagesReceived")
    def messages_received(self) -> float:
        """
        The number of BGP messages received.
        """
        return pulumi.get(self, "messages_received")

    @property
    @pulumi.getter(name="messagesSent")
    def messages_sent(self) -> float:
        """
        The number of BGP messages sent.
        """
        return pulumi.get(self, "messages_sent")

    @property
    @pulumi.getter
    def neighbor(self) -> str:
        """
        The remote BGP peer.
        """
        return pulumi.get(self, "neighbor")

    @property
    @pulumi.getter(name="routesReceived")
    def routes_received(self) -> float:
        """
        The number of routes learned from this peer.
        """
        return pulumi.get(self, "routes_received")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The BGP peer state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class BgpSettingsResponse(dict):
    """
    BGP settings details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bgpPeeringAddress":
            suggest = "bgp_peering_address"
        elif key == "bgpPeeringAddresses":
            suggest = "bgp_peering_addresses"
        elif key == "peerWeight":
            suggest = "peer_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BgpSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BgpSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BgpSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asn: Optional[float] = None,
                 bgp_peering_address: Optional[str] = None,
                 bgp_peering_addresses: Optional[Sequence['outputs.IPConfigurationBgpPeeringAddressResponse']] = None,
                 peer_weight: Optional[int] = None):
        """
        BGP settings details.
        :param float asn: The BGP speaker's ASN.
        :param str bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
        :param Sequence['IPConfigurationBgpPeeringAddressResponse'] bgp_peering_addresses: BGP peering address with IP configuration ID for virtual network gateway.
        :param int peer_weight: The weight added to routes learned from this BGP speaker.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if bgp_peering_address is not None:
            pulumi.set(__self__, "bgp_peering_address", bgp_peering_address)
        if bgp_peering_addresses is not None:
            pulumi.set(__self__, "bgp_peering_addresses", bgp_peering_addresses)
        if peer_weight is not None:
            pulumi.set(__self__, "peer_weight", peer_weight)

    @property
    @pulumi.getter
    def asn(self) -> Optional[float]:
        """
        The BGP speaker's ASN.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="bgpPeeringAddress")
    def bgp_peering_address(self) -> Optional[str]:
        """
        The BGP peering address and BGP identifier of this BGP speaker.
        """
        return pulumi.get(self, "bgp_peering_address")

    @property
    @pulumi.getter(name="bgpPeeringAddresses")
    def bgp_peering_addresses(self) -> Optional[Sequence['outputs.IPConfigurationBgpPeeringAddressResponse']]:
        """
        BGP peering address with IP configuration ID for virtual network gateway.
        """
        return pulumi.get(self, "bgp_peering_addresses")

    @property
    @pulumi.getter(name="peerWeight")
    def peer_weight(self) -> Optional[int]:
        """
        The weight added to routes learned from this BGP speaker.
        """
        return pulumi.get(self, "peer_weight")


@pulumi.output_type
class BreakOutCategoryPoliciesResponse(dict):
    """
    Network Virtual Appliance Sku Properties.
    """
    def __init__(__self__, *,
                 allow: Optional[bool] = None,
                 default: Optional[bool] = None,
                 optimize: Optional[bool] = None):
        """
        Network Virtual Appliance Sku Properties.
        :param bool allow: Flag to control breakout of o365 allow category.
        :param bool default: Flag to control breakout of o365 default category.
        :param bool optimize: Flag to control breakout of o365 optimize category.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if optimize is not None:
            pulumi.set(__self__, "optimize", optimize)

    @property
    @pulumi.getter
    def allow(self) -> Optional[bool]:
        """
        Flag to control breakout of o365 allow category.
        """
        return pulumi.get(self, "allow")

    @property
    @pulumi.getter
    def default(self) -> Optional[bool]:
        """
        Flag to control breakout of o365 default category.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def optimize(self) -> Optional[bool]:
        """
        Flag to control breakout of o365 optimize category.
        """
        return pulumi.get(self, "optimize")


@pulumi.output_type
class CacheConfigurationResponse(dict):
    """
    Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheDuration":
            suggest = "cache_duration"
        elif key == "dynamicCompression":
            suggest = "dynamic_compression"
        elif key == "queryParameterStripDirective":
            suggest = "query_parameter_strip_directive"
        elif key == "queryParameters":
            suggest = "query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_duration: Optional[str] = None,
                 dynamic_compression: Optional[str] = None,
                 query_parameter_strip_directive: Optional[str] = None,
                 query_parameters: Optional[str] = None):
        """
        Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
        :param str cache_duration: The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations). HTTP requires the value to be no more than a year
        :param str dynamic_compression: Whether to use dynamic compression for cached content
        :param str query_parameter_strip_directive: Treatment of URL query terms when forming the cache key.
        :param str query_parameters: query parameters to include or exclude (comma separated).
        """
        if cache_duration is not None:
            pulumi.set(__self__, "cache_duration", cache_duration)
        if dynamic_compression is not None:
            pulumi.set(__self__, "dynamic_compression", dynamic_compression)
        if query_parameter_strip_directive is not None:
            pulumi.set(__self__, "query_parameter_strip_directive", query_parameter_strip_directive)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)

    @property
    @pulumi.getter(name="cacheDuration")
    def cache_duration(self) -> Optional[str]:
        """
        The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations). HTTP requires the value to be no more than a year
        """
        return pulumi.get(self, "cache_duration")

    @property
    @pulumi.getter(name="dynamicCompression")
    def dynamic_compression(self) -> Optional[str]:
        """
        Whether to use dynamic compression for cached content
        """
        return pulumi.get(self, "dynamic_compression")

    @property
    @pulumi.getter(name="queryParameterStripDirective")
    def query_parameter_strip_directive(self) -> Optional[str]:
        """
        Treatment of URL query terms when forming the cache key.
        """
        return pulumi.get(self, "query_parameter_strip_directive")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[str]:
        """
        query parameters to include or exclude (comma separated).
        """
        return pulumi.get(self, "query_parameters")


@pulumi.output_type
class ConnectionMonitorDestinationResponse(dict):
    """
    Describes the destination of connection monitor.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 port: Optional[int] = None,
                 resource_id: Optional[str] = None):
        """
        Describes the destination of connection monitor.
        :param str address: Address of the connection monitor destination (IP or domain name).
        :param int port: The destination port used by connection monitor.
        :param str resource_id: The ID of the resource used as the destination by connection monitor.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Address of the connection monitor destination (IP or domain name).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The destination port used by connection monitor.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The ID of the resource used as the destination by connection monitor.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ConnectionMonitorEndpointFilterItemResponse(dict):
    """
    Describes the connection monitor endpoint filter item.
    """
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Describes the connection monitor endpoint filter item.
        :param str address: The address of the filter item.
        :param str type: The type of item included in the filter. Currently only 'AgentAddress' is supported.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The address of the filter item.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of item included in the filter. Currently only 'AgentAddress' is supported.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConnectionMonitorEndpointFilterResponse(dict):
    """
    Describes the connection monitor endpoint filter.
    """
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.ConnectionMonitorEndpointFilterItemResponse']] = None,
                 type: Optional[str] = None):
        """
        Describes the connection monitor endpoint filter.
        :param Sequence['ConnectionMonitorEndpointFilterItemResponse'] items: List of items in the filter.
        :param str type: The behavior of the endpoint filter. Currently only 'Include' is supported.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.ConnectionMonitorEndpointFilterItemResponse']]:
        """
        List of items in the filter.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The behavior of the endpoint filter. Currently only 'Include' is supported.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConnectionMonitorEndpointResponse(dict):
    """
    Describes the connection monitor endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 address: Optional[str] = None,
                 filter: Optional['outputs.ConnectionMonitorEndpointFilterResponse'] = None,
                 resource_id: Optional[str] = None):
        """
        Describes the connection monitor endpoint.
        :param str name: The name of the connection monitor endpoint.
        :param str address: Address of the connection monitor endpoint (IP or domain name).
        :param 'ConnectionMonitorEndpointFilterResponse' filter: Filter for sub-items within the endpoint.
        :param str resource_id: Resource ID of the connection monitor endpoint.
        """
        pulumi.set(__self__, "name", name)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the connection monitor endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Address of the connection monitor endpoint (IP or domain name).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.ConnectionMonitorEndpointFilterResponse']:
        """
        Filter for sub-items within the endpoint.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        Resource ID of the connection monitor endpoint.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ConnectionMonitorHttpConfigurationResponse(dict):
    """
    Describes the HTTP configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferHTTPS":
            suggest = "prefer_https"
        elif key == "requestHeaders":
            suggest = "request_headers"
        elif key == "validStatusCodeRanges":
            suggest = "valid_status_code_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorHttpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorHttpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorHttpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None,
                 prefer_https: Optional[bool] = None,
                 request_headers: Optional[Sequence['outputs.HTTPHeaderResponse']] = None,
                 valid_status_code_ranges: Optional[Sequence[str]] = None):
        """
        Describes the HTTP configuration.
        :param str method: The HTTP method to use.
        :param str path: The path component of the URI. For instance, "/dir1/dir2".
        :param int port: The port to connect to.
        :param bool prefer_https: Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
        :param Sequence['HTTPHeaderResponse'] request_headers: The HTTP headers to transmit with the request.
        :param Sequence[str] valid_status_code_ranges: HTTP status codes to consider successful. For instance, "2xx,301-304,418".
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if prefer_https is not None:
            pulumi.set(__self__, "prefer_https", prefer_https)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if valid_status_code_ranges is not None:
            pulumi.set(__self__, "valid_status_code_ranges", valid_status_code_ranges)

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        The HTTP method to use.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path component of the URI. For instance, "/dir1/dir2".
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port to connect to.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferHTTPS")
    def prefer_https(self) -> Optional[bool]:
        """
        Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
        """
        return pulumi.get(self, "prefer_https")

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[Sequence['outputs.HTTPHeaderResponse']]:
        """
        The HTTP headers to transmit with the request.
        """
        return pulumi.get(self, "request_headers")

    @property
    @pulumi.getter(name="validStatusCodeRanges")
    def valid_status_code_ranges(self) -> Optional[Sequence[str]]:
        """
        HTTP status codes to consider successful. For instance, "2xx,301-304,418".
        """
        return pulumi.get(self, "valid_status_code_ranges")


@pulumi.output_type
class ConnectionMonitorIcmpConfigurationResponse(dict):
    """
    Describes the ICMP configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableTraceRoute":
            suggest = "disable_trace_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorIcmpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorIcmpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorIcmpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_trace_route: Optional[bool] = None):
        """
        Describes the ICMP configuration.
        :param bool disable_trace_route: Value indicating whether path evaluation with trace route should be disabled.
        """
        if disable_trace_route is not None:
            pulumi.set(__self__, "disable_trace_route", disable_trace_route)

    @property
    @pulumi.getter(name="disableTraceRoute")
    def disable_trace_route(self) -> Optional[bool]:
        """
        Value indicating whether path evaluation with trace route should be disabled.
        """
        return pulumi.get(self, "disable_trace_route")


@pulumi.output_type
class ConnectionMonitorOutputResponse(dict):
    """
    Describes a connection monitor output destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceSettings":
            suggest = "workspace_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: Optional[str] = None,
                 workspace_settings: Optional['outputs.ConnectionMonitorWorkspaceSettingsResponse'] = None):
        """
        Describes a connection monitor output destination.
        :param str type: Connection monitor output destination type. Currently, only "Workspace" is supported.
        :param 'ConnectionMonitorWorkspaceSettingsResponse' workspace_settings: Describes the settings for producing output into a log analytics workspace.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if workspace_settings is not None:
            pulumi.set(__self__, "workspace_settings", workspace_settings)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Connection monitor output destination type. Currently, only "Workspace" is supported.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="workspaceSettings")
    def workspace_settings(self) -> Optional['outputs.ConnectionMonitorWorkspaceSettingsResponse']:
        """
        Describes the settings for producing output into a log analytics workspace.
        """
        return pulumi.get(self, "workspace_settings")


@pulumi.output_type
class ConnectionMonitorSourceResponse(dict):
    """
    Describes the source of connection monitor.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: str,
                 port: Optional[int] = None):
        """
        Describes the source of connection monitor.
        :param str resource_id: The ID of the resource used as the source by connection monitor.
        :param int port: The source port used by connection monitor.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The ID of the resource used as the source by connection monitor.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The source port used by connection monitor.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ConnectionMonitorSuccessThresholdResponse(dict):
    """
    Describes the threshold for declaring a test successful.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checksFailedPercent":
            suggest = "checks_failed_percent"
        elif key == "roundTripTimeMs":
            suggest = "round_trip_time_ms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorSuccessThresholdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorSuccessThresholdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorSuccessThresholdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 checks_failed_percent: Optional[int] = None,
                 round_trip_time_ms: Optional[float] = None):
        """
        Describes the threshold for declaring a test successful.
        :param int checks_failed_percent: The maximum percentage of failed checks permitted for a test to evaluate as successful.
        :param float round_trip_time_ms: The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.
        """
        if checks_failed_percent is not None:
            pulumi.set(__self__, "checks_failed_percent", checks_failed_percent)
        if round_trip_time_ms is not None:
            pulumi.set(__self__, "round_trip_time_ms", round_trip_time_ms)

    @property
    @pulumi.getter(name="checksFailedPercent")
    def checks_failed_percent(self) -> Optional[int]:
        """
        The maximum percentage of failed checks permitted for a test to evaluate as successful.
        """
        return pulumi.get(self, "checks_failed_percent")

    @property
    @pulumi.getter(name="roundTripTimeMs")
    def round_trip_time_ms(self) -> Optional[float]:
        """
        The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.
        """
        return pulumi.get(self, "round_trip_time_ms")


@pulumi.output_type
class ConnectionMonitorTcpConfigurationResponse(dict):
    """
    Describes the TCP configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableTraceRoute":
            suggest = "disable_trace_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorTcpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorTcpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorTcpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_trace_route: Optional[bool] = None,
                 port: Optional[int] = None):
        """
        Describes the TCP configuration.
        :param bool disable_trace_route: Value indicating whether path evaluation with trace route should be disabled.
        :param int port: The port to connect to.
        """
        if disable_trace_route is not None:
            pulumi.set(__self__, "disable_trace_route", disable_trace_route)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="disableTraceRoute")
    def disable_trace_route(self) -> Optional[bool]:
        """
        Value indicating whether path evaluation with trace route should be disabled.
        """
        return pulumi.get(self, "disable_trace_route")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port to connect to.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ConnectionMonitorTestConfigurationResponse(dict):
    """
    Describes a connection monitor test configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpConfiguration":
            suggest = "http_configuration"
        elif key == "icmpConfiguration":
            suggest = "icmp_configuration"
        elif key == "preferredIPVersion":
            suggest = "preferred_ip_version"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "tcpConfiguration":
            suggest = "tcp_configuration"
        elif key == "testFrequencySec":
            suggest = "test_frequency_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorTestConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorTestConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorTestConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 protocol: str,
                 http_configuration: Optional['outputs.ConnectionMonitorHttpConfigurationResponse'] = None,
                 icmp_configuration: Optional['outputs.ConnectionMonitorIcmpConfigurationResponse'] = None,
                 preferred_ip_version: Optional[str] = None,
                 success_threshold: Optional['outputs.ConnectionMonitorSuccessThresholdResponse'] = None,
                 tcp_configuration: Optional['outputs.ConnectionMonitorTcpConfigurationResponse'] = None,
                 test_frequency_sec: Optional[int] = None):
        """
        Describes a connection monitor test configuration.
        :param str name: The name of the connection monitor test configuration.
        :param str protocol: The protocol to use in test evaluation.
        :param 'ConnectionMonitorHttpConfigurationResponse' http_configuration: The parameters used to perform test evaluation over HTTP.
        :param 'ConnectionMonitorIcmpConfigurationResponse' icmp_configuration: The parameters used to perform test evaluation over ICMP.
        :param str preferred_ip_version: The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.
        :param 'ConnectionMonitorSuccessThresholdResponse' success_threshold: The threshold for declaring a test successful.
        :param 'ConnectionMonitorTcpConfigurationResponse' tcp_configuration: The parameters used to perform test evaluation over TCP.
        :param int test_frequency_sec: The frequency of test evaluation, in seconds.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)
        if http_configuration is not None:
            pulumi.set(__self__, "http_configuration", http_configuration)
        if icmp_configuration is not None:
            pulumi.set(__self__, "icmp_configuration", icmp_configuration)
        if preferred_ip_version is not None:
            pulumi.set(__self__, "preferred_ip_version", preferred_ip_version)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if tcp_configuration is not None:
            pulumi.set(__self__, "tcp_configuration", tcp_configuration)
        if test_frequency_sec is not None:
            pulumi.set(__self__, "test_frequency_sec", test_frequency_sec)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the connection monitor test configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol to use in test evaluation.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="httpConfiguration")
    def http_configuration(self) -> Optional['outputs.ConnectionMonitorHttpConfigurationResponse']:
        """
        The parameters used to perform test evaluation over HTTP.
        """
        return pulumi.get(self, "http_configuration")

    @property
    @pulumi.getter(name="icmpConfiguration")
    def icmp_configuration(self) -> Optional['outputs.ConnectionMonitorIcmpConfigurationResponse']:
        """
        The parameters used to perform test evaluation over ICMP.
        """
        return pulumi.get(self, "icmp_configuration")

    @property
    @pulumi.getter(name="preferredIPVersion")
    def preferred_ip_version(self) -> Optional[str]:
        """
        The preferred IP version to use in test evaluation. The connection monitor may choose to use a different version depending on other parameters.
        """
        return pulumi.get(self, "preferred_ip_version")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional['outputs.ConnectionMonitorSuccessThresholdResponse']:
        """
        The threshold for declaring a test successful.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="tcpConfiguration")
    def tcp_configuration(self) -> Optional['outputs.ConnectionMonitorTcpConfigurationResponse']:
        """
        The parameters used to perform test evaluation over TCP.
        """
        return pulumi.get(self, "tcp_configuration")

    @property
    @pulumi.getter(name="testFrequencySec")
    def test_frequency_sec(self) -> Optional[int]:
        """
        The frequency of test evaluation, in seconds.
        """
        return pulumi.get(self, "test_frequency_sec")


@pulumi.output_type
class ConnectionMonitorTestGroupResponse(dict):
    """
    Describes the connection monitor test group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testConfigurations":
            suggest = "test_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorTestGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorTestGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorTestGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destinations: Sequence[str],
                 name: str,
                 sources: Sequence[str],
                 test_configurations: Sequence[str],
                 disable: Optional[bool] = None):
        """
        Describes the connection monitor test group.
        :param Sequence[str] destinations: List of destination endpoint names.
        :param str name: The name of the connection monitor test group.
        :param Sequence[str] sources: List of source endpoint names.
        :param Sequence[str] test_configurations: List of test configuration names.
        :param bool disable: Value indicating whether test group is disabled.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "test_configurations", test_configurations)
        if disable is not None:
            pulumi.set(__self__, "disable", disable)

    @property
    @pulumi.getter
    def destinations(self) -> Sequence[str]:
        """
        List of destination endpoint names.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the connection monitor test group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sources(self) -> Sequence[str]:
        """
        List of source endpoint names.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="testConfigurations")
    def test_configurations(self) -> Sequence[str]:
        """
        List of test configuration names.
        """
        return pulumi.get(self, "test_configurations")

    @property
    @pulumi.getter
    def disable(self) -> Optional[bool]:
        """
        Value indicating whether test group is disabled.
        """
        return pulumi.get(self, "disable")


@pulumi.output_type
class ConnectionMonitorWorkspaceSettingsResponse(dict):
    """
    Describes the settings for producing output into a log analytics workspace.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceResourceId":
            suggest = "workspace_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorWorkspaceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorWorkspaceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorWorkspaceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workspace_resource_id: Optional[str] = None):
        """
        Describes the settings for producing output into a log analytics workspace.
        :param str workspace_resource_id: Log analytics workspace resource ID.
        """
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[str]:
        """
        Log analytics workspace resource ID.
        """
        return pulumi.get(self, "workspace_resource_id")


@pulumi.output_type
class ContainerNetworkInterfaceConfigurationResponse(dict):
    """
    Container network interface configuration child resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "containerNetworkInterfaces":
            suggest = "container_network_interfaces"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerNetworkInterfaceConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerNetworkInterfaceConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerNetworkInterfaceConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 container_network_interfaces: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 id: Optional[str] = None,
                 ip_configurations: Optional[Sequence['outputs.IPConfigurationProfileResponse']] = None,
                 name: Optional[str] = None):
        """
        Container network interface configuration child resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the container network interface configuration resource.
        :param str type: Sub Resource type.
        :param Sequence['SubResourceResponse'] container_network_interfaces: A list of container network interfaces created from this container network interface configuration.
        :param str id: Resource ID.
        :param Sequence['IPConfigurationProfileResponse'] ip_configurations: A list of ip configurations of the container network interface configuration.
        :param str name: The name of the resource. This name can be used to access the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if container_network_interfaces is not None:
            pulumi.set(__self__, "container_network_interfaces", container_network_interfaces)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the container network interface configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Sub Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="containerNetworkInterfaces")
    def container_network_interfaces(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        A list of container network interfaces created from this container network interface configuration.
        """
        return pulumi.get(self, "container_network_interfaces")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.IPConfigurationProfileResponse']]:
        """
        A list of ip configurations of the container network interface configuration.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContainerNetworkInterfaceIpConfigurationResponse(dict):
    """
    The ip configuration for a container network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerNetworkInterfaceIpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerNetworkInterfaceIpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerNetworkInterfaceIpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 name: Optional[str] = None):
        """
        The ip configuration for a container network interface.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the container network interface IP configuration resource.
        :param str type: Sub Resource type.
        :param str name: The name of the resource. This name can be used to access the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the container network interface IP configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Sub Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContainerNetworkInterfaceResponse(dict):
    """
    Container network interface child resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerNetworkInterfaceConfiguration":
            suggest = "container_network_interface_configuration"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerNetworkInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerNetworkInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerNetworkInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_network_interface_configuration: 'outputs.ContainerNetworkInterfaceConfigurationResponse',
                 etag: str,
                 ip_configurations: Sequence['outputs.ContainerNetworkInterfaceIpConfigurationResponse'],
                 provisioning_state: str,
                 type: str,
                 container: Optional['outputs.ContainerResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Container network interface child resource.
        :param 'ContainerNetworkInterfaceConfigurationResponse' container_network_interface_configuration: Container network interface configuration from which this container network interface is created.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param Sequence['ContainerNetworkInterfaceIpConfigurationResponse'] ip_configurations: Reference to the ip configuration on this container nic.
        :param str provisioning_state: The provisioning state of the container network interface resource.
        :param str type: Sub Resource type.
        :param 'ContainerResponse' container: Reference to the container to which this container network interface is attached.
        :param str id: Resource ID.
        :param str name: The name of the resource. This name can be used to access the resource.
        """
        pulumi.set(__self__, "container_network_interface_configuration", container_network_interface_configuration)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerNetworkInterfaceConfiguration")
    def container_network_interface_configuration(self) -> 'outputs.ContainerNetworkInterfaceConfigurationResponse':
        """
        Container network interface configuration from which this container network interface is created.
        """
        return pulumi.get(self, "container_network_interface_configuration")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.ContainerNetworkInterfaceIpConfigurationResponse']:
        """
        Reference to the ip configuration on this container nic.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the container network interface resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Sub Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def container(self) -> Optional['outputs.ContainerResponse']:
        """
        Reference to the container to which this container network interface is attached.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContainerResponse(dict):
    """
    Reference to container resource in remote resource provider.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Reference to container resource in remote resource provider.
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class CustomDnsConfigPropertiesFormatResponse(dict):
    """
    Contains custom Dns resolution configuration from customer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDnsConfigPropertiesFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDnsConfigPropertiesFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDnsConfigPropertiesFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        Contains custom Dns resolution configuration from customer.
        :param str fqdn: Fqdn that resolves to private endpoint ip address.
        :param Sequence[str] ip_addresses: A list of private ip addresses of the private endpoint.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Fqdn that resolves to private endpoint ip address.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        A list of private ip addresses of the private endpoint.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class CustomHttpsConfigurationResponse(dict):
    """
    Https settings for a domain
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSource":
            suggest = "certificate_source"
        elif key == "minimumTlsVersion":
            suggest = "minimum_tls_version"
        elif key == "protocolType":
            suggest = "protocol_type"
        elif key == "certificateType":
            suggest = "certificate_type"
        elif key == "secretName":
            suggest = "secret_name"
        elif key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomHttpsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomHttpsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomHttpsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_source: str,
                 minimum_tls_version: str,
                 protocol_type: str,
                 certificate_type: Optional[str] = None,
                 secret_name: Optional[str] = None,
                 secret_version: Optional[str] = None,
                 vault: Optional['outputs.KeyVaultCertificateSourceParametersResponseVault'] = None):
        """
        Https settings for a domain
        :param str certificate_source: Defines the source of the SSL certificate
        :param str minimum_tls_version: The minimum TLS version required from the clients to establish an SSL handshake with Front Door.
        :param str protocol_type: Defines the TLS extension protocol that is used for secure delivery
        :param str certificate_type: Defines the type of the certificate used for secure connections to a frontendEndpoint
        :param str secret_name: The name of the Key Vault secret representing the full certificate PFX
        :param str secret_version: The version of the Key Vault secret representing the full certificate PFX
        :param 'KeyVaultCertificateSourceParametersResponseVault' vault: The Key Vault containing the SSL certificate
        """
        pulumi.set(__self__, "certificate_source", certificate_source)
        pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)
        pulumi.set(__self__, "protocol_type", protocol_type)
        if certificate_type is not None:
            pulumi.set(__self__, "certificate_type", certificate_type)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)
        if vault is not None:
            pulumi.set(__self__, "vault", vault)

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> str:
        """
        Defines the source of the SSL certificate
        """
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> str:
        """
        The minimum TLS version required from the clients to establish an SSL handshake with Front Door.
        """
        return pulumi.get(self, "minimum_tls_version")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> str:
        """
        Defines the TLS extension protocol that is used for secure delivery
        """
        return pulumi.get(self, "protocol_type")

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> Optional[str]:
        """
        Defines the type of the certificate used for secure connections to a frontendEndpoint
        """
        return pulumi.get(self, "certificate_type")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[str]:
        """
        The name of the Key Vault secret representing the full certificate PFX
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[str]:
        """
        The version of the Key Vault secret representing the full certificate PFX
        """
        return pulumi.get(self, "secret_version")

    @property
    @pulumi.getter
    def vault(self) -> Optional['outputs.KeyVaultCertificateSourceParametersResponseVault']:
        """
        The Key Vault containing the SSL certificate
        """
        return pulumi.get(self, "vault")


@pulumi.output_type
class DdosSettingsResponse(dict):
    """
    Contains the DDoS protection settings of the public IP.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ddosCustomPolicy":
            suggest = "ddos_custom_policy"
        elif key == "protectedIP":
            suggest = "protected_ip"
        elif key == "protectionCoverage":
            suggest = "protection_coverage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DdosSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DdosSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DdosSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ddos_custom_policy: Optional['outputs.SubResourceResponse'] = None,
                 protected_ip: Optional[bool] = None,
                 protection_coverage: Optional[str] = None):
        """
        Contains the DDoS protection settings of the public IP.
        :param 'SubResourceResponse' ddos_custom_policy: The DDoS custom policy associated with the public IP.
        :param bool protected_ip: Enables DDoS protection on the public IP.
        :param str protection_coverage: The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized.
        """
        if ddos_custom_policy is not None:
            pulumi.set(__self__, "ddos_custom_policy", ddos_custom_policy)
        if protected_ip is not None:
            pulumi.set(__self__, "protected_ip", protected_ip)
        if protection_coverage is not None:
            pulumi.set(__self__, "protection_coverage", protection_coverage)

    @property
    @pulumi.getter(name="ddosCustomPolicy")
    def ddos_custom_policy(self) -> Optional['outputs.SubResourceResponse']:
        """
        The DDoS custom policy associated with the public IP.
        """
        return pulumi.get(self, "ddos_custom_policy")

    @property
    @pulumi.getter(name="protectedIP")
    def protected_ip(self) -> Optional[bool]:
        """
        Enables DDoS protection on the public IP.
        """
        return pulumi.get(self, "protected_ip")

    @property
    @pulumi.getter(name="protectionCoverage")
    def protection_coverage(self) -> Optional[str]:
        """
        The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized.
        """
        return pulumi.get(self, "protection_coverage")


@pulumi.output_type
class DelegationResponse(dict):
    """
    Details the service to which the subnet is delegated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DelegationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DelegationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DelegationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence[str],
                 etag: str,
                 provisioning_state: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 service_name: Optional[str] = None):
        """
        Details the service to which the subnet is delegated.
        :param Sequence[str] actions: The actions permitted to the service upon delegation.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the service delegation resource.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a subnet. This name can be used to access the resource.
        :param str service_name: The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[str]:
        """
        The actions permitted to the service upon delegation.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the service delegation resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a subnet. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class DevicePropertiesResponse(dict):
    """
    List of properties of the device.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceModel":
            suggest = "device_model"
        elif key == "deviceVendor":
            suggest = "device_vendor"
        elif key == "linkSpeedInMbps":
            suggest = "link_speed_in_mbps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DevicePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DevicePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DevicePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_model: Optional[str] = None,
                 device_vendor: Optional[str] = None,
                 link_speed_in_mbps: Optional[int] = None):
        """
        List of properties of the device.
        :param str device_model: Model of the device.
        :param str device_vendor: Name of the device Vendor.
        :param int link_speed_in_mbps: Link speed.
        """
        if device_model is not None:
            pulumi.set(__self__, "device_model", device_model)
        if device_vendor is not None:
            pulumi.set(__self__, "device_vendor", device_vendor)
        if link_speed_in_mbps is not None:
            pulumi.set(__self__, "link_speed_in_mbps", link_speed_in_mbps)

    @property
    @pulumi.getter(name="deviceModel")
    def device_model(self) -> Optional[str]:
        """
        Model of the device.
        """
        return pulumi.get(self, "device_model")

    @property
    @pulumi.getter(name="deviceVendor")
    def device_vendor(self) -> Optional[str]:
        """
        Name of the device Vendor.
        """
        return pulumi.get(self, "device_vendor")

    @property
    @pulumi.getter(name="linkSpeedInMbps")
    def link_speed_in_mbps(self) -> Optional[int]:
        """
        Link speed.
        """
        return pulumi.get(self, "link_speed_in_mbps")


@pulumi.output_type
class DhcpOptionsResponse(dict):
    """
    DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServers":
            suggest = "dns_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DhcpOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DhcpOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DhcpOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_servers: Optional[Sequence[str]] = None):
        """
        DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
        :param Sequence[str] dns_servers: The list of DNS servers IP addresses.
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        The list of DNS servers IP addresses.
        """
        return pulumi.get(self, "dns_servers")


@pulumi.output_type
class DnsSettingsResponse(dict):
    """
    DNS Proxy Settings in Firewall Policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableProxy":
            suggest = "enable_proxy"
        elif key == "requireProxyForNetworkRules":
            suggest = "require_proxy_for_network_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_proxy: Optional[bool] = None,
                 require_proxy_for_network_rules: Optional[bool] = None,
                 servers: Optional[Sequence[str]] = None):
        """
        DNS Proxy Settings in Firewall Policy.
        :param bool enable_proxy: Enable DNS Proxy on Firewalls attached to the Firewall Policy.
        :param bool require_proxy_for_network_rules: FQDNs in Network Rules are supported when set to true.
        :param Sequence[str] servers: List of Custom DNS Servers.
        """
        if enable_proxy is not None:
            pulumi.set(__self__, "enable_proxy", enable_proxy)
        if require_proxy_for_network_rules is not None:
            pulumi.set(__self__, "require_proxy_for_network_rules", require_proxy_for_network_rules)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)

    @property
    @pulumi.getter(name="enableProxy")
    def enable_proxy(self) -> Optional[bool]:
        """
        Enable DNS Proxy on Firewalls attached to the Firewall Policy.
        """
        return pulumi.get(self, "enable_proxy")

    @property
    @pulumi.getter(name="requireProxyForNetworkRules")
    def require_proxy_for_network_rules(self) -> Optional[bool]:
        """
        FQDNs in Network Rules are supported when set to true.
        """
        return pulumi.get(self, "require_proxy_for_network_rules")

    @property
    @pulumi.getter
    def servers(self) -> Optional[Sequence[str]]:
        """
        List of Custom DNS Servers.
        """
        return pulumi.get(self, "servers")


@pulumi.output_type
class ExpressRouteCircuitAuthorizationResponse(dict):
    """
    Authorization in an ExpressRouteCircuit resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "authorizationKey":
            suggest = "authorization_key"
        elif key == "authorizationUseStatus":
            suggest = "authorization_use_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitAuthorizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitAuthorizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitAuthorizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 authorization_key: Optional[str] = None,
                 authorization_use_status: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Authorization in an ExpressRouteCircuit resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the authorization resource.
        :param str type: Type of the resource.
        :param str authorization_key: The authorization key.
        :param str authorization_use_status: The authorization use status.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if authorization_use_status is not None:
            pulumi.set(__self__, "authorization_use_status", authorization_use_status)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the authorization resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[str]:
        """
        The authorization key.
        """
        return pulumi.get(self, "authorization_key")

    @property
    @pulumi.getter(name="authorizationUseStatus")
    def authorization_use_status(self) -> Optional[str]:
        """
        The authorization use status.
        """
        return pulumi.get(self, "authorization_use_status")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ExpressRouteCircuitConnectionResponse(dict):
    """
    Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "circuitConnectionStatus":
            suggest = "circuit_connection_status"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "authorizationKey":
            suggest = "authorization_key"
        elif key == "expressRouteCircuitPeering":
            suggest = "express_route_circuit_peering"
        elif key == "ipv6CircuitConnectionConfig":
            suggest = "ipv6_circuit_connection_config"
        elif key == "peerExpressRouteCircuitPeering":
            suggest = "peer_express_route_circuit_peering"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 circuit_connection_status: str,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 address_prefix: Optional[str] = None,
                 authorization_key: Optional[str] = None,
                 express_route_circuit_peering: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 ipv6_circuit_connection_config: Optional['outputs.Ipv6CircuitConnectionConfigResponse'] = None,
                 name: Optional[str] = None,
                 peer_express_route_circuit_peering: Optional['outputs.SubResourceResponse'] = None):
        """
        Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
        :param str circuit_connection_status: Express Route Circuit connection state.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the express route circuit connection resource.
        :param str type: Type of the resource.
        :param str address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
        :param str authorization_key: The authorization key.
        :param 'SubResourceResponse' express_route_circuit_peering: Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
        :param str id: Resource ID.
        :param 'Ipv6CircuitConnectionConfigResponse' ipv6_circuit_connection_config: IPv6 Address PrefixProperties of the express route circuit connection.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'SubResourceResponse' peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering Resource of the peered circuit.
        """
        pulumi.set(__self__, "circuit_connection_status", circuit_connection_status)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if express_route_circuit_peering is not None:
            pulumi.set(__self__, "express_route_circuit_peering", express_route_circuit_peering)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ipv6_circuit_connection_config is not None:
            pulumi.set(__self__, "ipv6_circuit_connection_config", ipv6_circuit_connection_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_express_route_circuit_peering is not None:
            pulumi.set(__self__, "peer_express_route_circuit_peering", peer_express_route_circuit_peering)

    @property
    @pulumi.getter(name="circuitConnectionStatus")
    def circuit_connection_status(self) -> str:
        """
        Express Route Circuit connection state.
        """
        return pulumi.get(self, "circuit_connection_status")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the express route circuit connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        /29 IP address space to carve out Customer addresses for tunnels.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[str]:
        """
        The authorization key.
        """
        return pulumi.get(self, "authorization_key")

    @property
    @pulumi.getter(name="expressRouteCircuitPeering")
    def express_route_circuit_peering(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
        """
        return pulumi.get(self, "express_route_circuit_peering")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv6CircuitConnectionConfig")
    def ipv6_circuit_connection_config(self) -> Optional['outputs.Ipv6CircuitConnectionConfigResponse']:
        """
        IPv6 Address PrefixProperties of the express route circuit connection.
        """
        return pulumi.get(self, "ipv6_circuit_connection_config")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerExpressRouteCircuitPeering")
    def peer_express_route_circuit_peering(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to Express Route Circuit Private Peering Resource of the peered circuit.
        """
        return pulumi.get(self, "peer_express_route_circuit_peering")


@pulumi.output_type
class ExpressRouteCircuitPeeringConfigResponse(dict):
    """
    Specifies the peering configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advertisedPublicPrefixesState":
            suggest = "advertised_public_prefixes_state"
        elif key == "advertisedCommunities":
            suggest = "advertised_communities"
        elif key == "advertisedPublicPrefixes":
            suggest = "advertised_public_prefixes"
        elif key == "customerASN":
            suggest = "customer_asn"
        elif key == "legacyMode":
            suggest = "legacy_mode"
        elif key == "routingRegistryName":
            suggest = "routing_registry_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitPeeringConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advertised_public_prefixes_state: str,
                 advertised_communities: Optional[Sequence[str]] = None,
                 advertised_public_prefixes: Optional[Sequence[str]] = None,
                 customer_asn: Optional[int] = None,
                 legacy_mode: Optional[int] = None,
                 routing_registry_name: Optional[str] = None):
        """
        Specifies the peering configuration.
        :param str advertised_public_prefixes_state: The advertised public prefix state of the Peering resource.
        :param Sequence[str] advertised_communities: The communities of bgp peering. Specified for microsoft peering.
        :param Sequence[str] advertised_public_prefixes: The reference to AdvertisedPublicPrefixes.
        :param int customer_asn: The CustomerASN of the peering.
        :param int legacy_mode: The legacy mode of the peering.
        :param str routing_registry_name: The RoutingRegistryName of the configuration.
        """
        pulumi.set(__self__, "advertised_public_prefixes_state", advertised_public_prefixes_state)
        if advertised_communities is not None:
            pulumi.set(__self__, "advertised_communities", advertised_communities)
        if advertised_public_prefixes is not None:
            pulumi.set(__self__, "advertised_public_prefixes", advertised_public_prefixes)
        if customer_asn is not None:
            pulumi.set(__self__, "customer_asn", customer_asn)
        if legacy_mode is not None:
            pulumi.set(__self__, "legacy_mode", legacy_mode)
        if routing_registry_name is not None:
            pulumi.set(__self__, "routing_registry_name", routing_registry_name)

    @property
    @pulumi.getter(name="advertisedPublicPrefixesState")
    def advertised_public_prefixes_state(self) -> str:
        """
        The advertised public prefix state of the Peering resource.
        """
        return pulumi.get(self, "advertised_public_prefixes_state")

    @property
    @pulumi.getter(name="advertisedCommunities")
    def advertised_communities(self) -> Optional[Sequence[str]]:
        """
        The communities of bgp peering. Specified for microsoft peering.
        """
        return pulumi.get(self, "advertised_communities")

    @property
    @pulumi.getter(name="advertisedPublicPrefixes")
    def advertised_public_prefixes(self) -> Optional[Sequence[str]]:
        """
        The reference to AdvertisedPublicPrefixes.
        """
        return pulumi.get(self, "advertised_public_prefixes")

    @property
    @pulumi.getter(name="customerASN")
    def customer_asn(self) -> Optional[int]:
        """
        The CustomerASN of the peering.
        """
        return pulumi.get(self, "customer_asn")

    @property
    @pulumi.getter(name="legacyMode")
    def legacy_mode(self) -> Optional[int]:
        """
        The legacy mode of the peering.
        """
        return pulumi.get(self, "legacy_mode")

    @property
    @pulumi.getter(name="routingRegistryName")
    def routing_registry_name(self) -> Optional[str]:
        """
        The RoutingRegistryName of the configuration.
        """
        return pulumi.get(self, "routing_registry_name")


@pulumi.output_type
class ExpressRouteCircuitPeeringIdResponse(dict):
    """
    ExpressRoute circuit peering identifier.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        ExpressRoute circuit peering identifier.
        :param str id: The ID of the ExpressRoute circuit peering.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the ExpressRoute circuit peering.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ExpressRouteCircuitPeeringResponse(dict):
    """
    Peering in an ExpressRouteCircuit resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "peeredConnections":
            suggest = "peered_connections"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "azureASN":
            suggest = "azure_asn"
        elif key == "expressRouteConnection":
            suggest = "express_route_connection"
        elif key == "gatewayManagerEtag":
            suggest = "gateway_manager_etag"
        elif key == "ipv6PeeringConfig":
            suggest = "ipv6_peering_config"
        elif key == "microsoftPeeringConfig":
            suggest = "microsoft_peering_config"
        elif key == "peerASN":
            suggest = "peer_asn"
        elif key == "peeringType":
            suggest = "peering_type"
        elif key == "primaryAzurePort":
            suggest = "primary_azure_port"
        elif key == "primaryPeerAddressPrefix":
            suggest = "primary_peer_address_prefix"
        elif key == "routeFilter":
            suggest = "route_filter"
        elif key == "secondaryAzurePort":
            suggest = "secondary_azure_port"
        elif key == "secondaryPeerAddressPrefix":
            suggest = "secondary_peer_address_prefix"
        elif key == "sharedKey":
            suggest = "shared_key"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitPeeringResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitPeeringResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitPeeringResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 last_modified_by: str,
                 peered_connections: Sequence['outputs.PeerExpressRouteCircuitConnectionResponse'],
                 provisioning_state: str,
                 type: str,
                 azure_asn: Optional[int] = None,
                 connections: Optional[Sequence['outputs.ExpressRouteCircuitConnectionResponse']] = None,
                 express_route_connection: Optional['outputs.ExpressRouteConnectionIdResponse'] = None,
                 gateway_manager_etag: Optional[str] = None,
                 id: Optional[str] = None,
                 ipv6_peering_config: Optional['outputs.Ipv6ExpressRouteCircuitPeeringConfigResponse'] = None,
                 microsoft_peering_config: Optional['outputs.ExpressRouteCircuitPeeringConfigResponse'] = None,
                 name: Optional[str] = None,
                 peer_asn: Optional[float] = None,
                 peering_type: Optional[str] = None,
                 primary_azure_port: Optional[str] = None,
                 primary_peer_address_prefix: Optional[str] = None,
                 route_filter: Optional['outputs.SubResourceResponse'] = None,
                 secondary_azure_port: Optional[str] = None,
                 secondary_peer_address_prefix: Optional[str] = None,
                 shared_key: Optional[str] = None,
                 state: Optional[str] = None,
                 stats: Optional['outputs.ExpressRouteCircuitStatsResponse'] = None,
                 vlan_id: Optional[int] = None):
        """
        Peering in an ExpressRouteCircuit resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str last_modified_by: Who was the last to modify the peering.
        :param Sequence['PeerExpressRouteCircuitConnectionResponse'] peered_connections: The list of peered circuit connections associated with Azure Private Peering for this circuit.
        :param str provisioning_state: The provisioning state of the express route circuit peering resource.
        :param str type: Type of the resource.
        :param int azure_asn: The Azure ASN.
        :param Sequence['ExpressRouteCircuitConnectionResponse'] connections: The list of circuit connections associated with Azure Private Peering for this circuit.
        :param 'ExpressRouteConnectionIdResponse' express_route_connection: The ExpressRoute connection.
        :param str gateway_manager_etag: The GatewayManager Etag.
        :param str id: Resource ID.
        :param 'Ipv6ExpressRouteCircuitPeeringConfigResponse' ipv6_peering_config: The IPv6 peering configuration.
        :param 'ExpressRouteCircuitPeeringConfigResponse' microsoft_peering_config: The Microsoft peering configuration.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param float peer_asn: The peer ASN.
        :param str peering_type: The peering type.
        :param str primary_azure_port: The primary port.
        :param str primary_peer_address_prefix: The primary address prefix.
        :param 'SubResourceResponse' route_filter: The reference to the RouteFilter resource.
        :param str secondary_azure_port: The secondary port.
        :param str secondary_peer_address_prefix: The secondary address prefix.
        :param str shared_key: The shared key.
        :param str state: The peering state.
        :param 'ExpressRouteCircuitStatsResponse' stats: The peering stats of express route circuit.
        :param int vlan_id: The VLAN ID.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "last_modified_by", last_modified_by)
        pulumi.set(__self__, "peered_connections", peered_connections)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if azure_asn is not None:
            pulumi.set(__self__, "azure_asn", azure_asn)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if express_route_connection is not None:
            pulumi.set(__self__, "express_route_connection", express_route_connection)
        if gateway_manager_etag is not None:
            pulumi.set(__self__, "gateway_manager_etag", gateway_manager_etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ipv6_peering_config is not None:
            pulumi.set(__self__, "ipv6_peering_config", ipv6_peering_config)
        if microsoft_peering_config is not None:
            pulumi.set(__self__, "microsoft_peering_config", microsoft_peering_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peering_type is not None:
            pulumi.set(__self__, "peering_type", peering_type)
        if primary_azure_port is not None:
            pulumi.set(__self__, "primary_azure_port", primary_azure_port)
        if primary_peer_address_prefix is not None:
            pulumi.set(__self__, "primary_peer_address_prefix", primary_peer_address_prefix)
        if route_filter is not None:
            pulumi.set(__self__, "route_filter", route_filter)
        if secondary_azure_port is not None:
            pulumi.set(__self__, "secondary_azure_port", secondary_azure_port)
        if secondary_peer_address_prefix is not None:
            pulumi.set(__self__, "secondary_peer_address_prefix", secondary_peer_address_prefix)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stats is not None:
            pulumi.set(__self__, "stats", stats)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> str:
        """
        Who was the last to modify the peering.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="peeredConnections")
    def peered_connections(self) -> Sequence['outputs.PeerExpressRouteCircuitConnectionResponse']:
        """
        The list of peered circuit connections associated with Azure Private Peering for this circuit.
        """
        return pulumi.get(self, "peered_connections")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the express route circuit peering resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="azureASN")
    def azure_asn(self) -> Optional[int]:
        """
        The Azure ASN.
        """
        return pulumi.get(self, "azure_asn")

    @property
    @pulumi.getter
    def connections(self) -> Optional[Sequence['outputs.ExpressRouteCircuitConnectionResponse']]:
        """
        The list of circuit connections associated with Azure Private Peering for this circuit.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter(name="expressRouteConnection")
    def express_route_connection(self) -> Optional['outputs.ExpressRouteConnectionIdResponse']:
        """
        The ExpressRoute connection.
        """
        return pulumi.get(self, "express_route_connection")

    @property
    @pulumi.getter(name="gatewayManagerEtag")
    def gateway_manager_etag(self) -> Optional[str]:
        """
        The GatewayManager Etag.
        """
        return pulumi.get(self, "gateway_manager_etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv6PeeringConfig")
    def ipv6_peering_config(self) -> Optional['outputs.Ipv6ExpressRouteCircuitPeeringConfigResponse']:
        """
        The IPv6 peering configuration.
        """
        return pulumi.get(self, "ipv6_peering_config")

    @property
    @pulumi.getter(name="microsoftPeeringConfig")
    def microsoft_peering_config(self) -> Optional['outputs.ExpressRouteCircuitPeeringConfigResponse']:
        """
        The Microsoft peering configuration.
        """
        return pulumi.get(self, "microsoft_peering_config")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> Optional[float]:
        """
        The peer ASN.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> Optional[str]:
        """
        The peering type.
        """
        return pulumi.get(self, "peering_type")

    @property
    @pulumi.getter(name="primaryAzurePort")
    def primary_azure_port(self) -> Optional[str]:
        """
        The primary port.
        """
        return pulumi.get(self, "primary_azure_port")

    @property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> Optional[str]:
        """
        The primary address prefix.
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @property
    @pulumi.getter(name="routeFilter")
    def route_filter(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference to the RouteFilter resource.
        """
        return pulumi.get(self, "route_filter")

    @property
    @pulumi.getter(name="secondaryAzurePort")
    def secondary_azure_port(self) -> Optional[str]:
        """
        The secondary port.
        """
        return pulumi.get(self, "secondary_azure_port")

    @property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> Optional[str]:
        """
        The secondary address prefix.
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[str]:
        """
        The shared key.
        """
        return pulumi.get(self, "shared_key")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The peering state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def stats(self) -> Optional['outputs.ExpressRouteCircuitStatsResponse']:
        """
        The peering stats of express route circuit.
        """
        return pulumi.get(self, "stats")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[int]:
        """
        The VLAN ID.
        """
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class ExpressRouteCircuitServiceProviderPropertiesResponse(dict):
    """
    Contains ServiceProviderProperties in an ExpressRouteCircuit.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthInMbps":
            suggest = "bandwidth_in_mbps"
        elif key == "peeringLocation":
            suggest = "peering_location"
        elif key == "serviceProviderName":
            suggest = "service_provider_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitServiceProviderPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitServiceProviderPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitServiceProviderPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_in_mbps: Optional[int] = None,
                 peering_location: Optional[str] = None,
                 service_provider_name: Optional[str] = None):
        """
        Contains ServiceProviderProperties in an ExpressRouteCircuit.
        :param int bandwidth_in_mbps: The BandwidthInMbps.
        :param str peering_location: The peering location.
        :param str service_provider_name: The serviceProviderName.
        """
        if bandwidth_in_mbps is not None:
            pulumi.set(__self__, "bandwidth_in_mbps", bandwidth_in_mbps)
        if peering_location is not None:
            pulumi.set(__self__, "peering_location", peering_location)
        if service_provider_name is not None:
            pulumi.set(__self__, "service_provider_name", service_provider_name)

    @property
    @pulumi.getter(name="bandwidthInMbps")
    def bandwidth_in_mbps(self) -> Optional[int]:
        """
        The BandwidthInMbps.
        """
        return pulumi.get(self, "bandwidth_in_mbps")

    @property
    @pulumi.getter(name="peeringLocation")
    def peering_location(self) -> Optional[str]:
        """
        The peering location.
        """
        return pulumi.get(self, "peering_location")

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> Optional[str]:
        """
        The serviceProviderName.
        """
        return pulumi.get(self, "service_provider_name")


@pulumi.output_type
class ExpressRouteCircuitSkuResponse(dict):
    """
    Contains SKU in an ExpressRouteCircuit.
    """
    def __init__(__self__, *,
                 family: Optional[str] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Contains SKU in an ExpressRouteCircuit.
        :param str family: The family of the SKU.
        :param str name: The name of the SKU.
        :param str tier: The tier of the SKU.
        """
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        The family of the SKU.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier of the SKU.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class ExpressRouteCircuitStatsResponse(dict):
    """
    Contains stats associated with the peering.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primarybytesIn":
            suggest = "primarybytes_in"
        elif key == "primarybytesOut":
            suggest = "primarybytes_out"
        elif key == "secondarybytesIn":
            suggest = "secondarybytes_in"
        elif key == "secondarybytesOut":
            suggest = "secondarybytes_out"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitStatsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitStatsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitStatsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primarybytes_in: Optional[float] = None,
                 primarybytes_out: Optional[float] = None,
                 secondarybytes_in: Optional[float] = None,
                 secondarybytes_out: Optional[float] = None):
        """
        Contains stats associated with the peering.
        :param float primarybytes_in: The Primary BytesIn of the peering.
        :param float primarybytes_out: The primary BytesOut of the peering.
        :param float secondarybytes_in: The secondary BytesIn of the peering.
        :param float secondarybytes_out: The secondary BytesOut of the peering.
        """
        if primarybytes_in is not None:
            pulumi.set(__self__, "primarybytes_in", primarybytes_in)
        if primarybytes_out is not None:
            pulumi.set(__self__, "primarybytes_out", primarybytes_out)
        if secondarybytes_in is not None:
            pulumi.set(__self__, "secondarybytes_in", secondarybytes_in)
        if secondarybytes_out is not None:
            pulumi.set(__self__, "secondarybytes_out", secondarybytes_out)

    @property
    @pulumi.getter(name="primarybytesIn")
    def primarybytes_in(self) -> Optional[float]:
        """
        The Primary BytesIn of the peering.
        """
        return pulumi.get(self, "primarybytes_in")

    @property
    @pulumi.getter(name="primarybytesOut")
    def primarybytes_out(self) -> Optional[float]:
        """
        The primary BytesOut of the peering.
        """
        return pulumi.get(self, "primarybytes_out")

    @property
    @pulumi.getter(name="secondarybytesIn")
    def secondarybytes_in(self) -> Optional[float]:
        """
        The secondary BytesIn of the peering.
        """
        return pulumi.get(self, "secondarybytes_in")

    @property
    @pulumi.getter(name="secondarybytesOut")
    def secondarybytes_out(self) -> Optional[float]:
        """
        The secondary BytesOut of the peering.
        """
        return pulumi.get(self, "secondarybytes_out")


@pulumi.output_type
class ExpressRouteConnectionIdResponse(dict):
    """
    The ID of the ExpressRouteConnection.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The ID of the ExpressRouteConnection.
        :param str id: The ID of the ExpressRouteConnection.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the ExpressRouteConnection.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ExpressRouteConnectionResponse(dict):
    """
    ExpressRouteConnection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expressRouteCircuitPeering":
            suggest = "express_route_circuit_peering"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "authorizationKey":
            suggest = "authorization_key"
        elif key == "enableInternetSecurity":
            suggest = "enable_internet_security"
        elif key == "routingConfiguration":
            suggest = "routing_configuration"
        elif key == "routingWeight":
            suggest = "routing_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 express_route_circuit_peering: 'outputs.ExpressRouteCircuitPeeringIdResponse',
                 name: str,
                 provisioning_state: str,
                 authorization_key: Optional[str] = None,
                 enable_internet_security: Optional[bool] = None,
                 id: Optional[str] = None,
                 routing_configuration: Optional['outputs.RoutingConfigurationResponse'] = None,
                 routing_weight: Optional[int] = None):
        """
        ExpressRouteConnection resource.
        :param 'ExpressRouteCircuitPeeringIdResponse' express_route_circuit_peering: The ExpressRoute circuit peering.
        :param str name: The name of the resource.
        :param str provisioning_state: The provisioning state of the express route connection resource.
        :param str authorization_key: Authorization key to establish the connection.
        :param bool enable_internet_security: Enable internet security.
        :param str id: Resource ID.
        :param 'RoutingConfigurationResponse' routing_configuration: The Routing Configuration indicating the associated and propagated route tables on this connection.
        :param int routing_weight: The routing weight associated to the connection.
        """
        pulumi.set(__self__, "express_route_circuit_peering", express_route_circuit_peering)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if enable_internet_security is not None:
            pulumi.set(__self__, "enable_internet_security", enable_internet_security)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if routing_configuration is not None:
            pulumi.set(__self__, "routing_configuration", routing_configuration)
        if routing_weight is not None:
            pulumi.set(__self__, "routing_weight", routing_weight)

    @property
    @pulumi.getter(name="expressRouteCircuitPeering")
    def express_route_circuit_peering(self) -> 'outputs.ExpressRouteCircuitPeeringIdResponse':
        """
        The ExpressRoute circuit peering.
        """
        return pulumi.get(self, "express_route_circuit_peering")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the express route connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[str]:
        """
        Authorization key to establish the connection.
        """
        return pulumi.get(self, "authorization_key")

    @property
    @pulumi.getter(name="enableInternetSecurity")
    def enable_internet_security(self) -> Optional[bool]:
        """
        Enable internet security.
        """
        return pulumi.get(self, "enable_internet_security")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> Optional['outputs.RoutingConfigurationResponse']:
        """
        The Routing Configuration indicating the associated and propagated route tables on this connection.
        """
        return pulumi.get(self, "routing_configuration")

    @property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> Optional[int]:
        """
        The routing weight associated to the connection.
        """
        return pulumi.get(self, "routing_weight")


@pulumi.output_type
class ExpressRouteGatewayPropertiesResponseAutoScaleConfiguration(dict):
    """
    Configuration for auto scaling.
    """
    def __init__(__self__, *,
                 bounds: Optional['outputs.ExpressRouteGatewayPropertiesResponseBounds'] = None):
        """
        Configuration for auto scaling.
        :param 'ExpressRouteGatewayPropertiesResponseBounds' bounds: Minimum and maximum number of scale units to deploy.
        """
        if bounds is not None:
            pulumi.set(__self__, "bounds", bounds)

    @property
    @pulumi.getter
    def bounds(self) -> Optional['outputs.ExpressRouteGatewayPropertiesResponseBounds']:
        """
        Minimum and maximum number of scale units to deploy.
        """
        return pulumi.get(self, "bounds")


@pulumi.output_type
class ExpressRouteGatewayPropertiesResponseBounds(dict):
    """
    Minimum and maximum number of scale units to deploy.
    """
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        """
        Minimum and maximum number of scale units to deploy.
        :param int max: Maximum number of scale units deployed for ExpressRoute gateway.
        :param int min: Minimum number of scale units deployed for ExpressRoute gateway.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        Maximum number of scale units deployed for ExpressRoute gateway.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        Minimum number of scale units deployed for ExpressRoute gateway.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class ExpressRouteLinkMacSecConfigResponse(dict):
    """
    ExpressRouteLink Mac Security Configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cakSecretIdentifier":
            suggest = "cak_secret_identifier"
        elif key == "cknSecretIdentifier":
            suggest = "ckn_secret_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteLinkMacSecConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteLinkMacSecConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteLinkMacSecConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cak_secret_identifier: Optional[str] = None,
                 cipher: Optional[str] = None,
                 ckn_secret_identifier: Optional[str] = None):
        """
        ExpressRouteLink Mac Security Configuration.
        :param str cak_secret_identifier: Keyvault Secret Identifier URL containing Mac security CAK key.
        :param str cipher: Mac security cipher.
        :param str ckn_secret_identifier: Keyvault Secret Identifier URL containing Mac security CKN key.
        """
        if cak_secret_identifier is not None:
            pulumi.set(__self__, "cak_secret_identifier", cak_secret_identifier)
        if cipher is not None:
            pulumi.set(__self__, "cipher", cipher)
        if ckn_secret_identifier is not None:
            pulumi.set(__self__, "ckn_secret_identifier", ckn_secret_identifier)

    @property
    @pulumi.getter(name="cakSecretIdentifier")
    def cak_secret_identifier(self) -> Optional[str]:
        """
        Keyvault Secret Identifier URL containing Mac security CAK key.
        """
        return pulumi.get(self, "cak_secret_identifier")

    @property
    @pulumi.getter
    def cipher(self) -> Optional[str]:
        """
        Mac security cipher.
        """
        return pulumi.get(self, "cipher")

    @property
    @pulumi.getter(name="cknSecretIdentifier")
    def ckn_secret_identifier(self) -> Optional[str]:
        """
        Keyvault Secret Identifier URL containing Mac security CKN key.
        """
        return pulumi.get(self, "ckn_secret_identifier")


@pulumi.output_type
class ExpressRouteLinkResponse(dict):
    """
    ExpressRouteLink child resource definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectorType":
            suggest = "connector_type"
        elif key == "interfaceName":
            suggest = "interface_name"
        elif key == "patchPanelId":
            suggest = "patch_panel_id"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "rackId":
            suggest = "rack_id"
        elif key == "routerName":
            suggest = "router_name"
        elif key == "adminState":
            suggest = "admin_state"
        elif key == "macSecConfig":
            suggest = "mac_sec_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector_type: str,
                 etag: str,
                 interface_name: str,
                 patch_panel_id: str,
                 provisioning_state: str,
                 rack_id: str,
                 router_name: str,
                 admin_state: Optional[str] = None,
                 id: Optional[str] = None,
                 mac_sec_config: Optional['outputs.ExpressRouteLinkMacSecConfigResponse'] = None,
                 name: Optional[str] = None):
        """
        ExpressRouteLink child resource definition.
        :param str connector_type: Physical fiber port type.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str interface_name: Name of Azure router interface.
        :param str patch_panel_id: Mapping between physical port to patch panel port.
        :param str provisioning_state: The provisioning state of the express route link resource.
        :param str rack_id: Mapping of physical patch panel to rack.
        :param str router_name: Name of Azure router associated with physical port.
        :param str admin_state: Administrative state of the physical port.
        :param str id: Resource ID.
        :param 'ExpressRouteLinkMacSecConfigResponse' mac_sec_config: MacSec configuration.
        :param str name: Name of child port resource that is unique among child port resources of the parent.
        """
        pulumi.set(__self__, "connector_type", connector_type)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "interface_name", interface_name)
        pulumi.set(__self__, "patch_panel_id", patch_panel_id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "rack_id", rack_id)
        pulumi.set(__self__, "router_name", router_name)
        if admin_state is not None:
            pulumi.set(__self__, "admin_state", admin_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mac_sec_config is not None:
            pulumi.set(__self__, "mac_sec_config", mac_sec_config)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> str:
        """
        Physical fiber port type.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> str:
        """
        Name of Azure router interface.
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter(name="patchPanelId")
    def patch_panel_id(self) -> str:
        """
        Mapping between physical port to patch panel port.
        """
        return pulumi.get(self, "patch_panel_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the express route link resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="rackId")
    def rack_id(self) -> str:
        """
        Mapping of physical patch panel to rack.
        """
        return pulumi.get(self, "rack_id")

    @property
    @pulumi.getter(name="routerName")
    def router_name(self) -> str:
        """
        Name of Azure router associated with physical port.
        """
        return pulumi.get(self, "router_name")

    @property
    @pulumi.getter(name="adminState")
    def admin_state(self) -> Optional[str]:
        """
        Administrative state of the physical port.
        """
        return pulumi.get(self, "admin_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="macSecConfig")
    def mac_sec_config(self) -> Optional['outputs.ExpressRouteLinkMacSecConfigResponse']:
        """
        MacSec configuration.
        """
        return pulumi.get(self, "mac_sec_config")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of child port resource that is unique among child port resources of the parent.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FirewallPolicyFilterRuleCollectionActionResponse(dict):
    """
    Properties of the FirewallPolicyFilterRuleCollectionAction.
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        Properties of the FirewallPolicyFilterRuleCollectionAction.
        :param str type: The type of action.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FirewallPolicyFilterRuleCollectionResponse(dict):
    """
    Firewall Policy Filter Rule Collection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleCollectionType":
            suggest = "rule_collection_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyFilterRuleCollectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyFilterRuleCollectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyFilterRuleCollectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_collection_type: str,
                 action: Optional['outputs.FirewallPolicyFilterRuleCollectionActionResponse'] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 rules: Optional[Sequence[Any]] = None):
        """
        Firewall Policy Filter Rule Collection.
        :param str rule_collection_type: The type of the rule collection.
               Expected value is 'FirewallPolicyFilterRuleCollection'.
        :param 'FirewallPolicyFilterRuleCollectionActionResponse' action: The action type of a Filter rule collection.
        :param str name: The name of the rule collection.
        :param int priority: Priority of the Firewall Policy Rule Collection resource.
        :param Sequence[Union['ApplicationRuleResponse', 'NatRuleResponse', 'NetworkRuleResponse']] rules: List of rules included in a rule collection.
        """
        pulumi.set(__self__, "rule_collection_type", 'FirewallPolicyFilterRuleCollection')
        if action is not None:
            pulumi.set(__self__, "action", action)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleCollectionType")
    def rule_collection_type(self) -> str:
        """
        The type of the rule collection.
        Expected value is 'FirewallPolicyFilterRuleCollection'.
        """
        return pulumi.get(self, "rule_collection_type")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.FirewallPolicyFilterRuleCollectionActionResponse']:
        """
        The action type of a Filter rule collection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the rule collection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of the Firewall Policy Rule Collection resource.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence[Any]]:
        """
        List of rules included in a rule collection.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class FirewallPolicyNatRuleCollectionActionResponse(dict):
    """
    Properties of the FirewallPolicyNatRuleCollectionAction.
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        Properties of the FirewallPolicyNatRuleCollectionAction.
        :param str type: The type of action.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FirewallPolicyNatRuleCollectionResponse(dict):
    """
    Firewall Policy NAT Rule Collection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleCollectionType":
            suggest = "rule_collection_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyNatRuleCollectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyNatRuleCollectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyNatRuleCollectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_collection_type: str,
                 action: Optional['outputs.FirewallPolicyNatRuleCollectionActionResponse'] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 rules: Optional[Sequence[Any]] = None):
        """
        Firewall Policy NAT Rule Collection.
        :param str rule_collection_type: The type of the rule collection.
               Expected value is 'FirewallPolicyNatRuleCollection'.
        :param 'FirewallPolicyNatRuleCollectionActionResponse' action: The action type of a Nat rule collection.
        :param str name: The name of the rule collection.
        :param int priority: Priority of the Firewall Policy Rule Collection resource.
        :param Sequence[Union['ApplicationRuleResponse', 'NatRuleResponse', 'NetworkRuleResponse']] rules: List of rules included in a rule collection.
        """
        pulumi.set(__self__, "rule_collection_type", 'FirewallPolicyNatRuleCollection')
        if action is not None:
            pulumi.set(__self__, "action", action)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleCollectionType")
    def rule_collection_type(self) -> str:
        """
        The type of the rule collection.
        Expected value is 'FirewallPolicyNatRuleCollection'.
        """
        return pulumi.get(self, "rule_collection_type")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.FirewallPolicyNatRuleCollectionActionResponse']:
        """
        The action type of a Nat rule collection.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the rule collection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of the Firewall Policy Rule Collection resource.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence[Any]]:
        """
        List of rules included in a rule collection.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class FirewallPolicyRuleApplicationProtocolResponse(dict):
    """
    Properties of the application rule protocol.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolType":
            suggest = "protocol_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyRuleApplicationProtocolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyRuleApplicationProtocolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyRuleApplicationProtocolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: Optional[int] = None,
                 protocol_type: Optional[str] = None):
        """
        Properties of the application rule protocol.
        :param int port: Port number for the protocol, cannot be greater than 64000.
        :param str protocol_type: Protocol type.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number for the protocol, cannot be greater than 64000.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[str]:
        """
        Protocol type.
        """
        return pulumi.get(self, "protocol_type")


@pulumi.output_type
class FirewallPolicyThreatIntelWhitelistResponse(dict):
    """
    ThreatIntel Whitelist for Firewall Policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPolicyThreatIntelWhitelistResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPolicyThreatIntelWhitelistResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPolicyThreatIntelWhitelistResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdns: Optional[Sequence[str]] = None,
                 ip_addresses: Optional[Sequence[str]] = None):
        """
        ThreatIntel Whitelist for Firewall Policy.
        :param Sequence[str] fqdns: List of FQDNs for the ThreatIntel Whitelist.
        :param Sequence[str] ip_addresses: List of IP addresses for the ThreatIntel Whitelist.
        """
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter
    def fqdns(self) -> Optional[Sequence[str]]:
        """
        List of FQDNs for the ThreatIntel Whitelist.
        """
        return pulumi.get(self, "fqdns")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        List of IP addresses for the ThreatIntel Whitelist.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class FlowLogFormatParametersResponse(dict):
    """
    Parameters that define the flow log format.
    """
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 version: Optional[int] = None):
        """
        Parameters that define the flow log format.
        :param str type: The file type of flow log.
        :param int version: The version (revision) of the flow log.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is None:
            version = 0
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The file type of flow log.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> Optional[int]:
        """
        The version (revision) of the flow log.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class FlowLogResponse(dict):
    """
    A flow log resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "storageId":
            suggest = "storage_id"
        elif key == "targetResourceGuid":
            suggest = "target_resource_guid"
        elif key == "targetResourceId":
            suggest = "target_resource_id"
        elif key == "flowAnalyticsConfiguration":
            suggest = "flow_analytics_configuration"
        elif key == "retentionPolicy":
            suggest = "retention_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlowLogResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlowLogResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlowLogResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 name: str,
                 provisioning_state: str,
                 storage_id: str,
                 target_resource_guid: str,
                 target_resource_id: str,
                 type: str,
                 enabled: Optional[bool] = None,
                 flow_analytics_configuration: Optional['outputs.TrafficAnalyticsPropertiesResponse'] = None,
                 format: Optional['outputs.FlowLogFormatParametersResponse'] = None,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 retention_policy: Optional['outputs.RetentionPolicyParametersResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        A flow log resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the flow log.
        :param str storage_id: ID of the storage account which is used to store the flow log.
        :param str target_resource_guid: Guid of network security group to which flow log will be applied.
        :param str target_resource_id: ID of network security group to which flow log will be applied.
        :param str type: Resource type.
        :param bool enabled: Flag to enable/disable flow logging.
        :param 'TrafficAnalyticsPropertiesResponse' flow_analytics_configuration: Parameters that define the configuration of traffic analytics.
        :param 'FlowLogFormatParametersResponse' format: Parameters that define the flow log format.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param 'RetentionPolicyParametersResponse' retention_policy: Parameters that define the retention policy for flow log.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "storage_id", storage_id)
        pulumi.set(__self__, "target_resource_guid", target_resource_guid)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        pulumi.set(__self__, "type", type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if flow_analytics_configuration is not None:
            pulumi.set(__self__, "flow_analytics_configuration", flow_analytics_configuration)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the flow log.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="storageId")
    def storage_id(self) -> str:
        """
        ID of the storage account which is used to store the flow log.
        """
        return pulumi.get(self, "storage_id")

    @property
    @pulumi.getter(name="targetResourceGuid")
    def target_resource_guid(self) -> str:
        """
        Guid of network security group to which flow log will be applied.
        """
        return pulumi.get(self, "target_resource_guid")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> str:
        """
        ID of network security group to which flow log will be applied.
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Flag to enable/disable flow logging.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="flowAnalyticsConfiguration")
    def flow_analytics_configuration(self) -> Optional['outputs.TrafficAnalyticsPropertiesResponse']:
        """
        Parameters that define the configuration of traffic analytics.
        """
        return pulumi.get(self, "flow_analytics_configuration")

    @property
    @pulumi.getter
    def format(self) -> Optional['outputs.FlowLogFormatParametersResponse']:
        """
        Parameters that define the flow log format.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional['outputs.RetentionPolicyParametersResponse']:
        """
        Parameters that define the retention policy for flow log.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ForwardingConfigurationResponse(dict):
    """
    Describes Forwarding Route.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "backendPool":
            suggest = "backend_pool"
        elif key == "cacheConfiguration":
            suggest = "cache_configuration"
        elif key == "customForwardingPath":
            suggest = "custom_forwarding_path"
        elif key == "forwardingProtocol":
            suggest = "forwarding_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ForwardingConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ForwardingConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ForwardingConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 backend_pool: Optional['outputs.SubResourceResponse'] = None,
                 cache_configuration: Optional['outputs.CacheConfigurationResponse'] = None,
                 custom_forwarding_path: Optional[str] = None,
                 forwarding_protocol: Optional[str] = None):
        """
        Describes Forwarding Route.
        :param str odata_type: 
               Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
        :param 'SubResourceResponse' backend_pool: A reference to the BackendPool which this rule routes to.
        :param 'CacheConfigurationResponse' cache_configuration: The caching configuration associated with this rule.
        :param str custom_forwarding_path: A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
        :param str forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration')
        if backend_pool is not None:
            pulumi.set(__self__, "backend_pool", backend_pool)
        if cache_configuration is not None:
            pulumi.set(__self__, "cache_configuration", cache_configuration)
        if custom_forwarding_path is not None:
            pulumi.set(__self__, "custom_forwarding_path", custom_forwarding_path)
        if forwarding_protocol is not None:
            pulumi.set(__self__, "forwarding_protocol", forwarding_protocol)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """

        Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="backendPool")
    def backend_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to the BackendPool which this rule routes to.
        """
        return pulumi.get(self, "backend_pool")

    @property
    @pulumi.getter(name="cacheConfiguration")
    def cache_configuration(self) -> Optional['outputs.CacheConfigurationResponse']:
        """
        The caching configuration associated with this rule.
        """
        return pulumi.get(self, "cache_configuration")

    @property
    @pulumi.getter(name="customForwardingPath")
    def custom_forwarding_path(self) -> Optional[str]:
        """
        A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
        """
        return pulumi.get(self, "custom_forwarding_path")

    @property
    @pulumi.getter(name="forwardingProtocol")
    def forwarding_protocol(self) -> Optional[str]:
        """
        Protocol this rule will use when forwarding traffic to backends.
        """
        return pulumi.get(self, "forwarding_protocol")


@pulumi.output_type
class FrontendEndpointResponse(dict):
    """
    A frontend endpoint used for routing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customHttpsConfiguration":
            suggest = "custom_https_configuration"
        elif key == "customHttpsProvisioningState":
            suggest = "custom_https_provisioning_state"
        elif key == "customHttpsProvisioningSubstate":
            suggest = "custom_https_provisioning_substate"
        elif key == "resourceState":
            suggest = "resource_state"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "sessionAffinityEnabledState":
            suggest = "session_affinity_enabled_state"
        elif key == "sessionAffinityTtlSeconds":
            suggest = "session_affinity_ttl_seconds"
        elif key == "webApplicationFirewallPolicyLink":
            suggest = "web_application_firewall_policy_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontendEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontendEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontendEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_https_configuration: 'outputs.CustomHttpsConfigurationResponse',
                 custom_https_provisioning_state: str,
                 custom_https_provisioning_substate: str,
                 resource_state: str,
                 type: str,
                 host_name: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 session_affinity_enabled_state: Optional[str] = None,
                 session_affinity_ttl_seconds: Optional[int] = None,
                 web_application_firewall_policy_link: Optional['outputs.FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink'] = None):
        """
        A frontend endpoint used for routing.
        :param 'CustomHttpsConfigurationResponse' custom_https_configuration: The configuration specifying how to enable HTTPS
        :param str custom_https_provisioning_state: Provisioning status of Custom Https of the frontendEndpoint.
        :param str custom_https_provisioning_substate: Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
        :param str resource_state: Resource status.
        :param str type: Resource type.
        :param str host_name: The host name of the frontendEndpoint. Must be a domain name.
        :param str id: Resource ID.
        :param str name: Resource name.
        :param str session_affinity_enabled_state: Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
        :param int session_affinity_ttl_seconds: UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
        :param 'FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink' web_application_firewall_policy_link: Defines the Web Application Firewall policy for each host (if applicable)
        """
        pulumi.set(__self__, "custom_https_configuration", custom_https_configuration)
        pulumi.set(__self__, "custom_https_provisioning_state", custom_https_provisioning_state)
        pulumi.set(__self__, "custom_https_provisioning_substate", custom_https_provisioning_substate)
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "type", type)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if session_affinity_enabled_state is not None:
            pulumi.set(__self__, "session_affinity_enabled_state", session_affinity_enabled_state)
        if session_affinity_ttl_seconds is not None:
            pulumi.set(__self__, "session_affinity_ttl_seconds", session_affinity_ttl_seconds)
        if web_application_firewall_policy_link is not None:
            pulumi.set(__self__, "web_application_firewall_policy_link", web_application_firewall_policy_link)

    @property
    @pulumi.getter(name="customHttpsConfiguration")
    def custom_https_configuration(self) -> 'outputs.CustomHttpsConfigurationResponse':
        """
        The configuration specifying how to enable HTTPS
        """
        return pulumi.get(self, "custom_https_configuration")

    @property
    @pulumi.getter(name="customHttpsProvisioningState")
    def custom_https_provisioning_state(self) -> str:
        """
        Provisioning status of Custom Https of the frontendEndpoint.
        """
        return pulumi.get(self, "custom_https_provisioning_state")

    @property
    @pulumi.getter(name="customHttpsProvisioningSubstate")
    def custom_https_provisioning_substate(self) -> str:
        """
        Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
        """
        return pulumi.get(self, "custom_https_provisioning_substate")

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Resource status.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        The host name of the frontendEndpoint. Must be a domain name.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sessionAffinityEnabledState")
    def session_affinity_enabled_state(self) -> Optional[str]:
        """
        Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "session_affinity_enabled_state")

    @property
    @pulumi.getter(name="sessionAffinityTtlSeconds")
    def session_affinity_ttl_seconds(self) -> Optional[int]:
        """
        UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
        """
        return pulumi.get(self, "session_affinity_ttl_seconds")

    @property
    @pulumi.getter(name="webApplicationFirewallPolicyLink")
    def web_application_firewall_policy_link(self) -> Optional['outputs.FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink']:
        """
        Defines the Web Application Firewall policy for each host (if applicable)
        """
        return pulumi.get(self, "web_application_firewall_policy_link")


@pulumi.output_type
class FrontendEndpointUpdateParametersResponseWebApplicationFirewallPolicyLink(dict):
    """
    Defines the Web Application Firewall policy for each host (if applicable)
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Defines the Web Application Firewall policy for each host (if applicable)
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class FrontendIPConfigurationResponse(dict):
    """
    Frontend IP address of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundNatPools":
            suggest = "inbound_nat_pools"
        elif key == "inboundNatRules":
            suggest = "inbound_nat_rules"
        elif key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "outboundRules":
            suggest = "outbound_rules"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAddressVersion":
            suggest = "private_ip_address_version"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"
        elif key == "publicIPPrefix":
            suggest = "public_ip_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontendIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontendIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontendIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 inbound_nat_pools: Sequence['outputs.SubResourceResponse'],
                 inbound_nat_rules: Sequence['outputs.SubResourceResponse'],
                 load_balancing_rules: Sequence['outputs.SubResourceResponse'],
                 outbound_rules: Sequence['outputs.SubResourceResponse'],
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_address_version: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 public_ip_address: Optional['outputs.PublicIPAddressResponse'] = None,
                 public_ip_prefix: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        Frontend IP address of the load balancer.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param Sequence['SubResourceResponse'] inbound_nat_pools: An array of references to inbound pools that use this frontend IP.
        :param Sequence['SubResourceResponse'] inbound_nat_rules: An array of references to inbound rules that use this frontend IP.
        :param Sequence['SubResourceResponse'] load_balancing_rules: An array of references to load balancing rules that use this frontend IP.
        :param Sequence['SubResourceResponse'] outbound_rules: An array of references to outbound rules that use this frontend IP.
        :param str provisioning_state: The provisioning state of the frontend IP configuration resource.
        :param str type: Type of the resource.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
        :param str private_ip_address: The private IP address of the IP configuration.
        :param str private_ip_address_version: Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
        :param str private_ip_allocation_method: The Private IP allocation method.
        :param 'PublicIPAddressResponse' public_ip_address: The reference to the Public IP resource.
        :param 'SubResourceResponse' public_ip_prefix: The reference to the Public IP Prefix resource.
        :param 'SubnetResponse' subnet: The reference to the subnet resource.
        :param Sequence[str] zones: A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "inbound_nat_pools", inbound_nat_pools)
        pulumi.set(__self__, "inbound_nat_rules", inbound_nat_rules)
        pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        pulumi.set(__self__, "outbound_rules", outbound_rules)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if public_ip_prefix is not None:
            pulumi.set(__self__, "public_ip_prefix", public_ip_prefix)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="inboundNatPools")
    def inbound_nat_pools(self) -> Sequence['outputs.SubResourceResponse']:
        """
        An array of references to inbound pools that use this frontend IP.
        """
        return pulumi.get(self, "inbound_nat_pools")

    @property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        An array of references to inbound rules that use this frontend IP.
        """
        return pulumi.get(self, "inbound_nat_rules")

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        An array of references to load balancing rules that use this frontend IP.
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        An array of references to outbound rules that use this frontend IP.
        """
        return pulumi.get(self, "outbound_rules")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the frontend IP configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[str]:
        """
        Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
        """
        return pulumi.get(self, "private_ip_address_version")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The Private IP allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.PublicIPAddressResponse']:
        """
        The reference to the Public IP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="publicIPPrefix")
    def public_ip_prefix(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference to the Public IP Prefix resource.
        """
        return pulumi.get(self, "public_ip_prefix")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        The reference to the subnet resource.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class GatewayRouteResponse(dict):
    """
    Gateway routing details.
    """
    def __init__(__self__, *,
                 as_path: str,
                 local_address: str,
                 network: str,
                 next_hop: str,
                 origin: str,
                 source_peer: str,
                 weight: int):
        """
        Gateway routing details.
        :param str as_path: The route's AS path sequence.
        :param str local_address: The gateway's local address.
        :param str network: The route's network prefix.
        :param str next_hop: The route's next hop.
        :param str origin: The source this route was learned from.
        :param str source_peer: The peer this route was learned from.
        :param int weight: The route's weight.
        """
        pulumi.set(__self__, "as_path", as_path)
        pulumi.set(__self__, "local_address", local_address)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "source_peer", source_peer)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="asPath")
    def as_path(self) -> str:
        """
        The route's AS path sequence.
        """
        return pulumi.get(self, "as_path")

    @property
    @pulumi.getter(name="localAddress")
    def local_address(self) -> str:
        """
        The gateway's local address.
        """
        return pulumi.get(self, "local_address")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The route's network prefix.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The route's next hop.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter
    def origin(self) -> str:
        """
        The source this route was learned from.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="sourcePeer")
    def source_peer(self) -> str:
        """
        The peer this route was learned from.
        """
        return pulumi.get(self, "source_peer")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The route's weight.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class HTTPHeaderResponse(dict):
    """
    The HTTP header.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        The HTTP header.
        :param str name: The name in HTTP header.
        :param str value: The value in HTTP header.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name in HTTP header.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value in HTTP header.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HeaderActionResponse(dict):
    """
    An action that can manipulate an http header.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerActionType":
            suggest = "header_action_type"
        elif key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeaderActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeaderActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeaderActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_action_type: str,
                 header_name: str,
                 value: Optional[str] = None):
        """
        An action that can manipulate an http header.
        :param str header_action_type: Which type of manipulation to apply to the header.
        :param str header_name: The name of the header this action will apply to.
        :param str value: The value to update the given header name with. This value is not used if the actionType is Delete.
        """
        pulumi.set(__self__, "header_action_type", header_action_type)
        pulumi.set(__self__, "header_name", header_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="headerActionType")
    def header_action_type(self) -> str:
        """
        Which type of manipulation to apply to the header.
        """
        return pulumi.get(self, "header_action_type")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        The name of the header this action will apply to.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value to update the given header name with. This value is not used if the actionType is Delete.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HealthProbeSettingsModelResponse(dict):
    """
    Load balancing settings for a backend pool
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceState":
            suggest = "resource_state"
        elif key == "enabledState":
            suggest = "enabled_state"
        elif key == "healthProbeMethod":
            suggest = "health_probe_method"
        elif key == "intervalInSeconds":
            suggest = "interval_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthProbeSettingsModelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthProbeSettingsModelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthProbeSettingsModelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_state: str,
                 type: str,
                 enabled_state: Optional[str] = None,
                 health_probe_method: Optional[str] = None,
                 id: Optional[str] = None,
                 interval_in_seconds: Optional[int] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        Load balancing settings for a backend pool
        :param str resource_state: Resource status.
        :param str type: Resource type.
        :param str enabled_state: Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
        :param str health_probe_method: Configures which HTTP method to use to probe the backends defined under backendPools.
        :param str id: Resource ID.
        :param int interval_in_seconds: The number of seconds between health probes.
        :param str name: Resource name.
        :param str path: The path to use for the health probe. Default is /
        :param str protocol: Protocol scheme to use for this probe
        """
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "type", type)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if health_probe_method is None:
            health_probe_method = 'HEAD'
        if health_probe_method is not None:
            pulumi.set(__self__, "health_probe_method", health_probe_method)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Resource status.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[str]:
        """
        Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
        """
        return pulumi.get(self, "enabled_state")

    @property
    @pulumi.getter(name="healthProbeMethod")
    def health_probe_method(self) -> Optional[str]:
        """
        Configures which HTTP method to use to probe the backends defined under backendPools.
        """
        return pulumi.get(self, "health_probe_method")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[int]:
        """
        The number of seconds between health probes.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to use for the health probe. Default is /
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol scheme to use for this probe
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class HubIPAddressesResponse(dict):
    """
    IP addresses associated with azure firewall.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "publicIPs":
            suggest = "public_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HubIPAddressesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HubIPAddressesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HubIPAddressesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_ip_address: Optional[str] = None,
                 public_ips: Optional['outputs.HubPublicIPAddressesResponse'] = None):
        """
        IP addresses associated with azure firewall.
        :param str private_ip_address: Private IP Address associated with azure firewall.
        :param 'HubPublicIPAddressesResponse' public_ips: Public IP addresses associated with azure firewall.
        """
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        Private IP Address associated with azure firewall.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIPs")
    def public_ips(self) -> Optional['outputs.HubPublicIPAddressesResponse']:
        """
        Public IP addresses associated with azure firewall.
        """
        return pulumi.get(self, "public_ips")


@pulumi.output_type
class HubPublicIPAddressesResponse(dict):
    """
    Public IP addresses associated with azure firewall.
    """
    def __init__(__self__, *,
                 addresses: Optional[Sequence['outputs.AzureFirewallPublicIPAddressResponse']] = None,
                 count: Optional[int] = None):
        """
        Public IP addresses associated with azure firewall.
        :param Sequence['AzureFirewallPublicIPAddressResponse'] addresses: The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
        :param int count: The number of Public IP addresses associated with azure firewall.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence['outputs.AzureFirewallPublicIPAddressResponse']]:
        """
        The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The number of Public IP addresses associated with azure firewall.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class HubRouteResponse(dict):
    """
    RouteTable route.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationType":
            suggest = "destination_type"
        elif key == "nextHop":
            suggest = "next_hop"
        elif key == "nextHopType":
            suggest = "next_hop_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HubRouteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HubRouteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HubRouteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_type: str,
                 destinations: Sequence[str],
                 name: str,
                 next_hop: str,
                 next_hop_type: str):
        """
        RouteTable route.
        :param str destination_type: The type of destinations (eg: CIDR, ResourceId, Service).
        :param Sequence[str] destinations: List of all destinations.
        :param str name: The name of the Route that is unique within a RouteTable. This name can be used to access this route.
        :param str next_hop: NextHop resource ID.
        :param str next_hop_type: The type of next hop (eg: ResourceId).
        """
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "next_hop_type", next_hop_type)

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> str:
        """
        The type of destinations (eg: CIDR, ResourceId, Service).
        """
        return pulumi.get(self, "destination_type")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence[str]:
        """
        List of all destinations.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Route that is unique within a RouteTable. This name can be used to access this route.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        NextHop resource ID.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> str:
        """
        The type of next hop (eg: ResourceId).
        """
        return pulumi.get(self, "next_hop_type")


@pulumi.output_type
class IPConfigurationBgpPeeringAddressResponse(dict):
    """
    Properties of IPConfigurationBgpPeeringAddress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultBgpIpAddresses":
            suggest = "default_bgp_ip_addresses"
        elif key == "tunnelIpAddresses":
            suggest = "tunnel_ip_addresses"
        elif key == "customBgpIpAddresses":
            suggest = "custom_bgp_ip_addresses"
        elif key == "ipconfigurationId":
            suggest = "ipconfiguration_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPConfigurationBgpPeeringAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPConfigurationBgpPeeringAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPConfigurationBgpPeeringAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_bgp_ip_addresses: Sequence[str],
                 tunnel_ip_addresses: Sequence[str],
                 custom_bgp_ip_addresses: Optional[Sequence[str]] = None,
                 ipconfiguration_id: Optional[str] = None):
        """
        Properties of IPConfigurationBgpPeeringAddress.
        :param Sequence[str] default_bgp_ip_addresses: The list of default BGP peering addresses which belong to IP configuration.
        :param Sequence[str] tunnel_ip_addresses: The list of tunnel public IP addresses which belong to IP configuration.
        :param Sequence[str] custom_bgp_ip_addresses: The list of custom BGP peering addresses which belong to IP configuration.
        :param str ipconfiguration_id: The ID of IP configuration which belongs to gateway.
        """
        pulumi.set(__self__, "default_bgp_ip_addresses", default_bgp_ip_addresses)
        pulumi.set(__self__, "tunnel_ip_addresses", tunnel_ip_addresses)
        if custom_bgp_ip_addresses is not None:
            pulumi.set(__self__, "custom_bgp_ip_addresses", custom_bgp_ip_addresses)
        if ipconfiguration_id is not None:
            pulumi.set(__self__, "ipconfiguration_id", ipconfiguration_id)

    @property
    @pulumi.getter(name="defaultBgpIpAddresses")
    def default_bgp_ip_addresses(self) -> Sequence[str]:
        """
        The list of default BGP peering addresses which belong to IP configuration.
        """
        return pulumi.get(self, "default_bgp_ip_addresses")

    @property
    @pulumi.getter(name="tunnelIpAddresses")
    def tunnel_ip_addresses(self) -> Sequence[str]:
        """
        The list of tunnel public IP addresses which belong to IP configuration.
        """
        return pulumi.get(self, "tunnel_ip_addresses")

    @property
    @pulumi.getter(name="customBgpIpAddresses")
    def custom_bgp_ip_addresses(self) -> Optional[Sequence[str]]:
        """
        The list of custom BGP peering addresses which belong to IP configuration.
        """
        return pulumi.get(self, "custom_bgp_ip_addresses")

    @property
    @pulumi.getter(name="ipconfigurationId")
    def ipconfiguration_id(self) -> Optional[str]:
        """
        The ID of IP configuration which belongs to gateway.
        """
        return pulumi.get(self, "ipconfiguration_id")


@pulumi.output_type
class IPConfigurationProfileResponse(dict):
    """
    IP configuration profile child resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPConfigurationProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPConfigurationProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPConfigurationProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None):
        """
        IP configuration profile child resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the IP configuration profile resource.
        :param str type: Sub Resource type.
        :param str id: Resource ID.
        :param str name: The name of the resource. This name can be used to access the resource.
        :param 'SubnetResponse' subnet: The reference to the subnet resource to create a container network interface ip configuration.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the IP configuration profile resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Sub Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        The reference to the subnet resource to create a container network interface ip configuration.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class IPConfigurationResponse(dict):
    """
    IP configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 public_ip_address: Optional['outputs.PublicIPAddressResponse'] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None):
        """
        IP configuration.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the IP configuration resource.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_ip_address: The private IP address of the IP configuration.
        :param str private_ip_allocation_method: The private IP address allocation method.
        :param 'PublicIPAddressResponse' public_ip_address: The reference to the public IP resource.
        :param 'SubnetResponse' subnet: The reference to the subnet resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the IP configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.PublicIPAddressResponse']:
        """
        The reference to the public IP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        The reference to the subnet resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class InboundNatPoolResponse(dict):
    """
    Inbound NAT pool of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendPortRangeEnd":
            suggest = "frontend_port_range_end"
        elif key == "frontendPortRangeStart":
            suggest = "frontend_port_range_start"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "enableFloatingIP":
            suggest = "enable_floating_ip"
        elif key == "enableTcpReset":
            suggest = "enable_tcp_reset"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundNatPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: int,
                 etag: str,
                 frontend_port_range_end: int,
                 frontend_port_range_start: int,
                 protocol: str,
                 provisioning_state: str,
                 type: str,
                 enable_floating_ip: Optional[bool] = None,
                 enable_tcp_reset: Optional[bool] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 name: Optional[str] = None):
        """
        Inbound NAT pool of the load balancer.
        :param int backend_port: The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param int frontend_port_range_end: The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
        :param int frontend_port_range_start: The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
        :param str protocol: The reference to the transport protocol used by the inbound NAT pool.
        :param str provisioning_state: The provisioning state of the inbound NAT pool resource.
        :param str type: Type of the resource.
        :param bool enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        :param bool enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param 'SubResourceResponse' frontend_ip_configuration: A reference to frontend IP addresses.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        :param str name: The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "frontend_port_range_end", frontend_port_range_end)
        pulumi.set(__self__, "frontend_port_range_start", frontend_port_range_start)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> int:
        """
        The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendPortRangeEnd")
    def frontend_port_range_end(self) -> int:
        """
        The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
        """
        return pulumi.get(self, "frontend_port_range_end")

    @property
    @pulumi.getter(name="frontendPortRangeStart")
    def frontend_port_range_start(self) -> int:
        """
        The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
        """
        return pulumi.get(self, "frontend_port_range_start")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The reference to the transport protocol used by the inbound NAT pool.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the inbound NAT pool resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> Optional[bool]:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[bool]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InboundNatRuleResponse(dict):
    """
    Inbound NAT rule of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendIPConfiguration":
            suggest = "backend_ip_configuration"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "backendPort":
            suggest = "backend_port"
        elif key == "enableFloatingIP":
            suggest = "enable_floating_ip"
        elif key == "enableTcpReset":
            suggest = "enable_tcp_reset"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundNatRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundNatRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundNatRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_ip_configuration: 'outputs.NetworkInterfaceIPConfigurationResponse',
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 backend_port: Optional[int] = None,
                 enable_floating_ip: Optional[bool] = None,
                 enable_tcp_reset: Optional[bool] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 frontend_port: Optional[int] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 name: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        Inbound NAT rule of the load balancer.
        :param 'NetworkInterfaceIPConfigurationResponse' backend_ip_configuration: A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backend IP.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the inbound NAT rule resource.
        :param str type: Type of the resource.
        :param int backend_port: The port used for the internal endpoint. Acceptable values range from 1 to 65535.
        :param bool enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        :param bool enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param 'SubResourceResponse' frontend_ip_configuration: A reference to frontend IP addresses.
        :param int frontend_port: The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        :param str name: The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
        :param str protocol: The reference to the transport protocol used by the load balancing rule.
        """
        pulumi.set(__self__, "backend_ip_configuration", backend_ip_configuration)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="backendIPConfiguration")
    def backend_ip_configuration(self) -> 'outputs.NetworkInterfaceIPConfigurationResponse':
        """
        A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backend IP.
        """
        return pulumi.get(self, "backend_ip_configuration")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the inbound NAT rule resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[int]:
        """
        The port used for the internal endpoint. Acceptable values range from 1 to 65535.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> Optional[bool]:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[bool]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[int]:
        """
        The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The reference to the transport protocol used by the load balancing rule.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class IpTagResponse(dict):
    """
    Contains the IpTag associated with the object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipTagType":
            suggest = "ip_tag_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpTagResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpTagResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpTagResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_tag_type: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        Contains the IpTag associated with the object.
        :param str ip_tag_type: The IP tag type. Example: FirstPartyUsage.
        :param str tag: The value of the IP tag associated with the public IP. Example: SQL.
        """
        if ip_tag_type is not None:
            pulumi.set(__self__, "ip_tag_type", ip_tag_type)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="ipTagType")
    def ip_tag_type(self) -> Optional[str]:
        """
        The IP tag type. Example: FirstPartyUsage.
        """
        return pulumi.get(self, "ip_tag_type")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The value of the IP tag associated with the public IP. Example: SQL.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class IpsecPolicyResponse(dict):
    """
    An IPSec Policy configuration for a virtual network gateway connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dhGroup":
            suggest = "dh_group"
        elif key == "ikeEncryption":
            suggest = "ike_encryption"
        elif key == "ikeIntegrity":
            suggest = "ike_integrity"
        elif key == "ipsecEncryption":
            suggest = "ipsec_encryption"
        elif key == "ipsecIntegrity":
            suggest = "ipsec_integrity"
        elif key == "pfsGroup":
            suggest = "pfs_group"
        elif key == "saDataSizeKilobytes":
            suggest = "sa_data_size_kilobytes"
        elif key == "saLifeTimeSeconds":
            suggest = "sa_life_time_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpsecPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpsecPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpsecPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dh_group: str,
                 ike_encryption: str,
                 ike_integrity: str,
                 ipsec_encryption: str,
                 ipsec_integrity: str,
                 pfs_group: str,
                 sa_data_size_kilobytes: int,
                 sa_life_time_seconds: int):
        """
        An IPSec Policy configuration for a virtual network gateway connection.
        :param str dh_group: The DH Group used in IKE Phase 1 for initial SA.
        :param str ike_encryption: The IKE encryption algorithm (IKE phase 2).
        :param str ike_integrity: The IKE integrity algorithm (IKE phase 2).
        :param str ipsec_encryption: The IPSec encryption algorithm (IKE phase 1).
        :param str ipsec_integrity: The IPSec integrity algorithm (IKE phase 1).
        :param str pfs_group: The Pfs Group used in IKE Phase 2 for new child SA.
        :param int sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
        :param int sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
        """
        pulumi.set(__self__, "dh_group", dh_group)
        pulumi.set(__self__, "ike_encryption", ike_encryption)
        pulumi.set(__self__, "ike_integrity", ike_integrity)
        pulumi.set(__self__, "ipsec_encryption", ipsec_encryption)
        pulumi.set(__self__, "ipsec_integrity", ipsec_integrity)
        pulumi.set(__self__, "pfs_group", pfs_group)
        pulumi.set(__self__, "sa_data_size_kilobytes", sa_data_size_kilobytes)
        pulumi.set(__self__, "sa_life_time_seconds", sa_life_time_seconds)

    @property
    @pulumi.getter(name="dhGroup")
    def dh_group(self) -> str:
        """
        The DH Group used in IKE Phase 1 for initial SA.
        """
        return pulumi.get(self, "dh_group")

    @property
    @pulumi.getter(name="ikeEncryption")
    def ike_encryption(self) -> str:
        """
        The IKE encryption algorithm (IKE phase 2).
        """
        return pulumi.get(self, "ike_encryption")

    @property
    @pulumi.getter(name="ikeIntegrity")
    def ike_integrity(self) -> str:
        """
        The IKE integrity algorithm (IKE phase 2).
        """
        return pulumi.get(self, "ike_integrity")

    @property
    @pulumi.getter(name="ipsecEncryption")
    def ipsec_encryption(self) -> str:
        """
        The IPSec encryption algorithm (IKE phase 1).
        """
        return pulumi.get(self, "ipsec_encryption")

    @property
    @pulumi.getter(name="ipsecIntegrity")
    def ipsec_integrity(self) -> str:
        """
        The IPSec integrity algorithm (IKE phase 1).
        """
        return pulumi.get(self, "ipsec_integrity")

    @property
    @pulumi.getter(name="pfsGroup")
    def pfs_group(self) -> str:
        """
        The Pfs Group used in IKE Phase 2 for new child SA.
        """
        return pulumi.get(self, "pfs_group")

    @property
    @pulumi.getter(name="saDataSizeKilobytes")
    def sa_data_size_kilobytes(self) -> int:
        """
        The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
        """
        return pulumi.get(self, "sa_data_size_kilobytes")

    @property
    @pulumi.getter(name="saLifeTimeSeconds")
    def sa_life_time_seconds(self) -> int:
        """
        The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
        """
        return pulumi.get(self, "sa_life_time_seconds")


@pulumi.output_type
class Ipv6CircuitConnectionConfigResponse(dict):
    """
    IPv6 Circuit Connection properties for global reach.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "circuitConnectionStatus":
            suggest = "circuit_connection_status"
        elif key == "addressPrefix":
            suggest = "address_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Ipv6CircuitConnectionConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Ipv6CircuitConnectionConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Ipv6CircuitConnectionConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 circuit_connection_status: str,
                 address_prefix: Optional[str] = None):
        """
        IPv6 Circuit Connection properties for global reach.
        :param str circuit_connection_status: Express Route Circuit connection state.
        :param str address_prefix: /125 IP address space to carve out customer addresses for global reach.
        """
        pulumi.set(__self__, "circuit_connection_status", circuit_connection_status)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)

    @property
    @pulumi.getter(name="circuitConnectionStatus")
    def circuit_connection_status(self) -> str:
        """
        Express Route Circuit connection state.
        """
        return pulumi.get(self, "circuit_connection_status")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        /125 IP address space to carve out customer addresses for global reach.
        """
        return pulumi.get(self, "address_prefix")


@pulumi.output_type
class Ipv6ExpressRouteCircuitPeeringConfigResponse(dict):
    """
    Contains IPv6 peering config.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "microsoftPeeringConfig":
            suggest = "microsoft_peering_config"
        elif key == "primaryPeerAddressPrefix":
            suggest = "primary_peer_address_prefix"
        elif key == "routeFilter":
            suggest = "route_filter"
        elif key == "secondaryPeerAddressPrefix":
            suggest = "secondary_peer_address_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Ipv6ExpressRouteCircuitPeeringConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Ipv6ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Ipv6ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 microsoft_peering_config: Optional['outputs.ExpressRouteCircuitPeeringConfigResponse'] = None,
                 primary_peer_address_prefix: Optional[str] = None,
                 route_filter: Optional['outputs.SubResourceResponse'] = None,
                 secondary_peer_address_prefix: Optional[str] = None,
                 state: Optional[str] = None):
        """
        Contains IPv6 peering config.
        :param 'ExpressRouteCircuitPeeringConfigResponse' microsoft_peering_config: The Microsoft peering configuration.
        :param str primary_peer_address_prefix: The primary address prefix.
        :param 'SubResourceResponse' route_filter: The reference to the RouteFilter resource.
        :param str secondary_peer_address_prefix: The secondary address prefix.
        :param str state: The state of peering.
        """
        if microsoft_peering_config is not None:
            pulumi.set(__self__, "microsoft_peering_config", microsoft_peering_config)
        if primary_peer_address_prefix is not None:
            pulumi.set(__self__, "primary_peer_address_prefix", primary_peer_address_prefix)
        if route_filter is not None:
            pulumi.set(__self__, "route_filter", route_filter)
        if secondary_peer_address_prefix is not None:
            pulumi.set(__self__, "secondary_peer_address_prefix", secondary_peer_address_prefix)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="microsoftPeeringConfig")
    def microsoft_peering_config(self) -> Optional['outputs.ExpressRouteCircuitPeeringConfigResponse']:
        """
        The Microsoft peering configuration.
        """
        return pulumi.get(self, "microsoft_peering_config")

    @property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> Optional[str]:
        """
        The primary address prefix.
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @property
    @pulumi.getter(name="routeFilter")
    def route_filter(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference to the RouteFilter resource.
        """
        return pulumi.get(self, "route_filter")

    @property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> Optional[str]:
        """
        The secondary address prefix.
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of peering.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class KeyVaultCertificateSourceParametersResponseVault(dict):
    """
    The Key Vault containing the SSL certificate
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        The Key Vault containing the SSL certificate
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LoadBalancerBackendAddressResponse(dict):
    """
    Load balancer backend addresses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaceIPConfiguration":
            suggest = "network_interface_ip_configuration"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "virtualNetwork":
            suggest = "virtual_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerBackendAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerBackendAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerBackendAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interface_ip_configuration: 'outputs.SubResourceResponse',
                 ip_address: Optional[str] = None,
                 name: Optional[str] = None,
                 virtual_network: Optional['outputs.SubResourceResponse'] = None):
        """
        Load balancer backend addresses.
        :param 'SubResourceResponse' network_interface_ip_configuration: Reference to IP address defined in network interfaces.
        :param str ip_address: IP Address belonging to the referenced virtual network.
        :param str name: Name of the backend address.
        :param 'SubResourceResponse' virtual_network: Reference to an existing virtual network.
        """
        pulumi.set(__self__, "network_interface_ip_configuration", network_interface_ip_configuration)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_network is not None:
            pulumi.set(__self__, "virtual_network", virtual_network)

    @property
    @pulumi.getter(name="networkInterfaceIPConfiguration")
    def network_interface_ip_configuration(self) -> 'outputs.SubResourceResponse':
        """
        Reference to IP address defined in network interfaces.
        """
        return pulumi.get(self, "network_interface_ip_configuration")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        IP Address belonging to the referenced virtual network.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the backend address.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="virtualNetwork")
    def virtual_network(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to an existing virtual network.
        """
        return pulumi.get(self, "virtual_network")


@pulumi.output_type
class LoadBalancerSkuResponse(dict):
    """
    SKU of a load balancer.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        SKU of a load balancer.
        :param str name: Name of a load balancer SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of a load balancer SKU.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LoadBalancingRuleResponse(dict):
    """
    A load balancing rule for a load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frontendPort":
            suggest = "frontend_port"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "backendPort":
            suggest = "backend_port"
        elif key == "disableOutboundSnat":
            suggest = "disable_outbound_snat"
        elif key == "enableFloatingIP":
            suggest = "enable_floating_ip"
        elif key == "enableTcpReset":
            suggest = "enable_tcp_reset"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "loadDistribution":
            suggest = "load_distribution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 frontend_port: int,
                 protocol: str,
                 provisioning_state: str,
                 type: str,
                 backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 backend_port: Optional[int] = None,
                 disable_outbound_snat: Optional[bool] = None,
                 enable_floating_ip: Optional[bool] = None,
                 enable_tcp_reset: Optional[bool] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 load_distribution: Optional[str] = None,
                 name: Optional[str] = None,
                 probe: Optional['outputs.SubResourceResponse'] = None):
        """
        A load balancing rule for a load balancer.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param int frontend_port: The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port".
        :param str protocol: The reference to the transport protocol used by the load balancing rule.
        :param str provisioning_state: The provisioning state of the load balancing rule resource.
        :param str type: Type of the resource.
        :param 'SubResourceResponse' backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
        :param int backend_port: The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port".
        :param bool disable_outbound_snat: Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.
        :param bool enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        :param bool enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param 'SubResourceResponse' frontend_ip_configuration: A reference to frontend IP addresses.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        :param str load_distribution: The load distribution policy for this rule.
        :param str name: The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource.
        :param 'SubResourceResponse' probe: The reference to the load balancer probe used by the load balancing rule.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if disable_outbound_snat is not None:
            pulumi.set(__self__, "disable_outbound_snat", disable_outbound_snat)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if load_distribution is not None:
            pulumi.set(__self__, "load_distribution", load_distribution)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if probe is not None:
            pulumi.set(__self__, "probe", probe)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> int:
        """
        The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port".
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The reference to the transport protocol used by the load balancing rule.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the load balancing rule resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[int]:
        """
        The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port".
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="disableOutboundSnat")
    def disable_outbound_snat(self) -> Optional[bool]:
        """
        Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.
        """
        return pulumi.get(self, "disable_outbound_snat")

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> Optional[bool]:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[bool]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="loadDistribution")
    def load_distribution(self) -> Optional[str]:
        """
        The load distribution policy for this rule.
        """
        return pulumi.get(self, "load_distribution")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def probe(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference to the load balancer probe used by the load balancing rule.
        """
        return pulumi.get(self, "probe")


@pulumi.output_type
class LoadBalancingSettingsModelResponse(dict):
    """
    Load balancing settings for a backend pool
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceState":
            suggest = "resource_state"
        elif key == "additionalLatencyMilliseconds":
            suggest = "additional_latency_milliseconds"
        elif key == "sampleSize":
            suggest = "sample_size"
        elif key == "successfulSamplesRequired":
            suggest = "successful_samples_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancingSettingsModelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancingSettingsModelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancingSettingsModelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_state: str,
                 type: str,
                 additional_latency_milliseconds: Optional[int] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 sample_size: Optional[int] = None,
                 successful_samples_required: Optional[int] = None):
        """
        Load balancing settings for a backend pool
        :param str resource_state: Resource status.
        :param str type: Resource type.
        :param int additional_latency_milliseconds: The additional latency in milliseconds for probes to fall into the lowest latency bucket
        :param str id: Resource ID.
        :param str name: Resource name.
        :param int sample_size: The number of samples to consider for load balancing decisions
        :param int successful_samples_required: The number of samples within the sample period that must succeed
        """
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "type", type)
        if additional_latency_milliseconds is not None:
            pulumi.set(__self__, "additional_latency_milliseconds", additional_latency_milliseconds)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)
        if successful_samples_required is not None:
            pulumi.set(__self__, "successful_samples_required", successful_samples_required)

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Resource status.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="additionalLatencyMilliseconds")
    def additional_latency_milliseconds(self) -> Optional[int]:
        """
        The additional latency in milliseconds for probes to fall into the lowest latency bucket
        """
        return pulumi.get(self, "additional_latency_milliseconds")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[int]:
        """
        The number of samples to consider for load balancing decisions
        """
        return pulumi.get(self, "sample_size")

    @property
    @pulumi.getter(name="successfulSamplesRequired")
    def successful_samples_required(self) -> Optional[int]:
        """
        The number of samples within the sample period that must succeed
        """
        return pulumi.get(self, "successful_samples_required")


@pulumi.output_type
class LocalNetworkGatewayResponse(dict):
    """
    A common class for general resource information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "bgpSettings":
            suggest = "bgp_settings"
        elif key == "gatewayIpAddress":
            suggest = "gateway_ip_address"
        elif key == "localNetworkAddressSpace":
            suggest = "local_network_address_space"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocalNetworkGatewayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocalNetworkGatewayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocalNetworkGatewayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 name: str,
                 provisioning_state: str,
                 resource_guid: str,
                 type: str,
                 bgp_settings: Optional['outputs.BgpSettingsResponse'] = None,
                 fqdn: Optional[str] = None,
                 gateway_ip_address: Optional[str] = None,
                 id: Optional[str] = None,
                 local_network_address_space: Optional['outputs.AddressSpaceResponse'] = None,
                 location: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        A common class for general resource information.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the local network gateway resource.
        :param str resource_guid: The resource GUID property of the local network gateway resource.
        :param str type: Resource type.
        :param 'BgpSettingsResponse' bgp_settings: Local network gateway's BGP speaker settings.
        :param str fqdn: FQDN of local network gateway.
        :param str gateway_ip_address: IP address of local network gateway.
        :param str id: Resource ID.
        :param 'AddressSpaceResponse' local_network_address_space: Local network site address space.
        :param str location: Resource location.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "type", type)
        if bgp_settings is not None:
            pulumi.set(__self__, "bgp_settings", bgp_settings)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if gateway_ip_address is not None:
            pulumi.set(__self__, "gateway_ip_address", gateway_ip_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if local_network_address_space is not None:
            pulumi.set(__self__, "local_network_address_space", local_network_address_space)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the local network gateway resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resource GUID property of the local network gateway resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Optional['outputs.BgpSettingsResponse']:
        """
        Local network gateway's BGP speaker settings.
        """
        return pulumi.get(self, "bgp_settings")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        FQDN of local network gateway.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="gatewayIpAddress")
    def gateway_ip_address(self) -> Optional[str]:
        """
        IP address of local network gateway.
        """
        return pulumi.get(self, "gateway_ip_address")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localNetworkAddressSpace")
    def local_network_address_space(self) -> Optional['outputs.AddressSpaceResponse']:
        """
        Local network site address space.
        """
        return pulumi.get(self, "local_network_address_space")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ManagedRuleGroupOverrideResponse(dict):
    """
    Defines a managed rule group override setting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleGroupName":
            suggest = "rule_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedRuleGroupOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedRuleGroupOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedRuleGroupOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_group_name: str,
                 rules: Optional[Sequence['outputs.ManagedRuleOverrideResponse']] = None):
        """
        Defines a managed rule group override setting.
        :param str rule_group_name: The managed rule group to override.
        :param Sequence['ManagedRuleOverrideResponse'] rules: List of rules that will be disabled. If none specified, all rules in the group will be disabled.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> str:
        """
        The managed rule group to override.
        """
        return pulumi.get(self, "rule_group_name")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.ManagedRuleOverrideResponse']]:
        """
        List of rules that will be disabled. If none specified, all rules in the group will be disabled.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ManagedRuleOverrideResponse(dict):
    """
    Defines a managed rule group override setting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedRuleOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedRuleOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedRuleOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_id: str,
                 state: Optional[str] = None):
        """
        Defines a managed rule group override setting.
        :param str rule_id: Identifier for the managed rule.
        :param str state: The state of the managed rule. Defaults to Disabled if not specified.
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> str:
        """
        Identifier for the managed rule.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of the managed rule. Defaults to Disabled if not specified.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ManagedRuleSetResponse(dict):
    """
    Defines a managed rule set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleSetType":
            suggest = "rule_set_type"
        elif key == "ruleSetVersion":
            suggest = "rule_set_version"
        elif key == "ruleGroupOverrides":
            suggest = "rule_group_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_set_type: str,
                 rule_set_version: str,
                 rule_group_overrides: Optional[Sequence['outputs.ManagedRuleGroupOverrideResponse']] = None):
        """
        Defines a managed rule set.
        :param str rule_set_type: Defines the rule set type to use.
        :param str rule_set_version: Defines the version of the rule set to use.
        :param Sequence['ManagedRuleGroupOverrideResponse'] rule_group_overrides: Defines the rule group overrides to apply to the rule set.
        """
        pulumi.set(__self__, "rule_set_type", rule_set_type)
        pulumi.set(__self__, "rule_set_version", rule_set_version)
        if rule_group_overrides is not None:
            pulumi.set(__self__, "rule_group_overrides", rule_group_overrides)

    @property
    @pulumi.getter(name="ruleSetType")
    def rule_set_type(self) -> str:
        """
        Defines the rule set type to use.
        """
        return pulumi.get(self, "rule_set_type")

    @property
    @pulumi.getter(name="ruleSetVersion")
    def rule_set_version(self) -> str:
        """
        Defines the version of the rule set to use.
        """
        return pulumi.get(self, "rule_set_version")

    @property
    @pulumi.getter(name="ruleGroupOverrides")
    def rule_group_overrides(self) -> Optional[Sequence['outputs.ManagedRuleGroupOverrideResponse']]:
        """
        Defines the rule group overrides to apply to the rule set.
        """
        return pulumi.get(self, "rule_group_overrides")


@pulumi.output_type
class ManagedRulesDefinitionResponse(dict):
    """
    Allow to exclude some variable satisfy the condition for the WAF check.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedRuleSets":
            suggest = "managed_rule_sets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedRulesDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedRulesDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedRulesDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_rule_sets: Sequence['outputs.ManagedRuleSetResponse'],
                 exclusions: Optional[Sequence['outputs.OwaspCrsExclusionEntryResponse']] = None):
        """
        Allow to exclude some variable satisfy the condition for the WAF check.
        :param Sequence['ManagedRuleSetResponse'] managed_rule_sets: The managed rule sets that are associated with the policy.
        :param Sequence['OwaspCrsExclusionEntryResponse'] exclusions: The Exclusions that are applied on the policy.
        """
        pulumi.set(__self__, "managed_rule_sets", managed_rule_sets)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)

    @property
    @pulumi.getter(name="managedRuleSets")
    def managed_rule_sets(self) -> Sequence['outputs.ManagedRuleSetResponse']:
        """
        The managed rule sets that are associated with the policy.
        """
        return pulumi.get(self, "managed_rule_sets")

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence['outputs.OwaspCrsExclusionEntryResponse']]:
        """
        The Exclusions that are applied on the policy.
        """
        return pulumi.get(self, "exclusions")


@pulumi.output_type
class ManagedServiceIdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.ManagedServiceIdentityResponseUserAssignedIdentities']] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal id of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str type: The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
        :param Mapping[str, 'ManagedServiceIdentityResponseUserAssignedIdentities'] user_assigned_identities: The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.ManagedServiceIdentityResponseUserAssignedIdentities']]:
        """
        The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ManagedServiceIdentityResponseUserAssignedIdentities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedServiceIdentityResponseUserAssignedIdentities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedServiceIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedServiceIdentityResponseUserAssignedIdentities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class MatchConditionResponse(dict):
    """
    Define match conditions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchValues":
            suggest = "match_values"
        elif key == "matchVariables":
            suggest = "match_variables"
        elif key == "negationConditon":
            suggest = "negation_conditon"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_values: Sequence[str],
                 match_variables: Sequence['outputs.MatchVariableResponse'],
                 operator: str,
                 negation_conditon: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Define match conditions.
        :param Sequence[str] match_values: Match value.
        :param Sequence['MatchVariableResponse'] match_variables: List of match variables.
        :param str operator: The operator to be matched.
        :param bool negation_conditon: Whether this is negate condition or not.
        :param Sequence[str] transforms: List of transforms.
        """
        pulumi.set(__self__, "match_values", match_values)
        pulumi.set(__self__, "match_variables", match_variables)
        pulumi.set(__self__, "operator", operator)
        if negation_conditon is not None:
            pulumi.set(__self__, "negation_conditon", negation_conditon)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Sequence[str]:
        """
        Match value.
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="matchVariables")
    def match_variables(self) -> Sequence['outputs.MatchVariableResponse']:
        """
        List of match variables.
        """
        return pulumi.get(self, "match_variables")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to be matched.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="negationConditon")
    def negation_conditon(self) -> Optional[bool]:
        """
        Whether this is negate condition or not.
        """
        return pulumi.get(self, "negation_conditon")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms.
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class MatchVariableResponse(dict):
    """
    Define match variables.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "variableName":
            suggest = "variable_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchVariableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchVariableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchVariableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 variable_name: str,
                 selector: Optional[str] = None):
        """
        Define match variables.
        :param str variable_name: Match Variable.
        :param str selector: The selector of match variable.
        """
        pulumi.set(__self__, "variable_name", variable_name)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> str:
        """
        Match Variable.
        """
        return pulumi.get(self, "variable_name")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        """
        The selector of match variable.
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class NatGatewaySkuResponse(dict):
    """
    SKU of nat gateway.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        SKU of nat gateway.
        :param str name: Name of Nat Gateway SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of Nat Gateway SKU.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NatRuleResponse(dict):
    """
    Rule of type nat.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"
        elif key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "destinationPorts":
            suggest = "destination_ports"
        elif key == "ipProtocols":
            suggest = "ip_protocols"
        elif key == "sourceAddresses":
            suggest = "source_addresses"
        elif key == "sourceIpGroups":
            suggest = "source_ip_groups"
        elif key == "translatedAddress":
            suggest = "translated_address"
        elif key == "translatedPort":
            suggest = "translated_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NatRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NatRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NatRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: str,
                 description: Optional[str] = None,
                 destination_addresses: Optional[Sequence[str]] = None,
                 destination_ports: Optional[Sequence[str]] = None,
                 ip_protocols: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 source_ip_groups: Optional[Sequence[str]] = None,
                 translated_address: Optional[str] = None,
                 translated_port: Optional[str] = None):
        """
        Rule of type nat.
        :param str rule_type: Rule Type.
               Expected value is 'NatRule'.
        :param str description: Description of the rule.
        :param Sequence[str] destination_addresses: List of destination IP addresses or Service Tags.
        :param Sequence[str] destination_ports: List of destination ports.
        :param Sequence[str] ip_protocols: Array of FirewallPolicyRuleNetworkProtocols.
        :param str name: Name of the rule.
        :param Sequence[str] source_addresses: List of source IP addresses for this rule.
        :param Sequence[str] source_ip_groups: List of source IpGroups for this rule.
        :param str translated_address: The translated address for this NAT rule.
        :param str translated_port: The translated port for this NAT rule.
        """
        pulumi.set(__self__, "rule_type", 'NatRule')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if ip_protocols is not None:
            pulumi.set(__self__, "ip_protocols", ip_protocols)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)
        if translated_address is not None:
            pulumi.set(__self__, "translated_address", translated_address)
        if translated_port is not None:
            pulumi.set(__self__, "translated_port", translated_port)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        Rule Type.
        Expected value is 'NatRule'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        List of destination IP addresses or Service Tags.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[Sequence[str]]:
        """
        List of destination ports.
        """
        return pulumi.get(self, "destination_ports")

    @property
    @pulumi.getter(name="ipProtocols")
    def ip_protocols(self) -> Optional[Sequence[str]]:
        """
        Array of FirewallPolicyRuleNetworkProtocols.
        """
        return pulumi.get(self, "ip_protocols")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[Sequence[str]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")

    @property
    @pulumi.getter(name="translatedAddress")
    def translated_address(self) -> Optional[str]:
        """
        The translated address for this NAT rule.
        """
        return pulumi.get(self, "translated_address")

    @property
    @pulumi.getter(name="translatedPort")
    def translated_port(self) -> Optional[str]:
        """
        The translated port for this NAT rule.
        """
        return pulumi.get(self, "translated_port")


@pulumi.output_type
class NetworkInterfaceDnsSettingsResponse(dict):
    """
    DNS settings of a network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedDnsServers":
            suggest = "applied_dns_servers"
        elif key == "internalDomainNameSuffix":
            suggest = "internal_domain_name_suffix"
        elif key == "internalFqdn":
            suggest = "internal_fqdn"
        elif key == "dnsServers":
            suggest = "dns_servers"
        elif key == "internalDnsNameLabel":
            suggest = "internal_dns_name_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_dns_servers: Sequence[str],
                 internal_domain_name_suffix: str,
                 internal_fqdn: str,
                 dns_servers: Optional[Sequence[str]] = None,
                 internal_dns_name_label: Optional[str] = None):
        """
        DNS settings of a network interface.
        :param Sequence[str] applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.
        :param str internal_domain_name_suffix: Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix.
        :param str internal_fqdn: Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
        :param Sequence[str] dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
        :param str internal_dns_name_label: Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
        """
        pulumi.set(__self__, "applied_dns_servers", applied_dns_servers)
        pulumi.set(__self__, "internal_domain_name_suffix", internal_domain_name_suffix)
        pulumi.set(__self__, "internal_fqdn", internal_fqdn)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if internal_dns_name_label is not None:
            pulumi.set(__self__, "internal_dns_name_label", internal_dns_name_label)

    @property
    @pulumi.getter(name="appliedDnsServers")
    def applied_dns_servers(self) -> Sequence[str]:
        """
        If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.
        """
        return pulumi.get(self, "applied_dns_servers")

    @property
    @pulumi.getter(name="internalDomainNameSuffix")
    def internal_domain_name_suffix(self) -> str:
        """
        Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix.
        """
        return pulumi.get(self, "internal_domain_name_suffix")

    @property
    @pulumi.getter(name="internalFqdn")
    def internal_fqdn(self) -> str:
        """
        Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
        """
        return pulumi.get(self, "internal_fqdn")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="internalDnsNameLabel")
    def internal_dns_name_label(self) -> Optional[str]:
        """
        Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
        """
        return pulumi.get(self, "internal_dns_name_label")


@pulumi.output_type
class NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse(dict):
    """
    PrivateLinkConnection properties for the network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "requiredMemberName":
            suggest = "required_member_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdns: Sequence[str],
                 group_id: str,
                 required_member_name: str):
        """
        PrivateLinkConnection properties for the network interface.
        :param Sequence[str] fqdns: List of FQDNs for current private link connection.
        :param str group_id: The group ID for current private link connection.
        :param str required_member_name: The required member name for current private link connection.
        """
        pulumi.set(__self__, "fqdns", fqdns)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "required_member_name", required_member_name)

    @property
    @pulumi.getter
    def fqdns(self) -> Sequence[str]:
        """
        List of FQDNs for current private link connection.
        """
        return pulumi.get(self, "fqdns")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The group ID for current private link connection.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="requiredMemberName")
    def required_member_name(self) -> str:
        """
        The required member name for current private link connection.
        """
        return pulumi.get(self, "required_member_name")


@pulumi.output_type
class NetworkInterfaceIPConfigurationResponse(dict):
    """
    IPConfiguration in a network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkConnectionProperties":
            suggest = "private_link_connection_properties"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "applicationGatewayBackendAddressPools":
            suggest = "application_gateway_backend_address_pools"
        elif key == "applicationSecurityGroups":
            suggest = "application_security_groups"
        elif key == "loadBalancerBackendAddressPools":
            suggest = "load_balancer_backend_address_pools"
        elif key == "loadBalancerInboundNatRules":
            suggest = "load_balancer_inbound_nat_rules"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAddressVersion":
            suggest = "private_ip_address_version"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"
        elif key == "virtualNetworkTaps":
            suggest = "virtual_network_taps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 private_link_connection_properties: 'outputs.NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse',
                 provisioning_state: str,
                 application_gateway_backend_address_pools: Optional[Sequence['outputs.ApplicationGatewayBackendAddressPoolResponse']] = None,
                 application_security_groups: Optional[Sequence['outputs.ApplicationSecurityGroupResponse']] = None,
                 id: Optional[str] = None,
                 load_balancer_backend_address_pools: Optional[Sequence['outputs.BackendAddressPoolResponse']] = None,
                 load_balancer_inbound_nat_rules: Optional[Sequence['outputs.InboundNatRuleResponse']] = None,
                 name: Optional[str] = None,
                 primary: Optional[bool] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_address_version: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 public_ip_address: Optional['outputs.PublicIPAddressResponse'] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None,
                 virtual_network_taps: Optional[Sequence['outputs.VirtualNetworkTapResponse']] = None):
        """
        IPConfiguration in a network interface.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse' private_link_connection_properties: PrivateLinkConnection properties for the network interface.
        :param str provisioning_state: The provisioning state of the network interface IP configuration.
        :param Sequence['ApplicationGatewayBackendAddressPoolResponse'] application_gateway_backend_address_pools: The reference to ApplicationGatewayBackendAddressPool resource.
        :param Sequence['ApplicationSecurityGroupResponse'] application_security_groups: Application security groups in which the IP configuration is included.
        :param str id: Resource ID.
        :param Sequence['BackendAddressPoolResponse'] load_balancer_backend_address_pools: The reference to LoadBalancerBackendAddressPool resource.
        :param Sequence['InboundNatRuleResponse'] load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param bool primary: Whether this is a primary customer address on the network interface.
        :param str private_ip_address: Private IP address of the IP configuration.
        :param str private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
        :param str private_ip_allocation_method: The private IP address allocation method.
        :param 'PublicIPAddressResponse' public_ip_address: Public IP address bound to the IP configuration.
        :param 'SubnetResponse' subnet: Subnet bound to the IP configuration.
        :param Sequence['VirtualNetworkTapResponse'] virtual_network_taps: The reference to Virtual Network Taps.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "private_link_connection_properties", private_link_connection_properties)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if application_gateway_backend_address_pools is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pools", application_gateway_backend_address_pools)
        if application_security_groups is not None:
            pulumi.set(__self__, "application_security_groups", application_security_groups)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_inbound_nat_rules is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_rules", load_balancer_inbound_nat_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if virtual_network_taps is not None:
            pulumi.set(__self__, "virtual_network_taps", virtual_network_taps)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="privateLinkConnectionProperties")
    def private_link_connection_properties(self) -> 'outputs.NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse':
        """
        PrivateLinkConnection properties for the network interface.
        """
        return pulumi.get(self, "private_link_connection_properties")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the network interface IP configuration.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="applicationGatewayBackendAddressPools")
    def application_gateway_backend_address_pools(self) -> Optional[Sequence['outputs.ApplicationGatewayBackendAddressPoolResponse']]:
        """
        The reference to ApplicationGatewayBackendAddressPool resource.
        """
        return pulumi.get(self, "application_gateway_backend_address_pools")

    @property
    @pulumi.getter(name="applicationSecurityGroups")
    def application_security_groups(self) -> Optional[Sequence['outputs.ApplicationSecurityGroupResponse']]:
        """
        Application security groups in which the IP configuration is included.
        """
        return pulumi.get(self, "application_security_groups")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[Sequence['outputs.BackendAddressPoolResponse']]:
        """
        The reference to LoadBalancerBackendAddressPool resource.
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @property
    @pulumi.getter(name="loadBalancerInboundNatRules")
    def load_balancer_inbound_nat_rules(self) -> Optional[Sequence['outputs.InboundNatRuleResponse']]:
        """
        A list of references of LoadBalancerInboundNatRules.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_rules")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Whether this is a primary customer address on the network interface.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        Private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[str]:
        """
        Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
        """
        return pulumi.get(self, "private_ip_address_version")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.PublicIPAddressResponse']:
        """
        Public IP address bound to the IP configuration.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        Subnet bound to the IP configuration.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="virtualNetworkTaps")
    def virtual_network_taps(self) -> Optional[Sequence['outputs.VirtualNetworkTapResponse']]:
        """
        The reference to Virtual Network Taps.
        """
        return pulumi.get(self, "virtual_network_taps")


@pulumi.output_type
class NetworkInterfaceResponse(dict):
    """
    A network interface in a resource group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostedWorkloads":
            suggest = "hosted_workloads"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "tapConfigurations":
            suggest = "tap_configurations"
        elif key == "virtualMachine":
            suggest = "virtual_machine"
        elif key == "dnsSettings":
            suggest = "dns_settings"
        elif key == "enableAcceleratedNetworking":
            suggest = "enable_accelerated_networking"
        elif key == "enableIPForwarding":
            suggest = "enable_ip_forwarding"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "networkSecurityGroup":
            suggest = "network_security_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 hosted_workloads: Sequence[str],
                 mac_address: str,
                 name: str,
                 primary: bool,
                 private_endpoint: 'outputs.PrivateEndpointResponse',
                 provisioning_state: str,
                 resource_guid: str,
                 tap_configurations: Sequence['outputs.NetworkInterfaceTapConfigurationResponse'],
                 type: str,
                 virtual_machine: 'outputs.SubResourceResponse',
                 dns_settings: Optional['outputs.NetworkInterfaceDnsSettingsResponse'] = None,
                 enable_accelerated_networking: Optional[bool] = None,
                 enable_ip_forwarding: Optional[bool] = None,
                 id: Optional[str] = None,
                 ip_configurations: Optional[Sequence['outputs.NetworkInterfaceIPConfigurationResponse']] = None,
                 location: Optional[str] = None,
                 network_security_group: Optional['outputs.NetworkSecurityGroupResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        A network interface in a resource group.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param Sequence[str] hosted_workloads: A list of references to linked BareMetal resources.
        :param str mac_address: The MAC address of the network interface.
        :param str name: Resource name.
        :param bool primary: Whether this is a primary network interface on a virtual machine.
        :param 'PrivateEndpointResponse' private_endpoint: A reference to the private endpoint to which the network interface is linked.
        :param str provisioning_state: The provisioning state of the network interface resource.
        :param str resource_guid: The resource GUID property of the network interface resource.
        :param Sequence['NetworkInterfaceTapConfigurationResponse'] tap_configurations: A list of TapConfigurations of the network interface.
        :param str type: Resource type.
        :param 'SubResourceResponse' virtual_machine: The reference to a virtual machine.
        :param 'NetworkInterfaceDnsSettingsResponse' dns_settings: The DNS settings in network interface.
        :param bool enable_accelerated_networking: If the network interface is accelerated networking enabled.
        :param bool enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network interface.
        :param str id: Resource ID.
        :param Sequence['NetworkInterfaceIPConfigurationResponse'] ip_configurations: A list of IPConfigurations of the network interface.
        :param str location: Resource location.
        :param 'NetworkSecurityGroupResponse' network_security_group: The reference to the NetworkSecurityGroup resource.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "hosted_workloads", hosted_workloads)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "tap_configurations", tap_configurations)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "virtual_machine", virtual_machine)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="hostedWorkloads")
    def hosted_workloads(self) -> Sequence[str]:
        """
        A list of references to linked BareMetal resources.
        """
        return pulumi.get(self, "hosted_workloads")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> str:
        """
        The MAC address of the network interface.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def primary(self) -> bool:
        """
        Whether this is a primary network interface on a virtual machine.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> 'outputs.PrivateEndpointResponse':
        """
        A reference to the private endpoint to which the network interface is linked.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the network interface resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resource GUID property of the network interface resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter(name="tapConfigurations")
    def tap_configurations(self) -> Sequence['outputs.NetworkInterfaceTapConfigurationResponse']:
        """
        A list of TapConfigurations of the network interface.
        """
        return pulumi.get(self, "tap_configurations")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> 'outputs.SubResourceResponse':
        """
        The reference to a virtual machine.
        """
        return pulumi.get(self, "virtual_machine")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional['outputs.NetworkInterfaceDnsSettingsResponse']:
        """
        The DNS settings in network interface.
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[bool]:
        """
        If the network interface is accelerated networking enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @property
    @pulumi.getter(name="enableIPForwarding")
    def enable_ip_forwarding(self) -> Optional[bool]:
        """
        Indicates whether IP forwarding is enabled on this network interface.
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.NetworkInterfaceIPConfigurationResponse']]:
        """
        A list of IPConfigurations of the network interface.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional['outputs.NetworkSecurityGroupResponse']:
        """
        The reference to the NetworkSecurityGroup resource.
        """
        return pulumi.get(self, "network_security_group")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class NetworkInterfaceTapConfigurationResponse(dict):
    """
    Tap configuration in a Network Interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "virtualNetworkTap":
            suggest = "virtual_network_tap"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceTapConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceTapConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceTapConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 virtual_network_tap: Optional['outputs.VirtualNetworkTapResponse'] = None):
        """
        Tap configuration in a Network Interface.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the network interface tap configuration resource.
        :param str type: Sub Resource type.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'VirtualNetworkTapResponse' virtual_network_tap: The reference to the Virtual Network Tap resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_network_tap is not None:
            pulumi.set(__self__, "virtual_network_tap", virtual_network_tap)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the network interface tap configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Sub Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="virtualNetworkTap")
    def virtual_network_tap(self) -> Optional['outputs.VirtualNetworkTapResponse']:
        """
        The reference to the Virtual Network Tap resource.
        """
        return pulumi.get(self, "virtual_network_tap")


@pulumi.output_type
class NetworkRuleResponse(dict):
    """
    Rule of type network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"
        elif key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "destinationFqdns":
            suggest = "destination_fqdns"
        elif key == "destinationIpGroups":
            suggest = "destination_ip_groups"
        elif key == "destinationPorts":
            suggest = "destination_ports"
        elif key == "ipProtocols":
            suggest = "ip_protocols"
        elif key == "sourceAddresses":
            suggest = "source_addresses"
        elif key == "sourceIpGroups":
            suggest = "source_ip_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: str,
                 description: Optional[str] = None,
                 destination_addresses: Optional[Sequence[str]] = None,
                 destination_fqdns: Optional[Sequence[str]] = None,
                 destination_ip_groups: Optional[Sequence[str]] = None,
                 destination_ports: Optional[Sequence[str]] = None,
                 ip_protocols: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 source_ip_groups: Optional[Sequence[str]] = None):
        """
        Rule of type network.
        :param str rule_type: Rule Type.
               Expected value is 'NetworkRule'.
        :param str description: Description of the rule.
        :param Sequence[str] destination_addresses: List of destination IP addresses or Service Tags.
        :param Sequence[str] destination_fqdns: List of destination FQDNs.
        :param Sequence[str] destination_ip_groups: List of destination IpGroups for this rule.
        :param Sequence[str] destination_ports: List of destination ports.
        :param Sequence[str] ip_protocols: Array of FirewallPolicyRuleNetworkProtocols.
        :param str name: Name of the rule.
        :param Sequence[str] source_addresses: List of source IP addresses for this rule.
        :param Sequence[str] source_ip_groups: List of source IpGroups for this rule.
        """
        pulumi.set(__self__, "rule_type", 'NetworkRule')
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_fqdns is not None:
            pulumi.set(__self__, "destination_fqdns", destination_fqdns)
        if destination_ip_groups is not None:
            pulumi.set(__self__, "destination_ip_groups", destination_ip_groups)
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if ip_protocols is not None:
            pulumi.set(__self__, "ip_protocols", ip_protocols)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_ip_groups is not None:
            pulumi.set(__self__, "source_ip_groups", source_ip_groups)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        Rule Type.
        Expected value is 'NetworkRule'.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        List of destination IP addresses or Service Tags.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="destinationFqdns")
    def destination_fqdns(self) -> Optional[Sequence[str]]:
        """
        List of destination FQDNs.
        """
        return pulumi.get(self, "destination_fqdns")

    @property
    @pulumi.getter(name="destinationIpGroups")
    def destination_ip_groups(self) -> Optional[Sequence[str]]:
        """
        List of destination IpGroups for this rule.
        """
        return pulumi.get(self, "destination_ip_groups")

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[Sequence[str]]:
        """
        List of destination ports.
        """
        return pulumi.get(self, "destination_ports")

    @property
    @pulumi.getter(name="ipProtocols")
    def ip_protocols(self) -> Optional[Sequence[str]]:
        """
        Array of FirewallPolicyRuleNetworkProtocols.
        """
        return pulumi.get(self, "ip_protocols")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="sourceIpGroups")
    def source_ip_groups(self) -> Optional[Sequence[str]]:
        """
        List of source IpGroups for this rule.
        """
        return pulumi.get(self, "source_ip_groups")


@pulumi.output_type
class NetworkSecurityGroupResponse(dict):
    """
    NetworkSecurityGroup resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultSecurityRules":
            suggest = "default_security_rules"
        elif key == "flowLogs":
            suggest = "flow_logs"
        elif key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "securityRules":
            suggest = "security_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkSecurityGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkSecurityGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkSecurityGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_security_rules: Sequence['outputs.SecurityRuleResponse'],
                 etag: str,
                 flow_logs: Sequence['outputs.FlowLogResponse'],
                 name: str,
                 network_interfaces: Sequence['outputs.NetworkInterfaceResponse'],
                 provisioning_state: str,
                 resource_guid: str,
                 subnets: Sequence['outputs.SubnetResponse'],
                 type: str,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 security_rules: Optional[Sequence['outputs.SecurityRuleResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        NetworkSecurityGroup resource.
        :param Sequence['SecurityRuleResponse'] default_security_rules: The default security rules of network security group.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param Sequence['FlowLogResponse'] flow_logs: A collection of references to flow log resources.
        :param str name: Resource name.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: A collection of references to network interfaces.
        :param str provisioning_state: The provisioning state of the network security group resource.
        :param str resource_guid: The resource GUID property of the network security group resource.
        :param Sequence['SubnetResponse'] subnets: A collection of references to subnets.
        :param str type: Resource type.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Sequence['SecurityRuleResponse'] security_rules: A collection of security rules of the network security group.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "default_security_rules", default_security_rules)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "flow_logs", flow_logs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="defaultSecurityRules")
    def default_security_rules(self) -> Sequence['outputs.SecurityRuleResponse']:
        """
        The default security rules of network security group.
        """
        return pulumi.get(self, "default_security_rules")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="flowLogs")
    def flow_logs(self) -> Sequence['outputs.FlowLogResponse']:
        """
        A collection of references to flow log resources.
        """
        return pulumi.get(self, "flow_logs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.NetworkInterfaceResponse']:
        """
        A collection of references to network interfaces.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the network security group resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resource GUID property of the network security group resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.SubnetResponse']:
        """
        A collection of references to subnets.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[Sequence['outputs.SecurityRuleResponse']]:
        """
        A collection of security rules of the network security group.
        """
        return pulumi.get(self, "security_rules")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class Office365PolicyPropertiesResponse(dict):
    """
    Network Virtual Appliance Sku Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "breakOutCategories":
            suggest = "break_out_categories"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Office365PolicyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Office365PolicyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Office365PolicyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 break_out_categories: Optional['outputs.BreakOutCategoryPoliciesResponse'] = None):
        """
        Network Virtual Appliance Sku Properties.
        :param 'BreakOutCategoryPoliciesResponse' break_out_categories: Office 365 breakout categories.
        """
        if break_out_categories is not None:
            pulumi.set(__self__, "break_out_categories", break_out_categories)

    @property
    @pulumi.getter(name="breakOutCategories")
    def break_out_categories(self) -> Optional['outputs.BreakOutCategoryPoliciesResponse']:
        """
        Office 365 breakout categories.
        """
        return pulumi.get(self, "break_out_categories")


@pulumi.output_type
class OutboundRuleResponse(dict):
    """
    Outbound rule of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "frontendIPConfigurations":
            suggest = "frontend_ip_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "allocatedOutboundPorts":
            suggest = "allocated_outbound_ports"
        elif key == "enableTcpReset":
            suggest = "enable_tcp_reset"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutboundRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutboundRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutboundRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_address_pool: 'outputs.SubResourceResponse',
                 etag: str,
                 frontend_ip_configurations: Sequence['outputs.SubResourceResponse'],
                 protocol: str,
                 provisioning_state: str,
                 type: str,
                 allocated_outbound_ports: Optional[int] = None,
                 enable_tcp_reset: Optional[bool] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 name: Optional[str] = None):
        """
        Outbound rule of the load balancer.
        :param 'SubResourceResponse' backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param Sequence['SubResourceResponse'] frontend_ip_configurations: The Frontend IP addresses of the load balancer.
        :param str protocol: The protocol for the outbound rule in load balancer.
        :param str provisioning_state: The provisioning state of the outbound rule resource.
        :param str type: Type of the resource.
        :param int allocated_outbound_ports: The number of outbound ports to be used for NAT.
        :param bool enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The timeout for the TCP idle connection.
        :param str name: The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource.
        """
        pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if allocated_outbound_ports is not None:
            pulumi.set(__self__, "allocated_outbound_ports", allocated_outbound_ports)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> 'outputs.SubResourceResponse':
        """
        A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfigurations")
    def frontend_ip_configurations(self) -> Sequence['outputs.SubResourceResponse']:
        """
        The Frontend IP addresses of the load balancer.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol for the outbound rule in load balancer.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the outbound rule resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allocatedOutboundPorts")
    def allocated_outbound_ports(self) -> Optional[int]:
        """
        The number of outbound ports to be used for NAT.
        """
        return pulumi.get(self, "allocated_outbound_ports")

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[bool]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The timeout for the TCP idle connection.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OwaspCrsExclusionEntryResponse(dict):
    """
    Allow to exclude some variable satisfy the condition for the WAF check.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchVariable":
            suggest = "match_variable"
        elif key == "selectorMatchOperator":
            suggest = "selector_match_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OwaspCrsExclusionEntryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OwaspCrsExclusionEntryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OwaspCrsExclusionEntryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_variable: str,
                 selector: str,
                 selector_match_operator: str):
        """
        Allow to exclude some variable satisfy the condition for the WAF check.
        :param str match_variable: The variable to be excluded.
        :param str selector: When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
        :param str selector_match_operator: When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "selector_match_operator", selector_match_operator)

    @property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> str:
        """
        The variable to be excluded.
        """
        return pulumi.get(self, "match_variable")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="selectorMatchOperator")
    def selector_match_operator(self) -> str:
        """
        When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector_match_operator")


@pulumi.output_type
class P2SConnectionConfigurationResponse(dict):
    """
    P2SConnectionConfiguration Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "routingConfiguration":
            suggest = "routing_configuration"
        elif key == "vpnClientAddressPool":
            suggest = "vpn_client_address_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in P2SConnectionConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        P2SConnectionConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        P2SConnectionConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 routing_configuration: Optional['outputs.RoutingConfigurationResponse'] = None,
                 vpn_client_address_pool: Optional['outputs.AddressSpaceResponse'] = None):
        """
        P2SConnectionConfiguration Resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the P2SConnectionConfiguration resource.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'RoutingConfigurationResponse' routing_configuration: The Routing Configuration indicating the associated and propagated route tables on this connection.
        :param 'AddressSpaceResponse' vpn_client_address_pool: The reference to the address space resource which represents Address space for P2S VpnClient.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routing_configuration is not None:
            pulumi.set(__self__, "routing_configuration", routing_configuration)
        if vpn_client_address_pool is not None:
            pulumi.set(__self__, "vpn_client_address_pool", vpn_client_address_pool)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the P2SConnectionConfiguration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> Optional['outputs.RoutingConfigurationResponse']:
        """
        The Routing Configuration indicating the associated and propagated route tables on this connection.
        """
        return pulumi.get(self, "routing_configuration")

    @property
    @pulumi.getter(name="vpnClientAddressPool")
    def vpn_client_address_pool(self) -> Optional['outputs.AddressSpaceResponse']:
        """
        The reference to the address space resource which represents Address space for P2S VpnClient.
        """
        return pulumi.get(self, "vpn_client_address_pool")


@pulumi.output_type
class P2SVpnGatewayResponse(dict):
    """
    P2SVpnGateway Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "vpnClientConnectionHealth":
            suggest = "vpn_client_connection_health"
        elif key == "customDnsServers":
            suggest = "custom_dns_servers"
        elif key == "p2SConnectionConfigurations":
            suggest = "p2_s_connection_configurations"
        elif key == "virtualHub":
            suggest = "virtual_hub"
        elif key == "vpnGatewayScaleUnit":
            suggest = "vpn_gateway_scale_unit"
        elif key == "vpnServerConfiguration":
            suggest = "vpn_server_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in P2SVpnGatewayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        P2SVpnGatewayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        P2SVpnGatewayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 location: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 vpn_client_connection_health: 'outputs.VpnClientConnectionHealthResponse',
                 custom_dns_servers: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 p2_s_connection_configurations: Optional[Sequence['outputs.P2SConnectionConfigurationResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 virtual_hub: Optional['outputs.SubResourceResponse'] = None,
                 vpn_gateway_scale_unit: Optional[int] = None,
                 vpn_server_configuration: Optional['outputs.SubResourceResponse'] = None):
        """
        P2SVpnGateway Resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str location: Resource location.
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the P2S VPN gateway resource.
        :param str type: Resource type.
        :param 'VpnClientConnectionHealthResponse' vpn_client_connection_health: All P2S VPN clients' connection health status.
        :param Sequence[str] custom_dns_servers: List of all customer specified DNS servers IP addresses.
        :param str id: Resource ID.
        :param Sequence['P2SConnectionConfigurationResponse'] p2_s_connection_configurations: List of all p2s connection configurations of the gateway.
        :param Mapping[str, str] tags: Resource tags.
        :param 'SubResourceResponse' virtual_hub: The VirtualHub to which the gateway belongs.
        :param int vpn_gateway_scale_unit: The scale unit for this p2s vpn gateway.
        :param 'SubResourceResponse' vpn_server_configuration: The VpnServerConfiguration to which the p2sVpnGateway is attached to.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vpn_client_connection_health", vpn_client_connection_health)
        if custom_dns_servers is not None:
            pulumi.set(__self__, "custom_dns_servers", custom_dns_servers)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if p2_s_connection_configurations is not None:
            pulumi.set(__self__, "p2_s_connection_configurations", p2_s_connection_configurations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_hub is not None:
            pulumi.set(__self__, "virtual_hub", virtual_hub)
        if vpn_gateway_scale_unit is not None:
            pulumi.set(__self__, "vpn_gateway_scale_unit", vpn_gateway_scale_unit)
        if vpn_server_configuration is not None:
            pulumi.set(__self__, "vpn_server_configuration", vpn_server_configuration)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the P2S VPN gateway resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpnClientConnectionHealth")
    def vpn_client_connection_health(self) -> 'outputs.VpnClientConnectionHealthResponse':
        """
        All P2S VPN clients' connection health status.
        """
        return pulumi.get(self, "vpn_client_connection_health")

    @property
    @pulumi.getter(name="customDnsServers")
    def custom_dns_servers(self) -> Optional[Sequence[str]]:
        """
        List of all customer specified DNS servers IP addresses.
        """
        return pulumi.get(self, "custom_dns_servers")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="p2SConnectionConfigurations")
    def p2_s_connection_configurations(self) -> Optional[Sequence['outputs.P2SConnectionConfigurationResponse']]:
        """
        List of all p2s connection configurations of the gateway.
        """
        return pulumi.get(self, "p2_s_connection_configurations")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="virtualHub")
    def virtual_hub(self) -> Optional['outputs.SubResourceResponse']:
        """
        The VirtualHub to which the gateway belongs.
        """
        return pulumi.get(self, "virtual_hub")

    @property
    @pulumi.getter(name="vpnGatewayScaleUnit")
    def vpn_gateway_scale_unit(self) -> Optional[int]:
        """
        The scale unit for this p2s vpn gateway.
        """
        return pulumi.get(self, "vpn_gateway_scale_unit")

    @property
    @pulumi.getter(name="vpnServerConfiguration")
    def vpn_server_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        The VpnServerConfiguration to which the p2sVpnGateway is attached to.
        """
        return pulumi.get(self, "vpn_server_configuration")


@pulumi.output_type
class PacketCaptureFilterResponse(dict):
    """
    Filter that is applied to packet capture request. Multiple filters can be applied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localIPAddress":
            suggest = "local_ip_address"
        elif key == "localPort":
            suggest = "local_port"
        elif key == "remoteIPAddress":
            suggest = "remote_ip_address"
        elif key == "remotePort":
            suggest = "remote_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketCaptureFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketCaptureFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketCaptureFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_ip_address: Optional[str] = None,
                 local_port: Optional[str] = None,
                 protocol: Optional[str] = None,
                 remote_ip_address: Optional[str] = None,
                 remote_port: Optional[str] = None):
        """
        Filter that is applied to packet capture request. Multiple filters can be applied.
        :param str local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param str local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param str protocol: Protocol to be filtered on.
        :param str remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param str remote_port: Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        if local_ip_address is not None:
            pulumi.set(__self__, "local_ip_address", local_ip_address)
        if local_port is not None:
            pulumi.set(__self__, "local_port", local_port)
        if protocol is None:
            protocol = 'Any'
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remote_ip_address is not None:
            pulumi.set(__self__, "remote_ip_address", remote_ip_address)
        if remote_port is not None:
            pulumi.set(__self__, "remote_port", remote_port)

    @property
    @pulumi.getter(name="localIPAddress")
    def local_ip_address(self) -> Optional[str]:
        """
        Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "local_ip_address")

    @property
    @pulumi.getter(name="localPort")
    def local_port(self) -> Optional[str]:
        """
        Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "local_port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol to be filtered on.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="remoteIPAddress")
    def remote_ip_address(self) -> Optional[str]:
        """
        Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "remote_ip_address")

    @property
    @pulumi.getter(name="remotePort")
    def remote_port(self) -> Optional[str]:
        """
        Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "remote_port")


@pulumi.output_type
class PacketCaptureStorageLocationResponse(dict):
    """
    The storage location for a packet capture session.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePath":
            suggest = "file_path"
        elif key == "storageId":
            suggest = "storage_id"
        elif key == "storagePath":
            suggest = "storage_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketCaptureStorageLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketCaptureStorageLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketCaptureStorageLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_path: Optional[str] = None,
                 storage_id: Optional[str] = None,
                 storage_path: Optional[str] = None):
        """
        The storage location for a packet capture session.
        :param str file_path: A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
        :param str storage_id: The ID of the storage account to save the packet capture session. Required if no local file path is provided.
        :param str storage_path: The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
        """
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if storage_id is not None:
            pulumi.set(__self__, "storage_id", storage_id)
        if storage_path is not None:
            pulumi.set(__self__, "storage_path", storage_path)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[str]:
        """
        A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter(name="storageId")
    def storage_id(self) -> Optional[str]:
        """
        The ID of the storage account to save the packet capture session. Required if no local file path is provided.
        """
        return pulumi.get(self, "storage_id")

    @property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> Optional[str]:
        """
        The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
        """
        return pulumi.get(self, "storage_path")


@pulumi.output_type
class PeerExpressRouteCircuitConnectionResponse(dict):
    """
    Peer Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "circuitConnectionStatus":
            suggest = "circuit_connection_status"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "authResourceGuid":
            suggest = "auth_resource_guid"
        elif key == "connectionName":
            suggest = "connection_name"
        elif key == "expressRouteCircuitPeering":
            suggest = "express_route_circuit_peering"
        elif key == "peerExpressRouteCircuitPeering":
            suggest = "peer_express_route_circuit_peering"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PeerExpressRouteCircuitConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PeerExpressRouteCircuitConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PeerExpressRouteCircuitConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 circuit_connection_status: str,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 address_prefix: Optional[str] = None,
                 auth_resource_guid: Optional[str] = None,
                 connection_name: Optional[str] = None,
                 express_route_circuit_peering: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 peer_express_route_circuit_peering: Optional['outputs.SubResourceResponse'] = None):
        """
        Peer Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
        :param str circuit_connection_status: Express Route Circuit connection state.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the peer express route circuit connection resource.
        :param str type: Type of the resource.
        :param str address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
        :param str auth_resource_guid: The resource guid of the authorization used for the express route circuit connection.
        :param str connection_name: The name of the express route circuit connection resource.
        :param 'SubResourceResponse' express_route_circuit_peering: Reference to Express Route Circuit Private Peering Resource of the circuit.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'SubResourceResponse' peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering Resource of the peered circuit.
        """
        pulumi.set(__self__, "circuit_connection_status", circuit_connection_status)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if auth_resource_guid is not None:
            pulumi.set(__self__, "auth_resource_guid", auth_resource_guid)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if express_route_circuit_peering is not None:
            pulumi.set(__self__, "express_route_circuit_peering", express_route_circuit_peering)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_express_route_circuit_peering is not None:
            pulumi.set(__self__, "peer_express_route_circuit_peering", peer_express_route_circuit_peering)

    @property
    @pulumi.getter(name="circuitConnectionStatus")
    def circuit_connection_status(self) -> str:
        """
        Express Route Circuit connection state.
        """
        return pulumi.get(self, "circuit_connection_status")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the peer express route circuit connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        /29 IP address space to carve out Customer addresses for tunnels.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter(name="authResourceGuid")
    def auth_resource_guid(self) -> Optional[str]:
        """
        The resource guid of the authorization used for the express route circuit connection.
        """
        return pulumi.get(self, "auth_resource_guid")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[str]:
        """
        The name of the express route circuit connection resource.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="expressRouteCircuitPeering")
    def express_route_circuit_peering(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to Express Route Circuit Private Peering Resource of the circuit.
        """
        return pulumi.get(self, "express_route_circuit_peering")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerExpressRouteCircuitPeering")
    def peer_express_route_circuit_peering(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to Express Route Circuit Private Peering Resource of the peered circuit.
        """
        return pulumi.get(self, "peer_express_route_circuit_peering")


@pulumi.output_type
class PolicySettingsResponse(dict):
    """
    Defines contents of a web application firewall global configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileUploadLimitInMb":
            suggest = "file_upload_limit_in_mb"
        elif key == "maxRequestBodySizeInKb":
            suggest = "max_request_body_size_in_kb"
        elif key == "requestBodyCheck":
            suggest = "request_body_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_upload_limit_in_mb: Optional[int] = None,
                 max_request_body_size_in_kb: Optional[int] = None,
                 mode: Optional[str] = None,
                 request_body_check: Optional[bool] = None,
                 state: Optional[str] = None):
        """
        Defines contents of a web application firewall global configuration.
        :param int file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
        :param int max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
        :param str mode: The mode of the policy.
        :param bool request_body_check: Whether to allow WAF to check request Body.
        :param str state: The state of the policy.
        """
        if file_upload_limit_in_mb is not None:
            pulumi.set(__self__, "file_upload_limit_in_mb", file_upload_limit_in_mb)
        if max_request_body_size_in_kb is not None:
            pulumi.set(__self__, "max_request_body_size_in_kb", max_request_body_size_in_kb)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if request_body_check is not None:
            pulumi.set(__self__, "request_body_check", request_body_check)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="fileUploadLimitInMb")
    def file_upload_limit_in_mb(self) -> Optional[int]:
        """
        Maximum file upload size in Mb for WAF.
        """
        return pulumi.get(self, "file_upload_limit_in_mb")

    @property
    @pulumi.getter(name="maxRequestBodySizeInKb")
    def max_request_body_size_in_kb(self) -> Optional[int]:
        """
        Maximum request body size in Kb for WAF.
        """
        return pulumi.get(self, "max_request_body_size_in_kb")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The mode of the policy.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="requestBodyCheck")
    def request_body_check(self) -> Optional[bool]:
        """
        Whether to allow WAF to check request Body.
        """
        return pulumi.get(self, "request_body_check")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of the policy.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class PrivateDnsZoneConfigResponse(dict):
    """
    PrivateDnsZoneConfig resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordSets":
            suggest = "record_sets"
        elif key == "privateDnsZoneId":
            suggest = "private_dns_zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateDnsZoneConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateDnsZoneConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateDnsZoneConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_sets: Sequence['outputs.RecordSetResponse'],
                 name: Optional[str] = None,
                 private_dns_zone_id: Optional[str] = None):
        """
        PrivateDnsZoneConfig resource.
        :param Sequence['RecordSetResponse'] record_sets: A collection of information regarding a recordSet, holding information to identify private resources.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_dns_zone_id: The resource id of the private dns zone.
        """
        pulumi.set(__self__, "record_sets", record_sets)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_dns_zone_id is not None:
            pulumi.set(__self__, "private_dns_zone_id", private_dns_zone_id)

    @property
    @pulumi.getter(name="recordSets")
    def record_sets(self) -> Sequence['outputs.RecordSetResponse']:
        """
        A collection of information regarding a recordSet, holding information to identify private resources.
        """
        return pulumi.get(self, "record_sets")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> Optional[str]:
        """
        The resource id of the private dns zone.
        """
        return pulumi.get(self, "private_dns_zone_id")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    PrivateEndpointConnection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkIdentifier":
            suggest = "link_identifier"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 link_identifier: str,
                 private_endpoint: 'outputs.PrivateEndpointResponse',
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None):
        """
        PrivateEndpointConnection resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str link_identifier: The consumer link id.
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param str type: The resource type.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "link_identifier", link_identifier)
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="linkIdentifier")
    def link_identifier(self) -> str:
        """
        The consumer link id.
        """
        return pulumi.get(self, "link_identifier")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> 'outputs.PrivateEndpointResponse':
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    Private endpoint resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "customDnsConfigs":
            suggest = "custom_dns_configs"
        elif key == "manualPrivateLinkServiceConnections":
            suggest = "manual_private_link_service_connections"
        elif key == "privateLinkServiceConnections":
            suggest = "private_link_service_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 name: str,
                 network_interfaces: Sequence['outputs.NetworkInterfaceResponse'],
                 provisioning_state: str,
                 type: str,
                 custom_dns_configs: Optional[Sequence['outputs.CustomDnsConfigPropertiesFormatResponse']] = None,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 manual_private_link_service_connections: Optional[Sequence['outputs.PrivateLinkServiceConnectionResponse']] = None,
                 private_link_service_connections: Optional[Sequence['outputs.PrivateLinkServiceConnectionResponse']] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Private endpoint resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str name: Resource name.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: An array of references to the network interfaces created for this private endpoint.
        :param str provisioning_state: The provisioning state of the private endpoint resource.
        :param str type: Resource type.
        :param Sequence['CustomDnsConfigPropertiesFormatResponse'] custom_dns_configs: An array of custom dns configurations.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Sequence['PrivateLinkServiceConnectionResponse'] manual_private_link_service_connections: A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
        :param Sequence['PrivateLinkServiceConnectionResponse'] private_link_service_connections: A grouping of information about the connection to the remote resource.
        :param 'SubnetResponse' subnet: The ID of the subnet from which the private IP will be allocated.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if custom_dns_configs is not None:
            pulumi.set(__self__, "custom_dns_configs", custom_dns_configs)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if manual_private_link_service_connections is not None:
            pulumi.set(__self__, "manual_private_link_service_connections", manual_private_link_service_connections)
        if private_link_service_connections is not None:
            pulumi.set(__self__, "private_link_service_connections", private_link_service_connections)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.NetworkInterfaceResponse']:
        """
        An array of references to the network interfaces created for this private endpoint.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="customDnsConfigs")
    def custom_dns_configs(self) -> Optional[Sequence['outputs.CustomDnsConfigPropertiesFormatResponse']]:
        """
        An array of custom dns configurations.
        """
        return pulumi.get(self, "custom_dns_configs")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="manualPrivateLinkServiceConnections")
    def manual_private_link_service_connections(self) -> Optional[Sequence['outputs.PrivateLinkServiceConnectionResponse']]:
        """
        A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
        """
        return pulumi.get(self, "manual_private_link_service_connections")

    @property
    @pulumi.getter(name="privateLinkServiceConnections")
    def private_link_service_connections(self) -> Optional[Sequence['outputs.PrivateLinkServiceConnectionResponse']]:
        """
        A grouping of information about the connection to the remote resource.
        """
        return pulumi.get(self, "private_link_service_connections")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        The ID of the subnet from which the private IP will be allocated.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class PrivateLinkServiceConnectionResponse(dict):
    """
    PrivateLinkServiceConnection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "groupIds":
            suggest = "group_ids"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "privateLinkServiceId":
            suggest = "private_link_service_id"
        elif key == "requestMessage":
            suggest = "request_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 group_ids: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None,
                 private_link_service_id: Optional[str] = None,
                 request_message: Optional[str] = None):
        """
        PrivateLinkServiceConnection resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the private link service connection resource.
        :param str type: The resource type.
        :param Sequence[str] group_ids: The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of read-only information about the state of the connection to the remote resource.
        :param str private_link_service_id: The resource id of private link service.
        :param str request_message: A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        if private_link_service_id is not None:
            pulumi.set(__self__, "private_link_service_id", private_link_service_id)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private link service connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[Sequence[str]]:
        """
        The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        A collection of read-only information about the state of the connection to the remote resource.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="privateLinkServiceId")
    def private_link_service_id(self) -> Optional[str]:
        """
        The resource id of private link service.
        """
        return pulumi.get(self, "private_link_service_id")

    @property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[str]:
        """
        A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
        """
        return pulumi.get(self, "request_message")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PrivateLinkServiceIpConfigurationResponse(dict):
    """
    The private link service ip configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAddressVersion":
            suggest = "private_ip_address_version"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceIpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceIpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceIpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 primary: Optional[bool] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_address_version: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None):
        """
        The private link service ip configuration.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the private link service IP configuration resource.
        :param str type: The resource type.
        :param str id: Resource ID.
        :param str name: The name of private link service ip configuration.
        :param bool primary: Whether the ip configuration is primary or not.
        :param str private_ip_address: The private IP address of the IP configuration.
        :param str private_ip_address_version: Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
        :param str private_ip_allocation_method: The private IP address allocation method.
        :param 'SubnetResponse' subnet: The reference to the subnet resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private link service IP configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of private link service ip configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Whether the ip configuration is primary or not.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[str]:
        """
        Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
        """
        return pulumi.get(self, "private_ip_address_version")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        The reference to the subnet resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class PrivateLinkServicePropertiesResponseAutoApproval(dict):
    """
    The auto-approval list of the private link service.
    """
    def __init__(__self__, *,
                 subscriptions: Optional[Sequence[str]] = None):
        """
        The auto-approval list of the private link service.
        :param Sequence[str] subscriptions: The list of subscriptions.
        """
        if subscriptions is not None:
            pulumi.set(__self__, "subscriptions", subscriptions)

    @property
    @pulumi.getter
    def subscriptions(self) -> Optional[Sequence[str]]:
        """
        The list of subscriptions.
        """
        return pulumi.get(self, "subscriptions")


@pulumi.output_type
class PrivateLinkServicePropertiesResponseVisibility(dict):
    """
    The visibility list of the private link service.
    """
    def __init__(__self__, *,
                 subscriptions: Optional[Sequence[str]] = None):
        """
        The visibility list of the private link service.
        :param Sequence[str] subscriptions: The list of subscriptions.
        """
        if subscriptions is not None:
            pulumi.set(__self__, "subscriptions", subscriptions)

    @property
    @pulumi.getter
    def subscriptions(self) -> Optional[Sequence[str]]:
        """
        The list of subscriptions.
        """
        return pulumi.get(self, "subscriptions")


@pulumi.output_type
class ProbeResponse(dict):
    """
    A load balancer probe.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "numberOfProbes":
            suggest = "number_of_probes"
        elif key == "requestPath":
            suggest = "request_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProbeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProbeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProbeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 load_balancing_rules: Sequence['outputs.SubResourceResponse'],
                 port: int,
                 protocol: str,
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 interval_in_seconds: Optional[int] = None,
                 name: Optional[str] = None,
                 number_of_probes: Optional[int] = None,
                 request_path: Optional[str] = None):
        """
        A load balancer probe.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param Sequence['SubResourceResponse'] load_balancing_rules: The load balancer rules that use this probe.
        :param int port: The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
        :param str protocol: The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
        :param str provisioning_state: The provisioning state of the probe resource.
        :param str type: Type of the resource.
        :param str id: Resource ID.
        :param int interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
        :param str name: The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource.
        :param int number_of_probes: The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
        :param str request_path: The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_probes is not None:
            pulumi.set(__self__, "number_of_probes", number_of_probes)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        The load balancer rules that use this probe.
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the probe resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[int]:
        """
        The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfProbes")
    def number_of_probes(self) -> Optional[int]:
        """
        The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
        """
        return pulumi.get(self, "number_of_probes")

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[str]:
        """
        The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        """
        return pulumi.get(self, "request_path")


@pulumi.output_type
class PropagatedRouteTableResponse(dict):
    """
    The list of RouteTables to advertise the routes to.
    """
    def __init__(__self__, *,
                 ids: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 labels: Optional[Sequence[str]] = None):
        """
        The list of RouteTables to advertise the routes to.
        :param Sequence['SubResourceResponse'] ids: The list of resource ids of all the RouteTables.
        :param Sequence[str] labels: The list of labels.
        """
        if ids is not None:
            pulumi.set(__self__, "ids", ids)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        The list of resource ids of all the RouteTables.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence[str]]:
        """
        The list of labels.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class ProtocolCustomSettingsFormatResponse(dict):
    """
    DDoS custom policy properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRateOverride":
            suggest = "source_rate_override"
        elif key == "triggerRateOverride":
            suggest = "trigger_rate_override"
        elif key == "triggerSensitivityOverride":
            suggest = "trigger_sensitivity_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProtocolCustomSettingsFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProtocolCustomSettingsFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProtocolCustomSettingsFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: Optional[str] = None,
                 source_rate_override: Optional[str] = None,
                 trigger_rate_override: Optional[str] = None,
                 trigger_sensitivity_override: Optional[str] = None):
        """
        DDoS custom policy properties.
        :param str protocol: The protocol for which the DDoS protection policy is being customized.
        :param str source_rate_override: The customized DDoS protection source rate.
        :param str trigger_rate_override: The customized DDoS protection trigger rate.
        :param str trigger_sensitivity_override: The customized DDoS protection trigger rate sensitivity degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t. normal traffic.
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_rate_override is not None:
            pulumi.set(__self__, "source_rate_override", source_rate_override)
        if trigger_rate_override is not None:
            pulumi.set(__self__, "trigger_rate_override", trigger_rate_override)
        if trigger_sensitivity_override is not None:
            pulumi.set(__self__, "trigger_sensitivity_override", trigger_sensitivity_override)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol for which the DDoS protection policy is being customized.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceRateOverride")
    def source_rate_override(self) -> Optional[str]:
        """
        The customized DDoS protection source rate.
        """
        return pulumi.get(self, "source_rate_override")

    @property
    @pulumi.getter(name="triggerRateOverride")
    def trigger_rate_override(self) -> Optional[str]:
        """
        The customized DDoS protection trigger rate.
        """
        return pulumi.get(self, "trigger_rate_override")

    @property
    @pulumi.getter(name="triggerSensitivityOverride")
    def trigger_sensitivity_override(self) -> Optional[str]:
        """
        The customized DDoS protection trigger rate sensitivity degrees. High: Trigger rate set with most sensitivity w.r.t. normal traffic. Default: Trigger rate set with moderate sensitivity w.r.t. normal traffic. Low: Trigger rate set with less sensitivity w.r.t. normal traffic. Relaxed: Trigger rate set with least sensitivity w.r.t. normal traffic.
        """
        return pulumi.get(self, "trigger_sensitivity_override")


@pulumi.output_type
class PublicIPAddressDnsSettingsResponse(dict):
    """
    Contains FQDN of the DNS record associated with the public IP address.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNameLabel":
            suggest = "domain_name_label"
        elif key == "reverseFqdn":
            suggest = "reverse_fqdn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicIPAddressDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicIPAddressDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicIPAddressDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name_label: Optional[str] = None,
                 fqdn: Optional[str] = None,
                 reverse_fqdn: Optional[str] = None):
        """
        Contains FQDN of the DNS record associated with the public IP address.
        :param str domain_name_label: The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        :param str fqdn: The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        :param str reverse_fqdn: The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        """
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if reverse_fqdn is not None:
            pulumi.set(__self__, "reverse_fqdn", reverse_fqdn)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[str]:
        """
        The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        """
        return pulumi.get(self, "domain_name_label")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="reverseFqdn")
    def reverse_fqdn(self) -> Optional[str]:
        """
        The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        """
        return pulumi.get(self, "reverse_fqdn")


@pulumi.output_type
class PublicIPAddressResponse(dict):
    """
    Public IP address resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "ddosSettings":
            suggest = "ddos_settings"
        elif key == "dnsSettings":
            suggest = "dns_settings"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipTags":
            suggest = "ip_tags"
        elif key == "publicIPAddressVersion":
            suggest = "public_ip_address_version"
        elif key == "publicIPAllocationMethod":
            suggest = "public_ip_allocation_method"
        elif key == "publicIPPrefix":
            suggest = "public_ip_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicIPAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicIPAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicIPAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 ip_configuration: 'outputs.IPConfigurationResponse',
                 name: str,
                 provisioning_state: str,
                 resource_guid: str,
                 type: str,
                 ddos_settings: Optional['outputs.DdosSettingsResponse'] = None,
                 dns_settings: Optional['outputs.PublicIPAddressDnsSettingsResponse'] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 ip_address: Optional[str] = None,
                 ip_tags: Optional[Sequence['outputs.IpTagResponse']] = None,
                 location: Optional[str] = None,
                 public_ip_address_version: Optional[str] = None,
                 public_ip_allocation_method: Optional[str] = None,
                 public_ip_prefix: Optional['outputs.SubResourceResponse'] = None,
                 sku: Optional['outputs.PublicIPAddressSkuResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        Public IP address resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'IPConfigurationResponse' ip_configuration: The IP configuration associated with the public IP address.
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the public IP address resource.
        :param str resource_guid: The resource GUID property of the public IP address resource.
        :param str type: Resource type.
        :param 'DdosSettingsResponse' ddos_settings: The DDoS protection custom policy associated with the public IP address.
        :param 'PublicIPAddressDnsSettingsResponse' dns_settings: The FQDN of the DNS record associated with the public IP address.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The idle timeout of the public IP address.
        :param str ip_address: The IP address associated with the public IP address resource.
        :param Sequence['IpTagResponse'] ip_tags: The list of tags associated with the public IP address.
        :param str location: Resource location.
        :param str public_ip_address_version: The public IP address version.
        :param str public_ip_allocation_method: The public IP address allocation method.
        :param 'SubResourceResponse' public_ip_prefix: The Public IP Prefix this Public IP Address should be allocated from.
        :param 'PublicIPAddressSkuResponse' sku: The public IP address SKU.
        :param Mapping[str, str] tags: Resource tags.
        :param Sequence[str] zones: A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "ip_configuration", ip_configuration)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "type", type)
        if ddos_settings is not None:
            pulumi.set(__self__, "ddos_settings", ddos_settings)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_tags is not None:
            pulumi.set(__self__, "ip_tags", ip_tags)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if public_ip_address_version is not None:
            pulumi.set(__self__, "public_ip_address_version", public_ip_address_version)
        if public_ip_allocation_method is not None:
            pulumi.set(__self__, "public_ip_allocation_method", public_ip_allocation_method)
        if public_ip_prefix is not None:
            pulumi.set(__self__, "public_ip_prefix", public_ip_prefix)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> 'outputs.IPConfigurationResponse':
        """
        The IP configuration associated with the public IP address.
        """
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the public IP address resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resource GUID property of the public IP address resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="ddosSettings")
    def ddos_settings(self) -> Optional['outputs.DdosSettingsResponse']:
        """
        The DDoS protection custom policy associated with the public IP address.
        """
        return pulumi.get(self, "ddos_settings")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional['outputs.PublicIPAddressDnsSettingsResponse']:
        """
        The FQDN of the DNS record associated with the public IP address.
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The idle timeout of the public IP address.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP address associated with the public IP address resource.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Optional[Sequence['outputs.IpTagResponse']]:
        """
        The list of tags associated with the public IP address.
        """
        return pulumi.get(self, "ip_tags")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="publicIPAddressVersion")
    def public_ip_address_version(self) -> Optional[str]:
        """
        The public IP address version.
        """
        return pulumi.get(self, "public_ip_address_version")

    @property
    @pulumi.getter(name="publicIPAllocationMethod")
    def public_ip_allocation_method(self) -> Optional[str]:
        """
        The public IP address allocation method.
        """
        return pulumi.get(self, "public_ip_allocation_method")

    @property
    @pulumi.getter(name="publicIPPrefix")
    def public_ip_prefix(self) -> Optional['outputs.SubResourceResponse']:
        """
        The Public IP Prefix this Public IP Address should be allocated from.
        """
        return pulumi.get(self, "public_ip_prefix")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.PublicIPAddressSkuResponse']:
        """
        The public IP address SKU.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class PublicIPAddressSkuResponse(dict):
    """
    SKU of a public IP address.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        SKU of a public IP address.
        :param str name: Name of a public IP address SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of a public IP address SKU.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PublicIPPrefixSkuResponse(dict):
    """
    SKU of a public IP prefix.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        SKU of a public IP prefix.
        :param str name: Name of a public IP prefix SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of a public IP prefix SKU.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RadiusServerResponse(dict):
    """
    Radius Server Settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "radiusServerAddress":
            suggest = "radius_server_address"
        elif key == "radiusServerScore":
            suggest = "radius_server_score"
        elif key == "radiusServerSecret":
            suggest = "radius_server_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RadiusServerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RadiusServerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RadiusServerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 radius_server_address: str,
                 radius_server_score: Optional[float] = None,
                 radius_server_secret: Optional[str] = None):
        """
        Radius Server Settings.
        :param str radius_server_address: The address of this radius server.
        :param float radius_server_score: The initial score assigned to this radius server.
        :param str radius_server_secret: The secret used for this radius server.
        """
        pulumi.set(__self__, "radius_server_address", radius_server_address)
        if radius_server_score is not None:
            pulumi.set(__self__, "radius_server_score", radius_server_score)
        if radius_server_secret is not None:
            pulumi.set(__self__, "radius_server_secret", radius_server_secret)

    @property
    @pulumi.getter(name="radiusServerAddress")
    def radius_server_address(self) -> str:
        """
        The address of this radius server.
        """
        return pulumi.get(self, "radius_server_address")

    @property
    @pulumi.getter(name="radiusServerScore")
    def radius_server_score(self) -> Optional[float]:
        """
        The initial score assigned to this radius server.
        """
        return pulumi.get(self, "radius_server_score")

    @property
    @pulumi.getter(name="radiusServerSecret")
    def radius_server_secret(self) -> Optional[str]:
        """
        The secret used for this radius server.
        """
        return pulumi.get(self, "radius_server_secret")


@pulumi.output_type
class RecordSetResponse(dict):
    """
    A collective group of information about the record set information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "ipAddresses":
            suggest = "ip_addresses"
        elif key == "recordSetName":
            suggest = "record_set_name"
        elif key == "recordType":
            suggest = "record_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 fqdn: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None,
                 record_set_name: Optional[str] = None,
                 record_type: Optional[str] = None,
                 ttl: Optional[int] = None):
        """
        A collective group of information about the record set information.
        :param str provisioning_state: The provisioning state of the recordset.
        :param str fqdn: Fqdn that resolves to private endpoint ip address.
        :param Sequence[str] ip_addresses: The private ip address of the private endpoint.
        :param str record_set_name: Recordset name.
        :param str record_type: Resource record type.
        :param int ttl: Recordset time to live.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if record_set_name is not None:
            pulumi.set(__self__, "record_set_name", record_set_name)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the recordset.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Fqdn that resolves to private endpoint ip address.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        The private ip address of the private endpoint.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="recordSetName")
    def record_set_name(self) -> Optional[str]:
        """
        Recordset name.
        """
        return pulumi.get(self, "record_set_name")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[str]:
        """
        Resource record type.
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[int]:
        """
        Recordset time to live.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class RedirectConfigurationResponse(dict):
    """
    Describes Redirect Route.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "customFragment":
            suggest = "custom_fragment"
        elif key == "customHost":
            suggest = "custom_host"
        elif key == "customPath":
            suggest = "custom_path"
        elif key == "customQueryString":
            suggest = "custom_query_string"
        elif key == "redirectProtocol":
            suggest = "redirect_protocol"
        elif key == "redirectType":
            suggest = "redirect_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedirectConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedirectConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedirectConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 custom_fragment: Optional[str] = None,
                 custom_host: Optional[str] = None,
                 custom_path: Optional[str] = None,
                 custom_query_string: Optional[str] = None,
                 redirect_protocol: Optional[str] = None,
                 redirect_type: Optional[str] = None):
        """
        Describes Redirect Route.
        :param str odata_type: 
               Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
        :param str custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        :param str custom_host: Host to redirect. Leave empty to use the incoming host as the destination host.
        :param str custom_path: The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        :param str custom_query_string: The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
        :param str redirect_protocol: The protocol of the destination to where the traffic is redirected
        :param str redirect_type: The redirect type the rule will use when redirecting traffic.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration')
        if custom_fragment is not None:
            pulumi.set(__self__, "custom_fragment", custom_fragment)
        if custom_host is not None:
            pulumi.set(__self__, "custom_host", custom_host)
        if custom_path is not None:
            pulumi.set(__self__, "custom_path", custom_path)
        if custom_query_string is not None:
            pulumi.set(__self__, "custom_query_string", custom_query_string)
        if redirect_protocol is not None:
            pulumi.set(__self__, "redirect_protocol", redirect_protocol)
        if redirect_type is not None:
            pulumi.set(__self__, "redirect_type", redirect_type)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """

        Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="customFragment")
    def custom_fragment(self) -> Optional[str]:
        """
        Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        """
        return pulumi.get(self, "custom_fragment")

    @property
    @pulumi.getter(name="customHost")
    def custom_host(self) -> Optional[str]:
        """
        Host to redirect. Leave empty to use the incoming host as the destination host.
        """
        return pulumi.get(self, "custom_host")

    @property
    @pulumi.getter(name="customPath")
    def custom_path(self) -> Optional[str]:
        """
        The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        """
        return pulumi.get(self, "custom_path")

    @property
    @pulumi.getter(name="customQueryString")
    def custom_query_string(self) -> Optional[str]:
        """
        The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
        """
        return pulumi.get(self, "custom_query_string")

    @property
    @pulumi.getter(name="redirectProtocol")
    def redirect_protocol(self) -> Optional[str]:
        """
        The protocol of the destination to where the traffic is redirected
        """
        return pulumi.get(self, "redirect_protocol")

    @property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> Optional[str]:
        """
        The redirect type the rule will use when redirecting traffic.
        """
        return pulumi.get(self, "redirect_type")


@pulumi.output_type
class ReferencedPublicIpAddressResponse(dict):
    """
    Reference to a public IP address.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Reference to a public IP address.
        :param str id: The PublicIPAddress Reference.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The PublicIPAddress Reference.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ResourceNavigationLinkResponse(dict):
    """
    ResourceNavigationLink resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "linkedResourceType":
            suggest = "linked_resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceNavigationLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceNavigationLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceNavigationLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 provisioning_state: str,
                 type: str,
                 link: Optional[str] = None,
                 linked_resource_type: Optional[str] = None,
                 name: Optional[str] = None):
        """
        ResourceNavigationLink resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str provisioning_state: The provisioning state of the resource navigation link resource.
        :param str type: Resource type.
        :param str link: Link to the external resource.
        :param str linked_resource_type: Resource type of the linked resource.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if linked_resource_type is not None:
            pulumi.set(__self__, "linked_resource_type", linked_resource_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource navigation link resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Link to the external resource.
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter(name="linkedResourceType")
    def linked_resource_type(self) -> Optional[str]:
        """
        Resource type of the linked resource.
        """
        return pulumi.get(self, "linked_resource_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RetentionPolicyParametersResponse(dict):
    """
    Parameters that define the retention policy for flow log.
    """
    def __init__(__self__, *,
                 days: Optional[int] = None,
                 enabled: Optional[bool] = None):
        """
        Parameters that define the retention policy for flow log.
        :param int days: Number of days to retain flow log records.
        :param bool enabled: Flag to enable/disable retention.
        """
        if days is None:
            days = 0
        if days is not None:
            pulumi.set(__self__, "days", days)
        if enabled is None:
            enabled = False
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Number of days to retain flow log records.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Flag to enable/disable retention.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class RouteFilterRuleResponse(dict):
    """
    Route Filter Rule Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "routeFilterRuleType":
            suggest = "route_filter_rule_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteFilterRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteFilterRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteFilterRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: str,
                 communities: Sequence[str],
                 etag: str,
                 provisioning_state: str,
                 route_filter_rule_type: str,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Route Filter Rule Resource.
        :param str access: The access type of the rule.
        :param Sequence[str] communities: The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the route filter rule resource.
        :param str route_filter_rule_type: The rule type of the rule.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "communities", communities)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "route_filter_rule_type", route_filter_rule_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        The access type of the rule.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def communities(self) -> Sequence[str]:
        """
        The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
        """
        return pulumi.get(self, "communities")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the route filter rule resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="routeFilterRuleType")
    def route_filter_rule_type(self) -> str:
        """
        The rule type of the rule.
        """
        return pulumi.get(self, "route_filter_rule_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RouteResponse(dict):
    """
    Route resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextHopType":
            suggest = "next_hop_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "nextHopIpAddress":
            suggest = "next_hop_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 next_hop_type: str,
                 provisioning_state: str,
                 address_prefix: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 next_hop_ip_address: Optional[str] = None):
        """
        Route resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str next_hop_type: The type of Azure hop the packet should be sent to.
        :param str provisioning_state: The provisioning state of the route resource.
        :param str address_prefix: The destination CIDR to which the route applies.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> str:
        """
        The type of Azure hop the packet should be sent to.
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the route resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        The destination CIDR to which the route applies.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[str]:
        """
        The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        return pulumi.get(self, "next_hop_ip_address")


@pulumi.output_type
class RouteTableResponse(dict):
    """
    Route table resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "disableBgpRoutePropagation":
            suggest = "disable_bgp_route_propagation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 name: str,
                 provisioning_state: str,
                 subnets: Sequence['outputs.SubnetResponse'],
                 type: str,
                 disable_bgp_route_propagation: Optional[bool] = None,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 routes: Optional[Sequence['outputs.RouteResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Route table resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the route table resource.
        :param Sequence['SubnetResponse'] subnets: A collection of references to subnets.
        :param str type: Resource type.
        :param bool disable_bgp_route_propagation: Whether to disable the routes learned by BGP on that route table. True means disable.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Sequence['RouteResponse'] routes: Collection of routes contained within a route table.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if disable_bgp_route_propagation is not None:
            pulumi.set(__self__, "disable_bgp_route_propagation", disable_bgp_route_propagation)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the route table resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.SubnetResponse']:
        """
        A collection of references to subnets.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="disableBgpRoutePropagation")
    def disable_bgp_route_propagation(self) -> Optional[bool]:
        """
        Whether to disable the routes learned by BGP on that route table. True means disable.
        """
        return pulumi.get(self, "disable_bgp_route_propagation")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.RouteResponse']]:
        """
        Collection of routes contained within a route table.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class RoutingConfigurationResponse(dict):
    """
    Routing Configuration indicating the associated and propagated route tables for this connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "associatedRouteTable":
            suggest = "associated_route_table"
        elif key == "propagatedRouteTables":
            suggest = "propagated_route_tables"
        elif key == "vnetRoutes":
            suggest = "vnet_routes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 associated_route_table: Optional['outputs.SubResourceResponse'] = None,
                 propagated_route_tables: Optional['outputs.PropagatedRouteTableResponse'] = None,
                 vnet_routes: Optional['outputs.VnetRouteResponse'] = None):
        """
        Routing Configuration indicating the associated and propagated route tables for this connection.
        :param 'SubResourceResponse' associated_route_table: The resource id RouteTable associated with this RoutingConfiguration.
        :param 'PropagatedRouteTableResponse' propagated_route_tables: The list of RouteTables to advertise the routes to.
        :param 'VnetRouteResponse' vnet_routes: List of routes that control routing from VirtualHub into a virtual network connection.
        """
        if associated_route_table is not None:
            pulumi.set(__self__, "associated_route_table", associated_route_table)
        if propagated_route_tables is not None:
            pulumi.set(__self__, "propagated_route_tables", propagated_route_tables)
        if vnet_routes is not None:
            pulumi.set(__self__, "vnet_routes", vnet_routes)

    @property
    @pulumi.getter(name="associatedRouteTable")
    def associated_route_table(self) -> Optional['outputs.SubResourceResponse']:
        """
        The resource id RouteTable associated with this RoutingConfiguration.
        """
        return pulumi.get(self, "associated_route_table")

    @property
    @pulumi.getter(name="propagatedRouteTables")
    def propagated_route_tables(self) -> Optional['outputs.PropagatedRouteTableResponse']:
        """
        The list of RouteTables to advertise the routes to.
        """
        return pulumi.get(self, "propagated_route_tables")

    @property
    @pulumi.getter(name="vnetRoutes")
    def vnet_routes(self) -> Optional['outputs.VnetRouteResponse']:
        """
        List of routes that control routing from VirtualHub into a virtual network connection.
        """
        return pulumi.get(self, "vnet_routes")


@pulumi.output_type
class RoutingRuleResponse(dict):
    """
    A routing rule represents a specification for traffic to treat and where to send it, along with health probe information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceState":
            suggest = "resource_state"
        elif key == "acceptedProtocols":
            suggest = "accepted_protocols"
        elif key == "enabledState":
            suggest = "enabled_state"
        elif key == "frontendEndpoints":
            suggest = "frontend_endpoints"
        elif key == "patternsToMatch":
            suggest = "patterns_to_match"
        elif key == "routeConfiguration":
            suggest = "route_configuration"
        elif key == "rulesEngine":
            suggest = "rules_engine"
        elif key == "webApplicationFirewallPolicyLink":
            suggest = "web_application_firewall_policy_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_state: str,
                 type: str,
                 accepted_protocols: Optional[Sequence[str]] = None,
                 enabled_state: Optional[str] = None,
                 frontend_endpoints: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 patterns_to_match: Optional[Sequence[str]] = None,
                 route_configuration: Optional[Any] = None,
                 rules_engine: Optional['outputs.SubResourceResponse'] = None,
                 web_application_firewall_policy_link: Optional['outputs.RoutingRuleUpdateParametersResponseWebApplicationFirewallPolicyLink'] = None):
        """
        A routing rule represents a specification for traffic to treat and where to send it, along with health probe information.
        :param str resource_state: Resource status.
        :param str type: Resource type.
        :param Sequence[str] accepted_protocols: Protocol schemes to match for this rule
        :param str enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
        :param Sequence['SubResourceResponse'] frontend_endpoints: Frontend endpoints associated with this rule
        :param str id: Resource ID.
        :param str name: Resource name.
        :param Sequence[str] patterns_to_match: The route patterns of the rule.
        :param Union['ForwardingConfigurationResponse', 'RedirectConfigurationResponse'] route_configuration: A reference to the routing configuration.
        :param 'SubResourceResponse' rules_engine: A reference to a specific Rules Engine Configuration to apply to this route.
        :param 'RoutingRuleUpdateParametersResponseWebApplicationFirewallPolicyLink' web_application_firewall_policy_link: Defines the Web Application Firewall policy for each routing rule (if applicable)
        """
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "type", type)
        if accepted_protocols is not None:
            pulumi.set(__self__, "accepted_protocols", accepted_protocols)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if frontend_endpoints is not None:
            pulumi.set(__self__, "frontend_endpoints", frontend_endpoints)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if patterns_to_match is not None:
            pulumi.set(__self__, "patterns_to_match", patterns_to_match)
        if route_configuration is not None:
            pulumi.set(__self__, "route_configuration", route_configuration)
        if rules_engine is not None:
            pulumi.set(__self__, "rules_engine", rules_engine)
        if web_application_firewall_policy_link is not None:
            pulumi.set(__self__, "web_application_firewall_policy_link", web_application_firewall_policy_link)

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Resource status.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="acceptedProtocols")
    def accepted_protocols(self) -> Optional[Sequence[str]]:
        """
        Protocol schemes to match for this rule
        """
        return pulumi.get(self, "accepted_protocols")

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[str]:
        """
        Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "enabled_state")

    @property
    @pulumi.getter(name="frontendEndpoints")
    def frontend_endpoints(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Frontend endpoints associated with this rule
        """
        return pulumi.get(self, "frontend_endpoints")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="patternsToMatch")
    def patterns_to_match(self) -> Optional[Sequence[str]]:
        """
        The route patterns of the rule.
        """
        return pulumi.get(self, "patterns_to_match")

    @property
    @pulumi.getter(name="routeConfiguration")
    def route_configuration(self) -> Optional[Any]:
        """
        A reference to the routing configuration.
        """
        return pulumi.get(self, "route_configuration")

    @property
    @pulumi.getter(name="rulesEngine")
    def rules_engine(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to a specific Rules Engine Configuration to apply to this route.
        """
        return pulumi.get(self, "rules_engine")

    @property
    @pulumi.getter(name="webApplicationFirewallPolicyLink")
    def web_application_firewall_policy_link(self) -> Optional['outputs.RoutingRuleUpdateParametersResponseWebApplicationFirewallPolicyLink']:
        """
        Defines the Web Application Firewall policy for each routing rule (if applicable)
        """
        return pulumi.get(self, "web_application_firewall_policy_link")


@pulumi.output_type
class RoutingRuleUpdateParametersResponseWebApplicationFirewallPolicyLink(dict):
    """
    Defines the Web Application Firewall policy for each routing rule (if applicable)
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Defines the Web Application Firewall policy for each routing rule (if applicable)
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class RulesEngineActionResponse(dict):
    """
    One or more actions that will execute, modifying the request and/or response.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestHeaderActions":
            suggest = "request_header_actions"
        elif key == "responseHeaderActions":
            suggest = "response_header_actions"
        elif key == "routeConfigurationOverride":
            suggest = "route_configuration_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulesEngineActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulesEngineActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulesEngineActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_header_actions: Optional[Sequence['outputs.HeaderActionResponse']] = None,
                 response_header_actions: Optional[Sequence['outputs.HeaderActionResponse']] = None,
                 route_configuration_override: Optional[Any] = None):
        """
        One or more actions that will execute, modifying the request and/or response.
        :param Sequence['HeaderActionResponse'] request_header_actions: A list of header actions to apply from the request from AFD to the origin.
        :param Sequence['HeaderActionResponse'] response_header_actions: A list of header actions to apply from the response from AFD to the client.
        :param Union['ForwardingConfigurationResponse', 'RedirectConfigurationResponse'] route_configuration_override: Override the route configuration.
        """
        if request_header_actions is not None:
            pulumi.set(__self__, "request_header_actions", request_header_actions)
        if response_header_actions is not None:
            pulumi.set(__self__, "response_header_actions", response_header_actions)
        if route_configuration_override is not None:
            pulumi.set(__self__, "route_configuration_override", route_configuration_override)

    @property
    @pulumi.getter(name="requestHeaderActions")
    def request_header_actions(self) -> Optional[Sequence['outputs.HeaderActionResponse']]:
        """
        A list of header actions to apply from the request from AFD to the origin.
        """
        return pulumi.get(self, "request_header_actions")

    @property
    @pulumi.getter(name="responseHeaderActions")
    def response_header_actions(self) -> Optional[Sequence['outputs.HeaderActionResponse']]:
        """
        A list of header actions to apply from the response from AFD to the client.
        """
        return pulumi.get(self, "response_header_actions")

    @property
    @pulumi.getter(name="routeConfigurationOverride")
    def route_configuration_override(self) -> Optional[Any]:
        """
        Override the route configuration.
        """
        return pulumi.get(self, "route_configuration_override")


@pulumi.output_type
class RulesEngineMatchConditionResponse(dict):
    """
    Define a match condition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rulesEngineMatchValue":
            suggest = "rules_engine_match_value"
        elif key == "rulesEngineMatchVariable":
            suggest = "rules_engine_match_variable"
        elif key == "rulesEngineOperator":
            suggest = "rules_engine_operator"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulesEngineMatchConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulesEngineMatchConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulesEngineMatchConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rules_engine_match_value: Sequence[str],
                 rules_engine_match_variable: str,
                 rules_engine_operator: str,
                 negate_condition: Optional[bool] = None,
                 selector: Optional[str] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Define a match condition
        :param Sequence[str] rules_engine_match_value: Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        :param str rules_engine_match_variable: Match Variable
        :param str rules_engine_operator: Describes operator to apply to the match condition.
        :param bool negate_condition: Describes if this is negate condition or not
        :param str selector: Name of selector in RequestHeader or RequestBody to be matched
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "rules_engine_match_value", rules_engine_match_value)
        pulumi.set(__self__, "rules_engine_match_variable", rules_engine_match_variable)
        pulumi.set(__self__, "rules_engine_operator", rules_engine_operator)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="rulesEngineMatchValue")
    def rules_engine_match_value(self) -> Sequence[str]:
        """
        Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        """
        return pulumi.get(self, "rules_engine_match_value")

    @property
    @pulumi.getter(name="rulesEngineMatchVariable")
    def rules_engine_match_variable(self) -> str:
        """
        Match Variable
        """
        return pulumi.get(self, "rules_engine_match_variable")

    @property
    @pulumi.getter(name="rulesEngineOperator")
    def rules_engine_operator(self) -> str:
        """
        Describes operator to apply to the match condition.
        """
        return pulumi.get(self, "rules_engine_operator")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        """
        Name of selector in RequestHeader or RequestBody to be matched
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class RulesEngineResponse(dict):
    """
    A rules engine configuration containing a list of rules that will run to modify the runtime behavior of the request and response.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceState":
            suggest = "resource_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulesEngineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulesEngineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulesEngineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 resource_state: str,
                 type: str,
                 rules: Optional[Sequence['outputs.RulesEngineRuleResponse']] = None):
        """
        A rules engine configuration containing a list of rules that will run to modify the runtime behavior of the request and response.
        :param str id: Resource ID.
        :param str name: Resource name.
        :param str resource_state: Resource status.
        :param str type: Resource type.
        :param Sequence['RulesEngineRuleResponse'] rules: A list of rules that define a particular Rules Engine Configuration.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_state", resource_state)
        pulumi.set(__self__, "type", type)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceState")
    def resource_state(self) -> str:
        """
        Resource status.
        """
        return pulumi.get(self, "resource_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.RulesEngineRuleResponse']]:
        """
        A list of rules that define a particular Rules Engine Configuration.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class RulesEngineRuleResponse(dict):
    """
    Contains a list of match conditions, and an action on how to modify the request/response. If multiple rules match, the actions from one rule that conflict with a previous rule overwrite for a singular action, or append in the case of headers manipulation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchConditions":
            suggest = "match_conditions"
        elif key == "matchProcessingBehavior":
            suggest = "match_processing_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulesEngineRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulesEngineRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulesEngineRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'outputs.RulesEngineActionResponse',
                 name: str,
                 priority: int,
                 match_conditions: Optional[Sequence['outputs.RulesEngineMatchConditionResponse']] = None,
                 match_processing_behavior: Optional[str] = None):
        """
        Contains a list of match conditions, and an action on how to modify the request/response. If multiple rules match, the actions from one rule that conflict with a previous rule overwrite for a singular action, or append in the case of headers manipulation.
        :param 'RulesEngineActionResponse' action: Actions to perform on the request and response if all of the match conditions are met.
        :param str name: A name to refer to this specific rule.
        :param int priority: A priority assigned to this rule. 
        :param Sequence['RulesEngineMatchConditionResponse'] match_conditions: A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
        :param str match_processing_behavior: If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        if match_conditions is not None:
            pulumi.set(__self__, "match_conditions", match_conditions)
        if match_processing_behavior is not None:
            pulumi.set(__self__, "match_processing_behavior", match_processing_behavior)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.RulesEngineActionResponse':
        """
        Actions to perform on the request and response if all of the match conditions are met.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name to refer to this specific rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        A priority assigned to this rule. 
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Optional[Sequence['outputs.RulesEngineMatchConditionResponse']]:
        """
        A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
        """
        return pulumi.get(self, "match_conditions")

    @property
    @pulumi.getter(name="matchProcessingBehavior")
    def match_processing_behavior(self) -> Optional[str]:
        """
        If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
        """
        return pulumi.get(self, "match_processing_behavior")


@pulumi.output_type
class SecurityRuleResponse(dict):
    """
    Network security rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "destinationAddressPrefix":
            suggest = "destination_address_prefix"
        elif key == "destinationAddressPrefixes":
            suggest = "destination_address_prefixes"
        elif key == "destinationApplicationSecurityGroups":
            suggest = "destination_application_security_groups"
        elif key == "destinationPortRange":
            suggest = "destination_port_range"
        elif key == "destinationPortRanges":
            suggest = "destination_port_ranges"
        elif key == "sourceAddressPrefix":
            suggest = "source_address_prefix"
        elif key == "sourceAddressPrefixes":
            suggest = "source_address_prefixes"
        elif key == "sourceApplicationSecurityGroups":
            suggest = "source_application_security_groups"
        elif key == "sourcePortRange":
            suggest = "source_port_range"
        elif key == "sourcePortRanges":
            suggest = "source_port_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: str,
                 direction: str,
                 etag: str,
                 protocol: str,
                 provisioning_state: str,
                 description: Optional[str] = None,
                 destination_address_prefix: Optional[str] = None,
                 destination_address_prefixes: Optional[Sequence[str]] = None,
                 destination_application_security_groups: Optional[Sequence['outputs.ApplicationSecurityGroupResponse']] = None,
                 destination_port_range: Optional[str] = None,
                 destination_port_ranges: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 source_address_prefix: Optional[str] = None,
                 source_address_prefixes: Optional[Sequence[str]] = None,
                 source_application_security_groups: Optional[Sequence['outputs.ApplicationSecurityGroupResponse']] = None,
                 source_port_range: Optional[str] = None,
                 source_port_ranges: Optional[Sequence[str]] = None):
        """
        Network security rule.
        :param str access: The network traffic is allowed or denied.
        :param str direction: The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str protocol: Network protocol this rule applies to.
        :param str provisioning_state: The provisioning state of the security rule resource.
        :param str description: A description for this rule. Restricted to 140 chars.
        :param str destination_address_prefix: The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        :param Sequence[str] destination_address_prefixes: The destination address prefixes. CIDR or destination IP ranges.
        :param Sequence['ApplicationSecurityGroupResponse'] destination_application_security_groups: The application security group specified as destination.
        :param str destination_port_range: The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        :param Sequence[str] destination_port_ranges: The destination port ranges.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int priority: The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param str source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
        :param Sequence[str] source_address_prefixes: The CIDR or source IP ranges.
        :param Sequence['ApplicationSecurityGroupResponse'] source_application_security_groups: The application security group specified as source.
        :param str source_port_range: The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        :param Sequence[str] source_port_ranges: The source port ranges.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address_prefix is not None:
            pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        if destination_address_prefixes is not None:
            pulumi.set(__self__, "destination_address_prefixes", destination_address_prefixes)
        if destination_application_security_groups is not None:
            pulumi.set(__self__, "destination_application_security_groups", destination_application_security_groups)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if destination_port_ranges is not None:
            pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_address_prefix is not None:
            pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_address_prefixes is not None:
            pulumi.set(__self__, "source_address_prefixes", source_address_prefixes)
        if source_application_security_groups is not None:
            pulumi.set(__self__, "source_application_security_groups", source_application_security_groups)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        The network traffic is allowed or denied.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Network protocol this rule applies to.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the security rule resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> Optional[str]:
        """
        The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        """
        return pulumi.get(self, "destination_address_prefix")

    @property
    @pulumi.getter(name="destinationAddressPrefixes")
    def destination_address_prefixes(self) -> Optional[Sequence[str]]:
        """
        The destination address prefixes. CIDR or destination IP ranges.
        """
        return pulumi.get(self, "destination_address_prefixes")

    @property
    @pulumi.getter(name="destinationApplicationSecurityGroups")
    def destination_application_security_groups(self) -> Optional[Sequence['outputs.ApplicationSecurityGroupResponse']]:
        """
        The application security group specified as destination.
        """
        return pulumi.get(self, "destination_application_security_groups")

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[str]:
        """
        The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        return pulumi.get(self, "destination_port_range")

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Optional[Sequence[str]]:
        """
        The destination port ranges.
        """
        return pulumi.get(self, "destination_port_ranges")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> Optional[str]:
        """
        The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.
        """
        return pulumi.get(self, "source_address_prefix")

    @property
    @pulumi.getter(name="sourceAddressPrefixes")
    def source_address_prefixes(self) -> Optional[Sequence[str]]:
        """
        The CIDR or source IP ranges.
        """
        return pulumi.get(self, "source_address_prefixes")

    @property
    @pulumi.getter(name="sourceApplicationSecurityGroups")
    def source_application_security_groups(self) -> Optional[Sequence['outputs.ApplicationSecurityGroupResponse']]:
        """
        The application security group specified as source.
        """
        return pulumi.get(self, "source_application_security_groups")

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[str]:
        """
        The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        return pulumi.get(self, "source_port_range")

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[Sequence[str]]:
        """
        The source port ranges.
        """
        return pulumi.get(self, "source_port_ranges")


@pulumi.output_type
class ServiceAssociationLinkResponse(dict):
    """
    ServiceAssociationLink resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "allowDelete":
            suggest = "allow_delete"
        elif key == "linkedResourceType":
            suggest = "linked_resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAssociationLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAssociationLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAssociationLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 allow_delete: Optional[bool] = None,
                 id: Optional[str] = None,
                 link: Optional[str] = None,
                 linked_resource_type: Optional[str] = None,
                 locations: Optional[Sequence[str]] = None,
                 name: Optional[str] = None):
        """
        ServiceAssociationLink resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the service association link resource.
        :param str type: Resource type.
        :param bool allow_delete: If true, the resource can be deleted.
        :param str id: Resource ID.
        :param str link: Link to the external resource.
        :param str linked_resource_type: Resource type of the linked resource.
        :param Sequence[str] locations: A list of locations.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if allow_delete is not None:
            pulumi.set(__self__, "allow_delete", allow_delete)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if linked_resource_type is not None:
            pulumi.set(__self__, "linked_resource_type", linked_resource_type)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the service association link resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allowDelete")
    def allow_delete(self) -> Optional[bool]:
        """
        If true, the resource can be deleted.
        """
        return pulumi.get(self, "allow_delete")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Link to the external resource.
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter(name="linkedResourceType")
    def linked_resource_type(self) -> Optional[str]:
        """
        Resource type of the linked resource.
        """
        return pulumi.get(self, "linked_resource_type")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        """
        A list of locations.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceEndpointPolicyDefinitionResponse(dict):
    """
    Service Endpoint policy definitions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "serviceResources":
            suggest = "service_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointPolicyDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointPolicyDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointPolicyDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 description: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 service: Optional[str] = None,
                 service_resources: Optional[Sequence[str]] = None):
        """
        Service Endpoint policy definitions.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the service endpoint policy definition resource.
        :param str description: A description for this rule. Restricted to 140 chars.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str service: Service endpoint name.
        :param Sequence[str] service_resources: A list of service resources.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_resources is not None:
            pulumi.set(__self__, "service_resources", service_resources)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the service endpoint policy definition resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> Optional[str]:
        """
        Service endpoint name.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceResources")
    def service_resources(self) -> Optional[Sequence[str]]:
        """
        A list of service resources.
        """
        return pulumi.get(self, "service_resources")


@pulumi.output_type
class ServiceEndpointPolicyResponse(dict):
    """
    Service End point policy resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "serviceEndpointPolicyDefinitions":
            suggest = "service_endpoint_policy_definitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 name: str,
                 provisioning_state: str,
                 resource_guid: str,
                 subnets: Sequence['outputs.SubnetResponse'],
                 type: str,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 service_endpoint_policy_definitions: Optional[Sequence['outputs.ServiceEndpointPolicyDefinitionResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Service End point policy resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the service endpoint policy resource.
        :param str resource_guid: The resource GUID property of the service endpoint policy resource.
        :param Sequence['SubnetResponse'] subnets: A collection of references to subnets.
        :param str type: Resource type.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Sequence['ServiceEndpointPolicyDefinitionResponse'] service_endpoint_policy_definitions: A collection of service endpoint policy definitions of the service endpoint policy.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if service_endpoint_policy_definitions is not None:
            pulumi.set(__self__, "service_endpoint_policy_definitions", service_endpoint_policy_definitions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the service endpoint policy resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resource GUID property of the service endpoint policy resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.SubnetResponse']:
        """
        A collection of references to subnets.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="serviceEndpointPolicyDefinitions")
    def service_endpoint_policy_definitions(self) -> Optional[Sequence['outputs.ServiceEndpointPolicyDefinitionResponse']]:
        """
        A collection of service endpoint policy definitions of the service endpoint policy.
        """
        return pulumi.get(self, "service_endpoint_policy_definitions")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ServiceEndpointPropertiesFormatResponse(dict):
    """
    The service endpoint properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointPropertiesFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointPropertiesFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointPropertiesFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 locations: Optional[Sequence[str]] = None,
                 service: Optional[str] = None):
        """
        The service endpoint properties.
        :param str provisioning_state: The provisioning state of the service endpoint resource.
        :param Sequence[str] locations: A list of locations.
        :param str service: The type of the endpoint service.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the service endpoint resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        """
        A list of locations.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def service(self) -> Optional[str]:
        """
        The type of the endpoint service.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class StaticRouteResponse(dict):
    """
    List of all Static Routes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefixes":
            suggest = "address_prefixes"
        elif key == "nextHopIpAddress":
            suggest = "next_hop_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticRouteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticRouteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticRouteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefixes: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 next_hop_ip_address: Optional[str] = None):
        """
        List of all Static Routes.
        :param Sequence[str] address_prefixes: List of all address prefixes.
        :param str name: The name of the StaticRoute that is unique within a VnetRoute.
        :param str next_hop_ip_address: The ip address of the next hop.
        """
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        List of all address prefixes.
        """
        return pulumi.get(self, "address_prefixes")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the StaticRoute that is unique within a VnetRoute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[str]:
        """
        The ip address of the next hop.
        """
        return pulumi.get(self, "next_hop_ip_address")


@pulumi.output_type
class SubResourceResponse(dict):
    """
    Reference to another subresource.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Reference to another subresource.
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SubnetResponse(dict):
    """
    Subnet in a virtual network resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfigurationProfiles":
            suggest = "ip_configuration_profiles"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "privateEndpoints":
            suggest = "private_endpoints"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceNavigationLinks":
            suggest = "resource_navigation_links"
        elif key == "serviceAssociationLinks":
            suggest = "service_association_links"
        elif key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "addressPrefixes":
            suggest = "address_prefixes"
        elif key == "ipAllocations":
            suggest = "ip_allocations"
        elif key == "natGateway":
            suggest = "nat_gateway"
        elif key == "networkSecurityGroup":
            suggest = "network_security_group"
        elif key == "privateEndpointNetworkPolicies":
            suggest = "private_endpoint_network_policies"
        elif key == "privateLinkServiceNetworkPolicies":
            suggest = "private_link_service_network_policies"
        elif key == "routeTable":
            suggest = "route_table"
        elif key == "serviceEndpointPolicies":
            suggest = "service_endpoint_policies"
        elif key == "serviceEndpoints":
            suggest = "service_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 ip_configuration_profiles: Sequence['outputs.IPConfigurationProfileResponse'],
                 ip_configurations: Sequence['outputs.IPConfigurationResponse'],
                 private_endpoints: Sequence['outputs.PrivateEndpointResponse'],
                 provisioning_state: str,
                 purpose: str,
                 resource_navigation_links: Sequence['outputs.ResourceNavigationLinkResponse'],
                 service_association_links: Sequence['outputs.ServiceAssociationLinkResponse'],
                 address_prefix: Optional[str] = None,
                 address_prefixes: Optional[Sequence[str]] = None,
                 delegations: Optional[Sequence['outputs.DelegationResponse']] = None,
                 id: Optional[str] = None,
                 ip_allocations: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 name: Optional[str] = None,
                 nat_gateway: Optional['outputs.SubResourceResponse'] = None,
                 network_security_group: Optional['outputs.NetworkSecurityGroupResponse'] = None,
                 private_endpoint_network_policies: Optional[str] = None,
                 private_link_service_network_policies: Optional[str] = None,
                 route_table: Optional['outputs.RouteTableResponse'] = None,
                 service_endpoint_policies: Optional[Sequence['outputs.ServiceEndpointPolicyResponse']] = None,
                 service_endpoints: Optional[Sequence['outputs.ServiceEndpointPropertiesFormatResponse']] = None):
        """
        Subnet in a virtual network resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param Sequence['IPConfigurationProfileResponse'] ip_configuration_profiles: Array of IP configuration profiles which reference this subnet.
        :param Sequence['IPConfigurationResponse'] ip_configurations: An array of references to the network interface IP configurations using subnet.
        :param Sequence['PrivateEndpointResponse'] private_endpoints: An array of references to private endpoints.
        :param str provisioning_state: The provisioning state of the subnet resource.
        :param str purpose: A read-only string identifying the intention of use for this subnet based on delegations and other user-defined properties.
        :param Sequence['ResourceNavigationLinkResponse'] resource_navigation_links: An array of references to the external resources using subnet.
        :param Sequence['ServiceAssociationLinkResponse'] service_association_links: An array of references to services injecting into this subnet.
        :param str address_prefix: The address prefix for the subnet.
        :param Sequence[str] address_prefixes: List of address prefixes for the subnet.
        :param Sequence['DelegationResponse'] delegations: An array of references to the delegations on the subnet.
        :param str id: Resource ID.
        :param Sequence['SubResourceResponse'] ip_allocations: Array of IpAllocation which reference this subnet.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'SubResourceResponse' nat_gateway: Nat gateway associated with this subnet.
        :param 'NetworkSecurityGroupResponse' network_security_group: The reference to the NetworkSecurityGroup resource.
        :param str private_endpoint_network_policies: Enable or Disable apply network policies on private end point in the subnet.
        :param str private_link_service_network_policies: Enable or Disable apply network policies on private link service in the subnet.
        :param 'RouteTableResponse' route_table: The reference to the RouteTable resource.
        :param Sequence['ServiceEndpointPolicyResponse'] service_endpoint_policies: An array of service endpoint policies.
        :param Sequence['ServiceEndpointPropertiesFormatResponse'] service_endpoints: An array of service endpoints.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "ip_configuration_profiles", ip_configuration_profiles)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "private_endpoints", private_endpoints)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "purpose", purpose)
        pulumi.set(__self__, "resource_navigation_links", resource_navigation_links)
        pulumi.set(__self__, "service_association_links", service_association_links)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if delegations is not None:
            pulumi.set(__self__, "delegations", delegations)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_allocations is not None:
            pulumi.set(__self__, "ip_allocations", ip_allocations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_gateway is not None:
            pulumi.set(__self__, "nat_gateway", nat_gateway)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if private_endpoint_network_policies is not None:
            pulumi.set(__self__, "private_endpoint_network_policies", private_endpoint_network_policies)
        if private_link_service_network_policies is not None:
            pulumi.set(__self__, "private_link_service_network_policies", private_link_service_network_policies)
        if route_table is not None:
            pulumi.set(__self__, "route_table", route_table)
        if service_endpoint_policies is not None:
            pulumi.set(__self__, "service_endpoint_policies", service_endpoint_policies)
        if service_endpoints is not None:
            pulumi.set(__self__, "service_endpoints", service_endpoints)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="ipConfigurationProfiles")
    def ip_configuration_profiles(self) -> Sequence['outputs.IPConfigurationProfileResponse']:
        """
        Array of IP configuration profiles which reference this subnet.
        """
        return pulumi.get(self, "ip_configuration_profiles")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.IPConfigurationResponse']:
        """
        An array of references to the network interface IP configurations using subnet.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Sequence['outputs.PrivateEndpointResponse']:
        """
        An array of references to private endpoints.
        """
        return pulumi.get(self, "private_endpoints")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the subnet resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def purpose(self) -> str:
        """
        A read-only string identifying the intention of use for this subnet based on delegations and other user-defined properties.
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter(name="resourceNavigationLinks")
    def resource_navigation_links(self) -> Sequence['outputs.ResourceNavigationLinkResponse']:
        """
        An array of references to the external resources using subnet.
        """
        return pulumi.get(self, "resource_navigation_links")

    @property
    @pulumi.getter(name="serviceAssociationLinks")
    def service_association_links(self) -> Sequence['outputs.ServiceAssociationLinkResponse']:
        """
        An array of references to services injecting into this subnet.
        """
        return pulumi.get(self, "service_association_links")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        The address prefix for the subnet.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        List of address prefixes for the subnet.
        """
        return pulumi.get(self, "address_prefixes")

    @property
    @pulumi.getter
    def delegations(self) -> Optional[Sequence['outputs.DelegationResponse']]:
        """
        An array of references to the delegations on the subnet.
        """
        return pulumi.get(self, "delegations")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAllocations")
    def ip_allocations(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Array of IpAllocation which reference this subnet.
        """
        return pulumi.get(self, "ip_allocations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natGateway")
    def nat_gateway(self) -> Optional['outputs.SubResourceResponse']:
        """
        Nat gateway associated with this subnet.
        """
        return pulumi.get(self, "nat_gateway")

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional['outputs.NetworkSecurityGroupResponse']:
        """
        The reference to the NetworkSecurityGroup resource.
        """
        return pulumi.get(self, "network_security_group")

    @property
    @pulumi.getter(name="privateEndpointNetworkPolicies")
    def private_endpoint_network_policies(self) -> Optional[str]:
        """
        Enable or Disable apply network policies on private end point in the subnet.
        """
        return pulumi.get(self, "private_endpoint_network_policies")

    @property
    @pulumi.getter(name="privateLinkServiceNetworkPolicies")
    def private_link_service_network_policies(self) -> Optional[str]:
        """
        Enable or Disable apply network policies on private link service in the subnet.
        """
        return pulumi.get(self, "private_link_service_network_policies")

    @property
    @pulumi.getter(name="routeTable")
    def route_table(self) -> Optional['outputs.RouteTableResponse']:
        """
        The reference to the RouteTable resource.
        """
        return pulumi.get(self, "route_table")

    @property
    @pulumi.getter(name="serviceEndpointPolicies")
    def service_endpoint_policies(self) -> Optional[Sequence['outputs.ServiceEndpointPolicyResponse']]:
        """
        An array of service endpoint policies.
        """
        return pulumi.get(self, "service_endpoint_policies")

    @property
    @pulumi.getter(name="serviceEndpoints")
    def service_endpoints(self) -> Optional[Sequence['outputs.ServiceEndpointPropertiesFormatResponse']]:
        """
        An array of service endpoints.
        """
        return pulumi.get(self, "service_endpoints")


@pulumi.output_type
class TrafficAnalyticsConfigurationPropertiesResponse(dict):
    """
    Parameters that define the configuration of traffic analytics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trafficAnalyticsInterval":
            suggest = "traffic_analytics_interval"
        elif key == "workspaceId":
            suggest = "workspace_id"
        elif key == "workspaceRegion":
            suggest = "workspace_region"
        elif key == "workspaceResourceId":
            suggest = "workspace_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficAnalyticsConfigurationPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficAnalyticsConfigurationPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficAnalyticsConfigurationPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 traffic_analytics_interval: Optional[int] = None,
                 workspace_id: Optional[str] = None,
                 workspace_region: Optional[str] = None,
                 workspace_resource_id: Optional[str] = None):
        """
        Parameters that define the configuration of traffic analytics.
        :param bool enabled: Flag to enable/disable traffic analytics.
        :param int traffic_analytics_interval: The interval in minutes which would decide how frequently TA service should do flow analytics.
        :param str workspace_id: The resource guid of the attached workspace.
        :param str workspace_region: The location of the attached workspace.
        :param str workspace_resource_id: Resource Id of the attached workspace.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if traffic_analytics_interval is not None:
            pulumi.set(__self__, "traffic_analytics_interval", traffic_analytics_interval)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)
        if workspace_region is not None:
            pulumi.set(__self__, "workspace_region", workspace_region)
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Flag to enable/disable traffic analytics.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="trafficAnalyticsInterval")
    def traffic_analytics_interval(self) -> Optional[int]:
        """
        The interval in minutes which would decide how frequently TA service should do flow analytics.
        """
        return pulumi.get(self, "traffic_analytics_interval")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[str]:
        """
        The resource guid of the attached workspace.
        """
        return pulumi.get(self, "workspace_id")

    @property
    @pulumi.getter(name="workspaceRegion")
    def workspace_region(self) -> Optional[str]:
        """
        The location of the attached workspace.
        """
        return pulumi.get(self, "workspace_region")

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[str]:
        """
        Resource Id of the attached workspace.
        """
        return pulumi.get(self, "workspace_resource_id")


@pulumi.output_type
class TrafficAnalyticsPropertiesResponse(dict):
    """
    Parameters that define the configuration of traffic analytics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkWatcherFlowAnalyticsConfiguration":
            suggest = "network_watcher_flow_analytics_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficAnalyticsPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficAnalyticsPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficAnalyticsPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_watcher_flow_analytics_configuration: Optional['outputs.TrafficAnalyticsConfigurationPropertiesResponse'] = None):
        """
        Parameters that define the configuration of traffic analytics.
        :param 'TrafficAnalyticsConfigurationPropertiesResponse' network_watcher_flow_analytics_configuration: Parameters that define the configuration of traffic analytics.
        """
        if network_watcher_flow_analytics_configuration is not None:
            pulumi.set(__self__, "network_watcher_flow_analytics_configuration", network_watcher_flow_analytics_configuration)

    @property
    @pulumi.getter(name="networkWatcherFlowAnalyticsConfiguration")
    def network_watcher_flow_analytics_configuration(self) -> Optional['outputs.TrafficAnalyticsConfigurationPropertiesResponse']:
        """
        Parameters that define the configuration of traffic analytics.
        """
        return pulumi.get(self, "network_watcher_flow_analytics_configuration")


@pulumi.output_type
class TrafficSelectorPolicyResponse(dict):
    """
    An traffic selector policy for a virtual network gateway connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localAddressRanges":
            suggest = "local_address_ranges"
        elif key == "remoteAddressRanges":
            suggest = "remote_address_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficSelectorPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficSelectorPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficSelectorPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_address_ranges: Sequence[str],
                 remote_address_ranges: Sequence[str]):
        """
        An traffic selector policy for a virtual network gateway connection.
        :param Sequence[str] local_address_ranges: A collection of local address spaces in CIDR format.
        :param Sequence[str] remote_address_ranges: A collection of remote address spaces in CIDR format.
        """
        pulumi.set(__self__, "local_address_ranges", local_address_ranges)
        pulumi.set(__self__, "remote_address_ranges", remote_address_ranges)

    @property
    @pulumi.getter(name="localAddressRanges")
    def local_address_ranges(self) -> Sequence[str]:
        """
        A collection of local address spaces in CIDR format.
        """
        return pulumi.get(self, "local_address_ranges")

    @property
    @pulumi.getter(name="remoteAddressRanges")
    def remote_address_ranges(self) -> Sequence[str]:
        """
        A collection of remote address spaces in CIDR format.
        """
        return pulumi.get(self, "remote_address_ranges")


@pulumi.output_type
class TunnelConnectionHealthResponse(dict):
    """
    VirtualNetworkGatewayConnection properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionStatus":
            suggest = "connection_status"
        elif key == "egressBytesTransferred":
            suggest = "egress_bytes_transferred"
        elif key == "ingressBytesTransferred":
            suggest = "ingress_bytes_transferred"
        elif key == "lastConnectionEstablishedUtcTime":
            suggest = "last_connection_established_utc_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TunnelConnectionHealthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TunnelConnectionHealthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TunnelConnectionHealthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_status: str,
                 egress_bytes_transferred: float,
                 ingress_bytes_transferred: float,
                 last_connection_established_utc_time: str,
                 tunnel: str):
        """
        VirtualNetworkGatewayConnection properties.
        :param str connection_status: Virtual Network Gateway connection status.
        :param float egress_bytes_transferred: The Egress Bytes Transferred in this connection.
        :param float ingress_bytes_transferred: The Ingress Bytes Transferred in this connection.
        :param str last_connection_established_utc_time: The time at which connection was established in Utc format.
        :param str tunnel: Tunnel name.
        """
        pulumi.set(__self__, "connection_status", connection_status)
        pulumi.set(__self__, "egress_bytes_transferred", egress_bytes_transferred)
        pulumi.set(__self__, "ingress_bytes_transferred", ingress_bytes_transferred)
        pulumi.set(__self__, "last_connection_established_utc_time", last_connection_established_utc_time)
        pulumi.set(__self__, "tunnel", tunnel)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> str:
        """
        Virtual Network Gateway connection status.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="egressBytesTransferred")
    def egress_bytes_transferred(self) -> float:
        """
        The Egress Bytes Transferred in this connection.
        """
        return pulumi.get(self, "egress_bytes_transferred")

    @property
    @pulumi.getter(name="ingressBytesTransferred")
    def ingress_bytes_transferred(self) -> float:
        """
        The Ingress Bytes Transferred in this connection.
        """
        return pulumi.get(self, "ingress_bytes_transferred")

    @property
    @pulumi.getter(name="lastConnectionEstablishedUtcTime")
    def last_connection_established_utc_time(self) -> str:
        """
        The time at which connection was established in Utc format.
        """
        return pulumi.get(self, "last_connection_established_utc_time")

    @property
    @pulumi.getter
    def tunnel(self) -> str:
        """
        Tunnel name.
        """
        return pulumi.get(self, "tunnel")


@pulumi.output_type
class VMResponse(dict):
    """
    Describes a Virtual Machine.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Describes a Virtual Machine.
        :param str name: Resource name.
        :param str type: Resource type.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class VirtualApplianceNicPropertiesResponse(dict):
    """
    Network Virtual Appliance NIC properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "publicIpAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualApplianceNicPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualApplianceNicPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualApplianceNicPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 private_ip_address: str,
                 public_ip_address: str):
        """
        Network Virtual Appliance NIC properties.
        :param str name: NIC name.
        :param str private_ip_address: Private IP address.
        :param str public_ip_address: Public IP address.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        NIC name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        Private IP address.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP address.
        """
        return pulumi.get(self, "public_ip_address")


@pulumi.output_type
class VirtualApplianceSkuPropertiesResponse(dict):
    """
    Network Virtual Appliance Sku Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bundledScaleUnit":
            suggest = "bundled_scale_unit"
        elif key == "marketPlaceVersion":
            suggest = "market_place_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualApplianceSkuPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualApplianceSkuPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualApplianceSkuPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bundled_scale_unit: Optional[str] = None,
                 market_place_version: Optional[str] = None,
                 vendor: Optional[str] = None):
        """
        Network Virtual Appliance Sku Properties.
        :param str bundled_scale_unit: Virtual Appliance Scale Unit.
        :param str market_place_version: Virtual Appliance Version.
        :param str vendor: Virtual Appliance Vendor.
        """
        if bundled_scale_unit is not None:
            pulumi.set(__self__, "bundled_scale_unit", bundled_scale_unit)
        if market_place_version is not None:
            pulumi.set(__self__, "market_place_version", market_place_version)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="bundledScaleUnit")
    def bundled_scale_unit(self) -> Optional[str]:
        """
        Virtual Appliance Scale Unit.
        """
        return pulumi.get(self, "bundled_scale_unit")

    @property
    @pulumi.getter(name="marketPlaceVersion")
    def market_place_version(self) -> Optional[str]:
        """
        Virtual Appliance Version.
        """
        return pulumi.get(self, "market_place_version")

    @property
    @pulumi.getter
    def vendor(self) -> Optional[str]:
        """
        Virtual Appliance Vendor.
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class VirtualHubIdResponse(dict):
    """
    Virtual Hub identifier.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Virtual Hub identifier.
        :param str id: The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VirtualHubRouteResponse(dict):
    """
    VirtualHub route.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefixes":
            suggest = "address_prefixes"
        elif key == "nextHopIpAddress":
            suggest = "next_hop_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualHubRouteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualHubRouteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualHubRouteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefixes: Optional[Sequence[str]] = None,
                 next_hop_ip_address: Optional[str] = None):
        """
        VirtualHub route.
        :param Sequence[str] address_prefixes: List of all addressPrefixes.
        :param str next_hop_ip_address: NextHop ip address.
        """
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        List of all addressPrefixes.
        """
        return pulumi.get(self, "address_prefixes")

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[str]:
        """
        NextHop ip address.
        """
        return pulumi.get(self, "next_hop_ip_address")


@pulumi.output_type
class VirtualHubRouteTableResponse(dict):
    """
    VirtualHub route table.
    """
    def __init__(__self__, *,
                 routes: Optional[Sequence['outputs.VirtualHubRouteResponse']] = None):
        """
        VirtualHub route table.
        :param Sequence['VirtualHubRouteResponse'] routes: List of all routes.
        """
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.VirtualHubRouteResponse']]:
        """
        List of all routes.
        """
        return pulumi.get(self, "routes")


@pulumi.output_type
class VirtualHubRouteTableV2Response(dict):
    """
    VirtualHubRouteTableV2 Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "attachedConnections":
            suggest = "attached_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualHubRouteTableV2Response. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualHubRouteTableV2Response.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualHubRouteTableV2Response.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 attached_connections: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 routes: Optional[Sequence['outputs.VirtualHubRouteV2Response']] = None):
        """
        VirtualHubRouteTableV2 Resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the virtual hub route table v2 resource.
        :param Sequence[str] attached_connections: List of all connections attached to this route table v2.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param Sequence['VirtualHubRouteV2Response'] routes: List of all routes.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if attached_connections is not None:
            pulumi.set(__self__, "attached_connections", attached_connections)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the virtual hub route table v2 resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="attachedConnections")
    def attached_connections(self) -> Optional[Sequence[str]]:
        """
        List of all connections attached to this route table v2.
        """
        return pulumi.get(self, "attached_connections")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.VirtualHubRouteV2Response']]:
        """
        List of all routes.
        """
        return pulumi.get(self, "routes")


@pulumi.output_type
class VirtualHubRouteV2Response(dict):
    """
    VirtualHubRouteTableV2 route.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationType":
            suggest = "destination_type"
        elif key == "nextHopType":
            suggest = "next_hop_type"
        elif key == "nextHops":
            suggest = "next_hops"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualHubRouteV2Response. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualHubRouteV2Response.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualHubRouteV2Response.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_type: Optional[str] = None,
                 destinations: Optional[Sequence[str]] = None,
                 next_hop_type: Optional[str] = None,
                 next_hops: Optional[Sequence[str]] = None):
        """
        VirtualHubRouteTableV2 route.
        :param str destination_type: The type of destinations.
        :param Sequence[str] destinations: List of all destinations.
        :param str next_hop_type: The type of next hops.
        :param Sequence[str] next_hops: NextHops ip address.
        """
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if next_hop_type is not None:
            pulumi.set(__self__, "next_hop_type", next_hop_type)
        if next_hops is not None:
            pulumi.set(__self__, "next_hops", next_hops)

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[str]:
        """
        The type of destinations.
        """
        return pulumi.get(self, "destination_type")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence[str]]:
        """
        List of all destinations.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> Optional[str]:
        """
        The type of next hops.
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter(name="nextHops")
    def next_hops(self) -> Optional[Sequence[str]]:
        """
        NextHops ip address.
        """
        return pulumi.get(self, "next_hops")


@pulumi.output_type
class VirtualNetworkBgpCommunitiesResponse(dict):
    """
    Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionalCommunity":
            suggest = "regional_community"
        elif key == "virtualNetworkCommunity":
            suggest = "virtual_network_community"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkBgpCommunitiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkBgpCommunitiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkBgpCommunitiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 regional_community: str,
                 virtual_network_community: str):
        """
        Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
        :param str regional_community: The BGP community associated with the region of the virtual network.
        :param str virtual_network_community: The BGP community associated with the virtual network.
        """
        pulumi.set(__self__, "regional_community", regional_community)
        pulumi.set(__self__, "virtual_network_community", virtual_network_community)

    @property
    @pulumi.getter(name="regionalCommunity")
    def regional_community(self) -> str:
        """
        The BGP community associated with the region of the virtual network.
        """
        return pulumi.get(self, "regional_community")

    @property
    @pulumi.getter(name="virtualNetworkCommunity")
    def virtual_network_community(self) -> str:
        """
        The BGP community associated with the virtual network.
        """
        return pulumi.get(self, "virtual_network_community")


@pulumi.output_type
class VirtualNetworkGatewayIPConfigurationResponse(dict):
    """
    IP configuration for virtual network gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkGatewayIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkGatewayIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkGatewayIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 private_ip_address: str,
                 provisioning_state: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 public_ip_address: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        IP configuration for virtual network gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str private_ip_address: Private IP Address for this gateway.
        :param str provisioning_state: The provisioning state of the virtual network gateway IP configuration resource.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_ip_allocation_method: The private IP address allocation method.
        :param 'SubResourceResponse' public_ip_address: The reference to the public IP resource.
        :param 'SubResourceResponse' subnet: The reference to the subnet resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> str:
        """
        Private IP Address for this gateway.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the virtual network gateway IP configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference to the public IP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference to the subnet resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class VirtualNetworkGatewayResponse(dict):
    """
    A common class for general resource information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundDnsForwardingEndpoint":
            suggest = "inbound_dns_forwarding_endpoint"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "activeActive":
            suggest = "active_active"
        elif key == "bgpSettings":
            suggest = "bgp_settings"
        elif key == "customRoutes":
            suggest = "custom_routes"
        elif key == "enableBgp":
            suggest = "enable_bgp"
        elif key == "enableDnsForwarding":
            suggest = "enable_dns_forwarding"
        elif key == "enablePrivateIpAddress":
            suggest = "enable_private_ip_address"
        elif key == "gatewayDefaultSite":
            suggest = "gateway_default_site"
        elif key == "gatewayType":
            suggest = "gateway_type"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "vpnClientConfiguration":
            suggest = "vpn_client_configuration"
        elif key == "vpnGatewayGeneration":
            suggest = "vpn_gateway_generation"
        elif key == "vpnType":
            suggest = "vpn_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkGatewayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkGatewayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkGatewayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 inbound_dns_forwarding_endpoint: str,
                 name: str,
                 provisioning_state: str,
                 resource_guid: str,
                 type: str,
                 active_active: Optional[bool] = None,
                 bgp_settings: Optional['outputs.BgpSettingsResponse'] = None,
                 custom_routes: Optional['outputs.AddressSpaceResponse'] = None,
                 enable_bgp: Optional[bool] = None,
                 enable_dns_forwarding: Optional[bool] = None,
                 enable_private_ip_address: Optional[bool] = None,
                 gateway_default_site: Optional['outputs.SubResourceResponse'] = None,
                 gateway_type: Optional[str] = None,
                 id: Optional[str] = None,
                 ip_configurations: Optional[Sequence['outputs.VirtualNetworkGatewayIPConfigurationResponse']] = None,
                 location: Optional[str] = None,
                 sku: Optional['outputs.VirtualNetworkGatewaySkuResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 vpn_client_configuration: Optional['outputs.VpnClientConfigurationResponse'] = None,
                 vpn_gateway_generation: Optional[str] = None,
                 vpn_type: Optional[str] = None):
        """
        A common class for general resource information.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str inbound_dns_forwarding_endpoint: The IP address allocated by the gateway to which dns requests can be sent.
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the virtual network gateway resource.
        :param str resource_guid: The resource GUID property of the virtual network gateway resource.
        :param str type: Resource type.
        :param bool active_active: ActiveActive flag.
        :param 'BgpSettingsResponse' bgp_settings: Virtual network gateway's BGP speaker settings.
        :param 'AddressSpaceResponse' custom_routes: The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
        :param bool enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
        :param bool enable_dns_forwarding: Whether dns forwarding is enabled or not.
        :param bool enable_private_ip_address: Whether private IP needs to be enabled on this gateway for connections or not.
        :param 'SubResourceResponse' gateway_default_site: The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
        :param str gateway_type: The type of this virtual network gateway.
        :param str id: Resource ID.
        :param Sequence['VirtualNetworkGatewayIPConfigurationResponse'] ip_configurations: IP configurations for virtual network gateway.
        :param str location: Resource location.
        :param 'VirtualNetworkGatewaySkuResponse' sku: The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
        :param Mapping[str, str] tags: Resource tags.
        :param 'VpnClientConfigurationResponse' vpn_client_configuration: The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
        :param str vpn_gateway_generation: The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
        :param str vpn_type: The type of this virtual network gateway.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "inbound_dns_forwarding_endpoint", inbound_dns_forwarding_endpoint)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "type", type)
        if active_active is not None:
            pulumi.set(__self__, "active_active", active_active)
        if bgp_settings is not None:
            pulumi.set(__self__, "bgp_settings", bgp_settings)
        if custom_routes is not None:
            pulumi.set(__self__, "custom_routes", custom_routes)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if enable_dns_forwarding is not None:
            pulumi.set(__self__, "enable_dns_forwarding", enable_dns_forwarding)
        if enable_private_ip_address is not None:
            pulumi.set(__self__, "enable_private_ip_address", enable_private_ip_address)
        if gateway_default_site is not None:
            pulumi.set(__self__, "gateway_default_site", gateway_default_site)
        if gateway_type is not None:
            pulumi.set(__self__, "gateway_type", gateway_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpn_client_configuration is not None:
            pulumi.set(__self__, "vpn_client_configuration", vpn_client_configuration)
        if vpn_gateway_generation is not None:
            pulumi.set(__self__, "vpn_gateway_generation", vpn_gateway_generation)
        if vpn_type is not None:
            pulumi.set(__self__, "vpn_type", vpn_type)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="inboundDnsForwardingEndpoint")
    def inbound_dns_forwarding_endpoint(self) -> str:
        """
        The IP address allocated by the gateway to which dns requests can be sent.
        """
        return pulumi.get(self, "inbound_dns_forwarding_endpoint")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the virtual network gateway resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resource GUID property of the virtual network gateway resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="activeActive")
    def active_active(self) -> Optional[bool]:
        """
        ActiveActive flag.
        """
        return pulumi.get(self, "active_active")

    @property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Optional['outputs.BgpSettingsResponse']:
        """
        Virtual network gateway's BGP speaker settings.
        """
        return pulumi.get(self, "bgp_settings")

    @property
    @pulumi.getter(name="customRoutes")
    def custom_routes(self) -> Optional['outputs.AddressSpaceResponse']:
        """
        The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
        """
        return pulumi.get(self, "custom_routes")

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[bool]:
        """
        Whether BGP is enabled for this virtual network gateway or not.
        """
        return pulumi.get(self, "enable_bgp")

    @property
    @pulumi.getter(name="enableDnsForwarding")
    def enable_dns_forwarding(self) -> Optional[bool]:
        """
        Whether dns forwarding is enabled or not.
        """
        return pulumi.get(self, "enable_dns_forwarding")

    @property
    @pulumi.getter(name="enablePrivateIpAddress")
    def enable_private_ip_address(self) -> Optional[bool]:
        """
        Whether private IP needs to be enabled on this gateway for connections or not.
        """
        return pulumi.get(self, "enable_private_ip_address")

    @property
    @pulumi.getter(name="gatewayDefaultSite")
    def gateway_default_site(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
        """
        return pulumi.get(self, "gateway_default_site")

    @property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> Optional[str]:
        """
        The type of this virtual network gateway.
        """
        return pulumi.get(self, "gateway_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.VirtualNetworkGatewayIPConfigurationResponse']]:
        """
        IP configurations for virtual network gateway.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.VirtualNetworkGatewaySkuResponse']:
        """
        The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpnClientConfiguration")
    def vpn_client_configuration(self) -> Optional['outputs.VpnClientConfigurationResponse']:
        """
        The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
        """
        return pulumi.get(self, "vpn_client_configuration")

    @property
    @pulumi.getter(name="vpnGatewayGeneration")
    def vpn_gateway_generation(self) -> Optional[str]:
        """
        The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
        """
        return pulumi.get(self, "vpn_gateway_generation")

    @property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> Optional[str]:
        """
        The type of this virtual network gateway.
        """
        return pulumi.get(self, "vpn_type")


@pulumi.output_type
class VirtualNetworkGatewaySkuResponse(dict):
    """
    VirtualNetworkGatewaySku details.
    """
    def __init__(__self__, *,
                 capacity: int,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        VirtualNetworkGatewaySku details.
        :param int capacity: The capacity.
        :param str name: Gateway SKU name.
        :param str tier: Gateway SKU tier.
        """
        pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> int:
        """
        The capacity.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gateway SKU name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Gateway SKU tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class VirtualNetworkPeeringResponse(dict):
    """
    Peerings in a virtual network resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "allowForwardedTraffic":
            suggest = "allow_forwarded_traffic"
        elif key == "allowGatewayTransit":
            suggest = "allow_gateway_transit"
        elif key == "allowVirtualNetworkAccess":
            suggest = "allow_virtual_network_access"
        elif key == "peeringState":
            suggest = "peering_state"
        elif key == "remoteAddressSpace":
            suggest = "remote_address_space"
        elif key == "remoteVirtualNetwork":
            suggest = "remote_virtual_network"
        elif key == "useRemoteGateways":
            suggest = "use_remote_gateways"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkPeeringResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkPeeringResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkPeeringResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 allow_forwarded_traffic: Optional[bool] = None,
                 allow_gateway_transit: Optional[bool] = None,
                 allow_virtual_network_access: Optional[bool] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 peering_state: Optional[str] = None,
                 remote_address_space: Optional['outputs.AddressSpaceResponse'] = None,
                 remote_virtual_network: Optional['outputs.SubResourceResponse'] = None,
                 use_remote_gateways: Optional[bool] = None):
        """
        Peerings in a virtual network resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the virtual network peering resource.
        :param bool allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
        :param bool allow_gateway_transit: If gateway links can be used in remote virtual networking to link to this virtual network.
        :param bool allow_virtual_network_access: Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str peering_state: The status of the virtual network peering.
        :param 'AddressSpaceResponse' remote_address_space: The reference to the remote virtual network address space.
        :param 'SubResourceResponse' remote_virtual_network: The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
        :param bool use_remote_gateways: If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if allow_forwarded_traffic is not None:
            pulumi.set(__self__, "allow_forwarded_traffic", allow_forwarded_traffic)
        if allow_gateway_transit is not None:
            pulumi.set(__self__, "allow_gateway_transit", allow_gateway_transit)
        if allow_virtual_network_access is not None:
            pulumi.set(__self__, "allow_virtual_network_access", allow_virtual_network_access)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peering_state is not None:
            pulumi.set(__self__, "peering_state", peering_state)
        if remote_address_space is not None:
            pulumi.set(__self__, "remote_address_space", remote_address_space)
        if remote_virtual_network is not None:
            pulumi.set(__self__, "remote_virtual_network", remote_virtual_network)
        if use_remote_gateways is not None:
            pulumi.set(__self__, "use_remote_gateways", use_remote_gateways)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the virtual network peering resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="allowForwardedTraffic")
    def allow_forwarded_traffic(self) -> Optional[bool]:
        """
        Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
        """
        return pulumi.get(self, "allow_forwarded_traffic")

    @property
    @pulumi.getter(name="allowGatewayTransit")
    def allow_gateway_transit(self) -> Optional[bool]:
        """
        If gateway links can be used in remote virtual networking to link to this virtual network.
        """
        return pulumi.get(self, "allow_gateway_transit")

    @property
    @pulumi.getter(name="allowVirtualNetworkAccess")
    def allow_virtual_network_access(self) -> Optional[bool]:
        """
        Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
        """
        return pulumi.get(self, "allow_virtual_network_access")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peeringState")
    def peering_state(self) -> Optional[str]:
        """
        The status of the virtual network peering.
        """
        return pulumi.get(self, "peering_state")

    @property
    @pulumi.getter(name="remoteAddressSpace")
    def remote_address_space(self) -> Optional['outputs.AddressSpaceResponse']:
        """
        The reference to the remote virtual network address space.
        """
        return pulumi.get(self, "remote_address_space")

    @property
    @pulumi.getter(name="remoteVirtualNetwork")
    def remote_virtual_network(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
        """
        return pulumi.get(self, "remote_virtual_network")

    @property
    @pulumi.getter(name="useRemoteGateways")
    def use_remote_gateways(self) -> Optional[bool]:
        """
        If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
        """
        return pulumi.get(self, "use_remote_gateways")


@pulumi.output_type
class VirtualNetworkTapResponse(dict):
    """
    Virtual Network Tap resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaceTapConfigurations":
            suggest = "network_interface_tap_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "destinationLoadBalancerFrontEndIPConfiguration":
            suggest = "destination_load_balancer_front_end_ip_configuration"
        elif key == "destinationNetworkInterfaceIPConfiguration":
            suggest = "destination_network_interface_ip_configuration"
        elif key == "destinationPort":
            suggest = "destination_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkTapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkTapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkTapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 name: str,
                 network_interface_tap_configurations: Sequence['outputs.NetworkInterfaceTapConfigurationResponse'],
                 provisioning_state: str,
                 resource_guid: str,
                 type: str,
                 destination_load_balancer_front_end_ip_configuration: Optional['outputs.FrontendIPConfigurationResponse'] = None,
                 destination_network_interface_ip_configuration: Optional['outputs.NetworkInterfaceIPConfigurationResponse'] = None,
                 destination_port: Optional[int] = None,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Virtual Network Tap resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str name: Resource name.
        :param Sequence['NetworkInterfaceTapConfigurationResponse'] network_interface_tap_configurations: Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped.
        :param str provisioning_state: The provisioning state of the virtual network tap resource.
        :param str resource_guid: The resource GUID property of the virtual network tap resource.
        :param str type: Resource type.
        :param 'FrontendIPConfigurationResponse' destination_load_balancer_front_end_ip_configuration: The reference to the private IP address on the internal Load Balancer that will receive the tap.
        :param 'NetworkInterfaceIPConfigurationResponse' destination_network_interface_ip_configuration: The reference to the private IP Address of the collector nic that will receive the tap.
        :param int destination_port: The VXLAN destination port that will receive the tapped traffic.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_interface_tap_configurations", network_interface_tap_configurations)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "type", type)
        if destination_load_balancer_front_end_ip_configuration is not None:
            pulumi.set(__self__, "destination_load_balancer_front_end_ip_configuration", destination_load_balancer_front_end_ip_configuration)
        if destination_network_interface_ip_configuration is not None:
            pulumi.set(__self__, "destination_network_interface_ip_configuration", destination_network_interface_ip_configuration)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaceTapConfigurations")
    def network_interface_tap_configurations(self) -> Sequence['outputs.NetworkInterfaceTapConfigurationResponse']:
        """
        Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped.
        """
        return pulumi.get(self, "network_interface_tap_configurations")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the virtual network tap resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resource GUID property of the virtual network tap resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="destinationLoadBalancerFrontEndIPConfiguration")
    def destination_load_balancer_front_end_ip_configuration(self) -> Optional['outputs.FrontendIPConfigurationResponse']:
        """
        The reference to the private IP address on the internal Load Balancer that will receive the tap.
        """
        return pulumi.get(self, "destination_load_balancer_front_end_ip_configuration")

    @property
    @pulumi.getter(name="destinationNetworkInterfaceIPConfiguration")
    def destination_network_interface_ip_configuration(self) -> Optional['outputs.NetworkInterfaceIPConfigurationResponse']:
        """
        The reference to the private IP Address of the collector nic that will receive the tap.
        """
        return pulumi.get(self, "destination_network_interface_ip_configuration")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[int]:
        """
        The VXLAN destination port that will receive the tapped traffic.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class VnetRouteResponse(dict):
    """
    List of routes that control routing from VirtualHub into a virtual network connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "staticRoutes":
            suggest = "static_routes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VnetRouteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VnetRouteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VnetRouteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 static_routes: Optional[Sequence['outputs.StaticRouteResponse']] = None):
        """
        List of routes that control routing from VirtualHub into a virtual network connection.
        :param Sequence['StaticRouteResponse'] static_routes: List of all Static Routes.
        """
        if static_routes is not None:
            pulumi.set(__self__, "static_routes", static_routes)

    @property
    @pulumi.getter(name="staticRoutes")
    def static_routes(self) -> Optional[Sequence['outputs.StaticRouteResponse']]:
        """
        List of all Static Routes.
        """
        return pulumi.get(self, "static_routes")


@pulumi.output_type
class VpnClientConfigurationResponse(dict):
    """
    VpnClientConfiguration for P2S client.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadAudience":
            suggest = "aad_audience"
        elif key == "aadIssuer":
            suggest = "aad_issuer"
        elif key == "aadTenant":
            suggest = "aad_tenant"
        elif key == "radiusServerAddress":
            suggest = "radius_server_address"
        elif key == "radiusServerSecret":
            suggest = "radius_server_secret"
        elif key == "radiusServers":
            suggest = "radius_servers"
        elif key == "vpnClientAddressPool":
            suggest = "vpn_client_address_pool"
        elif key == "vpnClientIpsecPolicies":
            suggest = "vpn_client_ipsec_policies"
        elif key == "vpnClientProtocols":
            suggest = "vpn_client_protocols"
        elif key == "vpnClientRevokedCertificates":
            suggest = "vpn_client_revoked_certificates"
        elif key == "vpnClientRootCertificates":
            suggest = "vpn_client_root_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnClientConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnClientConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnClientConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_audience: Optional[str] = None,
                 aad_issuer: Optional[str] = None,
                 aad_tenant: Optional[str] = None,
                 radius_server_address: Optional[str] = None,
                 radius_server_secret: Optional[str] = None,
                 radius_servers: Optional[Sequence['outputs.RadiusServerResponse']] = None,
                 vpn_client_address_pool: Optional['outputs.AddressSpaceResponse'] = None,
                 vpn_client_ipsec_policies: Optional[Sequence['outputs.IpsecPolicyResponse']] = None,
                 vpn_client_protocols: Optional[Sequence[str]] = None,
                 vpn_client_revoked_certificates: Optional[Sequence['outputs.VpnClientRevokedCertificateResponse']] = None,
                 vpn_client_root_certificates: Optional[Sequence['outputs.VpnClientRootCertificateResponse']] = None):
        """
        VpnClientConfiguration for P2S client.
        :param str aad_audience: The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        :param str aad_issuer: The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        :param str aad_tenant: The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        :param str radius_server_address: The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
        :param str radius_server_secret: The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
        :param Sequence['RadiusServerResponse'] radius_servers: The radiusServers property for multiple radius server configuration.
        :param 'AddressSpaceResponse' vpn_client_address_pool: The reference to the address space resource which represents Address space for P2S VpnClient.
        :param Sequence['IpsecPolicyResponse'] vpn_client_ipsec_policies: VpnClientIpsecPolicies for virtual network gateway P2S client.
        :param Sequence[str] vpn_client_protocols: VpnClientProtocols for Virtual network gateway.
        :param Sequence['VpnClientRevokedCertificateResponse'] vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network gateway.
        :param Sequence['VpnClientRootCertificateResponse'] vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
        """
        if aad_audience is not None:
            pulumi.set(__self__, "aad_audience", aad_audience)
        if aad_issuer is not None:
            pulumi.set(__self__, "aad_issuer", aad_issuer)
        if aad_tenant is not None:
            pulumi.set(__self__, "aad_tenant", aad_tenant)
        if radius_server_address is not None:
            pulumi.set(__self__, "radius_server_address", radius_server_address)
        if radius_server_secret is not None:
            pulumi.set(__self__, "radius_server_secret", radius_server_secret)
        if radius_servers is not None:
            pulumi.set(__self__, "radius_servers", radius_servers)
        if vpn_client_address_pool is not None:
            pulumi.set(__self__, "vpn_client_address_pool", vpn_client_address_pool)
        if vpn_client_ipsec_policies is not None:
            pulumi.set(__self__, "vpn_client_ipsec_policies", vpn_client_ipsec_policies)
        if vpn_client_protocols is not None:
            pulumi.set(__self__, "vpn_client_protocols", vpn_client_protocols)
        if vpn_client_revoked_certificates is not None:
            pulumi.set(__self__, "vpn_client_revoked_certificates", vpn_client_revoked_certificates)
        if vpn_client_root_certificates is not None:
            pulumi.set(__self__, "vpn_client_root_certificates", vpn_client_root_certificates)

    @property
    @pulumi.getter(name="aadAudience")
    def aad_audience(self) -> Optional[str]:
        """
        The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        """
        return pulumi.get(self, "aad_audience")

    @property
    @pulumi.getter(name="aadIssuer")
    def aad_issuer(self) -> Optional[str]:
        """
        The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        """
        return pulumi.get(self, "aad_issuer")

    @property
    @pulumi.getter(name="aadTenant")
    def aad_tenant(self) -> Optional[str]:
        """
        The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
        """
        return pulumi.get(self, "aad_tenant")

    @property
    @pulumi.getter(name="radiusServerAddress")
    def radius_server_address(self) -> Optional[str]:
        """
        The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
        """
        return pulumi.get(self, "radius_server_address")

    @property
    @pulumi.getter(name="radiusServerSecret")
    def radius_server_secret(self) -> Optional[str]:
        """
        The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
        """
        return pulumi.get(self, "radius_server_secret")

    @property
    @pulumi.getter(name="radiusServers")
    def radius_servers(self) -> Optional[Sequence['outputs.RadiusServerResponse']]:
        """
        The radiusServers property for multiple radius server configuration.
        """
        return pulumi.get(self, "radius_servers")

    @property
    @pulumi.getter(name="vpnClientAddressPool")
    def vpn_client_address_pool(self) -> Optional['outputs.AddressSpaceResponse']:
        """
        The reference to the address space resource which represents Address space for P2S VpnClient.
        """
        return pulumi.get(self, "vpn_client_address_pool")

    @property
    @pulumi.getter(name="vpnClientIpsecPolicies")
    def vpn_client_ipsec_policies(self) -> Optional[Sequence['outputs.IpsecPolicyResponse']]:
        """
        VpnClientIpsecPolicies for virtual network gateway P2S client.
        """
        return pulumi.get(self, "vpn_client_ipsec_policies")

    @property
    @pulumi.getter(name="vpnClientProtocols")
    def vpn_client_protocols(self) -> Optional[Sequence[str]]:
        """
        VpnClientProtocols for Virtual network gateway.
        """
        return pulumi.get(self, "vpn_client_protocols")

    @property
    @pulumi.getter(name="vpnClientRevokedCertificates")
    def vpn_client_revoked_certificates(self) -> Optional[Sequence['outputs.VpnClientRevokedCertificateResponse']]:
        """
        VpnClientRevokedCertificate for Virtual network gateway.
        """
        return pulumi.get(self, "vpn_client_revoked_certificates")

    @property
    @pulumi.getter(name="vpnClientRootCertificates")
    def vpn_client_root_certificates(self) -> Optional[Sequence['outputs.VpnClientRootCertificateResponse']]:
        """
        VpnClientRootCertificate for virtual network gateway.
        """
        return pulumi.get(self, "vpn_client_root_certificates")


@pulumi.output_type
class VpnClientConnectionHealthDetailResponse(dict):
    """
    VPN client connection health detail.
    """
    def __init__(__self__, *,
                 egress_bytes_transferred: float,
                 egress_packets_transferred: float,
                 ingress_bytes_transferred: float,
                 ingress_packets_transferred: float,
                 max_bandwidth: float,
                 max_packets_per_second: float,
                 private_ip_address: str,
                 public_ip_address: str,
                 vpn_connection_duration: float,
                 vpn_connection_id: str,
                 vpn_connection_time: str,
                 vpn_user_name: str):
        """
        VPN client connection health detail.
        :param float egress_bytes_transferred: The egress bytes per second.
        :param float egress_packets_transferred: The egress packets per second.
        :param float ingress_bytes_transferred: The ingress bytes per second.
        :param float ingress_packets_transferred: The ingress packets per second.
        :param float max_bandwidth: The max band width.
        :param float max_packets_per_second: The max packets transferred per second.
        :param str private_ip_address: The assigned private Ip of a connected vpn client.
        :param str public_ip_address: The public Ip of a connected vpn client.
        :param float vpn_connection_duration: The duration time of a connected vpn client.
        :param str vpn_connection_id: The vpn client Id.
        :param str vpn_connection_time: The start time of a connected vpn client.
        :param str vpn_user_name: The user name of a connected vpn client.
        """
        pulumi.set(__self__, "egress_bytes_transferred", egress_bytes_transferred)
        pulumi.set(__self__, "egress_packets_transferred", egress_packets_transferred)
        pulumi.set(__self__, "ingress_bytes_transferred", ingress_bytes_transferred)
        pulumi.set(__self__, "ingress_packets_transferred", ingress_packets_transferred)
        pulumi.set(__self__, "max_bandwidth", max_bandwidth)
        pulumi.set(__self__, "max_packets_per_second", max_packets_per_second)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "vpn_connection_duration", vpn_connection_duration)
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)
        pulumi.set(__self__, "vpn_connection_time", vpn_connection_time)
        pulumi.set(__self__, "vpn_user_name", vpn_user_name)

    @property
    @pulumi.getter(name="egressBytesTransferred")
    def egress_bytes_transferred(self) -> float:
        """
        The egress bytes per second.
        """
        return pulumi.get(self, "egress_bytes_transferred")

    @property
    @pulumi.getter(name="egressPacketsTransferred")
    def egress_packets_transferred(self) -> float:
        """
        The egress packets per second.
        """
        return pulumi.get(self, "egress_packets_transferred")

    @property
    @pulumi.getter(name="ingressBytesTransferred")
    def ingress_bytes_transferred(self) -> float:
        """
        The ingress bytes per second.
        """
        return pulumi.get(self, "ingress_bytes_transferred")

    @property
    @pulumi.getter(name="ingressPacketsTransferred")
    def ingress_packets_transferred(self) -> float:
        """
        The ingress packets per second.
        """
        return pulumi.get(self, "ingress_packets_transferred")

    @property
    @pulumi.getter(name="maxBandwidth")
    def max_bandwidth(self) -> float:
        """
        The max band width.
        """
        return pulumi.get(self, "max_bandwidth")

    @property
    @pulumi.getter(name="maxPacketsPerSecond")
    def max_packets_per_second(self) -> float:
        """
        The max packets transferred per second.
        """
        return pulumi.get(self, "max_packets_per_second")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        The assigned private Ip of a connected vpn client.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        The public Ip of a connected vpn client.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="vpnConnectionDuration")
    def vpn_connection_duration(self) -> float:
        """
        The duration time of a connected vpn client.
        """
        return pulumi.get(self, "vpn_connection_duration")

    @property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> str:
        """
        The vpn client Id.
        """
        return pulumi.get(self, "vpn_connection_id")

    @property
    @pulumi.getter(name="vpnConnectionTime")
    def vpn_connection_time(self) -> str:
        """
        The start time of a connected vpn client.
        """
        return pulumi.get(self, "vpn_connection_time")

    @property
    @pulumi.getter(name="vpnUserName")
    def vpn_user_name(self) -> str:
        """
        The user name of a connected vpn client.
        """
        return pulumi.get(self, "vpn_user_name")


@pulumi.output_type
class VpnClientConnectionHealthResponse(dict):
    """
    VpnClientConnectionHealth properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "totalEgressBytesTransferred":
            suggest = "total_egress_bytes_transferred"
        elif key == "totalIngressBytesTransferred":
            suggest = "total_ingress_bytes_transferred"
        elif key == "allocatedIpAddresses":
            suggest = "allocated_ip_addresses"
        elif key == "vpnClientConnectionsCount":
            suggest = "vpn_client_connections_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnClientConnectionHealthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnClientConnectionHealthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnClientConnectionHealthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 total_egress_bytes_transferred: float,
                 total_ingress_bytes_transferred: float,
                 allocated_ip_addresses: Optional[Sequence[str]] = None,
                 vpn_client_connections_count: Optional[int] = None):
        """
        VpnClientConnectionHealth properties.
        :param float total_egress_bytes_transferred: Total of the Egress Bytes Transferred in this connection.
        :param float total_ingress_bytes_transferred: Total of the Ingress Bytes Transferred in this P2S Vpn connection.
        :param Sequence[str] allocated_ip_addresses: List of allocated ip addresses to the connected p2s vpn clients.
        :param int vpn_client_connections_count: The total of p2s vpn clients connected at this time to this P2SVpnGateway.
        """
        pulumi.set(__self__, "total_egress_bytes_transferred", total_egress_bytes_transferred)
        pulumi.set(__self__, "total_ingress_bytes_transferred", total_ingress_bytes_transferred)
        if allocated_ip_addresses is not None:
            pulumi.set(__self__, "allocated_ip_addresses", allocated_ip_addresses)
        if vpn_client_connections_count is not None:
            pulumi.set(__self__, "vpn_client_connections_count", vpn_client_connections_count)

    @property
    @pulumi.getter(name="totalEgressBytesTransferred")
    def total_egress_bytes_transferred(self) -> float:
        """
        Total of the Egress Bytes Transferred in this connection.
        """
        return pulumi.get(self, "total_egress_bytes_transferred")

    @property
    @pulumi.getter(name="totalIngressBytesTransferred")
    def total_ingress_bytes_transferred(self) -> float:
        """
        Total of the Ingress Bytes Transferred in this P2S Vpn connection.
        """
        return pulumi.get(self, "total_ingress_bytes_transferred")

    @property
    @pulumi.getter(name="allocatedIpAddresses")
    def allocated_ip_addresses(self) -> Optional[Sequence[str]]:
        """
        List of allocated ip addresses to the connected p2s vpn clients.
        """
        return pulumi.get(self, "allocated_ip_addresses")

    @property
    @pulumi.getter(name="vpnClientConnectionsCount")
    def vpn_client_connections_count(self) -> Optional[int]:
        """
        The total of p2s vpn clients connected at this time to this P2SVpnGateway.
        """
        return pulumi.get(self, "vpn_client_connections_count")


@pulumi.output_type
class VpnClientRevokedCertificateResponse(dict):
    """
    VPN client revoked certificate of virtual network gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnClientRevokedCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnClientRevokedCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnClientRevokedCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        VPN client revoked certificate of virtual network gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the VPN client revoked certificate resource.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str thumbprint: The revoked VPN client certificate thumbprint.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VPN client revoked certificate resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The revoked VPN client certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class VpnClientRootCertificateResponse(dict):
    """
    VPN client root certificate of virtual network gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicCertData":
            suggest = "public_cert_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnClientRootCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnClientRootCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnClientRootCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 public_cert_data: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        VPN client root certificate of virtual network gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the VPN client root certificate resource.
        :param str public_cert_data: The certificate public data.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "public_cert_data", public_cert_data)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VPN client root certificate resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> str:
        """
        The certificate public data.
        """
        return pulumi.get(self, "public_cert_data")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VpnConnectionResponse(dict):
    """
    VpnConnection Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionStatus":
            suggest = "connection_status"
        elif key == "egressBytesTransferred":
            suggest = "egress_bytes_transferred"
        elif key == "ingressBytesTransferred":
            suggest = "ingress_bytes_transferred"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "connectionBandwidth":
            suggest = "connection_bandwidth"
        elif key == "dpdTimeoutSeconds":
            suggest = "dpd_timeout_seconds"
        elif key == "enableBgp":
            suggest = "enable_bgp"
        elif key == "enableInternetSecurity":
            suggest = "enable_internet_security"
        elif key == "enableRateLimiting":
            suggest = "enable_rate_limiting"
        elif key == "ipsecPolicies":
            suggest = "ipsec_policies"
        elif key == "remoteVpnSite":
            suggest = "remote_vpn_site"
        elif key == "routingConfiguration":
            suggest = "routing_configuration"
        elif key == "routingWeight":
            suggest = "routing_weight"
        elif key == "sharedKey":
            suggest = "shared_key"
        elif key == "useLocalAzureIpAddress":
            suggest = "use_local_azure_ip_address"
        elif key == "usePolicyBasedTrafficSelectors":
            suggest = "use_policy_based_traffic_selectors"
        elif key == "vpnConnectionProtocolType":
            suggest = "vpn_connection_protocol_type"
        elif key == "vpnLinkConnections":
            suggest = "vpn_link_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_status: str,
                 egress_bytes_transferred: float,
                 etag: str,
                 ingress_bytes_transferred: float,
                 provisioning_state: str,
                 connection_bandwidth: Optional[int] = None,
                 dpd_timeout_seconds: Optional[int] = None,
                 enable_bgp: Optional[bool] = None,
                 enable_internet_security: Optional[bool] = None,
                 enable_rate_limiting: Optional[bool] = None,
                 id: Optional[str] = None,
                 ipsec_policies: Optional[Sequence['outputs.IpsecPolicyResponse']] = None,
                 name: Optional[str] = None,
                 remote_vpn_site: Optional['outputs.SubResourceResponse'] = None,
                 routing_configuration: Optional['outputs.RoutingConfigurationResponse'] = None,
                 routing_weight: Optional[int] = None,
                 shared_key: Optional[str] = None,
                 use_local_azure_ip_address: Optional[bool] = None,
                 use_policy_based_traffic_selectors: Optional[bool] = None,
                 vpn_connection_protocol_type: Optional[str] = None,
                 vpn_link_connections: Optional[Sequence['outputs.VpnSiteLinkConnectionResponse']] = None):
        """
        VpnConnection Resource.
        :param str connection_status: The connection status.
        :param float egress_bytes_transferred: Egress bytes transferred.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param float ingress_bytes_transferred: Ingress bytes transferred.
        :param str provisioning_state: The provisioning state of the VPN connection resource.
        :param int connection_bandwidth: Expected bandwidth in MBPS.
        :param int dpd_timeout_seconds: The dead peer detection timeout for a vpn connection in seconds.
        :param bool enable_bgp: EnableBgp flag.
        :param bool enable_internet_security: Enable internet security.
        :param bool enable_rate_limiting: EnableBgp flag.
        :param str id: Resource ID.
        :param Sequence['IpsecPolicyResponse'] ipsec_policies: The IPSec Policies to be considered by this connection.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'SubResourceResponse' remote_vpn_site: Id of the connected vpn site.
        :param 'RoutingConfigurationResponse' routing_configuration: The Routing Configuration indicating the associated and propagated route tables on this connection.
        :param int routing_weight: Routing weight for vpn connection.
        :param str shared_key: SharedKey for the vpn connection.
        :param bool use_local_azure_ip_address: Use local azure ip to initiate connection.
        :param bool use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
        :param str vpn_connection_protocol_type: Connection protocol used for this connection.
        :param Sequence['VpnSiteLinkConnectionResponse'] vpn_link_connections: List of all vpn site link connections to the gateway.
        """
        pulumi.set(__self__, "connection_status", connection_status)
        pulumi.set(__self__, "egress_bytes_transferred", egress_bytes_transferred)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "ingress_bytes_transferred", ingress_bytes_transferred)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if connection_bandwidth is not None:
            pulumi.set(__self__, "connection_bandwidth", connection_bandwidth)
        if dpd_timeout_seconds is not None:
            pulumi.set(__self__, "dpd_timeout_seconds", dpd_timeout_seconds)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if enable_internet_security is not None:
            pulumi.set(__self__, "enable_internet_security", enable_internet_security)
        if enable_rate_limiting is not None:
            pulumi.set(__self__, "enable_rate_limiting", enable_rate_limiting)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ipsec_policies is not None:
            pulumi.set(__self__, "ipsec_policies", ipsec_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remote_vpn_site is not None:
            pulumi.set(__self__, "remote_vpn_site", remote_vpn_site)
        if routing_configuration is not None:
            pulumi.set(__self__, "routing_configuration", routing_configuration)
        if routing_weight is not None:
            pulumi.set(__self__, "routing_weight", routing_weight)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if use_local_azure_ip_address is not None:
            pulumi.set(__self__, "use_local_azure_ip_address", use_local_azure_ip_address)
        if use_policy_based_traffic_selectors is not None:
            pulumi.set(__self__, "use_policy_based_traffic_selectors", use_policy_based_traffic_selectors)
        if vpn_connection_protocol_type is not None:
            pulumi.set(__self__, "vpn_connection_protocol_type", vpn_connection_protocol_type)
        if vpn_link_connections is not None:
            pulumi.set(__self__, "vpn_link_connections", vpn_link_connections)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> str:
        """
        The connection status.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="egressBytesTransferred")
    def egress_bytes_transferred(self) -> float:
        """
        Egress bytes transferred.
        """
        return pulumi.get(self, "egress_bytes_transferred")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="ingressBytesTransferred")
    def ingress_bytes_transferred(self) -> float:
        """
        Ingress bytes transferred.
        """
        return pulumi.get(self, "ingress_bytes_transferred")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VPN connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="connectionBandwidth")
    def connection_bandwidth(self) -> Optional[int]:
        """
        Expected bandwidth in MBPS.
        """
        return pulumi.get(self, "connection_bandwidth")

    @property
    @pulumi.getter(name="dpdTimeoutSeconds")
    def dpd_timeout_seconds(self) -> Optional[int]:
        """
        The dead peer detection timeout for a vpn connection in seconds.
        """
        return pulumi.get(self, "dpd_timeout_seconds")

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[bool]:
        """
        EnableBgp flag.
        """
        return pulumi.get(self, "enable_bgp")

    @property
    @pulumi.getter(name="enableInternetSecurity")
    def enable_internet_security(self) -> Optional[bool]:
        """
        Enable internet security.
        """
        return pulumi.get(self, "enable_internet_security")

    @property
    @pulumi.getter(name="enableRateLimiting")
    def enable_rate_limiting(self) -> Optional[bool]:
        """
        EnableBgp flag.
        """
        return pulumi.get(self, "enable_rate_limiting")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipsecPolicies")
    def ipsec_policies(self) -> Optional[Sequence['outputs.IpsecPolicyResponse']]:
        """
        The IPSec Policies to be considered by this connection.
        """
        return pulumi.get(self, "ipsec_policies")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="remoteVpnSite")
    def remote_vpn_site(self) -> Optional['outputs.SubResourceResponse']:
        """
        Id of the connected vpn site.
        """
        return pulumi.get(self, "remote_vpn_site")

    @property
    @pulumi.getter(name="routingConfiguration")
    def routing_configuration(self) -> Optional['outputs.RoutingConfigurationResponse']:
        """
        The Routing Configuration indicating the associated and propagated route tables on this connection.
        """
        return pulumi.get(self, "routing_configuration")

    @property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> Optional[int]:
        """
        Routing weight for vpn connection.
        """
        return pulumi.get(self, "routing_weight")

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[str]:
        """
        SharedKey for the vpn connection.
        """
        return pulumi.get(self, "shared_key")

    @property
    @pulumi.getter(name="useLocalAzureIpAddress")
    def use_local_azure_ip_address(self) -> Optional[bool]:
        """
        Use local azure ip to initiate connection.
        """
        return pulumi.get(self, "use_local_azure_ip_address")

    @property
    @pulumi.getter(name="usePolicyBasedTrafficSelectors")
    def use_policy_based_traffic_selectors(self) -> Optional[bool]:
        """
        Enable policy-based traffic selectors.
        """
        return pulumi.get(self, "use_policy_based_traffic_selectors")

    @property
    @pulumi.getter(name="vpnConnectionProtocolType")
    def vpn_connection_protocol_type(self) -> Optional[str]:
        """
        Connection protocol used for this connection.
        """
        return pulumi.get(self, "vpn_connection_protocol_type")

    @property
    @pulumi.getter(name="vpnLinkConnections")
    def vpn_link_connections(self) -> Optional[Sequence['outputs.VpnSiteLinkConnectionResponse']]:
        """
        List of all vpn site link connections to the gateway.
        """
        return pulumi.get(self, "vpn_link_connections")


@pulumi.output_type
class VpnLinkBgpSettingsResponse(dict):
    """
    BGP settings details for a link.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bgpPeeringAddress":
            suggest = "bgp_peering_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnLinkBgpSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnLinkBgpSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnLinkBgpSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asn: Optional[float] = None,
                 bgp_peering_address: Optional[str] = None):
        """
        BGP settings details for a link.
        :param float asn: The BGP speaker's ASN.
        :param str bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if bgp_peering_address is not None:
            pulumi.set(__self__, "bgp_peering_address", bgp_peering_address)

    @property
    @pulumi.getter
    def asn(self) -> Optional[float]:
        """
        The BGP speaker's ASN.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="bgpPeeringAddress")
    def bgp_peering_address(self) -> Optional[str]:
        """
        The BGP peering address and BGP identifier of this BGP speaker.
        """
        return pulumi.get(self, "bgp_peering_address")


@pulumi.output_type
class VpnLinkProviderPropertiesResponse(dict):
    """
    List of properties of a link provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkProviderName":
            suggest = "link_provider_name"
        elif key == "linkSpeedInMbps":
            suggest = "link_speed_in_mbps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnLinkProviderPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnLinkProviderPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnLinkProviderPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 link_provider_name: Optional[str] = None,
                 link_speed_in_mbps: Optional[int] = None):
        """
        List of properties of a link provider.
        :param str link_provider_name: Name of the link provider.
        :param int link_speed_in_mbps: Link speed.
        """
        if link_provider_name is not None:
            pulumi.set(__self__, "link_provider_name", link_provider_name)
        if link_speed_in_mbps is not None:
            pulumi.set(__self__, "link_speed_in_mbps", link_speed_in_mbps)

    @property
    @pulumi.getter(name="linkProviderName")
    def link_provider_name(self) -> Optional[str]:
        """
        Name of the link provider.
        """
        return pulumi.get(self, "link_provider_name")

    @property
    @pulumi.getter(name="linkSpeedInMbps")
    def link_speed_in_mbps(self) -> Optional[int]:
        """
        Link speed.
        """
        return pulumi.get(self, "link_speed_in_mbps")


@pulumi.output_type
class VpnServerConfigRadiusClientRootCertificateResponse(dict):
    """
    Properties of the Radius client root certificate of VpnServerConfiguration.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        Properties of the Radius client root certificate of VpnServerConfiguration.
        :param str name: The certificate name.
        :param str thumbprint: The Radius client root certificate thumbprint.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The certificate name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The Radius client root certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class VpnServerConfigRadiusServerRootCertificateResponse(dict):
    """
    Properties of Radius Server root certificate of VpnServerConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicCertData":
            suggest = "public_cert_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnServerConfigRadiusServerRootCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnServerConfigRadiusServerRootCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnServerConfigRadiusServerRootCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 public_cert_data: Optional[str] = None):
        """
        Properties of Radius Server root certificate of VpnServerConfiguration.
        :param str name: The certificate name.
        :param str public_cert_data: The certificate public data.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_cert_data is not None:
            pulumi.set(__self__, "public_cert_data", public_cert_data)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The certificate name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> Optional[str]:
        """
        The certificate public data.
        """
        return pulumi.get(self, "public_cert_data")


@pulumi.output_type
class VpnServerConfigVpnClientRevokedCertificateResponse(dict):
    """
    Properties of the revoked VPN client certificate of VpnServerConfiguration.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        Properties of the revoked VPN client certificate of VpnServerConfiguration.
        :param str name: The certificate name.
        :param str thumbprint: The revoked VPN client certificate thumbprint.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The certificate name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The revoked VPN client certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class VpnServerConfigVpnClientRootCertificateResponse(dict):
    """
    Properties of VPN client root certificate of VpnServerConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicCertData":
            suggest = "public_cert_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnServerConfigVpnClientRootCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnServerConfigVpnClientRootCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnServerConfigVpnClientRootCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 public_cert_data: Optional[str] = None):
        """
        Properties of VPN client root certificate of VpnServerConfiguration.
        :param str name: The certificate name.
        :param str public_cert_data: The certificate public data.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_cert_data is not None:
            pulumi.set(__self__, "public_cert_data", public_cert_data)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The certificate name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> Optional[str]:
        """
        The certificate public data.
        """
        return pulumi.get(self, "public_cert_data")


@pulumi.output_type
class VpnSiteLinkConnectionResponse(dict):
    """
    VpnSiteLinkConnection Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionStatus":
            suggest = "connection_status"
        elif key == "egressBytesTransferred":
            suggest = "egress_bytes_transferred"
        elif key == "ingressBytesTransferred":
            suggest = "ingress_bytes_transferred"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "connectionBandwidth":
            suggest = "connection_bandwidth"
        elif key == "enableBgp":
            suggest = "enable_bgp"
        elif key == "enableRateLimiting":
            suggest = "enable_rate_limiting"
        elif key == "ipsecPolicies":
            suggest = "ipsec_policies"
        elif key == "routingWeight":
            suggest = "routing_weight"
        elif key == "sharedKey":
            suggest = "shared_key"
        elif key == "useLocalAzureIpAddress":
            suggest = "use_local_azure_ip_address"
        elif key == "usePolicyBasedTrafficSelectors":
            suggest = "use_policy_based_traffic_selectors"
        elif key == "vpnConnectionProtocolType":
            suggest = "vpn_connection_protocol_type"
        elif key == "vpnSiteLink":
            suggest = "vpn_site_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnSiteLinkConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnSiteLinkConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnSiteLinkConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_status: str,
                 egress_bytes_transferred: float,
                 etag: str,
                 ingress_bytes_transferred: float,
                 provisioning_state: str,
                 type: str,
                 connection_bandwidth: Optional[int] = None,
                 enable_bgp: Optional[bool] = None,
                 enable_rate_limiting: Optional[bool] = None,
                 id: Optional[str] = None,
                 ipsec_policies: Optional[Sequence['outputs.IpsecPolicyResponse']] = None,
                 name: Optional[str] = None,
                 routing_weight: Optional[int] = None,
                 shared_key: Optional[str] = None,
                 use_local_azure_ip_address: Optional[bool] = None,
                 use_policy_based_traffic_selectors: Optional[bool] = None,
                 vpn_connection_protocol_type: Optional[str] = None,
                 vpn_site_link: Optional['outputs.SubResourceResponse'] = None):
        """
        VpnSiteLinkConnection Resource.
        :param str connection_status: The connection status.
        :param float egress_bytes_transferred: Egress bytes transferred.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param float ingress_bytes_transferred: Ingress bytes transferred.
        :param str provisioning_state: The provisioning state of the VPN site link connection resource.
        :param str type: Resource type.
        :param int connection_bandwidth: Expected bandwidth in MBPS.
        :param bool enable_bgp: EnableBgp flag.
        :param bool enable_rate_limiting: EnableBgp flag.
        :param str id: Resource ID.
        :param Sequence['IpsecPolicyResponse'] ipsec_policies: The IPSec Policies to be considered by this connection.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int routing_weight: Routing weight for vpn connection.
        :param str shared_key: SharedKey for the vpn connection.
        :param bool use_local_azure_ip_address: Use local azure ip to initiate connection.
        :param bool use_policy_based_traffic_selectors: Enable policy-based traffic selectors.
        :param str vpn_connection_protocol_type: Connection protocol used for this connection.
        :param 'SubResourceResponse' vpn_site_link: Id of the connected vpn site link.
        """
        pulumi.set(__self__, "connection_status", connection_status)
        pulumi.set(__self__, "egress_bytes_transferred", egress_bytes_transferred)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "ingress_bytes_transferred", ingress_bytes_transferred)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if connection_bandwidth is not None:
            pulumi.set(__self__, "connection_bandwidth", connection_bandwidth)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if enable_rate_limiting is not None:
            pulumi.set(__self__, "enable_rate_limiting", enable_rate_limiting)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ipsec_policies is not None:
            pulumi.set(__self__, "ipsec_policies", ipsec_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routing_weight is not None:
            pulumi.set(__self__, "routing_weight", routing_weight)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if use_local_azure_ip_address is not None:
            pulumi.set(__self__, "use_local_azure_ip_address", use_local_azure_ip_address)
        if use_policy_based_traffic_selectors is not None:
            pulumi.set(__self__, "use_policy_based_traffic_selectors", use_policy_based_traffic_selectors)
        if vpn_connection_protocol_type is not None:
            pulumi.set(__self__, "vpn_connection_protocol_type", vpn_connection_protocol_type)
        if vpn_site_link is not None:
            pulumi.set(__self__, "vpn_site_link", vpn_site_link)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> str:
        """
        The connection status.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="egressBytesTransferred")
    def egress_bytes_transferred(self) -> float:
        """
        Egress bytes transferred.
        """
        return pulumi.get(self, "egress_bytes_transferred")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="ingressBytesTransferred")
    def ingress_bytes_transferred(self) -> float:
        """
        Ingress bytes transferred.
        """
        return pulumi.get(self, "ingress_bytes_transferred")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VPN site link connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="connectionBandwidth")
    def connection_bandwidth(self) -> Optional[int]:
        """
        Expected bandwidth in MBPS.
        """
        return pulumi.get(self, "connection_bandwidth")

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[bool]:
        """
        EnableBgp flag.
        """
        return pulumi.get(self, "enable_bgp")

    @property
    @pulumi.getter(name="enableRateLimiting")
    def enable_rate_limiting(self) -> Optional[bool]:
        """
        EnableBgp flag.
        """
        return pulumi.get(self, "enable_rate_limiting")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipsecPolicies")
    def ipsec_policies(self) -> Optional[Sequence['outputs.IpsecPolicyResponse']]:
        """
        The IPSec Policies to be considered by this connection.
        """
        return pulumi.get(self, "ipsec_policies")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> Optional[int]:
        """
        Routing weight for vpn connection.
        """
        return pulumi.get(self, "routing_weight")

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[str]:
        """
        SharedKey for the vpn connection.
        """
        return pulumi.get(self, "shared_key")

    @property
    @pulumi.getter(name="useLocalAzureIpAddress")
    def use_local_azure_ip_address(self) -> Optional[bool]:
        """
        Use local azure ip to initiate connection.
        """
        return pulumi.get(self, "use_local_azure_ip_address")

    @property
    @pulumi.getter(name="usePolicyBasedTrafficSelectors")
    def use_policy_based_traffic_selectors(self) -> Optional[bool]:
        """
        Enable policy-based traffic selectors.
        """
        return pulumi.get(self, "use_policy_based_traffic_selectors")

    @property
    @pulumi.getter(name="vpnConnectionProtocolType")
    def vpn_connection_protocol_type(self) -> Optional[str]:
        """
        Connection protocol used for this connection.
        """
        return pulumi.get(self, "vpn_connection_protocol_type")

    @property
    @pulumi.getter(name="vpnSiteLink")
    def vpn_site_link(self) -> Optional['outputs.SubResourceResponse']:
        """
        Id of the connected vpn site link.
        """
        return pulumi.get(self, "vpn_site_link")


@pulumi.output_type
class VpnSiteLinkResponse(dict):
    """
    VpnSiteLink Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "bgpProperties":
            suggest = "bgp_properties"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "linkProperties":
            suggest = "link_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnSiteLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnSiteLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnSiteLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 type: str,
                 bgp_properties: Optional['outputs.VpnLinkBgpSettingsResponse'] = None,
                 fqdn: Optional[str] = None,
                 id: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 link_properties: Optional['outputs.VpnLinkProviderPropertiesResponse'] = None,
                 name: Optional[str] = None):
        """
        VpnSiteLink Resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the VPN site link resource.
        :param str type: Resource type.
        :param 'VpnLinkBgpSettingsResponse' bgp_properties: The set of bgp properties.
        :param str fqdn: FQDN of vpn-site-link.
        :param str id: Resource ID.
        :param str ip_address: The ip-address for the vpn-site-link.
        :param 'VpnLinkProviderPropertiesResponse' link_properties: The link provider properties.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if bgp_properties is not None:
            pulumi.set(__self__, "bgp_properties", bgp_properties)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if link_properties is not None:
            pulumi.set(__self__, "link_properties", link_properties)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VPN site link resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="bgpProperties")
    def bgp_properties(self) -> Optional['outputs.VpnLinkBgpSettingsResponse']:
        """
        The set of bgp properties.
        """
        return pulumi.get(self, "bgp_properties")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        FQDN of vpn-site-link.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The ip-address for the vpn-site-link.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="linkProperties")
    def link_properties(self) -> Optional['outputs.VpnLinkProviderPropertiesResponse']:
        """
        The link provider properties.
        """
        return pulumi.get(self, "link_properties")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WebApplicationFirewallCustomRuleResponse(dict):
    """
    Defines contents of a web application rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchConditions":
            suggest = "match_conditions"
        elif key == "ruleType":
            suggest = "rule_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebApplicationFirewallCustomRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebApplicationFirewallCustomRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebApplicationFirewallCustomRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 etag: str,
                 match_conditions: Sequence['outputs.MatchConditionResponse'],
                 priority: int,
                 rule_type: str,
                 name: Optional[str] = None):
        """
        Defines contents of a web application rule.
        :param str action: Type of Actions.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param Sequence['MatchConditionResponse'] match_conditions: List of match conditions.
        :param int priority: Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
        :param str rule_type: The rule type.
        :param str name: The name of the resource that is unique within a policy. This name can be used to access the resource.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "match_conditions", match_conditions)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_type", rule_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Type of Actions.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Sequence['outputs.MatchConditionResponse']:
        """
        List of match conditions.
        """
        return pulumi.get(self, "match_conditions")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The rule type.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a policy. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


