# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AccountEncryptionKeyType',
    'DefaultAction',
    'MinimumTlsVersion',
    'PrivateEndpointServiceConnectionStatus',
    'PublicNetworkAccess',
    'StorageAccountType',
    'StorageAuthentication',
]


class AccountEncryptionKeyType(str, Enum):
    """
    The type of key used to encrypt the Account Key.
    """
    SYSTEM_KEY = "SystemKey"
    """
    The Account Key is encrypted with a System Key.
    """
    CUSTOMER_KEY = "CustomerKey"
    """
    The Account Key is encrypted with a Customer Key.
    """


class DefaultAction(str, Enum):
    """
    The behavior for IP access control in Key Delivery.
    """
    ALLOW = "Allow"
    """
    All public IP addresses are allowed.
    """
    DENY = "Deny"
    """
    Public IP addresses are blocked.
    """


class MinimumTlsVersion(str, Enum):
    """
    The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used.
    """
    TLS10 = "Tls10"
    """
    Minimum TLS version is TLS 1.0.
    """
    TLS11 = "Tls11"
    """
    Minimum TLS version is TLS 1.1.
    """
    TLS12 = "Tls12"
    """
    Minimum TLS version is TLS 1.2.
    """
    TLS13 = "Tls13"
    """
    Minimum TLS version is TLS 1.3.
    """


class PrivateEndpointServiceConnectionStatus(str, Enum):
    """
    Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
    """
    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class PublicNetworkAccess(str, Enum):
    """
    Whether or not public network access is allowed for resources under the Media Services account.
    """
    ENABLED = "Enabled"
    """
    Public network access is enabled.
    """
    DISABLED = "Disabled"
    """
    Public network access is disabled.
    """


class StorageAccountType(str, Enum):
    """
    The type of the storage account.
    """
    PRIMARY = "Primary"
    """
    The primary storage account for the Media Services account.
    """
    SECONDARY = "Secondary"
    """
    A secondary storage account for the Media Services account.
    """


class StorageAuthentication(str, Enum):
    SYSTEM = "System"
    """
    System authentication.
    """
    MANAGED_IDENTITY = "ManagedIdentity"
    """
    Managed Identity authentication.
    """
