# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessPolicyEntryResponse',
    'IPRuleResponse',
    'KeyAttributesResponse',
    'MHSMIPRuleResponse',
    'MHSMNetworkRuleSetResponse',
    'MHSMPrivateEndpointConnectionItemResponse',
    'MHSMPrivateEndpointResponse',
    'MHSMPrivateLinkServiceConnectionStateResponse',
    'MHSMVirtualNetworkRuleResponse',
    'ManagedHsmPropertiesResponse',
    'ManagedHsmSkuResponse',
    'NetworkRuleSetResponse',
    'PermissionsResponse',
    'PrivateEndpointConnectionItemResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'SecretAttributesResponse',
    'SecretPropertiesResponse',
    'SkuResponse',
    'SystemDataResponse',
    'VaultPropertiesResponse',
    'VirtualNetworkRuleResponse',
]

@pulumi.output_type
class AccessPolicyEntryResponse(dict):
    """
    An identity that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "applicationId":
            suggest = "application_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessPolicyEntryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessPolicyEntryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessPolicyEntryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id: str,
                 permissions: 'outputs.PermissionsResponse',
                 tenant_id: str,
                 application_id: Optional[str] = None):
        """
        An identity that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
        :param str object_id: The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
        :param 'PermissionsResponse' permissions: Permissions the identity has for keys, secrets and certificates.
        :param str tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        :param str application_id:  Application ID of the client making request on behalf of a principal
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> str:
        """
        The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter
    def permissions(self) -> 'outputs.PermissionsResponse':
        """
        Permissions the identity has for keys, secrets and certificates.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
         Application ID of the client making request on behalf of a principal
        """
        return pulumi.get(self, "application_id")


@pulumi.output_type
class IPRuleResponse(dict):
    """
    A rule governing the accessibility of a vault from a specific ip address or ip range.
    """
    def __init__(__self__, *,
                 value: str):
        """
        A rule governing the accessibility of a vault from a specific ip address or ip range.
        :param str value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class KeyAttributesResponse(dict):
    """
    The attributes of the key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recoveryLevel":
            suggest = "recovery_level"
        elif key == "notBefore":
            suggest = "not_before"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyAttributesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyAttributesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyAttributesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created: float,
                 recovery_level: str,
                 updated: float,
                 enabled: Optional[bool] = None,
                 expires: Optional[float] = None,
                 not_before: Optional[float] = None):
        """
        The attributes of the key.
        :param float created: Creation time in seconds since 1970-01-01T00:00:00Z.
        :param str recovery_level: The deletion recovery level currently in effect for the object. If it contains 'Purgeable', then the object can be permanently deleted by a privileged user; otherwise, only the system can purge the object at the end of the retention interval.
        :param float updated: Last updated time in seconds since 1970-01-01T00:00:00Z.
        :param bool enabled: Determines whether or not the object is enabled.
        :param float expires: Expiry date in seconds since 1970-01-01T00:00:00Z.
        :param float not_before: Not before date in seconds since 1970-01-01T00:00:00Z.
        """
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "recovery_level", recovery_level)
        pulumi.set(__self__, "updated", updated)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if not_before is not None:
            pulumi.set(__self__, "not_before", not_before)

    @property
    @pulumi.getter
    def created(self) -> float:
        """
        Creation time in seconds since 1970-01-01T00:00:00Z.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="recoveryLevel")
    def recovery_level(self) -> str:
        """
        The deletion recovery level currently in effect for the object. If it contains 'Purgeable', then the object can be permanently deleted by a privileged user; otherwise, only the system can purge the object at the end of the retention interval.
        """
        return pulumi.get(self, "recovery_level")

    @property
    @pulumi.getter
    def updated(self) -> float:
        """
        Last updated time in seconds since 1970-01-01T00:00:00Z.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Determines whether or not the object is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def expires(self) -> Optional[float]:
        """
        Expiry date in seconds since 1970-01-01T00:00:00Z.
        """
        return pulumi.get(self, "expires")

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> Optional[float]:
        """
        Not before date in seconds since 1970-01-01T00:00:00Z.
        """
        return pulumi.get(self, "not_before")


@pulumi.output_type
class MHSMIPRuleResponse(dict):
    """
    A rule governing the accessibility of a managed hsm pool from a specific ip address or ip range.
    """
    def __init__(__self__, *,
                 value: str):
        """
        A rule governing the accessibility of a managed hsm pool from a specific ip address or ip range.
        :param str value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MHSMNetworkRuleSetResponse(dict):
    """
    A set of rules governing the network accessibility of a managed hsm pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "virtualNetworkRules":
            suggest = "virtual_network_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MHSMNetworkRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MHSMNetworkRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MHSMNetworkRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bypass: Optional[str] = None,
                 default_action: Optional[str] = None,
                 ip_rules: Optional[Sequence['outputs.MHSMIPRuleResponse']] = None,
                 virtual_network_rules: Optional[Sequence['outputs.MHSMVirtualNetworkRuleResponse']] = None):
        """
        A set of rules governing the network accessibility of a managed hsm pool.
        :param str bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
        :param str default_action: The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
        :param Sequence['MHSMIPRuleResponse'] ip_rules: The list of IP address rules.
        :param Sequence['MHSMVirtualNetworkRuleResponse'] virtual_network_rules: The list of virtual network rules.
        """
        if bypass is None:
            bypass = 'AzureServices'
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if default_action is None:
            default_action = 'Allow'
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter
    def bypass(self) -> Optional[str]:
        """
        Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
        """
        return pulumi.get(self, "bypass")

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[str]:
        """
        The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence['outputs.MHSMIPRuleResponse']]:
        """
        The list of IP address rules.
        """
        return pulumi.get(self, "ip_rules")

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[Sequence['outputs.MHSMVirtualNetworkRuleResponse']]:
        """
        The list of virtual network rules.
        """
        return pulumi.get(self, "virtual_network_rules")


@pulumi.output_type
class MHSMPrivateEndpointConnectionItemResponse(dict):
    """
    Private endpoint connection item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MHSMPrivateEndpointConnectionItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MHSMPrivateEndpointConnectionItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MHSMPrivateEndpointConnectionItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 private_endpoint: Optional['outputs.MHSMPrivateEndpointResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.MHSMPrivateLinkServiceConnectionStateResponse'] = None):
        """
        Private endpoint connection item.
        :param str provisioning_state: Provisioning state of the private endpoint connection.
        :param str etag: Modified whenever there is a change in the state of private endpoint connection.
        :param str id: Id of private endpoint connection.
        :param 'MHSMPrivateEndpointResponse' private_endpoint: Properties of the private endpoint object.
        :param 'MHSMPrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: Approval state of the private link connection.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Modified whenever there is a change in the state of private endpoint connection.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of private endpoint connection.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.MHSMPrivateEndpointResponse']:
        """
        Properties of the private endpoint object.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.MHSMPrivateLinkServiceConnectionStateResponse']:
        """
        Approval state of the private link connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class MHSMPrivateEndpointResponse(dict):
    """
    Private endpoint object properties.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Private endpoint object properties.
        :param str id: Full identifier of the private endpoint resource.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Full identifier of the private endpoint resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class MHSMPrivateLinkServiceConnectionStateResponse(dict):
    """
    An object that represents the approval state of the private link connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MHSMPrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MHSMPrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MHSMPrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        An object that represents the approval state of the private link connection.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval or rejection.
        :param str status: Indicates whether the connection has been approved, rejected or removed by the key vault owner.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval or rejection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been approved, rejected or removed by the key vault owner.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class MHSMVirtualNetworkRuleResponse(dict):
    """
    A rule governing the accessibility of a managed hsm pool from a specific virtual network.
    """
    def __init__(__self__, *,
                 id: str):
        """
        A rule governing the accessibility of a managed hsm pool from a specific virtual network.
        :param str id: Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ManagedHsmPropertiesResponse(dict):
    """
    Properties of the managed HSM Pool
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hsmUri":
            suggest = "hsm_uri"
        elif key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "scheduledPurgeDate":
            suggest = "scheduled_purge_date"
        elif key == "statusMessage":
            suggest = "status_message"
        elif key == "enablePurgeProtection":
            suggest = "enable_purge_protection"
        elif key == "enableSoftDelete":
            suggest = "enable_soft_delete"
        elif key == "initialAdminObjectIds":
            suggest = "initial_admin_object_ids"
        elif key == "networkAcls":
            suggest = "network_acls"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"
        elif key == "softDeleteRetentionInDays":
            suggest = "soft_delete_retention_in_days"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedHsmPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedHsmPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedHsmPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hsm_uri: str,
                 private_endpoint_connections: Sequence['outputs.MHSMPrivateEndpointConnectionItemResponse'],
                 provisioning_state: str,
                 scheduled_purge_date: str,
                 status_message: str,
                 enable_purge_protection: Optional[bool] = None,
                 enable_soft_delete: Optional[bool] = None,
                 initial_admin_object_ids: Optional[Sequence[str]] = None,
                 network_acls: Optional['outputs.MHSMNetworkRuleSetResponse'] = None,
                 public_network_access: Optional[str] = None,
                 soft_delete_retention_in_days: Optional[int] = None,
                 tenant_id: Optional[str] = None):
        """
        Properties of the managed HSM Pool
        :param str hsm_uri: The URI of the managed hsm pool for performing operations on keys.
        :param Sequence['MHSMPrivateEndpointConnectionItemResponse'] private_endpoint_connections: List of private endpoint connections associated with the managed hsm pool.
        :param str provisioning_state: Provisioning state.
        :param str scheduled_purge_date: The scheduled purge date in UTC.
        :param str status_message: Resource Status Message.
        :param bool enable_purge_protection: Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true activates protection against purge for this managed HSM pool and its content - only the Managed HSM service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible.
        :param bool enable_soft_delete: Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. If it's not set to any value(true or false) when creating new managed HSM pool, it will be set to true by default. Once set to true, it cannot be reverted to false.
        :param Sequence[str] initial_admin_object_ids: Array of initial administrators object ids for this managed hsm pool.
        :param 'MHSMNetworkRuleSetResponse' network_acls: Rules governing the accessibility of the key vault from specific network locations.
        :param str public_network_access: Control permission for data plane traffic coming from public networks while private endpoint is enabled.
        :param int soft_delete_retention_in_days: softDelete data retention days. It accepts >=7 and <=90.
        :param str tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool.
        """
        pulumi.set(__self__, "hsm_uri", hsm_uri)
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "scheduled_purge_date", scheduled_purge_date)
        pulumi.set(__self__, "status_message", status_message)
        if enable_purge_protection is None:
            enable_purge_protection = True
        if enable_purge_protection is not None:
            pulumi.set(__self__, "enable_purge_protection", enable_purge_protection)
        if enable_soft_delete is None:
            enable_soft_delete = True
        if enable_soft_delete is not None:
            pulumi.set(__self__, "enable_soft_delete", enable_soft_delete)
        if initial_admin_object_ids is not None:
            pulumi.set(__self__, "initial_admin_object_ids", initial_admin_object_ids)
        if network_acls is not None:
            pulumi.set(__self__, "network_acls", network_acls)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if soft_delete_retention_in_days is None:
            soft_delete_retention_in_days = 90
        if soft_delete_retention_in_days is not None:
            pulumi.set(__self__, "soft_delete_retention_in_days", soft_delete_retention_in_days)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="hsmUri")
    def hsm_uri(self) -> str:
        """
        The URI of the managed hsm pool for performing operations on keys.
        """
        return pulumi.get(self, "hsm_uri")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.MHSMPrivateEndpointConnectionItemResponse']:
        """
        List of private endpoint connections associated with the managed hsm pool.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="scheduledPurgeDate")
    def scheduled_purge_date(self) -> str:
        """
        The scheduled purge date in UTC.
        """
        return pulumi.get(self, "scheduled_purge_date")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Resource Status Message.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="enablePurgeProtection")
    def enable_purge_protection(self) -> Optional[bool]:
        """
        Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true activates protection against purge for this managed HSM pool and its content - only the Managed HSM service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible.
        """
        return pulumi.get(self, "enable_purge_protection")

    @property
    @pulumi.getter(name="enableSoftDelete")
    def enable_soft_delete(self) -> Optional[bool]:
        """
        Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. If it's not set to any value(true or false) when creating new managed HSM pool, it will be set to true by default. Once set to true, it cannot be reverted to false.
        """
        return pulumi.get(self, "enable_soft_delete")

    @property
    @pulumi.getter(name="initialAdminObjectIds")
    def initial_admin_object_ids(self) -> Optional[Sequence[str]]:
        """
        Array of initial administrators object ids for this managed hsm pool.
        """
        return pulumi.get(self, "initial_admin_object_ids")

    @property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional['outputs.MHSMNetworkRuleSetResponse']:
        """
        Rules governing the accessibility of the key vault from specific network locations.
        """
        return pulumi.get(self, "network_acls")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        Control permission for data plane traffic coming from public networks while private endpoint is enabled.
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter(name="softDeleteRetentionInDays")
    def soft_delete_retention_in_days(self) -> Optional[int]:
        """
        softDelete data retention days. It accepts >=7 and <=90.
        """
        return pulumi.get(self, "soft_delete_retention_in_days")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ManagedHsmSkuResponse(dict):
    """
    SKU details
    """
    def __init__(__self__, *,
                 family: str,
                 name: str):
        """
        SKU details
        :param str family: SKU Family of the managed HSM Pool
        :param str name: SKU of the managed HSM Pool
        """
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def family(self) -> str:
        """
        SKU Family of the managed HSM Pool
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        SKU of the managed HSM Pool
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NetworkRuleSetResponse(dict):
    """
    A set of rules governing the network accessibility of a vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "virtualNetworkRules":
            suggest = "virtual_network_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bypass: Optional[str] = None,
                 default_action: Optional[str] = None,
                 ip_rules: Optional[Sequence['outputs.IPRuleResponse']] = None,
                 virtual_network_rules: Optional[Sequence['outputs.VirtualNetworkRuleResponse']] = None):
        """
        A set of rules governing the network accessibility of a vault.
        :param str bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
        :param str default_action: The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
        :param Sequence['IPRuleResponse'] ip_rules: The list of IP address rules.
        :param Sequence['VirtualNetworkRuleResponse'] virtual_network_rules: The list of virtual network rules.
        """
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter
    def bypass(self) -> Optional[str]:
        """
        Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'.
        """
        return pulumi.get(self, "bypass")

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[str]:
        """
        The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence['outputs.IPRuleResponse']]:
        """
        The list of IP address rules.
        """
        return pulumi.get(self, "ip_rules")

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[Sequence['outputs.VirtualNetworkRuleResponse']]:
        """
        The list of virtual network rules.
        """
        return pulumi.get(self, "virtual_network_rules")


@pulumi.output_type
class PermissionsResponse(dict):
    """
    Permissions the identity has for keys, secrets, certificates and storage.
    """
    def __init__(__self__, *,
                 certificates: Optional[Sequence[str]] = None,
                 keys: Optional[Sequence[str]] = None,
                 secrets: Optional[Sequence[str]] = None,
                 storage: Optional[Sequence[str]] = None):
        """
        Permissions the identity has for keys, secrets, certificates and storage.
        :param Sequence[str] certificates: Permissions to certificates
        :param Sequence[str] keys: Permissions to keys
        :param Sequence[str] secrets: Permissions to secrets
        :param Sequence[str] storage: Permissions to storage accounts
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[Sequence[str]]:
        """
        Permissions to certificates
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[str]]:
        """
        Permissions to keys
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence[str]]:
        """
        Permissions to secrets
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def storage(self) -> Optional[Sequence[str]]:
        """
        Permissions to storage accounts
        """
        return pulumi.get(self, "storage")


@pulumi.output_type
class PrivateEndpointConnectionItemResponse(dict):
    """
    Private endpoint connection item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None):
        """
        Private endpoint connection item.
        :param str provisioning_state: Provisioning state of the private endpoint connection.
        :param str etag: Modified whenever there is a change in the state of private endpoint connection.
        :param str id: Id of private endpoint connection.
        :param 'PrivateEndpointResponse' private_endpoint: Properties of the private endpoint object.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: Approval state of the private link connection.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Modified whenever there is a change in the state of private endpoint connection.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of private endpoint connection.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        Properties of the private endpoint object.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        Approval state of the private link connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    Private endpoint object properties.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Private endpoint object properties.
        :param str id: Full identifier of the private endpoint resource.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Full identifier of the private endpoint resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    An object that represents the approval state of the private link connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        An object that represents the approval state of the private link connection.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval or rejection.
        :param str status: Indicates whether the connection has been approved, rejected or removed by the key vault owner.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval or rejection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been approved, rejected or removed by the key vault owner.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SecretAttributesResponse(dict):
    """
    The secret management attributes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notBefore":
            suggest = "not_before"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretAttributesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretAttributesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretAttributesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created: int,
                 updated: int,
                 enabled: Optional[bool] = None,
                 expires: Optional[int] = None,
                 not_before: Optional[int] = None):
        """
        The secret management attributes.
        :param int created: Creation time in seconds since 1970-01-01T00:00:00Z.
        :param int updated: Last updated time in seconds since 1970-01-01T00:00:00Z.
        :param bool enabled: Determines whether the object is enabled.
        :param int expires: Expiry date in seconds since 1970-01-01T00:00:00Z.
        :param int not_before: Not before date in seconds since 1970-01-01T00:00:00Z.
        """
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "updated", updated)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if not_before is not None:
            pulumi.set(__self__, "not_before", not_before)

    @property
    @pulumi.getter
    def created(self) -> int:
        """
        Creation time in seconds since 1970-01-01T00:00:00Z.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def updated(self) -> int:
        """
        Last updated time in seconds since 1970-01-01T00:00:00Z.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Determines whether the object is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def expires(self) -> Optional[int]:
        """
        Expiry date in seconds since 1970-01-01T00:00:00Z.
        """
        return pulumi.get(self, "expires")

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> Optional[int]:
        """
        Not before date in seconds since 1970-01-01T00:00:00Z.
        """
        return pulumi.get(self, "not_before")


@pulumi.output_type
class SecretPropertiesResponse(dict):
    """
    Properties of the secret
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUri":
            suggest = "secret_uri"
        elif key == "secretUriWithVersion":
            suggest = "secret_uri_with_version"
        elif key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_uri: str,
                 secret_uri_with_version: str,
                 attributes: Optional['outputs.SecretAttributesResponse'] = None,
                 content_type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Properties of the secret
        :param str secret_uri: The URI to retrieve the current version of the secret.
        :param str secret_uri_with_version: The URI to retrieve the specific version of the secret.
        :param 'SecretAttributesResponse' attributes: The attributes of the secret.
        :param str content_type: The content type of the secret.
        :param str value: The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using this model are is intended for internal use in ARM deployments. Users should use the data-plane REST service for interaction with vault secrets.
        """
        pulumi.set(__self__, "secret_uri", secret_uri)
        pulumi.set(__self__, "secret_uri_with_version", secret_uri_with_version)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="secretUri")
    def secret_uri(self) -> str:
        """
        The URI to retrieve the current version of the secret.
        """
        return pulumi.get(self, "secret_uri")

    @property
    @pulumi.getter(name="secretUriWithVersion")
    def secret_uri_with_version(self) -> str:
        """
        The URI to retrieve the specific version of the secret.
        """
        return pulumi.get(self, "secret_uri_with_version")

    @property
    @pulumi.getter
    def attributes(self) -> Optional['outputs.SecretAttributesResponse']:
        """
        The attributes of the secret.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The content type of the secret.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using this model are is intended for internal use in ARM deployments. Users should use the data-plane REST service for interaction with vault secrets.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SkuResponse(dict):
    """
    SKU details
    """
    def __init__(__self__, *,
                 family: str,
                 name: str):
        """
        SKU details
        :param str family: SKU family name
        :param str name: SKU name to specify whether the key vault is a standard vault or a premium vault.
        """
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def family(self) -> str:
        """
        SKU family name
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        SKU name to specify whether the key vault is a standard vault or a premium vault.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the key vault resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the key vault resource.
        :param str created_at: The timestamp of the key vault resource creation (UTC).
        :param str created_by: The identity that created the key vault resource.
        :param str created_by_type: The type of identity that created the key vault resource.
        :param str last_modified_at: The timestamp of the key vault resource last modification (UTC).
        :param str last_modified_by: The identity that last modified the key vault resource.
        :param str last_modified_by_type: The type of identity that last modified the key vault resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of the key vault resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the key vault resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the key vault resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of the key vault resource last modification (UTC).
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the key vault resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the key vault resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class VaultPropertiesResponse(dict):
    """
    Properties of the vault
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hsmPoolResourceId":
            suggest = "hsm_pool_resource_id"
        elif key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "accessPolicies":
            suggest = "access_policies"
        elif key == "enablePurgeProtection":
            suggest = "enable_purge_protection"
        elif key == "enableRbacAuthorization":
            suggest = "enable_rbac_authorization"
        elif key == "enableSoftDelete":
            suggest = "enable_soft_delete"
        elif key == "enabledForDeployment":
            suggest = "enabled_for_deployment"
        elif key == "enabledForDiskEncryption":
            suggest = "enabled_for_disk_encryption"
        elif key == "enabledForTemplateDeployment":
            suggest = "enabled_for_template_deployment"
        elif key == "networkAcls":
            suggest = "network_acls"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "softDeleteRetentionInDays":
            suggest = "soft_delete_retention_in_days"
        elif key == "vaultUri":
            suggest = "vault_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hsm_pool_resource_id: str,
                 private_endpoint_connections: Sequence['outputs.PrivateEndpointConnectionItemResponse'],
                 sku: 'outputs.SkuResponse',
                 tenant_id: str,
                 access_policies: Optional[Sequence['outputs.AccessPolicyEntryResponse']] = None,
                 enable_purge_protection: Optional[bool] = None,
                 enable_rbac_authorization: Optional[bool] = None,
                 enable_soft_delete: Optional[bool] = None,
                 enabled_for_deployment: Optional[bool] = None,
                 enabled_for_disk_encryption: Optional[bool] = None,
                 enabled_for_template_deployment: Optional[bool] = None,
                 network_acls: Optional['outputs.NetworkRuleSetResponse'] = None,
                 provisioning_state: Optional[str] = None,
                 soft_delete_retention_in_days: Optional[int] = None,
                 vault_uri: Optional[str] = None):
        """
        Properties of the vault
        :param str hsm_pool_resource_id: The resource id of HSM Pool.
        :param Sequence['PrivateEndpointConnectionItemResponse'] private_endpoint_connections: List of private endpoint connections associated with the key vault.
        :param 'SkuResponse' sku: SKU details
        :param str tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        :param Sequence['AccessPolicyEntryResponse'] access_policies: An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
        :param bool enable_purge_protection: Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates protection against purge for this vault and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible - that is, the property does not accept false as its value.
        :param bool enable_rbac_authorization: Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC) for authorization of data actions, and the access policies specified in vault properties will be  ignored. When false, the key vault will use the access policies specified in vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or not specified, the vault is created with the default value of false. Note that management actions are always authorized with RBAC.
        :param bool enable_soft_delete: Property to specify whether the 'soft delete' functionality is enabled for this key vault. If it's not set to any value(true or false) when creating new key vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
        :param bool enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
        :param bool enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        :param bool enabled_for_template_deployment: Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
        :param 'NetworkRuleSetResponse' network_acls: Rules governing the accessibility of the key vault from specific network locations.
        :param str provisioning_state: Provisioning state of the vault.
        :param int soft_delete_retention_in_days: softDelete data retention days. It accepts >=7 and <=90.
        :param str vault_uri: The URI of the vault for performing operations on keys and secrets. This property is readonly
        """
        pulumi.set(__self__, "hsm_pool_resource_id", hsm_pool_resource_id)
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)
        if enable_purge_protection is not None:
            pulumi.set(__self__, "enable_purge_protection", enable_purge_protection)
        if enable_rbac_authorization is None:
            enable_rbac_authorization = False
        if enable_rbac_authorization is not None:
            pulumi.set(__self__, "enable_rbac_authorization", enable_rbac_authorization)
        if enable_soft_delete is None:
            enable_soft_delete = True
        if enable_soft_delete is not None:
            pulumi.set(__self__, "enable_soft_delete", enable_soft_delete)
        if enabled_for_deployment is not None:
            pulumi.set(__self__, "enabled_for_deployment", enabled_for_deployment)
        if enabled_for_disk_encryption is not None:
            pulumi.set(__self__, "enabled_for_disk_encryption", enabled_for_disk_encryption)
        if enabled_for_template_deployment is not None:
            pulumi.set(__self__, "enabled_for_template_deployment", enabled_for_template_deployment)
        if network_acls is not None:
            pulumi.set(__self__, "network_acls", network_acls)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if soft_delete_retention_in_days is None:
            soft_delete_retention_in_days = 90
        if soft_delete_retention_in_days is not None:
            pulumi.set(__self__, "soft_delete_retention_in_days", soft_delete_retention_in_days)
        if vault_uri is not None:
            pulumi.set(__self__, "vault_uri", vault_uri)

    @property
    @pulumi.getter(name="hsmPoolResourceId")
    def hsm_pool_resource_id(self) -> str:
        """
        The resource id of HSM Pool.
        """
        return pulumi.get(self, "hsm_pool_resource_id")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.PrivateEndpointConnectionItemResponse']:
        """
        List of private endpoint connections associated with the key vault.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter
    def sku(self) -> 'outputs.SkuResponse':
        """
        SKU details
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[Sequence['outputs.AccessPolicyEntryResponse']]:
        """
        An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
        """
        return pulumi.get(self, "access_policies")

    @property
    @pulumi.getter(name="enablePurgeProtection")
    def enable_purge_protection(self) -> Optional[bool]:
        """
        Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates protection against purge for this vault and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible - that is, the property does not accept false as its value.
        """
        return pulumi.get(self, "enable_purge_protection")

    @property
    @pulumi.getter(name="enableRbacAuthorization")
    def enable_rbac_authorization(self) -> Optional[bool]:
        """
        Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC) for authorization of data actions, and the access policies specified in vault properties will be  ignored. When false, the key vault will use the access policies specified in vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or not specified, the vault is created with the default value of false. Note that management actions are always authorized with RBAC.
        """
        return pulumi.get(self, "enable_rbac_authorization")

    @property
    @pulumi.getter(name="enableSoftDelete")
    def enable_soft_delete(self) -> Optional[bool]:
        """
        Property to specify whether the 'soft delete' functionality is enabled for this key vault. If it's not set to any value(true or false) when creating new key vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
        """
        return pulumi.get(self, "enable_soft_delete")

    @property
    @pulumi.getter(name="enabledForDeployment")
    def enabled_for_deployment(self) -> Optional[bool]:
        """
        Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
        """
        return pulumi.get(self, "enabled_for_deployment")

    @property
    @pulumi.getter(name="enabledForDiskEncryption")
    def enabled_for_disk_encryption(self) -> Optional[bool]:
        """
        Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        """
        return pulumi.get(self, "enabled_for_disk_encryption")

    @property
    @pulumi.getter(name="enabledForTemplateDeployment")
    def enabled_for_template_deployment(self) -> Optional[bool]:
        """
        Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
        """
        return pulumi.get(self, "enabled_for_template_deployment")

    @property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional['outputs.NetworkRuleSetResponse']:
        """
        Rules governing the accessibility of the key vault from specific network locations.
        """
        return pulumi.get(self, "network_acls")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the vault.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="softDeleteRetentionInDays")
    def soft_delete_retention_in_days(self) -> Optional[int]:
        """
        softDelete data retention days. It accepts >=7 and <=90.
        """
        return pulumi.get(self, "soft_delete_retention_in_days")

    @property
    @pulumi.getter(name="vaultUri")
    def vault_uri(self) -> Optional[str]:
        """
        The URI of the vault for performing operations on keys and secrets. This property is readonly
        """
        return pulumi.get(self, "vault_uri")


@pulumi.output_type
class VirtualNetworkRuleResponse(dict):
    """
    A rule governing the accessibility of a vault from a specific virtual network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreMissingVnetServiceEndpoint":
            suggest = "ignore_missing_vnet_service_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 ignore_missing_vnet_service_endpoint: Optional[bool] = None):
        """
        A rule governing the accessibility of a vault from a specific virtual network.
        :param str id: Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
        :param bool ignore_missing_vnet_service_endpoint: Property to specify whether NRP will ignore the check if parent subnet has serviceEndpoints configured.
        """
        pulumi.set(__self__, "id", id)
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[bool]:
        """
        Property to specify whether NRP will ignore the check if parent subnet has serviceEndpoints configured.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")


