# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs',
    'HeaderFieldArgs',
    'WebTestGeolocationArgs',
    'WebTestPropertiesConfigurationArgs',
    'WebTestPropertiesContentValidationArgs',
    'WebTestPropertiesRequestArgs',
    'WebTestPropertiesValidationRulesArgs',
]

@pulumi.input_type
class ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 help_url: Optional[pulumi.Input[str]] = None,
                 is_enabled_by_default: Optional[pulumi.Input[bool]] = None,
                 is_hidden: Optional[pulumi.Input[bool]] = None,
                 is_in_preview: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 supports_email_notifications: Optional[pulumi.Input[bool]] = None):
        """
        Static definitions of the ProactiveDetection configuration rule (same values for all components).
        :param pulumi.Input[str] description: The rule description
        :param pulumi.Input[str] display_name: The rule name as it is displayed in UI
        :param pulumi.Input[str] help_url: URL which displays additional info about the proactive detection rule
        :param pulumi.Input[bool] is_enabled_by_default: A flag indicating whether the rule is enabled by default
        :param pulumi.Input[bool] is_hidden: A flag indicating whether the rule is hidden (from the UI)
        :param pulumi.Input[bool] is_in_preview: A flag indicating whether the rule is in preview
        :param pulumi.Input[str] name: The rule name
        :param pulumi.Input[bool] supports_email_notifications: A flag indicating whether email notifications are supported for detections for this rule
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if help_url is not None:
            pulumi.set(__self__, "help_url", help_url)
        if is_enabled_by_default is not None:
            pulumi.set(__self__, "is_enabled_by_default", is_enabled_by_default)
        if is_hidden is not None:
            pulumi.set(__self__, "is_hidden", is_hidden)
        if is_in_preview is not None:
            pulumi.set(__self__, "is_in_preview", is_in_preview)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if supports_email_notifications is not None:
            pulumi.set(__self__, "supports_email_notifications", supports_email_notifications)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The rule description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The rule name as it is displayed in UI
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="helpUrl")
    def help_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL which displays additional info about the proactive detection rule
        """
        return pulumi.get(self, "help_url")

    @help_url.setter
    def help_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "help_url", value)

    @property
    @pulumi.getter(name="isEnabledByDefault")
    def is_enabled_by_default(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether the rule is enabled by default
        """
        return pulumi.get(self, "is_enabled_by_default")

    @is_enabled_by_default.setter
    def is_enabled_by_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled_by_default", value)

    @property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether the rule is hidden (from the UI)
        """
        return pulumi.get(self, "is_hidden")

    @is_hidden.setter
    def is_hidden(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_hidden", value)

    @property
    @pulumi.getter(name="isInPreview")
    def is_in_preview(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether the rule is in preview
        """
        return pulumi.get(self, "is_in_preview")

    @is_in_preview.setter
    def is_in_preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_in_preview", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="supportsEmailNotifications")
    def supports_email_notifications(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether email notifications are supported for detections for this rule
        """
        return pulumi.get(self, "supports_email_notifications")

    @supports_email_notifications.setter
    def supports_email_notifications(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "supports_email_notifications", value)


@pulumi.input_type
class HeaderFieldArgs:
    def __init__(__self__, *,
                 header_field_name: Optional[pulumi.Input[str]] = None,
                 header_field_value: Optional[pulumi.Input[str]] = None):
        """
        A header to add to the WebTest.
        :param pulumi.Input[str] header_field_name: The name of the header.
        :param pulumi.Input[str] header_field_value: The value of the header.
        """
        if header_field_name is not None:
            pulumi.set(__self__, "header_field_name", header_field_name)
        if header_field_value is not None:
            pulumi.set(__self__, "header_field_value", header_field_value)

    @property
    @pulumi.getter(name="headerFieldName")
    def header_field_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the header.
        """
        return pulumi.get(self, "header_field_name")

    @header_field_name.setter
    def header_field_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_field_name", value)

    @property
    @pulumi.getter(name="headerFieldValue")
    def header_field_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the header.
        """
        return pulumi.get(self, "header_field_value")

    @header_field_value.setter
    def header_field_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_field_value", value)


@pulumi.input_type
class WebTestGeolocationArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None):
        """
        Geo-physical location to run a WebTest from. You must specify one or more locations for the test to run from.
        :param pulumi.Input[str] location: Location ID for the WebTest to run from.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location ID for the WebTest to run from.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class WebTestPropertiesConfigurationArgs:
    def __init__(__self__, *,
                 web_test: Optional[pulumi.Input[str]] = None):
        """
        An XML configuration specification for a WebTest.
        :param pulumi.Input[str] web_test: The XML specification of a WebTest to run against an application.
        """
        if web_test is not None:
            pulumi.set(__self__, "web_test", web_test)

    @property
    @pulumi.getter(name="webTest")
    def web_test(self) -> Optional[pulumi.Input[str]]:
        """
        The XML specification of a WebTest to run against an application.
        """
        return pulumi.get(self, "web_test")

    @web_test.setter
    def web_test(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_test", value)


@pulumi.input_type
class WebTestPropertiesContentValidationArgs:
    def __init__(__self__, *,
                 content_match: Optional[pulumi.Input[str]] = None,
                 ignore_case: Optional[pulumi.Input[bool]] = None,
                 pass_if_text_found: Optional[pulumi.Input[bool]] = None):
        """
        The collection of content validation properties
        :param pulumi.Input[str] content_match: Content to look for in the return of the WebTest.  Must not be null or empty.
        :param pulumi.Input[bool] ignore_case: When set, this value makes the ContentMatch validation case insensitive.
        :param pulumi.Input[bool] pass_if_text_found: When true, validation will pass if there is a match for the ContentMatch string.  If false, validation will fail if there is a match
        """
        if content_match is not None:
            pulumi.set(__self__, "content_match", content_match)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if pass_if_text_found is not None:
            pulumi.set(__self__, "pass_if_text_found", pass_if_text_found)

    @property
    @pulumi.getter(name="contentMatch")
    def content_match(self) -> Optional[pulumi.Input[str]]:
        """
        Content to look for in the return of the WebTest.  Must not be null or empty.
        """
        return pulumi.get(self, "content_match")

    @content_match.setter
    def content_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_match", value)

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[pulumi.Input[bool]]:
        """
        When set, this value makes the ContentMatch validation case insensitive.
        """
        return pulumi.get(self, "ignore_case")

    @ignore_case.setter
    def ignore_case(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_case", value)

    @property
    @pulumi.getter(name="passIfTextFound")
    def pass_if_text_found(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, validation will pass if there is a match for the ContentMatch string.  If false, validation will fail if there is a match
        """
        return pulumi.get(self, "pass_if_text_found")

    @pass_if_text_found.setter
    def pass_if_text_found(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pass_if_text_found", value)


@pulumi.input_type
class WebTestPropertiesRequestArgs:
    def __init__(__self__, *,
                 follow_redirects: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderFieldArgs']]]] = None,
                 http_verb: Optional[pulumi.Input[str]] = None,
                 parse_dependent_requests: Optional[pulumi.Input[bool]] = None,
                 request_body: Optional[pulumi.Input[str]] = None,
                 request_url: Optional[pulumi.Input[str]] = None):
        """
        The collection of request properties
        :param pulumi.Input[bool] follow_redirects: Follow redirects for this web test.
        :param pulumi.Input[Sequence[pulumi.Input['HeaderFieldArgs']]] headers: List of headers and their values to add to the WebTest call.
        :param pulumi.Input[str] http_verb: Http verb to use for this web test.
        :param pulumi.Input[bool] parse_dependent_requests: Parse Dependent request for this WebTest.
        :param pulumi.Input[str] request_body: Base64 encoded string body to send with this web test.
        :param pulumi.Input[str] request_url: Url location to test.
        """
        if follow_redirects is not None:
            pulumi.set(__self__, "follow_redirects", follow_redirects)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_verb is not None:
            pulumi.set(__self__, "http_verb", http_verb)
        if parse_dependent_requests is not None:
            pulumi.set(__self__, "parse_dependent_requests", parse_dependent_requests)
        if request_body is not None:
            pulumi.set(__self__, "request_body", request_body)
        if request_url is not None:
            pulumi.set(__self__, "request_url", request_url)

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> Optional[pulumi.Input[bool]]:
        """
        Follow redirects for this web test.
        """
        return pulumi.get(self, "follow_redirects")

    @follow_redirects.setter
    def follow_redirects(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "follow_redirects", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeaderFieldArgs']]]]:
        """
        List of headers and their values to add to the WebTest call.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderFieldArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="httpVerb")
    def http_verb(self) -> Optional[pulumi.Input[str]]:
        """
        Http verb to use for this web test.
        """
        return pulumi.get(self, "http_verb")

    @http_verb.setter
    def http_verb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_verb", value)

    @property
    @pulumi.getter(name="parseDependentRequests")
    def parse_dependent_requests(self) -> Optional[pulumi.Input[bool]]:
        """
        Parse Dependent request for this WebTest.
        """
        return pulumi.get(self, "parse_dependent_requests")

    @parse_dependent_requests.setter
    def parse_dependent_requests(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parse_dependent_requests", value)

    @property
    @pulumi.getter(name="requestBody")
    def request_body(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded string body to send with this web test.
        """
        return pulumi.get(self, "request_body")

    @request_body.setter
    def request_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_body", value)

    @property
    @pulumi.getter(name="requestUrl")
    def request_url(self) -> Optional[pulumi.Input[str]]:
        """
        Url location to test.
        """
        return pulumi.get(self, "request_url")

    @request_url.setter
    def request_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_url", value)


@pulumi.input_type
class WebTestPropertiesValidationRulesArgs:
    def __init__(__self__, *,
                 content_validation: Optional[pulumi.Input['WebTestPropertiesContentValidationArgs']] = None,
                 expected_http_status_code: Optional[pulumi.Input[int]] = None,
                 ignore_https_status_code: Optional[pulumi.Input[bool]] = None,
                 s_sl_cert_remaining_lifetime_check: Optional[pulumi.Input[int]] = None,
                 s_sl_check: Optional[pulumi.Input[bool]] = None):
        """
        The collection of validation rule properties
        :param pulumi.Input['WebTestPropertiesContentValidationArgs'] content_validation: The collection of content validation properties
        :param pulumi.Input[int] expected_http_status_code: Validate that the WebTest returns the http status code provided.
        :param pulumi.Input[bool] ignore_https_status_code: When set, validation will ignore the status code.
        :param pulumi.Input[int] s_sl_cert_remaining_lifetime_check: A number of days to check still remain before the the existing SSL cert expires.  Value must be positive and the SSLCheck must be set to true.
        :param pulumi.Input[bool] s_sl_check: Checks to see if the SSL cert is still valid.
        """
        if content_validation is not None:
            pulumi.set(__self__, "content_validation", content_validation)
        if expected_http_status_code is not None:
            pulumi.set(__self__, "expected_http_status_code", expected_http_status_code)
        if ignore_https_status_code is not None:
            pulumi.set(__self__, "ignore_https_status_code", ignore_https_status_code)
        if s_sl_cert_remaining_lifetime_check is not None:
            pulumi.set(__self__, "s_sl_cert_remaining_lifetime_check", s_sl_cert_remaining_lifetime_check)
        if s_sl_check is not None:
            pulumi.set(__self__, "s_sl_check", s_sl_check)

    @property
    @pulumi.getter(name="contentValidation")
    def content_validation(self) -> Optional[pulumi.Input['WebTestPropertiesContentValidationArgs']]:
        """
        The collection of content validation properties
        """
        return pulumi.get(self, "content_validation")

    @content_validation.setter
    def content_validation(self, value: Optional[pulumi.Input['WebTestPropertiesContentValidationArgs']]):
        pulumi.set(self, "content_validation", value)

    @property
    @pulumi.getter(name="expectedHttpStatusCode")
    def expected_http_status_code(self) -> Optional[pulumi.Input[int]]:
        """
        Validate that the WebTest returns the http status code provided.
        """
        return pulumi.get(self, "expected_http_status_code")

    @expected_http_status_code.setter
    def expected_http_status_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expected_http_status_code", value)

    @property
    @pulumi.getter(name="ignoreHttpsStatusCode")
    def ignore_https_status_code(self) -> Optional[pulumi.Input[bool]]:
        """
        When set, validation will ignore the status code.
        """
        return pulumi.get(self, "ignore_https_status_code")

    @ignore_https_status_code.setter
    def ignore_https_status_code(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_https_status_code", value)

    @property
    @pulumi.getter(name="sSLCertRemainingLifetimeCheck")
    def s_sl_cert_remaining_lifetime_check(self) -> Optional[pulumi.Input[int]]:
        """
        A number of days to check still remain before the the existing SSL cert expires.  Value must be positive and the SSLCheck must be set to true.
        """
        return pulumi.get(self, "s_sl_cert_remaining_lifetime_check")

    @s_sl_cert_remaining_lifetime_check.setter
    def s_sl_cert_remaining_lifetime_check(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "s_sl_cert_remaining_lifetime_check", value)

    @property
    @pulumi.getter(name="sSLCheck")
    def s_sl_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Checks to see if the SSL cert is still valid.
        """
        return pulumi.get(self, "s_sl_check")

    @s_sl_check.setter
    def s_sl_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "s_sl_check", value)


