# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetGitHubOAuthResult',
    'AwaitableGetGitHubOAuthResult',
    'get_git_hub_o_auth',
    'get_git_hub_o_auth_output',
]

@pulumi.output_type
class GetGitHubOAuthResult:
    """
    URL used to authorize the Developer Hub GitHub App
    """
    def __init__(__self__, auth_url=None, token=None):
        if auth_url and not isinstance(auth_url, str):
            raise TypeError("Expected argument 'auth_url' to be a str")
        pulumi.set(__self__, "auth_url", auth_url)
        if token and not isinstance(token, str):
            raise TypeError("Expected argument 'token' to be a str")
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="authURL")
    def auth_url(self) -> Optional[str]:
        """
        URL for authorizing the Developer Hub GitHub App
        """
        return pulumi.get(self, "auth_url")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        OAuth token used to make calls to GitHub
        """
        return pulumi.get(self, "token")


class AwaitableGetGitHubOAuthResult(GetGitHubOAuthResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGitHubOAuthResult(
            auth_url=self.auth_url,
            token=self.token)


def get_git_hub_o_auth(location: Optional[str] = None,
                       redirect_url: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGitHubOAuthResult:
    """
    URL used to authorize the Developer Hub GitHub App


    :param str location: The name of Azure region.
    :param str redirect_url: The URL the client will redirect to on successful authentication. If empty, no redirect will occur.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['redirectUrl'] = redirect_url
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:devhub/v20220401preview:getGitHubOAuth', __args__, opts=opts, typ=GetGitHubOAuthResult).value

    return AwaitableGetGitHubOAuthResult(
        auth_url=__ret__.auth_url,
        token=__ret__.token)


@_utilities.lift_output_func(get_git_hub_o_auth)
def get_git_hub_o_auth_output(location: Optional[pulumi.Input[str]] = None,
                              redirect_url: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGitHubOAuthResult]:
    """
    URL used to authorize the Developer Hub GitHub App


    :param str location: The name of Azure region.
    :param str redirect_url: The URL the client will redirect to on successful authentication. If empty, no redirect will occur.
    """
    ...
