# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApiKeyAuthenticationResponse',
    'CloudErrorBodyResponse',
    'HealthCheckStepPropertiesResponse',
    'IdentityResponse',
    'MessageResponse',
    'PrePostStepResponse',
    'ResourceOperationResponse',
    'RestHealthCheckResponse',
    'RestHealthCheckStepAttributesResponse',
    'RestRequestResponse',
    'RestResponseResponse',
    'RestResponseResponseRegex',
    'RolloutIdentityAuthenticationResponse',
    'RolloutOperationInfoResponse',
    'RolloutStepResponse',
    'SasAuthenticationResponse',
    'ServiceResponse',
    'ServiceUnitArtifactsResponse',
    'ServiceUnitResponse',
    'StepGroupResponse',
    'StepOperationInfoResponse',
    'WaitStepAttributesResponse',
    'WaitStepPropertiesResponse',
]

@pulumi.output_type
class ApiKeyAuthenticationResponse(dict):
    """
    ApiKey authentication gives a name and a value that can be included in either the request header or query parameters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "in":
            suggest = "in_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiKeyAuthenticationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiKeyAuthenticationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiKeyAuthenticationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 in_: str,
                 name: str,
                 type: str,
                 value: str):
        """
        ApiKey authentication gives a name and a value that can be included in either the request header or query parameters.
        :param str in_: The location of the authentication key/value pair in the request.
        :param str name: The key name of the authentication key/value pair.
        :param str type: The authentication type.
               Expected value is 'ApiKey'.
        :param str value: The value of the authentication key/value pair.
        """
        pulumi.set(__self__, "in_", in_)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", 'ApiKey')
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="in")
    def in_(self) -> str:
        """
        The location of the authentication key/value pair in the request.
        """
        return pulumi.get(self, "in_")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The key name of the authentication key/value pair.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The authentication type.
        Expected value is 'ApiKey'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the authentication key/value pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CloudErrorBodyResponse(dict):
    """
    Detailed error information of any failure.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 details: Optional[Sequence['outputs.CloudErrorBodyResponse']] = None,
                 target: Optional[str] = None):
        """
        Detailed error information of any failure.
        :param str code: Error code string.
        :param str message: Descriptive error information.
        :param Sequence['CloudErrorBodyResponse'] details: More detailed error information.
        :param str target: Error target
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code string.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Descriptive error information.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.CloudErrorBodyResponse']]:
        """
        More detailed error information.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Error target
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class HealthCheckStepPropertiesResponse(dict):
    """
    Defines the properties of a health check step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stepType":
            suggest = "step_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthCheckStepPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthCheckStepPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthCheckStepPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributes: 'outputs.RestHealthCheckStepAttributesResponse',
                 step_type: str):
        """
        Defines the properties of a health check step.
        :param 'RestHealthCheckStepAttributesResponse' attributes: The health check step attributes
        :param str step_type: The type of step.
               Expected value is 'HealthCheck'.
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "step_type", 'HealthCheck')

    @property
    @pulumi.getter
    def attributes(self) -> 'outputs.RestHealthCheckStepAttributesResponse':
        """
        The health check step attributes
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="stepType")
    def step_type(self) -> str:
        """
        The type of step.
        Expected value is 'HealthCheck'.
        """
        return pulumi.get(self, "step_type")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_ids: Sequence[str],
                 type: str):
        """
        Identity for the resource.
        :param Sequence[str] identity_ids: The list of identities.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[str]:
        """
        The list of identities.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MessageResponse(dict):
    """
    Supplementary contextual messages during a rollout.
    """
    def __init__(__self__, *,
                 message: str,
                 time_stamp: str):
        """
        Supplementary contextual messages during a rollout.
        :param str message: The actual message text.
        :param str time_stamp: Time in UTC this message was provided.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "time_stamp", time_stamp)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The actual message text.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="timeStamp")
    def time_stamp(self) -> str:
        """
        Time in UTC this message was provided.
        """
        return pulumi.get(self, "time_stamp")


@pulumi.output_type
class PrePostStepResponse(dict):
    """
    The properties that define a step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stepId":
            suggest = "step_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrePostStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrePostStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrePostStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 step_id: str):
        """
        The properties that define a step.
        :param str step_id: The resource Id of the step to be run.
        """
        pulumi.set(__self__, "step_id", step_id)

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> str:
        """
        The resource Id of the step to be run.
        """
        return pulumi.get(self, "step_id")


@pulumi.output_type
class ResourceOperationResponse(dict):
    """
    Individual resource operation information.
    """
    def __init__(__self__, *,
                 operation_id: str,
                 provisioning_state: str,
                 status_code: str,
                 status_message: str,
                 resource_name: Optional[str] = None,
                 resource_type: Optional[str] = None):
        """
        Individual resource operation information.
        :param str operation_id: Unique identifier of the operation. For ARM resources, this is the operationId obtained from ARM service.
        :param str provisioning_state: State of the resource deployment. For ARM resources, this is the current provisioning state of the resource.
        :param str status_code: Http status code of the operation.
        :param str status_message: Descriptive information of the resource operation.
        :param str resource_name: Name of the resource as specified in the artifacts. For ARM resources, this is the name of the resource specified in the template.
        :param str resource_type: Type of the resource as specified in the artifacts. For ARM resources, this is the type of the resource specified in the template.
        """
        pulumi.set(__self__, "operation_id", operation_id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status_code", status_code)
        pulumi.set(__self__, "status_message", status_message)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> str:
        """
        Unique identifier of the operation. For ARM resources, this is the operationId obtained from ARM service.
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the resource deployment. For ARM resources, this is the current provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> str:
        """
        Http status code of the operation.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        Descriptive information of the resource operation.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[str]:
        """
        Name of the resource as specified in the artifacts. For ARM resources, this is the name of the resource specified in the template.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        Type of the resource as specified in the artifacts. For ARM resources, this is the type of the resource specified in the template.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class RestHealthCheckResponse(dict):
    """
    A REST based health check
    """
    def __init__(__self__, *,
                 name: str,
                 request: 'outputs.RestRequestResponse',
                 response: Optional['outputs.RestResponseResponse'] = None):
        """
        A REST based health check
        :param str name: A unique name for this check.
        :param 'RestRequestResponse' request: The request to the health provider.
        :param 'RestResponseResponse' response: The expected response from the health provider. If no expected response is provided, the default is to expect the received response to have an HTTP status code of 200 OK.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "request", request)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name for this check.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def request(self) -> 'outputs.RestRequestResponse':
        """
        The request to the health provider.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def response(self) -> Optional['outputs.RestResponseResponse']:
        """
        The expected response from the health provider. If no expected response is provided, the default is to expect the received response to have an HTTP status code of 200 OK.
        """
        return pulumi.get(self, "response")


@pulumi.output_type
class RestHealthCheckStepAttributesResponse(dict):
    """
    Defines the REST health check step properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthChecks":
            suggest = "health_checks"
        elif key == "healthyStateDuration":
            suggest = "healthy_state_duration"
        elif key == "maxElasticDuration":
            suggest = "max_elastic_duration"
        elif key == "waitDuration":
            suggest = "wait_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestHealthCheckStepAttributesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestHealthCheckStepAttributesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestHealthCheckStepAttributesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_checks: Sequence['outputs.RestHealthCheckResponse'],
                 healthy_state_duration: str,
                 type: str,
                 max_elastic_duration: Optional[str] = None,
                 wait_duration: Optional[str] = None):
        """
        Defines the REST health check step properties.
        :param Sequence['RestHealthCheckResponse'] health_checks: The list of checks that form the health check step.
        :param str healthy_state_duration: The duration in ISO 8601 format for which the resource is expected to be continuously healthy. If maxElasticDuration is specified, healthy state duration is enforced after the detection of first healthy signal.
        :param str type: The type of health check.
               Expected value is 'REST'.
        :param str max_elastic_duration: The duration in ISO 8601 format for which the health check waits for the resource to become healthy. Health check fails if it doesn't. Health check starts to enforce healthyStateDuration once resource becomes healthy.
        :param str wait_duration: The duration in ISO 8601 format for which health check waits idly without any checks.
        """
        pulumi.set(__self__, "health_checks", health_checks)
        pulumi.set(__self__, "healthy_state_duration", healthy_state_duration)
        pulumi.set(__self__, "type", 'REST')
        if max_elastic_duration is not None:
            pulumi.set(__self__, "max_elastic_duration", max_elastic_duration)
        if wait_duration is not None:
            pulumi.set(__self__, "wait_duration", wait_duration)

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Sequence['outputs.RestHealthCheckResponse']:
        """
        The list of checks that form the health check step.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter(name="healthyStateDuration")
    def healthy_state_duration(self) -> str:
        """
        The duration in ISO 8601 format for which the resource is expected to be continuously healthy. If maxElasticDuration is specified, healthy state duration is enforced after the detection of first healthy signal.
        """
        return pulumi.get(self, "healthy_state_duration")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of health check.
        Expected value is 'REST'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="maxElasticDuration")
    def max_elastic_duration(self) -> Optional[str]:
        """
        The duration in ISO 8601 format for which the health check waits for the resource to become healthy. Health check fails if it doesn't. Health check starts to enforce healthyStateDuration once resource becomes healthy.
        """
        return pulumi.get(self, "max_elastic_duration")

    @property
    @pulumi.getter(name="waitDuration")
    def wait_duration(self) -> Optional[str]:
        """
        The duration in ISO 8601 format for which health check waits idly without any checks.
        """
        return pulumi.get(self, "wait_duration")


@pulumi.output_type
class RestRequestResponse(dict):
    """
    The properties that make up a REST request
    """
    def __init__(__self__, *,
                 authentication: Any,
                 method: str,
                 uri: str):
        """
        The properties that make up a REST request
        :param Union['ApiKeyAuthenticationResponse', 'RolloutIdentityAuthenticationResponse'] authentication: The authentication information required in the request to the health provider.
        :param str method: The HTTP method to use for the request.
        :param str uri: The HTTP URI to use for the request.
        """
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def authentication(self) -> Any:
        """
        The authentication information required in the request to the health provider.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The HTTP method to use for the request.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The HTTP URI to use for the request.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class RestResponseResponse(dict):
    """
    The properties that make up the expected REST response
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "successStatusCodes":
            suggest = "success_status_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestResponseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestResponseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestResponseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 regex: Optional['outputs.RestResponseResponseRegex'] = None,
                 success_status_codes: Optional[Sequence[str]] = None):
        """
        The properties that make up the expected REST response
        :param 'RestResponseResponseRegex' regex: The regular expressions to match the response content with.
        :param Sequence[str] success_status_codes: The HTTP status codes expected in a successful health check response. The response is expected to match one of the given status codes. If no expected status codes are provided, default expected status code is 200 OK.
        """
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if success_status_codes is not None:
            pulumi.set(__self__, "success_status_codes", success_status_codes)

    @property
    @pulumi.getter
    def regex(self) -> Optional['outputs.RestResponseResponseRegex']:
        """
        The regular expressions to match the response content with.
        """
        return pulumi.get(self, "regex")

    @property
    @pulumi.getter(name="successStatusCodes")
    def success_status_codes(self) -> Optional[Sequence[str]]:
        """
        The HTTP status codes expected in a successful health check response. The response is expected to match one of the given status codes. If no expected status codes are provided, default expected status code is 200 OK.
        """
        return pulumi.get(self, "success_status_codes")


@pulumi.output_type
class RestResponseResponseRegex(dict):
    """
    The regular expressions to match the response content with.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchQuantifier":
            suggest = "match_quantifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestResponseResponseRegex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestResponseResponseRegex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestResponseResponseRegex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_quantifier: Optional[str] = None,
                 matches: Optional[Sequence[str]] = None):
        """
        The regular expressions to match the response content with.
        :param str match_quantifier: Indicates whether any or all of the expressions should match with the response content.
        :param Sequence[str] matches: The list of regular expressions.
        """
        if match_quantifier is not None:
            pulumi.set(__self__, "match_quantifier", match_quantifier)
        if matches is not None:
            pulumi.set(__self__, "matches", matches)

    @property
    @pulumi.getter(name="matchQuantifier")
    def match_quantifier(self) -> Optional[str]:
        """
        Indicates whether any or all of the expressions should match with the response content.
        """
        return pulumi.get(self, "match_quantifier")

    @property
    @pulumi.getter
    def matches(self) -> Optional[Sequence[str]]:
        """
        The list of regular expressions.
        """
        return pulumi.get(self, "matches")


@pulumi.output_type
class RolloutIdentityAuthenticationResponse(dict):
    """
    RolloutIdentity uses the user-assigned managed identity authentication context specified in the Identity property during rollout creation.
    """
    def __init__(__self__, *,
                 type: str):
        """
        RolloutIdentity uses the user-assigned managed identity authentication context specified in the Identity property during rollout creation.
        :param str type: The authentication type.
               Expected value is 'RolloutIdentity'.
        """
        pulumi.set(__self__, "type", 'RolloutIdentity')

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The authentication type.
        Expected value is 'RolloutIdentity'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RolloutOperationInfoResponse(dict):
    """
    Detailed runtime information of the rollout.
    """
    def __init__(__self__, *,
                 end_time: str,
                 error: 'outputs.CloudErrorBodyResponse',
                 retry_attempt: int,
                 skip_succeeded_on_retry: bool,
                 start_time: str):
        """
        Detailed runtime information of the rollout.
        :param str end_time: The start time of the rollout in UTC. This property will not be set if the rollout has not completed yet.
        :param 'CloudErrorBodyResponse' error: The detailed error information for any failure.
        :param int retry_attempt: The ordinal count of the number of retry attempts on a rollout. 0 if no retries of the rollout have been performed. If the rollout is updated with a PUT, this count is reset to 0.
        :param bool skip_succeeded_on_retry: True, if all steps that succeeded on the previous run/attempt were chosen to be skipped in this retry attempt. False, otherwise.
        :param str start_time: The start time of the rollout in UTC.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "retry_attempt", retry_attempt)
        pulumi.set(__self__, "skip_succeeded_on_retry", skip_succeeded_on_retry)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The start time of the rollout in UTC. This property will not be set if the rollout has not completed yet.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.CloudErrorBodyResponse':
        """
        The detailed error information for any failure.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="retryAttempt")
    def retry_attempt(self) -> int:
        """
        The ordinal count of the number of retry attempts on a rollout. 0 if no retries of the rollout have been performed. If the rollout is updated with a PUT, this count is reset to 0.
        """
        return pulumi.get(self, "retry_attempt")

    @property
    @pulumi.getter(name="skipSucceededOnRetry")
    def skip_succeeded_on_retry(self) -> bool:
        """
        True, if all steps that succeeded on the previous run/attempt were chosen to be skipped in this retry attempt. False, otherwise.
        """
        return pulumi.get(self, "skip_succeeded_on_retry")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of the rollout in UTC.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class RolloutStepResponse(dict):
    """
    Defines a specific step on a target service unit.
    """
    def __init__(__self__, *,
                 messages: Sequence['outputs.MessageResponse'],
                 name: str,
                 operation_info: 'outputs.StepOperationInfoResponse',
                 resource_operations: Sequence['outputs.ResourceOperationResponse'],
                 status: str,
                 step_group: Optional[str] = None):
        """
        Defines a specific step on a target service unit.
        :param Sequence['MessageResponse'] messages: Supplementary informative messages during rollout.
        :param str name: Name of the step.
        :param 'StepOperationInfoResponse' operation_info: Detailed information of specific action execution.
        :param Sequence['ResourceOperationResponse'] resource_operations: Set of resource operations that were performed, if any, on an Azure resource.
        :param str status: Current state of the step.
        :param str step_group: The step group the current step is part of.
        """
        pulumi.set(__self__, "messages", messages)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operation_info", operation_info)
        pulumi.set(__self__, "resource_operations", resource_operations)
        pulumi.set(__self__, "status", status)
        if step_group is not None:
            pulumi.set(__self__, "step_group", step_group)

    @property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.MessageResponse']:
        """
        Supplementary informative messages during rollout.
        """
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the step.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationInfo")
    def operation_info(self) -> 'outputs.StepOperationInfoResponse':
        """
        Detailed information of specific action execution.
        """
        return pulumi.get(self, "operation_info")

    @property
    @pulumi.getter(name="resourceOperations")
    def resource_operations(self) -> Sequence['outputs.ResourceOperationResponse']:
        """
        Set of resource operations that were performed, if any, on an Azure resource.
        """
        return pulumi.get(self, "resource_operations")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current state of the step.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stepGroup")
    def step_group(self) -> Optional[str]:
        """
        The step group the current step is part of.
        """
        return pulumi.get(self, "step_group")


@pulumi.output_type
class SasAuthenticationResponse(dict):
    """
    Defines the properties to access the artifacts using an Azure Storage SAS URI.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sasUri":
            suggest = "sas_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SasAuthenticationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SasAuthenticationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SasAuthenticationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sas_uri: str,
                 type: str):
        """
        Defines the properties to access the artifacts using an Azure Storage SAS URI.
        :param str sas_uri: The SAS URI to the Azure Storage blob container. Any offset from the root of the container to where the artifacts are located can be defined in the artifactRoot.
        :param str type: The authentication type
               Expected value is 'Sas'.
        """
        pulumi.set(__self__, "sas_uri", sas_uri)
        pulumi.set(__self__, "type", 'Sas')

    @property
    @pulumi.getter(name="sasUri")
    def sas_uri(self) -> str:
        """
        The SAS URI to the Azure Storage blob container. Any offset from the root of the container to where the artifacts are located can be defined in the artifactRoot.
        """
        return pulumi.get(self, "sas_uri")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The authentication type
        Expected value is 'Sas'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceResponse(dict):
    """
    Defines a service.
    """
    def __init__(__self__, *,
                 target_location: str,
                 target_subscription_id: str,
                 name: Optional[str] = None,
                 service_units: Optional[Sequence['outputs.ServiceUnitResponse']] = None):
        """
        Defines a service.
        :param str target_location: The Azure location to which the resources in the service belong to or should be deployed to.
        :param str target_subscription_id: The subscription to which the resources in the service belong to or should be deployed to.
        :param str name: Name of the service.
        :param Sequence['ServiceUnitResponse'] service_units: The detailed information about the units that make up the service.
        """
        pulumi.set(__self__, "target_location", target_location)
        pulumi.set(__self__, "target_subscription_id", target_subscription_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_units is not None:
            pulumi.set(__self__, "service_units", service_units)

    @property
    @pulumi.getter(name="targetLocation")
    def target_location(self) -> str:
        """
        The Azure location to which the resources in the service belong to or should be deployed to.
        """
        return pulumi.get(self, "target_location")

    @property
    @pulumi.getter(name="targetSubscriptionId")
    def target_subscription_id(self) -> str:
        """
        The subscription to which the resources in the service belong to or should be deployed to.
        """
        return pulumi.get(self, "target_subscription_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceUnits")
    def service_units(self) -> Optional[Sequence['outputs.ServiceUnitResponse']]:
        """
        The detailed information about the units that make up the service.
        """
        return pulumi.get(self, "service_units")


@pulumi.output_type
class ServiceUnitArtifactsResponse(dict):
    """
    Defines the artifacts of a service unit.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parametersArtifactSourceRelativePath":
            suggest = "parameters_artifact_source_relative_path"
        elif key == "parametersUri":
            suggest = "parameters_uri"
        elif key == "templateArtifactSourceRelativePath":
            suggest = "template_artifact_source_relative_path"
        elif key == "templateUri":
            suggest = "template_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceUnitArtifactsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceUnitArtifactsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceUnitArtifactsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameters_artifact_source_relative_path: Optional[str] = None,
                 parameters_uri: Optional[str] = None,
                 template_artifact_source_relative_path: Optional[str] = None,
                 template_uri: Optional[str] = None):
        """
        Defines the artifacts of a service unit.
        :param str parameters_artifact_source_relative_path: The path to the ARM parameters file relative to the artifact source.
        :param str parameters_uri: The full URI of the ARM parameters file with the SAS token.
        :param str template_artifact_source_relative_path: The path to the ARM template file relative to the artifact source.
        :param str template_uri: The full URI of the ARM template file with the SAS token.
        """
        if parameters_artifact_source_relative_path is not None:
            pulumi.set(__self__, "parameters_artifact_source_relative_path", parameters_artifact_source_relative_path)
        if parameters_uri is not None:
            pulumi.set(__self__, "parameters_uri", parameters_uri)
        if template_artifact_source_relative_path is not None:
            pulumi.set(__self__, "template_artifact_source_relative_path", template_artifact_source_relative_path)
        if template_uri is not None:
            pulumi.set(__self__, "template_uri", template_uri)

    @property
    @pulumi.getter(name="parametersArtifactSourceRelativePath")
    def parameters_artifact_source_relative_path(self) -> Optional[str]:
        """
        The path to the ARM parameters file relative to the artifact source.
        """
        return pulumi.get(self, "parameters_artifact_source_relative_path")

    @property
    @pulumi.getter(name="parametersUri")
    def parameters_uri(self) -> Optional[str]:
        """
        The full URI of the ARM parameters file with the SAS token.
        """
        return pulumi.get(self, "parameters_uri")

    @property
    @pulumi.getter(name="templateArtifactSourceRelativePath")
    def template_artifact_source_relative_path(self) -> Optional[str]:
        """
        The path to the ARM template file relative to the artifact source.
        """
        return pulumi.get(self, "template_artifact_source_relative_path")

    @property
    @pulumi.getter(name="templateUri")
    def template_uri(self) -> Optional[str]:
        """
        The full URI of the ARM template file with the SAS token.
        """
        return pulumi.get(self, "template_uri")


@pulumi.output_type
class ServiceUnitResponse(dict):
    """
    Defines a service unit.
    """
    def __init__(__self__, *,
                 deployment_mode: str,
                 target_resource_group: str,
                 artifacts: Optional['outputs.ServiceUnitArtifactsResponse'] = None,
                 name: Optional[str] = None,
                 steps: Optional[Sequence['outputs.RolloutStepResponse']] = None):
        """
        Defines a service unit.
        :param str deployment_mode: Describes the type of ARM deployment to be performed on the resource.
        :param str target_resource_group: The Azure Resource Group to which the resources in the service unit belong to or should be deployed to.
        :param 'ServiceUnitArtifactsResponse' artifacts: The artifacts for the service unit.
        :param str name: Name of the service unit.
        :param Sequence['RolloutStepResponse'] steps: Detailed step information, if present.
        """
        pulumi.set(__self__, "deployment_mode", deployment_mode)
        pulumi.set(__self__, "target_resource_group", target_resource_group)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)

    @property
    @pulumi.getter(name="deploymentMode")
    def deployment_mode(self) -> str:
        """
        Describes the type of ARM deployment to be performed on the resource.
        """
        return pulumi.get(self, "deployment_mode")

    @property
    @pulumi.getter(name="targetResourceGroup")
    def target_resource_group(self) -> str:
        """
        The Azure Resource Group to which the resources in the service unit belong to or should be deployed to.
        """
        return pulumi.get(self, "target_resource_group")

    @property
    @pulumi.getter
    def artifacts(self) -> Optional['outputs.ServiceUnitArtifactsResponse']:
        """
        The artifacts for the service unit.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the service unit.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def steps(self) -> Optional[Sequence['outputs.RolloutStepResponse']]:
        """
        Detailed step information, if present.
        """
        return pulumi.get(self, "steps")


@pulumi.output_type
class StepGroupResponse(dict):
    """
    The properties that define a Step group in a rollout.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentTargetId":
            suggest = "deployment_target_id"
        elif key == "dependsOnStepGroups":
            suggest = "depends_on_step_groups"
        elif key == "postDeploymentSteps":
            suggest = "post_deployment_steps"
        elif key == "preDeploymentSteps":
            suggest = "pre_deployment_steps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StepGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StepGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StepGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_target_id: str,
                 name: str,
                 depends_on_step_groups: Optional[Sequence[str]] = None,
                 post_deployment_steps: Optional[Sequence['outputs.PrePostStepResponse']] = None,
                 pre_deployment_steps: Optional[Sequence['outputs.PrePostStepResponse']] = None):
        """
        The properties that define a Step group in a rollout.
        :param str deployment_target_id: The resource Id of service unit to be deployed. The service unit should be from the service topology referenced in targetServiceTopologyId
        :param str name: The name of the step group.
        :param Sequence[str] depends_on_step_groups: The list of step group names on which this step group depends on.
        :param Sequence['PrePostStepResponse'] post_deployment_steps: The list of steps to be run after deploying the target.
        :param Sequence['PrePostStepResponse'] pre_deployment_steps: The list of steps to be run before deploying the target.
        """
        pulumi.set(__self__, "deployment_target_id", deployment_target_id)
        pulumi.set(__self__, "name", name)
        if depends_on_step_groups is not None:
            pulumi.set(__self__, "depends_on_step_groups", depends_on_step_groups)
        if post_deployment_steps is not None:
            pulumi.set(__self__, "post_deployment_steps", post_deployment_steps)
        if pre_deployment_steps is not None:
            pulumi.set(__self__, "pre_deployment_steps", pre_deployment_steps)

    @property
    @pulumi.getter(name="deploymentTargetId")
    def deployment_target_id(self) -> str:
        """
        The resource Id of service unit to be deployed. The service unit should be from the service topology referenced in targetServiceTopologyId
        """
        return pulumi.get(self, "deployment_target_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the step group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dependsOnStepGroups")
    def depends_on_step_groups(self) -> Optional[Sequence[str]]:
        """
        The list of step group names on which this step group depends on.
        """
        return pulumi.get(self, "depends_on_step_groups")

    @property
    @pulumi.getter(name="postDeploymentSteps")
    def post_deployment_steps(self) -> Optional[Sequence['outputs.PrePostStepResponse']]:
        """
        The list of steps to be run after deploying the target.
        """
        return pulumi.get(self, "post_deployment_steps")

    @property
    @pulumi.getter(name="preDeploymentSteps")
    def pre_deployment_steps(self) -> Optional[Sequence['outputs.PrePostStepResponse']]:
        """
        The list of steps to be run before deploying the target.
        """
        return pulumi.get(self, "pre_deployment_steps")


@pulumi.output_type
class StepOperationInfoResponse(dict):
    """
    Detailed information of a specific step run.
    """
    def __init__(__self__, *,
                 correlation_id: str,
                 deployment_name: str,
                 end_time: str,
                 last_updated_time: str,
                 start_time: str,
                 error: Optional['outputs.CloudErrorBodyResponse'] = None):
        """
        Detailed information of a specific step run.
        :param str correlation_id: Unique identifier to track the request for ARM-based resources.
        :param str deployment_name: The name of the ARM deployment initiated as part of the step.
        :param str end_time: End time of the action in UTC.
        :param str last_updated_time: Last time in UTC this operation was updated.
        :param str start_time: Start time of the action in UTC.
        :param 'CloudErrorBodyResponse' error: The errors, if any, for the action.
        """
        pulumi.set(__self__, "correlation_id", correlation_id)
        pulumi.set(__self__, "deployment_name", deployment_name)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        pulumi.set(__self__, "start_time", start_time)
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> str:
        """
        Unique identifier to track the request for ARM-based resources.
        """
        return pulumi.get(self, "correlation_id")

    @property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> str:
        """
        The name of the ARM deployment initiated as part of the step.
        """
        return pulumi.get(self, "deployment_name")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        End time of the action in UTC.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> str:
        """
        Last time in UTC this operation was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Start time of the action in UTC.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.CloudErrorBodyResponse']:
        """
        The errors, if any, for the action.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class WaitStepAttributesResponse(dict):
    """
    The parameters for the wait step.
    """
    def __init__(__self__, *,
                 duration: str):
        """
        The parameters for the wait step.
        :param str duration: The duration in ISO 8601 format of how long the wait should be.
        """
        pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        The duration in ISO 8601 format of how long the wait should be.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class WaitStepPropertiesResponse(dict):
    """
    Defines the properties of a Wait step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stepType":
            suggest = "step_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WaitStepPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WaitStepPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WaitStepPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributes: 'outputs.WaitStepAttributesResponse',
                 step_type: str):
        """
        Defines the properties of a Wait step.
        :param 'WaitStepAttributesResponse' attributes: The Wait attributes
        :param str step_type: The type of step.
               Expected value is 'Wait'.
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "step_type", 'Wait')

    @property
    @pulumi.getter
    def attributes(self) -> 'outputs.WaitStepAttributesResponse':
        """
        The Wait attributes
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="stepType")
    def step_type(self) -> str:
        """
        The type of step.
        Expected value is 'Wait'.
        """
        return pulumi.get(self, "step_type")


