# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFrontendsInterfaceResult',
    'AwaitableGetFrontendsInterfaceResult',
    'get_frontends_interface',
    'get_frontends_interface_output',
]

@pulumi.output_type
class GetFrontendsInterfaceResult:
    """
    Frontend Subresource of Traffic Controller.
    """
    def __init__(__self__, id=None, ip_address_version=None, location=None, mode=None, name=None, provisioning_state=None, public_ip_address=None, system_data=None, tags=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address_version and not isinstance(ip_address_version, str):
            raise TypeError("Expected argument 'ip_address_version' to be a str")
        pulumi.set(__self__, "ip_address_version", ip_address_version)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address and not isinstance(public_ip_address, dict):
            raise TypeError("Expected argument 'public_ip_address' to be a dict")
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddressVersion")
    def ip_address_version(self) -> Optional[str]:
        """
        Frontend IP Address Version (Optional).
        """
        return pulumi.get(self, "ip_address_version")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Frontend Mode (Optional).
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        test doc
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.FrontendPropertiesIPAddressResponse']:
        """
        Frontend Public IP Address (Optional).
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetFrontendsInterfaceResult(GetFrontendsInterfaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFrontendsInterfaceResult(
            id=self.id,
            ip_address_version=self.ip_address_version,
            location=self.location,
            mode=self.mode,
            name=self.name,
            provisioning_state=self.provisioning_state,
            public_ip_address=self.public_ip_address,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_frontends_interface(frontend_name: Optional[str] = None,
                            resource_group_name: Optional[str] = None,
                            traffic_controller_name: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFrontendsInterfaceResult:
    """
    Frontend Subresource of Traffic Controller.
    API Version: 2022-10-01-preview.


    :param str frontend_name: Frontends
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str traffic_controller_name: traffic controller name for path
    """
    __args__ = dict()
    __args__['frontendName'] = frontend_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['trafficControllerName'] = traffic_controller_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:servicenetworking:getFrontendsInterface', __args__, opts=opts, typ=GetFrontendsInterfaceResult).value

    return AwaitableGetFrontendsInterfaceResult(
        id=__ret__.id,
        ip_address_version=__ret__.ip_address_version,
        location=__ret__.location,
        mode=__ret__.mode,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        public_ip_address=__ret__.public_ip_address,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_frontends_interface)
def get_frontends_interface_output(frontend_name: Optional[pulumi.Input[str]] = None,
                                   resource_group_name: Optional[pulumi.Input[str]] = None,
                                   traffic_controller_name: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFrontendsInterfaceResult]:
    """
    Frontend Subresource of Traffic Controller.
    API Version: 2022-10-01-preview.


    :param str frontend_name: Frontends
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str traffic_controller_name: traffic controller name for path
    """
    ...
