# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AacAudioArgs',
    'AbsoluteClipTimeArgs',
    'AudioAnalyzerPresetArgs',
    'AudioOverlayArgs',
    'AudioTrackDescriptorArgs',
    'AudioArgs',
    'BuiltInStandardEncoderPresetArgs',
    'CmafFormatArgs',
    'CopyAudioArgs',
    'CopyVideoArgs',
    'DDAudioArgs',
    'DeinterlaceArgs',
    'FaceDetectorPresetArgs',
    'FiltersArgs',
    'FromAllInputFileArgs',
    'FromEachInputFileArgs',
    'H264LayerArgs',
    'H264VideoArgs',
    'H265LayerArgs',
    'H265VideoArgs',
    'ImageFormatArgs',
    'ImageArgs',
    'InputFileArgs',
    'JobInputAssetArgs',
    'JobInputClipArgs',
    'JobInputHttpArgs',
    'JobInputSequenceArgs',
    'JobInputsArgs',
    'JobOutputAssetArgs',
    'JpgFormatArgs',
    'JpgImageArgs',
    'JpgLayerArgs',
    'Mp4FormatArgs',
    'MultiBitrateFormatArgs',
    'OutputFileArgs',
    'PngFormatArgs',
    'PngImageArgs',
    'PngLayerArgs',
    'PresetConfigurationsArgs',
    'RectangleArgs',
    'SelectAudioTrackByAttributeArgs',
    'SelectAudioTrackByIdArgs',
    'SelectVideoTrackByAttributeArgs',
    'SelectVideoTrackByIdArgs',
    'StandardEncoderPresetArgs',
    'TransformOutputArgs',
    'TransportStreamFormatArgs',
    'UtcClipTimeArgs',
    'VideoAnalyzerPresetArgs',
    'VideoOverlayArgs',
    'VideoTrackDescriptorArgs',
    'VideoArgs',
]

@pulumi.input_type
class AacAudioArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 bitrate: Optional[pulumi.Input[int]] = None,
                 channels: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[Union[str, 'AacAudioProfile']]] = None,
                 sampling_rate: Optional[pulumi.Input[int]] = None):
        """
        Describes Advanced Audio Codec (AAC) audio encoding settings.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AacAudio'.
        :param pulumi.Input[int] bitrate: The bitrate, in bits per second, of the output encoded audio.
        :param pulumi.Input[int] channels: The number of channels in the audio.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Union[str, 'AacAudioProfile']] profile: The encoding profile to be used when encoding audio with AAC.
        :param pulumi.Input[int] sampling_rate: The sampling rate to use for encoding in hertz.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AacAudio')
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AacAudio'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The bitrate, in bits per second, of the output encoded audio.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter
    def channels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of channels in the audio.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[Union[str, 'AacAudioProfile']]]:
        """
        The encoding profile to be used when encoding audio with AAC.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[Union[str, 'AacAudioProfile']]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The sampling rate to use for encoding in hertz.
        """
        return pulumi.get(self, "sampling_rate")

    @sampling_rate.setter
    def sampling_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sampling_rate", value)


@pulumi.input_type
class AbsoluteClipTimeArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 time: pulumi.Input[str]):
        """
        Specifies the clip time as an absolute time position in the media file.  The absolute time can point to a different position depending on whether the media file starts from a timestamp of zero or not.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AbsoluteClipTime'.
        :param pulumi.Input[str] time: The time position on the timeline of the input media. It is usually specified as an ISO8601 period. e.g PT30S for 30 seconds.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AbsoluteClipTime')
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AbsoluteClipTime'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def time(self) -> pulumi.Input[str]:
        """
        The time position on the timeline of the input media. It is usually specified as an ISO8601 period. e.g PT30S for 30 seconds.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: pulumi.Input[str]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class AudioAnalyzerPresetArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 audio_language: Optional[pulumi.Input[str]] = None,
                 experimental_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]] = None):
        """
        The Audio Analyzer preset applies a pre-defined set of AI-based analysis operations, including speech transcription. Currently, the preset supports processing of content with a single audio track.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
        :param pulumi.Input[str] audio_language: The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] experimental_options: Dictionary containing key value pairs for parameters not exposed in the preset itself
        :param pulumi.Input[Union[str, 'AudioAnalysisMode']] mode: Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioAnalyzerPreset')
        if audio_language is not None:
            pulumi.set(__self__, "audio_language", audio_language)
        if experimental_options is not None:
            pulumi.set(__self__, "experimental_options", experimental_options)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="audioLanguage")
    def audio_language(self) -> Optional[pulumi.Input[str]]:
        """
        The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        """
        return pulumi.get(self, "audio_language")

    @audio_language.setter
    def audio_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audio_language", value)

    @property
    @pulumi.getter(name="experimentalOptions")
    def experimental_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary containing key value pairs for parameters not exposed in the preset itself
        """
        return pulumi.get(self, "experimental_options")

    @experimental_options.setter
    def experimental_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "experimental_options", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]]:
        """
        Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class AudioOverlayArgs:
    def __init__(__self__, *,
                 input_label: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 audio_gain_level: Optional[pulumi.Input[float]] = None,
                 end: Optional[pulumi.Input[str]] = None,
                 fade_in_duration: Optional[pulumi.Input[str]] = None,
                 fade_out_duration: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        Describes the properties of an audio overlay.
        :param pulumi.Input[str] input_label: The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioOverlay'.
        :param pulumi.Input[float] audio_gain_level: The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        :param pulumi.Input[str] end: The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        :param pulumi.Input[str] fade_in_duration: The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        :param pulumi.Input[str] fade_out_duration: The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        :param pulumi.Input[str] start: The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        pulumi.set(__self__, "input_label", input_label)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioOverlay')
        if audio_gain_level is not None:
            pulumi.set(__self__, "audio_gain_level", audio_gain_level)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if fade_in_duration is not None:
            pulumi.set(__self__, "fade_in_duration", fade_in_duration)
        if fade_out_duration is not None:
            pulumi.set(__self__, "fade_out_duration", fade_out_duration)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="inputLabel")
    def input_label(self) -> pulumi.Input[str]:
        """
        The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        """
        return pulumi.get(self, "input_label")

    @input_label.setter
    def input_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_label", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioOverlay'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="audioGainLevel")
    def audio_gain_level(self) -> Optional[pulumi.Input[float]]:
        """
        The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        """
        return pulumi.get(self, "audio_gain_level")

    @audio_gain_level.setter
    def audio_gain_level(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "audio_gain_level", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter(name="fadeInDuration")
    def fade_in_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        """
        return pulumi.get(self, "fade_in_duration")

    @fade_in_duration.setter
    def fade_in_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fade_in_duration", value)

    @property
    @pulumi.getter(name="fadeOutDuration")
    def fade_out_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        """
        return pulumi.get(self, "fade_out_duration")

    @fade_out_duration.setter
    def fade_out_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fade_out_duration", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class AudioTrackDescriptorArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 channel_mapping: Optional[pulumi.Input[Union[str, 'ChannelMapping']]] = None):
        """
        A TrackSelection to select audio tracks.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioTrackDescriptor'.
        :param pulumi.Input[Union[str, 'ChannelMapping']] channel_mapping: Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioTrackDescriptor')
        if channel_mapping is not None:
            pulumi.set(__self__, "channel_mapping", channel_mapping)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioTrackDescriptor'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="channelMapping")
    def channel_mapping(self) -> Optional[pulumi.Input[Union[str, 'ChannelMapping']]]:
        """
        Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        return pulumi.get(self, "channel_mapping")

    @channel_mapping.setter
    def channel_mapping(self, value: Optional[pulumi.Input[Union[str, 'ChannelMapping']]]):
        pulumi.set(self, "channel_mapping", value)


@pulumi.input_type
class AudioArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 bitrate: Optional[pulumi.Input[int]] = None,
                 channels: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 sampling_rate: Optional[pulumi.Input[int]] = None):
        """
        Defines the common properties for all audio codecs.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Audio'.
        :param pulumi.Input[int] bitrate: The bitrate, in bits per second, of the output encoded audio.
        :param pulumi.Input[int] channels: The number of channels in the audio.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[int] sampling_rate: The sampling rate to use for encoding in hertz.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Audio')
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Audio'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The bitrate, in bits per second, of the output encoded audio.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter
    def channels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of channels in the audio.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The sampling rate to use for encoding in hertz.
        """
        return pulumi.get(self, "sampling_rate")

    @sampling_rate.setter
    def sampling_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sampling_rate", value)


@pulumi.input_type
class BuiltInStandardEncoderPresetArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 preset_name: pulumi.Input[Union[str, 'EncoderNamedPreset']],
                 configurations: Optional[pulumi.Input['PresetConfigurationsArgs']] = None):
        """
        Describes a built-in preset for encoding the input video with the Standard Encoder.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
        :param pulumi.Input[Union[str, 'EncoderNamedPreset']] preset_name: The built-in preset to be used for encoding videos.
        :param pulumi.Input['PresetConfigurationsArgs'] configurations: Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.BuiltInStandardEncoderPreset')
        pulumi.set(__self__, "preset_name", preset_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> pulumi.Input[Union[str, 'EncoderNamedPreset']]:
        """
        The built-in preset to be used for encoding videos.
        """
        return pulumi.get(self, "preset_name")

    @preset_name.setter
    def preset_name(self, value: pulumi.Input[Union[str, 'EncoderNamedPreset']]):
        pulumi.set(self, "preset_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input['PresetConfigurationsArgs']]:
        """
        Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input['PresetConfigurationsArgs']]):
        pulumi.set(self, "configurations", value)


@pulumi.input_type
class CmafFormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 output_files: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]] = None,
                 streaming_format: Optional[pulumi.Input[Union[str, 'StreamingFormatType']]] = None):
        """
        A CMAF based output format.
        :param pulumi.Input[str] filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.CmafFormat'.
        :param pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.CmafFormat')
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)
        if streaming_format is not None:
            pulumi.set(__self__, "streaming_format", streaming_format)

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.CmafFormat'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")

    @output_files.setter
    def output_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]):
        pulumi.set(self, "output_files", value)

    @property
    @pulumi.getter(name="streamingFormat")
    def streaming_format(self) -> Optional[pulumi.Input[Union[str, 'StreamingFormatType']]]:
        return pulumi.get(self, "streaming_format")

    @streaming_format.setter
    def streaming_format(self, value: Optional[pulumi.Input[Union[str, 'StreamingFormatType']]]):
        pulumi.set(self, "streaming_format", value)


@pulumi.input_type
class CopyAudioArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 label: Optional[pulumi.Input[str]] = None):
        """
        A codec flag, which tells the encoder to copy the input audio bitstream.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.CopyAudio'.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.CopyAudio')
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.CopyAudio'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)


@pulumi.input_type
class CopyVideoArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 label: Optional[pulumi.Input[str]] = None):
        """
        A codec flag, which tells the encoder to copy the input video bitstream without re-encoding.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.CopyVideo'.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.CopyVideo')
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.CopyVideo'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)


@pulumi.input_type
class DDAudioArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 bitrate: Optional[pulumi.Input[int]] = None,
                 channels: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 sampling_rate: Optional[pulumi.Input[int]] = None):
        """
        Describes Dolby Digital Audio Codec (AC3) audio encoding settings. The current implementation for Dolby Digital Audio support are: Audio channel numbers at 1((mono), 2(stereo), 6(5.1side); Audio sampling frequency rates at: 32K/44.1K/48K Hz; Audio bitrate values as AC3 specification supports: 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 448000, 512000, 576000, 640000 bps.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.DDAudio'.
        :param pulumi.Input[int] bitrate: The bitrate, in bits per second, of the output encoded audio.
        :param pulumi.Input[int] channels: The number of channels in the audio.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[int] sampling_rate: The sampling rate to use for encoding in hertz.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.DDAudio')
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if channels is not None:
            pulumi.set(__self__, "channels", channels)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.DDAudio'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The bitrate, in bits per second, of the output encoded audio.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter
    def channels(self) -> Optional[pulumi.Input[int]]:
        """
        The number of channels in the audio.
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The sampling rate to use for encoding in hertz.
        """
        return pulumi.get(self, "sampling_rate")

    @sampling_rate.setter
    def sampling_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sampling_rate", value)


@pulumi.input_type
class DeinterlaceArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[Union[str, 'DeinterlaceMode']]] = None,
                 parity: Optional[pulumi.Input[Union[str, 'DeinterlaceParity']]] = None):
        """
        Describes the de-interlacing settings.
        :param pulumi.Input[Union[str, 'DeinterlaceMode']] mode: The deinterlacing mode. Defaults to AutoPixelAdaptive.
        :param pulumi.Input[Union[str, 'DeinterlaceParity']] parity: The field parity for de-interlacing, defaults to Auto.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if parity is not None:
            pulumi.set(__self__, "parity", parity)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'DeinterlaceMode']]]:
        """
        The deinterlacing mode. Defaults to AutoPixelAdaptive.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'DeinterlaceMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def parity(self) -> Optional[pulumi.Input[Union[str, 'DeinterlaceParity']]]:
        """
        The field parity for de-interlacing, defaults to Auto.
        """
        return pulumi.get(self, "parity")

    @parity.setter
    def parity(self, value: Optional[pulumi.Input[Union[str, 'DeinterlaceParity']]]):
        pulumi.set(self, "parity", value)


@pulumi.input_type
class FaceDetectorPresetArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 blur_type: Optional[pulumi.Input[Union[str, 'BlurType']]] = None,
                 experimental_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'FaceRedactorMode']]] = None,
                 resolution: Optional[pulumi.Input[Union[str, 'AnalysisResolution']]] = None):
        """
        Describes all the settings to be used when analyzing a video in order to detect (and optionally redact) all the faces present.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.FaceDetectorPreset'.
        :param pulumi.Input[Union[str, 'BlurType']] blur_type: Blur type
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] experimental_options: Dictionary containing key value pairs for parameters not exposed in the preset itself
        :param pulumi.Input[Union[str, 'FaceRedactorMode']] mode: This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
        :param pulumi.Input[Union[str, 'AnalysisResolution']] resolution: Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.FaceDetectorPreset')
        if blur_type is not None:
            pulumi.set(__self__, "blur_type", blur_type)
        if experimental_options is not None:
            pulumi.set(__self__, "experimental_options", experimental_options)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.FaceDetectorPreset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="blurType")
    def blur_type(self) -> Optional[pulumi.Input[Union[str, 'BlurType']]]:
        """
        Blur type
        """
        return pulumi.get(self, "blur_type")

    @blur_type.setter
    def blur_type(self, value: Optional[pulumi.Input[Union[str, 'BlurType']]]):
        pulumi.set(self, "blur_type", value)

    @property
    @pulumi.getter(name="experimentalOptions")
    def experimental_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary containing key value pairs for parameters not exposed in the preset itself
        """
        return pulumi.get(self, "experimental_options")

    @experimental_options.setter
    def experimental_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "experimental_options", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'FaceRedactorMode']]]:
        """
        This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'FaceRedactorMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def resolution(self) -> Optional[pulumi.Input[Union[str, 'AnalysisResolution']]]:
        """
        Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
        """
        return pulumi.get(self, "resolution")

    @resolution.setter
    def resolution(self, value: Optional[pulumi.Input[Union[str, 'AnalysisResolution']]]):
        pulumi.set(self, "resolution", value)


@pulumi.input_type
class FiltersArgs:
    def __init__(__self__, *,
                 crop: Optional[pulumi.Input['RectangleArgs']] = None,
                 deinterlace: Optional[pulumi.Input['DeinterlaceArgs']] = None,
                 overlays: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioOverlayArgs', 'VideoOverlayArgs']]]]] = None,
                 rotation: Optional[pulumi.Input[Union[str, 'Rotation']]] = None):
        """
        Describes all the filtering operations, such as de-interlacing, rotation etc. that are to be applied to the input media before encoding.
        :param pulumi.Input['RectangleArgs'] crop: The parameters for the rectangular window with which to crop the input video.
        :param pulumi.Input['DeinterlaceArgs'] deinterlace: The de-interlacing settings.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AudioOverlayArgs', 'VideoOverlayArgs']]]] overlays: The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
        :param pulumi.Input[Union[str, 'Rotation']] rotation: The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
        """
        if crop is not None:
            pulumi.set(__self__, "crop", crop)
        if deinterlace is not None:
            pulumi.set(__self__, "deinterlace", deinterlace)
        if overlays is not None:
            pulumi.set(__self__, "overlays", overlays)
        if rotation is not None:
            pulumi.set(__self__, "rotation", rotation)

    @property
    @pulumi.getter
    def crop(self) -> Optional[pulumi.Input['RectangleArgs']]:
        """
        The parameters for the rectangular window with which to crop the input video.
        """
        return pulumi.get(self, "crop")

    @crop.setter
    def crop(self, value: Optional[pulumi.Input['RectangleArgs']]):
        pulumi.set(self, "crop", value)

    @property
    @pulumi.getter
    def deinterlace(self) -> Optional[pulumi.Input['DeinterlaceArgs']]:
        """
        The de-interlacing settings.
        """
        return pulumi.get(self, "deinterlace")

    @deinterlace.setter
    def deinterlace(self, value: Optional[pulumi.Input['DeinterlaceArgs']]):
        pulumi.set(self, "deinterlace", value)

    @property
    @pulumi.getter
    def overlays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioOverlayArgs', 'VideoOverlayArgs']]]]]:
        """
        The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
        """
        return pulumi.get(self, "overlays")

    @overlays.setter
    def overlays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioOverlayArgs', 'VideoOverlayArgs']]]]]):
        pulumi.set(self, "overlays", value)

    @property
    @pulumi.getter
    def rotation(self) -> Optional[pulumi.Input[Union[str, 'Rotation']]]:
        """
        The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
        """
        return pulumi.get(self, "rotation")

    @rotation.setter
    def rotation(self, value: Optional[pulumi.Input[Union[str, 'Rotation']]]):
        pulumi.set(self, "rotation", value)


@pulumi.input_type
class FromAllInputFileArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 included_tracks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]] = None):
        """
        An InputDefinition that looks across all of the files provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to allow selection of a single track across a set of input files.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.FromAllInputFile'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]] included_tracks: The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.FromAllInputFile')
        if included_tracks is not None:
            pulumi.set(__self__, "included_tracks", included_tracks)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.FromAllInputFile'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="includedTracks")
    def included_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]:
        """
        The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        return pulumi.get(self, "included_tracks")

    @included_tracks.setter
    def included_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]):
        pulumi.set(self, "included_tracks", value)


@pulumi.input_type
class FromEachInputFileArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 included_tracks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]] = None):
        """
        An InputDefinition that looks at each input file provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to select tracks from each file given.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.FromEachInputFile'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]] included_tracks: The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.FromEachInputFile')
        if included_tracks is not None:
            pulumi.set(__self__, "included_tracks", included_tracks)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.FromEachInputFile'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="includedTracks")
    def included_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]:
        """
        The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        return pulumi.get(self, "included_tracks")

    @included_tracks.setter
    def included_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]):
        pulumi.set(self, "included_tracks", value)


@pulumi.input_type
class H264LayerArgs:
    def __init__(__self__, *,
                 bitrate: pulumi.Input[int],
                 adaptive_b_frame: Optional[pulumi.Input[bool]] = None,
                 b_frames: Optional[pulumi.Input[int]] = None,
                 buffer_window: Optional[pulumi.Input[str]] = None,
                 crf: Optional[pulumi.Input[float]] = None,
                 entropy_mode: Optional[pulumi.Input[Union[str, 'EntropyMode']]] = None,
                 frame_rate: Optional[pulumi.Input[str]] = None,
                 height: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 max_bitrate: Optional[pulumi.Input[int]] = None,
                 profile: Optional[pulumi.Input[Union[str, 'H264VideoProfile']]] = None,
                 reference_frames: Optional[pulumi.Input[int]] = None,
                 slices: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.264 video codec.
        :param pulumi.Input[int] bitrate: The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
        :param pulumi.Input[bool] adaptive_b_frame: Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        :param pulumi.Input[int] b_frames: The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        :param pulumi.Input[str] buffer_window: The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        :param pulumi.Input[float] crf: The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 23.
        :param pulumi.Input[Union[str, 'EntropyMode']] entropy_mode: The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
        :param pulumi.Input[str] frame_rate: The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        :param pulumi.Input[str] height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param pulumi.Input[str] label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param pulumi.Input[str] level: We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        :param pulumi.Input[int] max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        :param pulumi.Input[Union[str, 'H264VideoProfile']] profile: We currently support Baseline, Main, High, High422, High444. Default is Auto.
        :param pulumi.Input[int] reference_frames: The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        :param pulumi.Input[int] slices: The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        :param pulumi.Input[str] width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        pulumi.set(__self__, "bitrate", bitrate)
        if adaptive_b_frame is not None:
            pulumi.set(__self__, "adaptive_b_frame", adaptive_b_frame)
        if b_frames is not None:
            pulumi.set(__self__, "b_frames", b_frames)
        if buffer_window is not None:
            pulumi.set(__self__, "buffer_window", buffer_window)
        if crf is not None:
            pulumi.set(__self__, "crf", crf)
        if entropy_mode is not None:
            pulumi.set(__self__, "entropy_mode", entropy_mode)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if reference_frames is not None:
            pulumi.set(__self__, "reference_frames", reference_frames)
        if slices is not None:
            pulumi.set(__self__, "slices", slices)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def bitrate(self) -> pulumi.Input[int]:
        """
        The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: pulumi.Input[int]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter(name="adaptiveBFrame")
    def adaptive_b_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        """
        return pulumi.get(self, "adaptive_b_frame")

    @adaptive_b_frame.setter
    def adaptive_b_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "adaptive_b_frame", value)

    @property
    @pulumi.getter(name="bFrames")
    def b_frames(self) -> Optional[pulumi.Input[int]]:
        """
        The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        """
        return pulumi.get(self, "b_frames")

    @b_frames.setter
    def b_frames(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "b_frames", value)

    @property
    @pulumi.getter(name="bufferWindow")
    def buffer_window(self) -> Optional[pulumi.Input[str]]:
        """
        The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        """
        return pulumi.get(self, "buffer_window")

    @buffer_window.setter
    def buffer_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "buffer_window", value)

    @property
    @pulumi.getter
    def crf(self) -> Optional[pulumi.Input[float]]:
        """
        The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 23.
        """
        return pulumi.get(self, "crf")

    @crf.setter
    def crf(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "crf", value)

    @property
    @pulumi.getter(name="entropyMode")
    def entropy_mode(self) -> Optional[pulumi.Input[Union[str, 'EntropyMode']]]:
        """
        The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level.
        """
        return pulumi.get(self, "entropy_mode")

    @entropy_mode.setter
    def entropy_mode(self, value: Optional[pulumi.Input[Union[str, 'EntropyMode']]]):
        pulumi.set(self, "entropy_mode", value)

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[pulumi.Input[str]]:
        """
        The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        """
        return pulumi.get(self, "frame_rate")

    @frame_rate.setter
    def frame_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frame_rate", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bitrate", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[Union[str, 'H264VideoProfile']]]:
        """
        We currently support Baseline, Main, High, High422, High444. Default is Auto.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[Union[str, 'H264VideoProfile']]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="referenceFrames")
    def reference_frames(self) -> Optional[pulumi.Input[int]]:
        """
        The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        """
        return pulumi.get(self, "reference_frames")

    @reference_frames.setter
    def reference_frames(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reference_frames", value)

    @property
    @pulumi.getter
    def slices(self) -> Optional[pulumi.Input[int]]:
        """
        The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        """
        return pulumi.get(self, "slices")

    @slices.setter
    def slices(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "slices", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class H264VideoArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 complexity: Optional[pulumi.Input[Union[str, 'H264Complexity']]] = None,
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input['H264LayerArgs']]]] = None,
                 rate_control_mode: Optional[pulumi.Input[Union[str, 'H264RateControlMode']]] = None,
                 scene_change_detection: Optional[pulumi.Input[bool]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes all the properties for encoding a video with the H.264 codec.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.H264Video'.
        :param pulumi.Input[Union[str, 'H264Complexity']] complexity: Tells the encoder how to choose its encoding settings. The default value is Balanced.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Sequence[pulumi.Input['H264LayerArgs']]] layers: The collection of output H.264 layers to be produced by the encoder.
        :param pulumi.Input[Union[str, 'H264RateControlMode']] rate_control_mode: The video rate control mode
        :param pulumi.Input[bool] scene_change_detection: Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.H264Video')
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if rate_control_mode is not None:
            pulumi.set(__self__, "rate_control_mode", rate_control_mode)
        if scene_change_detection is not None:
            pulumi.set(__self__, "scene_change_detection", scene_change_detection)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.H264Video'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[Union[str, 'H264Complexity']]]:
        """
        Tells the encoder how to choose its encoding settings. The default value is Balanced.
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[Union[str, 'H264Complexity']]]):
        pulumi.set(self, "complexity", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['H264LayerArgs']]]]:
        """
        The collection of output H.264 layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['H264LayerArgs']]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="rateControlMode")
    def rate_control_mode(self) -> Optional[pulumi.Input[Union[str, 'H264RateControlMode']]]:
        """
        The video rate control mode
        """
        return pulumi.get(self, "rate_control_mode")

    @rate_control_mode.setter
    def rate_control_mode(self, value: Optional[pulumi.Input[Union[str, 'H264RateControlMode']]]):
        pulumi.set(self, "rate_control_mode", value)

    @property
    @pulumi.getter(name="sceneChangeDetection")
    def scene_change_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        """
        return pulumi.get(self, "scene_change_detection")

    @scene_change_detection.setter
    def scene_change_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scene_change_detection", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


@pulumi.input_type
class H265LayerArgs:
    def __init__(__self__, *,
                 bitrate: pulumi.Input[int],
                 adaptive_b_frame: Optional[pulumi.Input[bool]] = None,
                 b_frames: Optional[pulumi.Input[int]] = None,
                 buffer_window: Optional[pulumi.Input[str]] = None,
                 crf: Optional[pulumi.Input[float]] = None,
                 frame_rate: Optional[pulumi.Input[str]] = None,
                 height: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 max_bitrate: Optional[pulumi.Input[int]] = None,
                 profile: Optional[pulumi.Input[Union[str, 'H265VideoProfile']]] = None,
                 reference_frames: Optional[pulumi.Input[int]] = None,
                 slices: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.265 video codec.
        :param pulumi.Input[int] bitrate: The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
        :param pulumi.Input[bool] adaptive_b_frame: Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        :param pulumi.Input[int] b_frames: The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        :param pulumi.Input[str] buffer_window: The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        :param pulumi.Input[float] crf: The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 28.
        :param pulumi.Input[str] frame_rate: The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        :param pulumi.Input[str] height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param pulumi.Input[str] label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param pulumi.Input[str] level: We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        :param pulumi.Input[int] max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        :param pulumi.Input[Union[str, 'H265VideoProfile']] profile: We currently support Main. Default is Auto.
        :param pulumi.Input[int] reference_frames: The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        :param pulumi.Input[int] slices: The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        :param pulumi.Input[str] width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        pulumi.set(__self__, "bitrate", bitrate)
        if adaptive_b_frame is not None:
            pulumi.set(__self__, "adaptive_b_frame", adaptive_b_frame)
        if b_frames is not None:
            pulumi.set(__self__, "b_frames", b_frames)
        if buffer_window is not None:
            pulumi.set(__self__, "buffer_window", buffer_window)
        if crf is not None:
            pulumi.set(__self__, "crf", crf)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if reference_frames is not None:
            pulumi.set(__self__, "reference_frames", reference_frames)
        if slices is not None:
            pulumi.set(__self__, "slices", slices)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def bitrate(self) -> pulumi.Input[int]:
        """
        The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: pulumi.Input[int]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter(name="adaptiveBFrame")
    def adaptive_b_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
        """
        return pulumi.get(self, "adaptive_b_frame")

    @adaptive_b_frame.setter
    def adaptive_b_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "adaptive_b_frame", value)

    @property
    @pulumi.getter(name="bFrames")
    def b_frames(self) -> Optional[pulumi.Input[int]]:
        """
        The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
        """
        return pulumi.get(self, "b_frames")

    @b_frames.setter
    def b_frames(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "b_frames", value)

    @property
    @pulumi.getter(name="bufferWindow")
    def buffer_window(self) -> Optional[pulumi.Input[str]]:
        """
        The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
        """
        return pulumi.get(self, "buffer_window")

    @buffer_window.setter
    def buffer_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "buffer_window", value)

    @property
    @pulumi.getter
    def crf(self) -> Optional[pulumi.Input[float]]:
        """
        The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 28.
        """
        return pulumi.get(self, "crf")

    @crf.setter
    def crf(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "crf", value)

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[pulumi.Input[str]]:
        """
        The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
        """
        return pulumi.get(self, "frame_rate")

    @frame_rate.setter
    def frame_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frame_rate", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bitrate", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[Union[str, 'H265VideoProfile']]]:
        """
        We currently support Main. Default is Auto.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[Union[str, 'H265VideoProfile']]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="referenceFrames")
    def reference_frames(self) -> Optional[pulumi.Input[int]]:
        """
        The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
        """
        return pulumi.get(self, "reference_frames")

    @reference_frames.setter
    def reference_frames(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reference_frames", value)

    @property
    @pulumi.getter
    def slices(self) -> Optional[pulumi.Input[int]]:
        """
        The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
        """
        return pulumi.get(self, "slices")

    @slices.setter
    def slices(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "slices", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class H265VideoArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 complexity: Optional[pulumi.Input[Union[str, 'H265Complexity']]] = None,
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input['H265LayerArgs']]]] = None,
                 scene_change_detection: Optional[pulumi.Input[bool]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes all the properties for encoding a video with the H.265 codec.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.H265Video'.
        :param pulumi.Input[Union[str, 'H265Complexity']] complexity: Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Sequence[pulumi.Input['H265LayerArgs']]] layers: The collection of output H.265 layers to be produced by the encoder.
        :param pulumi.Input[bool] scene_change_detection: Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.H265Video')
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if scene_change_detection is not None:
            pulumi.set(__self__, "scene_change_detection", scene_change_detection)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.H265Video'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[Union[str, 'H265Complexity']]]:
        """
        Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced.
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[Union[str, 'H265Complexity']]]):
        pulumi.set(self, "complexity", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['H265LayerArgs']]]]:
        """
        The collection of output H.265 layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['H265LayerArgs']]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="sceneChangeDetection")
    def scene_change_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
        """
        return pulumi.get(self, "scene_change_detection")

    @scene_change_detection.setter
    def scene_change_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scene_change_detection", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


@pulumi.input_type
class ImageFormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Describes the properties for an output image file.
        :param pulumi.Input[str] filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ImageFormat'.
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ImageFormat')

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ImageFormat'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 start: pulumi.Input[str],
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 range: Optional[pulumi.Input[str]] = None,
                 step: Optional[pulumi.Input[str]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes the basic properties for generating thumbnails from the input video
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Image'.
        :param pulumi.Input[str] start: The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[str] range: The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        :param pulumi.Input[str] step: The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Image')
        pulumi.set(__self__, "start", start)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Image'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[str]]:
        """
        The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter
    def step(self) -> Optional[pulumi.Input[str]]:
        """
        The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        """
        return pulumi.get(self, "step")

    @step.setter
    def step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


@pulumi.input_type
class InputFileArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 filename: Optional[pulumi.Input[str]] = None,
                 included_tracks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]] = None):
        """
        An InputDefinition for a single file.  TrackSelections are scoped to the file specified.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.InputFile'.
        :param pulumi.Input[str] filename: Name of the file that this input definition applies to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]] included_tracks: The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.InputFile')
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if included_tracks is not None:
            pulumi.set(__self__, "included_tracks", included_tracks)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.InputFile'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the file that this input definition applies to.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filename", value)

    @property
    @pulumi.getter(name="includedTracks")
    def included_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]:
        """
        The list of TrackDescriptors which define the metadata and selection of tracks in the input.
        """
        return pulumi.get(self, "included_tracks")

    @included_tracks.setter
    def included_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AudioTrackDescriptorArgs', 'SelectAudioTrackByAttributeArgs', 'SelectAudioTrackByIdArgs', 'SelectVideoTrackByAttributeArgs', 'SelectVideoTrackByIdArgs', 'VideoTrackDescriptorArgs']]]]]):
        pulumi.set(self, "included_tracks", value)


@pulumi.input_type
class JobInputAssetArgs:
    def __init__(__self__, *,
                 asset_name: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 end: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 input_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None):
        """
        Represents an Asset for input into a Job.
        :param pulumi.Input[str] asset_name: The name of the input Asset.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputAsset'.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] end: Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]] input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        :param pulumi.Input[str] label: A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] start: Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        pulumi.set(__self__, "asset_name", asset_name)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputAsset')
        if end is not None:
            pulumi.set(__self__, "end", end)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if input_definitions is not None:
            pulumi.set(__self__, "input_definitions", input_definitions)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> pulumi.Input[str]:
        """
        The name of the input Asset.
        """
        return pulumi.get(self, "asset_name")

    @asset_name.setter
    def asset_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "asset_name", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputAsset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="inputDefinitions")
    def input_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]:
        """
        Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        """
        return pulumi.get(self, "input_definitions")

    @input_definitions.setter
    def input_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]):
        pulumi.set(self, "input_definitions", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class JobInputClipArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 end: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 input_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None):
        """
        Represents input files for a Job.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputClip'.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] end: Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]] input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        :param pulumi.Input[str] label: A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] start: Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputClip')
        if end is not None:
            pulumi.set(__self__, "end", end)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if input_definitions is not None:
            pulumi.set(__self__, "input_definitions", input_definitions)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputClip'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="inputDefinitions")
    def input_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]:
        """
        Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        """
        return pulumi.get(self, "input_definitions")

    @input_definitions.setter
    def input_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]):
        pulumi.set(self, "input_definitions", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class JobInputHttpArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 base_uri: Optional[pulumi.Input[str]] = None,
                 end: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 input_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]] = None):
        """
        Represents HTTPS job input.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputHttp'.
        :param pulumi.Input[str] base_uri: Base URI for HTTPS job input. It will be concatenated with provided file names. If no base uri is given, then the provided file list is assumed to be fully qualified uris. Maximum length of 4000 characters. The query strings will not be returned in service responses to prevent sensitive data exposure.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] end: Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]] input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        :param pulumi.Input[str] label: A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        :param pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']] start: Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputHttp')
        if base_uri is not None:
            pulumi.set(__self__, "base_uri", base_uri)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if input_definitions is not None:
            pulumi.set(__self__, "input_definitions", input_definitions)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputHttp'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="baseUri")
    def base_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Base URI for HTTPS job input. It will be concatenated with provided file names. If no base uri is given, then the provided file list is assumed to be fully qualified uris. Maximum length of 4000 characters. The query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "base_uri")

    @base_uri.setter
    def base_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_uri", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="inputDefinitions")
    def input_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]:
        """
        Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
        """
        return pulumi.get(self, "input_definitions")

    @input_definitions.setter
    def input_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FromAllInputFileArgs', 'FromEachInputFileArgs', 'InputFileArgs']]]]]):
        pulumi.set(self, "input_definitions", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]:
        """
        Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[Union['AbsoluteClipTimeArgs', 'UtcClipTimeArgs']]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class JobInputSequenceArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input['JobInputClipArgs']]]] = None):
        """
        A Sequence contains an ordered list of Clips where each clip is a JobInput.  The Sequence will be treated as a single input.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputSequence'.
        :param pulumi.Input[Sequence[pulumi.Input['JobInputClipArgs']]] inputs: JobInputs that make up the timeline.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputSequence')
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputSequence'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobInputClipArgs']]]]:
        """
        JobInputs that make up the timeline.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobInputClipArgs']]]]):
        pulumi.set(self, "inputs", value)


@pulumi.input_type
class JobInputsArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 inputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobInputAssetArgs', 'JobInputClipArgs', 'JobInputHttpArgs', 'JobInputSequenceArgs', 'JobInputsArgs']]]]] = None):
        """
        Describes a list of inputs to a Job.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobInputs'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobInputAssetArgs', 'JobInputClipArgs', 'JobInputHttpArgs', 'JobInputSequenceArgs', 'JobInputsArgs']]]] inputs: List of inputs to a Job.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobInputs')
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobInputs'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobInputAssetArgs', 'JobInputClipArgs', 'JobInputHttpArgs', 'JobInputSequenceArgs', 'JobInputsArgs']]]]]:
        """
        List of inputs to a Job.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobInputAssetArgs', 'JobInputClipArgs', 'JobInputHttpArgs', 'JobInputSequenceArgs', 'JobInputsArgs']]]]]):
        pulumi.set(self, "inputs", value)


@pulumi.input_type
class JobOutputAssetArgs:
    def __init__(__self__, *,
                 asset_name: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 label: Optional[pulumi.Input[str]] = None,
                 preset_override: Optional[pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']]] = None):
        """
        Represents an Asset used as a JobOutput.
        :param pulumi.Input[str] asset_name: The name of the output Asset.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JobOutputAsset'.
        :param pulumi.Input[str] label: A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more than one TransformOutput, whereby your Job has more than one JobOutput. In such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you retrieve the Job, either through events or on a GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the Job. Note that this index is the same as the relative index of the corresponding TransformOutput within its Transform.
        :param pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']] preset_override: A preset used to override the preset in the corresponding transform output.
        """
        pulumi.set(__self__, "asset_name", asset_name)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JobOutputAsset')
        if label is not None:
            pulumi.set(__self__, "label", label)
        if preset_override is not None:
            pulumi.set(__self__, "preset_override", preset_override)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> pulumi.Input[str]:
        """
        The name of the output Asset.
        """
        return pulumi.get(self, "asset_name")

    @asset_name.setter
    def asset_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "asset_name", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JobOutputAsset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more than one TransformOutput, whereby your Job has more than one JobOutput. In such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you retrieve the Job, either through events or on a GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the Job. Note that this index is the same as the relative index of the corresponding TransformOutput within its Transform.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="presetOverride")
    def preset_override(self) -> Optional[pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']]]:
        """
        A preset used to override the preset in the corresponding transform output.
        """
        return pulumi.get(self, "preset_override")

    @preset_override.setter
    def preset_override(self, value: Optional[pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']]]):
        pulumi.set(self, "preset_override", value)


@pulumi.input_type
class JpgFormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Describes the settings for producing JPEG thumbnails.
        :param pulumi.Input[str] filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JpgFormat'.
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JpgFormat')

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JpgFormat'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class JpgImageArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 start: pulumi.Input[str],
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input['JpgLayerArgs']]]] = None,
                 range: Optional[pulumi.Input[str]] = None,
                 sprite_column: Optional[pulumi.Input[int]] = None,
                 step: Optional[pulumi.Input[str]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes the properties for producing a series of JPEG images from the input video.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.JpgImage'.
        :param pulumi.Input[str] start: The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Sequence[pulumi.Input['JpgLayerArgs']]] layers: A collection of output JPEG image layers to be produced by the encoder.
        :param pulumi.Input[str] range: The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        :param pulumi.Input[int] sprite_column: Sets the number of columns used in thumbnail sprite image.  The number of rows are automatically calculated and a VTT file is generated with the coordinate mappings for each thumbnail in the sprite. Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will not go beyond JPEG maximum pixel resolution limit 65535x65535.
        :param pulumi.Input[str] step: The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.JpgImage')
        pulumi.set(__self__, "start", start)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if sprite_column is not None:
            pulumi.set(__self__, "sprite_column", sprite_column)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.JpgImage'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JpgLayerArgs']]]]:
        """
        A collection of output JPEG image layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JpgLayerArgs']]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[str]]:
        """
        The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter(name="spriteColumn")
    def sprite_column(self) -> Optional[pulumi.Input[int]]:
        """
        Sets the number of columns used in thumbnail sprite image.  The number of rows are automatically calculated and a VTT file is generated with the coordinate mappings for each thumbnail in the sprite. Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will not go beyond JPEG maximum pixel resolution limit 65535x65535.
        """
        return pulumi.get(self, "sprite_column")

    @sprite_column.setter
    def sprite_column(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sprite_column", value)

    @property
    @pulumi.getter
    def step(self) -> Optional[pulumi.Input[str]]:
        """
        The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        """
        return pulumi.get(self, "step")

    @step.setter
    def step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


@pulumi.input_type
class JpgLayerArgs:
    def __init__(__self__, *,
                 height: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 quality: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Describes the settings to produce a JPEG image from the input video.
        :param pulumi.Input[str] height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param pulumi.Input[str] label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param pulumi.Input[int] quality: The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
        :param pulumi.Input[str] width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def quality(self) -> Optional[pulumi.Input[int]]:
        """
        The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
        """
        return pulumi.get(self, "quality")

    @quality.setter
    def quality(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quality", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class Mp4FormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 output_files: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]] = None):
        """
        Describes the properties for an output ISO MP4 file.
        :param pulumi.Input[str] filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Mp4Format'.
        :param pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Mp4Format')
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Mp4Format'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")

    @output_files.setter
    def output_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]):
        pulumi.set(self, "output_files", value)


@pulumi.input_type
class MultiBitrateFormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 output_files: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]] = None):
        """
        Describes the properties for producing a collection of GOP aligned multi-bitrate files. The default behavior is to produce one output file for each video layer which is muxed together with all the audios. The exact output files produced can be controlled by specifying the outputFiles collection.
        :param pulumi.Input[str] filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.MultiBitrateFormat'.
        :param pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.MultiBitrateFormat')
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.MultiBitrateFormat'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")

    @output_files.setter
    def output_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]):
        pulumi.set(self, "output_files", value)


@pulumi.input_type
class OutputFileArgs:
    def __init__(__self__, *,
                 labels: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Represents an output file produced.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The list of labels that describe how the encoder should multiplex video and audio into an output file. For example, if the encoder is producing two video layers with labels v1 and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented by v1 and the audio track represented by a1.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of labels that describe how the encoder should multiplex video and audio into an output file. For example, if the encoder is producing two video layers with labels v1 and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented by v1 and the audio track represented by a1.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class PngFormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Describes the settings for producing PNG thumbnails.
        :param pulumi.Input[str] filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.PngFormat'.
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.PngFormat')

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.PngFormat'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class PngImageArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 start: pulumi.Input[str],
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input['PngLayerArgs']]]] = None,
                 range: Optional[pulumi.Input[str]] = None,
                 step: Optional[pulumi.Input[str]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes the properties for producing a series of PNG images from the input video.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.PngImage'.
        :param pulumi.Input[str] start: The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Sequence[pulumi.Input['PngLayerArgs']]] layers: A collection of output PNG image layers to be produced by the encoder.
        :param pulumi.Input[str] range: The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        :param pulumi.Input[str] step: The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.PngImage')
        pulumi.set(__self__, "start", start)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if step is not None:
            pulumi.set(__self__, "step", step)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.PngImage'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PngLayerArgs']]]]:
        """
        A collection of output PNG image layers to be produced by the encoder.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PngLayerArgs']]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[str]]:
        """
        The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter
    def step(self) -> Optional[pulumi.Input[str]]:
        """
        The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
        """
        return pulumi.get(self, "step")

    @step.setter
    def step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


@pulumi.input_type
class PngLayerArgs:
    def __init__(__self__, *,
                 height: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Describes the settings to produce a PNG image from the input video.
        :param pulumi.Input[str] height: The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        :param pulumi.Input[str] label: The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        :param pulumi.Input[str] width: The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class PresetConfigurationsArgs:
    def __init__(__self__, *,
                 complexity: Optional[pulumi.Input[Union[str, 'Complexity']]] = None,
                 interleave_output: Optional[pulumi.Input[Union[str, 'InterleaveOutput']]] = None,
                 key_frame_interval_in_seconds: Optional[pulumi.Input[float]] = None,
                 max_bitrate_bps: Optional[pulumi.Input[int]] = None,
                 max_height: Optional[pulumi.Input[int]] = None,
                 max_layers: Optional[pulumi.Input[int]] = None,
                 min_bitrate_bps: Optional[pulumi.Input[int]] = None,
                 min_height: Optional[pulumi.Input[int]] = None,
                 output_format: Optional[pulumi.Input[Union['CmafFormatArgs', 'ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']]] = None):
        """
        An object of optional configuration settings for encoder.
        :param pulumi.Input[Union[str, 'Complexity']] complexity: Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
        :param pulumi.Input[Union[str, 'InterleaveOutput']] interleave_output: Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
        :param pulumi.Input[float] key_frame_interval_in_seconds: The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
        :param pulumi.Input[int] max_bitrate_bps: The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for contents with high complexity.
        :param pulumi.Input[int] max_height: The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the input is 4K.
        :param pulumi.Input[int] max_layers: The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced to control the overall cost of the encoding job.
        :param pulumi.Input[int] min_bitrate_bps: The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users with low network bandwidth.
        :param pulumi.Input[int] min_height: The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions like 180P.
        :param pulumi.Input[Union['CmafFormatArgs', 'ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']] output_format: Sets the output format type. Only Mp4Format and CmafFormat are supported in current implementation. Example: set OutputFormat as CmafFormat to produce audio/video stream variant and manifest files for streaming.
        """
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if interleave_output is not None:
            pulumi.set(__self__, "interleave_output", interleave_output)
        if key_frame_interval_in_seconds is not None:
            pulumi.set(__self__, "key_frame_interval_in_seconds", key_frame_interval_in_seconds)
        if max_bitrate_bps is not None:
            pulumi.set(__self__, "max_bitrate_bps", max_bitrate_bps)
        if max_height is not None:
            pulumi.set(__self__, "max_height", max_height)
        if max_layers is not None:
            pulumi.set(__self__, "max_layers", max_layers)
        if min_bitrate_bps is not None:
            pulumi.set(__self__, "min_bitrate_bps", min_bitrate_bps)
        if min_height is not None:
            pulumi.set(__self__, "min_height", min_height)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)

    @property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[Union[str, 'Complexity']]]:
        """
        Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[Union[str, 'Complexity']]]):
        pulumi.set(self, "complexity", value)

    @property
    @pulumi.getter(name="interleaveOutput")
    def interleave_output(self) -> Optional[pulumi.Input[Union[str, 'InterleaveOutput']]]:
        """
        Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
        """
        return pulumi.get(self, "interleave_output")

    @interleave_output.setter
    def interleave_output(self, value: Optional[pulumi.Input[Union[str, 'InterleaveOutput']]]):
        pulumi.set(self, "interleave_output", value)

    @property
    @pulumi.getter(name="keyFrameIntervalInSeconds")
    def key_frame_interval_in_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
        """
        return pulumi.get(self, "key_frame_interval_in_seconds")

    @key_frame_interval_in_seconds.setter
    def key_frame_interval_in_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "key_frame_interval_in_seconds", value)

    @property
    @pulumi.getter(name="maxBitrateBps")
    def max_bitrate_bps(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for contents with high complexity.
        """
        return pulumi.get(self, "max_bitrate_bps")

    @max_bitrate_bps.setter
    def max_bitrate_bps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bitrate_bps", value)

    @property
    @pulumi.getter(name="maxHeight")
    def max_height(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the input is 4K.
        """
        return pulumi.get(self, "max_height")

    @max_height.setter
    def max_height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_height", value)

    @property
    @pulumi.getter(name="maxLayers")
    def max_layers(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced to control the overall cost of the encoding job.
        """
        return pulumi.get(self, "max_layers")

    @max_layers.setter
    def max_layers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_layers", value)

    @property
    @pulumi.getter(name="minBitrateBps")
    def min_bitrate_bps(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users with low network bandwidth.
        """
        return pulumi.get(self, "min_bitrate_bps")

    @min_bitrate_bps.setter
    def min_bitrate_bps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_bitrate_bps", value)

    @property
    @pulumi.getter(name="minHeight")
    def min_height(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions like 180P.
        """
        return pulumi.get(self, "min_height")

    @min_height.setter
    def min_height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_height", value)

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[pulumi.Input[Union['CmafFormatArgs', 'ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']]]:
        """
        Sets the output format type. Only Mp4Format and CmafFormat are supported in current implementation. Example: set OutputFormat as CmafFormat to produce audio/video stream variant and manifest files for streaming.
        """
        return pulumi.get(self, "output_format")

    @output_format.setter
    def output_format(self, value: Optional[pulumi.Input[Union['CmafFormatArgs', 'ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']]]):
        pulumi.set(self, "output_format", value)


@pulumi.input_type
class RectangleArgs:
    def __init__(__self__, *,
                 height: Optional[pulumi.Input[str]] = None,
                 left: Optional[pulumi.Input[str]] = None,
                 top: Optional[pulumi.Input[str]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Describes the properties of a rectangular window applied to the input media before processing it.
        :param pulumi.Input[str] height: The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param pulumi.Input[str] left: The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param pulumi.Input[str] top: The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        :param pulumi.Input[str] width: The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if left is not None:
            pulumi.set(__self__, "left", left)
        if top is not None:
            pulumi.set(__self__, "top", top)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def left(self) -> Optional[pulumi.Input[str]]:
        """
        The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "left")

    @left.setter
    def left(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "left", value)

    @property
    @pulumi.getter
    def top(self) -> Optional[pulumi.Input[str]]:
        """
        The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "top")

    @top.setter
    def top(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "top", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class SelectAudioTrackByAttributeArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[Union[str, 'TrackAttribute']],
                 filter: pulumi.Input[Union[str, 'AttributeFilter']],
                 odata_type: pulumi.Input[str],
                 channel_mapping: Optional[pulumi.Input[Union[str, 'ChannelMapping']]] = None,
                 filter_value: Optional[pulumi.Input[str]] = None):
        """
        Select audio tracks from the input by specifying an attribute and an attribute filter.
        :param pulumi.Input[Union[str, 'TrackAttribute']] attribute: The TrackAttribute to filter the tracks by.
        :param pulumi.Input[Union[str, 'AttributeFilter']] filter: The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectAudioTrackByAttribute'.
        :param pulumi.Input[Union[str, 'ChannelMapping']] channel_mapping: Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        :param pulumi.Input[str] filter_value: The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectAudioTrackByAttribute')
        if channel_mapping is not None:
            pulumi.set(__self__, "channel_mapping", channel_mapping)
        if filter_value is not None:
            pulumi.set(__self__, "filter_value", filter_value)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[Union[str, 'TrackAttribute']]:
        """
        The TrackAttribute to filter the tracks by.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[Union[str, 'TrackAttribute']]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[Union[str, 'AttributeFilter']]:
        """
        The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[Union[str, 'AttributeFilter']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectAudioTrackByAttribute'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="channelMapping")
    def channel_mapping(self) -> Optional[pulumi.Input[Union[str, 'ChannelMapping']]]:
        """
        Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        return pulumi.get(self, "channel_mapping")

    @channel_mapping.setter
    def channel_mapping(self, value: Optional[pulumi.Input[Union[str, 'ChannelMapping']]]):
        pulumi.set(self, "channel_mapping", value)

    @property
    @pulumi.getter(name="filterValue")
    def filter_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property.
        """
        return pulumi.get(self, "filter_value")

    @filter_value.setter
    def filter_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_value", value)


@pulumi.input_type
class SelectAudioTrackByIdArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 track_id: pulumi.Input[float],
                 channel_mapping: Optional[pulumi.Input[Union[str, 'ChannelMapping']]] = None):
        """
        Select audio tracks from the input by specifying a track identifier.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectAudioTrackById'.
        :param pulumi.Input[float] track_id: Track identifier to select
        :param pulumi.Input[Union[str, 'ChannelMapping']] channel_mapping: Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectAudioTrackById')
        pulumi.set(__self__, "track_id", track_id)
        if channel_mapping is not None:
            pulumi.set(__self__, "channel_mapping", channel_mapping)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectAudioTrackById'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="trackId")
    def track_id(self) -> pulumi.Input[float]:
        """
        Track identifier to select
        """
        return pulumi.get(self, "track_id")

    @track_id.setter
    def track_id(self, value: pulumi.Input[float]):
        pulumi.set(self, "track_id", value)

    @property
    @pulumi.getter(name="channelMapping")
    def channel_mapping(self) -> Optional[pulumi.Input[Union[str, 'ChannelMapping']]]:
        """
        Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
        """
        return pulumi.get(self, "channel_mapping")

    @channel_mapping.setter
    def channel_mapping(self, value: Optional[pulumi.Input[Union[str, 'ChannelMapping']]]):
        pulumi.set(self, "channel_mapping", value)


@pulumi.input_type
class SelectVideoTrackByAttributeArgs:
    def __init__(__self__, *,
                 attribute: pulumi.Input[Union[str, 'TrackAttribute']],
                 filter: pulumi.Input[Union[str, 'AttributeFilter']],
                 odata_type: pulumi.Input[str],
                 filter_value: Optional[pulumi.Input[str]] = None):
        """
        Select video tracks from the input by specifying an attribute and an attribute filter.
        :param pulumi.Input[Union[str, 'TrackAttribute']] attribute: The TrackAttribute to filter the tracks by.
        :param pulumi.Input[Union[str, 'AttributeFilter']] filter: The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectVideoTrackByAttribute'.
        :param pulumi.Input[str] filter_value: The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g: '1500000').  The TrackAttribute.Language is not supported for video tracks.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectVideoTrackByAttribute')
        if filter_value is not None:
            pulumi.set(__self__, "filter_value", filter_value)

    @property
    @pulumi.getter
    def attribute(self) -> pulumi.Input[Union[str, 'TrackAttribute']]:
        """
        The TrackAttribute to filter the tracks by.
        """
        return pulumi.get(self, "attribute")

    @attribute.setter
    def attribute(self, value: pulumi.Input[Union[str, 'TrackAttribute']]):
        pulumi.set(self, "attribute", value)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[Union[str, 'AttributeFilter']]:
        """
        The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[Union[str, 'AttributeFilter']]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectVideoTrackByAttribute'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="filterValue")
    def filter_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g: '1500000').  The TrackAttribute.Language is not supported for video tracks.
        """
        return pulumi.get(self, "filter_value")

    @filter_value.setter
    def filter_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_value", value)


@pulumi.input_type
class SelectVideoTrackByIdArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 track_id: pulumi.Input[float]):
        """
        Select video tracks from the input by specifying a track identifier.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.SelectVideoTrackById'.
        :param pulumi.Input[float] track_id: Track identifier to select
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.SelectVideoTrackById')
        pulumi.set(__self__, "track_id", track_id)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.SelectVideoTrackById'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="trackId")
    def track_id(self) -> pulumi.Input[float]:
        """
        Track identifier to select
        """
        return pulumi.get(self, "track_id")

    @track_id.setter
    def track_id(self, value: pulumi.Input[float]):
        pulumi.set(self, "track_id", value)


@pulumi.input_type
class StandardEncoderPresetArgs:
    def __init__(__self__, *,
                 codecs: pulumi.Input[Sequence[pulumi.Input[Union['AacAudioArgs', 'AudioArgs', 'CopyAudioArgs', 'CopyVideoArgs', 'DDAudioArgs', 'H264VideoArgs', 'H265VideoArgs', 'ImageArgs', 'JpgImageArgs', 'PngImageArgs', 'VideoArgs']]]],
                 formats: pulumi.Input[Sequence[pulumi.Input[Union['CmafFormatArgs', 'ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']]]],
                 odata_type: pulumi.Input[str],
                 filters: Optional[pulumi.Input['FiltersArgs']] = None):
        """
        Describes all the settings to be used when encoding the input video with the Standard Encoder.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AacAudioArgs', 'AudioArgs', 'CopyAudioArgs', 'CopyVideoArgs', 'DDAudioArgs', 'H264VideoArgs', 'H265VideoArgs', 'ImageArgs', 'JpgImageArgs', 'PngImageArgs', 'VideoArgs']]]] codecs: The list of codecs to be used when encoding the input video.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CmafFormatArgs', 'ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']]]] formats: The list of outputs to be produced by the encoder.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.StandardEncoderPreset'.
        :param pulumi.Input['FiltersArgs'] filters: One or more filtering operations that are applied to the input media before encoding.
        """
        pulumi.set(__self__, "codecs", codecs)
        pulumi.set(__self__, "formats", formats)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.StandardEncoderPreset')
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def codecs(self) -> pulumi.Input[Sequence[pulumi.Input[Union['AacAudioArgs', 'AudioArgs', 'CopyAudioArgs', 'CopyVideoArgs', 'DDAudioArgs', 'H264VideoArgs', 'H265VideoArgs', 'ImageArgs', 'JpgImageArgs', 'PngImageArgs', 'VideoArgs']]]]:
        """
        The list of codecs to be used when encoding the input video.
        """
        return pulumi.get(self, "codecs")

    @codecs.setter
    def codecs(self, value: pulumi.Input[Sequence[pulumi.Input[Union['AacAudioArgs', 'AudioArgs', 'CopyAudioArgs', 'CopyVideoArgs', 'DDAudioArgs', 'H264VideoArgs', 'H265VideoArgs', 'ImageArgs', 'JpgImageArgs', 'PngImageArgs', 'VideoArgs']]]]):
        pulumi.set(self, "codecs", value)

    @property
    @pulumi.getter
    def formats(self) -> pulumi.Input[Sequence[pulumi.Input[Union['CmafFormatArgs', 'ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']]]]:
        """
        The list of outputs to be produced by the encoder.
        """
        return pulumi.get(self, "formats")

    @formats.setter
    def formats(self, value: pulumi.Input[Sequence[pulumi.Input[Union['CmafFormatArgs', 'ImageFormatArgs', 'JpgFormatArgs', 'Mp4FormatArgs', 'MultiBitrateFormatArgs', 'PngFormatArgs', 'TransportStreamFormatArgs']]]]):
        pulumi.set(self, "formats", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.StandardEncoderPreset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['FiltersArgs']]:
        """
        One or more filtering operations that are applied to the input media before encoding.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['FiltersArgs']]):
        pulumi.set(self, "filters", value)


@pulumi.input_type
class TransformOutputArgs:
    def __init__(__self__, *,
                 preset: pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']],
                 on_error: Optional[pulumi.Input[Union[str, 'OnErrorType']]] = None,
                 relative_priority: Optional[pulumi.Input[Union[str, 'Priority']]] = None):
        """
        Describes the properties of a TransformOutput, which are the rules to be applied while generating the desired output.
        :param pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']] preset: Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
        :param pulumi.Input[Union[str, 'OnErrorType']] on_error: A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
        :param pulumi.Input[Union[str, 'Priority']] relative_priority: Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
        """
        pulumi.set(__self__, "preset", preset)
        if on_error is not None:
            pulumi.set(__self__, "on_error", on_error)
        if relative_priority is not None:
            pulumi.set(__self__, "relative_priority", relative_priority)

    @property
    @pulumi.getter
    def preset(self) -> pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']]:
        """
        Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
        """
        return pulumi.get(self, "preset")

    @preset.setter
    def preset(self, value: pulumi.Input[Union['AudioAnalyzerPresetArgs', 'BuiltInStandardEncoderPresetArgs', 'FaceDetectorPresetArgs', 'StandardEncoderPresetArgs', 'VideoAnalyzerPresetArgs']]):
        pulumi.set(self, "preset", value)

    @property
    @pulumi.getter(name="onError")
    def on_error(self) -> Optional[pulumi.Input[Union[str, 'OnErrorType']]]:
        """
        A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
        """
        return pulumi.get(self, "on_error")

    @on_error.setter
    def on_error(self, value: Optional[pulumi.Input[Union[str, 'OnErrorType']]]):
        pulumi.set(self, "on_error", value)

    @property
    @pulumi.getter(name="relativePriority")
    def relative_priority(self) -> Optional[pulumi.Input[Union[str, 'Priority']]]:
        """
        Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
        """
        return pulumi.get(self, "relative_priority")

    @relative_priority.setter
    def relative_priority(self, value: Optional[pulumi.Input[Union[str, 'Priority']]]):
        pulumi.set(self, "relative_priority", value)


@pulumi.input_type
class TransportStreamFormatArgs:
    def __init__(__self__, *,
                 filename_pattern: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 output_files: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]] = None):
        """
        Describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC 13818-1) output video file(s).
        :param pulumi.Input[str] filename_pattern: The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.TransportStreamFormat'.
        :param pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]] output_files: The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        pulumi.set(__self__, "filename_pattern", filename_pattern)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.TransportStreamFormat')
        if output_files is not None:
            pulumi.set(__self__, "output_files", output_files)

    @property
    @pulumi.getter(name="filenamePattern")
    def filename_pattern(self) -> pulumi.Input[str]:
        """
        The file naming pattern used for the creation of output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
        """
        return pulumi.get(self, "filename_pattern")

    @filename_pattern.setter
    def filename_pattern(self, value: pulumi.Input[str]):
        pulumi.set(self, "filename_pattern", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.TransportStreamFormat'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="outputFiles")
    def output_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]:
        """
        The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
        """
        return pulumi.get(self, "output_files")

    @output_files.setter
    def output_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OutputFileArgs']]]]):
        pulumi.set(self, "output_files", value)


@pulumi.input_type
class UtcClipTimeArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 time: pulumi.Input[str]):
        """
        Specifies the clip time as a Utc time position in the media file.  The Utc time can point to a different position depending on whether the media file starts from a timestamp of zero or not.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.UtcClipTime'.
        :param pulumi.Input[str] time: The time position on the timeline of the input media based on Utc time.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.UtcClipTime')
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.UtcClipTime'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def time(self) -> pulumi.Input[str]:
        """
        The time position on the timeline of the input media based on Utc time.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: pulumi.Input[str]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class VideoAnalyzerPresetArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 audio_language: Optional[pulumi.Input[str]] = None,
                 experimental_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 insights_to_extract: Optional[pulumi.Input[Union[str, 'InsightsType']]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]] = None):
        """
        A video analyzer preset that extracts insights (rich metadata) from both audio and video, and outputs a JSON format file.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoAnalyzerPreset'.
        :param pulumi.Input[str] audio_language: The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] experimental_options: Dictionary containing key value pairs for parameters not exposed in the preset itself
        :param pulumi.Input[Union[str, 'InsightsType']] insights_to_extract: Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly', and 'AllInsights'. The default is AllInsights. If you set this to AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only, then only video insights are generated. It is recommended that you not use AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your inputs to be audio only. Your Jobs in such conditions would error out.
        :param pulumi.Input[Union[str, 'AudioAnalysisMode']] mode: Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoAnalyzerPreset')
        if audio_language is not None:
            pulumi.set(__self__, "audio_language", audio_language)
        if experimental_options is not None:
            pulumi.set(__self__, "experimental_options", experimental_options)
        if insights_to_extract is not None:
            pulumi.set(__self__, "insights_to_extract", insights_to_extract)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoAnalyzerPreset'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="audioLanguage")
    def audio_language(self) -> Optional[pulumi.Input[str]]:
        """
        The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
        """
        return pulumi.get(self, "audio_language")

    @audio_language.setter
    def audio_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audio_language", value)

    @property
    @pulumi.getter(name="experimentalOptions")
    def experimental_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary containing key value pairs for parameters not exposed in the preset itself
        """
        return pulumi.get(self, "experimental_options")

    @experimental_options.setter
    def experimental_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "experimental_options", value)

    @property
    @pulumi.getter(name="insightsToExtract")
    def insights_to_extract(self) -> Optional[pulumi.Input[Union[str, 'InsightsType']]]:
        """
        Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly', and 'AllInsights'. The default is AllInsights. If you set this to AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only, then only video insights are generated. It is recommended that you not use AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your inputs to be audio only. Your Jobs in such conditions would error out.
        """
        return pulumi.get(self, "insights_to_extract")

    @insights_to_extract.setter
    def insights_to_extract(self, value: Optional[pulumi.Input[Union[str, 'InsightsType']]]):
        pulumi.set(self, "insights_to_extract", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]]:
        """
        Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'AudioAnalysisMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class VideoOverlayArgs:
    def __init__(__self__, *,
                 input_label: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 audio_gain_level: Optional[pulumi.Input[float]] = None,
                 crop_rectangle: Optional[pulumi.Input['RectangleArgs']] = None,
                 end: Optional[pulumi.Input[str]] = None,
                 fade_in_duration: Optional[pulumi.Input[str]] = None,
                 fade_out_duration: Optional[pulumi.Input[str]] = None,
                 opacity: Optional[pulumi.Input[float]] = None,
                 position: Optional[pulumi.Input['RectangleArgs']] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        Describes the properties of a video overlay.
        :param pulumi.Input[str] input_label: The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoOverlay'.
        :param pulumi.Input[float] audio_gain_level: The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        :param pulumi.Input['RectangleArgs'] crop_rectangle: An optional rectangular window used to crop the overlay image or video.
        :param pulumi.Input[str] end: The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        :param pulumi.Input[str] fade_in_duration: The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        :param pulumi.Input[str] fade_out_duration: The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        :param pulumi.Input[float] opacity: The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
        :param pulumi.Input['RectangleArgs'] position: The location in the input video where the overlay is applied.
        :param pulumi.Input[str] start: The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        pulumi.set(__self__, "input_label", input_label)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoOverlay')
        if audio_gain_level is not None:
            pulumi.set(__self__, "audio_gain_level", audio_gain_level)
        if crop_rectangle is not None:
            pulumi.set(__self__, "crop_rectangle", crop_rectangle)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if fade_in_duration is not None:
            pulumi.set(__self__, "fade_in_duration", fade_in_duration)
        if fade_out_duration is not None:
            pulumi.set(__self__, "fade_out_duration", fade_out_duration)
        if opacity is not None:
            pulumi.set(__self__, "opacity", opacity)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter(name="inputLabel")
    def input_label(self) -> pulumi.Input[str]:
        """
        The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
        """
        return pulumi.get(self, "input_label")

    @input_label.setter
    def input_label(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_label", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoOverlay'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="audioGainLevel")
    def audio_gain_level(self) -> Optional[pulumi.Input[float]]:
        """
        The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
        """
        return pulumi.get(self, "audio_gain_level")

    @audio_gain_level.setter
    def audio_gain_level(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "audio_gain_level", value)

    @property
    @pulumi.getter(name="cropRectangle")
    def crop_rectangle(self) -> Optional[pulumi.Input['RectangleArgs']]:
        """
        An optional rectangular window used to crop the overlay image or video.
        """
        return pulumi.get(self, "crop_rectangle")

    @crop_rectangle.setter
    def crop_rectangle(self, value: Optional[pulumi.Input['RectangleArgs']]):
        pulumi.set(self, "crop_rectangle", value)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter(name="fadeInDuration")
    def fade_in_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
        """
        return pulumi.get(self, "fade_in_duration")

    @fade_in_duration.setter
    def fade_in_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fade_in_duration", value)

    @property
    @pulumi.getter(name="fadeOutDuration")
    def fade_out_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
        """
        return pulumi.get(self, "fade_out_duration")

    @fade_out_duration.setter
    def fade_out_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fade_out_duration", value)

    @property
    @pulumi.getter
    def opacity(self) -> Optional[pulumi.Input[float]]:
        """
        The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
        """
        return pulumi.get(self, "opacity")

    @opacity.setter
    def opacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "opacity", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input['RectangleArgs']]:
        """
        The location in the input video where the overlay is applied.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input['RectangleArgs']]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class VideoTrackDescriptorArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        A TrackSelection to select video tracks.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoTrackDescriptor'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoTrackDescriptor')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoTrackDescriptor'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class VideoArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None,
                 sync_mode: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]] = None):
        """
        Describes the basic properties for encoding the input video.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.Video'.
        :param pulumi.Input[str] key_frame_interval: The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        :param pulumi.Input[str] label: An optional label for the codec. The label can be used to control muxing behavior.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        :param pulumi.Input[Union[str, 'VideoSyncMode']] sync_mode: The Video Sync Mode
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.Video')
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)
        if sync_mode is not None:
            pulumi.set(__self__, "sync_mode", sync_mode)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.Video'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label for the codec. The label can be used to control muxing behavior.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)

    @property
    @pulumi.getter(name="syncMode")
    def sync_mode(self) -> Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]:
        """
        The Video Sync Mode
        """
        return pulumi.get(self, "sync_mode")

    @sync_mode.setter
    def sync_mode(self, value: Optional[pulumi.Input[Union[str, 'VideoSyncMode']]]):
        pulumi.set(self, "sync_mode", value)


