# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetIncidentTaskResult',
    'AwaitableGetIncidentTaskResult',
    'get_incident_task',
    'get_incident_task_output',
]

@pulumi.output_type
class GetIncidentTaskResult:
    def __init__(__self__, created_by=None, created_time_utc=None, description=None, etag=None, id=None, last_modified_by=None, last_modified_time_utc=None, name=None, status=None, system_data=None, title=None, type=None):
        if created_by and not isinstance(created_by, dict):
            raise TypeError("Expected argument 'created_by' to be a dict")
        pulumi.set(__self__, "created_by", created_by)
        if created_time_utc and not isinstance(created_time_utc, str):
            raise TypeError("Expected argument 'created_time_utc' to be a str")
        pulumi.set(__self__, "created_time_utc", created_time_utc)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified_by and not isinstance(last_modified_by, dict):
            raise TypeError("Expected argument 'last_modified_by' to be a dict")
        pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_time_utc and not isinstance(last_modified_time_utc, str):
            raise TypeError("Expected argument 'last_modified_time_utc' to be a str")
        pulumi.set(__self__, "last_modified_time_utc", last_modified_time_utc)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional['outputs.ClientInfoResponse']:
        """
        Information on the client (user or application) that made some action
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdTimeUtc")
    def created_time_utc(self) -> str:
        """
        The time the task was created
        """
        return pulumi.get(self, "created_time_utc")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the task
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Etag of the azure resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional['outputs.ClientInfoResponse']:
        """
        Information on the client (user or application) that made some action
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedTimeUtc")
    def last_modified_time_utc(self) -> str:
        """
        The last time the task was updated
        """
        return pulumi.get(self, "last_modified_time_utc")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        The title of the task
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetIncidentTaskResult(GetIncidentTaskResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIncidentTaskResult(
            created_by=self.created_by,
            created_time_utc=self.created_time_utc,
            description=self.description,
            etag=self.etag,
            id=self.id,
            last_modified_by=self.last_modified_by,
            last_modified_time_utc=self.last_modified_time_utc,
            name=self.name,
            status=self.status,
            system_data=self.system_data,
            title=self.title,
            type=self.type)


def get_incident_task(incident_id: Optional[str] = None,
                      incident_task_id: Optional[str] = None,
                      resource_group_name: Optional[str] = None,
                      workspace_name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIncidentTaskResult:
    """
    Use this data source to access information about an existing resource.

    :param str incident_id: Incident ID
    :param str incident_task_id: Incident task ID
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str workspace_name: The name of the workspace.
    """
    __args__ = dict()
    __args__['incidentId'] = incident_id
    __args__['incidentTaskId'] = incident_task_id
    __args__['resourceGroupName'] = resource_group_name
    __args__['workspaceName'] = workspace_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:securityinsights/v20230201preview:getIncidentTask', __args__, opts=opts, typ=GetIncidentTaskResult).value

    return AwaitableGetIncidentTaskResult(
        created_by=__ret__.created_by,
        created_time_utc=__ret__.created_time_utc,
        description=__ret__.description,
        etag=__ret__.etag,
        id=__ret__.id,
        last_modified_by=__ret__.last_modified_by,
        last_modified_time_utc=__ret__.last_modified_time_utc,
        name=__ret__.name,
        status=__ret__.status,
        system_data=__ret__.system_data,
        title=__ret__.title,
        type=__ret__.type)


@_utilities.lift_output_func(get_incident_task)
def get_incident_task_output(incident_id: Optional[pulumi.Input[str]] = None,
                             incident_task_id: Optional[pulumi.Input[str]] = None,
                             resource_group_name: Optional[pulumi.Input[str]] = None,
                             workspace_name: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIncidentTaskResult]:
    """
    Use this data source to access information about an existing resource.

    :param str incident_id: Incident ID
    :param str incident_task_id: Incident task ID
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str workspace_name: The name of the workspace.
    """
    ...
