# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConnectionPropertiesResponsePrivateEndpoint',
    'ConnectionPropertiesResponsePrivateLinkServiceConnectionState',
    'DigitalTwinsIdentityResponse',
    'EventGridResponse',
    'EventHubResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointConnectionResponseProperties',
    'ServiceBusResponse',
]

@pulumi.output_type
class ConnectionPropertiesResponsePrivateEndpoint(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: The resource identifier.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource identifier.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ConnectionPropertiesResponsePrivateLinkServiceConnectionState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionPropertiesResponsePrivateLinkServiceConnectionState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionPropertiesResponsePrivateLinkServiceConnectionState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionPropertiesResponsePrivateLinkServiceConnectionState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 status: str,
                 actions_required: Optional[str] = None):
        """
        :param str description: The description for the current state of a private endpoint connection.
        :param str status: The status of a private endpoint connection.
        :param str actions_required: Actions required for a private endpoint connection.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description for the current state of a private endpoint connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of a private endpoint connection.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        Actions required for a private endpoint connection.
        """
        return pulumi.get(self, "actions_required")


@pulumi.output_type
class DigitalTwinsIdentityResponse(dict):
    """
    The managed identity for the DigitalTwinsInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DigitalTwinsIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DigitalTwinsIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DigitalTwinsIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        The managed identity for the DigitalTwinsInstance.
        :param str principal_id: The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        :param str tenant_id: The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        :param str type: The type of Managed Identity used by the DigitalTwinsInstance. Only SystemAssigned is supported.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of Managed Identity used by the DigitalTwinsInstance. Only SystemAssigned is supported.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EventGridResponse(dict):
    """
    Properties related to EventGrid.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey1":
            suggest = "access_key1"
        elif key == "createdTime":
            suggest = "created_time"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "topicEndpoint":
            suggest = "topic_endpoint"
        elif key == "accessKey2":
            suggest = "access_key2"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "deadLetterSecret":
            suggest = "dead_letter_secret"
        elif key == "deadLetterUri":
            suggest = "dead_letter_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventGridResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventGridResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventGridResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key1: str,
                 created_time: str,
                 endpoint_type: str,
                 provisioning_state: str,
                 topic_endpoint: str,
                 access_key2: Optional[str] = None,
                 authentication_type: Optional[str] = None,
                 dead_letter_secret: Optional[str] = None,
                 dead_letter_uri: Optional[str] = None):
        """
        Properties related to EventGrid.
        :param str access_key1: EventGrid secondary accesskey. Will be obfuscated during read.
        :param str created_time: Time when the Endpoint was added to DigitalTwinsInstance.
        :param str endpoint_type: The type of Digital Twins endpoint
               Expected value is 'EventGrid'.
        :param str provisioning_state: The provisioning state.
        :param str topic_endpoint: EventGrid Topic Endpoint
        :param str access_key2: EventGrid secondary accesskey. Will be obfuscated during read.
        :param str authentication_type: Specifies the authentication type being used for connecting to the endpoint.
        :param str dead_letter_secret: Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        :param str dead_letter_uri: Dead letter storage URL for identity-based authentication.
        """
        pulumi.set(__self__, "access_key1", access_key1)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "endpoint_type", 'EventGrid')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "topic_endpoint", topic_endpoint)
        if access_key2 is not None:
            pulumi.set(__self__, "access_key2", access_key2)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if dead_letter_secret is not None:
            pulumi.set(__self__, "dead_letter_secret", dead_letter_secret)
        if dead_letter_uri is not None:
            pulumi.set(__self__, "dead_letter_uri", dead_letter_uri)

    @property
    @pulumi.getter(name="accessKey1")
    def access_key1(self) -> str:
        """
        EventGrid secondary accesskey. Will be obfuscated during read.
        """
        return pulumi.get(self, "access_key1")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        Time when the Endpoint was added to DigitalTwinsInstance.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The type of Digital Twins endpoint
        Expected value is 'EventGrid'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="topicEndpoint")
    def topic_endpoint(self) -> str:
        """
        EventGrid Topic Endpoint
        """
        return pulumi.get(self, "topic_endpoint")

    @property
    @pulumi.getter(name="accessKey2")
    def access_key2(self) -> Optional[str]:
        """
        EventGrid secondary accesskey. Will be obfuscated during read.
        """
        return pulumi.get(self, "access_key2")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Specifies the authentication type being used for connecting to the endpoint.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="deadLetterSecret")
    def dead_letter_secret(self) -> Optional[str]:
        """
        Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "dead_letter_secret")

    @property
    @pulumi.getter(name="deadLetterUri")
    def dead_letter_uri(self) -> Optional[str]:
        """
        Dead letter storage URL for identity-based authentication.
        """
        return pulumi.get(self, "dead_letter_uri")


@pulumi.output_type
class EventHubResponse(dict):
    """
    Properties related to EventHub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTime":
            suggest = "created_time"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectionStringPrimaryKey":
            suggest = "connection_string_primary_key"
        elif key == "connectionStringSecondaryKey":
            suggest = "connection_string_secondary_key"
        elif key == "deadLetterSecret":
            suggest = "dead_letter_secret"
        elif key == "deadLetterUri":
            suggest = "dead_letter_uri"
        elif key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "entityPath":
            suggest = "entity_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_time: str,
                 endpoint_type: str,
                 provisioning_state: str,
                 authentication_type: Optional[str] = None,
                 connection_string_primary_key: Optional[str] = None,
                 connection_string_secondary_key: Optional[str] = None,
                 dead_letter_secret: Optional[str] = None,
                 dead_letter_uri: Optional[str] = None,
                 endpoint_uri: Optional[str] = None,
                 entity_path: Optional[str] = None):
        """
        Properties related to EventHub.
        :param str created_time: Time when the Endpoint was added to DigitalTwinsInstance.
        :param str endpoint_type: The type of Digital Twins endpoint
               Expected value is 'EventHub'.
        :param str provisioning_state: The provisioning state.
        :param str authentication_type: Specifies the authentication type being used for connecting to the endpoint.
        :param str connection_string_primary_key: PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        :param str connection_string_secondary_key: SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        :param str dead_letter_secret: Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        :param str dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :param str endpoint_uri: The URL of the EventHub namespace for identity-based authentication. It must include the protocol sb://
        :param str entity_path: The EventHub name in the EventHub namespace for identity-based authentication.
        """
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "endpoint_type", 'EventHub')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connection_string_primary_key is not None:
            pulumi.set(__self__, "connection_string_primary_key", connection_string_primary_key)
        if connection_string_secondary_key is not None:
            pulumi.set(__self__, "connection_string_secondary_key", connection_string_secondary_key)
        if dead_letter_secret is not None:
            pulumi.set(__self__, "dead_letter_secret", dead_letter_secret)
        if dead_letter_uri is not None:
            pulumi.set(__self__, "dead_letter_uri", dead_letter_uri)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if entity_path is not None:
            pulumi.set(__self__, "entity_path", entity_path)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        Time when the Endpoint was added to DigitalTwinsInstance.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The type of Digital Twins endpoint
        Expected value is 'EventHub'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Specifies the authentication type being used for connecting to the endpoint.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectionStringPrimaryKey")
    def connection_string_primary_key(self) -> Optional[str]:
        """
        PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "connection_string_primary_key")

    @property
    @pulumi.getter(name="connectionStringSecondaryKey")
    def connection_string_secondary_key(self) -> Optional[str]:
        """
        SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "connection_string_secondary_key")

    @property
    @pulumi.getter(name="deadLetterSecret")
    def dead_letter_secret(self) -> Optional[str]:
        """
        Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "dead_letter_secret")

    @property
    @pulumi.getter(name="deadLetterUri")
    def dead_letter_uri(self) -> Optional[str]:
        """
        Dead letter storage URL for identity-based authentication.
        """
        return pulumi.get(self, "dead_letter_uri")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[str]:
        """
        The URL of the EventHub namespace for identity-based authentication. It must include the protocol sb://
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> Optional[str]:
        """
        The EventHub name in the EventHub namespace for identity-based authentication.
        """
        return pulumi.get(self, "entity_path")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The private endpoint connection of a Digital Twin.
    """
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 properties: 'outputs.PrivateEndpointConnectionResponseProperties',
                 type: str):
        """
        The private endpoint connection of a Digital Twin.
        :param str id: The resource identifier.
        :param str name: The resource name.
        :param str type: The resource type.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.PrivateEndpointConnectionResponseProperties':
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateEndpointConnectionResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "groupIds":
            suggest = "group_ids"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 group_ids: Optional[Sequence[str]] = None,
                 private_endpoint: Optional['outputs.ConnectionPropertiesResponsePrivateEndpoint'] = None,
                 private_link_service_connection_state: Optional['outputs.ConnectionPropertiesResponsePrivateLinkServiceConnectionState'] = None):
        """
        :param str provisioning_state: The provisioning state.
        :param Sequence[str] group_ids: The list of group ids for the private endpoint connection.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[Sequence[str]]:
        """
        The list of group ids for the private endpoint connection.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.ConnectionPropertiesResponsePrivateEndpoint']:
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.ConnectionPropertiesResponsePrivateLinkServiceConnectionState']:
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class ServiceBusResponse(dict):
    """
    Properties related to ServiceBus.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTime":
            suggest = "created_time"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "deadLetterSecret":
            suggest = "dead_letter_secret"
        elif key == "deadLetterUri":
            suggest = "dead_letter_uri"
        elif key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "entityPath":
            suggest = "entity_path"
        elif key == "primaryConnectionString":
            suggest = "primary_connection_string"
        elif key == "secondaryConnectionString":
            suggest = "secondary_connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_time: str,
                 endpoint_type: str,
                 provisioning_state: str,
                 authentication_type: Optional[str] = None,
                 dead_letter_secret: Optional[str] = None,
                 dead_letter_uri: Optional[str] = None,
                 endpoint_uri: Optional[str] = None,
                 entity_path: Optional[str] = None,
                 primary_connection_string: Optional[str] = None,
                 secondary_connection_string: Optional[str] = None):
        """
        Properties related to ServiceBus.
        :param str created_time: Time when the Endpoint was added to DigitalTwinsInstance.
        :param str endpoint_type: The type of Digital Twins endpoint
               Expected value is 'ServiceBus'.
        :param str provisioning_state: The provisioning state.
        :param str authentication_type: Specifies the authentication type being used for connecting to the endpoint.
        :param str dead_letter_secret: Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        :param str dead_letter_uri: Dead letter storage URL for identity-based authentication.
        :param str endpoint_uri: The URL of the ServiceBus namespace for identity-based authentication. It must include the protocol sb://
        :param str entity_path: The ServiceBus Topic name for identity-based authentication
        :param str primary_connection_string: PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        :param str secondary_connection_string: SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        """
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "endpoint_type", 'ServiceBus')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if dead_letter_secret is not None:
            pulumi.set(__self__, "dead_letter_secret", dead_letter_secret)
        if dead_letter_uri is not None:
            pulumi.set(__self__, "dead_letter_uri", dead_letter_uri)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if entity_path is not None:
            pulumi.set(__self__, "entity_path", entity_path)
        if primary_connection_string is not None:
            pulumi.set(__self__, "primary_connection_string", primary_connection_string)
        if secondary_connection_string is not None:
            pulumi.set(__self__, "secondary_connection_string", secondary_connection_string)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        Time when the Endpoint was added to DigitalTwinsInstance.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The type of Digital Twins endpoint
        Expected value is 'ServiceBus'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Specifies the authentication type being used for connecting to the endpoint.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="deadLetterSecret")
    def dead_letter_secret(self) -> Optional[str]:
        """
        Dead letter storage secret for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "dead_letter_secret")

    @property
    @pulumi.getter(name="deadLetterUri")
    def dead_letter_uri(self) -> Optional[str]:
        """
        Dead letter storage URL for identity-based authentication.
        """
        return pulumi.get(self, "dead_letter_uri")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[str]:
        """
        The URL of the ServiceBus namespace for identity-based authentication. It must include the protocol sb://
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> Optional[str]:
        """
        The ServiceBus Topic name for identity-based authentication
        """
        return pulumi.get(self, "entity_path")

    @property
    @pulumi.getter(name="primaryConnectionString")
    def primary_connection_string(self) -> Optional[str]:
        """
        PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "primary_connection_string")

    @property
    @pulumi.getter(name="secondaryConnectionString")
    def secondary_connection_string(self) -> Optional[str]:
        """
        SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
        """
        return pulumi.get(self, "secondary_connection_string")


