# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CommonExportPropertiesResponse',
    'ConnectorCollectionErrorInfoResponse',
    'ConnectorCollectionInfoResponse',
    'CostAllocationProportionResponse',
    'CostAllocationRuleDetailsResponse',
    'CostAllocationRulePropertiesResponse',
    'ErrorDetailsResponse',
    'ExportDatasetConfigurationResponse',
    'ExportDatasetResponse',
    'ExportDefinitionResponse',
    'ExportDeliveryDestinationResponse',
    'ExportDeliveryInfoResponse',
    'ExportExecutionListResultResponse',
    'ExportExecutionResponse',
    'ExportRecurrencePeriodResponse',
    'ExportScheduleResponse',
    'ExportTimePeriodResponse',
    'FileDestinationResponse',
    'KpiPropertiesResponse',
    'NotificationPropertiesResponse',
    'PivotPropertiesResponse',
    'ReportAggregationResponse',
    'ReportComparisonExpressionResponse',
    'ReportConfigAggregationResponse',
    'ReportConfigComparisonExpressionResponse',
    'ReportConfigDatasetConfigurationResponse',
    'ReportConfigDatasetResponse',
    'ReportConfigFilterResponse',
    'ReportConfigGroupingResponse',
    'ReportConfigSortingResponse',
    'ReportConfigTimePeriodResponse',
    'ReportDatasetConfigurationResponse',
    'ReportDatasetResponse',
    'ReportDefinitionResponse',
    'ReportDeliveryDestinationResponse',
    'ReportDeliveryInfoResponse',
    'ReportFilterResponse',
    'ReportGroupingResponse',
    'ReportRecurrencePeriodResponse',
    'ReportScheduleResponse',
    'ReportTimePeriodResponse',
    'SchedulePropertiesResponse',
    'SettingsPropertiesResponseCache',
    'SourceCostAllocationResourceResponse',
    'SystemDataResponse',
    'TargetCostAllocationResourceResponse',
]

@pulumi.output_type
class CommonExportPropertiesResponse(dict):
    """
    The common properties of the export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryInfo":
            suggest = "delivery_info"
        elif key == "nextRunTimeEstimate":
            suggest = "next_run_time_estimate"
        elif key == "runHistory":
            suggest = "run_history"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommonExportPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommonExportPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommonExportPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 definition: 'outputs.ExportDefinitionResponse',
                 delivery_info: 'outputs.ExportDeliveryInfoResponse',
                 next_run_time_estimate: str,
                 format: Optional[str] = None,
                 run_history: Optional['outputs.ExportExecutionListResultResponse'] = None):
        """
        The common properties of the export.
        :param 'ExportDefinitionResponse' definition: Has the definition for the export.
        :param 'ExportDeliveryInfoResponse' delivery_info: Has delivery information for the export.
        :param str next_run_time_estimate: If the export has an active schedule, provides an estimate of the next execution time.
        :param str format: The format of the export being delivered. Currently only 'Csv' is supported.
        :param 'ExportExecutionListResultResponse' run_history: If requested, has the most recent execution history for the export.
        """
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "delivery_info", delivery_info)
        pulumi.set(__self__, "next_run_time_estimate", next_run_time_estimate)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if run_history is not None:
            pulumi.set(__self__, "run_history", run_history)

    @property
    @pulumi.getter
    def definition(self) -> 'outputs.ExportDefinitionResponse':
        """
        Has the definition for the export.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter(name="deliveryInfo")
    def delivery_info(self) -> 'outputs.ExportDeliveryInfoResponse':
        """
        Has delivery information for the export.
        """
        return pulumi.get(self, "delivery_info")

    @property
    @pulumi.getter(name="nextRunTimeEstimate")
    def next_run_time_estimate(self) -> str:
        """
        If the export has an active schedule, provides an estimate of the next execution time.
        """
        return pulumi.get(self, "next_run_time_estimate")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        The format of the export being delivered. Currently only 'Csv' is supported.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="runHistory")
    def run_history(self) -> Optional['outputs.ExportExecutionListResultResponse']:
        """
        If requested, has the most recent execution history for the export.
        """
        return pulumi.get(self, "run_history")


@pulumi.output_type
class ConnectorCollectionErrorInfoResponse(dict):
    """
    Details of any error encountered on last collection attempt
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorInnerMessage":
            suggest = "error_inner_message"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "errorStartTime":
            suggest = "error_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorCollectionErrorInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorCollectionErrorInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorCollectionErrorInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: str,
                 error_inner_message: str,
                 error_message: str,
                 error_start_time: str):
        """
        Details of any error encountered on last collection attempt
        :param str error_code: Short error code
        :param str error_inner_message: External Provider error message
        :param str error_message: Detailed error message
        :param str error_start_time: Time the error started occurring (Last time error occurred in lastChecked)
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "error_inner_message", error_inner_message)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "error_start_time", error_start_time)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        Short error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorInnerMessage")
    def error_inner_message(self) -> str:
        """
        External Provider error message
        """
        return pulumi.get(self, "error_inner_message")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        Detailed error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="errorStartTime")
    def error_start_time(self) -> str:
        """
        Time the error started occurring (Last time error occurred in lastChecked)
        """
        return pulumi.get(self, "error_start_time")


@pulumi.output_type
class ConnectorCollectionInfoResponse(dict):
    """
    Collection and ingestion information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastChecked":
            suggest = "last_checked"
        elif key == "lastUpdated":
            suggest = "last_updated"
        elif key == "sourceLastUpdated":
            suggest = "source_last_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectorCollectionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectorCollectionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectorCollectionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_checked: str,
                 last_updated: str,
                 source_last_updated: str,
                 error: Optional['outputs.ConnectorCollectionErrorInfoResponse'] = None):
        """
        Collection and ingestion information
        :param str last_checked: Last time the data acquisition process initiated connecting to the external provider
        :param str last_updated: Last time the external data was updated into Azure
        :param str source_last_updated: Source timestamp of external data currently available in Azure (eg AWS last processed CUR file timestamp)
        :param 'ConnectorCollectionErrorInfoResponse' error: Error information of last collection
        """
        pulumi.set(__self__, "last_checked", last_checked)
        pulumi.set(__self__, "last_updated", last_updated)
        pulumi.set(__self__, "source_last_updated", source_last_updated)
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter(name="lastChecked")
    def last_checked(self) -> str:
        """
        Last time the data acquisition process initiated connecting to the external provider
        """
        return pulumi.get(self, "last_checked")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> str:
        """
        Last time the external data was updated into Azure
        """
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter(name="sourceLastUpdated")
    def source_last_updated(self) -> str:
        """
        Source timestamp of external data currently available in Azure (eg AWS last processed CUR file timestamp)
        """
        return pulumi.get(self, "source_last_updated")

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.ConnectorCollectionErrorInfoResponse']:
        """
        Error information of last collection
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class CostAllocationProportionResponse(dict):
    """
    Target resources and allocation
    """
    def __init__(__self__, *,
                 name: str,
                 percentage: float):
        """
        Target resources and allocation
        :param str name: Target resource for cost allocation
        :param float percentage: Percentage of source cost to allocate to this resource. This value can be specified to two decimal places and the total percentage of all resources in this rule must sum to 100.00.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Target resource for cost allocation
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def percentage(self) -> float:
        """
        Percentage of source cost to allocate to this resource. This value can be specified to two decimal places and the total percentage of all resources in this rule must sum to 100.00.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class CostAllocationRuleDetailsResponse(dict):
    """
    Resource details of the cost allocation rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceResources":
            suggest = "source_resources"
        elif key == "targetResources":
            suggest = "target_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CostAllocationRuleDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CostAllocationRuleDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CostAllocationRuleDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_resources: Optional[Sequence['outputs.SourceCostAllocationResourceResponse']] = None,
                 target_resources: Optional[Sequence['outputs.TargetCostAllocationResourceResponse']] = None):
        """
        Resource details of the cost allocation rule
        :param Sequence['SourceCostAllocationResourceResponse'] source_resources: Source resources for cost allocation. At this time, this list can contain no more than one element.
        :param Sequence['TargetCostAllocationResourceResponse'] target_resources: Target resources for cost allocation. At this time, this list can contain no more than one element.
        """
        if source_resources is not None:
            pulumi.set(__self__, "source_resources", source_resources)
        if target_resources is not None:
            pulumi.set(__self__, "target_resources", target_resources)

    @property
    @pulumi.getter(name="sourceResources")
    def source_resources(self) -> Optional[Sequence['outputs.SourceCostAllocationResourceResponse']]:
        """
        Source resources for cost allocation. At this time, this list can contain no more than one element.
        """
        return pulumi.get(self, "source_resources")

    @property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> Optional[Sequence['outputs.TargetCostAllocationResourceResponse']]:
        """
        Target resources for cost allocation. At this time, this list can contain no more than one element.
        """
        return pulumi.get(self, "target_resources")


@pulumi.output_type
class CostAllocationRulePropertiesResponse(dict):
    """
    The properties of a cost allocation rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdDate":
            suggest = "created_date"
        elif key == "updatedDate":
            suggest = "updated_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CostAllocationRulePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CostAllocationRulePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CostAllocationRulePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_date: str,
                 details: 'outputs.CostAllocationRuleDetailsResponse',
                 status: str,
                 updated_date: str,
                 description: Optional[str] = None):
        """
        The properties of a cost allocation rule
        :param str created_date: Time at which the rule was created. Rules that change cost for the same resource are applied in order of creation.
        :param 'CostAllocationRuleDetailsResponse' details: Resource information for the cost allocation rule
        :param str status: Status of the rule
        :param str updated_date: Time at which the rule was last updated.
        :param str description: Description of a cost allocation rule.
        """
        pulumi.set(__self__, "created_date", created_date)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_date", updated_date)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> str:
        """
        Time at which the rule was created. Rules that change cost for the same resource are applied in order of creation.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def details(self) -> 'outputs.CostAllocationRuleDetailsResponse':
        """
        Resource information for the cost allocation rule
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the rule
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedDate")
    def updated_date(self) -> str:
        """
        Time at which the rule was last updated.
        """
        return pulumi.get(self, "updated_date")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of a cost allocation rule.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ErrorDetailsResponse(dict):
    """
    The details of the error.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str):
        """
        The details of the error.
        :param str code: Error code.
        :param str message: Error message indicating why the operation failed.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Error message indicating why the operation failed.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ExportDatasetConfigurationResponse(dict):
    """
    The export dataset configuration. Allows columns to be selected for the export. If not provided then the export will include all available columns.
    """
    def __init__(__self__, *,
                 columns: Optional[Sequence[str]] = None):
        """
        The export dataset configuration. Allows columns to be selected for the export. If not provided then the export will include all available columns.
        :param Sequence[str] columns: Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence[str]]:
        """
        Array of column names to be included in the export. If not provided then the export will include all available columns. The available columns can vary by customer channel (see examples).
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class ExportDatasetResponse(dict):
    """
    The definition for data in the export.
    """
    def __init__(__self__, *,
                 configuration: Optional['outputs.ExportDatasetConfigurationResponse'] = None,
                 granularity: Optional[str] = None):
        """
        The definition for data in the export.
        :param 'ExportDatasetConfigurationResponse' configuration: The export dataset configuration.
        :param str granularity: The granularity of rows in the export. Currently only 'Daily' is supported.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.ExportDatasetConfigurationResponse']:
        """
        The export dataset configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def granularity(self) -> Optional[str]:
        """
        The granularity of rows in the export. Currently only 'Daily' is supported.
        """
        return pulumi.get(self, "granularity")


@pulumi.output_type
class ExportDefinitionResponse(dict):
    """
    The definition of an export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSet":
            suggest = "data_set"
        elif key == "timePeriod":
            suggest = "time_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timeframe: str,
                 type: str,
                 data_set: Optional['outputs.ExportDatasetResponse'] = None,
                 time_period: Optional['outputs.ExportTimePeriodResponse'] = None):
        """
        The definition of an export.
        :param str timeframe: The time frame for pulling data for the export. If custom, then a specific time period must be provided.
        :param str type: The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
        :param 'ExportDatasetResponse' data_set: The definition for data in the export.
        :param 'ExportTimePeriodResponse' time_period: Has time period for pulling data for the export.
        """
        pulumi.set(__self__, "timeframe", timeframe)
        pulumi.set(__self__, "type", type)
        if data_set is not None:
            pulumi.set(__self__, "data_set", data_set)
        if time_period is not None:
            pulumi.set(__self__, "time_period", time_period)

    @property
    @pulumi.getter
    def timeframe(self) -> str:
        """
        The time frame for pulling data for the export. If custom, then a specific time period must be provided.
        """
        return pulumi.get(self, "timeframe")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the export. Note that 'Usage' is equivalent to 'ActualCost' and is applicable to exports that do not yet provide data for charges or amortization for service reservations.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dataSet")
    def data_set(self) -> Optional['outputs.ExportDatasetResponse']:
        """
        The definition for data in the export.
        """
        return pulumi.get(self, "data_set")

    @property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> Optional['outputs.ExportTimePeriodResponse']:
        """
        Has time period for pulling data for the export.
        """
        return pulumi.get(self, "time_period")


@pulumi.output_type
class ExportDeliveryDestinationResponse(dict):
    """
    The destination information for the delivery of the export. To allow access to a storage account, you must register the account's subscription with the Microsoft.CostManagementExports resource provider. This is required once per subscription. When creating an export in the Azure portal, it is done automatically, however API users need to register the subscription. For more information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services .
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "rootFolderPath":
            suggest = "root_folder_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportDeliveryDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportDeliveryDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportDeliveryDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container: str,
                 resource_id: str,
                 root_folder_path: Optional[str] = None):
        """
        The destination information for the delivery of the export. To allow access to a storage account, you must register the account's subscription with the Microsoft.CostManagementExports resource provider. This is required once per subscription. When creating an export in the Azure portal, it is done automatically, however API users need to register the subscription. For more information see https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-manager-supported-services .
        :param str container: The name of the container where exports will be uploaded.
        :param str resource_id: The resource id of the storage account where exports will be delivered.
        :param str root_folder_path: The name of the directory where exports will be uploaded.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "resource_id", resource_id)
        if root_folder_path is not None:
            pulumi.set(__self__, "root_folder_path", root_folder_path)

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The name of the container where exports will be uploaded.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The resource id of the storage account where exports will be delivered.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="rootFolderPath")
    def root_folder_path(self) -> Optional[str]:
        """
        The name of the directory where exports will be uploaded.
        """
        return pulumi.get(self, "root_folder_path")


@pulumi.output_type
class ExportDeliveryInfoResponse(dict):
    """
    The delivery information associated with a export.
    """
    def __init__(__self__, *,
                 destination: 'outputs.ExportDeliveryDestinationResponse'):
        """
        The delivery information associated with a export.
        :param 'ExportDeliveryDestinationResponse' destination: Has destination for the export being delivered.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.ExportDeliveryDestinationResponse':
        """
        Has destination for the export being delivered.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class ExportExecutionListResultResponse(dict):
    """
    Result of listing the execution history of an export.
    """
    def __init__(__self__, *,
                 value: Sequence['outputs.ExportExecutionResponse']):
        """
        Result of listing the execution history of an export.
        :param Sequence['ExportExecutionResponse'] value: A list of export executions.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Sequence['outputs.ExportExecutionResponse']:
        """
        A list of export executions.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ExportExecutionResponse(dict):
    """
    An export execution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eTag":
            suggest = "e_tag"
        elif key == "executionType":
            suggest = "execution_type"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "processingEndTime":
            suggest = "processing_end_time"
        elif key == "processingStartTime":
            suggest = "processing_start_time"
        elif key == "runSettings":
            suggest = "run_settings"
        elif key == "submittedBy":
            suggest = "submitted_by"
        elif key == "submittedTime":
            suggest = "submitted_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportExecutionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportExecutionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportExecutionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str,
                 e_tag: Optional[str] = None,
                 error: Optional['outputs.ErrorDetailsResponse'] = None,
                 execution_type: Optional[str] = None,
                 file_name: Optional[str] = None,
                 processing_end_time: Optional[str] = None,
                 processing_start_time: Optional[str] = None,
                 run_settings: Optional['outputs.CommonExportPropertiesResponse'] = None,
                 status: Optional[str] = None,
                 submitted_by: Optional[str] = None,
                 submitted_time: Optional[str] = None):
        """
        An export execution.
        :param str id: Resource Id.
        :param str name: Resource name.
        :param str type: Resource type.
        :param str e_tag: eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
        :param 'ErrorDetailsResponse' error: The details of any error.
        :param str execution_type: The type of the export execution.
        :param str file_name: The name of the exported file.
        :param str processing_end_time: The time when the export execution finished.
        :param str processing_start_time: The time when export was picked up to be executed.
        :param 'CommonExportPropertiesResponse' run_settings: The export settings that were in effect for this execution.
        :param str status: The last known status of the export execution.
        :param str submitted_by: The identifier for the entity that executed the export. For OnDemand executions it is the user email. For scheduled executions it is 'System'.
        :param str submitted_time: The time when export was queued to be executed.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if execution_type is not None:
            pulumi.set(__self__, "execution_type", execution_type)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if processing_end_time is not None:
            pulumi.set(__self__, "processing_end_time", processing_end_time)
        if processing_start_time is not None:
            pulumi.set(__self__, "processing_start_time", processing_start_time)
        if run_settings is not None:
            pulumi.set(__self__, "run_settings", run_settings)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if submitted_by is not None:
            pulumi.set(__self__, "submitted_by", submitted_by)
        if submitted_time is not None:
            pulumi.set(__self__, "submitted_time", submitted_time)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[str]:
        """
        eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.ErrorDetailsResponse']:
        """
        The details of any error.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="executionType")
    def execution_type(self) -> Optional[str]:
        """
        The type of the export execution.
        """
        return pulumi.get(self, "execution_type")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[str]:
        """
        The name of the exported file.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="processingEndTime")
    def processing_end_time(self) -> Optional[str]:
        """
        The time when the export execution finished.
        """
        return pulumi.get(self, "processing_end_time")

    @property
    @pulumi.getter(name="processingStartTime")
    def processing_start_time(self) -> Optional[str]:
        """
        The time when export was picked up to be executed.
        """
        return pulumi.get(self, "processing_start_time")

    @property
    @pulumi.getter(name="runSettings")
    def run_settings(self) -> Optional['outputs.CommonExportPropertiesResponse']:
        """
        The export settings that were in effect for this execution.
        """
        return pulumi.get(self, "run_settings")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The last known status of the export execution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="submittedBy")
    def submitted_by(self) -> Optional[str]:
        """
        The identifier for the entity that executed the export. For OnDemand executions it is the user email. For scheduled executions it is 'System'.
        """
        return pulumi.get(self, "submitted_by")

    @property
    @pulumi.getter(name="submittedTime")
    def submitted_time(self) -> Optional[str]:
        """
        The time when export was queued to be executed.
        """
        return pulumi.get(self, "submitted_time")


@pulumi.output_type
class ExportRecurrencePeriodResponse(dict):
    """
    The start and end date for recurrence schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportRecurrencePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportRecurrencePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportRecurrencePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: Optional[str] = None):
        """
        The start and end date for recurrence schedule.
        :param str from_: The start date of recurrence.
        :param str to: The end date of recurrence.
        """
        pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date of recurrence.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> Optional[str]:
        """
        The end date of recurrence.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class ExportScheduleResponse(dict):
    """
    The schedule associated with the export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recurrencePeriod":
            suggest = "recurrence_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recurrence: Optional[str] = None,
                 recurrence_period: Optional['outputs.ExportRecurrencePeriodResponse'] = None,
                 status: Optional[str] = None):
        """
        The schedule associated with the export.
        :param str recurrence: The schedule recurrence.
        :param 'ExportRecurrencePeriodResponse' recurrence_period: Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        :param str status: The status of the export's schedule. If 'Inactive', the export's schedule is paused.
        """
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if recurrence_period is not None:
            pulumi.set(__self__, "recurrence_period", recurrence_period)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[str]:
        """
        The schedule recurrence.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter(name="recurrencePeriod")
    def recurrence_period(self) -> Optional['outputs.ExportRecurrencePeriodResponse']:
        """
        Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        """
        return pulumi.get(self, "recurrence_period")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the export's schedule. If 'Inactive', the export's schedule is paused.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ExportTimePeriodResponse(dict):
    """
    The date range for data in the export. This should only be specified with timeFrame set to 'Custom'. The maximum date range is 3 months.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportTimePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportTimePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportTimePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: str):
        """
        The date range for data in the export. This should only be specified with timeFrame set to 'Custom'. The maximum date range is 3 months.
        :param str from_: The start date for export data.
        :param str to: The end date for export data.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date for export data.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> str:
        """
        The end date for export data.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class FileDestinationResponse(dict):
    """
    Destination of the view data. Currently only csv format is supported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileFormats":
            suggest = "file_formats"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_formats: Optional[Sequence[str]] = None):
        """
        Destination of the view data. Currently only csv format is supported.
        :param Sequence[str] file_formats: Destination of the view data. Currently only csv format is supported.
        """
        if file_formats is not None:
            pulumi.set(__self__, "file_formats", file_formats)

    @property
    @pulumi.getter(name="fileFormats")
    def file_formats(self) -> Optional[Sequence[str]]:
        """
        Destination of the view data. Currently only csv format is supported.
        """
        return pulumi.get(self, "file_formats")


@pulumi.output_type
class KpiPropertiesResponse(dict):
    """
    Each KPI must contain a 'type' and 'enabled' key.
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Each KPI must contain a 'type' and 'enabled' key.
        :param bool enabled: show the KPI in the UI?
        :param str id: ID of resource related to metric (budget).
        :param str type: KPI type (Forecast, Budget).
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        show the KPI in the UI?
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of resource related to metric (budget).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        KPI type (Forecast, Budget).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NotificationPropertiesResponse(dict):
    """
    The properties of the scheduled action notification.
    """
    def __init__(__self__, *,
                 subject: str,
                 to: Sequence[str],
                 message: Optional[str] = None):
        """
        The properties of the scheduled action notification.
        :param str subject: Subject of the email. Length is limited to 70 characters.
        :param Sequence[str] to: Array of email addresses.
        :param str message: Optional message to be added in the email. Length is limited to 250 characters.
        """
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "to", to)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        Subject of the email. Length is limited to 70 characters.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def to(self) -> Sequence[str]:
        """
        Array of email addresses.
        """
        return pulumi.get(self, "to")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Optional message to be added in the email. Length is limited to 250 characters.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class PivotPropertiesResponse(dict):
    """
    Each pivot must contain a 'type' and 'name'.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Each pivot must contain a 'type' and 'name'.
        :param str name: Data field to show in view.
        :param str type: Data type to show in view.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Data field to show in view.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Data type to show in view.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReportAggregationResponse(dict):
    """
    The aggregation expression to be used in the report.
    """
    def __init__(__self__, *,
                 function: str,
                 name: str):
        """
        The aggregation expression to be used in the report.
        :param str function: The name of the aggregation function to use.
        :param str name: The name of the column to aggregate.
        """
        pulumi.set(__self__, "function", function)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def function(self) -> str:
        """
        The name of the aggregation function to use.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to aggregate.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ReportComparisonExpressionResponse(dict):
    """
    The comparison expression to be used in the report.
    """
    def __init__(__self__, *,
                 name: str,
                 operator: str,
                 values: Sequence[str]):
        """
        The comparison expression to be used in the report.
        :param str name: The name of the column to use in comparison.
        :param str operator: The operator to use for comparison.
        :param Sequence[str] values: Array of values to use for comparison
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to use in comparison.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use for comparison.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Array of values to use for comparison
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ReportConfigAggregationResponse(dict):
    """
    The aggregation expression to be used in the report.
    """
    def __init__(__self__, *,
                 function: str,
                 name: str):
        """
        The aggregation expression to be used in the report.
        :param str function: The name of the aggregation function to use.
        :param str name: The name of the column to aggregate.
        """
        pulumi.set(__self__, "function", function)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def function(self) -> str:
        """
        The name of the aggregation function to use.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to aggregate.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ReportConfigComparisonExpressionResponse(dict):
    """
    The comparison expression to be used in the report.
    """
    def __init__(__self__, *,
                 name: str,
                 operator: str,
                 values: Sequence[str]):
        """
        The comparison expression to be used in the report.
        :param str name: The name of the column to use in comparison.
        :param str operator: The operator to use for comparison.
        :param Sequence[str] values: Array of values to use for comparison
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to use in comparison.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator to use for comparison.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Array of values to use for comparison
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ReportConfigDatasetConfigurationResponse(dict):
    """
    The configuration of dataset in the report.
    """
    def __init__(__self__, *,
                 columns: Optional[Sequence[str]] = None):
        """
        The configuration of dataset in the report.
        :param Sequence[str] columns: Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence[str]]:
        """
        Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class ReportConfigDatasetResponse(dict):
    """
    The definition of data present in the report.
    """
    def __init__(__self__, *,
                 aggregation: Optional[Mapping[str, 'outputs.ReportConfigAggregationResponse']] = None,
                 configuration: Optional['outputs.ReportConfigDatasetConfigurationResponse'] = None,
                 filter: Optional['outputs.ReportConfigFilterResponse'] = None,
                 granularity: Optional[str] = None,
                 grouping: Optional[Sequence['outputs.ReportConfigGroupingResponse']] = None,
                 sorting: Optional[Sequence['outputs.ReportConfigSortingResponse']] = None):
        """
        The definition of data present in the report.
        :param Mapping[str, 'ReportConfigAggregationResponse'] aggregation: Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
        :param 'ReportConfigDatasetConfigurationResponse' configuration: Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
        :param 'ReportConfigFilterResponse' filter: Has filter expression to use in the report.
        :param str granularity: The granularity of rows in the report.
        :param Sequence['ReportConfigGroupingResponse'] grouping: Array of group by expression to use in the report. Report can have up to 2 group by clauses.
        :param Sequence['ReportConfigSortingResponse'] sorting: Array of order by expression to use in the report.
        """
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if grouping is not None:
            pulumi.set(__self__, "grouping", grouping)
        if sorting is not None:
            pulumi.set(__self__, "sorting", sorting)

    @property
    @pulumi.getter
    def aggregation(self) -> Optional[Mapping[str, 'outputs.ReportConfigAggregationResponse']]:
        """
        Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.ReportConfigDatasetConfigurationResponse']:
        """
        Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.ReportConfigFilterResponse']:
        """
        Has filter expression to use in the report.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def granularity(self) -> Optional[str]:
        """
        The granularity of rows in the report.
        """
        return pulumi.get(self, "granularity")

    @property
    @pulumi.getter
    def grouping(self) -> Optional[Sequence['outputs.ReportConfigGroupingResponse']]:
        """
        Array of group by expression to use in the report. Report can have up to 2 group by clauses.
        """
        return pulumi.get(self, "grouping")

    @property
    @pulumi.getter
    def sorting(self) -> Optional[Sequence['outputs.ReportConfigSortingResponse']]:
        """
        Array of order by expression to use in the report.
        """
        return pulumi.get(self, "sorting")


@pulumi.output_type
class ReportConfigFilterResponse(dict):
    """
    The filter expression to be used in the report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "and":
            suggest = "and_"
        elif key == "or":
            suggest = "or_"
        elif key == "tagKey":
            suggest = "tag_key"
        elif key == "tagValue":
            suggest = "tag_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportConfigFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportConfigFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportConfigFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_: Optional[Sequence['outputs.ReportConfigFilterResponse']] = None,
                 dimensions: Optional['outputs.ReportConfigComparisonExpressionResponse'] = None,
                 or_: Optional[Sequence['outputs.ReportConfigFilterResponse']] = None,
                 tag_key: Optional['outputs.ReportConfigComparisonExpressionResponse'] = None,
                 tag_value: Optional['outputs.ReportConfigComparisonExpressionResponse'] = None,
                 tags: Optional['outputs.ReportConfigComparisonExpressionResponse'] = None):
        """
        The filter expression to be used in the report.
        :param Sequence['ReportConfigFilterResponse'] and_: The logical "AND" expression. Must have at least 2 items.
        :param 'ReportConfigComparisonExpressionResponse' dimensions: Has comparison expression for a dimension
        :param Sequence['ReportConfigFilterResponse'] or_: The logical "OR" expression. Must have at least 2 items.
        :param 'ReportConfigComparisonExpressionResponse' tag_key: Has comparison expression for a tag key
        :param 'ReportConfigComparisonExpressionResponse' tag_value: Has comparison expression for a tag value
        :param 'ReportConfigComparisonExpressionResponse' tags: Has comparison expression for a tag
        """
        if and_ is not None:
            pulumi.set(__self__, "and_", and_)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if or_ is not None:
            pulumi.set(__self__, "or_", or_)
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)
        if tag_value is not None:
            pulumi.set(__self__, "tag_value", tag_value)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="and")
    def and_(self) -> Optional[Sequence['outputs.ReportConfigFilterResponse']]:
        """
        The logical "AND" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "and_")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional['outputs.ReportConfigComparisonExpressionResponse']:
        """
        Has comparison expression for a dimension
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="or")
    def or_(self) -> Optional[Sequence['outputs.ReportConfigFilterResponse']]:
        """
        The logical "OR" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "or_")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional['outputs.ReportConfigComparisonExpressionResponse']:
        """
        Has comparison expression for a tag key
        """
        return pulumi.get(self, "tag_key")

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional['outputs.ReportConfigComparisonExpressionResponse']:
        """
        Has comparison expression for a tag value
        """
        return pulumi.get(self, "tag_value")

    @property
    @pulumi.getter
    def tags(self) -> Optional['outputs.ReportConfigComparisonExpressionResponse']:
        """
        Has comparison expression for a tag
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ReportConfigGroupingResponse(dict):
    """
    The group by expression to be used in the report.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        The group by expression to be used in the report.
        :param str name: The name of the column to group. This version supports subscription lowest possible grain.
        :param str type: Has type of the column to group.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to group. This version supports subscription lowest possible grain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Has type of the column to group.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReportConfigSortingResponse(dict):
    """
    The order by expression to be used in the report.
    """
    def __init__(__self__, *,
                 name: str,
                 direction: Optional[str] = None):
        """
        The order by expression to be used in the report.
        :param str name: The name of the column to sort.
        :param str direction: Direction of sort.
        """
        pulumi.set(__self__, "name", name)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to sort.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        Direction of sort.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class ReportConfigTimePeriodResponse(dict):
    """
    The start and end date for pulling data for the report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportConfigTimePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportConfigTimePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportConfigTimePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: str):
        """
        The start and end date for pulling data for the report.
        :param str from_: The start date to pull data from.
        :param str to: The end date to pull data to.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date to pull data from.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> str:
        """
        The end date to pull data to.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class ReportDatasetConfigurationResponse(dict):
    """
    The configuration of dataset in the report.
    """
    def __init__(__self__, *,
                 columns: Optional[Sequence[str]] = None):
        """
        The configuration of dataset in the report.
        :param Sequence[str] columns: Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence[str]]:
        """
        Array of column names to be included in the report. Any valid report column name is allowed. If not provided, then report includes all columns.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class ReportDatasetResponse(dict):
    """
    The definition of data present in the report.
    """
    def __init__(__self__, *,
                 aggregation: Optional[Mapping[str, 'outputs.ReportAggregationResponse']] = None,
                 configuration: Optional['outputs.ReportDatasetConfigurationResponse'] = None,
                 filter: Optional['outputs.ReportFilterResponse'] = None,
                 granularity: Optional[str] = None,
                 grouping: Optional[Sequence['outputs.ReportGroupingResponse']] = None):
        """
        The definition of data present in the report.
        :param Mapping[str, 'ReportAggregationResponse'] aggregation: Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
        :param 'ReportDatasetConfigurationResponse' configuration: Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
        :param 'ReportFilterResponse' filter: Has filter expression to use in the report.
        :param str granularity: The granularity of rows in the report.
        :param Sequence['ReportGroupingResponse'] grouping: Array of group by expression to use in the report. Report can have up to 2 group by clauses.
        """
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if grouping is not None:
            pulumi.set(__self__, "grouping", grouping)

    @property
    @pulumi.getter
    def aggregation(self) -> Optional[Mapping[str, 'outputs.ReportAggregationResponse']]:
        """
        Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
        """
        return pulumi.get(self, "aggregation")

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.ReportDatasetConfigurationResponse']:
        """
        Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.ReportFilterResponse']:
        """
        Has filter expression to use in the report.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def granularity(self) -> Optional[str]:
        """
        The granularity of rows in the report.
        """
        return pulumi.get(self, "granularity")

    @property
    @pulumi.getter
    def grouping(self) -> Optional[Sequence['outputs.ReportGroupingResponse']]:
        """
        Array of group by expression to use in the report. Report can have up to 2 group by clauses.
        """
        return pulumi.get(self, "grouping")


@pulumi.output_type
class ReportDefinitionResponse(dict):
    """
    The definition of a report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timePeriod":
            suggest = "time_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timeframe: str,
                 type: str,
                 dataset: Optional['outputs.ReportDatasetResponse'] = None,
                 time_period: Optional['outputs.ReportTimePeriodResponse'] = None):
        """
        The definition of a report.
        :param str timeframe: The time frame for pulling data for the report. If custom, then a specific time period must be provided.
        :param str type: The type of the report.
        :param 'ReportDatasetResponse' dataset: Has definition for data in this report.
        :param 'ReportTimePeriodResponse' time_period: Has time period for pulling data for the report.
        """
        pulumi.set(__self__, "timeframe", timeframe)
        pulumi.set(__self__, "type", type)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if time_period is not None:
            pulumi.set(__self__, "time_period", time_period)

    @property
    @pulumi.getter
    def timeframe(self) -> str:
        """
        The time frame for pulling data for the report. If custom, then a specific time period must be provided.
        """
        return pulumi.get(self, "timeframe")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the report.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def dataset(self) -> Optional['outputs.ReportDatasetResponse']:
        """
        Has definition for data in this report.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> Optional['outputs.ReportTimePeriodResponse']:
        """
        Has time period for pulling data for the report.
        """
        return pulumi.get(self, "time_period")


@pulumi.output_type
class ReportDeliveryDestinationResponse(dict):
    """
    The destination information for the delivery of the report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "rootFolderPath":
            suggest = "root_folder_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportDeliveryDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportDeliveryDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportDeliveryDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container: str,
                 resource_id: str,
                 root_folder_path: Optional[str] = None):
        """
        The destination information for the delivery of the report.
        :param str container: The name of the container where reports will be uploaded.
        :param str resource_id: The resource id of the storage account where reports will be delivered.
        :param str root_folder_path: The name of the directory where reports will be uploaded.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "resource_id", resource_id)
        if root_folder_path is not None:
            pulumi.set(__self__, "root_folder_path", root_folder_path)

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The name of the container where reports will be uploaded.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The resource id of the storage account where reports will be delivered.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="rootFolderPath")
    def root_folder_path(self) -> Optional[str]:
        """
        The name of the directory where reports will be uploaded.
        """
        return pulumi.get(self, "root_folder_path")


@pulumi.output_type
class ReportDeliveryInfoResponse(dict):
    """
    The delivery information associated with a report.
    """
    def __init__(__self__, *,
                 destination: 'outputs.ReportDeliveryDestinationResponse'):
        """
        The delivery information associated with a report.
        :param 'ReportDeliveryDestinationResponse' destination: Has destination for the report being delivered.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.ReportDeliveryDestinationResponse':
        """
        Has destination for the report being delivered.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class ReportFilterResponse(dict):
    """
    The filter expression to be used in the report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "and":
            suggest = "and_"
        elif key == "not":
            suggest = "not_"
        elif key == "or":
            suggest = "or_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_: Optional[Sequence['outputs.ReportFilterResponse']] = None,
                 dimension: Optional['outputs.ReportComparisonExpressionResponse'] = None,
                 not_: Optional['outputs.ReportFilterResponse'] = None,
                 or_: Optional[Sequence['outputs.ReportFilterResponse']] = None,
                 tag: Optional['outputs.ReportComparisonExpressionResponse'] = None):
        """
        The filter expression to be used in the report.
        :param Sequence['ReportFilterResponse'] and_: The logical "AND" expression. Must have at least 2 items.
        :param 'ReportComparisonExpressionResponse' dimension: Has comparison expression for a dimension
        :param 'ReportFilterResponse' not_: The logical "NOT" expression.
        :param Sequence['ReportFilterResponse'] or_: The logical "OR" expression. Must have at least 2 items.
        :param 'ReportComparisonExpressionResponse' tag: Has comparison expression for a tag
        """
        if and_ is not None:
            pulumi.set(__self__, "and_", and_)
        if dimension is not None:
            pulumi.set(__self__, "dimension", dimension)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if or_ is not None:
            pulumi.set(__self__, "or_", or_)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="and")
    def and_(self) -> Optional[Sequence['outputs.ReportFilterResponse']]:
        """
        The logical "AND" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "and_")

    @property
    @pulumi.getter
    def dimension(self) -> Optional['outputs.ReportComparisonExpressionResponse']:
        """
        Has comparison expression for a dimension
        """
        return pulumi.get(self, "dimension")

    @property
    @pulumi.getter(name="not")
    def not_(self) -> Optional['outputs.ReportFilterResponse']:
        """
        The logical "NOT" expression.
        """
        return pulumi.get(self, "not_")

    @property
    @pulumi.getter(name="or")
    def or_(self) -> Optional[Sequence['outputs.ReportFilterResponse']]:
        """
        The logical "OR" expression. Must have at least 2 items.
        """
        return pulumi.get(self, "or_")

    @property
    @pulumi.getter
    def tag(self) -> Optional['outputs.ReportComparisonExpressionResponse']:
        """
        Has comparison expression for a tag
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class ReportGroupingResponse(dict):
    """
    The group by expression to be used in the report.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        The group by expression to be used in the report.
        :param str name: The name of the column to group.
        :param str type: Has type of the column to group.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the column to group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Has type of the column to group.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReportRecurrencePeriodResponse(dict):
    """
    The start and end date for recurrence schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportRecurrencePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportRecurrencePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportRecurrencePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: Optional[str] = None):
        """
        The start and end date for recurrence schedule.
        :param str from_: The start date of recurrence.
        :param str to: The end date of recurrence.
        """
        pulumi.set(__self__, "from_", from_)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date of recurrence.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> Optional[str]:
        """
        The end date of recurrence.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class ReportScheduleResponse(dict):
    """
    The schedule associated with a report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recurrencePeriod":
            suggest = "recurrence_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recurrence: str,
                 recurrence_period: Optional['outputs.ReportRecurrencePeriodResponse'] = None,
                 status: Optional[str] = None):
        """
        The schedule associated with a report.
        :param str recurrence: The schedule recurrence.
        :param 'ReportRecurrencePeriodResponse' recurrence_period: Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        :param str status: The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
        """
        pulumi.set(__self__, "recurrence", recurrence)
        if recurrence_period is not None:
            pulumi.set(__self__, "recurrence_period", recurrence_period)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def recurrence(self) -> str:
        """
        The schedule recurrence.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter(name="recurrencePeriod")
    def recurrence_period(self) -> Optional['outputs.ReportRecurrencePeriodResponse']:
        """
        Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
        """
        return pulumi.get(self, "recurrence_period")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the schedule. Whether active or not. If inactive, the report's scheduled execution is paused.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ReportTimePeriodResponse(dict):
    """
    The start and end date for pulling data for the report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "from":
            suggest = "from_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportTimePeriodResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportTimePeriodResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportTimePeriodResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_: str,
                 to: str):
        """
        The start and end date for pulling data for the report.
        :param str from_: The start date to pull data from.
        :param str to: The end date to pull data to.
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> str:
        """
        The start date to pull data from.
        """
        return pulumi.get(self, "from_")

    @property
    @pulumi.getter
    def to(self) -> str:
        """
        The end date to pull data to.
        """
        return pulumi.get(self, "to")


@pulumi.output_type
class SchedulePropertiesResponse(dict):
    """
    The properties of the schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "startDate":
            suggest = "start_date"
        elif key == "dayOfMonth":
            suggest = "day_of_month"
        elif key == "daysOfWeek":
            suggest = "days_of_week"
        elif key == "hourOfDay":
            suggest = "hour_of_day"
        elif key == "weeksOfMonth":
            suggest = "weeks_of_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: str,
                 frequency: str,
                 start_date: str,
                 day_of_month: Optional[int] = None,
                 days_of_week: Optional[Sequence[str]] = None,
                 hour_of_day: Optional[int] = None,
                 weeks_of_month: Optional[Sequence[str]] = None):
        """
        The properties of the schedule.
        :param str end_date: The end date and time of the scheduled action (UTC).
        :param str frequency: Frequency of the schedule.
        :param str start_date: The start date and time of the scheduled action (UTC).
        :param int day_of_month: UTC day on which cost analysis data will be emailed. Must be between 1 and 31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or daysOfWeek.
        :param Sequence[str] days_of_week: Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
        :param int hour_of_day: UTC time at which cost analysis data will be emailed.
        :param Sequence[str] weeks_of_month: Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "start_date", start_date)
        if day_of_month is not None:
            pulumi.set(__self__, "day_of_month", day_of_month)
        if days_of_week is not None:
            pulumi.set(__self__, "days_of_week", days_of_week)
        if hour_of_day is not None:
            pulumi.set(__self__, "hour_of_day", hour_of_day)
        if weeks_of_month is not None:
            pulumi.set(__self__, "weeks_of_month", weeks_of_month)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        The end date and time of the scheduled action (UTC).
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        Frequency of the schedule.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        The start date and time of the scheduled action (UTC).
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> Optional[int]:
        """
        UTC day on which cost analysis data will be emailed. Must be between 1 and 31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or daysOfWeek.
        """
        return pulumi.get(self, "day_of_month")

    @property
    @pulumi.getter(name="daysOfWeek")
    def days_of_week(self) -> Optional[Sequence[str]]:
        """
        Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
        """
        return pulumi.get(self, "days_of_week")

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> Optional[int]:
        """
        UTC time at which cost analysis data will be emailed.
        """
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="weeksOfMonth")
    def weeks_of_month(self) -> Optional[Sequence[str]]:
        """
        Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
        """
        return pulumi.get(self, "weeks_of_month")


@pulumi.output_type
class SettingsPropertiesResponseCache(dict):
    def __init__(__self__, *,
                 channel: str,
                 id: str,
                 name: str,
                 subchannel: str,
                 parent: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str channel: Indicates the account type. Allowed values include: EA, PAYG, Modern, Internal, Unknown.
        :param str id: Resource ID used by Resource Manager to uniquely identify the scope.
        :param str name: Display name for the scope.
        :param str subchannel: Indicates the type of modern account. Allowed values include: Individual, Enterprise, Partner, Indirect, NotApplicable
        :param str parent: Resource ID of the parent scope. For instance, subscription's resource ID for a resource group or a management group resource ID for a subscription.
        :param str status: Indicates the status of the scope. Status only applies to subscriptions and billing accounts.
        """
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subchannel", subchannel)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        Indicates the account type. Allowed values include: EA, PAYG, Modern, Internal, Unknown.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID used by Resource Manager to uniquely identify the scope.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Display name for the scope.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subchannel(self) -> str:
        """
        Indicates the type of modern account. Allowed values include: Individual, Enterprise, Partner, Indirect, NotApplicable
        """
        return pulumi.get(self, "subchannel")

    @property
    @pulumi.getter
    def parent(self) -> Optional[str]:
        """
        Resource ID of the parent scope. For instance, subscription's resource ID for a resource group or a management group resource ID for a subscription.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates the status of the scope. Status only applies to subscriptions and billing accounts.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SourceCostAllocationResourceResponse(dict):
    """
    Source resources for cost allocation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceCostAllocationResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceCostAllocationResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceCostAllocationResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 resource_type: str,
                 values: Sequence[str]):
        """
        Source resources for cost allocation
        :param str name: If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
        :param str resource_type: Type of resources contained in this cost allocation rule
        :param Sequence[str] values: Source Resources for cost allocation. This list cannot contain more than 25 values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of resources contained in this cost allocation rule
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Source Resources for cost allocation. This list cannot contain more than 25 values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TargetCostAllocationResourceResponse(dict):
    """
    Target resources for cost allocation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetCostAllocationResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetCostAllocationResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetCostAllocationResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 policy_type: str,
                 resource_type: str,
                 values: Sequence['outputs.CostAllocationProportionResponse']):
        """
        Target resources for cost allocation.
        :param str name: If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
        :param str policy_type: Method of cost allocation for the rule
        :param str resource_type: Type of resources contained in this cost allocation rule
        :param Sequence['CostAllocationProportionResponse'] values: Target resources for cost allocation. This list cannot contain more than 25 values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """
        Method of cost allocation for the rule
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of resources contained in this cost allocation rule
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.CostAllocationProportionResponse']:
        """
        Target resources for cost allocation. This list cannot contain more than 25 values.
        """
        return pulumi.get(self, "values")


