# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AddressSpaceResponse',
    'ApplicationGatewayAuthenticationCertificateResponse',
    'ApplicationGatewayAutoscaleConfigurationResponse',
    'ApplicationGatewayBackendAddressPoolResponse',
    'ApplicationGatewayBackendAddressResponse',
    'ApplicationGatewayBackendHttpSettingsResponse',
    'ApplicationGatewayConnectionDrainingResponse',
    'ApplicationGatewayCustomErrorResponse',
    'ApplicationGatewayFirewallDisabledRuleGroupResponse',
    'ApplicationGatewayFirewallExclusionResponse',
    'ApplicationGatewayFrontendIPConfigurationResponse',
    'ApplicationGatewayFrontendPortResponse',
    'ApplicationGatewayHttpListenerResponse',
    'ApplicationGatewayIPConfigurationResponse',
    'ApplicationGatewayPathRuleResponse',
    'ApplicationGatewayProbeHealthResponseMatchResponse',
    'ApplicationGatewayProbeResponse',
    'ApplicationGatewayRedirectConfigurationResponse',
    'ApplicationGatewayRequestRoutingRuleResponse',
    'ApplicationGatewaySkuResponse',
    'ApplicationGatewaySslCertificateResponse',
    'ApplicationGatewaySslPolicyResponse',
    'ApplicationGatewayTrustedRootCertificateResponse',
    'ApplicationGatewayUrlPathMapResponse',
    'ApplicationGatewayWebApplicationFirewallConfigurationResponse',
    'ApplicationSecurityGroupResponse',
    'AzureFirewallApplicationRuleCollectionResponse',
    'AzureFirewallApplicationRuleProtocolResponse',
    'AzureFirewallApplicationRuleResponse',
    'AzureFirewallIPConfigurationResponse',
    'AzureFirewallNatRCActionResponse',
    'AzureFirewallNatRuleCollectionResponse',
    'AzureFirewallNatRuleResponse',
    'AzureFirewallNetworkRuleCollectionResponse',
    'AzureFirewallNetworkRuleResponse',
    'AzureFirewallRCActionResponse',
    'BackendAddressPoolResponse',
    'BgpPeerStatusResponse',
    'BgpSettingsResponse',
    'ConnectionMonitorDestinationResponse',
    'ConnectionMonitorSourceResponse',
    'ContainerNetworkInterfaceConfigurationResponse',
    'ContainerNetworkInterfaceIpConfigurationResponse',
    'ContainerNetworkInterfaceResponse',
    'ContainerResponse',
    'DelegationResponse',
    'DevicePropertiesResponse',
    'DhcpOptionsResponse',
    'DnsConfigResponse',
    'EndpointPropertiesResponseCustomHeaders',
    'EndpointPropertiesResponseSubnets',
    'EndpointResponse',
    'EndpointServiceResponse',
    'ExpressRouteCircuitAuthorizationResponse',
    'ExpressRouteCircuitConnectionResponse',
    'ExpressRouteCircuitPeeringConfigResponse',
    'ExpressRouteCircuitPeeringIdResponse',
    'ExpressRouteCircuitPeeringResponse',
    'ExpressRouteCircuitServiceProviderPropertiesResponse',
    'ExpressRouteCircuitSkuResponse',
    'ExpressRouteCircuitStatsResponse',
    'ExpressRouteConnectionIdResponse',
    'ExpressRouteConnectionResponse',
    'ExpressRouteGatewayPropertiesResponseAutoScaleConfiguration',
    'ExpressRouteGatewayPropertiesResponseBounds',
    'ExpressRouteLinkResponse',
    'FrontendIPConfigurationResponse',
    'GatewayRouteResponse',
    'HubVirtualNetworkConnectionResponse',
    'IPConfigurationProfileResponse',
    'IPConfigurationResponse',
    'InboundNatPoolResponse',
    'InboundNatRuleResponse',
    'InterfaceEndpointResponse',
    'IpTagResponse',
    'IpsecPolicyResponse',
    'Ipv6ExpressRouteCircuitPeeringConfigResponse',
    'LoadBalancerSkuResponse',
    'LoadBalancingRuleResponse',
    'LocalNetworkGatewayResponse',
    'MonitorConfigResponse',
    'MonitorConfigResponseCustomHeaders',
    'MonitorConfigResponseExpectedStatusCodeRanges',
    'NetworkInterfaceDnsSettingsResponse',
    'NetworkInterfaceIPConfigurationResponse',
    'NetworkInterfaceResponse',
    'NetworkInterfaceTapConfigurationResponse',
    'NetworkSecurityGroupResponse',
    'OutboundRuleResponse',
    'P2SVpnServerConfigRadiusClientRootCertificateResponse',
    'P2SVpnServerConfigRadiusServerRootCertificateResponse',
    'P2SVpnServerConfigVpnClientRevokedCertificateResponse',
    'P2SVpnServerConfigVpnClientRootCertificateResponse',
    'P2SVpnServerConfigurationResponse',
    'PacketCaptureFilterResponse',
    'PacketCaptureStorageLocationResponse',
    'ProbeResponse',
    'PublicIPAddressDnsSettingsResponse',
    'PublicIPAddressResponse',
    'PublicIPAddressSkuResponse',
    'PublicIPPrefixSkuResponse',
    'ReferencedPublicIpAddressResponse',
    'ResourceNavigationLinkResponse',
    'RouteFilterResponse',
    'RouteFilterRuleResponse',
    'RouteResponse',
    'RouteTableResponse',
    'SecurityRuleResponse',
    'ServiceAssociationLinkResponse',
    'ServiceEndpointPolicyDefinitionResponse',
    'ServiceEndpointPolicyResponse',
    'ServiceEndpointPropertiesFormatResponse',
    'SubResourceResponse',
    'SubnetResponse',
    'TunnelConnectionHealthResponse',
    'VirtualHubIdResponse',
    'VirtualHubRouteResponse',
    'VirtualHubRouteTableResponse',
    'VirtualNetworkGatewayIPConfigurationResponse',
    'VirtualNetworkGatewayResponse',
    'VirtualNetworkGatewaySkuResponse',
    'VirtualNetworkPeeringResponse',
    'VirtualNetworkTapResponse',
    'VpnClientConfigurationResponse',
    'VpnClientConnectionHealthResponse',
    'VpnClientRevokedCertificateResponse',
    'VpnClientRootCertificateResponse',
    'VpnConnectionResponse',
]

@pulumi.output_type
class AddressSpaceResponse(dict):
    """
    AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefixes":
            suggest = "address_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddressSpaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddressSpaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddressSpaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefixes: Optional[Sequence[str]] = None):
        """
        AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
        :param Sequence[str] address_prefixes: A list of address blocks reserved for this virtual network in CIDR notation.
        """
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        A list of address blocks reserved for this virtual network in CIDR notation.
        """
        return pulumi.get(self, "address_prefixes")


@pulumi.output_type
class ApplicationGatewayAuthenticationCertificateResponse(dict):
    """
    Authentication certificates of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayAuthenticationCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayAuthenticationCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayAuthenticationCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Authentication certificates of an application gateway.
        :param str data: Certificate public data.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the authentication certificate that is unique within an Application Gateway.
        :param str provisioning_state: Provisioning state of the authentication certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str type: Type of the resource.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        Certificate public data.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the authentication certificate that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the authentication certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationGatewayAutoscaleConfigurationResponse(dict):
    """
    Application Gateway autoscale configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minCapacity":
            suggest = "min_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayAutoscaleConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayAutoscaleConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayAutoscaleConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_capacity: int):
        """
        Application Gateway autoscale configuration.
        :param int min_capacity: Lower bound on number of Application Gateway instances
        """
        pulumi.set(__self__, "min_capacity", min_capacity)

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> int:
        """
        Lower bound on number of Application Gateway instances
        """
        return pulumi.get(self, "min_capacity")


@pulumi.output_type
class ApplicationGatewayBackendAddressPoolResponse(dict):
    """
    Backend Address Pool of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddresses":
            suggest = "backend_addresses"
        elif key == "backendIPConfigurations":
            suggest = "backend_ip_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendAddressPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendAddressPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendAddressPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_addresses: Optional[Sequence['outputs.ApplicationGatewayBackendAddressResponse']] = None,
                 backend_ip_configurations: Optional[Sequence['outputs.NetworkInterfaceIPConfigurationResponse']] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Backend Address Pool of an application gateway.
        :param Sequence['ApplicationGatewayBackendAddressResponse'] backend_addresses: Backend addresses
        :param Sequence['NetworkInterfaceIPConfigurationResponse'] backend_ip_configurations: Collection of references to IPs defined in network interfaces.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the backend address pool that is unique within an Application Gateway.
        :param str provisioning_state: Provisioning state of the backend address pool resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str type: Type of the resource.
        """
        if backend_addresses is not None:
            pulumi.set(__self__, "backend_addresses", backend_addresses)
        if backend_ip_configurations is not None:
            pulumi.set(__self__, "backend_ip_configurations", backend_ip_configurations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="backendAddresses")
    def backend_addresses(self) -> Optional[Sequence['outputs.ApplicationGatewayBackendAddressResponse']]:
        """
        Backend addresses
        """
        return pulumi.get(self, "backend_addresses")

    @property
    @pulumi.getter(name="backendIPConfigurations")
    def backend_ip_configurations(self) -> Optional[Sequence['outputs.NetworkInterfaceIPConfigurationResponse']]:
        """
        Collection of references to IPs defined in network interfaces.
        """
        return pulumi.get(self, "backend_ip_configurations")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the backend address pool that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the backend address pool resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationGatewayBackendAddressResponse(dict):
    """
    Backend address of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 ip_address: Optional[str] = None):
        """
        Backend address of an application gateway.
        :param str fqdn: Fully qualified domain name (FQDN).
        :param str ip_address: IP address
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Fully qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        IP address
        """
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class ApplicationGatewayBackendHttpSettingsResponse(dict):
    """
    Backend address pool settings of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "affinityCookieName":
            suggest = "affinity_cookie_name"
        elif key == "authenticationCertificates":
            suggest = "authentication_certificates"
        elif key == "connectionDraining":
            suggest = "connection_draining"
        elif key == "cookieBasedAffinity":
            suggest = "cookie_based_affinity"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "pickHostNameFromBackendAddress":
            suggest = "pick_host_name_from_backend_address"
        elif key == "probeEnabled":
            suggest = "probe_enabled"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "requestTimeout":
            suggest = "request_timeout"
        elif key == "trustedRootCertificates":
            suggest = "trusted_root_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayBackendHttpSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayBackendHttpSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayBackendHttpSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 affinity_cookie_name: Optional[str] = None,
                 authentication_certificates: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 connection_draining: Optional['outputs.ApplicationGatewayConnectionDrainingResponse'] = None,
                 cookie_based_affinity: Optional[str] = None,
                 etag: Optional[str] = None,
                 host_name: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None,
                 pick_host_name_from_backend_address: Optional[bool] = None,
                 port: Optional[int] = None,
                 probe: Optional['outputs.SubResourceResponse'] = None,
                 probe_enabled: Optional[bool] = None,
                 protocol: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 request_timeout: Optional[int] = None,
                 trusted_root_certificates: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 type: Optional[str] = None):
        """
        Backend address pool settings of an application gateway.
        :param str affinity_cookie_name: Cookie name to use for the affinity cookie.
        :param Sequence['SubResourceResponse'] authentication_certificates: Array of references to application gateway authentication certificates.
        :param 'ApplicationGatewayConnectionDrainingResponse' connection_draining: Connection draining of the backend http settings resource.
        :param str cookie_based_affinity: Cookie based affinity.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str host_name: Host header to be sent to the backend servers.
        :param str id: Resource ID.
        :param str name: Name of the backend http settings that is unique within an Application Gateway.
        :param str path: Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
        :param bool pick_host_name_from_backend_address: Whether to pick host header should be picked from the host name of the backend server. Default value is false.
        :param int port: The destination port on the backend.
        :param 'SubResourceResponse' probe: Probe resource of an application gateway.
        :param bool probe_enabled: Whether the probe is enabled. Default value is false.
        :param str protocol: The protocol used to communicate with the backend. Possible values are 'Http' and 'Https'.
        :param str provisioning_state: Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param int request_timeout: Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
        :param Sequence['SubResourceResponse'] trusted_root_certificates: Array of references to application gateway trusted root certificates.
        :param str type: Type of the resource.
        """
        if affinity_cookie_name is not None:
            pulumi.set(__self__, "affinity_cookie_name", affinity_cookie_name)
        if authentication_certificates is not None:
            pulumi.set(__self__, "authentication_certificates", authentication_certificates)
        if connection_draining is not None:
            pulumi.set(__self__, "connection_draining", connection_draining)
        if cookie_based_affinity is not None:
            pulumi.set(__self__, "cookie_based_affinity", cookie_based_affinity)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if pick_host_name_from_backend_address is not None:
            pulumi.set(__self__, "pick_host_name_from_backend_address", pick_host_name_from_backend_address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if probe is not None:
            pulumi.set(__self__, "probe", probe)
        if probe_enabled is not None:
            pulumi.set(__self__, "probe_enabled", probe_enabled)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if trusted_root_certificates is not None:
            pulumi.set(__self__, "trusted_root_certificates", trusted_root_certificates)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="affinityCookieName")
    def affinity_cookie_name(self) -> Optional[str]:
        """
        Cookie name to use for the affinity cookie.
        """
        return pulumi.get(self, "affinity_cookie_name")

    @property
    @pulumi.getter(name="authenticationCertificates")
    def authentication_certificates(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Array of references to application gateway authentication certificates.
        """
        return pulumi.get(self, "authentication_certificates")

    @property
    @pulumi.getter(name="connectionDraining")
    def connection_draining(self) -> Optional['outputs.ApplicationGatewayConnectionDrainingResponse']:
        """
        Connection draining of the backend http settings resource.
        """
        return pulumi.get(self, "connection_draining")

    @property
    @pulumi.getter(name="cookieBasedAffinity")
    def cookie_based_affinity(self) -> Optional[str]:
        """
        Cookie based affinity.
        """
        return pulumi.get(self, "cookie_based_affinity")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        Host header to be sent to the backend servers.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the backend http settings that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pickHostNameFromBackendAddress")
    def pick_host_name_from_backend_address(self) -> Optional[bool]:
        """
        Whether to pick host header should be picked from the host name of the backend server. Default value is false.
        """
        return pulumi.get(self, "pick_host_name_from_backend_address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The destination port on the backend.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def probe(self) -> Optional['outputs.SubResourceResponse']:
        """
        Probe resource of an application gateway.
        """
        return pulumi.get(self, "probe")

    @property
    @pulumi.getter(name="probeEnabled")
    def probe_enabled(self) -> Optional[bool]:
        """
        Whether the probe is enabled. Default value is false.
        """
        return pulumi.get(self, "probe_enabled")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol used to communicate with the backend. Possible values are 'Http' and 'Https'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[int]:
        """
        Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "request_timeout")

    @property
    @pulumi.getter(name="trustedRootCertificates")
    def trusted_root_certificates(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Array of references to application gateway trusted root certificates.
        """
        return pulumi.get(self, "trusted_root_certificates")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationGatewayConnectionDrainingResponse(dict):
    """
    Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drainTimeoutInSec":
            suggest = "drain_timeout_in_sec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayConnectionDrainingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayConnectionDrainingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayConnectionDrainingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 drain_timeout_in_sec: int,
                 enabled: bool):
        """
        Connection draining allows open connections to a backend server to be active for a specified time after the backend server got removed from the configuration.
        :param int drain_timeout_in_sec: The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
        :param bool enabled: Whether connection draining is enabled or not.
        """
        pulumi.set(__self__, "drain_timeout_in_sec", drain_timeout_in_sec)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="drainTimeoutInSec")
    def drain_timeout_in_sec(self) -> int:
        """
        The number of seconds connection draining is active. Acceptable values are from 1 second to 3600 seconds.
        """
        return pulumi.get(self, "drain_timeout_in_sec")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether connection draining is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ApplicationGatewayCustomErrorResponse(dict):
    """
    Customer error of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customErrorPageUrl":
            suggest = "custom_error_page_url"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayCustomErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayCustomErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayCustomErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_error_page_url: Optional[str] = None,
                 status_code: Optional[str] = None):
        """
        Customer error of an application gateway.
        :param str custom_error_page_url: Error page URL of the application gateway customer error.
        :param str status_code: Status code of the application gateway customer error.
        """
        if custom_error_page_url is not None:
            pulumi.set(__self__, "custom_error_page_url", custom_error_page_url)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="customErrorPageUrl")
    def custom_error_page_url(self) -> Optional[str]:
        """
        Error page URL of the application gateway customer error.
        """
        return pulumi.get(self, "custom_error_page_url")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[str]:
        """
        Status code of the application gateway customer error.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ApplicationGatewayFirewallDisabledRuleGroupResponse(dict):
    """
    Allows to disable rules within a rule group or an entire rule group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleGroupName":
            suggest = "rule_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFirewallDisabledRuleGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFirewallDisabledRuleGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFirewallDisabledRuleGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_group_name: str,
                 rules: Optional[Sequence[int]] = None):
        """
        Allows to disable rules within a rule group or an entire rule group.
        :param str rule_group_name: The name of the rule group that will be disabled.
        :param Sequence[int] rules: The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> str:
        """
        The name of the rule group that will be disabled.
        """
        return pulumi.get(self, "rule_group_name")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence[int]]:
        """
        The list of rules that will be disabled. If null, all rules of the rule group will be disabled.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ApplicationGatewayFirewallExclusionResponse(dict):
    """
    Allow to exclude some variable satisfy the condition for the WAF check
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchVariable":
            suggest = "match_variable"
        elif key == "selectorMatchOperator":
            suggest = "selector_match_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFirewallExclusionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFirewallExclusionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFirewallExclusionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_variable: str,
                 selector: str,
                 selector_match_operator: str):
        """
        Allow to exclude some variable satisfy the condition for the WAF check
        :param str match_variable: The variable to be excluded.
        :param str selector: When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
        :param str selector_match_operator: When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "selector_match_operator", selector_match_operator)

    @property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> str:
        """
        The variable to be excluded.
        """
        return pulumi.get(self, "match_variable")

    @property
    @pulumi.getter
    def selector(self) -> str:
        """
        When matchVariable is a collection, operator used to specify which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="selectorMatchOperator")
    def selector_match_operator(self) -> str:
        """
        When matchVariable is a collection, operate on the selector to specify which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector_match_operator")


@pulumi.output_type
class ApplicationGatewayFrontendIPConfigurationResponse(dict):
    """
    Frontend IP configuration of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFrontendIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFrontendIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFrontendIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None,
                 type: Optional[str] = None):
        """
        Frontend IP configuration of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the frontend IP configuration that is unique within an Application Gateway.
        :param str private_ip_address: PrivateIPAddress of the network interface IP Configuration.
        :param str private_ip_allocation_method: PrivateIP allocation method.
        :param str provisioning_state: Provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'SubResourceResponse' public_ip_address: Reference of the PublicIP resource.
        :param 'SubResourceResponse' subnet: Reference of the subnet resource.
        :param str type: Type of the resource.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the frontend IP configuration that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        PrivateIPAddress of the network interface IP Configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        PrivateIP allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference of the PublicIP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference of the subnet resource.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationGatewayFrontendPortResponse(dict):
    """
    Frontend port of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayFrontendPortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayFrontendPortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayFrontendPortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 port: Optional[int] = None,
                 provisioning_state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Frontend port of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the frontend port that is unique within an Application Gateway
        :param int port: Frontend port
        :param str provisioning_state: Provisioning state of the frontend port resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str type: Type of the resource.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the frontend port that is unique within an Application Gateway
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Frontend port
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the frontend port resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationGatewayHttpListenerResponse(dict):
    """
    Http listener of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customErrorConfigurations":
            suggest = "custom_error_configurations"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "requireServerNameIndication":
            suggest = "require_server_name_indication"
        elif key == "sslCertificate":
            suggest = "ssl_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayHttpListenerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayHttpListenerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayHttpListenerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_error_configurations: Optional[Sequence['outputs.ApplicationGatewayCustomErrorResponse']] = None,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 frontend_port: Optional['outputs.SubResourceResponse'] = None,
                 host_name: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 protocol: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 require_server_name_indication: Optional[bool] = None,
                 ssl_certificate: Optional['outputs.SubResourceResponse'] = None,
                 type: Optional[str] = None):
        """
        Http listener of an application gateway.
        :param Sequence['ApplicationGatewayCustomErrorResponse'] custom_error_configurations: Custom error configurations of the HTTP listener.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
        :param 'SubResourceResponse' frontend_port: Frontend port resource of an application gateway.
        :param str host_name: Host name of HTTP listener.
        :param str id: Resource ID.
        :param str name: Name of the HTTP listener that is unique within an Application Gateway.
        :param str protocol: Protocol of the HTTP listener. Possible values are 'Http' and 'Https'.
        :param str provisioning_state: Provisioning state of the HTTP listener resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param bool require_server_name_indication: Applicable only if protocol is https. Enables SNI for multi-hosting.
        :param 'SubResourceResponse' ssl_certificate: SSL certificate resource of an application gateway.
        :param str type: Type of the resource.
        """
        if custom_error_configurations is not None:
            pulumi.set(__self__, "custom_error_configurations", custom_error_configurations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if require_server_name_indication is not None:
            pulumi.set(__self__, "require_server_name_indication", require_server_name_indication)
        if ssl_certificate is not None:
            pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="customErrorConfigurations")
    def custom_error_configurations(self) -> Optional[Sequence['outputs.ApplicationGatewayCustomErrorResponse']]:
        """
        Custom error configurations of the HTTP listener.
        """
        return pulumi.get(self, "custom_error_configurations")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Frontend IP configuration resource of an application gateway.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional['outputs.SubResourceResponse']:
        """
        Frontend port resource of an application gateway.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        Host name of HTTP listener.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the HTTP listener that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol of the HTTP listener. Possible values are 'Http' and 'Https'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the HTTP listener resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="requireServerNameIndication")
    def require_server_name_indication(self) -> Optional[bool]:
        """
        Applicable only if protocol is https. Enables SNI for multi-hosting.
        """
        return pulumi.get(self, "require_server_name_indication")

    @property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> Optional['outputs.SubResourceResponse']:
        """
        SSL certificate resource of an application gateway.
        """
        return pulumi.get(self, "ssl_certificate")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationGatewayIPConfigurationResponse(dict):
    """
    IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None,
                 type: Optional[str] = None):
        """
        IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the IP configuration that is unique within an Application Gateway.
        :param str provisioning_state: Provisioning state of the application gateway subnet resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'SubResourceResponse' subnet: Reference of the subnet resource. A subnet from where application gateway gets its private address.
        :param str type: Type of the resource.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the IP configuration that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the application gateway subnet resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference of the subnet resource. A subnet from where application gateway gets its private address.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationGatewayPathRuleResponse(dict):
    """
    Path rule of URL path map of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "backendHttpSettings":
            suggest = "backend_http_settings"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "redirectConfiguration":
            suggest = "redirect_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayPathRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayPathRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayPathRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 backend_http_settings: Optional['outputs.SubResourceResponse'] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 paths: Optional[Sequence[str]] = None,
                 provisioning_state: Optional[str] = None,
                 redirect_configuration: Optional['outputs.SubResourceResponse'] = None,
                 type: Optional[str] = None):
        """
        Path rule of URL path map of an application gateway.
        :param 'SubResourceResponse' backend_address_pool: Backend address pool resource of URL path map path rule.
        :param 'SubResourceResponse' backend_http_settings: Backend http settings resource of URL path map path rule.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the path rule that is unique within an Application Gateway.
        :param Sequence[str] paths: Path rules of URL path map.
        :param str provisioning_state: Path rule of URL path map resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'SubResourceResponse' redirect_configuration: Redirect configuration resource of URL path map path rule.
        :param str type: Type of the resource.
        """
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_http_settings is not None:
            pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if redirect_configuration is not None:
            pulumi.set(__self__, "redirect_configuration", redirect_configuration)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        Backend address pool resource of URL path map path rule.
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Backend http settings resource of URL path map path rule.
        """
        return pulumi.get(self, "backend_http_settings")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the path rule that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        Path rules of URL path map.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Path rule of URL path map resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="redirectConfiguration")
    def redirect_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Redirect configuration resource of URL path map path rule.
        """
        return pulumi.get(self, "redirect_configuration")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationGatewayProbeHealthResponseMatchResponse(dict):
    """
    Application gateway probe health response match
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCodes":
            suggest = "status_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayProbeHealthResponseMatchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayProbeHealthResponseMatchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayProbeHealthResponseMatchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body: Optional[str] = None,
                 status_codes: Optional[Sequence[str]] = None):
        """
        Application gateway probe health response match
        :param str body: Body that must be contained in the health response. Default value is empty.
        :param Sequence[str] status_codes: Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)

    @property
    @pulumi.getter
    def body(self) -> Optional[str]:
        """
        Body that must be contained in the health response. Default value is empty.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[Sequence[str]]:
        """
        Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
        """
        return pulumi.get(self, "status_codes")


@pulumi.output_type
class ApplicationGatewayProbeResponse(dict):
    """
    Probe of the application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minServers":
            suggest = "min_servers"
        elif key == "pickHostNameFromBackendHttpSettings":
            suggest = "pick_host_name_from_backend_http_settings"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayProbeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayProbeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayProbeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 host: Optional[str] = None,
                 id: Optional[str] = None,
                 interval: Optional[int] = None,
                 match: Optional['outputs.ApplicationGatewayProbeHealthResponseMatchResponse'] = None,
                 min_servers: Optional[int] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None,
                 pick_host_name_from_backend_http_settings: Optional[bool] = None,
                 protocol: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 timeout: Optional[int] = None,
                 type: Optional[str] = None,
                 unhealthy_threshold: Optional[int] = None):
        """
        Probe of the application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str host: Host name to send the probe to.
        :param str id: Resource ID.
        :param int interval: The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        :param 'ApplicationGatewayProbeHealthResponseMatchResponse' match: Criterion for classifying a healthy probe response.
        :param int min_servers: Minimum number of servers that are always marked healthy. Default value is 0.
        :param str name: Name of the probe that is unique within an Application Gateway.
        :param str path: Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>
        :param bool pick_host_name_from_backend_http_settings: Whether the host header should be picked from the backend http settings. Default value is false.
        :param str protocol: The protocol used for the probe. Possible values are 'Http' and 'Https'.
        :param str provisioning_state: Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param int timeout: the probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        :param str type: Type of the resource.
        :param int unhealthy_threshold: The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if min_servers is not None:
            pulumi.set(__self__, "min_servers", min_servers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if pick_host_name_from_backend_http_settings is not None:
            pulumi.set(__self__, "pick_host_name_from_backend_http_settings", pick_host_name_from_backend_http_settings)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Host name to send the probe to.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The probing interval in seconds. This is the time interval between two consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def match(self) -> Optional['outputs.ApplicationGatewayProbeHealthResponseMatchResponse']:
        """
        Criterion for classifying a healthy probe response.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter(name="minServers")
    def min_servers(self) -> Optional[int]:
        """
        Minimum number of servers that are always marked healthy. Default value is 0.
        """
        return pulumi.get(self, "min_servers")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the probe that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pickHostNameFromBackendHttpSettings")
    def pick_host_name_from_backend_http_settings(self) -> Optional[bool]:
        """
        Whether the host header should be picked from the backend http settings. Default value is false.
        """
        return pulumi.get(self, "pick_host_name_from_backend_http_settings")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol used for the probe. Possible values are 'Http' and 'Https'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        the probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[int]:
        """
        The probe retry count. Backend server is marked down after consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second to 20.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class ApplicationGatewayRedirectConfigurationResponse(dict):
    """
    Redirect configuration of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includePath":
            suggest = "include_path"
        elif key == "includeQueryString":
            suggest = "include_query_string"
        elif key == "pathRules":
            suggest = "path_rules"
        elif key == "redirectType":
            suggest = "redirect_type"
        elif key == "requestRoutingRules":
            suggest = "request_routing_rules"
        elif key == "targetListener":
            suggest = "target_listener"
        elif key == "targetUrl":
            suggest = "target_url"
        elif key == "urlPathMaps":
            suggest = "url_path_maps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayRedirectConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayRedirectConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayRedirectConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 include_path: Optional[bool] = None,
                 include_query_string: Optional[bool] = None,
                 name: Optional[str] = None,
                 path_rules: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 redirect_type: Optional[str] = None,
                 request_routing_rules: Optional[Sequence['outputs.SubResourceResponse']] = None,
                 target_listener: Optional['outputs.SubResourceResponse'] = None,
                 target_url: Optional[str] = None,
                 type: Optional[str] = None,
                 url_path_maps: Optional[Sequence['outputs.SubResourceResponse']] = None):
        """
        Redirect configuration of an application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param bool include_path: Include path in the redirected url.
        :param bool include_query_string: Include query string in the redirected url.
        :param str name: Name of the redirect configuration that is unique within an Application Gateway.
        :param Sequence['SubResourceResponse'] path_rules: Path rules specifying redirect configuration.
        :param str redirect_type: Supported http redirection types - Permanent, Temporary, Found, SeeOther.
        :param Sequence['SubResourceResponse'] request_routing_rules: Request routing specifying redirect configuration.
        :param 'SubResourceResponse' target_listener: Reference to a listener to redirect the request to.
        :param str target_url: Url to redirect the request to.
        :param str type: Type of the resource.
        :param Sequence['SubResourceResponse'] url_path_maps: Url path maps specifying default redirect configuration.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if include_path is not None:
            pulumi.set(__self__, "include_path", include_path)
        if include_query_string is not None:
            pulumi.set(__self__, "include_query_string", include_query_string)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_rules is not None:
            pulumi.set(__self__, "path_rules", path_rules)
        if redirect_type is not None:
            pulumi.set(__self__, "redirect_type", redirect_type)
        if request_routing_rules is not None:
            pulumi.set(__self__, "request_routing_rules", request_routing_rules)
        if target_listener is not None:
            pulumi.set(__self__, "target_listener", target_listener)
        if target_url is not None:
            pulumi.set(__self__, "target_url", target_url)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if url_path_maps is not None:
            pulumi.set(__self__, "url_path_maps", url_path_maps)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includePath")
    def include_path(self) -> Optional[bool]:
        """
        Include path in the redirected url.
        """
        return pulumi.get(self, "include_path")

    @property
    @pulumi.getter(name="includeQueryString")
    def include_query_string(self) -> Optional[bool]:
        """
        Include query string in the redirected url.
        """
        return pulumi.get(self, "include_query_string")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the redirect configuration that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pathRules")
    def path_rules(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Path rules specifying redirect configuration.
        """
        return pulumi.get(self, "path_rules")

    @property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> Optional[str]:
        """
        Supported http redirection types - Permanent, Temporary, Found, SeeOther.
        """
        return pulumi.get(self, "redirect_type")

    @property
    @pulumi.getter(name="requestRoutingRules")
    def request_routing_rules(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Request routing specifying redirect configuration.
        """
        return pulumi.get(self, "request_routing_rules")

    @property
    @pulumi.getter(name="targetListener")
    def target_listener(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to a listener to redirect the request to.
        """
        return pulumi.get(self, "target_listener")

    @property
    @pulumi.getter(name="targetUrl")
    def target_url(self) -> Optional[str]:
        """
        Url to redirect the request to.
        """
        return pulumi.get(self, "target_url")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="urlPathMaps")
    def url_path_maps(self) -> Optional[Sequence['outputs.SubResourceResponse']]:
        """
        Url path maps specifying default redirect configuration.
        """
        return pulumi.get(self, "url_path_maps")


@pulumi.output_type
class ApplicationGatewayRequestRoutingRuleResponse(dict):
    """
    Request routing rule of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "backendHttpSettings":
            suggest = "backend_http_settings"
        elif key == "httpListener":
            suggest = "http_listener"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "redirectConfiguration":
            suggest = "redirect_configuration"
        elif key == "ruleType":
            suggest = "rule_type"
        elif key == "urlPathMap":
            suggest = "url_path_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayRequestRoutingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayRequestRoutingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayRequestRoutingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 backend_http_settings: Optional['outputs.SubResourceResponse'] = None,
                 etag: Optional[str] = None,
                 http_listener: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 redirect_configuration: Optional['outputs.SubResourceResponse'] = None,
                 rule_type: Optional[str] = None,
                 type: Optional[str] = None,
                 url_path_map: Optional['outputs.SubResourceResponse'] = None):
        """
        Request routing rule of an application gateway.
        :param 'SubResourceResponse' backend_address_pool: Backend address pool resource of the application gateway. 
        :param 'SubResourceResponse' backend_http_settings: Backend http settings resource of the application gateway.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' http_listener: Http listener resource of the application gateway. 
        :param str id: Resource ID.
        :param str name: Name of the request routing rule that is unique within an Application Gateway.
        :param str provisioning_state: Provisioning state of the request routing rule resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'SubResourceResponse' redirect_configuration: Redirect configuration resource of the application gateway.
        :param str rule_type: Rule type.
        :param str type: Type of the resource.
        :param 'SubResourceResponse' url_path_map: URL path map resource of the application gateway.
        """
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_http_settings is not None:
            pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if http_listener is not None:
            pulumi.set(__self__, "http_listener", http_listener)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if redirect_configuration is not None:
            pulumi.set(__self__, "redirect_configuration", redirect_configuration)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if url_path_map is not None:
            pulumi.set(__self__, "url_path_map", url_path_map)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        Backend address pool resource of the application gateway. 
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Backend http settings resource of the application gateway.
        """
        return pulumi.get(self, "backend_http_settings")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="httpListener")
    def http_listener(self) -> Optional['outputs.SubResourceResponse']:
        """
        Http listener resource of the application gateway. 
        """
        return pulumi.get(self, "http_listener")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the request routing rule that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the request routing rule resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="redirectConfiguration")
    def redirect_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Redirect configuration resource of the application gateway.
        """
        return pulumi.get(self, "redirect_configuration")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[str]:
        """
        Rule type.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="urlPathMap")
    def url_path_map(self) -> Optional['outputs.SubResourceResponse']:
        """
        URL path map resource of the application gateway.
        """
        return pulumi.get(self, "url_path_map")


@pulumi.output_type
class ApplicationGatewaySkuResponse(dict):
    """
    SKU of an application gateway
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        SKU of an application gateway
        :param int capacity: Capacity (instance count) of an application gateway.
        :param str name: Name of an application gateway SKU.
        :param str tier: Tier of an application gateway.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Capacity (instance count) of an application gateway.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of an application gateway SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Tier of an application gateway.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class ApplicationGatewaySslCertificateResponse(dict):
    """
    SSL certificates of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicCertData":
            suggest = "public_cert_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewaySslCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewaySslCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewaySslCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 password: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_cert_data: Optional[str] = None,
                 type: Optional[str] = None):
        """
        SSL certificates of an application gateway.
        :param str data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the SSL certificate that is unique within an Application Gateway.
        :param str password: Password for the pfx file specified in data. Only applicable in PUT request.
        :param str provisioning_state: Provisioning state of the SSL certificate resource Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
        :param str type: Type of the resource.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_cert_data is not None:
            pulumi.set(__self__, "public_cert_data", public_cert_data)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        Base-64 encoded pfx certificate. Only applicable in PUT Request.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the SSL certificate that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for the pfx file specified in data. Only applicable in PUT request.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the SSL certificate resource Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> Optional[str]:
        """
        Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
        """
        return pulumi.get(self, "public_cert_data")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationGatewaySslPolicyResponse(dict):
    """
    Application Gateway Ssl policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cipherSuites":
            suggest = "cipher_suites"
        elif key == "disabledSslProtocols":
            suggest = "disabled_ssl_protocols"
        elif key == "minProtocolVersion":
            suggest = "min_protocol_version"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "policyType":
            suggest = "policy_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewaySslPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewaySslPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewaySslPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cipher_suites: Optional[Sequence[str]] = None,
                 disabled_ssl_protocols: Optional[Sequence[str]] = None,
                 min_protocol_version: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 policy_type: Optional[str] = None):
        """
        Application Gateway Ssl policy.
        :param Sequence[str] cipher_suites: Ssl cipher suites to be enabled in the specified order to application gateway.
        :param Sequence[str] disabled_ssl_protocols: Ssl protocols to be disabled on application gateway.
        :param str min_protocol_version: Minimum version of Ssl protocol to be supported on application gateway.
        :param str policy_name: Name of Ssl predefined policy
        :param str policy_type: Type of Ssl Policy
        """
        if cipher_suites is not None:
            pulumi.set(__self__, "cipher_suites", cipher_suites)
        if disabled_ssl_protocols is not None:
            pulumi.set(__self__, "disabled_ssl_protocols", disabled_ssl_protocols)
        if min_protocol_version is not None:
            pulumi.set(__self__, "min_protocol_version", min_protocol_version)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)

    @property
    @pulumi.getter(name="cipherSuites")
    def cipher_suites(self) -> Optional[Sequence[str]]:
        """
        Ssl cipher suites to be enabled in the specified order to application gateway.
        """
        return pulumi.get(self, "cipher_suites")

    @property
    @pulumi.getter(name="disabledSslProtocols")
    def disabled_ssl_protocols(self) -> Optional[Sequence[str]]:
        """
        Ssl protocols to be disabled on application gateway.
        """
        return pulumi.get(self, "disabled_ssl_protocols")

    @property
    @pulumi.getter(name="minProtocolVersion")
    def min_protocol_version(self) -> Optional[str]:
        """
        Minimum version of Ssl protocol to be supported on application gateway.
        """
        return pulumi.get(self, "min_protocol_version")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Name of Ssl predefined policy
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[str]:
        """
        Type of Ssl Policy
        """
        return pulumi.get(self, "policy_type")


@pulumi.output_type
class ApplicationGatewayTrustedRootCertificateResponse(dict):
    """
    Trusted Root certificates of an application gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyvaultSecretId":
            suggest = "keyvault_secret_id"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayTrustedRootCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayTrustedRootCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayTrustedRootCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 keyvault_secret_id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Trusted Root certificates of an application gateway.
        :param str data: Certificate public data.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str keyvault_secret_id: KeyVault Secret Id for certificate.
        :param str name: Name of the trusted root certificate that is unique within an Application Gateway.
        :param str provisioning_state: Provisioning state of the trusted root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str type: Type of the resource.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if keyvault_secret_id is not None:
            pulumi.set(__self__, "keyvault_secret_id", keyvault_secret_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        Certificate public data.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyvaultSecretId")
    def keyvault_secret_id(self) -> Optional[str]:
        """
        KeyVault Secret Id for certificate.
        """
        return pulumi.get(self, "keyvault_secret_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the trusted root certificate that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the trusted root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationGatewayUrlPathMapResponse(dict):
    """
    UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultBackendAddressPool":
            suggest = "default_backend_address_pool"
        elif key == "defaultBackendHttpSettings":
            suggest = "default_backend_http_settings"
        elif key == "defaultRedirectConfiguration":
            suggest = "default_redirect_configuration"
        elif key == "pathRules":
            suggest = "path_rules"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayUrlPathMapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayUrlPathMapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayUrlPathMapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 default_backend_http_settings: Optional['outputs.SubResourceResponse'] = None,
                 default_redirect_configuration: Optional['outputs.SubResourceResponse'] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 path_rules: Optional[Sequence['outputs.ApplicationGatewayPathRuleResponse']] = None,
                 provisioning_state: Optional[str] = None,
                 type: Optional[str] = None):
        """
        UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.
        :param 'SubResourceResponse' default_backend_address_pool: Default backend address pool resource of URL path map.
        :param 'SubResourceResponse' default_backend_http_settings: Default backend http settings resource of URL path map.
        :param 'SubResourceResponse' default_redirect_configuration: Default redirect configuration resource of URL path map.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Name of the URL path map that is unique within an Application Gateway.
        :param Sequence['ApplicationGatewayPathRuleResponse'] path_rules: Path rule of URL path map resource.
        :param str provisioning_state: Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str type: Type of the resource.
        """
        if default_backend_address_pool is not None:
            pulumi.set(__self__, "default_backend_address_pool", default_backend_address_pool)
        if default_backend_http_settings is not None:
            pulumi.set(__self__, "default_backend_http_settings", default_backend_http_settings)
        if default_redirect_configuration is not None:
            pulumi.set(__self__, "default_redirect_configuration", default_redirect_configuration)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_rules is not None:
            pulumi.set(__self__, "path_rules", path_rules)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="defaultBackendAddressPool")
    def default_backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        Default backend address pool resource of URL path map.
        """
        return pulumi.get(self, "default_backend_address_pool")

    @property
    @pulumi.getter(name="defaultBackendHttpSettings")
    def default_backend_http_settings(self) -> Optional['outputs.SubResourceResponse']:
        """
        Default backend http settings resource of URL path map.
        """
        return pulumi.get(self, "default_backend_http_settings")

    @property
    @pulumi.getter(name="defaultRedirectConfiguration")
    def default_redirect_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        Default redirect configuration resource of URL path map.
        """
        return pulumi.get(self, "default_redirect_configuration")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the URL path map that is unique within an Application Gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pathRules")
    def path_rules(self) -> Optional[Sequence['outputs.ApplicationGatewayPathRuleResponse']]:
        """
        Path rule of URL path map resource.
        """
        return pulumi.get(self, "path_rules")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the backend http settings resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApplicationGatewayWebApplicationFirewallConfigurationResponse(dict):
    """
    Application gateway web application firewall configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firewallMode":
            suggest = "firewall_mode"
        elif key == "ruleSetType":
            suggest = "rule_set_type"
        elif key == "ruleSetVersion":
            suggest = "rule_set_version"
        elif key == "disabledRuleGroups":
            suggest = "disabled_rule_groups"
        elif key == "fileUploadLimitInMb":
            suggest = "file_upload_limit_in_mb"
        elif key == "maxRequestBodySize":
            suggest = "max_request_body_size"
        elif key == "maxRequestBodySizeInKb":
            suggest = "max_request_body_size_in_kb"
        elif key == "requestBodyCheck":
            suggest = "request_body_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationGatewayWebApplicationFirewallConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationGatewayWebApplicationFirewallConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationGatewayWebApplicationFirewallConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 firewall_mode: str,
                 rule_set_type: str,
                 rule_set_version: str,
                 disabled_rule_groups: Optional[Sequence['outputs.ApplicationGatewayFirewallDisabledRuleGroupResponse']] = None,
                 exclusions: Optional[Sequence['outputs.ApplicationGatewayFirewallExclusionResponse']] = None,
                 file_upload_limit_in_mb: Optional[int] = None,
                 max_request_body_size: Optional[int] = None,
                 max_request_body_size_in_kb: Optional[int] = None,
                 request_body_check: Optional[bool] = None):
        """
        Application gateway web application firewall configuration.
        :param bool enabled: Whether the web application firewall is enabled or not.
        :param str firewall_mode: Web application firewall mode.
        :param str rule_set_type: The type of the web application firewall rule set. Possible values are: 'OWASP'.
        :param str rule_set_version: The version of the rule set type.
        :param Sequence['ApplicationGatewayFirewallDisabledRuleGroupResponse'] disabled_rule_groups: The disabled rule groups.
        :param Sequence['ApplicationGatewayFirewallExclusionResponse'] exclusions: The exclusion list.
        :param int file_upload_limit_in_mb: Maximum file upload size in Mb for WAF.
        :param int max_request_body_size: Maximum request body size for WAF.
        :param int max_request_body_size_in_kb: Maximum request body size in Kb for WAF.
        :param bool request_body_check: Whether allow WAF to check request Body.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "firewall_mode", firewall_mode)
        pulumi.set(__self__, "rule_set_type", rule_set_type)
        pulumi.set(__self__, "rule_set_version", rule_set_version)
        if disabled_rule_groups is not None:
            pulumi.set(__self__, "disabled_rule_groups", disabled_rule_groups)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if file_upload_limit_in_mb is not None:
            pulumi.set(__self__, "file_upload_limit_in_mb", file_upload_limit_in_mb)
        if max_request_body_size is not None:
            pulumi.set(__self__, "max_request_body_size", max_request_body_size)
        if max_request_body_size_in_kb is not None:
            pulumi.set(__self__, "max_request_body_size_in_kb", max_request_body_size_in_kb)
        if request_body_check is not None:
            pulumi.set(__self__, "request_body_check", request_body_check)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the web application firewall is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="firewallMode")
    def firewall_mode(self) -> str:
        """
        Web application firewall mode.
        """
        return pulumi.get(self, "firewall_mode")

    @property
    @pulumi.getter(name="ruleSetType")
    def rule_set_type(self) -> str:
        """
        The type of the web application firewall rule set. Possible values are: 'OWASP'.
        """
        return pulumi.get(self, "rule_set_type")

    @property
    @pulumi.getter(name="ruleSetVersion")
    def rule_set_version(self) -> str:
        """
        The version of the rule set type.
        """
        return pulumi.get(self, "rule_set_version")

    @property
    @pulumi.getter(name="disabledRuleGroups")
    def disabled_rule_groups(self) -> Optional[Sequence['outputs.ApplicationGatewayFirewallDisabledRuleGroupResponse']]:
        """
        The disabled rule groups.
        """
        return pulumi.get(self, "disabled_rule_groups")

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence['outputs.ApplicationGatewayFirewallExclusionResponse']]:
        """
        The exclusion list.
        """
        return pulumi.get(self, "exclusions")

    @property
    @pulumi.getter(name="fileUploadLimitInMb")
    def file_upload_limit_in_mb(self) -> Optional[int]:
        """
        Maximum file upload size in Mb for WAF.
        """
        return pulumi.get(self, "file_upload_limit_in_mb")

    @property
    @pulumi.getter(name="maxRequestBodySize")
    def max_request_body_size(self) -> Optional[int]:
        """
        Maximum request body size for WAF.
        """
        return pulumi.get(self, "max_request_body_size")

    @property
    @pulumi.getter(name="maxRequestBodySizeInKb")
    def max_request_body_size_in_kb(self) -> Optional[int]:
        """
        Maximum request body size in Kb for WAF.
        """
        return pulumi.get(self, "max_request_body_size_in_kb")

    @property
    @pulumi.getter(name="requestBodyCheck")
    def request_body_check(self) -> Optional[bool]:
        """
        Whether allow WAF to check request Body.
        """
        return pulumi.get(self, "request_body_check")


@pulumi.output_type
class ApplicationSecurityGroupResponse(dict):
    """
    An application security group in a resource group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationSecurityGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationSecurityGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationSecurityGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 name: str,
                 provisioning_state: str,
                 resource_guid: str,
                 type: str,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        An application security group in a resource group.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the application security group resource. Possible values are: 'Succeeded', 'Updating', 'Deleting', and 'Failed'.
        :param str resource_guid: The resource GUID property of the application security group resource. It uniquely identifies a resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
        :param str type: Resource type.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the application security group resource. Possible values are: 'Succeeded', 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resource GUID property of the application security group resource. It uniquely identifies a resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class AzureFirewallApplicationRuleCollectionResponse(dict):
    """
    Application rule collection resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallApplicationRuleCollectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallApplicationRuleCollectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallApplicationRuleCollectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 action: Optional['outputs.AzureFirewallRCActionResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 rules: Optional[Sequence['outputs.AzureFirewallApplicationRuleResponse']] = None):
        """
        Application rule collection resource
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the resource.
        :param 'AzureFirewallRCActionResponse' action: The action type of a rule collection
        :param str id: Resource ID.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int priority: Priority of the application rule collection resource.
        :param Sequence['AzureFirewallApplicationRuleResponse'] rules: Collection of rules used by a application rule collection.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.AzureFirewallRCActionResponse']:
        """
        The action type of a rule collection
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of the application rule collection resource.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.AzureFirewallApplicationRuleResponse']]:
        """
        Collection of rules used by a application rule collection.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class AzureFirewallApplicationRuleProtocolResponse(dict):
    """
    Properties of the application rule protocol.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolType":
            suggest = "protocol_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallApplicationRuleProtocolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallApplicationRuleProtocolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallApplicationRuleProtocolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: Optional[int] = None,
                 protocol_type: Optional[str] = None):
        """
        Properties of the application rule protocol.
        :param int port: Port number for the protocol, cannot be greater than 64000. This field is optional.
        :param str protocol_type: Protocol type
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port number for the protocol, cannot be greater than 64000. This field is optional.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[str]:
        """
        Protocol type
        """
        return pulumi.get(self, "protocol_type")


@pulumi.output_type
class AzureFirewallApplicationRuleResponse(dict):
    """
    Properties of an application rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fqdnTags":
            suggest = "fqdn_tags"
        elif key == "sourceAddresses":
            suggest = "source_addresses"
        elif key == "targetFqdns":
            suggest = "target_fqdns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallApplicationRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallApplicationRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallApplicationRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 fqdn_tags: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 protocols: Optional[Sequence['outputs.AzureFirewallApplicationRuleProtocolResponse']] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 target_fqdns: Optional[Sequence[str]] = None):
        """
        Properties of an application rule.
        :param str description: Description of the rule.
        :param Sequence[str] fqdn_tags: List of FQDN Tags for this rule.
        :param str name: Name of the application rule.
        :param Sequence['AzureFirewallApplicationRuleProtocolResponse'] protocols: Array of ApplicationRuleProtocols.
        :param Sequence[str] source_addresses: List of source IP addresses for this rule.
        :param Sequence[str] target_fqdns: List of FQDNs for this rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fqdn_tags is not None:
            pulumi.set(__self__, "fqdn_tags", fqdn_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if target_fqdns is not None:
            pulumi.set(__self__, "target_fqdns", target_fqdns)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fqdnTags")
    def fqdn_tags(self) -> Optional[Sequence[str]]:
        """
        List of FQDN Tags for this rule.
        """
        return pulumi.get(self, "fqdn_tags")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the application rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence['outputs.AzureFirewallApplicationRuleProtocolResponse']]:
        """
        Array of ApplicationRuleProtocols.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="targetFqdns")
    def target_fqdns(self) -> Optional[Sequence[str]]:
        """
        List of FQDNs for this rule.
        """
        return pulumi.get(self, "target_fqdns")


@pulumi.output_type
class AzureFirewallIPConfigurationResponse(dict):
    """
    IP configuration of an Azure Firewall.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 public_ip_address: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        IP configuration of an Azure Firewall.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the resource.
        :param str id: Resource ID.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_ip_address: The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes.
        :param 'SubResourceResponse' public_ip_address: Reference of the PublicIP resource. This field is a mandatory input if subnet is not null.
        :param 'SubResourceResponse' subnet: Reference of the subnet resource. This resource must be named 'AzureFirewallSubnet'.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The Firewall Internal Load Balancer IP to be used as the next hop in User Defined Routes.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference of the PublicIP resource. This field is a mandatory input if subnet is not null.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference of the subnet resource. This resource must be named 'AzureFirewallSubnet'.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class AzureFirewallNatRCActionResponse(dict):
    """
    AzureFirewall NAT Rule Collection Action.
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        AzureFirewall NAT Rule Collection Action.
        :param str type: The type of action.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AzureFirewallNatRuleCollectionResponse(dict):
    """
    NAT rule collection resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallNatRuleCollectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallNatRuleCollectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallNatRuleCollectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 action: Optional['outputs.AzureFirewallNatRCActionResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 rules: Optional[Sequence['outputs.AzureFirewallNatRuleResponse']] = None):
        """
        NAT rule collection resource
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the resource.
        :param 'AzureFirewallNatRCActionResponse' action: The action type of a NAT rule collection
        :param str id: Resource ID.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int priority: Priority of the NAT rule collection resource.
        :param Sequence['AzureFirewallNatRuleResponse'] rules: Collection of rules used by a NAT rule collection.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.AzureFirewallNatRCActionResponse']:
        """
        The action type of a NAT rule collection
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of the NAT rule collection resource.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.AzureFirewallNatRuleResponse']]:
        """
        Collection of rules used by a NAT rule collection.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class AzureFirewallNatRuleResponse(dict):
    """
    Properties of a NAT rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "destinationPorts":
            suggest = "destination_ports"
        elif key == "sourceAddresses":
            suggest = "source_addresses"
        elif key == "translatedAddress":
            suggest = "translated_address"
        elif key == "translatedPort":
            suggest = "translated_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallNatRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallNatRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallNatRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 destination_addresses: Optional[Sequence[str]] = None,
                 destination_ports: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 protocols: Optional[Sequence[str]] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 translated_address: Optional[str] = None,
                 translated_port: Optional[str] = None):
        """
        Properties of a NAT rule.
        :param str description: Description of the rule.
        :param Sequence[str] destination_addresses: List of destination IP addresses for this rule.
        :param Sequence[str] destination_ports: List of destination ports.
        :param str name: Name of the NAT rule.
        :param Sequence[str] protocols: Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
        :param Sequence[str] source_addresses: List of source IP addresses for this rule.
        :param str translated_address: The translated address for this NAT rule.
        :param str translated_port: The translated port for this NAT rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if translated_address is not None:
            pulumi.set(__self__, "translated_address", translated_address)
        if translated_port is not None:
            pulumi.set(__self__, "translated_port", translated_port)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        List of destination IP addresses for this rule.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[Sequence[str]]:
        """
        List of destination ports.
        """
        return pulumi.get(self, "destination_ports")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the NAT rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[str]]:
        """
        Array of AzureFirewallNetworkRuleProtocols applicable to this NAT rule.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="translatedAddress")
    def translated_address(self) -> Optional[str]:
        """
        The translated address for this NAT rule.
        """
        return pulumi.get(self, "translated_address")

    @property
    @pulumi.getter(name="translatedPort")
    def translated_port(self) -> Optional[str]:
        """
        The translated port for this NAT rule.
        """
        return pulumi.get(self, "translated_port")


@pulumi.output_type
class AzureFirewallNetworkRuleCollectionResponse(dict):
    """
    Network rule collection resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallNetworkRuleCollectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallNetworkRuleCollectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallNetworkRuleCollectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 action: Optional['outputs.AzureFirewallRCActionResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 rules: Optional[Sequence['outputs.AzureFirewallNetworkRuleResponse']] = None):
        """
        Network rule collection resource
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the resource.
        :param 'AzureFirewallRCActionResponse' action: The action type of a rule collection
        :param str id: Resource ID.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int priority: Priority of the network rule collection resource.
        :param Sequence['AzureFirewallNetworkRuleResponse'] rules: Collection of rules used by a network rule collection.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.AzureFirewallRCActionResponse']:
        """
        The action type of a rule collection
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of the network rule collection resource.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.AzureFirewallNetworkRuleResponse']]:
        """
        Collection of rules used by a network rule collection.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class AzureFirewallNetworkRuleResponse(dict):
    """
    Properties of the network rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "destinationPorts":
            suggest = "destination_ports"
        elif key == "sourceAddresses":
            suggest = "source_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFirewallNetworkRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFirewallNetworkRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFirewallNetworkRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 destination_addresses: Optional[Sequence[str]] = None,
                 destination_ports: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 protocols: Optional[Sequence[str]] = None,
                 source_addresses: Optional[Sequence[str]] = None):
        """
        Properties of the network rule.
        :param str description: Description of the rule.
        :param Sequence[str] destination_addresses: List of destination IP addresses.
        :param Sequence[str] destination_ports: List of destination ports.
        :param str name: Name of the network rule.
        :param Sequence[str] protocols: Array of AzureFirewallNetworkRuleProtocols.
        :param Sequence[str] source_addresses: List of source IP addresses for this rule.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_ports is not None:
            pulumi.set(__self__, "destination_ports", destination_ports)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        List of destination IP addresses.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="destinationPorts")
    def destination_ports(self) -> Optional[Sequence[str]]:
        """
        List of destination ports.
        """
        return pulumi.get(self, "destination_ports")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the network rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence[str]]:
        """
        Array of AzureFirewallNetworkRuleProtocols.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        List of source IP addresses for this rule.
        """
        return pulumi.get(self, "source_addresses")


@pulumi.output_type
class AzureFirewallRCActionResponse(dict):
    """
    Properties of the AzureFirewallRCAction.
    """
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        Properties of the AzureFirewallRCAction.
        :param str type: The type of action.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class BackendAddressPoolResponse(dict):
    """
    Pool of backend IP addresses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendIPConfigurations":
            suggest = "backend_ip_configurations"
        elif key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "outboundRule":
            suggest = "outbound_rule"
        elif key == "outboundRules":
            suggest = "outbound_rules"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendAddressPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendAddressPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendAddressPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_ip_configurations: Sequence['outputs.NetworkInterfaceIPConfigurationResponse'],
                 load_balancing_rules: Sequence['outputs.SubResourceResponse'],
                 outbound_rule: 'outputs.SubResourceResponse',
                 outbound_rules: Sequence['outputs.SubResourceResponse'],
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Pool of backend IP addresses.
        :param Sequence['NetworkInterfaceIPConfigurationResponse'] backend_ip_configurations: Gets collection of references to IP addresses defined in network interfaces.
        :param Sequence['SubResourceResponse'] load_balancing_rules: Gets load balancing rules that use this backend address pool.
        :param 'SubResourceResponse' outbound_rule: Gets outbound rules that use this backend address pool.
        :param Sequence['SubResourceResponse'] outbound_rules: Gets outbound rules that use this backend address pool.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Get provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "backend_ip_configurations", backend_ip_configurations)
        pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        pulumi.set(__self__, "outbound_rule", outbound_rule)
        pulumi.set(__self__, "outbound_rules", outbound_rules)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendIPConfigurations")
    def backend_ip_configurations(self) -> Sequence['outputs.NetworkInterfaceIPConfigurationResponse']:
        """
        Gets collection of references to IP addresses defined in network interfaces.
        """
        return pulumi.get(self, "backend_ip_configurations")

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        Gets load balancing rules that use this backend address pool.
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter(name="outboundRule")
    def outbound_rule(self) -> 'outputs.SubResourceResponse':
        """
        Gets outbound rules that use this backend address pool.
        """
        return pulumi.get(self, "outbound_rule")

    @property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        Gets outbound rules that use this backend address pool.
        """
        return pulumi.get(self, "outbound_rules")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Get provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class BgpPeerStatusResponse(dict):
    """
    BGP peer status details
    """
    def __init__(__self__, *,
                 asn: int,
                 connected_duration: str,
                 local_address: str,
                 messages_received: float,
                 messages_sent: float,
                 neighbor: str,
                 routes_received: float,
                 state: str):
        """
        BGP peer status details
        :param int asn: The autonomous system number of the remote BGP peer
        :param str connected_duration: For how long the peering has been up
        :param str local_address: The virtual network gateway's local address
        :param float messages_received: The number of BGP messages received
        :param float messages_sent: The number of BGP messages sent
        :param str neighbor: The remote BGP peer
        :param float routes_received: The number of routes learned from this peer
        :param str state: The BGP peer state
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "connected_duration", connected_duration)
        pulumi.set(__self__, "local_address", local_address)
        pulumi.set(__self__, "messages_received", messages_received)
        pulumi.set(__self__, "messages_sent", messages_sent)
        pulumi.set(__self__, "neighbor", neighbor)
        pulumi.set(__self__, "routes_received", routes_received)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def asn(self) -> int:
        """
        The autonomous system number of the remote BGP peer
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="connectedDuration")
    def connected_duration(self) -> str:
        """
        For how long the peering has been up
        """
        return pulumi.get(self, "connected_duration")

    @property
    @pulumi.getter(name="localAddress")
    def local_address(self) -> str:
        """
        The virtual network gateway's local address
        """
        return pulumi.get(self, "local_address")

    @property
    @pulumi.getter(name="messagesReceived")
    def messages_received(self) -> float:
        """
        The number of BGP messages received
        """
        return pulumi.get(self, "messages_received")

    @property
    @pulumi.getter(name="messagesSent")
    def messages_sent(self) -> float:
        """
        The number of BGP messages sent
        """
        return pulumi.get(self, "messages_sent")

    @property
    @pulumi.getter
    def neighbor(self) -> str:
        """
        The remote BGP peer
        """
        return pulumi.get(self, "neighbor")

    @property
    @pulumi.getter(name="routesReceived")
    def routes_received(self) -> float:
        """
        The number of routes learned from this peer
        """
        return pulumi.get(self, "routes_received")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The BGP peer state
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class BgpSettingsResponse(dict):
    """
    BGP settings details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bgpPeeringAddress":
            suggest = "bgp_peering_address"
        elif key == "peerWeight":
            suggest = "peer_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BgpSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BgpSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BgpSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asn: Optional[float] = None,
                 bgp_peering_address: Optional[str] = None,
                 peer_weight: Optional[int] = None):
        """
        BGP settings details
        :param float asn: The BGP speaker's ASN.
        :param str bgp_peering_address: The BGP peering address and BGP identifier of this BGP speaker.
        :param int peer_weight: The weight added to routes learned from this BGP speaker.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if bgp_peering_address is not None:
            pulumi.set(__self__, "bgp_peering_address", bgp_peering_address)
        if peer_weight is not None:
            pulumi.set(__self__, "peer_weight", peer_weight)

    @property
    @pulumi.getter
    def asn(self) -> Optional[float]:
        """
        The BGP speaker's ASN.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="bgpPeeringAddress")
    def bgp_peering_address(self) -> Optional[str]:
        """
        The BGP peering address and BGP identifier of this BGP speaker.
        """
        return pulumi.get(self, "bgp_peering_address")

    @property
    @pulumi.getter(name="peerWeight")
    def peer_weight(self) -> Optional[int]:
        """
        The weight added to routes learned from this BGP speaker.
        """
        return pulumi.get(self, "peer_weight")


@pulumi.output_type
class ConnectionMonitorDestinationResponse(dict):
    """
    Describes the destination of connection monitor.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 port: Optional[int] = None,
                 resource_id: Optional[str] = None):
        """
        Describes the destination of connection monitor.
        :param str address: Address of the connection monitor destination (IP or domain name).
        :param int port: The destination port used by connection monitor.
        :param str resource_id: The ID of the resource used as the destination by connection monitor.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Address of the connection monitor destination (IP or domain name).
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The destination port used by connection monitor.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The ID of the resource used as the destination by connection monitor.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ConnectionMonitorSourceResponse(dict):
    """
    Describes the source of connection monitor.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionMonitorSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionMonitorSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionMonitorSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: str,
                 port: Optional[int] = None):
        """
        Describes the source of connection monitor.
        :param str resource_id: The ID of the resource used as the source by connection monitor.
        :param int port: The source port used by connection monitor.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The ID of the resource used as the source by connection monitor.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The source port used by connection monitor.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ContainerNetworkInterfaceConfigurationResponse(dict):
    """
    Container network interface configuration child resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "containerNetworkInterfaces":
            suggest = "container_network_interfaces"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerNetworkInterfaceConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerNetworkInterfaceConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerNetworkInterfaceConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 type: str,
                 container_network_interfaces: Optional[Sequence['outputs.ContainerNetworkInterfaceResponse']] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 ip_configurations: Optional[Sequence['outputs.IPConfigurationProfileResponse']] = None,
                 name: Optional[str] = None):
        """
        Container network interface configuration child resource.
        :param str provisioning_state: The provisioning state of the resource.
        :param str type: Sub Resource type.
        :param Sequence['ContainerNetworkInterfaceResponse'] container_network_interfaces: A list of container network interfaces created from this container network interface configuration.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param Sequence['IPConfigurationProfileResponse'] ip_configurations: A list of ip configurations of the container network interface configuration.
        :param str name: The name of the resource. This name can be used to access the resource.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if container_network_interfaces is not None:
            pulumi.set(__self__, "container_network_interfaces", container_network_interfaces)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Sub Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="containerNetworkInterfaces")
    def container_network_interfaces(self) -> Optional[Sequence['outputs.ContainerNetworkInterfaceResponse']]:
        """
        A list of container network interfaces created from this container network interface configuration.
        """
        return pulumi.get(self, "container_network_interfaces")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.IPConfigurationProfileResponse']]:
        """
        A list of ip configurations of the container network interface configuration.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContainerNetworkInterfaceIpConfigurationResponse(dict):
    """
    The ip configuration for a container network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerNetworkInterfaceIpConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerNetworkInterfaceIpConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerNetworkInterfaceIpConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 type: str,
                 etag: Optional[str] = None,
                 name: Optional[str] = None):
        """
        The ip configuration for a container network interface.
        :param str provisioning_state: The provisioning state of the resource.
        :param str type: Sub Resource type.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str name: The name of the resource. This name can be used to access the resource.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Sub Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContainerNetworkInterfaceResponse(dict):
    """
    Container network interface child resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "containerNetworkInterfaceConfiguration":
            suggest = "container_network_interface_configuration"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerNetworkInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerNetworkInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerNetworkInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 type: str,
                 container: Optional['outputs.ContainerResponse'] = None,
                 container_network_interface_configuration: Optional['outputs.ContainerNetworkInterfaceConfigurationResponse'] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 ip_configurations: Optional[Sequence['outputs.ContainerNetworkInterfaceIpConfigurationResponse']] = None,
                 name: Optional[str] = None):
        """
        Container network interface child resource.
        :param str provisioning_state: The provisioning state of the resource.
        :param str type: Sub Resource type.
        :param 'ContainerResponse' container: Reference to the container to which this container network interface is attached.
        :param 'ContainerNetworkInterfaceConfigurationResponse' container_network_interface_configuration: Container network interface configuration from which this container network interface is created.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param Sequence['ContainerNetworkInterfaceIpConfigurationResponse'] ip_configurations: Reference to the ip configuration on this container nic.
        :param str name: The name of the resource. This name can be used to access the resource.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if container_network_interface_configuration is not None:
            pulumi.set(__self__, "container_network_interface_configuration", container_network_interface_configuration)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Sub Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def container(self) -> Optional['outputs.ContainerResponse']:
        """
        Reference to the container to which this container network interface is attached.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="containerNetworkInterfaceConfiguration")
    def container_network_interface_configuration(self) -> Optional['outputs.ContainerNetworkInterfaceConfigurationResponse']:
        """
        Container network interface configuration from which this container network interface is created.
        """
        return pulumi.get(self, "container_network_interface_configuration")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.ContainerNetworkInterfaceIpConfigurationResponse']]:
        """
        Reference to the ip configuration on this container nic.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContainerResponse(dict):
    """
    Reference to container resource in remote resource provider.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Reference to container resource in remote resource provider.
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class DelegationResponse(dict):
    """
    Details the service to which the subnet is delegated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DelegationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DelegationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DelegationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 actions: Optional[Sequence[str]] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 service_name: Optional[str] = None):
        """
        Details the service to which the subnet is delegated.
        :param str provisioning_state: The provisioning state of the resource.
        :param Sequence[str] actions: Describes the actions permitted to the service upon delegation
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a subnet. This name can be used to access the resource.
        :param str service_name: The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers)
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence[str]]:
        """
        Describes the actions permitted to the service upon delegation
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a subnet. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers)
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class DevicePropertiesResponse(dict):
    """
    List of properties of the device.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceModel":
            suggest = "device_model"
        elif key == "deviceVendor":
            suggest = "device_vendor"
        elif key == "linkSpeedInMbps":
            suggest = "link_speed_in_mbps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DevicePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DevicePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DevicePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_model: Optional[str] = None,
                 device_vendor: Optional[str] = None,
                 link_speed_in_mbps: Optional[int] = None):
        """
        List of properties of the device.
        :param str device_model: Model of the device.
        :param str device_vendor: Name of the device Vendor.
        :param int link_speed_in_mbps: Link speed.
        """
        if device_model is not None:
            pulumi.set(__self__, "device_model", device_model)
        if device_vendor is not None:
            pulumi.set(__self__, "device_vendor", device_vendor)
        if link_speed_in_mbps is not None:
            pulumi.set(__self__, "link_speed_in_mbps", link_speed_in_mbps)

    @property
    @pulumi.getter(name="deviceModel")
    def device_model(self) -> Optional[str]:
        """
        Model of the device.
        """
        return pulumi.get(self, "device_model")

    @property
    @pulumi.getter(name="deviceVendor")
    def device_vendor(self) -> Optional[str]:
        """
        Name of the device Vendor.
        """
        return pulumi.get(self, "device_vendor")

    @property
    @pulumi.getter(name="linkSpeedInMbps")
    def link_speed_in_mbps(self) -> Optional[int]:
        """
        Link speed.
        """
        return pulumi.get(self, "link_speed_in_mbps")


@pulumi.output_type
class DhcpOptionsResponse(dict):
    """
    DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServers":
            suggest = "dns_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DhcpOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DhcpOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DhcpOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_servers: Optional[Sequence[str]] = None):
        """
        DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
        :param Sequence[str] dns_servers: The list of DNS servers IP addresses.
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        The list of DNS servers IP addresses.
        """
        return pulumi.get(self, "dns_servers")


@pulumi.output_type
class DnsConfigResponse(dict):
    """
    Class containing DNS settings in a Traffic Manager profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relativeName":
            suggest = "relative_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DnsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DnsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DnsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: str,
                 relative_name: Optional[str] = None,
                 ttl: Optional[float] = None):
        """
        Class containing DNS settings in a Traffic Manager profile.
        :param str fqdn: The fully-qualified domain name (FQDN) of the Traffic Manager profile. This is formed from the concatenation of the RelativeName with the DNS domain used by Azure Traffic Manager.
        :param str relative_name: The relative DNS name provided by this Traffic Manager profile. This value is combined with the DNS domain name used by Azure Traffic Manager to form the fully-qualified domain name (FQDN) of the profile.
        :param float ttl: The DNS Time-To-Live (TTL), in seconds. This informs the local DNS resolvers and DNS clients how long to cache DNS responses provided by this Traffic Manager profile.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        if relative_name is not None:
            pulumi.set(__self__, "relative_name", relative_name)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        The fully-qualified domain name (FQDN) of the Traffic Manager profile. This is formed from the concatenation of the RelativeName with the DNS domain used by Azure Traffic Manager.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="relativeName")
    def relative_name(self) -> Optional[str]:
        """
        The relative DNS name provided by this Traffic Manager profile. This value is combined with the DNS domain name used by Azure Traffic Manager to form the fully-qualified domain name (FQDN) of the profile.
        """
        return pulumi.get(self, "relative_name")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[float]:
        """
        The DNS Time-To-Live (TTL), in seconds. This informs the local DNS resolvers and DNS clients how long to cache DNS responses provided by this Traffic Manager profile.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class EndpointPropertiesResponseCustomHeaders(dict):
    """
    Custom header name and value.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Custom header name and value.
        :param str name: Header name.
        :param str value: Header value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Header name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EndpointPropertiesResponseSubnets(dict):
    """
    Subnet first address, scope, and/or last address.
    """
    def __init__(__self__, *,
                 first: Optional[str] = None,
                 last: Optional[str] = None,
                 scope: Optional[int] = None):
        """
        Subnet first address, scope, and/or last address.
        :param str first: First address in the subnet.
        :param str last: Last address in the subnet.
        :param int scope: Block size (number of leading bits in the subnet mask).
        """
        if first is not None:
            pulumi.set(__self__, "first", first)
        if last is not None:
            pulumi.set(__self__, "last", last)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def first(self) -> Optional[str]:
        """
        First address in the subnet.
        """
        return pulumi.get(self, "first")

    @property
    @pulumi.getter
    def last(self) -> Optional[str]:
        """
        Last address in the subnet.
        """
        return pulumi.get(self, "last")

    @property
    @pulumi.getter
    def scope(self) -> Optional[int]:
        """
        Block size (number of leading bits in the subnet mask).
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class EndpointResponse(dict):
    """
    Class representing a Traffic Manager endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customHeaders":
            suggest = "custom_headers"
        elif key == "endpointLocation":
            suggest = "endpoint_location"
        elif key == "endpointMonitorStatus":
            suggest = "endpoint_monitor_status"
        elif key == "endpointStatus":
            suggest = "endpoint_status"
        elif key == "geoMapping":
            suggest = "geo_mapping"
        elif key == "minChildEndpoints":
            suggest = "min_child_endpoints"
        elif key == "minChildEndpointsIPv4":
            suggest = "min_child_endpoints_i_pv4"
        elif key == "minChildEndpointsIPv6":
            suggest = "min_child_endpoints_i_pv6"
        elif key == "targetResourceId":
            suggest = "target_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_headers: Optional[Sequence['outputs.EndpointPropertiesResponseCustomHeaders']] = None,
                 endpoint_location: Optional[str] = None,
                 endpoint_monitor_status: Optional[str] = None,
                 endpoint_status: Optional[str] = None,
                 geo_mapping: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 min_child_endpoints: Optional[float] = None,
                 min_child_endpoints_i_pv4: Optional[float] = None,
                 min_child_endpoints_i_pv6: Optional[float] = None,
                 name: Optional[str] = None,
                 priority: Optional[float] = None,
                 subnets: Optional[Sequence['outputs.EndpointPropertiesResponseSubnets']] = None,
                 target: Optional[str] = None,
                 target_resource_id: Optional[str] = None,
                 type: Optional[str] = None,
                 weight: Optional[float] = None):
        """
        Class representing a Traffic Manager endpoint.
        :param Sequence['EndpointPropertiesResponseCustomHeaders'] custom_headers: List of custom headers.
        :param str endpoint_location: Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
        :param str endpoint_monitor_status: The monitoring status of the endpoint.
        :param str endpoint_status: The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
        :param Sequence[str] geo_mapping: The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
        :param str id: Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
        :param float min_child_endpoints: The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
        :param float min_child_endpoints_i_pv4: The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
        :param float min_child_endpoints_i_pv6: The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
        :param str name: The name of the resource
        :param float priority: The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
        :param Sequence['EndpointPropertiesResponseSubnets'] subnets: The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
        :param str target: The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
        :param str target_resource_id: The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
        :param str type: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
        :param float weight: The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
        """
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if endpoint_location is not None:
            pulumi.set(__self__, "endpoint_location", endpoint_location)
        if endpoint_monitor_status is not None:
            pulumi.set(__self__, "endpoint_monitor_status", endpoint_monitor_status)
        if endpoint_status is not None:
            pulumi.set(__self__, "endpoint_status", endpoint_status)
        if geo_mapping is not None:
            pulumi.set(__self__, "geo_mapping", geo_mapping)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if min_child_endpoints is not None:
            pulumi.set(__self__, "min_child_endpoints", min_child_endpoints)
        if min_child_endpoints_i_pv4 is not None:
            pulumi.set(__self__, "min_child_endpoints_i_pv4", min_child_endpoints_i_pv4)
        if min_child_endpoints_i_pv6 is not None:
            pulumi.set(__self__, "min_child_endpoints_i_pv6", min_child_endpoints_i_pv6)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[Sequence['outputs.EndpointPropertiesResponseCustomHeaders']]:
        """
        List of custom headers.
        """
        return pulumi.get(self, "custom_headers")

    @property
    @pulumi.getter(name="endpointLocation")
    def endpoint_location(self) -> Optional[str]:
        """
        Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
        """
        return pulumi.get(self, "endpoint_location")

    @property
    @pulumi.getter(name="endpointMonitorStatus")
    def endpoint_monitor_status(self) -> Optional[str]:
        """
        The monitoring status of the endpoint.
        """
        return pulumi.get(self, "endpoint_monitor_status")

    @property
    @pulumi.getter(name="endpointStatus")
    def endpoint_status(self) -> Optional[str]:
        """
        The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
        """
        return pulumi.get(self, "endpoint_status")

    @property
    @pulumi.getter(name="geoMapping")
    def geo_mapping(self) -> Optional[Sequence[str]]:
        """
        The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
        """
        return pulumi.get(self, "geo_mapping")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="minChildEndpoints")
    def min_child_endpoints(self) -> Optional[float]:
        """
        The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
        """
        return pulumi.get(self, "min_child_endpoints")

    @property
    @pulumi.getter(name="minChildEndpointsIPv4")
    def min_child_endpoints_i_pv4(self) -> Optional[float]:
        """
        The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
        """
        return pulumi.get(self, "min_child_endpoints_i_pv4")

    @property
    @pulumi.getter(name="minChildEndpointsIPv6")
    def min_child_endpoints_i_pv6(self) -> Optional[float]:
        """
        The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
        """
        return pulumi.get(self, "min_child_endpoints_i_pv6")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[float]:
        """
        The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def subnets(self) -> Optional[Sequence['outputs.EndpointPropertiesResponseSubnets']]:
        """
        The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[str]:
        """
        The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def weight(self) -> Optional[float]:
        """
        The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class EndpointServiceResponse(dict):
    """
    Identifies the service being brought into the virtual network.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Identifies the service being brought into the virtual network.
        :param str id: A unique identifier of the service being referenced by the interface endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique identifier of the service being referenced by the interface endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ExpressRouteCircuitAuthorizationResponse(dict):
    """
    Authorization in an ExpressRouteCircuit resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationKey":
            suggest = "authorization_key"
        elif key == "authorizationUseStatus":
            suggest = "authorization_use_status"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitAuthorizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitAuthorizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitAuthorizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 authorization_key: Optional[str] = None,
                 authorization_use_status: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Authorization in an ExpressRouteCircuit resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str authorization_key: The authorization key.
        :param str authorization_use_status: AuthorizationUseStatus. Possible values are: 'Available' and 'InUse'.
        :param str id: Resource ID.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "etag", etag)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if authorization_use_status is not None:
            pulumi.set(__self__, "authorization_use_status", authorization_use_status)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[str]:
        """
        The authorization key.
        """
        return pulumi.get(self, "authorization_key")

    @property
    @pulumi.getter(name="authorizationUseStatus")
    def authorization_use_status(self) -> Optional[str]:
        """
        AuthorizationUseStatus. Possible values are: 'Available' and 'InUse'.
        """
        return pulumi.get(self, "authorization_use_status")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ExpressRouteCircuitConnectionResponse(dict):
    """
    Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "circuitConnectionStatus":
            suggest = "circuit_connection_status"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "authorizationKey":
            suggest = "authorization_key"
        elif key == "expressRouteCircuitPeering":
            suggest = "express_route_circuit_peering"
        elif key == "peerExpressRouteCircuitPeering":
            suggest = "peer_express_route_circuit_peering"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 circuit_connection_status: str,
                 etag: str,
                 provisioning_state: str,
                 address_prefix: Optional[str] = None,
                 authorization_key: Optional[str] = None,
                 express_route_circuit_peering: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 peer_express_route_circuit_peering: Optional['outputs.SubResourceResponse'] = None):
        """
        Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
        :param str circuit_connection_status: Express Route Circuit Connection State. Possible values are: 'Connected' and 'Disconnected'.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: Provisioning state of the circuit connection resource. Possible values are: 'Succeeded', 'Updating', 'Deleting', and 'Failed'.
        :param str address_prefix: /29 IP address space to carve out Customer addresses for tunnels.
        :param str authorization_key: The authorization key.
        :param 'SubResourceResponse' express_route_circuit_peering: Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
        :param str id: Resource ID.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'SubResourceResponse' peer_express_route_circuit_peering: Reference to Express Route Circuit Private Peering Resource of the peered circuit.
        """
        pulumi.set(__self__, "circuit_connection_status", circuit_connection_status)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if express_route_circuit_peering is not None:
            pulumi.set(__self__, "express_route_circuit_peering", express_route_circuit_peering)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_express_route_circuit_peering is not None:
            pulumi.set(__self__, "peer_express_route_circuit_peering", peer_express_route_circuit_peering)

    @property
    @pulumi.getter(name="circuitConnectionStatus")
    def circuit_connection_status(self) -> str:
        """
        Express Route Circuit Connection State. Possible values are: 'Connected' and 'Disconnected'.
        """
        return pulumi.get(self, "circuit_connection_status")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the circuit connection resource. Possible values are: 'Succeeded', 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        /29 IP address space to carve out Customer addresses for tunnels.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[str]:
        """
        The authorization key.
        """
        return pulumi.get(self, "authorization_key")

    @property
    @pulumi.getter(name="expressRouteCircuitPeering")
    def express_route_circuit_peering(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to Express Route Circuit Private Peering Resource of the circuit initiating connection.
        """
        return pulumi.get(self, "express_route_circuit_peering")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerExpressRouteCircuitPeering")
    def peer_express_route_circuit_peering(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to Express Route Circuit Private Peering Resource of the peered circuit.
        """
        return pulumi.get(self, "peer_express_route_circuit_peering")


@pulumi.output_type
class ExpressRouteCircuitPeeringConfigResponse(dict):
    """
    Specifies the peering configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advertisedCommunities":
            suggest = "advertised_communities"
        elif key == "advertisedPublicPrefixes":
            suggest = "advertised_public_prefixes"
        elif key == "advertisedPublicPrefixesState":
            suggest = "advertised_public_prefixes_state"
        elif key == "customerASN":
            suggest = "customer_asn"
        elif key == "legacyMode":
            suggest = "legacy_mode"
        elif key == "routingRegistryName":
            suggest = "routing_registry_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitPeeringConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advertised_communities: Optional[Sequence[str]] = None,
                 advertised_public_prefixes: Optional[Sequence[str]] = None,
                 advertised_public_prefixes_state: Optional[str] = None,
                 customer_asn: Optional[int] = None,
                 legacy_mode: Optional[int] = None,
                 routing_registry_name: Optional[str] = None):
        """
        Specifies the peering configuration.
        :param Sequence[str] advertised_communities: The communities of bgp peering. Specified for microsoft peering
        :param Sequence[str] advertised_public_prefixes: The reference of AdvertisedPublicPrefixes.
        :param str advertised_public_prefixes_state: AdvertisedPublicPrefixState of the Peering resource. Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'.
        :param int customer_asn: The CustomerASN of the peering.
        :param int legacy_mode: The legacy mode of the peering.
        :param str routing_registry_name: The RoutingRegistryName of the configuration.
        """
        if advertised_communities is not None:
            pulumi.set(__self__, "advertised_communities", advertised_communities)
        if advertised_public_prefixes is not None:
            pulumi.set(__self__, "advertised_public_prefixes", advertised_public_prefixes)
        if advertised_public_prefixes_state is not None:
            pulumi.set(__self__, "advertised_public_prefixes_state", advertised_public_prefixes_state)
        if customer_asn is not None:
            pulumi.set(__self__, "customer_asn", customer_asn)
        if legacy_mode is not None:
            pulumi.set(__self__, "legacy_mode", legacy_mode)
        if routing_registry_name is not None:
            pulumi.set(__self__, "routing_registry_name", routing_registry_name)

    @property
    @pulumi.getter(name="advertisedCommunities")
    def advertised_communities(self) -> Optional[Sequence[str]]:
        """
        The communities of bgp peering. Specified for microsoft peering
        """
        return pulumi.get(self, "advertised_communities")

    @property
    @pulumi.getter(name="advertisedPublicPrefixes")
    def advertised_public_prefixes(self) -> Optional[Sequence[str]]:
        """
        The reference of AdvertisedPublicPrefixes.
        """
        return pulumi.get(self, "advertised_public_prefixes")

    @property
    @pulumi.getter(name="advertisedPublicPrefixesState")
    def advertised_public_prefixes_state(self) -> Optional[str]:
        """
        AdvertisedPublicPrefixState of the Peering resource. Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'.
        """
        return pulumi.get(self, "advertised_public_prefixes_state")

    @property
    @pulumi.getter(name="customerASN")
    def customer_asn(self) -> Optional[int]:
        """
        The CustomerASN of the peering.
        """
        return pulumi.get(self, "customer_asn")

    @property
    @pulumi.getter(name="legacyMode")
    def legacy_mode(self) -> Optional[int]:
        """
        The legacy mode of the peering.
        """
        return pulumi.get(self, "legacy_mode")

    @property
    @pulumi.getter(name="routingRegistryName")
    def routing_registry_name(self) -> Optional[str]:
        """
        The RoutingRegistryName of the configuration.
        """
        return pulumi.get(self, "routing_registry_name")


@pulumi.output_type
class ExpressRouteCircuitPeeringIdResponse(dict):
    """
    ExpressRoute circuit peering identifier.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        ExpressRoute circuit peering identifier.
        :param str id: The ID of the ExpressRoute circuit peering.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the ExpressRoute circuit peering.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ExpressRouteCircuitPeeringResponse(dict):
    """
    Peering in an ExpressRouteCircuit resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureASN":
            suggest = "azure_asn"
        elif key == "expressRouteConnection":
            suggest = "express_route_connection"
        elif key == "gatewayManagerEtag":
            suggest = "gateway_manager_etag"
        elif key == "ipv6PeeringConfig":
            suggest = "ipv6_peering_config"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "microsoftPeeringConfig":
            suggest = "microsoft_peering_config"
        elif key == "peerASN":
            suggest = "peer_asn"
        elif key == "peeringType":
            suggest = "peering_type"
        elif key == "primaryAzurePort":
            suggest = "primary_azure_port"
        elif key == "primaryPeerAddressPrefix":
            suggest = "primary_peer_address_prefix"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "routeFilter":
            suggest = "route_filter"
        elif key == "secondaryAzurePort":
            suggest = "secondary_azure_port"
        elif key == "secondaryPeerAddressPrefix":
            suggest = "secondary_peer_address_prefix"
        elif key == "sharedKey":
            suggest = "shared_key"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitPeeringResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitPeeringResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitPeeringResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 azure_asn: Optional[int] = None,
                 connections: Optional[Sequence['outputs.ExpressRouteCircuitConnectionResponse']] = None,
                 express_route_connection: Optional['outputs.ExpressRouteConnectionIdResponse'] = None,
                 gateway_manager_etag: Optional[str] = None,
                 id: Optional[str] = None,
                 ipv6_peering_config: Optional['outputs.Ipv6ExpressRouteCircuitPeeringConfigResponse'] = None,
                 last_modified_by: Optional[str] = None,
                 microsoft_peering_config: Optional['outputs.ExpressRouteCircuitPeeringConfigResponse'] = None,
                 name: Optional[str] = None,
                 peer_asn: Optional[float] = None,
                 peering_type: Optional[str] = None,
                 primary_azure_port: Optional[str] = None,
                 primary_peer_address_prefix: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 route_filter: Optional['outputs.RouteFilterResponse'] = None,
                 secondary_azure_port: Optional[str] = None,
                 secondary_peer_address_prefix: Optional[str] = None,
                 shared_key: Optional[str] = None,
                 state: Optional[str] = None,
                 stats: Optional['outputs.ExpressRouteCircuitStatsResponse'] = None,
                 vlan_id: Optional[int] = None):
        """
        Peering in an ExpressRouteCircuit resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param int azure_asn: The Azure ASN.
        :param Sequence['ExpressRouteCircuitConnectionResponse'] connections: The list of circuit connections associated with Azure Private Peering for this circuit.
        :param 'ExpressRouteConnectionIdResponse' express_route_connection: The ExpressRoute connection.
        :param str gateway_manager_etag: The GatewayManager Etag.
        :param str id: Resource ID.
        :param 'Ipv6ExpressRouteCircuitPeeringConfigResponse' ipv6_peering_config: The IPv6 peering configuration.
        :param str last_modified_by: Gets whether the provider or the customer last modified the peering.
        :param 'ExpressRouteCircuitPeeringConfigResponse' microsoft_peering_config: The Microsoft peering configuration.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param float peer_asn: The peer ASN.
        :param str peering_type: The peering type.
        :param str primary_azure_port: The primary port.
        :param str primary_peer_address_prefix: The primary address prefix.
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'RouteFilterResponse' route_filter: The reference of the RouteFilter resource.
        :param str secondary_azure_port: The secondary port.
        :param str secondary_peer_address_prefix: The secondary address prefix.
        :param str shared_key: The shared key.
        :param str state: The peering state.
        :param 'ExpressRouteCircuitStatsResponse' stats: Gets peering stats.
        :param int vlan_id: The VLAN ID.
        """
        pulumi.set(__self__, "etag", etag)
        if azure_asn is not None:
            pulumi.set(__self__, "azure_asn", azure_asn)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if express_route_connection is not None:
            pulumi.set(__self__, "express_route_connection", express_route_connection)
        if gateway_manager_etag is not None:
            pulumi.set(__self__, "gateway_manager_etag", gateway_manager_etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ipv6_peering_config is not None:
            pulumi.set(__self__, "ipv6_peering_config", ipv6_peering_config)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if microsoft_peering_config is not None:
            pulumi.set(__self__, "microsoft_peering_config", microsoft_peering_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peering_type is not None:
            pulumi.set(__self__, "peering_type", peering_type)
        if primary_azure_port is not None:
            pulumi.set(__self__, "primary_azure_port", primary_azure_port)
        if primary_peer_address_prefix is not None:
            pulumi.set(__self__, "primary_peer_address_prefix", primary_peer_address_prefix)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if route_filter is not None:
            pulumi.set(__self__, "route_filter", route_filter)
        if secondary_azure_port is not None:
            pulumi.set(__self__, "secondary_azure_port", secondary_azure_port)
        if secondary_peer_address_prefix is not None:
            pulumi.set(__self__, "secondary_peer_address_prefix", secondary_peer_address_prefix)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stats is not None:
            pulumi.set(__self__, "stats", stats)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="azureASN")
    def azure_asn(self) -> Optional[int]:
        """
        The Azure ASN.
        """
        return pulumi.get(self, "azure_asn")

    @property
    @pulumi.getter
    def connections(self) -> Optional[Sequence['outputs.ExpressRouteCircuitConnectionResponse']]:
        """
        The list of circuit connections associated with Azure Private Peering for this circuit.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter(name="expressRouteConnection")
    def express_route_connection(self) -> Optional['outputs.ExpressRouteConnectionIdResponse']:
        """
        The ExpressRoute connection.
        """
        return pulumi.get(self, "express_route_connection")

    @property
    @pulumi.getter(name="gatewayManagerEtag")
    def gateway_manager_etag(self) -> Optional[str]:
        """
        The GatewayManager Etag.
        """
        return pulumi.get(self, "gateway_manager_etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv6PeeringConfig")
    def ipv6_peering_config(self) -> Optional['outputs.Ipv6ExpressRouteCircuitPeeringConfigResponse']:
        """
        The IPv6 peering configuration.
        """
        return pulumi.get(self, "ipv6_peering_config")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        Gets whether the provider or the customer last modified the peering.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="microsoftPeeringConfig")
    def microsoft_peering_config(self) -> Optional['outputs.ExpressRouteCircuitPeeringConfigResponse']:
        """
        The Microsoft peering configuration.
        """
        return pulumi.get(self, "microsoft_peering_config")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerASN")
    def peer_asn(self) -> Optional[float]:
        """
        The peer ASN.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> Optional[str]:
        """
        The peering type.
        """
        return pulumi.get(self, "peering_type")

    @property
    @pulumi.getter(name="primaryAzurePort")
    def primary_azure_port(self) -> Optional[str]:
        """
        The primary port.
        """
        return pulumi.get(self, "primary_azure_port")

    @property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> Optional[str]:
        """
        The primary address prefix.
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="routeFilter")
    def route_filter(self) -> Optional['outputs.RouteFilterResponse']:
        """
        The reference of the RouteFilter resource.
        """
        return pulumi.get(self, "route_filter")

    @property
    @pulumi.getter(name="secondaryAzurePort")
    def secondary_azure_port(self) -> Optional[str]:
        """
        The secondary port.
        """
        return pulumi.get(self, "secondary_azure_port")

    @property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> Optional[str]:
        """
        The secondary address prefix.
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[str]:
        """
        The shared key.
        """
        return pulumi.get(self, "shared_key")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The peering state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def stats(self) -> Optional['outputs.ExpressRouteCircuitStatsResponse']:
        """
        Gets peering stats.
        """
        return pulumi.get(self, "stats")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[int]:
        """
        The VLAN ID.
        """
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class ExpressRouteCircuitServiceProviderPropertiesResponse(dict):
    """
    Contains ServiceProviderProperties in an ExpressRouteCircuit.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthInMbps":
            suggest = "bandwidth_in_mbps"
        elif key == "peeringLocation":
            suggest = "peering_location"
        elif key == "serviceProviderName":
            suggest = "service_provider_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitServiceProviderPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitServiceProviderPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitServiceProviderPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_in_mbps: Optional[int] = None,
                 peering_location: Optional[str] = None,
                 service_provider_name: Optional[str] = None):
        """
        Contains ServiceProviderProperties in an ExpressRouteCircuit.
        :param int bandwidth_in_mbps: The BandwidthInMbps.
        :param str peering_location: The peering location.
        :param str service_provider_name: The serviceProviderName.
        """
        if bandwidth_in_mbps is not None:
            pulumi.set(__self__, "bandwidth_in_mbps", bandwidth_in_mbps)
        if peering_location is not None:
            pulumi.set(__self__, "peering_location", peering_location)
        if service_provider_name is not None:
            pulumi.set(__self__, "service_provider_name", service_provider_name)

    @property
    @pulumi.getter(name="bandwidthInMbps")
    def bandwidth_in_mbps(self) -> Optional[int]:
        """
        The BandwidthInMbps.
        """
        return pulumi.get(self, "bandwidth_in_mbps")

    @property
    @pulumi.getter(name="peeringLocation")
    def peering_location(self) -> Optional[str]:
        """
        The peering location.
        """
        return pulumi.get(self, "peering_location")

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> Optional[str]:
        """
        The serviceProviderName.
        """
        return pulumi.get(self, "service_provider_name")


@pulumi.output_type
class ExpressRouteCircuitSkuResponse(dict):
    """
    Contains SKU in an ExpressRouteCircuit.
    """
    def __init__(__self__, *,
                 family: Optional[str] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Contains SKU in an ExpressRouteCircuit.
        :param str family: The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
        :param str name: The name of the SKU.
        :param str tier: The tier of the SKU. Possible values are 'Standard', 'Premium' or 'Basic'.
        """
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier of the SKU. Possible values are 'Standard', 'Premium' or 'Basic'.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class ExpressRouteCircuitStatsResponse(dict):
    """
    Contains stats associated with the peering.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primarybytesIn":
            suggest = "primarybytes_in"
        elif key == "primarybytesOut":
            suggest = "primarybytes_out"
        elif key == "secondarybytesIn":
            suggest = "secondarybytes_in"
        elif key == "secondarybytesOut":
            suggest = "secondarybytes_out"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteCircuitStatsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteCircuitStatsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteCircuitStatsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 primarybytes_in: Optional[float] = None,
                 primarybytes_out: Optional[float] = None,
                 secondarybytes_in: Optional[float] = None,
                 secondarybytes_out: Optional[float] = None):
        """
        Contains stats associated with the peering.
        :param float primarybytes_in: Gets BytesIn of the peering.
        :param float primarybytes_out: Gets BytesOut of the peering.
        :param float secondarybytes_in: Gets BytesIn of the peering.
        :param float secondarybytes_out: Gets BytesOut of the peering.
        """
        if primarybytes_in is not None:
            pulumi.set(__self__, "primarybytes_in", primarybytes_in)
        if primarybytes_out is not None:
            pulumi.set(__self__, "primarybytes_out", primarybytes_out)
        if secondarybytes_in is not None:
            pulumi.set(__self__, "secondarybytes_in", secondarybytes_in)
        if secondarybytes_out is not None:
            pulumi.set(__self__, "secondarybytes_out", secondarybytes_out)

    @property
    @pulumi.getter(name="primarybytesIn")
    def primarybytes_in(self) -> Optional[float]:
        """
        Gets BytesIn of the peering.
        """
        return pulumi.get(self, "primarybytes_in")

    @property
    @pulumi.getter(name="primarybytesOut")
    def primarybytes_out(self) -> Optional[float]:
        """
        Gets BytesOut of the peering.
        """
        return pulumi.get(self, "primarybytes_out")

    @property
    @pulumi.getter(name="secondarybytesIn")
    def secondarybytes_in(self) -> Optional[float]:
        """
        Gets BytesIn of the peering.
        """
        return pulumi.get(self, "secondarybytes_in")

    @property
    @pulumi.getter(name="secondarybytesOut")
    def secondarybytes_out(self) -> Optional[float]:
        """
        Gets BytesOut of the peering.
        """
        return pulumi.get(self, "secondarybytes_out")


@pulumi.output_type
class ExpressRouteConnectionIdResponse(dict):
    """
    The ID of the ExpressRouteConnection.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The ID of the ExpressRouteConnection.
        :param str id: The ID of the ExpressRouteConnection.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the ExpressRouteConnection.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ExpressRouteConnectionResponse(dict):
    """
    ExpressRouteConnection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expressRouteCircuitPeering":
            suggest = "express_route_circuit_peering"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "authorizationKey":
            suggest = "authorization_key"
        elif key == "routingWeight":
            suggest = "routing_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 express_route_circuit_peering: 'outputs.ExpressRouteCircuitPeeringIdResponse',
                 name: str,
                 provisioning_state: str,
                 authorization_key: Optional[str] = None,
                 id: Optional[str] = None,
                 routing_weight: Optional[int] = None):
        """
        ExpressRouteConnection resource.
        :param 'ExpressRouteCircuitPeeringIdResponse' express_route_circuit_peering: The ExpressRoute circuit peering.
        :param str name: The name of the resource.
        :param str provisioning_state: The provisioning state of the resource.
        :param str authorization_key: Authorization key to establish the connection.
        :param str id: Resource ID.
        :param int routing_weight: The routing weight associated to the connection.
        """
        pulumi.set(__self__, "express_route_circuit_peering", express_route_circuit_peering)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if routing_weight is not None:
            pulumi.set(__self__, "routing_weight", routing_weight)

    @property
    @pulumi.getter(name="expressRouteCircuitPeering")
    def express_route_circuit_peering(self) -> 'outputs.ExpressRouteCircuitPeeringIdResponse':
        """
        The ExpressRoute circuit peering.
        """
        return pulumi.get(self, "express_route_circuit_peering")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[str]:
        """
        Authorization key to establish the connection.
        """
        return pulumi.get(self, "authorization_key")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> Optional[int]:
        """
        The routing weight associated to the connection.
        """
        return pulumi.get(self, "routing_weight")


@pulumi.output_type
class ExpressRouteGatewayPropertiesResponseAutoScaleConfiguration(dict):
    """
    Configuration for auto scaling.
    """
    def __init__(__self__, *,
                 bounds: Optional['outputs.ExpressRouteGatewayPropertiesResponseBounds'] = None):
        """
        Configuration for auto scaling.
        :param 'ExpressRouteGatewayPropertiesResponseBounds' bounds: Minimum and maximum number of scale units to deploy.
        """
        if bounds is not None:
            pulumi.set(__self__, "bounds", bounds)

    @property
    @pulumi.getter
    def bounds(self) -> Optional['outputs.ExpressRouteGatewayPropertiesResponseBounds']:
        """
        Minimum and maximum number of scale units to deploy.
        """
        return pulumi.get(self, "bounds")


@pulumi.output_type
class ExpressRouteGatewayPropertiesResponseBounds(dict):
    """
    Minimum and maximum number of scale units to deploy.
    """
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        """
        Minimum and maximum number of scale units to deploy.
        :param int max: Maximum number of scale units deployed for ExpressRoute gateway.
        :param int min: Minimum number of scale units deployed for ExpressRoute gateway.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        Maximum number of scale units deployed for ExpressRoute gateway.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        Minimum number of scale units deployed for ExpressRoute gateway.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class ExpressRouteLinkResponse(dict):
    """
    ExpressRouteLink child resource definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectorType":
            suggest = "connector_type"
        elif key == "interfaceName":
            suggest = "interface_name"
        elif key == "patchPanelId":
            suggest = "patch_panel_id"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "rackId":
            suggest = "rack_id"
        elif key == "routerName":
            suggest = "router_name"
        elif key == "adminState":
            suggest = "admin_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpressRouteLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpressRouteLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpressRouteLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector_type: str,
                 etag: str,
                 interface_name: str,
                 patch_panel_id: str,
                 provisioning_state: str,
                 rack_id: str,
                 router_name: str,
                 admin_state: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        ExpressRouteLink child resource definition.
        :param str connector_type: Physical fiber port type.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str interface_name: Name of Azure router interface.
        :param str patch_panel_id: Mapping between physical port to patch panel port.
        :param str provisioning_state: The provisioning state of the ExpressRouteLink resource. Possible values are: 'Succeeded', 'Updating', 'Deleting', and 'Failed'.
        :param str rack_id: Mapping of physical patch panel to rack.
        :param str router_name: Name of Azure router associated with physical port.
        :param str admin_state: Administrative state of the physical port
        :param str id: Resource ID.
        :param str name: Name of child port resource that is unique among child port resources of the parent.
        """
        pulumi.set(__self__, "connector_type", connector_type)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "interface_name", interface_name)
        pulumi.set(__self__, "patch_panel_id", patch_panel_id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "rack_id", rack_id)
        pulumi.set(__self__, "router_name", router_name)
        if admin_state is not None:
            pulumi.set(__self__, "admin_state", admin_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> str:
        """
        Physical fiber port type.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> str:
        """
        Name of Azure router interface.
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter(name="patchPanelId")
    def patch_panel_id(self) -> str:
        """
        Mapping between physical port to patch panel port.
        """
        return pulumi.get(self, "patch_panel_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the ExpressRouteLink resource. Possible values are: 'Succeeded', 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="rackId")
    def rack_id(self) -> str:
        """
        Mapping of physical patch panel to rack.
        """
        return pulumi.get(self, "rack_id")

    @property
    @pulumi.getter(name="routerName")
    def router_name(self) -> str:
        """
        Name of Azure router associated with physical port.
        """
        return pulumi.get(self, "router_name")

    @property
    @pulumi.getter(name="adminState")
    def admin_state(self) -> Optional[str]:
        """
        Administrative state of the physical port
        """
        return pulumi.get(self, "admin_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of child port resource that is unique among child port resources of the parent.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FrontendIPConfigurationResponse(dict):
    """
    Frontend IP address of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundNatPools":
            suggest = "inbound_nat_pools"
        elif key == "inboundNatRules":
            suggest = "inbound_nat_rules"
        elif key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "outboundRules":
            suggest = "outbound_rules"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"
        elif key == "publicIPPrefix":
            suggest = "public_ip_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontendIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontendIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontendIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inbound_nat_pools: Sequence['outputs.SubResourceResponse'],
                 inbound_nat_rules: Sequence['outputs.SubResourceResponse'],
                 load_balancing_rules: Sequence['outputs.SubResourceResponse'],
                 outbound_rules: Sequence['outputs.SubResourceResponse'],
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address: Optional['outputs.PublicIPAddressResponse'] = None,
                 public_ip_prefix: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        Frontend IP address of the load balancer.
        :param Sequence['SubResourceResponse'] inbound_nat_pools: Read only. Inbound pools URIs that use this frontend IP.
        :param Sequence['SubResourceResponse'] inbound_nat_rules: Read only. Inbound rules URIs that use this frontend IP.
        :param Sequence['SubResourceResponse'] load_balancing_rules: Gets load balancing rules URIs that use this frontend IP.
        :param Sequence['SubResourceResponse'] outbound_rules: Read only. Outbound rules URIs that use this frontend IP.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_ip_address: The private IP address of the IP configuration.
        :param str private_ip_allocation_method: The Private IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'PublicIPAddressResponse' public_ip_address: The reference of the Public IP resource.
        :param 'SubResourceResponse' public_ip_prefix: The reference of the Public IP Prefix resource.
        :param 'SubnetResponse' subnet: The reference of the subnet resource.
        :param Sequence[str] zones: A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        pulumi.set(__self__, "inbound_nat_pools", inbound_nat_pools)
        pulumi.set(__self__, "inbound_nat_rules", inbound_nat_rules)
        pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        pulumi.set(__self__, "outbound_rules", outbound_rules)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if public_ip_prefix is not None:
            pulumi.set(__self__, "public_ip_prefix", public_ip_prefix)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="inboundNatPools")
    def inbound_nat_pools(self) -> Sequence['outputs.SubResourceResponse']:
        """
        Read only. Inbound pools URIs that use this frontend IP.
        """
        return pulumi.get(self, "inbound_nat_pools")

    @property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        Read only. Inbound rules URIs that use this frontend IP.
        """
        return pulumi.get(self, "inbound_nat_rules")

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        Gets load balancing rules URIs that use this frontend IP.
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        Read only. Outbound rules URIs that use this frontend IP.
        """
        return pulumi.get(self, "outbound_rules")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The Private IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.PublicIPAddressResponse']:
        """
        The reference of the Public IP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="publicIPPrefix")
    def public_ip_prefix(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of the Public IP Prefix resource.
        """
        return pulumi.get(self, "public_ip_prefix")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        The reference of the subnet resource.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class GatewayRouteResponse(dict):
    """
    Gateway routing details
    """
    def __init__(__self__, *,
                 as_path: str,
                 local_address: str,
                 network: str,
                 next_hop: str,
                 origin: str,
                 source_peer: str,
                 weight: int):
        """
        Gateway routing details
        :param str as_path: The route's AS path sequence
        :param str local_address: The gateway's local address
        :param str network: The route's network prefix
        :param str next_hop: The route's next hop
        :param str origin: The source this route was learned from
        :param str source_peer: The peer this route was learned from
        :param int weight: The route's weight
        """
        pulumi.set(__self__, "as_path", as_path)
        pulumi.set(__self__, "local_address", local_address)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "source_peer", source_peer)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="asPath")
    def as_path(self) -> str:
        """
        The route's AS path sequence
        """
        return pulumi.get(self, "as_path")

    @property
    @pulumi.getter(name="localAddress")
    def local_address(self) -> str:
        """
        The gateway's local address
        """
        return pulumi.get(self, "local_address")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The route's network prefix
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The route's next hop
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter
    def origin(self) -> str:
        """
        The source this route was learned from
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="sourcePeer")
    def source_peer(self) -> str:
        """
        The peer this route was learned from
        """
        return pulumi.get(self, "source_peer")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The route's weight
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class HubVirtualNetworkConnectionResponse(dict):
    """
    HubVirtualNetworkConnection Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "allowHubToRemoteVnetTransit":
            suggest = "allow_hub_to_remote_vnet_transit"
        elif key == "allowRemoteVnetToUseHubVnetGateways":
            suggest = "allow_remote_vnet_to_use_hub_vnet_gateways"
        elif key == "enableInternetSecurity":
            suggest = "enable_internet_security"
        elif key == "remoteVirtualNetwork":
            suggest = "remote_virtual_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HubVirtualNetworkConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HubVirtualNetworkConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HubVirtualNetworkConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 allow_hub_to_remote_vnet_transit: Optional[bool] = None,
                 allow_remote_vnet_to_use_hub_vnet_gateways: Optional[bool] = None,
                 enable_internet_security: Optional[bool] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 remote_virtual_network: Optional['outputs.SubResourceResponse'] = None):
        """
        HubVirtualNetworkConnection Resource.
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the resource.
        :param bool allow_hub_to_remote_vnet_transit: VirtualHub to RemoteVnet transit to enabled or not.
        :param bool allow_remote_vnet_to_use_hub_vnet_gateways: Allow RemoteVnet to use Virtual Hub's gateways.
        :param bool enable_internet_security: Enable internet security
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'SubResourceResponse' remote_virtual_network: Reference to the remote virtual network.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if allow_hub_to_remote_vnet_transit is not None:
            pulumi.set(__self__, "allow_hub_to_remote_vnet_transit", allow_hub_to_remote_vnet_transit)
        if allow_remote_vnet_to_use_hub_vnet_gateways is not None:
            pulumi.set(__self__, "allow_remote_vnet_to_use_hub_vnet_gateways", allow_remote_vnet_to_use_hub_vnet_gateways)
        if enable_internet_security is not None:
            pulumi.set(__self__, "enable_internet_security", enable_internet_security)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remote_virtual_network is not None:
            pulumi.set(__self__, "remote_virtual_network", remote_virtual_network)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="allowHubToRemoteVnetTransit")
    def allow_hub_to_remote_vnet_transit(self) -> Optional[bool]:
        """
        VirtualHub to RemoteVnet transit to enabled or not.
        """
        return pulumi.get(self, "allow_hub_to_remote_vnet_transit")

    @property
    @pulumi.getter(name="allowRemoteVnetToUseHubVnetGateways")
    def allow_remote_vnet_to_use_hub_vnet_gateways(self) -> Optional[bool]:
        """
        Allow RemoteVnet to use Virtual Hub's gateways.
        """
        return pulumi.get(self, "allow_remote_vnet_to_use_hub_vnet_gateways")

    @property
    @pulumi.getter(name="enableInternetSecurity")
    def enable_internet_security(self) -> Optional[bool]:
        """
        Enable internet security
        """
        return pulumi.get(self, "enable_internet_security")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="remoteVirtualNetwork")
    def remote_virtual_network(self) -> Optional['outputs.SubResourceResponse']:
        """
        Reference to the remote virtual network.
        """
        return pulumi.get(self, "remote_virtual_network")


@pulumi.output_type
class IPConfigurationProfileResponse(dict):
    """
    IP configuration profile child resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPConfigurationProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPConfigurationProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPConfigurationProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 type: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None):
        """
        IP configuration profile child resource.
        :param str provisioning_state: The provisioning state of the resource.
        :param str type: Sub Resource type.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource. This name can be used to access the resource.
        :param 'SubnetResponse' subnet: The reference of the subnet resource to create a container network interface ip configuration.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Sub Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        The reference of the subnet resource to create a container network interface ip configuration.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class IPConfigurationResponse(dict):
    """
    IP configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address: Optional['outputs.PublicIPAddressResponse'] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None):
        """
        IP configuration
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_ip_address: The private IP address of the IP configuration.
        :param str private_ip_allocation_method: The private IP allocation method. Possible values are 'Static' and 'Dynamic'.
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'PublicIPAddressResponse' public_ip_address: The reference of the public IP resource.
        :param 'SubnetResponse' subnet: The reference of the subnet resource.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        The private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The private IP allocation method. Possible values are 'Static' and 'Dynamic'.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.PublicIPAddressResponse']:
        """
        The reference of the public IP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        The reference of the subnet resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class InboundNatPoolResponse(dict):
    """
    Inbound NAT pool of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "frontendPortRangeEnd":
            suggest = "frontend_port_range_end"
        elif key == "frontendPortRangeStart":
            suggest = "frontend_port_range_start"
        elif key == "enableFloatingIP":
            suggest = "enable_floating_ip"
        elif key == "enableTcpReset":
            suggest = "enable_tcp_reset"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundNatPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundNatPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: int,
                 frontend_port_range_end: int,
                 frontend_port_range_start: int,
                 protocol: str,
                 enable_floating_ip: Optional[bool] = None,
                 enable_tcp_reset: Optional[bool] = None,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Inbound NAT pool of the load balancer.
        :param int backend_port: The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        :param int frontend_port_range_end: The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
        :param int frontend_port_range_start: The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
        :param str protocol: The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'.
        :param bool enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        :param bool enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' frontend_ip_configuration: A reference to frontend IP addresses.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port_range_end", frontend_port_range_end)
        pulumi.set(__self__, "frontend_port_range_start", frontend_port_range_start)
        pulumi.set(__self__, "protocol", protocol)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> int:
        """
        The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="frontendPortRangeEnd")
    def frontend_port_range_end(self) -> int:
        """
        The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
        """
        return pulumi.get(self, "frontend_port_range_end")

    @property
    @pulumi.getter(name="frontendPortRangeStart")
    def frontend_port_range_start(self) -> int:
        """
        The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
        """
        return pulumi.get(self, "frontend_port_range_start")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> Optional[bool]:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[bool]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class InboundNatRuleResponse(dict):
    """
    Inbound NAT rule of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendIPConfiguration":
            suggest = "backend_ip_configuration"
        elif key == "backendPort":
            suggest = "backend_port"
        elif key == "enableFloatingIP":
            suggest = "enable_floating_ip"
        elif key == "enableTcpReset":
            suggest = "enable_tcp_reset"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InboundNatRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InboundNatRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InboundNatRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_ip_configuration: 'outputs.NetworkInterfaceIPConfigurationResponse',
                 backend_port: Optional[int] = None,
                 enable_floating_ip: Optional[bool] = None,
                 enable_tcp_reset: Optional[bool] = None,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 frontend_port: Optional[int] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 name: Optional[str] = None,
                 protocol: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Inbound NAT rule of the load balancer.
        :param 'NetworkInterfaceIPConfigurationResponse' backend_ip_configuration: A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backend IP.
        :param int backend_port: The port used for the internal endpoint. Acceptable values range from 1 to 65535.
        :param bool enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        :param bool enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' frontend_ip_configuration: A reference to frontend IP addresses.
        :param int frontend_port: The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str protocol: The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'.
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "backend_ip_configuration", backend_ip_configuration)
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendIPConfiguration")
    def backend_ip_configuration(self) -> 'outputs.NetworkInterfaceIPConfigurationResponse':
        """
        A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backend IP.
        """
        return pulumi.get(self, "backend_ip_configuration")

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[int]:
        """
        The port used for the internal endpoint. Acceptable values range from 1 to 65535.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> Optional[bool]:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[bool]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[int]:
        """
        The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class InterfaceEndpointResponse(dict):
    """
    Interface endpoint resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "endpointService":
            suggest = "endpoint_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InterfaceEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InterfaceEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InterfaceEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 network_interfaces: Sequence['outputs.NetworkInterfaceResponse'],
                 owner: str,
                 provisioning_state: str,
                 type: str,
                 endpoint_service: Optional['outputs.EndpointServiceResponse'] = None,
                 etag: Optional[str] = None,
                 fqdn: Optional[str] = None,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Interface endpoint resource.
        :param str name: Resource name.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: Gets an array of references to the network interfaces created for this interface endpoint.
        :param str owner: A read-only property that identifies who created this interface endpoint.
        :param str provisioning_state: The provisioning state of the interface endpoint. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str type: Resource type.
        :param 'EndpointServiceResponse' endpoint_service: A reference to the service being brought into the virtual network.
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param str fqdn: A first-party service's FQDN that is mapped to the private IP allocated via this interface endpoint.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param 'SubnetResponse' subnet: The ID of the subnet from which the private IP will be allocated.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if endpoint_service is not None:
            pulumi.set(__self__, "endpoint_service", endpoint_service)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.NetworkInterfaceResponse']:
        """
        Gets an array of references to the network interfaces created for this interface endpoint.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        A read-only property that identifies who created this interface endpoint.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the interface endpoint. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="endpointService")
    def endpoint_service(self) -> Optional['outputs.EndpointServiceResponse']:
        """
        A reference to the service being brought into the virtual network.
        """
        return pulumi.get(self, "endpoint_service")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        A first-party service's FQDN that is mapped to the private IP allocated via this interface endpoint.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        The ID of the subnet from which the private IP will be allocated.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class IpTagResponse(dict):
    """
    Contains the IpTag associated with the object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipTagType":
            suggest = "ip_tag_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpTagResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpTagResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpTagResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_tag_type: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        Contains the IpTag associated with the object
        :param str ip_tag_type: Gets or sets the ipTag type: Example FirstPartyUsage.
        :param str tag: Gets or sets value of the IpTag associated with the public IP. Example SQL, Storage etc
        """
        if ip_tag_type is not None:
            pulumi.set(__self__, "ip_tag_type", ip_tag_type)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="ipTagType")
    def ip_tag_type(self) -> Optional[str]:
        """
        Gets or sets the ipTag type: Example FirstPartyUsage.
        """
        return pulumi.get(self, "ip_tag_type")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Gets or sets value of the IpTag associated with the public IP. Example SQL, Storage etc
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class IpsecPolicyResponse(dict):
    """
    An IPSec Policy configuration for a virtual network gateway connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dhGroup":
            suggest = "dh_group"
        elif key == "ikeEncryption":
            suggest = "ike_encryption"
        elif key == "ikeIntegrity":
            suggest = "ike_integrity"
        elif key == "ipsecEncryption":
            suggest = "ipsec_encryption"
        elif key == "ipsecIntegrity":
            suggest = "ipsec_integrity"
        elif key == "pfsGroup":
            suggest = "pfs_group"
        elif key == "saDataSizeKilobytes":
            suggest = "sa_data_size_kilobytes"
        elif key == "saLifeTimeSeconds":
            suggest = "sa_life_time_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpsecPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpsecPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpsecPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dh_group: str,
                 ike_encryption: str,
                 ike_integrity: str,
                 ipsec_encryption: str,
                 ipsec_integrity: str,
                 pfs_group: str,
                 sa_data_size_kilobytes: int,
                 sa_life_time_seconds: int):
        """
        An IPSec Policy configuration for a virtual network gateway connection
        :param str dh_group: The DH Groups used in IKE Phase 1 for initial SA.
        :param str ike_encryption: The IKE encryption algorithm (IKE phase 2).
        :param str ike_integrity: The IKE integrity algorithm (IKE phase 2).
        :param str ipsec_encryption: The IPSec encryption algorithm (IKE phase 1).
        :param str ipsec_integrity: The IPSec integrity algorithm (IKE phase 1).
        :param str pfs_group: The Pfs Groups used in IKE Phase 2 for new child SA.
        :param int sa_data_size_kilobytes: The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
        :param int sa_life_time_seconds: The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
        """
        pulumi.set(__self__, "dh_group", dh_group)
        pulumi.set(__self__, "ike_encryption", ike_encryption)
        pulumi.set(__self__, "ike_integrity", ike_integrity)
        pulumi.set(__self__, "ipsec_encryption", ipsec_encryption)
        pulumi.set(__self__, "ipsec_integrity", ipsec_integrity)
        pulumi.set(__self__, "pfs_group", pfs_group)
        pulumi.set(__self__, "sa_data_size_kilobytes", sa_data_size_kilobytes)
        pulumi.set(__self__, "sa_life_time_seconds", sa_life_time_seconds)

    @property
    @pulumi.getter(name="dhGroup")
    def dh_group(self) -> str:
        """
        The DH Groups used in IKE Phase 1 for initial SA.
        """
        return pulumi.get(self, "dh_group")

    @property
    @pulumi.getter(name="ikeEncryption")
    def ike_encryption(self) -> str:
        """
        The IKE encryption algorithm (IKE phase 2).
        """
        return pulumi.get(self, "ike_encryption")

    @property
    @pulumi.getter(name="ikeIntegrity")
    def ike_integrity(self) -> str:
        """
        The IKE integrity algorithm (IKE phase 2).
        """
        return pulumi.get(self, "ike_integrity")

    @property
    @pulumi.getter(name="ipsecEncryption")
    def ipsec_encryption(self) -> str:
        """
        The IPSec encryption algorithm (IKE phase 1).
        """
        return pulumi.get(self, "ipsec_encryption")

    @property
    @pulumi.getter(name="ipsecIntegrity")
    def ipsec_integrity(self) -> str:
        """
        The IPSec integrity algorithm (IKE phase 1).
        """
        return pulumi.get(self, "ipsec_integrity")

    @property
    @pulumi.getter(name="pfsGroup")
    def pfs_group(self) -> str:
        """
        The Pfs Groups used in IKE Phase 2 for new child SA.
        """
        return pulumi.get(self, "pfs_group")

    @property
    @pulumi.getter(name="saDataSizeKilobytes")
    def sa_data_size_kilobytes(self) -> int:
        """
        The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN tunnel.
        """
        return pulumi.get(self, "sa_data_size_kilobytes")

    @property
    @pulumi.getter(name="saLifeTimeSeconds")
    def sa_life_time_seconds(self) -> int:
        """
        The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site VPN tunnel.
        """
        return pulumi.get(self, "sa_life_time_seconds")


@pulumi.output_type
class Ipv6ExpressRouteCircuitPeeringConfigResponse(dict):
    """
    Contains IPv6 peering config.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "microsoftPeeringConfig":
            suggest = "microsoft_peering_config"
        elif key == "primaryPeerAddressPrefix":
            suggest = "primary_peer_address_prefix"
        elif key == "routeFilter":
            suggest = "route_filter"
        elif key == "secondaryPeerAddressPrefix":
            suggest = "secondary_peer_address_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Ipv6ExpressRouteCircuitPeeringConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Ipv6ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Ipv6ExpressRouteCircuitPeeringConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 microsoft_peering_config: Optional['outputs.ExpressRouteCircuitPeeringConfigResponse'] = None,
                 primary_peer_address_prefix: Optional[str] = None,
                 route_filter: Optional['outputs.RouteFilterResponse'] = None,
                 secondary_peer_address_prefix: Optional[str] = None,
                 state: Optional[str] = None):
        """
        Contains IPv6 peering config.
        :param 'ExpressRouteCircuitPeeringConfigResponse' microsoft_peering_config: The Microsoft peering configuration.
        :param str primary_peer_address_prefix: The primary address prefix.
        :param 'RouteFilterResponse' route_filter: The reference of the RouteFilter resource.
        :param str secondary_peer_address_prefix: The secondary address prefix.
        :param str state: The state of peering. Possible values are: 'Disabled' and 'Enabled'
        """
        if microsoft_peering_config is not None:
            pulumi.set(__self__, "microsoft_peering_config", microsoft_peering_config)
        if primary_peer_address_prefix is not None:
            pulumi.set(__self__, "primary_peer_address_prefix", primary_peer_address_prefix)
        if route_filter is not None:
            pulumi.set(__self__, "route_filter", route_filter)
        if secondary_peer_address_prefix is not None:
            pulumi.set(__self__, "secondary_peer_address_prefix", secondary_peer_address_prefix)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="microsoftPeeringConfig")
    def microsoft_peering_config(self) -> Optional['outputs.ExpressRouteCircuitPeeringConfigResponse']:
        """
        The Microsoft peering configuration.
        """
        return pulumi.get(self, "microsoft_peering_config")

    @property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> Optional[str]:
        """
        The primary address prefix.
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @property
    @pulumi.getter(name="routeFilter")
    def route_filter(self) -> Optional['outputs.RouteFilterResponse']:
        """
        The reference of the RouteFilter resource.
        """
        return pulumi.get(self, "route_filter")

    @property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> Optional[str]:
        """
        The secondary address prefix.
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of peering. Possible values are: 'Disabled' and 'Enabled'
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class LoadBalancerSkuResponse(dict):
    """
    SKU of a load balancer
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        SKU of a load balancer
        :param str name: Name of a load balancer SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of a load balancer SKU.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LoadBalancingRuleResponse(dict):
    """
    A load balancing rule for a load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frontendPort":
            suggest = "frontend_port"
        elif key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "backendPort":
            suggest = "backend_port"
        elif key == "disableOutboundSnat":
            suggest = "disable_outbound_snat"
        elif key == "enableFloatingIP":
            suggest = "enable_floating_ip"
        elif key == "enableTcpReset":
            suggest = "enable_tcp_reset"
        elif key == "frontendIPConfiguration":
            suggest = "frontend_ip_configuration"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "loadDistribution":
            suggest = "load_distribution"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancingRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancingRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancingRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frontend_port: int,
                 protocol: str,
                 backend_address_pool: Optional['outputs.SubResourceResponse'] = None,
                 backend_port: Optional[int] = None,
                 disable_outbound_snat: Optional[bool] = None,
                 enable_floating_ip: Optional[bool] = None,
                 enable_tcp_reset: Optional[bool] = None,
                 etag: Optional[str] = None,
                 frontend_ip_configuration: Optional['outputs.SubResourceResponse'] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 load_distribution: Optional[str] = None,
                 name: Optional[str] = None,
                 probe: Optional['outputs.SubResourceResponse'] = None,
                 provisioning_state: Optional[str] = None):
        """
        A load balancing rule for a load balancer.
        :param int frontend_port: The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port"
        :param str protocol: The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'.
        :param 'SubResourceResponse' backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
        :param int backend_port: The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port"
        :param bool disable_outbound_snat: Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.
        :param bool enable_floating_ip: Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        :param bool enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' frontend_ip_configuration: A reference to frontend IP addresses.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        :param str load_distribution: The load distribution policy for this rule. Possible values are 'Default', 'SourceIP', and 'SourceIPProtocol'.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'SubResourceResponse' probe: The reference of the load balancer probe used by the load balancing rule.
        :param str provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "protocol", protocol)
        if backend_address_pool is not None:
            pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        if backend_port is not None:
            pulumi.set(__self__, "backend_port", backend_port)
        if disable_outbound_snat is not None:
            pulumi.set(__self__, "disable_outbound_snat", disable_outbound_snat)
        if enable_floating_ip is not None:
            pulumi.set(__self__, "enable_floating_ip", enable_floating_ip)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if frontend_ip_configuration is not None:
            pulumi.set(__self__, "frontend_ip_configuration", frontend_ip_configuration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if load_distribution is not None:
            pulumi.set(__self__, "load_distribution", load_distribution)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if probe is not None:
            pulumi.set(__self__, "probe", probe)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> int:
        """
        The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port"
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> Optional[int]:
        """
        The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port"
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="disableOutboundSnat")
    def disable_outbound_snat(self) -> Optional[bool]:
        """
        Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.
        """
        return pulumi.get(self, "disable_outbound_snat")

    @property
    @pulumi.getter(name="enableFloatingIP")
    def enable_floating_ip(self) -> Optional[bool]:
        """
        Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
        """
        return pulumi.get(self, "enable_floating_ip")

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[bool]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="frontendIPConfiguration")
    def frontend_ip_configuration(self) -> Optional['outputs.SubResourceResponse']:
        """
        A reference to frontend IP addresses.
        """
        return pulumi.get(self, "frontend_ip_configuration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="loadDistribution")
    def load_distribution(self) -> Optional[str]:
        """
        The load distribution policy for this rule. Possible values are 'Default', 'SourceIP', and 'SourceIPProtocol'.
        """
        return pulumi.get(self, "load_distribution")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def probe(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of the load balancer probe used by the load balancing rule.
        """
        return pulumi.get(self, "probe")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class LocalNetworkGatewayResponse(dict):
    """
    A common class for general resource information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "bgpSettings":
            suggest = "bgp_settings"
        elif key == "gatewayIpAddress":
            suggest = "gateway_ip_address"
        elif key == "localNetworkAddressSpace":
            suggest = "local_network_address_space"
        elif key == "resourceGuid":
            suggest = "resource_guid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocalNetworkGatewayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocalNetworkGatewayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocalNetworkGatewayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 bgp_settings: Optional['outputs.BgpSettingsResponse'] = None,
                 etag: Optional[str] = None,
                 gateway_ip_address: Optional[str] = None,
                 id: Optional[str] = None,
                 local_network_address_space: Optional['outputs.AddressSpaceResponse'] = None,
                 location: Optional[str] = None,
                 resource_guid: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        A common class for general resource information
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the LocalNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str type: Resource type.
        :param 'BgpSettingsResponse' bgp_settings: Local network gateway's BGP speaker settings.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str gateway_ip_address: IP address of local network gateway.
        :param str id: Resource ID.
        :param 'AddressSpaceResponse' local_network_address_space: Local network site address space.
        :param str location: Resource location.
        :param str resource_guid: The resource GUID property of the LocalNetworkGateway resource.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if bgp_settings is not None:
            pulumi.set(__self__, "bgp_settings", bgp_settings)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if gateway_ip_address is not None:
            pulumi.set(__self__, "gateway_ip_address", gateway_ip_address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if local_network_address_space is not None:
            pulumi.set(__self__, "local_network_address_space", local_network_address_space)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if resource_guid is not None:
            pulumi.set(__self__, "resource_guid", resource_guid)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the LocalNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Optional['outputs.BgpSettingsResponse']:
        """
        Local network gateway's BGP speaker settings.
        """
        return pulumi.get(self, "bgp_settings")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="gatewayIpAddress")
    def gateway_ip_address(self) -> Optional[str]:
        """
        IP address of local network gateway.
        """
        return pulumi.get(self, "gateway_ip_address")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localNetworkAddressSpace")
    def local_network_address_space(self) -> Optional['outputs.AddressSpaceResponse']:
        """
        Local network site address space.
        """
        return pulumi.get(self, "local_network_address_space")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> Optional[str]:
        """
        The resource GUID property of the LocalNetworkGateway resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class MonitorConfigResponse(dict):
    """
    Class containing endpoint monitoring settings in a Traffic Manager profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customHeaders":
            suggest = "custom_headers"
        elif key == "expectedStatusCodeRanges":
            suggest = "expected_status_code_ranges"
        elif key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "profileMonitorStatus":
            suggest = "profile_monitor_status"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"
        elif key == "toleratedNumberOfFailures":
            suggest = "tolerated_number_of_failures"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitorConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitorConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitorConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_headers: Optional[Sequence['outputs.MonitorConfigResponseCustomHeaders']] = None,
                 expected_status_code_ranges: Optional[Sequence['outputs.MonitorConfigResponseExpectedStatusCodeRanges']] = None,
                 interval_in_seconds: Optional[float] = None,
                 path: Optional[str] = None,
                 port: Optional[float] = None,
                 profile_monitor_status: Optional[str] = None,
                 protocol: Optional[str] = None,
                 timeout_in_seconds: Optional[float] = None,
                 tolerated_number_of_failures: Optional[float] = None):
        """
        Class containing endpoint monitoring settings in a Traffic Manager profile.
        :param Sequence['MonitorConfigResponseCustomHeaders'] custom_headers: List of custom headers.
        :param Sequence['MonitorConfigResponseExpectedStatusCodeRanges'] expected_status_code_ranges: List of expected status code ranges.
        :param float interval_in_seconds: The monitor interval for endpoints in this profile. This is the interval at which Traffic Manager will check the health of each endpoint in this profile.
        :param str path: The path relative to the endpoint domain name used to probe for endpoint health.
        :param float port: The TCP port used to probe for endpoint health.
        :param str profile_monitor_status: The profile-level monitoring status of the Traffic Manager profile.
        :param str protocol: The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
        :param float timeout_in_seconds: The monitor timeout for endpoints in this profile. This is the time that Traffic Manager allows endpoints in this profile to response to the health check.
        :param float tolerated_number_of_failures: The number of consecutive failed health check that Traffic Manager tolerates before declaring an endpoint in this profile Degraded after the next failed health check.
        """
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if expected_status_code_ranges is not None:
            pulumi.set(__self__, "expected_status_code_ranges", expected_status_code_ranges)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if profile_monitor_status is not None:
            pulumi.set(__self__, "profile_monitor_status", profile_monitor_status)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if tolerated_number_of_failures is not None:
            pulumi.set(__self__, "tolerated_number_of_failures", tolerated_number_of_failures)

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[Sequence['outputs.MonitorConfigResponseCustomHeaders']]:
        """
        List of custom headers.
        """
        return pulumi.get(self, "custom_headers")

    @property
    @pulumi.getter(name="expectedStatusCodeRanges")
    def expected_status_code_ranges(self) -> Optional[Sequence['outputs.MonitorConfigResponseExpectedStatusCodeRanges']]:
        """
        List of expected status code ranges.
        """
        return pulumi.get(self, "expected_status_code_ranges")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[float]:
        """
        The monitor interval for endpoints in this profile. This is the interval at which Traffic Manager will check the health of each endpoint in this profile.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path relative to the endpoint domain name used to probe for endpoint health.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The TCP port used to probe for endpoint health.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="profileMonitorStatus")
    def profile_monitor_status(self) -> Optional[str]:
        """
        The profile-level monitoring status of the Traffic Manager profile.
        """
        return pulumi.get(self, "profile_monitor_status")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[float]:
        """
        The monitor timeout for endpoints in this profile. This is the time that Traffic Manager allows endpoints in this profile to response to the health check.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="toleratedNumberOfFailures")
    def tolerated_number_of_failures(self) -> Optional[float]:
        """
        The number of consecutive failed health check that Traffic Manager tolerates before declaring an endpoint in this profile Degraded after the next failed health check.
        """
        return pulumi.get(self, "tolerated_number_of_failures")


@pulumi.output_type
class MonitorConfigResponseCustomHeaders(dict):
    """
    Custom header name and value.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Custom header name and value.
        :param str name: Header name.
        :param str value: Header value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Header name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MonitorConfigResponseExpectedStatusCodeRanges(dict):
    """
    Min and max value of a status code range.
    """
    def __init__(__self__, *,
                 max: Optional[int] = None,
                 min: Optional[int] = None):
        """
        Min and max value of a status code range.
        :param int max: Max status code.
        :param int min: Min status code.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[int]:
        """
        Max status code.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[int]:
        """
        Min status code.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class NetworkInterfaceDnsSettingsResponse(dict):
    """
    DNS settings of a network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appliedDnsServers":
            suggest = "applied_dns_servers"
        elif key == "dnsServers":
            suggest = "dns_servers"
        elif key == "internalDnsNameLabel":
            suggest = "internal_dns_name_label"
        elif key == "internalDomainNameSuffix":
            suggest = "internal_domain_name_suffix"
        elif key == "internalFqdn":
            suggest = "internal_fqdn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applied_dns_servers: Optional[Sequence[str]] = None,
                 dns_servers: Optional[Sequence[str]] = None,
                 internal_dns_name_label: Optional[str] = None,
                 internal_domain_name_suffix: Optional[str] = None,
                 internal_fqdn: Optional[str] = None):
        """
        DNS settings of a network interface.
        :param Sequence[str] applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.
        :param Sequence[str] dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
        :param str internal_dns_name_label: Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
        :param str internal_domain_name_suffix: Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix.
        :param str internal_fqdn: Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
        """
        if applied_dns_servers is not None:
            pulumi.set(__self__, "applied_dns_servers", applied_dns_servers)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if internal_dns_name_label is not None:
            pulumi.set(__self__, "internal_dns_name_label", internal_dns_name_label)
        if internal_domain_name_suffix is not None:
            pulumi.set(__self__, "internal_domain_name_suffix", internal_domain_name_suffix)
        if internal_fqdn is not None:
            pulumi.set(__self__, "internal_fqdn", internal_fqdn)

    @property
    @pulumi.getter(name="appliedDnsServers")
    def applied_dns_servers(self) -> Optional[Sequence[str]]:
        """
        If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.
        """
        return pulumi.get(self, "applied_dns_servers")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="internalDnsNameLabel")
    def internal_dns_name_label(self) -> Optional[str]:
        """
        Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
        """
        return pulumi.get(self, "internal_dns_name_label")

    @property
    @pulumi.getter(name="internalDomainNameSuffix")
    def internal_domain_name_suffix(self) -> Optional[str]:
        """
        Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can be constructed by concatenating the VM name with the value of internalDomainNameSuffix.
        """
        return pulumi.get(self, "internal_domain_name_suffix")

    @property
    @pulumi.getter(name="internalFqdn")
    def internal_fqdn(self) -> Optional[str]:
        """
        Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
        """
        return pulumi.get(self, "internal_fqdn")


@pulumi.output_type
class NetworkInterfaceIPConfigurationResponse(dict):
    """
    IPConfiguration in a network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationGatewayBackendAddressPools":
            suggest = "application_gateway_backend_address_pools"
        elif key == "applicationSecurityGroups":
            suggest = "application_security_groups"
        elif key == "loadBalancerBackendAddressPools":
            suggest = "load_balancer_backend_address_pools"
        elif key == "loadBalancerInboundNatRules":
            suggest = "load_balancer_inbound_nat_rules"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAddressVersion":
            suggest = "private_ip_address_version"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"
        elif key == "virtualNetworkTaps":
            suggest = "virtual_network_taps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_gateway_backend_address_pools: Optional[Sequence['outputs.ApplicationGatewayBackendAddressPoolResponse']] = None,
                 application_security_groups: Optional[Sequence['outputs.ApplicationSecurityGroupResponse']] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 load_balancer_backend_address_pools: Optional[Sequence['outputs.BackendAddressPoolResponse']] = None,
                 load_balancer_inbound_nat_rules: Optional[Sequence['outputs.InboundNatRuleResponse']] = None,
                 name: Optional[str] = None,
                 primary: Optional[bool] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_address_version: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address: Optional['outputs.PublicIPAddressResponse'] = None,
                 subnet: Optional['outputs.SubnetResponse'] = None,
                 virtual_network_taps: Optional[Sequence['outputs.VirtualNetworkTapResponse']] = None):
        """
        IPConfiguration in a network interface.
        :param Sequence['ApplicationGatewayBackendAddressPoolResponse'] application_gateway_backend_address_pools: The reference of ApplicationGatewayBackendAddressPool resource.
        :param Sequence['ApplicationSecurityGroupResponse'] application_security_groups: Application security groups in which the IP configuration is included.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param Sequence['BackendAddressPoolResponse'] load_balancer_backend_address_pools: The reference of LoadBalancerBackendAddressPool resource.
        :param Sequence['InboundNatRuleResponse'] load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param bool primary: Gets whether this is a primary customer address on the network interface.
        :param str private_ip_address: Private IP address of the IP configuration.
        :param str private_ip_address_version: Available from Api-Version 2016-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        :param str private_ip_allocation_method: Defines how a private IP address is assigned. Possible values are: 'Static' and 'Dynamic'.
        :param str provisioning_state: The provisioning state of the network interface IP configuration. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param 'PublicIPAddressResponse' public_ip_address: Public IP address bound to the IP configuration.
        :param 'SubnetResponse' subnet: Subnet bound to the IP configuration.
        :param Sequence['VirtualNetworkTapResponse'] virtual_network_taps: The reference to Virtual Network Taps.
        """
        if application_gateway_backend_address_pools is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pools", application_gateway_backend_address_pools)
        if application_security_groups is not None:
            pulumi.set(__self__, "application_security_groups", application_security_groups)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_inbound_nat_rules is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_rules", load_balancer_inbound_nat_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_address_version is not None:
            pulumi.set(__self__, "private_ip_address_version", private_ip_address_version)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if virtual_network_taps is not None:
            pulumi.set(__self__, "virtual_network_taps", virtual_network_taps)

    @property
    @pulumi.getter(name="applicationGatewayBackendAddressPools")
    def application_gateway_backend_address_pools(self) -> Optional[Sequence['outputs.ApplicationGatewayBackendAddressPoolResponse']]:
        """
        The reference of ApplicationGatewayBackendAddressPool resource.
        """
        return pulumi.get(self, "application_gateway_backend_address_pools")

    @property
    @pulumi.getter(name="applicationSecurityGroups")
    def application_security_groups(self) -> Optional[Sequence['outputs.ApplicationSecurityGroupResponse']]:
        """
        Application security groups in which the IP configuration is included.
        """
        return pulumi.get(self, "application_security_groups")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[Sequence['outputs.BackendAddressPoolResponse']]:
        """
        The reference of LoadBalancerBackendAddressPool resource.
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @property
    @pulumi.getter(name="loadBalancerInboundNatRules")
    def load_balancer_inbound_nat_rules(self) -> Optional[Sequence['outputs.InboundNatRuleResponse']]:
        """
        A list of references of LoadBalancerInboundNatRules.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_rules")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Gets whether this is a primary customer address on the network interface.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        Private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAddressVersion")
    def private_ip_address_version(self) -> Optional[str]:
        """
        Available from Api-Version 2016-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.
        """
        return pulumi.get(self, "private_ip_address_version")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        Defines how a private IP address is assigned. Possible values are: 'Static' and 'Dynamic'.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the network interface IP configuration. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.PublicIPAddressResponse']:
        """
        Public IP address bound to the IP configuration.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubnetResponse']:
        """
        Subnet bound to the IP configuration.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="virtualNetworkTaps")
    def virtual_network_taps(self) -> Optional[Sequence['outputs.VirtualNetworkTapResponse']]:
        """
        The reference to Virtual Network Taps.
        """
        return pulumi.get(self, "virtual_network_taps")


@pulumi.output_type
class NetworkInterfaceResponse(dict):
    """
    A network interface in a resource group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostedWorkloads":
            suggest = "hosted_workloads"
        elif key == "interfaceEndpoint":
            suggest = "interface_endpoint"
        elif key == "virtualMachine":
            suggest = "virtual_machine"
        elif key == "dnsSettings":
            suggest = "dns_settings"
        elif key == "enableAcceleratedNetworking":
            suggest = "enable_accelerated_networking"
        elif key == "enableIPForwarding":
            suggest = "enable_ip_forwarding"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "networkSecurityGroup":
            suggest = "network_security_group"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "tapConfigurations":
            suggest = "tap_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosted_workloads: Sequence[str],
                 interface_endpoint: 'outputs.InterfaceEndpointResponse',
                 name: str,
                 type: str,
                 virtual_machine: 'outputs.SubResourceResponse',
                 dns_settings: Optional['outputs.NetworkInterfaceDnsSettingsResponse'] = None,
                 enable_accelerated_networking: Optional[bool] = None,
                 enable_ip_forwarding: Optional[bool] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 ip_configurations: Optional[Sequence['outputs.NetworkInterfaceIPConfigurationResponse']] = None,
                 location: Optional[str] = None,
                 mac_address: Optional[str] = None,
                 network_security_group: Optional['outputs.NetworkSecurityGroupResponse'] = None,
                 primary: Optional[bool] = None,
                 provisioning_state: Optional[str] = None,
                 resource_guid: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 tap_configurations: Optional[Sequence['outputs.NetworkInterfaceTapConfigurationResponse']] = None):
        """
        A network interface in a resource group.
        :param Sequence[str] hosted_workloads: A list of references to linked BareMetal resources
        :param 'InterfaceEndpointResponse' interface_endpoint: A reference to the interface endpoint to which the network interface is linked.
        :param str name: Resource name.
        :param str type: Resource type.
        :param 'SubResourceResponse' virtual_machine: The reference of a virtual machine.
        :param 'NetworkInterfaceDnsSettingsResponse' dns_settings: The DNS settings in network interface.
        :param bool enable_accelerated_networking: If the network interface is accelerated networking enabled.
        :param bool enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network interface.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param Sequence['NetworkInterfaceIPConfigurationResponse'] ip_configurations: A list of IPConfigurations of the network interface.
        :param str location: Resource location.
        :param str mac_address: The MAC address of the network interface.
        :param 'NetworkSecurityGroupResponse' network_security_group: The reference of the NetworkSecurityGroup resource.
        :param bool primary: Gets whether this is a primary network interface on a virtual machine.
        :param str provisioning_state: The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str resource_guid: The resource GUID property of the network interface resource.
        :param Mapping[str, str] tags: Resource tags.
        :param Sequence['NetworkInterfaceTapConfigurationResponse'] tap_configurations: A list of TapConfigurations of the network interface.
        """
        pulumi.set(__self__, "hosted_workloads", hosted_workloads)
        pulumi.set(__self__, "interface_endpoint", interface_endpoint)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "virtual_machine", virtual_machine)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if resource_guid is not None:
            pulumi.set(__self__, "resource_guid", resource_guid)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tap_configurations is not None:
            pulumi.set(__self__, "tap_configurations", tap_configurations)

    @property
    @pulumi.getter(name="hostedWorkloads")
    def hosted_workloads(self) -> Sequence[str]:
        """
        A list of references to linked BareMetal resources
        """
        return pulumi.get(self, "hosted_workloads")

    @property
    @pulumi.getter(name="interfaceEndpoint")
    def interface_endpoint(self) -> 'outputs.InterfaceEndpointResponse':
        """
        A reference to the interface endpoint to which the network interface is linked.
        """
        return pulumi.get(self, "interface_endpoint")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> 'outputs.SubResourceResponse':
        """
        The reference of a virtual machine.
        """
        return pulumi.get(self, "virtual_machine")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional['outputs.NetworkInterfaceDnsSettingsResponse']:
        """
        The DNS settings in network interface.
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[bool]:
        """
        If the network interface is accelerated networking enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @property
    @pulumi.getter(name="enableIPForwarding")
    def enable_ip_forwarding(self) -> Optional[bool]:
        """
        Indicates whether IP forwarding is enabled on this network interface.
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.NetworkInterfaceIPConfigurationResponse']]:
        """
        A list of IPConfigurations of the network interface.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        """
        The MAC address of the network interface.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional['outputs.NetworkSecurityGroupResponse']:
        """
        The reference of the NetworkSecurityGroup resource.
        """
        return pulumi.get(self, "network_security_group")

    @property
    @pulumi.getter
    def primary(self) -> Optional[bool]:
        """
        Gets whether this is a primary network interface on a virtual machine.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> Optional[str]:
        """
        The resource GUID property of the network interface resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tapConfigurations")
    def tap_configurations(self) -> Optional[Sequence['outputs.NetworkInterfaceTapConfigurationResponse']]:
        """
        A list of TapConfigurations of the network interface.
        """
        return pulumi.get(self, "tap_configurations")


@pulumi.output_type
class NetworkInterfaceTapConfigurationResponse(dict):
    """
    Tap configuration in a Network Interface
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "virtualNetworkTap":
            suggest = "virtual_network_tap"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceTapConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceTapConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceTapConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 type: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 virtual_network_tap: Optional['outputs.VirtualNetworkTapResponse'] = None):
        """
        Tap configuration in a Network Interface
        :param str provisioning_state: The provisioning state of the network interface tap configuration. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str type: Sub Resource type.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'VirtualNetworkTapResponse' virtual_network_tap: The reference of the Virtual Network Tap resource.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_network_tap is not None:
            pulumi.set(__self__, "virtual_network_tap", virtual_network_tap)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the network interface tap configuration. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Sub Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="virtualNetworkTap")
    def virtual_network_tap(self) -> Optional['outputs.VirtualNetworkTapResponse']:
        """
        The reference of the Virtual Network Tap resource.
        """
        return pulumi.get(self, "virtual_network_tap")


@pulumi.output_type
class NetworkSecurityGroupResponse(dict):
    """
    NetworkSecurityGroup resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "defaultSecurityRules":
            suggest = "default_security_rules"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "securityRules":
            suggest = "security_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkSecurityGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkSecurityGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkSecurityGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 network_interfaces: Sequence['outputs.NetworkInterfaceResponse'],
                 subnets: Sequence['outputs.SubnetResponse'],
                 type: str,
                 default_security_rules: Optional[Sequence['outputs.SecurityRuleResponse']] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 resource_guid: Optional[str] = None,
                 security_rules: Optional[Sequence['outputs.SecurityRuleResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        NetworkSecurityGroup resource.
        :param str name: Resource name.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: A collection of references to network interfaces.
        :param Sequence['SubnetResponse'] subnets: A collection of references to subnets.
        :param str type: Resource type.
        :param Sequence['SecurityRuleResponse'] default_security_rules: The default security rules of network security group.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param str provisioning_state: The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str resource_guid: The resource GUID property of the network security group resource.
        :param Sequence['SecurityRuleResponse'] security_rules: A collection of security rules of the network security group.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if default_security_rules is not None:
            pulumi.set(__self__, "default_security_rules", default_security_rules)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if resource_guid is not None:
            pulumi.set(__self__, "resource_guid", resource_guid)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.NetworkInterfaceResponse']:
        """
        A collection of references to network interfaces.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.SubnetResponse']:
        """
        A collection of references to subnets.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="defaultSecurityRules")
    def default_security_rules(self) -> Optional[Sequence['outputs.SecurityRuleResponse']]:
        """
        The default security rules of network security group.
        """
        return pulumi.get(self, "default_security_rules")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> Optional[str]:
        """
        The resource GUID property of the network security group resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[Sequence['outputs.SecurityRuleResponse']]:
        """
        A collection of security rules of the network security group.
        """
        return pulumi.get(self, "security_rules")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class OutboundRuleResponse(dict):
    """
    Outbound rule of the load balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendAddressPool":
            suggest = "backend_address_pool"
        elif key == "frontendIPConfigurations":
            suggest = "frontend_ip_configurations"
        elif key == "allocatedOutboundPorts":
            suggest = "allocated_outbound_ports"
        elif key == "enableTcpReset":
            suggest = "enable_tcp_reset"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutboundRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutboundRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutboundRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_address_pool: 'outputs.SubResourceResponse',
                 frontend_ip_configurations: Sequence['outputs.SubResourceResponse'],
                 protocol: str,
                 allocated_outbound_ports: Optional[int] = None,
                 enable_tcp_reset: Optional[bool] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 name: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Outbound rule of the load balancer.
        :param 'SubResourceResponse' backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        :param Sequence['SubResourceResponse'] frontend_ip_configurations: The Frontend IP addresses of the load balancer.
        :param str protocol: Protocol - TCP, UDP or All
        :param int allocated_outbound_ports: The number of outbound ports to be used for NAT.
        :param bool enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The timeout for the TCP idle connection
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "backend_address_pool", backend_address_pool)
        pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        pulumi.set(__self__, "protocol", protocol)
        if allocated_outbound_ports is not None:
            pulumi.set(__self__, "allocated_outbound_ports", allocated_outbound_ports)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="backendAddressPool")
    def backend_address_pool(self) -> 'outputs.SubResourceResponse':
        """
        A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool")

    @property
    @pulumi.getter(name="frontendIPConfigurations")
    def frontend_ip_configurations(self) -> Sequence['outputs.SubResourceResponse']:
        """
        The Frontend IP addresses of the load balancer.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol - TCP, UDP or All
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="allocatedOutboundPorts")
    def allocated_outbound_ports(self) -> Optional[int]:
        """
        The number of outbound ports to be used for NAT.
        """
        return pulumi.get(self, "allocated_outbound_ports")

    @property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[bool]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The timeout for the TCP idle connection
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class P2SVpnServerConfigRadiusClientRootCertificateResponse(dict):
    """
    Radius client root certificate of P2SVpnServerConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in P2SVpnServerConfigRadiusClientRootCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        P2SVpnServerConfigRadiusClientRootCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        P2SVpnServerConfigRadiusClientRootCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        Radius client root certificate of P2SVpnServerConfiguration.
        :param str provisioning_state: The provisioning state of the Radius client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str thumbprint: The Radius client root certificate thumbprint.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the Radius client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The Radius client root certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class P2SVpnServerConfigRadiusServerRootCertificateResponse(dict):
    """
    Radius Server root certificate of P2SVpnServerConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicCertData":
            suggest = "public_cert_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in P2SVpnServerConfigRadiusServerRootCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        P2SVpnServerConfigRadiusServerRootCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        P2SVpnServerConfigRadiusServerRootCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 public_cert_data: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Radius Server root certificate of P2SVpnServerConfiguration.
        :param str provisioning_state: The provisioning state of the P2SVpnServerConfiguration Radius Server root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str public_cert_data: The certificate public data.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "public_cert_data", public_cert_data)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the P2SVpnServerConfiguration Radius Server root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> str:
        """
        The certificate public data.
        """
        return pulumi.get(self, "public_cert_data")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class P2SVpnServerConfigVpnClientRevokedCertificateResponse(dict):
    """
    VPN client revoked certificate of P2SVpnServerConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in P2SVpnServerConfigVpnClientRevokedCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        P2SVpnServerConfigVpnClientRevokedCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        P2SVpnServerConfigVpnClientRevokedCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        VPN client revoked certificate of P2SVpnServerConfiguration.
        :param str provisioning_state: The provisioning state of the VPN client revoked certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str thumbprint: The revoked VPN client certificate thumbprint.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VPN client revoked certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The revoked VPN client certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class P2SVpnServerConfigVpnClientRootCertificateResponse(dict):
    """
    VPN client root certificate of P2SVpnServerConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicCertData":
            suggest = "public_cert_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in P2SVpnServerConfigVpnClientRootCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        P2SVpnServerConfigVpnClientRootCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        P2SVpnServerConfigVpnClientRootCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 public_cert_data: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        VPN client root certificate of P2SVpnServerConfiguration.
        :param str provisioning_state: The provisioning state of the P2SVpnServerConfiguration VPN client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str public_cert_data: The certificate public data.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "public_cert_data", public_cert_data)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the P2SVpnServerConfiguration VPN client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> str:
        """
        The certificate public data.
        """
        return pulumi.get(self, "public_cert_data")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class P2SVpnServerConfigurationResponse(dict):
    """
    P2SVpnServerConfiguration Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "p2SVpnGateways":
            suggest = "p2_s_vpn_gateways"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "p2SVpnServerConfigRadiusClientRootCertificates":
            suggest = "p2_s_vpn_server_config_radius_client_root_certificates"
        elif key == "p2SVpnServerConfigRadiusServerRootCertificates":
            suggest = "p2_s_vpn_server_config_radius_server_root_certificates"
        elif key == "p2SVpnServerConfigVpnClientRevokedCertificates":
            suggest = "p2_s_vpn_server_config_vpn_client_revoked_certificates"
        elif key == "p2SVpnServerConfigVpnClientRootCertificates":
            suggest = "p2_s_vpn_server_config_vpn_client_root_certificates"
        elif key == "radiusServerAddress":
            suggest = "radius_server_address"
        elif key == "radiusServerSecret":
            suggest = "radius_server_secret"
        elif key == "vpnClientIpsecPolicies":
            suggest = "vpn_client_ipsec_policies"
        elif key == "vpnProtocols":
            suggest = "vpn_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in P2SVpnServerConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        P2SVpnServerConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        P2SVpnServerConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 p2_s_vpn_gateways: Sequence['outputs.SubResourceResponse'],
                 provisioning_state: str,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 p2_s_vpn_server_config_radius_client_root_certificates: Optional[Sequence['outputs.P2SVpnServerConfigRadiusClientRootCertificateResponse']] = None,
                 p2_s_vpn_server_config_radius_server_root_certificates: Optional[Sequence['outputs.P2SVpnServerConfigRadiusServerRootCertificateResponse']] = None,
                 p2_s_vpn_server_config_vpn_client_revoked_certificates: Optional[Sequence['outputs.P2SVpnServerConfigVpnClientRevokedCertificateResponse']] = None,
                 p2_s_vpn_server_config_vpn_client_root_certificates: Optional[Sequence['outputs.P2SVpnServerConfigVpnClientRootCertificateResponse']] = None,
                 radius_server_address: Optional[str] = None,
                 radius_server_secret: Optional[str] = None,
                 vpn_client_ipsec_policies: Optional[Sequence['outputs.IpsecPolicyResponse']] = None,
                 vpn_protocols: Optional[Sequence[str]] = None):
        """
        P2SVpnServerConfiguration Resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the P2SVpnServerConfiguration resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str id: Resource ID.
        :param str name: The name of the P2SVpnServerConfiguration that is unique within a VirtualWan in a resource group. This name can be used to access the resource along with Parent VirtualWan resource name.
        :param Sequence['P2SVpnServerConfigRadiusClientRootCertificateResponse'] p2_s_vpn_server_config_radius_client_root_certificates: Radius client root certificate of P2SVpnServerConfiguration.
        :param Sequence['P2SVpnServerConfigRadiusServerRootCertificateResponse'] p2_s_vpn_server_config_radius_server_root_certificates: Radius Server root certificate of P2SVpnServerConfiguration.
        :param Sequence['P2SVpnServerConfigVpnClientRevokedCertificateResponse'] p2_s_vpn_server_config_vpn_client_revoked_certificates: VPN client revoked certificate of P2SVpnServerConfiguration.
        :param Sequence['P2SVpnServerConfigVpnClientRootCertificateResponse'] p2_s_vpn_server_config_vpn_client_root_certificates: VPN client root certificate of P2SVpnServerConfiguration.
        :param str radius_server_address: The radius server address property of the P2SVpnServerConfiguration resource for point to site client connection.
        :param str radius_server_secret: The radius secret property of the P2SVpnServerConfiguration resource for point to site client connection.
        :param Sequence['IpsecPolicyResponse'] vpn_client_ipsec_policies: VpnClientIpsecPolicies for P2SVpnServerConfiguration.
        :param Sequence[str] vpn_protocols: vpnProtocols for the P2SVpnServerConfiguration.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "p2_s_vpn_gateways", p2_s_vpn_gateways)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if p2_s_vpn_server_config_radius_client_root_certificates is not None:
            pulumi.set(__self__, "p2_s_vpn_server_config_radius_client_root_certificates", p2_s_vpn_server_config_radius_client_root_certificates)
        if p2_s_vpn_server_config_radius_server_root_certificates is not None:
            pulumi.set(__self__, "p2_s_vpn_server_config_radius_server_root_certificates", p2_s_vpn_server_config_radius_server_root_certificates)
        if p2_s_vpn_server_config_vpn_client_revoked_certificates is not None:
            pulumi.set(__self__, "p2_s_vpn_server_config_vpn_client_revoked_certificates", p2_s_vpn_server_config_vpn_client_revoked_certificates)
        if p2_s_vpn_server_config_vpn_client_root_certificates is not None:
            pulumi.set(__self__, "p2_s_vpn_server_config_vpn_client_root_certificates", p2_s_vpn_server_config_vpn_client_root_certificates)
        if radius_server_address is not None:
            pulumi.set(__self__, "radius_server_address", radius_server_address)
        if radius_server_secret is not None:
            pulumi.set(__self__, "radius_server_secret", radius_server_secret)
        if vpn_client_ipsec_policies is not None:
            pulumi.set(__self__, "vpn_client_ipsec_policies", vpn_client_ipsec_policies)
        if vpn_protocols is not None:
            pulumi.set(__self__, "vpn_protocols", vpn_protocols)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="p2SVpnGateways")
    def p2_s_vpn_gateways(self) -> Sequence['outputs.SubResourceResponse']:
        return pulumi.get(self, "p2_s_vpn_gateways")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the P2SVpnServerConfiguration resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the P2SVpnServerConfiguration that is unique within a VirtualWan in a resource group. This name can be used to access the resource along with Parent VirtualWan resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="p2SVpnServerConfigRadiusClientRootCertificates")
    def p2_s_vpn_server_config_radius_client_root_certificates(self) -> Optional[Sequence['outputs.P2SVpnServerConfigRadiusClientRootCertificateResponse']]:
        """
        Radius client root certificate of P2SVpnServerConfiguration.
        """
        return pulumi.get(self, "p2_s_vpn_server_config_radius_client_root_certificates")

    @property
    @pulumi.getter(name="p2SVpnServerConfigRadiusServerRootCertificates")
    def p2_s_vpn_server_config_radius_server_root_certificates(self) -> Optional[Sequence['outputs.P2SVpnServerConfigRadiusServerRootCertificateResponse']]:
        """
        Radius Server root certificate of P2SVpnServerConfiguration.
        """
        return pulumi.get(self, "p2_s_vpn_server_config_radius_server_root_certificates")

    @property
    @pulumi.getter(name="p2SVpnServerConfigVpnClientRevokedCertificates")
    def p2_s_vpn_server_config_vpn_client_revoked_certificates(self) -> Optional[Sequence['outputs.P2SVpnServerConfigVpnClientRevokedCertificateResponse']]:
        """
        VPN client revoked certificate of P2SVpnServerConfiguration.
        """
        return pulumi.get(self, "p2_s_vpn_server_config_vpn_client_revoked_certificates")

    @property
    @pulumi.getter(name="p2SVpnServerConfigVpnClientRootCertificates")
    def p2_s_vpn_server_config_vpn_client_root_certificates(self) -> Optional[Sequence['outputs.P2SVpnServerConfigVpnClientRootCertificateResponse']]:
        """
        VPN client root certificate of P2SVpnServerConfiguration.
        """
        return pulumi.get(self, "p2_s_vpn_server_config_vpn_client_root_certificates")

    @property
    @pulumi.getter(name="radiusServerAddress")
    def radius_server_address(self) -> Optional[str]:
        """
        The radius server address property of the P2SVpnServerConfiguration resource for point to site client connection.
        """
        return pulumi.get(self, "radius_server_address")

    @property
    @pulumi.getter(name="radiusServerSecret")
    def radius_server_secret(self) -> Optional[str]:
        """
        The radius secret property of the P2SVpnServerConfiguration resource for point to site client connection.
        """
        return pulumi.get(self, "radius_server_secret")

    @property
    @pulumi.getter(name="vpnClientIpsecPolicies")
    def vpn_client_ipsec_policies(self) -> Optional[Sequence['outputs.IpsecPolicyResponse']]:
        """
        VpnClientIpsecPolicies for P2SVpnServerConfiguration.
        """
        return pulumi.get(self, "vpn_client_ipsec_policies")

    @property
    @pulumi.getter(name="vpnProtocols")
    def vpn_protocols(self) -> Optional[Sequence[str]]:
        """
        vpnProtocols for the P2SVpnServerConfiguration.
        """
        return pulumi.get(self, "vpn_protocols")


@pulumi.output_type
class PacketCaptureFilterResponse(dict):
    """
    Filter that is applied to packet capture request. Multiple filters can be applied.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localIPAddress":
            suggest = "local_ip_address"
        elif key == "localPort":
            suggest = "local_port"
        elif key == "remoteIPAddress":
            suggest = "remote_ip_address"
        elif key == "remotePort":
            suggest = "remote_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketCaptureFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketCaptureFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketCaptureFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_ip_address: Optional[str] = None,
                 local_port: Optional[str] = None,
                 protocol: Optional[str] = None,
                 remote_ip_address: Optional[str] = None,
                 remote_port: Optional[str] = None):
        """
        Filter that is applied to packet capture request. Multiple filters can be applied.
        :param str local_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param str local_port: Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param str protocol: Protocol to be filtered on.
        :param str remote_ip_address: Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        :param str remote_port: Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        if local_ip_address is not None:
            pulumi.set(__self__, "local_ip_address", local_ip_address)
        if local_port is not None:
            pulumi.set(__self__, "local_port", local_port)
        if protocol is None:
            protocol = 'Any'
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remote_ip_address is not None:
            pulumi.set(__self__, "remote_ip_address", remote_ip_address)
        if remote_port is not None:
            pulumi.set(__self__, "remote_port", remote_port)

    @property
    @pulumi.getter(name="localIPAddress")
    def local_ip_address(self) -> Optional[str]:
        """
        Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "local_ip_address")

    @property
    @pulumi.getter(name="localPort")
    def local_port(self) -> Optional[str]:
        """
        Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "local_port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Protocol to be filtered on.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="remoteIPAddress")
    def remote_ip_address(self) -> Optional[str]:
        """
        Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "remote_ip_address")

    @property
    @pulumi.getter(name="remotePort")
    def remote_port(self) -> Optional[str]:
        """
        Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
        """
        return pulumi.get(self, "remote_port")


@pulumi.output_type
class PacketCaptureStorageLocationResponse(dict):
    """
    Describes the storage location for a packet capture session.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePath":
            suggest = "file_path"
        elif key == "storageId":
            suggest = "storage_id"
        elif key == "storagePath":
            suggest = "storage_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketCaptureStorageLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketCaptureStorageLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketCaptureStorageLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_path: Optional[str] = None,
                 storage_id: Optional[str] = None,
                 storage_path: Optional[str] = None):
        """
        Describes the storage location for a packet capture session.
        :param str file_path: A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
        :param str storage_id: The ID of the storage account to save the packet capture session. Required if no local file path is provided.
        :param str storage_path: The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
        """
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if storage_id is not None:
            pulumi.set(__self__, "storage_id", storage_id)
        if storage_path is not None:
            pulumi.set(__self__, "storage_path", storage_path)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[str]:
        """
        A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter(name="storageId")
    def storage_id(self) -> Optional[str]:
        """
        The ID of the storage account to save the packet capture session. Required if no local file path is provided.
        """
        return pulumi.get(self, "storage_id")

    @property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> Optional[str]:
        """
        The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
        """
        return pulumi.get(self, "storage_path")


@pulumi.output_type
class ProbeResponse(dict):
    """
    A load balancer probe.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancingRules":
            suggest = "load_balancing_rules"
        elif key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "numberOfProbes":
            suggest = "number_of_probes"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "requestPath":
            suggest = "request_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProbeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProbeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProbeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 load_balancing_rules: Sequence['outputs.SubResourceResponse'],
                 port: int,
                 protocol: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 interval_in_seconds: Optional[int] = None,
                 name: Optional[str] = None,
                 number_of_probes: Optional[int] = None,
                 provisioning_state: Optional[str] = None,
                 request_path: Optional[str] = None):
        """
        A load balancer probe.
        :param Sequence['SubResourceResponse'] load_balancing_rules: The load balancer rules that use this probe.
        :param int port: The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
        :param str protocol: The protocol of the end point. Possible values are: 'Http', 'Tcp', or 'Https'. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param int interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
        :param str name: Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int number_of_probes: The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
        :param str provisioning_state: Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str request_path: The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        """
        pulumi.set(__self__, "load_balancing_rules", load_balancing_rules)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_probes is not None:
            pulumi.set(__self__, "number_of_probes", number_of_probes)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)

    @property
    @pulumi.getter(name="loadBalancingRules")
    def load_balancing_rules(self) -> Sequence['outputs.SubResourceResponse']:
        """
        The load balancer rules that use this probe.
        """
        return pulumi.get(self, "load_balancing_rules")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol of the end point. Possible values are: 'Http', 'Tcp', or 'Https'. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[int]:
        """
        The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfProbes")
    def number_of_probes(self) -> Optional[int]:
        """
        The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.
        """
        return pulumi.get(self, "number_of_probes")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[str]:
        """
        The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        """
        return pulumi.get(self, "request_path")


@pulumi.output_type
class PublicIPAddressDnsSettingsResponse(dict):
    """
    Contains FQDN of the DNS record associated with the public IP address
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNameLabel":
            suggest = "domain_name_label"
        elif key == "reverseFqdn":
            suggest = "reverse_fqdn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicIPAddressDnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicIPAddressDnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicIPAddressDnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name_label: Optional[str] = None,
                 fqdn: Optional[str] = None,
                 reverse_fqdn: Optional[str] = None):
        """
        Contains FQDN of the DNS record associated with the public IP address
        :param str domain_name_label: Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        :param str fqdn: Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        :param str reverse_fqdn: Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN. 
        """
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if reverse_fqdn is not None:
            pulumi.set(__self__, "reverse_fqdn", reverse_fqdn)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[str]:
        """
        Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
        """
        return pulumi.get(self, "domain_name_label")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="reverseFqdn")
    def reverse_fqdn(self) -> Optional[str]:
        """
        Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN. 
        """
        return pulumi.get(self, "reverse_fqdn")


@pulumi.output_type
class PublicIPAddressResponse(dict):
    """
    Public IP address resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "dnsSettings":
            suggest = "dns_settings"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipTags":
            suggest = "ip_tags"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicIPAddressVersion":
            suggest = "public_ip_address_version"
        elif key == "publicIPAllocationMethod":
            suggest = "public_ip_allocation_method"
        elif key == "publicIPPrefix":
            suggest = "public_ip_prefix"
        elif key == "resourceGuid":
            suggest = "resource_guid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicIPAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicIPAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicIPAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configuration: 'outputs.IPConfigurationResponse',
                 name: str,
                 type: str,
                 dns_settings: Optional['outputs.PublicIPAddressDnsSettingsResponse'] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 idle_timeout_in_minutes: Optional[int] = None,
                 ip_address: Optional[str] = None,
                 ip_tags: Optional[Sequence['outputs.IpTagResponse']] = None,
                 location: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 public_ip_address_version: Optional[str] = None,
                 public_ip_allocation_method: Optional[str] = None,
                 public_ip_prefix: Optional['outputs.SubResourceResponse'] = None,
                 resource_guid: Optional[str] = None,
                 sku: Optional['outputs.PublicIPAddressSkuResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        Public IP address resource.
        :param 'IPConfigurationResponse' ip_configuration: The IP configuration associated with the public IP address.
        :param str name: Resource name.
        :param str type: Resource type.
        :param 'PublicIPAddressDnsSettingsResponse' dns_settings: The FQDN of the DNS record associated with the public IP address.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param int idle_timeout_in_minutes: The idle timeout of the public IP address.
        :param str ip_address: The IP address associated with the public IP address resource.
        :param Sequence['IpTagResponse'] ip_tags: The list of tags associated with the public IP address.
        :param str location: Resource location.
        :param str provisioning_state: The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str public_ip_address_version: The public IP address version. Possible values are: 'IPv4' and 'IPv6'.
        :param str public_ip_allocation_method: The public IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        :param 'SubResourceResponse' public_ip_prefix: The Public IP Prefix this Public IP Address should be allocated from.
        :param str resource_guid: The resource GUID property of the public IP resource.
        :param 'PublicIPAddressSkuResponse' sku: The public IP address SKU.
        :param Mapping[str, str] tags: Resource tags.
        :param Sequence[str] zones: A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        pulumi.set(__self__, "ip_configuration", ip_configuration)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_tags is not None:
            pulumi.set(__self__, "ip_tags", ip_tags)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_address_version is not None:
            pulumi.set(__self__, "public_ip_address_version", public_ip_address_version)
        if public_ip_allocation_method is not None:
            pulumi.set(__self__, "public_ip_allocation_method", public_ip_allocation_method)
        if public_ip_prefix is not None:
            pulumi.set(__self__, "public_ip_prefix", public_ip_prefix)
        if resource_guid is not None:
            pulumi.set(__self__, "resource_guid", resource_guid)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> 'outputs.IPConfigurationResponse':
        """
        The IP configuration associated with the public IP address.
        """
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional['outputs.PublicIPAddressDnsSettingsResponse']:
        """
        The FQDN of the DNS record associated with the public IP address.
        """
        return pulumi.get(self, "dns_settings")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[int]:
        """
        The idle timeout of the public IP address.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP address associated with the public IP address resource.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Optional[Sequence['outputs.IpTagResponse']]:
        """
        The list of tags associated with the public IP address.
        """
        return pulumi.get(self, "ip_tags")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPAddressVersion")
    def public_ip_address_version(self) -> Optional[str]:
        """
        The public IP address version. Possible values are: 'IPv4' and 'IPv6'.
        """
        return pulumi.get(self, "public_ip_address_version")

    @property
    @pulumi.getter(name="publicIPAllocationMethod")
    def public_ip_allocation_method(self) -> Optional[str]:
        """
        The public IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        """
        return pulumi.get(self, "public_ip_allocation_method")

    @property
    @pulumi.getter(name="publicIPPrefix")
    def public_ip_prefix(self) -> Optional['outputs.SubResourceResponse']:
        """
        The Public IP Prefix this Public IP Address should be allocated from.
        """
        return pulumi.get(self, "public_ip_prefix")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> Optional[str]:
        """
        The resource GUID property of the public IP resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.PublicIPAddressSkuResponse']:
        """
        The public IP address SKU.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        A list of availability zones denoting the IP allocated for the resource needs to come from.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class PublicIPAddressSkuResponse(dict):
    """
    SKU of a public IP address
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        SKU of a public IP address
        :param str name: Name of a public IP address SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of a public IP address SKU.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PublicIPPrefixSkuResponse(dict):
    """
    SKU of a public IP prefix
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        SKU of a public IP prefix
        :param str name: Name of a public IP prefix SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of a public IP prefix SKU.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ReferencedPublicIpAddressResponse(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        :param str id: The PublicIPAddress Reference
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The PublicIPAddress Reference
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ResourceNavigationLinkResponse(dict):
    """
    ResourceNavigationLink resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "linkedResourceType":
            suggest = "linked_resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceNavigationLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceNavigationLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceNavigationLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 id: Optional[str] = None,
                 link: Optional[str] = None,
                 linked_resource_type: Optional[str] = None,
                 name: Optional[str] = None):
        """
        ResourceNavigationLink resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: Provisioning state of the ResourceNavigationLink resource.
        :param str id: Resource ID.
        :param str link: Link to the external resource
        :param str linked_resource_type: Resource type of the linked resource.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if linked_resource_type is not None:
            pulumi.set(__self__, "linked_resource_type", linked_resource_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the ResourceNavigationLink resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Link to the external resource
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter(name="linkedResourceType")
    def linked_resource_type(self) -> Optional[str]:
        """
        Resource type of the linked resource.
        """
        return pulumi.get(self, "linked_resource_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RouteFilterResponse(dict):
    """
    Route Filter Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 location: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 id: Optional[str] = None,
                 peerings: Optional[Sequence['outputs.ExpressRouteCircuitPeeringResponse']] = None,
                 rules: Optional[Sequence['outputs.RouteFilterRuleResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Route Filter Resource.
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param str location: Resource location.
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
        :param str type: Resource type.
        :param str id: Resource ID.
        :param Sequence['ExpressRouteCircuitPeeringResponse'] peerings: A collection of references to express route circuit peerings.
        :param Sequence['RouteFilterRuleResponse'] rules: Collection of RouteFilterRules contained within a route filter.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if peerings is not None:
            pulumi.set(__self__, "peerings", peerings)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def peerings(self) -> Optional[Sequence['outputs.ExpressRouteCircuitPeeringResponse']]:
        """
        A collection of references to express route circuit peerings.
        """
        return pulumi.get(self, "peerings")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.RouteFilterRuleResponse']]:
        """
        Collection of RouteFilterRules contained within a route filter.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class RouteFilterRuleResponse(dict):
    """
    Route Filter Rule Resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "routeFilterRuleType":
            suggest = "route_filter_rule_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteFilterRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteFilterRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteFilterRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: str,
                 communities: Sequence[str],
                 etag: str,
                 provisioning_state: str,
                 route_filter_rule_type: str,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Route Filter Rule Resource
        :param str access: The access type of the rule. Valid values are: 'Allow', 'Deny'
        :param Sequence[str] communities: The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020']
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
        :param str route_filter_rule_type: The rule type of the rule. Valid value is: 'Community'
        :param str id: Resource ID.
        :param str location: Resource location.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "communities", communities)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "route_filter_rule_type", route_filter_rule_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        The access type of the rule. Valid values are: 'Allow', 'Deny'
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def communities(self) -> Sequence[str]:
        """
        The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020']
        """
        return pulumi.get(self, "communities")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', 'Succeeded' and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="routeFilterRuleType")
    def route_filter_rule_type(self) -> str:
        """
        The rule type of the rule. Valid value is: 'Community'
        """
        return pulumi.get(self, "route_filter_rule_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RouteResponse(dict):
    """
    Route resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nextHopType":
            suggest = "next_hop_type"
        elif key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "nextHopIpAddress":
            suggest = "next_hop_ip_address"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 next_hop_type: str,
                 address_prefix: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 next_hop_ip_address: Optional[str] = None,
                 provisioning_state: Optional[str] = None):
        """
        Route resource
        :param str next_hop_type: The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'
        :param str address_prefix: The destination CIDR to which the route applies.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        :param str provisioning_state: The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> str:
        """
        The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        The destination CIDR to which the route applies.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[str]:
        """
        The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        return pulumi.get(self, "next_hop_ip_address")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class RouteTableResponse(dict):
    """
    Route table resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableBgpRoutePropagation":
            suggest = "disable_bgp_route_propagation"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 subnets: Sequence['outputs.SubnetResponse'],
                 type: str,
                 disable_bgp_route_propagation: Optional[bool] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 routes: Optional[Sequence['outputs.RouteResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Route table resource.
        :param str name: Resource name.
        :param Sequence['SubnetResponse'] subnets: A collection of references to subnets.
        :param str type: Resource type.
        :param bool disable_bgp_route_propagation: Gets or sets whether to disable the routes learned by BGP on that route table. True means disable.
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param str provisioning_state: The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param Sequence['RouteResponse'] routes: Collection of routes contained within a route table.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if disable_bgp_route_propagation is not None:
            pulumi.set(__self__, "disable_bgp_route_propagation", disable_bgp_route_propagation)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.SubnetResponse']:
        """
        A collection of references to subnets.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="disableBgpRoutePropagation")
    def disable_bgp_route_propagation(self) -> Optional[bool]:
        """
        Gets or sets whether to disable the routes learned by BGP on that route table. True means disable.
        """
        return pulumi.get(self, "disable_bgp_route_propagation")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.RouteResponse']]:
        """
        Collection of routes contained within a route table.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class SecurityRuleResponse(dict):
    """
    Network security rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddressPrefix":
            suggest = "destination_address_prefix"
        elif key == "destinationAddressPrefixes":
            suggest = "destination_address_prefixes"
        elif key == "destinationApplicationSecurityGroups":
            suggest = "destination_application_security_groups"
        elif key == "destinationPortRange":
            suggest = "destination_port_range"
        elif key == "destinationPortRanges":
            suggest = "destination_port_ranges"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "sourceAddressPrefix":
            suggest = "source_address_prefix"
        elif key == "sourceAddressPrefixes":
            suggest = "source_address_prefixes"
        elif key == "sourceApplicationSecurityGroups":
            suggest = "source_application_security_groups"
        elif key == "sourcePortRange":
            suggest = "source_port_range"
        elif key == "sourcePortRanges":
            suggest = "source_port_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: str,
                 direction: str,
                 protocol: str,
                 description: Optional[str] = None,
                 destination_address_prefix: Optional[str] = None,
                 destination_address_prefixes: Optional[Sequence[str]] = None,
                 destination_application_security_groups: Optional[Sequence['outputs.ApplicationSecurityGroupResponse']] = None,
                 destination_port_range: Optional[str] = None,
                 destination_port_ranges: Optional[Sequence[str]] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 provisioning_state: Optional[str] = None,
                 source_address_prefix: Optional[str] = None,
                 source_address_prefixes: Optional[Sequence[str]] = None,
                 source_application_security_groups: Optional[Sequence['outputs.ApplicationSecurityGroupResponse']] = None,
                 source_port_range: Optional[str] = None,
                 source_port_ranges: Optional[Sequence[str]] = None):
        """
        Network security rule.
        :param str access: The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.
        :param str direction: The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'.
        :param str protocol: Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'.
        :param str description: A description for this rule. Restricted to 140 chars.
        :param str destination_address_prefix: The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        :param Sequence[str] destination_address_prefixes: The destination address prefixes. CIDR or destination IP ranges.
        :param Sequence['ApplicationSecurityGroupResponse'] destination_application_security_groups: The application security group specified as destination.
        :param str destination_port_range: The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        :param Sequence[str] destination_port_ranges: The destination port ranges.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param int priority: The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param str provisioning_state: The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. 
        :param Sequence[str] source_address_prefixes: The CIDR or source IP ranges.
        :param Sequence['ApplicationSecurityGroupResponse'] source_application_security_groups: The application security group specified as source.
        :param str source_port_range: The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        :param Sequence[str] source_port_ranges: The source port ranges.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address_prefix is not None:
            pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        if destination_address_prefixes is not None:
            pulumi.set(__self__, "destination_address_prefixes", destination_address_prefixes)
        if destination_application_security_groups is not None:
            pulumi.set(__self__, "destination_application_security_groups", destination_application_security_groups)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if destination_port_ranges is not None:
            pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if source_address_prefix is not None:
            pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_address_prefixes is not None:
            pulumi.set(__self__, "source_address_prefixes", source_address_prefixes)
        if source_application_security_groups is not None:
            pulumi.set(__self__, "source_application_security_groups", source_application_security_groups)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> Optional[str]:
        """
        The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.
        """
        return pulumi.get(self, "destination_address_prefix")

    @property
    @pulumi.getter(name="destinationAddressPrefixes")
    def destination_address_prefixes(self) -> Optional[Sequence[str]]:
        """
        The destination address prefixes. CIDR or destination IP ranges.
        """
        return pulumi.get(self, "destination_address_prefixes")

    @property
    @pulumi.getter(name="destinationApplicationSecurityGroups")
    def destination_application_security_groups(self) -> Optional[Sequence['outputs.ApplicationSecurityGroupResponse']]:
        """
        The application security group specified as destination.
        """
        return pulumi.get(self, "destination_application_security_groups")

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[str]:
        """
        The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        return pulumi.get(self, "destination_port_range")

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Optional[Sequence[str]]:
        """
        The destination port ranges.
        """
        return pulumi.get(self, "destination_port_ranges")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> Optional[str]:
        """
        The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. 
        """
        return pulumi.get(self, "source_address_prefix")

    @property
    @pulumi.getter(name="sourceAddressPrefixes")
    def source_address_prefixes(self) -> Optional[Sequence[str]]:
        """
        The CIDR or source IP ranges.
        """
        return pulumi.get(self, "source_address_prefixes")

    @property
    @pulumi.getter(name="sourceApplicationSecurityGroups")
    def source_application_security_groups(self) -> Optional[Sequence['outputs.ApplicationSecurityGroupResponse']]:
        """
        The application security group specified as source.
        """
        return pulumi.get(self, "source_application_security_groups")

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[str]:
        """
        The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.
        """
        return pulumi.get(self, "source_port_range")

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[Sequence[str]]:
        """
        The source port ranges.
        """
        return pulumi.get(self, "source_port_ranges")


@pulumi.output_type
class ServiceAssociationLinkResponse(dict):
    """
    ServiceAssociationLink resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "linkedResourceType":
            suggest = "linked_resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAssociationLinkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAssociationLinkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAssociationLinkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 provisioning_state: str,
                 id: Optional[str] = None,
                 link: Optional[str] = None,
                 linked_resource_type: Optional[str] = None,
                 name: Optional[str] = None):
        """
        ServiceAssociationLink resource.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str provisioning_state: Provisioning state of the ServiceAssociationLink resource.
        :param str id: Resource ID.
        :param str link: Link to the external resource.
        :param str linked_resource_type: Resource type of the linked resource.
        :param str name: Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if linked_resource_type is not None:
            pulumi.set(__self__, "linked_resource_type", linked_resource_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the ServiceAssociationLink resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Link to the external resource.
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter(name="linkedResourceType")
    def linked_resource_type(self) -> Optional[str]:
        """
        Resource type of the linked resource.
        """
        return pulumi.get(self, "linked_resource_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceEndpointPolicyDefinitionResponse(dict):
    """
    Service Endpoint policy definitions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "serviceResources":
            suggest = "service_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointPolicyDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointPolicyDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointPolicyDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 description: Optional[str] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 service: Optional[str] = None,
                 service_resources: Optional[Sequence[str]] = None):
        """
        Service Endpoint policy definitions.
        :param str provisioning_state: The provisioning state of the service end point policy definition. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str description: A description for this rule. Restricted to 140 chars.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str service: service endpoint name.
        :param Sequence[str] service_resources: A list of service resources.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_resources is not None:
            pulumi.set(__self__, "service_resources", service_resources)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the service end point policy definition. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> Optional[str]:
        """
        service endpoint name.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceResources")
    def service_resources(self) -> Optional[Sequence[str]]:
        """
        A list of service resources.
        """
        return pulumi.get(self, "service_resources")


@pulumi.output_type
class ServiceEndpointPolicyResponse(dict):
    """
    Service End point policy resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "serviceEndpointPolicyDefinitions":
            suggest = "service_endpoint_policy_definitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 provisioning_state: str,
                 resource_guid: str,
                 subnets: Sequence['outputs.SubnetResponse'],
                 type: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 service_endpoint_policy_definitions: Optional[Sequence['outputs.ServiceEndpointPolicyDefinitionResponse']] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Service End point policy resource.
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the service endpoint policy. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str resource_guid: The resource GUID property of the service endpoint policy resource.
        :param Sequence['SubnetResponse'] subnets: A collection of references to subnets.
        :param str type: Resource type.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Sequence['ServiceEndpointPolicyDefinitionResponse'] service_endpoint_policy_definitions: A collection of service endpoint policy definitions of the service endpoint policy.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if service_endpoint_policy_definitions is not None:
            pulumi.set(__self__, "service_endpoint_policy_definitions", service_endpoint_policy_definitions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the service endpoint policy. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resource GUID property of the service endpoint policy resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.SubnetResponse']:
        """
        A collection of references to subnets.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="serviceEndpointPolicyDefinitions")
    def service_endpoint_policy_definitions(self) -> Optional[Sequence['outputs.ServiceEndpointPolicyDefinitionResponse']]:
        """
        A collection of service endpoint policy definitions of the service endpoint policy.
        """
        return pulumi.get(self, "service_endpoint_policy_definitions")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ServiceEndpointPropertiesFormatResponse(dict):
    """
    The service endpoint properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointPropertiesFormatResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointPropertiesFormatResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointPropertiesFormatResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 locations: Optional[Sequence[str]] = None,
                 provisioning_state: Optional[str] = None,
                 service: Optional[str] = None):
        """
        The service endpoint properties.
        :param Sequence[str] locations: A list of locations.
        :param str provisioning_state: The provisioning state of the resource.
        :param str service: The type of the endpoint service.
        """
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        """
        A list of locations.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def service(self) -> Optional[str]:
        """
        The type of the endpoint service.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class SubResourceResponse(dict):
    """
    Reference to another subresource.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Reference to another subresource.
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SubnetResponse(dict):
    """
    Subnet in a virtual network resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interfaceEndpoints":
            suggest = "interface_endpoints"
        elif key == "ipConfigurationProfiles":
            suggest = "ip_configuration_profiles"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "addressPrefixes":
            suggest = "address_prefixes"
        elif key == "networkSecurityGroup":
            suggest = "network_security_group"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceNavigationLinks":
            suggest = "resource_navigation_links"
        elif key == "routeTable":
            suggest = "route_table"
        elif key == "serviceAssociationLinks":
            suggest = "service_association_links"
        elif key == "serviceEndpointPolicies":
            suggest = "service_endpoint_policies"
        elif key == "serviceEndpoints":
            suggest = "service_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interface_endpoints: Sequence['outputs.InterfaceEndpointResponse'],
                 ip_configuration_profiles: Sequence['outputs.IPConfigurationProfileResponse'],
                 ip_configurations: Sequence['outputs.IPConfigurationResponse'],
                 purpose: str,
                 address_prefix: Optional[str] = None,
                 address_prefixes: Optional[Sequence[str]] = None,
                 delegations: Optional[Sequence['outputs.DelegationResponse']] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 network_security_group: Optional['outputs.NetworkSecurityGroupResponse'] = None,
                 provisioning_state: Optional[str] = None,
                 resource_navigation_links: Optional[Sequence['outputs.ResourceNavigationLinkResponse']] = None,
                 route_table: Optional['outputs.RouteTableResponse'] = None,
                 service_association_links: Optional[Sequence['outputs.ServiceAssociationLinkResponse']] = None,
                 service_endpoint_policies: Optional[Sequence['outputs.ServiceEndpointPolicyResponse']] = None,
                 service_endpoints: Optional[Sequence['outputs.ServiceEndpointPropertiesFormatResponse']] = None):
        """
        Subnet in a virtual network resource.
        :param Sequence['InterfaceEndpointResponse'] interface_endpoints: An array of references to interface endpoints 
        :param Sequence['IPConfigurationProfileResponse'] ip_configuration_profiles: Array of IP configuration profiles which reference this subnet.
        :param Sequence['IPConfigurationResponse'] ip_configurations: Gets an array of references to the network interface IP configurations using subnet.
        :param str purpose: A read-only string identifying the intention of use for this subnet based on delegations and other user-defined properties.
        :param str address_prefix: The address prefix for the subnet.
        :param Sequence[str] address_prefixes: List of  address prefixes for the subnet.
        :param Sequence['DelegationResponse'] delegations: Gets an array of references to the delegations on the subnet.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'NetworkSecurityGroupResponse' network_security_group: The reference of the NetworkSecurityGroup resource.
        :param str provisioning_state: The provisioning state of the resource.
        :param Sequence['ResourceNavigationLinkResponse'] resource_navigation_links: Gets an array of references to the external resources using subnet.
        :param 'RouteTableResponse' route_table: The reference of the RouteTable resource.
        :param Sequence['ServiceAssociationLinkResponse'] service_association_links: Gets an array of references to services injecting into this subnet.
        :param Sequence['ServiceEndpointPolicyResponse'] service_endpoint_policies: An array of service endpoint policies.
        :param Sequence['ServiceEndpointPropertiesFormatResponse'] service_endpoints: An array of service endpoints.
        """
        pulumi.set(__self__, "interface_endpoints", interface_endpoints)
        pulumi.set(__self__, "ip_configuration_profiles", ip_configuration_profiles)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "purpose", purpose)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if delegations is not None:
            pulumi.set(__self__, "delegations", delegations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if resource_navigation_links is not None:
            pulumi.set(__self__, "resource_navigation_links", resource_navigation_links)
        if route_table is not None:
            pulumi.set(__self__, "route_table", route_table)
        if service_association_links is not None:
            pulumi.set(__self__, "service_association_links", service_association_links)
        if service_endpoint_policies is not None:
            pulumi.set(__self__, "service_endpoint_policies", service_endpoint_policies)
        if service_endpoints is not None:
            pulumi.set(__self__, "service_endpoints", service_endpoints)

    @property
    @pulumi.getter(name="interfaceEndpoints")
    def interface_endpoints(self) -> Sequence['outputs.InterfaceEndpointResponse']:
        """
        An array of references to interface endpoints 
        """
        return pulumi.get(self, "interface_endpoints")

    @property
    @pulumi.getter(name="ipConfigurationProfiles")
    def ip_configuration_profiles(self) -> Sequence['outputs.IPConfigurationProfileResponse']:
        """
        Array of IP configuration profiles which reference this subnet.
        """
        return pulumi.get(self, "ip_configuration_profiles")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.IPConfigurationResponse']:
        """
        Gets an array of references to the network interface IP configurations using subnet.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def purpose(self) -> str:
        """
        A read-only string identifying the intention of use for this subnet based on delegations and other user-defined properties.
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        The address prefix for the subnet.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        List of  address prefixes for the subnet.
        """
        return pulumi.get(self, "address_prefixes")

    @property
    @pulumi.getter
    def delegations(self) -> Optional[Sequence['outputs.DelegationResponse']]:
        """
        Gets an array of references to the delegations on the subnet.
        """
        return pulumi.get(self, "delegations")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional['outputs.NetworkSecurityGroupResponse']:
        """
        The reference of the NetworkSecurityGroup resource.
        """
        return pulumi.get(self, "network_security_group")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceNavigationLinks")
    def resource_navigation_links(self) -> Optional[Sequence['outputs.ResourceNavigationLinkResponse']]:
        """
        Gets an array of references to the external resources using subnet.
        """
        return pulumi.get(self, "resource_navigation_links")

    @property
    @pulumi.getter(name="routeTable")
    def route_table(self) -> Optional['outputs.RouteTableResponse']:
        """
        The reference of the RouteTable resource.
        """
        return pulumi.get(self, "route_table")

    @property
    @pulumi.getter(name="serviceAssociationLinks")
    def service_association_links(self) -> Optional[Sequence['outputs.ServiceAssociationLinkResponse']]:
        """
        Gets an array of references to services injecting into this subnet.
        """
        return pulumi.get(self, "service_association_links")

    @property
    @pulumi.getter(name="serviceEndpointPolicies")
    def service_endpoint_policies(self) -> Optional[Sequence['outputs.ServiceEndpointPolicyResponse']]:
        """
        An array of service endpoint policies.
        """
        return pulumi.get(self, "service_endpoint_policies")

    @property
    @pulumi.getter(name="serviceEndpoints")
    def service_endpoints(self) -> Optional[Sequence['outputs.ServiceEndpointPropertiesFormatResponse']]:
        """
        An array of service endpoints.
        """
        return pulumi.get(self, "service_endpoints")


@pulumi.output_type
class TunnelConnectionHealthResponse(dict):
    """
    VirtualNetworkGatewayConnection properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionStatus":
            suggest = "connection_status"
        elif key == "egressBytesTransferred":
            suggest = "egress_bytes_transferred"
        elif key == "ingressBytesTransferred":
            suggest = "ingress_bytes_transferred"
        elif key == "lastConnectionEstablishedUtcTime":
            suggest = "last_connection_established_utc_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TunnelConnectionHealthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TunnelConnectionHealthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TunnelConnectionHealthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_status: str,
                 egress_bytes_transferred: float,
                 ingress_bytes_transferred: float,
                 last_connection_established_utc_time: str,
                 tunnel: str):
        """
        VirtualNetworkGatewayConnection properties
        :param str connection_status: Virtual network Gateway connection status
        :param float egress_bytes_transferred: The Egress Bytes Transferred in this connection
        :param float ingress_bytes_transferred: The Ingress Bytes Transferred in this connection
        :param str last_connection_established_utc_time: The time at which connection was established in Utc format.
        :param str tunnel: Tunnel name.
        """
        pulumi.set(__self__, "connection_status", connection_status)
        pulumi.set(__self__, "egress_bytes_transferred", egress_bytes_transferred)
        pulumi.set(__self__, "ingress_bytes_transferred", ingress_bytes_transferred)
        pulumi.set(__self__, "last_connection_established_utc_time", last_connection_established_utc_time)
        pulumi.set(__self__, "tunnel", tunnel)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> str:
        """
        Virtual network Gateway connection status
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="egressBytesTransferred")
    def egress_bytes_transferred(self) -> float:
        """
        The Egress Bytes Transferred in this connection
        """
        return pulumi.get(self, "egress_bytes_transferred")

    @property
    @pulumi.getter(name="ingressBytesTransferred")
    def ingress_bytes_transferred(self) -> float:
        """
        The Ingress Bytes Transferred in this connection
        """
        return pulumi.get(self, "ingress_bytes_transferred")

    @property
    @pulumi.getter(name="lastConnectionEstablishedUtcTime")
    def last_connection_established_utc_time(self) -> str:
        """
        The time at which connection was established in Utc format.
        """
        return pulumi.get(self, "last_connection_established_utc_time")

    @property
    @pulumi.getter
    def tunnel(self) -> str:
        """
        Tunnel name.
        """
        return pulumi.get(self, "tunnel")


@pulumi.output_type
class VirtualHubIdResponse(dict):
    """
    Virtual Hub identifier.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Virtual Hub identifier.
        :param str id: The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VirtualHubRouteResponse(dict):
    """
    VirtualHub route
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefixes":
            suggest = "address_prefixes"
        elif key == "nextHopIpAddress":
            suggest = "next_hop_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualHubRouteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualHubRouteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualHubRouteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefixes: Optional[Sequence[str]] = None,
                 next_hop_ip_address: Optional[str] = None):
        """
        VirtualHub route
        :param Sequence[str] address_prefixes: list of all addressPrefixes.
        :param str next_hop_ip_address: NextHop ip address.
        """
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        list of all addressPrefixes.
        """
        return pulumi.get(self, "address_prefixes")

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[str]:
        """
        NextHop ip address.
        """
        return pulumi.get(self, "next_hop_ip_address")


@pulumi.output_type
class VirtualHubRouteTableResponse(dict):
    """
    VirtualHub route table
    """
    def __init__(__self__, *,
                 routes: Optional[Sequence['outputs.VirtualHubRouteResponse']] = None):
        """
        VirtualHub route table
        :param Sequence['VirtualHubRouteResponse'] routes: list of all routes.
        """
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.VirtualHubRouteResponse']]:
        """
        list of all routes.
        """
        return pulumi.get(self, "routes")


@pulumi.output_type
class VirtualNetworkGatewayIPConfigurationResponse(dict):
    """
    IP configuration for virtual network gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"
        elif key == "publicIPAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkGatewayIPConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkGatewayIPConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkGatewayIPConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 public_ip_address: Optional['outputs.SubResourceResponse'] = None,
                 subnet: Optional['outputs.SubResourceResponse'] = None):
        """
        IP configuration for virtual network gateway
        :param str provisioning_state: The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str private_ip_allocation_method: The private IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        :param 'SubResourceResponse' public_ip_address: The reference of the public IP resource.
        :param 'SubResourceResponse' subnet: The reference of the subnet resource.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        The private IP allocation method. Possible values are: 'Static' and 'Dynamic'.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of the public IP resource.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of the subnet resource.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class VirtualNetworkGatewayResponse(dict):
    """
    A common class for general resource information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "activeActive":
            suggest = "active_active"
        elif key == "bgpSettings":
            suggest = "bgp_settings"
        elif key == "enableBgp":
            suggest = "enable_bgp"
        elif key == "gatewayDefaultSite":
            suggest = "gateway_default_site"
        elif key == "gatewayType":
            suggest = "gateway_type"
        elif key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "vpnClientConfiguration":
            suggest = "vpn_client_configuration"
        elif key == "vpnType":
            suggest = "vpn_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkGatewayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkGatewayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkGatewayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 active_active: Optional[bool] = None,
                 bgp_settings: Optional['outputs.BgpSettingsResponse'] = None,
                 enable_bgp: Optional[bool] = None,
                 etag: Optional[str] = None,
                 gateway_default_site: Optional['outputs.SubResourceResponse'] = None,
                 gateway_type: Optional[str] = None,
                 id: Optional[str] = None,
                 ip_configurations: Optional[Sequence['outputs.VirtualNetworkGatewayIPConfigurationResponse']] = None,
                 location: Optional[str] = None,
                 resource_guid: Optional[str] = None,
                 sku: Optional['outputs.VirtualNetworkGatewaySkuResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 vpn_client_configuration: Optional['outputs.VpnClientConfigurationResponse'] = None,
                 vpn_type: Optional[str] = None):
        """
        A common class for general resource information
        :param str name: Resource name.
        :param str provisioning_state: The provisioning state of the VirtualNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str type: Resource type.
        :param bool active_active: ActiveActive flag
        :param 'BgpSettingsResponse' bgp_settings: Virtual network gateway's BGP speaker settings.
        :param bool enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param 'SubResourceResponse' gateway_default_site: The reference of the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
        :param str gateway_type: The type of this virtual network gateway. Possible values are: 'Vpn' and 'ExpressRoute'.
        :param str id: Resource ID.
        :param Sequence['VirtualNetworkGatewayIPConfigurationResponse'] ip_configurations: IP configurations for virtual network gateway.
        :param str location: Resource location.
        :param str resource_guid: The resource GUID property of the VirtualNetworkGateway resource.
        :param 'VirtualNetworkGatewaySkuResponse' sku: The reference of the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
        :param Mapping[str, str] tags: Resource tags.
        :param 'VpnClientConfigurationResponse' vpn_client_configuration: The reference of the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
        :param str vpn_type: The type of this virtual network gateway. Possible values are: 'PolicyBased' and 'RouteBased'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if active_active is not None:
            pulumi.set(__self__, "active_active", active_active)
        if bgp_settings is not None:
            pulumi.set(__self__, "bgp_settings", bgp_settings)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if gateway_default_site is not None:
            pulumi.set(__self__, "gateway_default_site", gateway_default_site)
        if gateway_type is not None:
            pulumi.set(__self__, "gateway_type", gateway_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if resource_guid is not None:
            pulumi.set(__self__, "resource_guid", resource_guid)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpn_client_configuration is not None:
            pulumi.set(__self__, "vpn_client_configuration", vpn_client_configuration)
        if vpn_type is not None:
            pulumi.set(__self__, "vpn_type", vpn_type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VirtualNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="activeActive")
    def active_active(self) -> Optional[bool]:
        """
        ActiveActive flag
        """
        return pulumi.get(self, "active_active")

    @property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Optional['outputs.BgpSettingsResponse']:
        """
        Virtual network gateway's BGP speaker settings.
        """
        return pulumi.get(self, "bgp_settings")

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[bool]:
        """
        Whether BGP is enabled for this virtual network gateway or not.
        """
        return pulumi.get(self, "enable_bgp")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="gatewayDefaultSite")
    def gateway_default_site(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
        """
        return pulumi.get(self, "gateway_default_site")

    @property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> Optional[str]:
        """
        The type of this virtual network gateway. Possible values are: 'Vpn' and 'ExpressRoute'.
        """
        return pulumi.get(self, "gateway_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[Sequence['outputs.VirtualNetworkGatewayIPConfigurationResponse']]:
        """
        IP configurations for virtual network gateway.
        """
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> Optional[str]:
        """
        The resource GUID property of the VirtualNetworkGateway resource.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.VirtualNetworkGatewaySkuResponse']:
        """
        The reference of the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpnClientConfiguration")
    def vpn_client_configuration(self) -> Optional['outputs.VpnClientConfigurationResponse']:
        """
        The reference of the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
        """
        return pulumi.get(self, "vpn_client_configuration")

    @property
    @pulumi.getter(name="vpnType")
    def vpn_type(self) -> Optional[str]:
        """
        The type of this virtual network gateway. Possible values are: 'PolicyBased' and 'RouteBased'.
        """
        return pulumi.get(self, "vpn_type")


@pulumi.output_type
class VirtualNetworkGatewaySkuResponse(dict):
    """
    VirtualNetworkGatewaySku details
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        VirtualNetworkGatewaySku details
        :param int capacity: The capacity.
        :param str name: Gateway SKU name.
        :param str tier: Gateway SKU tier.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The capacity.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gateway SKU name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Gateway SKU tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class VirtualNetworkPeeringResponse(dict):
    """
    Peerings in a virtual network resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowForwardedTraffic":
            suggest = "allow_forwarded_traffic"
        elif key == "allowGatewayTransit":
            suggest = "allow_gateway_transit"
        elif key == "allowVirtualNetworkAccess":
            suggest = "allow_virtual_network_access"
        elif key == "peeringState":
            suggest = "peering_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "remoteAddressSpace":
            suggest = "remote_address_space"
        elif key == "remoteVirtualNetwork":
            suggest = "remote_virtual_network"
        elif key == "useRemoteGateways":
            suggest = "use_remote_gateways"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkPeeringResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkPeeringResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkPeeringResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_forwarded_traffic: Optional[bool] = None,
                 allow_gateway_transit: Optional[bool] = None,
                 allow_virtual_network_access: Optional[bool] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 peering_state: Optional[str] = None,
                 provisioning_state: Optional[str] = None,
                 remote_address_space: Optional['outputs.AddressSpaceResponse'] = None,
                 remote_virtual_network: Optional['outputs.SubResourceResponse'] = None,
                 use_remote_gateways: Optional[bool] = None):
        """
        Peerings in a virtual network resource.
        :param bool allow_forwarded_traffic: Whether the forwarded traffic from the VMs in the remote virtual network will be allowed/disallowed.
        :param bool allow_gateway_transit: If gateway links can be used in remote virtual networking to link to this virtual network.
        :param bool allow_virtual_network_access: Whether the VMs in the linked virtual network space would be able to access all the VMs in local Virtual network space.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str peering_state: The status of the virtual network peering. Possible values are 'Initiated', 'Connected', and 'Disconnected'.
        :param str provisioning_state: The provisioning state of the resource.
        :param 'AddressSpaceResponse' remote_address_space: The reference of the remote virtual network address space.
        :param 'SubResourceResponse' remote_virtual_network: The reference of the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
        :param bool use_remote_gateways: If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
        """
        if allow_forwarded_traffic is not None:
            pulumi.set(__self__, "allow_forwarded_traffic", allow_forwarded_traffic)
        if allow_gateway_transit is not None:
            pulumi.set(__self__, "allow_gateway_transit", allow_gateway_transit)
        if allow_virtual_network_access is not None:
            pulumi.set(__self__, "allow_virtual_network_access", allow_virtual_network_access)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peering_state is not None:
            pulumi.set(__self__, "peering_state", peering_state)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if remote_address_space is not None:
            pulumi.set(__self__, "remote_address_space", remote_address_space)
        if remote_virtual_network is not None:
            pulumi.set(__self__, "remote_virtual_network", remote_virtual_network)
        if use_remote_gateways is not None:
            pulumi.set(__self__, "use_remote_gateways", use_remote_gateways)

    @property
    @pulumi.getter(name="allowForwardedTraffic")
    def allow_forwarded_traffic(self) -> Optional[bool]:
        """
        Whether the forwarded traffic from the VMs in the remote virtual network will be allowed/disallowed.
        """
        return pulumi.get(self, "allow_forwarded_traffic")

    @property
    @pulumi.getter(name="allowGatewayTransit")
    def allow_gateway_transit(self) -> Optional[bool]:
        """
        If gateway links can be used in remote virtual networking to link to this virtual network.
        """
        return pulumi.get(self, "allow_gateway_transit")

    @property
    @pulumi.getter(name="allowVirtualNetworkAccess")
    def allow_virtual_network_access(self) -> Optional[bool]:
        """
        Whether the VMs in the linked virtual network space would be able to access all the VMs in local Virtual network space.
        """
        return pulumi.get(self, "allow_virtual_network_access")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peeringState")
    def peering_state(self) -> Optional[str]:
        """
        The status of the virtual network peering. Possible values are 'Initiated', 'Connected', and 'Disconnected'.
        """
        return pulumi.get(self, "peering_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="remoteAddressSpace")
    def remote_address_space(self) -> Optional['outputs.AddressSpaceResponse']:
        """
        The reference of the remote virtual network address space.
        """
        return pulumi.get(self, "remote_address_space")

    @property
    @pulumi.getter(name="remoteVirtualNetwork")
    def remote_virtual_network(self) -> Optional['outputs.SubResourceResponse']:
        """
        The reference of the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
        """
        return pulumi.get(self, "remote_virtual_network")

    @property
    @pulumi.getter(name="useRemoteGateways")
    def use_remote_gateways(self) -> Optional[bool]:
        """
        If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
        """
        return pulumi.get(self, "use_remote_gateways")


@pulumi.output_type
class VirtualNetworkTapResponse(dict):
    """
    Virtual Network Tap resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaceTapConfigurations":
            suggest = "network_interface_tap_configurations"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "resourceGuid":
            suggest = "resource_guid"
        elif key == "destinationLoadBalancerFrontEndIPConfiguration":
            suggest = "destination_load_balancer_front_end_ip_configuration"
        elif key == "destinationNetworkInterfaceIPConfiguration":
            suggest = "destination_network_interface_ip_configuration"
        elif key == "destinationPort":
            suggest = "destination_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkTapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkTapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkTapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 network_interface_tap_configurations: Sequence['outputs.NetworkInterfaceTapConfigurationResponse'],
                 provisioning_state: str,
                 resource_guid: str,
                 type: str,
                 destination_load_balancer_front_end_ip_configuration: Optional['outputs.FrontendIPConfigurationResponse'] = None,
                 destination_network_interface_ip_configuration: Optional['outputs.NetworkInterfaceIPConfigurationResponse'] = None,
                 destination_port: Optional[int] = None,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Virtual Network Tap resource
        :param str name: Resource name.
        :param Sequence['NetworkInterfaceTapConfigurationResponse'] network_interface_tap_configurations: Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped.
        :param str provisioning_state: The provisioning state of the virtual network tap. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str resource_guid: The resourceGuid property of the virtual network tap.
        :param str type: Resource type.
        :param 'FrontendIPConfigurationResponse' destination_load_balancer_front_end_ip_configuration: The reference to the private IP address on the internal Load Balancer that will receive the tap
        :param 'NetworkInterfaceIPConfigurationResponse' destination_network_interface_ip_configuration: The reference to the private IP Address of the collector nic that will receive the tap
        :param int destination_port: The VXLAN destination port that will receive the tapped traffic.
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str location: Resource location.
        :param Mapping[str, str] tags: Resource tags.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_interface_tap_configurations", network_interface_tap_configurations)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "resource_guid", resource_guid)
        pulumi.set(__self__, "type", type)
        if destination_load_balancer_front_end_ip_configuration is not None:
            pulumi.set(__self__, "destination_load_balancer_front_end_ip_configuration", destination_load_balancer_front_end_ip_configuration)
        if destination_network_interface_ip_configuration is not None:
            pulumi.set(__self__, "destination_network_interface_ip_configuration", destination_network_interface_ip_configuration)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaceTapConfigurations")
    def network_interface_tap_configurations(self) -> Sequence['outputs.NetworkInterfaceTapConfigurationResponse']:
        """
        Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped.
        """
        return pulumi.get(self, "network_interface_tap_configurations")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the virtual network tap. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="resourceGuid")
    def resource_guid(self) -> str:
        """
        The resourceGuid property of the virtual network tap.
        """
        return pulumi.get(self, "resource_guid")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="destinationLoadBalancerFrontEndIPConfiguration")
    def destination_load_balancer_front_end_ip_configuration(self) -> Optional['outputs.FrontendIPConfigurationResponse']:
        """
        The reference to the private IP address on the internal Load Balancer that will receive the tap
        """
        return pulumi.get(self, "destination_load_balancer_front_end_ip_configuration")

    @property
    @pulumi.getter(name="destinationNetworkInterfaceIPConfiguration")
    def destination_network_interface_ip_configuration(self) -> Optional['outputs.NetworkInterfaceIPConfigurationResponse']:
        """
        The reference to the private IP Address of the collector nic that will receive the tap
        """
        return pulumi.get(self, "destination_network_interface_ip_configuration")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[int]:
        """
        The VXLAN destination port that will receive the tapped traffic.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class VpnClientConfigurationResponse(dict):
    """
    VpnClientConfiguration for P2S client.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "radiusServerAddress":
            suggest = "radius_server_address"
        elif key == "radiusServerSecret":
            suggest = "radius_server_secret"
        elif key == "vpnClientAddressPool":
            suggest = "vpn_client_address_pool"
        elif key == "vpnClientIpsecPolicies":
            suggest = "vpn_client_ipsec_policies"
        elif key == "vpnClientProtocols":
            suggest = "vpn_client_protocols"
        elif key == "vpnClientRevokedCertificates":
            suggest = "vpn_client_revoked_certificates"
        elif key == "vpnClientRootCertificates":
            suggest = "vpn_client_root_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnClientConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnClientConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnClientConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 radius_server_address: Optional[str] = None,
                 radius_server_secret: Optional[str] = None,
                 vpn_client_address_pool: Optional['outputs.AddressSpaceResponse'] = None,
                 vpn_client_ipsec_policies: Optional[Sequence['outputs.IpsecPolicyResponse']] = None,
                 vpn_client_protocols: Optional[Sequence[str]] = None,
                 vpn_client_revoked_certificates: Optional[Sequence['outputs.VpnClientRevokedCertificateResponse']] = None,
                 vpn_client_root_certificates: Optional[Sequence['outputs.VpnClientRootCertificateResponse']] = None):
        """
        VpnClientConfiguration for P2S client.
        :param str radius_server_address: The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
        :param str radius_server_secret: The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
        :param 'AddressSpaceResponse' vpn_client_address_pool: The reference of the address space resource which represents Address space for P2S VpnClient.
        :param Sequence['IpsecPolicyResponse'] vpn_client_ipsec_policies: VpnClientIpsecPolicies for virtual network gateway P2S client.
        :param Sequence[str] vpn_client_protocols: VpnClientProtocols for Virtual network gateway.
        :param Sequence['VpnClientRevokedCertificateResponse'] vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network gateway.
        :param Sequence['VpnClientRootCertificateResponse'] vpn_client_root_certificates: VpnClientRootCertificate for virtual network gateway.
        """
        if radius_server_address is not None:
            pulumi.set(__self__, "radius_server_address", radius_server_address)
        if radius_server_secret is not None:
            pulumi.set(__self__, "radius_server_secret", radius_server_secret)
        if vpn_client_address_pool is not None:
            pulumi.set(__self__, "vpn_client_address_pool", vpn_client_address_pool)
        if vpn_client_ipsec_policies is not None:
            pulumi.set(__self__, "vpn_client_ipsec_policies", vpn_client_ipsec_policies)
        if vpn_client_protocols is not None:
            pulumi.set(__self__, "vpn_client_protocols", vpn_client_protocols)
        if vpn_client_revoked_certificates is not None:
            pulumi.set(__self__, "vpn_client_revoked_certificates", vpn_client_revoked_certificates)
        if vpn_client_root_certificates is not None:
            pulumi.set(__self__, "vpn_client_root_certificates", vpn_client_root_certificates)

    @property
    @pulumi.getter(name="radiusServerAddress")
    def radius_server_address(self) -> Optional[str]:
        """
        The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
        """
        return pulumi.get(self, "radius_server_address")

    @property
    @pulumi.getter(name="radiusServerSecret")
    def radius_server_secret(self) -> Optional[str]:
        """
        The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
        """
        return pulumi.get(self, "radius_server_secret")

    @property
    @pulumi.getter(name="vpnClientAddressPool")
    def vpn_client_address_pool(self) -> Optional['outputs.AddressSpaceResponse']:
        """
        The reference of the address space resource which represents Address space for P2S VpnClient.
        """
        return pulumi.get(self, "vpn_client_address_pool")

    @property
    @pulumi.getter(name="vpnClientIpsecPolicies")
    def vpn_client_ipsec_policies(self) -> Optional[Sequence['outputs.IpsecPolicyResponse']]:
        """
        VpnClientIpsecPolicies for virtual network gateway P2S client.
        """
        return pulumi.get(self, "vpn_client_ipsec_policies")

    @property
    @pulumi.getter(name="vpnClientProtocols")
    def vpn_client_protocols(self) -> Optional[Sequence[str]]:
        """
        VpnClientProtocols for Virtual network gateway.
        """
        return pulumi.get(self, "vpn_client_protocols")

    @property
    @pulumi.getter(name="vpnClientRevokedCertificates")
    def vpn_client_revoked_certificates(self) -> Optional[Sequence['outputs.VpnClientRevokedCertificateResponse']]:
        """
        VpnClientRevokedCertificate for Virtual network gateway.
        """
        return pulumi.get(self, "vpn_client_revoked_certificates")

    @property
    @pulumi.getter(name="vpnClientRootCertificates")
    def vpn_client_root_certificates(self) -> Optional[Sequence['outputs.VpnClientRootCertificateResponse']]:
        """
        VpnClientRootCertificate for virtual network gateway.
        """
        return pulumi.get(self, "vpn_client_root_certificates")


@pulumi.output_type
class VpnClientConnectionHealthResponse(dict):
    """
    VpnClientConnectionHealth properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "totalEgressBytesTransferred":
            suggest = "total_egress_bytes_transferred"
        elif key == "totalIngressBytesTransferred":
            suggest = "total_ingress_bytes_transferred"
        elif key == "allocatedIpAddresses":
            suggest = "allocated_ip_addresses"
        elif key == "vpnClientConnectionsCount":
            suggest = "vpn_client_connections_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnClientConnectionHealthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnClientConnectionHealthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnClientConnectionHealthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 total_egress_bytes_transferred: float,
                 total_ingress_bytes_transferred: float,
                 allocated_ip_addresses: Optional[Sequence[str]] = None,
                 vpn_client_connections_count: Optional[int] = None):
        """
        VpnClientConnectionHealth properties
        :param float total_egress_bytes_transferred: Total of the Egress Bytes Transferred in this connection
        :param float total_ingress_bytes_transferred: Total of the Ingress Bytes Transferred in this P2S Vpn connection
        :param Sequence[str] allocated_ip_addresses: List of allocated ip addresses to the connected p2s vpn clients.
        :param int vpn_client_connections_count: The total of p2s vpn clients connected at this time to this P2SVpnGateway.
        """
        pulumi.set(__self__, "total_egress_bytes_transferred", total_egress_bytes_transferred)
        pulumi.set(__self__, "total_ingress_bytes_transferred", total_ingress_bytes_transferred)
        if allocated_ip_addresses is not None:
            pulumi.set(__self__, "allocated_ip_addresses", allocated_ip_addresses)
        if vpn_client_connections_count is not None:
            pulumi.set(__self__, "vpn_client_connections_count", vpn_client_connections_count)

    @property
    @pulumi.getter(name="totalEgressBytesTransferred")
    def total_egress_bytes_transferred(self) -> float:
        """
        Total of the Egress Bytes Transferred in this connection
        """
        return pulumi.get(self, "total_egress_bytes_transferred")

    @property
    @pulumi.getter(name="totalIngressBytesTransferred")
    def total_ingress_bytes_transferred(self) -> float:
        """
        Total of the Ingress Bytes Transferred in this P2S Vpn connection
        """
        return pulumi.get(self, "total_ingress_bytes_transferred")

    @property
    @pulumi.getter(name="allocatedIpAddresses")
    def allocated_ip_addresses(self) -> Optional[Sequence[str]]:
        """
        List of allocated ip addresses to the connected p2s vpn clients.
        """
        return pulumi.get(self, "allocated_ip_addresses")

    @property
    @pulumi.getter(name="vpnClientConnectionsCount")
    def vpn_client_connections_count(self) -> Optional[int]:
        """
        The total of p2s vpn clients connected at this time to this P2SVpnGateway.
        """
        return pulumi.get(self, "vpn_client_connections_count")


@pulumi.output_type
class VpnClientRevokedCertificateResponse(dict):
    """
    VPN client revoked certificate of virtual network gateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnClientRevokedCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnClientRevokedCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnClientRevokedCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        VPN client revoked certificate of virtual network gateway.
        :param str provisioning_state: The provisioning state of the VPN client revoked certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param str thumbprint: The revoked VPN client certificate thumbprint.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VPN client revoked certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The revoked VPN client certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class VpnClientRootCertificateResponse(dict):
    """
    VPN client root certificate of virtual network gateway
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicCertData":
            suggest = "public_cert_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnClientRootCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnClientRootCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnClientRootCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 public_cert_data: str,
                 etag: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        VPN client root certificate of virtual network gateway
        :param str provisioning_state: The provisioning state of the VPN client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :param str public_cert_data: The certificate public data.
        :param str etag: A unique read-only string that changes whenever the resource is updated.
        :param str id: Resource ID.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "public_cert_data", public_cert_data)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the VPN client root certificate resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicCertData")
    def public_cert_data(self) -> str:
        """
        The certificate public data.
        """
        return pulumi.get(self, "public_cert_data")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VpnConnectionResponse(dict):
    """
    VpnConnection Resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionStatus":
            suggest = "connection_status"
        elif key == "egressBytesTransferred":
            suggest = "egress_bytes_transferred"
        elif key == "ingressBytesTransferred":
            suggest = "ingress_bytes_transferred"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "connectionBandwidth":
            suggest = "connection_bandwidth"
        elif key == "enableBgp":
            suggest = "enable_bgp"
        elif key == "enableInternetSecurity":
            suggest = "enable_internet_security"
        elif key == "enableRateLimiting":
            suggest = "enable_rate_limiting"
        elif key == "ipsecPolicies":
            suggest = "ipsec_policies"
        elif key == "remoteVpnSite":
            suggest = "remote_vpn_site"
        elif key == "routingWeight":
            suggest = "routing_weight"
        elif key == "sharedKey":
            suggest = "shared_key"
        elif key == "vpnConnectionProtocolType":
            suggest = "vpn_connection_protocol_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpnConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpnConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpnConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_status: str,
                 egress_bytes_transferred: float,
                 etag: str,
                 ingress_bytes_transferred: float,
                 provisioning_state: str,
                 connection_bandwidth: Optional[int] = None,
                 enable_bgp: Optional[bool] = None,
                 enable_internet_security: Optional[bool] = None,
                 enable_rate_limiting: Optional[bool] = None,
                 id: Optional[str] = None,
                 ipsec_policies: Optional[Sequence['outputs.IpsecPolicyResponse']] = None,
                 name: Optional[str] = None,
                 remote_vpn_site: Optional['outputs.SubResourceResponse'] = None,
                 routing_weight: Optional[int] = None,
                 shared_key: Optional[str] = None,
                 vpn_connection_protocol_type: Optional[str] = None):
        """
        VpnConnection Resource.
        :param str connection_status: The connection status.
        :param float egress_bytes_transferred: Egress bytes transferred.
        :param str etag: Gets a unique read-only string that changes whenever the resource is updated.
        :param float ingress_bytes_transferred: Ingress bytes transferred.
        :param str provisioning_state: The provisioning state of the resource.
        :param int connection_bandwidth: Expected bandwidth in MBPS.
        :param bool enable_bgp: EnableBgp flag
        :param bool enable_internet_security: Enable internet security
        :param bool enable_rate_limiting: EnableBgp flag
        :param str id: Resource ID.
        :param Sequence['IpsecPolicyResponse'] ipsec_policies: The IPSec Policies to be considered by this connection.
        :param str name: The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'SubResourceResponse' remote_vpn_site: Id of the connected vpn site.
        :param int routing_weight: routing weight for vpn connection.
        :param str shared_key: SharedKey for the vpn connection.
        :param str vpn_connection_protocol_type: Connection protocol used for this connection
        """
        pulumi.set(__self__, "connection_status", connection_status)
        pulumi.set(__self__, "egress_bytes_transferred", egress_bytes_transferred)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "ingress_bytes_transferred", ingress_bytes_transferred)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if connection_bandwidth is not None:
            pulumi.set(__self__, "connection_bandwidth", connection_bandwidth)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if enable_internet_security is not None:
            pulumi.set(__self__, "enable_internet_security", enable_internet_security)
        if enable_rate_limiting is not None:
            pulumi.set(__self__, "enable_rate_limiting", enable_rate_limiting)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ipsec_policies is not None:
            pulumi.set(__self__, "ipsec_policies", ipsec_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remote_vpn_site is not None:
            pulumi.set(__self__, "remote_vpn_site", remote_vpn_site)
        if routing_weight is not None:
            pulumi.set(__self__, "routing_weight", routing_weight)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if vpn_connection_protocol_type is not None:
            pulumi.set(__self__, "vpn_connection_protocol_type", vpn_connection_protocol_type)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> str:
        """
        The connection status.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="egressBytesTransferred")
    def egress_bytes_transferred(self) -> float:
        """
        Egress bytes transferred.
        """
        return pulumi.get(self, "egress_bytes_transferred")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Gets a unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="ingressBytesTransferred")
    def ingress_bytes_transferred(self) -> float:
        """
        Ingress bytes transferred.
        """
        return pulumi.get(self, "ingress_bytes_transferred")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="connectionBandwidth")
    def connection_bandwidth(self) -> Optional[int]:
        """
        Expected bandwidth in MBPS.
        """
        return pulumi.get(self, "connection_bandwidth")

    @property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[bool]:
        """
        EnableBgp flag
        """
        return pulumi.get(self, "enable_bgp")

    @property
    @pulumi.getter(name="enableInternetSecurity")
    def enable_internet_security(self) -> Optional[bool]:
        """
        Enable internet security
        """
        return pulumi.get(self, "enable_internet_security")

    @property
    @pulumi.getter(name="enableRateLimiting")
    def enable_rate_limiting(self) -> Optional[bool]:
        """
        EnableBgp flag
        """
        return pulumi.get(self, "enable_rate_limiting")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipsecPolicies")
    def ipsec_policies(self) -> Optional[Sequence['outputs.IpsecPolicyResponse']]:
        """
        The IPSec Policies to be considered by this connection.
        """
        return pulumi.get(self, "ipsec_policies")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="remoteVpnSite")
    def remote_vpn_site(self) -> Optional['outputs.SubResourceResponse']:
        """
        Id of the connected vpn site.
        """
        return pulumi.get(self, "remote_vpn_site")

    @property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> Optional[int]:
        """
        routing weight for vpn connection.
        """
        return pulumi.get(self, "routing_weight")

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[str]:
        """
        SharedKey for the vpn connection.
        """
        return pulumi.get(self, "shared_key")

    @property
    @pulumi.getter(name="vpnConnectionProtocolType")
    def vpn_connection_protocol_type(self) -> Optional[str]:
        """
        Connection protocol used for this connection
        """
        return pulumi.get(self, "vpn_connection_protocol_type")


