# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CapabilityResponse',
    'CassandraPartitionKeyResponse',
    'CassandraSchemaResponse',
    'ClusterKeyResponse',
    'ColumnResponse',
    'ConflictResolutionPolicyResponse',
    'ConsistencyPolicyResponse',
    'ContainerPartitionKeyResponse',
    'DatabaseAccountConnectionStringResponse',
    'ExcludedPathResponse',
    'FailoverPolicyResponse',
    'IncludedPathResponse',
    'IndexesResponse',
    'IndexingPolicyResponse',
    'LocationResponse',
    'MongoIndexKeysResponse',
    'MongoIndexOptionsResponse',
    'MongoIndexResponse',
    'UniqueKeyPolicyResponse',
    'UniqueKeyResponse',
    'VirtualNetworkRuleResponse',
]

@pulumi.output_type
class CapabilityResponse(dict):
    """
    Cosmos DB capability object
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Cosmos DB capability object
        :param str name: Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CassandraPartitionKeyResponse(dict):
    """
    Cosmos DB Cassandra table partition key
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Cosmos DB Cassandra table partition key
        :param str name: Name of the Cosmos DB Cassandra table partition key
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the Cosmos DB Cassandra table partition key
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CassandraSchemaResponse(dict):
    """
    Cosmos DB Cassandra table schema
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterKeys":
            suggest = "cluster_keys"
        elif key == "partitionKeys":
            suggest = "partition_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraSchemaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraSchemaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraSchemaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_keys: Optional[Sequence['outputs.ClusterKeyResponse']] = None,
                 columns: Optional[Sequence['outputs.ColumnResponse']] = None,
                 partition_keys: Optional[Sequence['outputs.CassandraPartitionKeyResponse']] = None):
        """
        Cosmos DB Cassandra table schema
        :param Sequence['ClusterKeyResponse'] cluster_keys: List of cluster key.
        :param Sequence['ColumnResponse'] columns: List of Cassandra table columns.
        :param Sequence['CassandraPartitionKeyResponse'] partition_keys: List of partition key.
        """
        if cluster_keys is not None:
            pulumi.set(__self__, "cluster_keys", cluster_keys)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)

    @property
    @pulumi.getter(name="clusterKeys")
    def cluster_keys(self) -> Optional[Sequence['outputs.ClusterKeyResponse']]:
        """
        List of cluster key.
        """
        return pulumi.get(self, "cluster_keys")

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.ColumnResponse']]:
        """
        List of Cassandra table columns.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[Sequence['outputs.CassandraPartitionKeyResponse']]:
        """
        List of partition key.
        """
        return pulumi.get(self, "partition_keys")


@pulumi.output_type
class ClusterKeyResponse(dict):
    """
    Cosmos DB Cassandra table cluster key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderBy":
            suggest = "order_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 order_by: Optional[str] = None):
        """
        Cosmos DB Cassandra table cluster key
        :param str name: Name of the Cosmos DB Cassandra table cluster key
        :param str order_by: Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order_by is not None:
            pulumi.set(__self__, "order_by", order_by)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the Cosmos DB Cassandra table cluster key
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[str]:
        """
        Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
        """
        return pulumi.get(self, "order_by")


@pulumi.output_type
class ColumnResponse(dict):
    """
    Cosmos DB Cassandra table column
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Cosmos DB Cassandra table column
        :param str name: Name of the Cosmos DB Cassandra table column
        :param str type: Type of the Cosmos DB Cassandra table column
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the Cosmos DB Cassandra table column
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the Cosmos DB Cassandra table column
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConflictResolutionPolicyResponse(dict):
    """
    The conflict resolution policy for the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictResolutionPath":
            suggest = "conflict_resolution_path"
        elif key == "conflictResolutionProcedure":
            suggest = "conflict_resolution_procedure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConflictResolutionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConflictResolutionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConflictResolutionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_resolution_path: Optional[str] = None,
                 conflict_resolution_procedure: Optional[str] = None,
                 mode: Optional[str] = None):
        """
        The conflict resolution policy for the container.
        :param str conflict_resolution_path: The conflict resolution path in the case of LastWriterWins mode.
        :param str conflict_resolution_procedure: The procedure to resolve conflicts in the case of custom mode.
        :param str mode: Indicates the conflict resolution mode.
        """
        if conflict_resolution_path is not None:
            pulumi.set(__self__, "conflict_resolution_path", conflict_resolution_path)
        if conflict_resolution_procedure is not None:
            pulumi.set(__self__, "conflict_resolution_procedure", conflict_resolution_procedure)
        if mode is None:
            mode = 'LastWriterWins'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="conflictResolutionPath")
    def conflict_resolution_path(self) -> Optional[str]:
        """
        The conflict resolution path in the case of LastWriterWins mode.
        """
        return pulumi.get(self, "conflict_resolution_path")

    @property
    @pulumi.getter(name="conflictResolutionProcedure")
    def conflict_resolution_procedure(self) -> Optional[str]:
        """
        The procedure to resolve conflicts in the case of custom mode.
        """
        return pulumi.get(self, "conflict_resolution_procedure")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Indicates the conflict resolution mode.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class ConsistencyPolicyResponse(dict):
    """
    The consistency policy for the Cosmos DB database account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultConsistencyLevel":
            suggest = "default_consistency_level"
        elif key == "maxIntervalInSeconds":
            suggest = "max_interval_in_seconds"
        elif key == "maxStalenessPrefix":
            suggest = "max_staleness_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConsistencyPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConsistencyPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConsistencyPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_consistency_level: str,
                 max_interval_in_seconds: Optional[int] = None,
                 max_staleness_prefix: Optional[float] = None):
        """
        The consistency policy for the Cosmos DB database account.
        :param str default_consistency_level: The default consistency level and configuration settings of the Cosmos DB account.
        :param int max_interval_in_seconds: When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        :param float max_staleness_prefix: When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        """
        pulumi.set(__self__, "default_consistency_level", default_consistency_level)
        if max_interval_in_seconds is not None:
            pulumi.set(__self__, "max_interval_in_seconds", max_interval_in_seconds)
        if max_staleness_prefix is not None:
            pulumi.set(__self__, "max_staleness_prefix", max_staleness_prefix)

    @property
    @pulumi.getter(name="defaultConsistencyLevel")
    def default_consistency_level(self) -> str:
        """
        The default consistency level and configuration settings of the Cosmos DB account.
        """
        return pulumi.get(self, "default_consistency_level")

    @property
    @pulumi.getter(name="maxIntervalInSeconds")
    def max_interval_in_seconds(self) -> Optional[int]:
        """
        When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        """
        return pulumi.get(self, "max_interval_in_seconds")

    @property
    @pulumi.getter(name="maxStalenessPrefix")
    def max_staleness_prefix(self) -> Optional[float]:
        """
        When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        """
        return pulumi.get(self, "max_staleness_prefix")


@pulumi.output_type
class ContainerPartitionKeyResponse(dict):
    """
    The configuration of the partition key to be used for partitioning data into multiple partitions
    """
    def __init__(__self__, *,
                 kind: Optional[str] = None,
                 paths: Optional[Sequence[str]] = None):
        """
        The configuration of the partition key to be used for partitioning data into multiple partitions
        :param str kind: Indicates the kind of algorithm used for partitioning
        :param Sequence[str] paths: List of paths using which data within the container can be partitioned
        """
        if kind is None:
            kind = 'Hash'
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Indicates the kind of algorithm used for partitioning
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        List of paths using which data within the container can be partitioned
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class DatabaseAccountConnectionStringResponse(dict):
    """
    Connection string for the Cosmos DB account
    """
    def __init__(__self__, *,
                 connection_string: str,
                 description: str):
        """
        Connection string for the Cosmos DB account
        :param str connection_string: Value of the connection string
        :param str description: Description of the connection string
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        Value of the connection string
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the connection string
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ExcludedPathResponse(dict):
    def __init__(__self__, *,
                 path: Optional[str] = None):
        """
        :param str path: The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class FailoverPolicyResponse(dict):
    """
    The failover policy for a given region of a database account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverPriority":
            suggest = "failover_priority"
        elif key == "locationName":
            suggest = "location_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FailoverPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FailoverPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FailoverPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 failover_priority: Optional[int] = None,
                 location_name: Optional[str] = None):
        """
        The failover policy for a given region of a database account.
        :param str id: The unique identifier of the region in which the database account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
        :param int failover_priority: The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
        :param str location_name: The name of the region in which the database account exists.
        """
        pulumi.set(__self__, "id", id)
        if failover_priority is not None:
            pulumi.set(__self__, "failover_priority", failover_priority)
        if location_name is not None:
            pulumi.set(__self__, "location_name", location_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier of the region in which the database account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="failoverPriority")
    def failover_priority(self) -> Optional[int]:
        """
        The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
        """
        return pulumi.get(self, "failover_priority")

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> Optional[str]:
        """
        The name of the region in which the database account exists.
        """
        return pulumi.get(self, "location_name")


@pulumi.output_type
class IncludedPathResponse(dict):
    """
    The paths that are included in indexing
    """
    def __init__(__self__, *,
                 indexes: Optional[Sequence['outputs.IndexesResponse']] = None,
                 path: Optional[str] = None):
        """
        The paths that are included in indexing
        :param Sequence['IndexesResponse'] indexes: List of indexes for this path
        :param str path: The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        if indexes is not None:
            pulumi.set(__self__, "indexes", indexes)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def indexes(self) -> Optional[Sequence['outputs.IndexesResponse']]:
        """
        List of indexes for this path
        """
        return pulumi.get(self, "indexes")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class IndexesResponse(dict):
    """
    The indexes for the path.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: Optional[str] = None,
                 kind: Optional[str] = None,
                 precision: Optional[int] = None):
        """
        The indexes for the path.
        :param str data_type: The datatype for which the indexing behavior is applied to.
        :param str kind: Indicates the type of index.
        :param int precision: The precision of the index. -1 is maximum precision.
        """
        if data_type is None:
            data_type = 'String'
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if kind is None:
            kind = 'Hash'
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The datatype for which the indexing behavior is applied to.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Indicates the type of index.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def precision(self) -> Optional[int]:
        """
        The precision of the index. -1 is maximum precision.
        """
        return pulumi.get(self, "precision")


@pulumi.output_type
class IndexingPolicyResponse(dict):
    """
    Cosmos DB indexing policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedPaths":
            suggest = "excluded_paths"
        elif key == "includedPaths":
            suggest = "included_paths"
        elif key == "indexingMode":
            suggest = "indexing_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic: Optional[bool] = None,
                 excluded_paths: Optional[Sequence['outputs.ExcludedPathResponse']] = None,
                 included_paths: Optional[Sequence['outputs.IncludedPathResponse']] = None,
                 indexing_mode: Optional[str] = None):
        """
        Cosmos DB indexing policy
        :param bool automatic: Indicates if the indexing policy is automatic
        :param Sequence['ExcludedPathResponse'] excluded_paths: List of paths to exclude from indexing
        :param Sequence['IncludedPathResponse'] included_paths: List of paths to include in the indexing
        :param str indexing_mode: Indicates the indexing mode.
        """
        if automatic is not None:
            pulumi.set(__self__, "automatic", automatic)
        if excluded_paths is not None:
            pulumi.set(__self__, "excluded_paths", excluded_paths)
        if included_paths is not None:
            pulumi.set(__self__, "included_paths", included_paths)
        if indexing_mode is None:
            indexing_mode = 'Consistent'
        if indexing_mode is not None:
            pulumi.set(__self__, "indexing_mode", indexing_mode)

    @property
    @pulumi.getter
    def automatic(self) -> Optional[bool]:
        """
        Indicates if the indexing policy is automatic
        """
        return pulumi.get(self, "automatic")

    @property
    @pulumi.getter(name="excludedPaths")
    def excluded_paths(self) -> Optional[Sequence['outputs.ExcludedPathResponse']]:
        """
        List of paths to exclude from indexing
        """
        return pulumi.get(self, "excluded_paths")

    @property
    @pulumi.getter(name="includedPaths")
    def included_paths(self) -> Optional[Sequence['outputs.IncludedPathResponse']]:
        """
        List of paths to include in the indexing
        """
        return pulumi.get(self, "included_paths")

    @property
    @pulumi.getter(name="indexingMode")
    def indexing_mode(self) -> Optional[str]:
        """
        Indicates the indexing mode.
        """
        return pulumi.get(self, "indexing_mode")


@pulumi.output_type
class LocationResponse(dict):
    """
    A region in which the Azure Cosmos DB database account is deployed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentEndpoint":
            suggest = "document_endpoint"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "failoverPriority":
            suggest = "failover_priority"
        elif key == "isZoneRedundant":
            suggest = "is_zone_redundant"
        elif key == "locationName":
            suggest = "location_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 document_endpoint: str,
                 id: str,
                 provisioning_state: str,
                 failover_priority: Optional[int] = None,
                 is_zone_redundant: Optional[bool] = None,
                 location_name: Optional[str] = None):
        """
        A region in which the Azure Cosmos DB database account is deployed.
        :param str document_endpoint: The connection endpoint for the specific region. Example: https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/
        :param str id: The unique identifier of the region within the database account. Example: &lt;accountName&gt;-&lt;locationName&gt;.
        :param str provisioning_state: The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'Offline' - the Cosmos DB account is not active. 'DeletionFailed' – the Cosmos DB account deletion failed.
        :param int failover_priority: The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
        :param bool is_zone_redundant: Flag to indicate whether or not this region is an AvailabilityZone region
        :param str location_name: The name of the region.
        """
        pulumi.set(__self__, "document_endpoint", document_endpoint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if failover_priority is not None:
            pulumi.set(__self__, "failover_priority", failover_priority)
        if is_zone_redundant is not None:
            pulumi.set(__self__, "is_zone_redundant", is_zone_redundant)
        if location_name is not None:
            pulumi.set(__self__, "location_name", location_name)

    @property
    @pulumi.getter(name="documentEndpoint")
    def document_endpoint(self) -> str:
        """
        The connection endpoint for the specific region. Example: https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/
        """
        return pulumi.get(self, "document_endpoint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier of the region within the database account. Example: &lt;accountName&gt;-&lt;locationName&gt;.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'Offline' - the Cosmos DB account is not active. 'DeletionFailed' – the Cosmos DB account deletion failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="failoverPriority")
    def failover_priority(self) -> Optional[int]:
        """
        The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
        """
        return pulumi.get(self, "failover_priority")

    @property
    @pulumi.getter(name="isZoneRedundant")
    def is_zone_redundant(self) -> Optional[bool]:
        """
        Flag to indicate whether or not this region is an AvailabilityZone region
        """
        return pulumi.get(self, "is_zone_redundant")

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> Optional[str]:
        """
        The name of the region.
        """
        return pulumi.get(self, "location_name")


@pulumi.output_type
class MongoIndexKeysResponse(dict):
    """
    Cosmos DB MongoDB collection resource object
    """
    def __init__(__self__, *,
                 keys: Optional[Sequence[str]] = None):
        """
        Cosmos DB MongoDB collection resource object
        :param Sequence[str] keys: List of keys for each MongoDB collection in the Azure Cosmos DB service
        """
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[str]]:
        """
        List of keys for each MongoDB collection in the Azure Cosmos DB service
        """
        return pulumi.get(self, "keys")


@pulumi.output_type
class MongoIndexOptionsResponse(dict):
    """
    Cosmos DB MongoDB collection index options
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireAfterSeconds":
            suggest = "expire_after_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoIndexOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoIndexOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoIndexOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expire_after_seconds: Optional[int] = None,
                 unique: Optional[bool] = None):
        """
        Cosmos DB MongoDB collection index options
        :param int expire_after_seconds: Expire after seconds
        :param bool unique: Is unique or not
        """
        if expire_after_seconds is not None:
            pulumi.set(__self__, "expire_after_seconds", expire_after_seconds)
        if unique is not None:
            pulumi.set(__self__, "unique", unique)

    @property
    @pulumi.getter(name="expireAfterSeconds")
    def expire_after_seconds(self) -> Optional[int]:
        """
        Expire after seconds
        """
        return pulumi.get(self, "expire_after_seconds")

    @property
    @pulumi.getter
    def unique(self) -> Optional[bool]:
        """
        Is unique or not
        """
        return pulumi.get(self, "unique")


@pulumi.output_type
class MongoIndexResponse(dict):
    """
    Cosmos DB MongoDB collection index key
    """
    def __init__(__self__, *,
                 key: Optional['outputs.MongoIndexKeysResponse'] = None,
                 options: Optional['outputs.MongoIndexOptionsResponse'] = None):
        """
        Cosmos DB MongoDB collection index key
        :param 'MongoIndexKeysResponse' key: Cosmos DB MongoDB collection index keys
        :param 'MongoIndexOptionsResponse' options: Cosmos DB MongoDB collection index key options
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def key(self) -> Optional['outputs.MongoIndexKeysResponse']:
        """
        Cosmos DB MongoDB collection index keys
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def options(self) -> Optional['outputs.MongoIndexOptionsResponse']:
        """
        Cosmos DB MongoDB collection index key options
        """
        return pulumi.get(self, "options")


@pulumi.output_type
class UniqueKeyPolicyResponse(dict):
    """
    The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "uniqueKeys":
            suggest = "unique_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UniqueKeyPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UniqueKeyPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UniqueKeyPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 unique_keys: Optional[Sequence['outputs.UniqueKeyResponse']] = None):
        """
        The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
        :param Sequence['UniqueKeyResponse'] unique_keys: List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
        """
        if unique_keys is not None:
            pulumi.set(__self__, "unique_keys", unique_keys)

    @property
    @pulumi.getter(name="uniqueKeys")
    def unique_keys(self) -> Optional[Sequence['outputs.UniqueKeyResponse']]:
        """
        List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
        """
        return pulumi.get(self, "unique_keys")


@pulumi.output_type
class UniqueKeyResponse(dict):
    """
    The unique key on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
    """
    def __init__(__self__, *,
                 paths: Optional[Sequence[str]] = None):
        """
        The unique key on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
        :param Sequence[str] paths: List of paths must be unique for each document in the Azure Cosmos DB service
        """
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        List of paths must be unique for each document in the Azure Cosmos DB service
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class VirtualNetworkRuleResponse(dict):
    """
    Virtual Network ACL Rule object
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreMissingVNetServiceEndpoint":
            suggest = "ignore_missing_v_net_service_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 ignore_missing_v_net_service_endpoint: Optional[bool] = None):
        """
        Virtual Network ACL Rule object
        :param str id: Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
        :param bool ignore_missing_v_net_service_endpoint: Create firewall rule before the virtual network has vnet service endpoint enabled.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ignore_missing_v_net_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_v_net_service_endpoint", ignore_missing_v_net_service_endpoint)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoreMissingVNetServiceEndpoint")
    def ignore_missing_v_net_service_endpoint(self) -> Optional[bool]:
        """
        Create firewall rule before the virtual network has vnet service endpoint enabled.
        """
        return pulumi.get(self, "ignore_missing_v_net_service_endpoint")


