# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'OfferDetailResponse',
    'SystemDataResponse',
    'UserDetailResponse',
]

@pulumi.output_type
class OfferDetailResponse(dict):
    """
    Confluent Offer detail
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planId":
            suggest = "plan_id"
        elif key == "planName":
            suggest = "plan_name"
        elif key == "publisherId":
            suggest = "publisher_id"
        elif key == "termUnit":
            suggest = "term_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OfferDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OfferDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OfferDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 plan_id: str,
                 plan_name: str,
                 publisher_id: str,
                 status: str,
                 term_unit: str):
        """
        Confluent Offer detail
        :param str id: Offer Id
        :param str plan_id: Offer Plan Id
        :param str plan_name: Offer Plan Name
        :param str publisher_id: Publisher Id
        :param str status: SaaS Offer Status
        :param str term_unit: Offer Plan Term unit
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "plan_id", plan_id)
        pulumi.set(__self__, "plan_name", plan_name)
        pulumi.set(__self__, "publisher_id", publisher_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "term_unit", term_unit)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Offer Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        """
        Offer Plan Id
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="planName")
    def plan_name(self) -> str:
        """
        Offer Plan Name
        """
        return pulumi.get(self, "plan_name")

    @property
    @pulumi.getter(name="publisherId")
    def publisher_id(self) -> str:
        """
        Publisher Id
        """
        return pulumi.get(self, "publisher_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        SaaS Offer Status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="termUnit")
    def term_unit(self) -> str:
        """
        Offer Plan Term unit
        """
        return pulumi.get(self, "term_unit")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UserDetailResponse(dict):
    """
    Subscriber detail
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: str,
                 first_name: Optional[str] = None,
                 last_name: Optional[str] = None):
        """
        Subscriber detail
        :param str email_address: Email address
        :param str first_name: First name
        :param str last_name: Last name
        """
        pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        Email address
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[str]:
        """
        First name
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[str]:
        """
        Last name
        """
        return pulumi.get(self, "last_name")


