# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CreationDataArgs',
    'DataDiskImageEncryptionArgs',
    'DisallowedArgs',
    'DiskSkuArgs',
    'EncryptionImagesArgs',
    'EncryptionSetIdentityArgs',
    'EncryptionSettingsCollectionArgs',
    'EncryptionSettingsElementArgs',
    'EncryptionArgs',
    'ExtendedLocationArgs',
    'GalleryApplicationVersionPublishingProfileArgs',
    'GalleryArtifactVersionSourceArgs',
    'GalleryDataDiskImageArgs',
    'GalleryImageFeatureArgs',
    'GalleryImageIdentifierArgs',
    'GalleryImageVersionPublishingProfileArgs',
    'GalleryImageVersionStorageProfileArgs',
    'GalleryOSDiskImageArgs',
    'ImageDiskReferenceArgs',
    'ImagePurchasePlanArgs',
    'KeyForDiskEncryptionSetArgs',
    'KeyVaultAndKeyReferenceArgs',
    'KeyVaultAndSecretReferenceArgs',
    'OSDiskImageEncryptionArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'PurchasePlanArgs',
    'RecommendedMachineConfigurationArgs',
    'ResourceRangeArgs',
    'SharingProfileArgs',
    'SnapshotSkuArgs',
    'SourceVaultArgs',
    'TargetRegionArgs',
    'UserArtifactManageArgs',
    'UserArtifactSourceArgs',
]

@pulumi.input_type
class CreationDataArgs:
    def __init__(__self__, *,
                 create_option: pulumi.Input[Union[str, 'DiskCreateOption']],
                 gallery_image_reference: Optional[pulumi.Input['ImageDiskReferenceArgs']] = None,
                 image_reference: Optional[pulumi.Input['ImageDiskReferenceArgs']] = None,
                 logical_sector_size: Optional[pulumi.Input[int]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 source_uri: Optional[pulumi.Input[str]] = None,
                 storage_account_id: Optional[pulumi.Input[str]] = None,
                 upload_size_bytes: Optional[pulumi.Input[float]] = None):
        """
        Data used when creating a disk.
        :param pulumi.Input[Union[str, 'DiskCreateOption']] create_option: This enumerates the possible sources of a disk's creation.
        :param pulumi.Input['ImageDiskReferenceArgs'] gallery_image_reference: Required if creating from a Gallery Image. The id of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
        :param pulumi.Input['ImageDiskReferenceArgs'] image_reference: Disk source information.
        :param pulumi.Input[int] logical_sector_size: Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
        :param pulumi.Input[str] source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot or disk.
        :param pulumi.Input[str] source_uri: If createOption is Import, this is the URI of a blob to be imported into a managed disk.
        :param pulumi.Input[str] storage_account_id: Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
        :param pulumi.Input[float] upload_size_bytes: If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
        """
        pulumi.set(__self__, "create_option", create_option)
        if gallery_image_reference is not None:
            pulumi.set(__self__, "gallery_image_reference", gallery_image_reference)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if logical_sector_size is not None:
            pulumi.set(__self__, "logical_sector_size", logical_sector_size)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if upload_size_bytes is not None:
            pulumi.set(__self__, "upload_size_bytes", upload_size_bytes)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> pulumi.Input[Union[str, 'DiskCreateOption']]:
        """
        This enumerates the possible sources of a disk's creation.
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: pulumi.Input[Union[str, 'DiskCreateOption']]):
        pulumi.set(self, "create_option", value)

    @property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> Optional[pulumi.Input['ImageDiskReferenceArgs']]:
        """
        Required if creating from a Gallery Image. The id of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
        """
        return pulumi.get(self, "gallery_image_reference")

    @gallery_image_reference.setter
    def gallery_image_reference(self, value: Optional[pulumi.Input['ImageDiskReferenceArgs']]):
        pulumi.set(self, "gallery_image_reference", value)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional[pulumi.Input['ImageDiskReferenceArgs']]:
        """
        Disk source information.
        """
        return pulumi.get(self, "image_reference")

    @image_reference.setter
    def image_reference(self, value: Optional[pulumi.Input['ImageDiskReferenceArgs']]):
        pulumi.set(self, "image_reference", value)

    @property
    @pulumi.getter(name="logicalSectorSize")
    def logical_sector_size(self) -> Optional[pulumi.Input[int]]:
        """
        Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
        """
        return pulumi.get(self, "logical_sector_size")

    @logical_sector_size.setter
    def logical_sector_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "logical_sector_size", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        If createOption is Copy, this is the ARM id of the source snapshot or disk.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[pulumi.Input[str]]:
        """
        If createOption is Import, this is the URI of a blob to be imported into a managed disk.
        """
        return pulumi.get(self, "source_uri")

    @source_uri.setter
    def source_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_uri", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter(name="uploadSizeBytes")
    def upload_size_bytes(self) -> Optional[pulumi.Input[float]]:
        """
        If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
        """
        return pulumi.get(self, "upload_size_bytes")

    @upload_size_bytes.setter
    def upload_size_bytes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "upload_size_bytes", value)


@pulumi.input_type
class DataDiskImageEncryptionArgs:
    def __init__(__self__, *,
                 lun: pulumi.Input[int],
                 disk_encryption_set_id: Optional[pulumi.Input[str]] = None):
        """
        Contains encryption settings for a data disk image.
        :param pulumi.Input[int] lun: This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        :param pulumi.Input[str] disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption set.
        """
        pulumi.set(__self__, "lun", lun)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[int]:
        """
        This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        A relative URI containing the resource ID of the disk encryption set.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_set_id", value)


@pulumi.input_type
class DisallowedArgs:
    def __init__(__self__, *,
                 disk_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Describes the disallowed disk types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_types: A list of disk types.
        """
        if disk_types is not None:
            pulumi.set(__self__, "disk_types", disk_types)

    @property
    @pulumi.getter(name="diskTypes")
    def disk_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of disk types.
        """
        return pulumi.get(self, "disk_types")

    @disk_types.setter
    def disk_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disk_types", value)


@pulumi.input_type
class DiskSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'DiskStorageAccountTypes']]] = None):
        """
        The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, or UltraSSD_LRS.
        :param pulumi.Input[Union[str, 'DiskStorageAccountTypes']] name: The sku name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'DiskStorageAccountTypes']]]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'DiskStorageAccountTypes']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EncryptionImagesArgs:
    def __init__(__self__, *,
                 data_disk_images: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskImageEncryptionArgs']]]] = None,
                 os_disk_image: Optional[pulumi.Input['OSDiskImageEncryptionArgs']] = None):
        """
        Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
        :param pulumi.Input[Sequence[pulumi.Input['DataDiskImageEncryptionArgs']]] data_disk_images: A list of encryption specifications for data disk images.
        :param pulumi.Input['OSDiskImageEncryptionArgs'] os_disk_image: Contains encryption settings for an OS disk image.
        """
        if data_disk_images is not None:
            pulumi.set(__self__, "data_disk_images", data_disk_images)
        if os_disk_image is not None:
            pulumi.set(__self__, "os_disk_image", os_disk_image)

    @property
    @pulumi.getter(name="dataDiskImages")
    def data_disk_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskImageEncryptionArgs']]]]:
        """
        A list of encryption specifications for data disk images.
        """
        return pulumi.get(self, "data_disk_images")

    @data_disk_images.setter
    def data_disk_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskImageEncryptionArgs']]]]):
        pulumi.set(self, "data_disk_images", value)

    @property
    @pulumi.getter(name="osDiskImage")
    def os_disk_image(self) -> Optional[pulumi.Input['OSDiskImageEncryptionArgs']]:
        """
        Contains encryption settings for an OS disk image.
        """
        return pulumi.get(self, "os_disk_image")

    @os_disk_image.setter
    def os_disk_image(self, value: Optional[pulumi.Input['OSDiskImageEncryptionArgs']]):
        pulumi.set(self, "os_disk_image", value)


@pulumi.input_type
class EncryptionSetIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'DiskEncryptionSetIdentityType']]] = None):
        """
        The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
        :param pulumi.Input[Union[str, 'DiskEncryptionSetIdentityType']] type: The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported for new creations. Disk Encryption Sets can be updated with Identity type None during migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted resources to lose access to the keys.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'DiskEncryptionSetIdentityType']]]:
        """
        The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported for new creations. Disk Encryption Sets can be updated with Identity type None during migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted resources to lose access to the keys.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'DiskEncryptionSetIdentityType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class EncryptionSettingsCollectionArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 encryption_settings: Optional[pulumi.Input[Sequence[pulumi.Input['EncryptionSettingsElementArgs']]]] = None,
                 encryption_settings_version: Optional[pulumi.Input[str]] = None):
        """
        Encryption settings for disk or snapshot
        :param pulumi.Input[bool] enabled: Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
        :param pulumi.Input[Sequence[pulumi.Input['EncryptionSettingsElementArgs']]] encryption_settings: A collection of encryption settings, one for each disk volume.
        :param pulumi.Input[str] encryption_settings_version: Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
        """
        pulumi.set(__self__, "enabled", enabled)
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if encryption_settings_version is not None:
            pulumi.set(__self__, "encryption_settings_version", encryption_settings_version)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EncryptionSettingsElementArgs']]]]:
        """
        A collection of encryption settings, one for each disk volume.
        """
        return pulumi.get(self, "encryption_settings")

    @encryption_settings.setter
    def encryption_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EncryptionSettingsElementArgs']]]]):
        pulumi.set(self, "encryption_settings", value)

    @property
    @pulumi.getter(name="encryptionSettingsVersion")
    def encryption_settings_version(self) -> Optional[pulumi.Input[str]]:
        """
        Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
        """
        return pulumi.get(self, "encryption_settings_version")

    @encryption_settings_version.setter
    def encryption_settings_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_settings_version", value)


@pulumi.input_type
class EncryptionSettingsElementArgs:
    def __init__(__self__, *,
                 disk_encryption_key: Optional[pulumi.Input['KeyVaultAndSecretReferenceArgs']] = None,
                 key_encryption_key: Optional[pulumi.Input['KeyVaultAndKeyReferenceArgs']] = None):
        """
        Encryption settings for one disk volume.
        :param pulumi.Input['KeyVaultAndSecretReferenceArgs'] disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key
        :param pulumi.Input['KeyVaultAndKeyReferenceArgs'] key_encryption_key: Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
        """
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional[pulumi.Input['KeyVaultAndSecretReferenceArgs']]:
        """
        Key Vault Secret Url and vault id of the disk encryption key
        """
        return pulumi.get(self, "disk_encryption_key")

    @disk_encryption_key.setter
    def disk_encryption_key(self, value: Optional[pulumi.Input['KeyVaultAndSecretReferenceArgs']]):
        pulumi.set(self, "disk_encryption_key", value)

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional[pulumi.Input['KeyVaultAndKeyReferenceArgs']]:
        """
        Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
        """
        return pulumi.get(self, "key_encryption_key")

    @key_encryption_key.setter
    def key_encryption_key(self, value: Optional[pulumi.Input['KeyVaultAndKeyReferenceArgs']]):
        pulumi.set(self, "key_encryption_key", value)


@pulumi.input_type
class EncryptionArgs:
    def __init__(__self__, *,
                 disk_encryption_set_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'EncryptionType']]] = None):
        """
        Encryption at rest settings for disk or snapshot
        :param pulumi.Input[str] disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling encryption at rest.
        :param pulumi.Input[Union[str, 'EncryptionType']] type: The type of key used to encrypt the data of the disk.
        """
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        ResourceId of the disk encryption set to use for enabling encryption at rest.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'EncryptionType']]]:
        """
        The type of key used to encrypt the data of the disk.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'EncryptionType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]] = None):
        """
        The complex type of the extended location.
        :param pulumi.Input[str] name: The name of the extended location.
        :param pulumi.Input[Union[str, 'ExtendedLocationTypes']] type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GalleryApplicationVersionPublishingProfileArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['UserArtifactSourceArgs'],
                 enable_health_check: Optional[pulumi.Input[bool]] = None,
                 end_of_life_date: Optional[pulumi.Input[str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[bool]] = None,
                 manage_actions: Optional[pulumi.Input['UserArtifactManageArgs']] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'StorageAccountType']]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]] = None):
        """
        The publishing profile of a gallery image version.
        :param pulumi.Input['UserArtifactSourceArgs'] source: The source image from which the Image Version is going to be created.
        :param pulumi.Input[bool] enable_health_check: Optional. Whether or not this application reports health.
        :param pulumi.Input[str] end_of_life_date: The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        :param pulumi.Input[bool] exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        :param pulumi.Input[int] replica_count: The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        :param pulumi.Input[Union[str, 'StorageAccountType']] storage_account_type: Specifies the storage account type to be used to store the image. This property is not updatable.
        :param pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]] target_regions: The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        pulumi.set(__self__, "source", source)
        if enable_health_check is not None:
            pulumi.set(__self__, "enable_health_check", enable_health_check)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if manage_actions is not None:
            pulumi.set(__self__, "manage_actions", manage_actions)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if target_regions is not None:
            pulumi.set(__self__, "target_regions", target_regions)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['UserArtifactSourceArgs']:
        """
        The source image from which the Image Version is going to be created.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['UserArtifactSourceArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="enableHealthCheck")
    def enable_health_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether or not this application reports health.
        """
        return pulumi.get(self, "enable_health_check")

    @enable_health_check.setter
    def enable_health_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_health_check", value)

    @property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[str]]:
        """
        The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_of_life_date", value)

    @property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        """
        return pulumi.get(self, "exclude_from_latest")

    @exclude_from_latest.setter
    def exclude_from_latest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_from_latest", value)

    @property
    @pulumi.getter(name="manageActions")
    def manage_actions(self) -> Optional[pulumi.Input['UserArtifactManageArgs']]:
        return pulumi.get(self, "manage_actions")

    @manage_actions.setter
    def manage_actions(self, value: Optional[pulumi.Input['UserArtifactManageArgs']]):
        pulumi.set(self, "manage_actions", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'StorageAccountType']]]:
        """
        Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'StorageAccountType']]]):
        pulumi.set(self, "storage_account_type", value)

    @property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]]:
        """
        The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        return pulumi.get(self, "target_regions")

    @target_regions.setter
    def target_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]]):
        pulumi.set(self, "target_regions", value)


@pulumi.input_type
class GalleryArtifactVersionSourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        The gallery artifact version source.
        :param pulumi.Input[str] id: The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
        :param pulumi.Input[str] uri: The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GalleryDataDiskImageArgs:
    def __init__(__self__, *,
                 lun: pulumi.Input[int],
                 host_caching: Optional[pulumi.Input['HostCaching']] = None,
                 source: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']] = None):
        """
        This is the data disk image.
        :param pulumi.Input[int] lun: This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        :param pulumi.Input['HostCaching'] host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        :param pulumi.Input['GalleryArtifactVersionSourceArgs'] source: The gallery artifact version source.
        """
        pulumi.set(__self__, "lun", lun)
        if host_caching is not None:
            pulumi.set(__self__, "host_caching", host_caching)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[int]:
        """
        This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter(name="hostCaching")
    def host_caching(self) -> Optional[pulumi.Input['HostCaching']]:
        """
        The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        """
        return pulumi.get(self, "host_caching")

    @host_caching.setter
    def host_caching(self, value: Optional[pulumi.Input['HostCaching']]):
        pulumi.set(self, "host_caching", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]:
        """
        The gallery artifact version source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class GalleryImageFeatureArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        A feature for gallery image.
        :param pulumi.Input[str] name: The name of the gallery image feature.
        :param pulumi.Input[str] value: The value of the gallery image feature.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the gallery image feature.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the gallery image feature.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GalleryImageIdentifierArgs:
    def __init__(__self__, *,
                 offer: pulumi.Input[str],
                 publisher: pulumi.Input[str],
                 sku: pulumi.Input[str]):
        """
        This is the gallery image definition identifier.
        :param pulumi.Input[str] offer: The name of the gallery image definition offer.
        :param pulumi.Input[str] publisher: The name of the gallery image definition publisher.
        :param pulumi.Input[str] sku: The name of the gallery image definition SKU.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Input[str]:
        """
        The name of the gallery image definition offer.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: pulumi.Input[str]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[str]:
        """
        The name of the gallery image definition publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[str]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input[str]:
        """
        The name of the gallery image definition SKU.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[str]):
        pulumi.set(self, "sku", value)


@pulumi.input_type
class GalleryImageVersionPublishingProfileArgs:
    def __init__(__self__, *,
                 end_of_life_date: Optional[pulumi.Input[str]] = None,
                 exclude_from_latest: Optional[pulumi.Input[bool]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'StorageAccountType']]] = None,
                 target_regions: Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]] = None):
        """
        The publishing profile of a gallery image Version.
        :param pulumi.Input[str] end_of_life_date: The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        :param pulumi.Input[bool] exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        :param pulumi.Input[int] replica_count: The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        :param pulumi.Input[Union[str, 'StorageAccountType']] storage_account_type: Specifies the storage account type to be used to store the image. This property is not updatable.
        :param pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]] target_regions: The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if target_regions is not None:
            pulumi.set(__self__, "target_regions", target_regions)

    @property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[str]]:
        """
        The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_of_life_date", value)

    @property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
        """
        return pulumi.get(self, "exclude_from_latest")

    @exclude_from_latest.setter
    def exclude_from_latest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_from_latest", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'StorageAccountType']]]:
        """
        Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'StorageAccountType']]]):
        pulumi.set(self, "storage_account_type", value)

    @property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]]:
        """
        The target regions where the Image Version is going to be replicated to. This property is updatable.
        """
        return pulumi.get(self, "target_regions")

    @target_regions.setter
    def target_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetRegionArgs']]]]):
        pulumi.set(self, "target_regions", value)


@pulumi.input_type
class GalleryImageVersionStorageProfileArgs:
    def __init__(__self__, *,
                 data_disk_images: Optional[pulumi.Input[Sequence[pulumi.Input['GalleryDataDiskImageArgs']]]] = None,
                 os_disk_image: Optional[pulumi.Input['GalleryOSDiskImageArgs']] = None,
                 source: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']] = None):
        """
        This is the storage profile of a Gallery Image Version.
        :param pulumi.Input[Sequence[pulumi.Input['GalleryDataDiskImageArgs']]] data_disk_images: A list of data disk images.
        :param pulumi.Input['GalleryOSDiskImageArgs'] os_disk_image: This is the OS disk image.
        :param pulumi.Input['GalleryArtifactVersionSourceArgs'] source: The gallery artifact version source.
        """
        if data_disk_images is not None:
            pulumi.set(__self__, "data_disk_images", data_disk_images)
        if os_disk_image is not None:
            pulumi.set(__self__, "os_disk_image", os_disk_image)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="dataDiskImages")
    def data_disk_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GalleryDataDiskImageArgs']]]]:
        """
        A list of data disk images.
        """
        return pulumi.get(self, "data_disk_images")

    @data_disk_images.setter
    def data_disk_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GalleryDataDiskImageArgs']]]]):
        pulumi.set(self, "data_disk_images", value)

    @property
    @pulumi.getter(name="osDiskImage")
    def os_disk_image(self) -> Optional[pulumi.Input['GalleryOSDiskImageArgs']]:
        """
        This is the OS disk image.
        """
        return pulumi.get(self, "os_disk_image")

    @os_disk_image.setter
    def os_disk_image(self, value: Optional[pulumi.Input['GalleryOSDiskImageArgs']]):
        pulumi.set(self, "os_disk_image", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]:
        """
        The gallery artifact version source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class GalleryOSDiskImageArgs:
    def __init__(__self__, *,
                 host_caching: Optional[pulumi.Input['HostCaching']] = None,
                 source: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']] = None):
        """
        This is the OS disk image.
        :param pulumi.Input['HostCaching'] host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        :param pulumi.Input['GalleryArtifactVersionSourceArgs'] source: The gallery artifact version source.
        """
        if host_caching is not None:
            pulumi.set(__self__, "host_caching", host_caching)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="hostCaching")
    def host_caching(self) -> Optional[pulumi.Input['HostCaching']]:
        """
        The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
        """
        return pulumi.get(self, "host_caching")

    @host_caching.setter
    def host_caching(self, value: Optional[pulumi.Input['HostCaching']]):
        pulumi.set(self, "host_caching", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]:
        """
        The gallery artifact version source.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['GalleryArtifactVersionSourceArgs']]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class ImageDiskReferenceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 lun: Optional[pulumi.Input[int]] = None):
        """
        The source image used for creating the disk.
        :param pulumi.Input[str] id: A relative uri containing either a Platform Image Repository or user image reference.
        :param pulumi.Input[int] lun: If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
        """
        pulumi.set(__self__, "id", id)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        A relative uri containing either a Platform Image Repository or user image reference.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def lun(self) -> Optional[pulumi.Input[int]]:
        """
        If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lun", value)


@pulumi.input_type
class ImagePurchasePlanArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 product: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None):
        """
        Describes the gallery image definition purchase plan. This is used by marketplace images.
        :param pulumi.Input[str] name: The plan ID.
        :param pulumi.Input[str] product: The product ID.
        :param pulumi.Input[str] publisher: The publisher ID.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The plan ID.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input[str]]:
        """
        The product ID.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)


@pulumi.input_type
class KeyForDiskEncryptionSetArgs:
    def __init__(__self__, *,
                 key_url: pulumi.Input[str],
                 source_vault: Optional[pulumi.Input['SourceVaultArgs']] = None):
        """
        Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
        :param pulumi.Input[str] key_url: Fully versioned Key Url pointing to a key in KeyVault
        :param pulumi.Input['SourceVaultArgs'] source_vault: Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
        """
        pulumi.set(__self__, "key_url", key_url)
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> pulumi.Input[str]:
        """
        Fully versioned Key Url pointing to a key in KeyVault
        """
        return pulumi.get(self, "key_url")

    @key_url.setter
    def key_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_url", value)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional[pulumi.Input['SourceVaultArgs']]:
        """
        Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: Optional[pulumi.Input['SourceVaultArgs']]):
        pulumi.set(self, "source_vault", value)


@pulumi.input_type
class KeyVaultAndKeyReferenceArgs:
    def __init__(__self__, *,
                 key_url: pulumi.Input[str],
                 source_vault: pulumi.Input['SourceVaultArgs']):
        """
        Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey
        :param pulumi.Input[str] key_url: Url pointing to a key or secret in KeyVault
        :param pulumi.Input['SourceVaultArgs'] source_vault: Resource id of the KeyVault containing the key or secret
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> pulumi.Input[str]:
        """
        Url pointing to a key or secret in KeyVault
        """
        return pulumi.get(self, "key_url")

    @key_url.setter
    def key_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_url", value)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> pulumi.Input['SourceVaultArgs']:
        """
        Resource id of the KeyVault containing the key or secret
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: pulumi.Input['SourceVaultArgs']):
        pulumi.set(self, "source_vault", value)


@pulumi.input_type
class KeyVaultAndSecretReferenceArgs:
    def __init__(__self__, *,
                 secret_url: pulumi.Input[str],
                 source_vault: pulumi.Input['SourceVaultArgs']):
        """
        Key Vault Secret Url and vault id of the encryption key 
        :param pulumi.Input[str] secret_url: Url pointing to a key or secret in KeyVault
        :param pulumi.Input['SourceVaultArgs'] source_vault: Resource id of the KeyVault containing the key or secret
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> pulumi.Input[str]:
        """
        Url pointing to a key or secret in KeyVault
        """
        return pulumi.get(self, "secret_url")

    @secret_url.setter
    def secret_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_url", value)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> pulumi.Input['SourceVaultArgs']:
        """
        Resource id of the KeyVault containing the key or secret
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: pulumi.Input['SourceVaultArgs']):
        pulumi.set(self, "source_vault", value)


@pulumi.input_type
class OSDiskImageEncryptionArgs:
    def __init__(__self__, *,
                 disk_encryption_set_id: Optional[pulumi.Input[str]] = None):
        """
        Contains encryption settings for an OS disk image.
        :param pulumi.Input[str] disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption set.
        """
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        A relative URI containing the resource ID of the disk encryption set.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_set_id", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class PurchasePlanArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 product: pulumi.Input[str],
                 publisher: pulumi.Input[str],
                 promotion_code: Optional[pulumi.Input[str]] = None):
        """
        Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
        :param pulumi.Input[str] name: The plan ID.
        :param pulumi.Input[str] product: Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        :param pulumi.Input[str] publisher: The publisher ID.
        :param pulumi.Input[str] promotion_code: The Offer Promotion Code.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The plan ID.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def product(self) -> pulumi.Input[str]:
        """
        Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: pulumi.Input[str]):
        pulumi.set(self, "product", value)

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[str]:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[str]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[pulumi.Input[str]]:
        """
        The Offer Promotion Code.
        """
        return pulumi.get(self, "promotion_code")

    @promotion_code.setter
    def promotion_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "promotion_code", value)


@pulumi.input_type
class RecommendedMachineConfigurationArgs:
    def __init__(__self__, *,
                 memory: Optional[pulumi.Input['ResourceRangeArgs']] = None,
                 v_cpus: Optional[pulumi.Input['ResourceRangeArgs']] = None):
        """
        The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.
        :param pulumi.Input['ResourceRangeArgs'] memory: Describes the resource range.
        :param pulumi.Input['ResourceRangeArgs'] v_cpus: Describes the resource range.
        """
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if v_cpus is not None:
            pulumi.set(__self__, "v_cpus", v_cpus)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input['ResourceRangeArgs']]:
        """
        Describes the resource range.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input['ResourceRangeArgs']]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="vCPUs")
    def v_cpus(self) -> Optional[pulumi.Input['ResourceRangeArgs']]:
        """
        Describes the resource range.
        """
        return pulumi.get(self, "v_cpus")

    @v_cpus.setter
    def v_cpus(self, value: Optional[pulumi.Input['ResourceRangeArgs']]):
        pulumi.set(self, "v_cpus", value)


@pulumi.input_type
class ResourceRangeArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[int]] = None,
                 min: Optional[pulumi.Input[int]] = None):
        """
        Describes the resource range.
        :param pulumi.Input[int] max: The maximum number of the resource.
        :param pulumi.Input[int] min: The minimum number of the resource.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of the resource.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of the resource.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min", value)


@pulumi.input_type
class SharingProfileArgs:
    def __init__(__self__, *,
                 permissions: Optional[pulumi.Input[Union[str, 'GallerySharingPermissionTypes']]] = None):
        """
        Profile for gallery sharing to subscription or tenant
        :param pulumi.Input[Union[str, 'GallerySharingPermissionTypes']] permissions: This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups**
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Union[str, 'GallerySharingPermissionTypes']]]:
        """
        This property allows you to specify the permission of sharing gallery. <br><br> Possible values are: <br><br> **Private** <br><br> **Groups**
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Union[str, 'GallerySharingPermissionTypes']]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class SnapshotSkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'SnapshotStorageAccountTypes']]] = None):
        """
        The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
        :param pulumi.Input[Union[str, 'SnapshotStorageAccountTypes']] name: The sku name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'SnapshotStorageAccountTypes']]]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'SnapshotStorageAccountTypes']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SourceVaultArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        The vault id is an Azure Resource Manager Resource id in the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
        :param pulumi.Input[str] id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class TargetRegionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 encryption: Optional[pulumi.Input['EncryptionImagesArgs']] = None,
                 regional_replica_count: Optional[pulumi.Input[int]] = None,
                 storage_account_type: Optional[pulumi.Input[Union[str, 'StorageAccountType']]] = None):
        """
        Describes the target region information.
        :param pulumi.Input[str] name: The name of the region.
        :param pulumi.Input['EncryptionImagesArgs'] encryption: Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
        :param pulumi.Input[int] regional_replica_count: The number of replicas of the Image Version to be created per region. This property is updatable.
        :param pulumi.Input[Union[str, 'StorageAccountType']] storage_account_type: Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        pulumi.set(__self__, "name", name)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if regional_replica_count is not None:
            pulumi.set(__self__, "regional_replica_count", regional_replica_count)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the region.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['EncryptionImagesArgs']]:
        """
        Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['EncryptionImagesArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="regionalReplicaCount")
    def regional_replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of replicas of the Image Version to be created per region. This property is updatable.
        """
        return pulumi.get(self, "regional_replica_count")

    @regional_replica_count.setter
    def regional_replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "regional_replica_count", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[Union[str, 'StorageAccountType']]]:
        """
        Specifies the storage account type to be used to store the image. This property is not updatable.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[Union[str, 'StorageAccountType']]]):
        pulumi.set(self, "storage_account_type", value)


@pulumi.input_type
class UserArtifactManageArgs:
    def __init__(__self__, *,
                 install: pulumi.Input[str],
                 remove: pulumi.Input[str],
                 update: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] install: Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
        :param pulumi.Input[str] remove: Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
        :param pulumi.Input[str] update: Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters.
        """
        pulumi.set(__self__, "install", install)
        pulumi.set(__self__, "remove", remove)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def install(self) -> pulumi.Input[str]:
        """
        Required. The path and arguments to install the gallery application. This is limited to 4096 characters.
        """
        return pulumi.get(self, "install")

    @install.setter
    def install(self, value: pulumi.Input[str]):
        pulumi.set(self, "install", value)

    @property
    @pulumi.getter
    def remove(self) -> pulumi.Input[str]:
        """
        Required. The path and arguments to remove the gallery application. This is limited to 4096 characters.
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: pulumi.Input[str]):
        pulumi.set(self, "remove", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The path and arguments to update the gallery application. If not present, then update operation will invoke remove command on the previous version and install command on the current version of the gallery application. This is limited to 4096 characters.
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update", value)


@pulumi.input_type
class UserArtifactSourceArgs:
    def __init__(__self__, *,
                 media_link: pulumi.Input[str],
                 default_configuration_link: Optional[pulumi.Input[str]] = None):
        """
        The source image from which the Image Version is going to be created.
        :param pulumi.Input[str] media_link: Required. The mediaLink of the artifact, must be a readable storage page blob.
        :param pulumi.Input[str] default_configuration_link: Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
        """
        pulumi.set(__self__, "media_link", media_link)
        if default_configuration_link is not None:
            pulumi.set(__self__, "default_configuration_link", default_configuration_link)

    @property
    @pulumi.getter(name="mediaLink")
    def media_link(self) -> pulumi.Input[str]:
        """
        Required. The mediaLink of the artifact, must be a readable storage page blob.
        """
        return pulumi.get(self, "media_link")

    @media_link.setter
    def media_link(self, value: pulumi.Input[str]):
        pulumi.set(self, "media_link", value)

    @property
    @pulumi.getter(name="defaultConfigurationLink")
    def default_configuration_link(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The defaultConfigurationLink of the artifact, must be a readable storage page blob.
        """
        return pulumi.get(self, "default_configuration_link")

    @default_configuration_link.setter
    def default_configuration_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_configuration_link", value)


