# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CustomDomainResponse',
    'EncryptionResponse',
    'EncryptionServiceResponse',
    'EncryptionServicesResponse',
    'EndpointsResponse',
    'IPRuleResponse',
    'IdentityResponse',
    'KeyVaultPropertiesResponse',
    'NetworkRuleSetResponse',
    'RestrictionResponse',
    'SKUCapabilityResponse',
    'SkuResponse',
    'StorageAccountKeyResponse',
    'VirtualNetworkRuleResponse',
]

@pulumi.output_type
class CustomDomainResponse(dict):
    """
    The custom domain assigned to this storage account. This can be set via Update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useSubDomainName":
            suggest = "use_sub_domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDomainResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDomainResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDomainResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 use_sub_domain_name: Optional[bool] = None):
        """
        The custom domain assigned to this storage account. This can be set via Update.
        :param str name: Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
        :param bool use_sub_domain_name: Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
        """
        pulumi.set(__self__, "name", name)
        if use_sub_domain_name is not None:
            pulumi.set(__self__, "use_sub_domain_name", use_sub_domain_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="useSubDomainName")
    def use_sub_domain_name(self) -> Optional[bool]:
        """
        Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
        """
        return pulumi.get(self, "use_sub_domain_name")


@pulumi.output_type
class EncryptionResponse(dict):
    """
    The encryption settings on the storage account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keySource":
            suggest = "key_source"
        elif key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_source: str,
                 key_vault_properties: Optional['outputs.KeyVaultPropertiesResponse'] = None,
                 services: Optional['outputs.EncryptionServicesResponse'] = None):
        """
        The encryption settings on the storage account.
        :param str key_source: The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
        :param 'KeyVaultPropertiesResponse' key_vault_properties: Properties provided by key vault.
        :param 'EncryptionServicesResponse' services: List of services which support encryption.
        """
        if key_source is None:
            key_source = 'Microsoft.Storage'
        pulumi.set(__self__, "key_source", key_source)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> str:
        """
        The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
        """
        return pulumi.get(self, "key_source")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.KeyVaultPropertiesResponse']:
        """
        Properties provided by key vault.
        """
        return pulumi.get(self, "key_vault_properties")

    @property
    @pulumi.getter
    def services(self) -> Optional['outputs.EncryptionServicesResponse']:
        """
        List of services which support encryption.
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class EncryptionServiceResponse(dict):
    """
    A service that allows server-side encryption to be used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastEnabledTime":
            suggest = "last_enabled_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_enabled_time: str,
                 enabled: Optional[bool] = None):
        """
        A service that allows server-side encryption to be used.
        :param str last_enabled_time: Gets a rough estimate of the date/time when the encryption was last enabled by the user. Only returned when encryption is enabled. There might be some unencrypted blobs which were written after this time, as it is just a rough estimate.
        :param bool enabled: A boolean indicating whether or not the service encrypts the data as it is stored.
        """
        pulumi.set(__self__, "last_enabled_time", last_enabled_time)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="lastEnabledTime")
    def last_enabled_time(self) -> str:
        """
        Gets a rough estimate of the date/time when the encryption was last enabled by the user. Only returned when encryption is enabled. There might be some unencrypted blobs which were written after this time, as it is just a rough estimate.
        """
        return pulumi.get(self, "last_enabled_time")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        A boolean indicating whether or not the service encrypts the data as it is stored.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class EncryptionServicesResponse(dict):
    """
    A list of services that support encryption.
    """
    def __init__(__self__, *,
                 queue: 'outputs.EncryptionServiceResponse',
                 table: 'outputs.EncryptionServiceResponse',
                 blob: Optional['outputs.EncryptionServiceResponse'] = None,
                 file: Optional['outputs.EncryptionServiceResponse'] = None):
        """
        A list of services that support encryption.
        :param 'EncryptionServiceResponse' queue: The encryption function of the queue storage service.
        :param 'EncryptionServiceResponse' table: The encryption function of the table storage service.
        :param 'EncryptionServiceResponse' blob: The encryption function of the blob storage service.
        :param 'EncryptionServiceResponse' file: The encryption function of the file storage service.
        """
        pulumi.set(__self__, "queue", queue)
        pulumi.set(__self__, "table", table)
        if blob is not None:
            pulumi.set(__self__, "blob", blob)
        if file is not None:
            pulumi.set(__self__, "file", file)

    @property
    @pulumi.getter
    def queue(self) -> 'outputs.EncryptionServiceResponse':
        """
        The encryption function of the queue storage service.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter
    def table(self) -> 'outputs.EncryptionServiceResponse':
        """
        The encryption function of the table storage service.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def blob(self) -> Optional['outputs.EncryptionServiceResponse']:
        """
        The encryption function of the blob storage service.
        """
        return pulumi.get(self, "blob")

    @property
    @pulumi.getter
    def file(self) -> Optional['outputs.EncryptionServiceResponse']:
        """
        The encryption function of the file storage service.
        """
        return pulumi.get(self, "file")


@pulumi.output_type
class EndpointsResponse(dict):
    """
    The URIs that are used to perform a retrieval of a public blob, queue, or table object.
    """
    def __init__(__self__, *,
                 blob: str,
                 file: str,
                 queue: str,
                 table: str):
        """
        The URIs that are used to perform a retrieval of a public blob, queue, or table object.
        :param str blob: Gets the blob endpoint.
        :param str file: Gets the file endpoint.
        :param str queue: Gets the queue endpoint.
        :param str table: Gets the table endpoint.
        """
        pulumi.set(__self__, "blob", blob)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "queue", queue)
        pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter
    def blob(self) -> str:
        """
        Gets the blob endpoint.
        """
        return pulumi.get(self, "blob")

    @property
    @pulumi.getter
    def file(self) -> str:
        """
        Gets the file endpoint.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def queue(self) -> str:
        """
        Gets the queue endpoint.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Gets the table endpoint.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class IPRuleResponse(dict):
    """
    IP rule with specific IP or IP range in CIDR format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iPAddressOrRange":
            suggest = "i_p_address_or_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 i_p_address_or_range: str,
                 action: Optional[str] = None):
        """
        IP rule with specific IP or IP range in CIDR format.
        :param str i_p_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        :param str action: The action of IP ACL rule.
        """
        pulumi.set(__self__, "i_p_address_or_range", i_p_address_or_range)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="iPAddressOrRange")
    def i_p_address_or_range(self) -> str:
        """
        Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        """
        return pulumi.get(self, "i_p_address_or_range")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The action of IP ACL rule.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    """
    Properties of key vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "keyVaultUri":
            suggest = "key_vault_uri"
        elif key == "keyVersion":
            suggest = "key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: Optional[str] = None,
                 key_vault_uri: Optional[str] = None,
                 key_version: Optional[str] = None):
        """
        Properties of key vault.
        :param str key_name: The name of KeyVault key.
        :param str key_vault_uri: The Uri of KeyVault.
        :param str key_version: The version of KeyVault key.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[str]:
        """
        The name of KeyVault key.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[str]:
        """
        The Uri of KeyVault.
        """
        return pulumi.get(self, "key_vault_uri")

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[str]:
        """
        The version of KeyVault key.
        """
        return pulumi.get(self, "key_version")


@pulumi.output_type
class NetworkRuleSetResponse(dict):
    """
    Network rule set
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "virtualNetworkRules":
            suggest = "virtual_network_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: str,
                 bypass: Optional[str] = None,
                 ip_rules: Optional[Sequence['outputs.IPRuleResponse']] = None,
                 virtual_network_rules: Optional[Sequence['outputs.VirtualNetworkRuleResponse']] = None):
        """
        Network rule set
        :param str default_action: Specifies the default action of allow or deny when no other rules match.
        :param str bypass: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
        :param Sequence['IPRuleResponse'] ip_rules: Sets the IP ACL rules
        :param Sequence['VirtualNetworkRuleResponse'] virtual_network_rules: Sets the virtual network rules
        """
        if default_action is None:
            default_action = 'Allow'
        pulumi.set(__self__, "default_action", default_action)
        if bypass is None:
            bypass = 'AzureServices'
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> str:
        """
        Specifies the default action of allow or deny when no other rules match.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter
    def bypass(self) -> Optional[str]:
        """
        Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
        """
        return pulumi.get(self, "bypass")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence['outputs.IPRuleResponse']]:
        """
        Sets the IP ACL rules
        """
        return pulumi.get(self, "ip_rules")

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[Sequence['outputs.VirtualNetworkRuleResponse']]:
        """
        Sets the virtual network rules
        """
        return pulumi.get(self, "virtual_network_rules")


@pulumi.output_type
class RestrictionResponse(dict):
    """
    The restriction because of which SKU cannot be used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reasonCode":
            suggest = "reason_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 values: Sequence[str],
                 reason_code: Optional[str] = None):
        """
        The restriction because of which SKU cannot be used.
        :param str type: The type of restrictions. As of now only possible value for this is location.
        :param Sequence[str] values: The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
        :param str reason_code: The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "values", values)
        if reason_code is not None:
            pulumi.set(__self__, "reason_code", reason_code)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of restrictions. As of now only possible value for this is location.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter(name="reasonCode")
    def reason_code(self) -> Optional[str]:
        """
        The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC.
        """
        return pulumi.get(self, "reason_code")


@pulumi.output_type
class SKUCapabilityResponse(dict):
    """
    The capability information in the specified sku, including file encryption, network acls, change notification, etc.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        The capability information in the specified sku, including file encryption, network acls, change notification, etc.
        :param str name: The name of capability, The capability information in the specified sku, including file encryption, network acls, change notification, etc.
        :param str value: A string value to indicate states of given capability. Possibly 'true' or 'false'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of capability, The capability information in the specified sku, including file encryption, network acls, change notification, etc.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A string value to indicate states of given capability. Possibly 'true' or 'false'.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SkuResponse(dict):
    """
    The SKU of the storage account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkuResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkuResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkuResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capabilities: Sequence['outputs.SKUCapabilityResponse'],
                 kind: str,
                 locations: Sequence[str],
                 name: str,
                 resource_type: str,
                 tier: str,
                 restrictions: Optional[Sequence['outputs.RestrictionResponse']] = None):
        """
        The SKU of the storage account.
        :param Sequence['SKUCapabilityResponse'] capabilities: The capability information in the specified sku, including file encryption, network acls, change notification, etc.
        :param str kind: Indicates the type of storage account.
        :param Sequence[str] locations: The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
        :param str name: Gets or sets the sku name. Required for account creation; optional for update. Note that in older versions, sku name was called accountType.
        :param str resource_type: The type of the resource, usually it is 'storageAccounts'.
        :param str tier: Gets the sku tier. This is based on the SKU name.
        :param Sequence['RestrictionResponse'] restrictions: The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
        """
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "tier", tier)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)

    @property
    @pulumi.getter
    def capabilities(self) -> Sequence['outputs.SKUCapabilityResponse']:
        """
        The capability information in the specified sku, including file encryption, network acls, change notification, etc.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Indicates the type of storage account.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def locations(self) -> Sequence[str]:
        """
        The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Gets or sets the sku name. Required for account creation; optional for update. Note that in older versions, sku name was called accountType.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The type of the resource, usually it is 'storageAccounts'.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Gets the sku tier. This is based on the SKU name.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def restrictions(self) -> Optional[Sequence['outputs.RestrictionResponse']]:
        """
        The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
        """
        return pulumi.get(self, "restrictions")


@pulumi.output_type
class StorageAccountKeyResponse(dict):
    """
    An access key for the storage account.
    """
    def __init__(__self__, *,
                 key_name: str,
                 permissions: str,
                 value: str):
        """
        An access key for the storage account.
        :param str key_name: Name of the key.
        :param str permissions: Permissions for the key -- read-only or full permissions.
        :param str value: Base 64-encoded value of the key.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Name of the key.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def permissions(self) -> str:
        """
        Permissions for the key -- read-only or full permissions.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Base 64-encoded value of the key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class VirtualNetworkRuleResponse(dict):
    """
    Virtual Network rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualNetworkResourceId":
            suggest = "virtual_network_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 virtual_network_resource_id: str,
                 action: Optional[str] = None,
                 state: Optional[str] = None):
        """
        Virtual Network rule.
        :param str virtual_network_resource_id: Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :param str action: The action of virtual network rule.
        :param str state: Gets the state of virtual network rule.
        """
        pulumi.set(__self__, "virtual_network_resource_id", virtual_network_resource_id)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="virtualNetworkResourceId")
    def virtual_network_resource_id(self) -> str:
        """
        Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        """
        return pulumi.get(self, "virtual_network_resource_id")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The action of virtual network rule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Gets the state of virtual network rule.
        """
        return pulumi.get(self, "state")


