# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetNspProfileResult',
    'AwaitableGetNspProfileResult',
    'get_nsp_profile',
    'get_nsp_profile_output',
]

@pulumi.output_type
class GetNspProfileResult:
    """
    The network security perimeter profile resource
    """
    def __init__(__self__, access_rules_version=None, diagnostic_settings_version=None, id=None, location=None, name=None, tags=None, type=None):
        if access_rules_version and not isinstance(access_rules_version, str):
            raise TypeError("Expected argument 'access_rules_version' to be a str")
        pulumi.set(__self__, "access_rules_version", access_rules_version)
        if diagnostic_settings_version and not isinstance(diagnostic_settings_version, str):
            raise TypeError("Expected argument 'diagnostic_settings_version' to be a str")
        pulumi.set(__self__, "diagnostic_settings_version", diagnostic_settings_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accessRulesVersion")
    def access_rules_version(self) -> str:
        """
        Version number that increases with every update to access rules within the profile.
        """
        return pulumi.get(self, "access_rules_version")

    @property
    @pulumi.getter(name="diagnosticSettingsVersion")
    def diagnostic_settings_version(self) -> str:
        """
        Version number that increases with every update to diagnostic settings within the profile.
        """
        return pulumi.get(self, "diagnostic_settings_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetNspProfileResult(GetNspProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNspProfileResult(
            access_rules_version=self.access_rules_version,
            diagnostic_settings_version=self.diagnostic_settings_version,
            id=self.id,
            location=self.location,
            name=self.name,
            tags=self.tags,
            type=self.type)


def get_nsp_profile(network_security_perimeter_name: Optional[str] = None,
                    profile_name: Optional[str] = None,
                    resource_group_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNspProfileResult:
    """
    The network security perimeter profile resource
    API Version: 2021-02-01-preview.


    :param str network_security_perimeter_name: The name of the network security perimeter.
    :param str profile_name: The name of the NSP profile.
    :param str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['networkSecurityPerimeterName'] = network_security_perimeter_name
    __args__['profileName'] = profile_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:network:getNspProfile', __args__, opts=opts, typ=GetNspProfileResult).value

    return AwaitableGetNspProfileResult(
        access_rules_version=__ret__.access_rules_version,
        diagnostic_settings_version=__ret__.diagnostic_settings_version,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_nsp_profile)
def get_nsp_profile_output(network_security_perimeter_name: Optional[pulumi.Input[str]] = None,
                           profile_name: Optional[pulumi.Input[str]] = None,
                           resource_group_name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNspProfileResult]:
    """
    The network security perimeter profile resource
    API Version: 2021-02-01-preview.


    :param str network_security_perimeter_name: The name of the network security perimeter.
    :param str profile_name: The name of the NSP profile.
    :param str resource_group_name: The name of the resource group.
    """
    ...
