# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetContactResult',
    'AwaitableGetContactResult',
    'get_contact',
    'get_contact_output',
]

@pulumi.output_type
class GetContactResult:
    """
    Customer creates a contact resource for a spacecraft resource.
    """
    def __init__(__self__, contact_profile=None, end_azimuth_degrees=None, end_elevation_degrees=None, error_message=None, etag=None, ground_station_name=None, id=None, maximum_elevation_degrees=None, name=None, reservation_end_time=None, reservation_start_time=None, rx_end_time=None, rx_start_time=None, start_azimuth_degrees=None, start_elevation_degrees=None, status=None, system_data=None, tx_end_time=None, tx_start_time=None, type=None):
        if contact_profile and not isinstance(contact_profile, dict):
            raise TypeError("Expected argument 'contact_profile' to be a dict")
        pulumi.set(__self__, "contact_profile", contact_profile)
        if end_azimuth_degrees and not isinstance(end_azimuth_degrees, float):
            raise TypeError("Expected argument 'end_azimuth_degrees' to be a float")
        pulumi.set(__self__, "end_azimuth_degrees", end_azimuth_degrees)
        if end_elevation_degrees and not isinstance(end_elevation_degrees, float):
            raise TypeError("Expected argument 'end_elevation_degrees' to be a float")
        pulumi.set(__self__, "end_elevation_degrees", end_elevation_degrees)
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        pulumi.set(__self__, "error_message", error_message)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if ground_station_name and not isinstance(ground_station_name, str):
            raise TypeError("Expected argument 'ground_station_name' to be a str")
        pulumi.set(__self__, "ground_station_name", ground_station_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maximum_elevation_degrees and not isinstance(maximum_elevation_degrees, float):
            raise TypeError("Expected argument 'maximum_elevation_degrees' to be a float")
        pulumi.set(__self__, "maximum_elevation_degrees", maximum_elevation_degrees)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if reservation_end_time and not isinstance(reservation_end_time, str):
            raise TypeError("Expected argument 'reservation_end_time' to be a str")
        pulumi.set(__self__, "reservation_end_time", reservation_end_time)
        if reservation_start_time and not isinstance(reservation_start_time, str):
            raise TypeError("Expected argument 'reservation_start_time' to be a str")
        pulumi.set(__self__, "reservation_start_time", reservation_start_time)
        if rx_end_time and not isinstance(rx_end_time, str):
            raise TypeError("Expected argument 'rx_end_time' to be a str")
        pulumi.set(__self__, "rx_end_time", rx_end_time)
        if rx_start_time and not isinstance(rx_start_time, str):
            raise TypeError("Expected argument 'rx_start_time' to be a str")
        pulumi.set(__self__, "rx_start_time", rx_start_time)
        if start_azimuth_degrees and not isinstance(start_azimuth_degrees, float):
            raise TypeError("Expected argument 'start_azimuth_degrees' to be a float")
        pulumi.set(__self__, "start_azimuth_degrees", start_azimuth_degrees)
        if start_elevation_degrees and not isinstance(start_elevation_degrees, float):
            raise TypeError("Expected argument 'start_elevation_degrees' to be a float")
        pulumi.set(__self__, "start_elevation_degrees", start_elevation_degrees)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tx_end_time and not isinstance(tx_end_time, str):
            raise TypeError("Expected argument 'tx_end_time' to be a str")
        pulumi.set(__self__, "tx_end_time", tx_end_time)
        if tx_start_time and not isinstance(tx_start_time, str):
            raise TypeError("Expected argument 'tx_start_time' to be a str")
        pulumi.set(__self__, "tx_start_time", tx_start_time)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="contactProfile")
    def contact_profile(self) -> 'outputs.ResourceReferenceResponse':
        """
        The reference to the contact profile resource.
        """
        return pulumi.get(self, "contact_profile")

    @property
    @pulumi.getter(name="endAzimuthDegrees")
    def end_azimuth_degrees(self) -> float:
        """
        Azimuth of the antenna at the end of the contact in decimal degrees.
        """
        return pulumi.get(self, "end_azimuth_degrees")

    @property
    @pulumi.getter(name="endElevationDegrees")
    def end_elevation_degrees(self) -> float:
        """
        Spacecraft elevation above the horizon at contact end.
        """
        return pulumi.get(self, "end_elevation_degrees")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        Any error message while scheduling a contact.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        A unique read-only string that changes whenever the resource is updated.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="groundStationName")
    def ground_station_name(self) -> str:
        """
        Azure Ground Station name.
        """
        return pulumi.get(self, "ground_station_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maximumElevationDegrees")
    def maximum_elevation_degrees(self) -> float:
        """
        Maximum elevation of the antenna during the contact in decimal degrees.
        """
        return pulumi.get(self, "maximum_elevation_degrees")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="reservationEndTime")
    def reservation_end_time(self) -> str:
        """
        Reservation end time of a contact.
        """
        return pulumi.get(self, "reservation_end_time")

    @property
    @pulumi.getter(name="reservationStartTime")
    def reservation_start_time(self) -> str:
        """
        Reservation start time of a contact.
        """
        return pulumi.get(self, "reservation_start_time")

    @property
    @pulumi.getter(name="rxEndTime")
    def rx_end_time(self) -> str:
        """
        Receive end time of a contact.
        """
        return pulumi.get(self, "rx_end_time")

    @property
    @pulumi.getter(name="rxStartTime")
    def rx_start_time(self) -> str:
        """
        Receive start time of a contact.
        """
        return pulumi.get(self, "rx_start_time")

    @property
    @pulumi.getter(name="startAzimuthDegrees")
    def start_azimuth_degrees(self) -> float:
        """
        Azimuth of the antenna at the start of the contact in decimal degrees.
        """
        return pulumi.get(self, "start_azimuth_degrees")

    @property
    @pulumi.getter(name="startElevationDegrees")
    def start_elevation_degrees(self) -> float:
        """
        Spacecraft elevation above the horizon at contact start.
        """
        return pulumi.get(self, "start_elevation_degrees")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of a contact.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter(name="txEndTime")
    def tx_end_time(self) -> str:
        """
        Transmit end time of a contact.
        """
        return pulumi.get(self, "tx_end_time")

    @property
    @pulumi.getter(name="txStartTime")
    def tx_start_time(self) -> str:
        """
        Transmit start time of a contact.
        """
        return pulumi.get(self, "tx_start_time")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetContactResult(GetContactResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContactResult(
            contact_profile=self.contact_profile,
            end_azimuth_degrees=self.end_azimuth_degrees,
            end_elevation_degrees=self.end_elevation_degrees,
            error_message=self.error_message,
            etag=self.etag,
            ground_station_name=self.ground_station_name,
            id=self.id,
            maximum_elevation_degrees=self.maximum_elevation_degrees,
            name=self.name,
            reservation_end_time=self.reservation_end_time,
            reservation_start_time=self.reservation_start_time,
            rx_end_time=self.rx_end_time,
            rx_start_time=self.rx_start_time,
            start_azimuth_degrees=self.start_azimuth_degrees,
            start_elevation_degrees=self.start_elevation_degrees,
            status=self.status,
            system_data=self.system_data,
            tx_end_time=self.tx_end_time,
            tx_start_time=self.tx_start_time,
            type=self.type)


def get_contact(contact_name: Optional[str] = None,
                resource_group_name: Optional[str] = None,
                spacecraft_name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContactResult:
    """
    Customer creates a contact resource for a spacecraft resource.
    API Version: 2021-04-04-preview.


    :param str contact_name: Contact Name
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str spacecraft_name: Spacecraft ID
    """
    __args__ = dict()
    __args__['contactName'] = contact_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['spacecraftName'] = spacecraft_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:orbital:getContact', __args__, opts=opts, typ=GetContactResult).value

    return AwaitableGetContactResult(
        contact_profile=__ret__.contact_profile,
        end_azimuth_degrees=__ret__.end_azimuth_degrees,
        end_elevation_degrees=__ret__.end_elevation_degrees,
        error_message=__ret__.error_message,
        etag=__ret__.etag,
        ground_station_name=__ret__.ground_station_name,
        id=__ret__.id,
        maximum_elevation_degrees=__ret__.maximum_elevation_degrees,
        name=__ret__.name,
        reservation_end_time=__ret__.reservation_end_time,
        reservation_start_time=__ret__.reservation_start_time,
        rx_end_time=__ret__.rx_end_time,
        rx_start_time=__ret__.rx_start_time,
        start_azimuth_degrees=__ret__.start_azimuth_degrees,
        start_elevation_degrees=__ret__.start_elevation_degrees,
        status=__ret__.status,
        system_data=__ret__.system_data,
        tx_end_time=__ret__.tx_end_time,
        tx_start_time=__ret__.tx_start_time,
        type=__ret__.type)


@_utilities.lift_output_func(get_contact)
def get_contact_output(contact_name: Optional[pulumi.Input[str]] = None,
                       resource_group_name: Optional[pulumi.Input[str]] = None,
                       spacecraft_name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetContactResult]:
    """
    Customer creates a contact resource for a spacecraft resource.
    API Version: 2021-04-04-preview.


    :param str contact_name: Contact Name
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str spacecraft_name: Spacecraft ID
    """
    ...
