# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AuthenticationType',
    'BillingSku',
    'CoreNetworkType',
    'ManagedServiceIdentityType',
    'NaptEnabled',
    'PduSessionType',
    'PlatformType',
    'PreemptionCapability',
    'PreemptionVulnerability',
    'SdfDirection',
    'TrafficControlPermission',
]


class AuthenticationType(str, Enum):
    """
    How to authenticate users who access local diagnostics APIs.
    """
    AAD = "AAD"
    """
    Use AAD SSO to authenticate the user (this requires internet access).
    """
    PASSWORD = "Password"
    """
    Use locally stored passwords to authenticate the user.
    """


class BillingSku(str, Enum):
    """
    The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
    """
    G0 = "G0"
    """
    100 Mbps, 20 active SIMs plan, 2 RANs
    """
    G1 = "G1"
    """
    1 Gbps, 100 active SIMs plan, 5 RANs
    """
    G2 = "G2"
    """
    2 Gbps, 200 active SIMs plan, 10 RANs
    """
    G3 = "G3"
    """
    3 Gbps, 300 active SIMs plan
    """
    G4 = "G4"
    """
    4 Gbps, 400 active SIMs plan
    """
    G5 = "G5"
    """
    5 Gbps, 500 active SIMs plan
    """
    G10 = "G10"
    """
    10 Gbps, 1000 active SIMs plan
    """


class CoreNetworkType(str, Enum):
    """
    The core network technology generation (5G core or EPC / 4G core).
    """
    CORE_NETWORK_TYPE_5_GC = "5GC"
    """
    5G core
    """
    EPC = "EPC"
    """
    EPC / 4G core
    """


class ManagedServiceIdentityType(str, Enum):
    """
    Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
    """
    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class NaptEnabled(str, Enum):
    """
    Whether NAPT is enabled for connections to this attached data network.
    """
    ENABLED = "Enabled"
    """
    NAPT is enabled
    """
    DISABLED = "Disabled"
    """
    NAPT is disabled
    """


class PduSessionType(str, Enum):
    """
    The default PDU session type, which is used if the UE does not request a specific session type.
    """
    I_PV4 = "IPv4"
    I_PV6 = "IPv6"


class PlatformType(str, Enum):
    """
    The platform type where packet core is deployed.
    """
    AK_S_HCI = "AKS-HCI"
    """
    If this option is chosen, you must set one of "azureStackEdgeDevice", "connectedCluster" or "customLocation". If multiple are set, they must be consistent with each other.
    """
    PLATFORM_TYPE_3_P_AZUR_E_STAC_K_HCI = "3P-AZURE-STACK-HCI"
    """
    If this option is chosen, you must set one of "azureStackHciCluster", "connectedCluster" or "customLocation". If multiple are set, they must be consistent with each other.
    """


class PreemptionCapability(str, Enum):
    """
    Default QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
    """
    NOT_PREEMPT = "NotPreempt"
    """
    Cannot preempt
    """
    MAY_PREEMPT = "MayPreempt"
    """
    May preempt
    """


class PreemptionVulnerability(str, Enum):
    """
    Default QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
    """
    NOT_PREEMPTABLE = "NotPreemptable"
    """
    Cannot be preempted
    """
    PREEMPTABLE = "Preemptable"
    """
    May be preempted
    """


class SdfDirection(str, Enum):
    """
    The direction of this flow.
    """
    UPLINK = "Uplink"
    """
    Traffic flowing from the UE to the data network.
    """
    DOWNLINK = "Downlink"
    """
    Traffic flowing from the data network to the UE.
    """
    BIDIRECTIONAL = "Bidirectional"
    """
    Traffic flowing both to and from the UE.
    """


class TrafficControlPermission(str, Enum):
    """
    Determines whether flows that match this data flow policy rule are permitted.
    """
    ENABLED = "Enabled"
    """
    Traffic matching this rule is allowed to flow.
    """
    BLOCKED = "Blocked"
    """
    Traffic matching this rule is not allowed to flow.
    """
