# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AmbrResponse',
    'AttachedDataNetworkResourceIdResponse',
    'CustomLocationResourceIdResponse',
    'DataNetworkConfigurationResponse',
    'DataNetworkResourceIdResponse',
    'InterfacePropertiesResponse',
    'MobileNetworkResourceIdResponse',
    'NaptConfigurationResponse',
    'PccRuleConfigurationResponse',
    'PccRuleQosPolicyResponse',
    'PinholeTimeoutsResponse',
    'PlmnIdResponse',
    'PortRangeResponse',
    'PortReuseHoldTimesResponse',
    'QosPolicyResponse',
    'ServiceDataFlowTemplateResponse',
    'ServiceResourceIdResponse',
    'SimPolicyResourceIdResponse',
    'SimStaticIpPropertiesResponse',
    'SimStaticIpPropertiesResponseStaticIp',
    'SliceConfigurationResponse',
    'SliceResourceIdResponse',
    'SnssaiResponse',
    'SubResourceResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class AmbrResponse(dict):
    """
    Aggregate Maximum Bit Rate.
    """
    def __init__(__self__, *,
                 downlink: str,
                 uplink: str):
        """
        Aggregate Maximum Bit Rate.
        :param str downlink: Downlink bit rate.
        :param str uplink: Uplink bit rate.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @property
    @pulumi.getter
    def downlink(self) -> str:
        """
        Downlink bit rate.
        """
        return pulumi.get(self, "downlink")

    @property
    @pulumi.getter
    def uplink(self) -> str:
        """
        Uplink bit rate.
        """
        return pulumi.get(self, "uplink")


@pulumi.output_type
class AttachedDataNetworkResourceIdResponse(dict):
    """
    Reference to an Attached Data Network resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Reference to an Attached Data Network resource.
        :param str id: Attached Data Network resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Attached Data Network resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class CustomLocationResourceIdResponse(dict):
    """
    Reference to an Azure ARC custom location resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Reference to an Azure ARC custom location resource.
        :param str id: Azure ARC custom location resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Azure ARC custom location resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class DataNetworkConfigurationResponse(dict):
    """
    Settings controlling Data Network use
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedServices":
            suggest = "allowed_services"
        elif key == "dataNetwork":
            suggest = "data_network"
        elif key == "sessionAmbr":
            suggest = "session_ambr"
        elif key == "additionalAllowedSessionTypes":
            suggest = "additional_allowed_session_types"
        elif key == "allocationAndRetentionPriorityLevel":
            suggest = "allocation_and_retention_priority_level"
        elif key == "defaultSessionType":
            suggest = "default_session_type"
        elif key == "fiveQi":
            suggest = "five_qi"
        elif key == "preemptionCapability":
            suggest = "preemption_capability"
        elif key == "preemptionVulnerability":
            suggest = "preemption_vulnerability"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataNetworkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataNetworkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataNetworkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_services: Sequence['outputs.ServiceResourceIdResponse'],
                 data_network: 'outputs.DataNetworkResourceIdResponse',
                 session_ambr: 'outputs.AmbrResponse',
                 additional_allowed_session_types: Optional[Sequence[str]] = None,
                 allocation_and_retention_priority_level: Optional[int] = None,
                 default_session_type: Optional[str] = None,
                 five_qi: Optional[int] = None,
                 preemption_capability: Optional[str] = None,
                 preemption_vulnerability: Optional[str] = None):
        """
        Settings controlling Data Network use
        :param Sequence['ServiceResourceIdResponse'] allowed_services: List of Services that can be used as part of this Sim Policy. The list must not contain duplicate items and must contain at least one item.
        :param 'DataNetworkResourceIdResponse' data_network: A reference to the Data Network that these settings apply to
        :param 'AmbrResponse' session_ambr: Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the Session-AMBR.
        :param Sequence[str] additional_allowed_session_types: Allowed session types in addition to the default session type.  Must not duplicate the default session type.
        :param int allocation_and_retention_priority_level: Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param str default_session_type: The default PDU session type, which is used if the UE does not request a specific session type.
        :param int five_qi: Default QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        :param str preemption_capability: Default QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param str preemption_vulnerability: Default QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        pulumi.set(__self__, "allowed_services", allowed_services)
        pulumi.set(__self__, "data_network", data_network)
        pulumi.set(__self__, "session_ambr", session_ambr)
        if additional_allowed_session_types is not None:
            pulumi.set(__self__, "additional_allowed_session_types", additional_allowed_session_types)
        if allocation_and_retention_priority_level is None:
            allocation_and_retention_priority_level = 9
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if default_session_type is None:
            default_session_type = 'IPv4'
        if default_session_type is not None:
            pulumi.set(__self__, "default_session_type", default_session_type)
        if five_qi is None:
            five_qi = 9
        if five_qi is not None:
            pulumi.set(__self__, "five_qi", five_qi)
        if preemption_capability is None:
            preemption_capability = 'NotPreempt'
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is None:
            preemption_vulnerability = 'Preemptable'
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)

    @property
    @pulumi.getter(name="allowedServices")
    def allowed_services(self) -> Sequence['outputs.ServiceResourceIdResponse']:
        """
        List of Services that can be used as part of this Sim Policy. The list must not contain duplicate items and must contain at least one item.
        """
        return pulumi.get(self, "allowed_services")

    @property
    @pulumi.getter(name="dataNetwork")
    def data_network(self) -> 'outputs.DataNetworkResourceIdResponse':
        """
        A reference to the Data Network that these settings apply to
        """
        return pulumi.get(self, "data_network")

    @property
    @pulumi.getter(name="sessionAmbr")
    def session_ambr(self) -> 'outputs.AmbrResponse':
        """
        Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the Session-AMBR.
        """
        return pulumi.get(self, "session_ambr")

    @property
    @pulumi.getter(name="additionalAllowedSessionTypes")
    def additional_allowed_session_types(self) -> Optional[Sequence[str]]:
        """
        Allowed session types in addition to the default session type.  Must not duplicate the default session type.
        """
        return pulumi.get(self, "additional_allowed_session_types")

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[int]:
        """
        Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @property
    @pulumi.getter(name="defaultSessionType")
    def default_session_type(self) -> Optional[str]:
        """
        The default PDU session type, which is used if the UE does not request a specific session type.
        """
        return pulumi.get(self, "default_session_type")

    @property
    @pulumi.getter(name="fiveQi")
    def five_qi(self) -> Optional[int]:
        """
        Default QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        """
        return pulumi.get(self, "five_qi")

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[str]:
        """
        Default QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_capability")

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[str]:
        """
        Default QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_vulnerability")


@pulumi.output_type
class DataNetworkResourceIdResponse(dict):
    """
    Reference to a Data Network resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Reference to a Data Network resource.
        :param str id: Data Network resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Data Network resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class InterfacePropertiesResponse(dict):
    """
    Interface properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Address":
            suggest = "ipv4_address"
        elif key == "ipv4Gateway":
            suggest = "ipv4_gateway"
        elif key == "ipv4Subnet":
            suggest = "ipv4_subnet"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InterfacePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InterfacePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InterfacePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 ipv4_address: Optional[str] = None,
                 ipv4_gateway: Optional[str] = None,
                 ipv4_subnet: Optional[str] = None):
        """
        Interface properties
        :param str name: The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge machine.
        :param str ipv4_address: The IPv4 address.
        :param str ipv4_gateway: The default IPv4 gateway (router).
        :param str ipv4_subnet: The IPv4 subnet.
        """
        pulumi.set(__self__, "name", name)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_gateway is not None:
            pulumi.set(__self__, "ipv4_gateway", ipv4_gateway)
        if ipv4_subnet is not None:
            pulumi.set(__self__, "ipv4_subnet", ipv4_subnet)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge machine.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[str]:
        """
        The IPv4 address.
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv4Gateway")
    def ipv4_gateway(self) -> Optional[str]:
        """
        The default IPv4 gateway (router).
        """
        return pulumi.get(self, "ipv4_gateway")

    @property
    @pulumi.getter(name="ipv4Subnet")
    def ipv4_subnet(self) -> Optional[str]:
        """
        The IPv4 subnet.
        """
        return pulumi.get(self, "ipv4_subnet")


@pulumi.output_type
class MobileNetworkResourceIdResponse(dict):
    """
    Reference to a Mobile Network resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Reference to a Mobile Network resource.
        :param str id: Mobile Network resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Mobile Network resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class NaptConfigurationResponse(dict):
    """
    The Network Address and Port Translation settings to use for the attached data network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pinholeLimits":
            suggest = "pinhole_limits"
        elif key == "pinholeTimeouts":
            suggest = "pinhole_timeouts"
        elif key == "portRange":
            suggest = "port_range"
        elif key == "portReuseHoldTime":
            suggest = "port_reuse_hold_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NaptConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NaptConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NaptConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[str] = None,
                 pinhole_limits: Optional[int] = None,
                 pinhole_timeouts: Optional['outputs.PinholeTimeoutsResponse'] = None,
                 port_range: Optional['outputs.PortRangeResponse'] = None,
                 port_reuse_hold_time: Optional['outputs.PortReuseHoldTimesResponse'] = None):
        """
        The Network Address and Port Translation settings to use for the attached data network.
        :param str enabled: Whether NAPT is enabled for connections to this attachedDataNetwork.
        :param int pinhole_limits: Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface.
        :param 'PinholeTimeoutsResponse' pinhole_timeouts: Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
        :param 'PortRangeResponse' port_range: Range of port numbers to use as translated ports on each translated address.
               If not specified and NAPT is enabled, this range defaults to 1,024 - 65,535. (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA.)
        :param 'PortReuseHoldTimesResponse' port_reuse_hold_time: The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be minimum 1 second.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if pinhole_limits is None:
            pinhole_limits = 65536
        if pinhole_limits is not None:
            pulumi.set(__self__, "pinhole_limits", pinhole_limits)
        if pinhole_timeouts is not None:
            pulumi.set(__self__, "pinhole_timeouts", pinhole_timeouts)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if port_reuse_hold_time is not None:
            pulumi.set(__self__, "port_reuse_hold_time", port_reuse_hold_time)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[str]:
        """
        Whether NAPT is enabled for connections to this attachedDataNetwork.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="pinholeLimits")
    def pinhole_limits(self) -> Optional[int]:
        """
        Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface.
        """
        return pulumi.get(self, "pinhole_limits")

    @property
    @pulumi.getter(name="pinholeTimeouts")
    def pinhole_timeouts(self) -> Optional['outputs.PinholeTimeoutsResponse']:
        """
        Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
        """
        return pulumi.get(self, "pinhole_timeouts")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional['outputs.PortRangeResponse']:
        """
        Range of port numbers to use as translated ports on each translated address.
        If not specified and NAPT is enabled, this range defaults to 1,024 - 65,535. (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA.)
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter(name="portReuseHoldTime")
    def port_reuse_hold_time(self) -> Optional['outputs.PortReuseHoldTimesResponse']:
        """
        The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be minimum 1 second.
        """
        return pulumi.get(self, "port_reuse_hold_time")


@pulumi.output_type
class PccRuleConfigurationResponse(dict):
    """
    PCC rule configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleName":
            suggest = "rule_name"
        elif key == "rulePrecedence":
            suggest = "rule_precedence"
        elif key == "serviceDataFlowTemplates":
            suggest = "service_data_flow_templates"
        elif key == "ruleQosPolicy":
            suggest = "rule_qos_policy"
        elif key == "trafficControl":
            suggest = "traffic_control"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PccRuleConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PccRuleConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PccRuleConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_name: str,
                 rule_precedence: int,
                 service_data_flow_templates: Sequence['outputs.ServiceDataFlowTemplateResponse'],
                 rule_qos_policy: Optional['outputs.PccRuleQosPolicyResponse'] = None,
                 traffic_control: Optional[str] = None):
        """
        PCC rule configuration
        :param str rule_name: The name of the rule. This must be unique within the parent Service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        :param int rule_precedence: A precedence value that is used to decide between PCC Rules when identifying the QoS values to use for a particular Sim. A lower value means a higher priority. This value should be unique among all PCC Rules configured in the Mobile Network.
        :param Sequence['ServiceDataFlowTemplateResponse'] service_data_flow_templates: The set of service data flow templates to use for this PCC Rule.
        :param 'PccRuleQosPolicyResponse' rule_qos_policy: The QoS policy to use for packets matching this rule. If this field is null then the Service will define the QoS settings.
        :param str traffic_control: Determines whether flows that match this PCC Rule are permitted.
        """
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "rule_precedence", rule_precedence)
        pulumi.set(__self__, "service_data_flow_templates", service_data_flow_templates)
        if rule_qos_policy is not None:
            pulumi.set(__self__, "rule_qos_policy", rule_qos_policy)
        if traffic_control is None:
            traffic_control = 'Enabled'
        if traffic_control is not None:
            pulumi.set(__self__, "traffic_control", traffic_control)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> str:
        """
        The name of the rule. This must be unique within the parent Service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="rulePrecedence")
    def rule_precedence(self) -> int:
        """
        A precedence value that is used to decide between PCC Rules when identifying the QoS values to use for a particular Sim. A lower value means a higher priority. This value should be unique among all PCC Rules configured in the Mobile Network.
        """
        return pulumi.get(self, "rule_precedence")

    @property
    @pulumi.getter(name="serviceDataFlowTemplates")
    def service_data_flow_templates(self) -> Sequence['outputs.ServiceDataFlowTemplateResponse']:
        """
        The set of service data flow templates to use for this PCC Rule.
        """
        return pulumi.get(self, "service_data_flow_templates")

    @property
    @pulumi.getter(name="ruleQosPolicy")
    def rule_qos_policy(self) -> Optional['outputs.PccRuleQosPolicyResponse']:
        """
        The QoS policy to use for packets matching this rule. If this field is null then the Service will define the QoS settings.
        """
        return pulumi.get(self, "rule_qos_policy")

    @property
    @pulumi.getter(name="trafficControl")
    def traffic_control(self) -> Optional[str]:
        """
        Determines whether flows that match this PCC Rule are permitted.
        """
        return pulumi.get(self, "traffic_control")


@pulumi.output_type
class PccRuleQosPolicyResponse(dict):
    """
    PCC rule QoS policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumBitRate":
            suggest = "maximum_bit_rate"
        elif key == "allocationAndRetentionPriorityLevel":
            suggest = "allocation_and_retention_priority_level"
        elif key == "fiveQi":
            suggest = "five_qi"
        elif key == "guaranteedBitRate":
            suggest = "guaranteed_bit_rate"
        elif key == "preemptionCapability":
            suggest = "preemption_capability"
        elif key == "preemptionVulnerability":
            suggest = "preemption_vulnerability"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PccRuleQosPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PccRuleQosPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PccRuleQosPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_bit_rate: 'outputs.AmbrResponse',
                 allocation_and_retention_priority_level: Optional[int] = None,
                 five_qi: Optional[int] = None,
                 guaranteed_bit_rate: Optional['outputs.AmbrResponse'] = None,
                 preemption_capability: Optional[str] = None,
                 preemption_vulnerability: Optional[str] = None):
        """
        PCC rule QoS policy
        :param 'AmbrResponse' maximum_bit_rate: The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        :param int allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param int five_qi: QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        :param 'AmbrResponse' guaranteed_bit_rate: The Guaranteed Bit Rate (GBR) for all service data flows that use this PCC Rule. This is an optional setting. If you do not provide a value, there will be no GBR set for the PCC Rule that uses this QoS definition.
        :param str preemption_capability: QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param str preemption_vulnerability: QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        pulumi.set(__self__, "maximum_bit_rate", maximum_bit_rate)
        if allocation_and_retention_priority_level is None:
            allocation_and_retention_priority_level = 9
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if five_qi is None:
            five_qi = 9
        if five_qi is not None:
            pulumi.set(__self__, "five_qi", five_qi)
        if guaranteed_bit_rate is not None:
            pulumi.set(__self__, "guaranteed_bit_rate", guaranteed_bit_rate)
        if preemption_capability is None:
            preemption_capability = 'NotPreempt'
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is None:
            preemption_vulnerability = 'Preemptable'
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)

    @property
    @pulumi.getter(name="maximumBitRate")
    def maximum_bit_rate(self) -> 'outputs.AmbrResponse':
        """
        The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        return pulumi.get(self, "maximum_bit_rate")

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[int]:
        """
        QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @property
    @pulumi.getter(name="fiveQi")
    def five_qi(self) -> Optional[int]:
        """
        QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        """
        return pulumi.get(self, "five_qi")

    @property
    @pulumi.getter(name="guaranteedBitRate")
    def guaranteed_bit_rate(self) -> Optional['outputs.AmbrResponse']:
        """
        The Guaranteed Bit Rate (GBR) for all service data flows that use this PCC Rule. This is an optional setting. If you do not provide a value, there will be no GBR set for the PCC Rule that uses this QoS definition.
        """
        return pulumi.get(self, "guaranteed_bit_rate")

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[str]:
        """
        QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_capability")

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[str]:
        """
        QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_vulnerability")


@pulumi.output_type
class PinholeTimeoutsResponse(dict):
    """
    Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
    """
    def __init__(__self__, *,
                 icmp: Optional[int] = None,
                 tcp: Optional[int] = None,
                 udp: Optional[int] = None):
        """
        Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
        :param int icmp: Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 60 seconds per RFC 5508 section 3.2.
        :param int tcp: Pinhole timeout for TCP pinholes in seconds. Default for TCP is 2 hours 4 minutes per RFC 5382 section 5.
        :param int udp: Pinhole timeout for UDP pinholes in seconds. Default for UDP is 5 minutes per RFC 4787 section 4.3.
        """
        if icmp is None:
            icmp = 60
        if icmp is not None:
            pulumi.set(__self__, "icmp", icmp)
        if tcp is None:
            tcp = 7440
        if tcp is not None:
            pulumi.set(__self__, "tcp", tcp)
        if udp is None:
            udp = 300
        if udp is not None:
            pulumi.set(__self__, "udp", udp)

    @property
    @pulumi.getter
    def icmp(self) -> Optional[int]:
        """
        Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 60 seconds per RFC 5508 section 3.2.
        """
        return pulumi.get(self, "icmp")

    @property
    @pulumi.getter
    def tcp(self) -> Optional[int]:
        """
        Pinhole timeout for TCP pinholes in seconds. Default for TCP is 2 hours 4 minutes per RFC 5382 section 5.
        """
        return pulumi.get(self, "tcp")

    @property
    @pulumi.getter
    def udp(self) -> Optional[int]:
        """
        Pinhole timeout for UDP pinholes in seconds. Default for UDP is 5 minutes per RFC 4787 section 4.3.
        """
        return pulumi.get(self, "udp")


@pulumi.output_type
class PlmnIdResponse(dict):
    """
    Public Land Mobile Network (PLMN) ID.
    """
    def __init__(__self__, *,
                 mcc: str,
                 mnc: str):
        """
        Public Land Mobile Network (PLMN) ID.
        :param str mcc: Mobile Country Code (MCC).
        :param str mnc: Mobile Network Code (MNC).
        """
        pulumi.set(__self__, "mcc", mcc)
        pulumi.set(__self__, "mnc", mnc)

    @property
    @pulumi.getter
    def mcc(self) -> str:
        """
        Mobile Country Code (MCC).
        """
        return pulumi.get(self, "mcc")

    @property
    @pulumi.getter
    def mnc(self) -> str:
        """
        Mobile Network Code (MNC).
        """
        return pulumi.get(self, "mnc")


@pulumi.output_type
class PortRangeResponse(dict):
    """
    Range of port numbers to use as translated ports on each translated address.
    If not specified and NAPT is enabled, this range defaults to 1,024 - 65,535. (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA.)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPort":
            suggest = "max_port"
        elif key == "minPort":
            suggest = "min_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PortRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PortRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PortRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_port: Optional[int] = None,
                 min_port: Optional[int] = None):
        """
        Range of port numbers to use as translated ports on each translated address.
        If not specified and NAPT is enabled, this range defaults to 1,024 - 65,535. (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA.)
        :param int max_port: The maximum port number
        :param int min_port: The minimum port number
        """
        if max_port is None:
            max_port = 65535
        if max_port is not None:
            pulumi.set(__self__, "max_port", max_port)
        if min_port is None:
            min_port = 1024
        if min_port is not None:
            pulumi.set(__self__, "min_port", min_port)

    @property
    @pulumi.getter(name="maxPort")
    def max_port(self) -> Optional[int]:
        """
        The maximum port number
        """
        return pulumi.get(self, "max_port")

    @property
    @pulumi.getter(name="minPort")
    def min_port(self) -> Optional[int]:
        """
        The minimum port number
        """
        return pulumi.get(self, "min_port")


@pulumi.output_type
class PortReuseHoldTimesResponse(dict):
    """
    The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be minimum 1 second.
    """
    def __init__(__self__, *,
                 tcp: Optional[int] = None,
                 udp: Optional[int] = None):
        """
        The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be minimum 1 second.
        :param int tcp: Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP is 2 minutes.
        :param int udp: Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP is 1 minute.
        """
        if tcp is None:
            tcp = 120
        if tcp is not None:
            pulumi.set(__self__, "tcp", tcp)
        if udp is None:
            udp = 60
        if udp is not None:
            pulumi.set(__self__, "udp", udp)

    @property
    @pulumi.getter
    def tcp(self) -> Optional[int]:
        """
        Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP is 2 minutes.
        """
        return pulumi.get(self, "tcp")

    @property
    @pulumi.getter
    def udp(self) -> Optional[int]:
        """
        Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP is 1 minute.
        """
        return pulumi.get(self, "udp")


@pulumi.output_type
class QosPolicyResponse(dict):
    """
    QoS policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumBitRate":
            suggest = "maximum_bit_rate"
        elif key == "allocationAndRetentionPriorityLevel":
            suggest = "allocation_and_retention_priority_level"
        elif key == "fiveQi":
            suggest = "five_qi"
        elif key == "preemptionCapability":
            suggest = "preemption_capability"
        elif key == "preemptionVulnerability":
            suggest = "preemption_vulnerability"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QosPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QosPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QosPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_bit_rate: 'outputs.AmbrResponse',
                 allocation_and_retention_priority_level: Optional[int] = None,
                 five_qi: Optional[int] = None,
                 preemption_capability: Optional[str] = None,
                 preemption_vulnerability: Optional[str] = None):
        """
        QoS policy
        :param 'AmbrResponse' maximum_bit_rate: The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        :param int allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param int five_qi: QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        :param str preemption_capability: QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param str preemption_vulnerability: QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        pulumi.set(__self__, "maximum_bit_rate", maximum_bit_rate)
        if allocation_and_retention_priority_level is None:
            allocation_and_retention_priority_level = 9
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if five_qi is None:
            five_qi = 9
        if five_qi is not None:
            pulumi.set(__self__, "five_qi", five_qi)
        if preemption_capability is None:
            preemption_capability = 'NotPreempt'
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is None:
            preemption_vulnerability = 'Preemptable'
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)

    @property
    @pulumi.getter(name="maximumBitRate")
    def maximum_bit_rate(self) -> 'outputs.AmbrResponse':
        """
        The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        return pulumi.get(self, "maximum_bit_rate")

    @property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[int]:
        """
        QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @property
    @pulumi.getter(name="fiveQi")
    def five_qi(self) -> Optional[int]:
        """
        QoS Flow 5G QoS Indicator value.  The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. This must not be a standardized 5QI value selecting a GBR (Guaranteed Bit Rate) QoS.  The illegal GBR 5QI values are: 1, 2, 3, 4, 65, 66, 67, 71, 72, 73, 74, 75, 76, 82, 83, 84, and 85. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5Qi parameter, and table 5.7.4-1 for the definition of which are the GBR 5QI values.
        """
        return pulumi.get(self, "five_qi")

    @property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[str]:
        """
        QoS Flow preemption capability.  The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_capability")

    @property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[str]:
        """
        QoS Flow preemption vulnerability.  The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "preemption_vulnerability")


@pulumi.output_type
class ServiceDataFlowTemplateResponse(dict):
    """
    Service data flow (SDF) template
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "remoteIpList":
            suggest = "remote_ip_list"
        elif key == "templateName":
            suggest = "template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDataFlowTemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDataFlowTemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDataFlowTemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 direction: str,
                 protocol: Sequence[str],
                 remote_ip_list: Sequence[str],
                 template_name: str,
                 ports: Optional[Sequence[str]] = None):
        """
        Service data flow (SDF) template
        :param str direction: The direction of this flow.
        :param Sequence[str] protocol: A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
        :param Sequence[str] remote_ip_list: The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which Fusion Core will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, 192.0.2.54/24).
        :param str template_name: The name of the SDF template. This must be unique within the parent PccRuleConfiguration. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        :param Sequence[str] ports: The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. This is an optional setting. If you do not specify it then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "remote_ip_list", remote_ip_list)
        pulumi.set(__self__, "template_name", template_name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        The direction of this flow.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def protocol(self) -> Sequence[str]:
        """
        A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="remoteIpList")
    def remote_ip_list(self) -> Sequence[str]:
        """
        The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which Fusion Core will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, 192.0.2.54/24).
        """
        return pulumi.get(self, "remote_ip_list")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> str:
        """
        The name of the SDF template. This must be unique within the parent PccRuleConfiguration. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        """
        return pulumi.get(self, "template_name")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence[str]]:
        """
        The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. This is an optional setting. If you do not specify it then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class ServiceResourceIdResponse(dict):
    """
    Reference to a Service resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Reference to a Service resource.
        :param str id: Service resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Service resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SimPolicyResourceIdResponse(dict):
    """
    Reference to a SIM Policy resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Reference to a SIM Policy resource.
        :param str id: SIM Policy resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        SIM Policy resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SimStaticIpPropertiesResponse(dict):
    """
    Static IP configuration for a sim, scoped to a particular attached data network and slice.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attachedDataNetwork":
            suggest = "attached_data_network"
        elif key == "staticIp":
            suggest = "static_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SimStaticIpPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SimStaticIpPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SimStaticIpPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attached_data_network: Optional['outputs.AttachedDataNetworkResourceIdResponse'] = None,
                 slice: Optional['outputs.SliceResourceIdResponse'] = None,
                 static_ip: Optional['outputs.SimStaticIpPropertiesResponseStaticIp'] = None):
        """
        Static IP configuration for a sim, scoped to a particular attached data network and slice.
        :param 'AttachedDataNetworkResourceIdResponse' attached_data_network: The attached data network on which the static IP address will be used. The combination of attachedDataNetwork and slice defines the network scope of the IP address.
        :param 'SliceResourceIdResponse' slice: The network slice on which the static IP address will be used. The combination of attachedDataNetwork and slice defines the network scope of the IP address.
        :param 'SimStaticIpPropertiesResponseStaticIp' static_ip: The static IP configuration for the sim to use at the defined network scope.
        """
        if attached_data_network is not None:
            pulumi.set(__self__, "attached_data_network", attached_data_network)
        if slice is not None:
            pulumi.set(__self__, "slice", slice)
        if static_ip is not None:
            pulumi.set(__self__, "static_ip", static_ip)

    @property
    @pulumi.getter(name="attachedDataNetwork")
    def attached_data_network(self) -> Optional['outputs.AttachedDataNetworkResourceIdResponse']:
        """
        The attached data network on which the static IP address will be used. The combination of attachedDataNetwork and slice defines the network scope of the IP address.
        """
        return pulumi.get(self, "attached_data_network")

    @property
    @pulumi.getter
    def slice(self) -> Optional['outputs.SliceResourceIdResponse']:
        """
        The network slice on which the static IP address will be used. The combination of attachedDataNetwork and slice defines the network scope of the IP address.
        """
        return pulumi.get(self, "slice")

    @property
    @pulumi.getter(name="staticIp")
    def static_ip(self) -> Optional['outputs.SimStaticIpPropertiesResponseStaticIp']:
        """
        The static IP configuration for the sim to use at the defined network scope.
        """
        return pulumi.get(self, "static_ip")


@pulumi.output_type
class SimStaticIpPropertiesResponseStaticIp(dict):
    """
    The static IP configuration for the sim to use at the defined network scope.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Address":
            suggest = "ipv4_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SimStaticIpPropertiesResponseStaticIp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SimStaticIpPropertiesResponseStaticIp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SimStaticIpPropertiesResponseStaticIp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4_address: Optional[str] = None):
        """
        The static IP configuration for the sim to use at the defined network scope.
        :param str ipv4_address: The IPv4 address assigned to the sim at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attachedDataNetwork.
        """
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[str]:
        """
        The IPv4 address assigned to the sim at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attachedDataNetwork.
        """
        return pulumi.get(self, "ipv4_address")


@pulumi.output_type
class SliceConfigurationResponse(dict):
    """
    Per-slice settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataNetworkConfigurations":
            suggest = "data_network_configurations"
        elif key == "defaultDataNetwork":
            suggest = "default_data_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SliceConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SliceConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SliceConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_network_configurations: Sequence['outputs.DataNetworkConfigurationResponse'],
                 default_data_network: 'outputs.DataNetworkResourceIdResponse',
                 slice: 'outputs.SliceResourceIdResponse'):
        """
        Per-slice settings
        :param Sequence['DataNetworkConfigurationResponse'] data_network_configurations: The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
        :param 'DataNetworkResourceIdResponse' default_data_network: The default data network to use if the UE does not explicitly specify it.  Configuration for this object must exist in the `dataNetworkConfigurations` map.
        :param 'SliceResourceIdResponse' slice: A reference to the Slice that these settings apply to
        """
        pulumi.set(__self__, "data_network_configurations", data_network_configurations)
        pulumi.set(__self__, "default_data_network", default_data_network)
        pulumi.set(__self__, "slice", slice)

    @property
    @pulumi.getter(name="dataNetworkConfigurations")
    def data_network_configurations(self) -> Sequence['outputs.DataNetworkConfigurationResponse']:
        """
        The allowed data networks and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
        """
        return pulumi.get(self, "data_network_configurations")

    @property
    @pulumi.getter(name="defaultDataNetwork")
    def default_data_network(self) -> 'outputs.DataNetworkResourceIdResponse':
        """
        The default data network to use if the UE does not explicitly specify it.  Configuration for this object must exist in the `dataNetworkConfigurations` map.
        """
        return pulumi.get(self, "default_data_network")

    @property
    @pulumi.getter
    def slice(self) -> 'outputs.SliceResourceIdResponse':
        """
        A reference to the Slice that these settings apply to
        """
        return pulumi.get(self, "slice")


@pulumi.output_type
class SliceResourceIdResponse(dict):
    """
    Reference to a Slice resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Reference to a Slice resource.
        :param str id: Slice resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Slice resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SnssaiResponse(dict):
    """
    Single-Network Slice Selection Assistance Information (S-NSSAI).
    """
    def __init__(__self__, *,
                 sst: int,
                 sd: Optional[str] = None):
        """
        Single-Network Slice Selection Assistance Information (S-NSSAI).
        :param int sst: Slice/Service Type (SST).
        :param str sd: Slice Differentiator (SD).
        """
        pulumi.set(__self__, "sst", sst)
        if sd is not None:
            pulumi.set(__self__, "sd", sd)

    @property
    @pulumi.getter
    def sst(self) -> int:
        """
        Slice/Service Type (SST).
        """
        return pulumi.get(self, "sst")

    @property
    @pulumi.getter
    def sd(self) -> Optional[str]:
        """
        Slice Differentiator (SD).
        """
        return pulumi.get(self, "sd")


@pulumi.output_type
class SubResourceResponse(dict):
    """
    Reference to another sub resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Reference to another sub resource.
        :param str id: Resource ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


