# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetTemplateSpecVersionResult',
    'AwaitableGetTemplateSpecVersionResult',
    'get_template_spec_version',
    'get_template_spec_version_output',
]

@pulumi.output_type
class GetTemplateSpecVersionResult:
    """
    Template Spec Version object.
    """
    def __init__(__self__, artifacts=None, description=None, id=None, location=None, name=None, system_data=None, tags=None, template=None, type=None):
        if artifacts and not isinstance(artifacts, list):
            raise TypeError("Expected argument 'artifacts' to be a list")
        pulumi.set(__self__, "artifacts", artifacts)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if template and not isinstance(template, dict):
            raise TypeError("Expected argument 'template' to be a dict")
        pulumi.set(__self__, "template", template)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[Sequence['outputs.TemplateSpecTemplateArtifactResponse']]:
        """
        An array of Template Spec artifacts.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Template Spec version description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        String Id used to locate any resource on Azure.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location of the Template Spec Version. It must match the location of the parent Template Spec.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def template(self) -> Optional[Any]:
        """
        The Azure Resource Manager template content.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of this resource.
        """
        return pulumi.get(self, "type")


class AwaitableGetTemplateSpecVersionResult(GetTemplateSpecVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTemplateSpecVersionResult(
            artifacts=self.artifacts,
            description=self.description,
            id=self.id,
            location=self.location,
            name=self.name,
            system_data=self.system_data,
            tags=self.tags,
            template=self.template,
            type=self.type)


def get_template_spec_version(resource_group_name: Optional[str] = None,
                              template_spec_name: Optional[str] = None,
                              template_spec_version: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTemplateSpecVersionResult:
    """
    Template Spec Version object.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str template_spec_name: Name of the Template Spec.
    :param str template_spec_version: The version of the Template Spec.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['templateSpecName'] = template_spec_name
    __args__['templateSpecVersion'] = template_spec_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:resources/v20190601preview:getTemplateSpecVersion', __args__, opts=opts, typ=GetTemplateSpecVersionResult).value

    return AwaitableGetTemplateSpecVersionResult(
        artifacts=__ret__.artifacts,
        description=__ret__.description,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        template=__ret__.template,
        type=__ret__.type)


@_utilities.lift_output_func(get_template_spec_version)
def get_template_spec_version_output(resource_group_name: Optional[pulumi.Input[str]] = None,
                                     template_spec_name: Optional[pulumi.Input[str]] = None,
                                     template_spec_version: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTemplateSpecVersionResult]:
    """
    Template Spec Version object.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str template_spec_name: Name of the Template Spec.
    :param str template_spec_version: The version of the Template Spec.
    """
    ...
