# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['MachineArgs', 'Machine']

@pulumi.input_type
class MachineArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 client_public_key: Optional[pulumi.Input[str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['MachineExtensionInstanceViewArgs']]]] = None,
                 identity: Optional[pulumi.Input['IdentityArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 location_data: Optional[pulumi.Input['LocationDataArgs']] = None,
                 machine_name: Optional[pulumi.Input[str]] = None,
                 mssql_discovered: Optional[pulumi.Input[str]] = None,
                 os_profile: Optional[pulumi.Input['OSProfileArgs']] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 parent_cluster_resource_id: Optional[pulumi.Input[str]] = None,
                 private_link_scope_resource_id: Optional[pulumi.Input[str]] = None,
                 service_statuses: Optional[pulumi.Input['ServiceStatusesArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vm_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Machine resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] client_public_key: Public Key that the client provides to be used during initial resource onboarding
        :param pulumi.Input[Sequence[pulumi.Input['MachineExtensionInstanceViewArgs']]] extensions: Machine Extensions information (deprecated field)
        :param pulumi.Input['IdentityArgs'] identity: Identity for the resource.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input['LocationDataArgs'] location_data: Metadata pertaining to the geographic location of the resource.
        :param pulumi.Input[str] machine_name: The name of the hybrid machine.
        :param pulumi.Input[str] mssql_discovered: Specifies whether any MS SQL instance is discovered on the machine.
        :param pulumi.Input['OSProfileArgs'] os_profile: Specifies the operating system settings for the hybrid machine.
        :param pulumi.Input[str] os_type: The type of Operating System (windows/linux).
        :param pulumi.Input[str] parent_cluster_resource_id: The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
        :param pulumi.Input[str] private_link_scope_resource_id: The resource id of the private link scope this machine is assigned to, if any.
        :param pulumi.Input['ServiceStatusesArgs'] service_statuses: Statuses of dependent services that are reported back to ARM.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] vm_id: Specifies the hybrid machine unique ID.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if client_public_key is not None:
            pulumi.set(__self__, "client_public_key", client_public_key)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if location_data is not None:
            pulumi.set(__self__, "location_data", location_data)
        if machine_name is not None:
            pulumi.set(__self__, "machine_name", machine_name)
        if mssql_discovered is not None:
            pulumi.set(__self__, "mssql_discovered", mssql_discovered)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if parent_cluster_resource_id is not None:
            pulumi.set(__self__, "parent_cluster_resource_id", parent_cluster_resource_id)
        if private_link_scope_resource_id is not None:
            pulumi.set(__self__, "private_link_scope_resource_id", private_link_scope_resource_id)
        if service_statuses is not None:
            pulumi.set(__self__, "service_statuses", service_statuses)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="clientPublicKey")
    def client_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Public Key that the client provides to be used during initial resource onboarding
        """
        return pulumi.get(self, "client_public_key")

    @client_public_key.setter
    def client_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_public_key", value)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MachineExtensionInstanceViewArgs']]]]:
        """
        Machine Extensions information (deprecated field)
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MachineExtensionInstanceViewArgs']]]]):
        pulumi.set(self, "extensions", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['IdentityArgs']]:
        """
        Identity for the resource.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['IdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="locationData")
    def location_data(self) -> Optional[pulumi.Input['LocationDataArgs']]:
        """
        Metadata pertaining to the geographic location of the resource.
        """
        return pulumi.get(self, "location_data")

    @location_data.setter
    def location_data(self, value: Optional[pulumi.Input['LocationDataArgs']]):
        pulumi.set(self, "location_data", value)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the hybrid machine.
        """
        return pulumi.get(self, "machine_name")

    @machine_name.setter
    def machine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_name", value)

    @property
    @pulumi.getter(name="mssqlDiscovered")
    def mssql_discovered(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether any MS SQL instance is discovered on the machine.
        """
        return pulumi.get(self, "mssql_discovered")

    @mssql_discovered.setter
    def mssql_discovered(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mssql_discovered", value)

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional[pulumi.Input['OSProfileArgs']]:
        """
        Specifies the operating system settings for the hybrid machine.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: Optional[pulumi.Input['OSProfileArgs']]):
        pulumi.set(self, "os_profile", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Operating System (windows/linux).
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="parentClusterResourceId")
    def parent_cluster_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
        """
        return pulumi.get(self, "parent_cluster_resource_id")

    @parent_cluster_resource_id.setter
    def parent_cluster_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_cluster_resource_id", value)

    @property
    @pulumi.getter(name="privateLinkScopeResourceId")
    def private_link_scope_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the private link scope this machine is assigned to, if any.
        """
        return pulumi.get(self, "private_link_scope_resource_id")

    @private_link_scope_resource_id.setter
    def private_link_scope_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_scope_resource_id", value)

    @property
    @pulumi.getter(name="serviceStatuses")
    def service_statuses(self) -> Optional[pulumi.Input['ServiceStatusesArgs']]:
        """
        Statuses of dependent services that are reported back to ARM.
        """
        return pulumi.get(self, "service_statuses")

    @service_statuses.setter
    def service_statuses(self, value: Optional[pulumi.Input['ServiceStatusesArgs']]):
        pulumi.set(self, "service_statuses", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the hybrid machine unique ID.
        """
        return pulumi.get(self, "vm_id")

    @vm_id.setter
    def vm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_id", value)


class Machine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_public_key: Optional[pulumi.Input[str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MachineExtensionInstanceViewArgs']]]]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['IdentityArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 location_data: Optional[pulumi.Input[pulumi.InputType['LocationDataArgs']]] = None,
                 machine_name: Optional[pulumi.Input[str]] = None,
                 mssql_discovered: Optional[pulumi.Input[str]] = None,
                 os_profile: Optional[pulumi.Input[pulumi.InputType['OSProfileArgs']]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 parent_cluster_resource_id: Optional[pulumi.Input[str]] = None,
                 private_link_scope_resource_id: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 service_statuses: Optional[pulumi.Input[pulumi.InputType['ServiceStatusesArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vm_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Describes a hybrid machine.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_public_key: Public Key that the client provides to be used during initial resource onboarding
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MachineExtensionInstanceViewArgs']]]] extensions: Machine Extensions information (deprecated field)
        :param pulumi.Input[pulumi.InputType['IdentityArgs']] identity: Identity for the resource.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[pulumi.InputType['LocationDataArgs']] location_data: Metadata pertaining to the geographic location of the resource.
        :param pulumi.Input[str] machine_name: The name of the hybrid machine.
        :param pulumi.Input[str] mssql_discovered: Specifies whether any MS SQL instance is discovered on the machine.
        :param pulumi.Input[pulumi.InputType['OSProfileArgs']] os_profile: Specifies the operating system settings for the hybrid machine.
        :param pulumi.Input[str] os_type: The type of Operating System (windows/linux).
        :param pulumi.Input[str] parent_cluster_resource_id: The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
        :param pulumi.Input[str] private_link_scope_resource_id: The resource id of the private link scope this machine is assigned to, if any.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[pulumi.InputType['ServiceStatusesArgs']] service_statuses: Statuses of dependent services that are reported back to ARM.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] vm_id: Specifies the hybrid machine unique ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Describes a hybrid machine.

        :param str resource_name: The name of the resource.
        :param MachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_public_key: Optional[pulumi.Input[str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MachineExtensionInstanceViewArgs']]]]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['IdentityArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 location_data: Optional[pulumi.Input[pulumi.InputType['LocationDataArgs']]] = None,
                 machine_name: Optional[pulumi.Input[str]] = None,
                 mssql_discovered: Optional[pulumi.Input[str]] = None,
                 os_profile: Optional[pulumi.Input[pulumi.InputType['OSProfileArgs']]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 parent_cluster_resource_id: Optional[pulumi.Input[str]] = None,
                 private_link_scope_resource_id: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 service_statuses: Optional[pulumi.Input[pulumi.InputType['ServiceStatusesArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vm_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MachineArgs.__new__(MachineArgs)

            __props__.__dict__["client_public_key"] = client_public_key
            __props__.__dict__["extensions"] = extensions
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["location_data"] = location_data
            __props__.__dict__["machine_name"] = machine_name
            __props__.__dict__["mssql_discovered"] = mssql_discovered
            __props__.__dict__["os_profile"] = os_profile
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["parent_cluster_resource_id"] = parent_cluster_resource_id
            __props__.__dict__["private_link_scope_resource_id"] = private_link_scope_resource_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["service_statuses"] = service_statuses
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vm_id"] = vm_id
            __props__.__dict__["ad_fqdn"] = None
            __props__.__dict__["agent_configuration"] = None
            __props__.__dict__["agent_version"] = None
            __props__.__dict__["cloud_metadata"] = None
            __props__.__dict__["detected_properties"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["dns_fqdn"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["error_details"] = None
            __props__.__dict__["last_status_change"] = None
            __props__.__dict__["machine_fqdn"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["os_name"] = None
            __props__.__dict__["os_sku"] = None
            __props__.__dict__["os_version"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["resources"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["vm_uuid"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:hybridcompute:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20190318preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20190802preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20191212:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20200730preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20200802:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20200815preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20210128preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20210325preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20210422preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20210517preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20210520:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20210610preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20211210preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20220310:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20220510preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20220811preview:Machine"), pulumi.Alias(type_="azure-native:hybridcompute/v20221227preview:Machine")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Machine, __self__).__init__(
            'azure-native:hybridcompute/v20221110:Machine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Machine':
        """
        Get an existing Machine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MachineArgs.__new__(MachineArgs)

        __props__.__dict__["ad_fqdn"] = None
        __props__.__dict__["agent_configuration"] = None
        __props__.__dict__["agent_version"] = None
        __props__.__dict__["client_public_key"] = None
        __props__.__dict__["cloud_metadata"] = None
        __props__.__dict__["detected_properties"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["dns_fqdn"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["error_details"] = None
        __props__.__dict__["extensions"] = None
        __props__.__dict__["identity"] = None
        __props__.__dict__["last_status_change"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["location_data"] = None
        __props__.__dict__["machine_fqdn"] = None
        __props__.__dict__["mssql_discovered"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["os_name"] = None
        __props__.__dict__["os_profile"] = None
        __props__.__dict__["os_sku"] = None
        __props__.__dict__["os_type"] = None
        __props__.__dict__["os_version"] = None
        __props__.__dict__["parent_cluster_resource_id"] = None
        __props__.__dict__["private_link_scope_resource_id"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["resources"] = None
        __props__.__dict__["service_statuses"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["vm_id"] = None
        __props__.__dict__["vm_uuid"] = None
        return Machine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adFqdn")
    def ad_fqdn(self) -> pulumi.Output[str]:
        """
        Specifies the AD fully qualified display name.
        """
        return pulumi.get(self, "ad_fqdn")

    @property
    @pulumi.getter(name="agentConfiguration")
    def agent_configuration(self) -> pulumi.Output['outputs.AgentConfigurationResponse']:
        """
        Configurable properties that the user can set locally via the azcmagent config command, or remotely via ARM.
        """
        return pulumi.get(self, "agent_configuration")

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[str]:
        """
        The hybrid machine agent full version.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="clientPublicKey")
    def client_public_key(self) -> pulumi.Output[Optional[str]]:
        """
        Public Key that the client provides to be used during initial resource onboarding
        """
        return pulumi.get(self, "client_public_key")

    @property
    @pulumi.getter(name="cloudMetadata")
    def cloud_metadata(self) -> pulumi.Output[Optional['outputs.CloudMetadataResponse']]:
        """
        The metadata of the cloud environment (Azure/GCP/AWS/OCI...).
        """
        return pulumi.get(self, "cloud_metadata")

    @property
    @pulumi.getter(name="detectedProperties")
    def detected_properties(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Detected properties from the machine.
        """
        return pulumi.get(self, "detected_properties")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Specifies the hybrid machine display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsFqdn")
    def dns_fqdn(self) -> pulumi.Output[str]:
        """
        Specifies the DNS fully qualified display name.
        """
        return pulumi.get(self, "dns_fqdn")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Specifies the Windows domain name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="errorDetails")
    def error_details(self) -> pulumi.Output[Sequence['outputs.ErrorDetailResponse']]:
        """
        Details about the error state.
        """
        return pulumi.get(self, "error_details")

    @property
    @pulumi.getter
    def extensions(self) -> pulumi.Output[Optional[Sequence['outputs.MachineExtensionInstanceViewResponse']]]:
        """
        Machine Extensions information (deprecated field)
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.IdentityResponse']]:
        """
        Identity for the resource.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="lastStatusChange")
    def last_status_change(self) -> pulumi.Output[str]:
        """
        The time of the last status change.
        """
        return pulumi.get(self, "last_status_change")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="locationData")
    def location_data(self) -> pulumi.Output[Optional['outputs.LocationDataResponse']]:
        """
        Metadata pertaining to the geographic location of the resource.
        """
        return pulumi.get(self, "location_data")

    @property
    @pulumi.getter(name="machineFqdn")
    def machine_fqdn(self) -> pulumi.Output[str]:
        """
        Specifies the hybrid machine FQDN.
        """
        return pulumi.get(self, "machine_fqdn")

    @property
    @pulumi.getter(name="mssqlDiscovered")
    def mssql_discovered(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether any MS SQL instance is discovered on the machine.
        """
        return pulumi.get(self, "mssql_discovered")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> pulumi.Output[str]:
        """
        The Operating System running on the hybrid machine.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> pulumi.Output[Optional['outputs.OSProfileResponse']]:
        """
        Specifies the operating system settings for the hybrid machine.
        """
        return pulumi.get(self, "os_profile")

    @property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> pulumi.Output[str]:
        """
        Specifies the Operating System product SKU.
        """
        return pulumi.get(self, "os_sku")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of Operating System (windows/linux).
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> pulumi.Output[str]:
        """
        The version of Operating System running on the hybrid machine.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="parentClusterResourceId")
    def parent_cluster_resource_id(self) -> pulumi.Output[Optional[str]]:
        """
        The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
        """
        return pulumi.get(self, "parent_cluster_resource_id")

    @property
    @pulumi.getter(name="privateLinkScopeResourceId")
    def private_link_scope_resource_id(self) -> pulumi.Output[Optional[str]]:
        """
        The resource id of the private link scope this machine is assigned to, if any.
        """
        return pulumi.get(self, "private_link_scope_resource_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Sequence['outputs.MachineExtensionResponse']]:
        """
        The list of extensions affiliated to the machine
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="serviceStatuses")
    def service_statuses(self) -> pulumi.Output[Optional['outputs.ServiceStatusesResponse']]:
        """
        Statuses of dependent services that are reported back to ARM.
        """
        return pulumi.get(self, "service_statuses")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the hybrid machine agent.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the hybrid machine unique ID.
        """
        return pulumi.get(self, "vm_id")

    @property
    @pulumi.getter(name="vmUuid")
    def vm_uuid(self) -> pulumi.Output[str]:
        """
        Specifies the Arc Machine's unique SMBIOS ID
        """
        return pulumi.get(self, "vm_uuid")

