# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'HybridComputePrivateLinkScopePropertiesArgs',
    'IdentityArgs',
    'LocationDataArgs',
    'MachineExtensionInstanceViewStatusArgs',
    'MachineExtensionInstanceViewArgs',
    'OSProfileLinuxConfigurationArgs',
    'OSProfileWindowsConfigurationArgs',
    'OSProfileArgs',
    'PrivateEndpointConnectionPropertiesArgs',
    'PrivateEndpointPropertyArgs',
    'PrivateLinkServiceConnectionStatePropertyArgs',
    'ServiceStatusesArgs',
    'ServiceStatusArgs',
]

@pulumi.input_type
class HybridComputePrivateLinkScopePropertiesArgs:
    def __init__(__self__, *,
                 public_network_access: Optional[pulumi.Input[Union[str, 'PublicNetworkAccessType']]] = None):
        """
        Properties that define a Azure Arc PrivateLinkScope resource.
        :param pulumi.Input[Union[str, 'PublicNetworkAccessType']] public_network_access: Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
        """
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[Union[str, 'PublicNetworkAccessType']]]:
        """
        Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[Union[str, 'PublicNetworkAccessType']]]):
        pulumi.set(self, "public_network_access", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None):
        """
        Identity for the resource.
        :param pulumi.Input['ResourceIdentityType'] type: The identity type.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class LocationDataArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 city: Optional[pulumi.Input[str]] = None,
                 country_or_region: Optional[pulumi.Input[str]] = None,
                 district: Optional[pulumi.Input[str]] = None):
        """
        Metadata pertaining to the geographic location of the resource.
        :param pulumi.Input[str] name: A canonical name for the geographic or physical location.
        :param pulumi.Input[str] city: The city or locality where the resource is located.
        :param pulumi.Input[str] country_or_region: The country or region where the resource is located
        :param pulumi.Input[str] district: The district, state, or province where the resource is located.
        """
        pulumi.set(__self__, "name", name)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country_or_region is not None:
            pulumi.set(__self__, "country_or_region", country_or_region)
        if district is not None:
            pulumi.set(__self__, "district", district)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A canonical name for the geographic or physical location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        The city or locality where the resource is located.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="countryOrRegion")
    def country_or_region(self) -> Optional[pulumi.Input[str]]:
        """
        The country or region where the resource is located
        """
        return pulumi.get(self, "country_or_region")

    @country_or_region.setter
    def country_or_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country_or_region", value)

    @property
    @pulumi.getter
    def district(self) -> Optional[pulumi.Input[str]]:
        """
        The district, state, or province where the resource is located.
        """
        return pulumi.get(self, "district")

    @district.setter
    def district(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "district", value)


@pulumi.input_type
class MachineExtensionInstanceViewStatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 display_status: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[Union[str, 'StatusLevelTypes']]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 time: Optional[pulumi.Input[str]] = None):
        """
        Instance view status.
        :param pulumi.Input[str] code: The status code.
        :param pulumi.Input[str] display_status: The short localizable label for the status.
        :param pulumi.Input[Union[str, 'StatusLevelTypes']] level: The level code.
        :param pulumi.Input[str] message: The detailed status message, including for alerts and error messages.
        :param pulumi.Input[str] time: The time of the status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if display_status is not None:
            pulumi.set(__self__, "display_status", display_status)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        The status code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> Optional[pulumi.Input[str]]:
        """
        The short localizable label for the status.
        """
        return pulumi.get(self, "display_status")

    @display_status.setter
    def display_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_status", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[Union[str, 'StatusLevelTypes']]]:
        """
        The level code.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[Union[str, 'StatusLevelTypes']]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The detailed status message, including for alerts and error messages.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[str]]:
        """
        The time of the status.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class MachineExtensionInstanceViewArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input['MachineExtensionInstanceViewStatusArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 type_handler_version: Optional[pulumi.Input[str]] = None):
        """
        Describes the Machine Extension Instance View.
        :param pulumi.Input[str] name: The machine extension name.
        :param pulumi.Input['MachineExtensionInstanceViewStatusArgs'] status: Instance view status.
        :param pulumi.Input[str] type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param pulumi.Input[str] type_handler_version: Specifies the version of the script handler.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The machine extension name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['MachineExtensionInstanceViewStatusArgs']]:
        """
        Instance view status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['MachineExtensionInstanceViewStatusArgs']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type_handler_version", value)


@pulumi.input_type
class OSProfileLinuxConfigurationArgs:
    def __init__(__self__, *,
                 assessment_mode: Optional[pulumi.Input[Union[str, 'AssessmentModeTypes']]] = None,
                 patch_mode: Optional[pulumi.Input[Union[str, 'PatchModeTypes']]] = None):
        """
        Specifies the linux configuration for update management.
        :param pulumi.Input[Union[str, 'AssessmentModeTypes']] assessment_mode: Specifies the assessment mode.
        :param pulumi.Input[Union[str, 'PatchModeTypes']] patch_mode: Specifies the patch mode.
        """
        if assessment_mode is not None:
            pulumi.set(__self__, "assessment_mode", assessment_mode)
        if patch_mode is not None:
            pulumi.set(__self__, "patch_mode", patch_mode)

    @property
    @pulumi.getter(name="assessmentMode")
    def assessment_mode(self) -> Optional[pulumi.Input[Union[str, 'AssessmentModeTypes']]]:
        """
        Specifies the assessment mode.
        """
        return pulumi.get(self, "assessment_mode")

    @assessment_mode.setter
    def assessment_mode(self, value: Optional[pulumi.Input[Union[str, 'AssessmentModeTypes']]]):
        pulumi.set(self, "assessment_mode", value)

    @property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> Optional[pulumi.Input[Union[str, 'PatchModeTypes']]]:
        """
        Specifies the patch mode.
        """
        return pulumi.get(self, "patch_mode")

    @patch_mode.setter
    def patch_mode(self, value: Optional[pulumi.Input[Union[str, 'PatchModeTypes']]]):
        pulumi.set(self, "patch_mode", value)


@pulumi.input_type
class OSProfileWindowsConfigurationArgs:
    def __init__(__self__, *,
                 assessment_mode: Optional[pulumi.Input[Union[str, 'AssessmentModeTypes']]] = None,
                 patch_mode: Optional[pulumi.Input[Union[str, 'PatchModeTypes']]] = None):
        """
        Specifies the windows configuration for update management.
        :param pulumi.Input[Union[str, 'AssessmentModeTypes']] assessment_mode: Specifies the assessment mode.
        :param pulumi.Input[Union[str, 'PatchModeTypes']] patch_mode: Specifies the patch mode.
        """
        if assessment_mode is not None:
            pulumi.set(__self__, "assessment_mode", assessment_mode)
        if patch_mode is not None:
            pulumi.set(__self__, "patch_mode", patch_mode)

    @property
    @pulumi.getter(name="assessmentMode")
    def assessment_mode(self) -> Optional[pulumi.Input[Union[str, 'AssessmentModeTypes']]]:
        """
        Specifies the assessment mode.
        """
        return pulumi.get(self, "assessment_mode")

    @assessment_mode.setter
    def assessment_mode(self, value: Optional[pulumi.Input[Union[str, 'AssessmentModeTypes']]]):
        pulumi.set(self, "assessment_mode", value)

    @property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> Optional[pulumi.Input[Union[str, 'PatchModeTypes']]]:
        """
        Specifies the patch mode.
        """
        return pulumi.get(self, "patch_mode")

    @patch_mode.setter
    def patch_mode(self, value: Optional[pulumi.Input[Union[str, 'PatchModeTypes']]]):
        pulumi.set(self, "patch_mode", value)


@pulumi.input_type
class OSProfileArgs:
    def __init__(__self__, *,
                 linux_configuration: Optional[pulumi.Input['OSProfileLinuxConfigurationArgs']] = None,
                 windows_configuration: Optional[pulumi.Input['OSProfileWindowsConfigurationArgs']] = None):
        """
        Specifies the operating system settings for the hybrid machine.
        :param pulumi.Input['OSProfileLinuxConfigurationArgs'] linux_configuration: Specifies the linux configuration for update management.
        :param pulumi.Input['OSProfileWindowsConfigurationArgs'] windows_configuration: Specifies the windows configuration for update management.
        """
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional[pulumi.Input['OSProfileLinuxConfigurationArgs']]:
        """
        Specifies the linux configuration for update management.
        """
        return pulumi.get(self, "linux_configuration")

    @linux_configuration.setter
    def linux_configuration(self, value: Optional[pulumi.Input['OSProfileLinuxConfigurationArgs']]):
        pulumi.set(self, "linux_configuration", value)

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional[pulumi.Input['OSProfileWindowsConfigurationArgs']]:
        """
        Specifies the windows configuration for update management.
        """
        return pulumi.get(self, "windows_configuration")

    @windows_configuration.setter
    def windows_configuration(self, value: Optional[pulumi.Input['OSProfileWindowsConfigurationArgs']]):
        pulumi.set(self, "windows_configuration", value)


@pulumi.input_type
class PrivateEndpointConnectionPropertiesArgs:
    def __init__(__self__, *,
                 private_endpoint: Optional[pulumi.Input['PrivateEndpointPropertyArgs']] = None,
                 private_link_service_connection_state: Optional[pulumi.Input['PrivateLinkServiceConnectionStatePropertyArgs']] = None):
        """
        Properties of a private endpoint connection.
        :param pulumi.Input['PrivateEndpointPropertyArgs'] private_endpoint: Private endpoint which the connection belongs to.
        :param pulumi.Input['PrivateLinkServiceConnectionStatePropertyArgs'] private_link_service_connection_state: Connection state of the private endpoint connection.
        """
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input['PrivateEndpointPropertyArgs']]:
        """
        Private endpoint which the connection belongs to.
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input['PrivateEndpointPropertyArgs']]):
        pulumi.set(self, "private_endpoint", value)

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional[pulumi.Input['PrivateLinkServiceConnectionStatePropertyArgs']]:
        """
        Connection state of the private endpoint connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @private_link_service_connection_state.setter
    def private_link_service_connection_state(self, value: Optional[pulumi.Input['PrivateLinkServiceConnectionStatePropertyArgs']]):
        pulumi.set(self, "private_link_service_connection_state", value)


@pulumi.input_type
class PrivateEndpointPropertyArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Private endpoint which the connection belongs to.
        :param pulumi.Input[str] id: Resource id of the private endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStatePropertyArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 status: pulumi.Input[str]):
        """
        State of the private endpoint connection.
        :param pulumi.Input[str] description: The private link service connection description.
        :param pulumi.Input[str] status: The private link service connection status.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ServiceStatusesArgs:
    def __init__(__self__, *,
                 extension_service: Optional[pulumi.Input['ServiceStatusArgs']] = None,
                 guest_configuration_service: Optional[pulumi.Input['ServiceStatusArgs']] = None):
        """
        Reports the state and behavior of dependent services.
        :param pulumi.Input['ServiceStatusArgs'] extension_service: The state of the extension service on the Arc-enabled machine.
        :param pulumi.Input['ServiceStatusArgs'] guest_configuration_service: The state of the guest configuration service on the Arc-enabled machine.
        """
        if extension_service is not None:
            pulumi.set(__self__, "extension_service", extension_service)
        if guest_configuration_service is not None:
            pulumi.set(__self__, "guest_configuration_service", guest_configuration_service)

    @property
    @pulumi.getter(name="extensionService")
    def extension_service(self) -> Optional[pulumi.Input['ServiceStatusArgs']]:
        """
        The state of the extension service on the Arc-enabled machine.
        """
        return pulumi.get(self, "extension_service")

    @extension_service.setter
    def extension_service(self, value: Optional[pulumi.Input['ServiceStatusArgs']]):
        pulumi.set(self, "extension_service", value)

    @property
    @pulumi.getter(name="guestConfigurationService")
    def guest_configuration_service(self) -> Optional[pulumi.Input['ServiceStatusArgs']]:
        """
        The state of the guest configuration service on the Arc-enabled machine.
        """
        return pulumi.get(self, "guest_configuration_service")

    @guest_configuration_service.setter
    def guest_configuration_service(self, value: Optional[pulumi.Input['ServiceStatusArgs']]):
        pulumi.set(self, "guest_configuration_service", value)


@pulumi.input_type
class ServiceStatusArgs:
    def __init__(__self__, *,
                 startup_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Describes the status and behavior of a service.
        :param pulumi.Input[str] startup_type: The behavior of the service when the Arc-enabled machine starts up.
        :param pulumi.Input[str] status: The current status of the service.
        """
        if startup_type is not None:
            pulumi.set(__self__, "startup_type", startup_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="startupType")
    def startup_type(self) -> Optional[pulumi.Input[str]]:
        """
        The behavior of the service when the Arc-enabled machine starts up.
        """
        return pulumi.get(self, "startup_type")

    @startup_type.setter
    def startup_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "startup_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


