# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetSubscriptionFeatureRegistrationResult',
    'AwaitableGetSubscriptionFeatureRegistrationResult',
    'get_subscription_feature_registration',
    'get_subscription_feature_registration_output',
]

@pulumi.output_type
class GetSubscriptionFeatureRegistrationResult:
    """
    Subscription feature registration details
    """
    def __init__(__self__, id=None, name=None, properties=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Azure resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Azure resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.SubscriptionFeatureRegistrationResponseProperties':
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Azure resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetSubscriptionFeatureRegistrationResult(GetSubscriptionFeatureRegistrationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionFeatureRegistrationResult(
            id=self.id,
            name=self.name,
            properties=self.properties,
            type=self.type)


def get_subscription_feature_registration(feature_name: Optional[str] = None,
                                          provider_namespace: Optional[str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionFeatureRegistrationResult:
    """
    Subscription feature registration details


    :param str feature_name: The feature name.
    :param str provider_namespace: The provider namespace.
    """
    __args__ = dict()
    __args__['featureName'] = feature_name
    __args__['providerNamespace'] = provider_namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:features/v20210701:getSubscriptionFeatureRegistration', __args__, opts=opts, typ=GetSubscriptionFeatureRegistrationResult).value

    return AwaitableGetSubscriptionFeatureRegistrationResult(
        id=__ret__.id,
        name=__ret__.name,
        properties=__ret__.properties,
        type=__ret__.type)


@_utilities.lift_output_func(get_subscription_feature_registration)
def get_subscription_feature_registration_output(feature_name: Optional[pulumi.Input[str]] = None,
                                                 provider_namespace: Optional[pulumi.Input[str]] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubscriptionFeatureRegistrationResult]:
    """
    Subscription feature registration details


    :param str feature_name: The feature name.
    :param str provider_namespace: The provider namespace.
    """
    ...
