# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetPipelineResult',
    'AwaitableGetPipelineResult',
    'get_pipeline',
    'get_pipeline_output',
]

warnings.warn("""Version 2017-09-01-preview will be removed in v2 of the provider.""", DeprecationWarning)

@pulumi.output_type
class GetPipelineResult:
    """
    Pipeline resource type.
    """
    def __init__(__self__, activities=None, annotations=None, concurrency=None, description=None, etag=None, id=None, name=None, parameters=None, type=None):
        if activities and not isinstance(activities, list):
            raise TypeError("Expected argument 'activities' to be a list")
        pulumi.set(__self__, "activities", activities)
        if annotations and not isinstance(annotations, list):
            raise TypeError("Expected argument 'annotations' to be a list")
        pulumi.set(__self__, "annotations", annotations)
        if concurrency and not isinstance(concurrency, int):
            raise TypeError("Expected argument 'concurrency' to be a int")
        pulumi.set(__self__, "concurrency", concurrency)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def activities(self) -> Optional[Sequence[Any]]:
        """
        List of activities in pipeline.
        """
        return pulumi.get(self, "activities")

    @property
    @pulumi.getter
    def annotations(self) -> Optional[Sequence[Any]]:
        """
        List of tags that can be used for describing the Pipeline.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def concurrency(self) -> Optional[int]:
        """
        The max number of concurrent runs for the pipeline.
        """
        return pulumi.get(self, "concurrency")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the pipeline.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Etag identifies change in the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, 'outputs.ParameterSpecificationResponse']]:
        """
        List of parameters for pipeline.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetPipelineResult(GetPipelineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineResult(
            activities=self.activities,
            annotations=self.annotations,
            concurrency=self.concurrency,
            description=self.description,
            etag=self.etag,
            id=self.id,
            name=self.name,
            parameters=self.parameters,
            type=self.type)


def get_pipeline(factory_name: Optional[str] = None,
                 pipeline_name: Optional[str] = None,
                 resource_group_name: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineResult:
    """
    Pipeline resource type.


    :param str factory_name: The factory name.
    :param str pipeline_name: The pipeline name.
    :param str resource_group_name: The resource group name.
    """
    pulumi.log.warn("""get_pipeline is deprecated: Version 2017-09-01-preview will be removed in v2 of the provider.""")
    __args__ = dict()
    __args__['factoryName'] = factory_name
    __args__['pipelineName'] = pipeline_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:datafactory/v20170901preview:getPipeline', __args__, opts=opts, typ=GetPipelineResult).value

    return AwaitableGetPipelineResult(
        activities=__ret__.activities,
        annotations=__ret__.annotations,
        concurrency=__ret__.concurrency,
        description=__ret__.description,
        etag=__ret__.etag,
        id=__ret__.id,
        name=__ret__.name,
        parameters=__ret__.parameters,
        type=__ret__.type)


@_utilities.lift_output_func(get_pipeline)
def get_pipeline_output(factory_name: Optional[pulumi.Input[str]] = None,
                        pipeline_name: Optional[pulumi.Input[str]] = None,
                        resource_group_name: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPipelineResult]:
    """
    Pipeline resource type.


    :param str factory_name: The factory name.
    :param str pipeline_name: The pipeline name.
    :param str resource_group_name: The resource group name.
    """
    pulumi.log.warn("""get_pipeline is deprecated: Version 2017-09-01-preview will be removed in v2 of the provider.""")
    ...
