# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApiErrorBaseResponse',
    'ApiErrorResponse',
    'CopyCompletionErrorResponse',
    'CreationDataResponse',
    'DiskSecurityProfileResponse',
    'DiskSkuResponse',
    'EncryptionResponse',
    'EncryptionSetIdentityResponse',
    'EncryptionSettingsCollectionResponse',
    'EncryptionSettingsElementResponse',
    'ExtendedLocationResponse',
    'ImageDiskReferenceResponse',
    'InnerErrorResponse',
    'KeyForDiskEncryptionSetResponse',
    'KeyVaultAndKeyReferenceResponse',
    'KeyVaultAndSecretReferenceResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'PropertyUpdatesInProgressResponse',
    'PurchasePlanResponse',
    'ShareInfoElementResponse',
    'SnapshotSkuResponse',
    'SourceVaultResponse',
    'SupportedCapabilitiesResponse',
    'UserAssignedIdentitiesResponseUserAssignedIdentities',
]

@pulumi.output_type
class ApiErrorBaseResponse(dict):
    """
    Api error base.
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None,
                 target: Optional[str] = None):
        """
        Api error base.
        :param str code: The error code.
        :param str message: The error message.
        :param str target: The target of the particular error.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target of the particular error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ApiErrorResponse(dict):
    """
    Api error.
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 details: Optional[Sequence['outputs.ApiErrorBaseResponse']] = None,
                 innererror: Optional['outputs.InnerErrorResponse'] = None,
                 message: Optional[str] = None,
                 target: Optional[str] = None):
        """
        Api error.
        :param str code: The error code.
        :param Sequence['ApiErrorBaseResponse'] details: The Api error details
        :param 'InnerErrorResponse' innererror: The Api inner error
        :param str message: The error message.
        :param str target: The target of the particular error.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if innererror is not None:
            pulumi.set(__self__, "innererror", innererror)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ApiErrorBaseResponse']]:
        """
        The Api error details
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def innererror(self) -> Optional['outputs.InnerErrorResponse']:
        """
        The Api inner error
        """
        return pulumi.get(self, "innererror")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target of the particular error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class CopyCompletionErrorResponse(dict):
    """
    Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CopyCompletionErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CopyCompletionErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CopyCompletionErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: str,
                 error_message: str):
        """
        Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
        :param str error_code: Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
        :param str error_message: Indicates the error message if the background copy of a resource created via the CopyStart operation fails.
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "error_message", error_message)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        Indicates the error code if the background copy of a resource created via the CopyStart operation fails.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        Indicates the error message if the background copy of a resource created via the CopyStart operation fails.
        """
        return pulumi.get(self, "error_message")


@pulumi.output_type
class CreationDataResponse(dict):
    """
    Data used when creating a disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "sourceUniqueId":
            suggest = "source_unique_id"
        elif key == "galleryImageReference":
            suggest = "gallery_image_reference"
        elif key == "imageReference":
            suggest = "image_reference"
        elif key == "logicalSectorSize":
            suggest = "logical_sector_size"
        elif key == "securityDataUri":
            suggest = "security_data_uri"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "sourceUri":
            suggest = "source_uri"
        elif key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "uploadSizeBytes":
            suggest = "upload_size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CreationDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CreationDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CreationDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: str,
                 source_unique_id: str,
                 gallery_image_reference: Optional['outputs.ImageDiskReferenceResponse'] = None,
                 image_reference: Optional['outputs.ImageDiskReferenceResponse'] = None,
                 logical_sector_size: Optional[int] = None,
                 security_data_uri: Optional[str] = None,
                 source_resource_id: Optional[str] = None,
                 source_uri: Optional[str] = None,
                 storage_account_id: Optional[str] = None,
                 upload_size_bytes: Optional[float] = None):
        """
        Data used when creating a disk.
        :param str create_option: This enumerates the possible sources of a disk's creation.
        :param str source_unique_id: If this field is set, this is the unique id identifying the source of this resource.
        :param 'ImageDiskReferenceResponse' gallery_image_reference: Required if creating from a Gallery Image. The id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
        :param 'ImageDiskReferenceResponse' image_reference: Disk source information for PIR or user images.
        :param int logical_sector_size: Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
        :param str security_data_uri: If createOption is ImportSecure, this is the URI of a blob to be imported into VM guest state.
        :param str source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot or disk.
        :param str source_uri: If createOption is Import, this is the URI of a blob to be imported into a managed disk.
        :param str storage_account_id: Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
        :param float upload_size_bytes: If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "source_unique_id", source_unique_id)
        if gallery_image_reference is not None:
            pulumi.set(__self__, "gallery_image_reference", gallery_image_reference)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)
        if logical_sector_size is not None:
            pulumi.set(__self__, "logical_sector_size", logical_sector_size)
        if security_data_uri is not None:
            pulumi.set(__self__, "security_data_uri", security_data_uri)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if upload_size_bytes is not None:
            pulumi.set(__self__, "upload_size_bytes", upload_size_bytes)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> str:
        """
        This enumerates the possible sources of a disk's creation.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter(name="sourceUniqueId")
    def source_unique_id(self) -> str:
        """
        If this field is set, this is the unique id identifying the source of this resource.
        """
        return pulumi.get(self, "source_unique_id")

    @property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> Optional['outputs.ImageDiskReferenceResponse']:
        """
        Required if creating from a Gallery Image. The id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of the shared galley image version from which to create a disk.
        """
        return pulumi.get(self, "gallery_image_reference")

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional['outputs.ImageDiskReferenceResponse']:
        """
        Disk source information for PIR or user images.
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="logicalSectorSize")
    def logical_sector_size(self) -> Optional[int]:
        """
        Logical sector size in bytes for Ultra disks. Supported values are 512 ad 4096. 4096 is the default.
        """
        return pulumi.get(self, "logical_sector_size")

    @property
    @pulumi.getter(name="securityDataUri")
    def security_data_uri(self) -> Optional[str]:
        """
        If createOption is ImportSecure, this is the URI of a blob to be imported into VM guest state.
        """
        return pulumi.get(self, "security_data_uri")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        If createOption is Copy, this is the ARM id of the source snapshot or disk.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[str]:
        """
        If createOption is Import, this is the URI of a blob to be imported into a managed disk.
        """
        return pulumi.get(self, "source_uri")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[str]:
        """
        Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="uploadSizeBytes")
    def upload_size_bytes(self) -> Optional[float]:
        """
        If createOption is Upload, this is the size of the contents of the upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
        """
        return pulumi.get(self, "upload_size_bytes")


@pulumi.output_type
class DiskSecurityProfileResponse(dict):
    """
    Contains the security related information for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secureVMDiskEncryptionSetId":
            suggest = "secure_vm_disk_encryption_set_id"
        elif key == "securityType":
            suggest = "security_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskSecurityProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskSecurityProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskSecurityProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secure_vm_disk_encryption_set_id: Optional[str] = None,
                 security_type: Optional[str] = None):
        """
        Contains the security related information for the resource.
        :param str secure_vm_disk_encryption_set_id: ResourceId of the disk encryption set associated to Confidential VM supported disk encrypted with customer managed key
        :param str security_type: Specifies the SecurityType of the VM. Applicable for OS disks only.
        """
        if secure_vm_disk_encryption_set_id is not None:
            pulumi.set(__self__, "secure_vm_disk_encryption_set_id", secure_vm_disk_encryption_set_id)
        if security_type is not None:
            pulumi.set(__self__, "security_type", security_type)

    @property
    @pulumi.getter(name="secureVMDiskEncryptionSetId")
    def secure_vm_disk_encryption_set_id(self) -> Optional[str]:
        """
        ResourceId of the disk encryption set associated to Confidential VM supported disk encrypted with customer managed key
        """
        return pulumi.get(self, "secure_vm_disk_encryption_set_id")

    @property
    @pulumi.getter(name="securityType")
    def security_type(self) -> Optional[str]:
        """
        Specifies the SecurityType of the VM. Applicable for OS disks only.
        """
        return pulumi.get(self, "security_type")


@pulumi.output_type
class DiskSkuResponse(dict):
    """
    The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
    """
    def __init__(__self__, *,
                 tier: str,
                 name: Optional[str] = None):
        """
        The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
        :param str tier: The sku tier.
        :param str name: The sku name.
        """
        pulumi.set(__self__, "tier", tier)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The sku tier.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class EncryptionResponse(dict):
    """
    Encryption at rest settings for disk or snapshot
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_set_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Encryption at rest settings for disk or snapshot
        :param str disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling encryption at rest.
        :param str type: The type of key used to encrypt the data of the disk.
        """
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[str]:
        """
        ResourceId of the disk encryption set to use for enabling encryption at rest.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of key used to encrypt the data of the disk.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EncryptionSetIdentityResponse(dict):
    """
    The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionSetIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionSetIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionSetIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentitiesResponseUserAssignedIdentities']] = None):
        """
        The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.
        :param str principal_id: The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        :param str tenant_id: The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        :param str type: The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported for new creations. Disk Encryption Sets can be updated with Identity type None during migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted resources to lose access to the keys.
        :param Mapping[str, 'UserAssignedIdentitiesResponseUserAssignedIdentities'] user_assigned_identities: The list of user identities associated with the disk encryption set. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a systemAssigned(implicit) identity
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is supported for new creations. Disk Encryption Sets can be updated with Identity type None during migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted resources to lose access to the keys.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentitiesResponseUserAssignedIdentities']]:
        """
        The list of user identities associated with the disk encryption set. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class EncryptionSettingsCollectionResponse(dict):
    """
    Encryption settings for disk or snapshot
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionSettings":
            suggest = "encryption_settings"
        elif key == "encryptionSettingsVersion":
            suggest = "encryption_settings_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionSettingsCollectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionSettingsCollectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionSettingsCollectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 encryption_settings: Optional[Sequence['outputs.EncryptionSettingsElementResponse']] = None,
                 encryption_settings_version: Optional[str] = None):
        """
        Encryption settings for disk or snapshot
        :param bool enabled: Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
        :param Sequence['EncryptionSettingsElementResponse'] encryption_settings: A collection of encryption settings, one for each disk volume.
        :param str encryption_settings_version: Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
        """
        pulumi.set(__self__, "enabled", enabled)
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if encryption_settings_version is not None:
            pulumi.set(__self__, "encryption_settings_version", encryption_settings_version)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional[Sequence['outputs.EncryptionSettingsElementResponse']]:
        """
        A collection of encryption settings, one for each disk volume.
        """
        return pulumi.get(self, "encryption_settings")

    @property
    @pulumi.getter(name="encryptionSettingsVersion")
    def encryption_settings_version(self) -> Optional[str]:
        """
        Describes what type of encryption is used for the disks. Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption with AAD app.'1.1' corresponds to Azure Disk Encryption.
        """
        return pulumi.get(self, "encryption_settings_version")


@pulumi.output_type
class EncryptionSettingsElementResponse(dict):
    """
    Encryption settings for one disk volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionKey":
            suggest = "disk_encryption_key"
        elif key == "keyEncryptionKey":
            suggest = "key_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionSettingsElementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionSettingsElementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionSettingsElementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_key: Optional['outputs.KeyVaultAndSecretReferenceResponse'] = None,
                 key_encryption_key: Optional['outputs.KeyVaultAndKeyReferenceResponse'] = None):
        """
        Encryption settings for one disk volume.
        :param 'KeyVaultAndSecretReferenceResponse' disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key
        :param 'KeyVaultAndKeyReferenceResponse' key_encryption_key: Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
        """
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional['outputs.KeyVaultAndSecretReferenceResponse']:
        """
        Key Vault Secret Url and vault id of the disk encryption key
        """
        return pulumi.get(self, "disk_encryption_key")

    @property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional['outputs.KeyVaultAndKeyReferenceResponse']:
        """
        Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
        """
        return pulumi.get(self, "key_encryption_key")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    The complex type of the extended location.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The complex type of the extended location.
        :param str name: The name of the extended location.
        :param str type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ImageDiskReferenceResponse(dict):
    """
    The source image used for creating the disk.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "communityGalleryImageId":
            suggest = "community_gallery_image_id"
        elif key == "sharedGalleryImageId":
            suggest = "shared_gallery_image_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageDiskReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageDiskReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageDiskReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 community_gallery_image_id: Optional[str] = None,
                 id: Optional[str] = None,
                 lun: Optional[int] = None,
                 shared_gallery_image_id: Optional[str] = None):
        """
        The source image used for creating the disk.
        :param str community_gallery_image_id: A relative uri containing a community Azure Compute Gallery image reference.
        :param str id: A relative uri containing either a Platform Image Repository, user image, or Azure Compute Gallery image reference.
        :param int lun: If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
        :param str shared_gallery_image_id: A relative uri containing a direct shared Azure Compute Gallery image reference.
        """
        if community_gallery_image_id is not None:
            pulumi.set(__self__, "community_gallery_image_id", community_gallery_image_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if shared_gallery_image_id is not None:
            pulumi.set(__self__, "shared_gallery_image_id", shared_gallery_image_id)

    @property
    @pulumi.getter(name="communityGalleryImageId")
    def community_gallery_image_id(self) -> Optional[str]:
        """
        A relative uri containing a community Azure Compute Gallery image reference.
        """
        return pulumi.get(self, "community_gallery_image_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A relative uri containing either a Platform Image Repository, user image, or Azure Compute Gallery image reference.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def lun(self) -> Optional[int]:
        """
        If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter(name="sharedGalleryImageId")
    def shared_gallery_image_id(self) -> Optional[str]:
        """
        A relative uri containing a direct shared Azure Compute Gallery image reference.
        """
        return pulumi.get(self, "shared_gallery_image_id")


@pulumi.output_type
class InnerErrorResponse(dict):
    """
    Inner error details.
    """
    def __init__(__self__, *,
                 errordetail: Optional[str] = None,
                 exceptiontype: Optional[str] = None):
        """
        Inner error details.
        :param str errordetail: The internal error message or exception dump.
        :param str exceptiontype: The exception type.
        """
        if errordetail is not None:
            pulumi.set(__self__, "errordetail", errordetail)
        if exceptiontype is not None:
            pulumi.set(__self__, "exceptiontype", exceptiontype)

    @property
    @pulumi.getter
    def errordetail(self) -> Optional[str]:
        """
        The internal error message or exception dump.
        """
        return pulumi.get(self, "errordetail")

    @property
    @pulumi.getter
    def exceptiontype(self) -> Optional[str]:
        """
        The exception type.
        """
        return pulumi.get(self, "exceptiontype")


@pulumi.output_type
class KeyForDiskEncryptionSetResponse(dict):
    """
    Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUrl":
            suggest = "key_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyForDiskEncryptionSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyForDiskEncryptionSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyForDiskEncryptionSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_url: str,
                 source_vault: Optional['outputs.SourceVaultResponse'] = None):
        """
        Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
        :param str key_url: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of rotationToLatestKeyVersionEnabled value.
        :param 'SourceVaultResponse' source_vault: Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
        """
        pulumi.set(__self__, "key_url", key_url)
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> str:
        """
        Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required regardless of rotationToLatestKeyVersionEnabled value.
        """
        return pulumi.get(self, "key_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional['outputs.SourceVaultResponse']:
        """
        Resource id of the KeyVault containing the key or secret. This property is optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption Set subscription.
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class KeyVaultAndKeyReferenceResponse(dict):
    """
    Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUrl":
            suggest = "key_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultAndKeyReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultAndKeyReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultAndKeyReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_url: str,
                 source_vault: 'outputs.SourceVaultResponse'):
        """
        Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey
        :param str key_url: Url pointing to a key or secret in KeyVault
        :param 'SourceVaultResponse' source_vault: Resource id of the KeyVault containing the key or secret
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> str:
        """
        Url pointing to a key or secret in KeyVault
        """
        return pulumi.get(self, "key_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.SourceVaultResponse':
        """
        Resource id of the KeyVault containing the key or secret
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class KeyVaultAndSecretReferenceResponse(dict):
    """
    Key Vault Secret Url and vault id of the encryption key 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVault":
            suggest = "source_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultAndSecretReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultAndSecretReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultAndSecretReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: str,
                 source_vault: 'outputs.SourceVaultResponse'):
        """
        Key Vault Secret Url and vault id of the encryption key 
        :param str secret_url: Url pointing to a key or secret in KeyVault
        :param 'SourceVaultResponse' source_vault: Resource id of the KeyVault containing the key or secret
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> str:
        """
        Url pointing to a key or secret in KeyVault
        """
        return pulumi.get(self, "secret_url")

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> 'outputs.SourceVaultResponse':
        """
        Resource id of the KeyVault containing the key or secret
        """
        return pulumi.get(self, "source_vault")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_endpoint: 'outputs.PrivateEndpointResponse',
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 type: str):
        """
        The Private Endpoint Connection resource.
        :param str id: private endpoint connection Id
        :param str name: private endpoint connection name
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between DiskAccess and Virtual Network.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param str type: private endpoint connection type
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        private endpoint connection Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        private endpoint connection name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> 'outputs.PrivateEndpointResponse':
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between DiskAccess and Virtual Network.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        private endpoint connection type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PropertyUpdatesInProgressResponse(dict):
    """
    Properties of the disk for which update is pending.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetTier":
            suggest = "target_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PropertyUpdatesInProgressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PropertyUpdatesInProgressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PropertyUpdatesInProgressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_tier: Optional[str] = None):
        """
        Properties of the disk for which update is pending.
        :param str target_tier: The target performance tier of the disk if a tier change operation is in progress.
        """
        if target_tier is not None:
            pulumi.set(__self__, "target_tier", target_tier)

    @property
    @pulumi.getter(name="targetTier")
    def target_tier(self) -> Optional[str]:
        """
        The target performance tier of the disk if a tier change operation is in progress.
        """
        return pulumi.get(self, "target_tier")


@pulumi.output_type
class PurchasePlanResponse(dict):
    """
    Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promotionCode":
            suggest = "promotion_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PurchasePlanResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PurchasePlanResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PurchasePlanResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 product: str,
                 publisher: str,
                 promotion_code: Optional[str] = None):
        """
        Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
        :param str name: The plan ID.
        :param str product: Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        :param str publisher: The publisher ID.
        :param str promotion_code: The Offer Promotion Code.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The plan ID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def product(self) -> str:
        """
        Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def publisher(self) -> str:
        """
        The publisher ID.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[str]:
        """
        The Offer Promotion Code.
        """
        return pulumi.get(self, "promotion_code")


@pulumi.output_type
class ShareInfoElementResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmUri":
            suggest = "vm_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShareInfoElementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShareInfoElementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShareInfoElementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm_uri: str):
        """
        :param str vm_uri: A relative URI containing the ID of the VM that has the disk attached.
        """
        pulumi.set(__self__, "vm_uri", vm_uri)

    @property
    @pulumi.getter(name="vmUri")
    def vm_uri(self) -> str:
        """
        A relative URI containing the ID of the VM that has the disk attached.
        """
        return pulumi.get(self, "vm_uri")


@pulumi.output_type
class SnapshotSkuResponse(dict):
    """
    The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
    """
    def __init__(__self__, *,
                 tier: str,
                 name: Optional[str] = None):
        """
        The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
        :param str tier: The sku tier.
        :param str name: The sku name.
        """
        pulumi.set(__self__, "tier", tier)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The sku tier.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SourceVaultResponse(dict):
    """
    The vault id is an Azure Resource Manager Resource id in the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        The vault id is an Azure Resource Manager Resource id in the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
        :param str id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SupportedCapabilitiesResponse(dict):
    """
    List of supported capabilities persisted on the disk resource for VM use.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratedNetwork":
            suggest = "accelerated_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SupportedCapabilitiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SupportedCapabilitiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SupportedCapabilitiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerated_network: Optional[bool] = None,
                 architecture: Optional[str] = None):
        """
        List of supported capabilities persisted on the disk resource for VM use.
        :param bool accelerated_network: True if the image from which the OS disk is created supports accelerated networking.
        :param str architecture: CPU architecture supported by an OS disk.
        """
        if accelerated_network is not None:
            pulumi.set(__self__, "accelerated_network", accelerated_network)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)

    @property
    @pulumi.getter(name="acceleratedNetwork")
    def accelerated_network(self) -> Optional[bool]:
        """
        True if the image from which the OS disk is created supports accelerated networking.
        """
        return pulumi.get(self, "accelerated_network")

    @property
    @pulumi.getter
    def architecture(self) -> Optional[str]:
        """
        CPU architecture supported by an OS disk.
        """
        return pulumi.get(self, "architecture")


@pulumi.output_type
class UserAssignedIdentitiesResponseUserAssignedIdentities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentitiesResponseUserAssignedIdentities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentitiesResponseUserAssignedIdentities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentitiesResponseUserAssignedIdentities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


