# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'PrometheusRuleGroupActionArgs',
    'PrometheusRuleResolveConfigurationArgs',
    'PrometheusRuleArgs',
]

@pulumi.input_type
class PrometheusRuleGroupActionArgs:
    def __init__(__self__, *,
                 action_group_id: Optional[pulumi.Input[str]] = None,
                 action_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        An alert action. Only relevant for alerts.
        :param pulumi.Input[str] action_group_id: The resource id of the action group to use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] action_properties: The properties of an action group object.
        """
        if action_group_id is not None:
            pulumi.set(__self__, "action_group_id", action_group_id)
        if action_properties is not None:
            pulumi.set(__self__, "action_properties", action_properties)

    @property
    @pulumi.getter(name="actionGroupId")
    def action_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the action group to use.
        """
        return pulumi.get(self, "action_group_id")

    @action_group_id.setter
    def action_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_group_id", value)

    @property
    @pulumi.getter(name="actionProperties")
    def action_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The properties of an action group object.
        """
        return pulumi.get(self, "action_properties")

    @action_properties.setter
    def action_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "action_properties", value)


@pulumi.input_type
class PrometheusRuleResolveConfigurationArgs:
    def __init__(__self__, *,
                 auto_resolved: Optional[pulumi.Input[bool]] = None,
                 time_to_resolve: Optional[pulumi.Input[str]] = None):
        """
        Specifies the Prometheus alert rule configuration.
        :param pulumi.Input[bool] auto_resolved: the flag that indicates whether or not to auto resolve a fired alert.
        :param pulumi.Input[str] time_to_resolve: the duration a rule must evaluate as healthy before the fired alert is automatically resolved represented in ISO 8601 duration format. Should be between 1 and 15 minutes
        """
        if auto_resolved is not None:
            pulumi.set(__self__, "auto_resolved", auto_resolved)
        if time_to_resolve is not None:
            pulumi.set(__self__, "time_to_resolve", time_to_resolve)

    @property
    @pulumi.getter(name="autoResolved")
    def auto_resolved(self) -> Optional[pulumi.Input[bool]]:
        """
        the flag that indicates whether or not to auto resolve a fired alert.
        """
        return pulumi.get(self, "auto_resolved")

    @auto_resolved.setter
    def auto_resolved(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_resolved", value)

    @property
    @pulumi.getter(name="timeToResolve")
    def time_to_resolve(self) -> Optional[pulumi.Input[str]]:
        """
        the duration a rule must evaluate as healthy before the fired alert is automatically resolved represented in ISO 8601 duration format. Should be between 1 and 15 minutes
        """
        return pulumi.get(self, "time_to_resolve")

    @time_to_resolve.setter
    def time_to_resolve(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_to_resolve", value)


@pulumi.input_type
class PrometheusRuleArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['PrometheusRuleGroupActionArgs']]]] = None,
                 alert: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 for_: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 record: Optional[pulumi.Input[str]] = None,
                 resolve_configuration: Optional[pulumi.Input['PrometheusRuleResolveConfigurationArgs']] = None,
                 severity: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] expression: the expression to run for the rule.
        :param pulumi.Input[Sequence[pulumi.Input['PrometheusRuleGroupActionArgs']]] actions: The array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved. Only relevant for alerts.
        :param pulumi.Input[str] alert: the name of the alert rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: annotations for rule group. Only relevant for alerts.
        :param pulumi.Input[bool] enabled: the flag that indicates whether the Prometheus rule is enabled.
        :param pulumi.Input[str] for_: the amount of time alert must be active before firing. Only relevant for alerts.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: labels for rule group. Only relevant for alerts.
        :param pulumi.Input[str] record: the name of the recording rule.
        :param pulumi.Input['PrometheusRuleResolveConfigurationArgs'] resolve_configuration: defines the configuration for resolving fired alerts. Only relevant for alerts.
        :param pulumi.Input[int] severity: the severity of the alerts fired by the rule. Only relevant for alerts.
        """
        pulumi.set(__self__, "expression", expression)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if alert is not None:
            pulumi.set(__self__, "alert", alert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if for_ is not None:
            pulumi.set(__self__, "for_", for_)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if record is not None:
            pulumi.set(__self__, "record", record)
        if resolve_configuration is not None:
            pulumi.set(__self__, "resolve_configuration", resolve_configuration)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        the expression to run for the rule.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrometheusRuleGroupActionArgs']]]]:
        """
        The array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved. Only relevant for alerts.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrometheusRuleGroupActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def alert(self) -> Optional[pulumi.Input[str]]:
        """
        the name of the alert rule.
        """
        return pulumi.get(self, "alert")

    @alert.setter
    def alert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        annotations for rule group. Only relevant for alerts.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        the flag that indicates whether the Prometheus rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="for")
    def for_(self) -> Optional[pulumi.Input[str]]:
        """
        the amount of time alert must be active before firing. Only relevant for alerts.
        """
        return pulumi.get(self, "for_")

    @for_.setter
    def for_(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "for_", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        labels for rule group. Only relevant for alerts.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def record(self) -> Optional[pulumi.Input[str]]:
        """
        the name of the recording rule.
        """
        return pulumi.get(self, "record")

    @record.setter
    def record(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record", value)

    @property
    @pulumi.getter(name="resolveConfiguration")
    def resolve_configuration(self) -> Optional[pulumi.Input['PrometheusRuleResolveConfigurationArgs']]:
        """
        defines the configuration for resolving fired alerts. Only relevant for alerts.
        """
        return pulumi.get(self, "resolve_configuration")

    @resolve_configuration.setter
    def resolve_configuration(self, value: Optional[pulumi.Input['PrometheusRuleResolveConfigurationArgs']]):
        pulumi.set(self, "resolve_configuration", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[int]]:
        """
        the severity of the alerts fired by the rule. Only relevant for alerts.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "severity", value)


