# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AcsChatChannelResponse',
    'AlexaChannelPropertiesResponse',
    'AlexaChannelResponse',
    'BotPropertiesResponse',
    'ChannelSettingsResponse',
    'ConnectionSettingParameterResponse',
    'ConnectionSettingPropertiesResponse',
    'DirectLineChannelPropertiesResponse',
    'DirectLineChannelResponse',
    'DirectLineSiteResponse',
    'DirectLineSpeechChannelPropertiesResponse',
    'DirectLineSpeechChannelResponse',
    'EmailChannelPropertiesResponse',
    'EmailChannelResponse',
    'FacebookChannelPropertiesResponse',
    'FacebookChannelResponse',
    'FacebookPageResponse',
    'KikChannelPropertiesResponse',
    'KikChannelResponse',
    'LineChannelPropertiesResponse',
    'LineChannelResponse',
    'LineRegistrationResponse',
    'M365ExtensionsResponse',
    'MsTeamsChannelPropertiesResponse',
    'MsTeamsChannelResponse',
    'OmnichannelResponse',
    'OutlookChannelResponse',
    'SearchAssistantResponse',
    'ServiceProviderParameterResponse',
    'ServiceProviderParameterResponseConstraints',
    'ServiceProviderParameterResponseMetadata',
    'ServiceProviderPropertiesResponse',
    'ServiceProviderResponse',
    'SiteResponse',
    'SkuResponse',
    'SkypeChannelPropertiesResponse',
    'SkypeChannelResponse',
    'SlackChannelPropertiesResponse',
    'SlackChannelResponse',
    'SmsChannelPropertiesResponse',
    'SmsChannelResponse',
    'TelegramChannelPropertiesResponse',
    'TelegramChannelResponse',
    'TelephonyChannelPropertiesResponse',
    'TelephonyChannelResourceApiConfigurationResponse',
    'TelephonyChannelResponse',
    'TelephonyPhoneNumbersResponse',
    'WebChatChannelPropertiesResponse',
    'WebChatChannelResponse',
    'WebChatSiteResponse',
]

@pulumi.output_type
class AcsChatChannelResponse(dict):
    """
    AcsChat channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AcsChatChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AcsChatChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AcsChatChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None):
        """
        AcsChat channel definition
        :param str channel_name: The channel name
               Expected value is 'AcsChatChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        """
        pulumi.set(__self__, "channel_name", 'AcsChatChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'AcsChatChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class AlexaChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Alexa channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alexaSkillId":
            suggest = "alexa_skill_id"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "serviceEndpointUri":
            suggest = "service_endpoint_uri"
        elif key == "urlFragment":
            suggest = "url_fragment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlexaChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlexaChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlexaChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alexa_skill_id: str,
                 is_enabled: bool,
                 service_endpoint_uri: str,
                 url_fragment: str):
        """
        The parameters to provide for the Alexa channel.
        :param str alexa_skill_id: The Alexa skill Id
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str service_endpoint_uri: Full Uri used to configured the skill in Alexa
        :param str url_fragment: Url fragment used in part of the Uri configured in Alexa
        """
        pulumi.set(__self__, "alexa_skill_id", alexa_skill_id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "service_endpoint_uri", service_endpoint_uri)
        pulumi.set(__self__, "url_fragment", url_fragment)

    @property
    @pulumi.getter(name="alexaSkillId")
    def alexa_skill_id(self) -> str:
        """
        The Alexa skill Id
        """
        return pulumi.get(self, "alexa_skill_id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="serviceEndpointUri")
    def service_endpoint_uri(self) -> str:
        """
        Full Uri used to configured the skill in Alexa
        """
        return pulumi.get(self, "service_endpoint_uri")

    @property
    @pulumi.getter(name="urlFragment")
    def url_fragment(self) -> str:
        """
        Url fragment used in part of the Uri configured in Alexa
        """
        return pulumi.get(self, "url_fragment")


@pulumi.output_type
class AlexaChannelResponse(dict):
    """
    Alexa channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlexaChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlexaChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlexaChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.AlexaChannelPropertiesResponse'] = None):
        """
        Alexa channel definition
        :param str channel_name: The channel name
               Expected value is 'AlexaChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'AlexaChannelPropertiesResponse' properties: The set of properties specific to Alexa channel resource
        """
        pulumi.set(__self__, "channel_name", 'AlexaChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'AlexaChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.AlexaChannelPropertiesResponse']:
        """
        The set of properties specific to Alexa channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class BotPropertiesResponse(dict):
    """
    The parameters to provide for the Bot.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cmekEncryptionStatus":
            suggest = "cmek_encryption_status"
        elif key == "configuredChannels":
            suggest = "configured_channels"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "enabledChannels":
            suggest = "enabled_channels"
        elif key == "endpointVersion":
            suggest = "endpoint_version"
        elif key == "isDeveloperAppInsightsApiKeySet":
            suggest = "is_developer_app_insights_api_key_set"
        elif key == "migrationToken":
            suggest = "migration_token"
        elif key == "msaAppId":
            suggest = "msa_app_id"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "allSettings":
            suggest = "all_settings"
        elif key == "appPasswordHint":
            suggest = "app_password_hint"
        elif key == "cmekKeyVaultUrl":
            suggest = "cmek_key_vault_url"
        elif key == "developerAppInsightKey":
            suggest = "developer_app_insight_key"
        elif key == "developerAppInsightsApiKey":
            suggest = "developer_app_insights_api_key"
        elif key == "developerAppInsightsApplicationId":
            suggest = "developer_app_insights_application_id"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "iconUrl":
            suggest = "icon_url"
        elif key == "isCmekEnabled":
            suggest = "is_cmek_enabled"
        elif key == "isStreamingSupported":
            suggest = "is_streaming_supported"
        elif key == "luisAppIds":
            suggest = "luis_app_ids"
        elif key == "luisKey":
            suggest = "luis_key"
        elif key == "manifestUrl":
            suggest = "manifest_url"
        elif key == "msaAppMSIResourceId":
            suggest = "msa_app_msi_resource_id"
        elif key == "msaAppTenantId":
            suggest = "msa_app_tenant_id"
        elif key == "msaAppType":
            suggest = "msa_app_type"
        elif key == "openWithHint":
            suggest = "open_with_hint"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"
        elif key == "publishingCredentials":
            suggest = "publishing_credentials"
        elif key == "schemaTransformationVersion":
            suggest = "schema_transformation_version"
        elif key == "storageResourceId":
            suggest = "storage_resource_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BotPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BotPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BotPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cmek_encryption_status: str,
                 configured_channels: Sequence[str],
                 display_name: str,
                 enabled_channels: Sequence[str],
                 endpoint: str,
                 endpoint_version: str,
                 is_developer_app_insights_api_key_set: bool,
                 migration_token: str,
                 msa_app_id: str,
                 provisioning_state: str,
                 all_settings: Optional[Mapping[str, str]] = None,
                 app_password_hint: Optional[str] = None,
                 cmek_key_vault_url: Optional[str] = None,
                 description: Optional[str] = None,
                 developer_app_insight_key: Optional[str] = None,
                 developer_app_insights_api_key: Optional[str] = None,
                 developer_app_insights_application_id: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 icon_url: Optional[str] = None,
                 is_cmek_enabled: Optional[bool] = None,
                 is_streaming_supported: Optional[bool] = None,
                 luis_app_ids: Optional[Sequence[str]] = None,
                 luis_key: Optional[str] = None,
                 manifest_url: Optional[str] = None,
                 msa_app_msi_resource_id: Optional[str] = None,
                 msa_app_tenant_id: Optional[str] = None,
                 msa_app_type: Optional[str] = None,
                 open_with_hint: Optional[str] = None,
                 parameters: Optional[Mapping[str, str]] = None,
                 public_network_access: Optional[str] = None,
                 publishing_credentials: Optional[str] = None,
                 schema_transformation_version: Optional[str] = None,
                 storage_resource_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        The parameters to provide for the Bot.
        :param str cmek_encryption_status: The CMK encryption status
        :param Sequence[str] configured_channels: Collection of channels for which the bot is configured
        :param str display_name: The Name of the bot
        :param Sequence[str] enabled_channels: Collection of channels for which the bot is enabled
        :param str endpoint: The bot's endpoint
        :param str endpoint_version: The bot's endpoint version
        :param bool is_developer_app_insights_api_key_set: Whether the bot is developerAppInsightsApiKey set
        :param str migration_token: Token used to migrate non Azure bot to azure subscription
        :param str msa_app_id: Microsoft App Id for the bot
        :param str provisioning_state: Provisioning state of the resource
        :param Mapping[str, str] all_settings: Contains resource all settings defined as key/value pairs.
        :param str app_password_hint: The hint (e.g. keyVault secret resourceId) on how to fetch the app secret
        :param str cmek_key_vault_url: The CMK Url
        :param str description: The description of the bot
        :param str developer_app_insight_key: The Application Insights key
        :param str developer_app_insights_api_key: The Application Insights Api Key
        :param str developer_app_insights_application_id: The Application Insights App Id
        :param bool disable_local_auth: Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
        :param str icon_url: The Icon Url of the bot
        :param bool is_cmek_enabled: Whether Cmek is enabled
        :param bool is_streaming_supported: Whether the bot is streaming supported
        :param Sequence[str] luis_app_ids: Collection of LUIS App Ids
        :param str luis_key: The LUIS Key
        :param str manifest_url: The bot's manifest url
        :param str msa_app_msi_resource_id: Microsoft App Managed Identity Resource Id for the bot
        :param str msa_app_tenant_id: Microsoft App Tenant Id for the bot
        :param str msa_app_type: Microsoft App Type for the bot
        :param str open_with_hint: The hint to browser (e.g. protocol handler) on how to open the bot for authoring
        :param Mapping[str, str] parameters: Contains resource parameters defined as key/value pairs.
        :param str public_network_access: Whether the bot is in an isolated network
        :param str publishing_credentials: Publishing credentials of the resource
        :param str schema_transformation_version: The channel schema transformation version for the bot
        :param str storage_resource_id: The storage resourceId for the bot
        :param str tenant_id: The Tenant Id for the bot
        """
        pulumi.set(__self__, "cmek_encryption_status", cmek_encryption_status)
        pulumi.set(__self__, "configured_channels", configured_channels)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "enabled_channels", enabled_channels)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "endpoint_version", endpoint_version)
        pulumi.set(__self__, "is_developer_app_insights_api_key_set", is_developer_app_insights_api_key_set)
        pulumi.set(__self__, "migration_token", migration_token)
        pulumi.set(__self__, "msa_app_id", msa_app_id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if all_settings is not None:
            pulumi.set(__self__, "all_settings", all_settings)
        if app_password_hint is not None:
            pulumi.set(__self__, "app_password_hint", app_password_hint)
        if cmek_key_vault_url is not None:
            pulumi.set(__self__, "cmek_key_vault_url", cmek_key_vault_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if developer_app_insight_key is not None:
            pulumi.set(__self__, "developer_app_insight_key", developer_app_insight_key)
        if developer_app_insights_api_key is not None:
            pulumi.set(__self__, "developer_app_insights_api_key", developer_app_insights_api_key)
        if developer_app_insights_application_id is not None:
            pulumi.set(__self__, "developer_app_insights_application_id", developer_app_insights_application_id)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if icon_url is None:
            icon_url = ''
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if is_cmek_enabled is None:
            is_cmek_enabled = False
        if is_cmek_enabled is not None:
            pulumi.set(__self__, "is_cmek_enabled", is_cmek_enabled)
        if is_streaming_supported is None:
            is_streaming_supported = False
        if is_streaming_supported is not None:
            pulumi.set(__self__, "is_streaming_supported", is_streaming_supported)
        if luis_app_ids is not None:
            pulumi.set(__self__, "luis_app_ids", luis_app_ids)
        if luis_key is not None:
            pulumi.set(__self__, "luis_key", luis_key)
        if manifest_url is not None:
            pulumi.set(__self__, "manifest_url", manifest_url)
        if msa_app_msi_resource_id is not None:
            pulumi.set(__self__, "msa_app_msi_resource_id", msa_app_msi_resource_id)
        if msa_app_tenant_id is not None:
            pulumi.set(__self__, "msa_app_tenant_id", msa_app_tenant_id)
        if msa_app_type is not None:
            pulumi.set(__self__, "msa_app_type", msa_app_type)
        if open_with_hint is not None:
            pulumi.set(__self__, "open_with_hint", open_with_hint)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if public_network_access is None:
            public_network_access = 'Enabled'
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if publishing_credentials is not None:
            pulumi.set(__self__, "publishing_credentials", publishing_credentials)
        if schema_transformation_version is not None:
            pulumi.set(__self__, "schema_transformation_version", schema_transformation_version)
        if storage_resource_id is not None:
            pulumi.set(__self__, "storage_resource_id", storage_resource_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="cmekEncryptionStatus")
    def cmek_encryption_status(self) -> str:
        """
        The CMK encryption status
        """
        return pulumi.get(self, "cmek_encryption_status")

    @property
    @pulumi.getter(name="configuredChannels")
    def configured_channels(self) -> Sequence[str]:
        """
        Collection of channels for which the bot is configured
        """
        return pulumi.get(self, "configured_channels")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The Name of the bot
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enabledChannels")
    def enabled_channels(self) -> Sequence[str]:
        """
        Collection of channels for which the bot is enabled
        """
        return pulumi.get(self, "enabled_channels")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The bot's endpoint
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="endpointVersion")
    def endpoint_version(self) -> str:
        """
        The bot's endpoint version
        """
        return pulumi.get(self, "endpoint_version")

    @property
    @pulumi.getter(name="isDeveloperAppInsightsApiKeySet")
    def is_developer_app_insights_api_key_set(self) -> bool:
        """
        Whether the bot is developerAppInsightsApiKey set
        """
        return pulumi.get(self, "is_developer_app_insights_api_key_set")

    @property
    @pulumi.getter(name="migrationToken")
    def migration_token(self) -> str:
        """
        Token used to migrate non Azure bot to azure subscription
        """
        return pulumi.get(self, "migration_token")

    @property
    @pulumi.getter(name="msaAppId")
    def msa_app_id(self) -> str:
        """
        Microsoft App Id for the bot
        """
        return pulumi.get(self, "msa_app_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="allSettings")
    def all_settings(self) -> Optional[Mapping[str, str]]:
        """
        Contains resource all settings defined as key/value pairs.
        """
        return pulumi.get(self, "all_settings")

    @property
    @pulumi.getter(name="appPasswordHint")
    def app_password_hint(self) -> Optional[str]:
        """
        The hint (e.g. keyVault secret resourceId) on how to fetch the app secret
        """
        return pulumi.get(self, "app_password_hint")

    @property
    @pulumi.getter(name="cmekKeyVaultUrl")
    def cmek_key_vault_url(self) -> Optional[str]:
        """
        The CMK Url
        """
        return pulumi.get(self, "cmek_key_vault_url")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the bot
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="developerAppInsightKey")
    def developer_app_insight_key(self) -> Optional[str]:
        """
        The Application Insights key
        """
        return pulumi.get(self, "developer_app_insight_key")

    @property
    @pulumi.getter(name="developerAppInsightsApiKey")
    def developer_app_insights_api_key(self) -> Optional[str]:
        """
        The Application Insights Api Key
        """
        return pulumi.get(self, "developer_app_insights_api_key")

    @property
    @pulumi.getter(name="developerAppInsightsApplicationId")
    def developer_app_insights_application_id(self) -> Optional[str]:
        """
        The Application Insights App Id
        """
        return pulumi.get(self, "developer_app_insights_application_id")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[str]:
        """
        The Icon Url of the bot
        """
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter(name="isCmekEnabled")
    def is_cmek_enabled(self) -> Optional[bool]:
        """
        Whether Cmek is enabled
        """
        return pulumi.get(self, "is_cmek_enabled")

    @property
    @pulumi.getter(name="isStreamingSupported")
    def is_streaming_supported(self) -> Optional[bool]:
        """
        Whether the bot is streaming supported
        """
        return pulumi.get(self, "is_streaming_supported")

    @property
    @pulumi.getter(name="luisAppIds")
    def luis_app_ids(self) -> Optional[Sequence[str]]:
        """
        Collection of LUIS App Ids
        """
        return pulumi.get(self, "luis_app_ids")

    @property
    @pulumi.getter(name="luisKey")
    def luis_key(self) -> Optional[str]:
        """
        The LUIS Key
        """
        return pulumi.get(self, "luis_key")

    @property
    @pulumi.getter(name="manifestUrl")
    def manifest_url(self) -> Optional[str]:
        """
        The bot's manifest url
        """
        return pulumi.get(self, "manifest_url")

    @property
    @pulumi.getter(name="msaAppMSIResourceId")
    def msa_app_msi_resource_id(self) -> Optional[str]:
        """
        Microsoft App Managed Identity Resource Id for the bot
        """
        return pulumi.get(self, "msa_app_msi_resource_id")

    @property
    @pulumi.getter(name="msaAppTenantId")
    def msa_app_tenant_id(self) -> Optional[str]:
        """
        Microsoft App Tenant Id for the bot
        """
        return pulumi.get(self, "msa_app_tenant_id")

    @property
    @pulumi.getter(name="msaAppType")
    def msa_app_type(self) -> Optional[str]:
        """
        Microsoft App Type for the bot
        """
        return pulumi.get(self, "msa_app_type")

    @property
    @pulumi.getter(name="openWithHint")
    def open_with_hint(self) -> Optional[str]:
        """
        The hint to browser (e.g. protocol handler) on how to open the bot for authoring
        """
        return pulumi.get(self, "open_with_hint")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, str]]:
        """
        Contains resource parameters defined as key/value pairs.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        Whether the bot is in an isolated network
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter(name="publishingCredentials")
    def publishing_credentials(self) -> Optional[str]:
        """
        Publishing credentials of the resource
        """
        return pulumi.get(self, "publishing_credentials")

    @property
    @pulumi.getter(name="schemaTransformationVersion")
    def schema_transformation_version(self) -> Optional[str]:
        """
        The channel schema transformation version for the bot
        """
        return pulumi.get(self, "schema_transformation_version")

    @property
    @pulumi.getter(name="storageResourceId")
    def storage_resource_id(self) -> Optional[str]:
        """
        The storage resourceId for the bot
        """
        return pulumi.get(self, "storage_resource_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The Tenant Id for the bot
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ChannelSettingsResponse(dict):
    """
    Channel settings definition
    """
    def __init__(__self__, *,
                 bot_icon_url: Optional[str] = None,
                 bot_id: Optional[str] = None,
                 channel_display_name: Optional[str] = None,
                 channel_id: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 extension_key1: Optional[str] = None,
                 extension_key2: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 require_terms_agreement: Optional[bool] = None,
                 sites: Optional[Sequence['outputs.SiteResponse']] = None):
        """
        Channel settings definition
        :param str bot_icon_url: The bot icon url
        :param str bot_id: The bot id
        :param str channel_display_name: The channel display name
        :param str channel_id: The channel id
        :param bool disable_local_auth: Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
        :param str extension_key1: The extensionKey1
        :param str extension_key2: The extensionKey2
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param bool require_terms_agreement: Whether customer needs to agree to new terms.
        :param Sequence['SiteResponse'] sites: The list of sites
        """
        if bot_icon_url is not None:
            pulumi.set(__self__, "bot_icon_url", bot_icon_url)
        if bot_id is not None:
            pulumi.set(__self__, "bot_id", bot_id)
        if channel_display_name is not None:
            pulumi.set(__self__, "channel_display_name", channel_display_name)
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if extension_key1 is None:
            extension_key1 = ''
        if extension_key1 is not None:
            pulumi.set(__self__, "extension_key1", extension_key1)
        if extension_key2 is None:
            extension_key2 = ''
        if extension_key2 is not None:
            pulumi.set(__self__, "extension_key2", extension_key2)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if require_terms_agreement is not None:
            pulumi.set(__self__, "require_terms_agreement", require_terms_agreement)
        if sites is not None:
            pulumi.set(__self__, "sites", sites)

    @property
    @pulumi.getter(name="botIconUrl")
    def bot_icon_url(self) -> Optional[str]:
        """
        The bot icon url
        """
        return pulumi.get(self, "bot_icon_url")

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> Optional[str]:
        """
        The bot id
        """
        return pulumi.get(self, "bot_id")

    @property
    @pulumi.getter(name="channelDisplayName")
    def channel_display_name(self) -> Optional[str]:
        """
        The channel display name
        """
        return pulumi.get(self, "channel_display_name")

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[str]:
        """
        The channel id
        """
        return pulumi.get(self, "channel_id")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter(name="extensionKey1")
    def extension_key1(self) -> Optional[str]:
        """
        The extensionKey1
        """
        return pulumi.get(self, "extension_key1")

    @property
    @pulumi.getter(name="extensionKey2")
    def extension_key2(self) -> Optional[str]:
        """
        The extensionKey2
        """
        return pulumi.get(self, "extension_key2")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="requireTermsAgreement")
    def require_terms_agreement(self) -> Optional[bool]:
        """
        Whether customer needs to agree to new terms.
        """
        return pulumi.get(self, "require_terms_agreement")

    @property
    @pulumi.getter
    def sites(self) -> Optional[Sequence['outputs.SiteResponse']]:
        """
        The list of sites
        """
        return pulumi.get(self, "sites")


@pulumi.output_type
class ConnectionSettingParameterResponse(dict):
    """
    Extra Parameter in a Connection Setting Properties to indicate service provider specific properties
    """
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Extra Parameter in a Connection Setting Properties to indicate service provider specific properties
        :param str key: Key for the Connection Setting Parameter.
        :param str value: Value associated with the Connection Setting Parameter.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Key for the Connection Setting Parameter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value associated with the Connection Setting Parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectionSettingPropertiesResponse(dict):
    """
    Properties for a Connection Setting Item
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "settingId":
            suggest = "setting_id"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "serviceProviderDisplayName":
            suggest = "service_provider_display_name"
        elif key == "serviceProviderId":
            suggest = "service_provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSettingPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSettingPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSettingPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 setting_id: str,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 parameters: Optional[Sequence['outputs.ConnectionSettingParameterResponse']] = None,
                 provisioning_state: Optional[str] = None,
                 scopes: Optional[str] = None,
                 service_provider_display_name: Optional[str] = None,
                 service_provider_id: Optional[str] = None):
        """
        Properties for a Connection Setting Item
        :param str setting_id: Setting Id set by the service for the Connection Setting.
        :param str client_id: Client Id associated with the Connection Setting.
        :param str client_secret: Client Secret associated with the Connection Setting
        :param Sequence['ConnectionSettingParameterResponse'] parameters: Service Provider Parameters associated with the Connection Setting
        :param str provisioning_state: Provisioning state of the resource
        :param str scopes: Scopes associated with the Connection Setting
        :param str service_provider_display_name: Service Provider Display Name associated with the Connection Setting
        :param str service_provider_id: Service Provider Id associated with the Connection Setting
        """
        pulumi.set(__self__, "setting_id", setting_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if scopes is None:
            scopes = ''
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if service_provider_display_name is not None:
            pulumi.set(__self__, "service_provider_display_name", service_provider_display_name)
        if service_provider_id is not None:
            pulumi.set(__self__, "service_provider_id", service_provider_id)

    @property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> str:
        """
        Setting Id set by the service for the Connection Setting.
        """
        return pulumi.get(self, "setting_id")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Client Id associated with the Connection Setting.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        Client Secret associated with the Connection Setting
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ConnectionSettingParameterResponse']]:
        """
        Service Provider Parameters associated with the Connection Setting
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[str]:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[str]:
        """
        Scopes associated with the Connection Setting
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="serviceProviderDisplayName")
    def service_provider_display_name(self) -> Optional[str]:
        """
        Service Provider Display Name associated with the Connection Setting
        """
        return pulumi.get(self, "service_provider_display_name")

    @property
    @pulumi.getter(name="serviceProviderId")
    def service_provider_id(self) -> Optional[str]:
        """
        Service Provider Id associated with the Connection Setting
        """
        return pulumi.get(self, "service_provider_id")


@pulumi.output_type
class DirectLineChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Direct Line channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directLineEmbedCode":
            suggest = "direct_line_embed_code"
        elif key == "extensionKey1":
            suggest = "extension_key1"
        elif key == "extensionKey2":
            suggest = "extension_key2"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectLineChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectLineChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectLineChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 direct_line_embed_code: Optional[str] = None,
                 extension_key1: Optional[str] = None,
                 extension_key2: Optional[str] = None,
                 sites: Optional[Sequence['outputs.DirectLineSiteResponse']] = None):
        """
        The parameters to provide for the Direct Line channel.
        :param str direct_line_embed_code: Direct Line embed code of the resource
        :param str extension_key1: The extensionKey1
        :param str extension_key2: The extensionKey2
        :param Sequence['DirectLineSiteResponse'] sites: The list of Direct Line sites
        """
        if direct_line_embed_code is not None:
            pulumi.set(__self__, "direct_line_embed_code", direct_line_embed_code)
        if extension_key1 is None:
            extension_key1 = ''
        if extension_key1 is not None:
            pulumi.set(__self__, "extension_key1", extension_key1)
        if extension_key2 is None:
            extension_key2 = ''
        if extension_key2 is not None:
            pulumi.set(__self__, "extension_key2", extension_key2)
        if sites is not None:
            pulumi.set(__self__, "sites", sites)

    @property
    @pulumi.getter(name="directLineEmbedCode")
    def direct_line_embed_code(self) -> Optional[str]:
        """
        Direct Line embed code of the resource
        """
        return pulumi.get(self, "direct_line_embed_code")

    @property
    @pulumi.getter(name="extensionKey1")
    def extension_key1(self) -> Optional[str]:
        """
        The extensionKey1
        """
        return pulumi.get(self, "extension_key1")

    @property
    @pulumi.getter(name="extensionKey2")
    def extension_key2(self) -> Optional[str]:
        """
        The extensionKey2
        """
        return pulumi.get(self, "extension_key2")

    @property
    @pulumi.getter
    def sites(self) -> Optional[Sequence['outputs.DirectLineSiteResponse']]:
        """
        The list of Direct Line sites
        """
        return pulumi.get(self, "sites")


@pulumi.output_type
class DirectLineChannelResponse(dict):
    """
    Direct Line channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectLineChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectLineChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectLineChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.DirectLineChannelPropertiesResponse'] = None):
        """
        Direct Line channel definition
        :param str channel_name: The channel name
               Expected value is 'DirectLineChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'DirectLineChannelPropertiesResponse' properties: The set of properties specific to Direct Line channel resource
        """
        pulumi.set(__self__, "channel_name", 'DirectLineChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'DirectLineChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.DirectLineChannelPropertiesResponse']:
        """
        The set of properties specific to Direct Line channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class DirectLineSiteResponse(dict):
    """
    A site for the Direct Line channel
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "isTokenEnabled":
            suggest = "is_token_enabled"
        elif key == "isV1Enabled":
            suggest = "is_v1_enabled"
        elif key == "isV3Enabled":
            suggest = "is_v3_enabled"
        elif key == "siteId":
            suggest = "site_id"
        elif key == "siteName":
            suggest = "site_name"
        elif key == "appId":
            suggest = "app_id"
        elif key == "eTag":
            suggest = "e_tag"
        elif key == "isBlockUserUploadEnabled":
            suggest = "is_block_user_upload_enabled"
        elif key == "isDetailedLoggingEnabled":
            suggest = "is_detailed_logging_enabled"
        elif key == "isEndpointParametersEnabled":
            suggest = "is_endpoint_parameters_enabled"
        elif key == "isNoStorageEnabled":
            suggest = "is_no_storage_enabled"
        elif key == "isSecureSiteEnabled":
            suggest = "is_secure_site_enabled"
        elif key == "isWebChatSpeechEnabled":
            suggest = "is_web_chat_speech_enabled"
        elif key == "isWebchatPreviewEnabled":
            suggest = "is_webchat_preview_enabled"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "trustedOrigins":
            suggest = "trusted_origins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectLineSiteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectLineSiteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectLineSiteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 is_token_enabled: bool,
                 is_v1_enabled: bool,
                 is_v3_enabled: bool,
                 key: str,
                 key2: str,
                 site_id: str,
                 site_name: str,
                 app_id: Optional[str] = None,
                 e_tag: Optional[str] = None,
                 is_block_user_upload_enabled: Optional[bool] = None,
                 is_detailed_logging_enabled: Optional[bool] = None,
                 is_endpoint_parameters_enabled: Optional[bool] = None,
                 is_no_storage_enabled: Optional[bool] = None,
                 is_secure_site_enabled: Optional[bool] = None,
                 is_web_chat_speech_enabled: Optional[bool] = None,
                 is_webchat_preview_enabled: Optional[bool] = None,
                 tenant_id: Optional[str] = None,
                 trusted_origins: Optional[Sequence[str]] = None):
        """
        A site for the Direct Line channel
        :param bool is_enabled: Whether this site is enabled for DirectLine channel
        :param bool is_token_enabled: Whether this site is token enabled for channel
        :param bool is_v1_enabled: Whether this site is enabled for Bot Framework V1 protocol.
        :param bool is_v3_enabled: Whether this site is enabled for Bot Framework V3 protocol.
        :param str key: Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str key2: Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str site_id: Site Id
        :param str site_name: Site name
        :param str app_id: DirectLine application id
        :param str e_tag: Entity Tag
        :param bool is_block_user_upload_enabled: Whether this site is enabled for block user upload.
        :param bool is_detailed_logging_enabled: Whether this site is disabled detailed logging for
        :param bool is_endpoint_parameters_enabled: Whether this site is EndpointParameters enabled for channel
        :param bool is_no_storage_enabled: Whether this no-storage site is disabled detailed logging for
        :param bool is_secure_site_enabled: Whether this site is enabled for authentication with Bot Framework.
        :param bool is_web_chat_speech_enabled: Whether this site is enabled for Webchat Speech
        :param bool is_webchat_preview_enabled: Whether this site is enabled for preview versions of Webchat
        :param str tenant_id: Tenant Id
        :param Sequence[str] trusted_origins: List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "is_token_enabled", is_token_enabled)
        pulumi.set(__self__, "is_v1_enabled", is_v1_enabled)
        pulumi.set(__self__, "is_v3_enabled", is_v3_enabled)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "key2", key2)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "site_name", site_name)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if is_block_user_upload_enabled is not None:
            pulumi.set(__self__, "is_block_user_upload_enabled", is_block_user_upload_enabled)
        if is_detailed_logging_enabled is not None:
            pulumi.set(__self__, "is_detailed_logging_enabled", is_detailed_logging_enabled)
        if is_endpoint_parameters_enabled is not None:
            pulumi.set(__self__, "is_endpoint_parameters_enabled", is_endpoint_parameters_enabled)
        if is_no_storage_enabled is not None:
            pulumi.set(__self__, "is_no_storage_enabled", is_no_storage_enabled)
        if is_secure_site_enabled is not None:
            pulumi.set(__self__, "is_secure_site_enabled", is_secure_site_enabled)
        if is_web_chat_speech_enabled is None:
            is_web_chat_speech_enabled = False
        if is_web_chat_speech_enabled is not None:
            pulumi.set(__self__, "is_web_chat_speech_enabled", is_web_chat_speech_enabled)
        if is_webchat_preview_enabled is None:
            is_webchat_preview_enabled = False
        if is_webchat_preview_enabled is not None:
            pulumi.set(__self__, "is_webchat_preview_enabled", is_webchat_preview_enabled)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if trusted_origins is not None:
            pulumi.set(__self__, "trusted_origins", trusted_origins)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this site is enabled for DirectLine channel
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isTokenEnabled")
    def is_token_enabled(self) -> bool:
        """
        Whether this site is token enabled for channel
        """
        return pulumi.get(self, "is_token_enabled")

    @property
    @pulumi.getter(name="isV1Enabled")
    def is_v1_enabled(self) -> bool:
        """
        Whether this site is enabled for Bot Framework V1 protocol.
        """
        return pulumi.get(self, "is_v1_enabled")

    @property
    @pulumi.getter(name="isV3Enabled")
    def is_v3_enabled(self) -> bool:
        """
        Whether this site is enabled for Bot Framework V3 protocol.
        """
        return pulumi.get(self, "is_v3_enabled")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def key2(self) -> str:
        """
        Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "key2")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> str:
        """
        Site name
        """
        return pulumi.get(self, "site_name")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        DirectLine application id
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[str]:
        """
        Entity Tag
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter(name="isBlockUserUploadEnabled")
    def is_block_user_upload_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for block user upload.
        """
        return pulumi.get(self, "is_block_user_upload_enabled")

    @property
    @pulumi.getter(name="isDetailedLoggingEnabled")
    def is_detailed_logging_enabled(self) -> Optional[bool]:
        """
        Whether this site is disabled detailed logging for
        """
        return pulumi.get(self, "is_detailed_logging_enabled")

    @property
    @pulumi.getter(name="isEndpointParametersEnabled")
    def is_endpoint_parameters_enabled(self) -> Optional[bool]:
        """
        Whether this site is EndpointParameters enabled for channel
        """
        return pulumi.get(self, "is_endpoint_parameters_enabled")

    @property
    @pulumi.getter(name="isNoStorageEnabled")
    def is_no_storage_enabled(self) -> Optional[bool]:
        """
        Whether this no-storage site is disabled detailed logging for
        """
        return pulumi.get(self, "is_no_storage_enabled")

    @property
    @pulumi.getter(name="isSecureSiteEnabled")
    def is_secure_site_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for authentication with Bot Framework.
        """
        return pulumi.get(self, "is_secure_site_enabled")

    @property
    @pulumi.getter(name="isWebChatSpeechEnabled")
    def is_web_chat_speech_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for Webchat Speech
        """
        return pulumi.get(self, "is_web_chat_speech_enabled")

    @property
    @pulumi.getter(name="isWebchatPreviewEnabled")
    def is_webchat_preview_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for preview versions of Webchat
        """
        return pulumi.get(self, "is_webchat_preview_enabled")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="trustedOrigins")
    def trusted_origins(self) -> Optional[Sequence[str]]:
        """
        List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
        """
        return pulumi.get(self, "trusted_origins")


@pulumi.output_type
class DirectLineSpeechChannelPropertiesResponse(dict):
    """
    The parameters to provide for the DirectLine Speech channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cognitiveServiceRegion":
            suggest = "cognitive_service_region"
        elif key == "cognitiveServiceResourceId":
            suggest = "cognitive_service_resource_id"
        elif key == "cognitiveServiceSubscriptionKey":
            suggest = "cognitive_service_subscription_key"
        elif key == "customSpeechModelId":
            suggest = "custom_speech_model_id"
        elif key == "customVoiceDeploymentId":
            suggest = "custom_voice_deployment_id"
        elif key == "isDefaultBotForCogSvcAccount":
            suggest = "is_default_bot_for_cog_svc_account"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectLineSpeechChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectLineSpeechChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectLineSpeechChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cognitive_service_region: Optional[str] = None,
                 cognitive_service_resource_id: Optional[str] = None,
                 cognitive_service_subscription_key: Optional[str] = None,
                 custom_speech_model_id: Optional[str] = None,
                 custom_voice_deployment_id: Optional[str] = None,
                 is_default_bot_for_cog_svc_account: Optional[bool] = None,
                 is_enabled: Optional[bool] = None):
        """
        The parameters to provide for the DirectLine Speech channel.
        :param str cognitive_service_region: The cognitive service region with this channel registration.
        :param str cognitive_service_resource_id: The cognitive service id with this channel registration.
        :param str cognitive_service_subscription_key: The cognitive service subscription key to use with this channel registration.
        :param str custom_speech_model_id: Custom voice deployment id (optional).
        :param str custom_voice_deployment_id: Custom speech model id (optional).
        :param bool is_default_bot_for_cog_svc_account: Make this a default bot for chosen cognitive service account.
        :param bool is_enabled: Whether this channel is enabled or not.
        """
        if cognitive_service_region is not None:
            pulumi.set(__self__, "cognitive_service_region", cognitive_service_region)
        if cognitive_service_resource_id is not None:
            pulumi.set(__self__, "cognitive_service_resource_id", cognitive_service_resource_id)
        if cognitive_service_subscription_key is not None:
            pulumi.set(__self__, "cognitive_service_subscription_key", cognitive_service_subscription_key)
        if custom_speech_model_id is not None:
            pulumi.set(__self__, "custom_speech_model_id", custom_speech_model_id)
        if custom_voice_deployment_id is not None:
            pulumi.set(__self__, "custom_voice_deployment_id", custom_voice_deployment_id)
        if is_default_bot_for_cog_svc_account is not None:
            pulumi.set(__self__, "is_default_bot_for_cog_svc_account", is_default_bot_for_cog_svc_account)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="cognitiveServiceRegion")
    def cognitive_service_region(self) -> Optional[str]:
        """
        The cognitive service region with this channel registration.
        """
        return pulumi.get(self, "cognitive_service_region")

    @property
    @pulumi.getter(name="cognitiveServiceResourceId")
    def cognitive_service_resource_id(self) -> Optional[str]:
        """
        The cognitive service id with this channel registration.
        """
        return pulumi.get(self, "cognitive_service_resource_id")

    @property
    @pulumi.getter(name="cognitiveServiceSubscriptionKey")
    def cognitive_service_subscription_key(self) -> Optional[str]:
        """
        The cognitive service subscription key to use with this channel registration.
        """
        return pulumi.get(self, "cognitive_service_subscription_key")

    @property
    @pulumi.getter(name="customSpeechModelId")
    def custom_speech_model_id(self) -> Optional[str]:
        """
        Custom voice deployment id (optional).
        """
        return pulumi.get(self, "custom_speech_model_id")

    @property
    @pulumi.getter(name="customVoiceDeploymentId")
    def custom_voice_deployment_id(self) -> Optional[str]:
        """
        Custom speech model id (optional).
        """
        return pulumi.get(self, "custom_voice_deployment_id")

    @property
    @pulumi.getter(name="isDefaultBotForCogSvcAccount")
    def is_default_bot_for_cog_svc_account(self) -> Optional[bool]:
        """
        Make this a default bot for chosen cognitive service account.
        """
        return pulumi.get(self, "is_default_bot_for_cog_svc_account")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Whether this channel is enabled or not.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class DirectLineSpeechChannelResponse(dict):
    """
    DirectLine Speech channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectLineSpeechChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectLineSpeechChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectLineSpeechChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.DirectLineSpeechChannelPropertiesResponse'] = None):
        """
        DirectLine Speech channel definition
        :param str channel_name: The channel name
               Expected value is 'DirectLineSpeechChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'DirectLineSpeechChannelPropertiesResponse' properties: The set of properties specific to DirectLine Speech channel resource
        """
        pulumi.set(__self__, "channel_name", 'DirectLineSpeechChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'DirectLineSpeechChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.DirectLineSpeechChannelPropertiesResponse']:
        """
        The set of properties specific to DirectLine Speech channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class EmailChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Email channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "authMethod":
            suggest = "auth_method"
        elif key == "magicCode":
            suggest = "magic_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: str,
                 is_enabled: bool,
                 auth_method: Optional[float] = None,
                 magic_code: Optional[str] = None,
                 password: Optional[str] = None):
        """
        The parameters to provide for the Email channel.
        :param str email_address: The email address
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param float auth_method: Email channel auth method. 0 Password (Default); 1 Graph.
        :param str magic_code: The magic code for setting up the modern authentication.
        :param str password: The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "is_enabled", is_enabled)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if magic_code is not None:
            pulumi.set(__self__, "magic_code", magic_code)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        The email address
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[float]:
        """
        Email channel auth method. 0 Password (Default); 1 Graph.
        """
        return pulumi.get(self, "auth_method")

    @property
    @pulumi.getter(name="magicCode")
    def magic_code(self) -> Optional[str]:
        """
        The magic code for setting up the modern authentication.
        """
        return pulumi.get(self, "magic_code")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class EmailChannelResponse(dict):
    """
    Email channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.EmailChannelPropertiesResponse'] = None):
        """
        Email channel definition
        :param str channel_name: The channel name
               Expected value is 'EmailChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'EmailChannelPropertiesResponse' properties: The set of properties specific to email channel resource
        """
        pulumi.set(__self__, "channel_name", 'EmailChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'EmailChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.EmailChannelPropertiesResponse']:
        """
        The set of properties specific to email channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class FacebookChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Facebook channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appId":
            suggest = "app_id"
        elif key == "callbackUrl":
            suggest = "callback_url"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "verifyToken":
            suggest = "verify_token"
        elif key == "appSecret":
            suggest = "app_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FacebookChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FacebookChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FacebookChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_id: str,
                 callback_url: str,
                 is_enabled: bool,
                 verify_token: str,
                 app_secret: Optional[str] = None,
                 pages: Optional[Sequence['outputs.FacebookPageResponse']] = None):
        """
        The parameters to provide for the Facebook channel.
        :param str app_id: Facebook application id
        :param str callback_url: Callback Url
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str verify_token: Verify token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str app_secret: Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
        :param Sequence['FacebookPageResponse'] pages: The list of Facebook pages
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "callback_url", callback_url)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "verify_token", verify_token)
        if app_secret is not None:
            pulumi.set(__self__, "app_secret", app_secret)
        if pages is not None:
            pulumi.set(__self__, "pages", pages)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> str:
        """
        Facebook application id
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> str:
        """
        Callback Url
        """
        return pulumi.get(self, "callback_url")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="verifyToken")
    def verify_token(self) -> str:
        """
        Verify token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "verify_token")

    @property
    @pulumi.getter(name="appSecret")
    def app_secret(self) -> Optional[str]:
        """
        Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "app_secret")

    @property
    @pulumi.getter
    def pages(self) -> Optional[Sequence['outputs.FacebookPageResponse']]:
        """
        The list of Facebook pages
        """
        return pulumi.get(self, "pages")


@pulumi.output_type
class FacebookChannelResponse(dict):
    """
    Facebook channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FacebookChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FacebookChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FacebookChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.FacebookChannelPropertiesResponse'] = None):
        """
        Facebook channel definition
        :param str channel_name: The channel name
               Expected value is 'FacebookChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'FacebookChannelPropertiesResponse' properties: The set of properties specific to bot facebook channel
        """
        pulumi.set(__self__, "channel_name", 'FacebookChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'FacebookChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.FacebookChannelPropertiesResponse']:
        """
        The set of properties specific to bot facebook channel
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class FacebookPageResponse(dict):
    """
    A Facebook page for Facebook channel registration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FacebookPageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FacebookPageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FacebookPageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 access_token: Optional[str] = None):
        """
        A Facebook page for Facebook channel registration
        :param str id: Page id
        :param str access_token: Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        pulumi.set(__self__, "id", id)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Page id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "access_token")


@pulumi.output_type
class KikChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Kik channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "userName":
            suggest = "user_name"
        elif key == "apiKey":
            suggest = "api_key"
        elif key == "isValidated":
            suggest = "is_validated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KikChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KikChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KikChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 user_name: str,
                 api_key: Optional[str] = None,
                 is_validated: Optional[bool] = None):
        """
        The parameters to provide for the Kik channel.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str user_name: The Kik user name
        :param str api_key: Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param bool is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "user_name", user_name)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        The Kik user name
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[bool]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")


@pulumi.output_type
class KikChannelResponse(dict):
    """
    Kik channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KikChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KikChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KikChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.KikChannelPropertiesResponse'] = None):
        """
        Kik channel definition
        :param str channel_name: The channel name
               Expected value is 'KikChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'KikChannelPropertiesResponse' properties: The set of properties specific to Kik channel resource
        """
        pulumi.set(__self__, "channel_name", 'KikChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'KikChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.KikChannelPropertiesResponse']:
        """
        The set of properties specific to Kik channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class LineChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Line channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackUrl":
            suggest = "callback_url"
        elif key == "isValidated":
            suggest = "is_validated"
        elif key == "lineRegistrations":
            suggest = "line_registrations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LineChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LineChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LineChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_url: str,
                 is_validated: bool,
                 line_registrations: Sequence['outputs.LineRegistrationResponse']):
        """
        The parameters to provide for the Line channel.
        :param str callback_url: Callback Url to enter in line registration.
        :param bool is_validated: Whether this channel is validated for the bot
        :param Sequence['LineRegistrationResponse'] line_registrations: The list of line channel registrations
        """
        pulumi.set(__self__, "callback_url", callback_url)
        pulumi.set(__self__, "is_validated", is_validated)
        pulumi.set(__self__, "line_registrations", line_registrations)

    @property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> str:
        """
        Callback Url to enter in line registration.
        """
        return pulumi.get(self, "callback_url")

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> bool:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")

    @property
    @pulumi.getter(name="lineRegistrations")
    def line_registrations(self) -> Sequence['outputs.LineRegistrationResponse']:
        """
        The list of line channel registrations
        """
        return pulumi.get(self, "line_registrations")


@pulumi.output_type
class LineChannelResponse(dict):
    """
    Line channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LineChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LineChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LineChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.LineChannelPropertiesResponse'] = None):
        """
        Line channel definition
        :param str channel_name: The channel name
               Expected value is 'LineChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'LineChannelPropertiesResponse' properties: The set of properties specific to line channel resource
        """
        pulumi.set(__self__, "channel_name", 'LineChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'LineChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.LineChannelPropertiesResponse']:
        """
        The set of properties specific to line channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class LineRegistrationResponse(dict):
    """
    The properties corresponding to a line channel registration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generatedId":
            suggest = "generated_id"
        elif key == "channelAccessToken":
            suggest = "channel_access_token"
        elif key == "channelSecret":
            suggest = "channel_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LineRegistrationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LineRegistrationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LineRegistrationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generated_id: str,
                 channel_access_token: Optional[str] = None,
                 channel_secret: Optional[str] = None):
        """
        The properties corresponding to a line channel registration
        :param str generated_id: Id generated for the line channel registration
        :param str channel_access_token: Access token for the line channel registration
        :param str channel_secret: Secret for the line channel registration
        """
        pulumi.set(__self__, "generated_id", generated_id)
        if channel_access_token is not None:
            pulumi.set(__self__, "channel_access_token", channel_access_token)
        if channel_secret is not None:
            pulumi.set(__self__, "channel_secret", channel_secret)

    @property
    @pulumi.getter(name="generatedId")
    def generated_id(self) -> str:
        """
        Id generated for the line channel registration
        """
        return pulumi.get(self, "generated_id")

    @property
    @pulumi.getter(name="channelAccessToken")
    def channel_access_token(self) -> Optional[str]:
        """
        Access token for the line channel registration
        """
        return pulumi.get(self, "channel_access_token")

    @property
    @pulumi.getter(name="channelSecret")
    def channel_secret(self) -> Optional[str]:
        """
        Secret for the line channel registration
        """
        return pulumi.get(self, "channel_secret")


@pulumi.output_type
class M365ExtensionsResponse(dict):
    """
    M365 Extensions definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in M365ExtensionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        M365ExtensionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        M365ExtensionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None):
        """
        M365 Extensions definition
        :param str channel_name: The channel name
               Expected value is 'M365Extensions'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        """
        pulumi.set(__self__, "channel_name", 'M365Extensions')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'M365Extensions'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class MsTeamsChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Microsoft Teams channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "acceptedTerms":
            suggest = "accepted_terms"
        elif key == "callingWebhook":
            suggest = "calling_webhook"
        elif key == "deploymentEnvironment":
            suggest = "deployment_environment"
        elif key == "enableCalling":
            suggest = "enable_calling"
        elif key == "incomingCallRoute":
            suggest = "incoming_call_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MsTeamsChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MsTeamsChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MsTeamsChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 accepted_terms: Optional[bool] = None,
                 calling_webhook: Optional[str] = None,
                 deployment_environment: Optional[str] = None,
                 enable_calling: Optional[bool] = None,
                 incoming_call_route: Optional[str] = None):
        """
        The parameters to provide for the Microsoft Teams channel.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param bool accepted_terms: Whether this channel accepted terms
        :param str calling_webhook: Webhook for Microsoft Teams channel calls
        :param str deployment_environment: Deployment environment for Microsoft Teams channel calls
        :param bool enable_calling: Enable calling for Microsoft Teams channel
        :param str incoming_call_route: Webhook for Microsoft Teams channel calls
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if accepted_terms is not None:
            pulumi.set(__self__, "accepted_terms", accepted_terms)
        if calling_webhook is not None:
            pulumi.set(__self__, "calling_webhook", calling_webhook)
        if deployment_environment is None:
            deployment_environment = 'FallbackDeploymentEnvironment'
        if deployment_environment is not None:
            pulumi.set(__self__, "deployment_environment", deployment_environment)
        if enable_calling is None:
            enable_calling = False
        if enable_calling is not None:
            pulumi.set(__self__, "enable_calling", enable_calling)
        if incoming_call_route is not None:
            pulumi.set(__self__, "incoming_call_route", incoming_call_route)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="acceptedTerms")
    def accepted_terms(self) -> Optional[bool]:
        """
        Whether this channel accepted terms
        """
        return pulumi.get(self, "accepted_terms")

    @property
    @pulumi.getter(name="callingWebhook")
    def calling_webhook(self) -> Optional[str]:
        """
        Webhook for Microsoft Teams channel calls
        """
        return pulumi.get(self, "calling_webhook")

    @property
    @pulumi.getter(name="deploymentEnvironment")
    def deployment_environment(self) -> Optional[str]:
        """
        Deployment environment for Microsoft Teams channel calls
        """
        return pulumi.get(self, "deployment_environment")

    @property
    @pulumi.getter(name="enableCalling")
    def enable_calling(self) -> Optional[bool]:
        """
        Enable calling for Microsoft Teams channel
        """
        return pulumi.get(self, "enable_calling")

    @property
    @pulumi.getter(name="incomingCallRoute")
    def incoming_call_route(self) -> Optional[str]:
        """
        Webhook for Microsoft Teams channel calls
        """
        return pulumi.get(self, "incoming_call_route")


@pulumi.output_type
class MsTeamsChannelResponse(dict):
    """
    Microsoft Teams channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MsTeamsChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MsTeamsChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MsTeamsChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.MsTeamsChannelPropertiesResponse'] = None):
        """
        Microsoft Teams channel definition
        :param str channel_name: The channel name
               Expected value is 'MsTeamsChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'MsTeamsChannelPropertiesResponse' properties: The set of properties specific to Microsoft Teams channel resource
        """
        pulumi.set(__self__, "channel_name", 'MsTeamsChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'MsTeamsChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.MsTeamsChannelPropertiesResponse']:
        """
        The set of properties specific to Microsoft Teams channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class OmnichannelResponse(dict):
    """
    Omnichannel channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OmnichannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OmnichannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OmnichannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None):
        """
        Omnichannel channel definition
        :param str channel_name: The channel name
               Expected value is 'Omnichannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        """
        pulumi.set(__self__, "channel_name", 'Omnichannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'Omnichannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class OutlookChannelResponse(dict):
    """
    Outlook channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutlookChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutlookChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutlookChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None):
        """
        Outlook channel definition
        :param str channel_name: The channel name
               Expected value is 'OutlookChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        """
        pulumi.set(__self__, "channel_name", 'OutlookChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'OutlookChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class SearchAssistantResponse(dict):
    """
    SearchAssistant definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SearchAssistantResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SearchAssistantResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SearchAssistantResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None):
        """
        SearchAssistant definition
        :param str channel_name: The channel name
               Expected value is 'SearchAssistant'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        """
        pulumi.set(__self__, "channel_name", 'SearchAssistant')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'SearchAssistant'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class ServiceProviderParameterResponse(dict):
    """
    Extra Parameters specific to each Service Provider
    """
    def __init__(__self__, *,
                 default: str,
                 description: str,
                 display_name: str,
                 help_url: str,
                 metadata: 'outputs.ServiceProviderParameterResponseMetadata',
                 name: str,
                 type: str):
        """
        Extra Parameters specific to each Service Provider
        :param str default: Default Name for the Service Provider
        :param str description: Description of the Service Provider
        :param str display_name: Display Name of the Service Provider
        :param str help_url: Help Url for the  Service Provider
        :param 'ServiceProviderParameterResponseMetadata' metadata: Meta data for the Service Provider
        :param str name: Name of the Service Provider
        :param str type: Type of the Service Provider
        """
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "help_url", help_url)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def default(self) -> str:
        """
        Default Name for the Service Provider
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Service Provider
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display Name of the Service Provider
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="helpUrl")
    def help_url(self) -> str:
        """
        Help Url for the  Service Provider
        """
        return pulumi.get(self, "help_url")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.ServiceProviderParameterResponseMetadata':
        """
        Meta data for the Service Provider
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Service Provider
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the Service Provider
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceProviderParameterResponseConstraints(dict):
    """
    the constraints of the bot meta data.
    """
    def __init__(__self__, *,
                 required: Optional[bool] = None):
        """
        the constraints of the bot meta data.
        :param bool required: Whether required the constraints of the bot meta data.
        """
        if required is not None:
            pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def required(self) -> Optional[bool]:
        """
        Whether required the constraints of the bot meta data.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class ServiceProviderParameterResponseMetadata(dict):
    """
    Meta data for the Service Provider
    """
    def __init__(__self__, *,
                 constraints: Optional['outputs.ServiceProviderParameterResponseConstraints'] = None):
        """
        Meta data for the Service Provider
        :param 'ServiceProviderParameterResponseConstraints' constraints: the constraints of the bot meta data.
        """
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)

    @property
    @pulumi.getter
    def constraints(self) -> Optional['outputs.ServiceProviderParameterResponseConstraints']:
        """
        the constraints of the bot meta data.
        """
        return pulumi.get(self, "constraints")


@pulumi.output_type
class ServiceProviderPropertiesResponse(dict):
    """
    The Object used to describe a Service Provider supported by Bot Service
    """
    def __init__(__self__, *,
                 dev_portal_url: str,
                 display_name: str,
                 id: str,
                 service_provider_name: str,
                 icon_url: Optional[str] = None,
                 parameters: Optional[Sequence['outputs.ServiceProviderParameterResponse']] = None):
        """
        The Object used to describe a Service Provider supported by Bot Service
        :param str dev_portal_url: URL of Dev Portal
        :param str display_name: Display Name of the Service Provider
        :param str id: Id for Service Provider
        :param str service_provider_name: Name of the Service Provider
        :param str icon_url: The URL of icon
        :param Sequence['ServiceProviderParameterResponse'] parameters: The list of parameters for the Service Provider
        """
        pulumi.set(__self__, "dev_portal_url", dev_portal_url)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_provider_name", service_provider_name)
        if icon_url is None:
            icon_url = ''
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="devPortalUrl")
    def dev_portal_url(self) -> str:
        """
        URL of Dev Portal
        """
        return pulumi.get(self, "dev_portal_url")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display Name of the Service Provider
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Id for Service Provider
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceProviderName")
    def service_provider_name(self) -> str:
        """
        Name of the Service Provider
        """
        return pulumi.get(self, "service_provider_name")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[str]:
        """
        The URL of icon
        """
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.ServiceProviderParameterResponse']]:
        """
        The list of parameters for the Service Provider
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class ServiceProviderResponse(dict):
    """
    Service Provider Definition
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.ServiceProviderPropertiesResponse'] = None):
        """
        Service Provider Definition
        :param 'ServiceProviderPropertiesResponse' properties: The Properties of a Service Provider Object
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.ServiceProviderPropertiesResponse']:
        """
        The Properties of a Service Provider Object
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SiteResponse(dict):
    """
    A site for the channel
    """
    def __init__(__self__, *,
                 is_enabled: bool,
                 is_token_enabled: bool,
                 key: str,
                 key2: str,
                 site_id: str,
                 site_name: str,
                 app_id: Optional[str] = None,
                 e_tag: Optional[str] = None,
                 is_block_user_upload_enabled: Optional[bool] = None,
                 is_detailed_logging_enabled: Optional[bool] = None,
                 is_endpoint_parameters_enabled: Optional[bool] = None,
                 is_no_storage_enabled: Optional[bool] = None,
                 is_secure_site_enabled: Optional[bool] = None,
                 is_v1_enabled: Optional[bool] = None,
                 is_v3_enabled: Optional[bool] = None,
                 is_web_chat_speech_enabled: Optional[bool] = None,
                 is_webchat_preview_enabled: Optional[bool] = None,
                 tenant_id: Optional[str] = None,
                 trusted_origins: Optional[Sequence[str]] = None):
        """
        A site for the channel
        :param bool is_enabled: Whether this site is enabled for DirectLine channel
        :param bool is_token_enabled: Whether this site is token enabled for channel
        :param str key: Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str key2: Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str site_id: Site Id
        :param str site_name: Site name
        :param str app_id: DirectLine application id
        :param str e_tag: Entity Tag
        :param bool is_block_user_upload_enabled: Whether this site is enabled for block user upload.
        :param bool is_detailed_logging_enabled: Whether this site is disabled detailed logging for
        :param bool is_endpoint_parameters_enabled: Whether this site is EndpointParameters enabled for channel
        :param bool is_no_storage_enabled: Whether this no-storage site is disabled detailed logging for
        :param bool is_secure_site_enabled: Whether this site is enabled for authentication with Bot Framework.
        :param bool is_v1_enabled: Whether this site is enabled for Bot Framework V1 protocol.
        :param bool is_v3_enabled: Whether this site is enabled for Bot Framework V3 protocol.
        :param bool is_web_chat_speech_enabled: Whether this site is enabled for Webchat Speech
        :param bool is_webchat_preview_enabled: Whether this site is enabled for preview versions of Webchat
        :param str tenant_id: Tenant Id
        :param Sequence[str] trusted_origins: List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "is_token_enabled", is_token_enabled)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "key2", key2)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "site_name", site_name)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if is_block_user_upload_enabled is not None:
            pulumi.set(__self__, "is_block_user_upload_enabled", is_block_user_upload_enabled)
        if is_detailed_logging_enabled is not None:
            pulumi.set(__self__, "is_detailed_logging_enabled", is_detailed_logging_enabled)
        if is_endpoint_parameters_enabled is not None:
            pulumi.set(__self__, "is_endpoint_parameters_enabled", is_endpoint_parameters_enabled)
        if is_no_storage_enabled is not None:
            pulumi.set(__self__, "is_no_storage_enabled", is_no_storage_enabled)
        if is_secure_site_enabled is not None:
            pulumi.set(__self__, "is_secure_site_enabled", is_secure_site_enabled)
        if is_v1_enabled is not None:
            pulumi.set(__self__, "is_v1_enabled", is_v1_enabled)
        if is_v3_enabled is not None:
            pulumi.set(__self__, "is_v3_enabled", is_v3_enabled)
        if is_web_chat_speech_enabled is None:
            is_web_chat_speech_enabled = False
        if is_web_chat_speech_enabled is not None:
            pulumi.set(__self__, "is_web_chat_speech_enabled", is_web_chat_speech_enabled)
        if is_webchat_preview_enabled is None:
            is_webchat_preview_enabled = False
        if is_webchat_preview_enabled is not None:
            pulumi.set(__self__, "is_webchat_preview_enabled", is_webchat_preview_enabled)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if trusted_origins is not None:
            pulumi.set(__self__, "trusted_origins", trusted_origins)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this site is enabled for DirectLine channel
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isTokenEnabled")
    def is_token_enabled(self) -> bool:
        """
        Whether this site is token enabled for channel
        """
        return pulumi.get(self, "is_token_enabled")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def key2(self) -> str:
        """
        Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "key2")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> str:
        """
        Site name
        """
        return pulumi.get(self, "site_name")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        DirectLine application id
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[str]:
        """
        Entity Tag
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter(name="isBlockUserUploadEnabled")
    def is_block_user_upload_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for block user upload.
        """
        return pulumi.get(self, "is_block_user_upload_enabled")

    @property
    @pulumi.getter(name="isDetailedLoggingEnabled")
    def is_detailed_logging_enabled(self) -> Optional[bool]:
        """
        Whether this site is disabled detailed logging for
        """
        return pulumi.get(self, "is_detailed_logging_enabled")

    @property
    @pulumi.getter(name="isEndpointParametersEnabled")
    def is_endpoint_parameters_enabled(self) -> Optional[bool]:
        """
        Whether this site is EndpointParameters enabled for channel
        """
        return pulumi.get(self, "is_endpoint_parameters_enabled")

    @property
    @pulumi.getter(name="isNoStorageEnabled")
    def is_no_storage_enabled(self) -> Optional[bool]:
        """
        Whether this no-storage site is disabled detailed logging for
        """
        return pulumi.get(self, "is_no_storage_enabled")

    @property
    @pulumi.getter(name="isSecureSiteEnabled")
    def is_secure_site_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for authentication with Bot Framework.
        """
        return pulumi.get(self, "is_secure_site_enabled")

    @property
    @pulumi.getter(name="isV1Enabled")
    def is_v1_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for Bot Framework V1 protocol.
        """
        return pulumi.get(self, "is_v1_enabled")

    @property
    @pulumi.getter(name="isV3Enabled")
    def is_v3_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for Bot Framework V3 protocol.
        """
        return pulumi.get(self, "is_v3_enabled")

    @property
    @pulumi.getter(name="isWebChatSpeechEnabled")
    def is_web_chat_speech_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for Webchat Speech
        """
        return pulumi.get(self, "is_web_chat_speech_enabled")

    @property
    @pulumi.getter(name="isWebchatPreviewEnabled")
    def is_webchat_preview_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for preview versions of Webchat
        """
        return pulumi.get(self, "is_webchat_preview_enabled")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="trustedOrigins")
    def trusted_origins(self) -> Optional[Sequence[str]]:
        """
        List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
        """
        return pulumi.get(self, "trusted_origins")


@pulumi.output_type
class SkuResponse(dict):
    """
    The SKU of the cognitive services account.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: str):
        """
        The SKU of the cognitive services account.
        :param str name: The sku name
        :param str tier: Gets the sku tier. This is based on the SKU name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The sku name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Gets the sku tier. This is based on the SKU name.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SkypeChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Microsoft Teams channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "callingWebHook":
            suggest = "calling_web_hook"
        elif key == "enableCalling":
            suggest = "enable_calling"
        elif key == "enableGroups":
            suggest = "enable_groups"
        elif key == "enableMediaCards":
            suggest = "enable_media_cards"
        elif key == "enableMessaging":
            suggest = "enable_messaging"
        elif key == "enableScreenSharing":
            suggest = "enable_screen_sharing"
        elif key == "enableVideo":
            suggest = "enable_video"
        elif key == "groupsMode":
            suggest = "groups_mode"
        elif key == "incomingCallRoute":
            suggest = "incoming_call_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkypeChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkypeChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkypeChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 calling_web_hook: Optional[str] = None,
                 enable_calling: Optional[bool] = None,
                 enable_groups: Optional[bool] = None,
                 enable_media_cards: Optional[bool] = None,
                 enable_messaging: Optional[bool] = None,
                 enable_screen_sharing: Optional[bool] = None,
                 enable_video: Optional[bool] = None,
                 groups_mode: Optional[str] = None,
                 incoming_call_route: Optional[str] = None):
        """
        The parameters to provide for the Microsoft Teams channel.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str calling_web_hook: Calling web hook for Skype channel
        :param bool enable_calling: Enable calling for Skype channel
        :param bool enable_groups: Enable groups for Skype channel
        :param bool enable_media_cards: Enable media cards for Skype channel
        :param bool enable_messaging: Enable messaging for Skype channel
        :param bool enable_screen_sharing: Enable screen sharing for Skype channel
        :param bool enable_video: Enable video for Skype channel
        :param str groups_mode: Group mode for Skype channel
        :param str incoming_call_route: Incoming call route for Skype channel
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if calling_web_hook is not None:
            pulumi.set(__self__, "calling_web_hook", calling_web_hook)
        if enable_calling is None:
            enable_calling = False
        if enable_calling is not None:
            pulumi.set(__self__, "enable_calling", enable_calling)
        if enable_groups is not None:
            pulumi.set(__self__, "enable_groups", enable_groups)
        if enable_media_cards is not None:
            pulumi.set(__self__, "enable_media_cards", enable_media_cards)
        if enable_messaging is not None:
            pulumi.set(__self__, "enable_messaging", enable_messaging)
        if enable_screen_sharing is not None:
            pulumi.set(__self__, "enable_screen_sharing", enable_screen_sharing)
        if enable_video is not None:
            pulumi.set(__self__, "enable_video", enable_video)
        if groups_mode is not None:
            pulumi.set(__self__, "groups_mode", groups_mode)
        if incoming_call_route is not None:
            pulumi.set(__self__, "incoming_call_route", incoming_call_route)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="callingWebHook")
    def calling_web_hook(self) -> Optional[str]:
        """
        Calling web hook for Skype channel
        """
        return pulumi.get(self, "calling_web_hook")

    @property
    @pulumi.getter(name="enableCalling")
    def enable_calling(self) -> Optional[bool]:
        """
        Enable calling for Skype channel
        """
        return pulumi.get(self, "enable_calling")

    @property
    @pulumi.getter(name="enableGroups")
    def enable_groups(self) -> Optional[bool]:
        """
        Enable groups for Skype channel
        """
        return pulumi.get(self, "enable_groups")

    @property
    @pulumi.getter(name="enableMediaCards")
    def enable_media_cards(self) -> Optional[bool]:
        """
        Enable media cards for Skype channel
        """
        return pulumi.get(self, "enable_media_cards")

    @property
    @pulumi.getter(name="enableMessaging")
    def enable_messaging(self) -> Optional[bool]:
        """
        Enable messaging for Skype channel
        """
        return pulumi.get(self, "enable_messaging")

    @property
    @pulumi.getter(name="enableScreenSharing")
    def enable_screen_sharing(self) -> Optional[bool]:
        """
        Enable screen sharing for Skype channel
        """
        return pulumi.get(self, "enable_screen_sharing")

    @property
    @pulumi.getter(name="enableVideo")
    def enable_video(self) -> Optional[bool]:
        """
        Enable video for Skype channel
        """
        return pulumi.get(self, "enable_video")

    @property
    @pulumi.getter(name="groupsMode")
    def groups_mode(self) -> Optional[str]:
        """
        Group mode for Skype channel
        """
        return pulumi.get(self, "groups_mode")

    @property
    @pulumi.getter(name="incomingCallRoute")
    def incoming_call_route(self) -> Optional[str]:
        """
        Incoming call route for Skype channel
        """
        return pulumi.get(self, "incoming_call_route")


@pulumi.output_type
class SkypeChannelResponse(dict):
    """
    Skype channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkypeChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkypeChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkypeChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.SkypeChannelPropertiesResponse'] = None):
        """
        Skype channel definition
        :param str channel_name: The channel name
               Expected value is 'SkypeChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'SkypeChannelPropertiesResponse' properties: The set of properties specific to Skype channel resource
        """
        pulumi.set(__self__, "channel_name", 'SkypeChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'SkypeChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.SkypeChannelPropertiesResponse']:
        """
        The set of properties specific to Skype channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SlackChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Slack channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "isValidated":
            suggest = "is_validated"
        elif key == "lastSubmissionId":
            suggest = "last_submission_id"
        elif key == "redirectAction":
            suggest = "redirect_action"
        elif key == "registerBeforeOAuthFlow":
            suggest = "register_before_o_auth_flow"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "landingPageUrl":
            suggest = "landing_page_url"
        elif key == "signingSecret":
            suggest = "signing_secret"
        elif key == "verificationToken":
            suggest = "verification_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlackChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlackChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlackChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 is_validated: bool,
                 last_submission_id: str,
                 redirect_action: str,
                 register_before_o_auth_flow: bool,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None,
                 landing_page_url: Optional[str] = None,
                 scopes: Optional[str] = None,
                 signing_secret: Optional[str] = None,
                 verification_token: Optional[str] = None):
        """
        The parameters to provide for the Slack channel.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param bool is_validated: Whether this channel is validated for the bot
        :param str last_submission_id: The Sms auth token
        :param str redirect_action: The Slack redirect action
        :param bool register_before_o_auth_flow: Whether to register the settings before OAuth validation is performed. Recommended to True.
        :param str client_id: The Slack client id
        :param str client_secret: The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str landing_page_url: The Slack landing page Url
        :param str scopes: The Slack permission scopes.
        :param str signing_secret: The Slack signing secret.
        :param str verification_token: The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "is_validated", is_validated)
        pulumi.set(__self__, "last_submission_id", last_submission_id)
        pulumi.set(__self__, "redirect_action", redirect_action)
        pulumi.set(__self__, "register_before_o_auth_flow", register_before_o_auth_flow)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if landing_page_url is not None:
            pulumi.set(__self__, "landing_page_url", landing_page_url)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if signing_secret is not None:
            pulumi.set(__self__, "signing_secret", signing_secret)
        if verification_token is not None:
            pulumi.set(__self__, "verification_token", verification_token)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> bool:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")

    @property
    @pulumi.getter(name="lastSubmissionId")
    def last_submission_id(self) -> str:
        """
        The Sms auth token
        """
        return pulumi.get(self, "last_submission_id")

    @property
    @pulumi.getter(name="redirectAction")
    def redirect_action(self) -> str:
        """
        The Slack redirect action
        """
        return pulumi.get(self, "redirect_action")

    @property
    @pulumi.getter(name="registerBeforeOAuthFlow")
    def register_before_o_auth_flow(self) -> bool:
        """
        Whether to register the settings before OAuth validation is performed. Recommended to True.
        """
        return pulumi.get(self, "register_before_o_auth_flow")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The Slack client id
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="landingPageUrl")
    def landing_page_url(self) -> Optional[str]:
        """
        The Slack landing page Url
        """
        return pulumi.get(self, "landing_page_url")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[str]:
        """
        The Slack permission scopes.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="signingSecret")
    def signing_secret(self) -> Optional[str]:
        """
        The Slack signing secret.
        """
        return pulumi.get(self, "signing_secret")

    @property
    @pulumi.getter(name="verificationToken")
    def verification_token(self) -> Optional[str]:
        """
        The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "verification_token")


@pulumi.output_type
class SlackChannelResponse(dict):
    """
    Slack channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlackChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlackChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlackChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.SlackChannelPropertiesResponse'] = None):
        """
        Slack channel definition
        :param str channel_name: The channel name
               Expected value is 'SlackChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'SlackChannelPropertiesResponse' properties: The set of properties specific to Slack channel resource
        """
        pulumi.set(__self__, "channel_name", 'SlackChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'SlackChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.SlackChannelPropertiesResponse']:
        """
        The set of properties specific to Slack channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SmsChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Sms channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountSID":
            suggest = "account_sid"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "authToken":
            suggest = "auth_token"
        elif key == "isValidated":
            suggest = "is_validated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SmsChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SmsChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SmsChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_sid: str,
                 is_enabled: bool,
                 phone: str,
                 auth_token: Optional[str] = None,
                 is_validated: Optional[bool] = None):
        """
        The parameters to provide for the Sms channel.
        :param str account_sid: The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str phone: The Sms phone
        :param str auth_token: The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param bool is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "account_sid", account_sid)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "phone", phone)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="accountSID")
    def account_sid(self) -> str:
        """
        The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "account_sid")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def phone(self) -> str:
        """
        The Sms phone
        """
        return pulumi.get(self, "phone")

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[str]:
        """
        The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[bool]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")


@pulumi.output_type
class SmsChannelResponse(dict):
    """
    Sms channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SmsChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SmsChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SmsChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.SmsChannelPropertiesResponse'] = None):
        """
        Sms channel definition
        :param str channel_name: The channel name
               Expected value is 'SmsChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'SmsChannelPropertiesResponse' properties: The set of properties specific to Sms channel resource
        """
        pulumi.set(__self__, "channel_name", 'SmsChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'SmsChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.SmsChannelPropertiesResponse']:
        """
        The set of properties specific to Sms channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class TelegramChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Telegram channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "accessToken":
            suggest = "access_token"
        elif key == "isValidated":
            suggest = "is_validated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TelegramChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TelegramChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TelegramChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 access_token: Optional[str] = None,
                 is_validated: Optional[bool] = None):
        """
        The parameters to provide for the Telegram channel.
        :param bool is_enabled: Whether this channel is enabled for the bot
        :param str access_token: The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param bool is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[bool]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")


@pulumi.output_type
class TelegramChannelResponse(dict):
    """
    Telegram channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TelegramChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TelegramChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TelegramChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.TelegramChannelPropertiesResponse'] = None):
        """
        Telegram channel definition
        :param str channel_name: The channel name
               Expected value is 'TelegramChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'TelegramChannelPropertiesResponse' properties: The set of properties specific to Telegram channel resource
        """
        pulumi.set(__self__, "channel_name", 'TelegramChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'TelegramChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.TelegramChannelPropertiesResponse']:
        """
        The set of properties specific to Telegram channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class TelephonyChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Direct Line channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiConfigurations":
            suggest = "api_configurations"
        elif key == "cognitiveServiceRegion":
            suggest = "cognitive_service_region"
        elif key == "cognitiveServiceSubscriptionKey":
            suggest = "cognitive_service_subscription_key"
        elif key == "defaultLocale":
            suggest = "default_locale"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "phoneNumbers":
            suggest = "phone_numbers"
        elif key == "premiumSKU":
            suggest = "premium_sku"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TelephonyChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TelephonyChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TelephonyChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_configurations: Optional[Sequence['outputs.TelephonyChannelResourceApiConfigurationResponse']] = None,
                 cognitive_service_region: Optional[str] = None,
                 cognitive_service_subscription_key: Optional[str] = None,
                 default_locale: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 phone_numbers: Optional[Sequence['outputs.TelephonyPhoneNumbersResponse']] = None,
                 premium_sku: Optional[str] = None):
        """
        The parameters to provide for the Direct Line channel.
        :param Sequence['TelephonyChannelResourceApiConfigurationResponse'] api_configurations: The list of Telephony api configuration
        :param str cognitive_service_region: The extensionKey2
        :param str cognitive_service_subscription_key: The extensionKey1
        :param str default_locale: The default locale of the channel
        :param bool is_enabled: Whether the channel is enabled
        :param Sequence['TelephonyPhoneNumbersResponse'] phone_numbers: The list of Telephony phone numbers
        :param str premium_sku: The premium SKU applied to the channel
        """
        if api_configurations is not None:
            pulumi.set(__self__, "api_configurations", api_configurations)
        if cognitive_service_region is not None:
            pulumi.set(__self__, "cognitive_service_region", cognitive_service_region)
        if cognitive_service_subscription_key is not None:
            pulumi.set(__self__, "cognitive_service_subscription_key", cognitive_service_subscription_key)
        if default_locale is not None:
            pulumi.set(__self__, "default_locale", default_locale)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if phone_numbers is not None:
            pulumi.set(__self__, "phone_numbers", phone_numbers)
        if premium_sku is not None:
            pulumi.set(__self__, "premium_sku", premium_sku)

    @property
    @pulumi.getter(name="apiConfigurations")
    def api_configurations(self) -> Optional[Sequence['outputs.TelephonyChannelResourceApiConfigurationResponse']]:
        """
        The list of Telephony api configuration
        """
        return pulumi.get(self, "api_configurations")

    @property
    @pulumi.getter(name="cognitiveServiceRegion")
    def cognitive_service_region(self) -> Optional[str]:
        """
        The extensionKey2
        """
        return pulumi.get(self, "cognitive_service_region")

    @property
    @pulumi.getter(name="cognitiveServiceSubscriptionKey")
    def cognitive_service_subscription_key(self) -> Optional[str]:
        """
        The extensionKey1
        """
        return pulumi.get(self, "cognitive_service_subscription_key")

    @property
    @pulumi.getter(name="defaultLocale")
    def default_locale(self) -> Optional[str]:
        """
        The default locale of the channel
        """
        return pulumi.get(self, "default_locale")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Whether the channel is enabled
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="phoneNumbers")
    def phone_numbers(self) -> Optional[Sequence['outputs.TelephonyPhoneNumbersResponse']]:
        """
        The list of Telephony phone numbers
        """
        return pulumi.get(self, "phone_numbers")

    @property
    @pulumi.getter(name="premiumSKU")
    def premium_sku(self) -> Optional[str]:
        """
        The premium SKU applied to the channel
        """
        return pulumi.get(self, "premium_sku")


@pulumi.output_type
class TelephonyChannelResourceApiConfigurationResponse(dict):
    """
    A resource Api configuration for the Telephony channel
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cognitiveServiceRegion":
            suggest = "cognitive_service_region"
        elif key == "cognitiveServiceResourceId":
            suggest = "cognitive_service_resource_id"
        elif key == "cognitiveServiceSubscriptionKey":
            suggest = "cognitive_service_subscription_key"
        elif key == "defaultLocale":
            suggest = "default_locale"
        elif key == "providerName":
            suggest = "provider_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TelephonyChannelResourceApiConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TelephonyChannelResourceApiConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TelephonyChannelResourceApiConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cognitive_service_region: Optional[str] = None,
                 cognitive_service_resource_id: Optional[str] = None,
                 cognitive_service_subscription_key: Optional[str] = None,
                 default_locale: Optional[str] = None,
                 id: Optional[str] = None,
                 provider_name: Optional[str] = None):
        """
        A resource Api configuration for the Telephony channel
        :param str cognitive_service_region: The cognitive service region.
        :param str cognitive_service_resource_id: The cognitive service resourceId.
        :param str cognitive_service_subscription_key: The cognitive service subscription key.
        :param str default_locale: The default locale.
        :param str id: The id of config.
        :param str provider_name: The provider name.
        """
        if cognitive_service_region is not None:
            pulumi.set(__self__, "cognitive_service_region", cognitive_service_region)
        if cognitive_service_resource_id is not None:
            pulumi.set(__self__, "cognitive_service_resource_id", cognitive_service_resource_id)
        if cognitive_service_subscription_key is not None:
            pulumi.set(__self__, "cognitive_service_subscription_key", cognitive_service_subscription_key)
        if default_locale is not None:
            pulumi.set(__self__, "default_locale", default_locale)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)

    @property
    @pulumi.getter(name="cognitiveServiceRegion")
    def cognitive_service_region(self) -> Optional[str]:
        """
        The cognitive service region.
        """
        return pulumi.get(self, "cognitive_service_region")

    @property
    @pulumi.getter(name="cognitiveServiceResourceId")
    def cognitive_service_resource_id(self) -> Optional[str]:
        """
        The cognitive service resourceId.
        """
        return pulumi.get(self, "cognitive_service_resource_id")

    @property
    @pulumi.getter(name="cognitiveServiceSubscriptionKey")
    def cognitive_service_subscription_key(self) -> Optional[str]:
        """
        The cognitive service subscription key.
        """
        return pulumi.get(self, "cognitive_service_subscription_key")

    @property
    @pulumi.getter(name="defaultLocale")
    def default_locale(self) -> Optional[str]:
        """
        The default locale.
        """
        return pulumi.get(self, "default_locale")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of config.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[str]:
        """
        The provider name.
        """
        return pulumi.get(self, "provider_name")


@pulumi.output_type
class TelephonyChannelResponse(dict):
    """
    Telephony channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TelephonyChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TelephonyChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TelephonyChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.TelephonyChannelPropertiesResponse'] = None):
        """
        Telephony channel definition
        :param str channel_name: The channel name
               Expected value is 'TelephonyChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'TelephonyChannelPropertiesResponse' properties: The set of properties specific to Telephony channel resource
        """
        pulumi.set(__self__, "channel_name", 'TelephonyChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'TelephonyChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.TelephonyChannelPropertiesResponse']:
        """
        The set of properties specific to Telephony channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class TelephonyPhoneNumbersResponse(dict):
    """
    A telephone number for the Telephony channel
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acsEndpoint":
            suggest = "acs_endpoint"
        elif key == "acsResourceId":
            suggest = "acs_resource_id"
        elif key == "acsSecret":
            suggest = "acs_secret"
        elif key == "cognitiveServiceRegion":
            suggest = "cognitive_service_region"
        elif key == "cognitiveServiceResourceId":
            suggest = "cognitive_service_resource_id"
        elif key == "cognitiveServiceSubscriptionKey":
            suggest = "cognitive_service_subscription_key"
        elif key == "defaultLocale":
            suggest = "default_locale"
        elif key == "offerType":
            suggest = "offer_type"
        elif key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TelephonyPhoneNumbersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TelephonyPhoneNumbersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TelephonyPhoneNumbersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acs_endpoint: Optional[str] = None,
                 acs_resource_id: Optional[str] = None,
                 acs_secret: Optional[str] = None,
                 cognitive_service_region: Optional[str] = None,
                 cognitive_service_resource_id: Optional[str] = None,
                 cognitive_service_subscription_key: Optional[str] = None,
                 default_locale: Optional[str] = None,
                 id: Optional[str] = None,
                 offer_type: Optional[str] = None,
                 phone_number: Optional[str] = None):
        """
        A telephone number for the Telephony channel
        :param str acs_endpoint: The endpoint of ACS.
        :param str acs_resource_id: The resource id of ACS.
        :param str acs_secret: The secret of ACS.
        :param str cognitive_service_region: The service region of cognitive service.
        :param str cognitive_service_resource_id: The resource id of cognitive service.
        :param str cognitive_service_subscription_key: The subscription key of cognitive service.
        :param str default_locale: The default locale of the phone number.
        :param str id: The element id.
        :param str offer_type: Optional Property that will determine the offering type of the phone.
        :param str phone_number: The phone number.
        """
        if acs_endpoint is not None:
            pulumi.set(__self__, "acs_endpoint", acs_endpoint)
        if acs_resource_id is not None:
            pulumi.set(__self__, "acs_resource_id", acs_resource_id)
        if acs_secret is not None:
            pulumi.set(__self__, "acs_secret", acs_secret)
        if cognitive_service_region is not None:
            pulumi.set(__self__, "cognitive_service_region", cognitive_service_region)
        if cognitive_service_resource_id is not None:
            pulumi.set(__self__, "cognitive_service_resource_id", cognitive_service_resource_id)
        if cognitive_service_subscription_key is not None:
            pulumi.set(__self__, "cognitive_service_subscription_key", cognitive_service_subscription_key)
        if default_locale is not None:
            pulumi.set(__self__, "default_locale", default_locale)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer_type is not None:
            pulumi.set(__self__, "offer_type", offer_type)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="acsEndpoint")
    def acs_endpoint(self) -> Optional[str]:
        """
        The endpoint of ACS.
        """
        return pulumi.get(self, "acs_endpoint")

    @property
    @pulumi.getter(name="acsResourceId")
    def acs_resource_id(self) -> Optional[str]:
        """
        The resource id of ACS.
        """
        return pulumi.get(self, "acs_resource_id")

    @property
    @pulumi.getter(name="acsSecret")
    def acs_secret(self) -> Optional[str]:
        """
        The secret of ACS.
        """
        return pulumi.get(self, "acs_secret")

    @property
    @pulumi.getter(name="cognitiveServiceRegion")
    def cognitive_service_region(self) -> Optional[str]:
        """
        The service region of cognitive service.
        """
        return pulumi.get(self, "cognitive_service_region")

    @property
    @pulumi.getter(name="cognitiveServiceResourceId")
    def cognitive_service_resource_id(self) -> Optional[str]:
        """
        The resource id of cognitive service.
        """
        return pulumi.get(self, "cognitive_service_resource_id")

    @property
    @pulumi.getter(name="cognitiveServiceSubscriptionKey")
    def cognitive_service_subscription_key(self) -> Optional[str]:
        """
        The subscription key of cognitive service.
        """
        return pulumi.get(self, "cognitive_service_subscription_key")

    @property
    @pulumi.getter(name="defaultLocale")
    def default_locale(self) -> Optional[str]:
        """
        The default locale of the phone number.
        """
        return pulumi.get(self, "default_locale")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The element id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="offerType")
    def offer_type(self) -> Optional[str]:
        """
        Optional Property that will determine the offering type of the phone.
        """
        return pulumi.get(self, "offer_type")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[str]:
        """
        The phone number.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class WebChatChannelPropertiesResponse(dict):
    """
    The parameters to provide for the Web Chat channel.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "webChatEmbedCode":
            suggest = "web_chat_embed_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebChatChannelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebChatChannelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebChatChannelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 web_chat_embed_code: str,
                 sites: Optional[Sequence['outputs.WebChatSiteResponse']] = None):
        """
        The parameters to provide for the Web Chat channel.
        :param str web_chat_embed_code: Web chat control embed code
        :param Sequence['WebChatSiteResponse'] sites: The list of Web Chat sites
        """
        pulumi.set(__self__, "web_chat_embed_code", web_chat_embed_code)
        if sites is not None:
            pulumi.set(__self__, "sites", sites)

    @property
    @pulumi.getter(name="webChatEmbedCode")
    def web_chat_embed_code(self) -> str:
        """
        Web chat control embed code
        """
        return pulumi.get(self, "web_chat_embed_code")

    @property
    @pulumi.getter
    def sites(self) -> Optional[Sequence['outputs.WebChatSiteResponse']]:
        """
        The list of Web Chat sites
        """
        return pulumi.get(self, "sites")


@pulumi.output_type
class WebChatChannelResponse(dict):
    """
    Web Chat channel definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelName":
            suggest = "channel_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebChatChannelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebChatChannelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebChatChannelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_name: str,
                 provisioning_state: str,
                 etag: Optional[str] = None,
                 location: Optional[str] = None,
                 properties: Optional['outputs.WebChatChannelPropertiesResponse'] = None):
        """
        Web Chat channel definition
        :param str channel_name: The channel name
               Expected value is 'WebChatChannel'.
        :param str provisioning_state: Provisioning state of the resource
        :param str etag: Entity Tag of the resource
        :param str location: Specifies the location of the resource.
        :param 'WebChatChannelPropertiesResponse' properties: The set of properties specific to Web Chat channel resource
        """
        pulumi.set(__self__, "channel_name", 'WebChatChannel')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> str:
        """
        The channel name
        Expected value is 'WebChatChannel'.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.WebChatChannelPropertiesResponse']:
        """
        The set of properties specific to Web Chat channel resource
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class WebChatSiteResponse(dict):
    """
    A site for the Webchat channel
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "isTokenEnabled":
            suggest = "is_token_enabled"
        elif key == "isWebchatPreviewEnabled":
            suggest = "is_webchat_preview_enabled"
        elif key == "siteId":
            suggest = "site_id"
        elif key == "siteName":
            suggest = "site_name"
        elif key == "appId":
            suggest = "app_id"
        elif key == "eTag":
            suggest = "e_tag"
        elif key == "isBlockUserUploadEnabled":
            suggest = "is_block_user_upload_enabled"
        elif key == "isDetailedLoggingEnabled":
            suggest = "is_detailed_logging_enabled"
        elif key == "isEndpointParametersEnabled":
            suggest = "is_endpoint_parameters_enabled"
        elif key == "isNoStorageEnabled":
            suggest = "is_no_storage_enabled"
        elif key == "isSecureSiteEnabled":
            suggest = "is_secure_site_enabled"
        elif key == "isV1Enabled":
            suggest = "is_v1_enabled"
        elif key == "isV3Enabled":
            suggest = "is_v3_enabled"
        elif key == "isWebChatSpeechEnabled":
            suggest = "is_web_chat_speech_enabled"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "trustedOrigins":
            suggest = "trusted_origins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebChatSiteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebChatSiteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebChatSiteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 is_token_enabled: bool,
                 is_webchat_preview_enabled: bool,
                 key: str,
                 key2: str,
                 site_id: str,
                 site_name: str,
                 app_id: Optional[str] = None,
                 e_tag: Optional[str] = None,
                 is_block_user_upload_enabled: Optional[bool] = None,
                 is_detailed_logging_enabled: Optional[bool] = None,
                 is_endpoint_parameters_enabled: Optional[bool] = None,
                 is_no_storage_enabled: Optional[bool] = None,
                 is_secure_site_enabled: Optional[bool] = None,
                 is_v1_enabled: Optional[bool] = None,
                 is_v3_enabled: Optional[bool] = None,
                 is_web_chat_speech_enabled: Optional[bool] = None,
                 tenant_id: Optional[str] = None,
                 trusted_origins: Optional[Sequence[str]] = None):
        """
        A site for the Webchat channel
        :param bool is_enabled: Whether this site is enabled for DirectLine channel
        :param bool is_token_enabled: Whether this site is token enabled for channel
        :param bool is_webchat_preview_enabled: Whether this site is enabled for preview versions of Webchat
        :param str key: Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str key2: Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param str site_id: Site Id
        :param str site_name: Site name
        :param str app_id: DirectLine application id
        :param str e_tag: Entity Tag
        :param bool is_block_user_upload_enabled: Whether this site is enabled for block user upload.
        :param bool is_detailed_logging_enabled: Whether this site is disabled detailed logging for
        :param bool is_endpoint_parameters_enabled: Whether this site is EndpointParameters enabled for channel
        :param bool is_no_storage_enabled: Whether this no-storage site is disabled detailed logging for
        :param bool is_secure_site_enabled: Whether this site is enabled for authentication with Bot Framework.
        :param bool is_v1_enabled: Whether this site is enabled for Bot Framework V1 protocol.
        :param bool is_v3_enabled: Whether this site is enabled for Bot Framework V3 protocol.
        :param bool is_web_chat_speech_enabled: Whether this site is enabled for Webchat Speech
        :param str tenant_id: Tenant Id
        :param Sequence[str] trusted_origins: List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "is_token_enabled", is_token_enabled)
        if is_webchat_preview_enabled is None:
            is_webchat_preview_enabled = False
        pulumi.set(__self__, "is_webchat_preview_enabled", is_webchat_preview_enabled)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "key2", key2)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "site_name", site_name)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if is_block_user_upload_enabled is not None:
            pulumi.set(__self__, "is_block_user_upload_enabled", is_block_user_upload_enabled)
        if is_detailed_logging_enabled is not None:
            pulumi.set(__self__, "is_detailed_logging_enabled", is_detailed_logging_enabled)
        if is_endpoint_parameters_enabled is not None:
            pulumi.set(__self__, "is_endpoint_parameters_enabled", is_endpoint_parameters_enabled)
        if is_no_storage_enabled is not None:
            pulumi.set(__self__, "is_no_storage_enabled", is_no_storage_enabled)
        if is_secure_site_enabled is not None:
            pulumi.set(__self__, "is_secure_site_enabled", is_secure_site_enabled)
        if is_v1_enabled is not None:
            pulumi.set(__self__, "is_v1_enabled", is_v1_enabled)
        if is_v3_enabled is not None:
            pulumi.set(__self__, "is_v3_enabled", is_v3_enabled)
        if is_web_chat_speech_enabled is None:
            is_web_chat_speech_enabled = False
        if is_web_chat_speech_enabled is not None:
            pulumi.set(__self__, "is_web_chat_speech_enabled", is_web_chat_speech_enabled)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if trusted_origins is not None:
            pulumi.set(__self__, "trusted_origins", trusted_origins)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether this site is enabled for DirectLine channel
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isTokenEnabled")
    def is_token_enabled(self) -> bool:
        """
        Whether this site is token enabled for channel
        """
        return pulumi.get(self, "is_token_enabled")

    @property
    @pulumi.getter(name="isWebchatPreviewEnabled")
    def is_webchat_preview_enabled(self) -> bool:
        """
        Whether this site is enabled for preview versions of Webchat
        """
        return pulumi.get(self, "is_webchat_preview_enabled")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def key2(self) -> str:
        """
        Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "key2")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        """
        Site Id
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> str:
        """
        Site name
        """
        return pulumi.get(self, "site_name")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        DirectLine application id
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[str]:
        """
        Entity Tag
        """
        return pulumi.get(self, "e_tag")

    @property
    @pulumi.getter(name="isBlockUserUploadEnabled")
    def is_block_user_upload_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for block user upload.
        """
        return pulumi.get(self, "is_block_user_upload_enabled")

    @property
    @pulumi.getter(name="isDetailedLoggingEnabled")
    def is_detailed_logging_enabled(self) -> Optional[bool]:
        """
        Whether this site is disabled detailed logging for
        """
        return pulumi.get(self, "is_detailed_logging_enabled")

    @property
    @pulumi.getter(name="isEndpointParametersEnabled")
    def is_endpoint_parameters_enabled(self) -> Optional[bool]:
        """
        Whether this site is EndpointParameters enabled for channel
        """
        return pulumi.get(self, "is_endpoint_parameters_enabled")

    @property
    @pulumi.getter(name="isNoStorageEnabled")
    def is_no_storage_enabled(self) -> Optional[bool]:
        """
        Whether this no-storage site is disabled detailed logging for
        """
        return pulumi.get(self, "is_no_storage_enabled")

    @property
    @pulumi.getter(name="isSecureSiteEnabled")
    def is_secure_site_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for authentication with Bot Framework.
        """
        return pulumi.get(self, "is_secure_site_enabled")

    @property
    @pulumi.getter(name="isV1Enabled")
    def is_v1_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for Bot Framework V1 protocol.
        """
        return pulumi.get(self, "is_v1_enabled")

    @property
    @pulumi.getter(name="isV3Enabled")
    def is_v3_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for Bot Framework V3 protocol.
        """
        return pulumi.get(self, "is_v3_enabled")

    @property
    @pulumi.getter(name="isWebChatSpeechEnabled")
    def is_web_chat_speech_enabled(self) -> Optional[bool]:
        """
        Whether this site is enabled for Webchat Speech
        """
        return pulumi.get(self, "is_web_chat_speech_enabled")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="trustedOrigins")
    def trusted_origins(self) -> Optional[Sequence[str]]:
        """
        List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
        """
        return pulumi.get(self, "trusted_origins")


