# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AgentConfigurationResponse',
    'CloudMetadataResponse',
    'ConfigurationExtensionResponse',
    'ErrorAdditionalInfoResponse',
    'ErrorDetailResponse',
    'HybridComputePrivateLinkScopePropertiesResponse',
    'IdentityResponse',
    'LocationDataResponse',
    'MachineExtensionInstanceViewResponse',
    'MachineExtensionInstanceViewResponseStatus',
    'MachineExtensionResponse',
    'OSProfileResponse',
    'OSProfileResponseLinuxConfiguration',
    'OSProfileResponseWindowsConfiguration',
    'PrivateEndpointConnectionDataModelResponse',
    'PrivateEndpointConnectionPropertiesResponse',
    'PrivateEndpointPropertyResponse',
    'PrivateLinkServiceConnectionStatePropertyResponse',
    'ServiceStatusResponse',
    'ServiceStatusesResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class AgentConfigurationResponse(dict):
    """
    Configurable properties that the user can set locally via the azcmagent config command, or remotely via ARM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMode":
            suggest = "config_mode"
        elif key == "extensionsAllowList":
            suggest = "extensions_allow_list"
        elif key == "extensionsBlockList":
            suggest = "extensions_block_list"
        elif key == "extensionsEnabled":
            suggest = "extensions_enabled"
        elif key == "guestConfigurationEnabled":
            suggest = "guest_configuration_enabled"
        elif key == "incomingConnectionsPorts":
            suggest = "incoming_connections_ports"
        elif key == "proxyBypass":
            suggest = "proxy_bypass"
        elif key == "proxyUrl":
            suggest = "proxy_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AgentConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AgentConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AgentConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_mode: str,
                 extensions_allow_list: Sequence['outputs.ConfigurationExtensionResponse'],
                 extensions_block_list: Sequence['outputs.ConfigurationExtensionResponse'],
                 extensions_enabled: str,
                 guest_configuration_enabled: str,
                 incoming_connections_ports: Sequence[str],
                 proxy_bypass: Sequence[str],
                 proxy_url: str):
        """
        Configurable properties that the user can set locally via the azcmagent config command, or remotely via ARM.
        :param str config_mode: Name of configuration mode to use. Modes are pre-defined configurations of security controls, extension allowlists and guest configuration, maintained by Microsoft.
        :param Sequence['ConfigurationExtensionResponse'] extensions_allow_list: Array of extensions that are allowed to be installed or updated.
        :param Sequence['ConfigurationExtensionResponse'] extensions_block_list: Array of extensions that are blocked (cannot be installed or updated)
        :param str extensions_enabled: Specifies whether the extension service is enabled or disabled.
        :param str guest_configuration_enabled: Specified whether the guest configuration service is enabled or disabled.
        :param Sequence[str] incoming_connections_ports: Specifies the list of ports that the agent will be able to listen on.
        :param Sequence[str] proxy_bypass: List of service names which should not use the specified proxy server.
        :param str proxy_url: Specifies the URL of the proxy to be used.
        """
        pulumi.set(__self__, "config_mode", config_mode)
        pulumi.set(__self__, "extensions_allow_list", extensions_allow_list)
        pulumi.set(__self__, "extensions_block_list", extensions_block_list)
        pulumi.set(__self__, "extensions_enabled", extensions_enabled)
        pulumi.set(__self__, "guest_configuration_enabled", guest_configuration_enabled)
        pulumi.set(__self__, "incoming_connections_ports", incoming_connections_ports)
        pulumi.set(__self__, "proxy_bypass", proxy_bypass)
        pulumi.set(__self__, "proxy_url", proxy_url)

    @property
    @pulumi.getter(name="configMode")
    def config_mode(self) -> str:
        """
        Name of configuration mode to use. Modes are pre-defined configurations of security controls, extension allowlists and guest configuration, maintained by Microsoft.
        """
        return pulumi.get(self, "config_mode")

    @property
    @pulumi.getter(name="extensionsAllowList")
    def extensions_allow_list(self) -> Sequence['outputs.ConfigurationExtensionResponse']:
        """
        Array of extensions that are allowed to be installed or updated.
        """
        return pulumi.get(self, "extensions_allow_list")

    @property
    @pulumi.getter(name="extensionsBlockList")
    def extensions_block_list(self) -> Sequence['outputs.ConfigurationExtensionResponse']:
        """
        Array of extensions that are blocked (cannot be installed or updated)
        """
        return pulumi.get(self, "extensions_block_list")

    @property
    @pulumi.getter(name="extensionsEnabled")
    def extensions_enabled(self) -> str:
        """
        Specifies whether the extension service is enabled or disabled.
        """
        return pulumi.get(self, "extensions_enabled")

    @property
    @pulumi.getter(name="guestConfigurationEnabled")
    def guest_configuration_enabled(self) -> str:
        """
        Specified whether the guest configuration service is enabled or disabled.
        """
        return pulumi.get(self, "guest_configuration_enabled")

    @property
    @pulumi.getter(name="incomingConnectionsPorts")
    def incoming_connections_ports(self) -> Sequence[str]:
        """
        Specifies the list of ports that the agent will be able to listen on.
        """
        return pulumi.get(self, "incoming_connections_ports")

    @property
    @pulumi.getter(name="proxyBypass")
    def proxy_bypass(self) -> Sequence[str]:
        """
        List of service names which should not use the specified proxy server.
        """
        return pulumi.get(self, "proxy_bypass")

    @property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> str:
        """
        Specifies the URL of the proxy to be used.
        """
        return pulumi.get(self, "proxy_url")


@pulumi.output_type
class CloudMetadataResponse(dict):
    """
    The metadata of the cloud environment (Azure/GCP/AWS/OCI...).
    """
    def __init__(__self__, *,
                 provider: str):
        """
        The metadata of the cloud environment (Azure/GCP/AWS/OCI...).
        :param str provider: Specifies the cloud provider (Azure/AWS/GCP...).
        """
        pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def provider(self) -> str:
        """
        Specifies the cloud provider (Azure/AWS/GCP...).
        """
        return pulumi.get(self, "provider")


@pulumi.output_type
class ConfigurationExtensionResponse(dict):
    """
    Describes properties that can identify extensions.
    """
    def __init__(__self__, *,
                 publisher: str,
                 type: str):
        """
        Describes properties that can identify extensions.
        :param str publisher: Publisher of the extension.
        :param str type: Type of the extension.
        """
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def publisher(self) -> str:
        """
        Publisher of the extension.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the extension.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ErrorAdditionalInfoResponse(dict):
    """
    The resource management error additional info.
    """
    def __init__(__self__, *,
                 info: Any,
                 type: str):
        """
        The resource management error additional info.
        :param Any info: The additional info.
        :param str type: The additional info type.
        """
        pulumi.set(__self__, "info", info)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def info(self) -> Any:
        """
        The additional info.
        """
        return pulumi.get(self, "info")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The additional info type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    The error detail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalInfo":
            suggest = "additional_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_info: Sequence['outputs.ErrorAdditionalInfoResponse'],
                 code: str,
                 details: Sequence['outputs.ErrorDetailResponse'],
                 message: str,
                 target: str):
        """
        The error detail.
        :param Sequence['ErrorAdditionalInfoResponse'] additional_info: The error additional info.
        :param str code: The error code.
        :param Sequence['ErrorDetailResponse'] details: The error details.
        :param str message: The error message.
        :param str target: The error target.
        """
        pulumi.set(__self__, "additional_info", additional_info)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Sequence['outputs.ErrorAdditionalInfoResponse']:
        """
        The error additional info.
        """
        return pulumi.get(self, "additional_info")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorDetailResponse']:
        """
        The error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The error target.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class HybridComputePrivateLinkScopePropertiesResponse(dict):
    """
    Properties that define a Azure Arc PrivateLinkScope resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "privateLinkScopeId":
            suggest = "private_link_scope_id"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HybridComputePrivateLinkScopePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HybridComputePrivateLinkScopePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HybridComputePrivateLinkScopePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint_connections: Sequence['outputs.PrivateEndpointConnectionDataModelResponse'],
                 private_link_scope_id: str,
                 provisioning_state: str,
                 public_network_access: Optional[str] = None):
        """
        Properties that define a Azure Arc PrivateLinkScope resource.
        :param Sequence['PrivateEndpointConnectionDataModelResponse'] private_endpoint_connections: The collection of associated Private Endpoint Connections.
        :param str private_link_scope_id: The Guid id of the private link scope.
        :param str provisioning_state: Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
        :param str public_network_access: Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
        """
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        pulumi.set(__self__, "private_link_scope_id", private_link_scope_id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.PrivateEndpointConnectionDataModelResponse']:
        """
        The collection of associated Private Endpoint Connections.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="privateLinkScopeId")
    def private_link_scope_id(self) -> str:
        """
        The Guid id of the private link scope.
        """
        return pulumi.get(self, "private_link_scope_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
        """
        return pulumi.get(self, "public_network_access")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LocationDataResponse(dict):
    """
    Metadata pertaining to the geographic location of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryOrRegion":
            suggest = "country_or_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 city: Optional[str] = None,
                 country_or_region: Optional[str] = None,
                 district: Optional[str] = None):
        """
        Metadata pertaining to the geographic location of the resource.
        :param str name: A canonical name for the geographic or physical location.
        :param str city: The city or locality where the resource is located.
        :param str country_or_region: The country or region where the resource is located
        :param str district: The district, state, or province where the resource is located.
        """
        pulumi.set(__self__, "name", name)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country_or_region is not None:
            pulumi.set(__self__, "country_or_region", country_or_region)
        if district is not None:
            pulumi.set(__self__, "district", district)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A canonical name for the geographic or physical location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def city(self) -> Optional[str]:
        """
        The city or locality where the resource is located.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="countryOrRegion")
    def country_or_region(self) -> Optional[str]:
        """
        The country or region where the resource is located
        """
        return pulumi.get(self, "country_or_region")

    @property
    @pulumi.getter
    def district(self) -> Optional[str]:
        """
        The district, state, or province where the resource is located.
        """
        return pulumi.get(self, "district")


@pulumi.output_type
class MachineExtensionInstanceViewResponse(dict):
    """
    Describes the Machine Extension Instance View.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineExtensionInstanceViewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineExtensionInstanceViewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineExtensionInstanceViewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 status: Optional['outputs.MachineExtensionInstanceViewResponseStatus'] = None,
                 type: Optional[str] = None,
                 type_handler_version: Optional[str] = None):
        """
        Describes the Machine Extension Instance View.
        :param str name: The machine extension name.
        :param 'MachineExtensionInstanceViewResponseStatus' status: Instance view status.
        :param str type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :param str type_handler_version: Specifies the version of the script handler.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The machine extension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.MachineExtensionInstanceViewResponseStatus']:
        """
        Instance view status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of the extension; an example is "CustomScriptExtension".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class MachineExtensionInstanceViewResponseStatus(dict):
    """
    Instance view status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayStatus":
            suggest = "display_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineExtensionInstanceViewResponseStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineExtensionInstanceViewResponseStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineExtensionInstanceViewResponseStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 display_status: Optional[str] = None,
                 level: Optional[str] = None,
                 message: Optional[str] = None,
                 time: Optional[str] = None):
        """
        Instance view status.
        :param str code: The status code.
        :param str display_status: The short localizable label for the status.
        :param str level: The level code.
        :param str message: The detailed status message, including for alerts and error messages.
        :param str time: The time of the status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if display_status is not None:
            pulumi.set(__self__, "display_status", display_status)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The status code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> Optional[str]:
        """
        The short localizable label for the status.
        """
        return pulumi.get(self, "display_status")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        The level code.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The detailed status message, including for alerts and error messages.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def time(self) -> Optional[str]:
        """
        The time of the status.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class MachineExtensionResponse(dict):
    """
    Describes a Machine Extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "systemData":
            suggest = "system_data"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "enableAutomaticUpgrade":
            suggest = "enable_automatic_upgrade"
        elif key == "forceUpdateTag":
            suggest = "force_update_tag"
        elif key == "instanceView":
            suggest = "instance_view"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "typeHandlerVersion":
            suggest = "type_handler_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineExtensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineExtensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineExtensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 location: str,
                 name: str,
                 provisioning_state: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str,
                 auto_upgrade_minor_version: Optional[bool] = None,
                 enable_automatic_upgrade: Optional[bool] = None,
                 force_update_tag: Optional[str] = None,
                 instance_view: Optional['outputs.MachineExtensionInstanceViewResponse'] = None,
                 protected_settings: Optional[Any] = None,
                 publisher: Optional[str] = None,
                 settings: Optional[Any] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type_handler_version: Optional[str] = None):
        """
        Describes a Machine Extension.
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str location: The geo-location where the resource lives
        :param str name: The name of the resource
        :param str provisioning_state: The provisioning state, which only appears in the response.
        :param 'SystemDataResponse' system_data: Azure Resource Manager metadata containing createdBy and modifiedBy information.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param bool auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param bool enable_automatic_upgrade: Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
        :param str force_update_tag: How the extension handler should be forced to update even if the extension configuration has not changed.
        :param 'MachineExtensionInstanceViewResponse' instance_view: The machine extension instance view.
        :param Any protected_settings: The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        :param str publisher: The name of the extension handler publisher.
        :param Any settings: Json formatted public settings for the extension.
        :param Mapping[str, str] tags: Resource tags.
        :param str type_handler_version: Specifies the version of the script handler.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if enable_automatic_upgrade is not None:
            pulumi.set(__self__, "enable_automatic_upgrade", enable_automatic_upgrade)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if instance_view is not None:
            pulumi.set(__self__, "instance_view", instance_view)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[bool]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @property
    @pulumi.getter(name="enableAutomaticUpgrade")
    def enable_automatic_upgrade(self) -> Optional[bool]:
        """
        Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
        """
        return pulumi.get(self, "enable_automatic_upgrade")

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[str]:
        """
        How the extension handler should be forced to update even if the extension configuration has not changed.
        """
        return pulumi.get(self, "force_update_tag")

    @property
    @pulumi.getter(name="instanceView")
    def instance_view(self) -> Optional['outputs.MachineExtensionInstanceViewResponse']:
        """
        The machine extension instance view.
        """
        return pulumi.get(self, "instance_view")

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[Any]:
        """
        The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Json formatted public settings for the extension.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[str]:
        """
        Specifies the version of the script handler.
        """
        return pulumi.get(self, "type_handler_version")


@pulumi.output_type
class OSProfileResponse(dict):
    """
    Specifies the operating system settings for the hybrid machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computerName":
            suggest = "computer_name"
        elif key == "linuxConfiguration":
            suggest = "linux_configuration"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 computer_name: str,
                 linux_configuration: Optional['outputs.OSProfileResponseLinuxConfiguration'] = None,
                 windows_configuration: Optional['outputs.OSProfileResponseWindowsConfiguration'] = None):
        """
        Specifies the operating system settings for the hybrid machine.
        :param str computer_name: Specifies the host OS name of the hybrid machine.
        :param 'OSProfileResponseLinuxConfiguration' linux_configuration: Specifies the linux configuration for update management.
        :param 'OSProfileResponseWindowsConfiguration' windows_configuration: Specifies the windows configuration for update management.
        """
        pulumi.set(__self__, "computer_name", computer_name)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> str:
        """
        Specifies the host OS name of the hybrid machine.
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional['outputs.OSProfileResponseLinuxConfiguration']:
        """
        Specifies the linux configuration for update management.
        """
        return pulumi.get(self, "linux_configuration")

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.OSProfileResponseWindowsConfiguration']:
        """
        Specifies the windows configuration for update management.
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class OSProfileResponseLinuxConfiguration(dict):
    """
    Specifies the linux configuration for update management.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assessmentMode":
            suggest = "assessment_mode"
        elif key == "patchMode":
            suggest = "patch_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSProfileResponseLinuxConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSProfileResponseLinuxConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSProfileResponseLinuxConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assessment_mode: Optional[str] = None,
                 patch_mode: Optional[str] = None):
        """
        Specifies the linux configuration for update management.
        :param str assessment_mode: Specifies the assessment mode.
        :param str patch_mode: Specifies the patch mode.
        """
        if assessment_mode is not None:
            pulumi.set(__self__, "assessment_mode", assessment_mode)
        if patch_mode is not None:
            pulumi.set(__self__, "patch_mode", patch_mode)

    @property
    @pulumi.getter(name="assessmentMode")
    def assessment_mode(self) -> Optional[str]:
        """
        Specifies the assessment mode.
        """
        return pulumi.get(self, "assessment_mode")

    @property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> Optional[str]:
        """
        Specifies the patch mode.
        """
        return pulumi.get(self, "patch_mode")


@pulumi.output_type
class OSProfileResponseWindowsConfiguration(dict):
    """
    Specifies the windows configuration for update management.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assessmentMode":
            suggest = "assessment_mode"
        elif key == "patchMode":
            suggest = "patch_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSProfileResponseWindowsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSProfileResponseWindowsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSProfileResponseWindowsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assessment_mode: Optional[str] = None,
                 patch_mode: Optional[str] = None):
        """
        Specifies the windows configuration for update management.
        :param str assessment_mode: Specifies the assessment mode.
        :param str patch_mode: Specifies the patch mode.
        """
        if assessment_mode is not None:
            pulumi.set(__self__, "assessment_mode", assessment_mode)
        if patch_mode is not None:
            pulumi.set(__self__, "patch_mode", patch_mode)

    @property
    @pulumi.getter(name="assessmentMode")
    def assessment_mode(self) -> Optional[str]:
        """
        Specifies the assessment mode.
        """
        return pulumi.get(self, "assessment_mode")

    @property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> Optional[str]:
        """
        Specifies the patch mode.
        """
        return pulumi.get(self, "patch_mode")


@pulumi.output_type
class PrivateEndpointConnectionDataModelResponse(dict):
    """
    The Data Model for a Private Endpoint Connection associated with a Private Link Scope
    """
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str,
                 properties: Optional['outputs.PrivateEndpointConnectionPropertiesResponse'] = None):
        """
        The Data Model for a Private Endpoint Connection associated with a Private Link Scope
        :param str id: The ARM Resource Id of the Private Endpoint.
        :param str name: The Name of the Private Endpoint.
        :param str type: Azure resource type
        :param 'PrivateEndpointConnectionPropertiesResponse' properties: The Private Endpoint Connection properties.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM Resource Id of the Private Endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Name of the Private Endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Azure resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.PrivateEndpointConnectionPropertiesResponse']:
        """
        The Private Endpoint Connection properties.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class PrivateEndpointConnectionPropertiesResponse(dict):
    """
    Properties of a private endpoint connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupIds":
            suggest = "group_ids"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_ids: Sequence[str],
                 provisioning_state: str,
                 private_endpoint: Optional['outputs.PrivateEndpointPropertyResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse'] = None):
        """
        Properties of a private endpoint connection.
        :param Sequence[str] group_ids: List of group IDs.
        :param str provisioning_state: State of the private endpoint connection.
        :param 'PrivateEndpointPropertyResponse' private_endpoint: Private endpoint which the connection belongs to.
        :param 'PrivateLinkServiceConnectionStatePropertyResponse' private_link_service_connection_state: Connection state of the private endpoint connection.
        """
        pulumi.set(__self__, "group_ids", group_ids)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Sequence[str]:
        """
        List of group IDs.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointPropertyResponse']:
        """
        Private endpoint which the connection belongs to.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStatePropertyResponse']:
        """
        Connection state of the private endpoint connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointPropertyResponse(dict):
    """
    Private endpoint which the connection belongs to.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Private endpoint which the connection belongs to.
        :param str id: Resource id of the private endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStatePropertyResponse(dict):
    """
    State of the private endpoint connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStatePropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStatePropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: str,
                 status: str):
        """
        State of the private endpoint connection.
        :param str actions_required: The actions required for private link service connection.
        :param str description: The private link service connection description.
        :param str status: The private link service connection status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        The actions required for private link service connection.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServiceStatusResponse(dict):
    """
    Describes the status and behavior of a service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startupType":
            suggest = "startup_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 startup_type: Optional[str] = None,
                 status: Optional[str] = None):
        """
        Describes the status and behavior of a service.
        :param str startup_type: The behavior of the service when the Arc-enabled machine starts up.
        :param str status: The current status of the service.
        """
        if startup_type is not None:
            pulumi.set(__self__, "startup_type", startup_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="startupType")
    def startup_type(self) -> Optional[str]:
        """
        The behavior of the service when the Arc-enabled machine starts up.
        """
        return pulumi.get(self, "startup_type")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The current status of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ServiceStatusesResponse(dict):
    """
    Reports the state and behavior of dependent services.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionService":
            suggest = "extension_service"
        elif key == "guestConfigurationService":
            suggest = "guest_configuration_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceStatusesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceStatusesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceStatusesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extension_service: Optional['outputs.ServiceStatusResponse'] = None,
                 guest_configuration_service: Optional['outputs.ServiceStatusResponse'] = None):
        """
        Reports the state and behavior of dependent services.
        :param 'ServiceStatusResponse' extension_service: The state of the extension service on the Arc-enabled machine.
        :param 'ServiceStatusResponse' guest_configuration_service: The state of the guest configuration service on the Arc-enabled machine.
        """
        if extension_service is not None:
            pulumi.set(__self__, "extension_service", extension_service)
        if guest_configuration_service is not None:
            pulumi.set(__self__, "guest_configuration_service", guest_configuration_service)

    @property
    @pulumi.getter(name="extensionService")
    def extension_service(self) -> Optional['outputs.ServiceStatusResponse']:
        """
        The state of the extension service on the Arc-enabled machine.
        """
        return pulumi.get(self, "extension_service")

    @property
    @pulumi.getter(name="guestConfigurationService")
    def guest_configuration_service(self) -> Optional['outputs.ServiceStatusResponse']:
        """
        The state of the guest configuration service on the Arc-enabled machine.
        """
        return pulumi.get(self, "guest_configuration_service")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


