# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    User of a lab that can register for and use virtual machines within the lab.
    """
    def __init__(__self__, additional_usage_quota=None, display_name=None, email=None, id=None, invitation_sent=None, invitation_state=None, name=None, provisioning_state=None, registration_state=None, system_data=None, total_usage=None, type=None):
        if additional_usage_quota and not isinstance(additional_usage_quota, str):
            raise TypeError("Expected argument 'additional_usage_quota' to be a str")
        pulumi.set(__self__, "additional_usage_quota", additional_usage_quota)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if invitation_sent and not isinstance(invitation_sent, str):
            raise TypeError("Expected argument 'invitation_sent' to be a str")
        pulumi.set(__self__, "invitation_sent", invitation_sent)
        if invitation_state and not isinstance(invitation_state, str):
            raise TypeError("Expected argument 'invitation_state' to be a str")
        pulumi.set(__self__, "invitation_state", invitation_state)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if registration_state and not isinstance(registration_state, str):
            raise TypeError("Expected argument 'registration_state' to be a str")
        pulumi.set(__self__, "registration_state", registration_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if total_usage and not isinstance(total_usage, str):
            raise TypeError("Expected argument 'total_usage' to be a str")
        pulumi.set(__self__, "total_usage", total_usage)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="additionalUsageQuota")
    def additional_usage_quota(self) -> Optional[str]:
        """
        The amount of usage quota time the user gets in addition to the lab usage quota.
        """
        return pulumi.get(self, "additional_usage_quota")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name of the user, for example user's full name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        Email address of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="invitationSent")
    def invitation_sent(self) -> str:
        """
        Date and time when the invitation message was sent to the user.
        """
        return pulumi.get(self, "invitation_sent")

    @property
    @pulumi.getter(name="invitationState")
    def invitation_state(self) -> str:
        """
        State of the invitation message for the user.
        """
        return pulumi.get(self, "invitation_state")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Current provisioning state of the user resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="registrationState")
    def registration_state(self) -> str:
        """
        State of the user's registration within the lab.
        """
        return pulumi.get(self, "registration_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the user resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter(name="totalUsage")
    def total_usage(self) -> str:
        """
        How long the user has used their virtual machines in this lab.
        """
        return pulumi.get(self, "total_usage")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            additional_usage_quota=self.additional_usage_quota,
            display_name=self.display_name,
            email=self.email,
            id=self.id,
            invitation_sent=self.invitation_sent,
            invitation_state=self.invitation_state,
            name=self.name,
            provisioning_state=self.provisioning_state,
            registration_state=self.registration_state,
            system_data=self.system_data,
            total_usage=self.total_usage,
            type=self.type)


def get_user(lab_name: Optional[str] = None,
             resource_group_name: Optional[str] = None,
             user_name: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    User of a lab that can register for and use virtual machines within the lab.


    :param str lab_name: The name of the lab that uniquely identifies it within containing lab account. Used in resource URIs.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str user_name: The name of the user that uniquely identifies it within containing lab. Used in resource URIs.
    """
    __args__ = dict()
    __args__['labName'] = lab_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['userName'] = user_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:labservices/v20211115preview:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        additional_usage_quota=__ret__.additional_usage_quota,
        display_name=__ret__.display_name,
        email=__ret__.email,
        id=__ret__.id,
        invitation_sent=__ret__.invitation_sent,
        invitation_state=__ret__.invitation_state,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        registration_state=__ret__.registration_state,
        system_data=__ret__.system_data,
        total_usage=__ret__.total_usage,
        type=__ret__.type)


@_utilities.lift_output_func(get_user)
def get_user_output(lab_name: Optional[pulumi.Input[str]] = None,
                    resource_group_name: Optional[pulumi.Input[str]] = None,
                    user_name: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    User of a lab that can register for and use virtual machines within the lab.


    :param str lab_name: The name of the lab that uniquely identifies it within containing lab account. Used in resource URIs.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str user_name: The name of the user that uniquely identifies it within containing lab. Used in resource URIs.
    """
    ...
