# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AcsChatChannelArgs',
    'AlexaChannelPropertiesArgs',
    'AlexaChannelArgs',
    'BotPropertiesArgs',
    'ConnectionSettingParameterArgs',
    'ConnectionSettingPropertiesArgs',
    'DirectLineChannelPropertiesArgs',
    'DirectLineChannelArgs',
    'DirectLineSiteArgs',
    'DirectLineSpeechChannelPropertiesArgs',
    'DirectLineSpeechChannelArgs',
    'EmailChannelPropertiesArgs',
    'EmailChannelArgs',
    'EnterpriseChannelNodeArgs',
    'EnterpriseChannelPropertiesArgs',
    'FacebookChannelPropertiesArgs',
    'FacebookChannelArgs',
    'FacebookPageArgs',
    'KikChannelPropertiesArgs',
    'KikChannelArgs',
    'LineChannelPropertiesArgs',
    'LineChannelArgs',
    'LineRegistrationArgs',
    'M365ExtensionsArgs',
    'MsTeamsChannelPropertiesArgs',
    'MsTeamsChannelArgs',
    'OmnichannelArgs',
    'OutlookChannelArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'SearchAssistantArgs',
    'SkuArgs',
    'SkypeChannelPropertiesArgs',
    'SkypeChannelArgs',
    'SlackChannelPropertiesArgs',
    'SlackChannelArgs',
    'SmsChannelPropertiesArgs',
    'SmsChannelArgs',
    'TelegramChannelPropertiesArgs',
    'TelegramChannelArgs',
    'TelephonyChannelPropertiesArgs',
    'TelephonyChannelResourceApiConfigurationArgs',
    'TelephonyChannelArgs',
    'TelephonyPhoneNumbersArgs',
    'WebChatChannelPropertiesArgs',
    'WebChatChannelArgs',
    'WebChatSiteArgs',
]

@pulumi.input_type
class AcsChatChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None):
        """
        AcsChat channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'AcsChatChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        """
        pulumi.set(__self__, "channel_name", 'AcsChatChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'AcsChatChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class AlexaChannelPropertiesArgs:
    def __init__(__self__, *,
                 alexa_skill_id: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool]):
        """
        The parameters to provide for the Alexa channel.
        :param pulumi.Input[str] alexa_skill_id: The Alexa skill Id
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        """
        pulumi.set(__self__, "alexa_skill_id", alexa_skill_id)
        pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="alexaSkillId")
    def alexa_skill_id(self) -> pulumi.Input[str]:
        """
        The Alexa skill Id
        """
        return pulumi.get(self, "alexa_skill_id")

    @alexa_skill_id.setter
    def alexa_skill_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "alexa_skill_id", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)


@pulumi.input_type
class AlexaChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['AlexaChannelPropertiesArgs']] = None):
        """
        Alexa channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'AlexaChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['AlexaChannelPropertiesArgs'] properties: The set of properties specific to Alexa channel resource
        """
        pulumi.set(__self__, "channel_name", 'AlexaChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'AlexaChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AlexaChannelPropertiesArgs']]:
        """
        The set of properties specific to Alexa channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AlexaChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class BotPropertiesArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 endpoint: pulumi.Input[str],
                 msa_app_id: pulumi.Input[str],
                 all_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 app_password_hint: Optional[pulumi.Input[str]] = None,
                 cmek_key_vault_url: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 developer_app_insight_key: Optional[pulumi.Input[str]] = None,
                 developer_app_insights_api_key: Optional[pulumi.Input[str]] = None,
                 developer_app_insights_application_id: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 icon_url: Optional[pulumi.Input[str]] = None,
                 is_cmek_enabled: Optional[pulumi.Input[bool]] = None,
                 is_streaming_supported: Optional[pulumi.Input[bool]] = None,
                 luis_app_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 luis_key: Optional[pulumi.Input[str]] = None,
                 manifest_url: Optional[pulumi.Input[str]] = None,
                 msa_app_msi_resource_id: Optional[pulumi.Input[str]] = None,
                 msa_app_tenant_id: Optional[pulumi.Input[str]] = None,
                 msa_app_type: Optional[pulumi.Input[Union[str, 'MsaAppType']]] = None,
                 open_with_hint: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 public_network_access: Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]] = None,
                 publishing_credentials: Optional[pulumi.Input[str]] = None,
                 schema_transformation_version: Optional[pulumi.Input[str]] = None,
                 storage_resource_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        The parameters to provide for the Bot.
        :param pulumi.Input[str] display_name: The Name of the bot
        :param pulumi.Input[str] endpoint: The bot's endpoint
        :param pulumi.Input[str] msa_app_id: Microsoft App Id for the bot
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] all_settings: Contains resource all settings defined as key/value pairs.
        :param pulumi.Input[str] app_password_hint: The hint (e.g. keyVault secret resourceId) on how to fetch the app secret
        :param pulumi.Input[str] cmek_key_vault_url: The CMK Url
        :param pulumi.Input[str] description: The description of the bot
        :param pulumi.Input[str] developer_app_insight_key: The Application Insights key
        :param pulumi.Input[str] developer_app_insights_api_key: The Application Insights Api Key
        :param pulumi.Input[str] developer_app_insights_application_id: The Application Insights App Id
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
        :param pulumi.Input[str] icon_url: The Icon Url of the bot
        :param pulumi.Input[bool] is_cmek_enabled: Whether Cmek is enabled
        :param pulumi.Input[bool] is_streaming_supported: Whether the bot is streaming supported
        :param pulumi.Input[Sequence[pulumi.Input[str]]] luis_app_ids: Collection of LUIS App Ids
        :param pulumi.Input[str] luis_key: The LUIS Key
        :param pulumi.Input[str] manifest_url: The bot's manifest url
        :param pulumi.Input[str] msa_app_msi_resource_id: Microsoft App Managed Identity Resource Id for the bot
        :param pulumi.Input[str] msa_app_tenant_id: Microsoft App Tenant Id for the bot
        :param pulumi.Input[Union[str, 'MsaAppType']] msa_app_type: Microsoft App Type for the bot
        :param pulumi.Input[str] open_with_hint: The hint to browser (e.g. protocol handler) on how to open the bot for authoring
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Contains resource parameters defined as key/value pairs.
        :param pulumi.Input[Union[str, 'PublicNetworkAccess']] public_network_access: Whether the bot is in an isolated network
        :param pulumi.Input[str] publishing_credentials: Publishing credentials of the resource
        :param pulumi.Input[str] schema_transformation_version: The channel schema transformation version for the bot
        :param pulumi.Input[str] storage_resource_id: The storage resourceId for the bot
        :param pulumi.Input[str] tenant_id: The Tenant Id for the bot
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "msa_app_id", msa_app_id)
        if all_settings is not None:
            pulumi.set(__self__, "all_settings", all_settings)
        if app_password_hint is not None:
            pulumi.set(__self__, "app_password_hint", app_password_hint)
        if cmek_key_vault_url is not None:
            pulumi.set(__self__, "cmek_key_vault_url", cmek_key_vault_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if developer_app_insight_key is not None:
            pulumi.set(__self__, "developer_app_insight_key", developer_app_insight_key)
        if developer_app_insights_api_key is not None:
            pulumi.set(__self__, "developer_app_insights_api_key", developer_app_insights_api_key)
        if developer_app_insights_application_id is not None:
            pulumi.set(__self__, "developer_app_insights_application_id", developer_app_insights_application_id)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if icon_url is None:
            icon_url = ''
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if is_cmek_enabled is None:
            is_cmek_enabled = False
        if is_cmek_enabled is not None:
            pulumi.set(__self__, "is_cmek_enabled", is_cmek_enabled)
        if is_streaming_supported is None:
            is_streaming_supported = False
        if is_streaming_supported is not None:
            pulumi.set(__self__, "is_streaming_supported", is_streaming_supported)
        if luis_app_ids is not None:
            pulumi.set(__self__, "luis_app_ids", luis_app_ids)
        if luis_key is not None:
            pulumi.set(__self__, "luis_key", luis_key)
        if manifest_url is not None:
            pulumi.set(__self__, "manifest_url", manifest_url)
        if msa_app_msi_resource_id is not None:
            pulumi.set(__self__, "msa_app_msi_resource_id", msa_app_msi_resource_id)
        if msa_app_tenant_id is not None:
            pulumi.set(__self__, "msa_app_tenant_id", msa_app_tenant_id)
        if msa_app_type is not None:
            pulumi.set(__self__, "msa_app_type", msa_app_type)
        if open_with_hint is not None:
            pulumi.set(__self__, "open_with_hint", open_with_hint)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if public_network_access is None:
            public_network_access = 'Enabled'
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if publishing_credentials is not None:
            pulumi.set(__self__, "publishing_credentials", publishing_credentials)
        if schema_transformation_version is not None:
            pulumi.set(__self__, "schema_transformation_version", schema_transformation_version)
        if storage_resource_id is not None:
            pulumi.set(__self__, "storage_resource_id", storage_resource_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The Name of the bot
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        The bot's endpoint
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="msaAppId")
    def msa_app_id(self) -> pulumi.Input[str]:
        """
        Microsoft App Id for the bot
        """
        return pulumi.get(self, "msa_app_id")

    @msa_app_id.setter
    def msa_app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "msa_app_id", value)

    @property
    @pulumi.getter(name="allSettings")
    def all_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Contains resource all settings defined as key/value pairs.
        """
        return pulumi.get(self, "all_settings")

    @all_settings.setter
    def all_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "all_settings", value)

    @property
    @pulumi.getter(name="appPasswordHint")
    def app_password_hint(self) -> Optional[pulumi.Input[str]]:
        """
        The hint (e.g. keyVault secret resourceId) on how to fetch the app secret
        """
        return pulumi.get(self, "app_password_hint")

    @app_password_hint.setter
    def app_password_hint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_password_hint", value)

    @property
    @pulumi.getter(name="cmekKeyVaultUrl")
    def cmek_key_vault_url(self) -> Optional[pulumi.Input[str]]:
        """
        The CMK Url
        """
        return pulumi.get(self, "cmek_key_vault_url")

    @cmek_key_vault_url.setter
    def cmek_key_vault_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cmek_key_vault_url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the bot
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="developerAppInsightKey")
    def developer_app_insight_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Application Insights key
        """
        return pulumi.get(self, "developer_app_insight_key")

    @developer_app_insight_key.setter
    def developer_app_insight_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "developer_app_insight_key", value)

    @property
    @pulumi.getter(name="developerAppInsightsApiKey")
    def developer_app_insights_api_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Application Insights Api Key
        """
        return pulumi.get(self, "developer_app_insights_api_key")

    @developer_app_insights_api_key.setter
    def developer_app_insights_api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "developer_app_insights_api_key", value)

    @property
    @pulumi.getter(name="developerAppInsightsApplicationId")
    def developer_app_insights_application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Application Insights App Id
        """
        return pulumi.get(self, "developer_app_insights_application_id")

    @developer_app_insights_application_id.setter
    def developer_app_insights_application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "developer_app_insights_application_id", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Icon Url of the bot
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_url", value)

    @property
    @pulumi.getter(name="isCmekEnabled")
    def is_cmek_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Cmek is enabled
        """
        return pulumi.get(self, "is_cmek_enabled")

    @is_cmek_enabled.setter
    def is_cmek_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cmek_enabled", value)

    @property
    @pulumi.getter(name="isStreamingSupported")
    def is_streaming_supported(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the bot is streaming supported
        """
        return pulumi.get(self, "is_streaming_supported")

    @is_streaming_supported.setter
    def is_streaming_supported(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_streaming_supported", value)

    @property
    @pulumi.getter(name="luisAppIds")
    def luis_app_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Collection of LUIS App Ids
        """
        return pulumi.get(self, "luis_app_ids")

    @luis_app_ids.setter
    def luis_app_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "luis_app_ids", value)

    @property
    @pulumi.getter(name="luisKey")
    def luis_key(self) -> Optional[pulumi.Input[str]]:
        """
        The LUIS Key
        """
        return pulumi.get(self, "luis_key")

    @luis_key.setter
    def luis_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "luis_key", value)

    @property
    @pulumi.getter(name="manifestUrl")
    def manifest_url(self) -> Optional[pulumi.Input[str]]:
        """
        The bot's manifest url
        """
        return pulumi.get(self, "manifest_url")

    @manifest_url.setter
    def manifest_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_url", value)

    @property
    @pulumi.getter(name="msaAppMSIResourceId")
    def msa_app_msi_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Microsoft App Managed Identity Resource Id for the bot
        """
        return pulumi.get(self, "msa_app_msi_resource_id")

    @msa_app_msi_resource_id.setter
    def msa_app_msi_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "msa_app_msi_resource_id", value)

    @property
    @pulumi.getter(name="msaAppTenantId")
    def msa_app_tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Microsoft App Tenant Id for the bot
        """
        return pulumi.get(self, "msa_app_tenant_id")

    @msa_app_tenant_id.setter
    def msa_app_tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "msa_app_tenant_id", value)

    @property
    @pulumi.getter(name="msaAppType")
    def msa_app_type(self) -> Optional[pulumi.Input[Union[str, 'MsaAppType']]]:
        """
        Microsoft App Type for the bot
        """
        return pulumi.get(self, "msa_app_type")

    @msa_app_type.setter
    def msa_app_type(self, value: Optional[pulumi.Input[Union[str, 'MsaAppType']]]):
        pulumi.set(self, "msa_app_type", value)

    @property
    @pulumi.getter(name="openWithHint")
    def open_with_hint(self) -> Optional[pulumi.Input[str]]:
        """
        The hint to browser (e.g. protocol handler) on how to open the bot for authoring
        """
        return pulumi.get(self, "open_with_hint")

    @open_with_hint.setter
    def open_with_hint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "open_with_hint", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Contains resource parameters defined as key/value pairs.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]]:
        """
        Whether the bot is in an isolated network
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[Union[str, 'PublicNetworkAccess']]]):
        pulumi.set(self, "public_network_access", value)

    @property
    @pulumi.getter(name="publishingCredentials")
    def publishing_credentials(self) -> Optional[pulumi.Input[str]]:
        """
        Publishing credentials of the resource
        """
        return pulumi.get(self, "publishing_credentials")

    @publishing_credentials.setter
    def publishing_credentials(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publishing_credentials", value)

    @property
    @pulumi.getter(name="schemaTransformationVersion")
    def schema_transformation_version(self) -> Optional[pulumi.Input[str]]:
        """
        The channel schema transformation version for the bot
        """
        return pulumi.get(self, "schema_transformation_version")

    @schema_transformation_version.setter
    def schema_transformation_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_transformation_version", value)

    @property
    @pulumi.getter(name="storageResourceId")
    def storage_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The storage resourceId for the bot
        """
        return pulumi.get(self, "storage_resource_id")

    @storage_resource_id.setter
    def storage_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_resource_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Tenant Id for the bot
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class ConnectionSettingParameterArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Extra Parameter in a Connection Setting Properties to indicate service provider specific properties
        :param pulumi.Input[str] key: Key for the Connection Setting Parameter.
        :param pulumi.Input[str] value: Value associated with the Connection Setting Parameter.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key for the Connection Setting Parameter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value associated with the Connection Setting Parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ConnectionSettingPropertiesArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionSettingParameterArgs']]]] = None,
                 provisioning_state: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[str]] = None,
                 service_provider_display_name: Optional[pulumi.Input[str]] = None,
                 service_provider_id: Optional[pulumi.Input[str]] = None):
        """
        Properties for a Connection Setting Item
        :param pulumi.Input[str] client_id: Client Id associated with the Connection Setting.
        :param pulumi.Input[str] client_secret: Client Secret associated with the Connection Setting
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionSettingParameterArgs']]] parameters: Service Provider Parameters associated with the Connection Setting
        :param pulumi.Input[str] provisioning_state: Provisioning state of the resource
        :param pulumi.Input[str] scopes: Scopes associated with the Connection Setting
        :param pulumi.Input[str] service_provider_display_name: Service Provider Display Name associated with the Connection Setting
        :param pulumi.Input[str] service_provider_id: Service Provider Id associated with the Connection Setting
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if scopes is None:
            scopes = ''
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if service_provider_display_name is not None:
            pulumi.set(__self__, "service_provider_display_name", service_provider_display_name)
        if service_provider_id is not None:
            pulumi.set(__self__, "service_provider_id", service_provider_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client Id associated with the Connection Setting.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Client Secret associated with the Connection Setting
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionSettingParameterArgs']]]]:
        """
        Service Provider Parameters associated with the Connection Setting
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionSettingParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[pulumi.Input[str]]:
        """
        Provisioning state of the resource
        """
        return pulumi.get(self, "provisioning_state")

    @provisioning_state.setter
    def provisioning_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_state", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[str]]:
        """
        Scopes associated with the Connection Setting
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="serviceProviderDisplayName")
    def service_provider_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Service Provider Display Name associated with the Connection Setting
        """
        return pulumi.get(self, "service_provider_display_name")

    @service_provider_display_name.setter
    def service_provider_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_provider_display_name", value)

    @property
    @pulumi.getter(name="serviceProviderId")
    def service_provider_id(self) -> Optional[pulumi.Input[str]]:
        """
        Service Provider Id associated with the Connection Setting
        """
        return pulumi.get(self, "service_provider_id")

    @service_provider_id.setter
    def service_provider_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_provider_id", value)


@pulumi.input_type
class DirectLineChannelPropertiesArgs:
    def __init__(__self__, *,
                 direct_line_embed_code: Optional[pulumi.Input[str]] = None,
                 extension_key1: Optional[pulumi.Input[str]] = None,
                 extension_key2: Optional[pulumi.Input[str]] = None,
                 sites: Optional[pulumi.Input[Sequence[pulumi.Input['DirectLineSiteArgs']]]] = None):
        """
        The parameters to provide for the Direct Line channel.
        :param pulumi.Input[str] direct_line_embed_code: Direct Line embed code of the resource
        :param pulumi.Input[str] extension_key1: The extensionKey1
        :param pulumi.Input[str] extension_key2: The extensionKey2
        :param pulumi.Input[Sequence[pulumi.Input['DirectLineSiteArgs']]] sites: The list of Direct Line sites
        """
        if direct_line_embed_code is not None:
            pulumi.set(__self__, "direct_line_embed_code", direct_line_embed_code)
        if extension_key1 is None:
            extension_key1 = ''
        if extension_key1 is not None:
            pulumi.set(__self__, "extension_key1", extension_key1)
        if extension_key2 is None:
            extension_key2 = ''
        if extension_key2 is not None:
            pulumi.set(__self__, "extension_key2", extension_key2)
        if sites is not None:
            pulumi.set(__self__, "sites", sites)

    @property
    @pulumi.getter(name="directLineEmbedCode")
    def direct_line_embed_code(self) -> Optional[pulumi.Input[str]]:
        """
        Direct Line embed code of the resource
        """
        return pulumi.get(self, "direct_line_embed_code")

    @direct_line_embed_code.setter
    def direct_line_embed_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direct_line_embed_code", value)

    @property
    @pulumi.getter(name="extensionKey1")
    def extension_key1(self) -> Optional[pulumi.Input[str]]:
        """
        The extensionKey1
        """
        return pulumi.get(self, "extension_key1")

    @extension_key1.setter
    def extension_key1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension_key1", value)

    @property
    @pulumi.getter(name="extensionKey2")
    def extension_key2(self) -> Optional[pulumi.Input[str]]:
        """
        The extensionKey2
        """
        return pulumi.get(self, "extension_key2")

    @extension_key2.setter
    def extension_key2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension_key2", value)

    @property
    @pulumi.getter
    def sites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DirectLineSiteArgs']]]]:
        """
        The list of Direct Line sites
        """
        return pulumi.get(self, "sites")

    @sites.setter
    def sites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DirectLineSiteArgs']]]]):
        pulumi.set(self, "sites", value)


@pulumi.input_type
class DirectLineChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['DirectLineChannelPropertiesArgs']] = None):
        """
        Direct Line channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'DirectLineChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['DirectLineChannelPropertiesArgs'] properties: The set of properties specific to Direct Line channel resource
        """
        pulumi.set(__self__, "channel_name", 'DirectLineChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'DirectLineChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DirectLineChannelPropertiesArgs']]:
        """
        The set of properties specific to Direct Line channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DirectLineChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class DirectLineSiteArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 is_v1_enabled: pulumi.Input[bool],
                 is_v3_enabled: pulumi.Input[bool],
                 site_name: pulumi.Input[str],
                 app_id: Optional[pulumi.Input[str]] = None,
                 e_tag: Optional[pulumi.Input[str]] = None,
                 is_block_user_upload_enabled: Optional[pulumi.Input[bool]] = None,
                 is_detailed_logging_enabled: Optional[pulumi.Input[bool]] = None,
                 is_endpoint_parameters_enabled: Optional[pulumi.Input[bool]] = None,
                 is_no_storage_enabled: Optional[pulumi.Input[bool]] = None,
                 is_secure_site_enabled: Optional[pulumi.Input[bool]] = None,
                 is_web_chat_speech_enabled: Optional[pulumi.Input[bool]] = None,
                 is_webchat_preview_enabled: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 trusted_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A site for the Direct Line channel
        :param pulumi.Input[bool] is_enabled: Whether this site is enabled for DirectLine channel
        :param pulumi.Input[bool] is_v1_enabled: Whether this site is enabled for Bot Framework V1 protocol.
        :param pulumi.Input[bool] is_v3_enabled: Whether this site is enabled for Bot Framework V3 protocol.
        :param pulumi.Input[str] site_name: Site name
        :param pulumi.Input[str] app_id: DirectLine application id
        :param pulumi.Input[str] e_tag: Entity Tag
        :param pulumi.Input[bool] is_block_user_upload_enabled: Whether this site is enabled for block user upload.
        :param pulumi.Input[bool] is_detailed_logging_enabled: Whether this site is disabled detailed logging for
        :param pulumi.Input[bool] is_endpoint_parameters_enabled: Whether this site is EndpointParameters enabled for channel
        :param pulumi.Input[bool] is_no_storage_enabled: Whether this no-storage site is disabled detailed logging for
        :param pulumi.Input[bool] is_secure_site_enabled: Whether this site is enabled for authentication with Bot Framework.
        :param pulumi.Input[bool] is_web_chat_speech_enabled: Whether this site is enabled for Webchat Speech
        :param pulumi.Input[bool] is_webchat_preview_enabled: Whether this site is enabled for preview versions of Webchat
        :param pulumi.Input[str] tenant_id: Tenant Id
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trusted_origins: List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "is_v1_enabled", is_v1_enabled)
        pulumi.set(__self__, "is_v3_enabled", is_v3_enabled)
        pulumi.set(__self__, "site_name", site_name)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if is_block_user_upload_enabled is not None:
            pulumi.set(__self__, "is_block_user_upload_enabled", is_block_user_upload_enabled)
        if is_detailed_logging_enabled is not None:
            pulumi.set(__self__, "is_detailed_logging_enabled", is_detailed_logging_enabled)
        if is_endpoint_parameters_enabled is not None:
            pulumi.set(__self__, "is_endpoint_parameters_enabled", is_endpoint_parameters_enabled)
        if is_no_storage_enabled is not None:
            pulumi.set(__self__, "is_no_storage_enabled", is_no_storage_enabled)
        if is_secure_site_enabled is not None:
            pulumi.set(__self__, "is_secure_site_enabled", is_secure_site_enabled)
        if is_web_chat_speech_enabled is None:
            is_web_chat_speech_enabled = False
        if is_web_chat_speech_enabled is not None:
            pulumi.set(__self__, "is_web_chat_speech_enabled", is_web_chat_speech_enabled)
        if is_webchat_preview_enabled is None:
            is_webchat_preview_enabled = False
        if is_webchat_preview_enabled is not None:
            pulumi.set(__self__, "is_webchat_preview_enabled", is_webchat_preview_enabled)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if trusted_origins is not None:
            pulumi.set(__self__, "trusted_origins", trusted_origins)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this site is enabled for DirectLine channel
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="isV1Enabled")
    def is_v1_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this site is enabled for Bot Framework V1 protocol.
        """
        return pulumi.get(self, "is_v1_enabled")

    @is_v1_enabled.setter
    def is_v1_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_v1_enabled", value)

    @property
    @pulumi.getter(name="isV3Enabled")
    def is_v3_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this site is enabled for Bot Framework V3 protocol.
        """
        return pulumi.get(self, "is_v3_enabled")

    @is_v3_enabled.setter
    def is_v3_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_v3_enabled", value)

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> pulumi.Input[str]:
        """
        Site name
        """
        return pulumi.get(self, "site_name")

    @site_name.setter
    def site_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_name", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        DirectLine application id
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag
        """
        return pulumi.get(self, "e_tag")

    @e_tag.setter
    def e_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "e_tag", value)

    @property
    @pulumi.getter(name="isBlockUserUploadEnabled")
    def is_block_user_upload_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is enabled for block user upload.
        """
        return pulumi.get(self, "is_block_user_upload_enabled")

    @is_block_user_upload_enabled.setter
    def is_block_user_upload_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_block_user_upload_enabled", value)

    @property
    @pulumi.getter(name="isDetailedLoggingEnabled")
    def is_detailed_logging_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is disabled detailed logging for
        """
        return pulumi.get(self, "is_detailed_logging_enabled")

    @is_detailed_logging_enabled.setter
    def is_detailed_logging_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_detailed_logging_enabled", value)

    @property
    @pulumi.getter(name="isEndpointParametersEnabled")
    def is_endpoint_parameters_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is EndpointParameters enabled for channel
        """
        return pulumi.get(self, "is_endpoint_parameters_enabled")

    @is_endpoint_parameters_enabled.setter
    def is_endpoint_parameters_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_endpoint_parameters_enabled", value)

    @property
    @pulumi.getter(name="isNoStorageEnabled")
    def is_no_storage_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this no-storage site is disabled detailed logging for
        """
        return pulumi.get(self, "is_no_storage_enabled")

    @is_no_storage_enabled.setter
    def is_no_storage_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_no_storage_enabled", value)

    @property
    @pulumi.getter(name="isSecureSiteEnabled")
    def is_secure_site_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is enabled for authentication with Bot Framework.
        """
        return pulumi.get(self, "is_secure_site_enabled")

    @is_secure_site_enabled.setter
    def is_secure_site_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secure_site_enabled", value)

    @property
    @pulumi.getter(name="isWebChatSpeechEnabled")
    def is_web_chat_speech_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is enabled for Webchat Speech
        """
        return pulumi.get(self, "is_web_chat_speech_enabled")

    @is_web_chat_speech_enabled.setter
    def is_web_chat_speech_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_web_chat_speech_enabled", value)

    @property
    @pulumi.getter(name="isWebchatPreviewEnabled")
    def is_webchat_preview_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is enabled for preview versions of Webchat
        """
        return pulumi.get(self, "is_webchat_preview_enabled")

    @is_webchat_preview_enabled.setter
    def is_webchat_preview_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_webchat_preview_enabled", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="trustedOrigins")
    def trusted_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
        """
        return pulumi.get(self, "trusted_origins")

    @trusted_origins.setter
    def trusted_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trusted_origins", value)


@pulumi.input_type
class DirectLineSpeechChannelPropertiesArgs:
    def __init__(__self__, *,
                 cognitive_service_region: Optional[pulumi.Input[str]] = None,
                 cognitive_service_resource_id: Optional[pulumi.Input[str]] = None,
                 cognitive_service_subscription_key: Optional[pulumi.Input[str]] = None,
                 custom_speech_model_id: Optional[pulumi.Input[str]] = None,
                 custom_voice_deployment_id: Optional[pulumi.Input[str]] = None,
                 is_default_bot_for_cog_svc_account: Optional[pulumi.Input[bool]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The parameters to provide for the DirectLine Speech channel.
        :param pulumi.Input[str] cognitive_service_region: The cognitive service region with this channel registration.
        :param pulumi.Input[str] cognitive_service_resource_id: The cognitive service id with this channel registration.
        :param pulumi.Input[str] cognitive_service_subscription_key: The cognitive service subscription key to use with this channel registration.
        :param pulumi.Input[str] custom_speech_model_id: Custom voice deployment id (optional).
        :param pulumi.Input[str] custom_voice_deployment_id: Custom speech model id (optional).
        :param pulumi.Input[bool] is_default_bot_for_cog_svc_account: Make this a default bot for chosen cognitive service account.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled or not.
        """
        if cognitive_service_region is not None:
            pulumi.set(__self__, "cognitive_service_region", cognitive_service_region)
        if cognitive_service_resource_id is not None:
            pulumi.set(__self__, "cognitive_service_resource_id", cognitive_service_resource_id)
        if cognitive_service_subscription_key is not None:
            pulumi.set(__self__, "cognitive_service_subscription_key", cognitive_service_subscription_key)
        if custom_speech_model_id is not None:
            pulumi.set(__self__, "custom_speech_model_id", custom_speech_model_id)
        if custom_voice_deployment_id is not None:
            pulumi.set(__self__, "custom_voice_deployment_id", custom_voice_deployment_id)
        if is_default_bot_for_cog_svc_account is not None:
            pulumi.set(__self__, "is_default_bot_for_cog_svc_account", is_default_bot_for_cog_svc_account)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="cognitiveServiceRegion")
    def cognitive_service_region(self) -> Optional[pulumi.Input[str]]:
        """
        The cognitive service region with this channel registration.
        """
        return pulumi.get(self, "cognitive_service_region")

    @cognitive_service_region.setter
    def cognitive_service_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitive_service_region", value)

    @property
    @pulumi.getter(name="cognitiveServiceResourceId")
    def cognitive_service_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cognitive service id with this channel registration.
        """
        return pulumi.get(self, "cognitive_service_resource_id")

    @cognitive_service_resource_id.setter
    def cognitive_service_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitive_service_resource_id", value)

    @property
    @pulumi.getter(name="cognitiveServiceSubscriptionKey")
    def cognitive_service_subscription_key(self) -> Optional[pulumi.Input[str]]:
        """
        The cognitive service subscription key to use with this channel registration.
        """
        return pulumi.get(self, "cognitive_service_subscription_key")

    @cognitive_service_subscription_key.setter
    def cognitive_service_subscription_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitive_service_subscription_key", value)

    @property
    @pulumi.getter(name="customSpeechModelId")
    def custom_speech_model_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom voice deployment id (optional).
        """
        return pulumi.get(self, "custom_speech_model_id")

    @custom_speech_model_id.setter
    def custom_speech_model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_speech_model_id", value)

    @property
    @pulumi.getter(name="customVoiceDeploymentId")
    def custom_voice_deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom speech model id (optional).
        """
        return pulumi.get(self, "custom_voice_deployment_id")

    @custom_voice_deployment_id.setter
    def custom_voice_deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_voice_deployment_id", value)

    @property
    @pulumi.getter(name="isDefaultBotForCogSvcAccount")
    def is_default_bot_for_cog_svc_account(self) -> Optional[pulumi.Input[bool]]:
        """
        Make this a default bot for chosen cognitive service account.
        """
        return pulumi.get(self, "is_default_bot_for_cog_svc_account")

    @is_default_bot_for_cog_svc_account.setter
    def is_default_bot_for_cog_svc_account(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default_bot_for_cog_svc_account", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this channel is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)


@pulumi.input_type
class DirectLineSpeechChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['DirectLineSpeechChannelPropertiesArgs']] = None):
        """
        DirectLine Speech channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'DirectLineSpeechChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['DirectLineSpeechChannelPropertiesArgs'] properties: The set of properties specific to DirectLine Speech channel resource
        """
        pulumi.set(__self__, "channel_name", 'DirectLineSpeechChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'DirectLineSpeechChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DirectLineSpeechChannelPropertiesArgs']]:
        """
        The set of properties specific to DirectLine Speech channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DirectLineSpeechChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class EmailChannelPropertiesArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 auth_method: Optional[pulumi.Input[float]] = None,
                 magic_code: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None):
        """
        The parameters to provide for the Email channel.
        :param pulumi.Input[str] email_address: The email address
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[float] auth_method: Email channel auth method. 0 Password (Default); 1 Graph.
        :param pulumi.Input[str] magic_code: The magic code for setting up the modern authentication.
        :param pulumi.Input[str] password: The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "is_enabled", is_enabled)
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if magic_code is not None:
            pulumi.set(__self__, "magic_code", magic_code)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        """
        The email address
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[pulumi.Input[float]]:
        """
        Email channel auth method. 0 Password (Default); 1 Graph.
        """
        return pulumi.get(self, "auth_method")

    @auth_method.setter
    def auth_method(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "auth_method", value)

    @property
    @pulumi.getter(name="magicCode")
    def magic_code(self) -> Optional[pulumi.Input[str]]:
        """
        The magic code for setting up the modern authentication.
        """
        return pulumi.get(self, "magic_code")

    @magic_code.setter
    def magic_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "magic_code", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class EmailChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['EmailChannelPropertiesArgs']] = None):
        """
        Email channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'EmailChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['EmailChannelPropertiesArgs'] properties: The set of properties specific to email channel resource
        """
        pulumi.set(__self__, "channel_name", 'EmailChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'EmailChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['EmailChannelPropertiesArgs']]:
        """
        The set of properties specific to email channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['EmailChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class EnterpriseChannelNodeArgs:
    def __init__(__self__, *,
                 azure_location: pulumi.Input[str],
                 azure_sku: pulumi.Input[str],
                 name: pulumi.Input[str],
                 state: Optional[pulumi.Input[Union[str, 'EnterpriseChannelNodeState']]] = None):
        """
        The properties specific to an Enterprise Channel Node.
        :param pulumi.Input[str] azure_location: The location of the Enterprise Channel Node.
        :param pulumi.Input[str] azure_sku: The sku of the Enterprise Channel Node.
        :param pulumi.Input[str] name: The name of the Enterprise Channel Node.
        :param pulumi.Input[Union[str, 'EnterpriseChannelNodeState']] state: The current state of the Enterprise Channel Node.
        """
        pulumi.set(__self__, "azure_location", azure_location)
        pulumi.set(__self__, "azure_sku", azure_sku)
        pulumi.set(__self__, "name", name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="azureLocation")
    def azure_location(self) -> pulumi.Input[str]:
        """
        The location of the Enterprise Channel Node.
        """
        return pulumi.get(self, "azure_location")

    @azure_location.setter
    def azure_location(self, value: pulumi.Input[str]):
        pulumi.set(self, "azure_location", value)

    @property
    @pulumi.getter(name="azureSku")
    def azure_sku(self) -> pulumi.Input[str]:
        """
        The sku of the Enterprise Channel Node.
        """
        return pulumi.get(self, "azure_sku")

    @azure_sku.setter
    def azure_sku(self, value: pulumi.Input[str]):
        pulumi.set(self, "azure_sku", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Enterprise Channel Node.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'EnterpriseChannelNodeState']]]:
        """
        The current state of the Enterprise Channel Node.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'EnterpriseChannelNodeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class EnterpriseChannelPropertiesArgs:
    def __init__(__self__, *,
                 nodes: pulumi.Input[Sequence[pulumi.Input['EnterpriseChannelNodeArgs']]],
                 state: Optional[pulumi.Input[Union[str, 'EnterpriseChannelState']]] = None):
        """
        The parameters to provide for the Enterprise Channel.
        :param pulumi.Input[Sequence[pulumi.Input['EnterpriseChannelNodeArgs']]] nodes: The nodes associated with the Enterprise Channel.
        :param pulumi.Input[Union[str, 'EnterpriseChannelState']] state: The current state of the Enterprise Channel.
        """
        pulumi.set(__self__, "nodes", nodes)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Input[Sequence[pulumi.Input['EnterpriseChannelNodeArgs']]]:
        """
        The nodes associated with the Enterprise Channel.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: pulumi.Input[Sequence[pulumi.Input['EnterpriseChannelNodeArgs']]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'EnterpriseChannelState']]]:
        """
        The current state of the Enterprise Channel.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'EnterpriseChannelState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class FacebookChannelPropertiesArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 app_secret: Optional[pulumi.Input[str]] = None,
                 pages: Optional[pulumi.Input[Sequence[pulumi.Input['FacebookPageArgs']]]] = None):
        """
        The parameters to provide for the Facebook channel.
        :param pulumi.Input[str] app_id: Facebook application id
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] app_secret: Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[Sequence[pulumi.Input['FacebookPageArgs']]] pages: The list of Facebook pages
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        if app_secret is not None:
            pulumi.set(__self__, "app_secret", app_secret)
        if pages is not None:
            pulumi.set(__self__, "pages", pages)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        Facebook application id
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="appSecret")
    def app_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "app_secret")

    @app_secret.setter
    def app_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_secret", value)

    @property
    @pulumi.getter
    def pages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FacebookPageArgs']]]]:
        """
        The list of Facebook pages
        """
        return pulumi.get(self, "pages")

    @pages.setter
    def pages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FacebookPageArgs']]]]):
        pulumi.set(self, "pages", value)


@pulumi.input_type
class FacebookChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['FacebookChannelPropertiesArgs']] = None):
        """
        Facebook channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'FacebookChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['FacebookChannelPropertiesArgs'] properties: The set of properties specific to bot facebook channel
        """
        pulumi.set(__self__, "channel_name", 'FacebookChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'FacebookChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['FacebookChannelPropertiesArgs']]:
        """
        The set of properties specific to bot facebook channel
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['FacebookChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class FacebookPageArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 access_token: Optional[pulumi.Input[str]] = None):
        """
        A Facebook page for Facebook channel registration
        :param pulumi.Input[str] id: Page id
        :param pulumi.Input[str] access_token: Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        pulumi.set(__self__, "id", id)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Page id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)


@pulumi.input_type
class KikChannelPropertiesArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 user_name: pulumi.Input[str],
                 api_key: Optional[pulumi.Input[str]] = None,
                 is_validated: Optional[pulumi.Input[bool]] = None):
        """
        The parameters to provide for the Kik channel.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] user_name: The Kik user name
        :param pulumi.Input[str] api_key: Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[bool] is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "user_name", user_name)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        The Kik user name
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")

    @is_validated.setter
    def is_validated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_validated", value)


@pulumi.input_type
class KikChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['KikChannelPropertiesArgs']] = None):
        """
        Kik channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'KikChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['KikChannelPropertiesArgs'] properties: The set of properties specific to Kik channel resource
        """
        pulumi.set(__self__, "channel_name", 'KikChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'KikChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['KikChannelPropertiesArgs']]:
        """
        The set of properties specific to Kik channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['KikChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class LineChannelPropertiesArgs:
    def __init__(__self__, *,
                 line_registrations: pulumi.Input[Sequence[pulumi.Input['LineRegistrationArgs']]]):
        """
        The parameters to provide for the Line channel.
        :param pulumi.Input[Sequence[pulumi.Input['LineRegistrationArgs']]] line_registrations: The list of line channel registrations
        """
        pulumi.set(__self__, "line_registrations", line_registrations)

    @property
    @pulumi.getter(name="lineRegistrations")
    def line_registrations(self) -> pulumi.Input[Sequence[pulumi.Input['LineRegistrationArgs']]]:
        """
        The list of line channel registrations
        """
        return pulumi.get(self, "line_registrations")

    @line_registrations.setter
    def line_registrations(self, value: pulumi.Input[Sequence[pulumi.Input['LineRegistrationArgs']]]):
        pulumi.set(self, "line_registrations", value)


@pulumi.input_type
class LineChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['LineChannelPropertiesArgs']] = None):
        """
        Line channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'LineChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['LineChannelPropertiesArgs'] properties: The set of properties specific to line channel resource
        """
        pulumi.set(__self__, "channel_name", 'LineChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'LineChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['LineChannelPropertiesArgs']]:
        """
        The set of properties specific to line channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['LineChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class LineRegistrationArgs:
    def __init__(__self__, *,
                 channel_access_token: Optional[pulumi.Input[str]] = None,
                 channel_secret: Optional[pulumi.Input[str]] = None):
        """
        The properties corresponding to a line channel registration
        :param pulumi.Input[str] channel_access_token: Access token for the line channel registration
        :param pulumi.Input[str] channel_secret: Secret for the line channel registration
        """
        if channel_access_token is not None:
            pulumi.set(__self__, "channel_access_token", channel_access_token)
        if channel_secret is not None:
            pulumi.set(__self__, "channel_secret", channel_secret)

    @property
    @pulumi.getter(name="channelAccessToken")
    def channel_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        Access token for the line channel registration
        """
        return pulumi.get(self, "channel_access_token")

    @channel_access_token.setter
    def channel_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_access_token", value)

    @property
    @pulumi.getter(name="channelSecret")
    def channel_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Secret for the line channel registration
        """
        return pulumi.get(self, "channel_secret")

    @channel_secret.setter
    def channel_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_secret", value)


@pulumi.input_type
class M365ExtensionsArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None):
        """
        M365 Extensions definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'M365Extensions'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        """
        pulumi.set(__self__, "channel_name", 'M365Extensions')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'M365Extensions'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class MsTeamsChannelPropertiesArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 accepted_terms: Optional[pulumi.Input[bool]] = None,
                 calling_webhook: Optional[pulumi.Input[str]] = None,
                 deployment_environment: Optional[pulumi.Input[str]] = None,
                 enable_calling: Optional[pulumi.Input[bool]] = None,
                 incoming_call_route: Optional[pulumi.Input[str]] = None):
        """
        The parameters to provide for the Microsoft Teams channel.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[bool] accepted_terms: Whether this channel accepted terms
        :param pulumi.Input[str] calling_webhook: Webhook for Microsoft Teams channel calls
        :param pulumi.Input[str] deployment_environment: Deployment environment for Microsoft Teams channel calls
        :param pulumi.Input[bool] enable_calling: Enable calling for Microsoft Teams channel
        :param pulumi.Input[str] incoming_call_route: Webhook for Microsoft Teams channel calls
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if accepted_terms is not None:
            pulumi.set(__self__, "accepted_terms", accepted_terms)
        if calling_webhook is not None:
            pulumi.set(__self__, "calling_webhook", calling_webhook)
        if deployment_environment is None:
            deployment_environment = 'FallbackDeploymentEnvironment'
        if deployment_environment is not None:
            pulumi.set(__self__, "deployment_environment", deployment_environment)
        if enable_calling is None:
            enable_calling = False
        if enable_calling is not None:
            pulumi.set(__self__, "enable_calling", enable_calling)
        if incoming_call_route is not None:
            pulumi.set(__self__, "incoming_call_route", incoming_call_route)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="acceptedTerms")
    def accepted_terms(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this channel accepted terms
        """
        return pulumi.get(self, "accepted_terms")

    @accepted_terms.setter
    def accepted_terms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "accepted_terms", value)

    @property
    @pulumi.getter(name="callingWebhook")
    def calling_webhook(self) -> Optional[pulumi.Input[str]]:
        """
        Webhook for Microsoft Teams channel calls
        """
        return pulumi.get(self, "calling_webhook")

    @calling_webhook.setter
    def calling_webhook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "calling_webhook", value)

    @property
    @pulumi.getter(name="deploymentEnvironment")
    def deployment_environment(self) -> Optional[pulumi.Input[str]]:
        """
        Deployment environment for Microsoft Teams channel calls
        """
        return pulumi.get(self, "deployment_environment")

    @deployment_environment.setter
    def deployment_environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_environment", value)

    @property
    @pulumi.getter(name="enableCalling")
    def enable_calling(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable calling for Microsoft Teams channel
        """
        return pulumi.get(self, "enable_calling")

    @enable_calling.setter
    def enable_calling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_calling", value)

    @property
    @pulumi.getter(name="incomingCallRoute")
    def incoming_call_route(self) -> Optional[pulumi.Input[str]]:
        """
        Webhook for Microsoft Teams channel calls
        """
        return pulumi.get(self, "incoming_call_route")

    @incoming_call_route.setter
    def incoming_call_route(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "incoming_call_route", value)


@pulumi.input_type
class MsTeamsChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['MsTeamsChannelPropertiesArgs']] = None):
        """
        Microsoft Teams channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'MsTeamsChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['MsTeamsChannelPropertiesArgs'] properties: The set of properties specific to Microsoft Teams channel resource
        """
        pulumi.set(__self__, "channel_name", 'MsTeamsChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'MsTeamsChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['MsTeamsChannelPropertiesArgs']]:
        """
        The set of properties specific to Microsoft Teams channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['MsTeamsChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class OmnichannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None):
        """
        Omnichannel channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'Omnichannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        """
        pulumi.set(__self__, "channel_name", 'Omnichannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'Omnichannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class OutlookChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None):
        """
        Outlook channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'OutlookChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        """
        pulumi.set(__self__, "channel_name", 'OutlookChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'OutlookChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class SearchAssistantArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None):
        """
        SearchAssistant definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'SearchAssistant'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        """
        pulumi.set(__self__, "channel_name", 'SearchAssistant')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'SearchAssistant'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']]):
        """
        The SKU of the cognitive services account.
        :param pulumi.Input[Union[str, 'SkuName']] name: The sku name
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        The sku name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SkypeChannelPropertiesArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 calling_web_hook: Optional[pulumi.Input[str]] = None,
                 enable_calling: Optional[pulumi.Input[bool]] = None,
                 enable_groups: Optional[pulumi.Input[bool]] = None,
                 enable_media_cards: Optional[pulumi.Input[bool]] = None,
                 enable_messaging: Optional[pulumi.Input[bool]] = None,
                 enable_screen_sharing: Optional[pulumi.Input[bool]] = None,
                 enable_video: Optional[pulumi.Input[bool]] = None,
                 groups_mode: Optional[pulumi.Input[str]] = None,
                 incoming_call_route: Optional[pulumi.Input[str]] = None):
        """
        The parameters to provide for the Microsoft Teams channel.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] calling_web_hook: Calling web hook for Skype channel
        :param pulumi.Input[bool] enable_calling: Enable calling for Skype channel
        :param pulumi.Input[bool] enable_groups: Enable groups for Skype channel
        :param pulumi.Input[bool] enable_media_cards: Enable media cards for Skype channel
        :param pulumi.Input[bool] enable_messaging: Enable messaging for Skype channel
        :param pulumi.Input[bool] enable_screen_sharing: Enable screen sharing for Skype channel
        :param pulumi.Input[bool] enable_video: Enable video for Skype channel
        :param pulumi.Input[str] groups_mode: Group mode for Skype channel
        :param pulumi.Input[str] incoming_call_route: Incoming call route for Skype channel
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if calling_web_hook is not None:
            pulumi.set(__self__, "calling_web_hook", calling_web_hook)
        if enable_calling is None:
            enable_calling = False
        if enable_calling is not None:
            pulumi.set(__self__, "enable_calling", enable_calling)
        if enable_groups is not None:
            pulumi.set(__self__, "enable_groups", enable_groups)
        if enable_media_cards is not None:
            pulumi.set(__self__, "enable_media_cards", enable_media_cards)
        if enable_messaging is not None:
            pulumi.set(__self__, "enable_messaging", enable_messaging)
        if enable_screen_sharing is not None:
            pulumi.set(__self__, "enable_screen_sharing", enable_screen_sharing)
        if enable_video is not None:
            pulumi.set(__self__, "enable_video", enable_video)
        if groups_mode is not None:
            pulumi.set(__self__, "groups_mode", groups_mode)
        if incoming_call_route is not None:
            pulumi.set(__self__, "incoming_call_route", incoming_call_route)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="callingWebHook")
    def calling_web_hook(self) -> Optional[pulumi.Input[str]]:
        """
        Calling web hook for Skype channel
        """
        return pulumi.get(self, "calling_web_hook")

    @calling_web_hook.setter
    def calling_web_hook(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "calling_web_hook", value)

    @property
    @pulumi.getter(name="enableCalling")
    def enable_calling(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable calling for Skype channel
        """
        return pulumi.get(self, "enable_calling")

    @enable_calling.setter
    def enable_calling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_calling", value)

    @property
    @pulumi.getter(name="enableGroups")
    def enable_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable groups for Skype channel
        """
        return pulumi.get(self, "enable_groups")

    @enable_groups.setter
    def enable_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_groups", value)

    @property
    @pulumi.getter(name="enableMediaCards")
    def enable_media_cards(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable media cards for Skype channel
        """
        return pulumi.get(self, "enable_media_cards")

    @enable_media_cards.setter
    def enable_media_cards(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_media_cards", value)

    @property
    @pulumi.getter(name="enableMessaging")
    def enable_messaging(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable messaging for Skype channel
        """
        return pulumi.get(self, "enable_messaging")

    @enable_messaging.setter
    def enable_messaging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_messaging", value)

    @property
    @pulumi.getter(name="enableScreenSharing")
    def enable_screen_sharing(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable screen sharing for Skype channel
        """
        return pulumi.get(self, "enable_screen_sharing")

    @enable_screen_sharing.setter
    def enable_screen_sharing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_screen_sharing", value)

    @property
    @pulumi.getter(name="enableVideo")
    def enable_video(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable video for Skype channel
        """
        return pulumi.get(self, "enable_video")

    @enable_video.setter
    def enable_video(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_video", value)

    @property
    @pulumi.getter(name="groupsMode")
    def groups_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Group mode for Skype channel
        """
        return pulumi.get(self, "groups_mode")

    @groups_mode.setter
    def groups_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_mode", value)

    @property
    @pulumi.getter(name="incomingCallRoute")
    def incoming_call_route(self) -> Optional[pulumi.Input[str]]:
        """
        Incoming call route for Skype channel
        """
        return pulumi.get(self, "incoming_call_route")

    @incoming_call_route.setter
    def incoming_call_route(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "incoming_call_route", value)


@pulumi.input_type
class SkypeChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['SkypeChannelPropertiesArgs']] = None):
        """
        Skype channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'SkypeChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['SkypeChannelPropertiesArgs'] properties: The set of properties specific to Skype channel resource
        """
        pulumi.set(__self__, "channel_name", 'SkypeChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'SkypeChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['SkypeChannelPropertiesArgs']]:
        """
        The set of properties specific to Skype channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['SkypeChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class SlackChannelPropertiesArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 landing_page_url: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[str]] = None,
                 signing_secret: Optional[pulumi.Input[str]] = None,
                 verification_token: Optional[pulumi.Input[str]] = None):
        """
        The parameters to provide for the Slack channel.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] client_id: The Slack client id
        :param pulumi.Input[str] client_secret: The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[str] landing_page_url: The Slack landing page Url
        :param pulumi.Input[str] scopes: The Slack permission scopes.
        :param pulumi.Input[str] signing_secret: The Slack signing secret.
        :param pulumi.Input[str] verification_token: The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if landing_page_url is not None:
            pulumi.set(__self__, "landing_page_url", landing_page_url)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if signing_secret is not None:
            pulumi.set(__self__, "signing_secret", signing_secret)
        if verification_token is not None:
            pulumi.set(__self__, "verification_token", verification_token)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Slack client id
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="landingPageUrl")
    def landing_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Slack landing page Url
        """
        return pulumi.get(self, "landing_page_url")

    @landing_page_url.setter
    def landing_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "landing_page_url", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[str]]:
        """
        The Slack permission scopes.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="signingSecret")
    def signing_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The Slack signing secret.
        """
        return pulumi.get(self, "signing_secret")

    @signing_secret.setter
    def signing_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_secret", value)

    @property
    @pulumi.getter(name="verificationToken")
    def verification_token(self) -> Optional[pulumi.Input[str]]:
        """
        The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "verification_token")

    @verification_token.setter
    def verification_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verification_token", value)


@pulumi.input_type
class SlackChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['SlackChannelPropertiesArgs']] = None):
        """
        Slack channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'SlackChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['SlackChannelPropertiesArgs'] properties: The set of properties specific to Slack channel resource
        """
        pulumi.set(__self__, "channel_name", 'SlackChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'SlackChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['SlackChannelPropertiesArgs']]:
        """
        The set of properties specific to Slack channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['SlackChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class SmsChannelPropertiesArgs:
    def __init__(__self__, *,
                 account_sid: pulumi.Input[str],
                 is_enabled: pulumi.Input[bool],
                 phone: pulumi.Input[str],
                 auth_token: Optional[pulumi.Input[str]] = None,
                 is_validated: Optional[pulumi.Input[bool]] = None):
        """
        The parameters to provide for the Sms channel.
        :param pulumi.Input[str] account_sid: The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] phone: The Sms phone
        :param pulumi.Input[str] auth_token: The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[bool] is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "account_sid", account_sid)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "phone", phone)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="accountSID")
    def account_sid(self) -> pulumi.Input[str]:
        """
        The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "account_sid")

    @account_sid.setter
    def account_sid(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_sid", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def phone(self) -> pulumi.Input[str]:
        """
        The Sms phone
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        """
        The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")

    @is_validated.setter
    def is_validated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_validated", value)


@pulumi.input_type
class SmsChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['SmsChannelPropertiesArgs']] = None):
        """
        Sms channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'SmsChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['SmsChannelPropertiesArgs'] properties: The set of properties specific to Sms channel resource
        """
        pulumi.set(__self__, "channel_name", 'SmsChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'SmsChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['SmsChannelPropertiesArgs']]:
        """
        The set of properties specific to Sms channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['SmsChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class TelegramChannelPropertiesArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 access_token: Optional[pulumi.Input[str]] = None,
                 is_validated: Optional[pulumi.Input[bool]] = None):
        """
        The parameters to provide for the Telegram channel.
        :param pulumi.Input[bool] is_enabled: Whether this channel is enabled for the bot
        :param pulumi.Input[str] access_token: The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
        :param pulumi.Input[bool] is_validated: Whether this channel is validated for the bot
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if is_validated is not None:
            pulumi.set(__self__, "is_validated", is_validated)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this channel is enabled for the bot
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="isValidated")
    def is_validated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this channel is validated for the bot
        """
        return pulumi.get(self, "is_validated")

    @is_validated.setter
    def is_validated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_validated", value)


@pulumi.input_type
class TelegramChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['TelegramChannelPropertiesArgs']] = None):
        """
        Telegram channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'TelegramChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['TelegramChannelPropertiesArgs'] properties: The set of properties specific to Telegram channel resource
        """
        pulumi.set(__self__, "channel_name", 'TelegramChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'TelegramChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['TelegramChannelPropertiesArgs']]:
        """
        The set of properties specific to Telegram channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['TelegramChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class TelephonyChannelPropertiesArgs:
    def __init__(__self__, *,
                 api_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['TelephonyChannelResourceApiConfigurationArgs']]]] = None,
                 cognitive_service_region: Optional[pulumi.Input[str]] = None,
                 cognitive_service_subscription_key: Optional[pulumi.Input[str]] = None,
                 default_locale: Optional[pulumi.Input[str]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input['TelephonyPhoneNumbersArgs']]]] = None,
                 premium_sku: Optional[pulumi.Input[str]] = None):
        """
        The parameters to provide for the Direct Line channel.
        :param pulumi.Input[Sequence[pulumi.Input['TelephonyChannelResourceApiConfigurationArgs']]] api_configurations: The list of Telephony api configuration
        :param pulumi.Input[str] cognitive_service_region: The extensionKey2
        :param pulumi.Input[str] cognitive_service_subscription_key: The extensionKey1
        :param pulumi.Input[str] default_locale: The default locale of the channel
        :param pulumi.Input[bool] is_enabled: Whether the channel is enabled
        :param pulumi.Input[Sequence[pulumi.Input['TelephonyPhoneNumbersArgs']]] phone_numbers: The list of Telephony phone numbers
        :param pulumi.Input[str] premium_sku: The premium SKU applied to the channel
        """
        if api_configurations is not None:
            pulumi.set(__self__, "api_configurations", api_configurations)
        if cognitive_service_region is not None:
            pulumi.set(__self__, "cognitive_service_region", cognitive_service_region)
        if cognitive_service_subscription_key is not None:
            pulumi.set(__self__, "cognitive_service_subscription_key", cognitive_service_subscription_key)
        if default_locale is not None:
            pulumi.set(__self__, "default_locale", default_locale)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if phone_numbers is not None:
            pulumi.set(__self__, "phone_numbers", phone_numbers)
        if premium_sku is not None:
            pulumi.set(__self__, "premium_sku", premium_sku)

    @property
    @pulumi.getter(name="apiConfigurations")
    def api_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TelephonyChannelResourceApiConfigurationArgs']]]]:
        """
        The list of Telephony api configuration
        """
        return pulumi.get(self, "api_configurations")

    @api_configurations.setter
    def api_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TelephonyChannelResourceApiConfigurationArgs']]]]):
        pulumi.set(self, "api_configurations", value)

    @property
    @pulumi.getter(name="cognitiveServiceRegion")
    def cognitive_service_region(self) -> Optional[pulumi.Input[str]]:
        """
        The extensionKey2
        """
        return pulumi.get(self, "cognitive_service_region")

    @cognitive_service_region.setter
    def cognitive_service_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitive_service_region", value)

    @property
    @pulumi.getter(name="cognitiveServiceSubscriptionKey")
    def cognitive_service_subscription_key(self) -> Optional[pulumi.Input[str]]:
        """
        The extensionKey1
        """
        return pulumi.get(self, "cognitive_service_subscription_key")

    @cognitive_service_subscription_key.setter
    def cognitive_service_subscription_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitive_service_subscription_key", value)

    @property
    @pulumi.getter(name="defaultLocale")
    def default_locale(self) -> Optional[pulumi.Input[str]]:
        """
        The default locale of the channel
        """
        return pulumi.get(self, "default_locale")

    @default_locale.setter
    def default_locale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_locale", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the channel is enabled
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="phoneNumbers")
    def phone_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TelephonyPhoneNumbersArgs']]]]:
        """
        The list of Telephony phone numbers
        """
        return pulumi.get(self, "phone_numbers")

    @phone_numbers.setter
    def phone_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TelephonyPhoneNumbersArgs']]]]):
        pulumi.set(self, "phone_numbers", value)

    @property
    @pulumi.getter(name="premiumSKU")
    def premium_sku(self) -> Optional[pulumi.Input[str]]:
        """
        The premium SKU applied to the channel
        """
        return pulumi.get(self, "premium_sku")

    @premium_sku.setter
    def premium_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "premium_sku", value)


@pulumi.input_type
class TelephonyChannelResourceApiConfigurationArgs:
    def __init__(__self__, *,
                 cognitive_service_region: Optional[pulumi.Input[str]] = None,
                 cognitive_service_resource_id: Optional[pulumi.Input[str]] = None,
                 cognitive_service_subscription_key: Optional[pulumi.Input[str]] = None,
                 default_locale: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 provider_name: Optional[pulumi.Input[str]] = None):
        """
        A resource Api configuration for the Telephony channel
        :param pulumi.Input[str] cognitive_service_region: The cognitive service region.
        :param pulumi.Input[str] cognitive_service_resource_id: The cognitive service resourceId.
        :param pulumi.Input[str] cognitive_service_subscription_key: The cognitive service subscription key.
        :param pulumi.Input[str] default_locale: The default locale.
        :param pulumi.Input[str] id: The id of config.
        :param pulumi.Input[str] provider_name: The provider name.
        """
        if cognitive_service_region is not None:
            pulumi.set(__self__, "cognitive_service_region", cognitive_service_region)
        if cognitive_service_resource_id is not None:
            pulumi.set(__self__, "cognitive_service_resource_id", cognitive_service_resource_id)
        if cognitive_service_subscription_key is not None:
            pulumi.set(__self__, "cognitive_service_subscription_key", cognitive_service_subscription_key)
        if default_locale is not None:
            pulumi.set(__self__, "default_locale", default_locale)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)

    @property
    @pulumi.getter(name="cognitiveServiceRegion")
    def cognitive_service_region(self) -> Optional[pulumi.Input[str]]:
        """
        The cognitive service region.
        """
        return pulumi.get(self, "cognitive_service_region")

    @cognitive_service_region.setter
    def cognitive_service_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitive_service_region", value)

    @property
    @pulumi.getter(name="cognitiveServiceResourceId")
    def cognitive_service_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cognitive service resourceId.
        """
        return pulumi.get(self, "cognitive_service_resource_id")

    @cognitive_service_resource_id.setter
    def cognitive_service_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitive_service_resource_id", value)

    @property
    @pulumi.getter(name="cognitiveServiceSubscriptionKey")
    def cognitive_service_subscription_key(self) -> Optional[pulumi.Input[str]]:
        """
        The cognitive service subscription key.
        """
        return pulumi.get(self, "cognitive_service_subscription_key")

    @cognitive_service_subscription_key.setter
    def cognitive_service_subscription_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitive_service_subscription_key", value)

    @property
    @pulumi.getter(name="defaultLocale")
    def default_locale(self) -> Optional[pulumi.Input[str]]:
        """
        The default locale.
        """
        return pulumi.get(self, "default_locale")

    @default_locale.setter
    def default_locale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_locale", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of config.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[pulumi.Input[str]]:
        """
        The provider name.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_name", value)


@pulumi.input_type
class TelephonyChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['TelephonyChannelPropertiesArgs']] = None):
        """
        Telephony channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'TelephonyChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['TelephonyChannelPropertiesArgs'] properties: The set of properties specific to Telephony channel resource
        """
        pulumi.set(__self__, "channel_name", 'TelephonyChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'TelephonyChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['TelephonyChannelPropertiesArgs']]:
        """
        The set of properties specific to Telephony channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['TelephonyChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class TelephonyPhoneNumbersArgs:
    def __init__(__self__, *,
                 acs_endpoint: Optional[pulumi.Input[str]] = None,
                 acs_resource_id: Optional[pulumi.Input[str]] = None,
                 acs_secret: Optional[pulumi.Input[str]] = None,
                 cognitive_service_region: Optional[pulumi.Input[str]] = None,
                 cognitive_service_resource_id: Optional[pulumi.Input[str]] = None,
                 cognitive_service_subscription_key: Optional[pulumi.Input[str]] = None,
                 default_locale: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 offer_type: Optional[pulumi.Input[str]] = None,
                 phone_number: Optional[pulumi.Input[str]] = None):
        """
        A telephone number for the Telephony channel
        :param pulumi.Input[str] acs_endpoint: The endpoint of ACS.
        :param pulumi.Input[str] acs_resource_id: The resource id of ACS.
        :param pulumi.Input[str] acs_secret: The secret of ACS.
        :param pulumi.Input[str] cognitive_service_region: The service region of cognitive service.
        :param pulumi.Input[str] cognitive_service_resource_id: The resource id of cognitive service.
        :param pulumi.Input[str] cognitive_service_subscription_key: The subscription key of cognitive service.
        :param pulumi.Input[str] default_locale: The default locale of the phone number.
        :param pulumi.Input[str] id: The element id.
        :param pulumi.Input[str] offer_type: Optional Property that will determine the offering type of the phone.
        :param pulumi.Input[str] phone_number: The phone number.
        """
        if acs_endpoint is not None:
            pulumi.set(__self__, "acs_endpoint", acs_endpoint)
        if acs_resource_id is not None:
            pulumi.set(__self__, "acs_resource_id", acs_resource_id)
        if acs_secret is not None:
            pulumi.set(__self__, "acs_secret", acs_secret)
        if cognitive_service_region is not None:
            pulumi.set(__self__, "cognitive_service_region", cognitive_service_region)
        if cognitive_service_resource_id is not None:
            pulumi.set(__self__, "cognitive_service_resource_id", cognitive_service_resource_id)
        if cognitive_service_subscription_key is not None:
            pulumi.set(__self__, "cognitive_service_subscription_key", cognitive_service_subscription_key)
        if default_locale is not None:
            pulumi.set(__self__, "default_locale", default_locale)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer_type is not None:
            pulumi.set(__self__, "offer_type", offer_type)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="acsEndpoint")
    def acs_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint of ACS.
        """
        return pulumi.get(self, "acs_endpoint")

    @acs_endpoint.setter
    def acs_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acs_endpoint", value)

    @property
    @pulumi.getter(name="acsResourceId")
    def acs_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of ACS.
        """
        return pulumi.get(self, "acs_resource_id")

    @acs_resource_id.setter
    def acs_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acs_resource_id", value)

    @property
    @pulumi.getter(name="acsSecret")
    def acs_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The secret of ACS.
        """
        return pulumi.get(self, "acs_secret")

    @acs_secret.setter
    def acs_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acs_secret", value)

    @property
    @pulumi.getter(name="cognitiveServiceRegion")
    def cognitive_service_region(self) -> Optional[pulumi.Input[str]]:
        """
        The service region of cognitive service.
        """
        return pulumi.get(self, "cognitive_service_region")

    @cognitive_service_region.setter
    def cognitive_service_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitive_service_region", value)

    @property
    @pulumi.getter(name="cognitiveServiceResourceId")
    def cognitive_service_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of cognitive service.
        """
        return pulumi.get(self, "cognitive_service_resource_id")

    @cognitive_service_resource_id.setter
    def cognitive_service_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitive_service_resource_id", value)

    @property
    @pulumi.getter(name="cognitiveServiceSubscriptionKey")
    def cognitive_service_subscription_key(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription key of cognitive service.
        """
        return pulumi.get(self, "cognitive_service_subscription_key")

    @cognitive_service_subscription_key.setter
    def cognitive_service_subscription_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitive_service_subscription_key", value)

    @property
    @pulumi.getter(name="defaultLocale")
    def default_locale(self) -> Optional[pulumi.Input[str]]:
        """
        The default locale of the phone number.
        """
        return pulumi.get(self, "default_locale")

    @default_locale.setter
    def default_locale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_locale", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The element id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="offerType")
    def offer_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional Property that will determine the offering type of the phone.
        """
        return pulumi.get(self, "offer_type")

    @offer_type.setter
    def offer_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer_type", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[str]]:
        """
        The phone number.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class WebChatChannelPropertiesArgs:
    def __init__(__self__, *,
                 sites: Optional[pulumi.Input[Sequence[pulumi.Input['WebChatSiteArgs']]]] = None):
        """
        The parameters to provide for the Web Chat channel.
        :param pulumi.Input[Sequence[pulumi.Input['WebChatSiteArgs']]] sites: The list of Web Chat sites
        """
        if sites is not None:
            pulumi.set(__self__, "sites", sites)

    @property
    @pulumi.getter
    def sites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebChatSiteArgs']]]]:
        """
        The list of Web Chat sites
        """
        return pulumi.get(self, "sites")

    @sites.setter
    def sites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebChatSiteArgs']]]]):
        pulumi.set(self, "sites", value)


@pulumi.input_type
class WebChatChannelArgs:
    def __init__(__self__, *,
                 channel_name: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['WebChatChannelPropertiesArgs']] = None):
        """
        Web Chat channel definition
        :param pulumi.Input[str] channel_name: The channel name
               Expected value is 'WebChatChannel'.
        :param pulumi.Input[str] etag: Entity Tag of the resource
        :param pulumi.Input[str] location: Specifies the location of the resource.
        :param pulumi.Input['WebChatChannelPropertiesArgs'] properties: The set of properties specific to Web Chat channel resource
        """
        pulumi.set(__self__, "channel_name", 'WebChatChannel')
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is None:
            location = 'global'
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Input[str]:
        """
        The channel name
        Expected value is 'WebChatChannel'.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag of the resource
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['WebChatChannelPropertiesArgs']]:
        """
        The set of properties specific to Web Chat channel resource
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['WebChatChannelPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class WebChatSiteArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 is_webchat_preview_enabled: pulumi.Input[bool],
                 site_name: pulumi.Input[str],
                 app_id: Optional[pulumi.Input[str]] = None,
                 e_tag: Optional[pulumi.Input[str]] = None,
                 is_block_user_upload_enabled: Optional[pulumi.Input[bool]] = None,
                 is_detailed_logging_enabled: Optional[pulumi.Input[bool]] = None,
                 is_endpoint_parameters_enabled: Optional[pulumi.Input[bool]] = None,
                 is_no_storage_enabled: Optional[pulumi.Input[bool]] = None,
                 is_secure_site_enabled: Optional[pulumi.Input[bool]] = None,
                 is_v1_enabled: Optional[pulumi.Input[bool]] = None,
                 is_v3_enabled: Optional[pulumi.Input[bool]] = None,
                 is_web_chat_speech_enabled: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 trusted_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A site for the Webchat channel
        :param pulumi.Input[bool] is_enabled: Whether this site is enabled for DirectLine channel
        :param pulumi.Input[bool] is_webchat_preview_enabled: Whether this site is enabled for preview versions of Webchat
        :param pulumi.Input[str] site_name: Site name
        :param pulumi.Input[str] app_id: DirectLine application id
        :param pulumi.Input[str] e_tag: Entity Tag
        :param pulumi.Input[bool] is_block_user_upload_enabled: Whether this site is enabled for block user upload.
        :param pulumi.Input[bool] is_detailed_logging_enabled: Whether this site is disabled detailed logging for
        :param pulumi.Input[bool] is_endpoint_parameters_enabled: Whether this site is EndpointParameters enabled for channel
        :param pulumi.Input[bool] is_no_storage_enabled: Whether this no-storage site is disabled detailed logging for
        :param pulumi.Input[bool] is_secure_site_enabled: Whether this site is enabled for authentication with Bot Framework.
        :param pulumi.Input[bool] is_v1_enabled: Whether this site is enabled for Bot Framework V1 protocol.
        :param pulumi.Input[bool] is_v3_enabled: Whether this site is enabled for Bot Framework V3 protocol.
        :param pulumi.Input[bool] is_web_chat_speech_enabled: Whether this site is enabled for Webchat Speech
        :param pulumi.Input[str] tenant_id: Tenant Id
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trusted_origins: List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        if is_webchat_preview_enabled is None:
            is_webchat_preview_enabled = False
        pulumi.set(__self__, "is_webchat_preview_enabled", is_webchat_preview_enabled)
        pulumi.set(__self__, "site_name", site_name)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if e_tag is not None:
            pulumi.set(__self__, "e_tag", e_tag)
        if is_block_user_upload_enabled is not None:
            pulumi.set(__self__, "is_block_user_upload_enabled", is_block_user_upload_enabled)
        if is_detailed_logging_enabled is not None:
            pulumi.set(__self__, "is_detailed_logging_enabled", is_detailed_logging_enabled)
        if is_endpoint_parameters_enabled is not None:
            pulumi.set(__self__, "is_endpoint_parameters_enabled", is_endpoint_parameters_enabled)
        if is_no_storage_enabled is not None:
            pulumi.set(__self__, "is_no_storage_enabled", is_no_storage_enabled)
        if is_secure_site_enabled is not None:
            pulumi.set(__self__, "is_secure_site_enabled", is_secure_site_enabled)
        if is_v1_enabled is not None:
            pulumi.set(__self__, "is_v1_enabled", is_v1_enabled)
        if is_v3_enabled is not None:
            pulumi.set(__self__, "is_v3_enabled", is_v3_enabled)
        if is_web_chat_speech_enabled is None:
            is_web_chat_speech_enabled = False
        if is_web_chat_speech_enabled is not None:
            pulumi.set(__self__, "is_web_chat_speech_enabled", is_web_chat_speech_enabled)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if trusted_origins is not None:
            pulumi.set(__self__, "trusted_origins", trusted_origins)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this site is enabled for DirectLine channel
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="isWebchatPreviewEnabled")
    def is_webchat_preview_enabled(self) -> pulumi.Input[bool]:
        """
        Whether this site is enabled for preview versions of Webchat
        """
        return pulumi.get(self, "is_webchat_preview_enabled")

    @is_webchat_preview_enabled.setter
    def is_webchat_preview_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_webchat_preview_enabled", value)

    @property
    @pulumi.getter(name="siteName")
    def site_name(self) -> pulumi.Input[str]:
        """
        Site name
        """
        return pulumi.get(self, "site_name")

    @site_name.setter
    def site_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_name", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        DirectLine application id
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="eTag")
    def e_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity Tag
        """
        return pulumi.get(self, "e_tag")

    @e_tag.setter
    def e_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "e_tag", value)

    @property
    @pulumi.getter(name="isBlockUserUploadEnabled")
    def is_block_user_upload_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is enabled for block user upload.
        """
        return pulumi.get(self, "is_block_user_upload_enabled")

    @is_block_user_upload_enabled.setter
    def is_block_user_upload_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_block_user_upload_enabled", value)

    @property
    @pulumi.getter(name="isDetailedLoggingEnabled")
    def is_detailed_logging_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is disabled detailed logging for
        """
        return pulumi.get(self, "is_detailed_logging_enabled")

    @is_detailed_logging_enabled.setter
    def is_detailed_logging_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_detailed_logging_enabled", value)

    @property
    @pulumi.getter(name="isEndpointParametersEnabled")
    def is_endpoint_parameters_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is EndpointParameters enabled for channel
        """
        return pulumi.get(self, "is_endpoint_parameters_enabled")

    @is_endpoint_parameters_enabled.setter
    def is_endpoint_parameters_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_endpoint_parameters_enabled", value)

    @property
    @pulumi.getter(name="isNoStorageEnabled")
    def is_no_storage_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this no-storage site is disabled detailed logging for
        """
        return pulumi.get(self, "is_no_storage_enabled")

    @is_no_storage_enabled.setter
    def is_no_storage_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_no_storage_enabled", value)

    @property
    @pulumi.getter(name="isSecureSiteEnabled")
    def is_secure_site_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is enabled for authentication with Bot Framework.
        """
        return pulumi.get(self, "is_secure_site_enabled")

    @is_secure_site_enabled.setter
    def is_secure_site_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secure_site_enabled", value)

    @property
    @pulumi.getter(name="isV1Enabled")
    def is_v1_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is enabled for Bot Framework V1 protocol.
        """
        return pulumi.get(self, "is_v1_enabled")

    @is_v1_enabled.setter
    def is_v1_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_v1_enabled", value)

    @property
    @pulumi.getter(name="isV3Enabled")
    def is_v3_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is enabled for Bot Framework V3 protocol.
        """
        return pulumi.get(self, "is_v3_enabled")

    @is_v3_enabled.setter
    def is_v3_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_v3_enabled", value)

    @property
    @pulumi.getter(name="isWebChatSpeechEnabled")
    def is_web_chat_speech_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this site is enabled for Webchat Speech
        """
        return pulumi.get(self, "is_web_chat_speech_enabled")

    @is_web_chat_speech_enabled.setter
    def is_web_chat_speech_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_web_chat_speech_enabled", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="trustedOrigins")
    def trusted_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
        """
        return pulumi.get(self, "trusted_origins")

    @trusted_origins.setter
    def trusted_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trusted_origins", value)


