# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ArmIdentityResponse',
    'ArmUserIdentityResponse',
    'CertificatePropertiesResponse',
    'CloudToDevicePropertiesResponse',
    'EncryptionPropertiesDescriptionResponse',
    'EnrichmentPropertiesResponse',
    'EventHubPropertiesResponse',
    'FallbackRoutePropertiesResponse',
    'FeedbackPropertiesResponse',
    'IotHubLocationDescriptionResponse',
    'IotHubPropertiesResponse',
    'IotHubPropertiesResponseDeviceStreams',
    'IotHubSkuInfoResponse',
    'IpFilterRuleResponse',
    'KEKIdentityResponse',
    'KeyVaultKeyPropertiesResponse',
    'MessagingEndpointPropertiesResponse',
    'NetworkRuleSetIpRuleResponse',
    'NetworkRuleSetPropertiesResponse',
    'PrivateEndpointConnectionPropertiesResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'RoutePropertiesResponse',
    'RoutingEndpointsResponse',
    'RoutingEventHubPropertiesResponse',
    'RoutingPropertiesResponse',
    'RoutingServiceBusQueueEndpointPropertiesResponse',
    'RoutingServiceBusTopicEndpointPropertiesResponse',
    'RoutingStorageContainerPropertiesResponse',
    'SharedAccessSignatureAuthorizationRuleResponse',
    'StorageEndpointPropertiesResponse',
]

@pulumi.output_type
class ArmIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArmIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArmIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArmIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.ArmUserIdentityResponse']] = None):
        """
        :param str principal_id: Principal Id
        :param str tenant_id: Tenant Id
        :param str type: The type of identity used for the resource. The type 'SystemAssigned,UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        Principal Id
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Tenant Id
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of identity used for the resource. The type 'SystemAssigned,UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.ArmUserIdentityResponse']]:
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ArmUserIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArmUserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArmUserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArmUserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class CertificatePropertiesResponse(dict):
    """
    The description of an X509 CA Certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isVerified":
            suggest = "is_verified"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificatePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificatePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificatePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created: str,
                 expiry: str,
                 is_verified: bool,
                 subject: str,
                 thumbprint: str,
                 updated: str,
                 certificate: Optional[str] = None):
        """
        The description of an X509 CA Certificate.
        :param str created: The certificate's create date and time.
        :param str expiry: The certificate's expiration date and time.
        :param bool is_verified: Determines whether certificate has been verified.
        :param str subject: The certificate's subject name.
        :param str thumbprint: The certificate's thumbprint.
        :param str updated: The certificate's last update date and time.
        :param str certificate: The certificate content
        """
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "is_verified", is_verified)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "updated", updated)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)

    @property
    @pulumi.getter
    def created(self) -> str:
        """
        The certificate's create date and time.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def expiry(self) -> str:
        """
        The certificate's expiration date and time.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="isVerified")
    def is_verified(self) -> bool:
        """
        Determines whether certificate has been verified.
        """
        return pulumi.get(self, "is_verified")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The certificate's subject name.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        The certificate's thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter
    def updated(self) -> str:
        """
        The certificate's last update date and time.
        """
        return pulumi.get(self, "updated")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[str]:
        """
        The certificate content
        """
        return pulumi.get(self, "certificate")


@pulumi.output_type
class CloudToDevicePropertiesResponse(dict):
    """
    The IoT hub cloud-to-device messaging properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultTtlAsIso8601":
            suggest = "default_ttl_as_iso8601"
        elif key == "maxDeliveryCount":
            suggest = "max_delivery_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudToDevicePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudToDevicePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudToDevicePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_ttl_as_iso8601: Optional[str] = None,
                 feedback: Optional['outputs.FeedbackPropertiesResponse'] = None,
                 max_delivery_count: Optional[int] = None):
        """
        The IoT hub cloud-to-device messaging properties.
        :param str default_ttl_as_iso8601: The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :param 'FeedbackPropertiesResponse' feedback: The properties of the feedback queue for cloud-to-device messages.
        :param int max_delivery_count: The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        if default_ttl_as_iso8601 is not None:
            pulumi.set(__self__, "default_ttl_as_iso8601", default_ttl_as_iso8601)
        if feedback is not None:
            pulumi.set(__self__, "feedback", feedback)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)

    @property
    @pulumi.getter(name="defaultTtlAsIso8601")
    def default_ttl_as_iso8601(self) -> Optional[str]:
        """
        The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "default_ttl_as_iso8601")

    @property
    @pulumi.getter
    def feedback(self) -> Optional['outputs.FeedbackPropertiesResponse']:
        """
        The properties of the feedback queue for cloud-to-device messages.
        """
        return pulumi.get(self, "feedback")

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[int]:
        """
        The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "max_delivery_count")


@pulumi.output_type
class EncryptionPropertiesDescriptionResponse(dict):
    """
    The encryption properties for the IoT hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keySource":
            suggest = "key_source"
        elif key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionPropertiesDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionPropertiesDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionPropertiesDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_source: Optional[str] = None,
                 key_vault_properties: Optional[Sequence['outputs.KeyVaultKeyPropertiesResponse']] = None):
        """
        The encryption properties for the IoT hub.
        :param str key_source: The source of the key.
        :param Sequence['KeyVaultKeyPropertiesResponse'] key_vault_properties: The properties of the KeyVault key.
        """
        if key_source is not None:
            pulumi.set(__self__, "key_source", key_source)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> Optional[str]:
        """
        The source of the key.
        """
        return pulumi.get(self, "key_source")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[Sequence['outputs.KeyVaultKeyPropertiesResponse']]:
        """
        The properties of the KeyVault key.
        """
        return pulumi.get(self, "key_vault_properties")


@pulumi.output_type
class EnrichmentPropertiesResponse(dict):
    """
    The properties of an enrichment that your IoT hub applies to messages delivered to endpoints.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointNames":
            suggest = "endpoint_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnrichmentPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnrichmentPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnrichmentPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_names: Sequence[str],
                 key: str,
                 value: str):
        """
        The properties of an enrichment that your IoT hub applies to messages delivered to endpoints.
        :param Sequence[str] endpoint_names: The list of endpoints for which the enrichment is applied to the message.
        :param str key: The key or name for the enrichment property.
        :param str value: The value for the enrichment property.
        """
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> Sequence[str]:
        """
        The list of endpoints for which the enrichment is applied to the message.
        """
        return pulumi.get(self, "endpoint_names")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key or name for the enrichment property.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the enrichment property.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventHubPropertiesResponse(dict):
    """
    The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionIds":
            suggest = "partition_ids"
        elif key == "partitionCount":
            suggest = "partition_count"
        elif key == "retentionTimeInDays":
            suggest = "retention_time_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: str,
                 partition_ids: Sequence[str],
                 path: str,
                 partition_count: Optional[int] = None,
                 retention_time_in_days: Optional[float] = None):
        """
        The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.
        :param str endpoint: The Event Hub-compatible endpoint.
        :param Sequence[str] partition_ids: The partition ids in the Event Hub-compatible endpoint.
        :param str path: The Event Hub-compatible name.
        :param int partition_count: The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
        :param float retention_time_in_days: The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "partition_ids", partition_ids)
        pulumi.set(__self__, "path", path)
        if partition_count is not None:
            pulumi.set(__self__, "partition_count", partition_count)
        if retention_time_in_days is not None:
            pulumi.set(__self__, "retention_time_in_days", retention_time_in_days)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The Event Hub-compatible endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="partitionIds")
    def partition_ids(self) -> Sequence[str]:
        """
        The partition ids in the Event Hub-compatible endpoint.
        """
        return pulumi.get(self, "partition_ids")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The Event Hub-compatible name.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="partitionCount")
    def partition_count(self) -> Optional[int]:
        """
        The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
        """
        return pulumi.get(self, "partition_count")

    @property
    @pulumi.getter(name="retentionTimeInDays")
    def retention_time_in_days(self) -> Optional[float]:
        """
        The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
        """
        return pulumi.get(self, "retention_time_in_days")


@pulumi.output_type
class FallbackRoutePropertiesResponse(dict):
    """
    The properties of the fallback route. IoT Hub uses these properties when it routes messages to the fallback endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointNames":
            suggest = "endpoint_names"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FallbackRoutePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FallbackRoutePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FallbackRoutePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_names: Sequence[str],
                 is_enabled: bool,
                 source: str,
                 condition: Optional[str] = None,
                 name: Optional[str] = None):
        """
        The properties of the fallback route. IoT Hub uses these properties when it routes messages to the fallback endpoint.
        :param Sequence[str] endpoint_names: The list of endpoints to which the messages that satisfy the condition are routed to. Currently only 1 endpoint is allowed.
        :param bool is_enabled: Used to specify whether the fallback route is enabled.
        :param str source: The source to which the routing rule is to be applied to. For example, DeviceMessages
        :param str condition: The condition which is evaluated in order to apply the fallback route. If the condition is not provided it will evaluate to true by default. For grammar, See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        :param str name: The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        """
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "source", source)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> Sequence[str]:
        """
        The list of endpoints to which the messages that satisfy the condition are routed to. Currently only 1 endpoint is allowed.
        """
        return pulumi.get(self, "endpoint_names")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Used to specify whether the fallback route is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source to which the routing rule is to be applied to. For example, DeviceMessages
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def condition(self) -> Optional[str]:
        """
        The condition which is evaluated in order to apply the fallback route. If the condition is not provided it will evaluate to true by default. For grammar, See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FeedbackPropertiesResponse(dict):
    """
    The properties of the feedback queue for cloud-to-device messages.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lockDurationAsIso8601":
            suggest = "lock_duration_as_iso8601"
        elif key == "maxDeliveryCount":
            suggest = "max_delivery_count"
        elif key == "ttlAsIso8601":
            suggest = "ttl_as_iso8601"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeedbackPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeedbackPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeedbackPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lock_duration_as_iso8601: Optional[str] = None,
                 max_delivery_count: Optional[int] = None,
                 ttl_as_iso8601: Optional[str] = None):
        """
        The properties of the feedback queue for cloud-to-device messages.
        :param str lock_duration_as_iso8601: The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :param int max_delivery_count: The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :param str ttl_as_iso8601: The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        if lock_duration_as_iso8601 is not None:
            pulumi.set(__self__, "lock_duration_as_iso8601", lock_duration_as_iso8601)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if ttl_as_iso8601 is not None:
            pulumi.set(__self__, "ttl_as_iso8601", ttl_as_iso8601)

    @property
    @pulumi.getter(name="lockDurationAsIso8601")
    def lock_duration_as_iso8601(self) -> Optional[str]:
        """
        The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "lock_duration_as_iso8601")

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[int]:
        """
        The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "max_delivery_count")

    @property
    @pulumi.getter(name="ttlAsIso8601")
    def ttl_as_iso8601(self) -> Optional[str]:
        """
        The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        """
        return pulumi.get(self, "ttl_as_iso8601")


@pulumi.output_type
class IotHubLocationDescriptionResponse(dict):
    """
    Public representation of one of the locations where a resource is provisioned.
    """
    def __init__(__self__, *,
                 location: Optional[str] = None,
                 role: Optional[str] = None):
        """
        Public representation of one of the locations where a resource is provisioned.
        :param str location: The name of the Azure region
        :param str role: The role of the region, can be either primary or secondary. The primary region is where the IoT hub is currently provisioned. The secondary region is the Azure disaster recovery (DR) paired region and also the region where the IoT hub can failover to.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The name of the Azure region
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        The role of the region, can be either primary or secondary. The primary region is where the IoT hub is currently provisioned. The secondary region is the Azure disaster recovery (DR) paired region and also the region where the IoT hub can failover to.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class IotHubPropertiesResponse(dict):
    """
    The properties of an IoT hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "authorizationPolicies":
            suggest = "authorization_policies"
        elif key == "cloudToDevice":
            suggest = "cloud_to_device"
        elif key == "deviceStreams":
            suggest = "device_streams"
        elif key == "enableFileUploadNotifications":
            suggest = "enable_file_upload_notifications"
        elif key == "eventHubEndpoints":
            suggest = "event_hub_endpoints"
        elif key == "ipFilterRules":
            suggest = "ip_filter_rules"
        elif key == "messagingEndpoints":
            suggest = "messaging_endpoints"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "networkRuleSets":
            suggest = "network_rule_sets"
        elif key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"
        elif key == "storageEndpoints":
            suggest = "storage_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotHubPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotHubPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotHubPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: str,
                 locations: Sequence['outputs.IotHubLocationDescriptionResponse'],
                 provisioning_state: str,
                 state: str,
                 authorization_policies: Optional[Sequence['outputs.SharedAccessSignatureAuthorizationRuleResponse']] = None,
                 cloud_to_device: Optional['outputs.CloudToDevicePropertiesResponse'] = None,
                 comments: Optional[str] = None,
                 device_streams: Optional['outputs.IotHubPropertiesResponseDeviceStreams'] = None,
                 enable_file_upload_notifications: Optional[bool] = None,
                 encryption: Optional['outputs.EncryptionPropertiesDescriptionResponse'] = None,
                 event_hub_endpoints: Optional[Mapping[str, 'outputs.EventHubPropertiesResponse']] = None,
                 features: Optional[str] = None,
                 ip_filter_rules: Optional[Sequence['outputs.IpFilterRuleResponse']] = None,
                 messaging_endpoints: Optional[Mapping[str, 'outputs.MessagingEndpointPropertiesResponse']] = None,
                 min_tls_version: Optional[str] = None,
                 network_rule_sets: Optional['outputs.NetworkRuleSetPropertiesResponse'] = None,
                 private_endpoint_connections: Optional[Sequence['outputs.PrivateEndpointConnectionResponse']] = None,
                 public_network_access: Optional[str] = None,
                 routing: Optional['outputs.RoutingPropertiesResponse'] = None,
                 storage_endpoints: Optional[Mapping[str, 'outputs.StorageEndpointPropertiesResponse']] = None):
        """
        The properties of an IoT hub.
        :param str host_name: The name of the host.
        :param Sequence['IotHubLocationDescriptionResponse'] locations: Primary and secondary location for iot hub
        :param str provisioning_state: The provisioning state.
        :param str state: The hub state.
        :param Sequence['SharedAccessSignatureAuthorizationRuleResponse'] authorization_policies: The shared access policies you can use to secure a connection to the IoT hub.
        :param 'CloudToDevicePropertiesResponse' cloud_to_device: The IoT hub cloud-to-device messaging properties.
        :param str comments: IoT hub comments.
        :param 'IotHubPropertiesResponseDeviceStreams' device_streams: The device streams properties of iothub.
        :param bool enable_file_upload_notifications: If True, file upload notifications are enabled.
        :param 'EncryptionPropertiesDescriptionResponse' encryption: The encryption properties for the IoT hub.
        :param Mapping[str, 'EventHubPropertiesResponse'] event_hub_endpoints: The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
        :param str features: The capabilities and features enabled for the IoT hub.
        :param Sequence['IpFilterRuleResponse'] ip_filter_rules: The IP filter rules.
        :param Mapping[str, 'MessagingEndpointPropertiesResponse'] messaging_endpoints: The messaging endpoint properties for the file upload notification queue.
        :param str min_tls_version: Specifies the minimum TLS version to support for this hub. Can be set to "1.2" to have clients that use a TLS version below 1.2 to be rejected.
        :param 'NetworkRuleSetPropertiesResponse' network_rule_sets: Network Rule Set Properties of IotHub
        :param Sequence['PrivateEndpointConnectionResponse'] private_endpoint_connections: Private endpoint connections created on this IotHub
        :param str public_network_access: Whether requests from Public Network are allowed
        :param 'RoutingPropertiesResponse' routing: The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
        :param Mapping[str, 'StorageEndpointPropertiesResponse'] storage_endpoints: The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "state", state)
        if authorization_policies is not None:
            pulumi.set(__self__, "authorization_policies", authorization_policies)
        if cloud_to_device is not None:
            pulumi.set(__self__, "cloud_to_device", cloud_to_device)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if device_streams is not None:
            pulumi.set(__self__, "device_streams", device_streams)
        if enable_file_upload_notifications is not None:
            pulumi.set(__self__, "enable_file_upload_notifications", enable_file_upload_notifications)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if event_hub_endpoints is not None:
            pulumi.set(__self__, "event_hub_endpoints", event_hub_endpoints)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if ip_filter_rules is not None:
            pulumi.set(__self__, "ip_filter_rules", ip_filter_rules)
        if messaging_endpoints is not None:
            pulumi.set(__self__, "messaging_endpoints", messaging_endpoints)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if network_rule_sets is not None:
            pulumi.set(__self__, "network_rule_sets", network_rule_sets)
        if private_endpoint_connections is not None:
            pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if storage_endpoints is not None:
            pulumi.set(__self__, "storage_endpoints", storage_endpoints)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        The name of the host.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.IotHubLocationDescriptionResponse']:
        """
        Primary and secondary location for iot hub
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The hub state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="authorizationPolicies")
    def authorization_policies(self) -> Optional[Sequence['outputs.SharedAccessSignatureAuthorizationRuleResponse']]:
        """
        The shared access policies you can use to secure a connection to the IoT hub.
        """
        return pulumi.get(self, "authorization_policies")

    @property
    @pulumi.getter(name="cloudToDevice")
    def cloud_to_device(self) -> Optional['outputs.CloudToDevicePropertiesResponse']:
        """
        The IoT hub cloud-to-device messaging properties.
        """
        return pulumi.get(self, "cloud_to_device")

    @property
    @pulumi.getter
    def comments(self) -> Optional[str]:
        """
        IoT hub comments.
        """
        return pulumi.get(self, "comments")

    @property
    @pulumi.getter(name="deviceStreams")
    def device_streams(self) -> Optional['outputs.IotHubPropertiesResponseDeviceStreams']:
        """
        The device streams properties of iothub.
        """
        return pulumi.get(self, "device_streams")

    @property
    @pulumi.getter(name="enableFileUploadNotifications")
    def enable_file_upload_notifications(self) -> Optional[bool]:
        """
        If True, file upload notifications are enabled.
        """
        return pulumi.get(self, "enable_file_upload_notifications")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.EncryptionPropertiesDescriptionResponse']:
        """
        The encryption properties for the IoT hub.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="eventHubEndpoints")
    def event_hub_endpoints(self) -> Optional[Mapping[str, 'outputs.EventHubPropertiesResponse']]:
        """
        The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
        """
        return pulumi.get(self, "event_hub_endpoints")

    @property
    @pulumi.getter
    def features(self) -> Optional[str]:
        """
        The capabilities and features enabled for the IoT hub.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="ipFilterRules")
    def ip_filter_rules(self) -> Optional[Sequence['outputs.IpFilterRuleResponse']]:
        """
        The IP filter rules.
        """
        return pulumi.get(self, "ip_filter_rules")

    @property
    @pulumi.getter(name="messagingEndpoints")
    def messaging_endpoints(self) -> Optional[Mapping[str, 'outputs.MessagingEndpointPropertiesResponse']]:
        """
        The messaging endpoint properties for the file upload notification queue.
        """
        return pulumi.get(self, "messaging_endpoints")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[str]:
        """
        Specifies the minimum TLS version to support for this hub. Can be set to "1.2" to have clients that use a TLS version below 1.2 to be rejected.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter(name="networkRuleSets")
    def network_rule_sets(self) -> Optional['outputs.NetworkRuleSetPropertiesResponse']:
        """
        Network Rule Set Properties of IotHub
        """
        return pulumi.get(self, "network_rule_sets")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Optional[Sequence['outputs.PrivateEndpointConnectionResponse']]:
        """
        Private endpoint connections created on this IotHub
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        Whether requests from Public Network are allowed
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter
    def routing(self) -> Optional['outputs.RoutingPropertiesResponse']:
        """
        The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
        """
        return pulumi.get(self, "routing")

    @property
    @pulumi.getter(name="storageEndpoints")
    def storage_endpoints(self) -> Optional[Mapping[str, 'outputs.StorageEndpointPropertiesResponse']]:
        """
        The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
        """
        return pulumi.get(self, "storage_endpoints")


@pulumi.output_type
class IotHubPropertiesResponseDeviceStreams(dict):
    """
    The device streams properties of iothub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamingEndpoints":
            suggest = "streaming_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IotHubPropertiesResponseDeviceStreams. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IotHubPropertiesResponseDeviceStreams.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IotHubPropertiesResponseDeviceStreams.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 streaming_endpoints: Optional[Sequence[str]] = None):
        """
        The device streams properties of iothub.
        :param Sequence[str] streaming_endpoints: List of Device Streams Endpoints.
        """
        if streaming_endpoints is not None:
            pulumi.set(__self__, "streaming_endpoints", streaming_endpoints)

    @property
    @pulumi.getter(name="streamingEndpoints")
    def streaming_endpoints(self) -> Optional[Sequence[str]]:
        """
        List of Device Streams Endpoints.
        """
        return pulumi.get(self, "streaming_endpoints")


@pulumi.output_type
class IotHubSkuInfoResponse(dict):
    """
    Information about the SKU of the IoT hub.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: str,
                 capacity: Optional[float] = None):
        """
        Information about the SKU of the IoT hub.
        :param str name: The name of the SKU.
        :param str tier: The billing tier for the IoT hub.
        :param float capacity: The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The billing tier for the IoT hub.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[float]:
        """
        The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class IpFilterRuleResponse(dict):
    """
    The IP filter rules for the IoT hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterName":
            suggest = "filter_name"
        elif key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpFilterRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpFilterRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpFilterRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 filter_name: str,
                 ip_mask: str):
        """
        The IP filter rules for the IoT hub.
        :param str action: The desired action for requests captured by this rule.
        :param str filter_name: The name of the IP filter rule.
        :param str ip_mask: A string that contains the IP address range in CIDR notation for the rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "filter_name", filter_name)
        pulumi.set(__self__, "ip_mask", ip_mask)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The desired action for requests captured by this rule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> str:
        """
        The name of the IP filter rule.
        """
        return pulumi.get(self, "filter_name")

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> str:
        """
        A string that contains the IP address range in CIDR notation for the rule.
        """
        return pulumi.get(self, "ip_mask")


@pulumi.output_type
class KEKIdentityResponse(dict):
    """
    The properties of the KeyVault identity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KEKIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KEKIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KEKIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_assigned_identity: Optional[str] = None):
        """
        The properties of the KeyVault identity.
        :param str user_assigned_identity: The user assigned identity.
        """
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[str]:
        """
        The user assigned identity.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class KeyVaultKeyPropertiesResponse(dict):
    """
    The properties of the KeyVault key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyIdentifier":
            suggest = "key_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultKeyPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultKeyPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultKeyPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity: Optional['outputs.KEKIdentityResponse'] = None,
                 key_identifier: Optional[str] = None):
        """
        The properties of the KeyVault key.
        :param 'KEKIdentityResponse' identity: The identity.
        :param str key_identifier: The identifier of the key.
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_identifier is not None:
            pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.KEKIdentityResponse']:
        """
        The identity.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> Optional[str]:
        """
        The identifier of the key.
        """
        return pulumi.get(self, "key_identifier")


@pulumi.output_type
class MessagingEndpointPropertiesResponse(dict):
    """
    The properties of the messaging endpoints used by this IoT hub.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lockDurationAsIso8601":
            suggest = "lock_duration_as_iso8601"
        elif key == "maxDeliveryCount":
            suggest = "max_delivery_count"
        elif key == "ttlAsIso8601":
            suggest = "ttl_as_iso8601"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MessagingEndpointPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MessagingEndpointPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MessagingEndpointPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lock_duration_as_iso8601: Optional[str] = None,
                 max_delivery_count: Optional[int] = None,
                 ttl_as_iso8601: Optional[str] = None):
        """
        The properties of the messaging endpoints used by this IoT hub.
        :param str lock_duration_as_iso8601: The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        :param int max_delivery_count: The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        :param str ttl_as_iso8601: The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        if lock_duration_as_iso8601 is not None:
            pulumi.set(__self__, "lock_duration_as_iso8601", lock_duration_as_iso8601)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if ttl_as_iso8601 is not None:
            pulumi.set(__self__, "ttl_as_iso8601", ttl_as_iso8601)

    @property
    @pulumi.getter(name="lockDurationAsIso8601")
    def lock_duration_as_iso8601(self) -> Optional[str]:
        """
        The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        return pulumi.get(self, "lock_duration_as_iso8601")

    @property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[int]:
        """
        The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        return pulumi.get(self, "max_delivery_count")

    @property
    @pulumi.getter(name="ttlAsIso8601")
    def ttl_as_iso8601(self) -> Optional[str]:
        """
        The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        """
        return pulumi.get(self, "ttl_as_iso8601")


@pulumi.output_type
class NetworkRuleSetIpRuleResponse(dict):
    """
    IP Rule to be applied as part of Network Rule Set
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterName":
            suggest = "filter_name"
        elif key == "ipMask":
            suggest = "ip_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRuleSetIpRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRuleSetIpRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRuleSetIpRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_name: str,
                 ip_mask: str,
                 action: Optional[str] = None):
        """
        IP Rule to be applied as part of Network Rule Set
        :param str filter_name: Name of the IP filter rule.
        :param str ip_mask: A string that contains the IP address range in CIDR notation for the rule.
        :param str action: IP Filter Action
        """
        pulumi.set(__self__, "filter_name", filter_name)
        pulumi.set(__self__, "ip_mask", ip_mask)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> str:
        """
        Name of the IP filter rule.
        """
        return pulumi.get(self, "filter_name")

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> str:
        """
        A string that contains the IP address range in CIDR notation for the rule.
        """
        return pulumi.get(self, "ip_mask")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        IP Filter Action
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class NetworkRuleSetPropertiesResponse(dict):
    """
    Network Rule Set Properties of IotHub
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyToBuiltInEventHubEndpoint":
            suggest = "apply_to_built_in_event_hub_endpoint"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "defaultAction":
            suggest = "default_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRuleSetPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRuleSetPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRuleSetPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apply_to_built_in_event_hub_endpoint: bool,
                 ip_rules: Sequence['outputs.NetworkRuleSetIpRuleResponse'],
                 default_action: Optional[str] = None):
        """
        Network Rule Set Properties of IotHub
        :param bool apply_to_built_in_event_hub_endpoint: If True, then Network Rule Set is also applied to BuiltIn EventHub EndPoint of IotHub
        :param Sequence['NetworkRuleSetIpRuleResponse'] ip_rules: List of IP Rules
        :param str default_action: Default Action for Network Rule Set
        """
        pulumi.set(__self__, "apply_to_built_in_event_hub_endpoint", apply_to_built_in_event_hub_endpoint)
        pulumi.set(__self__, "ip_rules", ip_rules)
        if default_action is None:
            default_action = 'Deny'
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)

    @property
    @pulumi.getter(name="applyToBuiltInEventHubEndpoint")
    def apply_to_built_in_event_hub_endpoint(self) -> bool:
        """
        If True, then Network Rule Set is also applied to BuiltIn EventHub EndPoint of IotHub
        """
        return pulumi.get(self, "apply_to_built_in_event_hub_endpoint")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Sequence['outputs.NetworkRuleSetIpRuleResponse']:
        """
        List of IP Rules
        """
        return pulumi.get(self, "ip_rules")

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[str]:
        """
        Default Action for Network Rule Set
        """
        return pulumi.get(self, "default_action")


@pulumi.output_type
class PrivateEndpointConnectionPropertiesResponse(dict):
    """
    The properties of a private endpoint connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None):
        """
        The properties of a private endpoint connection
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: The current state of a private endpoint connection
        :param 'PrivateEndpointResponse' private_endpoint: The private endpoint property of a private endpoint connection
        """
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        The current state of a private endpoint connection
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The private endpoint property of a private endpoint connection
        """
        return pulumi.get(self, "private_endpoint")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The private endpoint connection of an IotHub
    """
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 properties: 'outputs.PrivateEndpointConnectionPropertiesResponse',
                 type: str):
        """
        The private endpoint connection of an IotHub
        :param str id: The resource identifier.
        :param str name: The resource name.
        :param 'PrivateEndpointConnectionPropertiesResponse' properties: The properties of a private endpoint connection
        :param str type: The resource type.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.PrivateEndpointConnectionPropertiesResponse':
        """
        The properties of a private endpoint connection
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The private endpoint property of a private endpoint connection
    """
    def __init__(__self__, *,
                 id: str):
        """
        The private endpoint property of a private endpoint connection
        :param str id: The resource identifier.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource identifier.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    The current state of a private endpoint connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 status: str,
                 actions_required: Optional[str] = None):
        """
        The current state of a private endpoint connection
        :param str description: The description for the current state of a private endpoint connection
        :param str status: The status of a private endpoint connection
        :param str actions_required: Actions required for a private endpoint connection
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description for the current state of a private endpoint connection
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of a private endpoint connection
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        Actions required for a private endpoint connection
        """
        return pulumi.get(self, "actions_required")


@pulumi.output_type
class RoutePropertiesResponse(dict):
    """
    The properties of a routing rule that your IoT hub uses to route messages to endpoints.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointNames":
            suggest = "endpoint_names"
        elif key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_names: Sequence[str],
                 is_enabled: bool,
                 name: str,
                 source: str,
                 condition: Optional[str] = None):
        """
        The properties of a routing rule that your IoT hub uses to route messages to endpoints.
        :param Sequence[str] endpoint_names: The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
        :param bool is_enabled: Used to specify whether a route is enabled.
        :param str name: The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        :param str source: The source that the routing rule is to be applied to, such as DeviceMessages.
        :param str condition: The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        """
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> Sequence[str]:
        """
        The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
        """
        return pulumi.get(self, "endpoint_names")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Used to specify whether a route is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source that the routing rule is to be applied to, such as DeviceMessages.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def condition(self) -> Optional[str]:
        """
        The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class RoutingEndpointsResponse(dict):
    """
    The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventHubs":
            suggest = "event_hubs"
        elif key == "serviceBusQueues":
            suggest = "service_bus_queues"
        elif key == "serviceBusTopics":
            suggest = "service_bus_topics"
        elif key == "storageContainers":
            suggest = "storage_containers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingEndpointsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingEndpointsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingEndpointsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_hubs: Optional[Sequence['outputs.RoutingEventHubPropertiesResponse']] = None,
                 service_bus_queues: Optional[Sequence['outputs.RoutingServiceBusQueueEndpointPropertiesResponse']] = None,
                 service_bus_topics: Optional[Sequence['outputs.RoutingServiceBusTopicEndpointPropertiesResponse']] = None,
                 storage_containers: Optional[Sequence['outputs.RoutingStorageContainerPropertiesResponse']] = None):
        """
        The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
        :param Sequence['RoutingEventHubPropertiesResponse'] event_hubs: The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
        :param Sequence['RoutingServiceBusQueueEndpointPropertiesResponse'] service_bus_queues: The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
        :param Sequence['RoutingServiceBusTopicEndpointPropertiesResponse'] service_bus_topics: The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
        :param Sequence['RoutingStorageContainerPropertiesResponse'] storage_containers: The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
        """
        if event_hubs is not None:
            pulumi.set(__self__, "event_hubs", event_hubs)
        if service_bus_queues is not None:
            pulumi.set(__self__, "service_bus_queues", service_bus_queues)
        if service_bus_topics is not None:
            pulumi.set(__self__, "service_bus_topics", service_bus_topics)
        if storage_containers is not None:
            pulumi.set(__self__, "storage_containers", storage_containers)

    @property
    @pulumi.getter(name="eventHubs")
    def event_hubs(self) -> Optional[Sequence['outputs.RoutingEventHubPropertiesResponse']]:
        """
        The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
        """
        return pulumi.get(self, "event_hubs")

    @property
    @pulumi.getter(name="serviceBusQueues")
    def service_bus_queues(self) -> Optional[Sequence['outputs.RoutingServiceBusQueueEndpointPropertiesResponse']]:
        """
        The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
        """
        return pulumi.get(self, "service_bus_queues")

    @property
    @pulumi.getter(name="serviceBusTopics")
    def service_bus_topics(self) -> Optional[Sequence['outputs.RoutingServiceBusTopicEndpointPropertiesResponse']]:
        """
        The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
        """
        return pulumi.get(self, "service_bus_topics")

    @property
    @pulumi.getter(name="storageContainers")
    def storage_containers(self) -> Optional[Sequence['outputs.RoutingStorageContainerPropertiesResponse']]:
        """
        The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
        """
        return pulumi.get(self, "storage_containers")


@pulumi.output_type
class RoutingEventHubPropertiesResponse(dict):
    """
    The properties related to an event hub endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "entityPath":
            suggest = "entity_path"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingEventHubPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingEventHubPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingEventHubPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 authentication_type: Optional[str] = None,
                 connection_string: Optional[str] = None,
                 endpoint_uri: Optional[str] = None,
                 entity_path: Optional[str] = None,
                 id: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 subscription_id: Optional[str] = None):
        """
        The properties related to an event hub endpoint.
        :param str name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        :param str authentication_type: Method used to authenticate against the event hub endpoint
        :param str connection_string: The connection string of the event hub endpoint. 
        :param str endpoint_uri: The url of the event hub endpoint. It must include the protocol sb://
        :param str entity_path: Event hub name on the event hub namespace
        :param str id: Id of the event hub endpoint
        :param str resource_group: The name of the resource group of the event hub endpoint.
        :param str subscription_id: The subscription identifier of the event hub endpoint.
        """
        pulumi.set(__self__, "name", name)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if entity_path is not None:
            pulumi.set(__self__, "entity_path", entity_path)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Method used to authenticate against the event hub endpoint
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[str]:
        """
        The connection string of the event hub endpoint. 
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[str]:
        """
        The url of the event hub endpoint. It must include the protocol sb://
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> Optional[str]:
        """
        Event hub name on the event hub namespace
        """
        return pulumi.get(self, "entity_path")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of the event hub endpoint
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        The name of the resource group of the event hub endpoint.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        The subscription identifier of the event hub endpoint.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class RoutingPropertiesResponse(dict):
    """
    The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackRoute":
            suggest = "fallback_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoints: Optional['outputs.RoutingEndpointsResponse'] = None,
                 enrichments: Optional[Sequence['outputs.EnrichmentPropertiesResponse']] = None,
                 fallback_route: Optional['outputs.FallbackRoutePropertiesResponse'] = None,
                 routes: Optional[Sequence['outputs.RoutePropertiesResponse']] = None):
        """
        The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
        :param 'RoutingEndpointsResponse' endpoints: The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
        :param Sequence['EnrichmentPropertiesResponse'] enrichments: The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid
        :param 'FallbackRoutePropertiesResponse' fallback_route: The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
        :param Sequence['RoutePropertiesResponse'] routes: The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
        """
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if enrichments is not None:
            pulumi.set(__self__, "enrichments", enrichments)
        if fallback_route is not None:
            pulumi.set(__self__, "fallback_route", fallback_route)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional['outputs.RoutingEndpointsResponse']:
        """
        The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def enrichments(self) -> Optional[Sequence['outputs.EnrichmentPropertiesResponse']]:
        """
        The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid
        """
        return pulumi.get(self, "enrichments")

    @property
    @pulumi.getter(name="fallbackRoute")
    def fallback_route(self) -> Optional['outputs.FallbackRoutePropertiesResponse']:
        """
        The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
        """
        return pulumi.get(self, "fallback_route")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.RoutePropertiesResponse']]:
        """
        The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
        """
        return pulumi.get(self, "routes")


@pulumi.output_type
class RoutingServiceBusQueueEndpointPropertiesResponse(dict):
    """
    The properties related to service bus queue endpoint types.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "entityPath":
            suggest = "entity_path"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingServiceBusQueueEndpointPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingServiceBusQueueEndpointPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingServiceBusQueueEndpointPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 authentication_type: Optional[str] = None,
                 connection_string: Optional[str] = None,
                 endpoint_uri: Optional[str] = None,
                 entity_path: Optional[str] = None,
                 id: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 subscription_id: Optional[str] = None):
        """
        The properties related to service bus queue endpoint types.
        :param str name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types. The name need not be the same as the actual queue name.
        :param str authentication_type: Method used to authenticate against the service bus queue endpoint
        :param str connection_string: The connection string of the service bus queue endpoint.
        :param str endpoint_uri: The url of the service bus queue endpoint. It must include the protocol sb://
        :param str entity_path: Queue name on the service bus namespace
        :param str id: Id of the service bus queue endpoint
        :param str resource_group: The name of the resource group of the service bus queue endpoint.
        :param str subscription_id: The subscription identifier of the service bus queue endpoint.
        """
        pulumi.set(__self__, "name", name)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if entity_path is not None:
            pulumi.set(__self__, "entity_path", entity_path)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types. The name need not be the same as the actual queue name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Method used to authenticate against the service bus queue endpoint
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[str]:
        """
        The connection string of the service bus queue endpoint.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[str]:
        """
        The url of the service bus queue endpoint. It must include the protocol sb://
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> Optional[str]:
        """
        Queue name on the service bus namespace
        """
        return pulumi.get(self, "entity_path")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of the service bus queue endpoint
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        The name of the resource group of the service bus queue endpoint.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        The subscription identifier of the service bus queue endpoint.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class RoutingServiceBusTopicEndpointPropertiesResponse(dict):
    """
    The properties related to service bus topic endpoint types.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "entityPath":
            suggest = "entity_path"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingServiceBusTopicEndpointPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingServiceBusTopicEndpointPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingServiceBusTopicEndpointPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 authentication_type: Optional[str] = None,
                 connection_string: Optional[str] = None,
                 endpoint_uri: Optional[str] = None,
                 entity_path: Optional[str] = None,
                 id: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 subscription_id: Optional[str] = None):
        """
        The properties related to service bus topic endpoint types.
        :param str name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.  The name need not be the same as the actual topic name.
        :param str authentication_type: Method used to authenticate against the service bus topic endpoint
        :param str connection_string: The connection string of the service bus topic endpoint.
        :param str endpoint_uri: The url of the service bus topic endpoint. It must include the protocol sb://
        :param str entity_path: Queue name on the service bus topic
        :param str id: Id of the service bus topic endpoint
        :param str resource_group: The name of the resource group of the service bus topic endpoint.
        :param str subscription_id: The subscription identifier of the service bus topic endpoint.
        """
        pulumi.set(__self__, "name", name)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if entity_path is not None:
            pulumi.set(__self__, "entity_path", entity_path)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.  The name need not be the same as the actual topic name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Method used to authenticate against the service bus topic endpoint
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[str]:
        """
        The connection string of the service bus topic endpoint.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[str]:
        """
        The url of the service bus topic endpoint. It must include the protocol sb://
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> Optional[str]:
        """
        Queue name on the service bus topic
        """
        return pulumi.get(self, "entity_path")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of the service bus topic endpoint
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        The name of the resource group of the service bus topic endpoint.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        The subscription identifier of the service bus topic endpoint.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class RoutingStorageContainerPropertiesResponse(dict):
    """
    The properties related to a storage container endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "batchFrequencyInSeconds":
            suggest = "batch_frequency_in_seconds"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "endpointUri":
            suggest = "endpoint_uri"
        elif key == "fileNameFormat":
            suggest = "file_name_format"
        elif key == "maxChunkSizeInBytes":
            suggest = "max_chunk_size_in_bytes"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoutingStorageContainerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoutingStorageContainerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoutingStorageContainerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: str,
                 name: str,
                 authentication_type: Optional[str] = None,
                 batch_frequency_in_seconds: Optional[int] = None,
                 connection_string: Optional[str] = None,
                 encoding: Optional[str] = None,
                 endpoint_uri: Optional[str] = None,
                 file_name_format: Optional[str] = None,
                 id: Optional[str] = None,
                 max_chunk_size_in_bytes: Optional[int] = None,
                 resource_group: Optional[str] = None,
                 subscription_id: Optional[str] = None):
        """
        The properties related to a storage container endpoint.
        :param str container_name: The name of storage container in the storage account.
        :param str name: The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        :param str authentication_type: Method used to authenticate against the storage endpoint
        :param int batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        :param str connection_string: The connection string of the storage account.
        :param str encoding: Encoding that is used to serialize messages to blobs. Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'.
        :param str endpoint_uri: The url of the storage endpoint. It must include the protocol https://
        :param str file_name_format: File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered.
        :param str id: Id of the storage container endpoint
        :param int max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        :param str resource_group: The name of the resource group of the storage account.
        :param str subscription_id: The subscription identifier of the storage account.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "name", name)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if batch_frequency_in_seconds is not None:
            pulumi.set(__self__, "batch_frequency_in_seconds", batch_frequency_in_seconds)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if file_name_format is not None:
            pulumi.set(__self__, "file_name_format", file_name_format)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if max_chunk_size_in_bytes is not None:
            pulumi.set(__self__, "max_chunk_size_in_bytes", max_chunk_size_in_bytes)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        The name of storage container in the storage account.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Method used to authenticate against the storage endpoint
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="batchFrequencyInSeconds")
    def batch_frequency_in_seconds(self) -> Optional[int]:
        """
        Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
        """
        return pulumi.get(self, "batch_frequency_in_seconds")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[str]:
        """
        The connection string of the storage account.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        Encoding that is used to serialize messages to blobs. Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[str]:
        """
        The url of the storage endpoint. It must include the protocol https://
        """
        return pulumi.get(self, "endpoint_uri")

    @property
    @pulumi.getter(name="fileNameFormat")
    def file_name_format(self) -> Optional[str]:
        """
        File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered.
        """
        return pulumi.get(self, "file_name_format")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Id of the storage container endpoint
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxChunkSizeInBytes")
    def max_chunk_size_in_bytes(self) -> Optional[int]:
        """
        Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        """
        return pulumi.get(self, "max_chunk_size_in_bytes")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        The name of the resource group of the storage account.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        The subscription identifier of the storage account.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class SharedAccessSignatureAuthorizationRuleResponse(dict):
    """
    The properties of an IoT hub shared access policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "primaryKey":
            suggest = "primary_key"
        elif key == "secondaryKey":
            suggest = "secondary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedAccessSignatureAuthorizationRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedAccessSignatureAuthorizationRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedAccessSignatureAuthorizationRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: str,
                 rights: str,
                 primary_key: Optional[str] = None,
                 secondary_key: Optional[str] = None):
        """
        The properties of an IoT hub shared access policy.
        :param str key_name: The name of the shared access policy.
        :param str rights: The permissions assigned to the shared access policy.
        :param str primary_key: The primary key.
        :param str secondary_key: The secondary key.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "rights", rights)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        The name of the shared access policy.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def rights(self) -> str:
        """
        The permissions assigned to the shared access policy.
        """
        return pulumi.get(self, "rights")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[str]:
        """
        The primary key.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[str]:
        """
        The secondary key.
        """
        return pulumi.get(self, "secondary_key")


@pulumi.output_type
class StorageEndpointPropertiesResponse(dict):
    """
    The properties of the Azure Storage endpoint for file upload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "authenticationType":
            suggest = "authentication_type"
        elif key == "sasTtlAsIso8601":
            suggest = "sas_ttl_as_iso8601"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageEndpointPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageEndpointPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageEndpointPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: str,
                 container_name: str,
                 authentication_type: Optional[str] = None,
                 sas_ttl_as_iso8601: Optional[str] = None):
        """
        The properties of the Azure Storage endpoint for file upload.
        :param str connection_string: The connection string for the Azure Storage account to which files are uploaded.
        :param str container_name: The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
        :param str authentication_type: Specifies authentication type being used for connecting to the storage account.
        :param str sas_ttl_as_iso8601: The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "container_name", container_name)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if sas_ttl_as_iso8601 is not None:
            pulumi.set(__self__, "sas_ttl_as_iso8601", sas_ttl_as_iso8601)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        The connection string for the Azure Storage account to which files are uploaded.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        Specifies authentication type being used for connecting to the storage account.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="sasTtlAsIso8601")
    def sas_ttl_as_iso8601(self) -> Optional[str]:
        """
        The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
        """
        return pulumi.get(self, "sas_ttl_as_iso8601")


