# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AkamaiAccessControlArgs',
    'AkamaiSignatureHeaderAuthenticationKeyArgs',
    'ArmStreamingEndpointCurrentSkuArgs',
    'AudioTrackArgs',
    'CbcsDrmConfigurationArgs',
    'CencDrmConfigurationArgs',
    'ClearKeyEncryptionConfigurationArgs',
    'CommonEncryptionCbcsArgs',
    'CommonEncryptionCencArgs',
    'ContentKeyPolicyClearKeyConfigurationArgs',
    'ContentKeyPolicyFairPlayConfigurationArgs',
    'ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs',
    'ContentKeyPolicyOpenRestrictionArgs',
    'ContentKeyPolicyOptionArgs',
    'ContentKeyPolicyPlayReadyConfigurationArgs',
    'ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs',
    'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs',
    'ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs',
    'ContentKeyPolicyPlayReadyLicenseArgs',
    'ContentKeyPolicyPlayReadyPlayRightArgs',
    'ContentKeyPolicyRsaTokenKeyArgs',
    'ContentKeyPolicySymmetricTokenKeyArgs',
    'ContentKeyPolicyTokenClaimArgs',
    'ContentKeyPolicyTokenRestrictionArgs',
    'ContentKeyPolicyUnknownConfigurationArgs',
    'ContentKeyPolicyUnknownRestrictionArgs',
    'ContentKeyPolicyWidevineConfigurationArgs',
    'ContentKeyPolicyX509CertificateTokenKeyArgs',
    'CrossSiteAccessPoliciesArgs',
    'DashSettingsArgs',
    'DefaultKeyArgs',
    'EnabledProtocolsArgs',
    'EnvelopeEncryptionArgs',
    'FilterTrackPropertyConditionArgs',
    'FilterTrackSelectionArgs',
    'FirstQualityArgs',
    'HlsSettingsArgs',
    'HlsArgs',
    'IPAccessControlArgs',
    'IPRangeArgs',
    'LiveEventEncodingArgs',
    'LiveEventEndpointArgs',
    'LiveEventInputAccessControlArgs',
    'LiveEventInputTrackSelectionArgs',
    'LiveEventInputArgs',
    'LiveEventOutputTranscriptionTrackArgs',
    'LiveEventPreviewAccessControlArgs',
    'LiveEventPreviewArgs',
    'LiveEventTranscriptionArgs',
    'NoEncryptionArgs',
    'PresentationTimeRangeArgs',
    'StreamingEndpointAccessControlArgs',
    'StreamingLocatorContentKeyArgs',
    'StreamingPolicyContentKeysArgs',
    'StreamingPolicyContentKeyArgs',
    'StreamingPolicyFairPlayConfigurationArgs',
    'StreamingPolicyPlayReadyConfigurationArgs',
    'StreamingPolicyWidevineConfigurationArgs',
    'TextTrackArgs',
    'TrackPropertyConditionArgs',
    'TrackSelectionArgs',
    'VideoTrackArgs',
]

@pulumi.input_type
class AkamaiAccessControlArgs:
    def __init__(__self__, *,
                 akamai_signature_header_authentication_key_list: Optional[pulumi.Input[Sequence[pulumi.Input['AkamaiSignatureHeaderAuthenticationKeyArgs']]]] = None):
        """
        Akamai access control
        :param pulumi.Input[Sequence[pulumi.Input['AkamaiSignatureHeaderAuthenticationKeyArgs']]] akamai_signature_header_authentication_key_list: authentication key list
        """
        if akamai_signature_header_authentication_key_list is not None:
            pulumi.set(__self__, "akamai_signature_header_authentication_key_list", akamai_signature_header_authentication_key_list)

    @property
    @pulumi.getter(name="akamaiSignatureHeaderAuthenticationKeyList")
    def akamai_signature_header_authentication_key_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AkamaiSignatureHeaderAuthenticationKeyArgs']]]]:
        """
        authentication key list
        """
        return pulumi.get(self, "akamai_signature_header_authentication_key_list")

    @akamai_signature_header_authentication_key_list.setter
    def akamai_signature_header_authentication_key_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AkamaiSignatureHeaderAuthenticationKeyArgs']]]]):
        pulumi.set(self, "akamai_signature_header_authentication_key_list", value)


@pulumi.input_type
class AkamaiSignatureHeaderAuthenticationKeyArgs:
    def __init__(__self__, *,
                 base64_key: Optional[pulumi.Input[str]] = None,
                 expiration: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None):
        """
        Akamai Signature Header authentication key.
        :param pulumi.Input[str] base64_key: authentication key
        :param pulumi.Input[str] expiration: The expiration time of the authentication key.
        :param pulumi.Input[str] identifier: identifier of the key
        """
        if base64_key is not None:
            pulumi.set(__self__, "base64_key", base64_key)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="base64Key")
    def base64_key(self) -> Optional[pulumi.Input[str]]:
        """
        authentication key
        """
        return pulumi.get(self, "base64_key")

    @base64_key.setter
    def base64_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base64_key", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[str]]:
        """
        The expiration time of the authentication key.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        identifier of the key
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)


@pulumi.input_type
class ArmStreamingEndpointCurrentSkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None):
        """
        The streaming endpoint current sku.
        :param pulumi.Input[int] capacity: The streaming endpoint sku capacity.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The streaming endpoint sku capacity.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)


@pulumi.input_type
class AudioTrackArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 dash_settings: Optional[pulumi.Input['DashSettingsArgs']] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 file_name: Optional[pulumi.Input[str]] = None,
                 hls_settings: Optional[pulumi.Input['HlsSettingsArgs']] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 mpeg4_track_id: Optional[pulumi.Input[int]] = None):
        """
        Represents an audio track in the asset.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioTrack'.
        :param pulumi.Input['DashSettingsArgs'] dash_settings: The DASH specific setting for the audio track.
        :param pulumi.Input[str] display_name: The display name of the audio track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        :param pulumi.Input[str] file_name: The file name to the source file. This file is located in the storage container of the asset.
        :param pulumi.Input['HlsSettingsArgs'] hls_settings: The HLS specific setting for the audio track.
        :param pulumi.Input[str] language_code: The RFC5646 language code for the audio track.
        :param pulumi.Input[int] mpeg4_track_id: The MPEG-4 audio track ID for the audio track.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioTrack')
        if dash_settings is not None:
            pulumi.set(__self__, "dash_settings", dash_settings)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if hls_settings is not None:
            pulumi.set(__self__, "hls_settings", hls_settings)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if mpeg4_track_id is not None:
            pulumi.set(__self__, "mpeg4_track_id", mpeg4_track_id)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioTrack'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="dashSettings")
    def dash_settings(self) -> Optional[pulumi.Input['DashSettingsArgs']]:
        """
        The DASH specific setting for the audio track.
        """
        return pulumi.get(self, "dash_settings")

    @dash_settings.setter
    def dash_settings(self, value: Optional[pulumi.Input['DashSettingsArgs']]):
        pulumi.set(self, "dash_settings", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the audio track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[str]]:
        """
        The file name to the source file. This file is located in the storage container of the asset.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter(name="hlsSettings")
    def hls_settings(self) -> Optional[pulumi.Input['HlsSettingsArgs']]:
        """
        The HLS specific setting for the audio track.
        """
        return pulumi.get(self, "hls_settings")

    @hls_settings.setter
    def hls_settings(self, value: Optional[pulumi.Input['HlsSettingsArgs']]):
        pulumi.set(self, "hls_settings", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        The RFC5646 language code for the audio track.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="mpeg4TrackId")
    def mpeg4_track_id(self) -> Optional[pulumi.Input[int]]:
        """
        The MPEG-4 audio track ID for the audio track.
        """
        return pulumi.get(self, "mpeg4_track_id")

    @mpeg4_track_id.setter
    def mpeg4_track_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mpeg4_track_id", value)


@pulumi.input_type
class CbcsDrmConfigurationArgs:
    def __init__(__self__, *,
                 fair_play: Optional[pulumi.Input['StreamingPolicyFairPlayConfigurationArgs']] = None,
                 play_ready: Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']] = None,
                 widevine: Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']] = None):
        """
        Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
        :param pulumi.Input['StreamingPolicyFairPlayConfigurationArgs'] fair_play: FairPlay configurations
        :param pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs'] play_ready: PlayReady configurations
        :param pulumi.Input['StreamingPolicyWidevineConfigurationArgs'] widevine: Widevine configurations
        """
        if fair_play is not None:
            pulumi.set(__self__, "fair_play", fair_play)
        if play_ready is not None:
            pulumi.set(__self__, "play_ready", play_ready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter(name="fairPlay")
    def fair_play(self) -> Optional[pulumi.Input['StreamingPolicyFairPlayConfigurationArgs']]:
        """
        FairPlay configurations
        """
        return pulumi.get(self, "fair_play")

    @fair_play.setter
    def fair_play(self, value: Optional[pulumi.Input['StreamingPolicyFairPlayConfigurationArgs']]):
        pulumi.set(self, "fair_play", value)

    @property
    @pulumi.getter(name="playReady")
    def play_ready(self) -> Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']]:
        """
        PlayReady configurations
        """
        return pulumi.get(self, "play_ready")

    @play_ready.setter
    def play_ready(self, value: Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']]):
        pulumi.set(self, "play_ready", value)

    @property
    @pulumi.getter
    def widevine(self) -> Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']]:
        """
        Widevine configurations
        """
        return pulumi.get(self, "widevine")

    @widevine.setter
    def widevine(self, value: Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']]):
        pulumi.set(self, "widevine", value)


@pulumi.input_type
class CencDrmConfigurationArgs:
    def __init__(__self__, *,
                 play_ready: Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']] = None,
                 widevine: Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']] = None):
        """
        Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
        :param pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs'] play_ready: PlayReady configurations
        :param pulumi.Input['StreamingPolicyWidevineConfigurationArgs'] widevine: Widevine configurations
        """
        if play_ready is not None:
            pulumi.set(__self__, "play_ready", play_ready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter(name="playReady")
    def play_ready(self) -> Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']]:
        """
        PlayReady configurations
        """
        return pulumi.get(self, "play_ready")

    @play_ready.setter
    def play_ready(self, value: Optional[pulumi.Input['StreamingPolicyPlayReadyConfigurationArgs']]):
        pulumi.set(self, "play_ready", value)

    @property
    @pulumi.getter
    def widevine(self) -> Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']]:
        """
        Widevine configurations
        """
        return pulumi.get(self, "widevine")

    @widevine.setter
    def widevine(self, value: Optional[pulumi.Input['StreamingPolicyWidevineConfigurationArgs']]):
        pulumi.set(self, "widevine", value)


@pulumi.input_type
class ClearKeyEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 custom_keys_acquisition_url_template: Optional[pulumi.Input[str]] = None):
        """
        Class to specify ClearKey configuration of common encryption schemes in Streaming Policy
        :param pulumi.Input[str] custom_keys_acquisition_url_template: Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media Services for issuing licenses. The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token value is {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId.
        """
        if custom_keys_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_keys_acquisition_url_template", custom_keys_acquisition_url_template)

    @property
    @pulumi.getter(name="customKeysAcquisitionUrlTemplate")
    def custom_keys_acquisition_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media Services for issuing licenses. The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token value is {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId.
        """
        return pulumi.get(self, "custom_keys_acquisition_url_template")

    @custom_keys_acquisition_url_template.setter
    def custom_keys_acquisition_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_keys_acquisition_url_template", value)


@pulumi.input_type
class CommonEncryptionCbcsArgs:
    def __init__(__self__, *,
                 clear_key_encryption_configuration: Optional[pulumi.Input['ClearKeyEncryptionConfigurationArgs']] = None,
                 clear_tracks: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]] = None,
                 content_keys: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']] = None,
                 drm: Optional[pulumi.Input['CbcsDrmConfigurationArgs']] = None,
                 enabled_protocols: Optional[pulumi.Input['EnabledProtocolsArgs']] = None):
        """
        Class for CommonEncryptionCbcs encryption scheme
        :param pulumi.Input['ClearKeyEncryptionConfigurationArgs'] clear_key_encryption_configuration: Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
        :param pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]] clear_tracks: Representing which tracks should not be encrypted
        :param pulumi.Input['StreamingPolicyContentKeysArgs'] content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param pulumi.Input['CbcsDrmConfigurationArgs'] drm: Configuration of DRMs for current encryption scheme
        :param pulumi.Input['EnabledProtocolsArgs'] enabled_protocols: Representing supported protocols
        """
        if clear_key_encryption_configuration is not None:
            pulumi.set(__self__, "clear_key_encryption_configuration", clear_key_encryption_configuration)
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if drm is not None:
            pulumi.set(__self__, "drm", drm)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearKeyEncryptionConfiguration")
    def clear_key_encryption_configuration(self) -> Optional[pulumi.Input['ClearKeyEncryptionConfigurationArgs']]:
        """
        Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
        """
        return pulumi.get(self, "clear_key_encryption_configuration")

    @clear_key_encryption_configuration.setter
    def clear_key_encryption_configuration(self, value: Optional[pulumi.Input['ClearKeyEncryptionConfigurationArgs']]):
        pulumi.set(self, "clear_key_encryption_configuration", value)

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @clear_tracks.setter
    def clear_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]):
        pulumi.set(self, "clear_tracks", value)

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @content_keys.setter
    def content_keys(self, value: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]):
        pulumi.set(self, "content_keys", value)

    @property
    @pulumi.getter
    def drm(self) -> Optional[pulumi.Input['CbcsDrmConfigurationArgs']]:
        """
        Configuration of DRMs for current encryption scheme
        """
        return pulumi.get(self, "drm")

    @drm.setter
    def drm(self, value: Optional[pulumi.Input['CbcsDrmConfigurationArgs']]):
        pulumi.set(self, "drm", value)

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional[pulumi.Input['EnabledProtocolsArgs']]:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")

    @enabled_protocols.setter
    def enabled_protocols(self, value: Optional[pulumi.Input['EnabledProtocolsArgs']]):
        pulumi.set(self, "enabled_protocols", value)


@pulumi.input_type
class CommonEncryptionCencArgs:
    def __init__(__self__, *,
                 clear_key_encryption_configuration: Optional[pulumi.Input['ClearKeyEncryptionConfigurationArgs']] = None,
                 clear_tracks: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]] = None,
                 content_keys: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']] = None,
                 drm: Optional[pulumi.Input['CencDrmConfigurationArgs']] = None,
                 enabled_protocols: Optional[pulumi.Input['EnabledProtocolsArgs']] = None):
        """
        Class for envelope encryption scheme
        :param pulumi.Input['ClearKeyEncryptionConfigurationArgs'] clear_key_encryption_configuration: Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
        :param pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]] clear_tracks: Representing which tracks should not be encrypted
        :param pulumi.Input['StreamingPolicyContentKeysArgs'] content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param pulumi.Input['CencDrmConfigurationArgs'] drm: Configuration of DRMs for CommonEncryptionCenc encryption scheme
        :param pulumi.Input['EnabledProtocolsArgs'] enabled_protocols: Representing supported protocols
        """
        if clear_key_encryption_configuration is not None:
            pulumi.set(__self__, "clear_key_encryption_configuration", clear_key_encryption_configuration)
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if drm is not None:
            pulumi.set(__self__, "drm", drm)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearKeyEncryptionConfiguration")
    def clear_key_encryption_configuration(self) -> Optional[pulumi.Input['ClearKeyEncryptionConfigurationArgs']]:
        """
        Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
        """
        return pulumi.get(self, "clear_key_encryption_configuration")

    @clear_key_encryption_configuration.setter
    def clear_key_encryption_configuration(self, value: Optional[pulumi.Input['ClearKeyEncryptionConfigurationArgs']]):
        pulumi.set(self, "clear_key_encryption_configuration", value)

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @clear_tracks.setter
    def clear_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]):
        pulumi.set(self, "clear_tracks", value)

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @content_keys.setter
    def content_keys(self, value: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]):
        pulumi.set(self, "content_keys", value)

    @property
    @pulumi.getter
    def drm(self) -> Optional[pulumi.Input['CencDrmConfigurationArgs']]:
        """
        Configuration of DRMs for CommonEncryptionCenc encryption scheme
        """
        return pulumi.get(self, "drm")

    @drm.setter
    def drm(self, value: Optional[pulumi.Input['CencDrmConfigurationArgs']]):
        pulumi.set(self, "drm", value)

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional[pulumi.Input['EnabledProtocolsArgs']]:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")

    @enabled_protocols.setter
    def enabled_protocols(self, value: Optional[pulumi.Input['EnabledProtocolsArgs']]):
        pulumi.set(self, "enabled_protocols", value)


@pulumi.input_type
class ContentKeyPolicyClearKeyConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Represents a configuration for non-DRM keys.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyFairPlayConfigurationArgs:
    def __init__(__self__, *,
                 ask: pulumi.Input[str],
                 fair_play_pfx: pulumi.Input[str],
                 fair_play_pfx_password: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 rental_and_lease_key_type: pulumi.Input[Union[str, 'ContentKeyPolicyFairPlayRentalAndLeaseKeyType']],
                 rental_duration: pulumi.Input[float],
                 offline_rental_configuration: Optional[pulumi.Input['ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs']] = None):
        """
        Specifies a configuration for FairPlay licenses.
        :param pulumi.Input[str] ask: The key that must be used as FairPlay Application Secret key. This needs to be base64 encoded.
        :param pulumi.Input[str] fair_play_pfx: The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
        :param pulumi.Input[str] fair_play_pfx_password: The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
        :param pulumi.Input[Union[str, 'ContentKeyPolicyFairPlayRentalAndLeaseKeyType']] rental_and_lease_key_type: The rental and lease key type.
        :param pulumi.Input[float] rental_duration: The rental duration. Must be greater than or equal to 0.
        :param pulumi.Input['ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs'] offline_rental_configuration: Offline rental policy
        """
        pulumi.set(__self__, "ask", ask)
        pulumi.set(__self__, "fair_play_pfx", fair_play_pfx)
        pulumi.set(__self__, "fair_play_pfx_password", fair_play_pfx_password)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration')
        pulumi.set(__self__, "rental_and_lease_key_type", rental_and_lease_key_type)
        pulumi.set(__self__, "rental_duration", rental_duration)
        if offline_rental_configuration is not None:
            pulumi.set(__self__, "offline_rental_configuration", offline_rental_configuration)

    @property
    @pulumi.getter
    def ask(self) -> pulumi.Input[str]:
        """
        The key that must be used as FairPlay Application Secret key. This needs to be base64 encoded.
        """
        return pulumi.get(self, "ask")

    @ask.setter
    def ask(self, value: pulumi.Input[str]):
        pulumi.set(self, "ask", value)

    @property
    @pulumi.getter(name="fairPlayPfx")
    def fair_play_pfx(self) -> pulumi.Input[str]:
        """
        The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
        """
        return pulumi.get(self, "fair_play_pfx")

    @fair_play_pfx.setter
    def fair_play_pfx(self, value: pulumi.Input[str]):
        pulumi.set(self, "fair_play_pfx", value)

    @property
    @pulumi.getter(name="fairPlayPfxPassword")
    def fair_play_pfx_password(self) -> pulumi.Input[str]:
        """
        The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
        """
        return pulumi.get(self, "fair_play_pfx_password")

    @fair_play_pfx_password.setter
    def fair_play_pfx_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "fair_play_pfx_password", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="rentalAndLeaseKeyType")
    def rental_and_lease_key_type(self) -> pulumi.Input[Union[str, 'ContentKeyPolicyFairPlayRentalAndLeaseKeyType']]:
        """
        The rental and lease key type.
        """
        return pulumi.get(self, "rental_and_lease_key_type")

    @rental_and_lease_key_type.setter
    def rental_and_lease_key_type(self, value: pulumi.Input[Union[str, 'ContentKeyPolicyFairPlayRentalAndLeaseKeyType']]):
        pulumi.set(self, "rental_and_lease_key_type", value)

    @property
    @pulumi.getter(name="rentalDuration")
    def rental_duration(self) -> pulumi.Input[float]:
        """
        The rental duration. Must be greater than or equal to 0.
        """
        return pulumi.get(self, "rental_duration")

    @rental_duration.setter
    def rental_duration(self, value: pulumi.Input[float]):
        pulumi.set(self, "rental_duration", value)

    @property
    @pulumi.getter(name="offlineRentalConfiguration")
    def offline_rental_configuration(self) -> Optional[pulumi.Input['ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs']]:
        """
        Offline rental policy
        """
        return pulumi.get(self, "offline_rental_configuration")

    @offline_rental_configuration.setter
    def offline_rental_configuration(self, value: Optional[pulumi.Input['ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs']]):
        pulumi.set(self, "offline_rental_configuration", value)


@pulumi.input_type
class ContentKeyPolicyFairPlayOfflineRentalConfigurationArgs:
    def __init__(__self__, *,
                 playback_duration_seconds: pulumi.Input[float],
                 storage_duration_seconds: pulumi.Input[float]):
        """
        :param pulumi.Input[float] playback_duration_seconds: Playback duration
        :param pulumi.Input[float] storage_duration_seconds: Storage duration
        """
        pulumi.set(__self__, "playback_duration_seconds", playback_duration_seconds)
        pulumi.set(__self__, "storage_duration_seconds", storage_duration_seconds)

    @property
    @pulumi.getter(name="playbackDurationSeconds")
    def playback_duration_seconds(self) -> pulumi.Input[float]:
        """
        Playback duration
        """
        return pulumi.get(self, "playback_duration_seconds")

    @playback_duration_seconds.setter
    def playback_duration_seconds(self, value: pulumi.Input[float]):
        pulumi.set(self, "playback_duration_seconds", value)

    @property
    @pulumi.getter(name="storageDurationSeconds")
    def storage_duration_seconds(self) -> pulumi.Input[float]:
        """
        Storage duration
        """
        return pulumi.get(self, "storage_duration_seconds")

    @storage_duration_seconds.setter
    def storage_duration_seconds(self, value: pulumi.Input[float]):
        pulumi.set(self, "storage_duration_seconds", value)


@pulumi.input_type
class ContentKeyPolicyOpenRestrictionArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Represents an open restriction. License or key will be delivered on every request.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyOpenRestriction')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyOptionArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input[Union['ContentKeyPolicyClearKeyConfigurationArgs', 'ContentKeyPolicyFairPlayConfigurationArgs', 'ContentKeyPolicyPlayReadyConfigurationArgs', 'ContentKeyPolicyUnknownConfigurationArgs', 'ContentKeyPolicyWidevineConfigurationArgs']],
                 restriction: pulumi.Input[Union['ContentKeyPolicyOpenRestrictionArgs', 'ContentKeyPolicyTokenRestrictionArgs', 'ContentKeyPolicyUnknownRestrictionArgs']],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Represents a policy option.
        :param pulumi.Input[Union['ContentKeyPolicyClearKeyConfigurationArgs', 'ContentKeyPolicyFairPlayConfigurationArgs', 'ContentKeyPolicyPlayReadyConfigurationArgs', 'ContentKeyPolicyUnknownConfigurationArgs', 'ContentKeyPolicyWidevineConfigurationArgs']] configuration: The key delivery configuration.
        :param pulumi.Input[Union['ContentKeyPolicyOpenRestrictionArgs', 'ContentKeyPolicyTokenRestrictionArgs', 'ContentKeyPolicyUnknownRestrictionArgs']] restriction: The requirements that must be met to deliver keys with this configuration
        :param pulumi.Input[str] name: The Policy Option description.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "restriction", restriction)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input[Union['ContentKeyPolicyClearKeyConfigurationArgs', 'ContentKeyPolicyFairPlayConfigurationArgs', 'ContentKeyPolicyPlayReadyConfigurationArgs', 'ContentKeyPolicyUnknownConfigurationArgs', 'ContentKeyPolicyWidevineConfigurationArgs']]:
        """
        The key delivery configuration.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input[Union['ContentKeyPolicyClearKeyConfigurationArgs', 'ContentKeyPolicyFairPlayConfigurationArgs', 'ContentKeyPolicyPlayReadyConfigurationArgs', 'ContentKeyPolicyUnknownConfigurationArgs', 'ContentKeyPolicyWidevineConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def restriction(self) -> pulumi.Input[Union['ContentKeyPolicyOpenRestrictionArgs', 'ContentKeyPolicyTokenRestrictionArgs', 'ContentKeyPolicyUnknownRestrictionArgs']]:
        """
        The requirements that must be met to deliver keys with this configuration
        """
        return pulumi.get(self, "restriction")

    @restriction.setter
    def restriction(self, value: pulumi.Input[Union['ContentKeyPolicyOpenRestrictionArgs', 'ContentKeyPolicyTokenRestrictionArgs', 'ContentKeyPolicyUnknownRestrictionArgs']]):
        pulumi.set(self, "restriction", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Policy Option description.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyConfigurationArgs:
    def __init__(__self__, *,
                 licenses: pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyPlayReadyLicenseArgs']]],
                 odata_type: pulumi.Input[str],
                 response_custom_data: Optional[pulumi.Input[str]] = None):
        """
        Specifies a configuration for PlayReady licenses.
        :param pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyPlayReadyLicenseArgs']]] licenses: The PlayReady licenses.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
        :param pulumi.Input[str] response_custom_data: The custom response data.
        """
        pulumi.set(__self__, "licenses", licenses)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration')
        if response_custom_data is not None:
            pulumi.set(__self__, "response_custom_data", response_custom_data)

    @property
    @pulumi.getter
    def licenses(self) -> pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyPlayReadyLicenseArgs']]]:
        """
        The PlayReady licenses.
        """
        return pulumi.get(self, "licenses")

    @licenses.setter
    def licenses(self, value: pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyPlayReadyLicenseArgs']]]):
        pulumi.set(self, "licenses", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="responseCustomData")
    def response_custom_data(self) -> Optional[pulumi.Input[str]]:
        """
        The custom response data.
        """
        return pulumi.get(self, "response_custom_data")

    @response_custom_data.setter
    def response_custom_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_custom_data", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Specifies that the content key ID is in the PlayReady header.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs:
    def __init__(__self__, *,
                 key_id: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Specifies that the content key ID is specified in the PlayReady configuration.
        :param pulumi.Input[str] key_id: The content key ID.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier')

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[str]:
        """
        The content key ID.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs:
    def __init__(__self__, *,
                 best_effort: pulumi.Input[bool],
                 configuration_data: pulumi.Input[int]):
        """
        Configures the Explicit Analog Television Output Restriction control bits. For further details see the PlayReady Compliance Rules.
        :param pulumi.Input[bool] best_effort: Indicates whether this restriction is enforced on a Best Effort basis.
        :param pulumi.Input[int] configuration_data: Configures the restriction control bits. Must be between 0 and 3 inclusive.
        """
        pulumi.set(__self__, "best_effort", best_effort)
        pulumi.set(__self__, "configuration_data", configuration_data)

    @property
    @pulumi.getter(name="bestEffort")
    def best_effort(self) -> pulumi.Input[bool]:
        """
        Indicates whether this restriction is enforced on a Best Effort basis.
        """
        return pulumi.get(self, "best_effort")

    @best_effort.setter
    def best_effort(self, value: pulumi.Input[bool]):
        pulumi.set(self, "best_effort", value)

    @property
    @pulumi.getter(name="configurationData")
    def configuration_data(self) -> pulumi.Input[int]:
        """
        Configures the restriction control bits. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "configuration_data")

    @configuration_data.setter
    def configuration_data(self, value: pulumi.Input[int]):
        pulumi.set(self, "configuration_data", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyLicenseArgs:
    def __init__(__self__, *,
                 allow_test_devices: pulumi.Input[bool],
                 content_key_location: pulumi.Input[Union['ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs', 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs']],
                 content_type: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyContentType']],
                 license_type: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyLicenseType']],
                 begin_date: Optional[pulumi.Input[str]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 grace_period: Optional[pulumi.Input[str]] = None,
                 play_right: Optional[pulumi.Input['ContentKeyPolicyPlayReadyPlayRightArgs']] = None,
                 relative_begin_date: Optional[pulumi.Input[str]] = None,
                 relative_expiration_date: Optional[pulumi.Input[str]] = None,
                 security_level: Optional[pulumi.Input[Union[str, 'SecurityLevel']]] = None):
        """
        The PlayReady license
        :param pulumi.Input[bool] allow_test_devices: A flag indicating whether test devices can use the license.
        :param pulumi.Input[Union['ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs', 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs']] content_key_location: The content key location.
        :param pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyContentType']] content_type: The PlayReady content type.
        :param pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyLicenseType']] license_type: The license type.
        :param pulumi.Input[str] begin_date: The begin date of license
        :param pulumi.Input[str] expiration_date: The expiration date of license.
        :param pulumi.Input[str] grace_period: The grace period of license.
        :param pulumi.Input['ContentKeyPolicyPlayReadyPlayRightArgs'] play_right: The license PlayRight
        :param pulumi.Input[str] relative_begin_date: The relative begin date of license.
        :param pulumi.Input[str] relative_expiration_date: The relative expiration date of license.
        :param pulumi.Input[Union[str, 'SecurityLevel']] security_level: The security level.
        """
        pulumi.set(__self__, "allow_test_devices", allow_test_devices)
        pulumi.set(__self__, "content_key_location", content_key_location)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "license_type", license_type)
        if begin_date is not None:
            pulumi.set(__self__, "begin_date", begin_date)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if play_right is not None:
            pulumi.set(__self__, "play_right", play_right)
        if relative_begin_date is not None:
            pulumi.set(__self__, "relative_begin_date", relative_begin_date)
        if relative_expiration_date is not None:
            pulumi.set(__self__, "relative_expiration_date", relative_expiration_date)
        if security_level is not None:
            pulumi.set(__self__, "security_level", security_level)

    @property
    @pulumi.getter(name="allowTestDevices")
    def allow_test_devices(self) -> pulumi.Input[bool]:
        """
        A flag indicating whether test devices can use the license.
        """
        return pulumi.get(self, "allow_test_devices")

    @allow_test_devices.setter
    def allow_test_devices(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_test_devices", value)

    @property
    @pulumi.getter(name="contentKeyLocation")
    def content_key_location(self) -> pulumi.Input[Union['ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs', 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs']]:
        """
        The content key location.
        """
        return pulumi.get(self, "content_key_location")

    @content_key_location.setter
    def content_key_location(self, value: pulumi.Input[Union['ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderArgs', 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierArgs']]):
        pulumi.set(self, "content_key_location", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyContentType']]:
        """
        The PlayReady content type.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyContentType']]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyLicenseType']]:
        """
        The license type.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyLicenseType']]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="beginDate")
    def begin_date(self) -> Optional[pulumi.Input[str]]:
        """
        The begin date of license
        """
        return pulumi.get(self, "begin_date")

    @begin_date.setter
    def begin_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "begin_date", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        The expiration date of license.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[pulumi.Input[str]]:
        """
        The grace period of license.
        """
        return pulumi.get(self, "grace_period")

    @grace_period.setter
    def grace_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grace_period", value)

    @property
    @pulumi.getter(name="playRight")
    def play_right(self) -> Optional[pulumi.Input['ContentKeyPolicyPlayReadyPlayRightArgs']]:
        """
        The license PlayRight
        """
        return pulumi.get(self, "play_right")

    @play_right.setter
    def play_right(self, value: Optional[pulumi.Input['ContentKeyPolicyPlayReadyPlayRightArgs']]):
        pulumi.set(self, "play_right", value)

    @property
    @pulumi.getter(name="relativeBeginDate")
    def relative_begin_date(self) -> Optional[pulumi.Input[str]]:
        """
        The relative begin date of license.
        """
        return pulumi.get(self, "relative_begin_date")

    @relative_begin_date.setter
    def relative_begin_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_begin_date", value)

    @property
    @pulumi.getter(name="relativeExpirationDate")
    def relative_expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        The relative expiration date of license.
        """
        return pulumi.get(self, "relative_expiration_date")

    @relative_expiration_date.setter
    def relative_expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relative_expiration_date", value)

    @property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> Optional[pulumi.Input[Union[str, 'SecurityLevel']]]:
        """
        The security level.
        """
        return pulumi.get(self, "security_level")

    @security_level.setter
    def security_level(self, value: Optional[pulumi.Input[Union[str, 'SecurityLevel']]]):
        pulumi.set(self, "security_level", value)


@pulumi.input_type
class ContentKeyPolicyPlayReadyPlayRightArgs:
    def __init__(__self__, *,
                 allow_passing_video_content_to_unknown_output: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyUnknownOutputPassingOption']],
                 digital_video_only_content_restriction: pulumi.Input[bool],
                 image_constraint_for_analog_component_video_restriction: pulumi.Input[bool],
                 image_constraint_for_analog_computer_monitor_restriction: pulumi.Input[bool],
                 agc_and_color_stripe_restriction: Optional[pulumi.Input[int]] = None,
                 analog_video_opl: Optional[pulumi.Input[int]] = None,
                 compressed_digital_audio_opl: Optional[pulumi.Input[int]] = None,
                 compressed_digital_video_opl: Optional[pulumi.Input[int]] = None,
                 explicit_analog_television_output_restriction: Optional[pulumi.Input['ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs']] = None,
                 first_play_expiration: Optional[pulumi.Input[str]] = None,
                 scms_restriction: Optional[pulumi.Input[int]] = None,
                 uncompressed_digital_audio_opl: Optional[pulumi.Input[int]] = None,
                 uncompressed_digital_video_opl: Optional[pulumi.Input[int]] = None):
        """
        Configures the Play Right in the PlayReady license.
        :param pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyUnknownOutputPassingOption']] allow_passing_video_content_to_unknown_output: Configures Unknown output handling settings of the license.
        :param pulumi.Input[bool] digital_video_only_content_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param pulumi.Input[bool] image_constraint_for_analog_component_video_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param pulumi.Input[bool] image_constraint_for_analog_computer_monitor_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param pulumi.Input[int] agc_and_color_stripe_restriction: Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
        :param pulumi.Input[int] analog_video_opl: Specifies the output protection level for compressed digital audio.
        :param pulumi.Input[int] compressed_digital_audio_opl: Specifies the output protection level for compressed digital audio.
        :param pulumi.Input[int] compressed_digital_video_opl: Specifies the output protection level for compressed digital video.
        :param pulumi.Input['ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs'] explicit_analog_television_output_restriction: Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
        :param pulumi.Input[str] first_play_expiration: The amount of time that the license is valid after the license is first used to play content.
        :param pulumi.Input[int] scms_restriction: Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
        :param pulumi.Input[int] uncompressed_digital_audio_opl: Specifies the output protection level for uncompressed digital audio.
        :param pulumi.Input[int] uncompressed_digital_video_opl: Specifies the output protection level for uncompressed digital video.
        """
        pulumi.set(__self__, "allow_passing_video_content_to_unknown_output", allow_passing_video_content_to_unknown_output)
        pulumi.set(__self__, "digital_video_only_content_restriction", digital_video_only_content_restriction)
        pulumi.set(__self__, "image_constraint_for_analog_component_video_restriction", image_constraint_for_analog_component_video_restriction)
        pulumi.set(__self__, "image_constraint_for_analog_computer_monitor_restriction", image_constraint_for_analog_computer_monitor_restriction)
        if agc_and_color_stripe_restriction is not None:
            pulumi.set(__self__, "agc_and_color_stripe_restriction", agc_and_color_stripe_restriction)
        if analog_video_opl is not None:
            pulumi.set(__self__, "analog_video_opl", analog_video_opl)
        if compressed_digital_audio_opl is not None:
            pulumi.set(__self__, "compressed_digital_audio_opl", compressed_digital_audio_opl)
        if compressed_digital_video_opl is not None:
            pulumi.set(__self__, "compressed_digital_video_opl", compressed_digital_video_opl)
        if explicit_analog_television_output_restriction is not None:
            pulumi.set(__self__, "explicit_analog_television_output_restriction", explicit_analog_television_output_restriction)
        if first_play_expiration is not None:
            pulumi.set(__self__, "first_play_expiration", first_play_expiration)
        if scms_restriction is not None:
            pulumi.set(__self__, "scms_restriction", scms_restriction)
        if uncompressed_digital_audio_opl is not None:
            pulumi.set(__self__, "uncompressed_digital_audio_opl", uncompressed_digital_audio_opl)
        if uncompressed_digital_video_opl is not None:
            pulumi.set(__self__, "uncompressed_digital_video_opl", uncompressed_digital_video_opl)

    @property
    @pulumi.getter(name="allowPassingVideoContentToUnknownOutput")
    def allow_passing_video_content_to_unknown_output(self) -> pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyUnknownOutputPassingOption']]:
        """
        Configures Unknown output handling settings of the license.
        """
        return pulumi.get(self, "allow_passing_video_content_to_unknown_output")

    @allow_passing_video_content_to_unknown_output.setter
    def allow_passing_video_content_to_unknown_output(self, value: pulumi.Input[Union[str, 'ContentKeyPolicyPlayReadyUnknownOutputPassingOption']]):
        pulumi.set(self, "allow_passing_video_content_to_unknown_output", value)

    @property
    @pulumi.getter(name="digitalVideoOnlyContentRestriction")
    def digital_video_only_content_restriction(self) -> pulumi.Input[bool]:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "digital_video_only_content_restriction")

    @digital_video_only_content_restriction.setter
    def digital_video_only_content_restriction(self, value: pulumi.Input[bool]):
        pulumi.set(self, "digital_video_only_content_restriction", value)

    @property
    @pulumi.getter(name="imageConstraintForAnalogComponentVideoRestriction")
    def image_constraint_for_analog_component_video_restriction(self) -> pulumi.Input[bool]:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "image_constraint_for_analog_component_video_restriction")

    @image_constraint_for_analog_component_video_restriction.setter
    def image_constraint_for_analog_component_video_restriction(self, value: pulumi.Input[bool]):
        pulumi.set(self, "image_constraint_for_analog_component_video_restriction", value)

    @property
    @pulumi.getter(name="imageConstraintForAnalogComputerMonitorRestriction")
    def image_constraint_for_analog_computer_monitor_restriction(self) -> pulumi.Input[bool]:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "image_constraint_for_analog_computer_monitor_restriction")

    @image_constraint_for_analog_computer_monitor_restriction.setter
    def image_constraint_for_analog_computer_monitor_restriction(self, value: pulumi.Input[bool]):
        pulumi.set(self, "image_constraint_for_analog_computer_monitor_restriction", value)

    @property
    @pulumi.getter(name="agcAndColorStripeRestriction")
    def agc_and_color_stripe_restriction(self) -> Optional[pulumi.Input[int]]:
        """
        Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "agc_and_color_stripe_restriction")

    @agc_and_color_stripe_restriction.setter
    def agc_and_color_stripe_restriction(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agc_and_color_stripe_restriction", value)

    @property
    @pulumi.getter(name="analogVideoOpl")
    def analog_video_opl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the output protection level for compressed digital audio.
        """
        return pulumi.get(self, "analog_video_opl")

    @analog_video_opl.setter
    def analog_video_opl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "analog_video_opl", value)

    @property
    @pulumi.getter(name="compressedDigitalAudioOpl")
    def compressed_digital_audio_opl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the output protection level for compressed digital audio.
        """
        return pulumi.get(self, "compressed_digital_audio_opl")

    @compressed_digital_audio_opl.setter
    def compressed_digital_audio_opl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compressed_digital_audio_opl", value)

    @property
    @pulumi.getter(name="compressedDigitalVideoOpl")
    def compressed_digital_video_opl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the output protection level for compressed digital video.
        """
        return pulumi.get(self, "compressed_digital_video_opl")

    @compressed_digital_video_opl.setter
    def compressed_digital_video_opl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compressed_digital_video_opl", value)

    @property
    @pulumi.getter(name="explicitAnalogTelevisionOutputRestriction")
    def explicit_analog_television_output_restriction(self) -> Optional[pulumi.Input['ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs']]:
        """
        Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "explicit_analog_television_output_restriction")

    @explicit_analog_television_output_restriction.setter
    def explicit_analog_television_output_restriction(self, value: Optional[pulumi.Input['ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionArgs']]):
        pulumi.set(self, "explicit_analog_television_output_restriction", value)

    @property
    @pulumi.getter(name="firstPlayExpiration")
    def first_play_expiration(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time that the license is valid after the license is first used to play content.
        """
        return pulumi.get(self, "first_play_expiration")

    @first_play_expiration.setter
    def first_play_expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_play_expiration", value)

    @property
    @pulumi.getter(name="scmsRestriction")
    def scms_restriction(self) -> Optional[pulumi.Input[int]]:
        """
        Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "scms_restriction")

    @scms_restriction.setter
    def scms_restriction(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scms_restriction", value)

    @property
    @pulumi.getter(name="uncompressedDigitalAudioOpl")
    def uncompressed_digital_audio_opl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the output protection level for uncompressed digital audio.
        """
        return pulumi.get(self, "uncompressed_digital_audio_opl")

    @uncompressed_digital_audio_opl.setter
    def uncompressed_digital_audio_opl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "uncompressed_digital_audio_opl", value)

    @property
    @pulumi.getter(name="uncompressedDigitalVideoOpl")
    def uncompressed_digital_video_opl(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the output protection level for uncompressed digital video.
        """
        return pulumi.get(self, "uncompressed_digital_video_opl")

    @uncompressed_digital_video_opl.setter
    def uncompressed_digital_video_opl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "uncompressed_digital_video_opl", value)


@pulumi.input_type
class ContentKeyPolicyRsaTokenKeyArgs:
    def __init__(__self__, *,
                 exponent: pulumi.Input[str],
                 modulus: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Specifies a RSA key for token validation
        :param pulumi.Input[str] exponent: The RSA Parameter exponent
        :param pulumi.Input[str] modulus: The RSA Parameter modulus
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
        """
        pulumi.set(__self__, "exponent", exponent)
        pulumi.set(__self__, "modulus", modulus)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyRsaTokenKey')

    @property
    @pulumi.getter
    def exponent(self) -> pulumi.Input[str]:
        """
        The RSA Parameter exponent
        """
        return pulumi.get(self, "exponent")

    @exponent.setter
    def exponent(self, value: pulumi.Input[str]):
        pulumi.set(self, "exponent", value)

    @property
    @pulumi.getter
    def modulus(self) -> pulumi.Input[str]:
        """
        The RSA Parameter modulus
        """
        return pulumi.get(self, "modulus")

    @modulus.setter
    def modulus(self, value: pulumi.Input[str]):
        pulumi.set(self, "modulus", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicySymmetricTokenKeyArgs:
    def __init__(__self__, *,
                 key_value: pulumi.Input[str],
                 odata_type: pulumi.Input[str]):
        """
        Specifies a symmetric key for token validation.
        :param pulumi.Input[str] key_value: The key value of the key
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
        """
        pulumi.set(__self__, "key_value", key_value)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey')

    @property
    @pulumi.getter(name="keyValue")
    def key_value(self) -> pulumi.Input[str]:
        """
        The key value of the key
        """
        return pulumi.get(self, "key_value")

    @key_value.setter
    def key_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_value", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyTokenClaimArgs:
    def __init__(__self__, *,
                 claim_type: Optional[pulumi.Input[str]] = None,
                 claim_value: Optional[pulumi.Input[str]] = None):
        """
        Represents a token claim.
        :param pulumi.Input[str] claim_type: Token claim type.
        :param pulumi.Input[str] claim_value: Token claim value.
        """
        if claim_type is not None:
            pulumi.set(__self__, "claim_type", claim_type)
        if claim_value is not None:
            pulumi.set(__self__, "claim_value", claim_value)

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> Optional[pulumi.Input[str]]:
        """
        Token claim type.
        """
        return pulumi.get(self, "claim_type")

    @claim_type.setter
    def claim_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "claim_type", value)

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> Optional[pulumi.Input[str]]:
        """
        Token claim value.
        """
        return pulumi.get(self, "claim_value")

    @claim_value.setter
    def claim_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "claim_value", value)


@pulumi.input_type
class ContentKeyPolicyTokenRestrictionArgs:
    def __init__(__self__, *,
                 audience: pulumi.Input[str],
                 issuer: pulumi.Input[str],
                 odata_type: pulumi.Input[str],
                 primary_verification_key: pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']],
                 restriction_token_type: pulumi.Input[Union[str, 'ContentKeyPolicyRestrictionTokenType']],
                 alternate_verification_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]]]] = None,
                 open_id_connect_discovery_document: Optional[pulumi.Input[str]] = None,
                 required_claims: Optional[pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyTokenClaimArgs']]]] = None):
        """
        Represents a token restriction. Provided token must match these requirements for successful license or key delivery.
        :param pulumi.Input[str] audience: The audience for the token.
        :param pulumi.Input[str] issuer: The token issuer.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
        :param pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']] primary_verification_key: The primary verification key.
        :param pulumi.Input[Union[str, 'ContentKeyPolicyRestrictionTokenType']] restriction_token_type: The type of token.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]]] alternate_verification_keys: A list of alternative verification keys.
        :param pulumi.Input[str] open_id_connect_discovery_document: The OpenID connect discovery document.
        :param pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyTokenClaimArgs']]] required_claims: A list of required token claims.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyTokenRestriction')
        pulumi.set(__self__, "primary_verification_key", primary_verification_key)
        pulumi.set(__self__, "restriction_token_type", restriction_token_type)
        if alternate_verification_keys is not None:
            pulumi.set(__self__, "alternate_verification_keys", alternate_verification_keys)
        if open_id_connect_discovery_document is not None:
            pulumi.set(__self__, "open_id_connect_discovery_document", open_id_connect_discovery_document)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)

    @property
    @pulumi.getter
    def audience(self) -> pulumi.Input[str]:
        """
        The audience for the token.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: pulumi.Input[str]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[str]:
        """
        The token issuer.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="primaryVerificationKey")
    def primary_verification_key(self) -> pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]:
        """
        The primary verification key.
        """
        return pulumi.get(self, "primary_verification_key")

    @primary_verification_key.setter
    def primary_verification_key(self, value: pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]):
        pulumi.set(self, "primary_verification_key", value)

    @property
    @pulumi.getter(name="restrictionTokenType")
    def restriction_token_type(self) -> pulumi.Input[Union[str, 'ContentKeyPolicyRestrictionTokenType']]:
        """
        The type of token.
        """
        return pulumi.get(self, "restriction_token_type")

    @restriction_token_type.setter
    def restriction_token_type(self, value: pulumi.Input[Union[str, 'ContentKeyPolicyRestrictionTokenType']]):
        pulumi.set(self, "restriction_token_type", value)

    @property
    @pulumi.getter(name="alternateVerificationKeys")
    def alternate_verification_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]]]]:
        """
        A list of alternative verification keys.
        """
        return pulumi.get(self, "alternate_verification_keys")

    @alternate_verification_keys.setter
    def alternate_verification_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContentKeyPolicyRsaTokenKeyArgs', 'ContentKeyPolicySymmetricTokenKeyArgs', 'ContentKeyPolicyX509CertificateTokenKeyArgs']]]]]):
        pulumi.set(self, "alternate_verification_keys", value)

    @property
    @pulumi.getter(name="openIdConnectDiscoveryDocument")
    def open_id_connect_discovery_document(self) -> Optional[pulumi.Input[str]]:
        """
        The OpenID connect discovery document.
        """
        return pulumi.get(self, "open_id_connect_discovery_document")

    @open_id_connect_discovery_document.setter
    def open_id_connect_discovery_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "open_id_connect_discovery_document", value)

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyTokenClaimArgs']]]]:
        """
        A list of required token claims.
        """
        return pulumi.get(self, "required_claims")

    @required_claims.setter
    def required_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContentKeyPolicyTokenClaimArgs']]]]):
        pulumi.set(self, "required_claims", value)


@pulumi.input_type
class ContentKeyPolicyUnknownConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Represents a ContentKeyPolicyConfiguration that is unavailable in the current API version.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyUnknownRestrictionArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyUnknownRestriction')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class ContentKeyPolicyWidevineConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 widevine_template: pulumi.Input[str]):
        """
        Specifies a configuration for Widevine licenses.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
        :param pulumi.Input[str] widevine_template: The Widevine template.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration')
        pulumi.set(__self__, "widevine_template", widevine_template)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="widevineTemplate")
    def widevine_template(self) -> pulumi.Input[str]:
        """
        The Widevine template.
        """
        return pulumi.get(self, "widevine_template")

    @widevine_template.setter
    def widevine_template(self, value: pulumi.Input[str]):
        pulumi.set(self, "widevine_template", value)


@pulumi.input_type
class ContentKeyPolicyX509CertificateTokenKeyArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 raw_body: pulumi.Input[str]):
        """
        Specifies a certificate for token validation.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
        :param pulumi.Input[str] raw_body: The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey')
        pulumi.set(__self__, "raw_body", raw_body)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="rawBody")
    def raw_body(self) -> pulumi.Input[str]:
        """
        The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
        """
        return pulumi.get(self, "raw_body")

    @raw_body.setter
    def raw_body(self, value: pulumi.Input[str]):
        pulumi.set(self, "raw_body", value)


@pulumi.input_type
class CrossSiteAccessPoliciesArgs:
    def __init__(__self__, *,
                 client_access_policy: Optional[pulumi.Input[str]] = None,
                 cross_domain_policy: Optional[pulumi.Input[str]] = None):
        """
        The client access policy.
        :param pulumi.Input[str] client_access_policy: The content of clientaccesspolicy.xml used by Silverlight.
        :param pulumi.Input[str] cross_domain_policy: The content of crossdomain.xml used by Silverlight.
        """
        if client_access_policy is not None:
            pulumi.set(__self__, "client_access_policy", client_access_policy)
        if cross_domain_policy is not None:
            pulumi.set(__self__, "cross_domain_policy", cross_domain_policy)

    @property
    @pulumi.getter(name="clientAccessPolicy")
    def client_access_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The content of clientaccesspolicy.xml used by Silverlight.
        """
        return pulumi.get(self, "client_access_policy")

    @client_access_policy.setter
    def client_access_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_access_policy", value)

    @property
    @pulumi.getter(name="crossDomainPolicy")
    def cross_domain_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The content of crossdomain.xml used by Silverlight.
        """
        return pulumi.get(self, "cross_domain_policy")

    @cross_domain_policy.setter
    def cross_domain_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_domain_policy", value)


@pulumi.input_type
class DashSettingsArgs:
    def __init__(__self__, *,
                 role: Optional[pulumi.Input[str]] = None):
        """
        The DASH setting for a track.
        :param pulumi.Input[str] role: The role for the DASH setting.
        """
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role for the DASH setting.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class DefaultKeyArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None):
        """
        Class to specify properties of default content key for each encryption scheme
        :param pulumi.Input[str] label: Label can be used to specify Content Key when creating a Streaming Locator
        :param pulumi.Input[str] policy_name: Policy used by Default Key
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Label can be used to specify Content Key when creating a Streaming Locator
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Policy used by Default Key
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)


@pulumi.input_type
class EnabledProtocolsArgs:
    def __init__(__self__, *,
                 dash: pulumi.Input[bool],
                 download: pulumi.Input[bool],
                 hls: pulumi.Input[bool],
                 smooth_streaming: pulumi.Input[bool]):
        """
        Class to specify which protocols are enabled
        :param pulumi.Input[bool] dash: Enable DASH protocol or not
        :param pulumi.Input[bool] download: Enable Download protocol or not
        :param pulumi.Input[bool] hls: Enable HLS protocol or not
        :param pulumi.Input[bool] smooth_streaming: Enable SmoothStreaming protocol or not
        """
        pulumi.set(__self__, "dash", dash)
        pulumi.set(__self__, "download", download)
        pulumi.set(__self__, "hls", hls)
        pulumi.set(__self__, "smooth_streaming", smooth_streaming)

    @property
    @pulumi.getter
    def dash(self) -> pulumi.Input[bool]:
        """
        Enable DASH protocol or not
        """
        return pulumi.get(self, "dash")

    @dash.setter
    def dash(self, value: pulumi.Input[bool]):
        pulumi.set(self, "dash", value)

    @property
    @pulumi.getter
    def download(self) -> pulumi.Input[bool]:
        """
        Enable Download protocol or not
        """
        return pulumi.get(self, "download")

    @download.setter
    def download(self, value: pulumi.Input[bool]):
        pulumi.set(self, "download", value)

    @property
    @pulumi.getter
    def hls(self) -> pulumi.Input[bool]:
        """
        Enable HLS protocol or not
        """
        return pulumi.get(self, "hls")

    @hls.setter
    def hls(self, value: pulumi.Input[bool]):
        pulumi.set(self, "hls", value)

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> pulumi.Input[bool]:
        """
        Enable SmoothStreaming protocol or not
        """
        return pulumi.get(self, "smooth_streaming")

    @smooth_streaming.setter
    def smooth_streaming(self, value: pulumi.Input[bool]):
        pulumi.set(self, "smooth_streaming", value)


@pulumi.input_type
class EnvelopeEncryptionArgs:
    def __init__(__self__, *,
                 clear_tracks: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]] = None,
                 content_keys: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']] = None,
                 custom_key_acquisition_url_template: Optional[pulumi.Input[str]] = None,
                 enabled_protocols: Optional[pulumi.Input['EnabledProtocolsArgs']] = None):
        """
        Class for EnvelopeEncryption encryption scheme
        :param pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]] clear_tracks: Representing which tracks should not be encrypted
        :param pulumi.Input['StreamingPolicyContentKeysArgs'] content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param pulumi.Input[str] custom_key_acquisition_url_template: Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        :param pulumi.Input['EnabledProtocolsArgs'] enabled_protocols: Representing supported protocols
        """
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if custom_key_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_key_acquisition_url_template", custom_key_acquisition_url_template)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @clear_tracks.setter
    def clear_tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]):
        pulumi.set(self, "clear_tracks", value)

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @content_keys.setter
    def content_keys(self, value: Optional[pulumi.Input['StreamingPolicyContentKeysArgs']]):
        pulumi.set(self, "content_keys", value)

    @property
    @pulumi.getter(name="customKeyAcquisitionUrlTemplate")
    def custom_key_acquisition_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_key_acquisition_url_template")

    @custom_key_acquisition_url_template.setter
    def custom_key_acquisition_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_key_acquisition_url_template", value)

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional[pulumi.Input['EnabledProtocolsArgs']]:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")

    @enabled_protocols.setter
    def enabled_protocols(self, value: Optional[pulumi.Input['EnabledProtocolsArgs']]):
        pulumi.set(self, "enabled_protocols", value)


@pulumi.input_type
class FilterTrackPropertyConditionArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input[Union[str, 'FilterTrackPropertyCompareOperation']],
                 property: pulumi.Input[Union[str, 'FilterTrackPropertyType']],
                 value: pulumi.Input[str]):
        """
        The class to specify one track property condition.
        :param pulumi.Input[Union[str, 'FilterTrackPropertyCompareOperation']] operation: The track property condition operation.
        :param pulumi.Input[Union[str, 'FilterTrackPropertyType']] property: The track property type.
        :param pulumi.Input[str] value: The track property value.
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[Union[str, 'FilterTrackPropertyCompareOperation']]:
        """
        The track property condition operation.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[Union[str, 'FilterTrackPropertyCompareOperation']]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The track property value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def property(self) -> pulumi.Input[Union[str, 'FilterTrackPropertyType']]:
        """
        The track property type.
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: pulumi.Input[Union[str, 'FilterTrackPropertyType']]):
        pulumi.set(self, "property", value)


@pulumi.input_type
class FilterTrackSelectionArgs:
    def __init__(__self__, *,
                 track_selections: pulumi.Input[Sequence[pulumi.Input['FilterTrackPropertyConditionArgs']]]):
        """
        Representing a list of FilterTrackPropertyConditions to select a track.  The filters are combined using a logical AND operation.
        :param pulumi.Input[Sequence[pulumi.Input['FilterTrackPropertyConditionArgs']]] track_selections: The track selections.
        """
        pulumi.set(__self__, "track_selections", track_selections)

    @property
    @pulumi.getter(name="trackSelections")
    def track_selections(self) -> pulumi.Input[Sequence[pulumi.Input['FilterTrackPropertyConditionArgs']]]:
        """
        The track selections.
        """
        return pulumi.get(self, "track_selections")

    @track_selections.setter
    def track_selections(self, value: pulumi.Input[Sequence[pulumi.Input['FilterTrackPropertyConditionArgs']]]):
        pulumi.set(self, "track_selections", value)


@pulumi.input_type
class FirstQualityArgs:
    def __init__(__self__, *,
                 bitrate: pulumi.Input[int]):
        """
        Filter First Quality
        :param pulumi.Input[int] bitrate: The first quality bitrate.
        """
        pulumi.set(__self__, "bitrate", bitrate)

    @property
    @pulumi.getter
    def bitrate(self) -> pulumi.Input[int]:
        """
        The first quality bitrate.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: pulumi.Input[int]):
        pulumi.set(self, "bitrate", value)


@pulumi.input_type
class HlsSettingsArgs:
    def __init__(__self__, *,
                 characteristics: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 forced: Optional[pulumi.Input[bool]] = None):
        """
        The HLS setting for a track.
        :param pulumi.Input[str] characteristics: The characteristics for the HLS setting.
        :param pulumi.Input[bool] default: The default for the HLS setting.
        :param pulumi.Input[bool] forced: The forced for the HLS setting.
        """
        if characteristics is not None:
            pulumi.set(__self__, "characteristics", characteristics)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if forced is not None:
            pulumi.set(__self__, "forced", forced)

    @property
    @pulumi.getter
    def characteristics(self) -> Optional[pulumi.Input[str]]:
        """
        The characteristics for the HLS setting.
        """
        return pulumi.get(self, "characteristics")

    @characteristics.setter
    def characteristics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "characteristics", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        The default for the HLS setting.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def forced(self) -> Optional[pulumi.Input[bool]]:
        """
        The forced for the HLS setting.
        """
        return pulumi.get(self, "forced")

    @forced.setter
    def forced(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forced", value)


@pulumi.input_type
class HlsArgs:
    def __init__(__self__, *,
                 fragments_per_ts_segment: Optional[pulumi.Input[int]] = None):
        """
        HTTP Live Streaming (HLS) packing setting for the live output.
        :param pulumi.Input[int] fragments_per_ts_segment: The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
        """
        if fragments_per_ts_segment is not None:
            pulumi.set(__self__, "fragments_per_ts_segment", fragments_per_ts_segment)

    @property
    @pulumi.getter(name="fragmentsPerTsSegment")
    def fragments_per_ts_segment(self) -> Optional[pulumi.Input[int]]:
        """
        The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
        """
        return pulumi.get(self, "fragments_per_ts_segment")

    @fragments_per_ts_segment.setter
    def fragments_per_ts_segment(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fragments_per_ts_segment", value)


@pulumi.input_type
class IPAccessControlArgs:
    def __init__(__self__, *,
                 allow: Optional[pulumi.Input[Sequence[pulumi.Input['IPRangeArgs']]]] = None):
        """
        The IP access control.
        :param pulumi.Input[Sequence[pulumi.Input['IPRangeArgs']]] allow: The IP allow list.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)

    @property
    @pulumi.getter
    def allow(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPRangeArgs']]]]:
        """
        The IP allow list.
        """
        return pulumi.get(self, "allow")

    @allow.setter
    def allow(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPRangeArgs']]]]):
        pulumi.set(self, "allow", value)


@pulumi.input_type
class IPRangeArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnet_prefix_length: Optional[pulumi.Input[int]] = None):
        """
        The IP address range in the CIDR scheme.
        :param pulumi.Input[str] address: The IP address.
        :param pulumi.Input[str] name: The friendly name for the IP address range.
        :param pulumi.Input[int] subnet_prefix_length: The subnet mask prefix length (see CIDR notation).
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet_prefix_length is not None:
            pulumi.set(__self__, "subnet_prefix_length", subnet_prefix_length)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The friendly name for the IP address range.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="subnetPrefixLength")
    def subnet_prefix_length(self) -> Optional[pulumi.Input[int]]:
        """
        The subnet mask prefix length (see CIDR notation).
        """
        return pulumi.get(self, "subnet_prefix_length")

    @subnet_prefix_length.setter
    def subnet_prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "subnet_prefix_length", value)


@pulumi.input_type
class LiveEventEncodingArgs:
    def __init__(__self__, *,
                 encoding_type: Optional[pulumi.Input[Union[str, 'LiveEventEncodingType']]] = None,
                 key_frame_interval: Optional[pulumi.Input[str]] = None,
                 preset_name: Optional[pulumi.Input[str]] = None,
                 stretch_mode: Optional[pulumi.Input[Union[str, 'StretchMode']]] = None):
        """
        Specifies the live event type and optional encoding settings for encoding live events.
        :param pulumi.Input[Union[str, 'LiveEventEncodingType']] encoding_type: Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
        :param pulumi.Input[str] key_frame_interval: Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
        :param pulumi.Input[str] preset_name: The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
        :param pulumi.Input[Union[str, 'StretchMode']] stretch_mode: Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
        """
        if encoding_type is not None:
            pulumi.set(__self__, "encoding_type", encoding_type)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if preset_name is not None:
            pulumi.set(__self__, "preset_name", preset_name)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)

    @property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> Optional[pulumi.Input[Union[str, 'LiveEventEncodingType']]]:
        """
        Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
        """
        return pulumi.get(self, "encoding_type")

    @encoding_type.setter
    def encoding_type(self, value: Optional[pulumi.Input[Union[str, 'LiveEventEncodingType']]]):
        pulumi.set(self, "encoding_type", value)

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[pulumi.Input[str]]:
        """
        Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
        """
        return pulumi.get(self, "key_frame_interval")

    @key_frame_interval.setter
    def key_frame_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval", value)

    @property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> Optional[pulumi.Input[str]]:
        """
        The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
        """
        return pulumi.get(self, "preset_name")

    @preset_name.setter
    def preset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preset_name", value)

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[pulumi.Input[Union[str, 'StretchMode']]]:
        """
        Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
        """
        return pulumi.get(self, "stretch_mode")

    @stretch_mode.setter
    def stretch_mode(self, value: Optional[pulumi.Input[Union[str, 'StretchMode']]]):
        pulumi.set(self, "stretch_mode", value)


@pulumi.input_type
class LiveEventEndpointArgs:
    def __init__(__self__, *,
                 protocol: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        The live event endpoint.
        :param pulumi.Input[str] protocol: The endpoint protocol.
        :param pulumi.Input[str] url: The endpoint URL.
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class LiveEventInputAccessControlArgs:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input['IPAccessControlArgs']] = None):
        """
        The IP access control for live event input.
        :param pulumi.Input['IPAccessControlArgs'] ip: The IP access control properties.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input['IPAccessControlArgs']]:
        """
        The IP access control properties.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input['IPAccessControlArgs']]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class LiveEventInputTrackSelectionArgs:
    def __init__(__self__, *,
                 operation: Optional[pulumi.Input[str]] = None,
                 property: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        A track selection condition. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[str] operation: Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[str] property: Property name to select. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[str] value: Property value to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Property value to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def property(self) -> Optional[pulumi.Input[str]]:
        """
        Property name to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property", value)


@pulumi.input_type
class LiveEventInputArgs:
    def __init__(__self__, *,
                 streaming_protocol: pulumi.Input[Union[str, 'LiveEventInputProtocol']],
                 access_control: Optional[pulumi.Input['LiveEventInputAccessControlArgs']] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]] = None,
                 key_frame_interval_duration: Optional[pulumi.Input[str]] = None):
        """
        The live event input.
        :param pulumi.Input[Union[str, 'LiveEventInputProtocol']] streaming_protocol: The input protocol for the live event. This is specified at creation time and cannot be updated.
        :param pulumi.Input['LiveEventInputAccessControlArgs'] access_control: Access control for live event input.
        :param pulumi.Input[str] access_token: A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
        :param pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]] endpoints: The input endpoints for the live event.
        :param pulumi.Input[str] key_frame_interval_duration: ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
        """
        pulumi.set(__self__, "streaming_protocol", streaming_protocol)
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if key_frame_interval_duration is not None:
            pulumi.set(__self__, "key_frame_interval_duration", key_frame_interval_duration)

    @property
    @pulumi.getter(name="streamingProtocol")
    def streaming_protocol(self) -> pulumi.Input[Union[str, 'LiveEventInputProtocol']]:
        """
        The input protocol for the live event. This is specified at creation time and cannot be updated.
        """
        return pulumi.get(self, "streaming_protocol")

    @streaming_protocol.setter
    def streaming_protocol(self, value: pulumi.Input[Union[str, 'LiveEventInputProtocol']]):
        pulumi.set(self, "streaming_protocol", value)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional[pulumi.Input['LiveEventInputAccessControlArgs']]:
        """
        Access control for live event input.
        """
        return pulumi.get(self, "access_control")

    @access_control.setter
    def access_control(self, value: Optional[pulumi.Input['LiveEventInputAccessControlArgs']]):
        pulumi.set(self, "access_control", value)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]]:
        """
        The input endpoints for the live event.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="keyFrameIntervalDuration")
    def key_frame_interval_duration(self) -> Optional[pulumi.Input[str]]:
        """
        ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
        """
        return pulumi.get(self, "key_frame_interval_duration")

    @key_frame_interval_duration.setter
    def key_frame_interval_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_frame_interval_duration", value)


@pulumi.input_type
class LiveEventOutputTranscriptionTrackArgs:
    def __init__(__self__, *,
                 track_name: pulumi.Input[str]):
        """
        Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[str] track_name: The output track name. This property is reserved for future use, any value set on this property will be ignored.
        """
        pulumi.set(__self__, "track_name", track_name)

    @property
    @pulumi.getter(name="trackName")
    def track_name(self) -> pulumi.Input[str]:
        """
        The output track name. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "track_name")

    @track_name.setter
    def track_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "track_name", value)


@pulumi.input_type
class LiveEventPreviewAccessControlArgs:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input['IPAccessControlArgs']] = None):
        """
        The IP access control for the live event preview endpoint.
        :param pulumi.Input['IPAccessControlArgs'] ip: The IP access control properties.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input['IPAccessControlArgs']]:
        """
        The IP access control properties.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input['IPAccessControlArgs']]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class LiveEventPreviewArgs:
    def __init__(__self__, *,
                 access_control: Optional[pulumi.Input['LiveEventPreviewAccessControlArgs']] = None,
                 alternative_media_id: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]] = None,
                 preview_locator: Optional[pulumi.Input[str]] = None,
                 streaming_policy_name: Optional[pulumi.Input[str]] = None):
        """
        Live event preview settings.
        :param pulumi.Input['LiveEventPreviewAccessControlArgs'] access_control: The access control for live event preview.
        :param pulumi.Input[str] alternative_media_id: An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        :param pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]] endpoints: The endpoints for preview. Do not share the preview URL with the live event audience.
        :param pulumi.Input[str] preview_locator: The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
        :param pulumi.Input[str] streaming_policy_name: The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
        """
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if alternative_media_id is not None:
            pulumi.set(__self__, "alternative_media_id", alternative_media_id)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if preview_locator is not None:
            pulumi.set(__self__, "preview_locator", preview_locator)
        if streaming_policy_name is not None:
            pulumi.set(__self__, "streaming_policy_name", streaming_policy_name)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional[pulumi.Input['LiveEventPreviewAccessControlArgs']]:
        """
        The access control for live event preview.
        """
        return pulumi.get(self, "access_control")

    @access_control.setter
    def access_control(self, value: Optional[pulumi.Input['LiveEventPreviewAccessControlArgs']]):
        pulumi.set(self, "access_control", value)

    @property
    @pulumi.getter(name="alternativeMediaId")
    def alternative_media_id(self) -> Optional[pulumi.Input[str]]:
        """
        An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        """
        return pulumi.get(self, "alternative_media_id")

    @alternative_media_id.setter
    def alternative_media_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alternative_media_id", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]]:
        """
        The endpoints for preview. Do not share the preview URL with the live event audience.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="previewLocator")
    def preview_locator(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
        """
        return pulumi.get(self, "preview_locator")

    @preview_locator.setter
    def preview_locator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preview_locator", value)

    @property
    @pulumi.getter(name="streamingPolicyName")
    def streaming_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
        """
        return pulumi.get(self, "streaming_policy_name")

    @streaming_policy_name.setter
    def streaming_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "streaming_policy_name", value)


@pulumi.input_type
class LiveEventTranscriptionArgs:
    def __init__(__self__, *,
                 input_track_selection: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventInputTrackSelectionArgs']]]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 output_transcription_track: Optional[pulumi.Input['LiveEventOutputTranscriptionTrackArgs']] = None):
        """
        Describes the transcription tracks in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[Sequence[pulumi.Input['LiveEventInputTrackSelectionArgs']]] input_track_selection: Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
        :param pulumi.Input[str] language: Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
        :param pulumi.Input['LiveEventOutputTranscriptionTrackArgs'] output_transcription_track: Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        """
        if input_track_selection is not None:
            pulumi.set(__self__, "input_track_selection", input_track_selection)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if output_transcription_track is not None:
            pulumi.set(__self__, "output_transcription_track", output_transcription_track)

    @property
    @pulumi.getter(name="inputTrackSelection")
    def input_track_selection(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventInputTrackSelectionArgs']]]]:
        """
        Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "input_track_selection")

    @input_track_selection.setter
    def input_track_selection(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LiveEventInputTrackSelectionArgs']]]]):
        pulumi.set(self, "input_track_selection", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="outputTranscriptionTrack")
    def output_transcription_track(self) -> Optional[pulumi.Input['LiveEventOutputTranscriptionTrackArgs']]:
        """
        Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "output_transcription_track")

    @output_transcription_track.setter
    def output_transcription_track(self, value: Optional[pulumi.Input['LiveEventOutputTranscriptionTrackArgs']]):
        pulumi.set(self, "output_transcription_track", value)


@pulumi.input_type
class NoEncryptionArgs:
    def __init__(__self__, *,
                 enabled_protocols: Optional[pulumi.Input['EnabledProtocolsArgs']] = None):
        """
        Class for NoEncryption scheme
        :param pulumi.Input['EnabledProtocolsArgs'] enabled_protocols: Representing supported protocols
        """
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional[pulumi.Input['EnabledProtocolsArgs']]:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")

    @enabled_protocols.setter
    def enabled_protocols(self, value: Optional[pulumi.Input['EnabledProtocolsArgs']]):
        pulumi.set(self, "enabled_protocols", value)


@pulumi.input_type
class PresentationTimeRangeArgs:
    def __init__(__self__, *,
                 end_timestamp: Optional[pulumi.Input[float]] = None,
                 force_end_timestamp: Optional[pulumi.Input[bool]] = None,
                 live_backoff_duration: Optional[pulumi.Input[float]] = None,
                 presentation_window_duration: Optional[pulumi.Input[float]] = None,
                 start_timestamp: Optional[pulumi.Input[float]] = None,
                 timescale: Optional[pulumi.Input[float]] = None):
        """
        The presentation time range, this is asset related and not recommended for Account Filter.
        :param pulumi.Input[float] end_timestamp: The absolute end time boundary.
        :param pulumi.Input[bool] force_end_timestamp: The indicator of forcing existing of end time stamp.
        :param pulumi.Input[float] live_backoff_duration: The relative to end right edge.
        :param pulumi.Input[float] presentation_window_duration: The relative to end sliding window.
        :param pulumi.Input[float] start_timestamp: The absolute start time boundary.
        :param pulumi.Input[float] timescale: The time scale of time stamps.
        """
        if end_timestamp is not None:
            pulumi.set(__self__, "end_timestamp", end_timestamp)
        if force_end_timestamp is not None:
            pulumi.set(__self__, "force_end_timestamp", force_end_timestamp)
        if live_backoff_duration is not None:
            pulumi.set(__self__, "live_backoff_duration", live_backoff_duration)
        if presentation_window_duration is not None:
            pulumi.set(__self__, "presentation_window_duration", presentation_window_duration)
        if start_timestamp is not None:
            pulumi.set(__self__, "start_timestamp", start_timestamp)
        if timescale is not None:
            pulumi.set(__self__, "timescale", timescale)

    @property
    @pulumi.getter(name="endTimestamp")
    def end_timestamp(self) -> Optional[pulumi.Input[float]]:
        """
        The absolute end time boundary.
        """
        return pulumi.get(self, "end_timestamp")

    @end_timestamp.setter
    def end_timestamp(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "end_timestamp", value)

    @property
    @pulumi.getter(name="forceEndTimestamp")
    def force_end_timestamp(self) -> Optional[pulumi.Input[bool]]:
        """
        The indicator of forcing existing of end time stamp.
        """
        return pulumi.get(self, "force_end_timestamp")

    @force_end_timestamp.setter
    def force_end_timestamp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_end_timestamp", value)

    @property
    @pulumi.getter(name="liveBackoffDuration")
    def live_backoff_duration(self) -> Optional[pulumi.Input[float]]:
        """
        The relative to end right edge.
        """
        return pulumi.get(self, "live_backoff_duration")

    @live_backoff_duration.setter
    def live_backoff_duration(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "live_backoff_duration", value)

    @property
    @pulumi.getter(name="presentationWindowDuration")
    def presentation_window_duration(self) -> Optional[pulumi.Input[float]]:
        """
        The relative to end sliding window.
        """
        return pulumi.get(self, "presentation_window_duration")

    @presentation_window_duration.setter
    def presentation_window_duration(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "presentation_window_duration", value)

    @property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> Optional[pulumi.Input[float]]:
        """
        The absolute start time boundary.
        """
        return pulumi.get(self, "start_timestamp")

    @start_timestamp.setter
    def start_timestamp(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "start_timestamp", value)

    @property
    @pulumi.getter
    def timescale(self) -> Optional[pulumi.Input[float]]:
        """
        The time scale of time stamps.
        """
        return pulumi.get(self, "timescale")

    @timescale.setter
    def timescale(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "timescale", value)


@pulumi.input_type
class StreamingEndpointAccessControlArgs:
    def __init__(__self__, *,
                 akamai: Optional[pulumi.Input['AkamaiAccessControlArgs']] = None,
                 ip: Optional[pulumi.Input['IPAccessControlArgs']] = None):
        """
        Streaming endpoint access control definition.
        :param pulumi.Input['AkamaiAccessControlArgs'] akamai: The access control of Akamai
        :param pulumi.Input['IPAccessControlArgs'] ip: The IP access control of the streaming endpoint.
        """
        if akamai is not None:
            pulumi.set(__self__, "akamai", akamai)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def akamai(self) -> Optional[pulumi.Input['AkamaiAccessControlArgs']]:
        """
        The access control of Akamai
        """
        return pulumi.get(self, "akamai")

    @akamai.setter
    def akamai(self, value: Optional[pulumi.Input['AkamaiAccessControlArgs']]):
        pulumi.set(self, "akamai", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input['IPAccessControlArgs']]:
        """
        The IP access control of the streaming endpoint.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input['IPAccessControlArgs']]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class StreamingLocatorContentKeyArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 label_reference_in_streaming_policy: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Class for content key in Streaming Locator
        :param pulumi.Input[str] id: ID of Content Key
        :param pulumi.Input[str] label_reference_in_streaming_policy: Label of Content Key as specified in the Streaming Policy
        :param pulumi.Input[str] value: Value of Content Key
        """
        pulumi.set(__self__, "id", id)
        if label_reference_in_streaming_policy is not None:
            pulumi.set(__self__, "label_reference_in_streaming_policy", label_reference_in_streaming_policy)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        ID of Content Key
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="labelReferenceInStreamingPolicy")
    def label_reference_in_streaming_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Label of Content Key as specified in the Streaming Policy
        """
        return pulumi.get(self, "label_reference_in_streaming_policy")

    @label_reference_in_streaming_policy.setter
    def label_reference_in_streaming_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_reference_in_streaming_policy", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of Content Key
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class StreamingPolicyContentKeysArgs:
    def __init__(__self__, *,
                 default_key: Optional[pulumi.Input['DefaultKeyArgs']] = None,
                 key_to_track_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['StreamingPolicyContentKeyArgs']]]] = None):
        """
        Class to specify properties of all content keys in Streaming Policy
        :param pulumi.Input['DefaultKeyArgs'] default_key: Default content key for an encryption scheme
        :param pulumi.Input[Sequence[pulumi.Input['StreamingPolicyContentKeyArgs']]] key_to_track_mappings: Representing tracks needs separate content key
        """
        if default_key is not None:
            pulumi.set(__self__, "default_key", default_key)
        if key_to_track_mappings is not None:
            pulumi.set(__self__, "key_to_track_mappings", key_to_track_mappings)

    @property
    @pulumi.getter(name="defaultKey")
    def default_key(self) -> Optional[pulumi.Input['DefaultKeyArgs']]:
        """
        Default content key for an encryption scheme
        """
        return pulumi.get(self, "default_key")

    @default_key.setter
    def default_key(self, value: Optional[pulumi.Input['DefaultKeyArgs']]):
        pulumi.set(self, "default_key", value)

    @property
    @pulumi.getter(name="keyToTrackMappings")
    def key_to_track_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StreamingPolicyContentKeyArgs']]]]:
        """
        Representing tracks needs separate content key
        """
        return pulumi.get(self, "key_to_track_mappings")

    @key_to_track_mappings.setter
    def key_to_track_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StreamingPolicyContentKeyArgs']]]]):
        pulumi.set(self, "key_to_track_mappings", value)


@pulumi.input_type
class StreamingPolicyContentKeyArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 tracks: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]] = None):
        """
        Class to specify properties of content key
        :param pulumi.Input[str] label: Label can be used to specify Content Key when creating a Streaming Locator
        :param pulumi.Input[str] policy_name: Policy used by Content Key
        :param pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]] tracks: Tracks which use this content key
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if tracks is not None:
            pulumi.set(__self__, "tracks", tracks)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Label can be used to specify Content Key when creating a Streaming Locator
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Policy used by Content Key
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)

    @property
    @pulumi.getter
    def tracks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]:
        """
        Tracks which use this content key
        """
        return pulumi.get(self, "tracks")

    @tracks.setter
    def tracks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrackSelectionArgs']]]]):
        pulumi.set(self, "tracks", value)


@pulumi.input_type
class StreamingPolicyFairPlayConfigurationArgs:
    def __init__(__self__, *,
                 allow_persistent_license: pulumi.Input[bool],
                 custom_license_acquisition_url_template: Optional[pulumi.Input[str]] = None):
        """
        Class to specify configurations of FairPlay in Streaming Policy
        :param pulumi.Input[bool] allow_persistent_license: All license to be persistent or not
        :param pulumi.Input[str] custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        pulumi.set(__self__, "allow_persistent_license", allow_persistent_license)
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)

    @property
    @pulumi.getter(name="allowPersistentLicense")
    def allow_persistent_license(self) -> pulumi.Input[bool]:
        """
        All license to be persistent or not
        """
        return pulumi.get(self, "allow_persistent_license")

    @allow_persistent_license.setter
    def allow_persistent_license(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_persistent_license", value)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")

    @custom_license_acquisition_url_template.setter
    def custom_license_acquisition_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_license_acquisition_url_template", value)


@pulumi.input_type
class StreamingPolicyPlayReadyConfigurationArgs:
    def __init__(__self__, *,
                 custom_license_acquisition_url_template: Optional[pulumi.Input[str]] = None,
                 play_ready_custom_attributes: Optional[pulumi.Input[str]] = None):
        """
        Class to specify configurations of PlayReady in Streaming Policy
        :param pulumi.Input[str] custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        :param pulumi.Input[str] play_ready_custom_attributes: Custom attributes for PlayReady
        """
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)
        if play_ready_custom_attributes is not None:
            pulumi.set(__self__, "play_ready_custom_attributes", play_ready_custom_attributes)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")

    @custom_license_acquisition_url_template.setter
    def custom_license_acquisition_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_license_acquisition_url_template", value)

    @property
    @pulumi.getter(name="playReadyCustomAttributes")
    def play_ready_custom_attributes(self) -> Optional[pulumi.Input[str]]:
        """
        Custom attributes for PlayReady
        """
        return pulumi.get(self, "play_ready_custom_attributes")

    @play_ready_custom_attributes.setter
    def play_ready_custom_attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "play_ready_custom_attributes", value)


@pulumi.input_type
class StreamingPolicyWidevineConfigurationArgs:
    def __init__(__self__, *,
                 custom_license_acquisition_url_template: Optional[pulumi.Input[str]] = None):
        """
        Class to specify configurations of Widevine in Streaming Policy
        :param pulumi.Input[str] custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")

    @custom_license_acquisition_url_template.setter
    def custom_license_acquisition_url_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_license_acquisition_url_template", value)


@pulumi.input_type
class TextTrackArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 file_name: Optional[pulumi.Input[str]] = None,
                 hls_settings: Optional[pulumi.Input['HlsSettingsArgs']] = None,
                 player_visibility: Optional[pulumi.Input[Union[str, 'Visibility']]] = None):
        """
        Represents a text track in an asset. A text track is usually used for sparse data related to the audio or video tracks.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.TextTrack'.
        :param pulumi.Input[str] display_name: The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        :param pulumi.Input[str] file_name: The file name to the source file. This file is located in the storage container of the asset.
        :param pulumi.Input['HlsSettingsArgs'] hls_settings: The HLS specific setting for the text track.
        :param pulumi.Input[Union[str, 'Visibility']] player_visibility: When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.TextTrack')
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if hls_settings is not None:
            pulumi.set(__self__, "hls_settings", hls_settings)
        if player_visibility is not None:
            pulumi.set(__self__, "player_visibility", player_visibility)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.TextTrack'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[str]]:
        """
        The file name to the source file. This file is located in the storage container of the asset.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter(name="hlsSettings")
    def hls_settings(self) -> Optional[pulumi.Input['HlsSettingsArgs']]:
        """
        The HLS specific setting for the text track.
        """
        return pulumi.get(self, "hls_settings")

    @hls_settings.setter
    def hls_settings(self, value: Optional[pulumi.Input['HlsSettingsArgs']]):
        pulumi.set(self, "hls_settings", value)

    @property
    @pulumi.getter(name="playerVisibility")
    def player_visibility(self) -> Optional[pulumi.Input[Union[str, 'Visibility']]]:
        """
        When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
        """
        return pulumi.get(self, "player_visibility")

    @player_visibility.setter
    def player_visibility(self, value: Optional[pulumi.Input[Union[str, 'Visibility']]]):
        pulumi.set(self, "player_visibility", value)


@pulumi.input_type
class TrackPropertyConditionArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input[Union[str, 'TrackPropertyCompareOperation']],
                 property: pulumi.Input[Union[str, 'TrackPropertyType']],
                 value: Optional[pulumi.Input[str]] = None):
        """
        Class to specify one track property condition
        :param pulumi.Input[Union[str, 'TrackPropertyCompareOperation']] operation: Track property condition operation
        :param pulumi.Input[Union[str, 'TrackPropertyType']] property: Track property type
        :param pulumi.Input[str] value: Track property value
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[Union[str, 'TrackPropertyCompareOperation']]:
        """
        Track property condition operation
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[Union[str, 'TrackPropertyCompareOperation']]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Track property value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def property(self) -> pulumi.Input[Union[str, 'TrackPropertyType']]:
        """
        Track property type
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: pulumi.Input[Union[str, 'TrackPropertyType']]):
        pulumi.set(self, "property", value)


@pulumi.input_type
class TrackSelectionArgs:
    def __init__(__self__, *,
                 track_selections: Optional[pulumi.Input[Sequence[pulumi.Input['TrackPropertyConditionArgs']]]] = None):
        """
        Class to select a track
        :param pulumi.Input[Sequence[pulumi.Input['TrackPropertyConditionArgs']]] track_selections: TrackSelections is a track property condition list which can specify track(s)
        """
        if track_selections is not None:
            pulumi.set(__self__, "track_selections", track_selections)

    @property
    @pulumi.getter(name="trackSelections")
    def track_selections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrackPropertyConditionArgs']]]]:
        """
        TrackSelections is a track property condition list which can specify track(s)
        """
        return pulumi.get(self, "track_selections")

    @track_selections.setter
    def track_selections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrackPropertyConditionArgs']]]]):
        pulumi.set(self, "track_selections", value)


@pulumi.input_type
class VideoTrackArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str]):
        """
        Represents a video track in the asset.
        :param pulumi.Input[str] odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoTrack'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoTrack')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoTrack'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


