# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetDomainTopicEventSubscriptionFullUrlResult',
    'AwaitableGetDomainTopicEventSubscriptionFullUrlResult',
    'get_domain_topic_event_subscription_full_url',
    'get_domain_topic_event_subscription_full_url_output',
]

@pulumi.output_type
class GetDomainTopicEventSubscriptionFullUrlResult:
    """
    Full endpoint url of an event subscription
    """
    def __init__(__self__, endpoint_url=None):
        if endpoint_url and not isinstance(endpoint_url, str):
            raise TypeError("Expected argument 'endpoint_url' to be a str")
        pulumi.set(__self__, "endpoint_url", endpoint_url)

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[str]:
        """
        The URL that represents the endpoint of the destination of an event subscription.
        """
        return pulumi.get(self, "endpoint_url")


class AwaitableGetDomainTopicEventSubscriptionFullUrlResult(GetDomainTopicEventSubscriptionFullUrlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainTopicEventSubscriptionFullUrlResult(
            endpoint_url=self.endpoint_url)


def get_domain_topic_event_subscription_full_url(domain_name: Optional[str] = None,
                                                 event_subscription_name: Optional[str] = None,
                                                 resource_group_name: Optional[str] = None,
                                                 topic_name: Optional[str] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainTopicEventSubscriptionFullUrlResult:
    """
    Full endpoint url of an event subscription


    :param str domain_name: Name of the top level domain.
    :param str event_subscription_name: Name of the event subscription.
    :param str resource_group_name: The name of the resource group within the user's subscription.
    :param str topic_name: Name of the domain topic.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    __args__['eventSubscriptionName'] = event_subscription_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['topicName'] = topic_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:eventgrid/v20220615:getDomainTopicEventSubscriptionFullUrl', __args__, opts=opts, typ=GetDomainTopicEventSubscriptionFullUrlResult).value

    return AwaitableGetDomainTopicEventSubscriptionFullUrlResult(
        endpoint_url=__ret__.endpoint_url)


@_utilities.lift_output_func(get_domain_topic_event_subscription_full_url)
def get_domain_topic_event_subscription_full_url_output(domain_name: Optional[pulumi.Input[str]] = None,
                                                        event_subscription_name: Optional[pulumi.Input[str]] = None,
                                                        resource_group_name: Optional[pulumi.Input[str]] = None,
                                                        topic_name: Optional[pulumi.Input[str]] = None,
                                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDomainTopicEventSubscriptionFullUrlResult]:
    """
    Full endpoint url of an event subscription


    :param str domain_name: Name of the top level domain.
    :param str event_subscription_name: Name of the event subscription.
    :param str resource_group_name: The name of the resource group within the user's subscription.
    :param str topic_name: Name of the domain topic.
    """
    ...
