# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AvroSerializationResponse',
    'AzureDataLakeStoreOutputDataSourceResponse',
    'AzureMachineLearningWebServiceFunctionBindingResponse',
    'AzureMachineLearningWebServiceInputColumnResponse',
    'AzureMachineLearningWebServiceInputsResponse',
    'AzureMachineLearningWebServiceOutputColumnResponse',
    'AzureSqlDatabaseOutputDataSourceResponse',
    'AzureTableOutputDataSourceResponse',
    'BlobOutputDataSourceResponse',
    'BlobReferenceInputDataSourceResponse',
    'BlobStreamInputDataSourceResponse',
    'ClusterJobResponse',
    'ClusterPropertiesResponse',
    'ClusterSkuResponse',
    'CsvSerializationResponse',
    'DiagnosticConditionResponse',
    'DiagnosticsResponse',
    'DocumentDbOutputDataSourceResponse',
    'EventHubOutputDataSourceResponse',
    'EventHubStreamInputDataSourceResponse',
    'FunctionInputResponse',
    'FunctionOutputResponse',
    'FunctionResponse',
    'InputResponse',
    'IoTHubStreamInputDataSourceResponse',
    'JavaScriptFunctionBindingResponse',
    'JsonSerializationResponse',
    'OutputResponse',
    'PowerBIOutputDataSourceResponse',
    'PrivateEndpointPropertiesResponse',
    'PrivateLinkConnectionStateResponse',
    'PrivateLinkServiceConnectionResponse',
    'ReferenceInputPropertiesResponse',
    'ScalarFunctionPropertiesResponse',
    'ServiceBusQueueOutputDataSourceResponse',
    'ServiceBusTopicOutputDataSourceResponse',
    'SkuResponse',
    'StorageAccountResponse',
    'StreamInputPropertiesResponse',
    'TransformationResponse',
]

@pulumi.output_type
class AvroSerializationResponse(dict):
    """
    Describes how data from an input is serialized or how data is serialized when written to an output in Avro format.
    """
    def __init__(__self__, *,
                 type: str):
        """
        Describes how data from an input is serialized or how data is serialized when written to an output in Avro format.
        :param str type: Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Avro'.
        """
        pulumi.set(__self__, "type", 'Avro')

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Avro'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AzureDataLakeStoreOutputDataSourceResponse(dict):
    """
    Describes an Azure Data Lake Store output data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "dateFormat":
            suggest = "date_format"
        elif key == "filePathPrefix":
            suggest = "file_path_prefix"
        elif key == "refreshToken":
            suggest = "refresh_token"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "timeFormat":
            suggest = "time_format"
        elif key == "tokenUserDisplayName":
            suggest = "token_user_display_name"
        elif key == "tokenUserPrincipalName":
            suggest = "token_user_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataLakeStoreOutputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataLakeStoreOutputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataLakeStoreOutputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 account_name: Optional[str] = None,
                 date_format: Optional[str] = None,
                 file_path_prefix: Optional[str] = None,
                 refresh_token: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 time_format: Optional[str] = None,
                 token_user_display_name: Optional[str] = None,
                 token_user_principal_name: Optional[str] = None):
        """
        Describes an Azure Data Lake Store output data source.
        :param str type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.DataLake/Accounts'.
        :param str account_name: The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
        :param str date_format: The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
        :param str file_path_prefix: The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
        :param str refresh_token: A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
        :param str tenant_id: The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
        :param str time_format: The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
        :param str token_user_display_name: The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        :param str token_user_principal_name: The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        pulumi.set(__self__, "type", 'Microsoft.DataLake/Accounts')
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if file_path_prefix is not None:
            pulumi.set(__self__, "file_path_prefix", file_path_prefix)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if token_user_display_name is not None:
            pulumi.set(__self__, "token_user_display_name", token_user_display_name)
        if token_user_principal_name is not None:
            pulumi.set(__self__, "token_user_principal_name", token_user_principal_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.DataLake/Accounts'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The name of the Azure Data Lake Store account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[str]:
        """
        The date format. Wherever {date} appears in filePathPrefix, the value of this property is used as the date format instead.
        """
        return pulumi.get(self, "date_format")

    @property
    @pulumi.getter(name="filePathPrefix")
    def file_path_prefix(self) -> Optional[str]:
        """
        The location of the file to which the output should be written to. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "file_path_prefix")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[str]:
        """
        A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "refresh_token")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The tenant id of the user used to obtain the refresh token. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        The time format. Wherever {time} appears in filePathPrefix, the value of this property is used as the time format instead.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="tokenUserDisplayName")
    def token_user_display_name(self) -> Optional[str]:
        """
        The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        return pulumi.get(self, "token_user_display_name")

    @property
    @pulumi.getter(name="tokenUserPrincipalName")
    def token_user_principal_name(self) -> Optional[str]:
        """
        The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        return pulumi.get(self, "token_user_principal_name")


@pulumi.output_type
class AzureMachineLearningWebServiceFunctionBindingResponse(dict):
    """
    The binding to an Azure Machine Learning web service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "batchSize":
            suggest = "batch_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMachineLearningWebServiceFunctionBindingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMachineLearningWebServiceFunctionBindingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMachineLearningWebServiceFunctionBindingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 api_key: Optional[str] = None,
                 batch_size: Optional[int] = None,
                 endpoint: Optional[str] = None,
                 inputs: Optional['outputs.AzureMachineLearningWebServiceInputsResponse'] = None,
                 outputs: Optional[Sequence['outputs.AzureMachineLearningWebServiceOutputColumnResponse']] = None):
        """
        The binding to an Azure Machine Learning web service.
        :param str type: Indicates the function binding type.
               Expected value is 'Microsoft.MachineLearning/WebService'.
        :param str api_key: The API key used to authenticate with Request-Response endpoint.
        :param int batch_size: Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
        :param str endpoint: The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
        :param 'AzureMachineLearningWebServiceInputsResponse' inputs: The inputs for the Azure Machine Learning web service endpoint.
        :param Sequence['AzureMachineLearningWebServiceOutputColumnResponse'] outputs: A list of outputs from the Azure Machine Learning web service endpoint execution.
        """
        pulumi.set(__self__, "type", 'Microsoft.MachineLearning/WebService')
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the function binding type.
        Expected value is 'Microsoft.MachineLearning/WebService'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[str]:
        """
        The API key used to authenticate with Request-Response endpoint.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        """
        Number between 1 and 10000 describing maximum number of rows for every Azure ML RRS execute request. Default is 1000.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        The Request-Response execute endpoint of the Azure Machine Learning web service. Find out more here: https://docs.microsoft.com/en-us/azure/machine-learning/machine-learning-consume-web-services#request-response-service-rrs
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def inputs(self) -> Optional['outputs.AzureMachineLearningWebServiceInputsResponse']:
        """
        The inputs for the Azure Machine Learning web service endpoint.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def outputs(self) -> Optional[Sequence['outputs.AzureMachineLearningWebServiceOutputColumnResponse']]:
        """
        A list of outputs from the Azure Machine Learning web service endpoint execution.
        """
        return pulumi.get(self, "outputs")


@pulumi.output_type
class AzureMachineLearningWebServiceInputColumnResponse(dict):
    """
    Describes an input column for the Azure Machine Learning web service endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "mapTo":
            suggest = "map_to"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMachineLearningWebServiceInputColumnResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMachineLearningWebServiceInputColumnResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMachineLearningWebServiceInputColumnResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: Optional[str] = None,
                 map_to: Optional[int] = None,
                 name: Optional[str] = None):
        """
        Describes an input column for the Azure Machine Learning web service endpoint.
        :param str data_type: The (Azure Machine Learning supported) data type of the input column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
        :param int map_to: The zero based index of the function parameter this input maps to.
        :param str name: The name of the input column.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if map_to is not None:
            pulumi.set(__self__, "map_to", map_to)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The (Azure Machine Learning supported) data type of the input column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="mapTo")
    def map_to(self) -> Optional[int]:
        """
        The zero based index of the function parameter this input maps to.
        """
        return pulumi.get(self, "map_to")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the input column.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AzureMachineLearningWebServiceInputsResponse(dict):
    """
    The inputs for the Azure Machine Learning web service endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnNames":
            suggest = "column_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMachineLearningWebServiceInputsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMachineLearningWebServiceInputsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMachineLearningWebServiceInputsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_names: Optional[Sequence['outputs.AzureMachineLearningWebServiceInputColumnResponse']] = None,
                 name: Optional[str] = None):
        """
        The inputs for the Azure Machine Learning web service endpoint.
        :param Sequence['AzureMachineLearningWebServiceInputColumnResponse'] column_names: A list of input columns for the Azure Machine Learning web service endpoint.
        :param str name: The name of the input. This is the name provided while authoring the endpoint.
        """
        if column_names is not None:
            pulumi.set(__self__, "column_names", column_names)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence['outputs.AzureMachineLearningWebServiceInputColumnResponse']]:
        """
        A list of input columns for the Azure Machine Learning web service endpoint.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the input. This is the name provided while authoring the endpoint.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AzureMachineLearningWebServiceOutputColumnResponse(dict):
    """
    Describes an output column for the Azure Machine Learning web service endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureMachineLearningWebServiceOutputColumnResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureMachineLearningWebServiceOutputColumnResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureMachineLearningWebServiceOutputColumnResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Describes an output column for the Azure Machine Learning web service endpoint.
        :param str data_type: The (Azure Machine Learning supported) data type of the output column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
        :param str name: The name of the output column.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The (Azure Machine Learning supported) data type of the output column. A list of valid  Azure Machine Learning data types are described at https://msdn.microsoft.com/en-us/library/azure/dn905923.aspx .
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the output column.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AzureSqlDatabaseOutputDataSourceResponse(dict):
    """
    Describes an Azure SQL database output data source.
    """
    def __init__(__self__, *,
                 type: str,
                 database: Optional[str] = None,
                 password: Optional[str] = None,
                 server: Optional[str] = None,
                 table: Optional[str] = None,
                 user: Optional[str] = None):
        """
        Describes an Azure SQL database output data source.
        :param str type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Sql/Server/Database'.
        :param str database: The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param str password: The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param str server: The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param str table: The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        :param str user: The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.Sql/Server/Database')
        if database is not None:
            pulumi.set(__self__, "database", database)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Sql/Server/Database'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        The name of the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def server(self) -> Optional[str]:
        """
        The name of the SQL server containing the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def table(self) -> Optional[str]:
        """
        The name of the table in the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        The user name that will be used to connect to the Azure SQL database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class AzureTableOutputDataSourceResponse(dict):
    """
    Describes an Azure Table output data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountKey":
            suggest = "account_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "batchSize":
            suggest = "batch_size"
        elif key == "columnsToRemove":
            suggest = "columns_to_remove"
        elif key == "partitionKey":
            suggest = "partition_key"
        elif key == "rowKey":
            suggest = "row_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureTableOutputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureTableOutputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureTableOutputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 account_key: Optional[str] = None,
                 account_name: Optional[str] = None,
                 batch_size: Optional[int] = None,
                 columns_to_remove: Optional[Sequence[str]] = None,
                 partition_key: Optional[str] = None,
                 row_key: Optional[str] = None,
                 table: Optional[str] = None):
        """
        Describes an Azure Table output data source.
        :param str type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Storage/Table'.
        :param str account_key: The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        :param str account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        :param int batch_size: The number of rows to write to the Azure Table at a time.
        :param Sequence[str] columns_to_remove: If specified, each item in the array is the name of a column to remove (if present) from output event entities.
        :param str partition_key: This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key for the Azure Table. Required on PUT (CreateOrReplace) requests.
        :param str row_key: This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace) requests.
        :param str table: The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.Storage/Table')
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if columns_to_remove is not None:
            pulumi.set(__self__, "columns_to_remove", columns_to_remove)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if row_key is not None:
            pulumi.set(__self__, "row_key", row_key)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Storage/Table'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[str]:
        """
        The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_key")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[int]:
        """
        The number of rows to write to the Azure Table at a time.
        """
        return pulumi.get(self, "batch_size")

    @property
    @pulumi.getter(name="columnsToRemove")
    def columns_to_remove(self) -> Optional[Sequence[str]]:
        """
        If specified, each item in the array is the name of a column to remove (if present) from output event entities.
        """
        return pulumi.get(self, "columns_to_remove")

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[str]:
        """
        This element indicates the name of a column from the SELECT statement in the query that will be used as the partition key for the Azure Table. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "partition_key")

    @property
    @pulumi.getter(name="rowKey")
    def row_key(self) -> Optional[str]:
        """
        This element indicates the name of a column from the SELECT statement in the query that will be used as the row key for the Azure Table. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "row_key")

    @property
    @pulumi.getter
    def table(self) -> Optional[str]:
        """
        The name of the Azure Table. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class BlobOutputDataSourceResponse(dict):
    """
    Describes a blob output data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateFormat":
            suggest = "date_format"
        elif key == "pathPattern":
            suggest = "path_pattern"
        elif key == "storageAccounts":
            suggest = "storage_accounts"
        elif key == "timeFormat":
            suggest = "time_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobOutputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobOutputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobOutputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 container: Optional[str] = None,
                 date_format: Optional[str] = None,
                 path_pattern: Optional[str] = None,
                 storage_accounts: Optional[Sequence['outputs.StorageAccountResponse']] = None,
                 time_format: Optional[str] = None):
        """
        Describes a blob output data source.
        :param str type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Storage/Blob'.
        :param str container: The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        :param str date_format: The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        :param str path_pattern: The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        :param Sequence['StorageAccountResponse'] storage_accounts: A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        :param str time_format: The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        pulumi.set(__self__, "type", 'Microsoft.Storage/Blob')
        if container is not None:
            pulumi.set(__self__, "container", container)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Storage/Blob'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def container(self) -> Optional[str]:
        """
        The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[str]:
        """
        The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        """
        return pulumi.get(self, "date_format")

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional[str]:
        """
        The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        """
        return pulumi.get(self, "path_pattern")

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[Sequence['outputs.StorageAccountResponse']]:
        """
        A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "storage_accounts")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        return pulumi.get(self, "time_format")


@pulumi.output_type
class BlobReferenceInputDataSourceResponse(dict):
    """
    Describes a blob input data source that contains reference data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateFormat":
            suggest = "date_format"
        elif key == "pathPattern":
            suggest = "path_pattern"
        elif key == "storageAccounts":
            suggest = "storage_accounts"
        elif key == "timeFormat":
            suggest = "time_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobReferenceInputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobReferenceInputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobReferenceInputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 container: Optional[str] = None,
                 date_format: Optional[str] = None,
                 path_pattern: Optional[str] = None,
                 storage_accounts: Optional[Sequence['outputs.StorageAccountResponse']] = None,
                 time_format: Optional[str] = None):
        """
        Describes a blob input data source that contains reference data.
        :param str type: Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Storage/Blob'.
        :param str container: The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        :param str date_format: The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        :param str path_pattern: The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        :param Sequence['StorageAccountResponse'] storage_accounts: A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        :param str time_format: The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        pulumi.set(__self__, "type", 'Microsoft.Storage/Blob')
        if container is not None:
            pulumi.set(__self__, "container", container)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Storage/Blob'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def container(self) -> Optional[str]:
        """
        The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[str]:
        """
        The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        """
        return pulumi.get(self, "date_format")

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional[str]:
        """
        The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        """
        return pulumi.get(self, "path_pattern")

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[Sequence['outputs.StorageAccountResponse']]:
        """
        A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "storage_accounts")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        return pulumi.get(self, "time_format")


@pulumi.output_type
class BlobStreamInputDataSourceResponse(dict):
    """
    Describes a blob input data source that contains stream data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateFormat":
            suggest = "date_format"
        elif key == "pathPattern":
            suggest = "path_pattern"
        elif key == "sourcePartitionCount":
            suggest = "source_partition_count"
        elif key == "storageAccounts":
            suggest = "storage_accounts"
        elif key == "timeFormat":
            suggest = "time_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobStreamInputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobStreamInputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobStreamInputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 container: Optional[str] = None,
                 date_format: Optional[str] = None,
                 path_pattern: Optional[str] = None,
                 source_partition_count: Optional[int] = None,
                 storage_accounts: Optional[Sequence['outputs.StorageAccountResponse']] = None,
                 time_format: Optional[str] = None):
        """
        Describes a blob input data source that contains stream data.
        :param str type: Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Storage/Blob'.
        :param str container: The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        :param str date_format: The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        :param str path_pattern: The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        :param int source_partition_count: The partition count of the blob input data source. Range 1 - 1024.
        :param Sequence['StorageAccountResponse'] storage_accounts: A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        :param str time_format: The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        pulumi.set(__self__, "type", 'Microsoft.Storage/Blob')
        if container is not None:
            pulumi.set(__self__, "container", container)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if source_partition_count is not None:
            pulumi.set(__self__, "source_partition_count", source_partition_count)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Storage/Blob'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def container(self) -> Optional[str]:
        """
        The name of a container within the associated Storage account. This container contains either the blob(s) to be read from or written to. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[str]:
        """
        The date format. Wherever {date} appears in pathPattern, the value of this property is used as the date format instead.
        """
        return pulumi.get(self, "date_format")

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional[str]:
        """
        The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a more detailed explanation and example.
        """
        return pulumi.get(self, "path_pattern")

    @property
    @pulumi.getter(name="sourcePartitionCount")
    def source_partition_count(self) -> Optional[int]:
        """
        The partition count of the blob input data source. Range 1 - 1024.
        """
        return pulumi.get(self, "source_partition_count")

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[Sequence['outputs.StorageAccountResponse']]:
        """
        A list of one or more Azure Storage accounts. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "storage_accounts")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        The time format. Wherever {time} appears in pathPattern, the value of this property is used as the time format instead.
        """
        return pulumi.get(self, "time_format")


@pulumi.output_type
class ClusterJobResponse(dict):
    """
    A streaming job.
    """
    def __init__(__self__, *,
                 id: str,
                 job_state: str,
                 streaming_units: int):
        """
        A streaming job.
        :param str id: Resource ID of the streaming job.
        :param str job_state: The current execution state of the streaming job.
        :param int streaming_units: The number of streaming units that are used by the streaming job.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "job_state", job_state)
        pulumi.set(__self__, "streaming_units", streaming_units)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID of the streaming job.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jobState")
    def job_state(self) -> str:
        """
        The current execution state of the streaming job.
        """
        return pulumi.get(self, "job_state")

    @property
    @pulumi.getter(name="streamingUnits")
    def streaming_units(self) -> int:
        """
        The number of streaming units that are used by the streaming job.
        """
        return pulumi.get(self, "streaming_units")


@pulumi.output_type
class ClusterPropertiesResponse(dict):
    """
    The properties associated with a Stream Analytics cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityAllocated":
            suggest = "capacity_allocated"
        elif key == "capacityAssigned":
            suggest = "capacity_assigned"
        elif key == "clusterId":
            suggest = "cluster_id"
        elif key == "createdDate":
            suggest = "created_date"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_allocated: int,
                 capacity_assigned: int,
                 cluster_id: str,
                 created_date: str,
                 provisioning_state: str):
        """
        The properties associated with a Stream Analytics cluster.
        :param int capacity_allocated: Represents the number of streaming units currently being used on the cluster.
        :param int capacity_assigned: Represents the sum of the SUs of all streaming jobs associated with the cluster. If all of the jobs were running, this would be the capacity allocated.
        :param str cluster_id: Unique identifier for the cluster.
        :param str created_date: The date this cluster was created.
        :param str provisioning_state: The status of the cluster provisioning. The three terminal states are: Succeeded, Failed and Canceled
        """
        pulumi.set(__self__, "capacity_allocated", capacity_allocated)
        pulumi.set(__self__, "capacity_assigned", capacity_assigned)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "created_date", created_date)
        pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="capacityAllocated")
    def capacity_allocated(self) -> int:
        """
        Represents the number of streaming units currently being used on the cluster.
        """
        return pulumi.get(self, "capacity_allocated")

    @property
    @pulumi.getter(name="capacityAssigned")
    def capacity_assigned(self) -> int:
        """
        Represents the sum of the SUs of all streaming jobs associated with the cluster. If all of the jobs were running, this would be the capacity allocated.
        """
        return pulumi.get(self, "capacity_assigned")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        Unique identifier for the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> str:
        """
        The date this cluster was created.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The status of the cluster provisioning. The three terminal states are: Succeeded, Failed and Canceled
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class ClusterSkuResponse(dict):
    """
    The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.
    """
    def __init__(__self__, *,
                 capacity: Optional[int] = None,
                 name: Optional[str] = None):
        """
        The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.
        :param int capacity: Denotes the number of streaming units the cluster can support. Valid values for this property are multiples of 36 with a minimum value of 36 and maximum value of 216. Required on PUT (CreateOrUpdate) requests.
        :param str name: Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Denotes the number of streaming units the cluster can support. Valid values for this property are multiples of 36 with a minimum value of 36 and maximum value of 216. Required on PUT (CreateOrUpdate) requests.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the SKU name of the cluster. Required on PUT (CreateOrUpdate) requests.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CsvSerializationResponse(dict):
    """
    Describes how data from an input is serialized or how data is serialized when written to an output in CSV format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldDelimiter":
            suggest = "field_delimiter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CsvSerializationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CsvSerializationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CsvSerializationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 encoding: Optional[str] = None,
                 field_delimiter: Optional[str] = None):
        """
        Describes how data from an input is serialized or how data is serialized when written to an output in CSV format.
        :param str type: Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Csv'.
        :param str encoding: Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
        :param str field_delimiter: Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Csv')
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Csv'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[str]:
        """
        Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "field_delimiter")


@pulumi.output_type
class DiagnosticConditionResponse(dict):
    """
    Condition applicable to the resource, or to the job overall, that warrant customer attention.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 since: str):
        """
        Condition applicable to the resource, or to the job overall, that warrant customer attention.
        :param str code: The opaque diagnostic code.
        :param str message: The human-readable message describing the condition in detail. Localized in the Accept-Language of the client request.
        :param str since: The UTC timestamp of when the condition started. Customers should be able to find a corresponding event in the ops log around this time.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "since", since)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The opaque diagnostic code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The human-readable message describing the condition in detail. Localized in the Accept-Language of the client request.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def since(self) -> str:
        """
        The UTC timestamp of when the condition started. Customers should be able to find a corresponding event in the ops log around this time.
        """
        return pulumi.get(self, "since")


@pulumi.output_type
class DiagnosticsResponse(dict):
    """
    Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
    """
    def __init__(__self__, *,
                 conditions: Sequence['outputs.DiagnosticConditionResponse']):
        """
        Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
        :param Sequence['DiagnosticConditionResponse'] conditions: A collection of zero or more conditions applicable to the resource, or to the job overall, that warrant customer attention.
        """
        pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.DiagnosticConditionResponse']:
        """
        A collection of zero or more conditions applicable to the resource, or to the job overall, that warrant customer attention.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class DocumentDbOutputDataSourceResponse(dict):
    """
    Describes a DocumentDB output data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "accountKey":
            suggest = "account_key"
        elif key == "collectionNamePattern":
            suggest = "collection_name_pattern"
        elif key == "documentId":
            suggest = "document_id"
        elif key == "partitionKey":
            suggest = "partition_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentDbOutputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentDbOutputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentDbOutputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 account_id: Optional[str] = None,
                 account_key: Optional[str] = None,
                 collection_name_pattern: Optional[str] = None,
                 database: Optional[str] = None,
                 document_id: Optional[str] = None,
                 partition_key: Optional[str] = None):
        """
        Describes a DocumentDB output data source.
        :param str type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Storage/DocumentDB'.
        :param str account_id: The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
        :param str account_key: The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
        :param str collection_name_pattern: The collection name pattern for the collections to be used. The collection name format can be constructed using the optional {partition} token, where partitions start from 0. See the DocumentDB section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required on PUT (CreateOrReplace) requests.
        :param str database: The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
        :param str document_id: The name of the field in output events used to specify the primary key which insert or update operations are based on.
        :param str partition_key: The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern' contains the {partition} token, this property is required to be specified.
        """
        pulumi.set(__self__, "type", 'Microsoft.Storage/DocumentDB')
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if collection_name_pattern is not None:
            pulumi.set(__self__, "collection_name_pattern", collection_name_pattern)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if document_id is not None:
            pulumi.set(__self__, "document_id", document_id)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Storage/DocumentDB'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[str]:
        """
        The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[str]:
        """
        The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_key")

    @property
    @pulumi.getter(name="collectionNamePattern")
    def collection_name_pattern(self) -> Optional[str]:
        """
        The collection name pattern for the collections to be used. The collection name format can be constructed using the optional {partition} token, where partitions start from 0. See the DocumentDB section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "collection_name_pattern")

    @property
    @pulumi.getter
    def database(self) -> Optional[str]:
        """
        The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="documentId")
    def document_id(self) -> Optional[str]:
        """
        The name of the field in output events used to specify the primary key which insert or update operations are based on.
        """
        return pulumi.get(self, "document_id")

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[str]:
        """
        The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern' contains the {partition} token, this property is required to be specified.
        """
        return pulumi.get(self, "partition_key")


@pulumi.output_type
class EventHubOutputDataSourceResponse(dict):
    """
    Describes an Event Hub output data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventHubName":
            suggest = "event_hub_name"
        elif key == "partitionKey":
            suggest = "partition_key"
        elif key == "serviceBusNamespace":
            suggest = "service_bus_namespace"
        elif key == "sharedAccessPolicyKey":
            suggest = "shared_access_policy_key"
        elif key == "sharedAccessPolicyName":
            suggest = "shared_access_policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubOutputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubOutputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubOutputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 event_hub_name: Optional[str] = None,
                 partition_key: Optional[str] = None,
                 service_bus_namespace: Optional[str] = None,
                 shared_access_policy_key: Optional[str] = None,
                 shared_access_policy_name: Optional[str] = None):
        """
        Describes an Event Hub output data source.
        :param str type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.ServiceBus/EventHub'.
        :param str event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :param str partition_key: The key/column that is used to determine to which partition to send event data.
        :param str service_bus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param str shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param str shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.ServiceBus/EventHub')
        if event_hub_name is not None:
            pulumi.set(__self__, "event_hub_name", event_hub_name)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if service_bus_namespace is not None:
            pulumi.set(__self__, "service_bus_namespace", service_bus_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.ServiceBus/EventHub'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="eventHubName")
    def event_hub_name(self) -> Optional[str]:
        """
        The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "event_hub_name")

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[str]:
        """
        The key/column that is used to determine to which partition to send event data.
        """
        return pulumi.get(self, "partition_key")

    @property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> Optional[str]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "service_bus_namespace")

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[str]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[str]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")


@pulumi.output_type
class EventHubStreamInputDataSourceResponse(dict):
    """
    Describes an Event Hub input data source that contains stream data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupName":
            suggest = "consumer_group_name"
        elif key == "eventHubName":
            suggest = "event_hub_name"
        elif key == "serviceBusNamespace":
            suggest = "service_bus_namespace"
        elif key == "sharedAccessPolicyKey":
            suggest = "shared_access_policy_key"
        elif key == "sharedAccessPolicyName":
            suggest = "shared_access_policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubStreamInputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubStreamInputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubStreamInputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 consumer_group_name: Optional[str] = None,
                 event_hub_name: Optional[str] = None,
                 service_bus_namespace: Optional[str] = None,
                 shared_access_policy_key: Optional[str] = None,
                 shared_access_policy_name: Optional[str] = None):
        """
        Describes an Event Hub input data source that contains stream data.
        :param str type: Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.ServiceBus/EventHub'.
        :param str consumer_group_name: The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
        :param str event_hub_name: The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        :param str service_bus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param str shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param str shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.ServiceBus/EventHub')
        if consumer_group_name is not None:
            pulumi.set(__self__, "consumer_group_name", consumer_group_name)
        if event_hub_name is not None:
            pulumi.set(__self__, "event_hub_name", event_hub_name)
        if service_bus_namespace is not None:
            pulumi.set(__self__, "service_bus_namespace", service_bus_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.ServiceBus/EventHub'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="consumerGroupName")
    def consumer_group_name(self) -> Optional[str]:
        """
        The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
        """
        return pulumi.get(self, "consumer_group_name")

    @property
    @pulumi.getter(name="eventHubName")
    def event_hub_name(self) -> Optional[str]:
        """
        The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "event_hub_name")

    @property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> Optional[str]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "service_bus_namespace")

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[str]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[str]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")


@pulumi.output_type
class FunctionInputResponse(dict):
    """
    Describes one input parameter of a function.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"
        elif key == "isConfigurationParameter":
            suggest = "is_configuration_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: Optional[str] = None,
                 is_configuration_parameter: Optional[bool] = None):
        """
        Describes one input parameter of a function.
        :param str data_type: The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
        :param bool is_configuration_parameter: A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if is_configuration_parameter is not None:
            pulumi.set(__self__, "is_configuration_parameter", is_configuration_parameter)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The (Azure Stream Analytics supported) data type of the function input parameter. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="isConfigurationParameter")
    def is_configuration_parameter(self) -> Optional[bool]:
        """
        A flag indicating if the parameter is a configuration parameter. True if this input parameter is expected to be a constant. Default is false.
        """
        return pulumi.get(self, "is_configuration_parameter")


@pulumi.output_type
class FunctionOutputResponse(dict):
    """
    Describes the output of a function.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataType":
            suggest = "data_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_type: Optional[str] = None):
        """
        Describes the output of a function.
        :param str data_type: The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
        """
        return pulumi.get(self, "data_type")


@pulumi.output_type
class FunctionResponse(dict):
    """
    A function object, containing all information associated with the named function. All functions are contained under a streaming job.
    """
    def __init__(__self__, *,
                 id: str,
                 type: str,
                 name: Optional[str] = None,
                 properties: Optional['outputs.ScalarFunctionPropertiesResponse'] = None):
        """
        A function object, containing all information associated with the named function. All functions are contained under a streaming job.
        :param str id: Resource Id
        :param str type: Resource type
        :param str name: Resource name
        :param 'ScalarFunctionPropertiesResponse' properties: The properties that are associated with a function.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.ScalarFunctionPropertiesResponse']:
        """
        The properties that are associated with a function.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class InputResponse(dict):
    """
    An input object, containing all information associated with the named input. All inputs are contained under a streaming job.
    """
    def __init__(__self__, *,
                 id: str,
                 type: str,
                 name: Optional[str] = None,
                 properties: Optional[Any] = None):
        """
        An input object, containing all information associated with the named input. All inputs are contained under a streaming job.
        :param str id: Resource Id
        :param str type: Resource type
        :param str name: Resource name
        :param Union['ReferenceInputPropertiesResponse', 'StreamInputPropertiesResponse'] properties: The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Any]:
        """
        The properties that are associated with an input. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class IoTHubStreamInputDataSourceResponse(dict):
    """
    Describes an IoT Hub input data source that contains stream data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupName":
            suggest = "consumer_group_name"
        elif key == "iotHubNamespace":
            suggest = "iot_hub_namespace"
        elif key == "sharedAccessPolicyKey":
            suggest = "shared_access_policy_key"
        elif key == "sharedAccessPolicyName":
            suggest = "shared_access_policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IoTHubStreamInputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IoTHubStreamInputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IoTHubStreamInputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 consumer_group_name: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 iot_hub_namespace: Optional[str] = None,
                 shared_access_policy_key: Optional[str] = None,
                 shared_access_policy_name: Optional[str] = None):
        """
        Describes an IoT Hub input data source that contains stream data.
        :param str type: Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.Devices/IotHubs'.
        :param str consumer_group_name: The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
        :param str endpoint: The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
        :param str iot_hub_namespace: The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
        :param str shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param str shared_access_policy_name: The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.Devices/IotHubs')
        if consumer_group_name is not None:
            pulumi.set(__self__, "consumer_group_name", consumer_group_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if iot_hub_namespace is not None:
            pulumi.set(__self__, "iot_hub_namespace", iot_hub_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.Devices/IotHubs'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="consumerGroupName")
    def consumer_group_name(self) -> Optional[str]:
        """
        The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
        """
        return pulumi.get(self, "consumer_group_name")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="iotHubNamespace")
    def iot_hub_namespace(self) -> Optional[str]:
        """
        The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "iot_hub_namespace")

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[str]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[str]:
        """
        The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")


@pulumi.output_type
class JavaScriptFunctionBindingResponse(dict):
    """
    The binding to a JavaScript function.
    """
    def __init__(__self__, *,
                 type: str,
                 script: Optional[str] = None):
        """
        The binding to a JavaScript function.
        :param str type: Indicates the function binding type.
               Expected value is 'Microsoft.StreamAnalytics/JavascriptUdf'.
        :param str script: The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
        """
        pulumi.set(__self__, "type", 'Microsoft.StreamAnalytics/JavascriptUdf')
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the function binding type.
        Expected value is 'Microsoft.StreamAnalytics/JavascriptUdf'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def script(self) -> Optional[str]:
        """
        The JavaScript code containing a single function definition. For example: 'function (x, y) { return x + y; }'
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class JsonSerializationResponse(dict):
    """
    Describes how data from an input is serialized or how data is serialized when written to an output in JSON format.
    """
    def __init__(__self__, *,
                 type: str,
                 encoding: Optional[str] = None,
                 format: Optional[str] = None):
        """
        Describes how data from an input is serialized or how data is serialized when written to an output in JSON format.
        :param str type: Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Json'.
        :param str encoding: Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
        :param str format: This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null.
        """
        pulumi.set(__self__, "type", 'Json')
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Json'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[str]:
        """
        Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        This property only applies to JSON serialization of outputs only. It is not applicable to inputs. This property specifies the format of the JSON the output will be written in. The currently supported values are 'lineSeparated' indicating the output will be formatted by having each JSON object separated by a new line and 'array' indicating the output will be formatted as an array of JSON objects. Default value is 'lineSeparated' if left null.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class OutputResponse(dict):
    """
    An output object, containing all information associated with the named output. All outputs are contained under a streaming job.
    """
    def __init__(__self__, *,
                 diagnostics: 'outputs.DiagnosticsResponse',
                 etag: str,
                 id: str,
                 type: str,
                 datasource: Optional[Any] = None,
                 name: Optional[str] = None,
                 serialization: Optional[Any] = None):
        """
        An output object, containing all information associated with the named output. All outputs are contained under a streaming job.
        :param 'DiagnosticsResponse' diagnostics: Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
        :param str etag: The current entity tag for the output. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
        :param str id: Resource Id
        :param str type: Resource type
        :param Union['AzureDataLakeStoreOutputDataSourceResponse', 'AzureSqlDatabaseOutputDataSourceResponse', 'AzureTableOutputDataSourceResponse', 'BlobOutputDataSourceResponse', 'DocumentDbOutputDataSourceResponse', 'EventHubOutputDataSourceResponse', 'PowerBIOutputDataSourceResponse', 'ServiceBusQueueOutputDataSourceResponse', 'ServiceBusTopicOutputDataSourceResponse'] datasource: Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
        :param str name: Resource name
        :param Union['AvroSerializationResponse', 'CsvSerializationResponse', 'JsonSerializationResponse'] serialization: Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "diagnostics", diagnostics)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if datasource is not None:
            pulumi.set(__self__, "datasource", datasource)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if serialization is not None:
            pulumi.set(__self__, "serialization", serialization)

    @property
    @pulumi.getter
    def diagnostics(self) -> 'outputs.DiagnosticsResponse':
        """
        Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
        """
        return pulumi.get(self, "diagnostics")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        The current entity tag for the output. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def datasource(self) -> Optional[Any]:
        """
        Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "datasource")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def serialization(self) -> Optional[Any]:
        """
        Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "serialization")


@pulumi.output_type
class PowerBIOutputDataSourceResponse(dict):
    """
    Describes a Power BI output data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "groupName":
            suggest = "group_name"
        elif key == "refreshToken":
            suggest = "refresh_token"
        elif key == "tokenUserDisplayName":
            suggest = "token_user_display_name"
        elif key == "tokenUserPrincipalName":
            suggest = "token_user_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PowerBIOutputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PowerBIOutputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PowerBIOutputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 dataset: Optional[str] = None,
                 group_id: Optional[str] = None,
                 group_name: Optional[str] = None,
                 refresh_token: Optional[str] = None,
                 table: Optional[str] = None,
                 token_user_display_name: Optional[str] = None,
                 token_user_principal_name: Optional[str] = None):
        """
        Describes a Power BI output data source.
        :param str type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'PowerBI'.
        :param str dataset: The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
        :param str group_id: The ID of the Power BI group.
        :param str group_name: The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
        :param str refresh_token: A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
        :param str table: The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
        :param str token_user_display_name: The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        :param str token_user_principal_name: The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        pulumi.set(__self__, "type", 'PowerBI')
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if token_user_display_name is not None:
            pulumi.set(__self__, "token_user_display_name", token_user_display_name)
        if token_user_principal_name is not None:
            pulumi.set(__self__, "token_user_principal_name", token_user_principal_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'PowerBI'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def dataset(self) -> Optional[str]:
        """
        The name of the Power BI dataset. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        The ID of the Power BI group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[str]:
        """
        The name of the Power BI group. Use this property to help remember which specific Power BI group id was used.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[str]:
        """
        A refresh token that can be used to obtain a valid access token that can then be used to authenticate with the data source. A valid refresh token is currently only obtainable via the Azure Portal. It is recommended to put a dummy string value here when creating the data source and then going to the Azure Portal to authenticate the data source which will update this property with a valid refresh token. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "refresh_token")

    @property
    @pulumi.getter
    def table(self) -> Optional[str]:
        """
        The name of the Power BI table under the specified dataset. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter(name="tokenUserDisplayName")
    def token_user_display_name(self) -> Optional[str]:
        """
        The user display name of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        return pulumi.get(self, "token_user_display_name")

    @property
    @pulumi.getter(name="tokenUserPrincipalName")
    def token_user_principal_name(self) -> Optional[str]:
        """
        The user principal name (UPN) of the user that was used to obtain the refresh token. Use this property to help remember which user was used to obtain the refresh token.
        """
        return pulumi.get(self, "token_user_principal_name")


@pulumi.output_type
class PrivateEndpointPropertiesResponse(dict):
    """
    The properties associated with a private endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdDate":
            suggest = "created_date"
        elif key == "manualPrivateLinkServiceConnections":
            suggest = "manual_private_link_service_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_date: str,
                 manual_private_link_service_connections: Optional[Sequence['outputs.PrivateLinkServiceConnectionResponse']] = None):
        """
        The properties associated with a private endpoint.
        :param str created_date: The date when this private endpoint was created.
        :param Sequence['PrivateLinkServiceConnectionResponse'] manual_private_link_service_connections: A list of connections to the remote resource. Immutable after it is set.
        """
        pulumi.set(__self__, "created_date", created_date)
        if manual_private_link_service_connections is not None:
            pulumi.set(__self__, "manual_private_link_service_connections", manual_private_link_service_connections)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> str:
        """
        The date when this private endpoint was created.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter(name="manualPrivateLinkServiceConnections")
    def manual_private_link_service_connections(self) -> Optional[Sequence['outputs.PrivateLinkServiceConnectionResponse']]:
        """
        A list of connections to the remote resource. Immutable after it is set.
        """
        return pulumi.get(self, "manual_private_link_service_connections")


@pulumi.output_type
class PrivateLinkConnectionStateResponse(dict):
    """
    A collection of read-only information about the state of the connection to the private remote resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: str,
                 status: str):
        """
        A collection of read-only information about the state of the connection to the private remote resource.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the remote resource/service.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the remote resource/service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PrivateLinkServiceConnectionResponse(dict):
    """
    A grouping of information about the connection to the remote resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestMessage":
            suggest = "request_message"
        elif key == "groupIds":
            suggest = "group_ids"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "privateLinkServiceId":
            suggest = "private_link_service_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_message: str,
                 group_ids: Optional[Sequence[str]] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkConnectionStateResponse'] = None,
                 private_link_service_id: Optional[str] = None):
        """
        A grouping of information about the connection to the remote resource.
        :param str request_message: A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
        :param Sequence[str] group_ids: The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
        :param 'PrivateLinkConnectionStateResponse' private_link_service_connection_state: A collection of read-only information about the state of the connection to the private remote resource.
        :param str private_link_service_id: The resource id of the private link service. Required on PUT (CreateOrUpdate) requests.
        """
        pulumi.set(__self__, "request_message", request_message)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        if private_link_service_id is not None:
            pulumi.set(__self__, "private_link_service_id", private_link_service_id)

    @property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> str:
        """
        A message passed to the owner of the remote resource with this connection request. Restricted to 140 chars.
        """
        return pulumi.get(self, "request_message")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[Sequence[str]]:
        """
        The ID(s) of the group(s) obtained from the remote resource that this private endpoint should connect to. Required on PUT (CreateOrUpdate) requests.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkConnectionStateResponse']:
        """
        A collection of read-only information about the state of the connection to the private remote resource.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="privateLinkServiceId")
    def private_link_service_id(self) -> Optional[str]:
        """
        The resource id of the private link service. Required on PUT (CreateOrUpdate) requests.
        """
        return pulumi.get(self, "private_link_service_id")


@pulumi.output_type
class ReferenceInputPropertiesResponse(dict):
    """
    The properties that are associated with an input containing reference data.
    """
    def __init__(__self__, *,
                 diagnostics: 'outputs.DiagnosticsResponse',
                 etag: str,
                 type: str,
                 datasource: Optional['outputs.BlobReferenceInputDataSourceResponse'] = None,
                 serialization: Optional[Any] = None):
        """
        The properties that are associated with an input containing reference data.
        :param 'DiagnosticsResponse' diagnostics: Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
        :param str etag: The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
        :param str type: Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Reference'.
        :param 'BlobReferenceInputDataSourceResponse' datasource: Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
        :param Union['AvroSerializationResponse', 'CsvSerializationResponse', 'JsonSerializationResponse'] serialization: Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "diagnostics", diagnostics)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "type", 'Reference')
        if datasource is not None:
            pulumi.set(__self__, "datasource", datasource)
        if serialization is not None:
            pulumi.set(__self__, "serialization", serialization)

    @property
    @pulumi.getter
    def diagnostics(self) -> 'outputs.DiagnosticsResponse':
        """
        Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
        """
        return pulumi.get(self, "diagnostics")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Reference'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def datasource(self) -> Optional['outputs.BlobReferenceInputDataSourceResponse']:
        """
        Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "datasource")

    @property
    @pulumi.getter
    def serialization(self) -> Optional[Any]:
        """
        Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "serialization")


@pulumi.output_type
class ScalarFunctionPropertiesResponse(dict):
    """
    The properties that are associated with a scalar function.
    """
    def __init__(__self__, *,
                 etag: str,
                 type: str,
                 binding: Optional[Any] = None,
                 inputs: Optional[Sequence['outputs.FunctionInputResponse']] = None,
                 output: Optional['outputs.FunctionOutputResponse'] = None):
        """
        The properties that are associated with a scalar function.
        :param str etag: The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
        :param str type: Indicates the type of function.
               Expected value is 'Scalar'.
        :param Union['AzureMachineLearningWebServiceFunctionBindingResponse', 'JavaScriptFunctionBindingResponse'] binding: The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
        :param Sequence['FunctionInputResponse'] inputs: A list of inputs describing the parameters of the function.
        :param 'FunctionOutputResponse' output: The output of the function.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "type", 'Scalar')
        if binding is not None:
            pulumi.set(__self__, "binding", binding)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if output is not None:
            pulumi.set(__self__, "output", output)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        The current entity tag for the function. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of function.
        Expected value is 'Scalar'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def binding(self) -> Optional[Any]:
        """
        The physical binding of the function. For example, in the Azure Machine Learning web service’s case, this describes the endpoint.
        """
        return pulumi.get(self, "binding")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence['outputs.FunctionInputResponse']]:
        """
        A list of inputs describing the parameters of the function.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def output(self) -> Optional['outputs.FunctionOutputResponse']:
        """
        The output of the function.
        """
        return pulumi.get(self, "output")


@pulumi.output_type
class ServiceBusQueueOutputDataSourceResponse(dict):
    """
    Describes a Service Bus Queue output data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyColumns":
            suggest = "property_columns"
        elif key == "queueName":
            suggest = "queue_name"
        elif key == "serviceBusNamespace":
            suggest = "service_bus_namespace"
        elif key == "sharedAccessPolicyKey":
            suggest = "shared_access_policy_key"
        elif key == "sharedAccessPolicyName":
            suggest = "shared_access_policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBusQueueOutputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBusQueueOutputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBusQueueOutputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 property_columns: Optional[Sequence[str]] = None,
                 queue_name: Optional[str] = None,
                 service_bus_namespace: Optional[str] = None,
                 shared_access_policy_key: Optional[str] = None,
                 shared_access_policy_name: Optional[str] = None):
        """
        Describes a Service Bus Queue output data source.
        :param str type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.ServiceBus/Queue'.
        :param Sequence[str] property_columns: A string array of the names of output columns to be attached to Service Bus messages as custom properties.
        :param str queue_name: The name of the Service Bus Queue. Required on PUT (CreateOrReplace) requests.
        :param str service_bus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param str shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param str shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.ServiceBus/Queue')
        if property_columns is not None:
            pulumi.set(__self__, "property_columns", property_columns)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if service_bus_namespace is not None:
            pulumi.set(__self__, "service_bus_namespace", service_bus_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.ServiceBus/Queue'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="propertyColumns")
    def property_columns(self) -> Optional[Sequence[str]]:
        """
        A string array of the names of output columns to be attached to Service Bus messages as custom properties.
        """
        return pulumi.get(self, "property_columns")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[str]:
        """
        The name of the Service Bus Queue. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> Optional[str]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "service_bus_namespace")

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[str]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[str]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")


@pulumi.output_type
class ServiceBusTopicOutputDataSourceResponse(dict):
    """
    Describes a Service Bus Topic output data source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyColumns":
            suggest = "property_columns"
        elif key == "serviceBusNamespace":
            suggest = "service_bus_namespace"
        elif key == "sharedAccessPolicyKey":
            suggest = "shared_access_policy_key"
        elif key == "sharedAccessPolicyName":
            suggest = "shared_access_policy_name"
        elif key == "topicName":
            suggest = "topic_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBusTopicOutputDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBusTopicOutputDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBusTopicOutputDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 property_columns: Optional[Sequence[str]] = None,
                 service_bus_namespace: Optional[str] = None,
                 shared_access_policy_key: Optional[str] = None,
                 shared_access_policy_name: Optional[str] = None,
                 topic_name: Optional[str] = None):
        """
        Describes a Service Bus Topic output data source.
        :param str type: Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Microsoft.ServiceBus/Topic'.
        :param Sequence[str] property_columns: A string array of the names of output columns to be attached to Service Bus messages as custom properties.
        :param str service_bus_namespace: The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param str shared_access_policy_key: The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        :param str shared_access_policy_name: The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        :param str topic_name: The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "type", 'Microsoft.ServiceBus/Topic')
        if property_columns is not None:
            pulumi.set(__self__, "property_columns", property_columns)
        if service_bus_namespace is not None:
            pulumi.set(__self__, "service_bus_namespace", service_bus_namespace)
        if shared_access_policy_key is not None:
            pulumi.set(__self__, "shared_access_policy_key", shared_access_policy_key)
        if shared_access_policy_name is not None:
            pulumi.set(__self__, "shared_access_policy_name", shared_access_policy_name)
        if topic_name is not None:
            pulumi.set(__self__, "topic_name", topic_name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Microsoft.ServiceBus/Topic'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="propertyColumns")
    def property_columns(self) -> Optional[Sequence[str]]:
        """
        A string array of the names of output columns to be attached to Service Bus messages as custom properties.
        """
        return pulumi.get(self, "property_columns")

    @property
    @pulumi.getter(name="serviceBusNamespace")
    def service_bus_namespace(self) -> Optional[str]:
        """
        The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "service_bus_namespace")

    @property
    @pulumi.getter(name="sharedAccessPolicyKey")
    def shared_access_policy_key(self) -> Optional[str]:
        """
        The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_key")

    @property
    @pulumi.getter(name="sharedAccessPolicyName")
    def shared_access_policy_name(self) -> Optional[str]:
        """
        The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "shared_access_policy_name")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> Optional[str]:
        """
        The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "topic_name")


@pulumi.output_type
class SkuResponse(dict):
    """
    The properties that are associated with a SKU.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        The properties that are associated with a SKU.
        :param str name: The name of the SKU. Required on PUT (CreateOrReplace) requests.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the SKU. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class StorageAccountResponse(dict):
    """
    The properties that are associated with an Azure Storage account
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountKey":
            suggest = "account_key"
        elif key == "accountName":
            suggest = "account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageAccountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageAccountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageAccountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_key: Optional[str] = None,
                 account_name: Optional[str] = None):
        """
        The properties that are associated with an Azure Storage account
        :param str account_key: The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        :param str account_name: The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[str]:
        """
        The account key for the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_key")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The name of the Azure Storage account. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "account_name")


@pulumi.output_type
class StreamInputPropertiesResponse(dict):
    """
    The properties that are associated with an input containing stream data.
    """
    def __init__(__self__, *,
                 diagnostics: 'outputs.DiagnosticsResponse',
                 etag: str,
                 type: str,
                 datasource: Optional[Any] = None,
                 serialization: Optional[Any] = None):
        """
        The properties that are associated with an input containing stream data.
        :param 'DiagnosticsResponse' diagnostics: Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
        :param str etag: The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
        :param str type: Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
               Expected value is 'Stream'.
        :param Union['BlobStreamInputDataSourceResponse', 'EventHubStreamInputDataSourceResponse', 'IoTHubStreamInputDataSourceResponse'] datasource: Describes an input data source that contains stream data. Required on PUT (CreateOrReplace) requests.
        :param Union['AvroSerializationResponse', 'CsvSerializationResponse', 'JsonSerializationResponse'] serialization: Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        """
        pulumi.set(__self__, "diagnostics", diagnostics)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "type", 'Stream')
        if datasource is not None:
            pulumi.set(__self__, "datasource", datasource)
        if serialization is not None:
            pulumi.set(__self__, "serialization", serialization)

    @property
    @pulumi.getter
    def diagnostics(self) -> 'outputs.DiagnosticsResponse':
        """
        Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
        """
        return pulumi.get(self, "diagnostics")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
        Expected value is 'Stream'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def datasource(self) -> Optional[Any]:
        """
        Describes an input data source that contains stream data. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "datasource")

    @property
    @pulumi.getter
    def serialization(self) -> Optional[Any]:
        """
        Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "serialization")


@pulumi.output_type
class TransformationResponse(dict):
    """
    A transformation object, containing all information associated with the named transformation. All transformations are contained under a streaming job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamingUnits":
            suggest = "streaming_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etag: str,
                 id: str,
                 type: str,
                 name: Optional[str] = None,
                 query: Optional[str] = None,
                 streaming_units: Optional[int] = None):
        """
        A transformation object, containing all information associated with the named transformation. All transformations are contained under a streaming job.
        :param str etag: The current entity tag for the transformation. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
        :param str id: Resource Id
        :param str type: Resource type
        :param str name: Resource name
        :param str query: Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
        :param int streaming_units: Specifies the number of streaming units that the streaming job uses.
        """
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if streaming_units is not None:
            pulumi.set(__self__, "streaming_units", streaming_units)

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        The current entity tag for the transformation. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        Specifies the query that will be run in the streaming job. You can learn more about the Stream Analytics Query Language (SAQL) here: https://msdn.microsoft.com/library/azure/dn834998 . Required on PUT (CreateOrReplace) requests.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="streamingUnits")
    def streaming_units(self) -> Optional[int]:
        """
        Specifies the number of streaming units that the streaming job uses.
        """
        return pulumi.get(self, "streaming_units")


