# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AbsoluteMonthlyScheduleArgs',
    'AgentPoolNetworkProfileArgs',
    'AgentPoolUpgradeSettingsArgs',
    'AgentPoolWindowsProfileArgs',
    'AzureKeyVaultKmsArgs',
    'ContainerServiceLinuxProfileArgs',
    'ContainerServiceNetworkProfileIpvsConfigArgs',
    'ContainerServiceNetworkProfileKubeProxyConfigArgs',
    'ContainerServiceNetworkProfileArgs',
    'ContainerServiceSshConfigurationArgs',
    'ContainerServiceSshPublicKeyArgs',
    'CreationDataArgs',
    'DailyScheduleArgs',
    'DateSpanArgs',
    'ExtendedLocationArgs',
    'GuardrailsProfileArgs',
    'IPTagArgs',
    'KubeletConfigArgs',
    'LinuxOSConfigArgs',
    'MaintenanceWindowArgs',
    'ManagedClusterAADProfileArgs',
    'ManagedClusterAPIServerAccessProfileArgs',
    'ManagedClusterAddonProfileArgs',
    'ManagedClusterAgentPoolProfileArgs',
    'ManagedClusterAutoUpgradeProfileArgs',
    'ManagedClusterAzureMonitorProfileKubeStateMetricsArgs',
    'ManagedClusterAzureMonitorProfileMetricsArgs',
    'ManagedClusterAzureMonitorProfileArgs',
    'ManagedClusterHTTPProxyConfigArgs',
    'ManagedClusterIdentityArgs',
    'ManagedClusterIngressProfileWebAppRoutingArgs',
    'ManagedClusterIngressProfileArgs',
    'ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs',
    'ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs',
    'ManagedClusterLoadBalancerProfileOutboundIPsArgs',
    'ManagedClusterLoadBalancerProfileArgs',
    'ManagedClusterManagedOutboundIPProfileArgs',
    'ManagedClusterNATGatewayProfileArgs',
    'ManagedClusterOIDCIssuerProfileArgs',
    'ManagedClusterPodIdentityExceptionArgs',
    'ManagedClusterPodIdentityProfileArgs',
    'ManagedClusterPodIdentityArgs',
    'ManagedClusterPropertiesAutoScalerProfileArgs',
    'ManagedClusterSKUArgs',
    'ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs',
    'ManagedClusterSecurityProfileDefenderArgs',
    'ManagedClusterSecurityProfileImageCleanerArgs',
    'ManagedClusterSecurityProfileNodeRestrictionArgs',
    'ManagedClusterSecurityProfileWorkloadIdentityArgs',
    'ManagedClusterSecurityProfileArgs',
    'ManagedClusterServicePrincipalProfileArgs',
    'ManagedClusterStorageProfileBlobCSIDriverArgs',
    'ManagedClusterStorageProfileDiskCSIDriverArgs',
    'ManagedClusterStorageProfileFileCSIDriverArgs',
    'ManagedClusterStorageProfileSnapshotControllerArgs',
    'ManagedClusterStorageProfileArgs',
    'ManagedClusterWindowsProfileArgs',
    'ManagedClusterWorkloadAutoScalerProfileKedaArgs',
    'ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscalerArgs',
    'ManagedClusterWorkloadAutoScalerProfileArgs',
    'PortRangeArgs',
    'PowerStateArgs',
    'PrivateEndpointArgs',
    'PrivateLinkResourceArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'RelativeMonthlyScheduleArgs',
    'ResourceReferenceArgs',
    'ScheduleArgs',
    'SysctlConfigArgs',
    'TimeInWeekArgs',
    'TimeSpanArgs',
    'UserAssignedIdentityArgs',
    'WeeklyScheduleArgs',
    'WindowsGmsaProfileArgs',
]

@pulumi.input_type
class AbsoluteMonthlyScheduleArgs:
    def __init__(__self__, *,
                 day_of_month: pulumi.Input[int],
                 interval_months: pulumi.Input[int]):
        """
        For schedules like: 'recur every month on the 15th' or 'recur every 3 months on the 20th'.
        :param pulumi.Input[int] day_of_month: The date of the month.
        :param pulumi.Input[int] interval_months: Specifies the number of months between each set of occurrences.
        """
        pulumi.set(__self__, "day_of_month", day_of_month)
        pulumi.set(__self__, "interval_months", interval_months)

    @property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> pulumi.Input[int]:
        """
        The date of the month.
        """
        return pulumi.get(self, "day_of_month")

    @day_of_month.setter
    def day_of_month(self, value: pulumi.Input[int]):
        pulumi.set(self, "day_of_month", value)

    @property
    @pulumi.getter(name="intervalMonths")
    def interval_months(self) -> pulumi.Input[int]:
        """
        Specifies the number of months between each set of occurrences.
        """
        return pulumi.get(self, "interval_months")

    @interval_months.setter
    def interval_months(self, value: pulumi.Input[int]):
        pulumi.set(self, "interval_months", value)


@pulumi.input_type
class AgentPoolNetworkProfileArgs:
    def __init__(__self__, *,
                 allowed_host_ports: Optional[pulumi.Input[Sequence[pulumi.Input['PortRangeArgs']]]] = None,
                 application_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_public_ip_tags: Optional[pulumi.Input[Sequence[pulumi.Input['IPTagArgs']]]] = None):
        """
        Network settings of an agent pool.
        :param pulumi.Input[Sequence[pulumi.Input['PortRangeArgs']]] allowed_host_ports: The port ranges that are allowed to access. The specified ranges are allowed to overlap.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] application_security_groups: The IDs of the application security groups which agent pool will associate when created.
        :param pulumi.Input[Sequence[pulumi.Input['IPTagArgs']]] node_public_ip_tags: IPTags of instance-level public IPs.
        """
        if allowed_host_ports is not None:
            pulumi.set(__self__, "allowed_host_ports", allowed_host_ports)
        if application_security_groups is not None:
            pulumi.set(__self__, "application_security_groups", application_security_groups)
        if node_public_ip_tags is not None:
            pulumi.set(__self__, "node_public_ip_tags", node_public_ip_tags)

    @property
    @pulumi.getter(name="allowedHostPorts")
    def allowed_host_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortRangeArgs']]]]:
        """
        The port ranges that are allowed to access. The specified ranges are allowed to overlap.
        """
        return pulumi.get(self, "allowed_host_ports")

    @allowed_host_ports.setter
    def allowed_host_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortRangeArgs']]]]):
        pulumi.set(self, "allowed_host_ports", value)

    @property
    @pulumi.getter(name="applicationSecurityGroups")
    def application_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of the application security groups which agent pool will associate when created.
        """
        return pulumi.get(self, "application_security_groups")

    @application_security_groups.setter
    def application_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "application_security_groups", value)

    @property
    @pulumi.getter(name="nodePublicIPTags")
    def node_public_ip_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPTagArgs']]]]:
        """
        IPTags of instance-level public IPs.
        """
        return pulumi.get(self, "node_public_ip_tags")

    @node_public_ip_tags.setter
    def node_public_ip_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPTagArgs']]]]):
        pulumi.set(self, "node_public_ip_tags", value)


@pulumi.input_type
class AgentPoolUpgradeSettingsArgs:
    def __init__(__self__, *,
                 max_surge: Optional[pulumi.Input[str]] = None):
        """
        Settings for upgrading an agentpool
        :param pulumi.Input[str] max_surge: This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is 1. For more information, including best practices, see: https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input[str]]:
        """
        This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is 1. For more information, including best practices, see: https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_surge", value)


@pulumi.input_type
class AgentPoolWindowsProfileArgs:
    def __init__(__self__, *,
                 disable_outbound_nat: Optional[pulumi.Input[bool]] = None):
        """
        The Windows agent pool's specific profile.
        :param pulumi.Input[bool] disable_outbound_nat: The default value is false. Outbound NAT can only be disabled if the cluster outboundType is NAT Gateway and the Windows agent pool does not have node public IP enabled.
        """
        if disable_outbound_nat is not None:
            pulumi.set(__self__, "disable_outbound_nat", disable_outbound_nat)

    @property
    @pulumi.getter(name="disableOutboundNat")
    def disable_outbound_nat(self) -> Optional[pulumi.Input[bool]]:
        """
        The default value is false. Outbound NAT can only be disabled if the cluster outboundType is NAT Gateway and the Windows agent pool does not have node public IP enabled.
        """
        return pulumi.get(self, "disable_outbound_nat")

    @disable_outbound_nat.setter
    def disable_outbound_nat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_outbound_nat", value)


@pulumi.input_type
class AzureKeyVaultKmsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_vault_network_access: Optional[pulumi.Input[Union[str, 'KeyVaultNetworkAccessTypes']]] = None,
                 key_vault_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Azure Key Vault key management service settings for the security profile.
        :param pulumi.Input[bool] enabled: Whether to enable Azure Key Vault key management service. The default is false.
        :param pulumi.Input[str] key_id: Identifier of Azure Key Vault key. See [key identifier format](https://docs.microsoft.com/en-us/azure/key-vault/general/about-keys-secrets-certificates#vault-name-and-object-name) for more details. When Azure Key Vault key management service is enabled, this field is required and must be a valid key identifier. When Azure Key Vault key management service is disabled, leave the field empty.
        :param pulumi.Input[Union[str, 'KeyVaultNetworkAccessTypes']] key_vault_network_access: Network access of key vault. The possible values are `Public` and `Private`. `Public` means the key vault allows public access from all networks. `Private` means the key vault disables public access and enables private link. The default value is `Public`.
        :param pulumi.Input[str] key_vault_resource_id: Resource ID of key vault. When keyVaultNetworkAccess is `Private`, this field is required and must be a valid resource ID. When keyVaultNetworkAccess is `Public`, leave the field empty.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_vault_network_access is None:
            key_vault_network_access = 'Public'
        if key_vault_network_access is not None:
            pulumi.set(__self__, "key_vault_network_access", key_vault_network_access)
        if key_vault_resource_id is not None:
            pulumi.set(__self__, "key_vault_resource_id", key_vault_resource_id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Azure Key Vault key management service. The default is false.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of Azure Key Vault key. See [key identifier format](https://docs.microsoft.com/en-us/azure/key-vault/general/about-keys-secrets-certificates#vault-name-and-object-name) for more details. When Azure Key Vault key management service is enabled, this field is required and must be a valid key identifier. When Azure Key Vault key management service is disabled, leave the field empty.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyVaultNetworkAccess")
    def key_vault_network_access(self) -> Optional[pulumi.Input[Union[str, 'KeyVaultNetworkAccessTypes']]]:
        """
        Network access of key vault. The possible values are `Public` and `Private`. `Public` means the key vault allows public access from all networks. `Private` means the key vault disables public access and enables private link. The default value is `Public`.
        """
        return pulumi.get(self, "key_vault_network_access")

    @key_vault_network_access.setter
    def key_vault_network_access(self, value: Optional[pulumi.Input[Union[str, 'KeyVaultNetworkAccessTypes']]]):
        pulumi.set(self, "key_vault_network_access", value)

    @property
    @pulumi.getter(name="keyVaultResourceId")
    def key_vault_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of key vault. When keyVaultNetworkAccess is `Private`, this field is required and must be a valid resource ID. When keyVaultNetworkAccess is `Public`, leave the field empty.
        """
        return pulumi.get(self, "key_vault_resource_id")

    @key_vault_resource_id.setter
    def key_vault_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_resource_id", value)


@pulumi.input_type
class ContainerServiceLinuxProfileArgs:
    def __init__(__self__, *,
                 admin_username: pulumi.Input[str],
                 ssh: pulumi.Input['ContainerServiceSshConfigurationArgs']):
        """
        Profile for Linux VMs in the container service cluster.
        :param pulumi.Input[str] admin_username: The administrator username to use for Linux VMs.
        :param pulumi.Input['ContainerServiceSshConfigurationArgs'] ssh: The SSH configuration for Linux-based VMs running on Azure.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Input[str]:
        """
        The administrator username to use for Linux VMs.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter
    def ssh(self) -> pulumi.Input['ContainerServiceSshConfigurationArgs']:
        """
        The SSH configuration for Linux-based VMs running on Azure.
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: pulumi.Input['ContainerServiceSshConfigurationArgs']):
        pulumi.set(self, "ssh", value)


@pulumi.input_type
class ContainerServiceNetworkProfileIpvsConfigArgs:
    def __init__(__self__, *,
                 scheduler: Optional[pulumi.Input[Union[str, 'IpvsScheduler']]] = None,
                 tcp_fin_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 tcp_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 udp_timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        Holds configuration customizations for IPVS. May only be specified if 'mode' is set to 'IPVS'.
        :param pulumi.Input[Union[str, 'IpvsScheduler']] scheduler: IPVS scheduler, for more information please see http://www.linuxvirtualserver.org/docs/scheduling.html.
        :param pulumi.Input[int] tcp_fin_timeout_seconds: The timeout value used for IPVS TCP sessions after receiving a FIN in seconds. Must be a positive integer value.
        :param pulumi.Input[int] tcp_timeout_seconds: The timeout value used for idle IPVS TCP sessions in seconds. Must be a positive integer value.
        :param pulumi.Input[int] udp_timeout_seconds: The timeout value used for IPVS UDP packets in seconds. Must be a positive integer value.
        """
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if tcp_fin_timeout_seconds is not None:
            pulumi.set(__self__, "tcp_fin_timeout_seconds", tcp_fin_timeout_seconds)
        if tcp_timeout_seconds is not None:
            pulumi.set(__self__, "tcp_timeout_seconds", tcp_timeout_seconds)
        if udp_timeout_seconds is not None:
            pulumi.set(__self__, "udp_timeout_seconds", udp_timeout_seconds)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[Union[str, 'IpvsScheduler']]]:
        """
        IPVS scheduler, for more information please see http://www.linuxvirtualserver.org/docs/scheduling.html.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[Union[str, 'IpvsScheduler']]]):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter(name="tcpFinTimeoutSeconds")
    def tcp_fin_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout value used for IPVS TCP sessions after receiving a FIN in seconds. Must be a positive integer value.
        """
        return pulumi.get(self, "tcp_fin_timeout_seconds")

    @tcp_fin_timeout_seconds.setter
    def tcp_fin_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_fin_timeout_seconds", value)

    @property
    @pulumi.getter(name="tcpTimeoutSeconds")
    def tcp_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout value used for idle IPVS TCP sessions in seconds. Must be a positive integer value.
        """
        return pulumi.get(self, "tcp_timeout_seconds")

    @tcp_timeout_seconds.setter
    def tcp_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tcp_timeout_seconds", value)

    @property
    @pulumi.getter(name="udpTimeoutSeconds")
    def udp_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout value used for IPVS UDP packets in seconds. Must be a positive integer value.
        """
        return pulumi.get(self, "udp_timeout_seconds")

    @udp_timeout_seconds.setter
    def udp_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "udp_timeout_seconds", value)


@pulumi.input_type
class ContainerServiceNetworkProfileKubeProxyConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 ipvs_config: Optional[pulumi.Input['ContainerServiceNetworkProfileIpvsConfigArgs']] = None,
                 mode: Optional[pulumi.Input[Union[str, 'Mode']]] = None):
        """
        Holds configuration customizations for kube-proxy. Any values not defined will use the kube-proxy defaulting behavior. See https://v<version>.docs.kubernetes.io/docs/reference/command-line-tools-reference/kube-proxy/ where <version> is represented by a <major version>-<minor version> string. Kubernetes version 1.23 would be '1-23'.
        :param pulumi.Input[bool] enabled: Whether to enable on kube-proxy on the cluster (if no 'kubeProxyConfig' exists, kube-proxy is enabled in AKS by default without these customizations).
        :param pulumi.Input['ContainerServiceNetworkProfileIpvsConfigArgs'] ipvs_config: Holds configuration customizations for IPVS. May only be specified if 'mode' is set to 'IPVS'.
        :param pulumi.Input[Union[str, 'Mode']] mode: Specify which proxy mode to use ('IPTABLES' or 'IPVS')
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ipvs_config is not None:
            pulumi.set(__self__, "ipvs_config", ipvs_config)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable on kube-proxy on the cluster (if no 'kubeProxyConfig' exists, kube-proxy is enabled in AKS by default without these customizations).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="ipvsConfig")
    def ipvs_config(self) -> Optional[pulumi.Input['ContainerServiceNetworkProfileIpvsConfigArgs']]:
        """
        Holds configuration customizations for IPVS. May only be specified if 'mode' is set to 'IPVS'.
        """
        return pulumi.get(self, "ipvs_config")

    @ipvs_config.setter
    def ipvs_config(self, value: Optional[pulumi.Input['ContainerServiceNetworkProfileIpvsConfigArgs']]):
        pulumi.set(self, "ipvs_config", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'Mode']]]:
        """
        Specify which proxy mode to use ('IPTABLES' or 'IPVS')
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'Mode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class ContainerServiceNetworkProfileArgs:
    def __init__(__self__, *,
                 dns_service_ip: Optional[pulumi.Input[str]] = None,
                 docker_bridge_cidr: Optional[pulumi.Input[str]] = None,
                 ebpf_dataplane: Optional[pulumi.Input[Union[str, 'EbpfDataplane']]] = None,
                 ip_families: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'IpFamily']]]]] = None,
                 kube_proxy_config: Optional[pulumi.Input['ContainerServiceNetworkProfileKubeProxyConfigArgs']] = None,
                 load_balancer_profile: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileArgs']] = None,
                 load_balancer_sku: Optional[pulumi.Input[Union[str, 'LoadBalancerSku']]] = None,
                 nat_gateway_profile: Optional[pulumi.Input['ManagedClusterNATGatewayProfileArgs']] = None,
                 network_mode: Optional[pulumi.Input[Union[str, 'NetworkMode']]] = None,
                 network_plugin: Optional[pulumi.Input[Union[str, 'NetworkPlugin']]] = None,
                 network_plugin_mode: Optional[pulumi.Input[Union[str, 'NetworkPluginMode']]] = None,
                 network_policy: Optional[pulumi.Input[Union[str, 'NetworkPolicy']]] = None,
                 outbound_type: Optional[pulumi.Input[Union[str, 'OutboundType']]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 pod_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 service_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Profile of network configuration.
        :param pulumi.Input[str] dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        :param pulumi.Input[str] docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :param pulumi.Input[Union[str, 'EbpfDataplane']] ebpf_dataplane: The eBPF dataplane used for building the Kubernetes network.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'IpFamily']]]] ip_families: IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For dual-stack, the expected values are IPv4 and IPv6.
        :param pulumi.Input['ContainerServiceNetworkProfileKubeProxyConfigArgs'] kube_proxy_config: Holds configuration customizations for kube-proxy. Any values not defined will use the kube-proxy defaulting behavior. See https://v<version>.docs.kubernetes.io/docs/reference/command-line-tools-reference/kube-proxy/ where <version> is represented by a <major version>-<minor version> string. Kubernetes version 1.23 would be '1-23'.
        :param pulumi.Input['ManagedClusterLoadBalancerProfileArgs'] load_balancer_profile: Profile of the cluster load balancer.
        :param pulumi.Input[Union[str, 'LoadBalancerSku']] load_balancer_sku: The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs.
        :param pulumi.Input['ManagedClusterNATGatewayProfileArgs'] nat_gateway_profile: Profile of the cluster NAT gateway.
        :param pulumi.Input[Union[str, 'NetworkMode']] network_mode: This cannot be specified if networkPlugin is anything other than 'azure'.
        :param pulumi.Input[Union[str, 'NetworkPlugin']] network_plugin: Network plugin used for building the Kubernetes network.
        :param pulumi.Input[Union[str, 'NetworkPluginMode']] network_plugin_mode: Network plugin mode used for building the Kubernetes network.
        :param pulumi.Input[Union[str, 'NetworkPolicy']] network_policy: Network policy used for building the Kubernetes network.
        :param pulumi.Input[Union[str, 'OutboundType']] outbound_type: This can only be set at cluster creation time and cannot be changed later. For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
        :param pulumi.Input[str] pod_cidr: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pod_cidrs: One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
        :param pulumi.Input[str] service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_cidrs: One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
        """
        if dns_service_ip is None:
            dns_service_ip = '10.0.0.10'
        if dns_service_ip is not None:
            pulumi.set(__self__, "dns_service_ip", dns_service_ip)
        if docker_bridge_cidr is None:
            docker_bridge_cidr = '172.17.0.1/16'
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if ebpf_dataplane is not None:
            pulumi.set(__self__, "ebpf_dataplane", ebpf_dataplane)
        if ip_families is not None:
            pulumi.set(__self__, "ip_families", ip_families)
        if kube_proxy_config is not None:
            pulumi.set(__self__, "kube_proxy_config", kube_proxy_config)
        if load_balancer_profile is not None:
            pulumi.set(__self__, "load_balancer_profile", load_balancer_profile)
        if load_balancer_sku is not None:
            pulumi.set(__self__, "load_balancer_sku", load_balancer_sku)
        if nat_gateway_profile is not None:
            pulumi.set(__self__, "nat_gateway_profile", nat_gateway_profile)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if network_plugin is not None:
            pulumi.set(__self__, "network_plugin", network_plugin)
        if network_plugin_mode is not None:
            pulumi.set(__self__, "network_plugin_mode", network_plugin_mode)
        if network_policy is not None:
            pulumi.set(__self__, "network_policy", network_policy)
        if outbound_type is None:
            outbound_type = 'loadBalancer'
        if outbound_type is not None:
            pulumi.set(__self__, "outbound_type", outbound_type)
        if pod_cidr is None:
            pod_cidr = '10.244.0.0/16'
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if pod_cidrs is not None:
            pulumi.set(__self__, "pod_cidrs", pod_cidrs)
        if service_cidr is None:
            service_cidr = '10.0.0.0/16'
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if service_cidrs is not None:
            pulumi.set(__self__, "service_cidrs", service_cidrs)

    @property
    @pulumi.getter(name="dnsServiceIP")
    def dns_service_ip(self) -> Optional[pulumi.Input[str]]:
        """
        An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        """
        return pulumi.get(self, "dns_service_ip")

    @dns_service_ip.setter
    def dns_service_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_service_ip", value)

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @docker_bridge_cidr.setter
    def docker_bridge_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_bridge_cidr", value)

    @property
    @pulumi.getter(name="ebpfDataplane")
    def ebpf_dataplane(self) -> Optional[pulumi.Input[Union[str, 'EbpfDataplane']]]:
        """
        The eBPF dataplane used for building the Kubernetes network.
        """
        return pulumi.get(self, "ebpf_dataplane")

    @ebpf_dataplane.setter
    def ebpf_dataplane(self, value: Optional[pulumi.Input[Union[str, 'EbpfDataplane']]]):
        pulumi.set(self, "ebpf_dataplane", value)

    @property
    @pulumi.getter(name="ipFamilies")
    def ip_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'IpFamily']]]]]:
        """
        IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For dual-stack, the expected values are IPv4 and IPv6.
        """
        return pulumi.get(self, "ip_families")

    @ip_families.setter
    def ip_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'IpFamily']]]]]):
        pulumi.set(self, "ip_families", value)

    @property
    @pulumi.getter(name="kubeProxyConfig")
    def kube_proxy_config(self) -> Optional[pulumi.Input['ContainerServiceNetworkProfileKubeProxyConfigArgs']]:
        """
        Holds configuration customizations for kube-proxy. Any values not defined will use the kube-proxy defaulting behavior. See https://v<version>.docs.kubernetes.io/docs/reference/command-line-tools-reference/kube-proxy/ where <version> is represented by a <major version>-<minor version> string. Kubernetes version 1.23 would be '1-23'.
        """
        return pulumi.get(self, "kube_proxy_config")

    @kube_proxy_config.setter
    def kube_proxy_config(self, value: Optional[pulumi.Input['ContainerServiceNetworkProfileKubeProxyConfigArgs']]):
        pulumi.set(self, "kube_proxy_config", value)

    @property
    @pulumi.getter(name="loadBalancerProfile")
    def load_balancer_profile(self) -> Optional[pulumi.Input['ManagedClusterLoadBalancerProfileArgs']]:
        """
        Profile of the cluster load balancer.
        """
        return pulumi.get(self, "load_balancer_profile")

    @load_balancer_profile.setter
    def load_balancer_profile(self, value: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileArgs']]):
        pulumi.set(self, "load_balancer_profile", value)

    @property
    @pulumi.getter(name="loadBalancerSku")
    def load_balancer_sku(self) -> Optional[pulumi.Input[Union[str, 'LoadBalancerSku']]]:
        """
        The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs.
        """
        return pulumi.get(self, "load_balancer_sku")

    @load_balancer_sku.setter
    def load_balancer_sku(self, value: Optional[pulumi.Input[Union[str, 'LoadBalancerSku']]]):
        pulumi.set(self, "load_balancer_sku", value)

    @property
    @pulumi.getter(name="natGatewayProfile")
    def nat_gateway_profile(self) -> Optional[pulumi.Input['ManagedClusterNATGatewayProfileArgs']]:
        """
        Profile of the cluster NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_profile")

    @nat_gateway_profile.setter
    def nat_gateway_profile(self, value: Optional[pulumi.Input['ManagedClusterNATGatewayProfileArgs']]):
        pulumi.set(self, "nat_gateway_profile", value)

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[Union[str, 'NetworkMode']]]:
        """
        This cannot be specified if networkPlugin is anything other than 'azure'.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[Union[str, 'NetworkMode']]]):
        pulumi.set(self, "network_mode", value)

    @property
    @pulumi.getter(name="networkPlugin")
    def network_plugin(self) -> Optional[pulumi.Input[Union[str, 'NetworkPlugin']]]:
        """
        Network plugin used for building the Kubernetes network.
        """
        return pulumi.get(self, "network_plugin")

    @network_plugin.setter
    def network_plugin(self, value: Optional[pulumi.Input[Union[str, 'NetworkPlugin']]]):
        pulumi.set(self, "network_plugin", value)

    @property
    @pulumi.getter(name="networkPluginMode")
    def network_plugin_mode(self) -> Optional[pulumi.Input[Union[str, 'NetworkPluginMode']]]:
        """
        Network plugin mode used for building the Kubernetes network.
        """
        return pulumi.get(self, "network_plugin_mode")

    @network_plugin_mode.setter
    def network_plugin_mode(self, value: Optional[pulumi.Input[Union[str, 'NetworkPluginMode']]]):
        pulumi.set(self, "network_plugin_mode", value)

    @property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> Optional[pulumi.Input[Union[str, 'NetworkPolicy']]]:
        """
        Network policy used for building the Kubernetes network.
        """
        return pulumi.get(self, "network_policy")

    @network_policy.setter
    def network_policy(self, value: Optional[pulumi.Input[Union[str, 'NetworkPolicy']]]):
        pulumi.set(self, "network_policy", value)

    @property
    @pulumi.getter(name="outboundType")
    def outbound_type(self) -> Optional[pulumi.Input[Union[str, 'OutboundType']]]:
        """
        This can only be set at cluster creation time and cannot be changed later. For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
        """
        return pulumi.get(self, "outbound_type")

    @outbound_type.setter
    def outbound_type(self, value: Optional[pulumi.Input[Union[str, 'OutboundType']]]):
        pulumi.set(self, "outbound_type", value)

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range from which to assign pod IPs when kubenet is used.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_cidr", value)

    @property
    @pulumi.getter(name="podCidrs")
    def pod_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
        """
        return pulumi.get(self, "pod_cidrs")

    @pod_cidrs.setter
    def pod_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pod_cidrs", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="serviceCidrs")
    def service_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidrs")

    @service_cidrs.setter
    def service_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_cidrs", value)


@pulumi.input_type
class ContainerServiceSshConfigurationArgs:
    def __init__(__self__, *,
                 public_keys: pulumi.Input[Sequence[pulumi.Input['ContainerServiceSshPublicKeyArgs']]]):
        """
        SSH configuration for Linux-based VMs running on Azure.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerServiceSshPublicKeyArgs']]] public_keys: The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
        """
        pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> pulumi.Input[Sequence[pulumi.Input['ContainerServiceSshPublicKeyArgs']]]:
        """
        The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
        """
        return pulumi.get(self, "public_keys")

    @public_keys.setter
    def public_keys(self, value: pulumi.Input[Sequence[pulumi.Input['ContainerServiceSshPublicKeyArgs']]]):
        pulumi.set(self, "public_keys", value)


@pulumi.input_type
class ContainerServiceSshPublicKeyArgs:
    def __init__(__self__, *,
                 key_data: pulumi.Input[str]):
        """
        Contains information about SSH certificate public key data.
        :param pulumi.Input[str] key_data: Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
        """
        pulumi.set(__self__, "key_data", key_data)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> pulumi.Input[str]:
        """
        Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_data", value)


@pulumi.input_type
class CreationDataArgs:
    def __init__(__self__, *,
                 source_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Data used when creating a target resource from a source resource.
        :param pulumi.Input[str] source_resource_id: This is the ARM ID of the source object to be used to create the target object.
        """
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        This is the ARM ID of the source object to be used to create the target object.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)


@pulumi.input_type
class DailyScheduleArgs:
    def __init__(__self__, *,
                 interval_days: pulumi.Input[int]):
        """
        For schedules like: 'recur every day' or 'recur every 3 days'.
        :param pulumi.Input[int] interval_days: Specifies the number of days between each set of occurrences.
        """
        pulumi.set(__self__, "interval_days", interval_days)

    @property
    @pulumi.getter(name="intervalDays")
    def interval_days(self) -> pulumi.Input[int]:
        """
        Specifies the number of days between each set of occurrences.
        """
        return pulumi.get(self, "interval_days")

    @interval_days.setter
    def interval_days(self, value: pulumi.Input[int]):
        pulumi.set(self, "interval_days", value)


@pulumi.input_type
class DateSpanArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[str],
                 start: pulumi.Input[str]):
        """
        For example, between '2022-12-23' and '2023-01-05'.
        :param pulumi.Input[str] end: The end date of the date span.
        :param pulumi.Input[str] start: The start date of the date span.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[str]:
        """
        The end date of the date span.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[str]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        The start date of the date span.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class ExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]] = None):
        """
        The complex type of the extended location.
        :param pulumi.Input[str] name: The name of the extended location.
        :param pulumi.Input[Union[str, 'ExtendedLocationTypes']] type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GuardrailsProfileArgs:
    def __init__(__self__, *,
                 level: pulumi.Input[Union[str, 'Level']],
                 version: pulumi.Input[str],
                 excluded_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The Guardrails profile.
        :param pulumi.Input[Union[str, 'Level']] level: The guardrails level to be used. By default, Guardrails is enabled for all namespaces except those that AKS excludes via systemExcludedNamespaces
        :param pulumi.Input[str] version: The version of constraints to use
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_namespaces: List of namespaces excluded from guardrails checks
        """
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "version", version)
        if excluded_namespaces is not None:
            pulumi.set(__self__, "excluded_namespaces", excluded_namespaces)

    @property
    @pulumi.getter
    def level(self) -> pulumi.Input[Union[str, 'Level']]:
        """
        The guardrails level to be used. By default, Guardrails is enabled for all namespaces except those that AKS excludes via systemExcludedNamespaces
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: pulumi.Input[Union[str, 'Level']]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        The version of constraints to use
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="excludedNamespaces")
    def excluded_namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of namespaces excluded from guardrails checks
        """
        return pulumi.get(self, "excluded_namespaces")

    @excluded_namespaces.setter
    def excluded_namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_namespaces", value)


@pulumi.input_type
class IPTagArgs:
    def __init__(__self__, *,
                 ip_tag_type: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        Contains the IPTag associated with the object.
        :param pulumi.Input[str] ip_tag_type: The IP tag type. Example: RoutingPreference.
        :param pulumi.Input[str] tag: The value of the IP tag associated with the public IP. Example: Internet.
        """
        if ip_tag_type is not None:
            pulumi.set(__self__, "ip_tag_type", ip_tag_type)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="ipTagType")
    def ip_tag_type(self) -> Optional[pulumi.Input[str]]:
        """
        The IP tag type. Example: RoutingPreference.
        """
        return pulumi.get(self, "ip_tag_type")

    @ip_tag_type.setter
    def ip_tag_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_tag_type", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the IP tag associated with the public IP. Example: Internet.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class KubeletConfigArgs:
    def __init__(__self__, *,
                 allowed_unsafe_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_log_max_files: Optional[pulumi.Input[int]] = None,
                 container_log_max_size_mb: Optional[pulumi.Input[int]] = None,
                 cpu_cfs_quota: Optional[pulumi.Input[bool]] = None,
                 cpu_cfs_quota_period: Optional[pulumi.Input[str]] = None,
                 cpu_manager_policy: Optional[pulumi.Input[str]] = None,
                 fail_swap_on: Optional[pulumi.Input[bool]] = None,
                 image_gc_high_threshold: Optional[pulumi.Input[int]] = None,
                 image_gc_low_threshold: Optional[pulumi.Input[int]] = None,
                 pod_max_pids: Optional[pulumi.Input[int]] = None,
                 topology_manager_policy: Optional[pulumi.Input[str]] = None):
        """
        See [AKS custom node configuration](https://docs.microsoft.com/azure/aks/custom-node-configuration) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_unsafe_sysctls: Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
        :param pulumi.Input[int] container_log_max_files: The maximum number of container log files that can be present for a container. The number must be ≥ 2.
        :param pulumi.Input[int] container_log_max_size_mb: The maximum size (e.g. 10Mi) of container log file before it is rotated.
        :param pulumi.Input[bool] cpu_cfs_quota: The default is true.
        :param pulumi.Input[str] cpu_cfs_quota_period: The default is '100ms.' Valid values are a sequence of decimal numbers with an optional fraction and a unit suffix. For example: '300ms', '2h45m'. Supported units are 'ns', 'us', 'ms', 's', 'm', and 'h'.
        :param pulumi.Input[str] cpu_manager_policy: The default is 'none'. See [Kubernetes CPU management policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies) for more information. Allowed values are 'none' and 'static'.
        :param pulumi.Input[bool] fail_swap_on: If set to true it will make the Kubelet fail to start if swap is enabled on the node.
        :param pulumi.Input[int] image_gc_high_threshold: To disable image garbage collection, set to 100. The default is 85%
        :param pulumi.Input[int] image_gc_low_threshold: This cannot be set higher than imageGcHighThreshold. The default is 80%
        :param pulumi.Input[int] pod_max_pids: The maximum number of processes per pod.
        :param pulumi.Input[str] topology_manager_policy: For more information see [Kubernetes Topology Manager](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager). The default is 'none'. Allowed values are 'none', 'best-effort', 'restricted', and 'single-numa-node'.
        """
        if allowed_unsafe_sysctls is not None:
            pulumi.set(__self__, "allowed_unsafe_sysctls", allowed_unsafe_sysctls)
        if container_log_max_files is not None:
            pulumi.set(__self__, "container_log_max_files", container_log_max_files)
        if container_log_max_size_mb is not None:
            pulumi.set(__self__, "container_log_max_size_mb", container_log_max_size_mb)
        if cpu_cfs_quota is not None:
            pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        if cpu_cfs_quota_period is not None:
            pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)
        if cpu_manager_policy is not None:
            pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)
        if fail_swap_on is not None:
            pulumi.set(__self__, "fail_swap_on", fail_swap_on)
        if image_gc_high_threshold is not None:
            pulumi.set(__self__, "image_gc_high_threshold", image_gc_high_threshold)
        if image_gc_low_threshold is not None:
            pulumi.set(__self__, "image_gc_low_threshold", image_gc_low_threshold)
        if pod_max_pids is not None:
            pulumi.set(__self__, "pod_max_pids", pod_max_pids)
        if topology_manager_policy is not None:
            pulumi.set(__self__, "topology_manager_policy", topology_manager_policy)

    @property
    @pulumi.getter(name="allowedUnsafeSysctls")
    def allowed_unsafe_sysctls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
        """
        return pulumi.get(self, "allowed_unsafe_sysctls")

    @allowed_unsafe_sysctls.setter
    def allowed_unsafe_sysctls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_unsafe_sysctls", value)

    @property
    @pulumi.getter(name="containerLogMaxFiles")
    def container_log_max_files(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of container log files that can be present for a container. The number must be ≥ 2.
        """
        return pulumi.get(self, "container_log_max_files")

    @container_log_max_files.setter
    def container_log_max_files(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_log_max_files", value)

    @property
    @pulumi.getter(name="containerLogMaxSizeMB")
    def container_log_max_size_mb(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size (e.g. 10Mi) of container log file before it is rotated.
        """
        return pulumi.get(self, "container_log_max_size_mb")

    @container_log_max_size_mb.setter
    def container_log_max_size_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_log_max_size_mb", value)

    @property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> Optional[pulumi.Input[bool]]:
        """
        The default is true.
        """
        return pulumi.get(self, "cpu_cfs_quota")

    @cpu_cfs_quota.setter
    def cpu_cfs_quota(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cpu_cfs_quota", value)

    @property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> Optional[pulumi.Input[str]]:
        """
        The default is '100ms.' Valid values are a sequence of decimal numbers with an optional fraction and a unit suffix. For example: '300ms', '2h45m'. Supported units are 'ns', 'us', 'ms', 's', 'm', and 'h'.
        """
        return pulumi.get(self, "cpu_cfs_quota_period")

    @cpu_cfs_quota_period.setter
    def cpu_cfs_quota_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_cfs_quota_period", value)

    @property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The default is 'none'. See [Kubernetes CPU management policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies) for more information. Allowed values are 'none' and 'static'.
        """
        return pulumi.get(self, "cpu_manager_policy")

    @cpu_manager_policy.setter
    def cpu_manager_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_manager_policy", value)

    @property
    @pulumi.getter(name="failSwapOn")
    def fail_swap_on(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true it will make the Kubelet fail to start if swap is enabled on the node.
        """
        return pulumi.get(self, "fail_swap_on")

    @fail_swap_on.setter
    def fail_swap_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fail_swap_on", value)

    @property
    @pulumi.getter(name="imageGcHighThreshold")
    def image_gc_high_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        To disable image garbage collection, set to 100. The default is 85%
        """
        return pulumi.get(self, "image_gc_high_threshold")

    @image_gc_high_threshold.setter
    def image_gc_high_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "image_gc_high_threshold", value)

    @property
    @pulumi.getter(name="imageGcLowThreshold")
    def image_gc_low_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        This cannot be set higher than imageGcHighThreshold. The default is 80%
        """
        return pulumi.get(self, "image_gc_low_threshold")

    @image_gc_low_threshold.setter
    def image_gc_low_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "image_gc_low_threshold", value)

    @property
    @pulumi.getter(name="podMaxPids")
    def pod_max_pids(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of processes per pod.
        """
        return pulumi.get(self, "pod_max_pids")

    @pod_max_pids.setter
    def pod_max_pids(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pod_max_pids", value)

    @property
    @pulumi.getter(name="topologyManagerPolicy")
    def topology_manager_policy(self) -> Optional[pulumi.Input[str]]:
        """
        For more information see [Kubernetes Topology Manager](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager). The default is 'none'. Allowed values are 'none', 'best-effort', 'restricted', and 'single-numa-node'.
        """
        return pulumi.get(self, "topology_manager_policy")

    @topology_manager_policy.setter
    def topology_manager_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topology_manager_policy", value)


@pulumi.input_type
class LinuxOSConfigArgs:
    def __init__(__self__, *,
                 swap_file_size_mb: Optional[pulumi.Input[int]] = None,
                 sysctls: Optional[pulumi.Input['SysctlConfigArgs']] = None,
                 transparent_huge_page_defrag: Optional[pulumi.Input[str]] = None,
                 transparent_huge_page_enabled: Optional[pulumi.Input[str]] = None):
        """
        See [AKS custom node configuration](https://docs.microsoft.com/azure/aks/custom-node-configuration) for more details.
        :param pulumi.Input[int] swap_file_size_mb: The size in MB of a swap file that will be created on each node.
        :param pulumi.Input['SysctlConfigArgs'] sysctls: Sysctl settings for Linux agent nodes.
        :param pulumi.Input[str] transparent_huge_page_defrag: Valid values are 'always', 'defer', 'defer+madvise', 'madvise' and 'never'. The default is 'madvise'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
        :param pulumi.Input[str] transparent_huge_page_enabled: Valid values are 'always', 'madvise', and 'never'. The default is 'always'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
        """
        if swap_file_size_mb is not None:
            pulumi.set(__self__, "swap_file_size_mb", swap_file_size_mb)
        if sysctls is not None:
            pulumi.set(__self__, "sysctls", sysctls)
        if transparent_huge_page_defrag is not None:
            pulumi.set(__self__, "transparent_huge_page_defrag", transparent_huge_page_defrag)
        if transparent_huge_page_enabled is not None:
            pulumi.set(__self__, "transparent_huge_page_enabled", transparent_huge_page_enabled)

    @property
    @pulumi.getter(name="swapFileSizeMB")
    def swap_file_size_mb(self) -> Optional[pulumi.Input[int]]:
        """
        The size in MB of a swap file that will be created on each node.
        """
        return pulumi.get(self, "swap_file_size_mb")

    @swap_file_size_mb.setter
    def swap_file_size_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "swap_file_size_mb", value)

    @property
    @pulumi.getter
    def sysctls(self) -> Optional[pulumi.Input['SysctlConfigArgs']]:
        """
        Sysctl settings for Linux agent nodes.
        """
        return pulumi.get(self, "sysctls")

    @sysctls.setter
    def sysctls(self, value: Optional[pulumi.Input['SysctlConfigArgs']]):
        pulumi.set(self, "sysctls", value)

    @property
    @pulumi.getter(name="transparentHugePageDefrag")
    def transparent_huge_page_defrag(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are 'always', 'defer', 'defer+madvise', 'madvise' and 'never'. The default is 'madvise'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
        """
        return pulumi.get(self, "transparent_huge_page_defrag")

    @transparent_huge_page_defrag.setter
    def transparent_huge_page_defrag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transparent_huge_page_defrag", value)

    @property
    @pulumi.getter(name="transparentHugePageEnabled")
    def transparent_huge_page_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are 'always', 'madvise', and 'never'. The default is 'always'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
        """
        return pulumi.get(self, "transparent_huge_page_enabled")

    @transparent_huge_page_enabled.setter
    def transparent_huge_page_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transparent_huge_page_enabled", value)


@pulumi.input_type
class MaintenanceWindowArgs:
    def __init__(__self__, *,
                 duration_hours: pulumi.Input[int],
                 schedule: pulumi.Input['ScheduleArgs'],
                 start_time: pulumi.Input[str],
                 not_allowed_dates: Optional[pulumi.Input[Sequence[pulumi.Input['DateSpanArgs']]]] = None,
                 start_date: Optional[pulumi.Input[str]] = None,
                 utc_offset: Optional[pulumi.Input[str]] = None):
        """
        Maintenance window used to configure scheduled auto-upgrade for a Managed Cluster.
        :param pulumi.Input[int] duration_hours: Length of maintenance window range from 4 to 24 hours.
        :param pulumi.Input['ScheduleArgs'] schedule: Recurrence schedule for the maintenance window.
        :param pulumi.Input[str] start_time: The start time of the maintenance window. Accepted values are from '00:00' to '23:59'. 'utcOffset' applies to this field. For example: '02:00' with 'utcOffset: +02:00' means UTC time '00:00'.
        :param pulumi.Input[Sequence[pulumi.Input['DateSpanArgs']]] not_allowed_dates: Date ranges on which upgrade is not allowed. 'utcOffset' applies to this field. For example, with 'utcOffset: +02:00' and 'dateSpan' being '2022-12-23' to '2023-01-03', maintenance will be blocked from '2022-12-22 22:00' to '2023-01-03 22:00' in UTC time.
        :param pulumi.Input[str] start_date: The date the maintenance window activates. If the current date is before this date, the maintenance window is inactive and will not be used for upgrades. If not specified, the maintenance window will be active right away.
        :param pulumi.Input[str] utc_offset: The UTC offset in format +/-HH:mm. For example, '+05:30' for IST and '-07:00' for PST. If not specified, the default is '+00:00'.
        """
        if duration_hours is None:
            duration_hours = 24
        pulumi.set(__self__, "duration_hours", duration_hours)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "start_time", start_time)
        if not_allowed_dates is not None:
            pulumi.set(__self__, "not_allowed_dates", not_allowed_dates)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if utc_offset is not None:
            pulumi.set(__self__, "utc_offset", utc_offset)

    @property
    @pulumi.getter(name="durationHours")
    def duration_hours(self) -> pulumi.Input[int]:
        """
        Length of maintenance window range from 4 to 24 hours.
        """
        return pulumi.get(self, "duration_hours")

    @duration_hours.setter
    def duration_hours(self, value: pulumi.Input[int]):
        pulumi.set(self, "duration_hours", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['ScheduleArgs']:
        """
        Recurrence schedule for the maintenance window.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['ScheduleArgs']):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[str]:
        """
        The start time of the maintenance window. Accepted values are from '00:00' to '23:59'. 'utcOffset' applies to this field. For example: '02:00' with 'utcOffset: +02:00' means UTC time '00:00'.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="notAllowedDates")
    def not_allowed_dates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DateSpanArgs']]]]:
        """
        Date ranges on which upgrade is not allowed. 'utcOffset' applies to this field. For example, with 'utcOffset: +02:00' and 'dateSpan' being '2022-12-23' to '2023-01-03', maintenance will be blocked from '2022-12-22 22:00' to '2023-01-03 22:00' in UTC time.
        """
        return pulumi.get(self, "not_allowed_dates")

    @not_allowed_dates.setter
    def not_allowed_dates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DateSpanArgs']]]]):
        pulumi.set(self, "not_allowed_dates", value)

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[pulumi.Input[str]]:
        """
        The date the maintenance window activates. If the current date is before this date, the maintenance window is inactive and will not be used for upgrades. If not specified, the maintenance window will be active right away.
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_date", value)

    @property
    @pulumi.getter(name="utcOffset")
    def utc_offset(self) -> Optional[pulumi.Input[str]]:
        """
        The UTC offset in format +/-HH:mm. For example, '+05:30' for IST and '-07:00' for PST. If not specified, the default is '+00:00'.
        """
        return pulumi.get(self, "utc_offset")

    @utc_offset.setter
    def utc_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "utc_offset", value)


@pulumi.input_type
class ManagedClusterAADProfileArgs:
    def __init__(__self__, *,
                 admin_group_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_app_id: Optional[pulumi.Input[str]] = None,
                 enable_azure_rbac: Optional[pulumi.Input[bool]] = None,
                 managed: Optional[pulumi.Input[bool]] = None,
                 server_app_id: Optional[pulumi.Input[str]] = None,
                 server_app_secret: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        For more details see [managed AAD on AKS](https://docs.microsoft.com/azure/aks/managed-aad).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_group_object_ids: The list of AAD group object IDs that will have admin role of the cluster.
        :param pulumi.Input[str] client_app_id: The client AAD application ID.
        :param pulumi.Input[bool] enable_azure_rbac: Whether to enable Azure RBAC for Kubernetes authorization.
        :param pulumi.Input[bool] managed: Whether to enable managed AAD.
        :param pulumi.Input[str] server_app_id: The server AAD application ID.
        :param pulumi.Input[str] server_app_secret: The server AAD application secret.
        :param pulumi.Input[str] tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
        """
        if admin_group_object_ids is not None:
            pulumi.set(__self__, "admin_group_object_ids", admin_group_object_ids)
        if client_app_id is not None:
            pulumi.set(__self__, "client_app_id", client_app_id)
        if enable_azure_rbac is not None:
            pulumi.set(__self__, "enable_azure_rbac", enable_azure_rbac)
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if server_app_id is not None:
            pulumi.set(__self__, "server_app_id", server_app_id)
        if server_app_secret is not None:
            pulumi.set(__self__, "server_app_secret", server_app_secret)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="adminGroupObjectIDs")
    def admin_group_object_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of AAD group object IDs that will have admin role of the cluster.
        """
        return pulumi.get(self, "admin_group_object_ids")

    @admin_group_object_ids.setter
    def admin_group_object_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "admin_group_object_ids", value)

    @property
    @pulumi.getter(name="clientAppID")
    def client_app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client AAD application ID.
        """
        return pulumi.get(self, "client_app_id")

    @client_app_id.setter
    def client_app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_app_id", value)

    @property
    @pulumi.getter(name="enableAzureRBAC")
    def enable_azure_rbac(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Azure RBAC for Kubernetes authorization.
        """
        return pulumi.get(self, "enable_azure_rbac")

    @enable_azure_rbac.setter
    def enable_azure_rbac(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_azure_rbac", value)

    @property
    @pulumi.getter
    def managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable managed AAD.
        """
        return pulumi.get(self, "managed")

    @managed.setter
    def managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "managed", value)

    @property
    @pulumi.getter(name="serverAppID")
    def server_app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The server AAD application ID.
        """
        return pulumi.get(self, "server_app_id")

    @server_app_id.setter
    def server_app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_app_id", value)

    @property
    @pulumi.getter(name="serverAppSecret")
    def server_app_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The server AAD application secret.
        """
        return pulumi.get(self, "server_app_secret")

    @server_app_secret.setter
    def server_app_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_app_secret", value)

    @property
    @pulumi.getter(name="tenantID")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class ManagedClusterAPIServerAccessProfileArgs:
    def __init__(__self__, *,
                 authorized_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 disable_run_command: Optional[pulumi.Input[bool]] = None,
                 enable_private_cluster: Optional[pulumi.Input[bool]] = None,
                 enable_private_cluster_public_fqdn: Optional[pulumi.Input[bool]] = None,
                 enable_vnet_integration: Optional[pulumi.Input[bool]] = None,
                 private_dns_zone: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Access profile for managed cluster API server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorized_ip_ranges: IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public IP Per Node, or clusters that are using a Basic Load Balancer. For more information see [API server authorized IP ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
        :param pulumi.Input[bool] disable_run_command: Whether to disable run command for the cluster or not.
        :param pulumi.Input[bool] enable_private_cluster: For more details, see [Creating a private AKS cluster](https://docs.microsoft.com/azure/aks/private-clusters).
        :param pulumi.Input[bool] enable_private_cluster_public_fqdn: Whether to create additional public FQDN for private cluster or not.
        :param pulumi.Input[bool] enable_vnet_integration: Whether to enable apiserver vnet integration for the cluster or not.
        :param pulumi.Input[str] private_dns_zone: The default is System. For more details see [configure private DNS zone](https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone). Allowed values are 'system' and 'none'.
        :param pulumi.Input[str] subnet_id: It is required when: 1. creating a new cluster with BYO Vnet; 2. updating an existing cluster to enable apiserver vnet integration.
        """
        if authorized_ip_ranges is not None:
            pulumi.set(__self__, "authorized_ip_ranges", authorized_ip_ranges)
        if disable_run_command is not None:
            pulumi.set(__self__, "disable_run_command", disable_run_command)
        if enable_private_cluster is not None:
            pulumi.set(__self__, "enable_private_cluster", enable_private_cluster)
        if enable_private_cluster_public_fqdn is not None:
            pulumi.set(__self__, "enable_private_cluster_public_fqdn", enable_private_cluster_public_fqdn)
        if enable_vnet_integration is not None:
            pulumi.set(__self__, "enable_vnet_integration", enable_vnet_integration)
        if private_dns_zone is not None:
            pulumi.set(__self__, "private_dns_zone", private_dns_zone)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="authorizedIPRanges")
    def authorized_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public IP Per Node, or clusters that are using a Basic Load Balancer. For more information see [API server authorized IP ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
        """
        return pulumi.get(self, "authorized_ip_ranges")

    @authorized_ip_ranges.setter
    def authorized_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "authorized_ip_ranges", value)

    @property
    @pulumi.getter(name="disableRunCommand")
    def disable_run_command(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable run command for the cluster or not.
        """
        return pulumi.get(self, "disable_run_command")

    @disable_run_command.setter
    def disable_run_command(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_run_command", value)

    @property
    @pulumi.getter(name="enablePrivateCluster")
    def enable_private_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        For more details, see [Creating a private AKS cluster](https://docs.microsoft.com/azure/aks/private-clusters).
        """
        return pulumi.get(self, "enable_private_cluster")

    @enable_private_cluster.setter
    def enable_private_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_cluster", value)

    @property
    @pulumi.getter(name="enablePrivateClusterPublicFQDN")
    def enable_private_cluster_public_fqdn(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create additional public FQDN for private cluster or not.
        """
        return pulumi.get(self, "enable_private_cluster_public_fqdn")

    @enable_private_cluster_public_fqdn.setter
    def enable_private_cluster_public_fqdn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_cluster_public_fqdn", value)

    @property
    @pulumi.getter(name="enableVnetIntegration")
    def enable_vnet_integration(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable apiserver vnet integration for the cluster or not.
        """
        return pulumi.get(self, "enable_vnet_integration")

    @enable_vnet_integration.setter
    def enable_vnet_integration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vnet_integration", value)

    @property
    @pulumi.getter(name="privateDNSZone")
    def private_dns_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The default is System. For more details see [configure private DNS zone](https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone). Allowed values are 'system' and 'none'.
        """
        return pulumi.get(self, "private_dns_zone")

    @private_dns_zone.setter
    def private_dns_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_dns_zone", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        It is required when: 1. creating a new cluster with BYO Vnet; 2. updating an existing cluster to enable apiserver vnet integration.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class ManagedClusterAddonProfileArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A Kubernetes add-on profile for a managed cluster.
        :param pulumi.Input[bool] enabled: Whether the add-on is enabled or not.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config: Key-value pairs for configuring an add-on.
        """
        pulumi.set(__self__, "enabled", enabled)
        if config is not None:
            pulumi.set(__self__, "config", config)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether the add-on is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value pairs for configuring an add-on.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "config", value)


@pulumi.input_type
class ManagedClusterAgentPoolProfileArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 capacity_reservation_group_id: Optional[pulumi.Input[str]] = None,
                 count: Optional[pulumi.Input[int]] = None,
                 creation_data: Optional[pulumi.Input['CreationDataArgs']] = None,
                 enable_auto_scaling: Optional[pulumi.Input[bool]] = None,
                 enable_custom_ca_trust: Optional[pulumi.Input[bool]] = None,
                 enable_encryption_at_host: Optional[pulumi.Input[bool]] = None,
                 enable_fips: Optional[pulumi.Input[bool]] = None,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 enable_ultra_ssd: Optional[pulumi.Input[bool]] = None,
                 gpu_instance_profile: Optional[pulumi.Input[Union[str, 'GPUInstanceProfile']]] = None,
                 host_group_id: Optional[pulumi.Input[str]] = None,
                 kubelet_config: Optional[pulumi.Input['KubeletConfigArgs']] = None,
                 kubelet_disk_type: Optional[pulumi.Input[Union[str, 'KubeletDiskType']]] = None,
                 linux_os_config: Optional[pulumi.Input['LinuxOSConfigArgs']] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 message_of_the_day: Optional[pulumi.Input[str]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'AgentPoolMode']]] = None,
                 network_profile: Optional[pulumi.Input['AgentPoolNetworkProfileArgs']] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_public_ip_prefix_id: Optional[pulumi.Input[str]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 orchestrator_version: Optional[pulumi.Input[str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 os_disk_type: Optional[pulumi.Input[Union[str, 'OSDiskType']]] = None,
                 os_sku: Optional[pulumi.Input[Union[str, 'OSSKU']]] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OSType']]] = None,
                 pod_subnet_id: Optional[pulumi.Input[str]] = None,
                 power_state: Optional[pulumi.Input['PowerStateArgs']] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[str]] = None,
                 scale_down_mode: Optional[pulumi.Input[Union[str, 'ScaleDownMode']]] = None,
                 scale_set_eviction_policy: Optional[pulumi.Input[Union[str, 'ScaleSetEvictionPolicy']]] = None,
                 scale_set_priority: Optional[pulumi.Input[Union[str, 'ScaleSetPriority']]] = None,
                 spot_max_price: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[Union[str, 'AgentPoolType']]] = None,
                 upgrade_settings: Optional[pulumi.Input['AgentPoolUpgradeSettingsArgs']] = None,
                 vm_size: Optional[pulumi.Input[str]] = None,
                 vnet_subnet_id: Optional[pulumi.Input[str]] = None,
                 windows_profile: Optional[pulumi.Input['AgentPoolWindowsProfileArgs']] = None,
                 workload_runtime: Optional[pulumi.Input[Union[str, 'WorkloadRuntime']]] = None):
        """
        Profile for the container service agent pool.
        :param pulumi.Input[str] name: Windows agent pool names must be 6 characters or less.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
        :param pulumi.Input[str] capacity_reservation_group_id: AKS will associate the specified agent pool with the Capacity Reservation Group.
        :param pulumi.Input[int] count: Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1.
        :param pulumi.Input['CreationDataArgs'] creation_data: CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
        :param pulumi.Input[bool] enable_auto_scaling: Whether to enable auto-scaler
        :param pulumi.Input[bool] enable_custom_ca_trust: When set to true, AKS adds a label to the node indicating that the feature is enabled and deploys a daemonset along with host services to sync custom certificate authorities from user-provided list of base64 encoded certificates into node trust stores. Defaults to false.
        :param pulumi.Input[bool] enable_encryption_at_host: This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
        :param pulumi.Input[bool] enable_fips: See [Add a FIPS-enabled node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more details.
        :param pulumi.Input[bool] enable_node_public_ip: Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools). The default is false.
        :param pulumi.Input[bool] enable_ultra_ssd: Whether to enable UltraSSD
        :param pulumi.Input[Union[str, 'GPUInstanceProfile']] gpu_instance_profile: GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
        :param pulumi.Input[str] host_group_id: This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}. For more information see [Azure dedicated hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
        :param pulumi.Input['KubeletConfigArgs'] kubelet_config: The Kubelet configuration on the agent pool nodes.
        :param pulumi.Input[Union[str, 'KubeletDiskType']] kubelet_disk_type: Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
        :param pulumi.Input['LinuxOSConfigArgs'] linux_os_config: The OS configuration of Linux agent nodes.
        :param pulumi.Input[int] max_count: The maximum number of nodes for auto-scaling
        :param pulumi.Input[int] max_pods: The maximum number of pods that can run on a node.
        :param pulumi.Input[str] message_of_the_day: A base64-encoded string which will be written to /etc/motd after decoding. This allows customization of the message of the day for Linux nodes. It must not be specified for Windows nodes. It must be a static string (i.e., will be printed raw and not be executed as a script).
        :param pulumi.Input[int] min_count: The minimum number of nodes for auto-scaling
        :param pulumi.Input[Union[str, 'AgentPoolMode']] mode: A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
        :param pulumi.Input['AgentPoolNetworkProfileArgs'] network_profile: Network-related settings of an agent pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_labels: The node labels to be persisted across all nodes in agent pool.
        :param pulumi.Input[str] node_public_ip_prefix_id: This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_taints: The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
        :param pulumi.Input[str] orchestrator_version: Both patch version <major.minor.patch> and <major.minor> are supported. When <major.minor> is specified, the latest supported patch version is chosen automatically. Updating the agent pool with the same <major.minor> once it has been created will not trigger an upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the control plane. The node pool minor version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more information see [upgrading a node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
        :param pulumi.Input[int] os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
        :param pulumi.Input[Union[str, 'OSDiskType']] os_disk_type: The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
        :param pulumi.Input[Union[str, 'OSSKU']] os_sku: Specifies the OS SKU used by the agent pool. If not specified, the default is Ubuntu if OSType=Linux or Windows2019 if OSType=Windows. And the default Windows OSSKU will be changed to Windows2022 after Windows2019 is deprecated.
        :param pulumi.Input[Union[str, 'OSType']] os_type: The operating system type. The default is Linux.
        :param pulumi.Input[str] pod_subnet_id: If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
        :param pulumi.Input['PowerStateArgs'] power_state: When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
        :param pulumi.Input[str] proximity_placement_group_id: The ID for Proximity Placement Group.
        :param pulumi.Input[Union[str, 'ScaleDownMode']] scale_down_mode: This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
        :param pulumi.Input[Union[str, 'ScaleSetEvictionPolicy']] scale_set_eviction_policy: This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
        :param pulumi.Input[Union[str, 'ScaleSetPriority']] scale_set_priority: The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
        :param pulumi.Input[float] spot_max_price: Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags to be persisted on the agent pool virtual machine scale set.
        :param pulumi.Input[Union[str, 'AgentPoolType']] type: The type of Agent Pool.
        :param pulumi.Input['AgentPoolUpgradeSettingsArgs'] upgrade_settings: Settings for upgrading the agentpool
        :param pulumi.Input[str] vm_size: VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions
        :param pulumi.Input[str] vnet_subnet_id: If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
        :param pulumi.Input['AgentPoolWindowsProfileArgs'] windows_profile: The Windows agent pool's specific profile.
        :param pulumi.Input[Union[str, 'WorkloadRuntime']] workload_runtime: Determines the type of workload a node can run.
        """
        pulumi.set(__self__, "name", name)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if capacity_reservation_group_id is not None:
            pulumi.set(__self__, "capacity_reservation_group_id", capacity_reservation_group_id)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if creation_data is not None:
            pulumi.set(__self__, "creation_data", creation_data)
        if enable_auto_scaling is not None:
            pulumi.set(__self__, "enable_auto_scaling", enable_auto_scaling)
        if enable_custom_ca_trust is not None:
            pulumi.set(__self__, "enable_custom_ca_trust", enable_custom_ca_trust)
        if enable_encryption_at_host is not None:
            pulumi.set(__self__, "enable_encryption_at_host", enable_encryption_at_host)
        if enable_fips is not None:
            pulumi.set(__self__, "enable_fips", enable_fips)
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if enable_ultra_ssd is not None:
            pulumi.set(__self__, "enable_ultra_ssd", enable_ultra_ssd)
        if gpu_instance_profile is not None:
            pulumi.set(__self__, "gpu_instance_profile", gpu_instance_profile)
        if host_group_id is not None:
            pulumi.set(__self__, "host_group_id", host_group_id)
        if kubelet_config is not None:
            pulumi.set(__self__, "kubelet_config", kubelet_config)
        if kubelet_disk_type is not None:
            pulumi.set(__self__, "kubelet_disk_type", kubelet_disk_type)
        if linux_os_config is not None:
            pulumi.set(__self__, "linux_os_config", linux_os_config)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if message_of_the_day is not None:
            pulumi.set(__self__, "message_of_the_day", message_of_the_day)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if node_labels is not None:
            pulumi.set(__self__, "node_labels", node_labels)
        if node_public_ip_prefix_id is not None:
            pulumi.set(__self__, "node_public_ip_prefix_id", node_public_ip_prefix_id)
        if node_taints is not None:
            pulumi.set(__self__, "node_taints", node_taints)
        if orchestrator_version is not None:
            pulumi.set(__self__, "orchestrator_version", orchestrator_version)
        if os_disk_size_gb is not None:
            pulumi.set(__self__, "os_disk_size_gb", os_disk_size_gb)
        if os_disk_type is not None:
            pulumi.set(__self__, "os_disk_type", os_disk_type)
        if os_sku is not None:
            pulumi.set(__self__, "os_sku", os_sku)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pod_subnet_id is not None:
            pulumi.set(__self__, "pod_subnet_id", pod_subnet_id)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if scale_down_mode is not None:
            pulumi.set(__self__, "scale_down_mode", scale_down_mode)
        if scale_set_eviction_policy is not None:
            pulumi.set(__self__, "scale_set_eviction_policy", scale_set_eviction_policy)
        if scale_set_priority is not None:
            pulumi.set(__self__, "scale_set_priority", scale_set_priority)
        if spot_max_price is not None:
            pulumi.set(__self__, "spot_max_price", spot_max_price)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if upgrade_settings is not None:
            pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)
        if vnet_subnet_id is not None:
            pulumi.set(__self__, "vnet_subnet_id", vnet_subnet_id)
        if windows_profile is not None:
            pulumi.set(__self__, "windows_profile", windows_profile)
        if workload_runtime is not None:
            pulumi.set(__self__, "workload_runtime", workload_runtime)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Windows agent pool names must be 6 characters or less.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="capacityReservationGroupID")
    def capacity_reservation_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        AKS will associate the specified agent pool with the Capacity Reservation Group.
        """
        return pulumi.get(self, "capacity_reservation_group_id")

    @capacity_reservation_group_id.setter
    def capacity_reservation_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_reservation_group_id", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="creationData")
    def creation_data(self) -> Optional[pulumi.Input['CreationDataArgs']]:
        """
        CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
        """
        return pulumi.get(self, "creation_data")

    @creation_data.setter
    def creation_data(self, value: Optional[pulumi.Input['CreationDataArgs']]):
        pulumi.set(self, "creation_data", value)

    @property
    @pulumi.getter(name="enableAutoScaling")
    def enable_auto_scaling(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable auto-scaler
        """
        return pulumi.get(self, "enable_auto_scaling")

    @enable_auto_scaling.setter
    def enable_auto_scaling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_scaling", value)

    @property
    @pulumi.getter(name="enableCustomCATrust")
    def enable_custom_ca_trust(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, AKS adds a label to the node indicating that the feature is enabled and deploys a daemonset along with host services to sync custom certificate authorities from user-provided list of base64 encoded certificates into node trust stores. Defaults to false.
        """
        return pulumi.get(self, "enable_custom_ca_trust")

    @enable_custom_ca_trust.setter
    def enable_custom_ca_trust(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_custom_ca_trust", value)

    @property
    @pulumi.getter(name="enableEncryptionAtHost")
    def enable_encryption_at_host(self) -> Optional[pulumi.Input[bool]]:
        """
        This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
        """
        return pulumi.get(self, "enable_encryption_at_host")

    @enable_encryption_at_host.setter
    def enable_encryption_at_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_encryption_at_host", value)

    @property
    @pulumi.getter(name="enableFIPS")
    def enable_fips(self) -> Optional[pulumi.Input[bool]]:
        """
        See [Add a FIPS-enabled node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more details.
        """
        return pulumi.get(self, "enable_fips")

    @enable_fips.setter
    def enable_fips(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_fips", value)

    @property
    @pulumi.getter(name="enableNodePublicIP")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools). The default is false.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @property
    @pulumi.getter(name="enableUltraSSD")
    def enable_ultra_ssd(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable UltraSSD
        """
        return pulumi.get(self, "enable_ultra_ssd")

    @enable_ultra_ssd.setter
    def enable_ultra_ssd(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ultra_ssd", value)

    @property
    @pulumi.getter(name="gpuInstanceProfile")
    def gpu_instance_profile(self) -> Optional[pulumi.Input[Union[str, 'GPUInstanceProfile']]]:
        """
        GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
        """
        return pulumi.get(self, "gpu_instance_profile")

    @gpu_instance_profile.setter
    def gpu_instance_profile(self, value: Optional[pulumi.Input[Union[str, 'GPUInstanceProfile']]]):
        pulumi.set(self, "gpu_instance_profile", value)

    @property
    @pulumi.getter(name="hostGroupID")
    def host_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}. For more information see [Azure dedicated hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
        """
        return pulumi.get(self, "host_group_id")

    @host_group_id.setter
    def host_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_group_id", value)

    @property
    @pulumi.getter(name="kubeletConfig")
    def kubelet_config(self) -> Optional[pulumi.Input['KubeletConfigArgs']]:
        """
        The Kubelet configuration on the agent pool nodes.
        """
        return pulumi.get(self, "kubelet_config")

    @kubelet_config.setter
    def kubelet_config(self, value: Optional[pulumi.Input['KubeletConfigArgs']]):
        pulumi.set(self, "kubelet_config", value)

    @property
    @pulumi.getter(name="kubeletDiskType")
    def kubelet_disk_type(self) -> Optional[pulumi.Input[Union[str, 'KubeletDiskType']]]:
        """
        Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
        """
        return pulumi.get(self, "kubelet_disk_type")

    @kubelet_disk_type.setter
    def kubelet_disk_type(self, value: Optional[pulumi.Input[Union[str, 'KubeletDiskType']]]):
        pulumi.set(self, "kubelet_disk_type", value)

    @property
    @pulumi.getter(name="linuxOSConfig")
    def linux_os_config(self) -> Optional[pulumi.Input['LinuxOSConfigArgs']]:
        """
        The OS configuration of Linux agent nodes.
        """
        return pulumi.get(self, "linux_os_config")

    @linux_os_config.setter
    def linux_os_config(self, value: Optional[pulumi.Input['LinuxOSConfigArgs']]):
        pulumi.set(self, "linux_os_config", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes for auto-scaling
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of pods that can run on a node.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods", value)

    @property
    @pulumi.getter(name="messageOfTheDay")
    def message_of_the_day(self) -> Optional[pulumi.Input[str]]:
        """
        A base64-encoded string which will be written to /etc/motd after decoding. This allows customization of the message of the day for Linux nodes. It must not be specified for Windows nodes. It must be a static string (i.e., will be printed raw and not be executed as a script).
        """
        return pulumi.get(self, "message_of_the_day")

    @message_of_the_day.setter
    def message_of_the_day(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_of_the_day", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of nodes for auto-scaling
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'AgentPoolMode']]]:
        """
        A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'AgentPoolMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['AgentPoolNetworkProfileArgs']]:
        """
        Network-related settings of an agent pool.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['AgentPoolNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The node labels to be persisted across all nodes in agent pool.
        """
        return pulumi.get(self, "node_labels")

    @node_labels.setter
    def node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_labels", value)

    @property
    @pulumi.getter(name="nodePublicIPPrefixID")
    def node_public_ip_prefix_id(self) -> Optional[pulumi.Input[str]]:
        """
        This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
        """
        return pulumi.get(self, "node_public_ip_prefix_id")

    @node_public_ip_prefix_id.setter
    def node_public_ip_prefix_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_public_ip_prefix_id", value)

    @property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
        """
        return pulumi.get(self, "node_taints")

    @node_taints.setter
    def node_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_taints", value)

    @property
    @pulumi.getter(name="orchestratorVersion")
    def orchestrator_version(self) -> Optional[pulumi.Input[str]]:
        """
        Both patch version <major.minor.patch> and <major.minor> are supported. When <major.minor> is specified, the latest supported patch version is chosen automatically. Updating the agent pool with the same <major.minor> once it has been created will not trigger an upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the control plane. The node pool minor version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more information see [upgrading a node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
        """
        return pulumi.get(self, "orchestrator_version")

    @orchestrator_version.setter
    def orchestrator_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "orchestrator_version", value)

    @property
    @pulumi.getter(name="osDiskSizeGB")
    def os_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @os_disk_size_gb.setter
    def os_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "os_disk_size_gb", value)

    @property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> Optional[pulumi.Input[Union[str, 'OSDiskType']]]:
        """
        The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
        """
        return pulumi.get(self, "os_disk_type")

    @os_disk_type.setter
    def os_disk_type(self, value: Optional[pulumi.Input[Union[str, 'OSDiskType']]]):
        pulumi.set(self, "os_disk_type", value)

    @property
    @pulumi.getter(name="osSKU")
    def os_sku(self) -> Optional[pulumi.Input[Union[str, 'OSSKU']]]:
        """
        Specifies the OS SKU used by the agent pool. If not specified, the default is Ubuntu if OSType=Linux or Windows2019 if OSType=Windows. And the default Windows OSSKU will be changed to Windows2022 after Windows2019 is deprecated.
        """
        return pulumi.get(self, "os_sku")

    @os_sku.setter
    def os_sku(self, value: Optional[pulumi.Input[Union[str, 'OSSKU']]]):
        pulumi.set(self, "os_sku", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OSType']]]:
        """
        The operating system type. The default is Linux.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OSType']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="podSubnetID")
    def pod_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
        """
        return pulumi.get(self, "pod_subnet_id")

    @pod_subnet_id.setter
    def pod_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_subnet_id", value)

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[pulumi.Input['PowerStateArgs']]:
        """
        When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
        """
        return pulumi.get(self, "power_state")

    @power_state.setter
    def power_state(self, value: Optional[pulumi.Input['PowerStateArgs']]):
        pulumi.set(self, "power_state", value)

    @property
    @pulumi.getter(name="proximityPlacementGroupID")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for Proximity Placement Group.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @property
    @pulumi.getter(name="scaleDownMode")
    def scale_down_mode(self) -> Optional[pulumi.Input[Union[str, 'ScaleDownMode']]]:
        """
        This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
        """
        return pulumi.get(self, "scale_down_mode")

    @scale_down_mode.setter
    def scale_down_mode(self, value: Optional[pulumi.Input[Union[str, 'ScaleDownMode']]]):
        pulumi.set(self, "scale_down_mode", value)

    @property
    @pulumi.getter(name="scaleSetEvictionPolicy")
    def scale_set_eviction_policy(self) -> Optional[pulumi.Input[Union[str, 'ScaleSetEvictionPolicy']]]:
        """
        This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
        """
        return pulumi.get(self, "scale_set_eviction_policy")

    @scale_set_eviction_policy.setter
    def scale_set_eviction_policy(self, value: Optional[pulumi.Input[Union[str, 'ScaleSetEvictionPolicy']]]):
        pulumi.set(self, "scale_set_eviction_policy", value)

    @property
    @pulumi.getter(name="scaleSetPriority")
    def scale_set_priority(self) -> Optional[pulumi.Input[Union[str, 'ScaleSetPriority']]]:
        """
        The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
        """
        return pulumi.get(self, "scale_set_priority")

    @scale_set_priority.setter
    def scale_set_priority(self, value: Optional[pulumi.Input[Union[str, 'ScaleSetPriority']]]):
        pulumi.set(self, "scale_set_priority", value)

    @property
    @pulumi.getter(name="spotMaxPrice")
    def spot_max_price(self) -> Optional[pulumi.Input[float]]:
        """
        Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing)
        """
        return pulumi.get(self, "spot_max_price")

    @spot_max_price.setter
    def spot_max_price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "spot_max_price", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to be persisted on the agent pool virtual machine scale set.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'AgentPoolType']]]:
        """
        The type of Agent Pool.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'AgentPoolType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Optional[pulumi.Input['AgentPoolUpgradeSettingsArgs']]:
        """
        Settings for upgrading the agentpool
        """
        return pulumi.get(self, "upgrade_settings")

    @upgrade_settings.setter
    def upgrade_settings(self, value: Optional[pulumi.Input['AgentPoolUpgradeSettingsArgs']]):
        pulumi.set(self, "upgrade_settings", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)

    @property
    @pulumi.getter(name="vnetSubnetID")
    def vnet_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
        """
        return pulumi.get(self, "vnet_subnet_id")

    @vnet_subnet_id.setter
    def vnet_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_subnet_id", value)

    @property
    @pulumi.getter(name="windowsProfile")
    def windows_profile(self) -> Optional[pulumi.Input['AgentPoolWindowsProfileArgs']]:
        """
        The Windows agent pool's specific profile.
        """
        return pulumi.get(self, "windows_profile")

    @windows_profile.setter
    def windows_profile(self, value: Optional[pulumi.Input['AgentPoolWindowsProfileArgs']]):
        pulumi.set(self, "windows_profile", value)

    @property
    @pulumi.getter(name="workloadRuntime")
    def workload_runtime(self) -> Optional[pulumi.Input[Union[str, 'WorkloadRuntime']]]:
        """
        Determines the type of workload a node can run.
        """
        return pulumi.get(self, "workload_runtime")

    @workload_runtime.setter
    def workload_runtime(self, value: Optional[pulumi.Input[Union[str, 'WorkloadRuntime']]]):
        pulumi.set(self, "workload_runtime", value)


@pulumi.input_type
class ManagedClusterAutoUpgradeProfileArgs:
    def __init__(__self__, *,
                 node_os_upgrade_channel: Optional[pulumi.Input[Union[str, 'NodeOSUpgradeChannel']]] = None,
                 upgrade_channel: Optional[pulumi.Input[Union[str, 'UpgradeChannel']]] = None):
        """
        Auto upgrade profile for a managed cluster.
        :param pulumi.Input[Union[str, 'NodeOSUpgradeChannel']] node_os_upgrade_channel: The default is Unmanaged, but may change to either NodeImage or SecurityPatch at GA.
        :param pulumi.Input[Union[str, 'UpgradeChannel']] upgrade_channel: For more information see [setting the AKS cluster auto-upgrade channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
        """
        if node_os_upgrade_channel is not None:
            pulumi.set(__self__, "node_os_upgrade_channel", node_os_upgrade_channel)
        if upgrade_channel is not None:
            pulumi.set(__self__, "upgrade_channel", upgrade_channel)

    @property
    @pulumi.getter(name="nodeOSUpgradeChannel")
    def node_os_upgrade_channel(self) -> Optional[pulumi.Input[Union[str, 'NodeOSUpgradeChannel']]]:
        """
        The default is Unmanaged, but may change to either NodeImage or SecurityPatch at GA.
        """
        return pulumi.get(self, "node_os_upgrade_channel")

    @node_os_upgrade_channel.setter
    def node_os_upgrade_channel(self, value: Optional[pulumi.Input[Union[str, 'NodeOSUpgradeChannel']]]):
        pulumi.set(self, "node_os_upgrade_channel", value)

    @property
    @pulumi.getter(name="upgradeChannel")
    def upgrade_channel(self) -> Optional[pulumi.Input[Union[str, 'UpgradeChannel']]]:
        """
        For more information see [setting the AKS cluster auto-upgrade channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
        """
        return pulumi.get(self, "upgrade_channel")

    @upgrade_channel.setter
    def upgrade_channel(self, value: Optional[pulumi.Input[Union[str, 'UpgradeChannel']]]):
        pulumi.set(self, "upgrade_channel", value)


@pulumi.input_type
class ManagedClusterAzureMonitorProfileKubeStateMetricsArgs:
    def __init__(__self__, *,
                 metric_annotations_allow_list: Optional[pulumi.Input[str]] = None,
                 metric_labels_allowlist: Optional[pulumi.Input[str]] = None):
        """
        Kube State Metrics for prometheus addon profile for the container service cluster
        :param pulumi.Input[str] metric_annotations_allow_list: Comma-separated list of additional Kubernetes label keys that will be used in the resource's labels metric.
        :param pulumi.Input[str] metric_labels_allowlist: Comma-separated list of Kubernetes annotations keys that will be used in the resource's labels metric. 
        """
        if metric_annotations_allow_list is not None:
            pulumi.set(__self__, "metric_annotations_allow_list", metric_annotations_allow_list)
        if metric_labels_allowlist is not None:
            pulumi.set(__self__, "metric_labels_allowlist", metric_labels_allowlist)

    @property
    @pulumi.getter(name="metricAnnotationsAllowList")
    def metric_annotations_allow_list(self) -> Optional[pulumi.Input[str]]:
        """
        Comma-separated list of additional Kubernetes label keys that will be used in the resource's labels metric.
        """
        return pulumi.get(self, "metric_annotations_allow_list")

    @metric_annotations_allow_list.setter
    def metric_annotations_allow_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_annotations_allow_list", value)

    @property
    @pulumi.getter(name="metricLabelsAllowlist")
    def metric_labels_allowlist(self) -> Optional[pulumi.Input[str]]:
        """
        Comma-separated list of Kubernetes annotations keys that will be used in the resource's labels metric. 
        """
        return pulumi.get(self, "metric_labels_allowlist")

    @metric_labels_allowlist.setter
    def metric_labels_allowlist(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_labels_allowlist", value)


@pulumi.input_type
class ManagedClusterAzureMonitorProfileMetricsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 kube_state_metrics: Optional[pulumi.Input['ManagedClusterAzureMonitorProfileKubeStateMetricsArgs']] = None):
        """
        Metrics profile for the prometheus service addon
        :param pulumi.Input[bool] enabled: Whether to enable the Prometheus collector
        :param pulumi.Input['ManagedClusterAzureMonitorProfileKubeStateMetricsArgs'] kube_state_metrics: Kube State Metrics for prometheus addon profile for the container service cluster
        """
        pulumi.set(__self__, "enabled", enabled)
        if kube_state_metrics is not None:
            pulumi.set(__self__, "kube_state_metrics", kube_state_metrics)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether to enable the Prometheus collector
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="kubeStateMetrics")
    def kube_state_metrics(self) -> Optional[pulumi.Input['ManagedClusterAzureMonitorProfileKubeStateMetricsArgs']]:
        """
        Kube State Metrics for prometheus addon profile for the container service cluster
        """
        return pulumi.get(self, "kube_state_metrics")

    @kube_state_metrics.setter
    def kube_state_metrics(self, value: Optional[pulumi.Input['ManagedClusterAzureMonitorProfileKubeStateMetricsArgs']]):
        pulumi.set(self, "kube_state_metrics", value)


@pulumi.input_type
class ManagedClusterAzureMonitorProfileArgs:
    def __init__(__self__, *,
                 metrics: Optional[pulumi.Input['ManagedClusterAzureMonitorProfileMetricsArgs']] = None):
        """
        Prometheus addon profile for the container service cluster
        :param pulumi.Input['ManagedClusterAzureMonitorProfileMetricsArgs'] metrics: Metrics profile for the prometheus service addon
        """
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input['ManagedClusterAzureMonitorProfileMetricsArgs']]:
        """
        Metrics profile for the prometheus service addon
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input['ManagedClusterAzureMonitorProfileMetricsArgs']]):
        pulumi.set(self, "metrics", value)


@pulumi.input_type
class ManagedClusterHTTPProxyConfigArgs:
    def __init__(__self__, *,
                 http_proxy: Optional[pulumi.Input[str]] = None,
                 https_proxy: Optional[pulumi.Input[str]] = None,
                 no_proxy: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trusted_ca: Optional[pulumi.Input[str]] = None):
        """
        Cluster HTTP proxy configuration.
        :param pulumi.Input[str] http_proxy: The HTTP proxy server endpoint to use.
        :param pulumi.Input[str] https_proxy: The HTTPS proxy server endpoint to use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] no_proxy: The endpoints that should not go through proxy.
        :param pulumi.Input[str] trusted_ca: Alternative CA cert to use for connecting to proxy servers.
        """
        if http_proxy is not None:
            pulumi.set(__self__, "http_proxy", http_proxy)
        if https_proxy is not None:
            pulumi.set(__self__, "https_proxy", https_proxy)
        if no_proxy is not None:
            pulumi.set(__self__, "no_proxy", no_proxy)
        if trusted_ca is not None:
            pulumi.set(__self__, "trusted_ca", trusted_ca)

    @property
    @pulumi.getter(name="httpProxy")
    def http_proxy(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP proxy server endpoint to use.
        """
        return pulumi.get(self, "http_proxy")

    @http_proxy.setter
    def http_proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_proxy", value)

    @property
    @pulumi.getter(name="httpsProxy")
    def https_proxy(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTPS proxy server endpoint to use.
        """
        return pulumi.get(self, "https_proxy")

    @https_proxy.setter
    def https_proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_proxy", value)

    @property
    @pulumi.getter(name="noProxy")
    def no_proxy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The endpoints that should not go through proxy.
        """
        return pulumi.get(self, "no_proxy")

    @no_proxy.setter
    def no_proxy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "no_proxy", value)

    @property
    @pulumi.getter(name="trustedCa")
    def trusted_ca(self) -> Optional[pulumi.Input[str]]:
        """
        Alternative CA cert to use for connecting to proxy servers.
        """
        return pulumi.get(self, "trusted_ca")

    @trusted_ca.setter
    def trusted_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trusted_ca", value)


@pulumi.input_type
class ManagedClusterIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the managed cluster.
        :param pulumi.Input['ResourceIdentityType'] type: For more information see [use managed identities in AKS](https://docs.microsoft.com/azure/aks/use-managed-identity).
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The keys must be ARM resource IDs in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        For more information see [use managed identities in AKS](https://docs.microsoft.com/azure/aks/use-managed-identity).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The keys must be ARM resource IDs in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ManagedClusterIngressProfileWebAppRoutingArgs:
    def __init__(__self__, *,
                 dns_zone_resource_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Web App Routing settings for the ingress profile.
        :param pulumi.Input[str] dns_zone_resource_id: Resource ID of the DNS Zone to be associated with the web app. Used only when Web App Routing is enabled.
        :param pulumi.Input[bool] enabled: Whether to enable Web App Routing.
        """
        if dns_zone_resource_id is not None:
            pulumi.set(__self__, "dns_zone_resource_id", dns_zone_resource_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="dnsZoneResourceId")
    def dns_zone_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of the DNS Zone to be associated with the web app. Used only when Web App Routing is enabled.
        """
        return pulumi.get(self, "dns_zone_resource_id")

    @dns_zone_resource_id.setter
    def dns_zone_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_zone_resource_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Web App Routing.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ManagedClusterIngressProfileArgs:
    def __init__(__self__, *,
                 web_app_routing: Optional[pulumi.Input['ManagedClusterIngressProfileWebAppRoutingArgs']] = None):
        """
        Ingress profile for the container service cluster.
        :param pulumi.Input['ManagedClusterIngressProfileWebAppRoutingArgs'] web_app_routing: Web App Routing settings for the ingress profile.
        """
        if web_app_routing is not None:
            pulumi.set(__self__, "web_app_routing", web_app_routing)

    @property
    @pulumi.getter(name="webAppRouting")
    def web_app_routing(self) -> Optional[pulumi.Input['ManagedClusterIngressProfileWebAppRoutingArgs']]:
        """
        Web App Routing settings for the ingress profile.
        """
        return pulumi.get(self, "web_app_routing")

    @web_app_routing.setter
    def web_app_routing(self, value: Optional[pulumi.Input['ManagedClusterIngressProfileWebAppRoutingArgs']]):
        pulumi.set(self, "web_app_routing", value)


@pulumi.input_type
class ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 count_i_pv6: Optional[pulumi.Input[int]] = None):
        """
        Desired managed outbound IPs for the cluster load balancer.
        :param pulumi.Input[int] count: The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1. 
        :param pulumi.Input[int] count_i_pv6: The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 0 for single-stack and 1 for dual-stack. 
        """
        if count is None:
            count = 1
        if count is not None:
            pulumi.set(__self__, "count", count)
        if count_i_pv6 is None:
            count_i_pv6 = 0
        if count_i_pv6 is not None:
            pulumi.set(__self__, "count_i_pv6", count_i_pv6)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1. 
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="countIPv6")
    def count_i_pv6(self) -> Optional[pulumi.Input[int]]:
        """
        The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 0 for single-stack and 1 for dual-stack. 
        """
        return pulumi.get(self, "count_i_pv6")

    @count_i_pv6.setter
    def count_i_pv6(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count_i_pv6", value)


@pulumi.input_type
class ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs:
    def __init__(__self__, *,
                 public_ip_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]] = None):
        """
        Desired outbound IP Prefix resources for the cluster load balancer.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]] public_ip_prefixes: A list of public IP prefix resources.
        """
        if public_ip_prefixes is not None:
            pulumi.set(__self__, "public_ip_prefixes", public_ip_prefixes)

    @property
    @pulumi.getter(name="publicIPPrefixes")
    def public_ip_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]:
        """
        A list of public IP prefix resources.
        """
        return pulumi.get(self, "public_ip_prefixes")

    @public_ip_prefixes.setter
    def public_ip_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]):
        pulumi.set(self, "public_ip_prefixes", value)


@pulumi.input_type
class ManagedClusterLoadBalancerProfileOutboundIPsArgs:
    def __init__(__self__, *,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]] = None):
        """
        Desired outbound IP resources for the cluster load balancer.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]] public_ips: A list of public IP resources.
        """
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)

    @property
    @pulumi.getter(name="publicIPs")
    def public_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]:
        """
        A list of public IP resources.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]):
        pulumi.set(self, "public_ips", value)


@pulumi.input_type
class ManagedClusterLoadBalancerProfileArgs:
    def __init__(__self__, *,
                 allocated_outbound_ports: Optional[pulumi.Input[int]] = None,
                 backend_pool_type: Optional[pulumi.Input[Union[str, 'BackendPoolType']]] = None,
                 effective_outbound_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]] = None,
                 enable_multiple_standard_load_balancers: Optional[pulumi.Input[bool]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 managed_outbound_ips: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs']] = None,
                 outbound_ip_prefixes: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs']] = None,
                 outbound_ips: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPsArgs']] = None):
        """
        Profile of the managed cluster load balancer.
        :param pulumi.Input[int] allocated_outbound_ports: The desired number of allocated SNAT ports per VM. Allowed values are in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure dynamically allocating ports.
        :param pulumi.Input[Union[str, 'BackendPoolType']] backend_pool_type: The type of the managed inbound Load Balancer BackendPool.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]] effective_outbound_ips: The effective outbound IP resources of the cluster load balancer.
        :param pulumi.Input[bool] enable_multiple_standard_load_balancers: Enable multiple standard load balancers per AKS cluster or not.
        :param pulumi.Input[int] idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 30 minutes.
        :param pulumi.Input['ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs'] managed_outbound_ips: Desired managed outbound IPs for the cluster load balancer.
        :param pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs'] outbound_ip_prefixes: Desired outbound IP Prefix resources for the cluster load balancer.
        :param pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPsArgs'] outbound_ips: Desired outbound IP resources for the cluster load balancer.
        """
        if allocated_outbound_ports is None:
            allocated_outbound_ports = 0
        if allocated_outbound_ports is not None:
            pulumi.set(__self__, "allocated_outbound_ports", allocated_outbound_ports)
        if backend_pool_type is None:
            backend_pool_type = 'NodeIPConfiguration'
        if backend_pool_type is not None:
            pulumi.set(__self__, "backend_pool_type", backend_pool_type)
        if effective_outbound_ips is not None:
            pulumi.set(__self__, "effective_outbound_ips", effective_outbound_ips)
        if enable_multiple_standard_load_balancers is not None:
            pulumi.set(__self__, "enable_multiple_standard_load_balancers", enable_multiple_standard_load_balancers)
        if idle_timeout_in_minutes is None:
            idle_timeout_in_minutes = 30
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if managed_outbound_ips is not None:
            pulumi.set(__self__, "managed_outbound_ips", managed_outbound_ips)
        if outbound_ip_prefixes is not None:
            pulumi.set(__self__, "outbound_ip_prefixes", outbound_ip_prefixes)
        if outbound_ips is not None:
            pulumi.set(__self__, "outbound_ips", outbound_ips)

    @property
    @pulumi.getter(name="allocatedOutboundPorts")
    def allocated_outbound_ports(self) -> Optional[pulumi.Input[int]]:
        """
        The desired number of allocated SNAT ports per VM. Allowed values are in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure dynamically allocating ports.
        """
        return pulumi.get(self, "allocated_outbound_ports")

    @allocated_outbound_ports.setter
    def allocated_outbound_ports(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocated_outbound_ports", value)

    @property
    @pulumi.getter(name="backendPoolType")
    def backend_pool_type(self) -> Optional[pulumi.Input[Union[str, 'BackendPoolType']]]:
        """
        The type of the managed inbound Load Balancer BackendPool.
        """
        return pulumi.get(self, "backend_pool_type")

    @backend_pool_type.setter
    def backend_pool_type(self, value: Optional[pulumi.Input[Union[str, 'BackendPoolType']]]):
        pulumi.set(self, "backend_pool_type", value)

    @property
    @pulumi.getter(name="effectiveOutboundIPs")
    def effective_outbound_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]:
        """
        The effective outbound IP resources of the cluster load balancer.
        """
        return pulumi.get(self, "effective_outbound_ips")

    @effective_outbound_ips.setter
    def effective_outbound_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]):
        pulumi.set(self, "effective_outbound_ips", value)

    @property
    @pulumi.getter(name="enableMultipleStandardLoadBalancers")
    def enable_multiple_standard_load_balancers(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable multiple standard load balancers per AKS cluster or not.
        """
        return pulumi.get(self, "enable_multiple_standard_load_balancers")

    @enable_multiple_standard_load_balancers.setter
    def enable_multiple_standard_load_balancers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_multiple_standard_load_balancers", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 30 minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="managedOutboundIPs")
    def managed_outbound_ips(self) -> Optional[pulumi.Input['ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs']]:
        """
        Desired managed outbound IPs for the cluster load balancer.
        """
        return pulumi.get(self, "managed_outbound_ips")

    @managed_outbound_ips.setter
    def managed_outbound_ips(self, value: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs']]):
        pulumi.set(self, "managed_outbound_ips", value)

    @property
    @pulumi.getter(name="outboundIPPrefixes")
    def outbound_ip_prefixes(self) -> Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs']]:
        """
        Desired outbound IP Prefix resources for the cluster load balancer.
        """
        return pulumi.get(self, "outbound_ip_prefixes")

    @outbound_ip_prefixes.setter
    def outbound_ip_prefixes(self, value: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs']]):
        pulumi.set(self, "outbound_ip_prefixes", value)

    @property
    @pulumi.getter(name="outboundIPs")
    def outbound_ips(self) -> Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPsArgs']]:
        """
        Desired outbound IP resources for the cluster load balancer.
        """
        return pulumi.get(self, "outbound_ips")

    @outbound_ips.setter
    def outbound_ips(self, value: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPsArgs']]):
        pulumi.set(self, "outbound_ips", value)


@pulumi.input_type
class ManagedClusterManagedOutboundIPProfileArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None):
        """
        Profile of the managed outbound IP resources of the managed cluster.
        :param pulumi.Input[int] count: The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16 (inclusive). The default value is 1. 
        """
        if count is None:
            count = 1
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16 (inclusive). The default value is 1. 
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)


@pulumi.input_type
class ManagedClusterNATGatewayProfileArgs:
    def __init__(__self__, *,
                 effective_outbound_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 managed_outbound_ip_profile: Optional[pulumi.Input['ManagedClusterManagedOutboundIPProfileArgs']] = None):
        """
        Profile of the managed cluster NAT gateway.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]] effective_outbound_ips: The effective outbound IP resources of the cluster NAT gateway.
        :param pulumi.Input[int] idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 4 minutes.
        :param pulumi.Input['ManagedClusterManagedOutboundIPProfileArgs'] managed_outbound_ip_profile: Profile of the managed outbound IP resources of the cluster NAT gateway.
        """
        if effective_outbound_ips is not None:
            pulumi.set(__self__, "effective_outbound_ips", effective_outbound_ips)
        if idle_timeout_in_minutes is None:
            idle_timeout_in_minutes = 4
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if managed_outbound_ip_profile is not None:
            pulumi.set(__self__, "managed_outbound_ip_profile", managed_outbound_ip_profile)

    @property
    @pulumi.getter(name="effectiveOutboundIPs")
    def effective_outbound_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]:
        """
        The effective outbound IP resources of the cluster NAT gateway.
        """
        return pulumi.get(self, "effective_outbound_ips")

    @effective_outbound_ips.setter
    def effective_outbound_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]):
        pulumi.set(self, "effective_outbound_ips", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 4 minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="managedOutboundIPProfile")
    def managed_outbound_ip_profile(self) -> Optional[pulumi.Input['ManagedClusterManagedOutboundIPProfileArgs']]:
        """
        Profile of the managed outbound IP resources of the cluster NAT gateway.
        """
        return pulumi.get(self, "managed_outbound_ip_profile")

    @managed_outbound_ip_profile.setter
    def managed_outbound_ip_profile(self, value: Optional[pulumi.Input['ManagedClusterManagedOutboundIPProfileArgs']]):
        pulumi.set(self, "managed_outbound_ip_profile", value)


@pulumi.input_type
class ManagedClusterOIDCIssuerProfileArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        The OIDC issuer profile of the Managed Cluster.
        :param pulumi.Input[bool] enabled: Whether the OIDC issuer is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the OIDC issuer is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ManagedClusterPodIdentityExceptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 pod_labels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        """
        See [disable AAD Pod Identity for a specific Pod/Application](https://azure.github.io/aad-pod-identity/docs/configure/application_exception/) for more details.
        :param pulumi.Input[str] name: The name of the pod identity exception.
        :param pulumi.Input[str] namespace: The namespace of the pod identity exception.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pod_labels: The pod labels to match.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "pod_labels", pod_labels)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the pod identity exception.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The namespace of the pod identity exception.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="podLabels")
    def pod_labels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        The pod labels to match.
        """
        return pulumi.get(self, "pod_labels")

    @pod_labels.setter
    def pod_labels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "pod_labels", value)


@pulumi.input_type
class ManagedClusterPodIdentityProfileArgs:
    def __init__(__self__, *,
                 allow_network_plugin_kubenet: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 user_assigned_identities: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityArgs']]]] = None,
                 user_assigned_identity_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityExceptionArgs']]]] = None):
        """
        See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on pod identity integration.
        :param pulumi.Input[bool] allow_network_plugin_kubenet: Running in Kubenet is disabled by default due to the security related nature of AAD Pod Identity and the risks of IP spoofing. See [using Kubenet network plugin with AAD Pod Identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities) for more information.
        :param pulumi.Input[bool] enabled: Whether the pod identity addon is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityArgs']]] user_assigned_identities: The pod identities to use in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityExceptionArgs']]] user_assigned_identity_exceptions: The pod identity exceptions to allow.
        """
        if allow_network_plugin_kubenet is not None:
            pulumi.set(__self__, "allow_network_plugin_kubenet", allow_network_plugin_kubenet)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)
        if user_assigned_identity_exceptions is not None:
            pulumi.set(__self__, "user_assigned_identity_exceptions", user_assigned_identity_exceptions)

    @property
    @pulumi.getter(name="allowNetworkPluginKubenet")
    def allow_network_plugin_kubenet(self) -> Optional[pulumi.Input[bool]]:
        """
        Running in Kubenet is disabled by default due to the security related nature of AAD Pod Identity and the risks of IP spoofing. See [using Kubenet network plugin with AAD Pod Identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities) for more information.
        """
        return pulumi.get(self, "allow_network_plugin_kubenet")

    @allow_network_plugin_kubenet.setter
    def allow_network_plugin_kubenet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_network_plugin_kubenet", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the pod identity addon is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityArgs']]]]:
        """
        The pod identities to use in the cluster.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityArgs']]]]):
        pulumi.set(self, "user_assigned_identities", value)

    @property
    @pulumi.getter(name="userAssignedIdentityExceptions")
    def user_assigned_identity_exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityExceptionArgs']]]]:
        """
        The pod identity exceptions to allow.
        """
        return pulumi.get(self, "user_assigned_identity_exceptions")

    @user_assigned_identity_exceptions.setter
    def user_assigned_identity_exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityExceptionArgs']]]]):
        pulumi.set(self, "user_assigned_identity_exceptions", value)


@pulumi.input_type
class ManagedClusterPodIdentityArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input['UserAssignedIdentityArgs'],
                 name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 binding_selector: Optional[pulumi.Input[str]] = None):
        """
        Details about the pod identity assigned to the Managed Cluster.
        :param pulumi.Input['UserAssignedIdentityArgs'] identity: The user assigned identity details.
        :param pulumi.Input[str] name: The name of the pod identity.
        :param pulumi.Input[str] namespace: The namespace of the pod identity.
        :param pulumi.Input[str] binding_selector: The binding selector to use for the AzureIdentityBinding resource.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        if binding_selector is not None:
            pulumi.set(__self__, "binding_selector", binding_selector)

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Input['UserAssignedIdentityArgs']:
        """
        The user assigned identity details.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['UserAssignedIdentityArgs']):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the pod identity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The namespace of the pod identity.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="bindingSelector")
    def binding_selector(self) -> Optional[pulumi.Input[str]]:
        """
        The binding selector to use for the AzureIdentityBinding resource.
        """
        return pulumi.get(self, "binding_selector")

    @binding_selector.setter
    def binding_selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "binding_selector", value)


@pulumi.input_type
class ManagedClusterPropertiesAutoScalerProfileArgs:
    def __init__(__self__, *,
                 balance_similar_node_groups: Optional[pulumi.Input[str]] = None,
                 expander: Optional[pulumi.Input[Union[str, 'Expander']]] = None,
                 max_empty_bulk_delete: Optional[pulumi.Input[str]] = None,
                 max_graceful_termination_sec: Optional[pulumi.Input[str]] = None,
                 max_node_provision_time: Optional[pulumi.Input[str]] = None,
                 max_total_unready_percentage: Optional[pulumi.Input[str]] = None,
                 new_pod_scale_up_delay: Optional[pulumi.Input[str]] = None,
                 ok_total_unready_count: Optional[pulumi.Input[str]] = None,
                 scale_down_delay_after_add: Optional[pulumi.Input[str]] = None,
                 scale_down_delay_after_delete: Optional[pulumi.Input[str]] = None,
                 scale_down_delay_after_failure: Optional[pulumi.Input[str]] = None,
                 scale_down_unneeded_time: Optional[pulumi.Input[str]] = None,
                 scale_down_unready_time: Optional[pulumi.Input[str]] = None,
                 scale_down_utilization_threshold: Optional[pulumi.Input[str]] = None,
                 scan_interval: Optional[pulumi.Input[str]] = None,
                 skip_nodes_with_local_storage: Optional[pulumi.Input[str]] = None,
                 skip_nodes_with_system_pods: Optional[pulumi.Input[str]] = None):
        """
        Parameters to be applied to the cluster-autoscaler when enabled
        :param pulumi.Input[str] balance_similar_node_groups: Valid values are 'true' and 'false'
        :param pulumi.Input[Union[str, 'Expander']] expander: If not specified, the default is 'random'. See [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders) for more information.
        :param pulumi.Input[str] max_empty_bulk_delete: The default is 10.
        :param pulumi.Input[str] max_graceful_termination_sec: The default is 600.
        :param pulumi.Input[str] max_node_provision_time: The default is '15m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        :param pulumi.Input[str] max_total_unready_percentage: The default is 45. The maximum is 100 and the minimum is 0.
        :param pulumi.Input[str] new_pod_scale_up_delay: For scenarios like burst/batch scale where you don't want CA to act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
        :param pulumi.Input[str] ok_total_unready_count: This must be an integer. The default is 3.
        :param pulumi.Input[str] scale_down_delay_after_add: The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        :param pulumi.Input[str] scale_down_delay_after_delete: The default is the scan-interval. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        :param pulumi.Input[str] scale_down_delay_after_failure: The default is '3m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        :param pulumi.Input[str] scale_down_unneeded_time: The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        :param pulumi.Input[str] scale_down_unready_time: The default is '20m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        :param pulumi.Input[str] scale_down_utilization_threshold: The default is '0.5'.
        :param pulumi.Input[str] scan_interval: The default is '10'. Values must be an integer number of seconds.
        :param pulumi.Input[str] skip_nodes_with_local_storage: The default is true.
        :param pulumi.Input[str] skip_nodes_with_system_pods: The default is true.
        """
        if balance_similar_node_groups is not None:
            pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        if expander is not None:
            pulumi.set(__self__, "expander", expander)
        if max_empty_bulk_delete is not None:
            pulumi.set(__self__, "max_empty_bulk_delete", max_empty_bulk_delete)
        if max_graceful_termination_sec is not None:
            pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        if max_node_provision_time is not None:
            pulumi.set(__self__, "max_node_provision_time", max_node_provision_time)
        if max_total_unready_percentage is not None:
            pulumi.set(__self__, "max_total_unready_percentage", max_total_unready_percentage)
        if new_pod_scale_up_delay is not None:
            pulumi.set(__self__, "new_pod_scale_up_delay", new_pod_scale_up_delay)
        if ok_total_unready_count is not None:
            pulumi.set(__self__, "ok_total_unready_count", ok_total_unready_count)
        if scale_down_delay_after_add is not None:
            pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        if scale_down_delay_after_delete is not None:
            pulumi.set(__self__, "scale_down_delay_after_delete", scale_down_delay_after_delete)
        if scale_down_delay_after_failure is not None:
            pulumi.set(__self__, "scale_down_delay_after_failure", scale_down_delay_after_failure)
        if scale_down_unneeded_time is not None:
            pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        if scale_down_unready_time is not None:
            pulumi.set(__self__, "scale_down_unready_time", scale_down_unready_time)
        if scale_down_utilization_threshold is not None:
            pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)
        if scan_interval is not None:
            pulumi.set(__self__, "scan_interval", scan_interval)
        if skip_nodes_with_local_storage is not None:
            pulumi.set(__self__, "skip_nodes_with_local_storage", skip_nodes_with_local_storage)
        if skip_nodes_with_system_pods is not None:
            pulumi.set(__self__, "skip_nodes_with_system_pods", skip_nodes_with_system_pods)

    @property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are 'true' and 'false'
        """
        return pulumi.get(self, "balance_similar_node_groups")

    @balance_similar_node_groups.setter
    def balance_similar_node_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "balance_similar_node_groups", value)

    @property
    @pulumi.getter
    def expander(self) -> Optional[pulumi.Input[Union[str, 'Expander']]]:
        """
        If not specified, the default is 'random'. See [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders) for more information.
        """
        return pulumi.get(self, "expander")

    @expander.setter
    def expander(self, value: Optional[pulumi.Input[Union[str, 'Expander']]]):
        pulumi.set(self, "expander", value)

    @property
    @pulumi.getter(name="maxEmptyBulkDelete")
    def max_empty_bulk_delete(self) -> Optional[pulumi.Input[str]]:
        """
        The default is 10.
        """
        return pulumi.get(self, "max_empty_bulk_delete")

    @max_empty_bulk_delete.setter
    def max_empty_bulk_delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_empty_bulk_delete", value)

    @property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> Optional[pulumi.Input[str]]:
        """
        The default is 600.
        """
        return pulumi.get(self, "max_graceful_termination_sec")

    @max_graceful_termination_sec.setter
    def max_graceful_termination_sec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_graceful_termination_sec", value)

    @property
    @pulumi.getter(name="maxNodeProvisionTime")
    def max_node_provision_time(self) -> Optional[pulumi.Input[str]]:
        """
        The default is '15m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        """
        return pulumi.get(self, "max_node_provision_time")

    @max_node_provision_time.setter
    def max_node_provision_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_node_provision_time", value)

    @property
    @pulumi.getter(name="maxTotalUnreadyPercentage")
    def max_total_unready_percentage(self) -> Optional[pulumi.Input[str]]:
        """
        The default is 45. The maximum is 100 and the minimum is 0.
        """
        return pulumi.get(self, "max_total_unready_percentage")

    @max_total_unready_percentage.setter
    def max_total_unready_percentage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_total_unready_percentage", value)

    @property
    @pulumi.getter(name="newPodScaleUpDelay")
    def new_pod_scale_up_delay(self) -> Optional[pulumi.Input[str]]:
        """
        For scenarios like burst/batch scale where you don't want CA to act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
        """
        return pulumi.get(self, "new_pod_scale_up_delay")

    @new_pod_scale_up_delay.setter
    def new_pod_scale_up_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_pod_scale_up_delay", value)

    @property
    @pulumi.getter(name="okTotalUnreadyCount")
    def ok_total_unready_count(self) -> Optional[pulumi.Input[str]]:
        """
        This must be an integer. The default is 3.
        """
        return pulumi.get(self, "ok_total_unready_count")

    @ok_total_unready_count.setter
    def ok_total_unready_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ok_total_unready_count", value)

    @property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> Optional[pulumi.Input[str]]:
        """
        The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        """
        return pulumi.get(self, "scale_down_delay_after_add")

    @scale_down_delay_after_add.setter
    def scale_down_delay_after_add(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_delay_after_add", value)

    @property
    @pulumi.getter(name="scaleDownDelayAfterDelete")
    def scale_down_delay_after_delete(self) -> Optional[pulumi.Input[str]]:
        """
        The default is the scan-interval. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        """
        return pulumi.get(self, "scale_down_delay_after_delete")

    @scale_down_delay_after_delete.setter
    def scale_down_delay_after_delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_delay_after_delete", value)

    @property
    @pulumi.getter(name="scaleDownDelayAfterFailure")
    def scale_down_delay_after_failure(self) -> Optional[pulumi.Input[str]]:
        """
        The default is '3m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        """
        return pulumi.get(self, "scale_down_delay_after_failure")

    @scale_down_delay_after_failure.setter
    def scale_down_delay_after_failure(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_delay_after_failure", value)

    @property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> Optional[pulumi.Input[str]]:
        """
        The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        """
        return pulumi.get(self, "scale_down_unneeded_time")

    @scale_down_unneeded_time.setter
    def scale_down_unneeded_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_unneeded_time", value)

    @property
    @pulumi.getter(name="scaleDownUnreadyTime")
    def scale_down_unready_time(self) -> Optional[pulumi.Input[str]]:
        """
        The default is '20m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        """
        return pulumi.get(self, "scale_down_unready_time")

    @scale_down_unready_time.setter
    def scale_down_unready_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_unready_time", value)

    @property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> Optional[pulumi.Input[str]]:
        """
        The default is '0.5'.
        """
        return pulumi.get(self, "scale_down_utilization_threshold")

    @scale_down_utilization_threshold.setter
    def scale_down_utilization_threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_utilization_threshold", value)

    @property
    @pulumi.getter(name="scanInterval")
    def scan_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The default is '10'. Values must be an integer number of seconds.
        """
        return pulumi.get(self, "scan_interval")

    @scan_interval.setter
    def scan_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_interval", value)

    @property
    @pulumi.getter(name="skipNodesWithLocalStorage")
    def skip_nodes_with_local_storage(self) -> Optional[pulumi.Input[str]]:
        """
        The default is true.
        """
        return pulumi.get(self, "skip_nodes_with_local_storage")

    @skip_nodes_with_local_storage.setter
    def skip_nodes_with_local_storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skip_nodes_with_local_storage", value)

    @property
    @pulumi.getter(name="skipNodesWithSystemPods")
    def skip_nodes_with_system_pods(self) -> Optional[pulumi.Input[str]]:
        """
        The default is true.
        """
        return pulumi.get(self, "skip_nodes_with_system_pods")

    @skip_nodes_with_system_pods.setter
    def skip_nodes_with_system_pods(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skip_nodes_with_system_pods", value)


@pulumi.input_type
class ManagedClusterSKUArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'ManagedClusterSKUName']]] = None,
                 tier: Optional[pulumi.Input[Union[str, 'ManagedClusterSKUTier']]] = None):
        """
        The SKU of a Managed Cluster.
        :param pulumi.Input[Union[str, 'ManagedClusterSKUName']] name: The name of a managed cluster SKU.
        :param pulumi.Input[Union[str, 'ManagedClusterSKUTier']] tier: If not specified, the default is 'Free'. See [uptime SLA](https://docs.microsoft.com/azure/aks/uptime-sla) for more details.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'ManagedClusterSKUName']]]:
        """
        The name of a managed cluster SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'ManagedClusterSKUName']]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[Union[str, 'ManagedClusterSKUTier']]]:
        """
        If not specified, the default is 'Free'. See [uptime SLA](https://docs.microsoft.com/azure/aks/uptime-sla) for more details.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[Union[str, 'ManagedClusterSKUTier']]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Microsoft Defender settings for the security profile threat detection.
        :param pulumi.Input[bool] enabled: Whether to enable Defender threat detection
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Defender threat detection
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ManagedClusterSecurityProfileDefenderArgs:
    def __init__(__self__, *,
                 log_analytics_workspace_resource_id: Optional[pulumi.Input[str]] = None,
                 security_monitoring: Optional[pulumi.Input['ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs']] = None):
        """
        Microsoft Defender settings for the security profile.
        :param pulumi.Input[str] log_analytics_workspace_resource_id: Resource ID of the Log Analytics workspace to be associated with Microsoft Defender. When Microsoft Defender is enabled, this field is required and must be a valid workspace resource ID. When Microsoft Defender is disabled, leave the field empty.
        :param pulumi.Input['ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs'] security_monitoring: Microsoft Defender threat detection for Cloud settings for the security profile.
        """
        if log_analytics_workspace_resource_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_resource_id", log_analytics_workspace_resource_id)
        if security_monitoring is not None:
            pulumi.set(__self__, "security_monitoring", security_monitoring)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceResourceId")
    def log_analytics_workspace_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of the Log Analytics workspace to be associated with Microsoft Defender. When Microsoft Defender is enabled, this field is required and must be a valid workspace resource ID. When Microsoft Defender is disabled, leave the field empty.
        """
        return pulumi.get(self, "log_analytics_workspace_resource_id")

    @log_analytics_workspace_resource_id.setter
    def log_analytics_workspace_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_analytics_workspace_resource_id", value)

    @property
    @pulumi.getter(name="securityMonitoring")
    def security_monitoring(self) -> Optional[pulumi.Input['ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs']]:
        """
        Microsoft Defender threat detection for Cloud settings for the security profile.
        """
        return pulumi.get(self, "security_monitoring")

    @security_monitoring.setter
    def security_monitoring(self, value: Optional[pulumi.Input['ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs']]):
        pulumi.set(self, "security_monitoring", value)


@pulumi.input_type
class ManagedClusterSecurityProfileImageCleanerArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 interval_hours: Optional[pulumi.Input[int]] = None):
        """
        ImageCleaner removes unused images from nodes, freeing up disk space and helping to reduce attack surface area. Here are settings for the security profile.
        :param pulumi.Input[bool] enabled: Whether to enable ImageCleaner on AKS cluster.
        :param pulumi.Input[int] interval_hours: ImageCleaner scanning interval.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if interval_hours is not None:
            pulumi.set(__self__, "interval_hours", interval_hours)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable ImageCleaner on AKS cluster.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="intervalHours")
    def interval_hours(self) -> Optional[pulumi.Input[int]]:
        """
        ImageCleaner scanning interval.
        """
        return pulumi.get(self, "interval_hours")

    @interval_hours.setter
    def interval_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval_hours", value)


@pulumi.input_type
class ManagedClusterSecurityProfileNodeRestrictionArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Node Restriction settings for the security profile.
        :param pulumi.Input[bool] enabled: Whether to enable Node Restriction
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Node Restriction
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ManagedClusterSecurityProfileWorkloadIdentityArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Workload Identity settings for the security profile.
        :param pulumi.Input[bool] enabled: Whether to enable Workload Identity
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Workload Identity
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ManagedClusterSecurityProfileArgs:
    def __init__(__self__, *,
                 azure_key_vault_kms: Optional[pulumi.Input['AzureKeyVaultKmsArgs']] = None,
                 custom_ca_trust_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defender: Optional[pulumi.Input['ManagedClusterSecurityProfileDefenderArgs']] = None,
                 image_cleaner: Optional[pulumi.Input['ManagedClusterSecurityProfileImageCleanerArgs']] = None,
                 node_restriction: Optional[pulumi.Input['ManagedClusterSecurityProfileNodeRestrictionArgs']] = None,
                 workload_identity: Optional[pulumi.Input['ManagedClusterSecurityProfileWorkloadIdentityArgs']] = None):
        """
        Security profile for the container service cluster.
        :param pulumi.Input['AzureKeyVaultKmsArgs'] azure_key_vault_kms: Azure Key Vault [key management service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/) settings for the security profile.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_ca_trust_certificates: A list of up to 10 base64 encoded CAs that will be added to the trust store on nodes with the Custom CA Trust feature enabled. For more information see [Custom CA Trust Certificates](https://learn.microsoft.com/en-us/azure/aks/custom-certificate-authority)
        :param pulumi.Input['ManagedClusterSecurityProfileDefenderArgs'] defender: Microsoft Defender settings for the security profile.
        :param pulumi.Input['ManagedClusterSecurityProfileImageCleanerArgs'] image_cleaner: ImageCleaner settings for the security profile.
        :param pulumi.Input['ManagedClusterSecurityProfileNodeRestrictionArgs'] node_restriction: [Node Restriction](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#noderestriction) settings for the security profile.
        :param pulumi.Input['ManagedClusterSecurityProfileWorkloadIdentityArgs'] workload_identity: [Workload Identity](https://azure.github.io/azure-workload-identity/docs/) settings for the security profile.
        """
        if azure_key_vault_kms is not None:
            pulumi.set(__self__, "azure_key_vault_kms", azure_key_vault_kms)
        if custom_ca_trust_certificates is not None:
            pulumi.set(__self__, "custom_ca_trust_certificates", custom_ca_trust_certificates)
        if defender is not None:
            pulumi.set(__self__, "defender", defender)
        if image_cleaner is not None:
            pulumi.set(__self__, "image_cleaner", image_cleaner)
        if node_restriction is not None:
            pulumi.set(__self__, "node_restriction", node_restriction)
        if workload_identity is not None:
            pulumi.set(__self__, "workload_identity", workload_identity)

    @property
    @pulumi.getter(name="azureKeyVaultKms")
    def azure_key_vault_kms(self) -> Optional[pulumi.Input['AzureKeyVaultKmsArgs']]:
        """
        Azure Key Vault [key management service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/) settings for the security profile.
        """
        return pulumi.get(self, "azure_key_vault_kms")

    @azure_key_vault_kms.setter
    def azure_key_vault_kms(self, value: Optional[pulumi.Input['AzureKeyVaultKmsArgs']]):
        pulumi.set(self, "azure_key_vault_kms", value)

    @property
    @pulumi.getter(name="customCATrustCertificates")
    def custom_ca_trust_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of up to 10 base64 encoded CAs that will be added to the trust store on nodes with the Custom CA Trust feature enabled. For more information see [Custom CA Trust Certificates](https://learn.microsoft.com/en-us/azure/aks/custom-certificate-authority)
        """
        return pulumi.get(self, "custom_ca_trust_certificates")

    @custom_ca_trust_certificates.setter
    def custom_ca_trust_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_ca_trust_certificates", value)

    @property
    @pulumi.getter
    def defender(self) -> Optional[pulumi.Input['ManagedClusterSecurityProfileDefenderArgs']]:
        """
        Microsoft Defender settings for the security profile.
        """
        return pulumi.get(self, "defender")

    @defender.setter
    def defender(self, value: Optional[pulumi.Input['ManagedClusterSecurityProfileDefenderArgs']]):
        pulumi.set(self, "defender", value)

    @property
    @pulumi.getter(name="imageCleaner")
    def image_cleaner(self) -> Optional[pulumi.Input['ManagedClusterSecurityProfileImageCleanerArgs']]:
        """
        ImageCleaner settings for the security profile.
        """
        return pulumi.get(self, "image_cleaner")

    @image_cleaner.setter
    def image_cleaner(self, value: Optional[pulumi.Input['ManagedClusterSecurityProfileImageCleanerArgs']]):
        pulumi.set(self, "image_cleaner", value)

    @property
    @pulumi.getter(name="nodeRestriction")
    def node_restriction(self) -> Optional[pulumi.Input['ManagedClusterSecurityProfileNodeRestrictionArgs']]:
        """
        [Node Restriction](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#noderestriction) settings for the security profile.
        """
        return pulumi.get(self, "node_restriction")

    @node_restriction.setter
    def node_restriction(self, value: Optional[pulumi.Input['ManagedClusterSecurityProfileNodeRestrictionArgs']]):
        pulumi.set(self, "node_restriction", value)

    @property
    @pulumi.getter(name="workloadIdentity")
    def workload_identity(self) -> Optional[pulumi.Input['ManagedClusterSecurityProfileWorkloadIdentityArgs']]:
        """
        [Workload Identity](https://azure.github.io/azure-workload-identity/docs/) settings for the security profile.
        """
        return pulumi.get(self, "workload_identity")

    @workload_identity.setter
    def workload_identity(self, value: Optional[pulumi.Input['ManagedClusterSecurityProfileWorkloadIdentityArgs']]):
        pulumi.set(self, "workload_identity", value)


@pulumi.input_type
class ManagedClusterServicePrincipalProfileArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 secret: Optional[pulumi.Input[str]] = None):
        """
        Information about a service principal identity for the cluster to use for manipulating Azure APIs.
        :param pulumi.Input[str] client_id: The ID for the service principal.
        :param pulumi.Input[str] secret: The secret password associated with the service principal in plain text.
        """
        pulumi.set(__self__, "client_id", client_id)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        The ID for the service principal.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        The secret password associated with the service principal in plain text.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class ManagedClusterStorageProfileBlobCSIDriverArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        AzureBlob CSI Driver settings for the storage profile.
        :param pulumi.Input[bool] enabled: Whether to enable AzureBlob CSI Driver. The default value is false.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable AzureBlob CSI Driver. The default value is false.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ManagedClusterStorageProfileDiskCSIDriverArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        AzureDisk CSI Driver settings for the storage profile.
        :param pulumi.Input[bool] enabled: Whether to enable AzureDisk CSI Driver. The default value is true.
        :param pulumi.Input[str] version: The version of AzureDisk CSI Driver. The default value is v1.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable AzureDisk CSI Driver. The default value is true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of AzureDisk CSI Driver. The default value is v1.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ManagedClusterStorageProfileFileCSIDriverArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        AzureFile CSI Driver settings for the storage profile.
        :param pulumi.Input[bool] enabled: Whether to enable AzureFile CSI Driver. The default value is true.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable AzureFile CSI Driver. The default value is true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ManagedClusterStorageProfileSnapshotControllerArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Snapshot Controller settings for the storage profile.
        :param pulumi.Input[bool] enabled: Whether to enable Snapshot Controller. The default value is true.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Snapshot Controller. The default value is true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ManagedClusterStorageProfileArgs:
    def __init__(__self__, *,
                 blob_csi_driver: Optional[pulumi.Input['ManagedClusterStorageProfileBlobCSIDriverArgs']] = None,
                 disk_csi_driver: Optional[pulumi.Input['ManagedClusterStorageProfileDiskCSIDriverArgs']] = None,
                 file_csi_driver: Optional[pulumi.Input['ManagedClusterStorageProfileFileCSIDriverArgs']] = None,
                 snapshot_controller: Optional[pulumi.Input['ManagedClusterStorageProfileSnapshotControllerArgs']] = None):
        """
        Storage profile for the container service cluster.
        :param pulumi.Input['ManagedClusterStorageProfileBlobCSIDriverArgs'] blob_csi_driver: AzureBlob CSI Driver settings for the storage profile.
        :param pulumi.Input['ManagedClusterStorageProfileDiskCSIDriverArgs'] disk_csi_driver: AzureDisk CSI Driver settings for the storage profile.
        :param pulumi.Input['ManagedClusterStorageProfileFileCSIDriverArgs'] file_csi_driver: AzureFile CSI Driver settings for the storage profile.
        :param pulumi.Input['ManagedClusterStorageProfileSnapshotControllerArgs'] snapshot_controller: Snapshot Controller settings for the storage profile.
        """
        if blob_csi_driver is not None:
            pulumi.set(__self__, "blob_csi_driver", blob_csi_driver)
        if disk_csi_driver is not None:
            pulumi.set(__self__, "disk_csi_driver", disk_csi_driver)
        if file_csi_driver is not None:
            pulumi.set(__self__, "file_csi_driver", file_csi_driver)
        if snapshot_controller is not None:
            pulumi.set(__self__, "snapshot_controller", snapshot_controller)

    @property
    @pulumi.getter(name="blobCSIDriver")
    def blob_csi_driver(self) -> Optional[pulumi.Input['ManagedClusterStorageProfileBlobCSIDriverArgs']]:
        """
        AzureBlob CSI Driver settings for the storage profile.
        """
        return pulumi.get(self, "blob_csi_driver")

    @blob_csi_driver.setter
    def blob_csi_driver(self, value: Optional[pulumi.Input['ManagedClusterStorageProfileBlobCSIDriverArgs']]):
        pulumi.set(self, "blob_csi_driver", value)

    @property
    @pulumi.getter(name="diskCSIDriver")
    def disk_csi_driver(self) -> Optional[pulumi.Input['ManagedClusterStorageProfileDiskCSIDriverArgs']]:
        """
        AzureDisk CSI Driver settings for the storage profile.
        """
        return pulumi.get(self, "disk_csi_driver")

    @disk_csi_driver.setter
    def disk_csi_driver(self, value: Optional[pulumi.Input['ManagedClusterStorageProfileDiskCSIDriverArgs']]):
        pulumi.set(self, "disk_csi_driver", value)

    @property
    @pulumi.getter(name="fileCSIDriver")
    def file_csi_driver(self) -> Optional[pulumi.Input['ManagedClusterStorageProfileFileCSIDriverArgs']]:
        """
        AzureFile CSI Driver settings for the storage profile.
        """
        return pulumi.get(self, "file_csi_driver")

    @file_csi_driver.setter
    def file_csi_driver(self, value: Optional[pulumi.Input['ManagedClusterStorageProfileFileCSIDriverArgs']]):
        pulumi.set(self, "file_csi_driver", value)

    @property
    @pulumi.getter(name="snapshotController")
    def snapshot_controller(self) -> Optional[pulumi.Input['ManagedClusterStorageProfileSnapshotControllerArgs']]:
        """
        Snapshot Controller settings for the storage profile.
        """
        return pulumi.get(self, "snapshot_controller")

    @snapshot_controller.setter
    def snapshot_controller(self, value: Optional[pulumi.Input['ManagedClusterStorageProfileSnapshotControllerArgs']]):
        pulumi.set(self, "snapshot_controller", value)


@pulumi.input_type
class ManagedClusterWindowsProfileArgs:
    def __init__(__self__, *,
                 admin_username: pulumi.Input[str],
                 admin_password: Optional[pulumi.Input[str]] = None,
                 enable_csi_proxy: Optional[pulumi.Input[bool]] = None,
                 gmsa_profile: Optional[pulumi.Input['WindowsGmsaProfileArgs']] = None,
                 license_type: Optional[pulumi.Input[Union[str, 'LicenseType']]] = None):
        """
        Profile for Windows VMs in the managed cluster.
        :param pulumi.Input[str] admin_username: Specifies the name of the administrator account. <br><br> **Restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
        :param pulumi.Input[str] admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
        :param pulumi.Input[bool] enable_csi_proxy: For more details on CSI proxy, see the [CSI proxy GitHub repo](https://github.com/kubernetes-csi/csi-proxy).
        :param pulumi.Input['WindowsGmsaProfileArgs'] gmsa_profile: The Windows gMSA Profile in the Managed Cluster.
        :param pulumi.Input[Union[str, 'LicenseType']] license_type: The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if enable_csi_proxy is not None:
            pulumi.set(__self__, "enable_csi_proxy", enable_csi_proxy)
        if gmsa_profile is not None:
            pulumi.set(__self__, "gmsa_profile", gmsa_profile)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Input[str]:
        """
        Specifies the name of the administrator account. <br><br> **Restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="enableCSIProxy")
    def enable_csi_proxy(self) -> Optional[pulumi.Input[bool]]:
        """
        For more details on CSI proxy, see the [CSI proxy GitHub repo](https://github.com/kubernetes-csi/csi-proxy).
        """
        return pulumi.get(self, "enable_csi_proxy")

    @enable_csi_proxy.setter
    def enable_csi_proxy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_csi_proxy", value)

    @property
    @pulumi.getter(name="gmsaProfile")
    def gmsa_profile(self) -> Optional[pulumi.Input['WindowsGmsaProfileArgs']]:
        """
        The Windows gMSA Profile in the Managed Cluster.
        """
        return pulumi.get(self, "gmsa_profile")

    @gmsa_profile.setter
    def gmsa_profile(self, value: Optional[pulumi.Input['WindowsGmsaProfileArgs']]):
        pulumi.set(self, "gmsa_profile", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[Union[str, 'LicenseType']]]:
        """
        The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[Union[str, 'LicenseType']]]):
        pulumi.set(self, "license_type", value)


@pulumi.input_type
class ManagedClusterWorkloadAutoScalerProfileKedaArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
        :param pulumi.Input[bool] enabled: Whether to enable KEDA.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether to enable KEDA.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscalerArgs:
    def __init__(__self__, *,
                 controlled_values: pulumi.Input[Union[str, 'ControlledValues']],
                 enabled: pulumi.Input[bool],
                 update_mode: pulumi.Input[Union[str, 'UpdateMode']]):
        """
        :param pulumi.Input[Union[str, 'ControlledValues']] controlled_values: Controls which resource value autoscaler will change. Default value is RequestsAndLimits.
        :param pulumi.Input[bool] enabled: Whether to enable VPA. Default value is false.
        :param pulumi.Input[Union[str, 'UpdateMode']] update_mode: Each update mode level is a superset of the lower levels. Off<Initial<Recreate<=Auto. For example: if UpdateMode is Initial, it means VPA sets the recommended resources in the VerticalPodAutoscaler Custom Resource (from UpdateMode Off) and also assigns resources on pod creation (from Initial). The default value is Off.
        """
        if controlled_values is None:
            controlled_values = 'RequestsAndLimits'
        pulumi.set(__self__, "controlled_values", controlled_values)
        if enabled is None:
            enabled = False
        pulumi.set(__self__, "enabled", enabled)
        if update_mode is None:
            update_mode = 'Off'
        pulumi.set(__self__, "update_mode", update_mode)

    @property
    @pulumi.getter(name="controlledValues")
    def controlled_values(self) -> pulumi.Input[Union[str, 'ControlledValues']]:
        """
        Controls which resource value autoscaler will change. Default value is RequestsAndLimits.
        """
        return pulumi.get(self, "controlled_values")

    @controlled_values.setter
    def controlled_values(self, value: pulumi.Input[Union[str, 'ControlledValues']]):
        pulumi.set(self, "controlled_values", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether to enable VPA. Default value is false.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="updateMode")
    def update_mode(self) -> pulumi.Input[Union[str, 'UpdateMode']]:
        """
        Each update mode level is a superset of the lower levels. Off<Initial<Recreate<=Auto. For example: if UpdateMode is Initial, it means VPA sets the recommended resources in the VerticalPodAutoscaler Custom Resource (from UpdateMode Off) and also assigns resources on pod creation (from Initial). The default value is Off.
        """
        return pulumi.get(self, "update_mode")

    @update_mode.setter
    def update_mode(self, value: pulumi.Input[Union[str, 'UpdateMode']]):
        pulumi.set(self, "update_mode", value)


@pulumi.input_type
class ManagedClusterWorkloadAutoScalerProfileArgs:
    def __init__(__self__, *,
                 keda: Optional[pulumi.Input['ManagedClusterWorkloadAutoScalerProfileKedaArgs']] = None,
                 vertical_pod_autoscaler: Optional[pulumi.Input['ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscalerArgs']] = None):
        """
        Workload Auto-scaler profile for the container service cluster.
        :param pulumi.Input['ManagedClusterWorkloadAutoScalerProfileKedaArgs'] keda: KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
        """
        if keda is not None:
            pulumi.set(__self__, "keda", keda)
        if vertical_pod_autoscaler is not None:
            pulumi.set(__self__, "vertical_pod_autoscaler", vertical_pod_autoscaler)

    @property
    @pulumi.getter
    def keda(self) -> Optional[pulumi.Input['ManagedClusterWorkloadAutoScalerProfileKedaArgs']]:
        """
        KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
        """
        return pulumi.get(self, "keda")

    @keda.setter
    def keda(self, value: Optional[pulumi.Input['ManagedClusterWorkloadAutoScalerProfileKedaArgs']]):
        pulumi.set(self, "keda", value)

    @property
    @pulumi.getter(name="verticalPodAutoscaler")
    def vertical_pod_autoscaler(self) -> Optional[pulumi.Input['ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscalerArgs']]:
        return pulumi.get(self, "vertical_pod_autoscaler")

    @vertical_pod_autoscaler.setter
    def vertical_pod_autoscaler(self, value: Optional[pulumi.Input['ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscalerArgs']]):
        pulumi.set(self, "vertical_pod_autoscaler", value)


@pulumi.input_type
class PortRangeArgs:
    def __init__(__self__, *,
                 port_end: Optional[pulumi.Input[int]] = None,
                 port_start: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[Union[str, 'Protocol']]] = None):
        """
        The port range.
        :param pulumi.Input[int] port_end: The maximum port that is included in the range. It should be ranged from 1 to 65535, and be greater than or equal to portStart.
        :param pulumi.Input[int] port_start: The minimum port that is included in the range. It should be ranged from 1 to 65535, and be less than or equal to portEnd.
        :param pulumi.Input[Union[str, 'Protocol']] protocol: The network protocol of the port.
        """
        if port_end is not None:
            pulumi.set(__self__, "port_end", port_end)
        if port_start is not None:
            pulumi.set(__self__, "port_start", port_start)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="portEnd")
    def port_end(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum port that is included in the range. It should be ranged from 1 to 65535, and be greater than or equal to portStart.
        """
        return pulumi.get(self, "port_end")

    @port_end.setter
    def port_end(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_end", value)

    @property
    @pulumi.getter(name="portStart")
    def port_start(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum port that is included in the range. It should be ranged from 1 to 65535, and be less than or equal to portEnd.
        """
        return pulumi.get(self, "port_start")

    @port_start.setter
    def port_start(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_start", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[str, 'Protocol']]]:
        """
        The network protocol of the port.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[str, 'Protocol']]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class PowerStateArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[Union[str, 'Code']]] = None):
        """
        Describes the Power State of the cluster
        :param pulumi.Input[Union[str, 'Code']] code: Tells whether the cluster is Running or Stopped
        """
        if code is not None:
            pulumi.set(__self__, "code", code)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[Union[str, 'Code']]]:
        """
        Tells whether the cluster is Running or Stopped
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[Union[str, 'Code']]]):
        pulumi.set(self, "code", value)


@pulumi.input_type
class PrivateEndpointArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Private endpoint which a connection belongs to.
        :param pulumi.Input[str] id: The resource ID of the private endpoint
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the private endpoint
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PrivateLinkResourceArgs:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 required_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        A private link resource
        :param pulumi.Input[str] group_id: The group ID of the resource.
        :param pulumi.Input[str] id: The ID of the private link resource.
        :param pulumi.Input[str] name: The name of the private link resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] required_members: The RequiredMembers of the resource
        :param pulumi.Input[str] type: The resource type.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if required_members is not None:
            pulumi.set(__self__, "required_members", required_members)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The group ID of the resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the private link resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the private link resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="requiredMembers")
    def required_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The RequiredMembers of the resource
        """
        return pulumi.get(self, "required_members")

    @required_members.setter
    def required_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "required_members", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The resource type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'ConnectionStatus']]] = None):
        """
        The state of a private link service connection.
        :param pulumi.Input[str] description: The private link service connection description.
        :param pulumi.Input[Union[str, 'ConnectionStatus']] status: The private link service connection status.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'ConnectionStatus']]]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'ConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class RelativeMonthlyScheduleArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[Union[str, 'WeekDay']],
                 interval_months: pulumi.Input[int],
                 week_index: pulumi.Input[Union[str, 'Type']]):
        """
        For schedules like: 'recur every month on the first Monday' or 'recur every 3 months on last Friday'.
        :param pulumi.Input[Union[str, 'WeekDay']] day_of_week: Specifies on which day of the week the maintenance occurs.
        :param pulumi.Input[int] interval_months: Specifies the number of months between each set of occurrences.
        :param pulumi.Input[Union[str, 'Type']] week_index: Specifies on which instance of the allowed days specified in daysOfWeek the maintenance occurs.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "interval_months", interval_months)
        pulumi.set(__self__, "week_index", week_index)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[Union[str, 'WeekDay']]:
        """
        Specifies on which day of the week the maintenance occurs.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[Union[str, 'WeekDay']]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="intervalMonths")
    def interval_months(self) -> pulumi.Input[int]:
        """
        Specifies the number of months between each set of occurrences.
        """
        return pulumi.get(self, "interval_months")

    @interval_months.setter
    def interval_months(self, value: pulumi.Input[int]):
        pulumi.set(self, "interval_months", value)

    @property
    @pulumi.getter(name="weekIndex")
    def week_index(self) -> pulumi.Input[Union[str, 'Type']]:
        """
        Specifies on which instance of the allowed days specified in daysOfWeek the maintenance occurs.
        """
        return pulumi.get(self, "week_index")

    @week_index.setter
    def week_index(self, value: pulumi.Input[Union[str, 'Type']]):
        pulumi.set(self, "week_index", value)


@pulumi.input_type
class ResourceReferenceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        A reference to an Azure resource.
        :param pulumi.Input[str] id: The fully qualified Azure resource id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified Azure resource id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 absolute_monthly: Optional[pulumi.Input['AbsoluteMonthlyScheduleArgs']] = None,
                 daily: Optional[pulumi.Input['DailyScheduleArgs']] = None,
                 relative_monthly: Optional[pulumi.Input['RelativeMonthlyScheduleArgs']] = None,
                 weekly: Optional[pulumi.Input['WeeklyScheduleArgs']] = None):
        """
        One and only one of the schedule types should be specified. Choose either 'daily', 'weekly', 'absoluteMonthly' or 'relativeMonthly' for your maintenance schedule.
        :param pulumi.Input['AbsoluteMonthlyScheduleArgs'] absolute_monthly: For schedules like: 'recur every month on the 15th' or 'recur every 3 months on the 20th'.
        :param pulumi.Input['DailyScheduleArgs'] daily: For schedules like: 'recur every day' or 'recur every 3 days'.
        :param pulumi.Input['RelativeMonthlyScheduleArgs'] relative_monthly: For schedules like: 'recur every month on the first Monday' or 'recur every 3 months on last Friday'.
        :param pulumi.Input['WeeklyScheduleArgs'] weekly: For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'.
        """
        if absolute_monthly is not None:
            pulumi.set(__self__, "absolute_monthly", absolute_monthly)
        if daily is not None:
            pulumi.set(__self__, "daily", daily)
        if relative_monthly is not None:
            pulumi.set(__self__, "relative_monthly", relative_monthly)
        if weekly is not None:
            pulumi.set(__self__, "weekly", weekly)

    @property
    @pulumi.getter(name="absoluteMonthly")
    def absolute_monthly(self) -> Optional[pulumi.Input['AbsoluteMonthlyScheduleArgs']]:
        """
        For schedules like: 'recur every month on the 15th' or 'recur every 3 months on the 20th'.
        """
        return pulumi.get(self, "absolute_monthly")

    @absolute_monthly.setter
    def absolute_monthly(self, value: Optional[pulumi.Input['AbsoluteMonthlyScheduleArgs']]):
        pulumi.set(self, "absolute_monthly", value)

    @property
    @pulumi.getter
    def daily(self) -> Optional[pulumi.Input['DailyScheduleArgs']]:
        """
        For schedules like: 'recur every day' or 'recur every 3 days'.
        """
        return pulumi.get(self, "daily")

    @daily.setter
    def daily(self, value: Optional[pulumi.Input['DailyScheduleArgs']]):
        pulumi.set(self, "daily", value)

    @property
    @pulumi.getter(name="relativeMonthly")
    def relative_monthly(self) -> Optional[pulumi.Input['RelativeMonthlyScheduleArgs']]:
        """
        For schedules like: 'recur every month on the first Monday' or 'recur every 3 months on last Friday'.
        """
        return pulumi.get(self, "relative_monthly")

    @relative_monthly.setter
    def relative_monthly(self, value: Optional[pulumi.Input['RelativeMonthlyScheduleArgs']]):
        pulumi.set(self, "relative_monthly", value)

    @property
    @pulumi.getter
    def weekly(self) -> Optional[pulumi.Input['WeeklyScheduleArgs']]:
        """
        For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'.
        """
        return pulumi.get(self, "weekly")

    @weekly.setter
    def weekly(self, value: Optional[pulumi.Input['WeeklyScheduleArgs']]):
        pulumi.set(self, "weekly", value)


@pulumi.input_type
class SysctlConfigArgs:
    def __init__(__self__, *,
                 fs_aio_max_nr: Optional[pulumi.Input[int]] = None,
                 fs_file_max: Optional[pulumi.Input[int]] = None,
                 fs_inotify_max_user_watches: Optional[pulumi.Input[int]] = None,
                 fs_nr_open: Optional[pulumi.Input[int]] = None,
                 kernel_threads_max: Optional[pulumi.Input[int]] = None,
                 net_core_netdev_max_backlog: Optional[pulumi.Input[int]] = None,
                 net_core_optmem_max: Optional[pulumi.Input[int]] = None,
                 net_core_rmem_default: Optional[pulumi.Input[int]] = None,
                 net_core_rmem_max: Optional[pulumi.Input[int]] = None,
                 net_core_somaxconn: Optional[pulumi.Input[int]] = None,
                 net_core_wmem_default: Optional[pulumi.Input[int]] = None,
                 net_core_wmem_max: Optional[pulumi.Input[int]] = None,
                 net_ipv4_ip_local_port_range: Optional[pulumi.Input[str]] = None,
                 net_ipv4_neigh_default_gc_thresh1: Optional[pulumi.Input[int]] = None,
                 net_ipv4_neigh_default_gc_thresh2: Optional[pulumi.Input[int]] = None,
                 net_ipv4_neigh_default_gc_thresh3: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_fin_timeout: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_keepalive_probes: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_keepalive_time: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_max_syn_backlog: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_max_tw_buckets: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_tw_reuse: Optional[pulumi.Input[bool]] = None,
                 net_ipv4_tcpkeepalive_intvl: Optional[pulumi.Input[int]] = None,
                 net_netfilter_nf_conntrack_buckets: Optional[pulumi.Input[int]] = None,
                 net_netfilter_nf_conntrack_max: Optional[pulumi.Input[int]] = None,
                 vm_max_map_count: Optional[pulumi.Input[int]] = None,
                 vm_swappiness: Optional[pulumi.Input[int]] = None,
                 vm_vfs_cache_pressure: Optional[pulumi.Input[int]] = None):
        """
        Sysctl settings for Linux agent nodes.
        :param pulumi.Input[int] fs_aio_max_nr: Sysctl setting fs.aio-max-nr.
        :param pulumi.Input[int] fs_file_max: Sysctl setting fs.file-max.
        :param pulumi.Input[int] fs_inotify_max_user_watches: Sysctl setting fs.inotify.max_user_watches.
        :param pulumi.Input[int] fs_nr_open: Sysctl setting fs.nr_open.
        :param pulumi.Input[int] kernel_threads_max: Sysctl setting kernel.threads-max.
        :param pulumi.Input[int] net_core_netdev_max_backlog: Sysctl setting net.core.netdev_max_backlog.
        :param pulumi.Input[int] net_core_optmem_max: Sysctl setting net.core.optmem_max.
        :param pulumi.Input[int] net_core_rmem_default: Sysctl setting net.core.rmem_default.
        :param pulumi.Input[int] net_core_rmem_max: Sysctl setting net.core.rmem_max.
        :param pulumi.Input[int] net_core_somaxconn: Sysctl setting net.core.somaxconn.
        :param pulumi.Input[int] net_core_wmem_default: Sysctl setting net.core.wmem_default.
        :param pulumi.Input[int] net_core_wmem_max: Sysctl setting net.core.wmem_max.
        :param pulumi.Input[str] net_ipv4_ip_local_port_range: Sysctl setting net.ipv4.ip_local_port_range.
        :param pulumi.Input[int] net_ipv4_neigh_default_gc_thresh1: Sysctl setting net.ipv4.neigh.default.gc_thresh1.
        :param pulumi.Input[int] net_ipv4_neigh_default_gc_thresh2: Sysctl setting net.ipv4.neigh.default.gc_thresh2.
        :param pulumi.Input[int] net_ipv4_neigh_default_gc_thresh3: Sysctl setting net.ipv4.neigh.default.gc_thresh3.
        :param pulumi.Input[int] net_ipv4_tcp_fin_timeout: Sysctl setting net.ipv4.tcp_fin_timeout.
        :param pulumi.Input[int] net_ipv4_tcp_keepalive_probes: Sysctl setting net.ipv4.tcp_keepalive_probes.
        :param pulumi.Input[int] net_ipv4_tcp_keepalive_time: Sysctl setting net.ipv4.tcp_keepalive_time.
        :param pulumi.Input[int] net_ipv4_tcp_max_syn_backlog: Sysctl setting net.ipv4.tcp_max_syn_backlog.
        :param pulumi.Input[int] net_ipv4_tcp_max_tw_buckets: Sysctl setting net.ipv4.tcp_max_tw_buckets.
        :param pulumi.Input[bool] net_ipv4_tcp_tw_reuse: Sysctl setting net.ipv4.tcp_tw_reuse.
        :param pulumi.Input[int] net_ipv4_tcpkeepalive_intvl: Sysctl setting net.ipv4.tcp_keepalive_intvl.
        :param pulumi.Input[int] net_netfilter_nf_conntrack_buckets: Sysctl setting net.netfilter.nf_conntrack_buckets.
        :param pulumi.Input[int] net_netfilter_nf_conntrack_max: Sysctl setting net.netfilter.nf_conntrack_max.
        :param pulumi.Input[int] vm_max_map_count: Sysctl setting vm.max_map_count.
        :param pulumi.Input[int] vm_swappiness: Sysctl setting vm.swappiness.
        :param pulumi.Input[int] vm_vfs_cache_pressure: Sysctl setting vm.vfs_cache_pressure.
        """
        if fs_aio_max_nr is not None:
            pulumi.set(__self__, "fs_aio_max_nr", fs_aio_max_nr)
        if fs_file_max is not None:
            pulumi.set(__self__, "fs_file_max", fs_file_max)
        if fs_inotify_max_user_watches is not None:
            pulumi.set(__self__, "fs_inotify_max_user_watches", fs_inotify_max_user_watches)
        if fs_nr_open is not None:
            pulumi.set(__self__, "fs_nr_open", fs_nr_open)
        if kernel_threads_max is not None:
            pulumi.set(__self__, "kernel_threads_max", kernel_threads_max)
        if net_core_netdev_max_backlog is not None:
            pulumi.set(__self__, "net_core_netdev_max_backlog", net_core_netdev_max_backlog)
        if net_core_optmem_max is not None:
            pulumi.set(__self__, "net_core_optmem_max", net_core_optmem_max)
        if net_core_rmem_default is not None:
            pulumi.set(__self__, "net_core_rmem_default", net_core_rmem_default)
        if net_core_rmem_max is not None:
            pulumi.set(__self__, "net_core_rmem_max", net_core_rmem_max)
        if net_core_somaxconn is not None:
            pulumi.set(__self__, "net_core_somaxconn", net_core_somaxconn)
        if net_core_wmem_default is not None:
            pulumi.set(__self__, "net_core_wmem_default", net_core_wmem_default)
        if net_core_wmem_max is not None:
            pulumi.set(__self__, "net_core_wmem_max", net_core_wmem_max)
        if net_ipv4_ip_local_port_range is not None:
            pulumi.set(__self__, "net_ipv4_ip_local_port_range", net_ipv4_ip_local_port_range)
        if net_ipv4_neigh_default_gc_thresh1 is not None:
            pulumi.set(__self__, "net_ipv4_neigh_default_gc_thresh1", net_ipv4_neigh_default_gc_thresh1)
        if net_ipv4_neigh_default_gc_thresh2 is not None:
            pulumi.set(__self__, "net_ipv4_neigh_default_gc_thresh2", net_ipv4_neigh_default_gc_thresh2)
        if net_ipv4_neigh_default_gc_thresh3 is not None:
            pulumi.set(__self__, "net_ipv4_neigh_default_gc_thresh3", net_ipv4_neigh_default_gc_thresh3)
        if net_ipv4_tcp_fin_timeout is not None:
            pulumi.set(__self__, "net_ipv4_tcp_fin_timeout", net_ipv4_tcp_fin_timeout)
        if net_ipv4_tcp_keepalive_probes is not None:
            pulumi.set(__self__, "net_ipv4_tcp_keepalive_probes", net_ipv4_tcp_keepalive_probes)
        if net_ipv4_tcp_keepalive_time is not None:
            pulumi.set(__self__, "net_ipv4_tcp_keepalive_time", net_ipv4_tcp_keepalive_time)
        if net_ipv4_tcp_max_syn_backlog is not None:
            pulumi.set(__self__, "net_ipv4_tcp_max_syn_backlog", net_ipv4_tcp_max_syn_backlog)
        if net_ipv4_tcp_max_tw_buckets is not None:
            pulumi.set(__self__, "net_ipv4_tcp_max_tw_buckets", net_ipv4_tcp_max_tw_buckets)
        if net_ipv4_tcp_tw_reuse is not None:
            pulumi.set(__self__, "net_ipv4_tcp_tw_reuse", net_ipv4_tcp_tw_reuse)
        if net_ipv4_tcpkeepalive_intvl is not None:
            pulumi.set(__self__, "net_ipv4_tcpkeepalive_intvl", net_ipv4_tcpkeepalive_intvl)
        if net_netfilter_nf_conntrack_buckets is not None:
            pulumi.set(__self__, "net_netfilter_nf_conntrack_buckets", net_netfilter_nf_conntrack_buckets)
        if net_netfilter_nf_conntrack_max is not None:
            pulumi.set(__self__, "net_netfilter_nf_conntrack_max", net_netfilter_nf_conntrack_max)
        if vm_max_map_count is not None:
            pulumi.set(__self__, "vm_max_map_count", vm_max_map_count)
        if vm_swappiness is not None:
            pulumi.set(__self__, "vm_swappiness", vm_swappiness)
        if vm_vfs_cache_pressure is not None:
            pulumi.set(__self__, "vm_vfs_cache_pressure", vm_vfs_cache_pressure)

    @property
    @pulumi.getter(name="fsAioMaxNr")
    def fs_aio_max_nr(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting fs.aio-max-nr.
        """
        return pulumi.get(self, "fs_aio_max_nr")

    @fs_aio_max_nr.setter
    def fs_aio_max_nr(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fs_aio_max_nr", value)

    @property
    @pulumi.getter(name="fsFileMax")
    def fs_file_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting fs.file-max.
        """
        return pulumi.get(self, "fs_file_max")

    @fs_file_max.setter
    def fs_file_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fs_file_max", value)

    @property
    @pulumi.getter(name="fsInotifyMaxUserWatches")
    def fs_inotify_max_user_watches(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting fs.inotify.max_user_watches.
        """
        return pulumi.get(self, "fs_inotify_max_user_watches")

    @fs_inotify_max_user_watches.setter
    def fs_inotify_max_user_watches(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fs_inotify_max_user_watches", value)

    @property
    @pulumi.getter(name="fsNrOpen")
    def fs_nr_open(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting fs.nr_open.
        """
        return pulumi.get(self, "fs_nr_open")

    @fs_nr_open.setter
    def fs_nr_open(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fs_nr_open", value)

    @property
    @pulumi.getter(name="kernelThreadsMax")
    def kernel_threads_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting kernel.threads-max.
        """
        return pulumi.get(self, "kernel_threads_max")

    @kernel_threads_max.setter
    def kernel_threads_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "kernel_threads_max", value)

    @property
    @pulumi.getter(name="netCoreNetdevMaxBacklog")
    def net_core_netdev_max_backlog(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.netdev_max_backlog.
        """
        return pulumi.get(self, "net_core_netdev_max_backlog")

    @net_core_netdev_max_backlog.setter
    def net_core_netdev_max_backlog(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_netdev_max_backlog", value)

    @property
    @pulumi.getter(name="netCoreOptmemMax")
    def net_core_optmem_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.optmem_max.
        """
        return pulumi.get(self, "net_core_optmem_max")

    @net_core_optmem_max.setter
    def net_core_optmem_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_optmem_max", value)

    @property
    @pulumi.getter(name="netCoreRmemDefault")
    def net_core_rmem_default(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.rmem_default.
        """
        return pulumi.get(self, "net_core_rmem_default")

    @net_core_rmem_default.setter
    def net_core_rmem_default(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_rmem_default", value)

    @property
    @pulumi.getter(name="netCoreRmemMax")
    def net_core_rmem_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.rmem_max.
        """
        return pulumi.get(self, "net_core_rmem_max")

    @net_core_rmem_max.setter
    def net_core_rmem_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_rmem_max", value)

    @property
    @pulumi.getter(name="netCoreSomaxconn")
    def net_core_somaxconn(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.somaxconn.
        """
        return pulumi.get(self, "net_core_somaxconn")

    @net_core_somaxconn.setter
    def net_core_somaxconn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_somaxconn", value)

    @property
    @pulumi.getter(name="netCoreWmemDefault")
    def net_core_wmem_default(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.wmem_default.
        """
        return pulumi.get(self, "net_core_wmem_default")

    @net_core_wmem_default.setter
    def net_core_wmem_default(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_wmem_default", value)

    @property
    @pulumi.getter(name="netCoreWmemMax")
    def net_core_wmem_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.wmem_max.
        """
        return pulumi.get(self, "net_core_wmem_max")

    @net_core_wmem_max.setter
    def net_core_wmem_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_wmem_max", value)

    @property
    @pulumi.getter(name="netIpv4IpLocalPortRange")
    def net_ipv4_ip_local_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Sysctl setting net.ipv4.ip_local_port_range.
        """
        return pulumi.get(self, "net_ipv4_ip_local_port_range")

    @net_ipv4_ip_local_port_range.setter
    def net_ipv4_ip_local_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_ipv4_ip_local_port_range", value)

    @property
    @pulumi.getter(name="netIpv4NeighDefaultGcThresh1")
    def net_ipv4_neigh_default_gc_thresh1(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.neigh.default.gc_thresh1.
        """
        return pulumi.get(self, "net_ipv4_neigh_default_gc_thresh1")

    @net_ipv4_neigh_default_gc_thresh1.setter
    def net_ipv4_neigh_default_gc_thresh1(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_neigh_default_gc_thresh1", value)

    @property
    @pulumi.getter(name="netIpv4NeighDefaultGcThresh2")
    def net_ipv4_neigh_default_gc_thresh2(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.neigh.default.gc_thresh2.
        """
        return pulumi.get(self, "net_ipv4_neigh_default_gc_thresh2")

    @net_ipv4_neigh_default_gc_thresh2.setter
    def net_ipv4_neigh_default_gc_thresh2(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_neigh_default_gc_thresh2", value)

    @property
    @pulumi.getter(name="netIpv4NeighDefaultGcThresh3")
    def net_ipv4_neigh_default_gc_thresh3(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.neigh.default.gc_thresh3.
        """
        return pulumi.get(self, "net_ipv4_neigh_default_gc_thresh3")

    @net_ipv4_neigh_default_gc_thresh3.setter
    def net_ipv4_neigh_default_gc_thresh3(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_neigh_default_gc_thresh3", value)

    @property
    @pulumi.getter(name="netIpv4TcpFinTimeout")
    def net_ipv4_tcp_fin_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_fin_timeout.
        """
        return pulumi.get(self, "net_ipv4_tcp_fin_timeout")

    @net_ipv4_tcp_fin_timeout.setter
    def net_ipv4_tcp_fin_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcp_fin_timeout", value)

    @property
    @pulumi.getter(name="netIpv4TcpKeepaliveProbes")
    def net_ipv4_tcp_keepalive_probes(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_keepalive_probes.
        """
        return pulumi.get(self, "net_ipv4_tcp_keepalive_probes")

    @net_ipv4_tcp_keepalive_probes.setter
    def net_ipv4_tcp_keepalive_probes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcp_keepalive_probes", value)

    @property
    @pulumi.getter(name="netIpv4TcpKeepaliveTime")
    def net_ipv4_tcp_keepalive_time(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_keepalive_time.
        """
        return pulumi.get(self, "net_ipv4_tcp_keepalive_time")

    @net_ipv4_tcp_keepalive_time.setter
    def net_ipv4_tcp_keepalive_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcp_keepalive_time", value)

    @property
    @pulumi.getter(name="netIpv4TcpMaxSynBacklog")
    def net_ipv4_tcp_max_syn_backlog(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_max_syn_backlog.
        """
        return pulumi.get(self, "net_ipv4_tcp_max_syn_backlog")

    @net_ipv4_tcp_max_syn_backlog.setter
    def net_ipv4_tcp_max_syn_backlog(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcp_max_syn_backlog", value)

    @property
    @pulumi.getter(name="netIpv4TcpMaxTwBuckets")
    def net_ipv4_tcp_max_tw_buckets(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_max_tw_buckets.
        """
        return pulumi.get(self, "net_ipv4_tcp_max_tw_buckets")

    @net_ipv4_tcp_max_tw_buckets.setter
    def net_ipv4_tcp_max_tw_buckets(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcp_max_tw_buckets", value)

    @property
    @pulumi.getter(name="netIpv4TcpTwReuse")
    def net_ipv4_tcp_tw_reuse(self) -> Optional[pulumi.Input[bool]]:
        """
        Sysctl setting net.ipv4.tcp_tw_reuse.
        """
        return pulumi.get(self, "net_ipv4_tcp_tw_reuse")

    @net_ipv4_tcp_tw_reuse.setter
    def net_ipv4_tcp_tw_reuse(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "net_ipv4_tcp_tw_reuse", value)

    @property
    @pulumi.getter(name="netIpv4TcpkeepaliveIntvl")
    def net_ipv4_tcpkeepalive_intvl(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_keepalive_intvl.
        """
        return pulumi.get(self, "net_ipv4_tcpkeepalive_intvl")

    @net_ipv4_tcpkeepalive_intvl.setter
    def net_ipv4_tcpkeepalive_intvl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcpkeepalive_intvl", value)

    @property
    @pulumi.getter(name="netNetfilterNfConntrackBuckets")
    def net_netfilter_nf_conntrack_buckets(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.netfilter.nf_conntrack_buckets.
        """
        return pulumi.get(self, "net_netfilter_nf_conntrack_buckets")

    @net_netfilter_nf_conntrack_buckets.setter
    def net_netfilter_nf_conntrack_buckets(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_netfilter_nf_conntrack_buckets", value)

    @property
    @pulumi.getter(name="netNetfilterNfConntrackMax")
    def net_netfilter_nf_conntrack_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.netfilter.nf_conntrack_max.
        """
        return pulumi.get(self, "net_netfilter_nf_conntrack_max")

    @net_netfilter_nf_conntrack_max.setter
    def net_netfilter_nf_conntrack_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_netfilter_nf_conntrack_max", value)

    @property
    @pulumi.getter(name="vmMaxMapCount")
    def vm_max_map_count(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting vm.max_map_count.
        """
        return pulumi.get(self, "vm_max_map_count")

    @vm_max_map_count.setter
    def vm_max_map_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vm_max_map_count", value)

    @property
    @pulumi.getter(name="vmSwappiness")
    def vm_swappiness(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting vm.swappiness.
        """
        return pulumi.get(self, "vm_swappiness")

    @vm_swappiness.setter
    def vm_swappiness(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vm_swappiness", value)

    @property
    @pulumi.getter(name="vmVfsCachePressure")
    def vm_vfs_cache_pressure(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting vm.vfs_cache_pressure.
        """
        return pulumi.get(self, "vm_vfs_cache_pressure")

    @vm_vfs_cache_pressure.setter
    def vm_vfs_cache_pressure(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vm_vfs_cache_pressure", value)


@pulumi.input_type
class TimeInWeekArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[Union[str, 'WeekDay']]] = None,
                 hour_slots: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Time in a week.
        :param pulumi.Input[Union[str, 'WeekDay']] day: The day of the week.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] hour_slots: Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour_slots is not None:
            pulumi.set(__self__, "hour_slots", hour_slots)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[Union[str, 'WeekDay']]]:
        """
        The day of the week.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[Union[str, 'WeekDay']]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter(name="hourSlots")
    def hour_slots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
        """
        return pulumi.get(self, "hour_slots")

    @hour_slots.setter
    def hour_slots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "hour_slots", value)


@pulumi.input_type
class TimeSpanArgs:
    def __init__(__self__, *,
                 end: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        For example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.
        :param pulumi.Input[str] end: The end of a time span
        :param pulumi.Input[str] start: The start of a time span
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        The end of a time span
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        The start of a time span
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class UserAssignedIdentityArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Details about a user assigned identity.
        :param pulumi.Input[str] client_id: The client ID of the user assigned identity.
        :param pulumi.Input[str] object_id: The object ID of the user assigned identity.
        :param pulumi.Input[str] resource_id: The resource ID of the user assigned identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client ID of the user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object ID of the user assigned identity.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the user assigned identity.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class WeeklyScheduleArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[Union[str, 'WeekDay']],
                 interval_weeks: pulumi.Input[int]):
        """
        For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'.
        :param pulumi.Input[Union[str, 'WeekDay']] day_of_week: Specifies on which day of the week the maintenance occurs.
        :param pulumi.Input[int] interval_weeks: Specifies the number of weeks between each set of occurrences.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "interval_weeks", interval_weeks)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[Union[str, 'WeekDay']]:
        """
        Specifies on which day of the week the maintenance occurs.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[Union[str, 'WeekDay']]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="intervalWeeks")
    def interval_weeks(self) -> pulumi.Input[int]:
        """
        Specifies the number of weeks between each set of occurrences.
        """
        return pulumi.get(self, "interval_weeks")

    @interval_weeks.setter
    def interval_weeks(self, value: pulumi.Input[int]):
        pulumi.set(self, "interval_weeks", value)


@pulumi.input_type
class WindowsGmsaProfileArgs:
    def __init__(__self__, *,
                 dns_server: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 root_domain_name: Optional[pulumi.Input[str]] = None):
        """
        Windows gMSA Profile in the managed cluster.
        :param pulumi.Input[str] dns_server: Specifies the DNS server for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
        :param pulumi.Input[bool] enabled: Specifies whether to enable Windows gMSA in the managed cluster.
        :param pulumi.Input[str] root_domain_name: Specifies the root domain name for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
        """
        if dns_server is not None:
            pulumi.set(__self__, "dns_server", dns_server)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if root_domain_name is not None:
            pulumi.set(__self__, "root_domain_name", root_domain_name)

    @property
    @pulumi.getter(name="dnsServer")
    def dns_server(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DNS server for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
        """
        return pulumi.get(self, "dns_server")

    @dns_server.setter
    def dns_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_server", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable Windows gMSA in the managed cluster.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="rootDomainName")
    def root_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the root domain name for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
        """
        return pulumi.get(self, "root_domain_name")

    @root_domain_name.setter
    def root_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_domain_name", value)


