# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['WorkflowArgs', 'Workflow']

@pulumi.input_type
class WorkflowArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 acr: Optional[pulumi.Input['ACRArgs']] = None,
                 aks_resource_id: Optional[pulumi.Input[str]] = None,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 deployment_properties: Optional[pulumi.Input['DeploymentPropertiesArgs']] = None,
                 docker_build_context: Optional[pulumi.Input[str]] = None,
                 dockerfile: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 oidc_credentials: Optional[pulumi.Input['GitHubWorkflowProfileOidcCredentialsArgs']] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 repository_owner: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 workflow_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Workflow resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input['ACRArgs'] acr: Information on the azure container registry
        :param pulumi.Input[str] aks_resource_id: The Azure Kubernetes Cluster Resource the application will be deployed to.
        :param pulumi.Input[str] branch_name: Repository Branch Name
        :param pulumi.Input[str] docker_build_context: Path to Dockerfile Build Context within the repository.
        :param pulumi.Input[str] dockerfile: Path to the Dockerfile within the repository.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] namespace: Kubernetes namespace the application is deployed to.
        :param pulumi.Input['GitHubWorkflowProfileOidcCredentialsArgs'] oidc_credentials: The fields needed for OIDC with GitHub.
        :param pulumi.Input[str] repository_name: Repository Name
        :param pulumi.Input[str] repository_owner: Repository Owner
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] workflow_name: The name of the workflow resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if acr is not None:
            pulumi.set(__self__, "acr", acr)
        if aks_resource_id is not None:
            pulumi.set(__self__, "aks_resource_id", aks_resource_id)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if deployment_properties is not None:
            pulumi.set(__self__, "deployment_properties", deployment_properties)
        if docker_build_context is not None:
            pulumi.set(__self__, "docker_build_context", docker_build_context)
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if oidc_credentials is not None:
            pulumi.set(__self__, "oidc_credentials", oidc_credentials)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if repository_owner is not None:
            pulumi.set(__self__, "repository_owner", repository_owner)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workflow_name is not None:
            pulumi.set(__self__, "workflow_name", workflow_name)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def acr(self) -> Optional[pulumi.Input['ACRArgs']]:
        """
        Information on the azure container registry
        """
        return pulumi.get(self, "acr")

    @acr.setter
    def acr(self, value: Optional[pulumi.Input['ACRArgs']]):
        pulumi.set(self, "acr", value)

    @property
    @pulumi.getter(name="aksResourceId")
    def aks_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Kubernetes Cluster Resource the application will be deployed to.
        """
        return pulumi.get(self, "aks_resource_id")

    @aks_resource_id.setter
    def aks_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aks_resource_id", value)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[str]]:
        """
        Repository Branch Name
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="deploymentProperties")
    def deployment_properties(self) -> Optional[pulumi.Input['DeploymentPropertiesArgs']]:
        return pulumi.get(self, "deployment_properties")

    @deployment_properties.setter
    def deployment_properties(self, value: Optional[pulumi.Input['DeploymentPropertiesArgs']]):
        pulumi.set(self, "deployment_properties", value)

    @property
    @pulumi.getter(name="dockerBuildContext")
    def docker_build_context(self) -> Optional[pulumi.Input[str]]:
        """
        Path to Dockerfile Build Context within the repository.
        """
        return pulumi.get(self, "docker_build_context")

    @docker_build_context.setter
    def docker_build_context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_build_context", value)

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the Dockerfile within the repository.
        """
        return pulumi.get(self, "dockerfile")

    @dockerfile.setter
    def dockerfile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dockerfile", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Kubernetes namespace the application is deployed to.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="oidcCredentials")
    def oidc_credentials(self) -> Optional[pulumi.Input['GitHubWorkflowProfileOidcCredentialsArgs']]:
        """
        The fields needed for OIDC with GitHub.
        """
        return pulumi.get(self, "oidc_credentials")

    @oidc_credentials.setter
    def oidc_credentials(self, value: Optional[pulumi.Input['GitHubWorkflowProfileOidcCredentialsArgs']]):
        pulumi.set(self, "oidc_credentials", value)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[pulumi.Input[str]]:
        """
        Repository Name
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter(name="repositoryOwner")
    def repository_owner(self) -> Optional[pulumi.Input[str]]:
        """
        Repository Owner
        """
        return pulumi.get(self, "repository_owner")

    @repository_owner.setter
    def repository_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_owner", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="workflowName")
    def workflow_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the workflow resource.
        """
        return pulumi.get(self, "workflow_name")

    @workflow_name.setter
    def workflow_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workflow_name", value)


class Workflow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr: Optional[pulumi.Input[pulumi.InputType['ACRArgs']]] = None,
                 aks_resource_id: Optional[pulumi.Input[str]] = None,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 deployment_properties: Optional[pulumi.Input[pulumi.InputType['DeploymentPropertiesArgs']]] = None,
                 docker_build_context: Optional[pulumi.Input[str]] = None,
                 dockerfile: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 oidc_credentials: Optional[pulumi.Input[pulumi.InputType['GitHubWorkflowProfileOidcCredentialsArgs']]] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 repository_owner: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 workflow_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource representation of a workflow

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ACRArgs']] acr: Information on the azure container registry
        :param pulumi.Input[str] aks_resource_id: The Azure Kubernetes Cluster Resource the application will be deployed to.
        :param pulumi.Input[str] branch_name: Repository Branch Name
        :param pulumi.Input[str] docker_build_context: Path to Dockerfile Build Context within the repository.
        :param pulumi.Input[str] dockerfile: Path to the Dockerfile within the repository.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] namespace: Kubernetes namespace the application is deployed to.
        :param pulumi.Input[pulumi.InputType['GitHubWorkflowProfileOidcCredentialsArgs']] oidc_credentials: The fields needed for OIDC with GitHub.
        :param pulumi.Input[str] repository_name: Repository Name
        :param pulumi.Input[str] repository_owner: Repository Owner
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] workflow_name: The name of the workflow resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkflowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource representation of a workflow

        :param str resource_name: The name of the resource.
        :param WorkflowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkflowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr: Optional[pulumi.Input[pulumi.InputType['ACRArgs']]] = None,
                 aks_resource_id: Optional[pulumi.Input[str]] = None,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 deployment_properties: Optional[pulumi.Input[pulumi.InputType['DeploymentPropertiesArgs']]] = None,
                 docker_build_context: Optional[pulumi.Input[str]] = None,
                 dockerfile: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 oidc_credentials: Optional[pulumi.Input[pulumi.InputType['GitHubWorkflowProfileOidcCredentialsArgs']]] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 repository_owner: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 workflow_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkflowArgs.__new__(WorkflowArgs)

            __props__.__dict__["acr"] = acr
            __props__.__dict__["aks_resource_id"] = aks_resource_id
            __props__.__dict__["branch_name"] = branch_name
            __props__.__dict__["deployment_properties"] = deployment_properties
            __props__.__dict__["docker_build_context"] = docker_build_context
            __props__.__dict__["dockerfile"] = dockerfile
            __props__.__dict__["location"] = location
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["oidc_credentials"] = oidc_credentials
            __props__.__dict__["repository_name"] = repository_name
            __props__.__dict__["repository_owner"] = repository_owner
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["workflow_name"] = workflow_name
            __props__.__dict__["auth_status"] = None
            __props__.__dict__["last_workflow_run"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pr_status"] = None
            __props__.__dict__["pr_url"] = None
            __props__.__dict__["pull_number"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:devhub:Workflow")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Workflow, __self__).__init__(
            'azure-native:devhub/v20220401preview:Workflow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Workflow':
        """
        Get an existing Workflow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WorkflowArgs.__new__(WorkflowArgs)

        __props__.__dict__["acr"] = None
        __props__.__dict__["aks_resource_id"] = None
        __props__.__dict__["auth_status"] = None
        __props__.__dict__["branch_name"] = None
        __props__.__dict__["deployment_properties"] = None
        __props__.__dict__["docker_build_context"] = None
        __props__.__dict__["dockerfile"] = None
        __props__.__dict__["last_workflow_run"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["namespace"] = None
        __props__.__dict__["oidc_credentials"] = None
        __props__.__dict__["pr_status"] = None
        __props__.__dict__["pr_url"] = None
        __props__.__dict__["pull_number"] = None
        __props__.__dict__["repository_name"] = None
        __props__.__dict__["repository_owner"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return Workflow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acr(self) -> pulumi.Output[Optional['outputs.ACRResponse']]:
        """
        Information on the azure container registry
        """
        return pulumi.get(self, "acr")

    @property
    @pulumi.getter(name="aksResourceId")
    def aks_resource_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Azure Kubernetes Cluster Resource the application will be deployed to.
        """
        return pulumi.get(self, "aks_resource_id")

    @property
    @pulumi.getter(name="authStatus")
    def auth_status(self) -> pulumi.Output[str]:
        """
        Determines the authorization status of requests.
        """
        return pulumi.get(self, "auth_status")

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> pulumi.Output[Optional[str]]:
        """
        Repository Branch Name
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="deploymentProperties")
    def deployment_properties(self) -> pulumi.Output[Optional['outputs.DeploymentPropertiesResponse']]:
        return pulumi.get(self, "deployment_properties")

    @property
    @pulumi.getter(name="dockerBuildContext")
    def docker_build_context(self) -> pulumi.Output[Optional[str]]:
        """
        Path to Dockerfile Build Context within the repository.
        """
        return pulumi.get(self, "docker_build_context")

    @property
    @pulumi.getter
    def dockerfile(self) -> pulumi.Output[Optional[str]]:
        """
        Path to the Dockerfile within the repository.
        """
        return pulumi.get(self, "dockerfile")

    @property
    @pulumi.getter(name="lastWorkflowRun")
    def last_workflow_run(self) -> pulumi.Output[Optional['outputs.WorkflowRunResponse']]:
        return pulumi.get(self, "last_workflow_run")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        Kubernetes namespace the application is deployed to.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="oidcCredentials")
    def oidc_credentials(self) -> pulumi.Output[Optional['outputs.GitHubWorkflowProfileResponseOidcCredentials']]:
        """
        The fields needed for OIDC with GitHub.
        """
        return pulumi.get(self, "oidc_credentials")

    @property
    @pulumi.getter(name="prStatus")
    def pr_status(self) -> pulumi.Output[str]:
        """
        The status of the Pull Request submitted against the users repository.
        """
        return pulumi.get(self, "pr_status")

    @property
    @pulumi.getter(name="prURL")
    def pr_url(self) -> pulumi.Output[str]:
        """
        The URL to the Pull Request submitted against the users repository.
        """
        return pulumi.get(self, "pr_url")

    @property
    @pulumi.getter(name="pullNumber")
    def pull_number(self) -> pulumi.Output[int]:
        """
        The number associated with the submitted pull request.
        """
        return pulumi.get(self, "pull_number")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> pulumi.Output[Optional[str]]:
        """
        Repository Name
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter(name="repositoryOwner")
    def repository_owner(self) -> pulumi.Output[Optional[str]]:
        """
        Repository Owner
        """
        return pulumi.get(self, "repository_owner")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

