# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CmkKekIdentityResponse',
    'CmkKeyVaultPropertiesResponse',
    'IdentityDataResponse',
    'PrivateEndpointConnectionVaultPropertiesResponse',
    'PrivateEndpointResponse',
    'SkuResponse',
    'SystemDataResponse',
    'UpgradeDetailsResponse',
    'UserIdentityResponse',
    'VaultPrivateEndpointConnectionResponse',
    'VaultPrivateLinkServiceConnectionStateResponse',
    'VaultPropertiesResponse',
    'VaultPropertiesResponseEncryption',
    'VaultPropertiesResponseMoveDetails',
]

@pulumi.output_type
class CmkKekIdentityResponse(dict):
    """
    The details of the identity used for CMK
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useSystemAssignedIdentity":
            suggest = "use_system_assigned_identity"
        elif key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CmkKekIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CmkKekIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CmkKekIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_system_assigned_identity: Optional[bool] = None,
                 user_assigned_identity: Optional[str] = None):
        """
        The details of the identity used for CMK
        :param bool use_system_assigned_identity: Indicate that system assigned identity should be used. Mutually exclusive with 'userAssignedIdentity' field
        :param str user_assigned_identity: The user assigned identity to be used to grant permissions in case the type of identity used is UserAssigned
        """
        if use_system_assigned_identity is not None:
            pulumi.set(__self__, "use_system_assigned_identity", use_system_assigned_identity)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="useSystemAssignedIdentity")
    def use_system_assigned_identity(self) -> Optional[bool]:
        """
        Indicate that system assigned identity should be used. Mutually exclusive with 'userAssignedIdentity' field
        """
        return pulumi.get(self, "use_system_assigned_identity")

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[str]:
        """
        The user assigned identity to be used to grant permissions in case the type of identity used is UserAssigned
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class CmkKeyVaultPropertiesResponse(dict):
    """
    The properties of the Key Vault which hosts CMK
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUri":
            suggest = "key_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CmkKeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CmkKeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CmkKeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_uri: Optional[str] = None):
        """
        The properties of the Key Vault which hosts CMK
        :param str key_uri: The key uri of the Customer Managed Key
        """
        if key_uri is not None:
            pulumi.set(__self__, "key_uri", key_uri)

    @property
    @pulumi.getter(name="keyUri")
    def key_uri(self) -> Optional[str]:
        """
        The key uri of the Customer Managed Key
        """
        return pulumi.get(self, "key_uri")


@pulumi.output_type
class IdentityDataResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserIdentityResponse']] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
        :param Mapping[str, 'UserIdentityResponse'] user_assigned_identities: The list of user-assigned identities associated with the resource. The user-assigned identity dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identities.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserIdentityResponse']]:
        """
        The list of user-assigned identities associated with the resource. The user-assigned identity dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class PrivateEndpointConnectionVaultPropertiesResponse(dict):
    """
    Information to be stored in Vault properties as an element of privateEndpointConnections List.
    """
    def __init__(__self__, *,
                 id: str,
                 location: str,
                 name: str,
                 properties: 'outputs.VaultPrivateEndpointConnectionResponse',
                 type: str):
        """
        Information to be stored in Vault properties as an element of privateEndpointConnections List.
        :param str id: Format of id subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
        :param str location: The location of the private Endpoint connection
        :param str name: The name of the private Endpoint Connection
        :param 'VaultPrivateEndpointConnectionResponse' properties: Private Endpoint Connection Response Properties.
        :param str type: The type, which will be of the format, Microsoft.RecoveryServices/vaults/privateEndpointConnections
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Format of id subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location of the private Endpoint connection
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the private Endpoint Connection
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.VaultPrivateEndpointConnectionResponse':
        """
        Private Endpoint Connection Response Properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type, which will be of the format, Microsoft.RecoveryServices/vaults/privateEndpointConnections
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint network resource that is linked to the Private Endpoint connection.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint network resource that is linked to the Private Endpoint connection.
        :param str id: Gets or sets id.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets or sets id.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class SkuResponse(dict):
    """
    Identifies the unique system identifier for each Azure resource.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[str] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Identifies the unique system identifier for each Azure resource.
        :param str name: The Sku name.
        :param str capacity: The sku capacity
        :param str family: The sku family
        :param str size: The sku size
        :param str tier: The Sku tier.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Sku name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[str]:
        """
        The sku capacity
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        The sku family
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The sku size
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The Sku tier.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The type of identity that last modified the resource.
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UpgradeDetailsResponse(dict):
    """
    Details for upgrading vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimeUtc":
            suggest = "end_time_utc"
        elif key == "lastUpdatedTimeUtc":
            suggest = "last_updated_time_utc"
        elif key == "operationId":
            suggest = "operation_id"
        elif key == "previousResourceId":
            suggest = "previous_resource_id"
        elif key == "startTimeUtc":
            suggest = "start_time_utc"
        elif key == "triggerType":
            suggest = "trigger_type"
        elif key == "upgradedResourceId":
            suggest = "upgraded_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time_utc: str,
                 last_updated_time_utc: str,
                 message: str,
                 operation_id: str,
                 previous_resource_id: str,
                 start_time_utc: str,
                 status: str,
                 trigger_type: str,
                 upgraded_resource_id: str):
        """
        Details for upgrading vault.
        :param str end_time_utc: UTC time at which the upgrade operation has ended.
        :param str last_updated_time_utc: UTC time at which the upgrade operation status was last updated.
        :param str message: Message to the user containing information about the upgrade operation.
        :param str operation_id: ID of the vault upgrade operation.
        :param str previous_resource_id: Resource ID of the vault before the upgrade.
        :param str start_time_utc: UTC time at which the upgrade operation has started.
        :param str status: Status of the vault upgrade operation.
        :param str trigger_type: The way the vault upgrade was triggered.
        :param str upgraded_resource_id: Resource ID of the upgraded vault.
        """
        pulumi.set(__self__, "end_time_utc", end_time_utc)
        pulumi.set(__self__, "last_updated_time_utc", last_updated_time_utc)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "operation_id", operation_id)
        pulumi.set(__self__, "previous_resource_id", previous_resource_id)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "trigger_type", trigger_type)
        pulumi.set(__self__, "upgraded_resource_id", upgraded_resource_id)

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation has ended.
        """
        return pulumi.get(self, "end_time_utc")

    @property
    @pulumi.getter(name="lastUpdatedTimeUtc")
    def last_updated_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation status was last updated.
        """
        return pulumi.get(self, "last_updated_time_utc")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Message to the user containing information about the upgrade operation.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> str:
        """
        ID of the vault upgrade operation.
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="previousResourceId")
    def previous_resource_id(self) -> str:
        """
        Resource ID of the vault before the upgrade.
        """
        return pulumi.get(self, "previous_resource_id")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> str:
        """
        UTC time at which the upgrade operation has started.
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the vault upgrade operation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> str:
        """
        The way the vault upgrade was triggered.
        """
        return pulumi.get(self, "trigger_type")

    @property
    @pulumi.getter(name="upgradedResourceId")
    def upgraded_resource_id(self) -> str:
        """
        Resource ID of the upgraded vault.
        """
        return pulumi.get(self, "upgraded_resource_id")


@pulumi.output_type
class UserIdentityResponse(dict):
    """
    A resource identity that is managed by the user of the service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        A resource identity that is managed by the user of the service.
        :param str client_id: The client ID of the user-assigned identity.
        :param str principal_id: The principal ID of the user-assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the user-assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the user-assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VaultPrivateEndpointConnectionResponse(dict):
    """
    Private Endpoint Connection Response Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_endpoint: 'outputs.PrivateEndpointResponse',
                 private_link_service_connection_state: 'outputs.VaultPrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str):
        """
        Private Endpoint Connection Response Properties.
        :param 'PrivateEndpointResponse' private_endpoint: The Private Endpoint network resource that is linked to the Private Endpoint connection.
        :param 'VaultPrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: Gets or sets private link service connection state.
        :param str provisioning_state: Gets or sets provisioning state of the private endpoint connection.
        """
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> 'outputs.PrivateEndpointResponse':
        """
        The Private Endpoint network resource that is linked to the Private Endpoint connection.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.VaultPrivateLinkServiceConnectionStateResponse':
        """
        Gets or sets private link service connection state.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets or sets provisioning state of the private endpoint connection.
        """
        return pulumi.get(self, "provisioning_state")


@pulumi.output_type
class VaultPrivateLinkServiceConnectionStateResponse(dict):
    """
    Gets or sets private link service connection state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: str,
                 description: str,
                 status: str):
        """
        Gets or sets private link service connection state.
        :param str actions_required: Gets or sets actions required.
        :param str description: Gets or sets description.
        :param str status: Gets or sets the status.
        """
        pulumi.set(__self__, "actions_required", actions_required)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> str:
        """
        Gets or sets actions required.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Gets or sets description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Gets or sets the status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class VaultPropertiesResponse(dict):
    """
    Properties of the vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupStorageVersion":
            suggest = "backup_storage_version"
        elif key == "moveState":
            suggest = "move_state"
        elif key == "privateEndpointConnections":
            suggest = "private_endpoint_connections"
        elif key == "privateEndpointStateForBackup":
            suggest = "private_endpoint_state_for_backup"
        elif key == "privateEndpointStateForSiteRecovery":
            suggest = "private_endpoint_state_for_site_recovery"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "moveDetails":
            suggest = "move_details"
        elif key == "upgradeDetails":
            suggest = "upgrade_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_storage_version: str,
                 move_state: str,
                 private_endpoint_connections: Sequence['outputs.PrivateEndpointConnectionVaultPropertiesResponse'],
                 private_endpoint_state_for_backup: str,
                 private_endpoint_state_for_site_recovery: str,
                 provisioning_state: str,
                 encryption: Optional['outputs.VaultPropertiesResponseEncryption'] = None,
                 move_details: Optional['outputs.VaultPropertiesResponseMoveDetails'] = None,
                 upgrade_details: Optional['outputs.UpgradeDetailsResponse'] = None):
        """
        Properties of the vault.
        :param str backup_storage_version: Backup storage version
        :param str move_state: The State of the Resource after the move operation
        :param Sequence['PrivateEndpointConnectionVaultPropertiesResponse'] private_endpoint_connections: List of private endpoint connection.
        :param str private_endpoint_state_for_backup: Private endpoint state for backup.
        :param str private_endpoint_state_for_site_recovery: Private endpoint state for site recovery.
        :param str provisioning_state: Provisioning State.
        :param 'VaultPropertiesResponseEncryption' encryption: Customer Managed Key details of the resource.
        :param 'VaultPropertiesResponseMoveDetails' move_details: The details of the latest move operation performed on the Azure Resource
        :param 'UpgradeDetailsResponse' upgrade_details: Details for upgrading vault.
        """
        pulumi.set(__self__, "backup_storage_version", backup_storage_version)
        pulumi.set(__self__, "move_state", move_state)
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        pulumi.set(__self__, "private_endpoint_state_for_backup", private_endpoint_state_for_backup)
        pulumi.set(__self__, "private_endpoint_state_for_site_recovery", private_endpoint_state_for_site_recovery)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if move_details is not None:
            pulumi.set(__self__, "move_details", move_details)
        if upgrade_details is not None:
            pulumi.set(__self__, "upgrade_details", upgrade_details)

    @property
    @pulumi.getter(name="backupStorageVersion")
    def backup_storage_version(self) -> str:
        """
        Backup storage version
        """
        return pulumi.get(self, "backup_storage_version")

    @property
    @pulumi.getter(name="moveState")
    def move_state(self) -> str:
        """
        The State of the Resource after the move operation
        """
        return pulumi.get(self, "move_state")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.PrivateEndpointConnectionVaultPropertiesResponse']:
        """
        List of private endpoint connection.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="privateEndpointStateForBackup")
    def private_endpoint_state_for_backup(self) -> str:
        """
        Private endpoint state for backup.
        """
        return pulumi.get(self, "private_endpoint_state_for_backup")

    @property
    @pulumi.getter(name="privateEndpointStateForSiteRecovery")
    def private_endpoint_state_for_site_recovery(self) -> str:
        """
        Private endpoint state for site recovery.
        """
        return pulumi.get(self, "private_endpoint_state_for_site_recovery")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning State.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.VaultPropertiesResponseEncryption']:
        """
        Customer Managed Key details of the resource.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="moveDetails")
    def move_details(self) -> Optional['outputs.VaultPropertiesResponseMoveDetails']:
        """
        The details of the latest move operation performed on the Azure Resource
        """
        return pulumi.get(self, "move_details")

    @property
    @pulumi.getter(name="upgradeDetails")
    def upgrade_details(self) -> Optional['outputs.UpgradeDetailsResponse']:
        """
        Details for upgrading vault.
        """
        return pulumi.get(self, "upgrade_details")


@pulumi.output_type
class VaultPropertiesResponseEncryption(dict):
    """
    Customer Managed Key details of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "infrastructureEncryption":
            suggest = "infrastructure_encryption"
        elif key == "kekIdentity":
            suggest = "kek_identity"
        elif key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponseEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponseEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponseEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 infrastructure_encryption: Optional[str] = None,
                 kek_identity: Optional['outputs.CmkKekIdentityResponse'] = None,
                 key_vault_properties: Optional['outputs.CmkKeyVaultPropertiesResponse'] = None):
        """
        Customer Managed Key details of the resource.
        :param str infrastructure_encryption: Enabling/Disabling the Double Encryption state
        :param 'CmkKekIdentityResponse' kek_identity: The details of the identity used for CMK
        :param 'CmkKeyVaultPropertiesResponse' key_vault_properties: The properties of the Key Vault which hosts CMK
        """
        if infrastructure_encryption is not None:
            pulumi.set(__self__, "infrastructure_encryption", infrastructure_encryption)
        if kek_identity is not None:
            pulumi.set(__self__, "kek_identity", kek_identity)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter(name="infrastructureEncryption")
    def infrastructure_encryption(self) -> Optional[str]:
        """
        Enabling/Disabling the Double Encryption state
        """
        return pulumi.get(self, "infrastructure_encryption")

    @property
    @pulumi.getter(name="kekIdentity")
    def kek_identity(self) -> Optional['outputs.CmkKekIdentityResponse']:
        """
        The details of the identity used for CMK
        """
        return pulumi.get(self, "kek_identity")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.CmkKeyVaultPropertiesResponse']:
        """
        The properties of the Key Vault which hosts CMK
        """
        return pulumi.get(self, "key_vault_properties")


@pulumi.output_type
class VaultPropertiesResponseMoveDetails(dict):
    """
    The details of the latest move operation performed on the Azure Resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTimeUtc":
            suggest = "completion_time_utc"
        elif key == "operationId":
            suggest = "operation_id"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "startTimeUtc":
            suggest = "start_time_utc"
        elif key == "targetResourceId":
            suggest = "target_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultPropertiesResponseMoveDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultPropertiesResponseMoveDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultPropertiesResponseMoveDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_time_utc: str,
                 operation_id: str,
                 source_resource_id: str,
                 start_time_utc: str,
                 target_resource_id: str):
        """
        The details of the latest move operation performed on the Azure Resource
        :param str completion_time_utc: End Time of the Resource Move Operation
        :param str operation_id: OperationId of the Resource Move Operation
        :param str source_resource_id: Source Resource of the Resource Move Operation
        :param str start_time_utc: Start Time of the Resource Move Operation
        :param str target_resource_id: Target Resource of the Resource Move Operation
        """
        pulumi.set(__self__, "completion_time_utc", completion_time_utc)
        pulumi.set(__self__, "operation_id", operation_id)
        pulumi.set(__self__, "source_resource_id", source_resource_id)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "target_resource_id", target_resource_id)

    @property
    @pulumi.getter(name="completionTimeUtc")
    def completion_time_utc(self) -> str:
        """
        End Time of the Resource Move Operation
        """
        return pulumi.get(self, "completion_time_utc")

    @property
    @pulumi.getter(name="operationId")
    def operation_id(self) -> str:
        """
        OperationId of the Resource Move Operation
        """
        return pulumi.get(self, "operation_id")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> str:
        """
        Source Resource of the Resource Move Operation
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> str:
        """
        Start Time of the Resource Move Operation
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> str:
        """
        Target Resource of the Resource Move Operation
        """
        return pulumi.get(self, "target_resource_id")


