# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCacheRuleResult',
    'AwaitableGetCacheRuleResult',
    'get_cache_rule',
    'get_cache_rule_output',
]

@pulumi.output_type
class GetCacheRuleResult:
    """
    An object that represents a cache rule for a container registry.
    """
    def __init__(__self__, creation_date=None, credential_set_resource_id=None, id=None, name=None, provisioning_state=None, source_repository=None, system_data=None, target_repository=None, type=None):
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if credential_set_resource_id and not isinstance(credential_set_resource_id, str):
            raise TypeError("Expected argument 'credential_set_resource_id' to be a str")
        pulumi.set(__self__, "credential_set_resource_id", credential_set_resource_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if source_repository and not isinstance(source_repository, str):
            raise TypeError("Expected argument 'source_repository' to be a str")
        pulumi.set(__self__, "source_repository", source_repository)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if target_repository and not isinstance(target_repository, str):
            raise TypeError("Expected argument 'target_repository' to be a str")
        pulumi.set(__self__, "target_repository", target_repository)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> str:
        """
        The creation date of the cache rule.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="credentialSetResourceId")
    def credential_set_resource_id(self) -> Optional[str]:
        """
        The ARM resource ID of the credential store which is associated with the cache rule.
        """
        return pulumi.get(self, "credential_set_resource_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> Optional[str]:
        """
        Source repository pulled from upstream.
        """
        return pulumi.get(self, "source_repository")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter(name="targetRepository")
    def target_repository(self) -> Optional[str]:
        """
        Target repository specified in docker pull command.
        Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}
        """
        return pulumi.get(self, "target_repository")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")


class AwaitableGetCacheRuleResult(GetCacheRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCacheRuleResult(
            creation_date=self.creation_date,
            credential_set_resource_id=self.credential_set_resource_id,
            id=self.id,
            name=self.name,
            provisioning_state=self.provisioning_state,
            source_repository=self.source_repository,
            system_data=self.system_data,
            target_repository=self.target_repository,
            type=self.type)


def get_cache_rule(cache_rule_name: Optional[str] = None,
                   registry_name: Optional[str] = None,
                   resource_group_name: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCacheRuleResult:
    """
    An object that represents a cache rule for a container registry.


    :param str cache_rule_name: The name of the cache rule.
    :param str registry_name: The name of the container registry.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['cacheRuleName'] = cache_rule_name
    __args__['registryName'] = registry_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:containerregistry/v20230101preview:getCacheRule', __args__, opts=opts, typ=GetCacheRuleResult).value

    return AwaitableGetCacheRuleResult(
        creation_date=__ret__.creation_date,
        credential_set_resource_id=__ret__.credential_set_resource_id,
        id=__ret__.id,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        source_repository=__ret__.source_repository,
        system_data=__ret__.system_data,
        target_repository=__ret__.target_repository,
        type=__ret__.type)


@_utilities.lift_output_func(get_cache_rule)
def get_cache_rule_output(cache_rule_name: Optional[pulumi.Input[str]] = None,
                          registry_name: Optional[pulumi.Input[str]] = None,
                          resource_group_name: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCacheRuleResult]:
    """
    An object that represents a cache rule for a container registry.


    :param str cache_rule_name: The name of the cache rule.
    :param str registry_name: The name of the container registry.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
