# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'BasicLoginInformationArgs',
    'DataControllerPropertiesArgs',
    'ExtendedLocationArgs',
    'LogAnalyticsWorkspaceConfigArgs',
    'OnPremisePropertyArgs',
    'PostgresInstancePropertiesArgs',
    'PostgresInstanceSkuArgs',
    'SqlManagedInstancePropertiesArgs',
    'SqlManagedInstanceSkuArgs',
    'SqlServerInstancePropertiesArgs',
    'UploadServicePrincipalArgs',
    'UploadWatermarkArgs',
]

@pulumi.input_type
class BasicLoginInformationArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Username and password for basic login authentication.
        :param pulumi.Input[str] password: Login password.
        :param pulumi.Input[str] username: Login username.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Login password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Login username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class DataControllerPropertiesArgs:
    def __init__(__self__, *,
                 basic_login_information: Optional[pulumi.Input['BasicLoginInformationArgs']] = None,
                 k8s_raw: Optional[Any] = None,
                 last_uploaded_date: Optional[pulumi.Input[str]] = None,
                 log_analytics_workspace_config: Optional[pulumi.Input['LogAnalyticsWorkspaceConfigArgs']] = None,
                 on_premise_property: Optional[pulumi.Input['OnPremisePropertyArgs']] = None,
                 upload_service_principal: Optional[pulumi.Input['UploadServicePrincipalArgs']] = None,
                 upload_watermark: Optional[pulumi.Input['UploadWatermarkArgs']] = None):
        """
        The data controller properties.
        :param pulumi.Input['BasicLoginInformationArgs'] basic_login_information: Username and password for basic login authentication.
        :param Any k8s_raw: The raw kubernetes information
        :param pulumi.Input[str] last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        :param pulumi.Input['LogAnalyticsWorkspaceConfigArgs'] log_analytics_workspace_config: Log analytics workspace id and primary key
        :param pulumi.Input['OnPremisePropertyArgs'] on_premise_property: Properties from the Kubernetes data controller
        :param pulumi.Input['UploadServicePrincipalArgs'] upload_service_principal: Service principal for uploading billing, metrics and logs.
        :param pulumi.Input['UploadWatermarkArgs'] upload_watermark: Properties on upload watermark.  Mostly timestamp for each upload data type
        """
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)
        if log_analytics_workspace_config is not None:
            pulumi.set(__self__, "log_analytics_workspace_config", log_analytics_workspace_config)
        if on_premise_property is not None:
            pulumi.set(__self__, "on_premise_property", on_premise_property)
        if upload_service_principal is not None:
            pulumi.set(__self__, "upload_service_principal", upload_service_principal)
        if upload_watermark is not None:
            pulumi.set(__self__, "upload_watermark", upload_watermark)

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional[pulumi.Input['BasicLoginInformationArgs']]:
        """
        Username and password for basic login authentication.
        """
        return pulumi.get(self, "basic_login_information")

    @basic_login_information.setter
    def basic_login_information(self, value: Optional[pulumi.Input['BasicLoginInformationArgs']]):
        pulumi.set(self, "basic_login_information", value)

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[Any]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @k8s_raw.setter
    def k8s_raw(self, value: Optional[Any]):
        pulumi.set(self, "k8s_raw", value)

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @last_uploaded_date.setter
    def last_uploaded_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_uploaded_date", value)

    @property
    @pulumi.getter(name="logAnalyticsWorkspaceConfig")
    def log_analytics_workspace_config(self) -> Optional[pulumi.Input['LogAnalyticsWorkspaceConfigArgs']]:
        """
        Log analytics workspace id and primary key
        """
        return pulumi.get(self, "log_analytics_workspace_config")

    @log_analytics_workspace_config.setter
    def log_analytics_workspace_config(self, value: Optional[pulumi.Input['LogAnalyticsWorkspaceConfigArgs']]):
        pulumi.set(self, "log_analytics_workspace_config", value)

    @property
    @pulumi.getter(name="onPremiseProperty")
    def on_premise_property(self) -> Optional[pulumi.Input['OnPremisePropertyArgs']]:
        """
        Properties from the Kubernetes data controller
        """
        return pulumi.get(self, "on_premise_property")

    @on_premise_property.setter
    def on_premise_property(self, value: Optional[pulumi.Input['OnPremisePropertyArgs']]):
        pulumi.set(self, "on_premise_property", value)

    @property
    @pulumi.getter(name="uploadServicePrincipal")
    def upload_service_principal(self) -> Optional[pulumi.Input['UploadServicePrincipalArgs']]:
        """
        Service principal for uploading billing, metrics and logs.
        """
        return pulumi.get(self, "upload_service_principal")

    @upload_service_principal.setter
    def upload_service_principal(self, value: Optional[pulumi.Input['UploadServicePrincipalArgs']]):
        pulumi.set(self, "upload_service_principal", value)

    @property
    @pulumi.getter(name="uploadWatermark")
    def upload_watermark(self) -> Optional[pulumi.Input['UploadWatermarkArgs']]:
        """
        Properties on upload watermark.  Mostly timestamp for each upload data type
        """
        return pulumi.get(self, "upload_watermark")

    @upload_watermark.setter
    def upload_watermark(self, value: Optional[pulumi.Input['UploadWatermarkArgs']]):
        pulumi.set(self, "upload_watermark", value)


@pulumi.input_type
class ExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]] = None):
        """
        The complex type of the extended location.
        :param pulumi.Input[str] name: The name of the extended location.
        :param pulumi.Input[Union[str, 'ExtendedLocationTypes']] type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class LogAnalyticsWorkspaceConfigArgs:
    def __init__(__self__, *,
                 primary_key: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        Log analytics workspace id and primary key
        :param pulumi.Input[str] primary_key: Primary key of the workspace
        :param pulumi.Input[str] workspace_id: Azure Log Analytics workspace ID
        """
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[str]]:
        """
        Primary key of the workspace
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Log Analytics workspace ID
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class OnPremisePropertyArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 public_signing_key: pulumi.Input[str],
                 signing_certificate_thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Properties from the Kubernetes data controller
        :param pulumi.Input[str] id: A globally unique ID identifying the associated Kubernetes cluster
        :param pulumi.Input[str] public_signing_key: Certificate that contains the Kubernetes cluster public key used to verify signing
        :param pulumi.Input[str] signing_certificate_thumbprint: Unique thumbprint returned to customer to verify the certificate being uploaded
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "public_signing_key", public_signing_key)
        if signing_certificate_thumbprint is not None:
            pulumi.set(__self__, "signing_certificate_thumbprint", signing_certificate_thumbprint)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        A globally unique ID identifying the associated Kubernetes cluster
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="publicSigningKey")
    def public_signing_key(self) -> pulumi.Input[str]:
        """
        Certificate that contains the Kubernetes cluster public key used to verify signing
        """
        return pulumi.get(self, "public_signing_key")

    @public_signing_key.setter
    def public_signing_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "public_signing_key", value)

    @property
    @pulumi.getter(name="signingCertificateThumbprint")
    def signing_certificate_thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        Unique thumbprint returned to customer to verify the certificate being uploaded
        """
        return pulumi.get(self, "signing_certificate_thumbprint")

    @signing_certificate_thumbprint.setter
    def signing_certificate_thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_certificate_thumbprint", value)


@pulumi.input_type
class PostgresInstancePropertiesArgs:
    def __init__(__self__, *,
                 admin: Optional[pulumi.Input[str]] = None,
                 basic_login_information: Optional[pulumi.Input['BasicLoginInformationArgs']] = None,
                 data_controller_id: Optional[pulumi.Input[str]] = None,
                 k8s_raw: Optional[Any] = None,
                 last_uploaded_date: Optional[pulumi.Input[str]] = None):
        """
        Postgres Instance properties.
        :param pulumi.Input[str] admin: The instance admin
        :param pulumi.Input['BasicLoginInformationArgs'] basic_login_information: Username and password for basic authentication.
        :param pulumi.Input[str] data_controller_id: The data controller id
        :param Any k8s_raw: The raw kubernetes information
        :param pulumi.Input[str] last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if data_controller_id is not None:
            pulumi.set(__self__, "data_controller_id", data_controller_id)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)

    @property
    @pulumi.getter
    def admin(self) -> Optional[pulumi.Input[str]]:
        """
        The instance admin
        """
        return pulumi.get(self, "admin")

    @admin.setter
    def admin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin", value)

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional[pulumi.Input['BasicLoginInformationArgs']]:
        """
        Username and password for basic authentication.
        """
        return pulumi.get(self, "basic_login_information")

    @basic_login_information.setter
    def basic_login_information(self, value: Optional[pulumi.Input['BasicLoginInformationArgs']]):
        pulumi.set(self, "basic_login_information", value)

    @property
    @pulumi.getter(name="dataControllerId")
    def data_controller_id(self) -> Optional[pulumi.Input[str]]:
        """
        The data controller id
        """
        return pulumi.get(self, "data_controller_id")

    @data_controller_id.setter
    def data_controller_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_controller_id", value)

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[Any]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @k8s_raw.setter
    def k8s_raw(self, value: Optional[Any]):
        pulumi.set(self, "k8s_raw", value)

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @last_uploaded_date.setter
    def last_uploaded_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_uploaded_date", value)


@pulumi.input_type
class PostgresInstanceSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 capacity: Optional[pulumi.Input[int]] = None,
                 dev: Optional[pulumi.Input[bool]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input['PostgresInstanceSkuTier']] = None):
        """
        The resource model definition representing SKU for Azure Database for PostgresSQL - Azure Arc
        :param pulumi.Input[str] name: The name of the SKU.  It is typically a letter+number code
        :param pulumi.Input[int] capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param pulumi.Input[bool] dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        :param pulumi.Input[str] family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param pulumi.Input[str] size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param pulumi.Input['PostgresInstanceSkuTier'] tier: This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dev is None:
            dev = True
        if dev is not None:
            pulumi.set(__self__, "dev", dev)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is None:
            tier = 'Hyperscale'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SKU.  It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def dev(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        """
        return pulumi.get(self, "dev")

    @dev.setter
    def dev(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dev", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input['PostgresInstanceSkuTier']]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input['PostgresInstanceSkuTier']]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SqlManagedInstancePropertiesArgs:
    def __init__(__self__, *,
                 admin: Optional[pulumi.Input[str]] = None,
                 basic_login_information: Optional[pulumi.Input['BasicLoginInformationArgs']] = None,
                 data_controller_id: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 k8s_raw: Optional[Any] = None,
                 last_uploaded_date: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Properties of sqlManagedInstance.
        :param pulumi.Input[str] admin: The instance admin user
        :param pulumi.Input['BasicLoginInformationArgs'] basic_login_information: Username and password for basic authentication.
        :param pulumi.Input[str] data_controller_id: null
        :param pulumi.Input[str] end_time: The instance end time
        :param Any k8s_raw: The raw kubernetes information
        :param pulumi.Input[str] last_uploaded_date: Last uploaded date from Kubernetes cluster. Defaults to current date time
        :param pulumi.Input[str] start_time: The instance start time
        """
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if basic_login_information is not None:
            pulumi.set(__self__, "basic_login_information", basic_login_information)
        if data_controller_id is not None:
            pulumi.set(__self__, "data_controller_id", data_controller_id)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if k8s_raw is not None:
            pulumi.set(__self__, "k8s_raw", k8s_raw)
        if last_uploaded_date is not None:
            pulumi.set(__self__, "last_uploaded_date", last_uploaded_date)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def admin(self) -> Optional[pulumi.Input[str]]:
        """
        The instance admin user
        """
        return pulumi.get(self, "admin")

    @admin.setter
    def admin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin", value)

    @property
    @pulumi.getter(name="basicLoginInformation")
    def basic_login_information(self) -> Optional[pulumi.Input['BasicLoginInformationArgs']]:
        """
        Username and password for basic authentication.
        """
        return pulumi.get(self, "basic_login_information")

    @basic_login_information.setter
    def basic_login_information(self, value: Optional[pulumi.Input['BasicLoginInformationArgs']]):
        pulumi.set(self, "basic_login_information", value)

    @property
    @pulumi.getter(name="dataControllerId")
    def data_controller_id(self) -> Optional[pulumi.Input[str]]:
        """
        null
        """
        return pulumi.get(self, "data_controller_id")

    @data_controller_id.setter
    def data_controller_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_controller_id", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The instance end time
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="k8sRaw")
    def k8s_raw(self) -> Optional[Any]:
        """
        The raw kubernetes information
        """
        return pulumi.get(self, "k8s_raw")

    @k8s_raw.setter
    def k8s_raw(self, value: Optional[Any]):
        pulumi.set(self, "k8s_raw", value)

    @property
    @pulumi.getter(name="lastUploadedDate")
    def last_uploaded_date(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date from Kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "last_uploaded_date")

    @last_uploaded_date.setter
    def last_uploaded_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_uploaded_date", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The instance start time
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class SqlManagedInstanceSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 capacity: Optional[pulumi.Input[int]] = None,
                 dev: Optional[pulumi.Input[bool]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input['SqlManagedInstanceSkuTier']] = None):
        """
        The resource model definition representing SKU for Azure Managed Instance - Azure Arc
        :param pulumi.Input[str] name: The name of the SKU.  It is typically a letter+number code
        :param pulumi.Input[int] capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param pulumi.Input[bool] dev: Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        :param pulumi.Input[str] family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param pulumi.Input[str] size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param pulumi.Input['SqlManagedInstanceSkuTier'] tier: This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if dev is None:
            dev = True
        if dev is not None:
            pulumi.set(__self__, "dev", dev)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is None:
            tier = 'GeneralPurpose'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SKU.  It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def dev(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose. 
        """
        return pulumi.get(self, "dev")

    @dev.setter
    def dev(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dev", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input['SqlManagedInstanceSkuTier']]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input['SqlManagedInstanceSkuTier']]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SqlServerInstancePropertiesArgs:
    def __init__(__self__, *,
                 container_resource_id: pulumi.Input[str],
                 status: pulumi.Input[str],
                 collation: Optional[pulumi.Input[str]] = None,
                 current_version: Optional[pulumi.Input[str]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 patch_level: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 tcp_dynamic_ports: Optional[pulumi.Input[str]] = None,
                 tcp_static_ports: Optional[pulumi.Input[str]] = None,
                 v_core: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Properties of SqlServerInstance.
        :param pulumi.Input[str] container_resource_id: ARM Resource id of the container resource (Azure Arc for Servers).
        :param pulumi.Input[str] status: The cloud connectivity status.
        :param pulumi.Input[str] collation: SQL Server collation.
        :param pulumi.Input[str] current_version: SQL Server current version.
        :param pulumi.Input[str] edition: SQL Server edition.
        :param pulumi.Input[str] instance_name: SQL Server instance name.
        :param pulumi.Input[str] license_type: SQL Server license type.
        :param pulumi.Input[str] patch_level: SQL Server update level.
        :param pulumi.Input[str] product_id: SQL Server product ID.
        :param pulumi.Input[str] tcp_dynamic_ports: Dynamic TCP ports used by SQL Server.
        :param pulumi.Input[str] tcp_static_ports: Static TCP ports used by SQL Server.
        :param pulumi.Input[str] v_core: The number of logical processors used by the SQL Server instance.
        :param pulumi.Input[str] version: SQL Server version.
        """
        pulumi.set(__self__, "container_resource_id", container_resource_id)
        pulumi.set(__self__, "status", status)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if patch_level is not None:
            pulumi.set(__self__, "patch_level", patch_level)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if tcp_dynamic_ports is not None:
            pulumi.set(__self__, "tcp_dynamic_ports", tcp_dynamic_ports)
        if tcp_static_ports is not None:
            pulumi.set(__self__, "tcp_static_ports", tcp_static_ports)
        if v_core is not None:
            pulumi.set(__self__, "v_core", v_core)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="containerResourceId")
    def container_resource_id(self) -> pulumi.Input[str]:
        """
        ARM Resource id of the container resource (Azure Arc for Servers).
        """
        return pulumi.get(self, "container_resource_id")

    @container_resource_id.setter
    def container_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_resource_id", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        The cloud connectivity status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server collation.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server current version.
        """
        return pulumi.get(self, "current_version")

    @current_version.setter
    def current_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_version", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server edition.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server license type.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="patchLevel")
    def patch_level(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server update level.
        """
        return pulumi.get(self, "patch_level")

    @patch_level.setter
    def patch_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patch_level", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server product ID.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="tcpDynamicPorts")
    def tcp_dynamic_ports(self) -> Optional[pulumi.Input[str]]:
        """
        Dynamic TCP ports used by SQL Server.
        """
        return pulumi.get(self, "tcp_dynamic_ports")

    @tcp_dynamic_ports.setter
    def tcp_dynamic_ports(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_dynamic_ports", value)

    @property
    @pulumi.getter(name="tcpStaticPorts")
    def tcp_static_ports(self) -> Optional[pulumi.Input[str]]:
        """
        Static TCP ports used by SQL Server.
        """
        return pulumi.get(self, "tcp_static_ports")

    @tcp_static_ports.setter
    def tcp_static_ports(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_static_ports", value)

    @property
    @pulumi.getter(name="vCore")
    def v_core(self) -> Optional[pulumi.Input[str]]:
        """
        The number of logical processors used by the SQL Server instance.
        """
        return pulumi.get(self, "v_core")

    @v_core.setter
    def v_core(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v_core", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        SQL Server version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class UploadServicePrincipalArgs:
    def __init__(__self__, *,
                 authority: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Service principal for uploading billing, metrics and logs.
        :param pulumi.Input[str] authority: Authority for the service principal. Example: https://login.microsoftonline.com/
        :param pulumi.Input[str] client_id: Client ID of the service principal for uploading data.
        :param pulumi.Input[str] client_secret: Secret of the service principal
        :param pulumi.Input[str] tenant_id: Tenant ID of the service principal.
        """
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def authority(self) -> Optional[pulumi.Input[str]]:
        """
        Authority for the service principal. Example: https://login.microsoftonline.com/
        """
        return pulumi.get(self, "authority")

    @authority.setter
    def authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authority", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client ID of the service principal for uploading data.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Secret of the service principal
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant ID of the service principal.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class UploadWatermarkArgs:
    def __init__(__self__, *,
                 logs: Optional[pulumi.Input[str]] = None,
                 metrics: Optional[pulumi.Input[str]] = None,
                 usages: Optional[pulumi.Input[str]] = None):
        """
        Properties on upload watermark.  Mostly timestamp for each upload data type
        :param pulumi.Input[str] logs: Last uploaded date for logs from kubernetes cluster. Defaults to current date time
        :param pulumi.Input[str] metrics: Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
        :param pulumi.Input[str] usages: Last uploaded date for usages from kubernetes cluster. Defaults to current date time
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if usages is not None:
            pulumi.set(__self__, "usages", usages)

    @property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date for logs from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def usages(self) -> Optional[pulumi.Input[str]]:
        """
        Last uploaded date for usages from kubernetes cluster. Defaults to current date time
        """
        return pulumi.get(self, "usages")

    @usages.setter
    def usages(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "usages", value)


